# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-vault-credential.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.v1_11_2.web.objects.Credential import Credential
from delphixpy.v1_11_2 import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class VaultCredential(Credential):
    """
    *(extends* :py:class:`v1_11_2.web.vo.Credential` *)* The password vault
    based security credential.
    """
    def __init__(self, undef_enabled=True):
        super(VaultCredential, self).__init__()
        self._type = ("VaultCredential", True)
        self._vault = (self.__undef__, True)
        self._vault_credential_id = (self.__undef__, True)

    API_VERSION = "1.11.2"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(VaultCredential, cls).from_dict(data, dirty, undef_enabled)
        obj._vault = (data.get("vault", obj.__undef__), dirty)
        if obj._vault[0] is not None and obj._vault[0] is not obj.__undef__:
            assert isinstance(obj._vault[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._vault[0], type(obj._vault[0])))
            common.validate_format(obj._vault[0], "objectReference", None, None)
        obj._vault_credential_id = (data.get("vaultCredentialId", obj.__undef__), dirty)
        if obj._vault_credential_id[0] is not None and obj._vault_credential_id[0] is not obj.__undef__:
            assert isinstance(obj._vault_credential_id[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._vault_credential_id[0], type(obj._vault_credential_id[0])))
            common.validate_format(obj._vault_credential_id[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(VaultCredential, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "vault" == "type" or (self.vault is not self.__undef__ and (not (dirty and not self._vault[1]) or isinstance(self.vault, list) or belongs_to_parent)):
            dct["vault"] = dictify(self.vault)
        if "vault_credential_id" == "type" or (self.vault_credential_id is not self.__undef__ and (not (dirty and not self._vault_credential_id[1]) or isinstance(self.vault_credential_id, list) or belongs_to_parent)):
            dct["vaultCredentialId"] = dictify(self.vault_credential_id)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._vault = (self._vault[0], True)
        self._vault_credential_id = (self._vault_credential_id[0], True)

    def is_dirty(self):
        return any([self._vault[1], self._vault_credential_id[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, VaultCredential):
            return False
        return super(VaultCredential, self).__eq__(other) and \
               self.vault == other.vault and \
               self.vault_credential_id == other.vault_credential_id

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def vault(self):
        """
        Reference to the password vault to use.

        :rtype: ``TEXT_TYPE``
        """
        return self._vault[0]

    @vault.setter
    def vault(self, value):
        self._vault = (value, True)

    @property
    def vault_credential_id(self):
        """
        Identifies credential in password vault.

        :rtype: ``TEXT_TYPE``
        """
        return self._vault_credential_id[0]

    @vault_credential_id.setter
    def vault_credential_id(self, value):
        self._vault_credential_id = (value, True)

