# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-cyberark-vault.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.v1_11_5.web.objects.PasswordVault import PasswordVault
from delphixpy.v1_11_5 import factory
from delphixpy.v1_11_5 import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class CyberArkPasswordVault(PasswordVault):
    """
    *(extends* :py:class:`v1_11_5.web.vo.PasswordVault` *)* CyberArk password
    vault configuration.
    """
    def __init__(self, undef_enabled=True):
        super(CyberArkPasswordVault, self).__init__()
        self._type = ("CyberArkPasswordVault", True)
        self._application_id = (self.__undef__, True)
        self._client_certificate = (self.__undef__, True)

    API_VERSION = "1.11.5"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(CyberArkPasswordVault, cls).from_dict(data, dirty, undef_enabled)
        obj._application_id = (data.get("applicationId", obj.__undef__), dirty)
        if obj._application_id[0] is not None and obj._application_id[0] is not obj.__undef__:
            assert isinstance(obj._application_id[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._application_id[0], type(obj._application_id[0])))
            common.validate_format(obj._application_id[0], "None", None, None)
        if "clientCertificate" in data and data["clientCertificate"] is not None:
            obj._client_certificate = (factory.create_object(data["clientCertificate"], "ClientCertificate"), dirty)
            factory.validate_type(obj._client_certificate[0], "ClientCertificate")
        else:
            obj._client_certificate = (obj.__undef__, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(CyberArkPasswordVault, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "application_id" == "type" or (self.application_id is not self.__undef__ and (not (dirty and not self._application_id[1]) or isinstance(self.application_id, list) or belongs_to_parent)):
            dct["applicationId"] = dictify(self.application_id)
        if "client_certificate" == "type" or (self.client_certificate is not self.__undef__ and (not (dirty and not self._client_certificate[1]) or isinstance(self.client_certificate, list) or belongs_to_parent)):
            dct["clientCertificate"] = dictify(self.client_certificate, prop_is_list_or_vo=True)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._application_id = (self._application_id[0], True)
        self._client_certificate = (self._client_certificate[0], True)

    def is_dirty(self):
        return any([self._application_id[1], self._client_certificate[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, CyberArkPasswordVault):
            return False
        return super(CyberArkPasswordVault, self).__eq__(other) and \
               self.application_id == other.application_id and \
               self.client_certificate == other.client_certificate

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def application_id(self):
        """
        Application identifier in the vault.

        :rtype: ``TEXT_TYPE``
        """
        return self._application_id[0]

    @application_id.setter
    def application_id(self, value):
        self._application_id = (value, True)

    @property
    def client_certificate(self):
        """
        Client certificate for authentication to the vault.

        :rtype: :py:class:`v1_11_5.web.vo.ClientCertificate`
        """
        return self._client_certificate[0]

    @client_certificate.setter
    def client_certificate(self, value):
        self._client_certificate = (value, True)

