# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-sso.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.v1_11_5.web.objects.TypedObject import TypedObject
from delphixpy.v1_11_5 import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class SsoConfig(TypedObject):
    """
    *(extends* :py:class:`v1_11_5.web.vo.TypedObject` *)* SAML Single Sign-on
    (SSO) Configuration.
    """
    def __init__(self, undef_enabled=True):
        super(SsoConfig, self).__init__()
        self._type = ("SsoConfig", True)
        self._enabled = (self.__undef__, True)
        self._saml_metadata = (self.__undef__, True)
        self._cloud_sso = (self.__undef__, True)

    API_VERSION = "1.11.5"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(SsoConfig, cls).from_dict(data, dirty, undef_enabled)
        obj._enabled = (data.get("enabled", obj.__undef__), dirty)
        if obj._enabled[0] is not None and obj._enabled[0] is not obj.__undef__:
            assert isinstance(obj._enabled[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._enabled[0], type(obj._enabled[0])))
            common.validate_format(obj._enabled[0], "None", None, None)
        obj._saml_metadata = (data.get("samlMetadata", obj.__undef__), dirty)
        if obj._saml_metadata[0] is not None and obj._saml_metadata[0] is not obj.__undef__:
            assert isinstance(obj._saml_metadata[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._saml_metadata[0], type(obj._saml_metadata[0])))
            common.validate_format(obj._saml_metadata[0], "xml", None, None)
        obj._cloud_sso = (data.get("cloudSso", obj.__undef__), dirty)
        if obj._cloud_sso[0] is not None and obj._cloud_sso[0] is not obj.__undef__:
            assert isinstance(obj._cloud_sso[0], bool), ("Expected one of ['boolean'], but got %s of type %s" % (obj._cloud_sso[0], type(obj._cloud_sso[0])))
            common.validate_format(obj._cloud_sso[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(SsoConfig, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "enabled" == "type" or (self.enabled is not self.__undef__ and (not (dirty and not self._enabled[1]) or isinstance(self.enabled, list) or belongs_to_parent)):
            dct["enabled"] = dictify(self.enabled)
        if "saml_metadata" == "type" or (self.saml_metadata is not self.__undef__ and (not (dirty and not self._saml_metadata[1]) or isinstance(self.saml_metadata, list) or belongs_to_parent)):
            dct["samlMetadata"] = dictify(self.saml_metadata)
        if "cloud_sso" == "type" or (self.cloud_sso is not self.__undef__ and (not (dirty and not self._cloud_sso[1]))):
            dct["cloudSso"] = dictify(self.cloud_sso)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._enabled = (self._enabled[0], True)
        self._saml_metadata = (self._saml_metadata[0], True)
        self._cloud_sso = (self._cloud_sso[0], True)

    def is_dirty(self):
        return any([self._enabled[1], self._saml_metadata[1], self._cloud_sso[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, SsoConfig):
            return False
        return super(SsoConfig, self).__eq__(other) and \
               self.enabled == other.enabled and \
               self.saml_metadata == other.saml_metadata and \
               self.cloud_sso == other.cloud_sso

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def enabled(self):
        """
        Whether SAML single sign-on is enabled.

        :rtype: ``bool``
        """
        return self._enabled[0]

    @enabled.setter
    def enabled(self, value):
        self._enabled = (value, True)

    @property
    def saml_metadata(self):
        """
        Metadata for the SAML identity provider.

        :rtype: ``TEXT_TYPE``
        """
        return self._saml_metadata[0]

    @saml_metadata.setter
    def saml_metadata(self, value):
        self._saml_metadata = (value, True)

    @property
    def cloud_sso(self):
        """
        Whether this system has SSO configured by Delphix Central Management.

        :rtype: ``bool``
        """
        return self._cloud_sso[0]

    @cloud_sso.setter
    def cloud_sso(self, value):
        self._cloud_sso = (value, True)

