# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-toolkit-discovery-definition.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.v1_6_1.web.objects.TypedObject import TypedObject
from delphixpy.v1_6_1 import factory
from delphixpy.v1_6_1 import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class ToolkitDiscoveryDefinition(TypedObject):
    """
    *(extends* :py:class:`v1_6_1.web.vo.TypedObject` *)* Defines the discovery
    schemas and workflow scripts for a toolkit.
    """
    def __init__(self, undef_enabled=True):
        super(ToolkitDiscoveryDefinition, self).__init__()
        self._type = ("ToolkitDiscoveryDefinition", True)
        self._repository_discovery = (self.__undef__, True)
        self._repository_identity_fields = (self.__undef__, True)
        self._repository_name_field = (self.__undef__, True)
        self._repository_schema = (self.__undef__, True)
        self._source_config_discovery = (self.__undef__, True)
        self._source_config_identity_fields = (self.__undef__, True)
        self._source_config_name_field = (self.__undef__, True)
        self._source_config_schema = (self.__undef__, True)

    API_VERSION = "1.6.1"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(ToolkitDiscoveryDefinition, cls).from_dict(data, dirty, undef_enabled)
        if "repositoryDiscovery" not in data:
            raise ValueError("Missing required property \"repositoryDiscovery\".")
        obj._repository_discovery = (data.get("repositoryDiscovery", obj.__undef__), dirty)
        if obj._repository_discovery[0] is not None and obj._repository_discovery[0] is not obj.__undef__:
            assert isinstance(obj._repository_discovery[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._repository_discovery[0], type(obj._repository_discovery[0])))
            common.validate_format(obj._repository_discovery[0], "None", None, None)
        if "repositoryIdentityFields" not in data:
            raise ValueError("Missing required property \"repositoryIdentityFields\".")
        obj._repository_identity_fields = []
        for item in data.get("repositoryIdentityFields") or []:
            assert isinstance(item, TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (item, type(item)))
            common.validate_format(item, "None", None, None)
            obj._repository_identity_fields.append(item)
        obj._repository_identity_fields = (obj._repository_identity_fields, dirty)
        if "repositoryNameField" not in data:
            raise ValueError("Missing required property \"repositoryNameField\".")
        obj._repository_name_field = (data.get("repositoryNameField", obj.__undef__), dirty)
        if obj._repository_name_field[0] is not None and obj._repository_name_field[0] is not obj.__undef__:
            assert isinstance(obj._repository_name_field[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._repository_name_field[0], type(obj._repository_name_field[0])))
            common.validate_format(obj._repository_name_field[0], "None", None, None)
        if "repositorySchema" not in data:
            raise ValueError("Missing required property \"repositorySchema\".")
        obj._repository_schema = []
        for item in data.get("repositorySchema") or []:
            obj._repository_schema.append(factory.create_object(item))
            factory.validate_type(obj._repository_schema[-1], "DynamicParameter")
        obj._repository_schema = (obj._repository_schema, dirty)
        if "sourceConfigDiscovery" not in data:
            raise ValueError("Missing required property \"sourceConfigDiscovery\".")
        obj._source_config_discovery = (data.get("sourceConfigDiscovery", obj.__undef__), dirty)
        if obj._source_config_discovery[0] is not None and obj._source_config_discovery[0] is not obj.__undef__:
            assert isinstance(obj._source_config_discovery[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._source_config_discovery[0], type(obj._source_config_discovery[0])))
            common.validate_format(obj._source_config_discovery[0], "None", None, None)
        if "sourceConfigIdentityFields" not in data:
            raise ValueError("Missing required property \"sourceConfigIdentityFields\".")
        obj._source_config_identity_fields = []
        for item in data.get("sourceConfigIdentityFields") or []:
            assert isinstance(item, TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (item, type(item)))
            common.validate_format(item, "None", None, None)
            obj._source_config_identity_fields.append(item)
        obj._source_config_identity_fields = (obj._source_config_identity_fields, dirty)
        if "sourceConfigNameField" not in data:
            raise ValueError("Missing required property \"sourceConfigNameField\".")
        obj._source_config_name_field = (data.get("sourceConfigNameField", obj.__undef__), dirty)
        if obj._source_config_name_field[0] is not None and obj._source_config_name_field[0] is not obj.__undef__:
            assert isinstance(obj._source_config_name_field[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._source_config_name_field[0], type(obj._source_config_name_field[0])))
            common.validate_format(obj._source_config_name_field[0], "None", None, None)
        if "sourceConfigSchema" not in data:
            raise ValueError("Missing required property \"sourceConfigSchema\".")
        obj._source_config_schema = []
        for item in data.get("sourceConfigSchema") or []:
            obj._source_config_schema.append(factory.create_object(item))
            factory.validate_type(obj._source_config_schema[-1], "DynamicParameter")
        obj._source_config_schema = (obj._source_config_schema, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(ToolkitDiscoveryDefinition, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "repository_discovery" == "type" or (self.repository_discovery is not self.__undef__ and (not (dirty and not self._repository_discovery[1]) or isinstance(self.repository_discovery, list) or belongs_to_parent)):
            dct["repositoryDiscovery"] = dictify(self.repository_discovery)
        if "repository_identity_fields" == "type" or (self.repository_identity_fields is not self.__undef__ and (not (dirty and not self._repository_identity_fields[1]) or isinstance(self.repository_identity_fields, list) or belongs_to_parent)):
            dct["repositoryIdentityFields"] = dictify(self.repository_identity_fields, prop_is_list_or_vo=True)
        if "repository_name_field" == "type" or (self.repository_name_field is not self.__undef__ and (not (dirty and not self._repository_name_field[1]) or isinstance(self.repository_name_field, list) or belongs_to_parent)):
            dct["repositoryNameField"] = dictify(self.repository_name_field)
        if "repository_schema" == "type" or (self.repository_schema is not self.__undef__ and (not (dirty and not self._repository_schema[1]) or isinstance(self.repository_schema, list) or belongs_to_parent)):
            dct["repositorySchema"] = dictify(self.repository_schema, prop_is_list_or_vo=True)
        if "source_config_discovery" == "type" or (self.source_config_discovery is not self.__undef__ and (not (dirty and not self._source_config_discovery[1]) or isinstance(self.source_config_discovery, list) or belongs_to_parent)):
            dct["sourceConfigDiscovery"] = dictify(self.source_config_discovery)
        if "source_config_identity_fields" == "type" or (self.source_config_identity_fields is not self.__undef__ and (not (dirty and not self._source_config_identity_fields[1]) or isinstance(self.source_config_identity_fields, list) or belongs_to_parent)):
            dct["sourceConfigIdentityFields"] = dictify(self.source_config_identity_fields, prop_is_list_or_vo=True)
        if "source_config_name_field" == "type" or (self.source_config_name_field is not self.__undef__ and (not (dirty and not self._source_config_name_field[1]) or isinstance(self.source_config_name_field, list) or belongs_to_parent)):
            dct["sourceConfigNameField"] = dictify(self.source_config_name_field)
        if "source_config_schema" == "type" or (self.source_config_schema is not self.__undef__ and (not (dirty and not self._source_config_schema[1]) or isinstance(self.source_config_schema, list) or belongs_to_parent)):
            dct["sourceConfigSchema"] = dictify(self.source_config_schema, prop_is_list_or_vo=True)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._repository_discovery = (self._repository_discovery[0], True)
        self._repository_identity_fields = (self._repository_identity_fields[0], True)
        self._repository_name_field = (self._repository_name_field[0], True)
        self._repository_schema = (self._repository_schema[0], True)
        self._source_config_discovery = (self._source_config_discovery[0], True)
        self._source_config_identity_fields = (self._source_config_identity_fields[0], True)
        self._source_config_name_field = (self._source_config_name_field[0], True)
        self._source_config_schema = (self._source_config_schema[0], True)

    def is_dirty(self):
        return any([self._repository_discovery[1], self._repository_identity_fields[1], self._repository_name_field[1], self._repository_schema[1], self._source_config_discovery[1], self._source_config_identity_fields[1], self._source_config_name_field[1], self._source_config_schema[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, ToolkitDiscoveryDefinition):
            return False
        return super(ToolkitDiscoveryDefinition, self).__eq__(other) and \
               self.repository_discovery == other.repository_discovery and \
               self.repository_identity_fields == other.repository_identity_fields and \
               self.repository_name_field == other.repository_name_field and \
               self.repository_schema == other.repository_schema and \
               self.source_config_discovery == other.source_config_discovery and \
               self.source_config_identity_fields == other.source_config_identity_fields and \
               self.source_config_name_field == other.source_config_name_field and \
               self.source_config_schema == other.source_config_schema

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def repository_discovery(self):
        """
        A workflow script that discovers repositories on a target environment.
        The script must return a list of repositories matching the
        repositorySchema.

        :rtype: ``TEXT_TYPE``
        """
        return self._repository_discovery[0]

    @repository_discovery.setter
    def repository_discovery(self, value):
        self._repository_discovery = (value, True)

    @property
    def repository_identity_fields(self):
        """
        A list of fields in the repositorySchema that collectively identify
        each discovered repository.

        :rtype: ``list`` of ``TEXT_TYPE``
        """
        return self._repository_identity_fields[0]

    @repository_identity_fields.setter
    def repository_identity_fields(self, value):
        self._repository_identity_fields = (value, True)

    @property
    def repository_name_field(self):
        """
        The field of the repositorySchema to display to the end user for naming
        this repository.

        :rtype: ``TEXT_TYPE``
        """
        return self._repository_name_field[0]

    @repository_name_field.setter
    def repository_name_field(self, value):
        self._repository_name_field = (value, True)

    @property
    def repository_schema(self):
        """
        Dynamic parameters to represent the repository schema.

        :rtype: ``list`` of :py:class:`v1_6_1.web.vo.DynamicParameter`
        """
        return self._repository_schema[0]

    @repository_schema.setter
    def repository_schema(self, value):
        self._repository_schema = (value, True)

    @property
    def source_config_discovery(self):
        """
        A workflow script that discovers source configs on a target
        environment. The script must return a list of source configs matching
        the sourceConfigSchema.

        :rtype: ``TEXT_TYPE``
        """
        return self._source_config_discovery[0]

    @source_config_discovery.setter
    def source_config_discovery(self, value):
        self._source_config_discovery = (value, True)

    @property
    def source_config_identity_fields(self):
        """
        A list of fields in the sourceConfigSchema that collectively identify
        each discovered source config.

        :rtype: ``list`` of ``TEXT_TYPE``
        """
        return self._source_config_identity_fields[0]

    @source_config_identity_fields.setter
    def source_config_identity_fields(self, value):
        self._source_config_identity_fields = (value, True)

    @property
    def source_config_name_field(self):
        """
        The field of the sourceConfigSchema to display to the end user for
        naming this source config.

        :rtype: ``TEXT_TYPE``
        """
        return self._source_config_name_field[0]

    @source_config_name_field.setter
    def source_config_name_field(self, value):
        self._source_config_name_field = (value, True)

    @property
    def source_config_schema(self):
        """
        Dynamic parameters to represent the source config schema.

        :rtype: ``list`` of :py:class:`v1_6_1.web.vo.DynamicParameter`
        """
        return self._source_config_schema[0]

    @source_config_schema.setter
    def source_config_schema(self, value):
        self._source_config_schema = (value, True)

