# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.v1_9_0.web.objects.Operation import Operation
from delphixpy.v1_9_0 import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class RunSyncOperation(Operation):
    """
    *(extends* :py:class:`v1_9_0.web.vo.Operation` *)* A user-specifiable
    operation that runs sync from the target host.
    """
    def __init__(self, undef_enabled=True):
        super(RunSyncOperation, self).__init__()
        self._type = ("RunSyncOperation", True)
        self._environment = (self.__undef__, True)
        self._host = (self.__undef__, True)
        self._user = (self.__undef__, True)
        self._source_directory = (self.__undef__, True)
        self._exclude_paths = (self.__undef__, True)
        self._follow_symlink_paths = (self.__undef__, True)

    API_VERSION = "1.9.0"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(RunSyncOperation, cls).from_dict(data, dirty, undef_enabled)
        obj._environment = (data.get("environment", obj.__undef__), dirty)
        if obj._environment[0] is not None and obj._environment[0] is not obj.__undef__:
            assert isinstance(obj._environment[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._environment[0], type(obj._environment[0])))
            common.validate_format(obj._environment[0], "objectReference", None, None)
        obj._host = (data.get("host", obj.__undef__), dirty)
        if obj._host[0] is not None and obj._host[0] is not obj.__undef__:
            assert isinstance(obj._host[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._host[0], type(obj._host[0])))
            common.validate_format(obj._host[0], "objectReference", None, None)
        obj._user = (data.get("user", obj.__undef__), dirty)
        if obj._user[0] is not None and obj._user[0] is not obj.__undef__:
            assert isinstance(obj._user[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._user[0], type(obj._user[0])))
            common.validate_format(obj._user[0], "objectReference", None, None)
        obj._source_directory = (data.get("sourceDirectory", obj.__undef__), dirty)
        if obj._source_directory[0] is not None and obj._source_directory[0] is not obj.__undef__:
            assert isinstance(obj._source_directory[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._source_directory[0], type(obj._source_directory[0])))
            common.validate_format(obj._source_directory[0], "None", None, None)
        obj._exclude_paths = []
        for item in data.get("excludePaths") or []:
            assert isinstance(item, TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (item, type(item)))
            common.validate_format(item, "None", None, None)
            obj._exclude_paths.append(item)
        obj._exclude_paths = (obj._exclude_paths, dirty)
        obj._follow_symlink_paths = []
        for item in data.get("followSymlinkPaths") or []:
            assert isinstance(item, TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (item, type(item)))
            common.validate_format(item, "None", None, None)
            obj._follow_symlink_paths.append(item)
        obj._follow_symlink_paths = (obj._follow_symlink_paths, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(RunSyncOperation, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "environment" == "type" or (self.environment is not self.__undef__ and (not (dirty and not self._environment[1]) or isinstance(self.environment, list) or belongs_to_parent)):
            dct["environment"] = dictify(self.environment)
        if "host" == "type" or (self.host is not self.__undef__ and (not (dirty and not self._host[1]) or isinstance(self.host, list) or belongs_to_parent)):
            dct["host"] = dictify(self.host)
        if "user" == "type" or (self.user is not self.__undef__ and (not (dirty and not self._user[1]) or isinstance(self.user, list) or belongs_to_parent)):
            dct["user"] = dictify(self.user)
        if "source_directory" == "type" or (self.source_directory is not self.__undef__ and (not (dirty and not self._source_directory[1]) or isinstance(self.source_directory, list) or belongs_to_parent)):
            dct["sourceDirectory"] = dictify(self.source_directory)
        if "exclude_paths" == "type" or (self.exclude_paths is not self.__undef__ and (not (dirty and not self._exclude_paths[1]) or isinstance(self.exclude_paths, list) or belongs_to_parent)):
            dct["excludePaths"] = dictify(self.exclude_paths, prop_is_list_or_vo=True)
        if "follow_symlink_paths" == "type" or (self.follow_symlink_paths is not self.__undef__ and (not (dirty and not self._follow_symlink_paths[1]) or isinstance(self.follow_symlink_paths, list) or belongs_to_parent)):
            dct["followSymlinkPaths"] = dictify(self.follow_symlink_paths, prop_is_list_or_vo=True)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._environment = (self._environment[0], True)
        self._host = (self._host[0], True)
        self._user = (self._user[0], True)
        self._source_directory = (self._source_directory[0], True)
        self._exclude_paths = (self._exclude_paths[0], True)
        self._follow_symlink_paths = (self._follow_symlink_paths[0], True)

    def is_dirty(self):
        return any([self._environment[1], self._host[1], self._user[1], self._source_directory[1], self._exclude_paths[1], self._follow_symlink_paths[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, RunSyncOperation):
            return False
        return super(RunSyncOperation, self).__eq__(other) and \
               self.environment == other.environment and \
               self.host == other.host and \
               self.user == other.user and \
               self.source_directory == other.source_directory and \
               self.exclude_paths == other.exclude_paths and \
               self.follow_symlink_paths == other.follow_symlink_paths

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def environment(self):
        """
        The environment to sync from.

        :rtype: ``TEXT_TYPE``
        """
        return self._environment[0]

    @environment.setter
    def environment(self, value):
        self._environment = (value, True)

    @property
    def host(self):
        """
        The host on which to sync.

        :rtype: ``TEXT_TYPE``
        """
        return self._host[0]

    @host.setter
    def host(self, value):
        self._host = (value, True)

    @property
    def user(self):
        """
        The environment user to use when syncing.

        :rtype: ``TEXT_TYPE``
        """
        return self._user[0]

    @user.setter
    def user(self, value):
        self._user = (value, True)

    @property
    def source_directory(self):
        """
        The directory data is copied from.

        :rtype: ``TEXT_TYPE``
        """
        return self._source_directory[0]

    @source_directory.setter
    def source_directory(self, value):
        self._source_directory = (value, True)

    @property
    def exclude_paths(self):
        """
        List of subdirectories in the source to exclude when syncing data.
        These paths are relative to the root of the source directory.

        :rtype: ``list`` of ``TEXT_TYPE``
        """
        return self._exclude_paths[0]

    @exclude_paths.setter
    def exclude_paths(self, value):
        self._exclude_paths = (value, True)

    @property
    def follow_symlink_paths(self):
        """
        List of symlinks in the source to follow when syncing data. These paths
        are relative to the root of the source directory. All other symlinks
        are preserved.

        :rtype: ``list`` of ``TEXT_TYPE``
        """
        return self._follow_symlink_paths[0]

    @follow_symlink_paths.setter
    def follow_symlink_paths(self, value):
        self._follow_symlink_paths = (value, True)

