# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-appdata-direct-link-data.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.v1_9_1.web.objects.AppDataLinkData import AppDataLinkData
from delphixpy.v1_9_1 import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class AppDataDirectLinkData(AppDataLinkData):
    """
    *(extends* :py:class:`v1_9_1.web.vo.AppDataLinkData` *)* Represents the
    AppData specific parameters of a link request for a source directly
    replicated into the Delphix Engine.
    """
    def __init__(self, undef_enabled=True):
        super(AppDataDirectLinkData, self).__init__()
        self._type = ("AppDataDirectLinkData", True)
        self._config = (self.__undef__, True)
        self._excludes = (self.__undef__, True)
        self._follow_symlinks = (self.__undef__, True)

    API_VERSION = "1.9.1"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(AppDataDirectLinkData, cls).from_dict(data, dirty, undef_enabled)
        if "config" not in data:
            raise ValueError("Missing required property \"config\".")
        obj._config = (data.get("config", obj.__undef__), dirty)
        if obj._config[0] is not None and obj._config[0] is not obj.__undef__:
            assert isinstance(obj._config[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._config[0], type(obj._config[0])))
            common.validate_format(obj._config[0], "objectReference", None, None)
        if "excludes" not in data:
            raise ValueError("Missing required property \"excludes\".")
        obj._excludes = []
        for item in data.get("excludes") or []:
            assert isinstance(item, TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (item, type(item)))
            common.validate_format(item, "None", None, None)
            obj._excludes.append(item)
        obj._excludes = (obj._excludes, dirty)
        if "followSymlinks" not in data:
            raise ValueError("Missing required property \"followSymlinks\".")
        obj._follow_symlinks = []
        for item in data.get("followSymlinks") or []:
            assert isinstance(item, TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (item, type(item)))
            common.validate_format(item, "None", None, None)
            obj._follow_symlinks.append(item)
        obj._follow_symlinks = (obj._follow_symlinks, dirty)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(AppDataDirectLinkData, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "config" == "type" or (self.config is not self.__undef__ and (not (dirty and not self._config[1]) or isinstance(self.config, list) or belongs_to_parent)):
            dct["config"] = dictify(self.config)
        if "excludes" == "type" or (self.excludes is not self.__undef__ and (not (dirty and not self._excludes[1]) or isinstance(self.excludes, list) or belongs_to_parent)):
            dct["excludes"] = dictify(self.excludes, prop_is_list_or_vo=True)
        if "follow_symlinks" == "type" or (self.follow_symlinks is not self.__undef__ and (not (dirty and not self._follow_symlinks[1]) or isinstance(self.follow_symlinks, list) or belongs_to_parent)):
            dct["followSymlinks"] = dictify(self.follow_symlinks, prop_is_list_or_vo=True)
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._config = (self._config[0], True)
        self._excludes = (self._excludes[0], True)
        self._follow_symlinks = (self._follow_symlinks[0], True)

    def is_dirty(self):
        return any([self._config[1], self._excludes[1], self._follow_symlinks[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, AppDataDirectLinkData):
            return False
        return super(AppDataDirectLinkData, self).__eq__(other) and \
               self.config == other.config and \
               self.excludes == other.excludes and \
               self.follow_symlinks == other.follow_symlinks

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def config(self):
        """
        Reference to the configuration for the source.

        :rtype: ``TEXT_TYPE``
        """
        return self._config[0]

    @config.setter
    def config(self, value):
        self._config = (value, True)

    @property
    def excludes(self):
        """
        List of subdirectories in the source to exclude when syncing data.
        These paths are relative to the root of the source directory.

        :rtype: ``list`` of ``TEXT_TYPE``
        """
        return self._excludes[0]

    @excludes.setter
    def excludes(self, value):
        self._excludes = (value, True)

    @property
    def follow_symlinks(self):
        """
        List of symlinks in the source to follow when syncing data. These paths
        are relative to the root of the source directory. All other symlinks
        are preserved.

        :rtype: ``list`` of ``TEXT_TYPE``
        """
        return self._follow_symlinks[0]

    @follow_symlinks.setter
    def follow_symlinks(self, value):
        self._follow_symlinks = (value, True)

