# coding: utf8
#
# Copyright 2022 by Delphix
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#
# This class has been automatically generated from:
#     /delphix-mssql-db-container.json
#
# Do not edit this file manually!
#

from __future__ import unicode_literals

from delphixpy.v1_9_1.web.objects.DatabaseContainer import DatabaseContainer
from delphixpy.v1_9_1 import factory
from delphixpy.v1_9_1 import common

class __Undef(object):
    def __repr__(self):
        return "undef"

    def __setattr__(self, name, value):
        raise Exception('Cannot modify attributes of __Undef.')

_UNDEFINED = __Undef()

try:
    TEXT_TYPE = unicode
except NameError:
    TEXT_TYPE = str

class MSSqlDatabaseContainer(DatabaseContainer):
    """
    *(extends* :py:class:`v1_9_1.web.vo.DatabaseContainer` *)* A MSSQL Database
    Container.
    """
    def __init__(self, undef_enabled=True):
        super(MSSqlDatabaseContainer, self).__init__()
        self._type = ("MSSqlDatabaseContainer", True)
        self._runtime = (self.__undef__, True)
        self._delphix_managed_status = (self.__undef__, True)

    API_VERSION = "1.9.1"

    @classmethod
    def from_dict(cls, data, dirty=False, undef_enabled=True):
        obj = super(MSSqlDatabaseContainer, cls).from_dict(data, dirty, undef_enabled)
        if "runtime" in data and data["runtime"] is not None:
            obj._runtime = (factory.create_object(data["runtime"], "MSSqlDBContainerRuntime"), dirty)
            factory.validate_type(obj._runtime[0], "MSSqlDBContainerRuntime")
        else:
            obj._runtime = (obj.__undef__, dirty)
        obj._delphix_managed_status = (data.get("delphixManagedStatus", obj.__undef__), dirty)
        if obj._delphix_managed_status[0] is not None and obj._delphix_managed_status[0] is not obj.__undef__:
            assert isinstance(obj._delphix_managed_status[0], TEXT_TYPE), ("Expected one of ['string'], but got %s of type %s" % (obj._delphix_managed_status[0], type(obj._delphix_managed_status[0])))
            assert obj._delphix_managed_status[0] in ['DELPHIX_MANAGED_UNCOMPRESSED', 'DELPHIX_MANAGED_COMPRESSED', 'NOT_DELPHIX_MANAGED'], "Expected enum ['DELPHIX_MANAGED_UNCOMPRESSED', 'DELPHIX_MANAGED_COMPRESSED', 'NOT_DELPHIX_MANAGED'] but got %s" % obj._delphix_managed_status[0]
            common.validate_format(obj._delphix_managed_status[0], "None", None, None)
        return obj

    def to_dict(self, dirty=False, belongs_to_parent=False):
        dct = super(MSSqlDatabaseContainer, self).to_dict(dirty, belongs_to_parent)

        def dictify(obj, prop_is_list_or_vo=False):
            if isinstance(obj, list):
                return [dictify(o, prop_is_list_or_vo) for o in obj]
            elif hasattr(obj, "to_dict"):
                return obj.to_dict(dirty=dirty, belongs_to_parent=prop_is_list_or_vo)
            else:
                return obj
        if "runtime" == "type" or (self.runtime is not self.__undef__ and (not (dirty and not self._runtime[1]))):
            dct["runtime"] = dictify(self.runtime)
        if "delphix_managed_status" == "type" or (self.delphix_managed_status is not self.__undef__ and (not (dirty and not self._delphix_managed_status[1]) or isinstance(self.delphix_managed_status, list) or belongs_to_parent)):
            dct["delphixManagedStatus"] = dictify(self.delphix_managed_status)
        elif belongs_to_parent and self.delphix_managed_status is self.__undef__:
            dct["delphixManagedStatus"] = "NOT_DELPHIX_MANAGED"
        return dct

    def dirty(self):
        return self.from_dict(self.to_dict(dirty=False), dirty=True)

    def force_dirty(self):
        self._runtime = (self._runtime[0], True)
        self._delphix_managed_status = (self._delphix_managed_status[0], True)

    def is_dirty(self):
        return any([self._runtime[1], self._delphix_managed_status[1]])

    def __eq__(self, other):
        if other is None:
            return False
        if not isinstance(other, MSSqlDatabaseContainer):
            return False
        return super(MSSqlDatabaseContainer, self).__eq__(other) and \
               self.runtime == other.runtime and \
               self.delphix_managed_status == other.delphix_managed_status

    def __ne__(self, other):
        return not self.__eq__(other)

    def __hash__(self):
        return id(self)

    def __repr__(self):
        return common.generate_repr_string(self)

    @property
    def runtime(self):
        """
        Runtime properties of this container.

        :rtype: :py:class:`v1_9_1.web.vo.MSSqlDBContainerRuntime`
        """
        return self._runtime[0]

    @runtime.setter
    def runtime(self, value):
        self._runtime = (value, True)

    @property
    def delphix_managed_status(self):
        """
        *(default value: NOT_DELPHIX_MANAGED)* Specifies whether Delphix should
        manage the backups for this container and if so, specify whether they
        are compressed or uncompressed. *(permitted values:
        DELPHIX_MANAGED_UNCOMPRESSED, DELPHIX_MANAGED_COMPRESSED,
        NOT_DELPHIX_MANAGED)*

        :rtype: ``TEXT_TYPE``
        """
        return self._delphix_managed_status[0]

    @delphix_managed_status.setter
    def delphix_managed_status(self, value):
        self._delphix_managed_status = (value, True)

