# AUTOGENERATED! DO NOT EDIT! File to edit: 01_direction.ipynb (unless otherwise specified).

__all__ = ['Direction']

# Cell
class Direction:
    """
    A cyclic direction class to make rotation easier.

    The directions are written in a specific order of North, East, South, West
    instead of North, South, East, West to make rotation simpler.

    To rotate the direction clockwise, this class simply updates the `idx` to `idx+1`.
    To rotate the direction clockwise, this class simply updates the `idx` to `idx-1`.

    Returns:
        An instance of itself with the updated direction on calling either `left` or `right`.
    """
    def __init__(self, directions=['NORTH', 'EAST', 'SOUTH', 'WEST'], idx=None):
        # get random direction if not passed
        if idx is None:
            idx = np.random.choice(np.arange(4))
        self.directions = directions
        self.max_idx = len(directions)-1
        self.f = self.directions[idx]

    def get_idx(self):
        "return the current direction index from `self.directions`."
        return self.directions.index(self.f)

    def left(self):
        "first get current direction index, then subtract 1 to rotate left."
        idx = self.get_idx()
        new_idx = idx-1 if idx>=1 else self.max_idx
        return self.__class__(idx=new_idx)

    def right(self):
        "first get current direction index, then add 1 to rotate right."
        idx = self.get_idx()
        new_idx = idx+1 if idx<=2 else 0
        return self.__class__(idx=new_idx)

    def __repr__(self):
        return self.f