# coding: utf-8

"""
    Data Repository API

    <details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress** There are a few top-level endpoints (besides some used by swagger):  * / - generated by swagger: swagger API page that provides this documentation and a live UI for submitting REST requests  * /status - provides the operational status of the service  * /configuration - provides the basic configuration and information about the service  * /api - is the authenticated and authorized Data Repository API  * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API  The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>   # noqa: E501

    The version of the OpenAPI document: 0.1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import unittest
import datetime

import data_repo_client
from data_repo_client.models.drs_object import DRSObject  # noqa: E501
from data_repo_client.rest import ApiException

class TestDRSObject(unittest.TestCase):
    """DRSObject unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional):
        """Test DRSObject
            include_option is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # model = data_repo_client.models.drs_object.DRSObject()  # noqa: E501
        if include_optional :
            return DRSObject(
                id = '0', 
                name = '0', 
                self_uri = 'drs://drs.example.org/314159', 
                size = 56, 
                created_time = '0', 
                updated_time = '0', 
                version = '0', 
                mime_type = 'application/json', 
                checksums = [
                    data_repo_client.models.drs_checksum.DRSChecksum(
                        checksum = '0', 
                        type = '0', )
                    ], 
                access_methods = [
                    data_repo_client.models.drs_access_method.DRSAccessMethod(
                        type = 's3', 
                        access_url = data_repo_client.models.drs_access_url.DRSAccessURL(
                            url = '0', 
                            headers = {"Authorization":"Basic Z2E0Z2g6ZHJz"}, ), 
                        access_id = '0', 
                        region = 'us-east-1', 
                        authorizations = data_repo_client.models.drs_authorizations.DRSAuthorizations(
                            supported_types = [
                                'None'
                                ], 
                            passport_auth_issuers = [
                                '0'
                                ], 
                            bearer_auth_issuers = [
                                '0'
                                ], ), )
                    ], 
                contents = [
                    data_repo_client.models.drs_contents_object.DRSContentsObject(
                        name = '0', 
                        id = '0', 
                        drs_uri = drs://example.com/ga4gh/drs/v1/objects/{object_id}, 
                        contents = [
                            data_repo_client.models.drs_contents_object.DRSContentsObject(
                                name = '0', 
                                id = '0', 
                                drs_uri = drs://example.com/ga4gh/drs/v1/objects/{object_id}, )
                            ], )
                    ], 
                description = '0', 
                aliases = [
                    '0'
                    ]
            )
        else :
            return DRSObject(
                id = '0',
                self_uri = 'drs://drs.example.org/314159',
                size = 56,
                checksums = [
                    data_repo_client.models.drs_checksum.DRSChecksum(
                        checksum = '0', 
                        type = '0', )
                    ],
        )

    def testDRSObject(self):
        """Test DRSObject"""
        inst_req_only = self.make_instance(include_optional=False)
        inst_req_and_optional = self.make_instance(include_optional=True)


if __name__ == '__main__':
    unittest.main()
