# AVIV CDK for Python

A set of AWS CDK examples and constructs.

## Install

Requires:

- Python >= 3.6
- pip

```sh
pip install aviv-cdk
```

Extras (provides additionnal libraries, in order to build some constructs):

- `cicd` - CDK codebuild/deploy
- `nextstep` - Stepfunctions & co
- `data` - data related stuff

```shx
pip install aviv-cdk[EXTRA]
```

## Build, distrib & release

_Requires __twine__ to be installed (`pip install twine`) and credentials to upload a new verison to pypi._

```sh
python3 setup.py sdist bdist_wheel
# test distrib
python3 -m twine upload --repository testpypi dist/*
```

## Included CDK apps / samples

- [CICD](docs/CICD.md)
- [IAM identity provider](docs/IAMidp.md)

## Command line tools

- [aviv-aws](bin/aws_local.py) (WIP)  
  Helper to run AWS stuff locally (CDK / SAM / StepFunctionsLocal)
- [aviv-cdk-sfn-extract](bin/sfn_extract.py)  
  Extract a StateMachine from a CFN template

## Develop and contribute :)

Requirements:

- Pipenv
- AWS cdk client
- [optional] docker
- [optional] AWS codebuild docker image (standard >= 4.0)

```sh
git clone https://github.com/aviv-group/aviv-cdk-python && cd aviv-cdk-python
pipenv install -d -e .

# Build with codebuild agent - see: buildspec.yml
codebuild_build.sh -i aws/codebuild/standard:4.0 -a cdk.out

# Run tests
pipenv run pytest -v tests/
```

## Contribute

Yes please! Fork this project, tweak it and share it back by sending your PRs.  
Have a look at the [TODO's](TODO) and [changelog](CHANGELOG) file if you're looking for inspiration.

## License

This project is developed under the [MIT license](license).

## Author(s) and Contributors

- Jules Clement \<jules.clement@aviv-group.com>
