/// @file
/// @author David Pilger <dpilger26@gmail.com>
/// [GitHub Repository](https://github.com/dpilger26/NumCpp)
///
/// License
/// Copyright 2018-2022 David Pilger
///
/// Permission is hereby granted, free of charge, to any person obtaining a copy of this
/// software and associated documentation files(the "Software"), to deal in the Software
/// without restriction, including without limitation the rights to use, copy, modify,
/// merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
/// permit persons to whom the Software is furnished to do so, subject to the following
/// conditions :
///
/// The above copyright notice and this permission notice shall be included in all copies
/// or substantial portions of the Software.
///
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
/// INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
/// PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
/// FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
/// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
/// DEALINGS IN THE SOFTWARE.
///
/// Description
/// Random number distributions
///
#pragma once

#include "NumCpp/Random/RNG.hpp"
#include "NumCpp/Random/bernoulli.hpp"
#include "NumCpp/Random/beta.hpp"
#include "NumCpp/Random/binomial.hpp"
#include "NumCpp/Random/cauchy.hpp"
#include "NumCpp/Random/chiSquare.hpp"
#include "NumCpp/Random/choice.hpp"
#include "NumCpp/Random/discrete.hpp"
#include "NumCpp/Random/exponential.hpp"
#include "NumCpp/Random/extremeValue.hpp"
#include "NumCpp/Random/f.hpp"
#include "NumCpp/Random/gamma.hpp"
#include "NumCpp/Random/generator.hpp"
#include "NumCpp/Random/geometric.hpp"
#include "NumCpp/Random/laplace.hpp"
#include "NumCpp/Random/lognormal.hpp"
#include "NumCpp/Random/negativeBinomial.hpp"
#include "NumCpp/Random/nonCentralChiSquared.hpp"
#include "NumCpp/Random/normal.hpp"
#include "NumCpp/Random/permutation.hpp"
#include "NumCpp/Random/poisson.hpp"
#include "NumCpp/Random/rand.hpp"
#include "NumCpp/Random/randFloat.hpp"
#include "NumCpp/Random/randInt.hpp"
#include "NumCpp/Random/randN.hpp"
#include "NumCpp/Random/shuffle.hpp"
#include "NumCpp/Random/standardNormal.hpp"
#include "NumCpp/Random/studentT.hpp"
#include "NumCpp/Random/triangle.hpp"
#include "NumCpp/Random/uniform.hpp"
#include "NumCpp/Random/uniformOnSphere.hpp"
#include "NumCpp/Random/weibull.hpp"
