/// @file
/// @author David Pilger <dpilger26@gmail.com>
/// [GitHub Repository](https://github.com/dpilger26/NumCpp)
///
/// License
/// Copyright 2018-2022 David Pilger
///
/// Permission is hereby granted, free of charge, to any person obtaining a copy of this
/// software and associated documentation files(the "Software"), to deal in the Software
/// without restriction, including without limitation the rights to use, copy, modify,
/// merge, publish, distribute, sublicense, and/or sell copies of the Software, and to
/// permit persons to whom the Software is furnished to do so, subject to the following
/// conditions :
///
/// The above copyright notice and this permission notice shall be included in all copies
/// or substantial portions of the Software.
///
/// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
/// INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
/// PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
/// FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
/// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
/// DEALINGS IN THE SOFTWARE.
///
/// Description
/// Special Functions
///
#pragma once

#include "NumCpp/Special/airy_ai.hpp"
#include "NumCpp/Special/airy_ai_prime.hpp"
#include "NumCpp/Special/airy_bi.hpp"
#include "NumCpp/Special/airy_bi_prime.hpp"
#include "NumCpp/Special/bernoulli.hpp"
#include "NumCpp/Special/bessel_in.hpp"
#include "NumCpp/Special/bessel_in_prime.hpp"
#include "NumCpp/Special/bessel_jn.hpp"
#include "NumCpp/Special/bessel_jn_prime.hpp"
#include "NumCpp/Special/bessel_kn.hpp"
#include "NumCpp/Special/bessel_kn_prime.hpp"
#include "NumCpp/Special/bessel_yn.hpp"
#include "NumCpp/Special/bessel_yn_prime.hpp"
#include "NumCpp/Special/beta.hpp"
#include "NumCpp/Special/cnr.hpp"
#include "NumCpp/Special/comp_ellint_1.hpp"
#include "NumCpp/Special/comp_ellint_2.hpp"
#include "NumCpp/Special/comp_ellint_3.hpp"
#include "NumCpp/Special/cyclic_hankel_1.hpp"
#include "NumCpp/Special/cyclic_hankel_2.hpp"
#include "NumCpp/Special/digamma.hpp"
#include "NumCpp/Special/ellint_1.hpp"
#include "NumCpp/Special/ellint_2.hpp"
#include "NumCpp/Special/ellint_3.hpp"
#include "NumCpp/Special/erf.hpp"
#include "NumCpp/Special/erf_inv.hpp"
#include "NumCpp/Special/erfc.hpp"
#include "NumCpp/Special/erfc_inv.hpp"
#include "NumCpp/Special/expint.hpp"
#include "NumCpp/Special/factorial.hpp"
#include "NumCpp/Special/gamma.hpp"
#include "NumCpp/Special/gamma1pm1.hpp"
#include "NumCpp/Special/log_gamma.hpp"
#include "NumCpp/Special/pnr.hpp"
#include "NumCpp/Special/polygamma.hpp"
#include "NumCpp/Special/prime.hpp"
#include "NumCpp/Special/riemann_zeta.hpp"
#include "NumCpp/Special/softmax.hpp"
#include "NumCpp/Special/spherical_bessel_jn.hpp"
#include "NumCpp/Special/spherical_bessel_yn.hpp"
#include "NumCpp/Special/spherical_hankel_1.hpp"
#include "NumCpp/Special/spherical_hankel_2.hpp"
#include "NumCpp/Special/trigamma.hpp"
