import numpy as np
import pandas as pd

from steam_sdk.data.DataAnalysis import ModifyModelMultipleVariables
from steam_sdk.utils.tic_toc import toc


def set_magnet_specific_parameters(aSTEAM, verbose):
    # Function to set up all parameters needed for a short-circuit analysis that are not dependent on the short-circuit position, but are dependent on the magnet


    # Add parameter values to analysis step
    current_step = 'set_magnet_specific_parameters'
    aSTEAM.data_analysis.AnalysisStepDefinition[current_step] = ModifyModelMultipleVariables(type='ModifyModelMultipleVariables')
    aSTEAM.data_analysis.AnalysisStepDefinition[current_step].model_name = 'BM'
    aSTEAM.data_analysis.AnalysisStepDefinition[current_step].variables_to_change = [
        'Circuit.R_circuit',
        'Power_Supply.I_initial',
        'Power_Supply.t_off',
        'Power_Supply.t_control_LUT',
        'Power_Supply.I_control_LUT',
        'Power_Supply.R_crowbar',
        'Power_Supply.Ud_crowbar',
        'Options_LEDET.time_vector.time_vector_params',
        'Options_LEDET.physics.fScaling_Mis',
        'Options_LEDET.physics.maxVoltagePC',
        'Options_LEDET.physics.minCurrentDiode',
        'Options_LEDET.simulation_3D.sim3D_min_ds_coarse',
        'Options_LEDET.simulation_3D.sim3D_min_ds_fine',
        'Options_LEDET.simulation_3D.sim3D_min_nodesPerStraightPart',
        'Options_LEDET.simulation_3D.sim3D_min_nodesPerEndsPart',
    ]
    aSTEAM.data_analysis.AnalysisStepDefinition[current_step].variables_value = [
        [0.0413],
        [0.0],
        [99999.0],
        [[0.0, 0.001, 0.002, 0.003, 0.004, 0.005, 0.006, 0.007, 0.008, 0.009, 0.01, 0.011, 0.012, 0.013, 0.014, 0.015, 0.016, 0.017, 0.018, 0.019, 0.02, 0.021, 0.022, 0.023, 0.024, 0.025, 0.026, 0.027, 0.028, 0.029, 0.03, 0.031, 0.032, 0.033, 0.034, 0.035, 0.036, 0.037, 0.038, 0.039, 0.04, 0.041, 0.042, 0.043, 0.044, 0.045, 0.046, 0.047, 0.048, 0.049, 0.05, 0.051, 0.052, 0.053, 0.054, 0.055, 0.056, 0.057, 0.058, 0.059, 0.06, 0.061, 0.062, 0.063, 0.064, 0.065, 0.066, 0.067, 0.068, 0.069, 0.07, 0.071, 0.072, 0.073, 0.074, 0.075, 0.076, 0.077, 0.078, 0.079, 0.08, 0.081, 0.082, 0.083, 0.084, 0.085, 0.086, 0.087, 0.088, 0.089, 0.09, 0.091, 0.092, 0.093, 0.094, 0.095, 0.096, 0.097, 0.098, 0.099, 0.1, 0.101, 0.102, 0.103, 0.104, 0.105, 0.106, 0.107, 0.108, 0.109, 0.11, 0.111, 0.112, 0.113, 0.114, 0.115, 0.116, 0.117, 0.118, 0.119, 0.12, 0.121, 0.122, 0.123, 0.124, 0.125, 0.126, 0.127, 0.128, 0.129, 0.13, 0.131, 0.132, 0.133, 0.134, 0.135, 0.136, 0.137, 0.138, 0.139, 0.14, 0.141, 0.142, 0.143, 0.144, 0.145, 0.146, 0.147, 0.148, 0.149, 0.15, 0.151, 0.152, 0.153, 0.154, 0.155, 0.156, 0.157, 0.158, 0.159, 0.16, 0.161, 0.162, 0.163, 0.164, 0.165, 0.166, 0.167, 0.168, 0.169, 0.17, 0.171, 0.172, 0.173, 0.174, 0.175, 0.176, 0.177, 0.178, 0.179, 0.18, 0.181, 0.182, 0.183, 0.184, 0.185, 0.186, 0.187, 0.188, 0.189, 0.19, 0.191, 0.192, 0.193, 0.194, 0.195, 0.196, 0.197, 0.198, 0.199, 0.2, 0.201, 0.202, 0.203, 0.204, 0.205, 0.206, 0.207, 0.208, 0.209, 0.21, 0.211, 0.212, 0.213, 0.214, 0.215, 0.216, 0.217, 0.218, 0.219, 0.22, 0.221, 0.222, 0.223, 0.224, 0.225, 0.226, 0.227, 0.228, 0.229, 0.23, 0.231, 0.232, 0.233, 0.234, 0.235, 0.236, 0.237, 0.238, 0.239, 0.24, 0.241, 0.242, 0.243, 0.244, 0.245, 0.246, 0.247, 0.248, 0.249, 0.25, 0.251, 0.252, 0.253, 0.254, 0.255, 0.256, 0.257, 0.258, 0.259, 0.26, 0.261, 0.262, 0.263, 0.264, 0.265, 0.266, 0.267, 0.268, 0.269, 0.27, 0.271, 0.272, 0.273, 0.274, 0.275, 0.276, 0.277, 0.278, 0.279, 0.28, 0.281, 0.282, 0.283, 0.284, 0.285, 0.286, 0.287, 0.288, 0.289, 0.29, 0.291, 0.292, 0.293, 0.294, 0.295, 0.296, 0.297, 0.298, 0.299, 0.3, 0.301, 0.302, 0.303, 0.304, 0.305, 0.306, 0.307, 0.308, 0.309, 0.31, 0.311, 0.312, 0.313, 0.314, 0.315, 0.316, 0.317, 0.318, 0.319, 0.32, 0.321, 0.322, 0.323, 0.324, 0.325, 0.326, 0.327, 0.328, 0.329, 0.33, 0.331, 0.332, 0.333, 0.334, 0.335, 0.336, 0.337, 0.338, 0.339, 0.34, 0.341, 0.342, 0.343, 0.344, 0.345, 0.346, 0.347, 0.348, 0.349, 0.35, 0.351, 0.352, 0.353, 0.354, 0.355, 0.356, 0.357, 0.358, 0.359, 0.36, 0.361, 0.362, 0.363, 0.364, 0.365, 0.366, 0.367, 0.368, 0.369, 0.37, 0.371, 0.372, 0.373, 0.374, 0.375, 0.376, 0.377, 0.378, 0.379, 0.38, 0.381, 0.382, 0.383, 0.384, 0.385, 0.386, 0.387, 0.388, 0.389, 0.39, 0.391, 0.392, 0.393, 0.394, 0.395, 0.396, 0.397, 0.398, 0.399, 0.4, 0.401, 0.402, 0.403, 0.404, 0.405, 0.406, 0.407, 0.408, 0.409, 0.41, 0.411, 0.412, 0.413, 0.414, 0.415, 0.416, 0.417, 0.418, 0.419, 0.42, 0.421, 0.422, 0.423, 0.424, 0.425, 0.426, 0.427, 0.428, 0.429, 0.43, 0.431, 0.432, 0.433, 0.434, 0.435, 0.436, 0.437, 0.438, 0.439, 0.44, 0.441, 0.442, 0.443, 0.444, 0.445, 0.446, 0.447, 0.448, 0.449, 0.45, 0.451, 0.452, 0.453, 0.454, 0.455, 0.456, 0.457, 0.458, 0.459, 0.46, 0.461, 0.462, 0.463, 0.464, 0.465, 0.466, 0.467, 0.468, 0.469, 0.47, 0.471, 0.472, 0.473, 0.474, 0.475, 0.476, 0.477, 0.478, 0.479, 0.48, 0.481, 0.482, 0.483, 0.484, 0.485, 0.486, 0.487, 0.488, 0.489, 0.49, 0.491, 0.492, 0.493, 0.494, 0.495, 0.496, 0.497, 0.498, 0.499, 0.5, 0.501, 0.502, 0.503, 0.504, 0.505, 0.506, 0.507, 0.508, 0.509, 0.51, 0.511, 0.512, 0.513, 0.514, 0.515, 0.516, 0.517, 0.518, 0.519, 0.52, 0.521, 0.522, 0.523, 0.524, 0.525, 0.526, 0.527, 0.528, 0.529, 0.53, 0.531, 0.532, 0.533, 0.534, 0.535, 0.536, 0.537, 0.538, 0.539, 0.54, 0.541, 0.542, 0.543, 0.544, 0.545, 0.546, 0.547, 0.548, 0.549, 0.55, 0.551, 0.552, 0.553, 0.554, 0.555, 0.556, 0.557, 0.558, 0.559, 0.56, 0.561, 0.562, 0.563, 0.564, 0.565, 0.566, 0.567, 0.568, 0.569, 0.57, 0.571, 0.572, 0.573, 0.574, 0.575, 0.576, 0.577, 0.578, 0.579, 0.58, 0.581, 0.582, 0.583, 0.584, 0.585, 0.586, 0.587, 0.588, 0.589, 0.59, 0.591, 0.592, 0.593, 0.594, 0.595, 0.596, 0.597, 0.598, 0.599, 0.6, 0.601, 0.602, 0.603, 0.604, 0.605, 0.606, 0.607, 0.608, 0.609, 0.61, 0.611, 0.612, 0.613, 0.614, 0.615, 0.616, 0.617, 0.618, 0.619, 0.62, 0.621, 0.622, 0.623, 0.624, 0.625, 0.626, 0.627, 0.628, 0.629, 0.63, 0.631, 0.632, 0.633, 0.634, 0.635, 0.636, 0.637, 0.638, 0.639, 0.64, 0.641, 0.642, 0.643, 0.644, 0.645, 0.646, 0.647, 0.648, 0.649, 0.65, 0.651, 0.652, 0.653, 0.654, 0.655, 0.656, 0.657, 0.658, 0.659, 0.66, 0.661, 0.662, 0.663, 0.664, 0.665, 0.666, 0.667, 0.668, 0.669, 0.67, 0.671, 0.672, 0.673, 0.674, 0.675, 0.676, 0.677, 0.678, 0.679, 0.68, 0.681, 0.682, 0.683, 0.684, 0.685, 0.686, 0.687, 0.688, 0.689, 0.69, 0.691, 0.692, 0.693, 0.694, 0.695, 0.696, 0.697, 0.698, 0.699, 0.7, 0.701, 0.702, 0.703, 0.704, 0.705, 0.706, 0.707, 0.708, 0.709, 0.71, 0.711, 0.712, 0.713, 0.714, 0.715, 0.716, 0.717, 0.718, 0.719, 0.72, 0.721, 0.722, 0.723, 0.724, 0.725, 0.726, 0.727, 0.728, 0.729, 0.73, 0.731, 0.732, 0.733, 0.734, 0.735, 0.736, 0.737, 0.738, 0.739, 0.74, 0.741, 0.742, 0.743, 0.744, 0.745, 0.746, 0.747, 0.748, 0.749, 0.75, 0.751, 0.752, 0.753, 0.754, 0.755, 0.756, 0.757, 0.758, 0.759, 0.76, 0.761, 0.762, 0.763, 0.764, 0.765, 0.766, 0.767, 0.768, 0.769, 0.77, 0.771, 0.772, 0.773, 0.774, 0.775, 0.776, 0.777, 0.778, 0.779, 0.78, 0.781, 0.782, 0.783, 0.784, 0.785, 0.786, 0.787, 0.788, 0.789, 0.79, 0.791, 0.792, 0.793, 0.794, 0.795, 0.796, 0.797, 0.798, 0.799, 0.8, 0.801, 0.802, 0.803, 0.804, 0.805, 0.806, 0.807, 0.808, 0.809, 0.81, 0.811, 0.812, 0.813, 0.814, 0.815, 0.816, 0.817, 0.818, 0.819, 0.82, 0.821, 0.822, 0.823, 0.824, 0.825, 0.826, 0.827, 0.828, 0.829, 0.83, 0.831, 0.832, 0.833, 0.834, 0.835, 0.836, 0.837, 0.838, 0.839, 0.84, 0.841, 0.842, 0.843, 0.844, 0.845, 0.846, 0.847, 0.848, 0.849, 0.85, 0.851, 0.852, 0.853, 0.854, 0.855, 0.856, 0.857, 0.858, 0.859, 0.86, 0.861, 0.862, 0.863, 0.864, 0.865, 0.866, 0.867, 0.868, 0.869, 0.87, 0.871, 0.872, 0.873, 0.874, 0.875, 0.876, 0.877, 0.878, 0.879, 0.88, 0.881, 0.882, 0.883, 0.884, 0.885, 0.886, 0.887, 0.888, 0.889, 0.89, 0.891, 0.892, 0.893, 0.894, 0.895, 0.896, 0.897, 0.898, 0.899, 0.9, 0.901, 0.902, 0.903, 0.904, 0.905, 0.906, 0.907, 0.908, 0.909, 0.91, 0.911, 0.912, 0.913, 0.914, 0.915, 0.916, 0.917, 0.918, 0.919, 0.92, 0.921, 0.922, 0.923, 0.924, 0.925, 0.926, 0.927, 0.928, 0.929, 0.93, 0.931, 0.932, 0.933, 0.934, 0.935, 0.936, 0.937, 0.938, 0.939, 0.94, 0.941, 0.942, 0.943, 0.944, 0.945, 0.946, 0.947, 0.948, 0.949, 0.95, 0.951, 0.952, 0.953, 0.954, 0.955, 0.956, 0.957, 0.958, 0.959, 0.96, 0.961, 0.962, 0.963, 0.964, 0.965, 0.966, 0.967, 0.968, 0.969, 0.97, 0.971, 0.972, 0.973, 0.974, 0.975, 0.976, 0.977, 0.978, 0.979, 0.98, 0.981, 0.982, 0.983, 0.984, 0.985, 0.986, 0.987, 0.988, 0.989, 0.99, 0.991, 0.992, 0.993, 0.994, 0.995, 0.996, 0.997, 0.998, 0.999, 1.0, 1.001, 1.002, 1.003, 1.004, 1.005, 1.006, 1.007, 1.008, 1.009, 1.01, 1.011, 1.012, 1.013, 1.014, 1.015, 1.016, 1.017, 1.018, 1.019, 1.02, 1.021, 1.022, 1.023, 1.024, 1.025, 1.026, 1.027, 1.028, 1.029, 1.03, 1.031, 1.032, 1.033, 1.034, 1.035, 1.036, 1.037, 1.038, 1.039, 1.04, 1.041, 1.042, 1.043, 1.044, 1.045, 1.046, 1.047, 1.048, 1.049, 1.05, 1.051, 1.052, 1.053, 1.054, 1.055, 1.056, 1.057, 1.058, 1.059, 1.06, 1.061, 1.062, 1.063, 1.064, 1.065, 1.066, 1.067, 1.068, 1.069, 1.07, 1.071, 1.072, 1.073, 1.074, 1.075, 1.076, 1.077, 1.078, 1.079, 1.08, 1.081, 1.082, 1.083, 1.084, 1.085, 1.086, 1.087, 1.088, 1.089, 1.09, 1.091, 1.092, 1.093, 1.094, 1.095, 1.096, 1.097, 1.098, 1.099, 1.1, 1.101, 1.102, 1.103, 1.104, 1.105, 1.106, 1.107, 1.108, 1.109, 1.11, 1.111, 1.112, 1.113, 1.114, 1.115, 1.116, 1.117, 1.118, 1.119, 1.12, 1.121, 1.122, 1.123, 1.124, 1.125, 1.126, 1.127, 1.128, 1.129, 1.13, 1.131, 1.132, 1.133, 1.134, 1.135, 1.136, 1.137, 1.138, 1.139, 1.14, 1.141, 1.142, 1.143, 1.144, 1.145, 1.146, 1.147, 1.148, 1.149, 1.15, 1.151, 1.152, 1.153, 1.154, 1.155, 1.156, 1.157, 1.158, 1.159, 1.16, 1.161, 1.162, 1.163, 1.164, 1.165, 1.166, 1.167, 1.168, 1.169, 1.17, 1.171, 1.172, 1.173, 1.174, 1.175, 1.176, 1.177, 1.178, 1.179, 1.18, 1.181, 1.182, 1.183, 1.184, 1.185, 1.186, 1.187, 1.188, 1.189, 1.19, 1.191, 1.192, 1.193, 1.194, 1.195, 1.196, 1.197, 1.198, 1.199, 1.2, 1.201, 1.202, 1.203, 1.204, 1.205, 1.206, 1.207, 1.208, 1.209, 1.21, 1.211, 1.212, 1.213, 1.214, 1.215, 1.216, 1.217, 1.218, 1.219, 1.22, 1.221, 1.222, 1.223, 1.224, 1.225, 1.226, 1.227, 1.228, 1.229, 1.23, 1.231, 1.232, 1.233, 1.234, 1.235, 1.236, 1.237, 1.238, 1.239, 1.24, 1.241, 1.242, 1.243, 1.244, 1.245, 1.246, 1.247, 1.248, 1.249, 1.25, 1.251, 1.252, 1.253, 1.254, 1.255, 1.256, 1.257, 1.258, 1.259, 1.26, 1.261, 1.262, 1.263, 1.264, 1.265, 1.266, 1.267, 1.268, 1.269, 1.27, 1.271, 1.272, 1.273, 1.274, 1.275, 1.276, 1.277, 1.278, 1.279, 1.28, 1.281, 1.282, 1.283, 1.284, 1.285, 1.286, 1.287, 1.288, 1.289, 1.29, 1.291, 1.292, 1.293, 1.294, 1.295, 1.296, 1.297, 1.298, 1.299, 1.3, 1.301, 1.302, 1.303, 1.304, 1.305, 1.306, 1.307, 1.308, 1.309, 1.31, 1.311, 1.312, 1.313, 1.314, 1.315, 1.316, 1.317, 1.318, 1.319, 1.32, 1.321, 1.322, 1.323, 1.324, 1.325, 1.326, 1.327, 1.328, 1.329, 1.33, 1.331, 1.332, 1.333, 1.334, 1.335, 1.336, 1.337, 1.338, 1.339, 1.34, 1.341, 1.342, 1.343, 1.344, 1.345, 1.346, 1.347, 1.348, 1.349, 1.35, 1.351, 1.352, 1.353, 1.354, 1.355, 1.356, 1.357, 1.358, 1.359, 1.36, 1.361, 1.362, 1.363, 1.364, 1.365, 1.366, 1.367, 1.368, 1.369, 1.37, 1.371, 1.372, 1.373, 1.374, 1.375, 1.376, 1.377, 1.378, 1.379, 1.38, 1.381, 1.382, 1.383, 1.384, 1.385, 1.386, 1.387, 1.388, 1.389, 1.39, 1.391, 1.392, 1.393, 1.394, 1.395, 1.396, 1.397, 1.398, 1.399, 1.4, 1.401, 1.402, 1.403, 1.404, 1.405, 1.406, 1.407, 1.408, 1.409, 1.41, 1.411, 1.412, 1.413, 1.414, 1.415, 1.416, 1.417, 1.418, 1.419, 1.42, 1.421, 1.422, 1.423, 1.424, 1.425, 1.426, 1.427, 1.428, 1.429, 1.43, 1.431, 1.432, 1.433, 1.434, 1.435, 1.436, 1.437, 1.438, 1.439, 1.44, 1.441, 1.442, 1.443, 1.444, 1.445, 1.446, 1.447, 1.448, 1.449, 1.45, 1.451, 1.452, 1.453, 1.454, 1.455, 1.456, 1.457, 1.458, 1.459, 1.46, 1.461, 1.462, 1.463, 1.464, 1.465, 1.466, 1.467, 1.468, 1.469, 1.47, 1.471, 1.472, 1.473, 1.474, 1.475, 1.476, 1.477, 1.478, 1.479, 1.48, 1.481, 1.482, 1.483, 1.484, 1.485, 1.486, 1.487, 1.488, 1.489, 1.49, 1.491, 1.492, 1.493, 1.494, 1.495, 1.496, 1.497, 1.498, 1.499, 1.5, 1.501, 1.502, 1.503, 1.504, 1.505, 1.506, 1.507, 1.508, 1.509, 1.51, 1.511, 1.512, 1.513, 1.514, 1.515, 1.516, 1.517, 1.518, 1.519, 1.52, 1.521, 1.522, 1.523, 1.524, 1.525, 1.526, 1.527, 1.528, 1.529, 1.53, 1.531, 1.532, 1.533, 1.534, 1.535, 1.536, 1.537, 1.538, 1.539, 1.54, 1.541, 1.542, 1.543, 1.544, 1.545, 1.546, 1.547, 1.548, 1.549, 1.55, 1.551, 1.552, 1.553, 1.554, 1.555, 1.556, 1.557, 1.558, 1.559, 1.56, 1.561, 1.562, 1.563, 1.564, 1.565, 1.566, 1.567, 1.568, 1.569, 1.57, 1.571, 1.572, 1.573, 1.574, 1.575, 1.576, 1.577, 1.578, 1.579, 1.58, 1.581, 1.582, 1.583, 1.584, 1.585, 1.586, 1.587, 1.588, 1.589, 1.59, 1.591, 1.592, 1.593, 1.594, 1.595, 1.596, 1.597, 1.598, 1.599, 1.6, 1.601, 1.602, 1.603, 1.604, 1.605, 1.606, 1.607, 1.608, 1.609, 1.61, 1.611, 1.612, 1.613, 1.614, 1.615, 1.616, 1.617, 1.618, 1.619, 1.62, 1.621, 1.622, 1.623, 1.624, 1.625, 1.626, 1.627, 1.628, 1.629, 1.63, 1.631, 1.632, 1.633, 1.634, 1.635, 1.636, 1.637, 1.638, 1.639, 1.64, 1.641, 1.642, 1.643, 1.644, 1.645, 1.646, 1.647, 1.648, 1.649, 1.65, 1.651, 1.652, 1.653, 1.654, 1.655, 1.656, 1.657, 1.658, 1.659, 1.66, 1.661, 1.662, 1.663, 1.664, 1.665, 1.666, 1.667, 1.668, 1.669, 1.67, 1.671, 1.672, 1.673, 1.674, 1.675, 1.676, 1.677, 1.678, 1.679, 1.68, 1.681, 1.682, 1.683, 1.684, 1.685, 1.686, 1.687, 1.688, 1.689, 1.69, 1.691, 1.692, 1.693, 1.694, 1.695, 1.696, 1.697, 1.698, 1.699, 1.7, 1.701, 1.702, 1.703, 1.704, 1.705, 1.706, 1.707, 1.708, 1.709, 1.71, 1.711, 1.712, 1.713, 1.714, 1.715, 1.716, 1.717, 1.718, 1.719, 1.72, 1.721, 1.722, 1.723, 1.724, 1.725, 1.726, 1.727, 1.728, 1.729, 1.73, 1.731, 1.732, 1.733, 1.734, 1.735, 1.736, 1.737, 1.738, 1.739, 1.74, 1.741, 1.742, 1.743, 1.744, 1.745, 1.746, 1.747, 1.748, 1.749, 1.75, 1.751, 1.752, 1.753, 1.754, 1.755, 1.756, 1.757, 1.758, 1.759, 1.76, 1.761, 1.762, 1.763, 1.764, 1.765, 1.766, 1.767, 1.768, 1.769, 1.77, 1.771, 1.772, 1.773, 1.774, 1.775, 1.776, 1.777, 1.778, 1.779, 1.78, 1.781, 1.782, 1.783, 1.784, 1.785, 1.786, 1.787, 1.788, 1.789, 1.79, 1.791, 1.792, 1.793, 1.794, 1.795, 1.796, 1.797, 1.798, 1.799, 1.8, 1.801, 1.802, 1.803, 1.804, 1.805, 1.806, 1.807, 1.808, 1.809, 1.81, 1.811, 1.812, 1.813, 1.814, 1.815, 1.816, 1.817, 1.818, 1.819, 1.82, 1.821, 1.822, 1.823, 1.824, 1.825, 1.826, 1.827, 1.828, 1.829, 1.83, 1.831, 1.832, 1.833, 1.834, 1.835, 1.836, 1.837, 1.838, 1.839, 1.84, 1.841, 1.842, 1.843, 1.844, 1.845, 1.846, 1.847, 1.848, 1.849, 1.85, 1.851, 1.852, 1.853, 1.854, 1.855, 1.856, 1.857, 1.858, 1.859, 1.86, 1.861, 1.862, 1.863, 1.864, 1.865, 1.866, 1.867, 1.868, 1.869, 1.87, 1.871, 1.872, 1.873, 1.874, 1.875, 1.876, 1.877, 1.878, 1.879, 1.88, 1.881, 1.882, 1.883, 1.884, 1.885, 1.886, 1.887, 1.888, 1.889, 1.89, 1.891, 1.892, 1.893, 1.894, 1.895, 1.896, 1.897, 1.898, 1.899, 1.9, 1.901, 1.902, 1.903, 1.904, 1.905, 1.906, 1.907, 1.908, 1.909, 1.91, 1.911, 1.912, 1.913, 1.914, 1.915, 1.916, 1.917, 1.918, 1.919, 1.92, 1.921, 1.922, 1.923, 1.924, 1.925, 1.926, 1.927, 1.928, 1.929, 1.93, 1.931, 1.932, 1.933, 1.934, 1.935, 1.936, 1.937, 1.938, 1.939, 1.94, 1.941, 1.942, 1.943, 1.944, 1.945, 1.946, 1.947, 1.948, 1.949, 1.95, 1.951, 1.952, 1.953, 1.954, 1.955, 1.956, 1.957, 1.958, 1.959, 1.96, 1.961, 1.962, 1.963, 1.964, 1.965, 1.966, 1.967, 1.968, 1.969, 1.97, 1.971, 1.972, 1.973, 1.974, 1.975, 1.976, 1.977, 1.978, 1.979, 1.98, 1.981, 1.982, 1.983, 1.984, 1.985, 1.986, 1.987, 1.988, 1.989, 1.99, 1.991, 1.992, 1.993, 1.994, 1.995, 1.996, 1.997, 1.998, 1.999, 2.0, 2.001, 2.002, 2.003, 2.004, 2.005, 2.006, 2.007, 2.008, 2.009, 2.01, 2.011, 2.012, 2.013, 2.014, 2.015, 2.016, 2.017, 2.018, 2.019, 2.02, 2.021, 2.022, 2.023, 2.024, 2.025, 2.026, 2.027, 2.028, 2.029, 2.03, 2.031, 2.032, 2.033, 2.034, 2.035, 2.036, 2.037, 2.038, 2.039, 2.04, 2.041, 2.042, 2.043, 2.044, 2.045, 2.046, 2.047, 2.048, 2.049, 2.05, 2.051, 2.052, 2.053, 2.054, 2.055, 2.056, 2.057, 2.058, 2.059, 2.06, 2.061, 2.062, 2.063, 2.064, 2.065, 2.066, 2.067, 2.068, 2.069, 2.07, 2.071, 2.072, 2.073, 2.074, 2.075, 2.076, 2.077, 2.078, 2.079, 2.08, 2.081, 2.082, 2.083, 2.084, 2.085, 2.086, 2.087, 2.088, 2.089, 2.09, 2.091, 2.092, 2.093, 2.094, 2.095, 2.096, 2.097, 2.098, 2.099, 2.1, 2.101, 2.102, 2.103, 2.104, 2.105, 2.106, 2.107, 2.108, 2.109, 2.11, 2.111, 2.112, 2.113, 2.114, 2.115, 2.116, 2.117, 2.118, 2.119, 2.12, 2.121, 2.122, 2.123, 2.124, 2.125, 2.126, 2.127, 2.128, 2.129, 2.13, 2.131, 2.132, 2.133, 2.134, 2.135, 2.136, 2.137, 2.138, 2.139, 2.14, 2.141, 2.142, 2.143, 2.144, 2.145, 2.146, 2.147, 2.148, 2.149, 2.15, 2.151, 2.152, 2.153, 2.154, 2.155, 2.156, 2.157, 2.158, 2.159, 2.16, 2.161, 2.162, 2.163, 2.164, 2.165, 2.166, 2.167, 2.168, 2.169, 2.17, 2.171, 2.172, 2.173, 2.174, 2.175, 2.176, 2.177, 2.178, 2.179, 2.18, 2.181, 2.182, 2.183, 2.184, 2.185, 2.186, 2.187, 2.188, 2.189, 2.19, 2.191, 2.192, 2.193, 2.194, 2.195, 2.196, 2.197, 2.198, 2.199, 2.2, 2.201, 2.202, 2.203, 2.204, 2.205, 2.206, 2.207, 2.208, 2.209, 2.21, 2.211, 2.212, 2.213, 2.214, 2.215, 2.216, 2.217, 2.218, 2.219, 2.22, 2.221, 2.222, 2.223, 2.224, 2.225, 2.226, 2.227, 2.228, 2.229, 2.23, 2.231, 2.232, 2.233, 2.234, 2.235, 2.236, 2.237, 2.238, 2.239, 2.24, 2.241, 2.242, 2.243, 2.244, 2.245, 2.246, 2.247, 2.248, 2.249, 2.25, 2.251, 2.252, 2.253, 2.254, 2.255, 2.256, 2.257, 2.258, 2.259, 2.26, 2.261, 2.262, 2.263, 2.264, 2.265, 2.266, 2.267, 2.268, 2.269, 2.27, 2.271, 2.272, 2.273, 2.274, 2.275, 2.276, 2.277, 2.278, 2.279, 2.28, 2.281, 2.282, 2.283, 2.284, 2.285, 2.286, 2.287, 2.288, 2.289, 2.29, 2.291, 2.292, 2.293, 2.294, 2.295, 2.296, 2.297, 2.298, 2.299, 2.3, 2.301, 2.302, 2.303, 2.304, 2.305, 2.306, 2.307, 2.308, 2.309, 2.31, 2.311, 2.312, 2.313, 2.314, 2.315, 2.316, 2.317, 2.318, 2.319, 2.32, 2.321, 2.322, 2.323, 2.324, 2.325, 2.326, 2.327, 2.328, 2.329, 2.33, 2.331, 2.332, 2.333, 2.334, 2.335, 2.336, 2.337, 2.338, 2.339, 2.34, 2.341, 2.342, 2.343, 2.344, 2.345, 2.346, 2.347, 2.348, 2.349, 2.35, 2.351, 2.352, 2.353, 2.354, 2.355, 2.356, 2.357, 2.358, 2.359, 2.36, 2.361, 2.362, 2.363, 2.364, 2.365, 2.366, 2.367, 2.368, 2.369, 2.37, 2.371, 2.372, 2.373, 2.374, 2.375, 2.376, 2.377, 2.378, 2.379, 2.38, 2.381, 2.382, 2.383, 2.384, 2.385, 2.386, 2.387, 2.388, 2.389, 2.39, 2.391, 2.392, 2.393, 2.394, 2.395, 2.396, 2.397, 2.398, 2.399, 2.4, 2.401, 2.402, 2.403, 2.404, 2.405, 2.406, 2.407, 2.408, 2.409, 2.41, 2.411, 2.412, 2.413, 2.414, 2.415, 2.416, 2.417, 2.418, 2.419, 2.42, 2.421, 2.422, 2.423, 2.424, 2.425, 2.426, 2.427, 2.428, 2.429, 2.43, 2.431, 2.432, 2.433, 2.434, 2.435, 2.436, 2.437, 2.438, 2.439, 2.44, 2.441, 2.442, 2.443, 2.444, 2.445, 2.446, 2.447, 2.448, 2.449, 2.45, 2.451, 2.452, 2.453, 2.454, 2.455, 2.456, 2.457, 2.458, 2.459, 2.46, 2.461, 2.462, 2.463, 2.464, 2.465, 2.466, 2.467, 2.468, 2.469, 2.47, 2.471, 2.472, 2.473, 2.474, 2.475, 2.476, 2.477, 2.478, 2.479, 2.48, 2.481, 2.482, 2.483, 2.484, 2.485, 2.486, 2.487, 2.488, 2.489, 2.49, 2.491, 2.492, 2.493, 2.494, 2.495, 2.496, 2.497, 2.498, 2.499, 2.5, 2.501, 2.502, 2.503, 2.504, 2.505, 2.506, 2.507, 2.508, 2.509, 2.51, 2.511, 2.512, 2.513, 2.514, 2.515, 2.516, 2.517, 2.518, 2.519, 2.52, 2.521, 2.522, 2.523, 2.524, 2.525, 2.526, 2.527, 2.528, 2.529, 2.53, 2.531, 2.532, 2.533, 2.534, 2.535, 2.536, 2.537, 2.538, 2.539, 2.54, 2.541, 2.542, 2.543, 2.544, 2.545, 2.546, 2.547, 2.548, 2.549, 2.55, 2.551, 2.552, 2.553, 2.554, 2.555, 2.556, 2.557, 2.558, 2.559, 2.56, 2.561, 2.562, 2.563, 2.564, 2.565, 2.566, 2.567, 2.568, 2.569, 2.57, 2.571, 2.572, 2.573, 2.574, 2.575, 2.576, 2.577, 2.578, 2.579, 2.58, 2.581, 2.582, 2.583, 2.584, 2.585, 2.586, 2.587, 2.588, 2.589, 2.59, 2.591, 2.592, 2.593, 2.594, 2.595, 2.596, 2.597, 2.598, 2.599, 2.6, 2.601, 2.602, 2.603, 2.604, 2.605, 2.606, 2.607, 2.608, 2.609, 2.61, 2.611, 2.612, 2.613, 2.614, 2.615, 2.616, 2.617, 2.618, 2.619, 2.62, 2.621, 2.622, 2.623, 2.624, 2.625, 2.626, 2.627, 2.628, 2.629, 2.63, 2.631, 2.632, 2.633, 2.634, 2.635, 2.636, 2.637, 2.638, 2.639, 2.64, 2.641, 2.642, 2.643, 2.644, 2.645, 2.646, 2.647, 2.648, 2.649, 2.65, 2.651, 2.652, 2.653, 2.654, 2.655, 2.656, 2.657, 2.658, 2.659, 2.66, 2.661, 2.662, 2.663, 2.664, 2.665, 2.666, 2.667, 2.668, 2.669, 2.67, 2.671, 2.672, 2.673, 2.674, 2.675, 2.676, 2.677, 2.678, 2.679, 2.68, 2.681, 2.682, 2.683, 2.684, 2.685, 2.686, 2.687, 2.688, 2.689, 2.69, 2.691, 2.692, 2.693, 2.694, 2.695, 2.696, 2.697, 2.698, 2.699, 2.7, 2.701, 2.702, 2.703, 2.704, 2.705, 2.706, 2.707, 2.708, 2.709, 2.71, 2.711, 2.712, 2.713, 2.714, 2.715, 2.716, 2.717, 2.718, 2.719, 2.72, 2.721, 2.722, 2.723, 2.724, 2.725, 2.726, 2.727, 2.728, 2.729, 2.73, 2.731, 2.732, 2.733, 2.734, 2.735, 2.736, 2.737, 2.738, 2.739, 2.74, 2.741, 2.742, 2.743, 2.744, 2.745, 2.746, 2.747, 2.748, 2.749, 2.75, 2.751, 2.752, 2.753, 2.754, 2.755, 2.756, 2.757, 2.758, 2.759, 2.76, 2.761, 2.762, 2.763, 2.764, 2.765, 2.766, 2.767, 2.768, 2.769, 2.77, 2.771, 2.772, 2.773, 2.774, 2.775, 2.776, 2.777, 2.778, 2.779, 2.78, 2.781, 2.782, 2.783, 2.784, 2.785, 2.786, 2.787, 2.788, 2.789, 2.79, 2.791, 2.792, 2.793, 2.794, 2.795, 2.796, 2.797, 2.798, 2.799, 2.8, 2.801, 2.802, 2.803, 2.804, 2.805, 2.806, 2.807, 2.808, 2.809, 2.81, 2.811, 2.812, 2.813, 2.814, 2.815, 2.816, 2.817, 2.818, 2.819, 2.82, 2.821, 2.822, 2.823, 2.824, 2.825, 2.826, 2.827, 2.828, 2.829, 2.83, 2.831, 2.832, 2.833, 2.834, 2.835, 2.836, 2.837, 2.838, 2.839, 2.84, 2.841, 2.842, 2.843, 2.844, 2.845, 2.846, 2.847, 2.848, 2.849, 2.85, 2.851, 2.852, 2.853, 2.854, 2.855, 2.856, 2.857, 2.858, 2.859, 2.86, 2.861, 2.862, 2.863, 2.864, 2.865, 2.866, 2.867, 2.868, 2.869, 2.87, 2.871, 2.872, 2.873, 2.874, 2.875, 2.876, 2.877, 2.878, 2.879, 2.88, 2.881, 2.882, 2.883, 2.884, 2.885, 2.886, 2.887, 2.888, 2.889, 2.89, 2.891, 2.892, 2.893, 2.894, 2.895, 2.896, 2.897, 2.898, 2.899, 2.9, 2.901, 2.902, 2.903, 2.904, 2.905, 2.906, 2.907, 2.908, 2.909, 2.91, 2.911, 2.912, 2.913, 2.914, 2.915, 2.916, 2.917, 2.918, 2.919, 2.92, 2.921, 2.922, 2.923, 2.924, 2.925, 2.926, 2.927, 2.928, 2.929, 2.93, 2.931, 2.932, 2.933, 2.934, 2.935, 2.936, 2.937, 2.938, 2.939, 2.94, 2.941, 2.942, 2.943, 2.944, 2.945, 2.946, 2.947, 2.948, 2.949, 2.95, 2.951, 2.952, 2.953, 2.954, 2.955, 2.956, 2.957, 2.958, 2.959, 2.96, 2.961, 2.962, 2.963, 2.964, 2.965, 2.966, 2.967, 2.968, 2.969, 2.97, 2.971, 2.972, 2.973, 2.974, 2.975, 2.976, 2.977, 2.978, 2.979, 2.98, 2.981, 2.982, 2.983, 2.984, 2.985, 2.986, 2.987, 2.988, 2.989, 2.99, 2.991, 2.992, 2.993, 2.994, 2.995, 2.996, 2.997, 2.998, 2.999, 3.0, 3.001, 3.002, 3.003, 3.004, 3.005, 3.006, 3.007, 3.008, 3.009, 3.01, 3.011, 3.012, 3.013, 3.014, 3.015, 3.016, 3.017, 3.018, 3.019, 3.02, 3.021, 3.022, 3.023, 3.024, 3.025, 3.026, 3.027, 3.028, 3.029, 3.03, 3.031, 3.032, 3.033, 3.034, 3.035, 3.036, 3.037, 3.038, 3.039, 3.04, 3.041, 3.042, 3.043, 3.044, 3.045, 3.046, 3.047, 3.048, 3.049, 3.05, 3.051, 3.052, 3.053, 3.054, 3.055, 3.056, 3.057, 3.058, 3.059, 3.06, 3.061, 3.062, 3.063, 3.064, 3.065, 3.066, 3.067, 3.068, 3.069, 3.07, 3.071, 3.072, 3.073, 3.074, 3.075, 3.076, 3.077, 3.078, 3.079, 3.08, 3.081, 3.082, 3.083, 3.084, 3.085, 3.086, 3.087, 3.088, 3.089, 3.09, 3.091, 3.092, 3.093, 3.094, 3.095, 3.096, 3.097, 3.098, 3.099, 3.1, 3.101, 3.102, 3.103, 3.104, 3.105, 3.106, 3.107, 3.108, 3.109, 3.11, 3.111, 3.112, 3.113, 3.114, 3.115, 3.116, 3.117, 3.118, 3.119, 3.12, 3.121, 3.122, 3.123, 3.124, 3.125, 3.126, 3.127, 3.128, 3.129, 3.13, 3.131, 3.132, 3.133, 3.134, 3.135, 3.136, 3.137, 3.138, 3.139, 3.14, 3.141, 3.142, 3.143, 3.144, 3.145, 3.146, 3.147, 3.148, 3.149, 3.15, 3.151, 3.152, 3.153, 3.154, 3.155, 3.156, 3.157, 3.158, 3.159, 3.16, 3.161, 3.162, 3.163, 3.164, 3.165, 3.166, 3.167, 3.168, 3.169, 3.17, 3.171, 3.172, 3.173, 3.174, 3.175, 3.176, 3.177, 3.178, 3.179, 3.18, 3.181, 3.182, 3.183, 3.184, 3.185, 3.186, 3.187, 3.188, 3.189, 3.19, 3.191, 3.192, 3.193, 3.194, 3.195, 3.196, 3.197, 3.198, 3.199, 3.2, 3.201, 3.202, 3.203, 3.204, 3.205, 3.206, 3.207, 3.208, 3.209, 3.21, 3.211, 3.212, 3.213, 3.214, 3.215, 3.216, 3.217, 3.218, 3.219, 3.22, 3.221, 3.222, 3.223, 3.224, 3.225, 3.226, 3.227, 3.228, 3.229, 3.23, 3.231, 3.232, 3.233, 3.234, 3.235, 3.236, 3.237, 3.238, 3.239, 3.24, 3.241, 3.242, 3.243, 3.244, 3.245, 3.246, 3.247, 3.248, 3.249, 3.25, 3.251, 3.252, 3.253, 3.254, 3.255, 3.256, 3.257, 3.258, 3.259, 3.26, 3.261, 3.262, 3.263, 3.264, 3.265, 3.266, 3.267, 3.268, 3.269, 3.27, 3.271, 3.272, 3.273, 3.274, 3.275, 3.276, 3.277, 3.278, 3.279, 3.28, 3.281, 3.282, 3.283, 3.284, 3.285, 3.286, 3.287, 3.288, 3.289, 3.29, 3.291, 3.292, 3.293, 3.294, 3.295, 3.296, 3.297, 3.298, 3.299, 3.3, 3.301, 3.302, 3.303, 3.304, 3.305, 3.306, 3.307, 3.308, 3.309, 3.31, 3.311, 3.312, 3.313, 3.314, 3.315, 3.316, 3.317, 3.318, 3.319, 3.32, 3.321, 3.322, 3.323, 3.324, 3.325, 3.326, 3.327, 3.328, 3.329, 3.33, 3.331, 3.332, 3.333, 3.334, 3.335, 3.336, 3.337, 3.338, 3.339, 3.34, 3.341, 3.342, 3.343, 3.344, 3.345, 3.346, 3.347, 3.348, 3.349, 3.35, 3.351, 3.352, 3.353, 3.354, 3.355, 3.356, 3.357, 3.358, 3.359, 3.36, 3.361, 3.362, 3.363, 3.364, 3.365, 3.366, 3.367, 3.368, 3.369, 3.37, 3.371, 3.372, 3.373, 3.374, 3.375, 3.376, 3.377, 3.378, 3.379, 3.38, 3.381, 3.382, 3.383, 3.384, 3.385, 3.386, 3.387, 3.388, 3.389, 3.39, 3.391, 3.392, 3.393, 3.394, 3.395, 3.396, 3.397, 3.398, 3.399, 3.4, 3.401, 3.402, 3.403, 3.404, 3.405, 3.406, 3.407, 3.408, 3.409, 3.41, 3.411, 3.412, 3.413, 3.414, 3.415, 3.416, 3.417, 3.418, 3.419, 3.42, 3.421, 3.422, 3.423, 3.424, 3.425, 3.426, 3.427, 3.428, 3.429, 3.43, 3.431, 3.432, 3.433, 3.434, 3.435, 3.436, 3.437, 3.438, 3.439, 3.44, 3.441, 3.442, 3.443, 3.444, 3.445, 3.446, 3.447, 3.448, 3.449, 3.45, 3.451, 3.452, 3.453, 3.454, 3.455, 3.456, 3.457, 3.458, 3.459, 3.46, 3.461, 3.462, 3.463, 3.464, 3.465, 3.466, 3.467, 3.468, 3.469, 3.47, 3.471, 3.472, 3.473, 3.474, 3.475, 3.476, 3.477, 3.478, 3.479, 3.48, 3.481, 3.482, 3.483, 3.484, 3.485, 3.486, 3.487, 3.488, 3.489, 3.49, 3.491, 3.492, 3.493, 3.494, 3.495, 3.496, 3.497, 3.498, 3.499, 3.5, 3.501, 3.502, 3.503, 3.504, 3.505, 3.506, 3.507, 3.508, 3.509, 3.51, 3.511, 3.512, 3.513, 3.514, 3.515, 3.516, 3.517, 3.518, 3.519, 3.52, 3.521, 3.522, 3.523, 3.524, 3.525, 3.526, 3.527, 3.528, 3.529, 3.53, 3.531, 3.532, 3.533, 3.534, 3.535, 3.536, 3.537, 3.538, 3.539, 3.54, 3.541, 3.542, 3.543, 3.544, 3.545, 3.546, 3.547, 3.548, 3.549, 3.55, 3.551, 3.552, 3.553, 3.554, 3.555, 3.556, 3.557, 3.558, 3.559, 3.56, 3.561, 3.562, 3.563, 3.564, 3.565, 3.566, 3.567, 3.568, 3.569, 3.57, 3.571, 3.572, 3.573, 3.574, 3.575, 3.576, 3.577, 3.578, 3.579, 3.58, 3.581, 3.582, 3.583, 3.584, 3.585, 3.586, 3.587, 3.588, 3.589, 3.59, 3.591, 3.592, 3.593, 3.594, 3.595, 3.596, 3.597, 3.598, 3.599, 3.6, 3.601, 3.602, 3.603, 3.604, 3.605, 3.606, 3.607, 3.608, 3.609, 3.61, 3.611, 3.612, 3.613, 3.614, 3.615, 3.616, 3.617, 3.618, 3.619, 3.62, 3.621, 3.622, 3.623, 3.624, 3.625, 3.626, 3.627, 3.628, 3.629, 3.63, 3.631, 3.632, 3.633, 3.634, 3.635, 3.636, 3.637, 3.638, 3.639, 3.64, 3.641, 3.642, 3.643, 3.644, 3.645, 3.646, 3.647, 3.648, 3.649, 3.65, 3.651, 3.652, 3.653, 3.654, 3.655, 3.656, 3.657, 3.658, 3.659, 3.66, 3.661, 3.662, 3.663, 3.664, 3.665, 3.666, 3.667, 3.668, 3.669, 3.67, 3.671, 3.672, 3.673, 3.674, 3.675, 3.676, 3.677, 3.678, 3.679, 3.68, 3.681, 3.682, 3.683, 3.684, 3.685, 3.686, 3.687, 3.688, 3.689, 3.69, 3.691, 3.692, 3.693, 3.694, 3.695, 3.696, 3.697, 3.698, 3.699, 3.7, 3.701, 3.702, 3.703, 3.704, 3.705, 3.706, 3.707, 3.708, 3.709, 3.71, 3.711, 3.712, 3.713, 3.714, 3.715, 3.716, 3.717, 3.718, 3.719, 3.72, 3.721, 3.722, 3.723, 3.724, 3.725, 3.726, 3.727, 3.728, 3.729, 3.73, 3.731, 3.732, 3.733, 3.734, 3.735, 3.736, 3.737, 3.738, 3.739, 3.74, 3.741, 3.742, 3.743, 3.744, 3.745, 3.746, 3.747, 3.748, 3.749, 3.75, 3.751, 3.752, 3.753, 3.754, 3.755, 3.756, 3.757, 3.758, 3.759, 3.76, 3.761, 3.762, 3.763, 3.764, 3.765, 3.766, 3.767, 3.768, 3.769, 3.77, 3.771, 3.772, 3.773, 3.774, 3.775, 3.776, 3.777, 3.778, 3.779, 3.78, 3.781, 3.782, 3.783, 3.784, 3.785, 3.786, 3.787, 3.788, 3.789, 3.79, 3.791, 3.792, 3.793, 3.794, 3.795, 3.796, 3.797, 3.798, 3.799, 3.8, 3.801, 3.802, 3.803, 3.804, 3.805, 3.806, 3.807, 3.808, 3.809, 3.81, 3.811, 3.812, 3.813, 3.814, 3.815, 3.816, 3.817, 3.818, 3.819, 3.82, 3.821, 3.822, 3.823, 3.824, 3.825, 3.826, 3.827, 3.828, 3.829, 3.83, 3.831, 3.832, 3.833, 3.834, 3.835, 3.836, 3.837, 3.838, 3.839, 3.84, 3.841, 3.842, 3.843, 3.844, 3.845, 3.846, 3.847, 3.848, 3.849, 3.85, 3.851, 3.852, 3.853, 3.854, 3.855, 3.856, 3.857, 3.858, 3.859, 3.86, 3.861, 3.862, 3.863, 3.864, 3.865, 3.866, 3.867, 3.868, 3.869, 3.87, 3.871, 3.872, 3.873, 3.874, 3.875, 3.876, 3.877, 3.878, 3.879, 3.88, 3.881, 3.882, 3.883, 3.884, 3.885, 3.886, 3.887, 3.888, 3.889, 3.89, 3.891, 3.892, 3.893, 3.894, 3.895, 3.896, 3.897, 3.898, 3.899, 3.9, 3.901, 3.902, 3.903, 3.904, 3.905, 3.906, 3.907, 3.908, 3.909, 3.91, 3.911, 3.912, 3.913, 3.914, 3.915, 3.916, 3.917, 3.918, 3.919, 3.92, 3.921, 3.922, 3.923, 3.924, 3.925, 3.926, 3.927, 3.928, 3.929, 3.93, 3.931, 3.932, 3.933, 3.934, 3.935, 3.936, 3.937, 3.938, 3.939, 3.94, 3.941, 3.942, 3.943, 3.944, 3.945, 3.946, 3.947, 3.948, 3.949, 3.95, 3.951, 3.952, 3.953, 3.954, 3.955, 3.956, 3.957, 3.958, 3.959, 3.96, 3.961, 3.962, 3.963, 3.964, 3.965, 3.966, 3.967, 3.968, 3.969, 3.97, 3.971, 3.972, 3.973, 3.974, 3.975, 3.976, 3.977, 3.978, 3.979, 3.98, 3.981, 3.982, 3.983, 3.984, 3.985, 3.986, 3.987, 3.988, 3.989, 3.99, 3.991, 3.992, 3.993, 3.994, 3.995, 3.996, 3.997, 3.998, 3.999, 4.0, 4.001, 4.002, 4.003, 4.004, 4.005, 4.006, 4.007, 4.008, 4.009, 4.01, 4.011, 4.012, 4.013, 4.014, 4.015, 4.016, 4.017, 4.018, 4.019, 4.02, 4.021, 4.022, 4.023, 4.024, 4.025, 4.026, 4.027, 4.028, 4.029, 4.03, 4.031, 4.032, 4.033, 4.034, 4.035, 4.036, 4.037, 4.038, 4.039, 4.04, 4.041, 4.042, 4.043, 4.044, 4.045, 4.046, 4.047, 4.048, 4.049, 4.05, 4.051, 4.052, 4.053, 4.054, 4.055, 4.056, 4.057, 4.058, 4.059, 4.06, 4.061, 4.062, 4.063, 4.064, 4.065, 4.066, 4.067, 4.068, 4.069, 4.07, 4.071, 4.072, 4.073, 4.074, 4.075, 4.076, 4.077, 4.078, 4.079, 4.08, 4.081, 4.082, 4.083, 4.084, 4.085, 4.086, 4.087, 4.088, 4.089, 4.09, 4.091, 4.092, 4.093, 4.094, 4.095, 4.096, 4.097, 4.098, 4.099, 4.1, 4.101, 4.102, 4.103, 4.104, 4.105, 4.106, 4.107, 4.108, 4.109, 4.11, 4.111, 4.112, 4.113, 4.114, 4.115, 4.116, 4.117, 4.118, 4.119, 4.12, 4.121, 4.122, 4.123, 4.124, 4.125, 4.126, 4.127, 4.128, 4.129, 4.13, 4.131, 4.132, 4.133, 4.134, 4.135, 4.136, 4.137, 4.138, 4.139, 4.14, 4.141, 4.142, 4.143, 4.144, 4.145, 4.146, 4.147, 4.148, 4.149, 4.15, 4.151, 4.152, 4.153, 4.154, 4.155, 4.156, 4.157, 4.158, 4.159, 4.16, 4.161, 4.162, 4.163, 4.164, 4.165, 4.166, 4.167, 4.168, 4.169, 4.17, 4.171, 4.172, 4.173, 4.174, 4.175, 4.176, 4.177, 4.178, 4.179, 4.18, 4.181, 4.182, 4.183, 4.184, 4.185, 4.186, 4.187, 4.188, 4.189, 4.19, 4.191, 4.192, 4.193, 4.194, 4.195, 4.196, 4.197, 4.198, 4.199, 4.2, 4.201, 4.202, 4.203, 4.204, 4.205, 4.206, 4.207, 4.208, 4.209, 4.21, 4.211, 4.212, 4.213, 4.214, 4.215, 4.216, 4.217, 4.218, 4.219, 4.22, 4.221, 4.222, 4.223, 4.224, 4.225, 4.226, 4.227, 4.228, 4.229, 4.23, 4.231, 4.232, 4.233, 4.234, 4.235, 4.236, 4.237, 4.238, 4.239, 4.24, 4.241, 4.242, 4.243, 4.244, 4.245, 4.246, 4.247, 4.248, 4.249, 4.25, 4.251, 4.252, 4.253, 4.254, 4.255, 4.256, 4.257, 4.258, 4.259, 4.26, 4.261, 4.262, 4.263, 4.264, 4.265, 4.266, 4.267, 4.268, 4.269, 4.27, 4.271, 4.272, 4.273, 4.274, 4.275, 4.276, 4.277, 4.278, 4.279, 4.28, 4.281, 4.282, 4.283, 4.284, 4.285, 4.286, 4.287, 4.288, 4.289, 4.29, 4.291, 4.292, 4.293, 4.294, 4.295, 4.296, 4.297, 4.298, 4.299, 4.3, 4.301, 4.302, 4.303, 4.304, 4.305, 4.306, 4.307, 4.308, 4.309, 4.31, 4.311, 4.312, 4.313, 4.314, 4.315, 4.316, 4.317, 4.318, 4.319, 4.32, 4.321, 4.322, 4.323, 4.324, 4.325, 4.326, 4.327, 4.328, 4.329, 4.33, 4.331, 4.332, 4.333, 4.334, 4.335, 4.336, 4.337, 4.338, 4.339, 4.34, 4.341, 4.342, 4.343, 4.344, 4.345, 4.346, 4.347, 4.348, 4.349, 4.35, 4.351, 4.352, 4.353, 4.354, 4.355, 4.356, 4.357, 4.358, 4.359, 4.36, 4.361, 4.362, 4.363, 4.364, 4.365, 4.366, 4.367, 4.368, 4.369, 4.37, 4.371, 4.372, 4.373, 4.374, 4.375, 4.376, 4.377, 4.378, 4.379, 4.38, 4.381, 4.382, 4.383, 4.384, 4.385, 4.386, 4.387, 4.388, 4.389, 4.39, 4.391, 4.392, 4.393, 4.394, 4.395, 4.396, 4.397, 4.398, 4.399, 4.4, 4.401, 4.402, 4.403, 4.404, 4.405, 4.406, 4.407, 4.408, 4.409, 4.41, 4.411, 4.412, 4.413, 4.414, 4.415, 4.416, 4.417, 4.418, 4.419, 4.42, 4.421, 4.422, 4.423, 4.424, 4.425, 4.426, 4.427, 4.428, 4.429, 4.43, 4.431, 4.432, 4.433, 4.434, 4.435, 4.436, 4.437, 4.438, 4.439, 4.44, 4.441, 4.442, 4.443, 4.444, 4.445, 4.446, 4.447, 4.448, 4.449, 4.45, 4.451, 4.452, 4.453, 4.454, 4.455, 4.456, 4.457, 4.458, 4.459, 4.46, 4.461, 4.462, 4.463, 4.464, 4.465, 4.466, 4.467, 4.468, 4.469, 4.47, 4.471, 4.472, 4.473, 4.474, 4.475, 4.476, 4.477, 4.478, 4.479, 4.48, 4.481, 4.482, 4.483, 4.484, 4.485, 4.486, 4.487, 4.488, 4.489, 4.49, 4.491, 4.492, 4.493, 4.494, 4.495, 4.496, 4.497, 4.498, 4.499, 4.5, 4.501, 4.502, 4.503, 4.504, 4.505, 4.506, 4.507, 4.508, 4.509, 4.51, 4.511, 4.512, 4.513, 4.514, 4.515, 4.516, 4.517, 4.518, 4.519, 4.52, 4.521, 4.522, 4.523, 4.524, 4.525, 4.526, 4.527, 4.528, 4.529, 4.53, 4.531, 4.532, 4.533, 4.534, 4.535, 4.536, 4.537, 4.538, 4.539, 4.54, 4.541, 4.542, 4.543, 4.544, 4.545, 4.546, 4.547, 4.548, 4.549, 4.55, 4.551, 4.552, 4.553, 4.554, 4.555, 4.556, 4.557, 4.558, 4.559, 4.56, 4.561, 4.562, 4.563, 4.564, 4.565, 4.566, 4.567, 4.568, 4.569, 4.57, 4.571, 4.572, 4.573, 4.574, 4.575, 4.576, 4.577, 4.578, 4.579, 4.58, 4.581, 4.582, 4.583, 4.584, 4.585, 4.586, 4.587, 4.588, 4.589, 4.59, 4.591, 4.592, 4.593, 4.594, 4.595, 4.596, 4.597, 4.598, 4.599, 4.6, 4.601, 4.602, 4.603, 4.604, 4.605, 4.606, 4.607, 4.608, 4.609, 4.61, 4.611, 4.612, 4.613, 4.614, 4.615, 4.616, 4.617, 4.618, 4.619, 4.62, 4.621, 4.622, 4.623, 4.624, 4.625, 4.626, 4.627, 4.628, 4.629, 4.63, 4.631, 4.632, 4.633, 4.634, 4.635, 4.636, 4.637, 4.638, 4.639, 4.64, 4.641, 4.642, 4.643, 4.644, 4.645, 4.646, 4.647, 4.648, 4.649, 4.65, 4.651, 4.652, 4.653, 4.654, 4.655, 4.656, 4.657, 4.658, 4.659, 4.66, 4.661, 4.662, 4.663, 4.664, 4.665, 4.666, 4.667, 4.668, 4.669, 4.67, 4.671, 4.672, 4.673, 4.674, 4.675, 4.676, 4.677, 4.678, 4.679, 4.68, 4.681, 4.682, 4.683, 4.684, 4.685, 4.686, 4.687, 4.688, 4.689, 4.69, 4.691, 4.692, 4.693, 4.694, 4.695, 4.696, 4.697, 4.698, 4.699, 4.7, 4.701, 4.702, 4.703, 4.704, 4.705, 4.706, 4.707, 4.708, 4.709, 4.71, 4.711, 4.712, 4.713, 4.714, 4.715, 4.716, 4.717, 4.718, 4.719, 4.72, 4.721, 4.722, 4.723, 4.724, 4.725, 4.726, 4.727, 4.728, 4.729, 4.73, 4.731, 4.732, 4.733, 4.734, 4.735, 4.736, 4.737, 4.738, 4.739, 4.74, 4.741, 4.742, 4.743, 4.744, 4.745, 4.746, 4.747, 4.748, 4.749, 4.75, 4.751, 4.752, 4.753, 4.754, 4.755, 4.756, 4.757, 4.758, 4.759, 4.76, 4.761, 4.762, 4.763, 4.764, 4.765, 4.766, 4.767, 4.768, 4.769, 4.77, 4.771, 4.772, 4.773, 4.774, 4.775, 4.776, 4.777, 4.778, 4.779, 4.78, 4.781, 4.782, 4.783, 4.784, 4.785, 4.786, 4.787, 4.788, 4.789, 4.79, 4.791, 4.792, 4.793, 4.794, 4.795, 4.796, 4.797, 4.798, 4.799, 4.8, 4.801, 4.802, 4.803, 4.804, 4.805, 4.806, 4.807, 4.808, 4.809, 4.81, 4.811, 4.812, 4.813, 4.814, 4.815, 4.816, 4.817, 4.818, 4.819, 4.82, 4.821, 4.822, 4.823, 4.824, 4.825, 4.826, 4.827, 4.828, 4.829, 4.83, 4.831, 4.832, 4.833, 4.834, 4.835, 4.836, 4.837, 4.838, 4.839, 4.84, 4.841, 4.842, 4.843, 4.844, 4.845, 4.846, 4.847, 4.848, 4.849, 4.85, 4.851, 4.852, 4.853, 4.854, 4.855, 4.856, 4.857, 4.858, 4.859, 4.86, 4.861, 4.862, 4.863, 4.864, 4.865, 4.866, 4.867, 4.868, 4.869, 4.87, 4.871, 4.872, 4.873, 4.874, 4.875, 4.876, 4.877, 4.878, 4.879, 4.88, 4.881, 4.882, 4.883, 4.884, 4.885, 4.886, 4.887, 4.888, 4.889, 4.89, 4.891, 4.892, 4.893, 4.894, 4.895, 4.896, 4.897, 4.898, 4.899, 4.9, 4.901, 4.902, 4.903, 4.904, 4.905, 4.906, 4.907, 4.908, 4.909, 4.91, 4.911, 4.912, 4.913, 4.914, 4.915, 4.916, 4.917, 4.918, 4.919, 4.92, 4.921, 4.922, 4.923, 4.924, 4.925, 4.926, 4.927, 4.928, 4.929, 4.93, 4.931, 4.932, 4.933, 4.934, 4.935, 4.936, 4.937, 4.938, 4.939, 4.94, 4.941, 4.942, 4.943, 4.944, 4.945, 4.946, 4.947, 4.948, 4.949, 4.95, 4.951, 4.952, 4.953, 4.954, 4.955, 4.956, 4.957, 4.958, 4.959, 4.96, 4.961, 4.962, 4.963, 4.964, 4.965, 4.966, 4.967, 4.968, 4.969, 4.97, 4.971, 4.972, 4.973, 4.974, 4.975, 4.976, 4.977, 4.978, 4.979, 4.98, 4.981, 4.982, 4.983, 4.984, 4.985, 4.986, 4.987, 4.988, 4.989, 4.99, 4.991, 4.992, 4.993, 4.994, 4.995, 4.996, 4.997, 4.998, 4.999, 5.0, 5.001, 5.002, 5.003, 5.004, 5.005, 5.006, 5.007, 5.008, 5.009, 5.01, 5.011, 5.012, 5.013, 5.014, 5.015, 5.016, 5.017, 5.018, 5.019, 5.02, 5.021, 5.022, 5.023, 5.024, 5.025, 5.026, 5.027, 5.028, 5.029, 5.03, 5.031, 5.032, 5.033, 5.034, 5.035, 5.036, 5.037, 5.038, 5.039, 5.04, 5.041, 5.042, 5.043, 5.044, 5.045, 5.046, 5.047, 5.048, 5.049, 5.05, 5.051, 5.052, 5.053, 5.054, 5.055, 5.056, 5.057, 5.058, 5.059, 5.06, 5.061, 5.062, 5.063, 5.064, 5.065, 5.066, 5.067, 5.068, 5.069, 5.07, 5.071, 5.072, 5.073, 5.074, 5.075, 5.076, 5.077, 5.078, 5.079, 5.08, 5.081, 5.082, 5.083, 5.084, 5.085, 5.086, 5.087, 5.088, 5.089, 5.09, 5.091, 5.092, 5.093, 5.094, 5.095, 5.096, 5.097, 5.098, 5.099, 5.1, 5.101, 5.102, 5.103, 5.104, 5.105, 5.106, 5.107, 5.108, 5.109, 5.11, 5.111, 5.112, 5.113, 5.114, 5.115, 5.116, 5.117, 5.118, 5.119, 5.12, 5.121, 5.122, 5.123, 5.124, 5.125, 5.126, 5.127, 5.128, 5.129, 5.13, 5.131, 5.132, 5.133, 5.134, 5.135, 5.136, 5.137, 5.138, 5.139, 5.14, 5.141, 5.142, 5.143, 5.144, 5.145, 5.146, 5.147, 5.148, 5.149, 5.15, 5.151, 5.152, 5.153, 5.154, 5.155, 5.156, 5.157, 5.158, 5.159, 5.16, 5.161, 5.162, 5.163, 5.164, 5.165, 5.166, 5.167, 5.168, 5.169, 5.17, 5.171, 5.172, 5.173, 5.174, 5.175, 5.176, 5.177, 5.178, 5.179, 5.18, 5.181, 5.182, 5.183, 5.184, 5.185, 5.186, 5.187, 5.188, 5.189, 5.19, 5.191, 5.192, 5.193, 5.194, 5.195, 5.196, 5.197, 5.198, 5.199, 5.2, 5.201, 5.202, 5.203, 5.204, 5.205, 5.206, 5.207, 5.208, 5.209, 5.21, 5.211, 5.212, 5.213, 5.214, 5.215, 5.216, 5.217, 5.218, 5.219, 5.22, 5.221, 5.222, 5.223, 5.224, 5.225, 5.226, 5.227, 5.228, 5.229, 5.23, 5.231, 5.232, 5.233, 5.234, 5.235, 5.236, 5.237, 5.238, 5.239, 5.24, 5.241, 5.242, 5.243, 5.244, 5.245, 5.246, 5.247, 5.248, 5.249, 5.25, 5.251, 5.252, 5.253, 5.254, 5.255, 5.256, 5.257, 5.258, 5.259, 5.26, 5.261, 5.262, 5.263, 5.264, 5.265, 5.266, 5.267, 5.268, 5.269, 5.27, 5.271, 5.272, 5.273, 5.274, 5.275, 5.276, 5.277, 5.278, 5.279, 5.28, 5.281, 5.282, 5.283, 5.284, 5.285, 5.286, 5.287, 5.288, 5.289, 5.29, 5.291, 5.292, 5.293, 5.294, 5.295, 5.296, 5.297, 5.298, 5.299, 5.3, 5.301, 5.302, 5.303, 5.304, 5.305, 5.306, 5.307, 5.308, 5.309, 5.31, 5.311, 5.312, 5.313, 5.314, 5.315, 5.316, 5.317, 5.318, 5.319, 5.32, 5.321, 5.322, 5.323, 5.324, 5.325, 5.326, 5.327, 5.328, 5.329, 5.33, 5.331, 5.332, 5.333, 5.334, 5.335, 5.336, 5.337, 5.338, 5.339, 133.0, 136.0]],
        [[50.0, 49.99999988, 49.9999995, 49.99999888, 49.999998, 49.99999688, 49.9999955, 49.99999388, 49.999992, 49.99998988, 49.9999875, 49.99998488, 49.999982, 49.99997888, 49.9999755, 49.99997188, 49.999968, 49.99996388, 49.9999595, 49.99995488, 49.99995, 49.99994488, 49.9999395, 49.99993388, 49.999928, 49.99992188, 49.9999155, 49.99990888, 49.999902, 49.99989488, 49.9998875, 49.99987988, 49.999872, 49.99986388, 49.9998555, 49.99984688, 49.999838, 49.99982888, 49.9998195, 49.99980988, 49.9998, 49.99978988, 49.9997795, 49.99976888, 49.999758, 49.99974688, 49.9997355, 49.99972388, 49.999712, 49.99969988, 49.9996875, 49.99967488, 49.999662, 49.99964888, 49.9996355, 49.99962188, 49.999608, 49.99959388, 49.9995795, 49.99956488, 49.99955, 49.99953488, 49.9995195, 49.99950388, 49.999488, 49.99947188, 49.9994555, 49.99943888, 49.999422, 49.99940488, 49.9993875, 49.99936988, 49.999352, 49.99933388, 49.9993155, 49.99929688, 49.999278, 49.99925888, 49.9992395, 49.99921988, 49.9992, 49.99917988, 49.9991595, 49.99913888, 49.999118, 49.99909688, 49.9990755, 49.99905388, 49.999032, 49.99900988, 49.9989875, 49.99896488, 49.998942, 49.99891888, 49.9988955, 49.99887188, 49.998848, 49.99882388, 49.9987995, 49.99877488, 49.99875, 49.99872488, 49.9986995, 49.99867388, 49.998648, 49.99862188, 49.9985955, 49.99856888, 49.998542, 49.99851488, 49.9984875, 49.99845988, 49.998432, 49.99840388, 49.9983755, 49.99834688, 49.998318, 49.99828888, 49.9982595, 49.99822988, 49.9982, 49.99816988, 49.9981395, 49.99810888, 49.998078, 49.99804688, 49.9980155, 49.99798388, 49.997952, 49.99791988, 49.9978875, 49.99785488, 49.997822, 49.99778888, 49.9977555, 49.99772188, 49.997688, 49.99765388, 49.9976195, 49.99758488, 49.99755, 49.99751488, 49.9974795, 49.99744388, 49.997408, 49.99737188, 49.9973355, 49.99729888, 49.997262, 49.99722488, 49.9971875, 49.99714988, 49.997112, 49.99707388, 49.9970355, 49.99699688, 49.996958, 49.99691888, 49.9968795, 49.99683988, 49.9968, 49.99675988, 49.9967195, 49.99667888, 49.996638, 49.99659688, 49.9965555, 49.99651388, 49.996472, 49.99642988, 49.9963875, 49.99634488, 49.996302, 49.99625888, 49.9962155, 49.99617188, 49.996128, 49.99608388, 49.9960395, 49.99599488, 49.99595, 49.99590488, 49.9958595, 49.99581388, 49.995768, 49.99572188, 49.9956755, 49.99562888, 49.995582, 49.99553488, 49.9954875, 49.99543988, 49.995392, 49.99534388, 49.9952955, 49.99524688, 49.995198, 49.99514888, 49.9950995, 49.99504988, 49.995, 49.99494988, 49.9948995, 49.99484888, 49.994798, 49.99474688, 49.9946955, 49.99464388, 49.994592, 49.99453988, 49.9944875, 49.99443488, 49.994382, 49.99432888, 49.9942755, 49.99422188, 49.994168, 49.99411388, 49.9940595, 49.99400488, 49.99395, 49.99389488, 49.9938395, 49.99378388, 49.993728, 49.99367188, 49.9936155, 49.99355888, 49.993502, 49.99344488, 49.9933875, 49.99332988, 49.993272, 49.99321388, 49.9931555, 49.99309688, 49.993038, 49.99297888, 49.9929195, 49.99285988, 49.9928, 49.99273988, 49.9926795, 49.99261888, 49.992558, 49.99249688, 49.9924355, 49.99237388, 49.992312, 49.99224988, 49.9921875, 49.99212488, 49.992062, 49.99199888, 49.9919355, 49.99187188, 49.991808, 49.99174388, 49.9916795, 49.99161488, 49.99155, 49.99148488, 49.9914195, 49.99135388, 49.991288, 49.99122188, 49.9911555, 49.99108888, 49.991022, 49.99095488, 49.9908875, 49.99081988, 49.990752, 49.99068388, 49.9906155, 49.99054688, 49.990478, 49.99040888, 49.9903395, 49.99026988, 49.9902, 49.99012988, 49.9900595, 49.98998888, 49.989918, 49.98984688, 49.9897755, 49.98970388, 49.989632, 49.98955988, 49.9894875, 49.98941488, 49.989342, 49.98926888, 49.9891955, 49.98912188, 49.989048, 49.98897388, 49.9888995, 49.98882488, 49.98875, 49.98867488, 49.9885995, 49.98852388, 49.988448, 49.98837188, 49.9882955, 49.98821888, 49.988142, 49.98806488, 49.9879875, 49.98790988, 49.987832, 49.98775388, 49.9876755, 49.98759688, 49.987518, 49.98743888, 49.9873595, 49.98727988, 49.9872, 49.98711988, 49.9870395, 49.98695888, 49.986878, 49.98679688, 49.9867155, 49.98663388, 49.986552, 49.98646988, 49.9863875, 49.98630488, 49.986222, 49.98613888, 49.9860555, 49.98597188, 49.985888, 49.98580388, 49.9857195, 49.98563488, 49.98555, 49.98546488, 49.9853795, 49.98529388, 49.985208, 49.98512188, 49.9850355, 49.98494888, 49.984862, 49.98477488, 49.9846875, 49.98459988, 49.984512, 49.98442388, 49.9843355, 49.98424688, 49.984158, 49.98406888, 49.9839795, 49.98388988, 49.9838, 49.98370988, 49.9836195, 49.98352888, 49.983438, 49.98334688, 49.9832555, 49.98316388, 49.983072, 49.98297988, 49.9828875, 49.98279488, 49.982702, 49.98260888, 49.9825155, 49.98242188, 49.982328, 49.98223388, 49.9821395, 49.98204488, 49.98195, 49.98185488, 49.9817595, 49.98166388, 49.981568, 49.98147188, 49.9813755, 49.98127888, 49.981182, 49.98108488, 49.9809875, 49.98088988, 49.980792, 49.98069388, 49.9805955, 49.98049688, 49.980398, 49.98029888, 49.9801995, 49.98009988, 49.98, 49.97989988, 49.9797995, 49.97969888, 49.979598, 49.97949688, 49.9793955, 49.97929388, 49.979192, 49.97908988, 49.9789875, 49.97888488, 49.978782, 49.97867888, 49.9785755, 49.97847188, 49.978368, 49.97826388, 49.9781595, 49.97805488, 49.97795, 49.97784488, 49.9777395, 49.97763388, 49.977528, 49.97742188, 49.9773155, 49.97720888, 49.977102, 49.97699488, 49.9768875, 49.97677988, 49.976672, 49.97656388, 49.9764555, 49.97634688, 49.976238, 49.97612888, 49.9760195, 49.97590988, 49.9758, 49.97568988, 49.9755795, 49.97546888, 49.975358, 49.97524688, 49.9751355, 49.97502388, 49.974912, 49.97479988, 49.9746875, 49.97457488, 49.974462, 49.97434888, 49.9742355, 49.97412188, 49.974008, 49.97389388, 49.9737795, 49.97366488, 49.97355, 49.97343488, 49.9733195, 49.97320388, 49.973088, 49.97297188, 49.9728555, 49.97273888, 49.972622, 49.97250488, 49.9723875, 49.97226988, 49.972152, 49.97203388, 49.9719155, 49.97179688, 49.971678, 49.97155888, 49.9714395, 49.97131988, 49.9712, 49.97107988, 49.9709595, 49.97083888, 49.970718, 49.97059688, 49.9704755, 49.97035388, 49.970232, 49.97010988, 49.9699875, 49.96986488, 49.969742, 49.96961888, 49.9694955, 49.96937188, 49.969248, 49.96912388, 49.9689995, 49.96887488, 49.96875, 49.96862488, 49.9684995, 49.96837388, 49.968248, 49.96812188, 49.9679955, 49.96786888, 49.967742, 49.96761488, 49.9674875, 49.96735988, 49.967232, 49.96710388, 49.9669755, 49.96684688, 49.966718, 49.96658888, 49.9664595, 49.96632988, 49.9662, 49.96606988, 49.9659395, 49.96580888, 49.965678, 49.96554688, 49.9654155, 49.96528388, 49.965152, 49.96501988, 49.9648875, 49.96475488, 49.964622, 49.96448888, 49.9643555, 49.96422188, 49.964088, 49.96395388, 49.9638195, 49.96368488, 49.96355, 49.96341488, 49.9632795, 49.96314388, 49.963008, 49.96287188, 49.9627355, 49.96259888, 49.962462, 49.96232488, 49.9621875, 49.96204988, 49.961912, 49.96177388, 49.9616355, 49.96149688, 49.961358, 49.96121888, 49.9610795, 49.96093988, 49.9608, 49.96065988, 49.9605195, 49.96037888, 49.960238, 49.96009688, 49.9599555, 49.95981388, 49.959672, 49.95952988, 49.9593875, 49.95924488, 49.959102, 49.95895888, 49.9588155, 49.95867188, 49.958528, 49.95838388, 49.9582395, 49.95809488, 49.95795, 49.95780488, 49.9576595, 49.95751388, 49.957368, 49.95722188, 49.9570755, 49.95692888, 49.956782, 49.95663488, 49.9564875, 49.95633988, 49.956192, 49.95604388, 49.9558955, 49.95574688, 49.955598, 49.95544888, 49.9552995, 49.95514988, 49.955, 49.95484988, 49.9546995, 49.95454888, 49.954398, 49.95424688, 49.9540955, 49.95394388, 49.953792, 49.95363988, 49.9534875, 49.95333488, 49.953182, 49.95302888, 49.9528755, 49.95272188, 49.952568, 49.95241388, 49.9522595, 49.95210488, 49.95195, 49.95179488, 49.9516395, 49.95148388, 49.951328, 49.95117188, 49.9510155, 49.95085888, 49.950702, 49.95054488, 49.9503875, 49.95022988, 49.950072, 49.94991388, 49.9497555, 49.94959688, 49.949438, 49.94927888, 49.9491195, 49.94895988, 49.9488, 49.94863988, 49.9484795, 49.94831888, 49.948158, 49.94799688, 49.9478355, 49.94767388, 49.947512, 49.94734988, 49.9471875, 49.94702488, 49.946862, 49.94669888, 49.9465355, 49.94637188, 49.946208, 49.94604388, 49.9458795, 49.94571488, 49.94555, 49.94538488, 49.9452195, 49.94505388, 49.944888, 49.94472188, 49.9445555, 49.94438888, 49.944222, 49.94405488, 49.9438875, 49.94371988, 49.943552, 49.94338388, 49.9432155, 49.94304688, 49.942878, 49.94270888, 49.9425395, 49.94236988, 49.9422, 49.94202988, 49.9418595, 49.94168888, 49.941518, 49.94134688, 49.9411755, 49.94100388, 49.940832, 49.94065988, 49.9404875, 49.94031488, 49.940142, 49.93996888, 49.9397955, 49.93962188, 49.939448, 49.93927388, 49.9390995, 49.93892488, 49.93875, 49.93857488, 49.9383995, 49.93822388, 49.938048, 49.93787188, 49.9376955, 49.93751888, 49.937342, 49.93716488, 49.9369875, 49.93680988, 49.936632, 49.93645388, 49.9362755, 49.93609688, 49.935918, 49.93573888, 49.9355595, 49.93537988, 49.9352, 49.93501988, 49.9348395, 49.93465888, 49.934478, 49.93429688, 49.9341155, 49.93393388, 49.933752, 49.93356988, 49.9333875, 49.93320488, 49.933022, 49.93283888, 49.9326555, 49.93247188, 49.932288, 49.93210388, 49.9319195, 49.93173488, 49.93155, 49.93136488, 49.9311795, 49.93099388, 49.930808, 49.93062188, 49.9304355, 49.93024888, 49.930062, 49.92987488, 49.9296875, 49.92949988, 49.929312, 49.92912388, 49.9289355, 49.92874688, 49.928558, 49.92836888, 49.9281795, 49.92798988, 49.9278, 49.92760988, 49.9274195, 49.92722888, 49.927038, 49.92684688, 49.9266555, 49.92646388, 49.926272, 49.92607988, 49.9258875, 49.92569488, 49.925502, 49.92530888, 49.9251155, 49.92492188, 49.924728, 49.92453388, 49.9243395, 49.92414488, 49.92395, 49.92375488, 49.9235595, 49.92336388, 49.923168, 49.92297188, 49.9227755, 49.92257888, 49.922382, 49.92218488, 49.9219875, 49.92178988, 49.921592, 49.92139388, 49.9211955, 49.92099688, 49.920798, 49.92059888, 49.9203995, 49.92019988, 49.92, 49.91979988, 49.9195995, 49.91939888, 49.919198, 49.91899688, 49.9187955, 49.91859388, 49.918392, 49.91818988, 49.9179875, 49.91778488, 49.917582, 49.91737888, 49.9171755, 49.91697188, 49.916768, 49.91656388, 49.9163595, 49.91615488, 49.91595, 49.91574488, 49.9155395, 49.91533388, 49.915128, 49.91492188, 49.9147155, 49.91450888, 49.914302, 49.91409488, 49.9138875, 49.91367988, 49.913472, 49.91326388, 49.9130555, 49.91284688, 49.912638, 49.91242888, 49.9122195, 49.91200988, 49.9118, 49.91158988, 49.9113795, 49.91116888, 49.910958, 49.91074688, 49.9105355, 49.91032388, 49.910112, 49.90989988, 49.9096875, 49.90947488, 49.909262, 49.90904888, 49.9088355, 49.90862188, 49.908408, 49.90819388, 49.9079795, 49.90776488, 49.90755, 49.90733488, 49.9071195, 49.90690388, 49.906688, 49.90647188, 49.9062555, 49.90603888, 49.905822, 49.90560488, 49.9053875, 49.90516988, 49.904952, 49.90473388, 49.9045155, 49.90429688, 49.904078, 49.90385888, 49.9036395, 49.90341988, 49.9032, 49.90297988, 49.9027595, 49.90253888, 49.902318, 49.90209688, 49.9018755, 49.90165388, 49.901432, 49.90120988, 49.9009875, 49.90076488, 49.900542, 49.90031888, 49.9000955, 49.89987188, 49.899648, 49.89942388, 49.8991995, 49.89897488, 49.89875, 49.89852488, 49.8982995, 49.89807388, 49.897848, 49.89762188, 49.8973955, 49.89716888, 49.896942, 49.89671488, 49.8964875, 49.89625988, 49.896032, 49.89580388, 49.8955755, 49.89534688, 49.895118, 49.89488888, 49.8946595, 49.89442988, 49.8942, 49.89396988, 49.8937395, 49.89350888, 49.893278, 49.89304688, 49.8928155, 49.89258388, 49.892352, 49.89211988, 49.8918875, 49.89165488, 49.891422, 49.89118888, 49.8909555, 49.89072188, 49.890488, 49.89025388, 49.8900195, 49.88978488, 49.88955, 49.88931488, 49.8890795, 49.88884388, 49.888608, 49.88837188, 49.8881355, 49.88789888, 49.887662, 49.88742488, 49.8871875, 49.88694988, 49.886712, 49.88647388, 49.8862355, 49.88599688, 49.885758, 49.88551888, 49.8852795, 49.88503988, 49.8848, 49.88455988, 49.8843195, 49.88407888, 49.883838, 49.88359688, 49.8833555, 49.88311388, 49.882872, 49.88262988, 49.8823875, 49.88214488, 49.881902, 49.88165888, 49.8814155, 49.88117188, 49.880928, 49.88068388, 49.8804395, 49.88019488, 49.87995, 49.87970488, 49.8794595, 49.87921388, 49.878968, 49.87872188, 49.8784755, 49.87822888, 49.877982, 49.87773488, 49.8774875, 49.87723988, 49.876992, 49.87674388, 49.8764955, 49.87624688, 49.875998, 49.87574888, 49.8754995, 49.87524988, 49.875, 49.87474988, 49.8744995, 49.87424888, 49.873998, 49.87374688, 49.8734955, 49.87324388, 49.872992, 49.87273988, 49.8724875, 49.87223488, 49.871982, 49.87172888, 49.8714755, 49.87122188, 49.870968, 49.87071388, 49.8704595, 49.87020488, 49.86995, 49.86969488, 49.8694395, 49.86918388, 49.868928, 49.86867188, 49.8684155, 49.86815888, 49.867902, 49.86764488, 49.8673875, 49.86712988, 49.866872, 49.86661388, 49.8663555, 49.86609688, 49.865838, 49.86557888, 49.8653195, 49.86505988, 49.8648, 49.86453988, 49.8642795, 49.86401888, 49.863758, 49.86349688, 49.8632355, 49.86297388, 49.862712, 49.86244988, 49.8621875, 49.86192488, 49.861662, 49.86139888, 49.8611355, 49.86087188, 49.860608, 49.86034388, 49.8600795, 49.85981488, 49.85955, 49.85928488, 49.8590195, 49.85875388, 49.858488, 49.85822188, 49.8579555, 49.85768888, 49.857422, 49.85715488, 49.8568875, 49.85661988, 49.856352, 49.85608388, 49.8558155, 49.85554688, 49.855278, 49.85500888, 49.8547395, 49.85446988, 49.8542, 49.85392988, 49.8536595, 49.85338888, 49.853118, 49.85284688, 49.8525755, 49.85230388, 49.852032, 49.85175988, 49.8514875, 49.85121488, 49.850942, 49.85066888, 49.8503955, 49.85012188, 49.849848, 49.84957388, 49.8492995, 49.84902488, 49.84875, 49.84847488, 49.8481995, 49.84792388, 49.847648, 49.84737188, 49.8470955, 49.84681888, 49.846542, 49.84626488, 49.8459875, 49.84570988, 49.845432, 49.84515388, 49.8448755, 49.84459688, 49.844318, 49.84403888, 49.8437595, 49.84347988, 49.8432, 49.84291988, 49.8426395, 49.84235888, 49.842078, 49.84179688, 49.8415155, 49.84123388, 49.840952, 49.84066988, 49.8403875, 49.84010488, 49.839822, 49.83953888, 49.8392555, 49.83897188, 49.838688, 49.83840388, 49.8381195, 49.83783488, 49.83755, 49.83726488, 49.8369795, 49.83669388, 49.836408, 49.83612188, 49.8358355, 49.83554888, 49.835262, 49.83497488, 49.8346875, 49.83439988, 49.834112, 49.83382388, 49.8335355, 49.83324688, 49.832958, 49.83266888, 49.8323795, 49.83208988, 49.8318, 49.83150988, 49.8312195, 49.83092888, 49.830638, 49.83034688, 49.8300555, 49.82976388, 49.829472, 49.82917988, 49.8288875, 49.82859488, 49.828302, 49.82800888, 49.8277155, 49.82742188, 49.827128, 49.82683388, 49.8265395, 49.82624488, 49.82595, 49.82565488, 49.8253595, 49.82506388, 49.824768, 49.82447188, 49.8241755, 49.82387888, 49.823582, 49.82328488, 49.8229875, 49.82268988, 49.822392, 49.82209388, 49.8217955, 49.82149688, 49.821198, 49.82089888, 49.8205995, 49.82029988, 49.82, 49.81969988, 49.8193995, 49.81909888, 49.818798, 49.81849688, 49.8181955, 49.81789388, 49.817592, 49.81728988, 49.8169875, 49.81668488, 49.816382, 49.81607888, 49.8157755, 49.81547188, 49.815168, 49.81486388, 49.8145595, 49.81425488, 49.81395, 49.81364488, 49.8133395, 49.81303388, 49.812728, 49.81242188, 49.8121155, 49.81180888, 49.811502, 49.81119488, 49.8108875, 49.81057988, 49.810272, 49.80996388, 49.8096555, 49.80934688, 49.809038, 49.80872888, 49.8084195, 49.80810988, 49.8078, 49.80748988, 49.8071795, 49.80686888, 49.806558, 49.80624688, 49.8059355, 49.80562388, 49.805312, 49.80499988, 49.8046875, 49.80437488, 49.804062, 49.80374888, 49.8034355, 49.80312188, 49.802808, 49.80249388, 49.8021795, 49.80186488, 49.80155, 49.80123488, 49.8009195, 49.80060388, 49.800288, 49.79997188, 49.7996555, 49.79933888, 49.799022, 49.79870488, 49.7983875, 49.79806988, 49.797752, 49.79743388, 49.7971155, 49.79679688, 49.796478, 49.79615888, 49.7958395, 49.79551988, 49.7952, 49.79487988, 49.7945595, 49.79423888, 49.793918, 49.79359688, 49.7932755, 49.79295388, 49.792632, 49.79230988, 49.7919875, 49.79166488, 49.791342, 49.79101888, 49.7906955, 49.79037188, 49.790048, 49.78972388, 49.7893995, 49.78907488, 49.78875, 49.78842488, 49.7880995, 49.78777388, 49.787448, 49.78712188, 49.7867955, 49.78646888, 49.786142, 49.78581488, 49.7854875, 49.78515988, 49.784832, 49.78450388, 49.7841755, 49.78384688, 49.783518, 49.78318888, 49.7828595, 49.78252988, 49.7822, 49.78186988, 49.7815395, 49.78120888, 49.780878, 49.78054688, 49.7802155, 49.77988388, 49.779552, 49.77921988, 49.7788875, 49.77855488, 49.778222, 49.77788888, 49.7775555, 49.77722188, 49.776888, 49.77655388, 49.7762195, 49.77588488, 49.77555, 49.77521488, 49.7748795, 49.77454388, 49.774208, 49.77387188, 49.7735355, 49.77319888, 49.772862, 49.77252488, 49.7721875, 49.77184988, 49.771512, 49.77117388, 49.7708355, 49.77049688, 49.770158, 49.76981888, 49.7694795, 49.76913988, 49.7688, 49.76845988, 49.7681195, 49.76777888, 49.767438, 49.76709688, 49.7667555, 49.76641388, 49.766072, 49.76572988, 49.7653875, 49.76504488, 49.764702, 49.76435888, 49.7640155, 49.76367188, 49.763328, 49.76298388, 49.7626395, 49.76229488, 49.76195, 49.76160488, 49.7612595, 49.76091388, 49.760568, 49.76022188, 49.7598755, 49.75952888, 49.759182, 49.75883488, 49.7584875, 49.75813988, 49.757792, 49.75744388, 49.7570955, 49.75674688, 49.756398, 49.75604888, 49.7556995, 49.75534988, 49.755, 49.75464988, 49.7542995, 49.75394888, 49.753598, 49.75324688, 49.7528955, 49.75254388, 49.752192, 49.75183988, 49.7514875, 49.75113488, 49.750782, 49.75042888, 49.7500755, 49.74972188, 49.749368, 49.74901388, 49.7486595, 49.74830488, 49.74795, 49.74759488, 49.7472395, 49.74688388, 49.746528, 49.74617188, 49.7458155, 49.74545888, 49.745102, 49.74474488, 49.7443875, 49.74402988, 49.743672, 49.74331388, 49.7429555, 49.74259688, 49.742238, 49.74187888, 49.7415195, 49.74115988, 49.7408, 49.74043988, 49.7400795, 49.73971888, 49.739358, 49.73899688, 49.7386355, 49.73827388, 49.737912, 49.73754988, 49.7371875, 49.73682488, 49.736462, 49.73609888, 49.7357355, 49.73537188, 49.735008, 49.73464388, 49.7342795, 49.73391488, 49.73355, 49.73318488, 49.7328195, 49.73245388, 49.732088, 49.73172188, 49.7313555, 49.73098888, 49.730622, 49.73025488, 49.7298875, 49.72951988, 49.729152, 49.72878388, 49.7284155, 49.72804688, 49.727678, 49.72730888, 49.7269395, 49.72656988, 49.7262, 49.72582988, 49.7254595, 49.72508888, 49.724718, 49.72434688, 49.7239755, 49.72360388, 49.723232, 49.72285988, 49.7224875, 49.72211488, 49.721742, 49.72136888, 49.7209955, 49.72062188, 49.720248, 49.71987388, 49.7194995, 49.71912488, 49.71875, 49.71837488, 49.7179995, 49.71762388, 49.717248, 49.71687188, 49.7164955, 49.71611888, 49.715742, 49.71536488, 49.7149875, 49.71460988, 49.714232, 49.71385388, 49.7134755, 49.71309688, 49.712718, 49.71233888, 49.7119595, 49.71157988, 49.7112, 49.71081988, 49.7104395, 49.71005888, 49.709678, 49.70929688, 49.7089155, 49.70853388, 49.708152, 49.70776988, 49.7073875, 49.70700488, 49.706622, 49.70623888, 49.7058555, 49.70547188, 49.705088, 49.70470388, 49.7043195, 49.70393488, 49.70355, 49.70316488, 49.7027795, 49.70239388, 49.702008, 49.70162188, 49.7012355, 49.70084888, 49.700462, 49.70007488, 49.6996875, 49.69929988, 49.698912, 49.69852388, 49.6981355, 49.69774688, 49.697358, 49.69696888, 49.6965795, 49.69618988, 49.6958, 49.69540988, 49.6950195, 49.69462888, 49.694238, 49.69384688, 49.6934555, 49.69306388, 49.692672, 49.69227988, 49.6918875, 49.69149488, 49.691102, 49.69070888, 49.6903155, 49.68992188, 49.689528, 49.68913388, 49.6887395, 49.68834488, 49.68795, 49.68755488, 49.6871595, 49.68676388, 49.686368, 49.68597188, 49.6855755, 49.68517888, 49.684782, 49.68438488, 49.6839875, 49.68358988, 49.683192, 49.68279388, 49.6823955, 49.68199688, 49.681598, 49.68119888, 49.6807995, 49.68039988, 49.68, 49.67959988, 49.6791995, 49.67879888, 49.678398, 49.67799688, 49.6775955, 49.67719388, 49.676792, 49.67638988, 49.6759875, 49.67558488, 49.675182, 49.67477888, 49.6743755, 49.67397188, 49.673568, 49.67316388, 49.6727595, 49.67235488, 49.67195, 49.67154488, 49.6711395, 49.67073388, 49.670328, 49.66992188, 49.6695155, 49.66910888, 49.668702, 49.66829488, 49.6678875, 49.66747988, 49.667072, 49.66666388, 49.6662555, 49.66584688, 49.665438, 49.66502888, 49.6646195, 49.66420988, 49.6638, 49.66338988, 49.6629795, 49.66256888, 49.662158, 49.66174688, 49.6613355, 49.66092388, 49.660512, 49.66009988, 49.6596875, 49.65927488, 49.658862, 49.65844888, 49.6580355, 49.65762188, 49.657208, 49.65679388, 49.6563795, 49.65596488, 49.65555, 49.65513488, 49.6547195, 49.65430388, 49.653888, 49.65347188, 49.6530555, 49.65263888, 49.652222, 49.65180488, 49.6513875, 49.65096988, 49.650552, 49.65013388, 49.6497155, 49.64929688, 49.648878, 49.64845888, 49.6480395, 49.64761988, 49.6472, 49.64677988, 49.6463595, 49.64593888, 49.645518, 49.64509688, 49.6446755, 49.64425388, 49.643832, 49.64340988, 49.6429875, 49.64256488, 49.642142, 49.64171888, 49.6412955, 49.64087188, 49.640448, 49.64002388, 49.6395995, 49.63917488, 49.63875, 49.63832488, 49.6378995, 49.63747388, 49.637048, 49.63662188, 49.6361955, 49.63576888, 49.635342, 49.63491488, 49.6344875, 49.63405988, 49.633632, 49.63320388, 49.6327755, 49.63234688, 49.631918, 49.63148888, 49.6310595, 49.63062988, 49.6302, 49.62976988, 49.6293395, 49.62890888, 49.628478, 49.62804688, 49.6276155, 49.62718388, 49.626752, 49.62631988, 49.6258875, 49.62545488, 49.625022, 49.62458888, 49.6241555, 49.62372188, 49.623288, 49.62285388, 49.6224195, 49.62198488, 49.62155, 49.62111488, 49.6206795, 49.62024388, 49.619808, 49.61937188, 49.6189355, 49.61849888, 49.618062, 49.61762488, 49.6171875, 49.61674988, 49.616312, 49.61587388, 49.6154355, 49.61499688, 49.614558, 49.61411888, 49.6136795, 49.61323988, 49.6128, 49.61235988, 49.6119195, 49.61147888, 49.611038, 49.61059688, 49.6101555, 49.60971388, 49.609272, 49.60882988, 49.6083875, 49.60794488, 49.607502, 49.60705888, 49.6066155, 49.60617188, 49.605728, 49.60528388, 49.6048395, 49.60439488, 49.60395, 49.60350488, 49.6030595, 49.60261388, 49.602168, 49.60172188, 49.6012755, 49.60082888, 49.600382, 49.59993488, 49.5994875, 49.59903988, 49.598592, 49.59814388, 49.5976955, 49.59724688, 49.596798, 49.59634888, 49.5958995, 49.59544988, 49.595, 49.59454988, 49.5940995, 49.59364888, 49.593198, 49.59274688, 49.5922955, 49.59184388, 49.591392, 49.59093988, 49.5904875, 49.59003488, 49.589582, 49.58912888, 49.5886755, 49.58822188, 49.587768, 49.58731388, 49.5868595, 49.58640488, 49.58595, 49.58549488, 49.5850395, 49.58458388, 49.584128, 49.58367188, 49.5832155, 49.58275888, 49.582302, 49.58184488, 49.5813875, 49.58092988, 49.580472, 49.58001388, 49.5795555, 49.57909688, 49.578638, 49.57817888, 49.5777195, 49.57725988, 49.5768, 49.57633988, 49.5758795, 49.57541888, 49.574958, 49.57449688, 49.5740355, 49.57357388, 49.573112, 49.57264988, 49.5721875, 49.57172488, 49.571262, 49.57079888, 49.5703355, 49.56987188, 49.569408, 49.56894388, 49.5684795, 49.56801488, 49.56755, 49.56708488, 49.5666195, 49.56615388, 49.565688, 49.56522188, 49.5647555, 49.56428888, 49.563822, 49.56335488, 49.5628875, 49.56241988, 49.561952, 49.56148388, 49.5610155, 49.56054688, 49.560078, 49.55960888, 49.5591395, 49.55866988, 49.5582, 49.55772988, 49.5572595, 49.55678888, 49.556318, 49.55584688, 49.5553755, 49.55490388, 49.554432, 49.55395988, 49.5534875, 49.55301488, 49.552542, 49.55206888, 49.5515955, 49.55112188, 49.550648, 49.55017388, 49.5496995, 49.54922488, 49.54875, 49.54827488, 49.5477995, 49.54732388, 49.546848, 49.54637188, 49.5458955, 49.54541888, 49.544942, 49.54446488, 49.5439875, 49.54350988, 49.543032, 49.54255388, 49.5420755, 49.54159688, 49.541118, 49.54063888, 49.5401595, 49.53967988, 49.5392, 49.53871988, 49.5382395, 49.53775888, 49.537278, 49.53679688, 49.5363155, 49.53583388, 49.535352, 49.53486988, 49.5343875, 49.53390488, 49.533422, 49.53293888, 49.5324555, 49.53197188, 49.531488, 49.53100388, 49.5305195, 49.53003488, 49.52955, 49.52906488, 49.5285795, 49.52809388, 49.527608, 49.52712188, 49.5266355, 49.52614888, 49.525662, 49.52517488, 49.5246875, 49.52419988, 49.523712, 49.52322388, 49.5227355, 49.52224688, 49.521758, 49.52126888, 49.5207795, 49.52028988, 49.5198, 49.51930988, 49.5188195, 49.51832888, 49.517838, 49.51734688, 49.5168555, 49.51636388, 49.515872, 49.51537988, 49.5148875, 49.51439488, 49.513902, 49.51340888, 49.5129155, 49.51242188, 49.511928, 49.51143388, 49.5109395, 49.51044488, 49.50995, 49.50945488, 49.5089595, 49.50846388, 49.507968, 49.50747188, 49.5069755, 49.50647888, 49.505982, 49.50548488, 49.5049875, 49.50448988, 49.503992, 49.50349388, 49.5029955, 49.50249688, 49.501998, 49.50149888, 49.5009995, 49.50049988, 49.5, 49.49949988, 49.4989995, 49.49849888, 49.497998, 49.49749688, 49.4969955, 49.49649388, 49.495992, 49.49548988, 49.4949875, 49.49448488, 49.493982, 49.49347888, 49.4929755, 49.49247188, 49.491968, 49.49146388, 49.4909595, 49.49045488, 49.48995, 49.48944488, 49.4889395, 49.48843388, 49.487928, 49.48742188, 49.4869155, 49.48640888, 49.485902, 49.48539488, 49.4848875, 49.48437988, 49.483872, 49.48336388, 49.4828555, 49.48234688, 49.481838, 49.48132888, 49.4808195, 49.48030988, 49.4798, 49.47928988, 49.4787795, 49.47826888, 49.477758, 49.47724688, 49.4767355, 49.47622388, 49.475712, 49.47519988, 49.4746875, 49.47417488, 49.473662, 49.47314888, 49.4726355, 49.47212188, 49.471608, 49.47109388, 49.4705795, 49.47006488, 49.46955, 49.46903488, 49.4685195, 49.46800388, 49.467488, 49.46697188, 49.4664555, 49.46593888, 49.465422, 49.46490488, 49.4643875, 49.46386988, 49.463352, 49.46283388, 49.4623155, 49.46179688, 49.461278, 49.46075888, 49.4602395, 49.45971988, 49.4592, 49.45867988, 49.4581595, 49.45763888, 49.457118, 49.45659688, 49.4560755, 49.45555388, 49.455032, 49.45450988, 49.4539875, 49.45346488, 49.452942, 49.45241888, 49.4518955, 49.45137188, 49.450848, 49.45032388, 49.4497995, 49.44927488, 49.44875, 49.44822488, 49.4476995, 49.44717388, 49.446648, 49.44612188, 49.4455955, 49.44506888, 49.444542, 49.44401488, 49.4434875, 49.44295988, 49.442432, 49.44190388, 49.4413755, 49.44084688, 49.440318, 49.43978888, 49.4392595, 49.43872988, 49.4382, 49.43766988, 49.4371395, 49.43660888, 49.436078, 49.43554688, 49.4350155, 49.43448388, 49.433952, 49.43341988, 49.4328875, 49.43235488, 49.431822, 49.43128888, 49.4307555, 49.43022188, 49.429688, 49.42915388, 49.4286195, 49.42808488, 49.42755, 49.42701488, 49.4264795, 49.42594388, 49.425408, 49.42487188, 49.4243355, 49.42379888, 49.423262, 49.42272488, 49.4221875, 49.42164988, 49.421112, 49.42057388, 49.4200355, 49.41949688, 49.418958, 49.41841888, 49.4178795, 49.41733988, 49.4168, 49.41625988, 49.4157195, 49.41517888, 49.414638, 49.41409688, 49.4135555, 49.41301388, 49.412472, 49.41192988, 49.4113875, 49.41084488, 49.410302, 49.40975888, 49.4092155, 49.40867188, 49.408128, 49.40758388, 49.4070395, 49.40649488, 49.40595, 49.40540488, 49.4048595, 49.40431388, 49.403768, 49.40322188, 49.4026755, 49.40212888, 49.401582, 49.40103488, 49.4004875, 49.39993988, 49.399392, 49.39884388, 49.3982955, 49.39774688, 49.397198, 49.39664888, 49.3960995, 49.39554988, 49.395, 49.39445, 49.3939, 49.39335, 49.3928, 49.39225, 49.3917, 49.39115, 49.3906, 49.39005, 49.3895, 49.38895, 49.3884, 49.38785, 49.3873, 49.38675, 49.3862, 49.38565, 49.3851, 49.38455, 49.384, 49.38345, 49.3829, 49.38235, 49.3818, 49.38125, 49.3807, 49.38015, 49.3796, 49.37905, 49.3785, 49.37795, 49.3774, 49.37685, 49.3763, 49.37575, 49.3752, 49.37465, 49.3741, 49.37355, 49.373, 49.37245, 49.3719, 49.37135, 49.3708, 49.37025, 49.3697, 49.36915, 49.3686, 49.36805, 49.3675, 49.36695, 49.3664, 49.36585, 49.3653, 49.36475, 49.3642, 49.36365, 49.3631, 49.36255, 49.362, 49.36145, 49.3609, 49.36035, 49.3598, 49.35925, 49.3587, 49.35815, 49.3576, 49.35705, 49.3565, 49.35595, 49.3554, 49.35485, 49.3543, 49.35375, 49.3532, 49.35265, 49.3521, 49.35155, 49.351, 49.35045, 49.3499, 49.34935, 49.3488, 49.34825, 49.3477, 49.34715, 49.3466, 49.34605, 49.3455, 49.34495, 49.3444, 49.34385, 49.3433, 49.34275, 49.3422, 49.34165, 49.3411, 49.34055, 49.34, 49.33945, 49.3389, 49.33835, 49.3378, 49.33725, 49.3367, 49.33615, 49.3356, 49.33505, 49.3345, 49.33395, 49.3334, 49.33285, 49.3323, 49.33175, 49.3312, 49.33065, 49.3301, 49.32955, 49.329, 49.32845, 49.3279, 49.32735, 49.3268, 49.32625, 49.3257, 49.32515, 49.3246, 49.32405, 49.3235, 49.32295, 49.3224, 49.32185, 49.3213, 49.32075, 49.3202, 49.31965, 49.3191, 49.31855, 49.318, 49.31745, 49.3169, 49.31635, 49.3158, 49.31525, 49.3147, 49.31415, 49.3136, 49.31305, 49.3125, 49.31195, 49.3114, 49.31085, 49.3103, 49.30975, 49.3092, 49.30865, 49.3081, 49.30755, 49.307, 49.30645, 49.3059, 49.30535, 49.3048, 49.30425, 49.3037, 49.30315, 49.3026, 49.30205, 49.3015, 49.30095, 49.3004, 49.29985, 49.2993, 49.29875, 49.2982, 49.29765, 49.2971, 49.29655, 49.296, 49.29545, 49.2949, 49.29435, 49.2938, 49.29325, 49.2927, 49.29215, 49.2916, 49.29105, 49.2905, 49.28995, 49.2894, 49.28885, 49.2883, 49.28775, 49.2872, 49.28665, 49.2861, 49.28555, 49.285, 49.28445, 49.2839, 49.28335, 49.2828, 49.28225, 49.2817, 49.28115, 49.2806, 49.28005, 49.2795, 49.27895, 49.2784, 49.27785, 49.2773, 49.27675, 49.2762, 49.27565, 49.2751, 49.27455, 49.274, 49.27345, 49.2729, 49.27235, 49.2718, 49.27125, 49.2707, 49.27015, 49.2696, 49.26905, 49.2685, 49.26795, 49.2674, 49.26685, 49.2663, 49.26575, 49.2652, 49.26465, 49.2641, 49.26355, 49.263, 49.26245, 49.2619, 49.26135, 49.2608, 49.26025, 49.2597, 49.25915, 49.2586, 49.25805, 49.2575, 49.25695, 49.2564, 49.25585, 49.2553, 49.25475, 49.2542, 49.25365, 49.2531, 49.25255, 49.252, 49.25145, 49.2509, 49.25035, 49.2498, 49.24925, 49.2487, 49.24815, 49.2476, 49.24705, 49.2465, 49.24595, 49.2454, 49.24485, 49.2443, 49.24375, 49.2432, 49.24265, 49.2421, 49.24155, 49.241, 49.24045, 49.2399, 49.23935, 49.2388, 49.23825, 49.2377, 49.23715, 49.2366, 49.23605, 49.2355, 49.23495, 49.2344, 49.23385, 49.2333, 49.23275, 49.2322, 49.23165, 49.2311, 49.23055, 49.23, 49.22945, 49.2289, 49.22835, 49.2278, 49.22725, 49.2267, 49.22615, 49.2256, 49.22505, 49.2245, 49.22395, 49.2234, 49.22285, 49.2223, 49.22175, 49.2212, 49.22065, 49.2201, 49.21955, 49.219, 49.21845, 49.2179, 49.21735, 49.2168, 49.21625, 49.2157, 49.21515, 49.2146, 49.21405, 49.2135, 49.21295, 49.2124, 49.21185, 49.2113, 49.21075, 49.2102, 49.20965, 49.2091, 49.20855, 49.208, 49.20745, 49.2069, 49.20635, 49.2058, 49.20525, 49.2047, 49.20415, 49.2036, 49.20305, 49.2025, 49.20195, 49.2014, 49.20085, 49.2003, 49.19975, 49.1992, 49.19865, 49.1981, 49.19755, 49.197, 49.19645, 49.1959, 49.19535, 49.1948, 49.19425, 49.1937, 49.19315, 49.1926, 49.19205, 49.1915, 49.19095, 49.1904, 49.18985, 49.1893, 49.18875, 49.1882, 49.18765, 49.1871, 49.18655, 49.186, 49.18545, 49.1849, 49.18435, 49.1838, 49.18325, 49.1827, 49.18215, 49.1816, 49.18105, 49.1805, 49.17995, 49.1794, 49.17885, 49.1783, 49.17775, 49.1772, 49.17665, 49.1761, 49.17555, 49.175, 49.17445, 49.1739, 49.17335, 49.1728, 49.17225, 49.1717, 49.17115, 49.1706, 49.17005, 49.1695, 49.16895, 49.1684, 49.16785, 49.1673, 49.16675, 49.1662, 49.16565, 49.1651, 49.16455, 49.164, 49.16345, 49.1629, 49.16235, 49.1618, 49.16125, 49.1607, 49.16015, 49.1596, 49.15905, 49.1585, 49.15795, 49.1574, 49.15685, 49.1563, 49.15575, 49.1552, 49.15465, 49.1541, 49.15355, 49.153, 49.15245, 49.1519, 49.15135, 49.1508, 49.15025, 49.1497, 49.14915, 49.1486, 49.14805, 49.1475, 49.14695, 49.1464, 49.14585, 49.1453, 49.14475, 49.1442, 49.14365, 49.1431, 49.14255, 49.142, 49.14145, 49.1409, 49.14035, 49.1398, 49.13925, 49.1387, 49.13815, 49.1376, 49.13705, 49.1365, 49.13595, 49.1354, 49.13485, 49.1343, 49.13375, 49.1332, 49.13265, 49.1321, 49.13155, 49.131, 49.13045, 49.1299, 49.12935, 49.1288, 49.12825, 49.1277, 49.12715, 49.1266, 49.12605, 49.1255, 49.12495, 49.1244, 49.12385, 49.1233, 49.12275, 49.1222, 49.12165, 49.1211, 49.12055, 49.12, 49.11945, 49.1189, 49.11835, 49.1178, 49.11725, 49.1167, 49.11615, 49.1156, 49.11505, 49.1145, 49.11395, 49.1134, 49.11285, 49.1123, 49.11175, 49.1112, 49.11065, 49.1101, 49.10955, 49.109, 49.10845, 49.1079, 49.10735, 49.1068, 49.10625, 49.1057, 49.10515, 49.1046, 49.10405, 49.1035, 49.10295, 49.1024, 49.10185, 49.1013, 49.10075, 49.1002, 49.09965, 49.0991, 49.09855, 49.098, 49.09745, 49.0969, 49.09635, 49.0958, 49.09525, 49.0947, 49.09415, 49.0936, 49.09305, 49.0925, 49.09195, 49.0914, 49.09085, 49.0903, 49.08975, 49.0892, 49.08865, 49.0881, 49.08755, 49.087, 49.08645, 49.0859, 49.08535, 49.0848, 49.08425, 49.0837, 49.08315, 49.0826, 49.08205, 49.0815, 49.08095, 49.0804, 49.07985, 49.0793, 49.07875, 49.0782, 49.07765, 49.0771, 49.07655, 49.076, 49.07545, 49.0749, 49.07435, 49.0738, 49.07325, 49.0727, 49.07215, 49.0716, 49.07105, 49.0705, 49.06995, 49.0694, 49.06885, 49.0683, 49.06775, 49.0672, 49.06665, 49.0661, 49.06555, 49.065, 49.06445, 49.0639, 49.06335, 49.0628, 49.06225, 49.0617, 49.06115, 49.0606, 49.06005, 49.0595, 49.05895, 49.0584, 49.05785, 49.0573, 49.05675, 49.0562, 49.05565, 49.0551, 49.05455, 49.054, 49.05345, 49.0529, 49.05235, 49.0518, 49.05125, 49.0507, 49.05015, 49.0496, 49.04905, 49.0485, 49.04795, 49.0474, 49.04685, 49.0463, 49.04575, 49.0452, 49.04465, 49.0441, 49.04355, 49.043, 49.04245, 49.0419, 49.04135, 49.0408, 49.04025, 49.0397, 49.03915, 49.0386, 49.03805, 49.0375, 49.03695, 49.0364, 49.03585, 49.0353, 49.03475, 49.0342, 49.03365, 49.0331, 49.03255, 49.032, 49.03145, 49.0309, 49.03035, 49.0298, 49.02925, 49.0287, 49.02815, 49.0276, 49.02705, 49.0265, 49.02595, 49.0254, 49.02485, 49.0243, 49.02375, 49.0232, 49.02265, 49.0221, 49.02155, 49.021, 49.02045, 49.0199, 49.01935, 49.0188, 49.01825, 49.0177, 49.01715, 49.0166, 49.01605, 49.0155, 49.01495, 49.0144, 49.01385, 49.0133, 49.01275, 49.0122, 49.01165, 49.0111, 49.01055, 49.01, 49.00945, 49.0089, 49.00835, 49.0078, 49.00725, 49.0067, 49.00615, 49.0056, 49.00505, 49.0045, 49.00395, 49.0034, 49.00285, 49.0023, 49.00175, 49.0012, 49.00065, 49.0001, 48.99955, 48.999, 48.99845, 48.9979, 48.99735, 48.9968, 48.99625, 48.9957, 48.99515, 48.9946, 48.99405, 48.9935, 48.99295, 48.9924, 48.99185, 48.9913, 48.99075, 48.9902, 48.98965, 48.9891, 48.98855, 48.988, 48.98745, 48.9869, 48.98635, 48.9858, 48.98525, 48.9847, 48.98415, 48.9836, 48.98305, 48.9825, 48.98195, 48.9814, 48.98085, 48.9803, 48.97975, 48.9792, 48.97865, 48.9781, 48.97755, 48.977, 48.97645, 48.9759, 48.97535, 48.9748, 48.97425, 48.9737, 48.97315, 48.9726, 48.97205, 48.9715, 48.97095, 48.9704, 48.96985, 48.9693, 48.96875, 48.9682, 48.96765, 48.9671, 48.96655, 48.966, 48.96545, 48.9649, 48.96435, 48.9638, 48.96325, 48.9627, 48.96215, 48.9616, 48.96105, 48.9605, 48.95995, 48.9594, 48.95885, 48.9583, 48.95775, 48.9572, 48.95665, 48.9561, 48.95555, 48.955, 48.95445, 48.9539, 48.95335, 48.9528, 48.95225, 48.9517, 48.95115, 48.9506, 48.95005, 48.9495, 48.94895, 48.9484, 48.94785, 48.9473, 48.94675, 48.9462, 48.94565, 48.9451, 48.94455, 48.944, 48.94345, 48.9429, 48.94235, 48.9418, 48.94125, 48.9407, 48.94015, 48.9396, 48.93905, 48.9385, 48.93795, 48.9374, 48.93685, 48.9363, 48.93575, 48.9352, 48.93465, 48.9341, 48.93355, 48.933, 48.93245, 48.9319, 48.93135, 48.9308, 48.93025, 48.9297, 48.92915, 48.9286, 48.92805, 48.9275, 48.92695, 48.9264, 48.92585, 48.9253, 48.92475, 48.9242, 48.92365, 48.9231, 48.92255, 48.922, 48.92145, 48.9209, 48.92035, 48.9198, 48.91925, 48.9187, 48.91815, 48.9176, 48.91705, 48.9165, 48.91595, 48.9154, 48.91485, 48.9143, 48.91375, 48.9132, 48.91265, 48.9121, 48.91155, 48.911, 48.91045, 48.9099, 48.90935, 48.9088, 48.90825, 48.9077, 48.90715, 48.9066, 48.90605, 48.9055, 48.90495, 48.9044, 48.90385, 48.9033, 48.90275, 48.9022, 48.90165, 48.9011, 48.90055, 48.9, 48.89945, 48.8989, 48.89835, 48.8978, 48.89725, 48.8967, 48.89615, 48.8956, 48.89505, 48.8945, 48.89395, 48.8934, 48.89285, 48.8923, 48.89175, 48.8912, 48.89065, 48.8901, 48.88955, 48.889, 48.88845, 48.8879, 48.88735, 48.8868, 48.88625, 48.8857, 48.88515, 48.8846, 48.88405, 48.8835, 48.88295, 48.8824, 48.88185, 48.8813, 48.88075, 48.8802, 48.87965, 48.8791, 48.87855, 48.878, 48.87745, 48.8769, 48.87635, 48.8758, 48.87525, 48.8747, 48.87415, 48.8736, 48.87305, 48.8725, 48.87195, 48.8714, 48.87085, 48.8703, 48.86975, 48.8692, 48.86865, 48.8681, 48.86755, 48.867, 48.86645, 48.8659, 48.86535, 48.8648, 48.86425, 48.8637, 48.86315, 48.8626, 48.86205, 48.8615, 48.86095, 48.8604, 48.85985, 48.8593, 48.85875, 48.8582, 48.85765, 48.8571, 48.85655, 48.856, 48.85545, 48.8549, 48.85435, 48.8538, 48.85325, 48.8527, 48.85215, 48.8516, 48.85105, 48.8505, 48.84995, 48.8494, 48.84885, 48.8483, 48.84775, 48.8472, 48.84665, 48.8461, 48.84555, 48.845, 48.84445, 48.8439, 48.84335, 48.8428, 48.84225, 48.8417, 48.84115, 48.8406, 48.84005, 48.8395, 48.83895, 48.8384, 48.83785, 48.8373, 48.83675, 48.8362, 48.83565, 48.8351, 48.83455, 48.834, 48.83345, 48.8329, 48.83235, 48.8318, 48.83125, 48.8307, 48.83015, 48.8296, 48.82905, 48.8285, 48.82795, 48.8274, 48.82685, 48.8263, 48.82575, 48.8252, 48.82465, 48.8241, 48.82355, 48.823, 48.82245, 48.8219, 48.82135, 48.8208, 48.82025, 48.8197, 48.81915, 48.8186, 48.81805, 48.8175, 48.81695, 48.8164, 48.81585, 48.8153, 48.81475, 48.8142, 48.81365, 48.8131, 48.81255, 48.812, 48.81145, 48.8109, 48.81035, 48.8098, 48.80925, 48.8087, 48.80815, 48.8076, 48.80705, 48.8065, 48.80595, 48.8054, 48.80485, 48.8043, 48.80375, 48.8032, 48.80265, 48.8021, 48.80155, 48.801, 48.80045, 48.7999, 48.79935, 48.7988, 48.79825, 48.7977, 48.79715, 48.7966, 48.79605, 48.7955, 48.79495, 48.7944, 48.79385, 48.7933, 48.79275, 48.7922, 48.79165, 48.7911, 48.79055, 48.79, 48.78945, 48.7889, 48.78835, 48.7878, 48.78725, 48.7867, 48.78615, 48.7856, 48.78505, 48.7845, 48.78395, 48.7834, 48.78285, 48.7823, 48.78175, 48.7812, 48.78065, 48.7801, 48.77955, 48.779, 48.77845, 48.7779, 48.77735, 48.7768, 48.77625, 48.7757, 48.77515, 48.7746, 48.77405, 48.7735, 48.77295, 48.7724, 48.77185, 48.7713, 48.77075, 48.7702, 48.76965, 48.7691, 48.76855, 48.768, 48.76745, 48.7669, 48.76635, 48.7658, 48.76525, 48.7647, 48.76415, 48.7636, 48.76305, 48.7625, 48.76195, 48.7614, 48.76085, 48.7603, 48.75975, 48.7592, 48.75865, 48.7581, 48.75755, 48.757, 48.75645, 48.7559, 48.75535, 48.7548, 48.75425, 48.7537, 48.75315, 48.7526, 48.75205, 48.7515, 48.75095, 48.7504, 48.74985, 48.7493, 48.74875, 48.7482, 48.74765, 48.7471, 48.74655, 48.746, 48.74545, 48.7449, 48.74435, 48.7438, 48.74325, 48.7427, 48.74215, 48.7416, 48.74105, 48.7405, 48.73995, 48.7394, 48.73885, 48.7383, 48.73775, 48.7372, 48.73665, 48.7361, 48.73555, 48.735, 48.73445, 48.7339, 48.73335, 48.7328, 48.73225, 48.7317, 48.73115, 48.7306, 48.73005, 48.7295, 48.72895, 48.7284, 48.72785, 48.7273, 48.72675, 48.7262, 48.72565, 48.7251, 48.72455, 48.724, 48.72345, 48.7229, 48.72235, 48.7218, 48.72125, 48.7207, 48.72015, 48.7196, 48.71905, 48.7185, 48.71795, 48.7174, 48.71685, 48.7163, 48.71575, 48.7152, 48.71465, 48.7141, 48.71355, 48.713, 48.71245, 48.7119, 48.71135, 48.7108, 48.71025, 48.7097, 48.70915, 48.7086, 48.70805, 48.7075, 48.70695, 48.7064, 48.70585, 48.7053, 48.70475, 48.7042, 48.70365, 48.7031, 48.70255, 48.702, 48.70145, 48.7009, 48.70035, 48.6998, 48.69925, 48.6987, 48.69815, 48.6976, 48.69705, 48.6965, 48.69595, 48.6954, 48.69485, 48.6943, 48.69375, 48.6932, 48.69265, 48.6921, 48.69155, 48.691, 48.69045, 48.6899, 48.68935, 48.6888, 48.68825, 48.6877, 48.68715, 48.6866, 48.68605, 48.6855, 48.68495, 48.6844, 48.68385, 48.6833, 48.68275, 48.6822, 48.68165, 48.6811, 48.68055, 48.68, 48.67945, 48.6789, 48.67835, 48.6778, 48.67725, 48.6767, 48.67615, 48.6756, 48.67505, 48.6745, 48.67395, 48.6734, 48.67285, 48.6723, 48.67175, 48.6712, 48.67065, 48.6701, 48.66955, 48.669, 48.66845, 48.6679, 48.66735, 48.6668, 48.66625, 48.6657, 48.66515, 48.6646, 48.66405, 48.6635, 48.66295, 48.6624, 48.66185, 48.6613, 48.66075, 48.6602, 48.65965, 48.6591, 48.65855, 48.658, 48.65745, 48.6569, 48.65635, 48.6558, 48.65525, 48.6547, 48.65415, 48.6536, 48.65305, 48.6525, 48.65195, 48.6514, 48.65085, 48.6503, 48.64975, 48.6492, 48.64865, 48.6481, 48.64755, 48.647, 48.64645, 48.6459, 48.64535, 48.6448, 48.64425, 48.6437, 48.64315, 48.6426, 48.64205, 48.6415, 48.64095, 48.6404, 48.63985, 48.6393, 48.63875, 48.6382, 48.63765, 48.6371, 48.63655, 48.636, 48.63545, 48.6349, 48.63435, 48.6338, 48.63325, 48.6327, 48.63215, 48.6316, 48.63105, 48.6305, 48.62995, 48.6294, 48.62885, 48.6283, 48.62775, 48.6272, 48.62665, 48.6261, 48.62555, 48.625, 48.62445, 48.6239, 48.62335, 48.6228, 48.62225, 48.6217, 48.62115, 48.6206, 48.62005, 48.6195, 48.61895, 48.6184, 48.61785, 48.6173, 48.61675, 48.6162, 48.61565, 48.6151, 48.61455, 48.614, 48.61345, 48.6129, 48.61235, 48.6118, 48.61125, 48.6107, 48.61015, 48.6096, 48.60905, 48.6085, 48.60795, 48.6074, 48.60685, 48.6063, 48.60575, 48.6052, 48.60465, 48.6041, 48.60355, 48.603, 48.60245, 48.6019, 48.60135, 48.6008, 48.60025, 48.5997, 48.59915, 48.5986, 48.59805, 48.5975, 48.59695, 48.5964, 48.59585, 48.5953, 48.59475, 48.5942, 48.59365, 48.5931, 48.59255, 48.592, 48.59145, 48.5909, 48.59035, 48.5898, 48.58925, 48.5887, 48.58815, 48.5876, 48.58705, 48.5865, 48.58595, 48.5854, 48.58485, 48.5843, 48.58375, 48.5832, 48.58265, 48.5821, 48.58155, 48.581, 48.58045, 48.5799, 48.57935, 48.5788, 48.57825, 48.5777, 48.57715, 48.5766, 48.57605, 48.5755, 48.57495, 48.5744, 48.57385, 48.5733, 48.57275, 48.5722, 48.57165, 48.5711, 48.57055, 48.57, 48.56945, 48.5689, 48.56835, 48.5678, 48.56725, 48.5667, 48.56615, 48.5656, 48.56505, 48.5645, 48.56395, 48.5634, 48.56285, 48.5623, 48.56175, 48.5612, 48.56065, 48.5601, 48.55955, 48.559, 48.55845, 48.5579, 48.55735, 48.5568, 48.55625, 48.5557, 48.55515, 48.5546, 48.55405, 48.5535, 48.55295, 48.5524, 48.55185, 48.5513, 48.55075, 48.5502, 48.54965, 48.5491, 48.54855, 48.548, 48.54745, 48.5469, 48.54635, 48.5458, 48.54525, 48.5447, 48.54415, 48.5436, 48.54305, 48.5425, 48.54195, 48.5414, 48.54085, 48.5403, 48.53975, 48.5392, 48.53865, 48.5381, 48.53755, 48.537, 48.53645, 48.5359, 48.53535, 48.5348, 48.53425, 48.5337, 48.53315, 48.5326, 48.53205, 48.5315, 48.53095, 48.5304, 48.52985, 48.5293, 48.52875, 48.5282, 48.52765, 48.5271, 48.52655, 48.526, 48.52545, 48.5249, 48.52435, 48.5238, 48.52325, 48.5227, 48.52215, 48.5216, 48.52105, 48.5205, 48.51995, 48.5194, 48.51885, 48.5183, 48.51775, 48.5172, 48.51665, 48.5161, 48.51555, 48.515, 48.51445, 48.5139, 48.51335, 48.5128, 48.51225, 48.5117, 48.51115, 48.5106, 48.51005, 48.5095, 48.50895, 48.5084, 48.50785, 48.5073, 48.50675, 48.5062, 48.50565, 48.5051, 48.50455, 48.504, 48.50345, 48.5029, 48.50235, 48.5018, 48.50125, 48.5007, 48.50015, 48.4996, 48.49905, 48.4985, 48.49795, 48.4974, 48.49685, 48.4963, 48.49575, 48.4952, 48.49465, 48.4941, 48.49355, 48.493, 48.49245, 48.4919, 48.49135, 48.4908, 48.49025, 48.4897, 48.48915, 48.4886, 48.48805, 48.4875, 48.48695, 48.4864, 48.48585, 48.4853, 48.48475, 48.4842, 48.48365, 48.4831, 48.48255, 48.482, 48.48145, 48.4809, 48.48035, 48.4798, 48.47925, 48.4787, 48.47815, 48.4776, 48.47705, 48.4765, 48.47595, 48.4754, 48.47485, 48.4743, 48.47375, 48.4732, 48.47265, 48.4721, 48.47155, 48.471, 48.47045, 48.4699, 48.46935, 48.4688, 48.46825, 48.4677, 48.46715, 48.4666, 48.46605, 48.4655, 48.46495, 48.4644, 48.46385, 48.4633, 48.46275, 48.4622, 48.46165, 48.4611, 48.46055, 48.46, 48.45945, 48.4589, 48.45835, 48.4578, 48.45725, 48.4567, 48.45615, 48.4556, 48.45505, 48.4545, 48.45395, 48.4534, 48.45285, 48.4523, 48.45175, 48.4512, 48.45065, 48.4501, 48.44955, 48.449, 48.44845, 48.4479, 48.44735, 48.4468, 48.44625, 48.4457, 48.44515, 48.4446, 48.44405, 48.4435, 48.44295, 48.4424, 48.44185, 48.4413, 48.44075, 48.4402, 48.43965, 48.4391, 48.43855, 48.438, 48.43745, 48.4369, 48.43635, 48.4358, 48.43525, 48.4347, 48.43415, 48.4336, 48.43305, 48.4325, 48.43195, 48.4314, 48.43085, 48.4303, 48.42975, 48.4292, 48.42865, 48.4281, 48.42755, 48.427, 48.42645, 48.4259, 48.42535, 48.4248, 48.42425, 48.4237, 48.42315, 48.4226, 48.42205, 48.4215, 48.42095, 48.4204, 48.41985, 48.4193, 48.41875, 48.4182, 48.41765, 48.4171, 48.41655, 48.416, 48.41545, 48.4149, 48.41435, 48.4138, 48.41325, 48.4127, 48.41215, 48.4116, 48.41105, 48.4105, 48.40995, 48.4094, 48.40885, 48.4083, 48.40775, 48.4072, 48.40665, 48.4061, 48.40555, 48.405, 48.40445, 48.4039, 48.40335, 48.4028, 48.40225, 48.4017, 48.40115, 48.4006, 48.40005, 48.3995, 48.39895, 48.3984, 48.39785, 48.3973, 48.39675, 48.3962, 48.39565, 48.3951, 48.39455, 48.394, 48.39345, 48.3929, 48.39235, 48.3918, 48.39125, 48.3907, 48.39015, 48.3896, 48.38905, 48.3885, 48.38795, 48.3874, 48.38685, 48.3863, 48.38575, 48.3852, 48.38465, 48.3841, 48.38355, 48.383, 48.38245, 48.3819, 48.38135, 48.3808, 48.38025, 48.3797, 48.37915, 48.3786, 48.37805, 48.3775, 48.37695, 48.3764, 48.37585, 48.3753, 48.37475, 48.3742, 48.37365, 48.3731, 48.37255, 48.372, 48.37145, 48.3709, 48.37035, 48.3698, 48.36925, 48.3687, 48.36815, 48.3676, 48.36705, 48.3665, 48.36595, 48.3654, 48.36485, 48.3643, 48.36375, 48.3632, 48.36265, 48.3621, 48.36155, 48.361, 48.36045, 48.3599, 48.35935, 48.3588, 48.35825, 48.3577, 48.35715, 48.3566, 48.35605, 48.3555, 48.35495, 48.3544, 48.35385, 48.3533, 48.35275, 48.3522, 48.35165, 48.3511, 48.35055, 48.35, 48.34945, 48.3489, 48.34835, 48.3478, 48.34725, 48.3467, 48.34615, 48.3456, 48.34505, 48.3445, 48.34395, 48.3434, 48.34285, 48.3423, 48.34175, 48.3412, 48.34065, 48.3401, 48.33955, 48.339, 48.33845, 48.3379, 48.33735, 48.3368, 48.33625, 48.3357, 48.33515, 48.3346, 48.33405, 48.3335, 48.33295, 48.3324, 48.33185, 48.3313, 48.33075, 48.3302, 48.32965, 48.3291, 48.32855, 48.328, 48.32745, 48.3269, 48.32635, 48.3258, 48.32525, 48.3247, 48.32415, 48.3236, 48.32305, 48.3225, 48.32195, 48.3214, 48.32085, 48.3203, 48.31975, 48.3192, 48.31865, 48.3181, 48.31755, 48.317, 48.31645, 48.3159, 48.31535, 48.3148, 48.31425, 48.3137, 48.31315, 48.3126, 48.31205, 48.3115, 48.31095, 48.3104, 48.30985, 48.3093, 48.30875, 48.3082, 48.30765, 48.3071, 48.30655, 48.306, 48.30545, 48.3049, 48.30435, 48.3038, 48.30325, 48.3027, 48.30215, 48.3016, 48.30105, 48.3005, 48.29995, 48.2994, 48.29885, 48.2983, 48.29775, 48.2972, 48.29665, 48.2961, 48.29555, 48.295, 48.29445, 48.2939, 48.29335, 48.2928, 48.29225, 48.2917, 48.29115, 48.2906, 48.29005, 48.2895, 48.28895, 48.2884, 48.28785, 48.2873, 48.28675, 48.2862, 48.28565, 48.2851, 48.28455, 48.284, 48.28345, 48.2829, 48.28235, 48.2818, 48.28125, 48.2807, 48.28015, 48.2796, 48.27905, 48.2785, 48.27795, 48.2774, 48.27685, 48.2763, 48.27575, 48.2752, 48.27465, 48.2741, 48.27355, 48.273, 48.27245, 48.2719, 48.27135, 48.2708, 48.27025, 48.2697, 48.26915, 48.2686, 48.26805, 48.2675, 48.26695, 48.2664, 48.26585, 48.2653, 48.26475, 48.2642, 48.26365, 48.2631, 48.26255, 48.262, 48.26145, 48.2609, 48.26035, 48.2598, 48.25925, 48.2587, 48.25815, 48.2576, 48.25705, 48.2565, 48.25595, 48.2554, 48.25485, 48.2543, 48.25375, 48.2532, 48.25265, 48.2521, 48.25155, 48.251, 48.25045, 48.2499, 48.24935, 48.2488, 48.24825, 48.2477, 48.24715, 48.2466, 48.24605, 48.2455, 48.24495, 48.2444, 48.24385, 48.2433, 48.24275, 48.2422, 48.24165, 48.2411, 48.24055, 48.24, 48.23945, 48.2389, 48.23835, 48.2378, 48.23725, 48.2367, 48.23615, 48.2356, 48.23505, 48.2345, 48.23395, 48.2334, 48.23285, 48.2323, 48.23175, 48.2312, 48.23065, 48.2301, 48.22955, 48.229, 48.22845, 48.2279, 48.22735, 48.2268, 48.22625, 48.2257, 48.22515, 48.2246, 48.22405, 48.2235, 48.22295, 48.2224, 48.22185, 48.2213, 48.22075, 48.2202, 48.21965, 48.2191, 48.21855, 48.218, 48.21745, 48.2169, 48.21635, 48.2158, 48.21525, 48.2147, 48.21415, 48.2136, 48.21305, 48.2125, 48.21195, 48.2114, 48.21085, 48.2103, 48.20975, 48.2092, 48.20865, 48.2081, 48.20755, 48.207, 48.20645, 48.2059, 48.20535, 48.2048, 48.20425, 48.2037, 48.20315, 48.2026, 48.20205, 48.2015, 48.20095, 48.2004, 48.19985, 48.1993, 48.19875, 48.1982, 48.19765, 48.1971, 48.19655, 48.196, 48.19545, 48.1949, 48.19435, 48.1938, 48.19325, 48.1927, 48.19215, 48.1916, 48.19105, 48.1905, 48.18995, 48.1894, 48.18885, 48.1883, 48.18775, 48.1872, 48.18665, 48.1861, 48.18555, 48.185, 48.18445, 48.1839, 48.18335, 48.1828, 48.18225, 48.1817, 48.18115, 48.1806, 48.18005, 48.1795, 48.17895, 48.1784, 48.17785, 48.1773, 48.17675, 48.1762, 48.17565, 48.1751, 48.17455, 48.174, 48.17345, 48.1729, 48.17235, 48.1718, 48.17125, 48.1707, 48.17015, 48.1696, 48.16905, 48.1685, 48.16795, 48.1674, 48.16685, 48.1663, 48.16575, 48.1652, 48.16465, 48.1641, 48.16355, 48.163, 48.16245, 48.1619, 48.16135, 48.1608, 48.16025, 48.1597, 48.15915, 48.1586, 48.15805, 48.1575, 48.15695, 48.1564, 48.15585, 48.1553, 48.15475, 48.1542, 48.15365, 48.1531, 48.15255, 48.152, 48.15145, 48.1509, 48.15035, 48.1498, 48.14925, 48.1487, 48.14815, 48.1476, 48.14705, 48.1465, 48.14595, 48.1454, 48.14485, 48.1443, 48.14375, 48.1432, 48.14265, 48.1421, 48.14155, 48.141, 48.14045, 48.1399, 48.13935, 48.1388, 48.13825, 48.1377, 48.13715, 48.1366, 48.13605, 48.1355, 48.13495, 48.1344, 48.13385, 48.1333, 48.13275, 48.1322, 48.13165, 48.1311, 48.13055, 48.13, 48.12945, 48.1289, 48.12835, 48.1278, 48.12725, 48.1267, 48.12615, 48.1256, 48.12505, 48.1245, 48.12395, 48.1234, 48.12285, 48.1223, 48.12175, 48.1212, 48.12065, 48.1201, 48.11955, 48.119, 48.11845, 48.1179, 48.11735, 48.1168, 48.11625, 48.1157, 48.11515, 48.1146, 48.11405, 48.1135, 48.11295, 48.1124, 48.11185, 48.1113, 48.11075, 48.1102, 48.10965, 48.1091, 48.10855, 48.108, 48.10745, 48.1069, 48.10635, 48.1058, 48.10525, 48.1047, 48.10415, 48.1036, 48.10305, 48.1025, 48.10195, 48.1014, 48.10085, 48.1003, 48.09975, 48.0992, 48.09865, 48.0981, 48.09755, 48.097, 48.09645, 48.0959, 48.09535, 48.0948, 48.09425, 48.0937, 48.09315, 48.0926, 48.09205, 48.0915, 48.09095, 48.0904, 48.08985, 48.0893, 48.08875, 48.0882, 48.08765, 48.0871, 48.08655, 48.086, 48.08545, 48.0849, 48.08435, 48.0838, 48.08325, 48.0827, 48.08215, 48.0816, 48.08105, 48.0805, 48.07995, 48.0794, 48.07885, 48.0783, 48.07775, 48.0772, 48.07665, 48.0761, 48.07555, 48.075, 48.07445, 48.0739, 48.07335, 48.0728, 48.07225, 48.0717, 48.07115, 48.0706, 48.07005, 48.0695, 48.06895, 48.0684, 48.06785, 48.0673, 48.06675, 48.0662, 48.06565, 48.0651, 48.06455, 48.064, 48.06345, 48.0629, 48.06235, 48.0618, 48.06125, 48.0607, 48.06015, 48.0596, 48.05905, 48.0585, 48.05795, 48.0574, 48.05685, 48.0563, 48.05575, 48.0552, 48.05465, 48.0541, 48.05355, 48.053, 48.05245, 48.0519, 48.05135, 48.0508, 48.05025, 48.0497, 48.04915, 48.0486, 48.04805, 48.0475, 48.04695, 48.0464, 48.04585, 48.0453, 48.04475, 48.0442, 48.04365, 48.0431, 48.04255, 48.042, 48.04145, 48.0409, 48.04035, 48.0398, 48.03925, 48.0387, 48.03815, 48.0376, 48.03705, 48.0365, 48.03595, 48.0354, 48.03485, 48.0343, 48.03375, 48.0332, 48.03265, 48.0321, 48.03155, 48.031, 48.03045, 48.0299, 48.02935, 48.0288, 48.02825, 48.0277, 48.02715, 48.0266, 48.02605, 48.0255, 48.02495, 48.0244, 48.02385, 48.0233, 48.02275, 48.0222, 48.02165, 48.0211, 48.02055, 48.02, 48.01945, 48.0189, 48.01835, 48.0178, 48.01725, 48.0167, 48.01615, 48.0156, 48.01505, 48.0145, 48.01395, 48.0134, 48.01285, 48.0123, 48.01175, 48.0112, 48.01065, 48.0101, 48.00955, 48.009, 48.00845, 48.0079, 48.00735, 48.0068, 48.00625, 48.0057, 48.00515, 48.0046, 48.00405, 48.0035, 48.00295, 48.0024, 48.00185, 48.0013, 48.00075, 48.0002, 47.99965, 47.9991, 47.99855, 47.998, 47.99745, 47.9969, 47.99635, 47.9958, 47.99525, 47.9947, 47.99415, 47.9936, 47.99305, 47.9925, 47.99195, 47.9914, 47.99085, 47.9903, 47.98975, 47.9892, 47.98865, 47.9881, 47.98755, 47.987, 47.98645, 47.9859, 47.98535, 47.9848, 47.98425, 47.9837, 47.98315, 47.9826, 47.98205, 47.9815, 47.98095, 47.9804, 47.97985, 47.9793, 47.97875, 47.9782, 47.97765, 47.9771, 47.97655, 47.976, 47.97545, 47.9749, 47.97435, 47.9738, 47.97325, 47.9727, 47.97215, 47.9716, 47.97105, 47.9705, 47.96995, 47.9694, 47.96885, 47.9683, 47.96775, 47.9672, 47.96665, 47.9661, 47.96555, 47.965, 47.96445, 47.9639, 47.96335, 47.9628, 47.96225, 47.9617, 47.96115, 47.9606, 47.96005, 47.9595, 47.95895, 47.9584, 47.95785, 47.9573, 47.95675, 47.9562, 47.95565, 47.9551, 47.95455, 47.954, 47.95345, 47.9529, 47.95235, 47.9518, 47.95125, 47.9507, 47.95015, 47.9496, 47.94905, 47.9485, 47.94795, 47.9474, 47.94685, 47.9463, 47.94575, 47.9452, 47.94465, 47.9441, 47.94355, 47.943, 47.94245, 47.9419, 47.94135, 47.9408, 47.94025, 47.9397, 47.93915, 47.9386, 47.93805, 47.9375, 47.93695, 47.9364, 47.93585, 47.9353, 47.93475, 47.9342, 47.93365, 47.9331, 47.93255, 47.932, 47.93145, 47.9309, 47.93035, 47.9298, 47.92925, 47.9287, 47.92815, 47.9276, 47.92705, 47.9265, 47.92595, 47.9254, 47.92485, 47.9243, 47.92375, 47.9232, 47.92265, 47.9221, 47.92155, 47.921, 47.92045, 47.9199, 47.91935, 47.9188, 47.91825, 47.9177, 47.91715, 47.9166, 47.91605, 47.9155, 47.91495, 47.9144, 47.91385, 47.9133, 47.91275, 47.9122, 47.91165, 47.9111, 47.91055, 47.91, 47.90945, 47.9089, 47.90835, 47.9078, 47.90725, 47.9067, 47.90615, 47.9056, 47.90505, 47.9045, 47.90395, 47.9034, 47.90285, 47.9023, 47.90175, 47.9012, 47.90065, 47.9001, 47.89955, 47.899, 47.89845, 47.8979, 47.89735, 47.8968, 47.89625, 47.8957, 47.89515, 47.8946, 47.89405, 47.8935, 47.89295, 47.8924, 47.89185, 47.8913, 47.89075, 47.8902, 47.88965, 47.8891, 47.88855, 47.888, 47.88745, 47.8869, 47.88635, 47.8858, 47.88525, 47.8847, 47.88415, 47.8836, 47.88305, 47.8825, 47.88195, 47.8814, 47.88085, 47.8803, 47.87975, 47.8792, 47.87865, 47.8781, 47.87755, 47.877, 47.87645, 47.8759, 47.87535, 47.8748, 47.87425, 47.8737, 47.87315, 47.8726, 47.87205, 47.8715, 47.87095, 47.8704, 47.86985, 47.8693, 47.86875, 47.8682, 47.86765, 47.8671, 47.86655, 47.866, 47.86545, 47.8649, 47.86435, 47.8638, 47.86325, 47.8627, 47.86215, 47.8616, 47.86105, 47.8605, 47.85995, 47.8594, 47.85885, 47.8583, 47.85775, 47.8572, 47.85665, 47.8561, 47.85555, 47.855, 47.85445, 47.8539, 47.85335, 47.8528, 47.85225, 47.8517, 47.85115, 47.8506, 47.85005, 47.8495, 47.84895, 47.8484, 47.84785, 47.8473, 47.84675, 47.8462, 47.84565, 47.8451, 47.84455, 47.844, 47.84345, 47.8429, 47.84235, 47.8418, 47.84125, 47.8407, 47.84015, 47.8396, 47.83905, 47.8385, 47.83795, 47.8374, 47.83685, 47.8363, 47.83575, 47.8352, 47.83465, 47.8341, 47.83355, 47.833, 47.83245, 47.8319, 47.83135, 47.8308, 47.83025, 47.8297, 47.82915, 47.8286, 47.82805, 47.8275, 47.82695, 47.8264, 47.82585, 47.8253, 47.82475, 47.8242, 47.82365, 47.8231, 47.82255, 47.822, 47.82145, 47.8209, 47.82035, 47.8198, 47.81925, 47.8187, 47.81815, 47.8176, 47.81705, 47.8165, 47.81595, 47.8154, 47.81485, 47.8143, 47.81375, 47.8132, 47.81265, 47.8121, 47.81155, 47.811, 47.81045, 47.8099, 47.80935, 47.8088, 47.80825, 47.8077, 47.80715, 47.8066, 47.80605, 47.8055, 47.80495, 47.8044, 47.80385, 47.8033, 47.80275, 47.8022, 47.80165, 47.8011, 47.80055, 47.8, 47.79945, 47.7989, 47.79835, 47.7978, 47.79725, 47.7967, 47.79615, 47.7956, 47.79505, 47.7945, 47.79395, 47.7934, 47.79285, 47.7923, 47.79175, 47.7912, 47.79065, 47.7901, 47.78955, 47.789, 47.78845, 47.7879, 47.78735, 47.7868, 47.78625, 47.7857, 47.78515, 47.7846, 47.78405, 47.7835, 47.78295, 47.7824, 47.78185, 47.7813, 47.78075, 47.7802, 47.77965, 47.7791, 47.77855, 47.778, 47.77745, 47.7769, 47.77635, 47.7758, 47.77525, 47.7747, 47.77415, 47.7736, 47.77305, 47.7725, 47.77195, 47.7714, 47.77085, 47.7703, 47.76975, 47.7692, 47.76865, 47.7681, 47.76755, 47.767, 47.76645, 47.7659, 47.76535, 47.7648, 47.76425, 47.7637, 47.76315, 47.7626, 47.76205, 47.7615, 47.76095, 47.7604, 47.75985, 47.7593, 47.75875, 47.7582, 47.75765, 47.7571, 47.75655, 47.756, 47.75545, 47.7549, 47.75435, 47.7538, 47.75325, 47.7527, 47.75215, 47.7516, 47.75105, 47.7505, 47.74995, 47.7494, 47.74885, 47.7483, 47.74775, 47.7472, 47.74665, 47.7461, 47.74555, 47.745, 47.74445, 47.7439, 47.74335, 47.7428, 47.74225, 47.7417, 47.74115, 47.7406, 47.74005, 47.7395, 47.73895, 47.7384, 47.73785, 47.7373, 47.73675, 47.7362, 47.73565, 47.7351, 47.73455, 47.734, 47.73345, 47.7329, 47.73235, 47.7318, 47.73125, 47.7307, 47.73015, 47.7296, 47.72905, 47.7285, 47.72795, 47.7274, 47.72685, 47.7263, 47.72575, 47.7252, 47.72465, 47.7241, 47.72355, 47.723, 47.72245, 47.7219, 47.72135, 47.7208, 47.72025, 47.7197, 47.71915, 47.7186, 47.71805, 47.7175, 47.71695, 47.7164, 47.71585, 47.7153, 47.71475, 47.7142, 47.71365, 47.7131, 47.71255, 47.712, 47.71145, 47.7109, 47.71035, 47.7098, 47.70925, 47.7087, 47.70815, 47.7076, 47.70705, 47.7065, 47.70595, 47.7054, 47.70485, 47.7043, 47.70375, 47.7032, 47.70265, 47.7021, 47.70155, 47.701, 47.70045, 47.6999, 47.69935, 47.6988, 47.69825, 47.6977, 47.69715, 47.6966, 47.69605, 47.6955, 47.69495, 47.6944, 47.69385, 47.6933, 47.69275, 47.6922, 47.69165, 47.6911, 47.69055, 47.69, 47.68945, 47.6889, 47.68835, 47.6878, 47.68725, 47.6867, 47.68615, 47.6856, 47.68505, 47.6845, 47.68395, 47.6834, 47.68285, 47.6823, 47.68175, 47.6812, 47.68065, 47.6801, 47.67955, 47.679, 47.67845, 47.6779, 47.67735, 47.6768, 47.67625, 47.6757, 47.67515, 47.6746, 47.67405, 47.6735, 47.67295, 47.6724, 47.67185, 47.6713, 47.67075, 47.6702, 47.66965, 47.6691, 47.66855, -22.545, -22.545]],
        [0.08],
        [0.7],
        [[0.0, 0.0001, 0.005, 0.006, 0.001, 0.05, 0.06, 0.01, 0.2, 0.21, 0.01, 2.1, 2.101, 0.001, 2.7, 2.75, 0.05, 5.0]],
        [0.0],
        [10.0],
        [0.0],
        [0.1],
        [0.0002],
        [4],
        [4],
    ]
    aSTEAM.data_analysis.AnalysisStepSequence.append(current_step)


    if verbose:
        print(f'Step "{current_step}" added to the STEAM analysis')
        toc()

    return
