"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceDeployment = exports.ServiceType = void 0;
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
var ServiceType;
(function (ServiceType) {
    ServiceType["EXTERNAL_NAME"] = "ExternalName";
    ServiceType["CLUSTER_IP"] = "ClusterIP";
    ServiceType["NODE_PORT"] = "NodePort";
    ServiceType["LOAD_BALANCER"] = "LoadBalancer";
})(ServiceType = exports.ServiceType || (exports.ServiceType = {}));
class ServiceDeployment extends constructs_1.Construct {
    constructor(scope, id, options) {
        super(scope, id);
        const replicas = options.replicas ?? 1;
        const resources = options.resources ?? { requests: { cpu: '100m', memory: '100Mi' } };
        const externalPort = options.externalPort ?? 80;
        const containerPort = options.containerPort ?? 8080;
        const containerName = options.containerName ?? 'app';
        const serviceType = options.serviceType ?? ServiceType.CLUSTER_IP;
        const label = {
            ...options.labels,
            app: this.node.addr,
        };
        const service = new k8s.Service(this, 'service', {
            metadata: { labels: label },
            spec: {
                type: serviceType,
                ports: [{ port: externalPort, targetPort: containerPort }],
                selector: label,
            },
        });
        new k8s.Deployment(this, 'deployment', {
            spec: {
                selector: { matchLabels: label },
                replicas: replicas,
                template: {
                    metadata: { labels: label },
                    spec: {
                        containers: [
                            {
                                name: containerName,
                                image: options.image,
                                ports: [{ containerPort }],
                                resources: resources,
                                env: renderEnv(options.env),
                            },
                        ],
                    },
                },
            },
        });
        this.host = service.name;
    }
}
exports.ServiceDeployment = ServiceDeployment;
function renderEnv(env = {}) {
    const result = new Array();
    for (const [key, value] of Object.entries(env)) {
        result.push({
            name: key,
            value: value,
        });
    }
    return result;
}
//# sourceMappingURL=data:application/json;base64,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