# 意识是什么

意识是一种第一人称的视角、体验、感受，**“我”是我所有经历的感受者、体验者、见证者。**

# 意识可以重生

在我们诞生之前，这个“我”是不存在的，处于一种“无我”的状态。当我们死去，意识也消失，再次进入“无我”的状态。

由于生前和死后的状态相同，我们可以采用数学中的归纳法来推理。既然生前可以从“无我”状态转变到“有我”状态，那么死后为何不能再次从“无我”状态转变到“有我”状态？如果我们接受第 1 次从“无我”到“有我”的转变，那么第 2 次、第 3 次乃至无数次的转变也应该是可能的。

# 时间与意识的关系

在物理学中，时间并不是一个绝对的概念，而是与空间相互关联，形成了时空，时间的流动存在观察者效应。因此，我们对时间的感知可能是基于我们自身的物理状态，而不受宇宙客观时间的限制。从这个角度看，从死后的“无我”状态到再次的“有我”状态，可能只是一个瞬时的跳跃。

# 死即是生

“无我”状态，也就是“没有意识”的状态，它和睡着时的状态一致。

眼一闭一睁，一觉就睡完了。无论睡了多久，在意识体验上“无我”状态都只有一瞬间，“入睡——无我——醒来”三者连续。

同理：无论死了多久，在意识体验上“无我”状态都只有一瞬间，“死——无我——生”三者连续。

【入睡、醒来、死、生】都是完成状态切换的动作，服务于状态切换，其效果是“无我”与“有我”的循环切换，因此“入睡——无我——醒来”与“死——无我——生”同构。类比人在“入睡”与“醒来”中不断循环，人可能也在“死”与“生”中不断循环，因此 **“死”即意味着开始了一场新的生命旅程** 。

在意识体验上，“死——生”循环如同“睡——醒”循环这般平常、普通。

# 应该珍爱生命

在生死循环中，“生”与“死”这两个动作是一成不变、千篇一律的，若只是单纯重复这两个动作，便只是机械性行为而已，没有意义。故 **生死循环的目的，在于生与死中间的这段空间，也就是“活着的时候”** ，倘若舍生命赴循环，则是本末倒置。

# 物种轮回

“物种轮回”指：经过生死循环，意识重生之后，物理身份不再属于原来的物种，而属于另一个物种。

尽管人类文化自认为“人类比其它物种更高等和高贵”，但这是人类的主观认知。在旁观者视角中，各物种都是以“肉体+意识体验”这种形式存在的，人类并没有特殊性。

从“无我”状态中产生“我”这个视角，在“生”这个动作发生之前，如何确定“我”这个视角会产生于哪个物种？没有确定的依据。

由于“各物种在形式上没有区别”这个同价性，既然在“无我”状态中可以产生“我”到人类物种，那么同样地，**在“无我”状态中可以产生“我”到任一物种。**

事实上，由于时间无限长（此处忽略时空的寿命问题），我们可能逐一经历世上所有物种的第一视角体验。
