# 项目描述

一个符合直觉的索引和切片语法。

|                                        | **Python**                                                           | Rslice                                                                     |
| -------------------------------------- | -------------------------------------------------------------------------- | -------------------------------------------------------------------------- |
| **索引**                         | 从 0 开始（0 表示第 1 个元素）<br /><br />-1 表示倒数第 1 个元素（相同点） | 从 1 开始（1 表示第 1 个元素）<br /><br />-1 表示倒数第 1 个元素（相同点） |
| **切片**                         | 左闭右开区间，例如：<br />[3: 5] 表示提取第 4、5 这 2 个元素               | 双闭区间，例如：<br />[3: 5] 表示提取第 3、4、5 这 3 个元素                |
| **从右往**<br />**左切片** | step（步长）为负值，例如：<br />[9: 1: -1] 表示提取第 9~3 这 7 个元素      | step（步长）始终为正值，例如：<br />[9: 1: 1] 表示提取第 9~1 这 9 个元素   |

切片格式为  [start: stop: step]  ，start 表示从哪条开始，stop 表示到哪条停止，step 表示步长。当  step>=2  时表示间隔式切片。

# 安装

```
pip install arts
```

# 导入

```python
from arts.cooltypes import Rslice
```

# 创建R风格容器

```python
obj = Rslice([1,2,3,4,5,6,7,8,9])
```

Python中任何可以索引和切片的对象（如list、str、tuple）都可以转化成R风格容器。

# 切片语法

切片格式为  [start: stop: step]  ，start表示从哪条开始，stop表示到哪条停止，step表示步长。

取值时，当  step>=2  时表示间隔式取值。

赋值时，step值无效。

| **索引和切片** | **（取值时）获取的元素** | **（赋值时）置换的元素** |
| -------------------- | ------------------------------ | ------------------------------ |
| [ : ]                | 全部                           | 全部                           |
| [ 1 ]                | 第1个                          | 第1个                          |
| [ -1 ]               | 倒数第1个                      | 倒数第1个                      |
| [ 3: 7 ]             | 第3~7个                        | 第3~7个                        |
| [ 7: 3 ]             | 第7~3个                        | 第3~7个                        |
| [ 3: ]               | 第3个~最后1个                  | 第3个~最后1个                  |
| [ : 7 ]              | 第1~7个                        | 第1~7个                        |
| [ 3: 7: 2 ]          | 第3、5、7个                    | 第3~7个                        |
| [ 3: 8: 2 ]          | 第3、5、7个                    | 第3~8个                        |
| [ 7: 3: 2 ]          | 第7、5、3个                    | 第3~7个                        |
| [ 8: 3: 2 ]          | 第8、6、4个                    | 第3~8个                        |

值得注意的地方：

1、取值时，  [ 3: 8: 2 ]  获取第  3、5、7  个，而  [ 8: 3: 2 ]  获取第  8、6、4  个。

2、赋值时，  [ 3: 8: 2 ]  和  [ 8: 3: 2 ]  都置换第  3~8  个。

# 索引取值

```python
obj[1]  # 获取第1个值
# >>> 1

obj[-1]  # 获取倒数第1个值
# >>> 9
```

# 索引赋值

```python
obj[1] = 111
obj[:]
# >>> [111, 2, 3, 4, 5, 6, 7, 8, 9]
```

# 正向切片

| 代码          | 结果                          |
| ------------- | ----------------------------- |
| obj[ : ]      | [111, 2, 3, 4, 5, 6, 7, 8, 9] |
| obj[ 1: 9 ]   | [111, 2, 3, 4, 5, 6, 7, 8, 9] |
| obj[ 1: -1 ]  | [111, 2, 3, 4, 5, 6, 7, 8, 9] |
| obj[ -9: -1 ] | [111, 2, 3, 4, 5, 6, 7, 8, 9] |
| obj[ : 9 ]    | [111, 2, 3, 4, 5, 6, 7, 8, 9] |
| obj[ 3: 7 ]   | [3, 4, 5, 6, 7]               |
| obj[ 3: -3 ]  | [3, 4, 5, 6, 7]               |
| obj[ -7: -3 ] | [3, 4, 5, 6, 7]               |
| obj[ 5: 5 ]   | [5]                           |
| obj[ 5: -5 ]  | [5]                           |
| obj[ -5: -5 ] | [5]                           |

# 逆向切片

| 代码          | 结果                          |
| ------------- | ----------------------------- |
| obj[ 9: 1 ]   | [9, 8, 7, 6, 5, 4, 3, 2, 111] |
| obj[ -1: 1 ]  | [9, 8, 7, 6, 5, 4, 3, 2, 111] |
| obj[ -1: -9 ] | [9, 8, 7, 6, 5, 4, 3, 2, 111] |
| obj[ 7: 3 ]   | [7, 6, 5, 4, 3]               |
| obj[ -3: 3 ]  | [7, 6, 5, 4, 3]               |
| obj[ -3: -7 ] | [7, 6, 5, 4, 3]               |

# 正向跳跃切片

| 代码             | 结果              |
| ---------------- | ----------------- |
| obj[ : : 2 ]     | [111, 3, 5, 7, 9] |
| obj[ 1: 9: 2 ]   | [111, 3, 5, 7, 9] |
| obj[ -9: 9: 2 ]  | [111, 3, 5, 7, 9] |
| obj[ 3: 7: 2 ]   | [3, 5, 7]         |
| obj[ 3: -3: 2 ]  | [3, 5, 7]         |
| obj[ -7: -3: 2 ] | [3, 5, 7]         |

# 逆向跳跃切片

| 代码             | 结果              |
| ---------------- | ----------------- |
| obj[ 9: 1: 2 ]   | [9, 7, 5, 3, 111] |
| obj[ -1: 1: 2 ]  | [9, 7, 5, 3, 111] |
| obj[ -1: -9: 2 ] | [9, 7, 5, 3, 111] |
| obj[ 8: 2: 3 ]   | [8, 5, 2]         |
| obj[ -2: 2: 3 ]  | [8, 5, 2]         |
| obj[ -2: -8: 3 ] | [8, 5, 2]         |

# 切片赋值

```python
obj = Rslice([111, 2, 3, 44, 55, 7, 8, 9])

obj[4:6] = []
obj[:]
# >>> [111, 2, 3, 8, 9]

obj[4:] = [1, 2, 3, 4, 5]
obj[:]
# >>> [111, 2, 3, 1, 2, 3, 4, 5]

obj[4:100] = ['1', 2, 3, 4, 5]
obj[:]
# >>> [111, 2, 3, '1', 2, 3, 4, 5]

obj[4:] = []
obj[:]
# >>> [111, 2, 3]

obj[:] = [1, 2, 3, 4, 5, 6, 7, 8, 9]
obj[:]
# >>> [1, 2, 3, 4, 5, 6, 7, 8, 9]

obj[:3] = ['0-3']
obj[:]
# >>> ['0-3', 4, 5, 6, 7, 8, 9]

obj[3:1] = ['一', '二', '三']
obj[:]
# >>> ['一', '二', '三', 6, 7, 8, 9]
```
