import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as rds from '@aws-cdk/aws-rds';
import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface KeyCloadProps {
    /**
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
}
/**
 * @stability stable
 */
export declare class KeyCloak extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly db?: Database;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props?: KeyCloadProps);
    /**
     * @stability stable
     */
    addDatabase(): Database;
    /**
     * @stability stable
     */
    addKeyCloakContainerService(props: ContainerServiceProps): ContainerService;
    private _generateKeycloakSecret;
}
/**
 * @stability stable
 */
export interface DatabaseProps {
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * @stability stable
     */
    readonly engine?: rds.IClusterEngine;
    /**
     * database user name.
     *
     * @default admin
     * @stability stable
     */
    readonly databaseUsername?: string;
}
/**
 * @stability stable
 */
export declare class Database extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly dbcluster: rds.DatabaseCluster;
    /**
     * @stability stable
     */
    readonly databaseUsername: string;
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly clusterEndpointHostname: string;
    /**
     * @stability stable
     */
    readonly clusterReadEndpointHostname: string;
    /**
     * @stability stable
     */
    readonly clusterIdentifier: string;
    /**
     * @stability stable
     */
    readonly secret: secretsmanager.ISecret;
    private readonly _autoraListenerPort;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: DatabaseProps);
}
/**
 * @stability stable
 */
export interface ContainerServiceProps {
    /**
     * @stability stable
     */
    readonly vpc: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly dbHost: string;
    /**
     * @stability stable
     */
    readonly dbUser: string;
    /**
     * @stability stable
     */
    readonly dbSecret: secretsmanager.ISecret;
    /**
     * @stability stable
     */
    readonly keycloakSecret: secretsmanager.ISecret;
}
/**
 * @stability stable
 */
export declare class ContainerService extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly service: ecs.FargateService;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: ContainerServiceProps);
}
