from typing import List

from torch.utils.data import Dataset


class BaseDataset(Dataset):
    """Dataset Template Class"""

    def __init__(self) -> None:
        super().__init__()

    def info(self) -> str:
        """Dataset related information"""
        raise NotImplementedError

    def keys(self) -> List[str]:
        """What the dataset contains"""
        raise NotImplementedError

    def meta(self) -> dict:
        """data that can be obtained quickly"""
        raise NotImplementedError

    def __len__(self) -> int:
        raise NotImplementedError

    def __getitem__(self, index: int) -> dict:
        raise NotImplementedError
