import os
import os.path as osp
import shutil

def _make_file(filename: str) -> None:
    with open(filename, "w") as fw:
        fw.write("")

def _make_folder(folder: str) -> None:
    os.makedirs(folder, exist_ok=True)

def make_project() -> None:
    _make_folder("configs/template")
    _make_folder("lib/datasets")
    _make_folder("lib/models")
    _make_folder("lib/utils")
    _make_folder("exps/template")
    _make_folder("logs")
    _make_folder("docs")
    _make_folder("data")
    _make_folder("tests")
    _make_folder("tools")
    _make_folder("examples")

    src = osp.join(osp.dirname(__file__), "template.yaml")
    dst = "configs/template/template.yaml"
    shutil.copy(src, dst)
    with open("exps/template/pipeline.py", "w") as fw:
        fw.write("""import torch
import torch.nn as nn
from human_cver.trainer import BasePipeline

class Pipeline(BasePipeline):
    def __init__(self):
        super().__init__()
    
    def forward(self, x):
        pass

    def run_train(self, batch):
        # TODO
        return total_loss, loss_dict, None
    
    def run_validation(self, batch):
        # TODO
        return total_loss, loss_dict, None
        """)

    _make_file("lib/datasets/__init__.py")
    _make_file("lib/models/__init__.py")
    _make_file("lib/utils/__init__.py")
    _make_file("tools/demo.py")
    _make_file("requirements.txt")
    _make_file("docs/model.dio")
    _make_file("docs/pipeline.km")



    with open("rsnyc.py", "w") as fw:
        fw.write("""import os
import os.path as osp
from human_cver.tools.rsync import rsnyc_hust_hpc, rsync_local

def rsnyc(src: str, dst: str):
    rsnyc_hust_hpc(
        src,
        dst,
        ip="202.114.0.141",
        port=20405,
        user="ud201980970",
        password="lwk960718gln",
        exclude=["*.pyc"],
    )

def upload_folder(name):
    rsnyc(f"{name}/", f"/home/ud201980970/???/{name}/")


def download_folder(name):
    rsnyc(f"/home/ud201980970//???/{name}/", f"{name}/")


def upload_file(filename):
    rsnyc(filename, osp.join("/home/ud201980970/???", filename))

""")

    with open(".pylintrc", "w") as fw:
        fw.write("""[MASTER]
extension-pkg-whitelist=numpy,torch

[TYPECHECK]
ignored-modules=numpy,torch
ignored-classes=numpy,torch
""")

