-- MySQL dump 10.13  Distrib 5.7.26, for macos10.14 (x86_64)
--
-- Host: localhost    Database: marshall
-- ------------------------------------------------------
-- Server version	5.7.26

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `transientBucket`
--

DROP TABLE IF EXISTS `transientBucket`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transientBucket` (
  `primaryKeyId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'The primary key for this table',
  `transientBucketId` bigint(20) NOT NULL COMMENT 'This is set to the primaryKeyId of the **first** entry of this object into the database (i.e. earliest dateCreated)',
  `masterIDFlag` int(11) NOT NULL DEFAULT '0' COMMENT 'If this flag is set (=1) then the transient is assigned this name as it''s master ID. If not set (=0) then there is another entry in this table where the master ID has been set.',
  `name` varchar(40) NOT NULL COMMENT 'the name of the transient given by the reporting survey.',
  `survey` varchar(45) DEFAULT 'unknown' COMMENT 'the survey reporting observation of this transient',
  `raDeg` double DEFAULT NULL COMMENT 'RA is decimal degreed',
  `decDeg` double DEFAULT NULL COMMENT 'DEC in decimal degrees',
  `raDegErr` double DEFAULT NULL,
  `decDegErr` double DEFAULT NULL,
  `observationDate` datetime DEFAULT NULL COMMENT 'the survey observation date',
  `observationMJD` double DEFAULT NULL COMMENT 'the survey observation MJD',
  `magnitude` float DEFAULT NULL COMMENT 'the survey discovery magnitude',
  `magnitudeError` float DEFAULT NULL,
  `filter` varchar(20) DEFAULT NULL COMMENT 'survey discovery filter',
  `transientRedshift` float DEFAULT NULL COMMENT 'redshift as measured from a spectrum of the transient',
  `transientRedshiftNotes` varchar(40) DEFAULT NULL COMMENT 'transient redshift notes',
  `spectralType` varchar(100) DEFAULT NULL COMMENT 'the spectral classification given by the reporting survey (if any)',
  `discoveryPhase` varchar(20) DEFAULT NULL COMMENT 'the discovery phase given by the reporting survey (if any)',
  `dateCreated` datetime DEFAULT CURRENT_TIMESTAMP,
  `dateLastModified` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `surveyObjectUrl` varchar(400) DEFAULT NULL COMMENT 'the url for dedicated webpage of transients supplied by the reporting survey (if any)',
  `transientTypePrediction` varchar(40) DEFAULT NULL COMMENT 'an attempt at predicting the transient type by the reporting survey.',
  `transientTypePredicationSource` varchar(40) DEFAULT NULL COMMENT 'the name of the source/catalogue that was used to predict the transient type',
  `hostRedshift` float DEFAULT NULL COMMENT 'redshift measure for the host',
  `hostRedshiftType` varchar(10) DEFAULT NULL COMMENT 'type of redshift measure for the host galaxy\n',
  `referenceImageUrl` varchar(500) DEFAULT NULL COMMENT 'true or false',
  `targetImageUrl` varchar(500) DEFAULT NULL COMMENT 'true or false',
  `subtractedImageUrl` varchar(500) DEFAULT NULL,
  `tripletImageUrl` varchar(500) DEFAULT NULL,
  `htm16ID` bigint(20) unsigned DEFAULT NULL COMMENT 'HTM Level 16',
  `telescope` varchar(100) DEFAULT NULL,
  `instrument` varchar(100) DEFAULT NULL,
  `reducer` varchar(100) DEFAULT NULL,
  `lastNonDetectionDate` datetime DEFAULT NULL,
  `lastNonDetectionMJD` double DEFAULT NULL,
  `dateLastRead` datetime DEFAULT NULL,
  `finderImageUrl` varchar(450) DEFAULT NULL,
  `lightcurveURL` varchar(450) DEFAULT NULL,
  `classificationWRTMax` varchar(45) DEFAULT NULL,
  `classificationPhase` int(11) DEFAULT NULL,
  `limitingMag` tinyint(4) DEFAULT '0',
  `sherlockClassification` varchar(200) DEFAULT NULL,
  `tmpFlag` int(11) DEFAULT NULL,
  `replacedByRowId` bigint(20) DEFAULT '0',
  `dateDeleted` datetime DEFAULT NULL,
  `updated` tinyint(4) DEFAULT '0',
  `htm13ID` int(11) DEFAULT NULL,
  `htm10ID` int(11) DEFAULT NULL,
  `cz` double DEFAULT NULL,
  `cx` double DEFAULT NULL,
  `htm20ID` bigint(20) DEFAULT NULL,
  `cy` double DEFAULT NULL,
  PRIMARY KEY (`primaryKeyId`) KEY_BLOCK_SIZE=1024,
  UNIQUE KEY `primaryKey_UNIQUE` (`primaryKeyId`) KEY_BLOCK_SIZE=1024,
  UNIQUE KEY `name_observationmjd_magnitude_filter_survey` (`name`,`observationMJD`,`magnitude`,`filter`,`survey`,`replacedByRowId`) KEY_BLOCK_SIZE=1024,
  UNIQUE KEY `name_observationmjd_magnitude_filter` (`name`,`observationMJD`,`magnitude`,`filter`,`replacedByRowId`),
  UNIQUE KEY `name_survey_obsmjd_decDeg_classification` (`name`,`survey`,`decDeg`,`observationMJD`,`replacedByRowId`,`spectralType`) KEY_BLOCK_SIZE=1024,
  KEY `idx_htm16ID` (`htm16ID`) KEY_BLOCK_SIZE=1024,
  KEY `idx_name` (`name`) KEY_BLOCK_SIZE=1024,
  KEY `tbi` (`transientBucketId`),
  KEY `masterflag` (`masterIDFlag`),
  KEY `idx_htm10ID` (`htm13ID`),
  KEY `idx_htm13ID` (`htm13ID`),
  KEY `idx_transientBucketId` (`transientBucketId`),
  KEY `idx_replacedByRowId` (`replacedByRowId`),
  KEY `idx_sherlockClassifcaition` (`sherlockClassification`),
  KEY `idx_magnitude` (`magnitude`),
  KEY `idx_htm20ID` (`htm20ID`),
  KEY `idx_dateLastModified` (`dateLastModified`),
  KEY `idx_observationmjd` (`observationMJD`),
  KEY `idx_observationDate` (`observationDate`),
  KEY `idx_surveyObjectUrl` (`surveyObjectUrl`),
  KEY `idx_dateCreated` (`dateCreated`),
  KEY `idx_replace_master` (`replacedByRowId`,`masterIDFlag`),
  FULLTEXT KEY `fulltext` (`name`,`survey`,`surveyObjectUrl`),
  FULLTEXT KEY `fulltext_name_survey_surveyObjectUrl` (`name`,`survey`,`surveyObjectUrl`),
  FULLTEXT KEY `fulltext_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=42027450 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPRESSED KEY_BLOCK_SIZE=8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transientBucket`
--
-- WHERE:  1 limit 10000

LOCK TABLES `transientBucket` WRITE;
/*!40000 ALTER TABLE `transientBucket` DISABLE KEYS */;
INSERT INTO `transientBucket` VALUES (1,48203,1,'LSQ13cho','LSQ',358.356708333,-6.45577777777778,NULL,NULL,'2012-07-07 11:18:33',56115.42955,18.6996,0.2048,'gr-LSQ',NULL,NULL,'IIb',NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_history.html','sne',NULL,NULL,NULL,NULL,'https://f87e10c6-a-05bac853-s-sites.googlegroups.com/a/pessto.org/wiki/pessto-wiki/home/finder-chart-repo/PSNJ13124116p1236018_fc.png',NULL,'https://f87e10c6-a-05bac853-s-sites.googlegroups.com/a/pessto.org/wiki/pessto-wiki/home/finder-chart-repo/PSNJ13124116p1236018_fc.png?attachauth=ANoY7crcR6M5pLKEFfk_hAsSAia3UJtRY1MsQe6f0oZBcpimNCcDM0mQQffRQ30AHs941uUlRh6fEzPT_cbmz8DrAclJD8v7NcP8aPvr6pd-1_sCfnd_oLNITBH2TkaiI_jEtg_FOn8kgL8W-ECV4FCmVHU3p-WJxHs3SULnezSEAlLWuZDda7uBitnZuHXnFvqnHWA9njNgjPDh7D5PVMSxFf1lLvUULPU0fFkBZG6H87Jbo2Dd0kc9_jv11Yb_VNtnPJVqPuKz6-CwbKbHXotwSgfxWT8FZw%3D%3D',49431272838,NULL,NULL,NULL,'2011-12-21 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,772363638,12068181,NULL,NULL,NULL,NULL),(2,48203,0,'LSQ12dlc','LSQ',36.8000416666667,-6.45563888888889,NULL,NULL,'2012-07-09 09:11:22',56117.3412299999,19.0466,0.1169,'gr-LSQ',NULL,NULL,'II',NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_history.html','sne',NULL,NULL,NULL,NULL,'http://www.das.uchile.cl/~gpignata/pessto/PSNJ08070669-2803101.gif',NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_snap_42931.gif',34941112030,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,545954875,8530544,NULL,NULL,NULL,NULL),(3,48203,0,'LSQ12dlc','LSQ',36.8,-50.5980833333333,NULL,NULL,'2012-07-09 10:28:01',56117.3944600001,19.2612,0.0897,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_history.html','sne',NULL,NULL,NULL,NULL,'http://cador.obs-hp.fr/sn_tarot/PSN_J06161835-2122329/NGC2207_20130301b.png',NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_snap_42932.gif',38190280452,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,596723132,9323798,NULL,NULL,NULL,NULL),(4,48203,0,'LSQ12dlc','LSQ',36.7999583333333,-6.45566666666667,NULL,NULL,'2012-07-11 10:46:54',56119.4075799999,18.3799,0.0864,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_snap_43084.gif',34941112030,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,545954875,8530544,NULL,NULL,NULL,NULL),(5,48203,0,'LSQ12dlc','LSQ',36.800125,-6.45577777777778,NULL,NULL,'2012-07-11 11:14:14',56119.4265600001,19.028,0.106,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_snap_43085.gif',34941112030,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,545954875,8530544,NULL,NULL,NULL,NULL),(6,48203,0,'LSQ12dlc','LSQ',36.8000416666667,-6.45566666666667,NULL,NULL,'2012-07-15 11:15:12',56123.42723,19.5923,0.0647,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_snap_43539.gif',34941112030,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,545954875,8530544,NULL,NULL,NULL,NULL),(7,48203,0,'LSQ12dlc','LSQ',36.8,-6.45563888888889,NULL,NULL,'2012-07-15 11:33:55',56123.4402200002,19.4087,0.0941,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_snap_43540.gif',34941112030,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,545954875,8530544,NULL,NULL,NULL,NULL),(8,48203,0,'LSQ12dlc','LSQ',36.7999583333333,-6.45558333333333,NULL,NULL,'2012-07-17 09:48:44',56125.3671800001,19.3993,0.091,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_snap_43889.gif',34941112030,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,545954875,8530544,NULL,NULL,NULL,NULL),(9,48203,0,'LSQ12dlc','LSQ',36.7999583333333,-6.45563888888889,NULL,NULL,'2012-07-17 11:21:38',56125.4317000001,19.2419,0.0877,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_snap_43890.gif',34941112030,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,545954875,8530544,NULL,NULL,NULL,NULL),(10,48203,0,'LSQ12dlc','LSQ',36.7999583333333,-50.598083333,NULL,NULL,'2012-07-23 08:29:03',56131.3118500002,18.7236,0.142,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_snap_45274.gif',38190280452,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,596723132,9323798,NULL,NULL,NULL,NULL),(11,48203,0,'LSQ12dlc','LSQ',36.8000416666667,-50.5980833333333,NULL,NULL,'2012-07-23 10:02:36',56131.3768099998,19.4502,0.1976,'gr-LSQ',NULL,NULL,'II',NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_snap_45275.gif',38190280452,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,596723132,9323798,NULL,NULL,NULL,NULL),(12,48203,0,'LSQ12dlc','LSQ',36.8,-6.45566666666667,NULL,NULL,'2012-07-25 08:50:32',56133.3267600001,19.5774,0.0803,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_snap_45809.gif',34941112030,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,545954875,8530544,NULL,NULL,NULL,NULL),(13,48203,0,'LSQ12dlc','LSQ',36.8000416666667,-6.45569444444444,NULL,NULL,'2012-07-25 10:12:50',56133.3839199999,19.4406,0.0946,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_snap_45810.gif',34941112030,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,545954875,8530544,NULL,NULL,NULL,NULL),(14,48203,0,'LSQ12dlc','LSQ',36.8,-6.45563888888889,NULL,NULL,'2012-07-27 08:03:51',56135.2943500001,18.749,0.0862,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_snap_46293.gif',34941112030,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,545954875,8530544,NULL,NULL,NULL,NULL),(15,48203,0,'LSQ12dlc','LSQ',36.7999583333333,-6.45561111111111,NULL,NULL,'2012-07-29 08:08:47',56137.2977700001,19.287,0.1554,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_snap_47236.gif',34941112030,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,545954875,8530544,NULL,NULL,NULL,NULL),(16,48203,0,'LSQ12dlc','LSQ',36.8000416666667,-6.45561111111111,NULL,NULL,'2012-07-29 11:12:49',56137.42557,19.361,0.0951,'gr-LSQ',NULL,NULL,'Ib/c',NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlc/LSQ12dlc_snap_47237.gif',34941112030,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,545954875,8530544,NULL,NULL,NULL,NULL),(17,17,1,'LSQ12dkp','LSQ',30.1440416666667,-0.500972222222222,NULL,NULL,'2012-07-09 08:53:23',56117.3287499999,21.027,0.114,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkp/LSQ12dkp_history.html','sne',NULL,0.117,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkp/LSQ12dkp_snap_42905.gif',35004557700,NULL,NULL,NULL,'2012-01-04 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,546946214,8546034,NULL,NULL,NULL,NULL),(18,17,0,'LSQ12dkp','LSQ',30.1440416666667,-0.500944444444444,NULL,NULL,'2012-07-09 10:21:15',56117.3897600002,20.7617,0.1176,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkp/LSQ12dkp_history.html','sne',NULL,0.117,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkp/LSQ12dkp_snap_42906.gif',35004557700,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,546946214,8546034,NULL,NULL,NULL,NULL),(19,17,0,'LSQ12dkp','LSQ',30.1440416666667,-0.500916666666667,NULL,NULL,'2012-07-27 08:47:54',56135.3249400002,21.9312,0.2097,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkp/LSQ12dkp_history.html','sne',NULL,0.117,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkp/LSQ12dkp_snap_46278.gif',35004557700,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,546946214,8546034,NULL,NULL,NULL,NULL),(20,17,0,'LSQ12dkp','LSQ',30.144125,-0.500916666666667,NULL,NULL,'2012-07-27 10:11:38',56135.3830900001,21.6159,0.1686,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkp/LSQ12dkp_history.html','sne',NULL,0.117,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkp/LSQ12dkp_snap_46279.gif',35004557700,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,546946214,8546034,NULL,NULL,NULL,NULL),(21,21,1,'LSQ12dkj','LSQ',240.155291666667,-2.56011111111111,NULL,NULL,'2012-07-09 01:32:04',56117.0222800002,19.5949,0.1093,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkj/LSQ12dkj_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkj/LSQ12dkj_snap_42893.gif',45529877078,NULL,NULL,NULL,'2012-07-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,711404329,11115692,NULL,NULL,NULL,NULL),(22,21,0,'LSQ12dkj','LSQ',240.155291666667,-2.56013888888889,NULL,NULL,'2012-07-09 03:32:40',56117.1060299999,20.3157,0.1468,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkj/LSQ12dkj_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkj/LSQ12dkj_snap_42894.gif',45529877078,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,711404329,11115692,NULL,NULL,NULL,NULL),(23,21,0,'LSQ12dkj','LSQ',240.155333333333,-2.56022222222222,NULL,NULL,'2012-07-23 01:07:57',56131.0055300002,20.0699,0.1592,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkj/LSQ12dkj_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkj/LSQ12dkj_snap_45281.gif',45529877078,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,711404329,11115692,NULL,NULL,NULL,NULL),(24,21,0,'LSQ12dkj','LSQ',240.155416666667,-2.56013888888889,NULL,NULL,'2012-07-29 00:43:33',56136.9885800001,19.2189,0.1592,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkj/LSQ12dkj_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkj/LSQ12dkj_snap_47231.gif',45529877078,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,711404329,11115692,NULL,NULL,NULL,NULL),(25,21,0,'LSQ12dkj','LSQ',240.155416666667,-2.56016666666667,NULL,NULL,'2012-07-29 02:44:18',56137.0724399998,19.8449,0.1489,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkj/LSQ12dkj_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkj/LSQ12dkj_snap_47232.gif',45529877078,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,711404329,11115692,NULL,NULL,NULL,NULL),(26,26,1,'LSQ12dkh','LSQ',231.71625,-0.877361111111111,NULL,NULL,'2012-07-07 01:32:45',56115.02275,20.3629,0.1355,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_snap_42955.gif',45403731771,NULL,NULL,NULL,'2012-07-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,709433308,11084895,NULL,NULL,NULL,NULL),(27,26,0,'LSQ12dkh','LSQ',231.716125,-0.877388888888889,NULL,NULL,'2012-07-09 00:59:28',56116.99963,19.5941,0.0945,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_snap_42889.gif',45403731771,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,709433308,11084895,NULL,NULL,NULL,NULL),(28,26,0,'LSQ12dkh','LSQ',231.716208333333,-0.877416666666667,NULL,NULL,'2012-07-09 03:00:00',56117.0833399999,19.5378,0.1052,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_snap_42890.gif',45403731771,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,709433308,11084895,NULL,NULL,NULL,NULL),(29,26,0,'LSQ12dkh','LSQ',231.71625,-0.877416666666667,NULL,NULL,'2012-07-11 01:00:12',56119.0001500002,19.4312,0.0762,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_snap_43077.gif',45403731771,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,709433308,11084895,NULL,NULL,NULL,NULL),(30,26,0,'LSQ12dkh','LSQ',231.716166666667,-0.877416666666667,NULL,NULL,'2012-07-13 01:00:50',56121.0005800002,19.2794,0.071,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_snap_43312.gif',45403731771,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,709433308,11084895,NULL,NULL,NULL,NULL),(31,26,0,'LSQ12dkh','LSQ',231.71625,-0.877416666666667,NULL,NULL,'2012-07-19 00:52:45',56126.9949699999,19.0737,0.0584,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_snap_44731.gif',45403731771,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,709433308,11084895,NULL,NULL,NULL,NULL),(32,26,0,'LSQ12dkh','LSQ',231.716166666667,-0.877444444444444,NULL,NULL,'2012-07-23 00:40:24',56130.9863900002,19.1715,0.0788,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_snap_45265.gif',45403731771,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,709433308,11084895,NULL,NULL,NULL,NULL),(33,26,0,'LSQ12dkh','LSQ',231.716375,-0.877388888888889,NULL,NULL,'2012-07-27 02:03:38',56135.0441999999,19.4193,0.1814,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_snap_46292.gif',45403731771,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,709433308,11084895,NULL,NULL,NULL,NULL),(34,26,0,'LSQ12dkh','LSQ',231.716333333333,-0.877416666666667,NULL,NULL,'2012-07-29 01:20:52',56137.0145,19.487,0.15,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkh/LSQ12dkh_snap_47226.gif',45403731771,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,709433308,11084895,NULL,NULL,NULL,NULL),(35,35,1,'LSQ12dkg','LSQ',41.2560833333333,-0.730111111111111,NULL,NULL,'2012-07-09 09:42:04',56117.3625500002,17.1124,0.0275,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkg/LSQ12dkg_history.html','sne-nice',NULL,0.05426,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkg/LSQ12dkg_snap_42887.gif',34903707595,NULL,NULL,NULL,'2010-11-22 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,545370431,8521412,NULL,NULL,NULL,NULL),(36,35,0,'LSQ12dkg','LSQ',41.2560833333333,-0.730194444444444,NULL,NULL,'2012-07-09 10:41:37',56117.4039099999,17.3142,0.0277,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkg/LSQ12dkg_history.html','sne-nice',NULL,0.05426,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkg/LSQ12dkg_snap_42888.gif',34903707595,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,545370431,8521412,NULL,NULL,NULL,NULL),(37,35,0,'LSQ12dkg','LSQ',41.2560833333333,-0.730138888888889,NULL,NULL,'2012-07-23 09:19:21',56131.3467799998,18.2903,0.1,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkg/LSQ12dkg_history.html','sne-nice',NULL,0.05426,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkg/LSQ12dkg_snap_45262.gif',34903707595,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,545370431,8521412,NULL,NULL,NULL,NULL),(38,35,0,'LSQ12dkg','LSQ',41.2560833333333,-0.730222222222222,NULL,NULL,'2012-07-23 10:27:45',56131.3942800001,18.1947,0.0587,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkg/LSQ12dkg_history.html','sne-nice',NULL,0.05426,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkg/LSQ12dkg_snap_45263.gif',34903707595,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,545370431,8521412,NULL,NULL,NULL,NULL),(39,35,0,'LSQ12dkg','LSQ',41.256125,-0.730083333333333,NULL,NULL,'2012-07-27 09:01:27',56135.3343500001,17.961,0.04,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkg/LSQ12dkg_history.html','sne-nice',NULL,0.05426,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkg/LSQ12dkg_snap_46261.gif',34903707595,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,545370431,8521412,NULL,NULL,NULL,NULL),(40,35,0,'LSQ12dkg','LSQ',41.256125,-0.730166666666667,NULL,NULL,'2012-07-27 10:18:25',56135.3878000001,17.8458,0.035,'gr-LSQ',NULL,NULL,'unknown',NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkg/LSQ12dkg_history.html','sne-nice',NULL,0.05426,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkg/LSQ12dkg_snap_46262.gif',34903707595,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,545370431,8521412,NULL,NULL,NULL,NULL),(41,35,0,'LSQ12dkg','LSQ',41.25625,-0.730055555555556,NULL,NULL,'2012-07-29 09:03:06',56137.33549,17.9797,0.0443,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkg/LSQ12dkg_history.html','sne-nice',NULL,0.05426,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkg/LSQ12dkg_snap_47219.gif',34903707595,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,545370431,8521412,NULL,NULL,NULL,NULL),(42,35,0,'LSQ12dkg','LSQ',41.2560833333333,-0.730111111111111,NULL,NULL,'2012-07-29 10:18:07',56137.3875899999,18.1234,0.0366,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkg/LSQ12dkg_history.html','sne-nice',NULL,0.05426,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dkg/LSQ12dkg_snap_47220.gif',34903707595,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,545370431,8521412,NULL,NULL,NULL,NULL),(43,43,1,'LSQ12dka','LSQ',338.102833333333,-0.856361111111111,NULL,NULL,'2012-07-05 05:40:41',56113.1949200002,18.8961,0.1487,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dka/LSQ12dka_history.html','sne-nice',NULL,0.08942,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dka/LSQ12dka_snap_42950.gif',50332511730,NULL,NULL,NULL,'2012-06-30 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,786445495,12288210,NULL,NULL,NULL,NULL),(44,43,0,'LSQ12dka','LSQ',338.10275,-0.856333333333333,NULL,NULL,'2012-07-05 07:39:47',56113.2776299999,18.7869,0.1814,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dka/LSQ12dka_history.html','sne-nice',NULL,0.08942,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dka/LSQ12dka_snap_42951.gif',50332511730,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,786445495,12288210,NULL,NULL,NULL,NULL),(45,43,0,'LSQ12dka','LSQ',338.10275,-0.856277777777778,NULL,NULL,'2012-07-09 05:24:09',56117.1834399998,19.1211,0.1298,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dka/LSQ12dka_history.html','sne-nice',NULL,0.08942,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dka/LSQ12dka_snap_42875.gif',50332511730,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,786445495,12288210,NULL,NULL,NULL,NULL),(46,43,0,'LSQ12dka','LSQ',338.102708333333,-0.85625,NULL,NULL,'2012-07-09 07:24:13',56117.26682,18.8167,0.1424,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dka/LSQ12dka_history.html','sne-nice',NULL,0.08942,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dka/LSQ12dka_snap_42876.gif',50332511730,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,786445495,12288210,NULL,NULL,NULL,NULL),(47,43,0,'LSQ12dka','LSQ',338.102666666667,-0.856027777777778,NULL,NULL,'2012-07-27 06:21:42',56135.2234100001,20.015,0.1974,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dka/LSQ12dka_history.html','sne-nice',NULL,0.08942,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dka/LSQ12dka_snap_46253.gif',50332511730,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,786445495,12288210,NULL,NULL,NULL,NULL),(48,48,1,'LSQ12djy','LSQ',246.300958333333,4.90677777777778,NULL,NULL,'2012-07-05 01:56:19',56113.0391199999,18.0289,0.0449,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_snap_42943.gif',56443767718,NULL,NULL,NULL,'2012-06-26 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881933870,13780216,NULL,NULL,NULL,NULL),(49,48,0,'LSQ12djy','LSQ',246.300958333333,4.90680555555556,NULL,NULL,'2012-07-05 03:56:57',56113.1228900002,18.1297,0.0466,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_snap_42944.gif',56443767718,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881933870,13780216,NULL,NULL,NULL,NULL),(50,48,0,'LSQ12djy','LSQ',246.300958333333,4.90680555555556,NULL,NULL,'2012-07-07 02:24:16',56115.05853,18.1298,0.029,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_snap_42945.gif',56443767718,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881933870,13780216,NULL,NULL,NULL,NULL),(51,48,0,'LSQ12djy','LSQ',246.301,4.90680555555556,NULL,NULL,'2012-07-07 04:24:40',56115.1421300001,18.1697,0.0403,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_snap_42946.gif',56443767718,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881933870,13780216,NULL,NULL,NULL,NULL),(52,48,0,'LSQ12djy','LSQ',246.300958333333,4.90680555555556,NULL,NULL,'2012-07-09 01:55:42',56117.0386899998,18.3821,0.0288,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_snap_42871.gif',56443767718,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881933870,13780216,NULL,NULL,NULL,NULL),(53,48,0,'LSQ12djy','LSQ',246.300958333333,4.90680555555556,NULL,NULL,'2012-07-09 04:00:00',56117.1250100001,18.3096,0.0282,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_snap_42872.gif',56443767718,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881933870,13780216,NULL,NULL,NULL,NULL),(54,48,0,'LSQ12djy','LSQ',246.300958333333,4.90680555555556,NULL,NULL,'2012-07-23 01:29:59',56131.0208299998,18.9199,0.045,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_snap_45319.gif',56443767718,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881933870,13780216,NULL,NULL,NULL,NULL),(55,48,0,'LSQ12djy','LSQ',246.301041666667,4.90680555555556,NULL,NULL,'2012-07-23 03:30:27',56131.1044800002,18.9359,0.0725,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_snap_45320.gif',56443767718,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881933870,13780216,NULL,NULL,NULL,NULL),(56,48,0,'LSQ12djy','LSQ',246.300916666667,4.90688888888889,NULL,NULL,'2012-08-04 04:14:28',56143.1350500002,19.5919,0.2,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djy/LSQ12djy_snap_49563.gif',56443767718,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881933870,13780216,NULL,NULL,NULL,NULL),(57,57,1,'LSQ12djx','LSQ',248.4625,6.95141666666667,NULL,NULL,'2012-07-05 01:49:33',56113.0344199999,19.1453,0.1155,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_snap_42939.gif',56765709353,NULL,NULL,NULL,'2012-06-26 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,886964208,13858815,NULL,NULL,NULL,NULL),(58,57,0,'LSQ12djx','LSQ',248.462458333333,6.95147222222222,NULL,NULL,'2012-07-05 03:50:11',56113.1181899998,18.8666,0.0831,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_snap_42940.gif',56765709353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,886964208,13858815,NULL,NULL,NULL,NULL),(59,57,0,'LSQ12djx','LSQ',248.462541666667,6.95144444444444,NULL,NULL,'2012-07-07 02:17:30',56115.0538300001,19.12,0.0618,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_snap_42941.gif',56765709353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,886964208,13858815,NULL,NULL,NULL,NULL),(60,57,0,'LSQ12djx','LSQ',248.4625,6.95138888888889,NULL,NULL,'2012-07-07 04:17:52',56115.13741,19.059,0.071,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_snap_42942.gif',56765709353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,886964208,13858815,NULL,NULL,NULL,NULL),(61,57,0,'LSQ12djx','LSQ',248.462458333333,6.95144444444444,NULL,NULL,'2012-07-09 01:48:57',56117.034,19.2363,0.0464,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_snap_42869.gif',56765709353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,886964208,13858815,NULL,NULL,NULL,NULL),(62,57,0,'LSQ12djx','LSQ',248.462458333333,6.95141666666667,NULL,NULL,'2012-07-09 03:53:13',56117.1203000001,19.2126,0.0473,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_snap_42870.gif',56765709353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,886964208,13858815,NULL,NULL,NULL,NULL),(63,57,0,'LSQ12djx','LSQ',248.462458333333,6.95147222222222,NULL,NULL,'2012-07-13 02:02:59',56121.0437400001,19.1939,0.0455,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_snap_43316.gif',56765709353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,886964208,13858815,NULL,NULL,NULL,NULL),(64,57,0,'LSQ12djx','LSQ',248.462541666667,6.95147222222222,NULL,NULL,'2012-07-15 01:55:40',56123.0386600001,19.0007,0.0424,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_snap_43544.gif',56765709353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,886964208,13858815,NULL,NULL,NULL,NULL),(65,57,0,'LSQ12djx','LSQ',248.462458333333,6.95141666666667,NULL,NULL,'2012-07-19 01:39:49',56127.0276600001,19.2197,0.0429,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_snap_44738.gif',56765709353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,886964208,13858815,NULL,NULL,NULL,NULL),(66,57,0,'LSQ12djx','LSQ',248.462583333333,6.95138888888889,NULL,NULL,'2012-07-21 01:32:09',56129.0223300001,19.1103,0.1772,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_snap_45025.gif',56765709353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,886964208,13858815,NULL,NULL,NULL,NULL),(67,57,0,'LSQ12djx','LSQ',248.4625,6.95141666666667,NULL,NULL,'2012-07-23 01:23:15',56131.01615,19.3938,0.0625,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_snap_45302.gif',56765709353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,886964208,13858815,NULL,NULL,NULL,NULL),(68,57,0,'LSQ12djx','LSQ',248.462625,6.95136111111111,NULL,NULL,'2012-07-23 03:25:22',56131.10096,19.1293,0.1369,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_snap_45303.gif',56765709353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,886964208,13858815,NULL,NULL,NULL,NULL),(69,57,0,'LSQ12djx','LSQ',248.462458333333,6.95141666666667,NULL,NULL,'2012-07-27 01:06:59',56135.0048600002,18.6993,0.0819,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_snap_46323.gif',56765709353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,886964208,13858815,NULL,NULL,NULL,NULL),(70,57,0,'LSQ12djx','LSQ',248.4625,6.95138888888889,NULL,NULL,'2012-07-29 00:58:44',56136.9991299999,18.7317,0.1158,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_snap_47314.gif',56765709353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,886964208,13858815,NULL,NULL,NULL,NULL),(71,57,0,'LSQ12djx','LSQ',248.462541666667,6.95141666666667,NULL,NULL,'2012-07-29 03:01:22',56137.0842900001,18.7971,0.1407,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_snap_47315.gif',56765709353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,886964208,13858815,NULL,NULL,NULL,NULL),(72,57,0,'LSQ12djx','LSQ',248.462666666667,6.95141666666667,NULL,NULL,'2012-08-04 04:30:50',56143.1464200001,18.3345,0.1387,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djx/LSQ12djx_snap_49560.gif',56765709353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,886964208,13858815,NULL,NULL,NULL,NULL),(73,73,1,'LSQ12djv','LSQ',251.267375,5.61513888888889,NULL,NULL,'2012-07-07 02:34:25',56115.0655700001,19.7859,0.1241,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djv/LSQ12djv_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djv/LSQ12djv_snap_42936.gif',56714908272,NULL,NULL,NULL,'2012-07-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,886170441,13846413,NULL,NULL,NULL,NULL),(74,73,0,'LSQ12djv','LSQ',251.267333333333,5.61519444444444,NULL,NULL,'2012-07-07 04:34:49',56115.1491800002,20.1178,0.1648,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djv/LSQ12djv_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djv/LSQ12djv_snap_42937.gif',56714908272,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,886170441,13846413,NULL,NULL,NULL,NULL),(75,73,0,'LSQ12djv','LSQ',251.267333333333,5.61519444444444,NULL,NULL,'2012-07-09 02:05:51',56117.0457299999,19.2958,0.0937,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djv/LSQ12djv_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djv/LSQ12djv_snap_42863.gif',56714908272,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,886170441,13846413,NULL,NULL,NULL,NULL),(76,73,0,'LSQ12djv','LSQ',251.267291666667,5.61511111111111,NULL,NULL,'2012-07-09 04:10:08',56117.1320400001,19.2703,0.107,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djv/LSQ12djv_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djv/LSQ12djv_snap_42864.gif',56714908272,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,886170441,13846413,NULL,NULL,NULL,NULL),(77,73,0,'LSQ12djv','LSQ',251.267291666667,5.61519444444444,NULL,NULL,'2012-07-15 02:10:55',56123.0492500002,20.1471,0.1642,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djv/LSQ12djv_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djv/LSQ12djv_snap_43526.gif',56714908272,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,886170441,13846413,NULL,NULL,NULL,NULL),(78,73,0,'LSQ12djv','LSQ',251.267375,5.61516666666667,NULL,NULL,'2012-07-23 01:40:09',56131.02789,20.7259,0.1468,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djv/LSQ12djv_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djv/LSQ12djv_snap_45256.gif',56714908272,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,886170441,13846413,NULL,NULL,NULL,NULL),(79,73,0,'LSQ12djv','LSQ',251.267458333333,5.61530555555556,NULL,NULL,'2012-07-23 03:40:37',56131.11154,20.4017,0.1652,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djv/LSQ12djv_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djv/LSQ12djv_snap_45257.gif',56714908272,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,886170441,13846413,NULL,NULL,NULL,NULL),(80,73,0,'LSQ12djv','LSQ',251.267375,5.61522222222222,NULL,NULL,'2012-07-25 01:58:43',56133.0407799999,20.0141,0.1785,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djv/LSQ12djv_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djv/LSQ12djv_snap_45791.gif',56714908272,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,886170441,13846413,NULL,NULL,NULL,NULL),(81,81,1,'LSQ12dli','LSQ',43.4815,-23.7229444444444,NULL,NULL,'2012-07-10 11:23:32',56118.4330199999,19.2841,0.066,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dli/LSQ12dli_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dli/LSQ12dli_snap_43065.gif',37937014005,NULL,NULL,NULL,'2012-07-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,592765843,9261966,NULL,NULL,NULL,NULL),(82,81,0,'LSQ12dli','LSQ',43.4815,-23.7230277777778,NULL,NULL,'2012-07-10 11:36:12',56118.4418100002,19.4068,0.0883,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dli/LSQ12dli_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dli/LSQ12dli_snap_43066.gif',37937014005,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,592765843,9261966,NULL,NULL,NULL,NULL),(83,81,0,'LSQ12dli','LSQ',43.4815833333333,-23.7228888888889,NULL,NULL,'2012-07-20 11:05:00',56128.4201400001,20.1197,0.2032,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dli/LSQ12dli_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dli/LSQ12dli_snap_44861.gif',37937014005,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,592765843,9261966,NULL,NULL,NULL,NULL),(84,81,0,'LSQ12dli','LSQ',43.4815,-23.7229166666667,NULL,NULL,'2012-07-20 11:22:10',56128.4320700001,20.2801,0.1592,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dli/LSQ12dli_history.html','radio source',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dli/LSQ12dli_snap_44862.gif',37937014005,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,592765843,9261966,NULL,NULL,NULL,NULL),(85,85,1,'LSQ12dlf','LSQ',27.6241666666667,-21.8126111111111,NULL,NULL,'2012-07-10 09:37:26',56118.35934,18.7585,0.0718,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_snap_43059.gif',35034119519,NULL,NULL,NULL,'2012-07-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,547408117,8553251,NULL,NULL,NULL,NULL),(86,85,0,'LSQ12dlf','LSQ',27.624125,-21.8126388888889,NULL,NULL,'2012-07-10 10:50:57',56118.4103899999,18.6088,0.0641,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_snap_43060.gif',35034119519,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,547408117,8553251,NULL,NULL,NULL,NULL),(87,85,0,'LSQ12dlf','LSQ',27.624125,-21.8126388888889,NULL,NULL,'2012-07-16 10:55:40',56124.4136600001,18.4228,0.0768,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_snap_43771.gif',35034119519,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,547408117,8553251,NULL,NULL,NULL,NULL),(88,85,0,'LSQ12dlf','LSQ',27.624,-21.8126388888889,NULL,NULL,'2012-07-16 11:28:09',56124.43622,18.2271,0.0441,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_snap_43772.gif',35034119519,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,547408117,8553251,NULL,NULL,NULL,NULL),(89,85,0,'LSQ12dlf','LSQ',27.624125,-21.8126111111111,NULL,NULL,'2012-07-18 11:20:19',56126.4307800001,18.4692,0.0405,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_snap_44459.gif',35034119519,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,547408117,8553251,NULL,NULL,NULL,NULL),(90,85,0,'LSQ12dlf','LSQ',27.6242083333333,-21.8126666666667,NULL,NULL,'2012-07-22 08:37:04',56130.3174100001,18.274,0.0331,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_snap_45129.gif',35034119519,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,547408117,8553251,NULL,NULL,NULL,NULL),(91,85,0,'LSQ12dlf','LSQ',27.6240833333333,-21.8126111111111,NULL,NULL,'2012-07-24 10:54:00',56132.4125100002,18.278,0.0307,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_snap_45559.gif',35034119519,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,547408117,8553251,NULL,NULL,NULL,NULL),(92,85,0,'LSQ12dlf','LSQ',27.624125,-21.8126111111111,NULL,NULL,'2012-07-28 06:52:54',56136.2450799998,18.1292,0.0661,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_snap_46640.gif',35034119519,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,547408117,8553251,NULL,NULL,NULL,NULL),(93,85,0,'LSQ12dlf','LSQ',27.624125,-21.8126111111111,NULL,NULL,'2012-07-28 08:52:39',56136.3282300001,18.1933,0.0316,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_snap_46641.gif',35034119519,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,547408117,8553251,NULL,NULL,NULL,NULL),(94,85,0,'LSQ12dlf','LSQ',27.6241666666667,-21.8125833333333,NULL,NULL,'2012-07-30 07:10:31',56138.2573099998,18.1587,0.0665,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_snap_48379.gif',35034119519,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,547408117,8553251,NULL,NULL,NULL,NULL),(95,85,0,'LSQ12dlf','LSQ',27.6241666666667,-21.8125833333333,NULL,NULL,'2012-07-30 09:12:02',56138.3417000002,18.1793,0.0449,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlf/LSQ12dlf_snap_48380.gif',35034119519,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,547408117,8553251,NULL,NULL,NULL,NULL),(96,96,1,'LSQ12dle','LSQ',25.1842916666667,-25.2649166666667,NULL,NULL,'2012-07-10 09:37:26',56118.35934,18.4788,0.0677,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_43057.gif',34695840990,NULL,NULL,NULL,'2012-07-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(97,96,0,'LSQ12dle','LSQ',25.1843333333333,-25.2648888888889,NULL,NULL,'2012-07-10 10:50:57',56118.4103899999,18.3289,0.0563,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_43058.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(98,96,0,'LSQ12dle','LSQ',25.184375,-25.2648611111111,NULL,NULL,'2012-07-16 10:55:40',56124.4136600001,17.2062,0.0189,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_43769.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(99,96,0,'LSQ12dle','LSQ',25.1843333333333,-25.2648611111111,NULL,NULL,'2012-07-16 11:28:09',56124.43622,17.1474,0.0191,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_43770.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(100,96,0,'LSQ12dle','LSQ',25.1843333333333,-25.2648888888889,NULL,NULL,'2012-07-18 11:01:24',56126.4176400001,17.1901,0.0169,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_44460.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(101,96,0,'LSQ12dle','LSQ',25.1843333333333,-25.2648888888889,NULL,NULL,'2012-07-18 11:20:19',56126.4307800001,17.0951,0.018,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_44461.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(102,96,0,'LSQ12dle','LSQ',25.1843333333333,-25.2648611111111,NULL,NULL,'2012-07-20 10:51:26',56128.41072,16.9765,0.024,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_44865.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(103,96,0,'LSQ12dle','LSQ',25.1843333333333,-25.2648611111111,NULL,NULL,'2012-07-20 11:15:25',56128.4273799998,17.0303,0.0257,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_44866.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(104,96,0,'LSQ12dle','LSQ',25.1843333333333,-25.2648888888889,NULL,NULL,'2012-07-22 08:37:04',56130.3174100001,16.9932,0.0153,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_45127.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(105,96,0,'LSQ12dle','LSQ',25.1843333333333,-25.2648888888889,NULL,NULL,'2012-07-22 10:06:31',56130.37953,16.9697,0.0165,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_45128.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(106,96,0,'LSQ12dle','LSQ',25.1843333333333,-25.2648888888889,NULL,NULL,'2012-07-24 10:54:00',56132.4125100002,16.9652,0.0148,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_45557.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(107,96,0,'LSQ12dle','LSQ',25.1843333333333,-25.2648611111111,NULL,NULL,'2012-07-24 11:14:39',56132.4268499999,16.995,0.0145,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_45558.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(108,96,0,'LSQ12dle','LSQ',25.184375,-25.2648888888889,NULL,NULL,'2012-07-26 09:05:30',56134.3371600001,17.0595,0.0204,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_46090.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(109,96,0,'LSQ12dle','LSQ',25.1843333333333,-25.2648611111111,NULL,NULL,'2012-07-26 10:19:55',56134.3888400001,17.0683,0.0162,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_46091.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(110,96,0,'LSQ12dle','LSQ',25.1842916666667,-25.2648888888889,NULL,NULL,'2012-07-28 06:52:54',56136.2450799998,17.1401,0.0272,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_46643.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(111,96,0,'LSQ12dle','LSQ',25.1843333333333,-25.2648611111111,NULL,NULL,'2012-07-28 08:52:39',56136.3282300001,17.2298,0.0194,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_46644.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(112,96,0,'LSQ12dle','LSQ',25.184375,-25.2649166666667,NULL,NULL,'2012-07-30 07:10:31',56138.2573099998,17.189,0.0317,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_48381.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(113,96,0,'LSQ12dle','LSQ',25.1842916666667,-25.2648611111111,NULL,NULL,'2012-07-30 09:12:02',56138.3417000002,17.1939,0.0248,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_history.html','sne-nice',NULL,0.051005,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dle/LSQ12dle_snap_48382.gif',34695840990,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(114,114,1,'LSQ12dlz','LSQ',310.10525,-25.5417222222222,NULL,NULL,'2012-07-11 05:37:30',56119.1927100001,20.4608,0.1179,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlz/LSQ12dlz_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlz/LSQ12dlz_snap_43498.gif',51319425935,NULL,NULL,NULL,'2012-07-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,801866030,12529156,NULL,NULL,NULL,NULL),(115,114,0,'LSQ12dlz','LSQ',310.105208333333,-25.5417777777778,NULL,NULL,'2012-07-11 05:44:53',56119.19784,20.6471,0.1092,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlz/LSQ12dlz_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlz/LSQ12dlz_snap_43499.gif',51319425935,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,801866030,12529156,NULL,NULL,NULL,NULL),(116,114,0,'LSQ12dlz','LSQ',310.105166666667,-25.5418055555556,NULL,NULL,'2012-07-11 07:54:51',56119.2881,20.7159,0.1756,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlz/LSQ12dlz_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlz/LSQ12dlz_snap_43500.gif',51319425934,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,801866030,12529156,NULL,NULL,NULL,NULL),(117,114,0,'LSQ12dlz','LSQ',310.105375,-25.5417222222222,NULL,NULL,'2012-07-11 09:52:47',56119.36999,20.4384,0.1291,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlz/LSQ12dlz_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlz/LSQ12dlz_snap_43501.gif',51319425935,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,801866030,12529156,NULL,NULL,NULL,NULL),(118,114,0,'LSQ12dlz','LSQ',310.105291666667,-25.5418333333333,NULL,NULL,'2012-07-12 06:02:49',56120.2102999999,20.8037,0.126,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlz/LSQ12dlz_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlz/LSQ12dlz_snap_43502.gif',51319425935,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,801866030,12529156,NULL,NULL,NULL,NULL),(119,114,0,'LSQ12dlz','LSQ',310.105333333333,-25.5417222222222,NULL,NULL,'2012-07-12 08:41:47',56120.32069,20.4916,0.1022,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlz/LSQ12dlz_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlz/LSQ12dlz_snap_43503.gif',51319425935,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,801866030,12529156,NULL,NULL,NULL,NULL),(120,114,0,'LSQ12dlz','LSQ',310.105166666667,-25.54175,NULL,NULL,'2012-07-13 03:52:24',56121.1197299999,20.4092,0.1079,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlz/LSQ12dlz_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlz/LSQ12dlz_snap_43445.gif',51319425934,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,801866030,12529156,NULL,NULL,NULL,NULL),(121,114,0,'LSQ12dlz','LSQ',310.105291666667,-25.54175,NULL,NULL,'2012-07-13 07:23:56',56121.26663,20.3789,0.141,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlz/LSQ12dlz_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlz/LSQ12dlz_snap_43446.gif',51319425935,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,801866030,12529156,NULL,NULL,NULL,NULL),(122,122,1,'LSQ12dlx','LSQ',302.489708333333,-23.8511944444444,NULL,NULL,'2012-07-11 02:39:45',56119.0692799999,18.1862,0.0225,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43480.gif',50808405417,NULL,NULL,NULL,'2012-06-04 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(123,122,0,'LSQ12dlx','LSQ',302.489708333333,-23.8512777777778,NULL,NULL,'2012-07-11 02:47:09',56119.0744099999,18.2964,0.0258,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43481.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(124,122,0,'LSQ12dlx','LSQ',302.489666666667,-23.85125,NULL,NULL,'2012-07-11 04:41:56',56119.1541300002,18.2742,0.0214,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43482.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(125,122,0,'LSQ12dlx','LSQ',302.489625,-23.8512777777778,NULL,NULL,'2012-07-11 04:49:19',56119.15925,18.4023,0.0239,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43483.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(126,122,0,'LSQ12dlx','LSQ',302.489708333333,-23.85125,NULL,NULL,'2012-07-11 08:16:58',56119.3034600001,18.1838,0.0426,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43484.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(127,122,0,'LSQ12dlx','LSQ',302.48975,-23.8512222222222,NULL,NULL,'2012-07-11 08:24:21',56119.30858,18.1291,0.0338,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43485.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(128,122,0,'LSQ12dlx','LSQ',302.489708333333,-23.8512777777778,NULL,NULL,'2012-07-12 04:56:21',56120.16414,18.1414,0.02,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43486.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(129,122,0,'LSQ12dlx','LSQ',302.489625,-23.85125,NULL,NULL,'2012-07-12 05:03:44',56120.1692599999,18.4487,0.0207,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43487.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(130,122,0,'LSQ12dlx','LSQ',302.489625,-23.85125,NULL,NULL,'2012-07-12 07:42:46',56120.2796999998,18.5012,0.025,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43488.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(131,122,0,'LSQ12dlx','LSQ',302.489791666667,-23.85125,NULL,NULL,'2012-07-12 07:50:09',56120.2848299998,18.3878,0.0274,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43489.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(132,122,0,'LSQ12dlx','LSQ',302.489833333333,-23.8510555555556,NULL,NULL,'2012-07-12 10:26:02',56120.3930899999,18.1031,0.0314,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43490.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(133,122,0,'LSQ12dlx','LSQ',302.489916666667,-23.8511944444444,NULL,NULL,'2012-07-12 10:35:20',56120.3995400001,18.1501,0.0339,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43491.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(134,122,0,'LSQ12dlx','LSQ',302.489666666667,-23.8512777777778,NULL,NULL,'2012-07-13 02:17:19',56121.0537,18.3069,0.023,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43441.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(135,122,0,'LSQ12dlx','LSQ',302.489666666667,-23.85125,NULL,NULL,'2012-07-13 04:18:19',56121.1377300001,18.1716,0.0232,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43442.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(136,122,0,'LSQ12dlx','LSQ',302.489666666667,-23.85125,NULL,NULL,'2012-07-13 06:39:32',56121.2357899998,18.5882,0.0493,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43492.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(137,122,0,'LSQ12dlx','LSQ',302.48975,-23.8511388888889,NULL,NULL,'2012-07-16 02:04:41',56124.0449299999,18.1407,0.0258,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43787.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(138,122,0,'LSQ12dlx','LSQ',302.48975,-23.8511388888889,NULL,NULL,'2012-07-16 04:18:46',56124.1380400001,18.232,0.0256,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_43788.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(139,122,0,'LSQ12dlx','LSQ',302.489625,-23.85125,NULL,NULL,'2012-07-18 01:54:45',56126.0380299999,18.5418,0.0279,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_44508.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(140,122,0,'LSQ12dlx','LSQ',302.489583333333,-23.8512777777778,NULL,NULL,'2012-07-18 03:59:13',56126.1244600001,18.9384,0.0414,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_44509.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(141,122,0,'LSQ12dlx','LSQ',302.489666666667,-23.85125,NULL,NULL,'2012-07-18 06:28:22',56126.22804,18.6667,0.0339,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_44510.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(142,122,0,'LSQ12dlx','LSQ',302.489833333333,-23.8511944444444,NULL,NULL,'2012-07-22 01:39:48',56130.0276500001,18.4067,0.0619,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_45176.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(143,122,0,'LSQ12dlx','LSQ',302.489708333333,-23.8512222222222,NULL,NULL,'2012-07-22 06:34:56',56130.2326000002,18.9604,0.0421,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_45177.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(144,122,0,'LSQ12dlx','LSQ',302.489583333333,-23.8513055555556,NULL,NULL,'2012-07-25 01:34:18',56133.0238299998,19.3159,0.0629,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_45889.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(145,122,0,'LSQ12dlx','LSQ',302.48975,-23.8511111111111,NULL,NULL,'2012-07-25 03:36:22',56133.1085899998,18.6311,0.0383,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_45890.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(146,122,0,'LSQ12dlx','LSQ',302.489708333333,-23.8511666666667,NULL,NULL,'2012-07-25 06:30:21',56133.2294200002,19.0034,0.038,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_45891.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(147,122,0,'LSQ12dlx','LSQ',302.489583333333,-23.8512777777778,NULL,NULL,'2012-07-26 01:59:50',56134.0415599998,19.7681,0.0719,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_46145.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(148,122,0,'LSQ12dlx','LSQ',302.48975,-23.8511666666667,NULL,NULL,'2012-07-26 04:02:57',56134.1270499998,18.692,0.0423,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_46146.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(149,122,0,'LSQ12dlx','LSQ',302.48975,-23.8511111111111,NULL,NULL,'2012-07-26 07:54:19',56134.28773,18.7369,0.0447,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_history.html','sne',NULL,0.073811,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dlx/LSQ12dlx_snap_46147.gif',50808405417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793881334,12404395,NULL,NULL,NULL,NULL),(150,150,1,'LSQ12dmi','LSQ',22.948375,-3.6745,NULL,NULL,'2012-07-07 10:10:23',56115.38222,18.2779,0.0769,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_44438.gif',35241776632,NULL,NULL,NULL,'2012-07-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(151,150,0,'LSQ12dmi','LSQ',22.948625,-3.6745,NULL,NULL,'2012-07-07 10:12:05',56115.3834000002,18.5047,0.0854,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_43714.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(152,150,0,'LSQ12dmi','LSQ',22.948625,-3.67447222222222,NULL,NULL,'2012-07-09 10:05:11',56117.3785999999,18.7937,0.0808,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_43715.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(153,150,0,'LSQ12dmi','LSQ',22.9485416666667,-3.67461111111111,NULL,NULL,'2012-07-11 09:25:54',56119.35133,17.8281,0.1499,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_44439.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(154,150,0,'LSQ12dmi','LSQ',22.948625,-3.67452777777778,NULL,NULL,'2012-07-15 11:05:04',56123.42019,18.895,0.069,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_43676.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(155,150,0,'LSQ12dmi','LSQ',22.9485,-3.6745,NULL,NULL,'2012-07-15 11:06:44',56123.42135,18.6626,0.0564,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_44440.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(156,150,0,'LSQ12dmi','LSQ',22.9486666666667,-3.67447222222222,NULL,NULL,'2012-07-15 11:22:04',56123.432,19.1105,0.0779,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_43677.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(157,150,0,'LSQ12dmi','LSQ',22.948625,-3.6745,NULL,NULL,'2012-07-17 09:38:34',56125.3601199999,19.2922,0.0899,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_43883.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(158,150,0,'LSQ12dmi','LSQ',22.948625,-3.67444444444444,NULL,NULL,'2012-07-17 09:40:16',56125.3613,19.0003,0.0725,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_44334.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(159,150,0,'LSQ12dmi','LSQ',22.9486666666667,-3.67444444444444,NULL,NULL,'2012-07-17 10:38:56',56125.4020400001,18.983,0.068,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_44335.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(160,150,0,'LSQ12dmi','LSQ',22.948625,-3.67438888888889,NULL,NULL,'2012-07-17 11:26:43',56125.4352299999,19.1348,0.0935,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_43884.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(161,150,0,'LSQ12dmi','LSQ',22.9485833333333,-3.67444444444444,NULL,NULL,'2012-07-21 09:32:57',56129.35622,19.309,0.1666,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_45021.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(162,150,0,'LSQ12dmi','LSQ',22.9484583333333,-3.67447222222222,NULL,NULL,'2012-07-23 08:12:06',56131.30008,19.2493,0.1673,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_45295.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(163,150,0,'LSQ12dmi','LSQ',22.948625,-3.67447222222222,NULL,NULL,'2012-07-23 08:13:48',56131.30125,18.6612,0.1043,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_45293.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(164,150,0,'LSQ12dmi','LSQ',22.948625,-3.67438888888889,NULL,NULL,'2012-07-23 09:55:51',56131.37212,18.8559,0.21,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_45294.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(165,150,0,'LSQ12dmi','LSQ',22.9486666666667,-3.67444444444444,NULL,NULL,'2012-07-25 08:40:22',56133.31971,19.7745,0.1224,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_45839.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(166,150,0,'LSQ12dmi','LSQ',22.948625,-3.67447222222222,NULL,NULL,'2012-07-25 08:42:04',56133.32088,19.401,0.1061,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_45837.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(167,150,0,'LSQ12dmi','LSQ',22.9485833333333,-3.67438888888889,NULL,NULL,'2012-07-25 10:24:40',56133.3921400001,19.7076,0.1112,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_45838.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(168,150,0,'LSQ12dmi','LSQ',22.948625,-3.67452777777778,NULL,NULL,'2012-07-27 07:55:26',56135.2884999998,19.6958,0.1154,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_46305.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(169,150,0,'LSQ12dmi','LSQ',22.948625,-3.67447222222222,NULL,NULL,'2012-07-27 09:44:46',56135.3644300001,19.9832,0.1404,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_46306.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(170,150,0,'LSQ12dmi','LSQ',22.9485833333333,-3.67444444444444,NULL,NULL,'2012-07-27 11:15:56',56135.4277400002,19.8744,0.1375,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_46307.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(171,150,0,'LSQ12dmi','LSQ',22.9485,-3.67444444444444,NULL,NULL,'2012-07-29 07:51:52',56137.2860300001,19.827,0.1681,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_47291.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(172,150,0,'LSQ12dmi','LSQ',22.9484583333333,-3.67466666666667,NULL,NULL,'2012-07-29 11:14:30',56137.42674,18.9333,0.0728,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_47292.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(173,173,1,'LSQ12dnk','LSQ',10.4951666666667,-25.1883055555556,NULL,NULL,'2012-07-01 07:32:03',56109.27226,19.4504,0.0842,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_history.html','outburst?',NULL,0.112638,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_snap_44192.gif',34798720798,NULL,NULL,NULL,'2012-06-27 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,543730012,8495781,NULL,NULL,NULL,NULL),(174,173,0,'LSQ12dnk','LSQ',10.4952083333333,-25.1883888888889,NULL,NULL,'2012-07-01 09:32:07',56109.3556400002,18.709,0.0486,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_history.html','outburst?',NULL,0.112638,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_snap_44193.gif',34798720785,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,543730012,8495781,NULL,NULL,NULL,NULL),(175,173,0,'LSQ12dnk','LSQ',10.4952916666667,-25.18825,NULL,NULL,'2012-07-03 09:18:25',56111.34613,16.7867,0.0206,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_history.html','outburst?',NULL,0.112638,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_snap_44194.gif',34798720785,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,543730012,8495781,NULL,NULL,NULL,NULL),(176,173,0,'LSQ12dnk','LSQ',10.495375,-25.1882777777778,NULL,NULL,'2012-07-04 11:35:59',56112.44166,18.0758,0.0492,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_history.html','outburst?',NULL,0.112638,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_snap_44195.gif',34798720785,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,543730012,8495781,NULL,NULL,NULL,NULL),(177,173,0,'LSQ12dnk','LSQ',10.495375,-25.1885555555556,NULL,NULL,'2012-07-06 09:05:28',56114.3371299999,18.1346,0.0385,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_history.html','outburst?',NULL,0.112638,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_snap_44196.gif',34798720787,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,543730012,8495781,NULL,NULL,NULL,NULL),(178,173,0,'LSQ12dnk','LSQ',10.49525,-25.1882222222222,NULL,NULL,'2012-07-10 09:22:11',56118.3487499999,18.3158,0.0486,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_history.html','outburst?',NULL,0.112638,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_snap_44197.gif',34798720798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,543730012,8495781,NULL,NULL,NULL,NULL),(179,173,0,'LSQ12dnk','LSQ',10.4952916666667,-25.1883888888889,NULL,NULL,'2012-07-10 11:06:12',56118.4209799999,18.519,0.0414,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_history.html','outburst?',NULL,0.112638,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_snap_44198.gif',34798720785,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,543730012,8495781,NULL,NULL,NULL,NULL),(180,173,0,'LSQ12dnk','LSQ',10.49525,-25.1883333333333,NULL,NULL,'2012-07-16 10:40:26',56124.4030900002,18.8746,0.0404,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_history.html','outburst?',NULL,0.112638,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_snap_44102.gif',34798720785,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,543730012,8495781,NULL,NULL,NULL,NULL),(181,173,0,'LSQ12dnk','LSQ',10.4953333333333,-25.1885277777778,NULL,NULL,'2012-07-16 11:36:36',56124.44209,18.5264,0.0447,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_history.html','outburst?',NULL,0.112638,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_snap_44103.gif',34798720787,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,543730012,8495781,NULL,NULL,NULL,NULL),(182,173,0,'LSQ12dnk','LSQ',10.4953333333333,-25.1883333333333,NULL,NULL,'2012-07-18 10:46:09',56126.4070600001,19.5664,0.0622,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_history.html','outburst?',NULL,0.112638,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_snap_44472.gif',34798720785,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,543730012,8495781,NULL,NULL,NULL,NULL),(183,173,0,'LSQ12dnk','LSQ',10.495375,-25.1881666666667,NULL,NULL,'2012-07-20 10:31:09',56128.3966399999,20.5188,0.1842,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_history.html','outburst?',NULL,0.112638,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_snap_44880.gif',34798720785,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,543730012,8495781,NULL,NULL,NULL,NULL),(184,173,0,'LSQ12dnk','LSQ',10.4953333333333,-25.1883888888889,NULL,NULL,'2012-07-22 08:21:50',56130.3068400002,20.0082,0.1216,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_history.html','outburst?',NULL,0.112638,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_snap_45144.gif',34798720785,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,543730012,8495781,NULL,NULL,NULL,NULL),(185,173,0,'LSQ12dnk','LSQ',10.49525,-25.1881111111111,NULL,NULL,'2012-07-24 10:38:46',56132.4019300002,18.101,0.0243,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_history.html','outburst?',NULL,0.112638,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_snap_45566.gif',34798720798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,543730012,8495781,NULL,NULL,NULL,NULL),(186,173,0,'LSQ12dnk','LSQ',10.49525,-25.1884444444444,NULL,NULL,'2012-07-24 11:35:00',56132.44098,18.3537,0.0416,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_history.html','outburst?',NULL,0.112638,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_snap_45567.gif',34798720787,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,543730012,8495781,NULL,NULL,NULL,NULL),(187,173,0,'LSQ12dnk','LSQ',10.4953333333333,-25.1884444444444,NULL,NULL,'2012-07-26 10:42:14',56134.4043399999,19.7322,0.0697,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_history.html','outburst?',NULL,0.112638,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_snap_46096.gif',34798720787,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,543730012,8495781,NULL,NULL,NULL,NULL),(188,173,0,'LSQ12dnk','LSQ',10.495375,-25.1883888888889,NULL,NULL,'2012-07-28 05:38:34',56136.1934600002,20.4626,0.1641,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_history.html','outburst?',NULL,0.112638,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dnk/LSQ12dnk_snap_46659.gif',34798720785,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,543730012,8495781,NULL,NULL,NULL,NULL),(189,189,1,'LSQ12dpx','LSQ',348.56125,-6.96694444444444,NULL,NULL,'2012-07-05 06:16:54',56113.2200799999,17.818,0.0659,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_snap_44411.gif',49602146390,NULL,NULL,NULL,'2012-06-30 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,775033537,12109899,NULL,NULL,NULL,NULL),(190,189,0,'LSQ12dpx','LSQ',348.561208333333,-6.96666666666667,NULL,NULL,'2012-07-05 08:15:59',56113.30277,17.9752,0.0497,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_snap_44412.gif',49602146390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,775033537,12109899,NULL,NULL,NULL,NULL),(191,189,0,'LSQ12dpx','LSQ',348.561208333333,-6.96658333333333,NULL,NULL,'2012-07-07 08:06:27',56115.2961499998,17.5734,0.0468,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_snap_44413.gif',49602146390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,775033537,12109899,NULL,NULL,NULL,NULL),(192,189,0,'LSQ12dpx','LSQ',348.561333333333,-6.9665,NULL,NULL,'2012-07-17 10:20:20',56125.38913,17.4705,0.0303,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_snap_44364.gif',49602146390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,775033537,12109899,NULL,NULL,NULL,NULL),(193,189,0,'LSQ12dpx','LSQ',348.561208333333,-6.96641666666667,NULL,NULL,'2012-07-17 11:05:21',56125.4203900001,17.6247,0.0298,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_snap_44365.gif',49602146390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,775033537,12109899,NULL,NULL,NULL,NULL),(194,189,0,'LSQ12dpx','LSQ',348.561333333333,-6.96663888888889,NULL,NULL,'2012-07-23 05:08:30',56131.17258,17.9871,0.0602,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_snap_45356.gif',49602146390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,775033537,12109899,NULL,NULL,NULL,NULL),(195,189,0,'LSQ12dpx','LSQ',348.561208333333,-6.96672222222222,NULL,NULL,'2012-07-25 11:10:56',56133.4242699998,17.801,0.0304,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_snap_45912.gif',49602146390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,775033537,12109899,NULL,NULL,NULL,NULL),(196,189,0,'LSQ12dpx','LSQ',348.561208333333,-6.96644444444444,NULL,NULL,'2012-07-25 11:26:12',56133.43487,17.3443,0.0271,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_snap_45913.gif',49602146390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,775033537,12109899,NULL,NULL,NULL,NULL),(197,189,0,'LSQ12dpx','LSQ',348.561166666667,-6.96675,NULL,NULL,'2012-07-31 10:47:47',56139.4081899999,18.4087,0.0553,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_snap_48819.gif',49602146390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,775033537,12109899,NULL,NULL,NULL,NULL),(198,198,1,'LSQ12dpw','LSQ',345.619791666667,-7.10825,NULL,NULL,'2012-07-05 07:58:29',56113.2906200001,19.315,0.1975,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpw/LSQ12dpw_history.html','sne or agn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpw/LSQ12dpw_snap_44403.gif',49487021214,NULL,NULL,NULL,'2012-06-30 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773234706,12081792,NULL,NULL,NULL,NULL),(199,198,0,'LSQ12dpw','LSQ',345.620083333333,-7.10830555555555,NULL,NULL,'2012-07-17 10:16:57',56125.3867799998,19.7948,0.1619,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpw/LSQ12dpw_history.html','sne or agn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpw/LSQ12dpw_snap_44362.gif',49487021214,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773234706,12081792,NULL,NULL,NULL,NULL),(200,198,0,'LSQ12dpw','LSQ',345.620208333333,-7.10833333333333,NULL,NULL,'2012-07-17 11:07:02',56125.4215600002,19.4497,0.129,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpw/LSQ12dpw_history.html','sne or agn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpw/LSQ12dpw_snap_44363.gif',49487021214,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773234706,12081792,NULL,NULL,NULL,NULL),(201,198,0,'LSQ12dpw','LSQ',345.620208333333,-7.10822222222222,NULL,NULL,'2012-07-25 11:07:34',56133.4219300002,20.2847,0.1816,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpw/LSQ12dpw_history.html','sne or agn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpw/LSQ12dpw_snap_45918.gif',49487021214,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773234706,12081792,NULL,NULL,NULL,NULL),(202,202,1,'LSQ12dpv','LSQ',337.130583333333,-6.07302777777778,NULL,NULL,'2012-07-09 05:11:53',56117.1749300002,20.0394,0.1492,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpv/LSQ12dpv_history.html','sne or agn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpv/LSQ12dpv_snap_44402.gif',50390558413,NULL,NULL,NULL,'2012-07-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,787352475,12302382,NULL,NULL,NULL,NULL),(203,202,0,'LSQ12dpv','LSQ',337.130625,-6.073,NULL,NULL,'2012-07-17 10:11:53',56125.38326,19.9201,0.1064,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpv/LSQ12dpv_history.html','sne or agn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpv/LSQ12dpv_snap_44360.gif',50390558413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,787352475,12302382,NULL,NULL,NULL,NULL),(204,202,0,'LSQ12dpv','LSQ',337.130583333333,-6.073,NULL,NULL,'2012-07-17 10:55:14',56125.4133600001,19.7412,0.0847,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpv/LSQ12dpv_history.html','sne or agn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpv/LSQ12dpv_snap_44361.gif',50390558413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,787352475,12302382,NULL,NULL,NULL,NULL),(205,202,0,'LSQ12dpv','LSQ',337.130625,-6.07291666666667,NULL,NULL,'2012-07-25 11:02:29',56133.4183999998,20.7785,0.1885,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpv/LSQ12dpv_history.html','sne or agn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpv/LSQ12dpv_snap_45916.gif',50390558413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,787352475,12302382,NULL,NULL,NULL,NULL),(206,202,0,'LSQ12dpv','LSQ',337.1305,-6.07291666666667,NULL,NULL,'2012-07-25 11:19:28',56133.4301900002,19.6917,0.0873,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpv/LSQ12dpv_history.html','sne or agn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpv/LSQ12dpv_snap_45917.gif',50390558413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,787352475,12302382,NULL,NULL,NULL,NULL),(207,202,0,'LSQ12dpv','LSQ',337.130541666667,-6.07280555555556,NULL,NULL,'2012-07-31 09:20:11',56139.3473499999,20.0047,0.2095,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpv/LSQ12dpv_history.html','sne or agn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpv/LSQ12dpv_snap_48822.gif',50390558413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,787352475,12302382,NULL,NULL,NULL,NULL),(208,208,1,'LSQ12dpq','LSQ',329.243,-7.13511111111111,NULL,NULL,'2012-07-05 04:53:40',56113.1622799998,17.3555,0.098,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_history.html','sne or agn',NULL,0.12054,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_snap_44386.gif',49923915501,NULL,NULL,NULL,'2012-06-30 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,780061179,12188455,NULL,NULL,NULL,NULL),(209,208,0,'LSQ12dpq','LSQ',329.242833333333,-7.13516666666667,NULL,NULL,'2012-07-05 06:55:35',56113.24694,19.2309,0.2007,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_history.html','sne or agn',NULL,0.12054,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_snap_44387.gif',49923915503,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,780061179,12188455,NULL,NULL,NULL,NULL),(210,208,0,'LSQ12dpq','LSQ',329.242708333333,-7.13538888888889,NULL,NULL,'2012-07-11 11:29:03',56119.4368500002,18.7863,0.122,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_history.html','sne or agn',NULL,0.12054,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_snap_44388.gif',49923915503,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,780061179,12188455,NULL,NULL,NULL,NULL),(211,208,0,'LSQ12dpq','LSQ',329.242416666667,-7.13552777777778,NULL,NULL,'2012-07-16 10:15:18',56124.3856299999,21.239,0.1356,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_history.html','sne or agn',NULL,0.12054,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_snap_44389.gif',49923915503,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,780061179,12188455,NULL,NULL,NULL,NULL),(212,208,0,'LSQ12dpq','LSQ',329.242875,-7.13516666666667,NULL,NULL,'2012-07-17 10:03:25',56125.37738,19.2508,0.1261,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_history.html','sne or agn',NULL,0.12054,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_snap_44350.gif',49923915503,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,780061179,12188455,NULL,NULL,NULL,NULL),(213,208,0,'LSQ12dpq','LSQ',329.243041666667,-7.13513888888889,NULL,NULL,'2012-07-17 10:51:51',56125.4110099999,18.4782,0.0415,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_history.html','sne or agn',NULL,0.12054,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_snap_44351.gif',49923915503,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,780061179,12188455,NULL,NULL,NULL,NULL),(214,208,0,'LSQ12dpq','LSQ',329.242791666667,-7.13511111111111,NULL,NULL,'2012-07-23 06:20:29',56131.2225600001,17.4667,0.0885,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_history.html','sne or agn',NULL,0.12054,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_snap_45332.gif',49923915501,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,780061179,12188455,NULL,NULL,NULL,NULL),(215,208,0,'LSQ12dpq','LSQ',329.242833333333,-7.135,NULL,NULL,'2012-07-27 06:03:03',56135.2104600002,18.9261,0.0974,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_history.html','sne or agn',NULL,0.12054,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_snap_46371.gif',49923915501,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,780061179,12188455,NULL,NULL,NULL,NULL),(216,216,1,'LSQ12dpp','LSQ',317.584625,-7.24022222222222,NULL,NULL,'2012-07-11 07:28:49',56119.2700200002,20.7192,0.1533,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_snap_44383.gif',50792332356,NULL,NULL,NULL,'2012-07-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793630193,12400471,NULL,NULL,NULL,NULL),(217,216,0,'LSQ12dpp','LSQ',317.5845,-7.24016666666667,NULL,NULL,'2012-07-12 10:33:32',56120.3982899999,20.6474,0.1599,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_snap_44384.gif',50792332356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793630193,12400471,NULL,NULL,NULL,NULL),(218,216,0,'LSQ12dpp','LSQ',317.584583333333,-7.24022222222222,NULL,NULL,'2012-07-16 09:44:05',56124.3639500001,20.6407,0.1308,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_snap_44385.gif',50792332356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793630193,12400471,NULL,NULL,NULL,NULL),(219,216,0,'LSQ12dpp','LSQ',317.584541666667,-7.24013888888889,NULL,NULL,'2012-07-17 07:47:36',56125.2830599998,20.6678,0.1272,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_snap_44348.gif',50792332356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793630193,12400471,NULL,NULL,NULL,NULL),(220,216,0,'LSQ12dpp','LSQ',317.584541666667,-7.24008333333333,NULL,NULL,'2012-07-17 09:26:00',56125.3514,20.3069,0.1112,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_snap_44349.gif',50792332356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793630193,12400471,NULL,NULL,NULL,NULL),(221,216,0,'LSQ12dpp','LSQ',317.584375,-7.24030555555556,NULL,NULL,'2012-07-18 06:35:51',56126.23324,21.0328,0.1833,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_snap_44506.gif',50792332356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793630193,12400471,NULL,NULL,NULL,NULL),(222,216,0,'LSQ12dpp','LSQ',317.584541666667,-7.24008333333333,NULL,NULL,'2012-07-19 05:13:55',56127.1763399998,20.9929,0.1767,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_snap_44757.gif',50792332356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793630193,12400471,NULL,NULL,NULL,NULL),(223,216,0,'LSQ12dpp','LSQ',317.584541666667,-7.24002777777778,NULL,NULL,'2012-07-24 02:56:41',56132.0810400001,20.7714,0.1473,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_snap_45595.gif',50792332356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793630193,12400471,NULL,NULL,NULL,NULL),(224,216,0,'LSQ12dpp','LSQ',317.5845,-7.24019444444444,NULL,NULL,'2012-07-24 08:51:56',56132.3277400001,20.7264,0.162,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_snap_45596.gif',50792332356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793630193,12400471,NULL,NULL,NULL,NULL),(225,216,0,'LSQ12dpp','LSQ',317.5845,-7.24030555555556,NULL,NULL,'2012-07-24 08:57:19',56132.3314800002,21.1058,0.1272,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_snap_45597.gif',50792332356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793630193,12400471,NULL,NULL,NULL,NULL),(226,216,0,'LSQ12dpp','LSQ',317.584625,-7.24008333333333,NULL,NULL,'2012-07-25 06:41:30',56133.23716,20.9601,0.1574,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_snap_45872.gif',50792332356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793630193,12400471,NULL,NULL,NULL,NULL),(227,216,0,'LSQ12dpp','LSQ',317.584458333333,-7.24019444444444,NULL,NULL,'2012-07-31 08:35:43',56139.31647,19.9383,0.1713,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpp/LSQ12dpp_snap_48802.gif',50792332356,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793630193,12400471,NULL,NULL,NULL,NULL),(228,228,1,'LSQ12dpn','LSQ',47.8050833333333,-5.48566666666667,NULL,NULL,'2012-07-17 09:58:54',56125.3742399998,19.1269,0.1218,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_snap_44344.gif',37858580920,NULL,NULL,NULL,'2012-07-17 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591540326,9242817,NULL,NULL,NULL,NULL),(229,228,0,'LSQ12dpn','LSQ',47.8050833333333,-5.48569444444444,NULL,NULL,'2012-07-17 11:16:35',56125.4281899999,19.367,0.1264,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_snap_44345.gif',37858580920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591540326,9242817,NULL,NULL,NULL,NULL),(230,228,0,'LSQ12dpn','LSQ',47.80525,-5.48561111111111,NULL,NULL,'2012-07-21 11:19:52',56129.43047,18.8779,0.1976,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_snap_45029.gif',37858580920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591540326,9242817,NULL,NULL,NULL,NULL),(231,228,0,'LSQ12dpn','LSQ',47.80525,-5.48566666666667,NULL,NULL,'2012-07-23 10:57:48',56131.4151499998,18.9324,0.1918,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_snap_45345.gif',37858580920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591540326,9242817,NULL,NULL,NULL,NULL),(232,228,0,'LSQ12dpn','LSQ',47.8050833333333,-5.48569444444444,NULL,NULL,'2012-07-25 10:52:55',56133.41175,18.5104,0.0726,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_snap_45868.gif',37858580920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591540326,9242817,NULL,NULL,NULL,NULL),(233,228,0,'LSQ12dpn','LSQ',47.805125,-5.48569444444444,NULL,NULL,'2012-07-25 11:35:43',56133.44148,18.5765,0.135,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_snap_45869.gif',37858580920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591540326,9242817,NULL,NULL,NULL,NULL),(234,228,0,'LSQ12dpn','LSQ',47.80525,-5.48572222222222,NULL,NULL,'2012-07-27 08:49:37',56135.3261299999,18.573,0.0883,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_snap_46372.gif',37858580920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591540326,9242817,NULL,NULL,NULL,NULL),(235,228,0,'LSQ12dpn','LSQ',47.805125,-5.48572222222222,NULL,NULL,'2012-07-27 10:53:42',56135.4123,18.7979,0.0648,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_snap_46373.gif',37858580920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591540326,9242817,NULL,NULL,NULL,NULL),(236,228,0,'LSQ12dpn','LSQ',47.8052083333333,-5.48572222222222,NULL,NULL,'2012-07-29 08:40:39',56137.3199,18.6224,0.0974,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_snap_47382.gif',37858580920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591540326,9242817,NULL,NULL,NULL,NULL),(237,228,0,'LSQ12dpn','LSQ',47.8051666666667,-5.48572222222222,NULL,NULL,'2012-07-29 10:54:36',56137.41292,18.8624,0.0646,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_snap_47383.gif',37858580920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591540326,9242817,NULL,NULL,NULL,NULL),(238,228,0,'LSQ12dpn','LSQ',47.8050416666667,-5.48577777777778,NULL,NULL,'2012-07-31 08:38:45',56139.3185800002,18.8245,0.1377,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_snap_48794.gif',37858580920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591540326,9242817,NULL,NULL,NULL,NULL),(239,228,0,'LSQ12dpn','LSQ',47.8047083333333,-5.48544444444444,NULL,NULL,'2012-08-04 10:13:01',56143.38405,18.8081,0.1968,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_snap_49566.gif',37858580920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591540326,9242817,NULL,NULL,NULL,NULL),(240,240,1,'LSQ12dpl','LSQ',40.6969583333333,-4.93511111111111,NULL,NULL,'2012-07-09 10:36:33',56117.4003900001,20.086,0.1464,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpl/LSQ12dpl_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpl/LSQ12dpl_snap_44380.gif',34905732548,NULL,NULL,NULL,'2012-07-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,545402071,8521907,NULL,NULL,NULL,NULL),(241,240,0,'LSQ12dpl','LSQ',40.69675,-4.93547222222222,NULL,NULL,'2012-07-17 09:52:07',56125.3695299998,20.4515,0.1334,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpl/LSQ12dpl_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpl/LSQ12dpl_snap_44340.gif',34905732548,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,545402071,8521907,NULL,NULL,NULL,NULL),(242,240,0,'LSQ12dpl','LSQ',40.696875,-4.93530555555556,NULL,NULL,'2012-07-17 11:19:57',56125.43053,20.4567,0.1318,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpl/LSQ12dpl_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpl/LSQ12dpl_snap_44341.gif',34905732548,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,545402071,8521907,NULL,NULL,NULL,NULL),(243,240,0,'LSQ12dpl','LSQ',40.69675,-4.93544444444444,NULL,NULL,'2012-07-27 08:18:13',56135.3043200001,20.4527,0.1364,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpl/LSQ12dpl_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpl/LSQ12dpl_snap_46358.gif',34905732548,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,545402071,8521907,NULL,NULL,NULL,NULL),(244,240,0,'LSQ12dpl','LSQ',40.6969583333333,-4.93525,NULL,NULL,'2012-07-27 11:10:12',56135.4237600002,20.5855,0.1337,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpl/LSQ12dpl_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpl/LSQ12dpl_snap_46359.gif',34905732548,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,545402071,8521907,NULL,NULL,NULL,NULL),(245,245,1,'LSQ12dpk','LSQ',35.6905833333333,-2.87938888888889,NULL,NULL,'2012-07-17 09:48:44',56125.3671800001,20.2081,0.157,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpk/LSQ12dpk_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpk/LSQ12dpk_snap_44338.gif',34928386426,NULL,NULL,NULL,'2012-07-15 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,545756037,8527438,NULL,NULL,NULL,NULL),(246,245,0,'LSQ12dpk','LSQ',35.6907083333333,-2.87930555555556,NULL,NULL,'2012-07-17 11:21:38',56125.4317000001,20.3766,0.1659,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpk/LSQ12dpk_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpk/LSQ12dpk_snap_44339.gif',34928386426,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,545756037,8527438,NULL,NULL,NULL,NULL),(247,245,0,'LSQ12dpk','LSQ',35.6905416666667,-2.87944444444444,NULL,NULL,'2012-07-27 09:51:31',56135.3691199999,20.1637,0.1363,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpk/LSQ12dpk_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpk/LSQ12dpk_snap_46379.gif',34928386426,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,545756037,8527438,NULL,NULL,NULL,NULL),(248,245,0,'LSQ12dpk','LSQ',35.69075,-2.8795,NULL,NULL,'2012-07-29 08:08:47',56137.2977700001,20.0237,0.2156,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpk/LSQ12dpk_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpk/LSQ12dpk_snap_47402.gif',34928386426,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,545756037,8527438,NULL,NULL,NULL,NULL),(249,245,0,'LSQ12dpk','LSQ',35.6905416666667,-2.87936111111111,NULL,NULL,'2012-07-29 11:12:49',56137.42557,20.3446,0.1502,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpk/LSQ12dpk_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpk/LSQ12dpk_snap_47403.gif',34928386426,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,545756037,8527438,NULL,NULL,NULL,NULL),(250,250,1,'LSQ12dpi','LSQ',18.804625,-3.19494444444444,NULL,NULL,'2012-07-07 10:15:27',56115.3857399998,19.094,0.1575,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_snap_44407.gif',34503822819,NULL,NULL,NULL,'2012-07-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539122231,8423784,NULL,NULL,NULL,NULL),(251,250,0,'LSQ12dpi','LSQ',18.804625,-3.19497222222222,NULL,NULL,'2012-07-09 08:06:48',56117.2963999999,19.4463,0.1839,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_snap_44408.gif',34503822819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539122231,8423784,NULL,NULL,NULL,NULL),(252,250,0,'LSQ12dpi','LSQ',18.8044583333333,-3.19480555555556,NULL,NULL,'2012-07-09 10:31:25',56117.3968199999,18.8455,0.0979,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_snap_44409.gif',34503822819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539122231,8423784,NULL,NULL,NULL,NULL),(253,250,0,'LSQ12dpi','LSQ',18.8045416666667,-3.19486111111111,NULL,NULL,'2012-07-11 10:27:57',56119.3944100002,18.7576,0.0847,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_snap_44410.gif',34503822819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539122231,8423784,NULL,NULL,NULL,NULL),(254,250,0,'LSQ12dpi','LSQ',18.804625,-3.19486111111111,NULL,NULL,'2012-07-17 09:35:11',56125.3577700001,19.7269,0.1266,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_snap_44332.gif',34503822819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539122231,8423784,NULL,NULL,NULL,NULL),(255,250,0,'LSQ12dpi','LSQ',18.8042916666667,-3.19491666666667,NULL,NULL,'2012-07-17 11:28:25',56125.4364100001,19.1614,0.1308,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_snap_44333.gif',34503822819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539122231,8423784,NULL,NULL,NULL,NULL),(256,250,0,'LSQ12dpi','LSQ',18.8047916666667,-3.19480555555556,NULL,NULL,'2012-07-19 11:18:52',56127.4297799999,19.9354,0.1544,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_snap_44756.gif',34503822819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539122231,8423784,NULL,NULL,NULL,NULL),(257,250,0,'LSQ12dpi','LSQ',18.8045833333333,-3.19486111111111,NULL,NULL,'2012-07-21 09:27:53',56129.3527000002,18.1869,0.0639,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_snap_45031.gif',34503822819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539122231,8423784,NULL,NULL,NULL,NULL),(258,250,0,'LSQ12dpi','LSQ',18.80475,-3.195,NULL,NULL,'2012-07-25 10:29:44',56133.3956499998,19.7893,0.1302,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_snap_45876.gif',34503822819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539122231,8423784,NULL,NULL,NULL,NULL),(259,250,0,'LSQ12dpi','LSQ',18.80475,-3.19497222222222,NULL,NULL,'2012-07-27 07:50:22',56135.28498,19.6003,0.1201,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_snap_46369.gif',34503822819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539122231,8423784,NULL,NULL,NULL,NULL),(260,250,0,'LSQ12dpi','LSQ',18.8046666666667,-3.19491666666667,NULL,NULL,'2012-07-29 09:41:08',56137.3618999999,19.649,0.1255,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_snap_47379.gif',34503822819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539122231,8423784,NULL,NULL,NULL,NULL),(261,261,1,'LSQ12dqy','LSQ',215.646916666667,-24.4561944444444,NULL,NULL,'2012-07-08 00:35:13',56115.9827899998,20.316,0.1267,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqy/LSQ12dqy_history.html','possible sn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqy/LSQ12dqy_snap_44673.gif',46565389206,NULL,NULL,NULL,'2012-07-06 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,727584206,11368503,NULL,NULL,NULL,NULL),(262,261,0,'LSQ12dqy','LSQ',215.647166666667,-24.45625,NULL,NULL,'2012-07-08 02:36:08',56116.0667599998,20.3079,0.1964,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqy/LSQ12dqy_history.html','possible sn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqy/LSQ12dqy_snap_44674.gif',46565389206,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,727584206,11368503,NULL,NULL,NULL,NULL),(263,261,0,'LSQ12dqy','LSQ',215.647,-24.45625,NULL,NULL,'2012-07-10 00:50:54',56117.9936899999,20.1211,0.1173,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqy/LSQ12dqy_history.html','possible sn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqy/LSQ12dqy_snap_44675.gif',46565389206,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,727584206,11368503,NULL,NULL,NULL,NULL),(264,261,0,'LSQ12dqy','LSQ',215.646875,-24.4563055555556,NULL,NULL,'2012-07-16 00:28:53',56123.9783999999,20.0568,0.1092,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqy/LSQ12dqy_history.html','possible sn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqy/LSQ12dqy_snap_44676.gif',46565389206,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,727584206,11368503,NULL,NULL,NULL,NULL),(265,261,0,'LSQ12dqy','LSQ',215.646916666667,-24.45625,NULL,NULL,'2012-07-18 00:23:33',56125.9746900001,20.0953,0.1174,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqy/LSQ12dqy_history.html','possible sn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqy/LSQ12dqy_snap_44650.gif',46565389206,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,727584206,11368503,NULL,NULL,NULL,NULL),(266,261,0,'LSQ12dqy','LSQ',215.646958333333,-24.45625,NULL,NULL,'2012-07-18 02:31:08',56126.06329,20.1626,0.105,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqy/LSQ12dqy_history.html','possible sn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqy/LSQ12dqy_snap_44651.gif',46565389206,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,727584206,11368503,NULL,NULL,NULL,NULL),(267,261,0,'LSQ12dqy','LSQ',215.646833333333,-24.4562777777778,NULL,NULL,'2012-07-24 01:16:31',56132.0114699998,20.7291,0.1603,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqy/LSQ12dqy_history.html','possible sn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqy/LSQ12dqy_snap_45617.gif',46565389206,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,727584206,11368503,NULL,NULL,NULL,NULL),(268,268,1,'LSQ12dqv','LSQ',213.945583333333,-18.4865277777778,NULL,NULL,'2012-07-08 00:28:24',56115.9780600001,20.1496,0.1545,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqv/LSQ12dqv_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqv/LSQ12dqv_snap_44713.gif',46563340370,NULL,NULL,NULL,'2012-07-06 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,727552193,11368003,NULL,NULL,NULL,NULL),(269,268,0,'LSQ12dqv','LSQ',213.945708333333,-18.4865,NULL,NULL,'2012-07-10 00:35:08',56117.9827399999,19.7451,0.1626,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqv/LSQ12dqv_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqv/LSQ12dqv_snap_44714.gif',46563340381,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,727552193,11368003,NULL,NULL,NULL,NULL),(270,268,0,'LSQ12dqv','LSQ',213.945625,-18.4864722222222,NULL,NULL,'2012-07-16 00:21:57',56123.97358,18.648,0.0994,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqv/LSQ12dqv_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqv/LSQ12dqv_snap_44715.gif',46563340381,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,727552193,11368003,NULL,NULL,NULL,NULL),(271,268,0,'LSQ12dqv','LSQ',213.945583333333,-18.4864444444444,NULL,NULL,'2012-07-18 00:16:42',56125.9699400002,18.4675,0.0768,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqv/LSQ12dqv_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqv/LSQ12dqv_snap_44644.gif',46563340381,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,727552193,11368003,NULL,NULL,NULL,NULL),(272,268,0,'LSQ12dqv','LSQ',213.945625,-18.4864722222222,NULL,NULL,'2012-07-18 02:18:28',56126.0545000001,18.7975,0.0624,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqv/LSQ12dqv_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqv/LSQ12dqv_snap_44645.gif',46563340381,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,727552193,11368003,NULL,NULL,NULL,NULL),(273,268,0,'LSQ12dqv','LSQ',213.945708333333,-18.4864722222222,NULL,NULL,'2012-07-24 01:26:39',56132.0185099998,18.5352,0.0859,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqv/LSQ12dqv_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqv/LSQ12dqv_snap_45613.gif',46563340381,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,727552193,11368003,NULL,NULL,NULL,NULL),(274,268,0,'LSQ12dqv','LSQ',213.945625,-18.4865,NULL,NULL,'2012-07-28 00:54:16',56135.99602,18.583,0.1211,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqv/LSQ12dqv_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dqv/LSQ12dqv_snap_46690.gif',46563340381,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,727552193,11368003,NULL,NULL,NULL,NULL),(275,275,1,'LSQ12drx','LSQ',22.887125,-22.3731388888889,NULL,NULL,'2012-07-10 09:34:03',56118.3569800002,20.358,0.1772,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_45244.gif',35176085309,NULL,NULL,NULL,'2012-07-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(276,275,0,'LSQ12drx','LSQ',22.8871666666667,-22.3730833333333,NULL,NULL,'2012-07-10 10:54:20',56118.4127400001,20.3446,0.1681,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_45245.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(277,275,0,'LSQ12drx','LSQ',22.8871666666667,-22.3731111111111,NULL,NULL,'2012-07-16 10:52:17',56124.4113099999,20.4711,0.1447,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_45246.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(278,275,0,'LSQ12drx','LSQ',22.887125,-22.3731111111111,NULL,NULL,'2012-07-16 11:16:20',56124.4280099999,20.7813,0.1735,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_45247.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(279,275,0,'LSQ12drx','LSQ',22.887125,-22.3731388888889,NULL,NULL,'2012-07-18 10:58:01',56126.4152899999,20.408,0.1524,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_45248.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(280,275,0,'LSQ12drx','LSQ',22.8872916666667,-22.3731111111111,NULL,NULL,'2012-07-18 11:32:09',56126.4389999998,19.9927,0.1917,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_45249.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(281,275,0,'LSQ12drx','LSQ',22.8871666666667,-22.3731388888889,NULL,NULL,'2012-07-20 10:48:03',56128.4083699998,19.9296,0.1755,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_45250.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(282,275,0,'LSQ12drx','LSQ',22.8871666666667,-22.3731111111111,NULL,NULL,'2012-07-20 11:34:02',56128.44031,20.1197,0.1372,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_45251.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(283,275,0,'LSQ12drx','LSQ',22.8870833333333,-22.3731666666667,NULL,NULL,'2012-07-22 08:33:40',56130.3150499999,19.9378,0.1273,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_45242.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(284,275,0,'LSQ12drx','LSQ',22.887125,-22.3730833333333,NULL,NULL,'2012-07-22 10:04:50',56130.37836,20.0243,0.1371,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_45243.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(285,275,0,'LSQ12drx','LSQ',22.887125,-22.3731388888889,NULL,NULL,'2012-07-24 10:50:38',56132.41017,19.5832,0.0842,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_45548.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(286,275,0,'LSQ12drx','LSQ',22.8870833333333,-22.3731111111111,NULL,NULL,'2012-07-24 11:12:57',56132.4256699998,19.4542,0.08,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_45549.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(287,275,0,'LSQ12drx','LSQ',22.887125,-22.3730833333333,NULL,NULL,'2012-07-26 09:02:07',56134.3348099999,19.3318,0.0756,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_46086.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(288,275,0,'LSQ12drx','LSQ',22.8871666666667,-22.3731111111111,NULL,NULL,'2012-07-26 10:26:45',56134.3935799999,19.3796,0.0749,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_46087.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(289,275,0,'LSQ12drx','LSQ',22.887,-22.3731388888889,NULL,NULL,'2012-07-28 06:35:26',56136.2329500001,19.3754,0.1113,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_46633.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(290,275,0,'LSQ12drx','LSQ',22.8871666666667,-22.3731666666667,NULL,NULL,'2012-07-28 08:35:11',56136.31611,19.3953,0.0843,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_46634.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(291,275,0,'LSQ12drx','LSQ',22.8871666666667,-22.3730277777778,NULL,NULL,'2012-07-30 07:07:07',56138.25495,19.6008,0.1946,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_48375.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(292,275,0,'LSQ12drx','LSQ',22.8871666666667,-22.3731388888889,NULL,NULL,'2012-07-30 09:08:39',56138.33935,19.3977,0.1045,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_history.html','galaxy merger',NULL,0.110143,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drx/LSQ12drx_snap_48376.gif',35176085309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,549626332,8587911,NULL,NULL,NULL,NULL),(293,293,1,'LSQ12dsr','LSQ',217.725958333333,-5.55697222222222,NULL,NULL,'2012-07-17 00:19:37',56124.9719600002,20.1075,0.1152,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsr/LSQ12dsr_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsr/LSQ12dsr_snap_45758.gif',43551714785,NULL,NULL,NULL,'2012-07-13 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,680495543,10632742,NULL,NULL,NULL,NULL),(294,293,0,'LSQ12dsr','LSQ',217.726,-5.55691666666667,NULL,NULL,'2012-07-19 00:14:36',56126.9684799998,19.7758,0.1182,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsr/LSQ12dsr_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsr/LSQ12dsr_snap_45759.gif',43551714785,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,680495543,10632742,NULL,NULL,NULL,NULL),(295,293,0,'LSQ12dsr','LSQ',217.726083333333,-5.55691666666667,NULL,NULL,'2012-07-23 01:53:51',56131.0373999998,19.4451,0.0724,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsr/LSQ12dsr_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsr/LSQ12dsr_snap_45729.gif',43551714785,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,680495543,10632742,NULL,NULL,NULL,NULL),(296,293,0,'LSQ12dsr','LSQ',217.726041666667,-5.55688888888889,NULL,NULL,'2012-07-23 02:00:44',56131.0421799999,19.655,0.0847,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsr/LSQ12dsr_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsr/LSQ12dsr_snap_45730.gif',43551714785,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,680495543,10632742,NULL,NULL,NULL,NULL),(297,297,1,'LSQ12dsc','LSQ',244.916291666667,4.21602777777778,NULL,NULL,'2012-07-19 01:31:21',56127.0217800001,20.2766,0.1583,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsc/LSQ12dsc_history.html','possible sne ',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsc/LSQ12dsc_snap_45750.gif',56499892140,NULL,NULL,NULL,'2012-07-15 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,882810814,13793918,NULL,NULL,NULL,NULL),(298,297,0,'LSQ12dsc','LSQ',244.916416666667,4.21613888888889,NULL,NULL,'2012-07-23 01:14:44',56131.0102400002,19.9232,0.1404,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsc/LSQ12dsc_history.html','possible sne ',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsc/LSQ12dsc_snap_45697.gif',56499892140,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,882810814,13793918,NULL,NULL,NULL,NULL),(299,297,0,'LSQ12dsc','LSQ',244.916458333333,4.21597222222222,NULL,NULL,'2012-07-23 01:45:13',56131.0314099998,20.1838,0.1362,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsc/LSQ12dsc_history.html','possible sne ',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsc/LSQ12dsc_snap_45698.gif',56499892140,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,882810814,13793918,NULL,NULL,NULL,NULL),(300,297,0,'LSQ12dsc','LSQ',244.916333333333,4.21602777777778,NULL,NULL,'2012-07-27 01:28:59',56135.0201300001,19.8902,0.2053,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsc/LSQ12dsc_history.html','possible sne ',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsc/LSQ12dsc_snap_46382.gif',56499892140,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,882810814,13793918,NULL,NULL,NULL,NULL),(301,297,0,'LSQ12dsc','LSQ',244.916458333333,4.21616666666667,NULL,NULL,'2012-07-29 00:50:17',56136.9932599999,19.4438,0.194,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsc/LSQ12dsc_history.html','possible sne ',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsc/LSQ12dsc_snap_47384.gif',56499892140,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,882810814,13793918,NULL,NULL,NULL,NULL),(302,302,1,'LSQ12dsb','LSQ',227.564333333333,3.53186111111111,NULL,NULL,'2012-07-13 00:33:06',56120.9813199998,20.5262,0.1508,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsb/LSQ12dsb_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsb/LSQ12dsb_snap_45747.gif',56381043115,NULL,NULL,NULL,'2012-07-11 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,880953798,13764903,NULL,NULL,NULL,NULL),(303,302,0,'LSQ12dsb','LSQ',227.564333333333,3.53186111111111,NULL,NULL,'2012-07-17 00:28:11',56124.9779099999,19.8049,0.1057,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsb/LSQ12dsb_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsb/LSQ12dsb_snap_45748.gif',56381043115,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,880953798,13764903,NULL,NULL,NULL,NULL),(304,302,0,'LSQ12dsb','LSQ',227.56425,3.53191666666667,NULL,NULL,'2012-07-19 00:23:08',56126.9744000002,19.3974,0.1296,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsb/LSQ12dsb_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsb/LSQ12dsb_snap_45749.gif',56381043115,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,880953798,13764903,NULL,NULL,NULL,NULL),(305,302,0,'LSQ12dsb','LSQ',227.564375,3.53188888888889,NULL,NULL,'2012-07-23 00:10:56',56130.9659299999,19.4943,0.1037,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsb/LSQ12dsb_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsb/LSQ12dsb_snap_45695.gif',56381043115,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,880953798,13764903,NULL,NULL,NULL,NULL),(306,302,0,'LSQ12dsb','LSQ',227.564333333333,3.53186111111111,NULL,NULL,'2012-07-23 01:48:41',56131.0338099999,19.3666,0.0855,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsb/LSQ12dsb_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsb/LSQ12dsb_snap_45696.gif',56381043115,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,880953798,13764903,NULL,NULL,NULL,NULL),(307,307,1,'LSQ12drz','LSQ',252.072625,19.2898333333333,NULL,NULL,'2012-07-23 00:47:21',56130.9912200002,19.0912,0.059,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drz/LSQ12drz_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drz/LSQ12drz_snap_45691.gif',56682128644,NULL,NULL,NULL,'2012-07-19 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,885658260,13838410,NULL,NULL,NULL,NULL),(308,307,0,'LSQ12drz','LSQ',252.072708333333,19.2897777777778,NULL,NULL,'2012-07-23 02:47:21',56131.0745600001,18.67,0.1103,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drz/LSQ12drz_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drz/LSQ12drz_snap_45692.gif',56682128644,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,885658260,13838410,NULL,NULL,NULL,NULL),(309,307,0,'LSQ12drz','LSQ',252.072625,19.2898611111111,NULL,NULL,'2012-07-27 01:58:25',56135.0405700002,19.1014,0.1091,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drz/LSQ12drz_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drz/LSQ12drz_snap_46390.gif',56682130440,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,885658288,13838410,NULL,NULL,NULL,NULL),(310,307,0,'LSQ12drz','LSQ',252.07275,19.2897777777778,NULL,NULL,'2012-07-27 03:16:30',56135.0948000001,19.1691,0.1152,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drz/LSQ12drz_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drz/LSQ12drz_snap_46391.gif',56682128644,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,885658260,13838410,NULL,NULL,NULL,NULL),(311,307,0,'LSQ12drz','LSQ',252.072458333333,19.28975,NULL,NULL,'2012-07-29 02:23:31',56137.0580000002,19.0147,0.1713,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drz/LSQ12drz_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12drz/LSQ12drz_snap_47397.gif',56682128644,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,885658260,13838410,NULL,NULL,NULL,NULL),(312,312,1,'LSQ12dxl','LSQ',254.771,16.6041111111111,NULL,NULL,'2012-07-07 03:59:11',56115.1244399999,20.6517,0.1914,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dxl/LSQ12dxl_history.html','galactic variability',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dxl/LSQ12dxl_snap_47809.gif',56901257269,NULL,NULL,NULL,'2012-07-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,889082144,13891908,NULL,NULL,NULL,NULL),(313,312,0,'LSQ12dxl','LSQ',254.771125,16.6040833333333,NULL,NULL,'2012-07-09 01:30:12',56117.02098,20.1972,0.0952,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dxl/LSQ12dxl_history.html','galactic variability',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dxl/LSQ12dxl_snap_47810.gif',56901257269,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,889082144,13891908,NULL,NULL,NULL,NULL),(314,312,0,'LSQ12dxl','LSQ',254.771083333333,16.604,NULL,NULL,'2012-07-27 00:49:55',56134.9929999998,19.9522,0.1559,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dxl/LSQ12dxl_history.html','galactic variability',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dxl/LSQ12dxl_snap_47726.gif',56901257226,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,889082144,13891908,NULL,NULL,NULL,NULL),(315,312,0,'LSQ12dxl','LSQ',254.771083333333,16.6039166666667,NULL,NULL,'2012-07-27 02:50:36',56135.07681,20.4601,0.1429,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dxl/LSQ12dxl_history.html','galactic variability',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dxl/LSQ12dxl_snap_47727.gif',56901257226,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,889082144,13891908,NULL,NULL,NULL,NULL),(316,316,1,'LSQ12dww','LSQ',229.472291666667,4.87497222222222,NULL,NULL,'2012-07-05 00:48:02',56112.9916900001,19.6549,0.1233,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_history.html','sne-pec',NULL,0.04572,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_snap_47738.gif',56380598798,NULL,NULL,NULL,'2012-06-03 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(317,316,0,'LSQ12dww','LSQ',229.472208333333,4.87491666666667,NULL,NULL,'2012-07-05 02:48:44',56113.07552,20.0415,0.2012,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_history.html','sne-pec',NULL,0.04572,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_snap_47739.gif',56380598798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(318,316,0,'LSQ12dww','LSQ',229.472208333333,4.87491666666667,NULL,NULL,'2012-07-07 01:15:33',56115.0108099999,20.7136,0.184,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_history.html','sne-pec',NULL,0.04572,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_snap_47740.gif',56380598798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(319,316,0,'LSQ12dww','LSQ',229.472208333333,4.87491666666667,NULL,NULL,'2012-07-07 03:16:23',56115.0947199999,19.8764,0.1241,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_history.html','sne-pec',NULL,0.04572,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_snap_47741.gif',56380598798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(320,316,0,'LSQ12dww','LSQ',229.472291666667,4.87494444444444,NULL,NULL,'2012-07-09 00:47:11',56116.9911099998,19.9205,0.0979,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_history.html','sne-pec',NULL,0.04572,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_snap_47742.gif',56380598798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(321,316,0,'LSQ12dww','LSQ',229.47225,4.87497222222222,NULL,NULL,'2012-07-09 02:47:47',56117.0748600001,19.9743,0.1049,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_history.html','sne-pec',NULL,0.04572,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_snap_47743.gif',56380598798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(322,316,0,'LSQ12dww','LSQ',229.472333333333,4.875,NULL,NULL,'2012-07-11 00:44:17',56118.9890899998,20.0801,0.1097,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_history.html','sne-pec',NULL,0.04572,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_snap_47744.gif',56380598798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(323,316,0,'LSQ12dww','LSQ',229.472208333333,4.87494444444444,NULL,NULL,'2012-07-13 00:45:15',56120.9897599998,20.0111,0.1108,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_history.html','sne-pec',NULL,0.04572,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_snap_47745.gif',56380598798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(324,316,0,'LSQ12dww','LSQ',229.472208333333,4.875,NULL,NULL,'2012-07-17 00:40:16',56124.9863,19.7383,0.0873,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_history.html','sne-pec',NULL,0.04572,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_snap_47746.gif',56380598798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(325,316,0,'LSQ12dww','LSQ',229.47225,4.87494444444444,NULL,NULL,'2012-07-19 00:38:51',56126.98532,20.4226,0.1463,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_history.html','sne-pec',NULL,0.04572,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_snap_47747.gif',56380598798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(326,316,0,'LSQ12dww','LSQ',229.47225,4.87497222222222,NULL,NULL,'2012-07-23 00:26:40',56130.9768599998,19.9327,0.1169,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_history.html','sne-pec',NULL,0.04572,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_snap_47748.gif',56380598798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(327,316,0,'LSQ12dww','LSQ',229.472291666667,4.87497222222222,NULL,NULL,'2012-07-23 02:26:48',56131.0602799999,20.2465,0.2142,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_history.html','sne-pec',NULL,0.04572,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_snap_47749.gif',56380598798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(328,316,0,'LSQ12dww','LSQ',229.472291666667,4.87486111111111,NULL,NULL,'2012-07-27 02:17:13',56135.05363,19.996,0.1675,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_history.html','sne-pec',NULL,0.04572,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_snap_47696.gif',56380598798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(329,316,0,'LSQ12dww','LSQ',229.472416666667,4.87486111111111,NULL,NULL,'2012-07-27 02:26:11',56135.0598599999,19.6131,0.1312,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_history.html','sne-pec',NULL,0.04572,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_snap_47697.gif',56380598798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(330,316,0,'LSQ12dww','LSQ',229.4725,4.87486111111111,NULL,NULL,'2012-07-29 01:41:42',56137.0289599998,19.4218,0.1747,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_history.html','sne-pec',NULL,0.04572,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_snap_47829.gif',56380598798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(331,316,0,'LSQ12dww','LSQ',229.472416666667,4.87491666666667,NULL,NULL,'2012-07-29 01:45:04',56137.0312999999,19.0573,0.1888,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_history.html','sne-pec',NULL,0.04572,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dww/LSQ12dww_snap_47830.gif',56380598798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(332,332,1,'LSQ12dwl','LSQ',333.173125,0.511972222222222,NULL,NULL,'2012-07-27 03:59:55',56135.1249500001,15.923,0.0096,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_history.html','sne-nice!',NULL,0.01377,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_snap_47674.gif',52152344380,NULL,NULL,NULL,'2012-07-23 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814880380,12732505,NULL,NULL,NULL,NULL),(333,332,0,'LSQ12dwl','LSQ',333.173125,0.511972222222222,NULL,NULL,'2012-07-27 06:14:55',56135.2187000001,15.7761,0.0069,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_history.html','sne-nice!',NULL,0.01377,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_snap_47675.gif',52152344380,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814880380,12732505,NULL,NULL,NULL,NULL),(334,332,0,'LSQ12dwl','LSQ',333.173125,0.511972222222222,NULL,NULL,'2012-07-29 03:54:34',56137.1212300002,15.3768,0.0072,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_history.html','sne-nice!',NULL,0.01377,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_snap_47823.gif',52152344380,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814880380,12732505,NULL,NULL,NULL,NULL),(335,332,0,'LSQ12dwl','LSQ',333.173125,0.511972222222222,NULL,NULL,'2012-07-29 06:11:17',56137.2161699999,15.2692,0.0054,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_history.html','sne-nice!',NULL,0.01377,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_snap_47824.gif',52152344380,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814880380,12732505,NULL,NULL,NULL,NULL),(336,336,1,'LSQ12dwf','LSQ',323.475041666667,0.149083333333333,NULL,NULL,'2012-07-24 03:43:01',56132.1132100001,20.4806,0.0995,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_history.html','sn',NULL,0.12212,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_snap_47194.gif',52106900277,NULL,NULL,NULL,'2012-07-23 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,814170316,12721411,NULL,NULL,NULL,NULL),(337,336,0,'LSQ12dwf','LSQ',323.474958333333,0.149055555555556,NULL,NULL,'2012-07-24 06:56:32',56132.2475999999,20.7393,0.1449,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_history.html','sn',NULL,0.12212,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_snap_47195.gif',52106900276,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,814170316,12721411,NULL,NULL,NULL,NULL),(338,336,0,'LSQ12dwf','LSQ',323.474958333333,0.149,NULL,NULL,'2012-07-24 09:23:24',56132.3495900002,20.7981,0.1187,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_history.html','sn',NULL,0.12212,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_snap_47196.gif',52106900232,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,814170316,12721411,NULL,NULL,NULL,NULL),(339,336,0,'LSQ12dwf','LSQ',323.475166666667,0.149083333333333,NULL,NULL,'2012-07-27 03:37:56',56135.1096800002,20.1494,0.1527,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_history.html','sn',NULL,0.12212,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_snap_47108.gif',52106900277,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,814170316,12721411,NULL,NULL,NULL,NULL),(340,336,0,'LSQ12dwf','LSQ',323.475083333333,0.149138888888889,NULL,NULL,'2012-07-27 05:38:21',56135.1932999999,19.6316,0.1081,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_history.html','sn',NULL,0.12212,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_snap_47109.gif',52106900277,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,814170316,12721411,NULL,NULL,NULL,NULL),(341,336,0,'LSQ12dwf','LSQ',323.475,0.149,NULL,NULL,'2012-07-29 03:32:34',56137.1059599998,19.5105,0.1217,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_history.html','sn',NULL,0.12212,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_snap_47421.gif',52106900235,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,814170316,12721411,NULL,NULL,NULL,NULL),(342,336,0,'LSQ12dwf','LSQ',323.475083333333,0.149055555555556,NULL,NULL,'2012-07-29 05:34:39',56137.19074,19.8062,0.1255,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_history.html','sn',NULL,0.12212,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_snap_47422.gif',52106900277,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,814170316,12721411,NULL,NULL,NULL,NULL),(343,343,1,'LSQ12dvr','LSQ',39.5682083333333,-2.43908333333333,NULL,NULL,'2012-07-23 10:27:45',56131.3942800001,17.6925,0.0306,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvr/LSQ12dvr_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvr/LSQ12dvr_snap_47152.gif',34958364933,NULL,NULL,NULL,'2012-07-09 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,546224452,8534757,NULL,NULL,NULL,NULL),(344,343,0,'LSQ12dvr','LSQ',39.5680833333333,-2.43886111111111,NULL,NULL,'2012-07-27 09:01:27',56135.3343500001,17.6513,0.0201,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvr/LSQ12dvr_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvr/LSQ12dvr_snap_47080.gif',34958364935,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,546224452,8534757,NULL,NULL,NULL,NULL),(345,343,0,'LSQ12dvr','LSQ',39.5681666666667,-2.43888888888889,NULL,NULL,'2012-07-27 10:18:25',56135.3878000001,17.6037,0.0221,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvr/LSQ12dvr_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvr/LSQ12dvr_snap_47081.gif',34958364933,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,546224452,8534757,NULL,NULL,NULL,NULL),(346,343,0,'LSQ12dvr','LSQ',39.5677916666667,-2.43811111111111,NULL,NULL,'2012-07-29 09:03:06',56137.33549,17.5701,0.0191,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvr/LSQ12dvr_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvr/LSQ12dvr_snap_48072.gif',34958364932,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,546224452,8534757,NULL,NULL,NULL,NULL),(347,343,0,'LSQ12dvr','LSQ',39.56775,-2.43816666666667,NULL,NULL,'2012-07-29 10:18:07',56137.3875899999,17.5986,0.0173,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvr/LSQ12dvr_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvr/LSQ12dvr_snap_48073.gif',34958364932,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,546224452,8534757,NULL,NULL,NULL,NULL),(348,348,1,'LSQ12dvl','LSQ',27.33375,1.71094444444444,NULL,NULL,'2012-07-23 10:22:40',56131.3907499998,19.363,0.194,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvl/LSQ12dvl_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvl/LSQ12dvl_snap_47139.gif',67037024368,NULL,NULL,NULL,'2012-07-09 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1047453505,16366461,NULL,NULL,NULL,NULL),(349,348,0,'LSQ12dvl','LSQ',27.3337083333333,1.71094444444444,NULL,NULL,'2012-07-27 08:47:54',56135.3249400002,19.4635,0.1493,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvl/LSQ12dvl_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvl/LSQ12dvl_snap_47068.gif',67037024368,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1047453505,16366461,NULL,NULL,NULL,NULL),(350,348,0,'LSQ12dvl','LSQ',27.3337083333333,1.71094444444444,NULL,NULL,'2012-07-27 10:11:38',56135.3830900001,19.072,0.1312,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvl/LSQ12dvl_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvl/LSQ12dvl_snap_47069.gif',67037024368,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1047453505,16366461,NULL,NULL,NULL,NULL),(351,348,0,'LSQ12dvl','LSQ',27.3336666666667,1.71102777777778,NULL,NULL,'2012-07-29 08:49:22',56137.32595,18.8461,0.1842,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvl/LSQ12dvl_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvl/LSQ12dvl_snap_47358.gif',67037024368,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1047453505,16366461,NULL,NULL,NULL,NULL),(352,348,0,'LSQ12dvl','LSQ',27.3338333333333,1.71094444444444,NULL,NULL,'2012-07-31 10:24:51',56139.3922600001,18.6161,0.1579,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvl/LSQ12dvl_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvl/LSQ12dvl_snap_48837.gif',67037024368,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1047453505,16366461,NULL,NULL,NULL,NULL),(353,353,1,'LSQ12dvj','LSQ',28.3065416666667,-1.85125,NULL,NULL,'2012-07-23 10:22:40',56131.3907499998,20.0125,0.0863,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvj/LSQ12dvj_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvj/LSQ12dvj_snap_47133.gif',35020647697,NULL,NULL,NULL,'2012-07-09 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,547197620,8549962,NULL,NULL,NULL,NULL),(354,353,0,'LSQ12dvj','LSQ',28.3065416666667,-1.85116666666667,NULL,NULL,'2012-07-27 08:47:54',56135.3249400002,19.9649,0.0759,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvj/LSQ12dvj_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvj/LSQ12dvj_snap_47064.gif',35020647710,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,547197620,8549962,NULL,NULL,NULL,NULL),(355,353,0,'LSQ12dvj','LSQ',28.306625,-1.85119444444444,NULL,NULL,'2012-07-27 10:11:38',56135.3830900001,19.7987,0.0635,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvj/LSQ12dvj_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvj/LSQ12dvj_snap_47065.gif',35020647710,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,547197620,8549962,NULL,NULL,NULL,NULL),(356,353,0,'LSQ12dvj','LSQ',28.306625,-1.85125,NULL,NULL,'2012-07-29 08:49:22',56137.32595,19.7222,0.0734,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvj/LSQ12dvj_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvj/LSQ12dvj_snap_47367.gif',35020647697,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,547197620,8549962,NULL,NULL,NULL,NULL),(357,353,0,'LSQ12dvj','LSQ',28.306625,-1.85122222222222,NULL,NULL,'2012-07-29 10:11:18',56137.3828500002,19.7985,0.0642,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvj/LSQ12dvj_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dvj/LSQ12dvj_snap_47368.gif',35020647710,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,547197620,8549962,NULL,NULL,NULL,NULL),(358,358,1,'LSQ12duw','LSQ',9.04120833333333,-2.58319444444444,NULL,NULL,'2012-07-27 08:27:02',56135.3104400001,20.4697,0.1353,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12duw/LSQ12duw_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12duw/LSQ12duw_snap_47038.gif',34579098878,NULL,NULL,NULL,'2012-07-23 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,540298419,8442162,NULL,NULL,NULL,NULL),(359,358,0,'LSQ12duw','LSQ',9.041125,-2.58327777777778,NULL,NULL,'2012-07-27 11:04:37',56135.4198799999,20.5953,0.1477,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12duw/LSQ12duw_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12duw/LSQ12duw_snap_47039.gif',34579098878,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,540298419,8442162,NULL,NULL,NULL,NULL),(360,358,0,'LSQ12duw','LSQ',9.04070833333333,-2.58291666666667,NULL,NULL,'2012-07-29 11:03:55',56137.4193899999,19.4155,0.0958,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12duw/LSQ12duw_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12duw/LSQ12duw_snap_47363.gif',34579098878,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,540298419,8442162,NULL,NULL,NULL,NULL),(361,358,0,'LSQ12duw','LSQ',9.041125,-2.58336111111111,NULL,NULL,'2012-07-31 10:33:15',56139.3980999999,20.5182,0.179,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12duw/LSQ12duw_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12duw/LSQ12duw_snap_48782.gif',34579098879,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,540298419,8442162,NULL,NULL,NULL,NULL),(362,362,1,'LSQ12dum','LSQ',0.243875,0.85725,NULL,NULL,'2012-07-23 08:36:16',56131.3168600001,19.7418,0.2104,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_snap_47021.gif',66572724993,NULL,NULL,NULL,'2012-07-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1040198828,16253106,NULL,NULL,NULL,NULL),(363,362,0,'LSQ12dum','LSQ',0.243833333333333,0.857361111111111,NULL,NULL,'2012-07-23 10:06:23',56131.3794399998,20.0513,0.1599,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_snap_47022.gif',66572724993,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1040198828,16253106,NULL,NULL,NULL,NULL),(364,362,0,'LSQ12dum','LSQ',0.243791666666667,0.857388888888889,NULL,NULL,'2012-07-27 08:14:24',56135.30167,19.3982,0.0613,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_snap_46856.gif',66572724993,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1040198828,16253106,NULL,NULL,NULL,NULL),(365,362,0,'LSQ12dum','LSQ',0.24375,0.857388888888889,NULL,NULL,'2012-07-27 11:12:20',56135.4252399998,19.4635,0.0803,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_snap_46857.gif',66572724993,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1040198828,16253106,NULL,NULL,NULL,NULL),(366,362,0,'LSQ12dum','LSQ',0.24375,0.857416666666667,NULL,NULL,'2012-07-29 08:16:00',56137.30278,19.2016,0.0782,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_snap_47307.gif',66572724993,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1040198828,16253106,NULL,NULL,NULL,NULL),(367,362,0,'LSQ12dum','LSQ',0.243791666666667,0.857388888888889,NULL,NULL,'2012-07-29 11:09:00',56137.4229199998,19.124,0.0645,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_snap_47308.gif',66572724993,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1040198828,16253106,NULL,NULL,NULL,NULL),(368,362,0,'LSQ12dum','LSQ',0.24375,0.857333333333333,NULL,NULL,'2012-07-31 08:46:10',56139.3237299998,19.1075,0.0962,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_snap_48842.gif',66572724993,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1040198828,16253106,NULL,NULL,NULL,NULL),(369,362,0,'LSQ12dum','LSQ',0.243791666666667,0.857416666666667,NULL,NULL,'2012-07-31 10:09:37',56139.3816800001,19.164,0.0883,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_snap_48843.gif',66572724993,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1040198828,16253106,NULL,NULL,NULL,NULL),(370,370,1,'LSQ12dtg','LSQ',358.90675,-6.24955555555556,NULL,NULL,'2012-07-17 09:16:50',56125.34503,20.1338,0.1031,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_history.html','variable?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_snap_46883.gif',49433754184,NULL,NULL,NULL,'2012-07-15 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,772402409,12068787,NULL,NULL,NULL,NULL),(371,370,0,'LSQ12dtg','LSQ',358.906791666667,-6.24991666666667,NULL,NULL,'2012-07-17 10:27:06',56125.3938199999,20.5062,0.1473,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_history.html','variable?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_snap_46884.gif',49433740676,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,772402198,12068784,NULL,NULL,NULL,NULL),(372,370,0,'LSQ12dtg','LSQ',358.9065,-6.25008333333333,NULL,NULL,'2012-07-23 07:53:30',56131.2871599998,18.4852,0.0719,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_history.html','variable?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_snap_46885.gif',49433740676,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,772402198,12068784,NULL,NULL,NULL,NULL),(373,370,0,'LSQ12dtg','LSQ',358.906416666667,-6.25030555555556,NULL,NULL,'2012-07-23 09:45:42',56131.3650699998,19.62,0.1669,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_history.html','variable?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_snap_46886.gif',49433740728,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,772402198,12068784,NULL,NULL,NULL,NULL),(374,370,0,'LSQ12dtg','LSQ',358.906625,-6.25005555555556,NULL,NULL,'2012-07-25 08:14:17',56133.3015899998,18.2327,0.0331,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_history.html','variable?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_snap_46887.gif',49433740676,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,772402198,12068784,NULL,NULL,NULL,NULL),(375,370,0,'LSQ12dtg','LSQ',358.906708333333,-6.24983333333333,NULL,NULL,'2012-07-25 10:48:56',56133.4089899999,19.2541,0.0705,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_history.html','variable?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_snap_46888.gif',49433740676,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,772402198,12068784,NULL,NULL,NULL,NULL),(376,370,0,'LSQ12dtg','LSQ',358.906583333333,-6.25008333333333,NULL,NULL,'2012-07-27 07:33:25',56135.2732099998,17.8464,0.0238,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_history.html','variable?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_snap_46792.gif',49433740676,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,772402198,12068784,NULL,NULL,NULL,NULL),(377,370,0,'LSQ12dtg','LSQ',358.906583333333,-6.25008333333333,NULL,NULL,'2012-07-27 09:32:55',56135.3561999998,18.294,0.0351,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_history.html','variable?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_snap_46793.gif',49433740676,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,772402198,12068784,NULL,NULL,NULL,NULL),(378,370,0,'LSQ12dtg','LSQ',358.906541666667,-6.25,NULL,NULL,'2012-07-29 07:33:15',56137.2730999999,18.7179,0.0712,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_history.html','variable?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_snap_47255.gif',49433740676,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,772402198,12068784,NULL,NULL,NULL,NULL),(379,370,0,'LSQ12dtg','LSQ',358.906583333333,-6.25008333333333,NULL,NULL,'2012-07-29 09:32:38',56137.3560000001,17.9012,0.0227,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_history.html','variable?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_snap_47256.gif',49433740676,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,772402198,12068784,NULL,NULL,NULL,NULL),(380,370,0,'LSQ12dtg','LSQ',358.906625,-6.25,NULL,NULL,'2012-07-31 09:32:11',56139.3556900001,17.7826,0.0365,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_history.html','variable?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_snap_48848.gif',49433740676,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,772402198,12068784,NULL,NULL,NULL,NULL),(381,381,1,'LSQ12dtf','LSQ',0.283833333333333,-6.23308333333333,NULL,NULL,'2012-07-15 08:41:42',56123.32063,19.1874,0.0969,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_snap_46784.gif',34385843399,NULL,NULL,NULL,'2012-07-13 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537278803,8394981,NULL,NULL,NULL,NULL),(382,381,0,'LSQ12dtf','LSQ',0.283625,-6.23297222222222,NULL,NULL,'2012-07-15 10:59:49',56123.4165500002,19.2628,0.0808,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_snap_46785.gif',34385843399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537278803,8394981,NULL,NULL,NULL,NULL),(383,381,0,'LSQ12dtf','LSQ',0.283833333333333,-6.233,NULL,NULL,'2012-07-17 09:15:08',56125.3438499998,18.6796,0.0571,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_snap_46786.gif',34385843399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537278803,8394981,NULL,NULL,NULL,NULL),(384,381,0,'LSQ12dtf','LSQ',0.283666666666667,-6.233,NULL,NULL,'2012-07-17 11:35:13',56125.4411300002,18.7424,0.0767,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_snap_46787.gif',34385843399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537278803,8394981,NULL,NULL,NULL,NULL),(385,381,0,'LSQ12dtf','LSQ',0.2835,-6.233,NULL,NULL,'2012-07-19 11:01:56',56127.4180200002,18.7492,0.0951,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_snap_46788.gif',34385843399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537278803,8394981,NULL,NULL,NULL,NULL),(386,381,0,'LSQ12dtf','LSQ',0.283833333333333,-6.23297222222222,NULL,NULL,'2012-07-23 07:51:50',56131.2859999998,18.9165,0.1392,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_snap_46789.gif',34385843399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537278803,8394981,NULL,NULL,NULL,NULL),(387,381,0,'LSQ12dtf','LSQ',0.283791666666667,-6.23308333333333,NULL,NULL,'2012-07-25 08:12:36',56133.3004200002,19.2966,0.0954,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_snap_46790.gif',34385843399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537278803,8394981,NULL,NULL,NULL,NULL),(388,381,0,'LSQ12dtf','LSQ',0.283625,-6.23302777777778,NULL,NULL,'2012-07-25 10:50:37',56133.41016,19.0011,0.0609,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_snap_46791.gif',34385843399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537278803,8394981,NULL,NULL,NULL,NULL),(389,381,0,'LSQ12dtf','LSQ',0.2835,-6.23302777777778,NULL,NULL,'2012-07-27 07:31:44',56135.2720400002,20.1324,0.1099,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_snap_46780.gif',34385843399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537278803,8394981,NULL,NULL,NULL,NULL),(390,381,0,'LSQ12dtf','LSQ',0.283666666666667,-6.23308333333333,NULL,NULL,'2012-07-27 09:31:12',56135.3550100001,19.739,0.0971,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_snap_46781.gif',34385843399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537278803,8394981,NULL,NULL,NULL,NULL),(391,381,0,'LSQ12dtf','LSQ',0.284166666666667,-6.23308333333333,NULL,NULL,'2012-07-31 09:30:31',56139.3545300001,19.0886,0.158,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_snap_48740.gif',34385843399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537278803,8394981,NULL,NULL,NULL,NULL),(392,392,1,'LSQ12dyc','LSQ',8.985,-20.7407222222222,NULL,NULL,'2012-07-08 11:10:38',56116.4240600001,17.3585,0.039,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyc/LSQ12dyc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyc/LSQ12dyc_snap_47943.gif',35359289499,NULL,NULL,NULL,'2012-07-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,552488898,8632639,NULL,NULL,NULL,NULL),(393,392,0,'LSQ12dyc','LSQ',8.984875,-20.7406666666667,NULL,NULL,'2012-07-28 06:27:00',56136.2270900002,18.094,0.0508,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyc/LSQ12dyc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyc/LSQ12dyc_snap_47866.gif',35359289499,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,552488898,8632639,NULL,NULL,NULL,NULL),(394,392,0,'LSQ12dyc','LSQ',8.98508333333333,-20.7406388888889,NULL,NULL,'2012-07-28 08:26:43',56136.3102299999,18.3494,0.0473,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyc/LSQ12dyc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyc/LSQ12dyc_snap_47867.gif',35359289499,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,552488898,8632639,NULL,NULL,NULL,NULL),(395,392,0,'LSQ12dyc','LSQ',8.98508333333333,-20.7406944444444,NULL,NULL,'2012-07-30 07:26:42',56138.2685500002,18.3843,0.0862,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyc/LSQ12dyc_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyc/LSQ12dyc_snap_48463.gif',35359289499,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,552488898,8632639,NULL,NULL,NULL,NULL),(396,396,1,'LSQ12dya','LSQ',346.8545,-23.5859166666667,NULL,NULL,'2012-07-28 04:16:55',56136.1367500001,12.2864,0.1638,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dya/LSQ12dya_history.html','interesting?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dya/LSQ12dya_snap_47862.gif',50298140916,NULL,NULL,NULL,'2012-07-26 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,785908451,12279819,NULL,NULL,NULL,NULL),(397,396,0,'LSQ12dya','LSQ',346.85425,-23.58575,NULL,NULL,'2012-07-28 06:18:17',56136.2210400002,11.1201,0.0074,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dya/LSQ12dya_history.html','interesting?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dya/LSQ12dya_snap_47863.gif',50298140919,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,785908451,12279819,NULL,NULL,NULL,NULL),(398,398,1,'LSQ12dzt','LSQ',44.4754583333333,-1.50394444444444,NULL,NULL,'2012-07-27 09:04:50',56135.3366999999,17.8963,0.034,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzt/LSQ12dzt_history.html','sne-very nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzt/LSQ12dzt_snap_48160.gif',37849891215,NULL,NULL,NULL,'2012-07-23 09:33:07',56131.398,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591404550,9240696,NULL,NULL,NULL,NULL),(399,398,0,'LSQ12dzt','LSQ',44.475375,-1.50397222222222,NULL,NULL,'2012-07-27 10:45:17',56135.4064500001,17.7695,0.0239,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzt/LSQ12dzt_history.html','sne-very nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzt/LSQ12dzt_snap_48161.gif',37849891213,NULL,NULL,NULL,'2012-07-23 09:33:07',56131.398,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591404550,9240696,NULL,NULL,NULL,NULL),(400,398,0,'LSQ12dzt','LSQ',44.4752083333333,-1.50394444444444,NULL,NULL,'2012-07-29 09:06:30',56137.3378499998,16.7644,0.0109,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzt/LSQ12dzt_history.html','sne-very nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzt/LSQ12dzt_snap_48076.gif',37849891213,NULL,NULL,NULL,'2012-07-23 09:33:07',56131.398,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591404550,9240696,NULL,NULL,NULL,NULL),(401,398,0,'LSQ12dzt','LSQ',44.4752083333333,-1.50394444444444,NULL,NULL,'2012-07-29 10:19:48',56137.38876,16.7445,0.0091,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzt/LSQ12dzt_history.html','sne-very nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzt/LSQ12dzt_snap_48077.gif',37849891213,NULL,NULL,NULL,'2012-07-23 09:33:07',56131.398,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591404550,9240696,NULL,NULL,NULL,NULL),(402,402,1,'LSQ12dzd','LSQ',4.162375,-0.358027777777778,NULL,NULL,'2012-07-23 11:09:45',56131.42344,20.3313,0.1831,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzd/LSQ12dzd_history.html','sne???',NULL,0.07471,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzd/LSQ12dzd_snap_48131.gif',34372011761,NULL,NULL,NULL,'2012-07-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537062683,8391604,NULL,NULL,NULL,NULL),(403,402,0,'LSQ12dzd','LSQ',4.16241666666667,-0.357972222222222,NULL,NULL,'2012-07-27 08:23:39',56135.3081,19.6941,0.0975,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzd/LSQ12dzd_history.html','sne???',NULL,0.07471,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzd/LSQ12dzd_snap_48132.gif',34372011761,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537062683,8391604,NULL,NULL,NULL,NULL),(404,402,0,'LSQ12dzd','LSQ',4.1625,-0.357972222222222,NULL,NULL,'2012-07-27 09:59:21',56135.3745599999,20.234,0.1204,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzd/LSQ12dzd_history.html','sne???',NULL,0.07471,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzd/LSQ12dzd_snap_48133.gif',34372011761,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537062683,8391604,NULL,NULL,NULL,NULL),(405,402,0,'LSQ12dzd','LSQ',4.16254166666667,-0.358027777777778,NULL,NULL,'2012-07-29 08:21:05',56137.3063099999,19.9612,0.1387,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzd/LSQ12dzd_history.html','sne???',NULL,0.07471,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzd/LSQ12dzd_snap_48040.gif',34372011761,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537062683,8391604,NULL,NULL,NULL,NULL),(406,402,0,'LSQ12dzd','LSQ',4.16241666666667,-0.357972222222222,NULL,NULL,'2012-07-29 09:58:23',56137.3738799999,19.5673,0.0949,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzd/LSQ12dzd_history.html','sne???',NULL,0.07471,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzd/LSQ12dzd_snap_48041.gif',34372011761,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537062683,8391604,NULL,NULL,NULL,NULL),(407,407,1,'LSQ12dyw','LSQ',352.353666666667,-7.38908333333333,NULL,NULL,'2012-07-17 10:25:24',56125.3926400002,19.3734,0.0942,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_snap_48113.gif',49660467229,NULL,NULL,NULL,'2012-07-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,775944800,12124137,NULL,NULL,NULL,NULL),(408,407,0,'LSQ12dyw','LSQ',352.353416666667,-7.38894444444445,NULL,NULL,'2012-07-17 11:02:00',56125.4180600001,19.2507,0.0634,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_snap_48114.gif',49660467229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,775944800,12124137,NULL,NULL,NULL,NULL),(409,407,0,'LSQ12dyw','LSQ',352.353416666667,-7.389,NULL,NULL,'2012-07-23 05:26:06',56131.1847999999,18.9507,0.1271,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_snap_48115.gif',49660467229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,775944800,12124137,NULL,NULL,NULL,NULL),(410,407,0,'LSQ12dyw','LSQ',352.353458333333,-7.38902777777778,NULL,NULL,'2012-07-23 07:27:23',56131.26902,18.9169,0.0978,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_snap_48116.gif',49660467229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,775944800,12124137,NULL,NULL,NULL,NULL),(411,407,0,'LSQ12dyw','LSQ',352.353416666667,-7.38897222222222,NULL,NULL,'2012-07-27 05:09:14',56135.1730800001,18.9048,0.0747,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_snap_48117.gif',49660467229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,775944800,12124137,NULL,NULL,NULL,NULL),(412,407,0,'LSQ12dyw','LSQ',352.353333333333,-7.38905555555556,NULL,NULL,'2012-07-27 07:09:31',56135.2566200001,18.7161,0.0433,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_snap_48118.gif',49660467229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,775944800,12124137,NULL,NULL,NULL,NULL),(413,407,0,'LSQ12dyw','LSQ',352.353083333333,-7.38894444444445,NULL,NULL,'2012-07-29 04:56:42',56137.16438,18.6649,0.0756,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_snap_48026.gif',49660467229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,775944800,12124137,NULL,NULL,NULL,NULL),(414,407,0,'LSQ12dyw','LSQ',352.353291666667,-7.38897222222222,NULL,NULL,'2012-07-29 06:58:57',56137.2492800001,18.6481,0.0531,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_snap_48027.gif',49660467229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,775944800,12124137,NULL,NULL,NULL,NULL),(415,407,0,'LSQ12dyw','LSQ',352.353458333333,-7.38897222222222,NULL,NULL,'2012-07-31 08:33:34',56139.3149799998,18.5063,0.0737,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_snap_48869.gif',49660467229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,775944800,12124137,NULL,NULL,NULL,NULL),(416,407,0,'LSQ12dyw','LSQ',352.353416666667,-7.389,NULL,NULL,'2012-07-31 10:03:10',56139.3772100001,18.5594,0.0652,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_snap_48870.gif',49660467229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,775944800,12124137,NULL,NULL,NULL,NULL),(417,417,1,'LSQ12dyt','LSQ',345.311166666667,-6.72166666666667,NULL,NULL,'2012-07-27 04:37:31',56135.1510600001,19.8541,0.1429,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyt/LSQ12dyt_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyt/LSQ12dyt_snap_48110.gif',49487242571,NULL,NULL,NULL,'2012-07-25 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,773238165,12081846,NULL,NULL,NULL,NULL),(418,417,0,'LSQ12dyt','LSQ',345.311083333333,-6.72152777777778,NULL,NULL,'2012-07-27 06:42:10',56135.2376199998,18.6546,0.0668,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyt/LSQ12dyt_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyt/LSQ12dyt_snap_48111.gif',49487242571,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,773238165,12081846,NULL,NULL,NULL,NULL),(419,417,0,'LSQ12dyt','LSQ',345.311125,-6.72161111111111,NULL,NULL,'2012-07-29 04:30:37',56137.1462699999,17.8791,0.0403,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyt/LSQ12dyt_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyt/LSQ12dyt_snap_48020.gif',49487242571,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,773238165,12081846,NULL,NULL,NULL,NULL),(420,417,0,'LSQ12dyt','LSQ',345.311166666667,-6.72158333333333,NULL,NULL,'2012-07-29 06:48:45',56137.2421900001,18.0193,0.0447,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyt/LSQ12dyt_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyt/LSQ12dyt_snap_48021.gif',49487242571,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,773238165,12081846,NULL,NULL,NULL,NULL),(421,417,0,'LSQ12dyt','LSQ',345.311125,-6.72152777777778,NULL,NULL,'2012-07-31 08:26:47',56139.3102699998,17.8981,0.0673,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyt/LSQ12dyt_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyt/LSQ12dyt_snap_48872.gif',49487242571,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,773238165,12081846,NULL,NULL,NULL,NULL),(422,417,0,'LSQ12dyt','LSQ',345.311166666667,-6.72158333333333,NULL,NULL,'2012-07-31 09:59:47',56139.3748599999,18.0358,0.071,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyt/LSQ12dyt_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyt/LSQ12dyt_snap_48873.gif',49487242571,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,773238165,12081846,NULL,NULL,NULL,NULL),(423,423,1,'LSQ12ecu','LSQ',356.538125,-19.3575833333333,NULL,NULL,'2012-07-30 04:49:57',56138.1596900001,18.7746,0.1212,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecu/LSQ12ecu_history.html','sne',NULL,0.005974,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecu/LSQ12ecu_snap_49023.gif',49535940995,NULL,NULL,NULL,'2012-07-28 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,773999078,12093735,NULL,NULL,NULL,NULL),(424,423,0,'LSQ12ecu','LSQ',356.538166666667,-19.3576111111111,NULL,NULL,'2012-07-30 06:52:33',56138.2448300002,19.8001,0.1277,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecu/LSQ12ecu_history.html','sne',NULL,0.005974,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecu/LSQ12ecu_snap_49024.gif',49535940995,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,773999078,12093735,NULL,NULL,NULL,NULL),(425,425,1,'LSQ12ecp','LSQ',21.7569583333333,-17.3654444444444,NULL,NULL,'2012-07-28 08:40:16',56136.3196299998,17.9065,0.0274,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecp/LSQ12ecp_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecp/LSQ12ecp_snap_49165.gif',35188002643,NULL,NULL,NULL,'2012-07-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549812541,8590820,NULL,NULL,NULL,NULL),(426,425,0,'LSQ12ecp','LSQ',21.7569166666667,-17.3654722222222,NULL,NULL,'2012-07-30 07:51:07',56138.2855000002,18.0767,0.0396,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecp/LSQ12ecp_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecp/LSQ12ecp_snap_49013.gif',35188002642,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549812541,8590820,NULL,NULL,NULL,NULL),(427,425,0,'LSQ12ecp','LSQ',21.7569583333333,-17.3654444444444,NULL,NULL,'2012-07-30 09:42:01',56138.36252,18.0383,0.0347,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecp/LSQ12ecp_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecp/LSQ12ecp_snap_49014.gif',35188002643,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549812541,8590820,NULL,NULL,NULL,NULL),(428,428,1,'LSQ12ecd','LSQ',339.4785,-21.1293888888889,NULL,NULL,'2012-07-22 11:05:21',56130.4203900001,19.4667,0.1612,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecd/LSQ12ecd_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecd/LSQ12ecd_snap_49081.gif',50257618254,NULL,NULL,NULL,'2012-07-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785275285,12269926,NULL,NULL,NULL,NULL),(429,428,0,'LSQ12ecd','LSQ',339.478208333333,-21.1295,NULL,NULL,'2012-07-26 11:08:25',56134.42252,18.9193,0.0796,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecd/LSQ12ecd_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecd/LSQ12ecd_snap_49082.gif',50257618254,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785275285,12269926,NULL,NULL,NULL,NULL),(430,428,0,'LSQ12ecd','LSQ',339.47825,-21.1295277777778,NULL,NULL,'2012-07-26 11:21:56',56134.4319000002,18.6971,0.0762,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecd/LSQ12ecd_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecd/LSQ12ecd_snap_49083.gif',50257618254,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785275285,12269926,NULL,NULL,NULL,NULL),(431,428,0,'LSQ12ecd','LSQ',339.47825,-21.1294722222222,NULL,NULL,'2012-07-28 03:41:30',56136.11216,18.8627,0.1098,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecd/LSQ12ecd_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecd/LSQ12ecd_snap_49084.gif',50257618254,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785275285,12269926,NULL,NULL,NULL,NULL),(432,428,0,'LSQ12ecd','LSQ',339.47825,-21.1294444444444,NULL,NULL,'2012-07-28 05:50:57',56136.20206,18.8043,0.0827,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecd/LSQ12ecd_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecd/LSQ12ecd_snap_49085.gif',50257618254,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785275285,12269926,NULL,NULL,NULL,NULL),(433,428,0,'LSQ12ecd','LSQ',339.478208333333,-21.1294166666667,NULL,NULL,'2012-07-30 04:10:37',56138.1323799998,18.6505,0.101,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecd/LSQ12ecd_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecd/LSQ12ecd_snap_48989.gif',50257618254,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785275285,12269926,NULL,NULL,NULL,NULL),(434,428,0,'LSQ12ecd','LSQ',339.478083333333,-21.1294722222222,NULL,NULL,'2012-07-30 06:10:44',56138.2157899998,18.7177,0.0826,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecd/LSQ12ecd_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecd/LSQ12ecd_snap_48990.gif',50257618254,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785275285,12269926,NULL,NULL,NULL,NULL),(435,435,1,'LSQ12ecb','LSQ',337.79475,-24.8876111111111,NULL,NULL,'2012-07-22 11:03:39',56130.41921,19.9478,0.1815,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_49070.gif',50073090666,NULL,NULL,NULL,'2012-07-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(436,435,0,'LSQ12ecb','LSQ',337.795,-24.8874444444444,NULL,NULL,'2012-07-22 11:05:21',56130.4203900001,20.0592,0.2057,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_49069.gif',50073090668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(437,435,0,'LSQ12ecb','LSQ',337.79475,-24.8875277777778,NULL,NULL,'2012-07-26 11:06:43',56134.4213399999,18.7645,0.0774,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_49073.gif',50073090668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(438,435,0,'LSQ12ecb','LSQ',337.795041666667,-24.8873611111111,NULL,NULL,'2012-07-26 11:08:25',56134.42252,18.5542,0.0534,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_49071.gif',50073090668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(439,435,0,'LSQ12ecb','LSQ',337.794625,-24.8875,NULL,NULL,'2012-07-26 11:20:15',56134.4307300001,18.6995,0.0794,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_49074.gif',50073090666,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(440,435,0,'LSQ12ecb','LSQ',337.794958333333,-24.8875,NULL,NULL,'2012-07-26 11:21:56',56134.4319000002,18.5151,0.0555,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_49072.gif',50073090668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(441,435,0,'LSQ12ecb','LSQ',337.794583333333,-24.8874722222222,NULL,NULL,'2012-07-28 03:39:50',56136.111,18.46,0.0823,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_49077.gif',50073090666,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(442,435,0,'LSQ12ecb','LSQ',337.794833333333,-24.8874444444444,NULL,NULL,'2012-07-28 03:41:30',56136.11216,18.3857,0.0776,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_49075.gif',50073090668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(443,435,0,'LSQ12ecb','LSQ',337.794625,-24.8875,NULL,NULL,'2012-07-28 05:49:16',56136.20089,18.2862,0.0586,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_49078.gif',50073090666,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(444,435,0,'LSQ12ecb','LSQ',337.794875,-24.8874166666667,NULL,NULL,'2012-07-28 05:50:57',56136.20206,18.533,0.0656,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_49076.gif',50073090668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(445,435,0,'LSQ12ecb','LSQ',337.794541666667,-24.8874444444444,NULL,NULL,'2012-07-30 04:08:54',56138.1311900001,18.4004,0.0714,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_48983.gif',50073090666,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(446,435,0,'LSQ12ecb','LSQ',337.794791666667,-24.8874722222222,NULL,NULL,'2012-07-30 04:10:37',56138.1323799998,18.073,0.0882,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_48985.gif',50073090668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(447,435,0,'LSQ12ecb','LSQ',337.794708333333,-24.8875,NULL,NULL,'2012-07-30 06:09:03',56138.2146200002,18.2554,0.0568,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_48984.gif',50073090666,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(448,435,0,'LSQ12ecb','LSQ',337.794791666667,-24.8874722222222,NULL,NULL,'2012-07-30 06:10:44',56138.2157899998,18.2818,0.0807,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_48986.gif',50073090668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(449,435,0,'LSQ12ecb','LSQ',337.794916666667,-24.8874722222222,NULL,NULL,'2012-08-01 03:25:30',56140.1010500002,18.1324,0.1414,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_49208.gif',50073090668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(450,435,0,'LSQ12ecb','LSQ',337.794708333333,-24.8875555555556,NULL,NULL,'2012-08-05 05:08:11',56144.1723600002,18.2218,0.2128,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_49598.gif',50073090666,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(451,451,1,'LSQ12eea','LSQ',358.399333333333,-6.38316666666667,NULL,NULL,'2012-07-05 06:53:38',56113.2455899999,19.3633,0.144,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eea/LSQ12eea_history.html','sne?',NULL,0.045465,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eea/LSQ12eea_snap_49427.gif',49431273985,NULL,NULL,NULL,'2012-06-30 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772363656,12068182,NULL,NULL,NULL,NULL),(452,451,0,'LSQ12eea','LSQ',358.399333333333,-6.38316666666667,NULL,NULL,'2012-07-29 05:17:22',56137.1787299998,19.4586,0.1116,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eea/LSQ12eea_history.html','sne?',NULL,0.045465,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eea/LSQ12eea_snap_49428.gif',49431273985,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772363656,12068182,NULL,NULL,NULL,NULL),(453,451,0,'LSQ12eea','LSQ',358.399625,-6.38336111111111,NULL,NULL,'2012-07-31 08:44:28',56139.3225500002,18.5394,0.1157,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eea/LSQ12eea_history.html','sne?',NULL,0.045465,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eea/LSQ12eea_snap_49309.gif',49431273985,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772363656,12068182,NULL,NULL,NULL,NULL),(454,451,0,'LSQ12eea','LSQ',358.399333333333,-6.38327777777778,NULL,NULL,'2012-07-31 10:41:21',56139.4037199998,18.0487,0.0734,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eea/LSQ12eea_history.html','sne?',NULL,0.045465,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eea/LSQ12eea_snap_49310.gif',49431273985,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772363656,12068182,NULL,NULL,NULL,NULL),(455,455,1,'LSQ12edt','LSQ',41.46675,0.18025,NULL,NULL,'2012-07-31 11:18:02',56139.4291900001,20.6744,0.1524,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edt/LSQ12edt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edt/LSQ12edt_snap_49295.gif',66850723408,NULL,NULL,NULL,'2012-07-29 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1044542553,16320977,NULL,NULL,NULL,NULL),(456,455,0,'LSQ12edt','LSQ',41.4665416666667,0.18025,NULL,NULL,'2012-07-31 11:24:48',56139.4339000001,19.8127,0.0982,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edt/LSQ12edt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edt/LSQ12edt_snap_49296.gif',66850723408,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1044542553,16320977,NULL,NULL,NULL,NULL),(457,457,1,'LSQ12edo','LSQ',51.5782083333333,-3.29761111111111,NULL,NULL,'2012-07-25 10:58:00',56133.4152799998,19.1096,0.1418,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_snap_49368.gif',36842019075,NULL,NULL,NULL,'2012-07-23 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,575656548,8994633,NULL,NULL,NULL,NULL),(458,457,0,'LSQ12edo','LSQ',51.578625,-3.29766666666667,NULL,NULL,'2012-07-27 10:21:48',56135.3901499999,18.8834,0.1097,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_snap_49369.gif',36842019075,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,575656548,8994633,NULL,NULL,NULL,NULL),(459,457,0,'LSQ12edo','LSQ',51.5784583333333,-3.29763888888889,NULL,NULL,'2012-07-29 10:16:24',56137.3864000002,18.6759,0.1424,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_snap_49370.gif',36842019075,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,575656548,8994633,NULL,NULL,NULL,NULL),(460,457,0,'LSQ12edo','LSQ',51.5784166666667,-3.29761111111111,NULL,NULL,'2012-07-31 08:51:52',56139.3276900002,18.3913,0.122,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_snap_49285.gif',36842019075,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,575656548,8994633,NULL,NULL,NULL,NULL),(461,457,0,'LSQ12edo','LSQ',51.5784583333333,-3.29772222222222,NULL,NULL,'2012-07-31 10:37:09',56139.40081,18.9142,0.1158,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_snap_49286.gif',36842019075,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,575656548,8994633,NULL,NULL,NULL,NULL),(462,462,1,'LSQ12edk','LSQ',47.2391666666667,-2.95441666666667,NULL,NULL,'2012-07-17 11:16:35',56125.4281899999,19.2438,0.1357,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_history.html','sne',NULL,0.0082,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_snap_49351.gif',36790348504,NULL,NULL,NULL,'2012-07-17 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,574849195,8982018,NULL,NULL,NULL,NULL),(463,462,0,'LSQ12edk','LSQ',47.2394166666667,-2.95466666666667,NULL,NULL,'2012-07-23 10:57:48',56131.4151499998,18.3389,0.1904,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_history.html','sne',NULL,0.0082,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_snap_49352.gif',36790348536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,574849195,8982018,NULL,NULL,NULL,NULL),(464,462,0,'LSQ12edk','LSQ',47.239375,-2.95436111111111,NULL,NULL,'2012-07-25 11:35:43',56133.44148,18.5233,0.1946,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_history.html','sne',NULL,0.0082,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_snap_49353.gif',36790348536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,574849195,8982018,NULL,NULL,NULL,NULL),(465,462,0,'LSQ12edk','LSQ',47.2390833333333,-2.95433333333333,NULL,NULL,'2012-07-31 08:38:45',56139.3185800002,18.8149,0.1412,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_history.html','sne',NULL,0.0082,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_snap_49277.gif',36790348504,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,574849195,8982018,NULL,NULL,NULL,NULL),(466,462,0,'LSQ12edk','LSQ',47.2392916666667,-2.95441666666667,NULL,NULL,'2012-07-31 10:45:23',56139.4065200002,18.3946,0.1338,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_history.html','sne',NULL,0.0082,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_snap_49278.gif',36790348536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,574849195,8982018,NULL,NULL,NULL,NULL),(467,467,1,'LSQ12eew','LSQ',316.854,-13.3195,NULL,NULL,'2012-07-08 06:23:47',56116.22486,19.6097,0.1359,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eew/LSQ12eew_history.html','sne?',NULL,0.082147,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eew/LSQ12eew_snap_49547.gif',50960592643,NULL,NULL,NULL,'2012-07-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,796259260,12441550,NULL,NULL,NULL,NULL),(468,467,0,'LSQ12eew','LSQ',316.854125,-13.3193888888889,NULL,NULL,'2012-07-28 04:25:37',56136.1428,18.8017,0.0783,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eew/LSQ12eew_history.html','sne?',NULL,0.082147,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eew/LSQ12eew_snap_49548.gif',50960592643,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,796259260,12441550,NULL,NULL,NULL,NULL),(469,467,0,'LSQ12eew','LSQ',316.854166666667,-13.3193888888889,NULL,NULL,'2012-07-30 03:04:14',56138.0862799999,18.8164,0.1146,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eew/LSQ12eew_history.html','sne?',NULL,0.082147,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eew/LSQ12eew_snap_49549.gif',50960592643,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,796259260,12441550,NULL,NULL,NULL,NULL),(470,467,0,'LSQ12eew','LSQ',316.854208333333,-13.3194166666667,NULL,NULL,'2012-08-01 02:04:16',56140.0446299999,18.5965,0.1422,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eew/LSQ12eew_history.html','sne?',NULL,0.082147,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eew/LSQ12eew_snap_49502.gif',50960592643,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,796259260,12441550,NULL,NULL,NULL,NULL),(471,467,0,'LSQ12eew','LSQ',316.854375,-13.3194722222222,NULL,NULL,'2012-08-01 04:06:00',56140.1291700001,18.3082,0.1113,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eew/LSQ12eew_history.html','sne?',NULL,0.082147,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eew/LSQ12eew_snap_49503.gif',50960592643,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,796259260,12441550,NULL,NULL,NULL,NULL),(472,472,1,'LSQ12eeq','LSQ',313.204416666667,-16.5600555555556,NULL,NULL,'2012-07-13 04:14:38',56121.1351700001,20.5025,0.1296,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_snap_49526.gif',50992845486,NULL,NULL,NULL,'2012-07-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796763210,12449425,NULL,NULL,NULL,NULL),(473,472,0,'LSQ12eeq','LSQ',313.204375,-16.5600555555556,NULL,NULL,'2012-07-28 02:07:15',56136.0467099999,18.8031,0.0845,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_snap_49527.gif',50992845486,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796763210,12449425,NULL,NULL,NULL,NULL),(474,472,0,'LSQ12eeq','LSQ',313.203458333333,-16.5599444444444,NULL,NULL,'2012-07-30 01:59:10',56138.04109,19.1421,0.1308,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_snap_49528.gif',50992845486,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796763210,12449425,NULL,NULL,NULL,NULL),(475,472,0,'LSQ12eeq','LSQ',313.204208333333,-16.5600555555556,NULL,NULL,'2012-08-01 01:51:13',56140.0355699998,18.5242,0.1487,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_snap_49490.gif',50992845486,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796763210,12449425,NULL,NULL,NULL,NULL),(476,472,0,'LSQ12eeq','LSQ',313.204083333333,-16.5601388888889,NULL,NULL,'2012-08-01 03:53:27',56140.1204599999,18.3835,0.128,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_snap_49491.gif',50992845486,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796763210,12449425,NULL,NULL,NULL,NULL),(477,472,0,'LSQ12eeq','LSQ',313.204541666667,-16.5601388888889,NULL,NULL,'2012-08-05 01:35:04',56144.0243600002,17.7383,0.1049,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-07 00:21:36','2012-08-07 00:21:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_snap_49601.gif',50992845478,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796763210,12449425,NULL,NULL,NULL,NULL),(478,478,1,'PS1-12bah','Pan-STARRS1',276.247225448,22.5591838579,NULL,NULL,'2012-05-15 15:36:54',56062.6089589,19.0075,0.0377883,'z',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1182459331223333000/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56062/1182459331223333000_56062.608_488089_2706_target.jpeg',NULL,NULL,54568800782,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,852637512,13322461,NULL,NULL,NULL,NULL),(479,478,0,'PS1-12bah','Pan-STARRS1',276.247252108,22.5591744449,NULL,NULL,'2012-07-28 08:05:20',56136.2953788,17.3449,0.00643286,'i',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1182459331223333000/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56136/1182459331223333000_56136.295_501270_853_target.jpeg',NULL,NULL,54568800782,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,852637512,13322461,NULL,NULL,NULL,NULL),(480,478,0,'PS1-12bah','Pan-STARRS1',276.247251145,22.5591730685,NULL,NULL,'2012-07-28 08:21:10',56136.3063697,17.3609,0.0065057,'i',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1182459331223333000/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,54568800782,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,852637512,13322461,NULL,NULL,NULL,NULL),(481,478,0,'PS1-12bah','Pan-STARRS1',276.247249679,22.5591707761,NULL,NULL,'2012-07-28 10:49:53',56136.409644,17.2824,0.00767984,'r',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1182459331223333000/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56136/1182459331223333000_56136.409_501460_625_target.jpeg',NULL,NULL,54568800782,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,852637512,13322461,NULL,NULL,NULL,NULL),(482,478,0,'PS1-12bah','Pan-STARRS1',276.24725208,22.5591685039,NULL,NULL,'2012-07-28 11:04:03',56136.4194882,17.2769,0.00706203,'r',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1182459331223333000/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56136/1182459331223333000_56136.419_501510_592_target.jpeg',NULL,NULL,54568800782,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,852637512,13322461,NULL,NULL,NULL,NULL),(483,483,1,'PS1-12bai','Pan-STARRS1',317.475613274,16.5144306093,NULL,NULL,'2012-05-19 15:26:42',56066.6018824,19.7404,0.065482,'z',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1210954141163051900/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56066/1210954141163051900_56066.601_490245_3473_target.jpeg',NULL,NULL,55288186833,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,863877919,13498092,NULL,NULL,NULL,NULL),(484,483,0,'PS1-12bai','Pan-STARRS1',317.475607459,16.5144183666,NULL,NULL,'2012-05-19 15:35:32',56066.6080178,19.465,0.0466104,'z',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1210954141163051900/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56066/1210954141163051900_56066.608_490264_2139_target.jpeg',NULL,NULL,55288186833,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,863877919,13498092,NULL,NULL,NULL,NULL),(485,483,0,'PS1-12bai','Pan-STARRS1',317.475615609,16.5144053905,NULL,NULL,'2012-07-28 13:01:59',56136.5013865,17.174,0.00621908,'g',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1210954141163051900/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56136/1210954141163051900_56136.501_501596_268_target.jpeg',NULL,NULL,55288186833,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,863877919,13498092,NULL,NULL,NULL,NULL),(486,483,0,'PS1-12bai','Pan-STARRS1',317.475617146,16.5144110899,NULL,NULL,'2012-07-28 13:17:02',56136.5118399,17.0304,0.00557996,'g',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1210954141163051900/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56136/1210954141163051900_56136.511_501613_236_target.jpeg',NULL,NULL,55288186833,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,863877919,13498092,NULL,NULL,NULL,NULL),(487,483,0,'PS1-12bai','Pan-STARRS1',317.475616847,16.5144098051,NULL,NULL,'2012-07-28 13:47:32',56136.5330143,16.8945,0.00528547,'g',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1210954141163051900/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,55288186833,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,863877919,13498092,NULL,NULL,NULL,NULL),(488,483,0,'PS1-12bai','Pan-STARRS1',317.475611183,16.5144084587,NULL,NULL,'2012-07-29 09:55:05',56137.3715905,16.6762,0.00474301,'i',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1210954141163051900/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,55288186833,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,863877919,13498092,NULL,NULL,NULL,NULL),(489,483,0,'PS1-12bai','Pan-STARRS1',317.47560956,16.5144023168,NULL,NULL,'2012-07-29 10:10:44',56137.3824583,16.5423,0.00436778,'i',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1210954141163051900/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,55288186833,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,863877919,13498092,NULL,NULL,NULL,NULL),(490,483,0,'PS1-12bai','Pan-STARRS1',317.475604584,16.5144107896,NULL,NULL,'2012-07-30 13:34:51',56138.5242052,16.6443,0.00450604,'i',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1210954141163051900/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,55288186833,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,863877919,13498092,NULL,NULL,NULL,NULL),(491,483,0,'PS1-12bai','Pan-STARRS1',317.47560695,16.5144049364,NULL,NULL,'2012-07-30 13:50:25',56138.5350195,16.771,0.00495634,'i',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1210954141163051900/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,55288186833,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,863877919,13498092,NULL,NULL,NULL,NULL),(492,492,1,'PS1-12baj','Pan-STARRS1',357.473017917,-9.26860035513,NULL,NULL,'2012-07-28 15:34:34',56136.6073394,19.8382,0.069707,'z',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1234953520091606900/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56136/1234953520091606900_56136.607_501695_355_target.jpeg',NULL,NULL,49612235860,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,775191185,12112362,NULL,NULL,NULL,NULL),(493,492,0,'PS1-12baj','Pan-STARRS1',357.47303713,-9.26860342331,NULL,NULL,'2012-07-28 15:51:12',56136.6188941,19.8088,0.0733816,'z',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1234953520091606900/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56136/1234953520091606900_56136.618_501719_252_target.jpeg',NULL,NULL,49612235860,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,775191185,12112362,NULL,NULL,NULL,NULL),(494,494,1,'PS1-12bag','Pan-STARRS1',1.74740143572,-8.96008317593,NULL,NULL,'2012-07-28 15:23:13',56136.5994599,19.3578,0.043632,'z',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1000659370085736200/','agn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56136/1000659370085736200_56136.599_501680_261_target.jpeg',NULL,NULL,34378395010,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,537162422,8393162,NULL,NULL,NULL,NULL),(495,494,0,'PS1-12bag','Pan-STARRS1',1.74740059304,-8.96007660321,NULL,NULL,'2012-07-28 15:39:52',56136.6110219,19.4054,0.0487866,'z',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1000659370085736200/','agn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56136/1000659370085736200_56136.611_501703_403_target.jpeg',NULL,NULL,34378395010,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,537162422,8393162,NULL,NULL,NULL,NULL),(496,496,1,'PS1-12bap','Pan-STARRS1',309.891349012,26.1569508418,NULL,NULL,'2012-06-05 13:24:47',56083.5172191,17.0715,0.00991525,'z',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1203933921260925000/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56083/1203933921260925000_56083.517_493843_1431_target.jpeg',NULL,NULL,55731630643,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,870806728,13606355,NULL,NULL,NULL,NULL),(497,496,0,'PS1-12bap','Pan-STARRS1',309.891354895,26.156945097,NULL,NULL,'2012-06-05 13:41:50',56083.5290594,17.0904,0.00990929,'z',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1203933921260925000/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56083/1203933921260925000_56083.529_493866_1502_target.jpeg',NULL,NULL,55731630643,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,870806728,13606355,NULL,NULL,NULL,NULL),(498,496,0,'PS1-12bap','Pan-STARRS1',309.891366228,26.156944298,NULL,NULL,'2012-07-29 13:33:24',56137.5232054,17.7641,0.0102383,'g',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1203933921260925000/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56137/1203933921260925000_56137.523_502175_1198_target.jpeg',NULL,NULL,55731630643,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,870806728,13606355,NULL,NULL,NULL,NULL),(499,496,0,'PS1-12bap','Pan-STARRS1',309.891364454,26.1569468547,NULL,NULL,'2012-07-29 13:49:22',56137.5342898,17.7805,0.0099802,'g',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1203933921260925000/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56137/1203933921260925000_56137.534_502192_1255_target.jpeg',NULL,NULL,55731630643,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,870806728,13606355,NULL,NULL,NULL,NULL),(500,496,0,'PS1-12bap','Pan-STARRS1',309.891365004,26.1569541848,NULL,NULL,'2012-08-05 08:32:58',56144.3145669,19.506,0.0376389,'i',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1203933921260925000/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,55731630643,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,870806728,13606355,NULL,NULL,NULL,NULL),(501,501,0,'PS1-12baq','Pan-STARRS1',312.082503374,15.2376194547,NULL,NULL,'2012-07-28 12:56:28',56136.4975524,19.1472,0.0210366,'g',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2019-12-24 20:38:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1204819801151415400/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56136/1204819801151415400_56136.497_501590_1044_target.jpeg',NULL,NULL,55260164875,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,863440076,13491251,NULL,NULL,NULL,NULL),(502,501,0,'PS1-12baq','Pan-STARRS1',312.082507757,15.2376308502,NULL,NULL,'2012-07-28 13:11:34',56136.5080336,19.1277,0.0202536,'g',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1204819801151415400/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56136/1204819801151415400_56136.508_501606_1123_target.jpeg',NULL,NULL,55260164875,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,863440076,13491251,NULL,NULL,NULL,NULL),(503,501,0,'PS1-12baq','Pan-STARRS1',312.082516599,15.2376355815,NULL,NULL,'2012-07-29 09:49:12',56137.3675068,19.792,0.0435509,'i',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1204819801151415400/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,55260164875,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,863440076,13491251,NULL,NULL,NULL,NULL),(504,501,0,'PS1-12baq','Pan-STARRS1',312.082520333,15.2376484849,NULL,NULL,'2012-07-29 10:04:50',56137.3783653,19.803,0.0405927,'i',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1204819801151415400/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,55260164875,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,863440076,13491251,NULL,NULL,NULL,NULL),(505,505,1,'PS1-12bar','Pan-STARRS1',281.637652872,63.7497576913,NULL,NULL,'2012-07-30 09:37:45',56138.3595579,19.7653,0.046025,'i',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1184633011634459200/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,53073322157,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,829270658,12957354,NULL,NULL,NULL,NULL),(506,505,0,'PS1-12bar','Pan-STARRS1',281.637628549,63.7497943114,NULL,NULL,'2012-07-30 09:55:08',56138.3716212,19.7733,0.0490857,'i',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1184633011634459200/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,53073322157,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,829270658,12957354,NULL,NULL,NULL,NULL),(507,505,0,'PS1-12bar','Pan-STARRS1',281.637557281,63.7497936344,NULL,NULL,'2012-07-30 10:12:27',56138.383657,19.3748,0.0443278,'r',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1184633011634459200/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56138/1184633011634459200_56138.383_502522_568_target.jpeg',NULL,NULL,53073322157,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,829270658,12957354,NULL,NULL,NULL,NULL),(508,505,0,'PS1-12bar','Pan-STARRS1',281.637602439,63.7497817787,NULL,NULL,'2012-07-30 10:29:04',56138.3951956,19.3993,0.0395044,'r',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1184633011634459200/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56138/1184633011634459200_56138.395_502540_592_target.jpeg',NULL,NULL,53073322157,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,829270658,12957354,NULL,NULL,NULL,NULL),(509,505,0,'PS1-12bar','Pan-STARRS1',281.637677568,63.7498266797,NULL,NULL,'2012-08-04 08:13:22',56143.3009501,20.1237,0.135133,'z',NULL,NULL,NULL,NULL,'2012-08-07 23:54:53','2012-08-07 23:54:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1184633011634459200/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,53073322157,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,829270658,12957354,NULL,NULL,NULL,NULL),(510,189,0,'LSQ12dpx','LSQ',348.561291666667,-6.96683333333333,NULL,NULL,'2012-08-06 09:03:20',56145.3356499998,17.088,0.1112,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-08 15:52:20','2012-08-08 15:52:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_snap_49730.gif',49602146390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,775033537,12109899,NULL,NULL,NULL,NULL),(511,198,0,'LSQ12dpw','LSQ',345.61975,-7.10836111111111,NULL,NULL,'2012-08-06 04:30:33',56145.14622,19.0157,0.1901,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-08 15:52:20','2012-08-08 15:52:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpw/LSQ12dpw_history.html','sne or agn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpw/LSQ12dpw_snap_49733.gif',49487021206,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773234706,12081792,NULL,NULL,NULL,NULL),(512,198,0,'LSQ12dpw','LSQ',345.620125,-7.10825,NULL,NULL,'2012-08-06 06:30:39',56145.2296199999,17.2099,0.1766,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-08 15:52:20','2012-08-08 15:52:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpw/LSQ12dpw_history.html','sne or agn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpw/LSQ12dpw_snap_49734.gif',49487021214,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773234706,12081792,NULL,NULL,NULL,NULL),(513,332,0,'LSQ12dwl','LSQ',333.173125,0.511944444444444,NULL,NULL,'2012-08-06 03:19:19',56145.09675,14.803,0.0137,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-08 15:52:20','2012-08-08 15:52:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_history.html','sne-nice!',NULL,0.01377,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_snap_49748.gif',52152344380,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814880380,12732505,NULL,NULL,NULL,NULL),(514,332,0,'LSQ12dwl','LSQ',333.173125,0.512,NULL,NULL,'2012-08-06 05:20:01',56145.1805699999,14.81,0.005,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-08 15:52:20','2012-08-08 15:52:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_history.html','sne-nice!',NULL,0.01377,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_snap_49749.gif',52152344378,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814880380,12732505,NULL,NULL,NULL,NULL),(515,336,0,'LSQ12dwf','LSQ',323.475208333333,0.148944444444444,NULL,NULL,'2012-08-06 02:46:49',56145.07418,13.5554,0.1846,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-08 15:52:20','2012-08-08 15:52:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_history.html','sn',NULL,0.12212,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_snap_49742.gif',52106900234,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,814170316,12721411,NULL,NULL,NULL,NULL),(516,435,0,'LSQ12ecb','LSQ',337.794666666667,-24.8875,NULL,NULL,'2012-08-07 04:45:12',56146.1563900001,18.0467,0.0457,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-08 15:52:20','2012-08-08 15:52:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_49898.gif',50073090666,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(517,435,0,'LSQ12ecb','LSQ',337.794916666667,-24.8874166666667,NULL,NULL,'2012-08-07 04:46:53',56146.1575600002,18.0044,0.0443,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-08 15:52:20','2012-08-08 15:52:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_49896.gif',50073090668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(518,435,0,'LSQ12ecb','LSQ',337.794708333333,-24.8875,NULL,NULL,'2012-08-07 06:52:15',56146.24462,18.0174,0.0541,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-08 15:52:20','2012-08-08 15:52:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_49899.gif',50073090666,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(519,435,0,'LSQ12ecb','LSQ',337.794958333333,-24.8873888888889,NULL,NULL,'2012-08-07 06:53:56',56146.2457900001,18.0421,0.0417,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-08 15:52:20','2012-08-08 15:52:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_49897.gif',50073090668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(520,472,0,'LSQ12eeq','LSQ',313.204333333333,-16.5600277777778,NULL,NULL,'2012-08-07 05:28:42',56146.1866000001,19.2125,0.0885,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-08 15:52:20','2012-08-08 15:52:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_snap_49905.gif',50992845486,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796763210,12449425,NULL,NULL,NULL,NULL),(521,521,1,'PS1-12bat','Pan-STARRS1',221.132343226,2.96487440242,NULL,NULL,'2012-04-27 12:51:02',56044.4937787,18.28,0.0106736,'r',NULL,NULL,NULL,NULL,'2012-08-08 19:00:20','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1144431761025753500/','agn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56044/1144431761025753500_56044.493_481924_184_target.jpeg',NULL,NULL,58263843864,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,910372560,14224571,NULL,NULL,NULL,NULL),(522,521,0,'PS1-12bat','Pan-STARRS1',221.13236969,2.96486717126,NULL,NULL,'2012-08-04 07:26:02',56143.2680899,18.0304,0.0233384,'z',NULL,NULL,NULL,NULL,'2012-08-08 19:00:20','2012-08-08 19:00:20','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1144431761025753500/','agn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56143/1144431761025753500_56143.268_504152_209_target.jpeg',NULL,NULL,58263843864,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,910372560,14224571,NULL,NULL,NULL,NULL),(523,521,0,'PS1-12bat','Pan-STARRS1',221.132364767,2.96485575711,NULL,NULL,'2012-08-04 07:41:32',56143.2788494,18.0812,0.0266641,'z',NULL,NULL,NULL,NULL,'2012-08-08 19:00:20','2012-08-08 19:00:20','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1144431761025753500/','agn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56143/1144431761025753500_56143.278_504174_218_target.jpeg',NULL,NULL,58263843864,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,910372560,14224571,NULL,NULL,NULL,NULL),(524,524,1,'PS1-12bas','Pan-STARRS1',18.5520411887,6.37945763624,NULL,NULL,'2012-08-02 14:35:54',56141.5666039,19.6577,0.076857,'z',NULL,NULL,NULL,NULL,'2012-08-08 19:00:20','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1011412481062246000/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56141/1011412481062246000_56141.566_503410_474_target.jpeg',NULL,NULL,67569964911,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1055780701,16496573,NULL,NULL,NULL,NULL),(525,524,0,'PS1-12bas','Pan-STARRS1',18.5520184633,6.37946827392,NULL,NULL,'2012-08-02 14:53:21',56141.5787257,19.5446,0.0640095,'z',NULL,NULL,NULL,NULL,'2012-08-08 19:00:20','2012-08-08 19:00:20','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1011412481062246000/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56141/1011412481062246000_56141.578_503434_329_target.jpeg',NULL,NULL,67569964911,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1055780701,16496573,NULL,NULL,NULL,NULL),(526,189,0,'LSQ12dpx','LSQ',348.561291666667,-6.96727777777778,NULL,NULL,'2012-08-08 08:16:51',56147.3033699999,17.8448,0.0389,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 07:45:22','2012-08-09 07:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_snap_50117.gif',49602146390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,775033537,12109899,NULL,NULL,NULL,NULL),(527,189,0,'LSQ12dpx','LSQ',348.561291666667,-6.9665,NULL,NULL,'2012-08-08 09:54:43',56147.3713400001,18.1982,0.0518,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 07:45:22','2012-08-09 07:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_snap_50118.gif',49602146390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,775033537,12109899,NULL,NULL,NULL,NULL),(528,202,0,'LSQ12dpv','LSQ',337.130333333333,-6.07302777777778,NULL,NULL,'2012-08-08 05:28:25',56147.1864100001,20.3863,0.1363,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 07:45:22','2012-08-09 07:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpv/LSQ12dpv_history.html','sne or agn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpv/LSQ12dpv_snap_50108.gif',50390558409,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,787352475,12302382,NULL,NULL,NULL,NULL),(529,208,0,'LSQ12dpq','LSQ',329.242916666667,-7.135,NULL,NULL,'2012-08-08 04:45:11',56147.1563800001,18.171,0.0546,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 07:45:22','2012-08-09 07:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_history.html','sne or agn',NULL,0.12054,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpq/LSQ12dpq_snap_50087.gif',49923915501,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,780061179,12188455,NULL,NULL,NULL,NULL),(530,228,0,'LSQ12dpn','LSQ',47.805375,-5.48552777777778,NULL,NULL,'2012-08-08 08:12:39',56147.3004600001,18.56,0.167,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 07:45:22','2012-08-09 07:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_snap_50101.gif',37858580920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591540326,9242817,NULL,NULL,NULL,NULL),(531,250,0,'LSQ12dpi','LSQ',18.8045833333333,-3.19469444444444,NULL,NULL,'2012-08-08 10:21:00',56147.3895899998,19.1435,0.1927,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 07:45:22','2012-08-09 07:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_snap_50085.gif',34503822819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539122231,8423784,NULL,NULL,NULL,NULL),(532,297,0,'LSQ12dsc','LSQ',244.916458333333,4.21605555555556,NULL,NULL,'2012-08-08 00:41:07',56146.9868899998,20.6644,0.1609,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 07:45:22','2012-08-09 07:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsc/LSQ12dsc_history.html','possible sne ',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dsc/LSQ12dsc_snap_50086.gif',56499892140,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,882810814,13793918,NULL,NULL,NULL,NULL),(533,332,0,'LSQ12dwl','LSQ',333.173166666667,0.512,NULL,NULL,'2012-08-08 03:11:49',56147.09155,14.7064,0.003,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 07:45:22','2012-08-09 07:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_history.html','sne-nice!',NULL,0.01377,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_snap_50165.gif',52152344380,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814880380,12732505,NULL,NULL,NULL,NULL),(534,332,0,'LSQ12dwl','LSQ',333.173166666667,0.511972222222222,NULL,NULL,'2012-08-08 05:14:51',56147.1769900001,14.762,0.0032,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 07:45:22','2012-08-09 07:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_history.html','sne-nice!',NULL,0.01377,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_snap_50166.gif',52152344380,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814880380,12732505,NULL,NULL,NULL,NULL),(535,336,0,'LSQ12dwf','LSQ',323.475083333333,0.149055555555556,NULL,NULL,'2012-08-08 02:37:36',56147.0677800002,20.0168,0.113,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 07:45:22','2012-08-09 07:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_history.html','sn',NULL,0.12212,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_snap_50150.gif',52106900277,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,814170316,12721411,NULL,NULL,NULL,NULL),(536,336,0,'LSQ12dwf','LSQ',323.475041666667,0.149055555555556,NULL,NULL,'2012-08-08 04:38:26',56147.1516999998,20.082,0.0931,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 07:45:22','2012-08-09 07:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_history.html','sn',NULL,0.12212,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_snap_50151.gif',52106900277,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,814170316,12721411,NULL,NULL,NULL,NULL),(537,362,0,'LSQ12dum','LSQ',0.24375,0.857361111111111,NULL,NULL,'2012-08-08 10:36:06',56147.40007,19.6263,0.1099,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 07:45:22','2012-08-09 07:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_snap_50144.gif',66572724993,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1040198828,16253106,NULL,NULL,NULL,NULL),(538,362,0,'LSQ12dum','LSQ',0.243833333333333,0.857472222222222,NULL,NULL,'2012-08-08 11:25:47',56147.4345800001,19.3294,0.2097,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 07:45:22','2012-08-09 07:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_snap_50145.gif',66572724993,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1040198828,16253106,NULL,NULL,NULL,NULL),(539,407,0,'LSQ12dyw','LSQ',352.353416666667,-7.38905555555556,NULL,NULL,'2012-08-08 08:30:33',56147.3128900002,18.4961,0.0575,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 07:45:22','2012-08-09 07:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_snap_50206.gif',49660467229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,775944800,12124137,NULL,NULL,NULL,NULL),(540,407,0,'LSQ12dyw','LSQ',352.353208333333,-7.38891666666667,NULL,NULL,'2012-08-08 10:08:15',56147.3807399999,18.4915,0.0506,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 07:45:22','2012-08-09 07:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_snap_50207.gif',49660467229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,775944800,12124137,NULL,NULL,NULL,NULL),(541,457,0,'LSQ12edo','LSQ',51.5784166666667,-3.29752777777778,NULL,NULL,'2012-08-08 08:26:21',56147.3099699998,18.8399,0.1377,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 07:45:22','2012-08-09 07:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_snap_50126.gif',36842019075,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,575656548,8994633,NULL,NULL,NULL,NULL),(542,542,1,'PSNJ21253403-4016432','TOCP',321.391766666667,-40.2786888888889,NULL,NULL,'2012-06-27 00:00:00',56105,15.5,0.3,'unfiltered',NULL,NULL,NULL,NULL,'2012-08-09 14:45:20','2019-10-11 14:10:04',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'http://www.das.uchile.cl/~gpignata/pessto/PSNJ21253403-4016432.gif',51356335194,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,802442737,12538167,NULL,NULL,NULL,NULL),(543,543,1,'PSNJ20032484-5557192','TOCP',300.8535,-55.955325,NULL,NULL,'2012-06-27 00:00:00',56105,15.5,0.3,'unfiltered',NULL,NULL,NULL,NULL,'2012-08-09 14:45:20','2020-04-28 09:08:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'http://www.das.uchile.cl/~gpignata/pessto/PSNJ20032484-5557192.gif',49049600212,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,766400003,11975000,NULL,NULL,NULL,NULL),(544,544,1,'LSQ12egf','LSQ',342.308791666667,1.74255555555556,NULL,NULL,'2012-07-05 05:24:00',56113.2250100002,19.2909,0.1348,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 15:45:25','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_50372.gif',51679416304,NULL,NULL,NULL,'2012-06-30 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(545,544,0,'LSQ12egf','LSQ',342.308708333333,1.74247222222222,NULL,NULL,'2012-07-05 07:26:35',56113.3101300001,18.8054,0.0936,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 15:45:25','2012-08-09 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_50373.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(546,544,0,'LSQ12egf','LSQ',342.309333333333,1.74280555555556,NULL,NULL,'2012-07-07 05:14:22',56115.21832,19.3915,0.1345,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 15:45:25','2012-08-09 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_50374.gif',51679416276,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(547,544,0,'LSQ12egf','LSQ',342.30875,1.7425,NULL,NULL,'2012-07-07 07:14:56',56115.30204,18.9726,0.1152,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 15:45:25','2012-08-09 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_50375.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(548,544,0,'LSQ12egf','LSQ',342.308916666667,1.7425,NULL,NULL,'2012-07-23 04:27:50',56131.1860000002,18.3959,0.053,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 15:45:25','2012-08-09 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_50376.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(549,544,0,'LSQ12egf','LSQ',342.308875,1.74255555555556,NULL,NULL,'2012-07-23 06:48:22',56131.2835900001,18.9626,0.075,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 15:45:25','2012-08-09 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_50377.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(550,544,0,'LSQ12egf','LSQ',342.308708333333,1.7425,NULL,NULL,'2012-07-27 04:27:59',56135.1861,19.0037,0.0679,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 15:45:25','2012-08-09 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_50378.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(551,544,0,'LSQ12egf','LSQ',342.30875,1.74261111111111,NULL,NULL,'2012-07-27 06:28:18',56135.2696600002,18.9684,0.0525,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 15:45:25','2012-08-09 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_50379.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(552,544,0,'LSQ12egf','LSQ',342.309041666667,1.74280555555556,NULL,NULL,'2012-07-29 04:05:20',56137.17038,19.5871,0.1743,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 15:45:25','2012-08-09 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_50380.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(553,544,0,'LSQ12egf','LSQ',342.308791666667,1.74247222222222,NULL,NULL,'2012-07-29 06:24:36',56137.2670900002,19.396,0.1044,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 15:45:25','2012-08-09 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_50381.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(554,544,0,'LSQ12egf','LSQ',342.309,1.74261111111111,NULL,NULL,'2012-07-31 10:07:19',56139.4217500002,19.4986,0.0711,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 15:45:25','2012-08-09 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_50382.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(555,544,0,'LSQ12egf','LSQ',342.308875,1.74275,NULL,NULL,'2012-08-08 03:14:23',56147.1349999998,20.1351,0.1365,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 15:45:25','2012-08-09 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_50331.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(556,544,0,'LSQ12egf','LSQ',342.309041666667,1.74275,NULL,NULL,'2012-08-08 05:14:34',56147.21845,19.7331,0.1144,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-09 15:45:25','2012-08-09 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_50332.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(557,557,1,'LSQ12ege','LSQ',252.716541666667,2.87413888888889,NULL,NULL,'2012-07-15 01:12:36',56123.0504200002,20.4853,0.2151,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-09 15:45:25','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_snap_50371.gif',55981405188,NULL,NULL,NULL,'2012-07-09 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,874709456,13667335,NULL,NULL,NULL,NULL),(558,557,0,'LSQ12ege','LSQ',252.715958333333,2.87455555555556,NULL,NULL,'2012-08-07 23:34:22',56146.9822,19.2516,0.0832,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-09 15:45:25','2012-08-09 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_snap_50329.gif',55981393928,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,874709280,13667332,NULL,NULL,NULL,NULL),(559,557,0,'LSQ12ege','LSQ',252.716,2.87452777777778,NULL,NULL,'2012-08-08 01:34:54',56147.0659099999,18.877,0.0661,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-09 15:45:25','2012-08-09 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_snap_50330.gif',55981393928,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,874709280,13667332,NULL,NULL,NULL,NULL),(560,560,1,'LSQ12ehh','LSQ',246.802,2.08336111111111,NULL,NULL,'2012-04-23 06:34:12',56040.2737599998,20.5828,0.1917,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-09 16:45:25','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_history.html','sne - nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_snap_50510.gif',56440595287,NULL,NULL,NULL,'2012-04-21 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881884301,13779442,NULL,NULL,NULL,NULL),(561,560,0,'LSQ12ehh','LSQ',246.801625,2.08341666666667,NULL,NULL,'2012-07-27 00:15:28',56135.0107499999,19.866,0.1641,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-09 16:45:25','2012-08-09 16:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_history.html','sne - nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_snap_50511.gif',56440595284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881884301,13779442,NULL,NULL,NULL,NULL),(562,560,0,'LSQ12ehh','LSQ',246.801458333333,2.08341666666667,NULL,NULL,'2012-07-29 02:08:07',56137.08898,19.9193,0.1511,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-09 16:45:25','2012-08-09 16:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_history.html','sne - nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_snap_50512.gif',56440595284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881884301,13779442,NULL,NULL,NULL,NULL),(563,560,0,'LSQ12ehh','LSQ',246.801541666667,2.08344444444444,NULL,NULL,'2012-08-07 23:29:16',56146.97866,19.2861,0.0514,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-09 16:45:25','2012-08-09 16:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_history.html','sne - nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_snap_50464.gif',56440595284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881884301,13779442,NULL,NULL,NULL,NULL),(564,560,0,'LSQ12ehh','LSQ',246.8015,2.08341666666667,NULL,NULL,'2012-08-08 01:29:51',56147.0624000002,19.4608,0.0497,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-09 16:45:25','2012-08-09 16:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_history.html','sne - nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_snap_50465.gif',56440595284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881884301,13779442,NULL,NULL,NULL,NULL),(565,428,0,'LSQ12ecd','LSQ',339.478541666667,-21.1294444444444,NULL,NULL,'2012-08-09 04:07:26',56148.1718299999,18.5691,0.1168,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-10 03:45:22','2012-08-10 03:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecd/LSQ12ecd_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecd/LSQ12ecd_snap_50521.gif',50257618254,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785275285,12269926,NULL,NULL,NULL,NULL),(566,435,0,'LSQ12ecb','LSQ',337.794625,-24.8875277777778,NULL,NULL,'2012-08-09 01:53:00',56148.0784800001,18.2246,0.0415,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-10 03:45:22','2012-08-10 03:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_50537.gif',50073090666,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(567,435,0,'LSQ12ecb','LSQ',337.794708333333,-24.8874722222222,NULL,NULL,'2012-08-09 01:54:41',56148.0796500002,18.2411,0.045,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-10 03:45:22','2012-08-10 03:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_50535.gif',50073090668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(568,435,0,'LSQ12ecb','LSQ',337.794666666667,-24.8875,NULL,NULL,'2012-08-09 04:05:44',56148.1706500002,18.4038,0.0367,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-10 03:45:22','2012-08-10 03:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_50538.gif',50073090666,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(569,435,0,'LSQ12ecb','LSQ',337.794833333333,-24.8874722222222,NULL,NULL,'2012-08-09 04:07:26',56148.1718299999,18.2945,0.0403,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-10 03:45:22','2012-08-10 03:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_50536.gif',50073090668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(570,472,0,'LSQ12eeq','LSQ',313.203583333333,-16.5599166666667,NULL,NULL,'2012-08-09 02:16:10',56148.0945700002,18.4594,0.0526,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-10 03:45:22','2012-08-10 03:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_snap_50556.gif',50992845486,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796763210,12449425,NULL,NULL,NULL,NULL),(571,571,1,'LSQ12ehj','LSQ',347.315666666667,7.04825,NULL,NULL,'2012-08-08 05:50:16',56147.2432499998,18.659,0.0736,'gr-LSQ',NULL,NULL,'AGN',NULL,'2012-08-10 15:45:22','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_snap_50468.gif',51719133726,NULL,NULL,NULL,'2012-08-04 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,808111464,12626741,NULL,NULL,NULL,NULL),(572,571,0,'LSQ12ehj','LSQ',347.315708333333,7.04827777777778,NULL,NULL,'2012-08-08 07:50:41',56147.32687,18.4789,0.0713,'gr-LSQ',NULL,NULL,'AGN',NULL,'2012-08-10 15:45:22','2012-08-10 15:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_snap_50469.gif',51719133726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,808111464,12626741,NULL,NULL,NULL,NULL),(573,573,1,'LSQ12ehn','LSQ',53.8109166666667,-18.4273888888889,NULL,NULL,'2012-07-28 08:35:17',56136.3578400002,20.1796,0.1193,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-10 15:45:22','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_history.html','variable or unusual',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_snap_50648.gif',38005697462,NULL,NULL,NULL,'2011-12-15 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,593839022,9278734,NULL,NULL,NULL,NULL),(574,573,0,'LSQ12ehn','LSQ',53.8109166666667,-18.4273333333333,NULL,NULL,'2012-07-28 09:35:15',56136.3994900002,20.3145,0.1199,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-10 15:45:22','2012-08-10 15:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_history.html','variable or unusual',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_snap_50649.gif',38005697462,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,593839022,9278734,NULL,NULL,NULL,NULL),(575,573,0,'LSQ12ehn','LSQ',53.811,-18.4273888888889,NULL,NULL,'2012-07-30 07:41:32',56138.32051,19.6753,0.2056,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-10 15:45:22','2012-08-10 15:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_history.html','variable or unusual',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_snap_50650.gif',38005697462,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,593839022,9278734,NULL,NULL,NULL,NULL),(576,573,0,'LSQ12ehn','LSQ',53.8109583333333,-18.4273333333333,NULL,NULL,'2012-07-30 09:08:04',56138.3806099999,20.0753,0.0851,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-10 15:45:22','2012-08-10 15:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_history.html','variable or unusual',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_snap_50651.gif',38005697462,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,593839022,9278734,NULL,NULL,NULL,NULL),(577,573,0,'LSQ12ehn','LSQ',53.811,-18.4273055555556,NULL,NULL,'2012-08-09 10:09:19',56148.4231400001,20.4118,0.1017,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-10 15:45:22','2012-08-10 15:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_history.html','variable or unusual',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_snap_50640.gif',38005697462,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,593839022,9278734,NULL,NULL,NULL,NULL),(578,573,0,'LSQ12ehn','LSQ',53.811,-18.4273888888889,NULL,NULL,'2012-08-09 10:17:49',56148.4290399998,20.0091,0.1319,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-10 15:45:22','2012-08-10 15:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_history.html','variable or unusual',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_snap_50641.gif',38005697462,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,593839022,9278734,NULL,NULL,NULL,NULL),(579,579,1,'LSQ12ehm','LSQ',55.0169583333333,-17.8017222222222,NULL,NULL,'2012-08-09 10:09:19',56148.4231400001,18.5302,0.068,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-10 15:45:22','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehm/LSQ12ehm_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehm/LSQ12ehm_snap_50638.gif',38011902031,NULL,NULL,NULL,'2012-08-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,593935969,9280249,NULL,NULL,NULL,NULL),(580,579,0,'LSQ12ehm','LSQ',55.0169583333333,-17.8017777777778,NULL,NULL,'2012-08-09 10:17:49',56148.4290399998,18.1673,0.0744,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-10 15:45:22','2012-08-10 15:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehm/LSQ12ehm_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehm/LSQ12ehm_snap_50639.gif',38011902031,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,593935969,9280249,NULL,NULL,NULL,NULL),(581,581,1,'LSQ12ehl','LSQ',72.5277083333333,-21.7752777777778,NULL,NULL,'2012-08-09 10:04:05',56148.4195099999,17.7974,0.0402,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-10 15:45:22','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_history.html','sne???',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_snap_50636.gif',37345461187,NULL,NULL,NULL,'2012-01-26 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,583522831,9117544,NULL,NULL,NULL,NULL),(582,581,0,'LSQ12ehl','LSQ',72.5276666666667,-21.77525,NULL,NULL,'2012-08-09 10:14:25',56148.42668,17.7687,0.0271,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-10 15:45:22','2012-08-10 15:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_history.html','sne???',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_snap_50637.gif',37345461187,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,583522831,9117544,NULL,NULL,NULL,NULL),(583,150,0,'LSQ12dmi','LSQ',22.9483333333333,-3.67475,NULL,NULL,'2012-08-10 08:39:02',56149.36045,19.7935,0.1518,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_50690.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(584,189,0,'LSQ12dpx','LSQ',348.561208333333,-6.96652777777778,NULL,NULL,'2012-08-10 09:32:02',56149.3972499999,17.2936,0.0307,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_snap_50781.gif',49602146390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,775033537,12109899,NULL,NULL,NULL,NULL),(585,189,0,'LSQ12dpx','LSQ',348.561208333333,-6.96652777777778,NULL,NULL,'2012-08-10 10:22:42',56149.4324400001,17.4055,0.0375,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpx/LSQ12dpx_snap_50782.gif',49602146390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,775033537,12109899,NULL,NULL,NULL,NULL),(586,198,0,'LSQ12dpw','LSQ',345.619875,-7.10816666666667,NULL,NULL,'2012-08-10 06:00:19',56149.2502299999,19.1647,0.1049,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpw/LSQ12dpw_history.html','sne or agn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpw/LSQ12dpw_snap_50769.gif',49487021214,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773234706,12081792,NULL,NULL,NULL,NULL),(587,198,0,'LSQ12dpw','LSQ',345.619583333333,-7.10825,NULL,NULL,'2012-08-10 07:59:58',56149.3333200002,19.4826,0.1218,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpw/LSQ12dpw_history.html','sne or agn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpw/LSQ12dpw_snap_50770.gif',49487021206,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773234706,12081792,NULL,NULL,NULL,NULL),(588,202,0,'LSQ12dpv','LSQ',337.130541666667,-6.07302777777778,NULL,NULL,'2012-08-10 04:21:20',56149.1814899999,20.7273,0.146,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpv/LSQ12dpv_history.html','sne or agn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpv/LSQ12dpv_snap_50784.gif',50390558413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,787352475,12302382,NULL,NULL,NULL,NULL),(589,228,0,'LSQ12dpn','LSQ',47.805125,-5.48575,NULL,NULL,'2012-08-10 07:25:24',56149.3093099999,19.5407,0.1419,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_snap_50750.gif',37858580920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591540326,9242817,NULL,NULL,NULL,NULL),(590,228,0,'LSQ12dpn','LSQ',47.805125,-5.48566666666667,NULL,NULL,'2012-08-10 08:57:50',56149.3735000002,19.5984,0.1806,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpn/LSQ12dpn_snap_50751.gif',37858580920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591540326,9242817,NULL,NULL,NULL,NULL),(591,250,0,'LSQ12dpi','LSQ',18.8044166666667,-3.19486111111111,NULL,NULL,'2012-08-10 06:45:06',56149.2813200001,18.8188,0.0865,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_snap_50738.gif',34503822819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539122231,8423784,NULL,NULL,NULL,NULL),(592,332,0,'LSQ12dwl','LSQ',333.173125,0.512,NULL,NULL,'2012-08-10 02:04:33',56149.0865000002,14.6743,0.0029,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_history.html','sne-nice!',NULL,0.01377,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_snap_50843.gif',52152344378,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814880380,12732505,NULL,NULL,NULL,NULL),(593,332,0,'LSQ12dwl','LSQ',333.173166666667,0.511944444444444,NULL,NULL,'2012-08-10 04:07:48',56149.17209,14.5799,0.0342,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_history.html','sne-nice!',NULL,0.01377,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_snap_50844.gif',52152344380,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814880380,12732505,NULL,NULL,NULL,NULL),(594,336,0,'LSQ12dwf','LSQ',323.475041666667,0.149027777777778,NULL,NULL,'2012-08-10 01:25:54',56149.0596599998,19.9129,0.1071,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_history.html','sn',NULL,0.12212,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_snap_50836.gif',52106900234,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,814170316,12721411,NULL,NULL,NULL,NULL),(595,336,0,'LSQ12dwf','LSQ',323.474958333333,0.149055555555556,NULL,NULL,'2012-08-10 03:27:56',56149.1444000001,20.4588,0.1453,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_history.html','sn',NULL,0.12212,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwf/LSQ12dwf_snap_50837.gif',52106900276,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,814170316,12721411,NULL,NULL,NULL,NULL),(596,358,0,'LSQ12duw','LSQ',9.04104166666667,-2.583,NULL,NULL,'2012-08-10 09:50:37',56149.41016,20.47,0.1743,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12duw/LSQ12duw_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12duw/LSQ12duw_snap_50732.gif',34579098878,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,540298419,8442162,NULL,NULL,NULL,NULL),(597,362,0,'LSQ12dum','LSQ',0.243791666666667,0.857388888888889,NULL,NULL,'2012-08-10 09:42:10',56149.40429,19.4992,0.0945,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_snap_50824.gif',66572724993,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1040198828,16253106,NULL,NULL,NULL,NULL),(598,362,0,'LSQ12dum','LSQ',0.243833333333333,0.857388888888889,NULL,NULL,'2012-08-10 10:15:55',56149.42772,19.5683,0.103,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dum/LSQ12dum_snap_50825.gif',66572724993,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1040198828,16253106,NULL,NULL,NULL,NULL),(599,381,0,'LSQ12dtf','LSQ',0.283375,-6.23297222222222,NULL,NULL,'2012-08-10 08:24:00',56149.3500000001,20.5549,0.1699,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_snap_50662.gif',34385843396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537278803,8394981,NULL,NULL,NULL,NULL),(600,402,0,'LSQ12dzd','LSQ',4.16241666666667,-0.357944444444444,NULL,NULL,'2012-08-10 09:47:14',56149.4078099998,20.2273,0.1825,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzd/LSQ12dzd_history.html','sne???',NULL,0.07471,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzd/LSQ12dzd_snap_50875.gif',34372011761,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537062683,8391604,NULL,NULL,NULL,NULL),(601,407,0,'LSQ12dyw','LSQ',352.353416666667,-7.38891666666667,NULL,NULL,'2012-08-10 09:37:07',56149.4007799998,18.4459,0.0415,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_snap_50878.gif',49660467229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,775944800,12124137,NULL,NULL,NULL,NULL),(602,407,0,'LSQ12dyw','LSQ',352.353333333333,-7.389,NULL,NULL,'2012-08-10 10:02:22',56149.4183200002,18.5806,0.049,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dyw/LSQ12dyw_snap_50879.gif',49660467229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,775944800,12124137,NULL,NULL,NULL,NULL),(603,457,0,'LSQ12edo','LSQ',51.578125,-3.29752777777778,NULL,NULL,'2012-08-10 07:38:53',56149.31868,17.5784,0.0618,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_snap_50790.gif',36842019075,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,575656548,8994633,NULL,NULL,NULL,NULL),(604,457,0,'LSQ12edo','LSQ',51.5785416666667,-3.29769444444444,NULL,NULL,'2012-08-10 09:02:53',56149.3770099999,19.2948,0.1301,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_snap_50791.gif',36842019075,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,575656548,8994633,NULL,NULL,NULL,NULL),(605,462,0,'LSQ12edk','LSQ',47.239,-2.95447222222222,NULL,NULL,'2012-08-10 07:25:24',56149.3093099999,19.11,0.196,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_history.html','sne',NULL,0.0082,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_snap_50808.gif',36790348504,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,574849195,8982018,NULL,NULL,NULL,NULL),(606,544,0,'LSQ12egf','LSQ',342.308708333333,1.74241666666667,NULL,NULL,'2012-08-10 03:07:05',56149.1299299998,19.0403,0.0698,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_50910.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(607,544,0,'LSQ12egf','LSQ',342.308666666667,1.74252777777778,NULL,NULL,'2012-08-10 05:07:35',56149.2135999999,19.0279,0.0506,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_50911.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(608,557,0,'LSQ12ege','LSQ',252.716,2.87458333333333,NULL,NULL,'2012-08-10 00:52:09',56149.0362200001,18.5607,0.07,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_snap_50930.gif',55981393928,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,874709280,13667332,NULL,NULL,NULL,NULL),(609,560,0,'LSQ12ehh','LSQ',246.8015,2.08347222222222,NULL,NULL,'2012-08-10 01:06:06',56149.0459099999,19.2252,0.0519,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_history.html','sne - nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_snap_50915.gif',56440595284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881884301,13779442,NULL,NULL,NULL,NULL),(610,571,0,'LSQ12ehj','LSQ',347.315708333333,7.04825,NULL,NULL,'2012-08-10 07:46:24',56149.3239000002,18.6274,0.0505,'gr-LSQ',NULL,NULL,'AGN',NULL,'2012-08-11 06:45:25','2012-08-11 06:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_snap_50916.gif',51719133726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,808111464,12626741,NULL,NULL,NULL,NULL),(611,611,1,'LSQ12eid','LSQ',4.408375,-5.38275,NULL,NULL,'2012-07-29 06:34:56',56137.2742699999,19.9358,0.1452,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-11 16:45:24','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_snap_51160.gif',34413529726,NULL,NULL,NULL,'2012-07-27 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537711401,8401740,NULL,NULL,NULL,NULL),(612,611,0,'LSQ12eid','LSQ',4.40833333333333,-5.38275,NULL,NULL,'2012-07-31 10:05:32',56139.4205100001,19.3654,0.0805,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-11 16:45:24','2012-08-11 16:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_snap_51161.gif',34413529726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537711401,8401740,NULL,NULL,NULL,NULL),(613,611,0,'LSQ12eid','LSQ',4.40833333333333,-5.38286111111111,NULL,NULL,'2012-08-08 06:14:41',56147.2601999999,17.8679,0.0581,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-11 16:45:24','2012-08-11 16:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_snap_51162.gif',34413529726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537711401,8401740,NULL,NULL,NULL,NULL),(614,611,0,'LSQ12eid','LSQ',4.408375,-5.38275,NULL,NULL,'2012-08-08 08:15:05',56147.34381,18.1069,0.0419,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-11 16:45:24','2012-08-11 16:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_snap_51163.gif',34413529726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537711401,8401740,NULL,NULL,NULL,NULL),(615,611,0,'LSQ12eid','LSQ',4.40820833333333,-5.38277777777778,NULL,NULL,'2012-08-10 06:31:35',56149.2719399999,18.084,0.0329,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-11 16:45:24','2012-08-11 16:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_snap_51111.gif',34413529726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537711401,8401740,NULL,NULL,NULL,NULL),(616,611,0,'LSQ12eid','LSQ',4.40808333333333,-5.38283333333333,NULL,NULL,'2012-08-10 09:14:54',56149.3853500001,18.0722,0.0479,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-11 16:45:24','2012-08-11 16:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_snap_51112.gif',34413529726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537711401,8401740,NULL,NULL,NULL,NULL),(617,617,1,'LSQ12eib','LSQ',8.040875,-7.38152777777778,NULL,NULL,'2012-07-31 06:38:38',56139.2768399999,18.9377,0.1506,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 16:45:24','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_snap_51156.gif',34627856184,NULL,NULL,NULL,'2012-07-29 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,541060252,8454066,NULL,NULL,NULL,NULL),(618,617,0,'LSQ12eib','LSQ',8.04095833333333,-7.38155555555555,NULL,NULL,'2012-07-31 08:35:34',56139.3580399998,19.1286,0.144,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 16:45:24','2012-08-11 16:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_snap_51157.gif',34627856184,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,541060252,8454066,NULL,NULL,NULL,NULL),(619,617,0,'LSQ12eib','LSQ',8.041,-7.38155555555555,NULL,NULL,'2012-08-08 06:27:02',56147.26878,18.7594,0.0776,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 16:45:24','2012-08-11 16:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_snap_51158.gif',34627856184,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,541060252,8454066,NULL,NULL,NULL,NULL),(620,617,0,'LSQ12eib','LSQ',8.040875,-7.38152777777778,NULL,NULL,'2012-08-08 08:26:57',56147.3520499999,18.6532,0.076,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 16:45:24','2012-08-11 16:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_snap_51159.gif',34627856184,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,541060252,8454066,NULL,NULL,NULL,NULL),(621,617,0,'LSQ12eib','LSQ',8.04095833333333,-7.38152777777778,NULL,NULL,'2012-08-10 06:36:38',56149.2754500001,18.8262,0.0528,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 16:45:24','2012-08-11 16:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_snap_51107.gif',34627856184,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,541060252,8454066,NULL,NULL,NULL,NULL),(622,617,0,'LSQ12eib','LSQ',8.04066666666667,-7.3815,NULL,NULL,'2012-08-10 09:09:49',56149.3818199998,18.657,0.0603,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 16:45:24','2012-08-11 16:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_snap_51108.gif',34627856184,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,541060252,8454066,NULL,NULL,NULL,NULL),(623,623,1,'LSQ12ehw','LSQ',357.061833333333,-7.17166666666667,NULL,NULL,'2012-08-08 07:33:57',56147.31525,19.5216,0.1119,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-11 16:45:24','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehw/LSQ12ehw_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehw/LSQ12ehw_snap_51129.gif',49435432346,NULL,NULL,NULL,'2012-08-04 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772428630,12069197,NULL,NULL,NULL,NULL),(624,623,0,'LSQ12ehw','LSQ',357.061833333333,-7.17166666666667,NULL,NULL,'2012-08-08 09:01:26',56147.3760000002,19.6484,0.1723,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-11 16:45:24','2012-08-11 16:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehw/LSQ12ehw_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehw/LSQ12ehw_snap_51130.gif',49435432346,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772428630,12069197,NULL,NULL,NULL,NULL),(625,623,0,'LSQ12ehw','LSQ',357.061833333333,-7.17163888888889,NULL,NULL,'2012-08-10 09:40:28',56149.4031099998,19.1804,0.0773,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-11 16:45:24','2012-08-11 16:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehw/LSQ12ehw_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehw/LSQ12ehw_snap_51097.gif',49435432346,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772428630,12069197,NULL,NULL,NULL,NULL),(626,623,0,'LSQ12ehw','LSQ',357.061875,-7.17177777777778,NULL,NULL,'2012-08-10 10:17:36',56149.4289000002,19.3434,0.1215,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-11 16:45:24','2012-08-11 16:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehw/LSQ12ehw_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehw/LSQ12ehw_snap_51098.gif',49435432346,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772428630,12069197,NULL,NULL,NULL,NULL),(627,627,1,'LSQ12eht','LSQ',354.3595,10.3063333333333,NULL,NULL,'2012-08-08 05:58:49',56147.2491799998,19.8216,0.1394,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 16:45:24','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eht/LSQ12eht_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eht/LSQ12eht_snap_51122.gif',51778995065,NULL,NULL,NULL,'2012-08-04 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,809046797,12641356,NULL,NULL,NULL,NULL),(628,627,0,'LSQ12eht','LSQ',354.359375,10.3062777777778,NULL,NULL,'2012-08-08 07:59:07',56147.3327299999,19.6511,0.1307,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 16:45:24','2012-08-11 16:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eht/LSQ12eht_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eht/LSQ12eht_snap_51123.gif',51778995065,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,809046797,12641356,NULL,NULL,NULL,NULL),(629,627,0,'LSQ12eht','LSQ',354.359458333333,10.3064166666667,NULL,NULL,'2012-08-10 05:58:35',56149.24902,19.6256,0.1002,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 16:45:24','2012-08-11 16:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eht/LSQ12eht_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eht/LSQ12eht_snap_51091.gif',51778995065,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,809046797,12641356,NULL,NULL,NULL,NULL),(630,627,0,'LSQ12eht','LSQ',354.359416666667,10.3064166666667,NULL,NULL,'2012-08-10 07:58:16',56149.33213,19.4427,0.0955,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 16:45:24','2012-08-11 16:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eht/LSQ12eht_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eht/LSQ12eht_snap_51092.gif',51778995065,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,809046797,12641356,NULL,NULL,NULL,NULL),(631,472,0,'LSQ12eeq','LSQ',313.204583333333,-16.5599722222222,NULL,NULL,'2012-08-11 00:31:48',56150.0220900001,19.6694,0.105,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-11 19:45:24','2012-08-11 19:45:24','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_snap_51170.gif',50992845486,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796763210,12449425,NULL,NULL,NULL,NULL),(632,150,0,'LSQ12dmi','LSQ',22.948,-3.67463888888889,NULL,NULL,'2012-08-12 08:23:49',56151.3498800001,20.03,0.1698,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-13 02:45:26','2012-08-13 02:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dmi/LSQ12dmi_snap_51227.gif',35241776632,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,550652759,8603949,NULL,NULL,NULL,NULL),(633,250,0,'LSQ12dpi','LSQ',18.8049166666667,-3.195,NULL,NULL,'2012-08-12 08:07:16',56151.3383800001,20.1555,0.1478,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-13 02:45:26','2012-08-13 02:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_snap_51269.gif',34503822819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539122231,8423784,NULL,NULL,NULL,NULL),(634,250,0,'LSQ12dpi','LSQ',18.8045,-3.19494444444444,NULL,NULL,'2012-08-12 09:42:02',56151.4042000002,19.1118,0.0936,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-13 02:45:26','2012-08-13 02:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dpi/LSQ12dpi_snap_51270.gif',34503822819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539122231,8423784,NULL,NULL,NULL,NULL),(635,312,0,'LSQ12dxl','LSQ',254.771166666667,16.6041388888889,NULL,NULL,'2012-08-12 01:16:08',56151.0528799999,20.6379,0.1256,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-13 02:45:26','2012-08-13 02:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dxl/LSQ12dxl_history.html','galactic variability',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dxl/LSQ12dxl_snap_51301.gif',56901257269,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,889082144,13891908,NULL,NULL,NULL,NULL),(636,381,0,'LSQ12dtf','LSQ',0.283541666666667,-6.23297222222222,NULL,NULL,'2012-08-12 07:50:21',56151.3266400001,19.8514,0.1671,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-13 02:45:26','2012-08-13 02:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtf/LSQ12dtf_snap_51202.gif',34385843399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537278803,8394981,NULL,NULL,NULL,NULL),(637,557,0,'LSQ12ege','LSQ',252.715875,2.87455555555556,NULL,NULL,'2012-08-11 23:27:46',56150.97762,18.7264,0.0686,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-13 02:45:26','2012-08-13 02:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_snap_51317.gif',55981393928,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,874709280,13667332,NULL,NULL,NULL,NULL),(638,560,0,'LSQ12ehh','LSQ',246.801458333333,2.08344444444444,NULL,NULL,'2012-08-11 23:32:51',56150.9811499999,19.5542,0.0582,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-13 02:45:26','2012-08-13 02:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_history.html','sne - nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_snap_51314.gif',56440595284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881884301,13779442,NULL,NULL,NULL,NULL),(639,560,0,'LSQ12ehh','LSQ',246.801458333333,2.08341666666667,NULL,NULL,'2012-08-11 23:36:14',56150.9835000001,19.4039,0.0573,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-13 02:45:26','2012-08-13 02:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_history.html','sne - nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_snap_51315.gif',56440595284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881884301,13779442,NULL,NULL,NULL,NULL),(640,611,0,'LSQ12eid','LSQ',4.40829166666667,-5.38277777777778,NULL,NULL,'2012-08-12 07:53:45',56151.3289999999,18.1278,0.0472,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-13 02:45:26','2012-08-13 02:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_snap_51246.gif',34413529726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537711401,8401740,NULL,NULL,NULL,NULL),(641,611,0,'LSQ12eid','LSQ',4.40833333333333,-5.38275,NULL,NULL,'2012-08-12 09:55:31',56151.4135599998,18.0815,0.0329,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-13 02:45:26','2012-08-13 02:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_snap_51247.gif',34413529726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537711401,8401740,NULL,NULL,NULL,NULL),(642,617,0,'LSQ12eib','LSQ',8.04095833333333,-7.38152777777778,NULL,NULL,'2012-08-12 07:58:49',56151.3325200002,19.0648,0.0548,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-13 02:45:26','2012-08-13 02:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_snap_51248.gif',34627856184,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,541060252,8454066,NULL,NULL,NULL,NULL),(643,617,0,'LSQ12eib','LSQ',8.04108333333333,-7.38155555555555,NULL,NULL,'2012-08-12 09:50:28',56151.4100500001,19.0052,0.0572,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-13 02:45:26','2012-08-13 02:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_snap_51249.gif',34627856132,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,541060252,8454066,NULL,NULL,NULL,NULL),(644,644,1,'LSQ12eij','LSQ',353.852416666667,-20.5113333333333,NULL,NULL,'2012-08-12 07:05:27',56151.2954600002,19.252,0.039,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-13 15:45:34','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eij/LSQ12eij_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eij/LSQ12eij_snap_51416.gif',50275077940,NULL,NULL,NULL,'2012-08-12 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785548092,12274188,NULL,NULL,NULL,NULL),(645,644,0,'LSQ12eij','LSQ',353.852416666667,-20.5113333333333,NULL,NULL,'2012-08-12 09:06:52',56151.37977,19.3949,0.0568,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-13 15:45:34','2012-08-13 15:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eij/LSQ12eij_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eij/LSQ12eij_snap_51417.gif',50275077940,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785548092,12274188,NULL,NULL,NULL,NULL),(646,646,1,'LSQ12eiq','LSQ',32.5290833333333,-5.57641666666667,NULL,NULL,'2011-12-15 01:07:07',55910.0466200002,20.1703,0.1134,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-13 18:45:22','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_snap_51525.gif',35142165909,NULL,NULL,NULL,'2011-12-14 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549096342,8579630,NULL,NULL,NULL,NULL),(647,646,0,'LSQ12eiq','LSQ',32.528875,-5.57658333333333,NULL,NULL,'2012-07-15 10:11:49',56123.4248799998,21.1003,0.1792,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-13 18:45:22','2012-08-13 18:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_snap_51526.gif',35142165909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549096342,8579630,NULL,NULL,NULL,NULL),(648,646,0,'LSQ12eiq','LSQ',32.5293333333333,-5.57613888888889,NULL,NULL,'2012-08-08 06:54:12',56147.2876499998,19.2592,0.1173,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-13 18:45:22','2012-08-13 18:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_snap_51527.gif',35142165909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549096342,8579630,NULL,NULL,NULL,NULL),(649,646,0,'LSQ12eiq','LSQ',32.5295,-5.57608333333333,NULL,NULL,'2012-08-10 06:59:23',56149.2912499998,18.8232,0.0573,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-13 18:45:22','2012-08-13 18:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_snap_51528.gif',35142165909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549096342,8579630,NULL,NULL,NULL,NULL),(650,646,0,'LSQ12eiq','LSQ',32.5292916666667,-5.57611111111111,NULL,NULL,'2012-08-10 08:42:25',56149.3627999998,18.9175,0.057,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-13 18:45:22','2012-08-13 18:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_snap_51529.gif',35142165909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549096342,8579630,NULL,NULL,NULL,NULL),(651,646,0,'LSQ12eiq','LSQ',32.529375,-5.57605555555556,NULL,NULL,'2012-08-12 10:04:14',56151.4196100002,18.7319,0.0396,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-13 18:45:22','2012-08-13 18:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_snap_51442.gif',35142165909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549096342,8579630,NULL,NULL,NULL,NULL),(652,646,0,'LSQ12eiq','LSQ',32.5295,-5.57608333333333,NULL,NULL,'2012-08-12 10:22:50',56151.4325299999,18.7734,0.0642,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-13 18:45:22','2012-08-13 18:45:22','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_snap_51443.gif',35142165909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549096342,8579630,NULL,NULL,NULL,NULL),(653,478,0,'PS1-12bah','Pan-STARRS1',276.247255165,22.559172102,NULL,NULL,'2012-08-09 09:24:29',56148.3920118,17.1947,0.00595375,'g',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1182459331223333000/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,54568800782,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,852637512,13322461,NULL,NULL,NULL,NULL),(654,478,0,'PS1-12bah','Pan-STARRS1',276.24725563,22.5591726713,NULL,NULL,'2012-08-09 09:40:07',56148.4028648,17.1649,0.00602876,'g',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1182459331223333000/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,54568800782,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,852637512,13322461,NULL,NULL,NULL,NULL),(655,496,0,'PS1-12bap','Pan-STARRS1',309.891358551,26.1569336782,NULL,NULL,'2012-08-05 07:50:25',56144.3266798,19.529,0.0443415,'i',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1203933921260925000/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,55731630643,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,870806728,13606355,NULL,NULL,NULL,NULL),(656,505,0,'PS1-12bar','Pan-STARRS1',281.637648493,63.7498206219,NULL,NULL,'2012-08-10 06:18:49',56149.2630718,20.592,0.0543534,'g',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1184633011634459200/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,53073322157,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,829270658,12957354,NULL,NULL,NULL,NULL),(657,505,0,'PS1-12bar','Pan-STARRS1',281.637681727,63.7498092547,NULL,NULL,'2012-08-10 06:35:28',56149.2746387,20.5615,0.0513097,'g',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1184633011634459200/','sn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,53073322157,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,829270658,12957354,NULL,NULL,NULL,NULL),(658,658,1,'PS1-12bcc','Pan-STARRS1',278.91270014,41.276081818,NULL,NULL,'2012-04-12 14:54:06',56029.6209127,19.6547,0.0721122,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1183539041411633800/','agn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56029/1183539041411633800_56029.620_475221_1644_target.jpeg',NULL,NULL,54820594501,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,856571789,13383934,NULL,NULL,NULL,NULL),(659,658,0,'PS1-12bcc','Pan-STARRS1',278.912728915,41.2761115241,NULL,NULL,'2012-06-15 13:27:56',56093.5610704,19.8933,0.033209,'r',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1183539041411633800/','agn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56093/1183539041411633800_56093.561_499917_1422_target.jpeg',NULL,NULL,54820594501,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,856571789,13383934,NULL,NULL,NULL,NULL),(660,658,0,'PS1-12bcc','Pan-STARRS1',278.912737247,41.2761052827,NULL,NULL,'2012-06-15 13:43:11',56093.5716639,19.6656,0.0272068,'r',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1183539041411633800/','agn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56093/1183539041411633800_56093.571_499933_1440_target.jpeg',NULL,NULL,54820594501,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,856571789,13383934,NULL,NULL,NULL,NULL),(661,658,0,'PS1-12bcc','Pan-STARRS1',278.912719709,41.2761004118,NULL,NULL,'2012-08-07 06:41:34',56146.2788747,16.8947,0.00529018,'g',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1183539041411633800/','agn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56146/1183539041411633800_56146.278_506258_217_target.jpeg',NULL,NULL,54820594501,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,856571789,13383934,NULL,NULL,NULL,NULL),(662,658,0,'PS1-12bcc','Pan-STARRS1',278.912719733,41.276101055,NULL,NULL,'2012-08-07 06:57:34',56146.2899803,16.8581,0.00516518,'g',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1183539041411633800/','agn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56146/1183539041411633800_56146.289_506275_221_target.jpeg',NULL,NULL,54820594501,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,856571789,13383934,NULL,NULL,NULL,NULL),(663,663,0,'PS1-12bcd','Pan-STARRS1',279.17719683,78.2000463719,NULL,NULL,'2012-06-05 11:12:55',56083.4673138,18.7245,0.0567864,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2019-10-11 20:38:49','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1183642521781200100/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56083/1183642521781200100_56083.467_493748_503_target.jpeg',NULL,NULL,52717045536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,823703836,12870372,NULL,NULL,NULL,NULL),(664,663,0,'PS1-12bcd','Pan-STARRS1',279.177340945,78.2000783084,NULL,NULL,'2012-06-05 11:22:09',56083.4737183,18.6678,0.0554529,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1183642521781200100/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56083/1183642521781200100_56083.473_493762_671_target.jpeg',NULL,NULL,52717045536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,823703836,12870372,NULL,NULL,NULL,NULL),(665,663,0,'PS1-12bcd','Pan-STARRS1',279.177287806,78.2000149079,NULL,NULL,'2012-08-05 06:26:37',56144.2684847,17.3177,0.00696293,'g',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1183642521781200100/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56144/1183642521781200100_56144.268_504857_149_target.jpeg',NULL,NULL,52717045536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,823703836,12870372,NULL,NULL,NULL,NULL),(666,663,0,'PS1-12bcd','Pan-STARRS1',279.177294399,78.2000090459,NULL,NULL,'2012-08-05 06:36:50',56144.2755894,17.3509,0.00702326,'g',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1183642521781200100/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56144/1183642521781200100_56144.275_504869_137_target.jpeg',NULL,NULL,52717045536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,823703836,12870372,NULL,NULL,NULL,NULL),(667,663,0,'PS1-12bcd','Pan-STARRS1',279.177318113,78.2000271136,NULL,NULL,'2012-08-05 06:47:09',56144.282745,17.3831,0.00691404,'r',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1183642521781200100/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56144/1183642521781200100_56144.282_504879_193_target.jpeg',NULL,NULL,52717045536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,823703836,12870372,NULL,NULL,NULL,NULL),(668,663,0,'PS1-12bcd','Pan-STARRS1',279.177325487,78.200025874,NULL,NULL,'2012-08-05 06:56:51',56144.2894839,17.4087,0.00704838,'r',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1183642521781200100/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56144/1183642521781200100_56144.289_504891_190_target.jpeg',NULL,NULL,52717045536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,823703836,12870372,NULL,NULL,NULL,NULL),(669,669,1,'PS1-12bcb','Pan-STARRS1',269.041711196,46.6663274581,NULL,NULL,'2012-06-12 10:50:56',56090.4520412,19.4854,0.0227541,'r',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1175610001463958700/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56090/1175610001463958700_56090.452_497865_357_target.jpeg',NULL,NULL,57448944982,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,897639765,14025621,NULL,NULL,NULL,NULL),(670,669,0,'PS1-12bcb','Pan-STARRS1',269.041690806,46.6663171903,NULL,NULL,'2012-06-12 11:19:57',56090.4721929,19.3613,0.026236,'i',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1175610001463958700/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56090/1175610001463958700_56090.472_497897_817_target.jpeg',NULL,NULL,57448944982,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,897639765,14025621,NULL,NULL,NULL,NULL),(671,669,0,'PS1-12bcb','Pan-STARRS1',269.041705601,46.6663164229,NULL,NULL,'2012-06-12 11:35:37',56090.4830685,19.3726,0.0264857,'i',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1175610001463958700/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56090/1175610001463958700_56090.483_497913_758_target.jpeg',NULL,NULL,57448944982,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,897639765,14025621,NULL,NULL,NULL,NULL),(672,669,0,'PS1-12bcb','Pan-STARRS1',269.041707476,46.6663179729,NULL,NULL,'2012-08-06 07:59:22',56145.3329027,19.423,0.0295188,'r',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1175610001463958700/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56145/1175610001463958700_56145.332_505643_435_target.jpeg',NULL,NULL,57448944982,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,897639765,14025621,NULL,NULL,NULL,NULL),(673,669,0,'PS1-12bcb','Pan-STARRS1',269.041690537,46.6663139945,NULL,NULL,'2012-08-06 08:13:45',56145.3428887,19.3688,0.0268795,'r',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1175610001463958700/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56145/1175610001463958700_56145.342_505659_404_target.jpeg',NULL,NULL,57448944982,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,897639765,14025621,NULL,NULL,NULL,NULL),(674,674,1,'PS1-12bca','Pan-STARRS1',268.547938158,48.1243953145,NULL,NULL,'2012-06-12 11:36:34',56090.4837318,20.2413,0.052285,'i',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1175411501480727800/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56090/1175411501480727800_56090.483_497914_1097_target.jpeg',NULL,NULL,57460908137,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,897826689,14028542,NULL,NULL,NULL,NULL),(675,674,0,'PS1-12bca','Pan-STARRS1',268.547943309,48.1243776406,NULL,NULL,'2012-08-06 08:00:14',56145.3335059,19.8346,0.0432495,'r',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1175411501480727800/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56145/1175411501480727800_56145.333_505644_804_target.jpeg',NULL,NULL,57460908137,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,897826689,14028542,NULL,NULL,NULL,NULL),(676,674,0,'PS1-12bca','Pan-STARRS1',268.547914221,48.124380672,NULL,NULL,'2012-08-06 08:14:37',56145.3434896,19.7907,0.0397345,'r',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1175411501480727800/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56145/1175411501480727800_56145.343_505660_670_target.jpeg',NULL,NULL,57460908137,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,897826689,14028542,NULL,NULL,NULL,NULL),(677,677,1,'PS1-12bby','Pan-STARRS1',222.292217648,-0.860626227018,NULL,NULL,'2012-08-04 06:31:40',56143.2719939,19.7336,0.0945935,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1144910130005138200/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56143/1144910130005138200_56143.271_504160_594_target.jpeg',NULL,NULL,43501814880,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,679715857,10620560,NULL,NULL,NULL,NULL),(678,677,0,'PS1-12bby','Pan-STARRS1',222.292242247,-0.860628527693,NULL,NULL,'2012-08-04 06:47:12',56143.2827794,19.7461,0.0988411,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1144910130005138200/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56143/1144910130005138200_56143.282_504182_736_target.jpeg',NULL,NULL,43501814880,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,679715857,10620560,NULL,NULL,NULL,NULL),(679,679,1,'PS1-12bbz','Pan-STARRS1',265.555446112,48.8709538522,NULL,NULL,'2012-08-06 06:09:23',56145.2565195,19.6233,0.0278078,'g',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1174213311485215400/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56145/1174213311485215400_56145.256_505532_486_target.jpeg',NULL,NULL,57458255417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,897785240,14027894,NULL,NULL,NULL,NULL),(680,679,0,'PS1-12bbz','Pan-STARRS1',265.555467558,48.870962174,NULL,NULL,'2012-08-06 06:25:05',56145.2674246,19.5556,0.0249662,'g',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1174213311485215400/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56145/1174213311485215400_56145.267_505581_468_target.jpeg',NULL,NULL,57458255417,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,897785240,14027894,NULL,NULL,NULL,NULL),(681,681,1,'PS1-12bcj','Pan-STARRS1',329.483829746,-7.38859559601,NULL,NULL,'2012-06-16 14:08:32',56094.5892627,18.1297,0.0190138,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1215756110072318900/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56094/1215756110072318900_56094.589_500534_295_target.jpeg',NULL,NULL,49924002725,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,780062542,12188477,NULL,NULL,NULL,NULL),(682,681,0,'PS1-12bcj','Pan-STARRS1',329.483826929,-7.38860085761,NULL,NULL,'2012-06-16 14:24:45',56094.6005275,18.1164,0.019899,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1215756110072318900/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56094/1215756110072318900_56094.600_500550_324_target.jpeg',NULL,NULL,49924002725,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,780062542,12188477,NULL,NULL,NULL,NULL),(683,681,0,'PS1-12bcj','Pan-STARRS1',329.483839032,-7.38858794508,NULL,NULL,'2012-08-06 09:45:08',56145.4063466,19.0794,0.0256169,'i',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1215756110072318900/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56145/1215756110072318900_56145.406_505740_462_target.jpeg',NULL,NULL,49924002725,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,780062542,12188477,NULL,NULL,NULL,NULL),(684,681,0,'PS1-12bcj','Pan-STARRS1',329.483827625,-7.38859995126,NULL,NULL,'2012-08-06 10:00:40',56145.4171384,19.062,0.0256441,'i',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1215756110072318900/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56145/1215756110072318900_56145.417_505756_458_target.jpeg',NULL,NULL,49924002725,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,780062542,12188477,NULL,NULL,NULL,NULL),(685,685,1,'PS1-12bcg','Pan-STARRS1',34.6261005007,-0.45615004647,NULL,NULL,'2012-08-04 14:05:19',56143.5870312,18.0266,0.019525,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1021830260002722100/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56143/1021830260002722100_56143.587_504653_167_target.jpeg',NULL,NULL,34914087818,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,545532622,8523947,NULL,NULL,NULL,NULL),(686,685,0,'PS1-12bcg','Pan-STARRS1',34.6260979546,-0.456161057491,NULL,NULL,'2012-08-04 14:20:32',56143.5975937,18.0077,0.0177074,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1021830260002722100/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56143/1021830260002722100_56143.597_504674_158_target.jpeg',NULL,NULL,34914087818,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,545532622,8523947,NULL,NULL,NULL,NULL),(687,687,1,'PS1-12bcf','Pan-STARRS1',33.2973388806,0.364601268549,NULL,NULL,'2012-08-04 14:05:19',56143.5870312,19.6106,0.0653377,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1021311361002152500/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56143/1021311361002152500_56143.587_504653_282_target.jpeg',NULL,NULL,66991673491,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,1046744898,16355389,NULL,NULL,NULL,NULL),(688,687,0,'PS1-12bcf','Pan-STARRS1',33.2973416552,0.364640213896,NULL,NULL,'2012-08-04 14:20:32',56143.5975937,19.7071,0.066534,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1021311361002152500/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56143/1021311361002152500_56143.597_504674_350_target.jpeg',NULL,NULL,66991673491,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,1046744898,16355389,NULL,NULL,NULL,NULL),(689,689,1,'PS1-12bci','Pan-STARRS1',324.582515025,-6.90536756795,NULL,NULL,'2012-08-06 09:43:04',56145.4049128,19.3174,0.0279908,'i',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1213819800065419300/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56145/1213819800065419300_56145.404_505738_571_target.jpeg',NULL,NULL,49682141053,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,776283453,12129428,NULL,NULL,NULL,NULL),(691,691,1,'PS1-12bch','Pan-STARRS1',37.141866732,24.1646723684,NULL,NULL,'2012-08-08 14:28:59',56147.6034668,17.7423,0.0177358,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1022834041240952800/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56147/1022834041240952800_56147.603_507239_204_target.jpeg',NULL,NULL,68086492146,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1063851439,16622678,NULL,NULL,NULL,NULL),(692,691,0,'PS1-12bch','Pan-STARRS1',37.1418617799,24.1646670354,NULL,NULL,'2012-08-08 14:46:23',56147.6155542,17.7732,0.0175042,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1022834041240952800/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56147/1022834041240952800_56147.615_507261_182_target.jpeg',NULL,NULL,68086492146,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1063851439,16622678,NULL,NULL,NULL,NULL),(693,693,1,'PS1-12bce','Pan-STARRS1',16.4931066639,-8.91040709726,NULL,NULL,'2012-08-09 14:22:31',56148.5989747,17.4087,0.0121014,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2019-10-11 14:10:04','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1010558340085437400/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56148/1010558340085437400_56148.598_507789_50_target.jpeg',NULL,NULL,35261956458,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,550968069,8608876,NULL,NULL,NULL,NULL),(694,693,0,'PS1-12bce','Pan-STARRS1',16.4931104555,-8.91040973255,NULL,NULL,'2012-08-09 14:24:01',56148.6000186,17.0589,0.00922582,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1010558340085437400/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56148/1010558340085437400_56148.600_507791_85_target.jpeg',NULL,NULL,35261956458,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,550968069,8608876,NULL,NULL,NULL,NULL),(695,693,0,'PS1-12bce','Pan-STARRS1',16.4931044868,-8.91039947889,NULL,NULL,'2012-08-09 14:39:34',56148.6108198,16.2515,0.00623449,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1010558340085437400/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56148/1010558340085437400_56148.610_507812_24_target.jpeg',NULL,NULL,35261956458,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,550968069,8608876,NULL,NULL,NULL,NULL),(696,693,0,'PS1-12bce','Pan-STARRS1',16.493110651,-8.91040956629,NULL,NULL,'2012-08-09 14:41:04',56148.6118616,16.4162,0.0069189,'z',NULL,NULL,NULL,NULL,'2012-08-15 14:45:21','2012-08-15 14:45:21','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1010558340085437400/','sn',NULL,NULL,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56148/1010558340085437400_56148.611_507814_60_target.jpeg',NULL,NULL,35261956458,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,550968069,8608876,NULL,NULL,NULL,NULL),(697,697,1,'LSQ12eix','LSQ',40.2240833333333,-6.53880555555556,NULL,NULL,'2012-07-11 09:51:59',56119.4111000001,20.0789,0.2139,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_51549.gif',34934513405,NULL,NULL,NULL,'2012-07-09 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(698,697,0,'LSQ12eix','LSQ',40.224,-6.53875,NULL,NULL,'2012-07-11 10:33:27',56119.4399000001,19.7396,0.1339,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_51550.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(699,697,0,'LSQ12eix','LSQ',40.2240833333333,-6.53883333333333,NULL,NULL,'2012-07-15 10:20:21',56123.4308000002,19.802,0.1813,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_51551.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(700,697,0,'LSQ12eix','LSQ',40.224125,-6.53883333333333,NULL,NULL,'2012-07-15 10:30:32',56123.4378800001,19.7273,0.1142,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_51552.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(701,697,0,'LSQ12eix','LSQ',40.224125,-6.53880555555556,NULL,NULL,'2012-07-17 08:53:49',56125.3707099999,19.7827,0.1199,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_51553.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(702,697,0,'LSQ12eix','LSQ',40.224125,-6.53886111111111,NULL,NULL,'2012-07-17 09:45:43',56125.4067500001,20.2572,0.1877,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_51554.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(703,697,0,'LSQ12eix','LSQ',40.2241666666667,-6.53877777777778,NULL,NULL,'2012-07-25 07:55:36',56133.3302799999,19.5773,0.1661,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_51555.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(704,697,0,'LSQ12eix','LSQ',40.224125,-6.53880555555556,NULL,NULL,'2012-07-25 09:16:12',56133.3862600001,20.0352,0.1526,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_51556.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(705,697,0,'LSQ12eix','LSQ',40.2240833333333,-6.53888888888889,NULL,NULL,'2012-07-27 08:57:19',56135.3731399998,19.6709,0.1528,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_51557.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(706,697,0,'LSQ12eix','LSQ',40.224,-6.53877777777778,NULL,NULL,'2012-07-29 07:13:50',56137.3012799998,19.6613,0.1531,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_51558.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(707,697,0,'LSQ12eix','LSQ',40.224125,-6.53875,NULL,NULL,'2012-07-29 08:54:36',56137.3712599999,19.5986,0.1523,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_51559.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(708,697,0,'LSQ12eix','LSQ',40.22425,-6.53883333333333,NULL,NULL,'2012-07-31 08:52:28',56139.3697700002,19.4617,0.2016,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_51560.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(709,697,0,'LSQ12eix','LSQ',40.2241666666667,-6.53883333333333,NULL,NULL,'2012-08-10 07:20:19',56149.3057800001,19.2537,0.1596,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_51561.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(710,697,0,'LSQ12eix','LSQ',40.224125,-6.53880555555556,NULL,NULL,'2012-08-10 08:52:46',56149.36998,19.0264,0.1399,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_51562.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(711,697,0,'LSQ12eix','LSQ',40.2240833333333,-6.53880555555556,NULL,NULL,'2012-08-12 10:12:40',56151.4254700001,19.2789,0.1361,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_51456.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(712,697,0,'LSQ12eix','LSQ',40.2241666666667,-6.53880555555556,NULL,NULL,'2012-08-12 10:17:44',56151.4289899999,19.7433,0.1335,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_51457.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(713,713,1,'LSQ12eit','LSQ',243.688958333333,-0.467166666666667,NULL,NULL,'2012-04-21 06:15:20',56038.2606500001,19.9966,0.1996,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_history.html','sne?',NULL,0.043744,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_snap_51543.gif',45506477318,NULL,NULL,NULL,'2012-04-19 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,711038708,11109979,NULL,NULL,NULL,NULL),(714,713,0,'LSQ12eit','LSQ',243.688875,-0.467194444444444,NULL,NULL,'2012-07-09 00:47:17',56117.03284,18.6267,0.1074,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_history.html','sne?',NULL,0.043744,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_snap_51544.gif',45506477318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,711038708,11109979,NULL,NULL,NULL,NULL),(715,713,0,'LSQ12eit','LSQ',243.688833333333,-0.46725,NULL,NULL,'2012-07-09 02:47:55',56117.1166099999,18.9786,0.1167,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_history.html','sne?',NULL,0.043744,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_snap_51545.gif',45506477318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,711038708,11109979,NULL,NULL,NULL,NULL),(716,713,0,'LSQ12eit','LSQ',243.688833333333,-0.467194444444444,NULL,NULL,'2012-07-23 00:21:31',56131.0149500002,19.0251,0.1024,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_history.html','sne?',NULL,0.043744,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_snap_51546.gif',45506477318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,711038708,11109979,NULL,NULL,NULL,NULL),(717,713,0,'LSQ12eit','LSQ',243.688833333333,-0.467138888888889,NULL,NULL,'2012-07-27 00:05:18',56135.0036900002,18.3516,0.1485,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_history.html','sne?',NULL,0.043744,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_snap_51547.gif',45506477318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,711038708,11109979,NULL,NULL,NULL,NULL),(718,713,0,'LSQ12eit','LSQ',243.68875,-0.46725,NULL,NULL,'2012-08-08 01:26:17',56147.0599199999,18.7995,0.1164,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_history.html','sne?',NULL,0.043744,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_snap_51548.gif',45506477318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,711038708,11109979,NULL,NULL,NULL,NULL),(719,713,0,'LSQ12eit','LSQ',243.688208333333,-0.467388888888889,NULL,NULL,'2012-08-10 01:35:34',56149.0663700001,19.5241,0.2022,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_history.html','sne?',NULL,0.043744,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_snap_51563.gif',45506477326,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,711038708,11109979,NULL,NULL,NULL,NULL),(720,713,0,'LSQ12eit','LSQ',243.688916666667,-0.467305555555556,NULL,NULL,'2012-08-11 23:39:40',56150.9858800001,19.2907,0.1242,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_history.html','sne?',NULL,0.043744,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_snap_51448.gif',45506477318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,711038708,11109979,NULL,NULL,NULL,NULL),(721,713,0,'LSQ12eit','LSQ',243.688916666667,-0.467194444444444,NULL,NULL,'2012-08-11 23:52:50',56150.9950299999,19.2782,0.1314,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_history.html','sne?',NULL,0.043744,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eit/LSQ12eit_snap_51449.gif',45506477318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,711038708,11109979,NULL,NULL,NULL,NULL),(722,722,1,'LSQ12eir','LSQ',34.10075,-3.01941666666667,NULL,NULL,'2012-08-10 07:01:05',56149.2924199998,18.7014,0.0862,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_snap_51530.gif',35133634952,NULL,NULL,NULL,'2012-08-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,548963046,8577547,NULL,NULL,NULL,NULL),(723,722,0,'LSQ12eir','LSQ',34.1007083333333,-3.01941666666667,NULL,NULL,'2012-08-10 08:44:07',56149.3639799999,18.7626,0.0693,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_snap_51531.gif',35133634952,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,548963046,8577547,NULL,NULL,NULL,NULL),(724,722,0,'LSQ12eir','LSQ',34.10075,-3.01944444444444,NULL,NULL,'2012-08-12 10:05:56',56151.4207899999,18.7087,0.0728,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_snap_51444.gif',35133634952,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,548963046,8577547,NULL,NULL,NULL,NULL),(725,722,0,'LSQ12eir','LSQ',34.10075,-3.01936111111111,NULL,NULL,'2012-08-12 10:14:21',56151.4266400002,18.6164,0.0751,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_snap_51445.gif',35133634952,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,548963046,8577547,NULL,NULL,NULL,NULL),(726,726,1,'LSQ12eil','LSQ',1.67291666666667,-6.28088888888889,NULL,NULL,'2012-08-10 08:25:41',56149.3511700002,19.9726,0.2049,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eil/LSQ12eil_history.html','sne - young ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eil/LSQ12eil_snap_51475.gif',34387815364,NULL,NULL,NULL,'2012-08-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537309615,8395462,NULL,NULL,NULL,NULL),(727,726,0,'LSQ12eil','LSQ',1.672875,-6.28083333333333,NULL,NULL,'2012-08-12 07:52:03',56151.3278199998,20.1364,0.1286,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eil/LSQ12eil_history.html','sne - young ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eil/LSQ12eil_snap_51432.gif',34387815364,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537309615,8395462,NULL,NULL,NULL,NULL),(728,726,0,'LSQ12eil','LSQ',1.67279166666667,-6.28086111111111,NULL,NULL,'2012-08-12 09:57:12',56151.4147299998,19.84,0.167,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eil/LSQ12eil_history.html','sne - young ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eil/LSQ12eil_snap_51433.gif',34387815364,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537309615,8395462,NULL,NULL,NULL,NULL),(729,729,1,'LSQ12eig','LSQ',335.277125,-16.6261111111111,NULL,NULL,'2012-07-08 05:45:49',56116.24016,19.0668,0.1654,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eig/LSQ12eig_history.html','sne ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eig/LSQ12eig_snap_51423.gif',50238735843,NULL,NULL,NULL,'2012-07-06 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,784980247,12265316,NULL,NULL,NULL,NULL),(730,729,0,'LSQ12eig','LSQ',335.27675,-16.6262777777778,NULL,NULL,'2012-07-30 03:26:02',56138.1430899999,20.6533,0.2102,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eig/LSQ12eig_history.html','sne ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eig/LSQ12eig_snap_51424.gif',50238735841,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,784980247,12265316,NULL,NULL,NULL,NULL),(731,729,0,'LSQ12eig','LSQ',335.276833333333,-16.6261111111111,NULL,NULL,'2012-08-11 01:55:30',56150.0802099998,21.0119,0.1339,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eig/LSQ12eig_history.html','sne ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eig/LSQ12eig_snap_51425.gif',50238735841,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,784980247,12265316,NULL,NULL,NULL,NULL),(732,729,0,'LSQ12eig','LSQ',335.276291666667,-16.6262777777778,NULL,NULL,'2012-08-12 01:38:03',56151.0680999998,21.236,0.1231,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eig/LSQ12eig_history.html','sne ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eig/LSQ12eig_snap_51409.gif',50238735841,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,784980247,12265316,NULL,NULL,NULL,NULL),(733,729,0,'LSQ12eig','LSQ',335.276625,-16.6263055555556,NULL,NULL,'2012-08-12 05:46:40',56151.2407499999,20.0219,0.0737,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eig/LSQ12eig_history.html','sne ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eig/LSQ12eig_snap_51410.gif',50238735841,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,784980247,12265316,NULL,NULL,NULL,NULL),(734,734,1,'LSQ12eif','LSQ',335.979791666667,-17.6941944444444,NULL,NULL,'2012-08-11 01:55:30',56150.0802099998,19.6883,0.1306,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eif/LSQ12eif_history.html','sne ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eif/LSQ12eif_snap_51420.gif',50239067131,NULL,NULL,NULL,'2012-08-09 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,784985423,12265397,NULL,NULL,NULL,NULL),(735,734,0,'LSQ12eif','LSQ',335.979666666667,-17.6941666666667,NULL,NULL,'2012-08-11 04:23:24',56150.1829200001,20.2793,0.1817,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eif/LSQ12eif_history.html','sne ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eif/LSQ12eif_snap_51421.gif',50239067131,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,784985423,12265397,NULL,NULL,NULL,NULL),(736,734,0,'LSQ12eif','LSQ',335.979833333333,-17.6941666666667,NULL,NULL,'2012-08-12 01:38:03',56151.0680999998,19.606,0.1193,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eif/LSQ12eif_history.html','sne ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eif/LSQ12eif_snap_51407.gif',50239067131,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,784985423,12265397,NULL,NULL,NULL,NULL),(737,734,0,'LSQ12eif','LSQ',335.979958333333,-17.69425,NULL,NULL,'2012-08-12 03:38:17',56151.1515899999,18.6552,0.1161,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eif/LSQ12eif_history.html','sne ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eif/LSQ12eif_snap_51422.gif',50239067131,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,784985423,12265397,NULL,NULL,NULL,NULL),(738,734,0,'LSQ12eif','LSQ',335.979625,-17.69425,NULL,NULL,'2012-08-12 05:46:40',56151.2407499999,18.6832,0.1086,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eif/LSQ12eif_history.html','sne ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eif/LSQ12eif_snap_51408.gif',50239067131,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,784985423,12265397,NULL,NULL,NULL,NULL),(739,739,1,'LSQ12eie','LSQ',336.09575,-17.6378055555556,NULL,NULL,'2012-07-06 05:55:13',56114.2466799999,18.6433,0.2059,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eie/LSQ12eie_history.html','sne ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eie/LSQ12eie_snap_51418.gif',50239093071,NULL,NULL,NULL,'2012-07-03 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,784985829,12265403,NULL,NULL,NULL,NULL),(740,739,0,'LSQ12eie','LSQ',336.095666666667,-17.6379444444444,NULL,NULL,'2012-08-11 04:23:24',56150.1829200001,19.5761,0.0981,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eie/LSQ12eie_history.html','sne ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eie/LSQ12eie_snap_51419.gif',50239093069,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,784985829,12265403,NULL,NULL,NULL,NULL),(741,739,0,'LSQ12eie','LSQ',336.095625,-17.6377777777778,NULL,NULL,'2012-08-12 01:38:03',56151.0680999998,19.9493,0.0947,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eie/LSQ12eie_history.html','sne ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eie/LSQ12eie_snap_51405.gif',50239093071,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,784985829,12265403,NULL,NULL,NULL,NULL),(742,739,0,'LSQ12eie','LSQ',336.095625,-17.6378333333333,NULL,NULL,'2012-08-12 03:38:17',56151.1515899999,19.6264,0.1228,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 15:45:25','2012-08-15 15:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eie/LSQ12eie_history.html','sne ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eie/LSQ12eie_snap_51406.gif',50239093069,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,784985829,12265403,NULL,NULL,NULL,NULL),(743,472,0,'LSQ12eeq','LSQ',313.204458333333,-16.5600277777778,NULL,NULL,'2012-08-15 00:47:53',56154.0332599999,20.1742,0.161,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 17:45:31','2012-08-15 17:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_snap_51582.gif',50992845486,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796763210,12449425,NULL,NULL,NULL,NULL),(744,644,0,'LSQ12eij','LSQ',353.852458333333,-20.5113333333333,NULL,NULL,'2012-08-15 02:48:52',56154.1172699998,19.4069,0.0558,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-15 17:45:31','2012-08-15 17:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eij/LSQ12eij_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eij/LSQ12eij_snap_51578.gif',50275077940,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785548092,12274188,NULL,NULL,NULL,NULL),(745,745,1,'LSQ12ejl','LSQ',301.377,-19.8933333333333,NULL,NULL,'2012-07-26 00:37:55',56134.0263399999,19.9526,0.0943,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejl/LSQ12ejl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejl/LSQ12ejl_snap_51700.gif',50813731843,NULL,NULL,NULL,'2012-07-16 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,793964560,12405696,NULL,NULL,NULL,NULL),(746,745,0,'LSQ12ejl','LSQ',301.377125,-19.8933333333333,NULL,NULL,'2012-08-14 23:55:50',56153.9971099999,20.8713,0.1479,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2012-08-16 00:15:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejl/LSQ12ejl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejl/LSQ12ejl_snap_51679.gif',50813731843,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,793964560,12405696,NULL,NULL,NULL,NULL),(747,745,0,'LSQ12ejl','LSQ',301.377,-19.8934444444444,NULL,NULL,'2012-08-15 03:56:49',56154.1644600001,21.0473,0.1365,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2012-08-16 00:15:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejl/LSQ12ejl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejl/LSQ12ejl_snap_51680.gif',50813731843,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,793964560,12405696,NULL,NULL,NULL,NULL),(748,748,1,'LSQ12eji','LSQ',301.496916666667,-19.33375,NULL,NULL,'2012-08-14 23:55:50',56153.9971099999,17.6034,0.0107,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eji/LSQ12eji_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eji/LSQ12eji_snap_51672.gif',50810834511,NULL,NULL,NULL,'2012-07-26 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793919289,12404988,NULL,NULL,NULL,NULL),(749,748,0,'LSQ12eji','LSQ',301.496958333333,-19.33375,NULL,NULL,'2012-08-15 01:56:09',56154.0806700001,17.6481,0.0141,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2012-08-16 00:15:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eji/LSQ12eji_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eji/LSQ12eji_snap_51674.gif',50810834511,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793919289,12404988,NULL,NULL,NULL,NULL),(750,748,0,'LSQ12eji','LSQ',301.497,-19.33375,NULL,NULL,'2012-08-15 03:56:49',56154.1644600001,17.6048,0.0118,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2012-08-16 00:15:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eji/LSQ12eji_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eji/LSQ12eji_snap_51673.gif',50810834511,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793919289,12404988,NULL,NULL,NULL,NULL),(751,751,0,'LSQ12ejf','LSQ',300.237916666667,-17.8160555555556,NULL,NULL,'2012-07-26 00:34:14',56134.0237799999,20.2593,0.1475,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2019-12-24 20:38:21','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_history.html','sn ',NULL,0.65,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_snap_51694.gif',47978099725,NULL,NULL,NULL,'2012-06-04 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,749657808,11713403,NULL,NULL,NULL,NULL),(752,751,0,'LSQ12ejf','LSQ',300.237958333333,-17.8161111111111,NULL,NULL,'2012-07-26 02:48:03',56134.1167100002,19.8032,0.0967,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2012-08-16 00:15:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_history.html','sn ',NULL,0.65,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_snap_51695.gif',47978099725,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,749657808,11713403,NULL,NULL,NULL,NULL),(753,751,0,'LSQ12ejf','LSQ',300.23775,-17.8160555555556,NULL,NULL,'2012-07-26 06:08:38',56134.2560000001,19.6469,0.0914,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2012-08-16 00:15:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_history.html','sn ',NULL,0.65,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_snap_51696.gif',47978099721,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,749657808,11713403,NULL,NULL,NULL,NULL),(754,751,0,'LSQ12ejf','LSQ',300.23775,-17.816,NULL,NULL,'2012-08-14 23:52:08',56153.9945399999,18.726,0.0466,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2012-08-16 00:15:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_history.html','sn ',NULL,0.65,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_snap_51665.gif',47978099721,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,749657808,11713403,NULL,NULL,NULL,NULL),(755,751,0,'LSQ12ejf','LSQ',300.237875,-17.8160277777778,NULL,NULL,'2012-08-15 01:52:28',56154.0781100001,18.6771,0.0499,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2012-08-16 00:15:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_history.html','sn ',NULL,0.65,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_snap_51667.gif',47978099721,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,749657808,11713403,NULL,NULL,NULL,NULL),(756,751,0,'LSQ12ejf','LSQ',300.23775,-17.8160277777778,NULL,NULL,'2012-08-15 03:53:07',56154.1618900001,19.0694,0.0834,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2012-08-16 00:15:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_history.html','sn ',NULL,0.65,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_snap_51666.gif',47978099721,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,749657808,11713403,NULL,NULL,NULL,NULL),(757,757,1,'LSQ12ejd','LSQ',300.880208333333,-19.8604166666667,NULL,NULL,'2012-07-26 02:48:03',56134.1167100002,20.8986,0.1405,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_history.html','sn?',NULL,0.083168,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_snap_51691.gif',50813697248,NULL,NULL,NULL,'2012-06-04 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793964019,12405687,NULL,NULL,NULL,NULL),(758,757,0,'LSQ12ejd','LSQ',300.880375,-19.8605555555556,NULL,NULL,'2012-07-26 06:08:38',56134.2560000001,20.165,0.0854,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2012-08-16 00:15:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_history.html','sn?',NULL,0.083168,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_snap_51692.gif',50813697251,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793964019,12405687,NULL,NULL,NULL,NULL),(759,757,0,'LSQ12ejd','LSQ',300.880416666667,-19.8605,NULL,NULL,'2012-08-14 23:52:08',56153.9945399999,20.8325,0.1431,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2012-08-16 00:15:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_history.html','sn?',NULL,0.083168,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_snap_51660.gif',50813697251,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793964019,12405687,NULL,NULL,NULL,NULL),(760,757,0,'LSQ12ejd','LSQ',300.880666666667,-19.8604166666667,NULL,NULL,'2012-08-15 01:52:28',56154.0781100001,20.5678,0.123,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2012-08-16 00:15:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_history.html','sn?',NULL,0.083168,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_snap_51662.gif',50813697251,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793964019,12405687,NULL,NULL,NULL,NULL),(761,757,0,'LSQ12ejd','LSQ',300.88075,-19.8604166666667,NULL,NULL,'2012-08-15 03:53:07',56154.1618900001,19.9959,0.1566,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-16 00:15:25','2012-08-16 00:15:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_history.html','sn?',NULL,0.083168,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_snap_51661.gif',50813697251,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793964019,12405687,NULL,NULL,NULL,NULL),(762,762,1,'PSNJ19371572-4218271','TOCP',294.315504166667,-42.3075388888889,NULL,NULL,'2012-08-12 00:00:00',56151,17.2,0.5,'unfiltered',NULL,NULL,NULL,NULL,'2012-08-18 16:15:28','2020-04-28 09:08:48',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'http://www.das.uchile.cl/~gpignata/pessto/PSNJ19371572-4218271.gif',51268024318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,801062879,12516607,NULL,NULL,NULL,NULL),(763,644,0,'LSQ12eij','LSQ',353.8525,-20.5113055555556,NULL,NULL,'2012-08-18 08:44:28',56157.3642199999,19.4013,0.0521,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 17:45:28','2012-08-18 17:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eij/LSQ12eij_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eij/LSQ12eij_snap_51719.gif',50275077940,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785548092,12274188,NULL,NULL,NULL,NULL),(764,748,0,'LSQ12eji','LSQ',301.497,-19.3337777777778,NULL,NULL,'2012-08-18 04:45:41',56157.1984000001,17.8642,0.0136,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 17:45:28','2012-08-18 17:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eji/LSQ12eji_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eji/LSQ12eji_snap_51724.gif',50810834511,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793919289,12404988,NULL,NULL,NULL,NULL),(765,751,0,'LSQ12ejf','LSQ',300.23775,-17.8160555555556,NULL,NULL,'2012-08-18 04:42:00',56157.1958400002,18.3247,0.0287,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 17:45:28','2012-08-18 17:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_history.html','sn ',NULL,0.65,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_snap_51721.gif',47978099721,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,749657808,11713403,NULL,NULL,NULL,NULL),(766,757,0,'LSQ12ejd','LSQ',300.88075,-19.8602222222222,NULL,NULL,'2012-08-18 04:42:00',56157.1958400002,20.419,0.1024,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 17:45:28','2012-08-18 17:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_history.html','sn?',NULL,0.083168,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_snap_51726.gif',50813697251,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793964019,12405687,NULL,NULL,NULL,NULL),(767,767,1,'LSQ12ejs','LSQ',351.870208333333,-5.38625,NULL,NULL,'2012-08-10 10:00:40',56149.41714,19.0835,0.1638,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejs/LSQ12ejs_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejs/LSQ12ejs_snap_51789.gif',49638442806,NULL,NULL,NULL,'2012-08-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775600668,12118760,NULL,NULL,NULL,NULL),(768,767,0,'LSQ12ejs','LSQ',351.8705,-5.38608333333333,NULL,NULL,'2012-08-15 03:22:58',56154.1409499999,19.8722,0.1273,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejs/LSQ12ejs_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejs/LSQ12ejs_snap_51790.gif',49638442788,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775600668,12118760,NULL,NULL,NULL,NULL),(769,767,0,'LSQ12ejs','LSQ',351.870541666667,-5.38611111111111,NULL,NULL,'2012-08-18 08:09:52',56157.3401899999,19.6359,0.1049,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejs/LSQ12ejs_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejs/LSQ12ejs_snap_51759.gif',49638442788,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775600668,12118760,NULL,NULL,NULL,NULL),(770,767,0,'LSQ12ejs','LSQ',351.870166666667,-5.38616666666667,NULL,NULL,'2012-08-18 09:58:35',56157.4156900002,20.5912,0.1503,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejs/LSQ12ejs_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejs/LSQ12ejs_snap_51760.gif',49638442807,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775600668,12118760,NULL,NULL,NULL,NULL),(771,771,1,'LSQ12ejr','LSQ',351.924375,-5.08997222222222,NULL,NULL,'2012-07-05 05:30:46',56113.2297100001,17.445,0.1193,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_snap_51804.gif',49638300038,NULL,NULL,NULL,'2012-06-30 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775598438,12118725,NULL,NULL,NULL,NULL),(772,771,0,'LSQ12ejr','LSQ',351.924833333333,-5.09013888888889,NULL,NULL,'2012-07-17 10:03:40',56125.41922,19.9565,0.1491,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_snap_51781.gif',49638300039,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775598438,12118725,NULL,NULL,NULL,NULL),(773,771,0,'LSQ12ejr','LSQ',351.924791666667,-5.09016666666667,NULL,NULL,'2012-07-27 04:07:33',56135.17191,19.6272,0.199,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_snap_51782.gif',49638300038,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775598438,12118725,NULL,NULL,NULL,NULL),(774,771,0,'LSQ12ejr','LSQ',351.925208333333,-5.09030555555556,NULL,NULL,'2012-07-29 03:54:59',56137.1631900002,17.3265,0.0347,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_snap_51783.gif',49638300039,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775598438,12118725,NULL,NULL,NULL,NULL),(775,771,0,'LSQ12ejr','LSQ',351.924791666667,-5.09016666666667,NULL,NULL,'2012-07-31 09:01:29',56139.37604,19.224,0.1922,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_snap_51784.gif',49638300038,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775598438,12118725,NULL,NULL,NULL,NULL),(776,771,0,'LSQ12ejr','LSQ',351.925041666667,-5.09030555555556,NULL,NULL,'2012-08-08 09:09:57',56147.38191,18.8905,0.1599,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_snap_51785.gif',49638300039,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775598438,12118725,NULL,NULL,NULL,NULL),(777,771,0,'LSQ12ejr','LSQ',351.9245,-5.09011111111111,NULL,NULL,'2012-08-10 09:35:24',56149.39959,19.9172,0.1838,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_snap_51805.gif',49638300038,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775598438,12118725,NULL,NULL,NULL,NULL),(778,771,0,'LSQ12ejr','LSQ',351.925,-5.09022222222222,NULL,NULL,'2012-08-10 10:00:40',56149.41714,19.4178,0.1798,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_snap_51786.gif',49638300039,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775598438,12118725,NULL,NULL,NULL,NULL),(779,771,0,'LSQ12ejr','LSQ',351.92475,-5.09019444444444,NULL,NULL,'2012-08-15 03:22:58',56154.1409499999,19.5406,0.1077,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_snap_51787.gif',49638300038,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775598438,12118725,NULL,NULL,NULL,NULL),(780,771,0,'LSQ12ejr','LSQ',351.925375,-5.09011111111111,NULL,NULL,'2012-08-18 05:47:29',56157.24131,20.4766,0.1612,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_snap_51757.gif',49638300037,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775598438,12118725,NULL,NULL,NULL,NULL),(781,771,0,'LSQ12ejr','LSQ',351.925083333333,-5.09013888888889,NULL,NULL,'2012-08-18 08:09:52',56157.3401899999,19.7056,0.0924,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_snap_51758.gif',49638300037,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775598438,12118725,NULL,NULL,NULL,NULL),(782,771,0,'LSQ12ejr','LSQ',351.924916666667,-5.08986111111111,NULL,NULL,'2012-08-18 09:58:35',56157.4156900002,20.4594,0.15,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_snap_51788.gif',49638300044,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775598438,12118725,NULL,NULL,NULL,NULL),(783,783,1,'LSQ12ejq','LSQ',353.857,-6.95041666666667,NULL,NULL,'2012-07-07 07:21:43',56115.30675,19.985,0.1533,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejq/LSQ12ejq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejq/LSQ12ejq_snap_51761.gif',49647415926,NULL,NULL,NULL,'2012-07-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,775740873,12120951,NULL,NULL,NULL,NULL),(784,783,0,'LSQ12ejq','LSQ',353.857708333333,-6.95,NULL,NULL,'2012-08-10 10:00:40',56149.41714,18.4005,0.0717,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejq/LSQ12ejq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejq/LSQ12ejq_snap_51762.gif',49647415908,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,775740873,12120951,NULL,NULL,NULL,NULL),(785,783,0,'LSQ12ejq','LSQ',353.857666666667,-6.94988888888889,NULL,NULL,'2012-08-15 03:22:58',56154.1409499999,20.8853,0.1772,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejq/LSQ12ejq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejq/LSQ12ejq_snap_51763.gif',49647415908,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,775740873,12120951,NULL,NULL,NULL,NULL),(786,783,0,'LSQ12ejq','LSQ',353.857791666667,-6.94986111111111,NULL,NULL,'2012-08-18 08:09:52',56157.3401899999,20.7721,0.1091,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejq/LSQ12ejq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejq/LSQ12ejq_snap_51755.gif',49647415908,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,775740873,12120951,NULL,NULL,NULL,NULL),(787,783,0,'LSQ12ejq','LSQ',353.8575,-6.94986111111111,NULL,NULL,'2012-08-18 09:58:35',56157.4156900002,21.0608,0.1386,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejq/LSQ12ejq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejq/LSQ12ejq_snap_51756.gif',49647415924,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,775740873,12120951,NULL,NULL,NULL,NULL),(788,788,1,'LSQ12ejo','LSQ',353.49225,-3.31555555555556,NULL,NULL,'2012-07-17 10:03:40',56125.41922,20.5937,0.1863,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_snap_51776.gif',49414528108,NULL,NULL,NULL,'2012-07-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772102001,12064093,NULL,NULL,NULL,NULL),(789,788,0,'LSQ12ejo','LSQ',353.492041666667,-3.31552777777778,NULL,NULL,'2012-07-27 06:07:50',56135.2554500001,20.7211,0.1676,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_snap_51777.gif',49414528108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772102001,12064093,NULL,NULL,NULL,NULL),(790,788,0,'LSQ12ejo','LSQ',353.492333333333,-3.31569444444444,NULL,NULL,'2012-08-08 07:28:52',56147.3117200001,20.2049,0.1455,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_snap_51778.gif',49414528108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772102001,12064093,NULL,NULL,NULL,NULL),(791,788,0,'LSQ12ejo','LSQ',353.492375,-3.31563888888889,NULL,NULL,'2012-08-10 10:00:40',56149.41714,20.0615,0.2071,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_snap_51779.gif',49414528108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772102001,12064093,NULL,NULL,NULL,NULL),(792,788,0,'LSQ12ejo','LSQ',353.492083333333,-3.31561111111111,NULL,NULL,'2012-08-15 03:22:58',56154.1409499999,20.8043,0.1641,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_snap_51780.gif',49414528108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772102001,12064093,NULL,NULL,NULL,NULL),(793,788,0,'LSQ12ejo','LSQ',353.49225,-3.31558333333333,NULL,NULL,'2012-08-18 05:47:29',56157.24131,20.1514,0.1057,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_snap_51751.gif',49414528108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772102001,12064093,NULL,NULL,NULL,NULL),(794,788,0,'LSQ12ejo','LSQ',353.492208333333,-3.31555555555556,NULL,NULL,'2012-08-18 08:09:52',56157.3401899999,20.1501,0.1201,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_snap_51752.gif',49414528108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772102001,12064093,NULL,NULL,NULL,NULL),(795,795,1,'LSQ12ejn','LSQ',303.86825,-22.37,NULL,NULL,'2012-07-11 01:50:51',56119.0769799999,20.755,0.1872,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_51764.gif',50806837566,NULL,NULL,NULL,'2012-06-04 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(796,795,0,'LSQ12ejn','LSQ',303.8685,-22.37,NULL,NULL,'2012-07-11 03:45:38',56119.1566900001,20.9305,0.1361,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_51765.gif',50806837566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(797,795,0,'LSQ12ejn','LSQ',303.868458333333,-22.3699722222222,NULL,NULL,'2012-07-13 03:22:01',56121.14029,21.452,0.1872,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_51766.gif',50806837566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(798,795,0,'LSQ12ejn','LSQ',303.868541666667,-22.3700277777778,NULL,NULL,'2012-07-13 05:43:12',56121.2383400002,20.8909,0.161,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_51767.gif',50806837566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(799,795,0,'LSQ12ejn','LSQ',303.868458333333,-22.37,NULL,NULL,'2012-07-16 08:14:19',56124.3432800001,21.0755,0.1619,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_51768.gif',50806837566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(800,795,0,'LSQ12ejn','LSQ',303.868333333333,-22.3699444444444,NULL,NULL,'2012-07-18 00:58:27',56126.0405999999,21.0432,0.1626,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_51769.gif',50806837566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(801,795,0,'LSQ12ejn','LSQ',303.868166666667,-22.3699722222222,NULL,NULL,'2012-07-18 05:32:04',56126.23061,20.9159,0.1484,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_51770.gif',50806837566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(802,795,0,'LSQ12ejn','LSQ',303.868916666667,-22.3700555555556,NULL,NULL,'2012-07-25 00:38:00',56133.0263899998,20.8426,0.157,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_51803.gif',50806837566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(803,795,0,'LSQ12ejn','LSQ',303.868541666667,-22.3699166666667,NULL,NULL,'2012-07-25 02:40:03',56133.1111499998,20.9183,0.1382,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_51771.gif',50806837566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(804,795,0,'LSQ12ejn','LSQ',303.8685,-22.3699166666667,NULL,NULL,'2012-07-25 05:34:03',56133.2319899998,21.079,0.2014,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_51772.gif',50806837566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(805,795,0,'LSQ12ejn','LSQ',303.868416666667,-22.37,NULL,NULL,'2012-07-26 01:03:31',56134.0441200002,20.4578,0.2013,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_51773.gif',50806837566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(806,795,0,'LSQ12ejn','LSQ',303.868416666667,-22.3699166666667,NULL,NULL,'2012-07-26 06:58:01',56134.2903,20.9974,0.1939,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_51774.gif',50806837566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(807,795,0,'LSQ12ejn','LSQ',303.8685,-22.37,NULL,NULL,'2012-08-12 01:26:37',56151.0601599999,21.0436,0.2021,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_51775.gif',50806837566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(808,795,0,'LSQ12ejn','LSQ',303.86825,-22.3699722222222,NULL,NULL,'2012-08-18 04:38:17',56157.1932600001,21.0204,0.139,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_51749.gif',50806837566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(809,795,0,'LSQ12ejn','LSQ',303.868,-22.3696944444444,NULL,NULL,'2012-08-18 07:21:48',56157.30681,20.0972,0.121,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-18 23:45:26','2012-08-18 23:45:26','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_51750.gif',50806837567,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(810,771,0,'LSQ12ejr','LSQ',351.92425,-5.09008333333333,NULL,NULL,'2012-07-29 05:57:16',56137.24811,19.5213,0.2146,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_snap_51829.gif',49638300038,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775598438,12118725,NULL,NULL,NULL,NULL),(811,811,1,'LSQ12ejy','LSQ',355.411291666667,-22.7780555555556,NULL,NULL,'2012-08-12 04:45:39',56151.1983699999,18.9493,0.1231,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_51825.gif',50274702770,NULL,NULL,NULL,'2012-08-12 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(812,811,0,'LSQ12ejy','LSQ',355.41125,-22.7780833333333,NULL,NULL,'2012-08-12 07:05:27',56151.2954600002,18.5744,0.0964,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_51826.gif',50274702770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(813,811,0,'LSQ12ejy','LSQ',355.411333333333,-22.7780555555556,NULL,NULL,'2012-08-12 09:06:52',56151.37977,18.6395,0.1118,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_51827.gif',50274702741,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(814,811,0,'LSQ12ejy','LSQ',355.411333333333,-22.7780555555556,NULL,NULL,'2012-08-15 02:48:52',56154.1172699998,18.4037,0.0887,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_51828.gif',50274702741,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(815,811,0,'LSQ12ejy','LSQ',355.411416666667,-22.7781388888889,NULL,NULL,'2012-08-18 06:29:34',56157.2705399999,18.4105,0.0781,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_51801.gif',50274702741,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(816,811,0,'LSQ12ejy','LSQ',355.411291666667,-22.7781388888889,NULL,NULL,'2012-08-18 08:44:28',56157.3642199999,18.3876,0.0835,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_51802.gif',50274702770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(817,817,1,'LSQ12ejx','LSQ',355.038666666667,-21.8748055555556,NULL,NULL,'2012-08-12 04:45:39',56151.1983699999,21.2119,0.1401,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_history.html','hostless sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_snap_51821.gif',50276293318,NULL,NULL,NULL,'2012-08-12 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,785567083,12274485,NULL,NULL,NULL,NULL),(818,817,0,'LSQ12ejx','LSQ',355.038625,-21.8748055555556,NULL,NULL,'2012-08-12 07:05:27',56151.2954600002,21.6411,0.1481,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_history.html','hostless sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_snap_51822.gif',50276293318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,785567083,12274485,NULL,NULL,NULL,NULL),(819,817,0,'LSQ12ejx','LSQ',355.038583333333,-21.8748055555556,NULL,NULL,'2012-08-12 09:06:52',56151.37977,21.1353,0.1453,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_history.html','hostless sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_snap_51823.gif',50276293318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,785567083,12274485,NULL,NULL,NULL,NULL),(820,817,0,'LSQ12ejx','LSQ',355.038583333333,-21.8748055555556,NULL,NULL,'2012-08-15 02:48:52',56154.1172699998,21.0926,0.1182,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_history.html','hostless sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_snap_51824.gif',50276293318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,785567083,12274485,NULL,NULL,NULL,NULL),(821,817,0,'LSQ12ejx','LSQ',355.038666666667,-21.8747777777778,NULL,NULL,'2012-08-18 06:29:34',56157.2705399999,20.8499,0.1237,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_history.html','hostless sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_snap_51799.gif',50276293318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,785567083,12274485,NULL,NULL,NULL,NULL),(822,817,0,'LSQ12ejx','LSQ',355.038625,-21.8747777777778,NULL,NULL,'2012-08-18 08:44:28',56157.3642199999,20.6644,0.1035,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_history.html','hostless sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_snap_51800.gif',50276293318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,785567083,12274485,NULL,NULL,NULL,NULL),(823,823,1,'LSQ12ejw','LSQ',357.600875,-24.6793055555556,NULL,NULL,'2012-08-12 09:06:52',56151.37977,20.0248,0.166,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_snap_51820.gif',50012664937,NULL,NULL,NULL,'2012-08-12 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,781447889,12210123,NULL,NULL,NULL,NULL),(824,823,0,'LSQ12ejw','LSQ',357.601,-24.6793888888889,NULL,NULL,'2012-08-18 06:29:34',56157.2705399999,20.0078,0.1433,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_snap_51797.gif',50012664937,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,781447889,12210123,NULL,NULL,NULL,NULL),(825,823,0,'LSQ12ejw','LSQ',357.601083333333,-24.6792222222222,NULL,NULL,'2012-08-18 08:44:28',56157.3642199999,16.948,0.0669,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_snap_51798.gif',50012665062,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,781447891,12210123,NULL,NULL,NULL,NULL),(826,826,1,'LSQ12eju','LSQ',350.748916666667,-7.43313888888889,NULL,NULL,'2012-07-17 09:23:43',56125.3914800002,20.2836,0.2152,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_51808.gif',49649863586,NULL,NULL,NULL,'2012-07-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(827,826,0,'LSQ12eju','LSQ',350.748958333333,-7.43333333333333,NULL,NULL,'2012-07-17 10:03:40',56125.41922,20.2937,0.2029,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_51809.gif',49649863586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(828,826,0,'LSQ12eju','LSQ',350.748916666667,-7.43311111111111,NULL,NULL,'2012-07-27 06:07:50',56135.2554500001,19.9539,0.1269,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_51810.gif',49649863617,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779119,12121548,NULL,NULL,NULL,NULL),(829,826,0,'LSQ12eju','LSQ',350.748916666667,-7.43325,NULL,NULL,'2012-07-29 03:54:59',56137.1631900002,19.4399,0.1885,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_51811.gif',49649863586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(830,826,0,'LSQ12eju','LSQ',350.748916666667,-7.43316666666667,NULL,NULL,'2012-07-31 07:31:53',56139.3138100002,19.0691,0.1701,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_51812.gif',49649863586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(831,826,0,'LSQ12eju','LSQ',350.74875,-7.43316666666667,NULL,NULL,'2012-07-31 09:01:29',56139.37604,19.4333,0.1858,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_51813.gif',49649863587,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(832,826,0,'LSQ12eju','LSQ',350.74875,-7.43330555555556,NULL,NULL,'2012-08-08 09:09:57',56147.38191,19.4987,0.173,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_51814.gif',49649863587,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(833,826,0,'LSQ12eju','LSQ',350.748833333333,-7.43322222222222,NULL,NULL,'2012-08-10 09:35:24',56149.39959,19.5165,0.1628,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_51815.gif',49649863586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(834,826,0,'LSQ12eju','LSQ',350.748875,-7.43322222222222,NULL,NULL,'2012-08-10 10:00:40',56149.41714,19.6497,0.1593,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_51816.gif',49649863586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(835,826,0,'LSQ12eju','LSQ',350.748833333333,-7.43322222222222,NULL,NULL,'2012-08-15 03:22:58',56154.1409499999,20.1592,0.1226,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_51817.gif',49649863586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(836,826,0,'LSQ12eju','LSQ',350.7495,-7.43325,NULL,NULL,'2012-08-18 05:47:29',56157.24131,20.389,0.1132,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_51818.gif',49649863617,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779119,12121548,NULL,NULL,NULL,NULL),(837,826,0,'LSQ12eju','LSQ',350.748833333333,-7.43325,NULL,NULL,'2012-08-18 08:09:52',56157.3401899999,19.7692,0.0672,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_51793.gif',49649863586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(838,826,0,'LSQ12eju','LSQ',350.748916666667,-7.43322222222222,NULL,NULL,'2012-08-18 09:58:35',56157.4156900002,19.9428,0.0841,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-19 00:45:27','2012-08-19 00:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_51794.gif',49649863586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(839,472,0,'LSQ12eeq','LSQ',313.204208333333,-16.55975,NULL,NULL,'2012-08-19 00:30:53',56158.0214499999,19.4981,0.1069,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 07:45:27','2012-08-20 07:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eeq/LSQ12eeq_snap_51869.gif',50992845486,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796763210,12449425,NULL,NULL,NULL,NULL),(840,544,0,'LSQ12egf','LSQ',342.308666666667,1.74263888888889,NULL,NULL,'2012-08-19 02:26:37',56158.10182,19.3115,0.0328,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 07:45:27','2012-08-20 07:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_51891.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(841,544,0,'LSQ12egf','LSQ',342.308833333333,1.74275,NULL,NULL,'2012-08-19 05:24:05',56158.2250600001,20.3775,0.1515,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 07:45:27','2012-08-20 07:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_51892.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(842,544,0,'LSQ12egf','LSQ',342.308625,1.74255555555556,NULL,NULL,'2012-08-19 07:41:26',56158.3204399999,19.2024,0.0341,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 07:45:27','2012-08-20 07:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_51893.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(843,571,0,'LSQ12ehj','LSQ',347.3155,7.04825,NULL,NULL,'2012-08-19 03:03:29',56158.1274299999,18.5573,0.0223,'gr-LSQ',NULL,NULL,'AGN',NULL,'2012-08-20 07:45:27','2012-08-20 07:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_snap_51900.gif',51719133726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,808111464,12626741,NULL,NULL,NULL,NULL),(844,571,0,'LSQ12ehj','LSQ',347.315583333333,7.04825,NULL,NULL,'2012-08-19 05:35:07',56158.2327299998,18.5533,0.0194,'gr-LSQ',NULL,NULL,'AGN',NULL,'2012-08-20 07:45:27','2012-08-20 07:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_snap_51901.gif',51719133726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,808111464,12626741,NULL,NULL,NULL,NULL),(845,571,0,'LSQ12ehj','LSQ',347.315583333333,7.04830555555556,NULL,NULL,'2012-08-19 07:52:31',56158.3281399999,18.4896,0.0229,'gr-LSQ',NULL,NULL,'AGN',NULL,'2012-08-20 07:45:27','2012-08-20 07:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_snap_51902.gif',51719133726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,808111464,12626741,NULL,NULL,NULL,NULL),(846,627,0,'LSQ12eht','LSQ',354.359291666667,10.3063333333333,NULL,NULL,'2012-08-19 03:48:34',56158.1587299998,20.4991,0.0901,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 07:45:27','2012-08-20 07:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eht/LSQ12eht_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eht/LSQ12eht_snap_51837.gif',51778995065,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,809046797,12641356,NULL,NULL,NULL,NULL),(847,627,0,'LSQ12eht','LSQ',354.359291666667,10.3063611111111,NULL,NULL,'2012-08-19 06:19:28',56158.26352,20.1135,0.0659,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 07:45:27','2012-08-20 07:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eht/LSQ12eht_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eht/LSQ12eht_snap_51838.gif',51778995065,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,809046797,12641356,NULL,NULL,NULL,NULL),(848,627,0,'LSQ12eht','LSQ',354.359291666667,10.3063333333333,NULL,NULL,'2012-08-19 08:29:37',56158.3539100001,20.0312,0.0673,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 07:45:27','2012-08-20 07:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eht/LSQ12eht_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eht/LSQ12eht_snap_51839.gif',51778995065,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,809046797,12641356,NULL,NULL,NULL,NULL),(849,849,1,'LSQ12eka','LSQ',353.038458333333,5.10011111111111,NULL,NULL,'2012-08-19 06:34:13',56158.2737699999,20.8584,0.1346,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 18:45:25','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eka/LSQ12eka_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eka/LSQ12eka_snap_51967.gif',51762700589,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,808792196,12637378,NULL,NULL,NULL,NULL),(850,849,0,'LSQ12eka','LSQ',353.038458333333,5.10013888888889,NULL,NULL,'2012-08-19 08:44:24',56158.36417,21.0106,0.1528,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 18:45:25','2012-08-20 18:45:25','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eka/LSQ12eka_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eka/LSQ12eka_snap_51968.gif',51762700589,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,808792196,12637378,NULL,NULL,NULL,NULL),(851,851,1,'LSQ12ekx','LSQ',354.105208333333,8.07225,NULL,NULL,'2012-08-19 06:15:46',56158.2609600001,20.7965,0.1638,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekx/LSQ12ekx_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekx/LSQ12ekx_snap_52048.gif',51792538858,NULL,NULL,NULL,'2012-08-19 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,809258419,12644662,NULL,NULL,NULL,NULL),(852,851,0,'LSQ12ekx','LSQ',354.105166666667,8.07225,NULL,NULL,'2012-08-19 08:25:55',56158.3513400001,21.0745,0.1375,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2012-08-20 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekx/LSQ12ekx_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekx/LSQ12ekx_snap_52049.gif',51792538858,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,809258419,12644662,NULL,NULL,NULL,NULL),(853,853,1,'LSQ12ekw','LSQ',353.275833333333,9.55786111111111,NULL,NULL,'2012-08-19 06:19:28',56158.26352,20.2351,0.095,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekw/LSQ12ekw_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekw/LSQ12ekw_snap_52044.gif',51799641073,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,809369391,12646396,NULL,NULL,NULL,NULL),(854,853,0,'LSQ12ekw','LSQ',353.27575,9.55788888888889,NULL,NULL,'2012-08-19 08:29:37',56158.3539100001,20.1983,0.0999,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2012-08-20 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekw/LSQ12ekw_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekw/LSQ12ekw_snap_52045.gif',51799641073,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,809369391,12646396,NULL,NULL,NULL,NULL),(855,855,1,'LSQ12eku','LSQ',352.120916666667,8.88397222222222,NULL,NULL,'2012-08-19 03:44:53',56158.1561699999,19.3903,0.0736,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eku/LSQ12eku_history.html','agn or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eku/LSQ12eku_snap_52040.gif',51797474876,NULL,NULL,NULL,'2012-08-19 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,809335544,12645867,NULL,NULL,NULL,NULL),(856,855,0,'LSQ12eku','LSQ',352.121166666667,8.88391666666667,NULL,NULL,'2012-08-19 06:15:46',56158.2609600001,19.6266,0.0769,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2012-08-20 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eku/LSQ12eku_history.html','agn or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eku/LSQ12eku_snap_52041.gif',51797474876,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,809335544,12645867,NULL,NULL,NULL,NULL),(857,855,0,'LSQ12eku','LSQ',352.121083333333,8.88402777777778,NULL,NULL,'2012-08-19 08:25:55',56158.3513400001,19.4491,0.0768,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2012-08-20 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eku/LSQ12eku_history.html','agn or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eku/LSQ12eku_snap_52056.gif',51797474876,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,809335544,12645867,NULL,NULL,NULL,NULL),(858,858,1,'LSQ12eks','LSQ',345.26725,-6.69516666666667,NULL,NULL,'2012-08-19 02:22:55',56158.09925,18.5634,0.024,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eks/LSQ12eks_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eks/LSQ12eks_snap_52006.gif',49487173961,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773237093,12081829,NULL,NULL,NULL,NULL),(859,858,0,'LSQ12eks','LSQ',345.26725,-6.69519444444444,NULL,NULL,'2012-08-19 06:12:04',56158.2583900001,18.746,0.0249,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2012-08-20 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eks/LSQ12eks_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eks/LSQ12eks_snap_52036.gif',49487173961,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773237093,12081829,NULL,NULL,NULL,NULL),(860,858,0,'LSQ12eks','LSQ',345.267208333333,-6.69519444444444,NULL,NULL,'2012-08-19 08:22:11',56158.3487399998,18.5253,0.0273,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2012-08-20 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eks/LSQ12eks_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eks/LSQ12eks_snap_52007.gif',49487173965,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773237093,12081829,NULL,NULL,NULL,NULL),(861,861,0,'LSQ12ekr','LSQ',344.380416666667,-6.24475,NULL,NULL,'2012-07-17 10:07:02',56125.4215600002,20.1092,0.1068,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-12-24 20:38:21','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_52026.gif',49488043284,NULL,NULL,NULL,'2012-07-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(862,861,0,'LSQ12ekr','LSQ',344.3805,-6.24466666666667,NULL,NULL,'2012-07-25 10:07:34',56133.4219300002,19.8188,0.0893,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-08-21 00:25:10','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_52050.gif',49488043284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(863,861,0,'LSQ12ekr','LSQ',344.380208333333,-6.24475,NULL,NULL,'2012-07-25 10:21:08',56133.4313500002,19.8948,0.1071,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-08-21 00:25:10','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_52027.gif',49488043284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(864,861,0,'LSQ12ekr','LSQ',344.379708333333,-6.24538888888889,NULL,NULL,'2012-07-27 03:35:48',56135.1498699998,19.5823,0.1865,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-08-21 00:25:10','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_52028.gif',49488043314,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(865,861,0,'LSQ12ekr','LSQ',344.380291666667,-6.24511111111111,NULL,NULL,'2012-07-27 05:40:26',56135.23642,20.1052,0.1144,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-08-21 00:25:10','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_52029.gif',49488043287,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(866,861,0,'LSQ12ekr','LSQ',344.379708333333,-6.24488888888889,NULL,NULL,'2012-07-29 05:47:04',56137.2410200001,19.581,0.1083,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-08-21 00:25:10','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_52030.gif',49488043315,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(867,861,0,'LSQ12ekr','LSQ',344.38025,-6.24483333333333,NULL,NULL,'2012-07-31 09:49:28',56139.4093599999,19.1496,0.1526,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-08-21 00:25:10','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_52031.gif',49488043284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(868,861,0,'LSQ12ekr','LSQ',344.379666666667,-6.24527777777778,NULL,NULL,'2012-08-06 03:30:33',56145.14622,18.9005,0.1165,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-08-21 00:25:10','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_52032.gif',49488043314,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(869,861,0,'LSQ12ekr','LSQ',344.379916666667,-6.24486111111111,NULL,NULL,'2012-08-10 06:00:19',56149.2502299999,19.7229,0.0996,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-08-21 00:25:10','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_52033.gif',49488043312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(870,861,0,'LSQ12ekr','LSQ',344.380041666667,-6.24477777777778,NULL,NULL,'2012-08-10 07:59:58',56149.3333200002,19.1488,0.125,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-08-21 00:25:10','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_52034.gif',49488043312,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(871,861,0,'LSQ12ekr','LSQ',344.379708333333,-6.24497222222222,NULL,NULL,'2012-08-19 02:19:14',56158.09669,19.6759,0.0761,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-08-21 00:25:10','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_52002.gif',49488043315,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(872,861,0,'LSQ12ekr','LSQ',344.379833333333,-6.24486111111111,NULL,NULL,'2012-08-19 06:08:23',56158.2558300002,19.9785,0.0827,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-08-21 00:25:10','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_52003.gif',49488043315,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(873,861,0,'LSQ12ekr','LSQ',344.379583333333,-6.24494444444444,NULL,NULL,'2012-08-19 08:18:29',56158.3461699998,19.532,0.0414,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-08-21 00:25:10','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_52035.gif',49488043315,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(874,874,1,'LSQ12eko','LSQ',348.718833333333,-3.04391666666667,NULL,NULL,'2012-08-19 03:59:38',56158.1664200001,20.7352,0.1188,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eko/LSQ12eko_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eko/LSQ12eko_snap_51996.gif',49633301517,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775520336,12117505,NULL,NULL,NULL,NULL),(875,874,0,'LSQ12eko','LSQ',348.71925,-3.04405555555556,NULL,NULL,'2012-08-19 08:48:04',56158.3667199998,20.252,0.1334,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2012-08-20 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eko/LSQ12eko_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eko/LSQ12eko_snap_51997.gif',49633301506,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775520336,12117505,NULL,NULL,NULL,NULL),(876,876,1,'LSQ12ekl','LSQ',347.856041666667,-1.86508333333333,NULL,NULL,'2012-08-19 02:33:59',56158.1069399999,19.7684,0.0527,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekl/LSQ12ekl_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekl/LSQ12ekl_snap_51990.gif',49495526397,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773367599,12083868,NULL,NULL,NULL,NULL),(877,876,0,'LSQ12ekl','LSQ',347.856041666667,-1.86505555555556,NULL,NULL,'2012-08-19 06:23:10',56158.26609,19.7437,0.0473,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2012-08-20 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekl/LSQ12ekl_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekl/LSQ12ekl_snap_52022.gif',49495526397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773367599,12083868,NULL,NULL,NULL,NULL),(878,876,0,'LSQ12ekl','LSQ',347.856125,-1.86505555555556,NULL,NULL,'2012-08-19 08:33:19',56158.35647,19.6952,0.0508,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2012-08-20 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekl/LSQ12ekl_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekl/LSQ12ekl_snap_51991.gif',49495526397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773367599,12083868,NULL,NULL,NULL,NULL),(879,879,1,'LSQ12ekf','LSQ',347.24925,7.45072222222222,NULL,NULL,'2012-08-19 03:03:29',56158.1274299999,20.5241,0.1303,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekf/LSQ12ekf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekf/LSQ12ekf_snap_51977.gif',51721564658,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,808149447,12627335,NULL,NULL,NULL,NULL),(880,879,0,'LSQ12ekf','LSQ',347.24925,7.45063888888889,NULL,NULL,'2012-08-19 05:35:07',56158.2327299998,20.0944,0.1324,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2012-08-20 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekf/LSQ12ekf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekf/LSQ12ekf_snap_51978.gif',51721564658,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,808149447,12627335,NULL,NULL,NULL,NULL),(881,879,0,'LSQ12ekf','LSQ',347.249291666667,7.45066666666667,NULL,NULL,'2012-08-19 07:52:31',56158.3281399999,20.5562,0.1366,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 19:45:27','2012-08-20 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekf/LSQ12ekf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekf/LSQ12ekf_snap_52018.gif',51721564658,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,808149447,12627335,NULL,NULL,NULL,NULL),(882,370,0,'LSQ12dtg','LSQ',358.9065,-6.24958333333333,NULL,NULL,'2012-08-20 09:43:17',56159.4050599998,20.8195,0.1763,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_history.html','variable?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dtg/LSQ12dtg_snap_52187.gif',49433754184,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,772402409,12068787,NULL,NULL,NULL,NULL),(883,457,0,'LSQ12edo','LSQ',51.5785833333333,-3.29775,NULL,NULL,'2012-08-20 09:55:36',56159.4136199998,19.3623,0.1162,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_snap_52155.gif',36842019075,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,575656548,8994633,NULL,NULL,NULL,NULL),(884,457,0,'LSQ12edo','LSQ',51.5785416666667,-3.29769444444444,NULL,NULL,'2012-08-20 10:05:49',56159.4207100002,19.1753,0.104,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_snap_52156.gif',36842019075,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,575656548,8994633,NULL,NULL,NULL,NULL),(885,462,0,'LSQ12edk','LSQ',47.239,-2.95444444444444,NULL,NULL,'2012-08-20 09:50:31',56159.4100899999,19.066,0.1743,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_history.html','sne',NULL,0.0082,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_snap_52172.gif',36790348504,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,574849195,8982018,NULL,NULL,NULL,NULL),(886,611,0,'LSQ12eid','LSQ',4.408375,-5.38275,NULL,NULL,'2012-08-20 07:30:44',56159.3130100002,18.429,0.0337,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_snap_52100.gif',34413529726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537711401,8401740,NULL,NULL,NULL,NULL),(887,611,0,'LSQ12eid','LSQ',4.40841666666667,-5.38277777777778,NULL,NULL,'2012-08-20 09:41:36',56159.4038900002,18.2917,0.0317,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_snap_52101.gif',34413529726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537711401,8401740,NULL,NULL,NULL,NULL),(888,617,0,'LSQ12eib','LSQ',8.04120833333333,-7.38152777777778,NULL,NULL,'2012-08-20 07:35:47',56159.3165199999,19.7271,0.0761,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_snap_52095.gif',34627856132,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,541060252,8454066,NULL,NULL,NULL,NULL),(889,617,0,'LSQ12eib','LSQ',8.041,-7.3815,NULL,NULL,'2012-08-20 09:36:30',56159.4003499998,19.7329,0.0943,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_snap_52096.gif',34627856184,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,541060252,8454066,NULL,NULL,NULL,NULL),(890,646,0,'LSQ12eiq','LSQ',32.5293333333333,-5.57611111111111,NULL,NULL,'2012-08-20 07:54:21',56159.3294199998,18.6289,0.0326,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_snap_52139.gif',35142165909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549096342,8579630,NULL,NULL,NULL,NULL),(891,646,0,'LSQ12eiq','LSQ',32.5295,-5.57608333333333,NULL,NULL,'2012-08-20 09:17:55',56159.3874499998,18.6573,0.033,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_snap_52140.gif',35142165909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549096342,8579630,NULL,NULL,NULL,NULL),(892,697,0,'LSQ12eix','LSQ',40.2242083333333,-6.53883333333333,NULL,NULL,'2012-08-20 08:11:22',56159.3412299999,19.6158,0.1356,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_52137.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(893,697,0,'LSQ12eix','LSQ',40.2242083333333,-6.53886111111111,NULL,NULL,'2012-08-20 09:14:32',56159.3851000001,19.9392,0.1127,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_52138.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(894,722,0,'LSQ12eir','LSQ',34.1007083333333,-3.01941666666667,NULL,NULL,'2012-08-20 07:56:03',56159.3306,18.8121,0.0662,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_snap_52149.gif',35133634952,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,548963046,8577547,NULL,NULL,NULL,NULL),(895,722,0,'LSQ12eir','LSQ',34.10075,-3.01938888888889,NULL,NULL,'2012-08-20 09:09:29',56159.3815899999,18.8554,0.0673,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_snap_52150.gif',35133634952,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,548963046,8577547,NULL,NULL,NULL,NULL),(896,726,0,'LSQ12eil','LSQ',1.67291666666667,-6.28097222222222,NULL,NULL,'2012-08-20 07:29:02',56159.31183,19.9375,0.1309,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eil/LSQ12eil_history.html','sne - young ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eil/LSQ12eil_snap_52147.gif',34387815364,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537309615,8395462,NULL,NULL,NULL,NULL),(897,751,0,'LSQ12ejf','LSQ',300.23775,-17.8160277777778,NULL,NULL,'2012-08-20 00:22:22',56159.0155400001,17.8865,0.019,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_history.html','sn ',NULL,0.65,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_snap_52182.gif',47978099721,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,749657808,11713403,NULL,NULL,NULL,NULL),(898,751,0,'LSQ12ejf','LSQ',300.23775,-17.816,NULL,NULL,'2012-08-20 02:24:31',56159.10036,17.9017,0.0167,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_history.html','sn ',NULL,0.65,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_snap_52183.gif',47978099721,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,749657808,11713403,NULL,NULL,NULL,NULL),(899,751,0,'LSQ12ejf','LSQ',300.237791666667,-17.8160277777778,NULL,NULL,'2012-08-20 05:35:06',56159.2327100001,17.8016,0.0171,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_history.html','sn ',NULL,0.65,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_snap_52184.gif',47978099721,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,749657808,11713403,NULL,NULL,NULL,NULL),(900,757,0,'LSQ12ejd','LSQ',300.880666666667,-19.8602777777778,NULL,NULL,'2012-08-20 00:22:22',56159.0155400001,20.1374,0.0865,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_history.html','sn?',NULL,0.083168,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_snap_52185.gif',50813697251,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793964019,12405687,NULL,NULL,NULL,NULL),(901,757,0,'LSQ12ejd','LSQ',300.880791666667,-19.8603888888889,NULL,NULL,'2012-08-20 02:24:31',56159.10036,20.7842,0.1174,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_history.html','sn?',NULL,0.083168,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_snap_52186.gif',50813697251,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793964019,12405687,NULL,NULL,NULL,NULL),(902,767,0,'LSQ12ejs','LSQ',351.870375,-5.38608333333333,NULL,NULL,'2012-08-20 08:24:48',56159.3505600002,20.0083,0.0733,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejs/LSQ12ejs_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejs/LSQ12ejs_snap_52200.gif',49638442804,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775600668,12118760,NULL,NULL,NULL,NULL),(903,771,0,'LSQ12ejr','LSQ',351.925208333333,-5.09027777777778,NULL,NULL,'2012-08-20 04:16:58',56159.17845,18.3955,0.0359,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_snap_52195.gif',49638300039,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775598438,12118725,NULL,NULL,NULL,NULL),(904,771,0,'LSQ12ejr','LSQ',351.925,-5.09025,NULL,NULL,'2012-08-20 06:31:33',56159.2719100001,20.3176,0.1384,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_snap_52196.gif',49638300039,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775598438,12118725,NULL,NULL,NULL,NULL),(905,783,0,'LSQ12ejq','LSQ',353.857416666667,-6.94975,NULL,NULL,'2012-08-20 04:16:58',56159.17845,18.8625,0.0286,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejq/LSQ12ejq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejq/LSQ12ejq_snap_52197.gif',49647415924,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,775740873,12120951,NULL,NULL,NULL,NULL),(906,783,0,'LSQ12ejq','LSQ',353.857708333333,-6.94997222222222,NULL,NULL,'2012-08-20 06:31:33',56159.2719100001,20.9451,0.1017,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejq/LSQ12ejq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejq/LSQ12ejq_snap_52198.gif',49647415908,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,775740873,12120951,NULL,NULL,NULL,NULL),(907,783,0,'LSQ12ejq','LSQ',353.857625,-6.94994444444444,NULL,NULL,'2012-08-20 08:24:48',56159.3505600002,20.8675,0.1064,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejq/LSQ12ejq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejq/LSQ12ejq_snap_52199.gif',49647415908,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,775740873,12120951,NULL,NULL,NULL,NULL),(908,788,0,'LSQ12ejo','LSQ',353.492083333333,-3.31558333333333,NULL,NULL,'2012-08-20 04:16:58',56159.17845,20.5215,0.0937,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_snap_52191.gif',49414528108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772102001,12064093,NULL,NULL,NULL,NULL),(909,788,0,'LSQ12ejo','LSQ',353.492125,-3.31558333333333,NULL,NULL,'2012-08-20 06:31:33',56159.2719100001,20.899,0.1917,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_snap_52192.gif',49414528108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772102001,12064093,NULL,NULL,NULL,NULL),(910,788,0,'LSQ12ejo','LSQ',353.492125,-3.31544444444444,NULL,NULL,'2012-08-20 08:24:48',56159.3505600002,21.0044,0.1247,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_snap_52193.gif',49414528108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772102001,12064093,NULL,NULL,NULL,NULL),(911,795,0,'LSQ12ejn','LSQ',303.868583333333,-22.3702222222222,NULL,NULL,'2012-08-20 05:42:29',56159.2378400001,19.762,0.0973,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_52194.gif',50806837566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(912,826,0,'LSQ12eju','LSQ',350.748833333333,-7.43313888888889,NULL,NULL,'2012-08-20 04:16:58',56159.17845,19.7292,0.0688,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_52204.gif',49649863586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(913,826,0,'LSQ12eju','LSQ',350.748833333333,-7.43316666666667,NULL,NULL,'2012-08-20 06:31:33',56159.2719100001,19.727,0.0627,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_52205.gif',49649863586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(914,826,0,'LSQ12eju','LSQ',350.748916666667,-7.43313888888889,NULL,NULL,'2012-08-20 08:24:48',56159.3505600002,19.7205,0.0661,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-20 20:45:28','2012-08-20 20:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_52206.gif',49649863586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(915,915,1,'LSQ12elk','LSQ',31.3318333333333,-5.97241666666667,NULL,NULL,'2012-08-10 07:01:05',56149.2924199998,20.0091,0.1812,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_snap_52404.gif',35137599396,NULL,NULL,NULL,'2012-08-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(916,915,0,'LSQ12elk','LSQ',31.331875,-5.97222222222222,NULL,NULL,'2012-08-10 08:44:07',56149.3639799999,20.0696,0.1441,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_snap_52405.gif',35137599396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(917,915,0,'LSQ12elk','LSQ',31.3317916666667,-5.97233333333333,NULL,NULL,'2012-08-12 10:05:56',56151.4207899999,19.5354,0.0939,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_snap_52406.gif',35137599396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(918,915,0,'LSQ12elk','LSQ',31.3317916666667,-5.97236111111111,NULL,NULL,'2012-08-12 10:14:21',56151.4266400002,19.3653,0.1225,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_snap_52407.gif',35137599396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(919,915,0,'LSQ12elk','LSQ',31.331875,-5.97233333333333,NULL,NULL,'2012-08-20 07:56:03',56159.3306,19.4464,0.0632,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_snap_52373.gif',35137599396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(920,915,0,'LSQ12elk','LSQ',31.3319166666667,-5.97236111111111,NULL,NULL,'2012-08-20 09:09:29',56159.3815899999,19.331,0.0618,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_snap_52374.gif',35137599396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(922,921,1,'LSQ12elj','LSQ',31.0349166666667,-4.82077777777778,NULL,NULL,'2012-07-27 07:02:10',56135.29318,20.8978,0.1653,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_history.html','sne?',NULL,0.0829,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_snap_52394.gif',35139786209,NULL,NULL,NULL,'2011-12-14 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,549059159,8579049,NULL,NULL,NULL,NULL),(923,921,0,'LSQ12elj','LSQ',31.0349583333333,-4.82075,NULL,NULL,'2012-07-27 08:48:08',56135.3667700002,20.7253,0.1515,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_history.html','sne?',NULL,0.0829,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_snap_52395.gif',35139786209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,549059159,8579049,NULL,NULL,NULL,NULL),(924,921,0,'LSQ12elj','LSQ',31.0350833333333,-4.82063888888889,NULL,NULL,'2012-07-29 07:07:06',56137.2966,20.0923,0.192,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_history.html','sne?',NULL,0.0829,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_snap_52396.gif',35139786209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,549059159,8579049,NULL,NULL,NULL,NULL),(925,921,0,'LSQ12elj','LSQ',31.0349166666667,-4.82075,NULL,NULL,'2012-07-29 08:51:14',56137.3689199998,20.0827,0.1042,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_history.html','sne?',NULL,0.0829,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_snap_52397.gif',35139786209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,549059159,8579049,NULL,NULL,NULL,NULL),(926,921,0,'LSQ12elj','LSQ',31.0350416666667,-4.82055555555556,NULL,NULL,'2012-07-31 08:49:05',56139.3674300001,19.6068,0.1871,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_history.html','sne?',NULL,0.0829,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_snap_52398.gif',35139786209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,549059159,8579049,NULL,NULL,NULL,NULL),(927,921,0,'LSQ12elj','LSQ',31.035,-4.82052777777778,NULL,NULL,'2012-08-06 08:08:51',56145.3394900002,18.8191,0.2153,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_history.html','sne?',NULL,0.0829,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_snap_52399.gif',35139786209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,549059159,8579049,NULL,NULL,NULL,NULL),(928,921,0,'LSQ12elj','LSQ',31.0349166666667,-4.82072222222222,NULL,NULL,'2012-08-10 07:01:05',56149.2924199998,19.4331,0.0872,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_history.html','sne?',NULL,0.0829,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_snap_52400.gif',35139786209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,549059159,8579049,NULL,NULL,NULL,NULL),(929,921,0,'LSQ12elj','LSQ',31.0349583333333,-4.82055555555556,NULL,NULL,'2012-08-10 08:44:07',56149.3639799999,19.4035,0.0849,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_history.html','sne?',NULL,0.0829,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_snap_52401.gif',35139786209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,549059159,8579049,NULL,NULL,NULL,NULL),(930,921,0,'LSQ12elj','LSQ',31.0349583333333,-4.82061111111111,NULL,NULL,'2012-08-12 10:05:56',56151.4207899999,19.4231,0.0747,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_history.html','sne?',NULL,0.0829,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_snap_52402.gif',35139786209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,549059159,8579049,NULL,NULL,NULL,NULL),(931,921,0,'LSQ12elj','LSQ',31.0350416666667,-4.82055555555556,NULL,NULL,'2012-08-12 10:14:21',56151.4266400002,19.495,0.1306,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_history.html','sne?',NULL,0.0829,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_snap_52403.gif',35139786209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,549059159,8579049,NULL,NULL,NULL,NULL),(932,921,0,'LSQ12elj','LSQ',31.0350416666667,-4.82066666666667,NULL,NULL,'2012-08-20 07:56:03',56159.3306,19.9786,0.0882,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_history.html','sne?',NULL,0.0829,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_snap_52371.gif',35139786209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,549059159,8579049,NULL,NULL,NULL,NULL),(933,921,0,'LSQ12elj','LSQ',31.0349166666667,-4.82066666666667,NULL,NULL,'2012-08-20 09:09:29',56159.3815899999,19.7403,0.0798,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_history.html','sne?',NULL,0.0829,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_snap_52372.gif',35139786209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,549059159,8579049,NULL,NULL,NULL,NULL),(934,934,1,'LSQ12eli','LSQ',51.1982083333333,-6.86372222222222,NULL,NULL,'2012-08-10 07:37:11',56149.3174999999,18.646,0.1121,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eli/LSQ12eli_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eli/LSQ12eli_snap_52391.gif',36804372250,NULL,NULL,NULL,'2012-08-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,575068316,8985442,NULL,NULL,NULL,NULL),(935,934,0,'LSQ12eli','LSQ',51.1981666666667,-6.86375,NULL,NULL,'2012-08-10 09:01:12',56149.3758399999,19.1384,0.1599,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eli/LSQ12eli_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eli/LSQ12eli_snap_52392.gif',36804372250,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,575068316,8985442,NULL,NULL,NULL,NULL),(936,934,0,'LSQ12eli','LSQ',51.198125,-6.86366666666667,NULL,NULL,'2012-08-20 09:53:54',56159.4124400001,18.8742,0.1017,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eli/LSQ12eli_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eli/LSQ12eli_snap_52369.gif',36804372250,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,575068316,8985442,NULL,NULL,NULL,NULL),(937,934,0,'LSQ12eli','LSQ',51.19825,-6.86372222222222,NULL,NULL,'2012-08-20 10:14:18',56159.4265999999,18.4039,0.1304,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eli/LSQ12eli_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eli/LSQ12eli_snap_52370.gif',36804372252,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,575068316,8985442,NULL,NULL,NULL,NULL),(938,938,1,'LSQ12elh','LSQ',51.3040833333333,-6.13441666666667,NULL,NULL,'2012-07-25 09:58:00',56133.4152799998,19.1818,0.1425,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elh/LSQ12elh_history.html','sne?',NULL,0.06982,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elh/LSQ12elh_snap_52387.gif',36803371237,NULL,NULL,NULL,'2012-07-23 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,575052675,8985198,NULL,NULL,NULL,NULL),(939,938,0,'LSQ12elh','LSQ',51.3040416666667,-6.13444444444445,NULL,NULL,'2012-07-27 09:21:48',56135.3901499999,19.191,0.0989,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elh/LSQ12elh_history.html','sne?',NULL,0.06982,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elh/LSQ12elh_snap_52388.gif',36803371237,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,575052675,8985198,NULL,NULL,NULL,NULL),(940,938,0,'LSQ12elh','LSQ',51.304125,-6.13433333333333,NULL,NULL,'2012-07-29 09:16:24',56137.3864000002,18.8873,0.1033,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elh/LSQ12elh_history.html','sne?',NULL,0.06982,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elh/LSQ12elh_snap_52389.gif',36803371237,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,575052675,8985198,NULL,NULL,NULL,NULL),(941,938,0,'LSQ12elh','LSQ',51.3041666666667,-6.13444444444445,NULL,NULL,'2012-08-10 09:02:53',56149.3770099999,19.1877,0.1706,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elh/LSQ12elh_history.html','sne?',NULL,0.06982,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elh/LSQ12elh_snap_52390.gif',36803371237,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,575052675,8985198,NULL,NULL,NULL,NULL),(942,938,0,'LSQ12elh','LSQ',51.304125,-6.1345,NULL,NULL,'2012-08-20 09:55:36',56159.4136199998,19.1129,0.0988,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elh/LSQ12elh_history.html','sne?',NULL,0.06982,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elh/LSQ12elh_snap_52367.gif',36803371237,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,575052675,8985198,NULL,NULL,NULL,NULL),(943,938,0,'LSQ12elh','LSQ',51.304125,-6.13447222222222,NULL,NULL,'2012-08-20 10:05:49',56159.4207100002,18.9907,0.1282,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elh/LSQ12elh_history.html','sne?',NULL,0.06982,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elh/LSQ12elh_snap_52368.gif',36803371237,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,575052675,8985198,NULL,NULL,NULL,NULL),(944,944,1,'LSQ12elf','LSQ',57.3404166666667,-3.49958333333333,NULL,NULL,'2012-08-10 08:12:48',56149.3422300001,19.8091,0.1615,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elf/LSQ12elf_history.html','possibly old sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elf/LSQ12elf_snap_52385.gif',37009717198,NULL,NULL,NULL,'2012-08-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,578276831,9035575,NULL,NULL,NULL,NULL),(945,944,0,'LSQ12elf','LSQ',57.3403333333333,-3.49961111111111,NULL,NULL,'2012-08-20 09:58:59',56159.41597,19.7741,0.1338,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elf/LSQ12elf_history.html','possibly old sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elf/LSQ12elf_snap_52363.gif',37009717198,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,578276831,9035575,NULL,NULL,NULL,NULL),(946,944,0,'LSQ12elf','LSQ',57.3404166666667,-3.49961111111111,NULL,NULL,'2012-08-20 10:07:30',56159.4218799998,19.6328,0.1116,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elf/LSQ12elf_history.html','possibly old sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elf/LSQ12elf_snap_52364.gif',37009717198,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,578276831,9035575,NULL,NULL,NULL,NULL),(947,947,1,'LSQ12ele','LSQ',62.6977083333333,-7.07011111111111,NULL,NULL,'2012-08-20 10:02:21',56159.4183100001,20.3019,0.1428,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ele/LSQ12ele_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ele/LSQ12ele_snap_52361.gif',36955954125,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,577436783,9022449,NULL,NULL,NULL,NULL),(948,947,0,'LSQ12ele','LSQ',62.6975833333333,-7.07013888888889,NULL,NULL,'2012-08-20 10:09:12',56159.4230599999,20.2412,0.1585,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ele/LSQ12ele_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ele/LSQ12ele_snap_52362.gif',36955954125,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,577436783,9022449,NULL,NULL,NULL,NULL),(949,949,1,'LSQ12eld','LSQ',306.786916666667,-4.64341666666667,NULL,NULL,'2012-08-20 00:10:56',56159.0076000001,20.3088,0.1163,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_history.html','variable or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_snap_52384.gif',47835908586,NULL,NULL,NULL,'2012-06-03 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747436071,11678688,NULL,NULL,NULL,NULL),(950,949,0,'LSQ12eld','LSQ',306.787,-4.64344444444444,NULL,NULL,'2012-08-20 02:13:10',56159.0924800001,19.8571,0.0919,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_history.html','variable or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_snap_52359.gif',47835908586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747436071,11678688,NULL,NULL,NULL,NULL),(951,949,0,'LSQ12eld','LSQ',306.787,-4.64341666666667,NULL,NULL,'2012-08-20 05:31:23',56159.23013,20.6724,0.1452,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_history.html','variable or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_snap_52360.gif',47835908586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747436071,11678688,NULL,NULL,NULL,NULL),(952,952,1,'LSQ12elc','LSQ',306.669208333333,-4.56158333333333,NULL,NULL,'2012-08-20 02:13:10',56159.0924800001,20.3572,0.1672,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_snap_52357.gif',47834277690,NULL,NULL,NULL,'2012-06-03 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747410588,11678290,NULL,NULL,NULL,NULL),(953,952,0,'LSQ12elc','LSQ',306.669041666667,-4.56163888888889,NULL,NULL,'2012-08-20 05:31:23',56159.23013,20.6676,0.1676,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_snap_52358.gif',47834277690,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747410588,11678290,NULL,NULL,NULL,NULL),(954,954,1,'LSQ12ela','LSQ',353.607583333333,-3.68661111111111,NULL,NULL,'2012-07-27 06:07:50',56135.2554500001,19.7934,0.0842,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ela/LSQ12ela_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ela/LSQ12ela_snap_52380.gif',49417146764,NULL,NULL,NULL,'2012-07-23 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,772142918,12064733,NULL,NULL,NULL,NULL),(955,954,0,'LSQ12ela','LSQ',353.607416666667,-3.68655555555556,NULL,NULL,'2012-08-18 08:09:52',56157.3401899999,20.6521,0.1433,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ela/LSQ12ela_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ela/LSQ12ela_snap_52381.gif',49417146764,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,772142918,12064733,NULL,NULL,NULL,NULL),(956,954,0,'LSQ12ela','LSQ',353.608166666667,-3.68680555555556,NULL,NULL,'2012-08-20 04:16:58',56159.17845,20.8115,0.1218,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ela/LSQ12ela_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ela/LSQ12ela_snap_52353.gif',49417146767,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,772142918,12064733,NULL,NULL,NULL,NULL),(957,954,0,'LSQ12ela','LSQ',353.608041666667,-3.68680555555556,NULL,NULL,'2012-08-20 06:31:33',56159.2719100001,20.4497,0.13,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ela/LSQ12ela_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ela/LSQ12ela_snap_52354.gif',49417146767,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,772142918,12064733,NULL,NULL,NULL,NULL),(958,958,1,'LSQ12ekz','LSQ',353.51625,-3.70047222222222,NULL,NULL,'2012-08-20 04:16:58',56159.17845,20.9541,0.1572,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekz/LSQ12ekz_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekz/LSQ12ekz_snap_52351.gif',49417144169,NULL,NULL,NULL,'2012-08-18 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772142877,12064732,NULL,NULL,NULL,NULL),(959,958,0,'LSQ12ekz','LSQ',353.51625,-3.70044444444444,NULL,NULL,'2012-08-20 06:31:33',56159.2719100001,20.6019,0.1343,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-21 15:45:30','2012-08-21 15:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekz/LSQ12ekz_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekz/LSQ12ekz_snap_52352.gif',49417144169,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772142877,12064732,NULL,NULL,NULL,NULL),(960,581,0,'LSQ12ehl','LSQ',72.5277083333333,-21.7752777777778,NULL,NULL,'2012-08-21 10:04:30',56160.4197999998,18.4676,0.0431,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 08:45:35','2012-08-22 08:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_history.html','sne???',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_snap_52431.gif',37345461187,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,583522831,9117544,NULL,NULL,NULL,NULL),(961,581,0,'LSQ12ehl','LSQ',72.5277083333333,-21.7752777777778,NULL,NULL,'2012-08-21 10:12:57',56160.4256600002,18.7692,0.1135,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 08:45:35','2012-08-22 08:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_history.html','sne???',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_snap_52432.gif',37345461187,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,583522831,9117544,NULL,NULL,NULL,NULL),(962,751,0,'LSQ12ejf','LSQ',300.23775,-17.8160555555556,NULL,NULL,'2012-08-21 00:13:26',56160.0093399999,18.0304,0.0199,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 08:45:35','2012-08-22 08:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_history.html','sn ',NULL,0.65,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_snap_52469.gif',47978099721,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,749657808,11713403,NULL,NULL,NULL,NULL),(963,751,0,'LSQ12ejf','LSQ',300.237791666667,-17.8160277777778,NULL,NULL,'2012-08-21 02:19:34',56160.09693,18.1375,0.0185,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 08:45:35','2012-08-22 08:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_history.html','sn ',NULL,0.65,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_snap_52470.gif',47978099721,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,749657808,11713403,NULL,NULL,NULL,NULL),(964,751,0,'LSQ12ejf','LSQ',300.237875,-17.8160555555556,NULL,NULL,'2012-08-21 05:24:57',56160.2256700001,18.2071,0.0275,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 08:45:35','2012-08-22 08:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_history.html','sn ',NULL,0.65,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejf/LSQ12ejf_snap_52471.gif',47978099721,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,749657808,11713403,NULL,NULL,NULL,NULL),(965,757,0,'LSQ12ejd','LSQ',300.88075,-19.8605,NULL,NULL,'2012-08-21 00:13:26',56160.0093399999,20.5798,0.1015,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 08:45:35','2012-08-22 08:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_history.html','sn?',NULL,0.083168,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_snap_52480.gif',50813697251,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793964019,12405687,NULL,NULL,NULL,NULL),(966,757,0,'LSQ12ejd','LSQ',300.880625,-19.8603611111111,NULL,NULL,'2012-08-21 05:24:57',56160.2256700001,20.1385,0.1031,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 08:45:35','2012-08-22 08:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_history.html','sn?',NULL,0.083168,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejd/LSQ12ejd_snap_52481.gif',50813697251,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793964019,12405687,NULL,NULL,NULL,NULL),(967,949,0,'LSQ12eld','LSQ',306.786958333333,-4.64341666666667,NULL,NULL,'2012-08-21 00:02:09',56160.0014999998,20.2317,0.1244,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 08:45:35','2012-08-22 08:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_history.html','variable or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_snap_52487.gif',47835908586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747436071,11678688,NULL,NULL,NULL,NULL),(968,949,0,'LSQ12eld','LSQ',306.787,-4.64341666666667,NULL,NULL,'2012-08-21 02:08:08',56160.0889900001,20.0975,0.1285,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 08:45:35','2012-08-22 08:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_history.html','variable or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_snap_52488.gif',47835908586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747436071,11678688,NULL,NULL,NULL,NULL),(969,949,0,'LSQ12eld','LSQ',306.787,-4.64341666666667,NULL,NULL,'2012-08-21 04:09:03',56160.1729600001,19.9238,0.1297,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 08:45:35','2012-08-22 08:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_history.html','variable or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_snap_52489.gif',47835908586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747436071,11678688,NULL,NULL,NULL,NULL),(970,952,0,'LSQ12elc','LSQ',306.669208333333,-4.56147222222222,NULL,NULL,'2012-08-21 00:02:09',56160.0014999998,20.3228,0.1299,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 08:45:35','2012-08-22 08:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_snap_52485.gif',47834277690,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747410588,11678290,NULL,NULL,NULL,NULL),(971,952,0,'LSQ12elc','LSQ',306.669125,-4.56155555555556,NULL,NULL,'2012-08-21 04:09:03',56160.1729600001,20.8978,0.1502,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 08:45:35','2012-08-22 08:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_snap_52486.gif',47834277690,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747410588,11678290,NULL,NULL,NULL,NULL),(972,332,0,'LSQ12dwl','LSQ',333.173083333333,0.512027777777778,NULL,NULL,'2012-08-22 02:55:46',56161.12207,14.7892,0.0022,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 19:45:30','2012-08-22 19:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_history.html','sne-nice!',NULL,0.01377,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_snap_52668.gif',52152344378,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814880380,12732505,NULL,NULL,NULL,NULL),(973,332,0,'LSQ12dwl','LSQ',333.173083333333,0.512027777777778,NULL,NULL,'2012-08-22 05:46:39',56161.2407399998,14.7992,0.0028,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 19:45:30','2012-08-22 19:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_history.html','sne-nice!',NULL,0.01377,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_snap_52669.gif',52152344378,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814880380,12732505,NULL,NULL,NULL,NULL),(974,332,0,'LSQ12dwl','LSQ',333.173125,0.511972222222222,NULL,NULL,'2012-08-22 08:21:40',56161.3483799999,15.1491,0.0184,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 19:45:30','2012-08-22 19:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_history.html','sne-nice!',NULL,0.01377,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dwl/LSQ12dwl_snap_52670.gif',52152344380,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814880380,12732505,NULL,NULL,NULL,NULL),(975,557,0,'LSQ12ege','LSQ',252.715958333333,2.87452777777778,NULL,NULL,'2012-08-22 00:01:27',56161.0010099998,18.5764,0.0531,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-22 19:45:30','2012-08-22 19:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_snap_52706.gif',55981393928,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,874709280,13667332,NULL,NULL,NULL,NULL),(976,560,0,'LSQ12ehh','LSQ',246.801333333333,2.08344444444444,NULL,NULL,'2012-08-22 00:06:33',56161.0045500002,20.6169,0.1084,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-22 19:45:30','2012-08-22 19:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_history.html','sne - nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_snap_52702.gif',56440595284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881884301,13779442,NULL,NULL,NULL,NULL),(977,560,0,'LSQ12ehh','LSQ',246.801375,2.0835,NULL,NULL,'2012-08-22 00:09:55',56161.0068899998,20.7545,0.1196,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-22 19:45:30','2012-08-22 19:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_history.html','sne - nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehh/LSQ12ehh_snap_52703.gif',56440595284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,881884301,13779442,NULL,NULL,NULL,NULL),(978,611,0,'LSQ12eid','LSQ',4.40816666666667,-5.38280555555555,NULL,NULL,'2012-08-22 08:51:38',56161.36919,18.2795,0.1148,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-22 19:45:30','2012-08-22 19:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_snap_52636.gif',34413529726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537711401,8401740,NULL,NULL,NULL,NULL),(979,795,0,'LSQ12ejn','LSQ',303.868166666667,-22.3699722222222,NULL,NULL,'2012-08-22 06:21:04',56161.2646300001,20.7866,0.1444,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 19:45:30','2012-08-22 19:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejn/LSQ12ejn_snap_52672.gif',50806837566,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,793856836,12404013,NULL,NULL,NULL,NULL),(980,949,0,'LSQ12eld','LSQ',306.787,-4.64338888888889,NULL,NULL,'2012-08-21 23:42:16',56160.9876899999,20.2737,0.1114,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 19:45:30','2012-08-22 19:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_history.html','variable or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_snap_52677.gif',47835908586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747436071,11678688,NULL,NULL,NULL,NULL),(981,949,0,'LSQ12eld','LSQ',306.786958333333,-4.64341666666667,NULL,NULL,'2012-08-22 03:03:27',56161.1274000001,19.4043,0.0528,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 19:45:30','2012-08-22 19:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_history.html','variable or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_snap_52678.gif',47835908586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747436071,11678688,NULL,NULL,NULL,NULL),(982,949,0,'LSQ12eld','LSQ',306.787,-4.64338888888889,NULL,NULL,'2012-08-22 06:02:01',56161.25141,19.6957,0.1128,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 19:45:30','2012-08-22 19:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_history.html','variable or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eld/LSQ12eld_snap_52679.gif',47835908586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747436071,11678688,NULL,NULL,NULL,NULL),(983,952,0,'LSQ12elc','LSQ',306.66925,-4.56152777777778,NULL,NULL,'2012-08-21 23:42:16',56160.9876899999,20.4342,0.163,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 19:45:30','2012-08-22 19:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_snap_52674.gif',47834277690,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747410588,11678290,NULL,NULL,NULL,NULL),(984,952,0,'LSQ12elc','LSQ',306.669,-4.56152777777778,NULL,NULL,'2012-08-22 03:03:27',56161.1274000001,20.6085,0.1397,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 19:45:30','2012-08-22 19:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_snap_52675.gif',47834277690,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747410588,11678290,NULL,NULL,NULL,NULL),(985,952,0,'LSQ12elc','LSQ',306.669,-4.5615,NULL,NULL,'2012-08-22 06:02:01',56161.25141,20.4662,0.1104,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 19:45:30','2012-08-22 19:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_snap_52676.gif',47834277690,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747410588,11678290,NULL,NULL,NULL,NULL),(986,986,1,'LSQ12elv','LSQ',44.2788333333333,-21.8778333333333,NULL,NULL,'2012-07-30 08:47:15',56138.3661500001,20.5347,0.1923,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elv/LSQ12elv_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elv/LSQ12elv_snap_52568.gif',38064771756,NULL,NULL,NULL,'2012-07-28 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,594762058,9293157,NULL,NULL,NULL,NULL),(987,986,0,'LSQ12elv','LSQ',44.2789583333333,-21.8778611111111,NULL,NULL,'2012-08-21 07:51:18',56160.3273,19.4315,0.1153,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elv/LSQ12elv_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elv/LSQ12elv_snap_52561.gif',38064771756,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,594762058,9293157,NULL,NULL,NULL,NULL),(988,986,0,'LSQ12elv','LSQ',44.2790416666667,-21.8779166666667,NULL,NULL,'2012-08-21 09:21:23',56160.3898499999,19.477,0.081,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elv/LSQ12elv_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elv/LSQ12elv_snap_52562.gif',38064771756,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,594762058,9293157,NULL,NULL,NULL,NULL),(989,989,0,'LSQ12elu','LSQ',70.4357083333333,-22.9943611111111,NULL,NULL,'2012-08-05 09:31:56',56144.3971799999,18.4014,0.1856,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2019-10-11 20:38:49','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_snap_52614.gif',37338457798,NULL,NULL,NULL,'2012-01-23 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,583413403,9115834,NULL,NULL,NULL,NULL),(990,989,0,'LSQ12elu','LSQ',70.435625,-22.9941111111111,NULL,NULL,'2012-08-21 10:01:06',56160.41744,18.8766,0.1078,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2019-09-06 21:34:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_snap_52559.gif',37338457798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,583413403,9115834,NULL,NULL,NULL,NULL),(991,989,0,'LSQ12elu','LSQ',70.4355416666667,-22.9941111111111,NULL,NULL,'2012-08-21 10:07:53',56160.42215,19.3531,0.1404,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2019-09-06 21:34:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_snap_52560.gif',37338457798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,583413403,9115834,NULL,NULL,NULL,NULL),(992,992,1,'LSQ12elt','LSQ',302.779875,-23.1457222222222,NULL,NULL,'2012-08-10 23:24:46',56149.97554,19.3211,0.0824,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52601.gif',50808789842,NULL,NULL,NULL,'2012-07-26 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(993,992,0,'LSQ12elt','LSQ',302.779791666667,-23.14575,NULL,NULL,'2012-08-11 01:25:03',56150.05907,19.3428,0.0719,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52602.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(994,992,0,'LSQ12elt','LSQ',302.779875,-23.14575,NULL,NULL,'2012-08-11 03:26:42',56150.1435500002,19.1923,0.0649,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52603.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(995,992,0,'LSQ12elt','LSQ',302.779875,-23.1457222222222,NULL,NULL,'2012-08-11 23:23:28',56150.9746400001,19.1431,0.0804,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52604.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(996,992,0,'LSQ12elt','LSQ',302.77975,-23.1456944444444,NULL,NULL,'2012-08-12 01:26:37',56151.0601599999,19.0464,0.0636,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52605.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(997,992,0,'LSQ12elt','LSQ',302.779791666667,-23.1457222222222,NULL,NULL,'2012-08-15 00:03:11',56154.0022200001,19.1434,0.0671,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52606.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(998,992,0,'LSQ12elt','LSQ',302.779791666667,-23.1456944444444,NULL,NULL,'2012-08-15 02:03:33',56154.0858,19.0994,0.0703,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52607.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(999,992,0,'LSQ12elt','LSQ',302.779875,-23.14575,NULL,NULL,'2012-08-15 04:04:10',56154.1695699999,18.6636,0.0788,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52608.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(1000,992,0,'LSQ12elt','LSQ',302.779791666667,-23.14575,NULL,NULL,'2012-08-18 04:38:17',56157.1932600001,19.4397,0.0739,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52609.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(1001,992,0,'LSQ12elt','LSQ',302.780041666667,-23.1456666666667,NULL,NULL,'2012-08-18 07:21:48',56157.30681,18.9976,0.075,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52610.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(1002,992,0,'LSQ12elt','LSQ',302.779791666667,-23.14575,NULL,NULL,'2012-08-20 00:33:55',56159.0235600001,19.5321,0.0829,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52611.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(1003,992,0,'LSQ12elt','LSQ',302.779833333333,-23.1457222222222,NULL,NULL,'2012-08-20 02:36:11',56159.1084699999,19.0188,0.0667,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52612.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(1004,992,0,'LSQ12elt','LSQ',302.779791666667,-23.1456944444444,NULL,NULL,'2012-08-21 00:20:50',56160.0144699998,19.3765,0.0989,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52557.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(1005,992,0,'LSQ12elt','LSQ',302.77975,-23.1457222222222,NULL,NULL,'2012-08-21 02:26:57',56160.1020599999,19.4055,0.0731,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52613.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(1006,992,0,'LSQ12elt','LSQ',302.779833333333,-23.1456944444444,NULL,NULL,'2012-08-21 05:32:21',56160.2308100001,19.0433,0.1399,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52558.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(1007,992,0,'LSQ12elt','LSQ',302.77975,-23.1457222222222,NULL,NULL,'2012-08-21 23:49:41',56160.99284,19.5218,0.0844,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52689.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(1008,992,0,'LSQ12elt','LSQ',302.77975,-23.1457222222222,NULL,NULL,'2012-08-22 03:19:20',56161.1384299998,19.2434,0.0919,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52690.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(1009,992,0,'LSQ12elt','LSQ',302.779833333333,-23.14575,NULL,NULL,'2012-08-22 06:21:04',56161.2646300001,19.1294,0.0894,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elt/LSQ12elt_snap_52691.gif',50808789842,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(1010,1010,1,'LSQ12elr','LSQ',76.6274583333333,-25.5124166666667,NULL,NULL,'2012-08-09 10:05:47',56148.4206900001,19.6988,0.1225,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elr/LSQ12elr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elr/LSQ12elr_snap_52579.gif',37247051297,NULL,NULL,NULL,'2012-01-27 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,581985176,9093518,NULL,NULL,NULL,NULL),(1011,1010,0,'LSQ12elr','LSQ',76.62725,-25.5123888888889,NULL,NULL,'2012-08-09 10:16:06',56148.4278500001,19.3985,0.0962,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elr/LSQ12elr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elr/LSQ12elr_snap_52580.gif',37247051297,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,581985176,9093518,NULL,NULL,NULL,NULL),(1012,1010,0,'LSQ12elr','LSQ',76.62725,-25.5121388888889,NULL,NULL,'2012-08-21 10:06:11',56160.4209699999,18.6429,0.0671,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elr/LSQ12elr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elr/LSQ12elr_snap_52553.gif',37247051297,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,581985176,9093518,NULL,NULL,NULL,NULL),(1013,1010,0,'LSQ12elr','LSQ',76.6272916666667,-25.5120833333333,NULL,NULL,'2012-08-21 10:11:15',56160.4244900001,18.4396,0.0922,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elr/LSQ12elr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elr/LSQ12elr_snap_52554.gif',37247051297,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,581985176,9093518,NULL,NULL,NULL,NULL),(1014,1014,0,'LSQ12elq','LSQ',308.064416666667,1.48769444444444,NULL,NULL,'2012-08-19 23:41:36',56158.9872300001,17.5527,0.0166,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2019-10-11 20:38:49','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elq/LSQ12elq_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elq/LSQ12elq_snap_52575.gif',53996973989,NULL,NULL,NULL,'2012-06-03 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,843702718,13182854,NULL,NULL,NULL,NULL),(1015,1014,0,'LSQ12elq','LSQ',308.064416666667,1.48772222222222,NULL,NULL,'2012-08-20 01:43:00',56159.0715299998,17.6042,0.0218,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elq/LSQ12elq_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elq/LSQ12elq_snap_52576.gif',53996973989,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,843702718,13182854,NULL,NULL,NULL,NULL),(1016,1014,0,'LSQ12elq','LSQ',308.064375,1.48769444444444,NULL,NULL,'2012-08-20 03:46:01',56159.1569599998,17.4668,0.0342,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elq/LSQ12elq_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elq/LSQ12elq_snap_52577.gif',53996973989,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,843702718,13182854,NULL,NULL,NULL,NULL),(1017,1014,0,'LSQ12elq','LSQ',308.064416666667,1.48769444444444,NULL,NULL,'2012-08-20 23:47:23',56159.99125,17.7419,0.0222,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elq/LSQ12elq_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elq/LSQ12elq_snap_52551.gif',53996973989,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,843702718,13182854,NULL,NULL,NULL,NULL),(1018,1014,0,'LSQ12elq','LSQ',308.064416666667,1.48769444444444,NULL,NULL,'2012-08-21 01:53:23',56160.0787499999,17.6287,0.0352,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elq/LSQ12elq_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elq/LSQ12elq_snap_52578.gif',53996973989,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,843702718,13182854,NULL,NULL,NULL,NULL),(1019,1014,0,'LSQ12elq','LSQ',308.064458333333,1.48769444444444,NULL,NULL,'2012-08-21 03:54:16',56160.1626900001,17.6986,0.0248,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elq/LSQ12elq_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elq/LSQ12elq_snap_52552.gif',53996973989,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,843702718,13182854,NULL,NULL,NULL,NULL),(1020,1020,1,'LSQ12elo','LSQ',318.356583333333,-6.59958333333333,NULL,NULL,'2012-08-12 00:52:05',56151.0361700002,21.1315,0.1853,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elo/LSQ12elo_history.html','sne?',NULL,0.12145,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elo/LSQ12elo_snap_52569.gif',50789822544,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793590977,12399859,NULL,NULL,NULL,NULL),(1021,1020,0,'LSQ12elo','LSQ',318.356666666667,-6.59933333333333,NULL,NULL,'2012-08-20 01:24:42',56159.05883,20.9025,0.2058,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elo/LSQ12elo_history.html','sne?',NULL,0.12145,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elo/LSQ12elo_snap_52570.gif',50789822656,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793590979,12399859,NULL,NULL,NULL,NULL),(1022,1020,0,'LSQ12elo','LSQ',318.356541666667,-6.59958333333333,NULL,NULL,'2012-08-21 00:46:58',56160.0326200002,20.6966,0.1272,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elo/LSQ12elo_history.html','sne?',NULL,0.12145,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elo/LSQ12elo_snap_52571.gif',50789822659,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793590979,12399859,NULL,NULL,NULL,NULL),(1023,1020,0,'LSQ12elo','LSQ',318.356541666667,-6.59955555555555,NULL,NULL,'2012-08-21 03:04:14',56160.1279500001,20.5072,0.1076,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elo/LSQ12elo_history.html','sne?',NULL,0.12145,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elo/LSQ12elo_snap_52547.gif',50789822659,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793590979,12399859,NULL,NULL,NULL,NULL),(1024,1020,0,'LSQ12elo','LSQ',318.3565,-6.59952777777778,NULL,NULL,'2012-08-21 06:02:19',56160.2516200002,20.7612,0.099,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elo/LSQ12elo_history.html','sne?',NULL,0.12145,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elo/LSQ12elo_snap_52548.gif',50789822659,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793590979,12399859,NULL,NULL,NULL,NULL),(1025,1020,0,'LSQ12elo','LSQ',318.35675,-6.59963888888889,NULL,NULL,'2012-08-22 00:14:35',56161.0101299998,20.8919,0.1594,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-22 20:45:31','2012-08-22 20:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elo/LSQ12elo_history.html','sne?',NULL,0.12145,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elo/LSQ12elo_snap_52685.gif',50789822547,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793590977,12399859,NULL,NULL,NULL,NULL),(1026,1026,1,'LSQ12elz','LSQ',329.397708333333,-0.839194444444444,NULL,NULL,'2012-07-27 02:44:41',56135.1143700001,19.2497,0.1421,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-23 16:45:32','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_history.html','sne?',NULL,0.21853,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_snap_52796.gif',49826069800,NULL,NULL,NULL,'2012-07-23 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778532340,12164567,NULL,NULL,NULL,NULL),(1027,1026,0,'LSQ12elz','LSQ',329.397541666667,-0.839111111111111,NULL,NULL,'2012-07-27 04:59:41',56135.2081200001,20.6747,0.1722,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-23 16:45:32','2012-08-23 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_history.html','sne?',NULL,0.21853,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_snap_52797.gif',49826069800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778532340,12164567,NULL,NULL,NULL,NULL),(1028,1026,0,'LSQ12elz','LSQ',329.3975,-0.839166666666667,NULL,NULL,'2012-07-29 04:56:02',56137.2055799998,20.6362,0.1781,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-23 16:45:32','2012-08-23 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_history.html','sne?',NULL,0.21853,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_snap_52798.gif',49826069800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778532340,12164567,NULL,NULL,NULL,NULL),(1029,1026,0,'LSQ12elz','LSQ',329.397416666667,-0.83925,NULL,NULL,'2012-08-08 03:51:59',56147.1611100002,20.1028,0.1492,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-23 16:45:32','2012-08-23 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_history.html','sne?',NULL,0.21853,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_snap_52799.gif',49826069800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778532340,12164567,NULL,NULL,NULL,NULL),(1030,1026,0,'LSQ12elz','LSQ',329.3975,-0.839194444444444,NULL,NULL,'2012-08-22 00:57:14',56161.03975,20.5842,0.1289,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-23 16:45:32','2012-08-23 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_history.html','sne?',NULL,0.21853,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_snap_52764.gif',49826069800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778532340,12164567,NULL,NULL,NULL,NULL),(1031,1026,0,'LSQ12elz','LSQ',329.397375,-0.83925,NULL,NULL,'2012-08-22 04:45:34',56161.19832,21.3092,0.186,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-23 16:45:32','2012-08-23 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_history.html','sne?',NULL,0.21853,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_snap_52800.gif',49826069800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778532340,12164567,NULL,NULL,NULL,NULL),(1032,1026,0,'LSQ12elz','LSQ',329.3975,-0.83925,NULL,NULL,'2012-08-22 07:43:38',56161.3219699999,20.5988,0.138,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-23 16:45:32','2012-08-23 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_history.html','sne?',NULL,0.21853,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_snap_52765.gif',49826069800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778532340,12164567,NULL,NULL,NULL,NULL),(1033,1033,1,'LSQ12ely','LSQ',329.641333333333,-1.70502777777778,NULL,NULL,'2012-07-09 05:50:02',56117.24309,19.9718,0.1718,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-23 16:45:32','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ely/LSQ12ely_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ely/LSQ12ely_snap_52793.gif',49828188398,NULL,NULL,NULL,'2012-07-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778565443,12165085,NULL,NULL,NULL,NULL),(1034,1033,0,'LSQ12ely','LSQ',329.641291666667,-1.70505555555556,NULL,NULL,'2012-07-21 06:14:38',56129.2601700001,19.2222,0.1838,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-23 16:45:32','2012-08-23 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ely/LSQ12ely_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ely/LSQ12ely_snap_52794.gif',49828188398,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778565443,12165085,NULL,NULL,NULL,NULL),(1035,1033,0,'LSQ12ely','LSQ',329.641291666667,-1.70488888888889,NULL,NULL,'2012-07-23 05:17:06',56131.2202099999,19.2154,0.1491,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-23 16:45:32','2012-08-23 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ely/LSQ12ely_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ely/LSQ12ely_snap_52795.gif',49828188398,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778565443,12165085,NULL,NULL,NULL,NULL),(1036,1033,0,'LSQ12ely','LSQ',329.641333333333,-1.70502777777778,NULL,NULL,'2012-08-22 04:45:34',56161.19832,20.7335,0.1353,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-23 16:45:32','2012-08-23 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ely/LSQ12ely_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ely/LSQ12ely_snap_52762.gif',49828188398,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778565443,12165085,NULL,NULL,NULL,NULL),(1037,1033,0,'LSQ12ely','LSQ',329.64125,-1.705,NULL,NULL,'2012-08-22 07:43:38',56161.3219699999,19.8428,0.1422,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-23 16:45:32','2012-08-23 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ely/LSQ12ely_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ely/LSQ12ely_snap_52763.gif',49828188398,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778565443,12165085,NULL,NULL,NULL,NULL),(1038,952,0,'LSQ12elc','LSQ',306.669375,-4.56163888888889,NULL,NULL,'2012-08-23 01:28:05',56162.0611800002,19.6242,0.1023,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-23 19:45:32','2012-08-23 19:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_snap_52832.gif',47834277690,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747410588,11678290,NULL,NULL,NULL,NULL),(1039,952,0,'LSQ12elc','LSQ',306.66925,-4.56147222222222,NULL,NULL,'2012-08-23 04:04:41',56162.1699199998,20.6075,0.1414,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-23 19:45:32','2012-08-23 19:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elc/LSQ12elc_snap_52833.gif',47834277690,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747410588,11678290,NULL,NULL,NULL,NULL),(1040,1026,0,'LSQ12elz','LSQ',329.397666666667,-0.839138888888889,NULL,NULL,'2012-08-23 02:09:05',56162.08965,20.3251,0.1513,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-23 19:45:32','2012-08-23 19:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_history.html','sne?',NULL,0.21853,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_snap_52818.gif',49826069800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778532340,12164567,NULL,NULL,NULL,NULL),(1041,1026,0,'LSQ12elz','LSQ',329.397291666667,-0.839194444444444,NULL,NULL,'2012-08-23 04:38:15',56162.1932399999,21.187,0.1859,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-23 19:45:32','2012-08-23 19:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_history.html','sne?',NULL,0.21853,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_snap_52819.gif',49826069800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778532340,12164567,NULL,NULL,NULL,NULL),(1042,1042,1,'LSQ12emd','LSQ',306.4815,-6.20341666666667,NULL,NULL,'2012-08-20 02:13:10',56159.0924800001,21.4843,0.1707,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-24 16:45:32','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emd/LSQ12emd_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emd/LSQ12emd_snap_52870.gif',47825825943,NULL,NULL,NULL,'2012-06-03 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747278530,11676227,NULL,NULL,NULL,NULL),(1043,1042,0,'LSQ12emd','LSQ',306.481208333333,-6.20305555555556,NULL,NULL,'2012-08-21 00:02:09',56160.0014999998,20.8046,0.1803,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-24 16:45:32','2012-08-24 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emd/LSQ12emd_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emd/LSQ12emd_snap_52885.gif',47825825941,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747278530,11676227,NULL,NULL,NULL,NULL),(1044,1042,0,'LSQ12emd','LSQ',306.4815,-6.20327777777778,NULL,NULL,'2012-08-22 06:02:01',56161.25141,20.5466,0.1132,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-24 16:45:32','2012-08-24 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emd/LSQ12emd_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emd/LSQ12emd_snap_52871.gif',47825825943,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747278530,11676227,NULL,NULL,NULL,NULL),(1045,1042,0,'LSQ12emd','LSQ',306.481958333333,-6.20352777777778,NULL,NULL,'2012-08-23 01:28:05',56162.0611800002,21.1954,0.1484,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-24 16:45:32','2012-08-24 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emd/LSQ12emd_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emd/LSQ12emd_snap_52868.gif',47825825942,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747278530,11676227,NULL,NULL,NULL,NULL),(1046,1042,0,'LSQ12emd','LSQ',306.482375,-6.20347222222222,NULL,NULL,'2012-08-23 04:04:41',56162.1699199998,20.9133,0.1603,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-24 16:45:32','2012-08-24 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emd/LSQ12emd_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emd/LSQ12emd_snap_52869.gif',47825825942,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747278530,11676227,NULL,NULL,NULL,NULL),(1047,1047,1,'LSQ12emc','LSQ',309.749333333333,-5.03875,NULL,NULL,'2012-08-20 00:10:56',56159.0076000001,19.3838,0.1125,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-24 16:45:32','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emc/LSQ12emc_history.html','variable or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emc/LSQ12emc_snap_52880.gif',47839885908,NULL,NULL,NULL,'2012-06-03 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747498217,11679659,NULL,NULL,NULL,NULL),(1048,1047,0,'LSQ12emc','LSQ',309.749458333333,-5.03869444444444,NULL,NULL,'2012-08-21 00:02:09',56160.0014999998,19.3938,0.0994,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-24 16:45:32','2012-08-24 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emc/LSQ12emc_history.html','variable or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emc/LSQ12emc_snap_52881.gif',47839885908,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747498217,11679659,NULL,NULL,NULL,NULL),(1049,1047,0,'LSQ12emc','LSQ',309.7495,-5.03869444444444,NULL,NULL,'2012-08-21 04:09:03',56160.1729600001,19.3936,0.0858,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-24 16:45:32','2012-08-24 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emc/LSQ12emc_history.html','variable or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emc/LSQ12emc_snap_52882.gif',47839885908,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747498217,11679659,NULL,NULL,NULL,NULL),(1050,1047,0,'LSQ12emc','LSQ',309.749416666667,-5.03869444444444,NULL,NULL,'2012-08-21 23:42:16',56160.9876899999,19.3605,0.0892,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-24 16:45:32','2012-08-24 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emc/LSQ12emc_history.html','variable or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emc/LSQ12emc_snap_52883.gif',47839885908,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747498217,11679659,NULL,NULL,NULL,NULL),(1051,1047,0,'LSQ12emc','LSQ',309.7495,-5.03861111111111,NULL,NULL,'2012-08-22 06:02:01',56161.25141,19.2165,0.0908,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-24 16:45:32','2012-08-24 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emc/LSQ12emc_history.html','variable or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emc/LSQ12emc_snap_52884.gif',47839885908,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747498217,11679659,NULL,NULL,NULL,NULL),(1052,1047,0,'LSQ12emc','LSQ',309.7495,-5.03858333333333,NULL,NULL,'2012-08-23 01:28:05',56162.0611800002,19.1097,0.1191,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-24 16:45:32','2012-08-24 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emc/LSQ12emc_history.html','variable or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emc/LSQ12emc_snap_52866.gif',47839885908,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747498217,11679659,NULL,NULL,NULL,NULL),(1053,1047,0,'LSQ12emc','LSQ',309.7495,-5.03866666666667,NULL,NULL,'2012-08-23 04:04:41',56162.1699199998,18.9505,0.1193,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-24 16:45:32','2012-08-24 16:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emc/LSQ12emc_history.html','variable or sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emc/LSQ12emc_snap_52867.gif',47839885908,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747498217,11679659,NULL,NULL,NULL,NULL),(1054,581,0,'LSQ12ehl','LSQ',72.5276666666667,-21.7752777777778,NULL,NULL,'2012-08-25 09:03:21',56164.37733,18.8282,0.0428,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-25 18:45:29','2012-08-25 18:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_history.html','sne???',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_snap_52886.gif',37345461187,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,583522831,9117544,NULL,NULL,NULL,NULL),(1055,581,0,'LSQ12ehl','LSQ',72.5277083333333,-21.7752777777778,NULL,NULL,'2012-08-25 09:43:11',56164.4049999998,19.0207,0.0468,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-25 18:45:29','2012-08-25 18:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_history.html','sne???',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_snap_52887.gif',37345461187,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,583522831,9117544,NULL,NULL,NULL,NULL),(1056,986,0,'LSQ12elv','LSQ',44.2789583333333,-21.8779166666667,NULL,NULL,'2012-08-25 08:39:39',56164.36087,19.6973,0.1371,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-25 18:45:29','2012-08-25 18:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elv/LSQ12elv_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elv/LSQ12elv_snap_52914.gif',38064771756,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,594762058,9293157,NULL,NULL,NULL,NULL),(1057,986,0,'LSQ12elv','LSQ',44.2789583333333,-21.8779444444444,NULL,NULL,'2012-08-25 09:55:02',56164.41322,19.6357,0.1046,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-25 18:45:29','2012-08-25 18:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elv/LSQ12elv_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elv/LSQ12elv_snap_52915.gif',38064771756,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,594762058,9293157,NULL,NULL,NULL,NULL),(1058,989,0,'LSQ12elu','LSQ',70.435625,-22.9941388888889,NULL,NULL,'2012-08-25 08:59:58',56164.3749799998,19.2729,0.0812,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-25 18:45:29','2019-09-06 21:34:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_snap_52912.gif',37338457798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,583413403,9115834,NULL,NULL,NULL,NULL),(1059,989,0,'LSQ12elu','LSQ',70.435625,-22.9941111111111,NULL,NULL,'2012-08-25 09:44:53',56164.4061799999,19.3408,0.0869,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-25 18:45:29','2019-09-06 21:34:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_snap_52913.gif',37338457798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,583413403,9115834,NULL,NULL,NULL,NULL),(1060,1060,1,'LSQ12emi','LSQ',75.0574583333333,-22.1881666666667,NULL,NULL,'2012-08-21 10:04:30',56160.4197999998,19.515,0.0948,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-25 21:45:29','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emi/LSQ12emi_history.html','sne-nice!',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emi/LSQ12emi_snap_52954.gif',37549808027,NULL,NULL,NULL,'2012-08-09 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,586715750,9167433,NULL,NULL,NULL,NULL),(1061,1060,0,'LSQ12emi','LSQ',75.0574166666667,-22.1882222222222,NULL,NULL,'2012-08-21 10:12:57',56160.4256600002,19.6254,0.1912,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-25 21:45:29','2012-08-25 21:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emi/LSQ12emi_history.html','sne-nice!',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emi/LSQ12emi_snap_52955.gif',37549808027,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,586715750,9167433,NULL,NULL,NULL,NULL),(1062,1060,0,'LSQ12emi','LSQ',75.0574583333333,-22.1883055555556,NULL,NULL,'2012-08-25 09:03:21',56164.37733,19.5697,0.0938,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-25 21:45:29','2012-08-25 21:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emi/LSQ12emi_history.html','sne-nice!',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emi/LSQ12emi_snap_52932.gif',37549808027,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,586715750,9167433,NULL,NULL,NULL,NULL),(1063,1060,0,'LSQ12emi','LSQ',75.0574166666667,-22.18825,NULL,NULL,'2012-08-25 09:43:11',56164.4049999998,19.5834,0.0784,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-25 21:45:29','2012-08-25 21:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emi/LSQ12emi_history.html','sne-nice!',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emi/LSQ12emi_snap_52933.gif',37549808027,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,586715750,9167433,NULL,NULL,NULL,NULL),(1064,402,0,'LSQ12dzd','LSQ',4.16229166666667,-0.357944444444444,NULL,NULL,'2012-08-26 09:10:30',56165.3823000002,19.0475,0.0779,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzd/LSQ12dzd_history.html','sne???',NULL,0.07471,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzd/LSQ12dzd_snap_53085.gif',34372011761,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537062683,8391604,NULL,NULL,NULL,NULL),(1065,402,0,'LSQ12dzd','LSQ',4.1625,-0.357944444444444,NULL,NULL,'2012-08-26 09:41:48',56165.4040299999,19.934,0.134,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzd/LSQ12dzd_history.html','sne???',NULL,0.07471,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzd/LSQ12dzd_snap_53086.gif',34372011761,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537062683,8391604,NULL,NULL,NULL,NULL),(1066,457,0,'LSQ12edo','LSQ',51.5786666666667,-3.29769444444444,NULL,NULL,'2012-08-26 09:51:06',56165.4104900002,18.9175,0.0937,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_snap_53039.gif',36842019075,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,575656548,8994633,NULL,NULL,NULL,NULL),(1067,462,0,'LSQ12edk','LSQ',47.2392916666667,-2.95436111111111,NULL,NULL,'2012-08-26 08:47:35',56165.36638,18.8661,0.1453,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_history.html','sne',NULL,0.0082,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_snap_53052.gif',36790348536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,574849195,8982018,NULL,NULL,NULL,NULL),(1068,462,0,'LSQ12edk','LSQ',47.23925,-2.95427777777778,NULL,NULL,'2012-08-26 09:29:06',56165.3952100002,18.902,0.1572,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_history.html','sne',NULL,0.0082,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_snap_53053.gif',36790348504,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,574849195,8982018,NULL,NULL,NULL,NULL),(1069,611,0,'LSQ12eid','LSQ',4.40825,-5.38275,NULL,NULL,'2012-08-26 08:10:16',56165.3404700002,18.7774,0.0438,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_snap_52990.gif',34413529726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537711401,8401740,NULL,NULL,NULL,NULL),(1070,617,0,'LSQ12eib','LSQ',8.041125,-7.38158333333333,NULL,NULL,'2012-08-26 08:15:23',56165.3440200002,20.4817,0.1235,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_snap_52994.gif',34627856132,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,541060252,8454066,NULL,NULL,NULL,NULL),(1071,617,0,'LSQ12eib','LSQ',8.04104166666667,-7.38155555555555,NULL,NULL,'2012-08-26 09:13:53',56165.3846499999,19.8223,0.0899,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_snap_52995.gif',34627856132,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,541060252,8454066,NULL,NULL,NULL,NULL),(1072,646,0,'LSQ12eiq','LSQ',32.5293333333333,-5.57611111111111,NULL,NULL,'2012-08-26 08:34:03',56165.3569899998,18.9154,0.0403,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_snap_53023.gif',35142165909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549096342,8579630,NULL,NULL,NULL,NULL),(1073,646,0,'LSQ12eiq','LSQ',32.529375,-5.57611111111111,NULL,NULL,'2012-08-26 09:22:20',56165.3905099998,18.8506,0.04,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_snap_53024.gif',35142165909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549096342,8579630,NULL,NULL,NULL,NULL),(1074,697,0,'LSQ12eix','LSQ',40.224125,-6.53877777777778,NULL,NULL,'2012-08-26 08:42:31',56165.3628600002,19.7193,0.1069,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_53033.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(1075,697,0,'LSQ12eix','LSQ',40.2241666666667,-6.53877777777778,NULL,NULL,'2012-08-26 09:27:24',56165.3940300001,19.6545,0.1316,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_53034.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(1076,722,0,'LSQ12eir','LSQ',34.10075,-3.01938888888889,NULL,NULL,'2012-08-26 08:35:45',56165.3581599998,19.4493,0.1168,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_snap_53027.gif',35133634952,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,548963046,8577547,NULL,NULL,NULL,NULL),(1077,722,0,'LSQ12eir','LSQ',34.1007916666667,-3.01938888888889,NULL,NULL,'2012-08-26 09:24:01',56165.3916799999,19.2985,0.1015,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_snap_53028.gif',35133634952,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,548963046,8577547,NULL,NULL,NULL,NULL),(1078,726,0,'LSQ12eil','LSQ',1.67283333333333,-6.28097222222222,NULL,NULL,'2012-08-26 08:08:36',56165.3393100002,20.1979,0.1904,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eil/LSQ12eil_history.html','sne - young ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eil/LSQ12eil_snap_53036.gif',34387815364,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537309615,8395462,NULL,NULL,NULL,NULL),(1079,915,0,'LSQ12elk','LSQ',31.3317916666667,-5.97230555555556,NULL,NULL,'2012-08-26 08:35:45',56165.3581599998,19.2845,0.0608,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_snap_53079.gif',35137599396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(1080,915,0,'LSQ12elk','LSQ',31.3318333333333,-5.97233333333333,NULL,NULL,'2012-08-26 09:24:01',56165.3916799999,19.4607,0.0635,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_snap_53080.gif',35137599396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(1081,934,0,'LSQ12eli','LSQ',51.1981666666667,-6.86366666666667,NULL,NULL,'2012-08-26 08:50:58',56165.3687300002,18.9486,0.0846,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eli/LSQ12eli_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eli/LSQ12eli_snap_53077.gif',36804372250,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,575068316,8985442,NULL,NULL,NULL,NULL),(1082,934,0,'LSQ12eli','LSQ',51.19825,-6.86363888888889,NULL,NULL,'2012-08-26 09:52:47',56165.4116600002,18.6298,0.1138,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eli/LSQ12eli_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eli/LSQ12eli_snap_53078.gif',36804372250,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,575068316,8985442,NULL,NULL,NULL,NULL),(1083,938,0,'LSQ12elh','LSQ',51.3041666666667,-6.1345,NULL,NULL,'2012-08-26 08:52:39',56165.3698999998,19.3682,0.1257,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elh/LSQ12elh_history.html','sne?',NULL,0.06982,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elh/LSQ12elh_snap_53075.gif',36803371237,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,575052675,8985198,NULL,NULL,NULL,NULL),(1084,938,0,'LSQ12elh','LSQ',51.3041666666667,-6.13441666666667,NULL,NULL,'2012-08-26 09:51:06',56165.4104900002,19.2186,0.1035,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elh/LSQ12elh_history.html','sne?',NULL,0.06982,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elh/LSQ12elh_snap_53076.gif',36803371237,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,575052675,8985198,NULL,NULL,NULL,NULL),(1085,944,0,'LSQ12elf','LSQ',57.3404583333333,-3.49952777777778,NULL,NULL,'2012-08-26 08:56:03',56165.3722600001,19.6812,0.1249,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elf/LSQ12elf_history.html','possibly old sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elf/LSQ12elf_snap_53073.gif',37009717198,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,578276831,9035575,NULL,NULL,NULL,NULL),(1086,944,0,'LSQ12elf','LSQ',57.3405833333333,-3.49944444444444,NULL,NULL,'2012-08-26 09:34:10',56165.39873,19.5682,0.0941,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elf/LSQ12elf_history.html','possibly old sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elf/LSQ12elf_snap_53074.gif',37009717198,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,578276831,9035575,NULL,NULL,NULL,NULL),(1087,947,0,'LSQ12ele','LSQ',62.6979166666667,-7.07033333333333,NULL,NULL,'2012-08-26 08:59:24',56165.3745900001,19.7283,0.1586,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ele/LSQ12ele_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ele/LSQ12ele_snap_53071.gif',36955954114,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,577436783,9022449,NULL,NULL,NULL,NULL),(1088,947,0,'LSQ12ele','LSQ',62.6977916666667,-7.07005555555556,NULL,NULL,'2012-08-26 09:47:43',56165.40814,19.7023,0.1225,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-26 16:45:29','2012-08-26 16:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ele/LSQ12ele_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ele/LSQ12ele_snap_53072.gif',36955954125,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,577436783,9022449,NULL,NULL,NULL,NULL),(1089,1089,1,'LSQ12emj','LSQ',12.5860416666667,-4.175,NULL,NULL,'2012-07-07 08:43:48',56115.3637600001,20.2947,0.1783,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 01:45:31','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emj/LSQ12emj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emj/LSQ12emj_snap_53246.gif',34518817227,NULL,NULL,NULL,'2012-07-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539356519,8427445,NULL,NULL,NULL,NULL),(1090,1089,0,'LSQ12emj','LSQ',12.5860416666667,-4.17511111111111,NULL,NULL,'2012-07-19 10:34:11',56127.4404099998,20.4209,0.1748,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 01:45:31','2012-08-27 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emj/LSQ12emj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emj/LSQ12emj_snap_53247.gif',34518817227,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539356519,8427445,NULL,NULL,NULL,NULL),(1091,1089,0,'LSQ12emj','LSQ',12.5860833333333,-4.17530555555556,NULL,NULL,'2012-08-04 05:04:52',56143.21172,19.749,0.2091,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 01:45:31','2012-08-27 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emj/LSQ12emj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emj/LSQ12emj_snap_53248.gif',34518817227,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539356519,8427445,NULL,NULL,NULL,NULL),(1092,1089,0,'LSQ12emj','LSQ',12.5856666666667,-4.17527777777778,NULL,NULL,'2012-08-10 08:32:17',56149.3557600002,21.4005,0.1732,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 01:45:31','2012-08-27 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emj/LSQ12emj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emj/LSQ12emj_snap_53249.gif',34518817225,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539356519,8427445,NULL,NULL,NULL,NULL),(1093,1089,0,'LSQ12emj','LSQ',12.585875,-4.175,NULL,NULL,'2012-08-12 08:00:30',56151.3336900002,21.2702,0.172,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 01:45:31','2012-08-27 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emj/LSQ12emj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emj/LSQ12emj_snap_53250.gif',34518817227,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539356519,8427445,NULL,NULL,NULL,NULL),(1094,1089,0,'LSQ12emj','LSQ',12.585625,-4.17530555555556,NULL,NULL,'2012-08-20 09:34:49',56159.3991800002,21.4064,0.1642,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 01:45:31','2012-08-27 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emj/LSQ12emj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emj/LSQ12emj_snap_53251.gif',34518817225,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539356519,8427445,NULL,NULL,NULL,NULL),(1095,1089,0,'LSQ12emj','LSQ',12.5855833333333,-4.17505555555556,NULL,NULL,'2012-08-26 08:17:04',56165.3451899998,21.1432,0.1329,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 01:45:31','2012-08-27 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emj/LSQ12emj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emj/LSQ12emj_snap_53195.gif',34518817225,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539356519,8427445,NULL,NULL,NULL,NULL),(1096,1089,0,'LSQ12emj','LSQ',12.5858333333333,-4.17522222222222,NULL,NULL,'2012-08-26 10:09:42',56165.4234099998,21.0108,0.1675,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 01:45:31','2012-08-27 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emj/LSQ12emj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emj/LSQ12emj_snap_53196.gif',34518817227,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,539356519,8427445,NULL,NULL,NULL,NULL),(1097,1097,1,'LSQ12enc','LSQ',66.971125,-3.19430555555556,NULL,NULL,'2012-08-26 09:02:49',56165.37696,19.2688,0.0874,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enc/LSQ12enc_history.html','sne??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enc/LSQ12enc_snap_53399.gif',36919365798,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,576865090,9013517,NULL,NULL,NULL,NULL),(1098,1097,0,'LSQ12enc','LSQ',66.9710416666667,-3.19430555555556,NULL,NULL,'2012-08-26 09:37:34',56165.4010899998,19.1231,0.0831,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enc/LSQ12enc_history.html','sne??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enc/LSQ12enc_snap_53400.gif',36919366489,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,576865101,9013517,NULL,NULL,NULL,NULL),(1099,1099,1,'LSQ12enb','LSQ',4.19720833333333,-0.644222222222222,NULL,NULL,'2012-07-07 06:21:55',56115.26523,19.0028,0.1352,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_history.html','agn?',NULL,0.06394,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_snap_53391.gif',34371929527,NULL,NULL,NULL,'2012-07-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537061398,8391584,NULL,NULL,NULL,NULL),(1100,1099,0,'LSQ12enb','LSQ',4.19716666666667,-0.644305555555556,NULL,NULL,'2012-07-23 07:39:39',56131.3192099999,18.6262,0.0863,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_history.html','agn?',NULL,0.06394,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_snap_53392.gif',34371929527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537061398,8391584,NULL,NULL,NULL,NULL),(1101,1099,0,'LSQ12enb','LSQ',4.196625,-0.644527777777778,NULL,NULL,'2012-07-23 10:11:26',56131.4246100001,19.1626,0.1615,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_history.html','agn?',NULL,0.06394,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_snap_53393.gif',34371929527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537061398,8391584,NULL,NULL,NULL,NULL),(1102,1099,0,'LSQ12enb','LSQ',4.197125,-0.644083333333333,NULL,NULL,'2012-07-29 08:56:42',56137.3727099998,20.4878,0.171,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_history.html','agn?',NULL,0.06394,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_snap_53394.gif',34371929527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537061398,8391584,NULL,NULL,NULL,NULL),(1103,1099,0,'LSQ12enb','LSQ',4.19720833333333,-0.644277777777778,NULL,NULL,'2012-07-31 09:13:00',56139.3840299998,18.8649,0.0857,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_history.html','agn?',NULL,0.06394,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_snap_53395.gif',34371929527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537061398,8391584,NULL,NULL,NULL,NULL),(1104,1099,0,'LSQ12enb','LSQ',4.197,-0.644416666666667,NULL,NULL,'2012-08-08 09:39:29',56147.4024200002,19.1552,0.1123,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_history.html','agn?',NULL,0.06394,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_snap_53396.gif',34371929527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537061398,8391584,NULL,NULL,NULL,NULL),(1105,1099,0,'LSQ12enb','LSQ',4.19716666666667,-0.644583333333333,NULL,NULL,'2012-08-10 09:45:32',56149.4066300001,19.5076,0.1523,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_history.html','agn?',NULL,0.06394,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_snap_53397.gif',34371929527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537061398,8391584,NULL,NULL,NULL,NULL),(1106,1099,0,'LSQ12enb','LSQ',4.197125,-0.644694444444444,NULL,NULL,'2012-08-10 10:14:13',56149.42655,19.9569,0.1573,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_history.html','agn?',NULL,0.06394,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_snap_53398.gif',34371929527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537061398,8391584,NULL,NULL,NULL,NULL),(1107,1099,0,'LSQ12enb','LSQ',4.19725,-0.644277777777778,NULL,NULL,'2012-08-26 09:08:48',56165.38112,18.6988,0.0493,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_history.html','agn?',NULL,0.06394,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_snap_53231.gif',34371929527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537061398,8391584,NULL,NULL,NULL,NULL),(1108,1099,0,'LSQ12enb','LSQ',4.196875,-0.644277777777778,NULL,NULL,'2012-08-26 09:43:30',56165.40521,19.7993,0.1371,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_history.html','agn?',NULL,0.06394,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_snap_53232.gif',34371929527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537061398,8391584,NULL,NULL,NULL,NULL),(1109,1109,1,'LSQ12emx','LSQ',57.5732083333333,-5.23116666666667,NULL,NULL,'2012-08-20 10:07:30',56159.4218799998,18.6131,0.1268,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emx/LSQ12emx_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emx/LSQ12emx_snap_53387.gif',37007224837,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,578237888,9034967,NULL,NULL,NULL,NULL),(1110,1109,0,'LSQ12emx','LSQ',57.5730833333333,-5.23119444444444,NULL,NULL,'2012-08-26 08:56:03',56165.3722600001,18.577,0.1025,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emx/LSQ12emx_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emx/LSQ12emx_snap_53223.gif',37007224837,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,578237888,9034967,NULL,NULL,NULL,NULL),(1111,1109,0,'LSQ12emx','LSQ',57.573,-5.23122222222222,NULL,NULL,'2012-08-26 09:34:10',56165.39873,18.787,0.1209,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emx/LSQ12emx_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emx/LSQ12emx_snap_53224.gif',37007224837,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,578237888,9034967,NULL,NULL,NULL,NULL),(1112,1112,1,'LSQ12emp','LSQ',40.585625,-6.70636111111111,NULL,NULL,'2012-07-15 10:18:38',56123.42961,19.8279,0.1098,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emp/LSQ12emp_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emp/LSQ12emp_snap_53313.gif',37874773295,NULL,NULL,NULL,'2012-07-11 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,591793332,9246770,NULL,NULL,NULL,NULL),(1113,1112,0,'LSQ12emp','LSQ',40.584875,-6.70658333333333,NULL,NULL,'2012-07-17 10:19:57',56125.43053,20.1442,0.1508,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emp/LSQ12emp_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emp/LSQ12emp_snap_53314.gif',37874773293,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,591793332,9246770,NULL,NULL,NULL,NULL),(1114,1112,0,'LSQ12emp','LSQ',40.5847083333333,-6.70655555555556,NULL,NULL,'2012-07-23 10:15:15',56131.4272599998,20.151,0.1463,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emp/LSQ12emp_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emp/LSQ12emp_snap_53315.gif',37874773293,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,591793332,9246770,NULL,NULL,NULL,NULL),(1115,1112,0,'LSQ12emp','LSQ',40.5857916666667,-6.70641666666667,NULL,NULL,'2012-07-31 09:53:40',56139.4122799998,20.0724,0.1929,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emp/LSQ12emp_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emp/LSQ12emp_snap_53316.gif',37874773295,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,591793332,9246770,NULL,NULL,NULL,NULL),(1116,1112,0,'LSQ12emp','LSQ',40.585375,-6.70655555555556,NULL,NULL,'2012-08-26 08:40:49',56165.3616800001,19.9282,0.1072,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emp/LSQ12emp_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emp/LSQ12emp_snap_53207.gif',37874773293,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,591793332,9246770,NULL,NULL,NULL,NULL),(1117,1112,0,'LSQ12emp','LSQ',40.5850416666667,-6.70652777777778,NULL,NULL,'2012-08-26 09:25:43',56165.39286,20.2336,0.1159,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-27 02:45:39','2012-08-27 02:45:39','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emp/LSQ12emp_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emp/LSQ12emp_snap_53208.gif',37874773293,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,591793332,9246770,NULL,NULL,NULL,NULL),(1118,1118,1,'LSQ12egy','LSQ',359.941416666667,-6.35219444444444,NULL,NULL,'2012-08-08 06:09:08',56147.2563499999,19.0941,0.1415,'gr-LSQ',NULL,NULL,'II',NULL,'2012-08-27 19:45:32','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_snap_50369.gif',49430463909,NULL,NULL,NULL,'2012-08-04 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772350998,12067984,NULL,NULL,NULL,NULL),(1119,1118,0,'LSQ12egy','LSQ',359.941458333333,-6.35219444444444,NULL,NULL,'2012-08-08 08:09:33',56147.3399700001,18.7328,0.1009,'gr-LSQ',NULL,NULL,'II',NULL,'2012-08-27 19:45:32','2012-08-27 19:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_snap_50370.gif',49430463909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772350998,12067984,NULL,NULL,NULL,NULL),(1120,1118,0,'LSQ12egy','LSQ',359.9415,-6.35222222222222,NULL,NULL,'2012-08-10 06:26:17',56149.2682599998,18.904,0.1087,'gr-LSQ',NULL,NULL,'II',NULL,'2012-08-27 19:45:32','2012-08-27 19:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_snap_50900.gif',49430463909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772350998,12067984,NULL,NULL,NULL,NULL),(1121,1118,0,'LSQ12egy','LSQ',359.941625,-6.35230555555555,NULL,NULL,'2012-08-10 08:25:41',56149.3511700002,18.9583,0.0743,'gr-LSQ',NULL,NULL,'II',NULL,'2012-08-27 19:45:32','2012-08-27 19:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_snap_50901.gif',49430463909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772350998,12067984,NULL,NULL,NULL,NULL),(1122,1118,0,'LSQ12egy','LSQ',359.941583333333,-6.35219444444444,NULL,NULL,'2012-08-12 07:52:03',56151.3278199998,19.1808,0.071,'gr-LSQ',NULL,NULL,'II',NULL,'2012-08-27 19:45:32','2012-08-27 19:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_snap_51310.gif',49430463909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772350998,12067984,NULL,NULL,NULL,NULL),(1123,1118,0,'LSQ12egy','LSQ',359.941625,-6.35211111111111,NULL,NULL,'2012-08-12 09:57:12',56151.4147299998,18.8652,0.0954,'gr-LSQ',NULL,NULL,'II',NULL,'2012-08-27 19:45:32','2012-08-27 19:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_snap_51311.gif',49430463909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772350998,12067984,NULL,NULL,NULL,NULL),(1124,1118,0,'LSQ12egy','LSQ',359.941291666667,-6.35213888888889,NULL,NULL,'2012-08-20 07:29:02',56159.31183,19.3463,0.0988,'gr-LSQ',NULL,NULL,'II',NULL,'2012-08-27 19:45:32','2012-08-27 19:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_snap_52220.gif',49430463909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772350998,12067984,NULL,NULL,NULL,NULL),(1125,1118,0,'LSQ12egy','LSQ',359.941583333333,-6.35216666666667,NULL,NULL,'2012-08-20 09:43:17',56159.4050599998,19.2605,0.0872,'gr-LSQ',NULL,NULL,'II',NULL,'2012-08-27 19:45:32','2012-08-27 19:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_snap_52221.gif',49430463909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772350998,12067984,NULL,NULL,NULL,NULL),(1126,1118,0,'LSQ12egy','LSQ',359.941625,-6.35225,NULL,NULL,'2012-08-26 08:08:36',56165.3393100002,19.3601,0.1331,'gr-LSQ',NULL,NULL,'II',NULL,'2012-08-27 19:45:32','2012-08-27 19:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_snap_53087.gif',49430463909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772350998,12067984,NULL,NULL,NULL,NULL),(1127,435,0,'LSQ12ecb','LSQ',337.794583333333,-24.8874444444444,NULL,NULL,'2012-08-27 01:43:05',56166.0715899998,19.2714,0.1103,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 06:45:33','2012-08-28 06:45:33','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_53505.gif',50073090666,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(1128,435,0,'LSQ12ecb','LSQ',337.794958333333,-24.8874722222222,NULL,NULL,'2012-08-27 01:44:45',56166.0727499998,19.4947,0.1531,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 06:45:33','2012-08-28 06:45:33','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_53503.gif',50073090668,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(1129,435,0,'LSQ12ecb','LSQ',337.794666666667,-24.8875277777778,NULL,NULL,'2012-08-27 03:53:30',56166.1621599998,19.3107,0.1074,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 06:45:33','2012-08-28 06:45:33','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_53506.gif',50073090666,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(1130,435,0,'LSQ12ecb','LSQ',337.794541666667,-24.8873888888889,NULL,NULL,'2012-08-27 03:55:11',56166.1633299999,19.2821,0.1668,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 06:45:33','2012-08-28 06:45:33','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_history.html','sne',NULL,0.0819,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ecb/LSQ12ecb_snap_53504.gif',50073090666,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(1131,573,0,'LSQ12ehn','LSQ',53.8109166666667,-18.4273611111111,NULL,NULL,'2012-08-27 08:40:17',56166.3613100001,20.0597,0.0749,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 06:45:33','2012-08-28 06:45:33','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_history.html','variable or unusual',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_snap_53463.gif',38005697462,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,593839022,9278734,NULL,NULL,NULL,NULL),(1132,573,0,'LSQ12ehn','LSQ',53.8109583333333,-18.4274166666667,NULL,NULL,'2012-08-27 09:24:48',56166.3922299999,20.0903,0.0888,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 06:45:33','2012-08-28 06:45:33','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_history.html','variable or unusual',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_snap_53464.gif',38005697462,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,593839022,9278734,NULL,NULL,NULL,NULL),(1133,581,0,'LSQ12ehl','LSQ',72.5276666666667,-21.7752777777778,NULL,NULL,'2012-08-27 08:25:03',56166.3507300001,18.9516,0.0465,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 06:45:33','2012-08-28 06:45:33','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_history.html','sne???',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_snap_53448.gif',37345461187,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,583522831,9117544,NULL,NULL,NULL,NULL),(1134,581,0,'LSQ12ehl','LSQ',72.5277083333333,-21.77525,NULL,NULL,'2012-08-27 09:23:05',56166.3910400001,18.9322,0.0434,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 06:45:33','2012-08-28 06:45:33','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_history.html','sne???',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_snap_53449.gif',37345461187,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,583522831,9117544,NULL,NULL,NULL,NULL),(1135,729,0,'LSQ12eig','LSQ',335.276666666667,-16.6261388888889,NULL,NULL,'2012-08-27 01:32:55',56166.0645300001,19.0308,0.1046,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 06:45:33','2012-08-28 06:45:33','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eig/LSQ12eig_history.html','sne ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eig/LSQ12eig_snap_53508.gif',50238735841,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,784980247,12265316,NULL,NULL,NULL,NULL),(1136,986,0,'LSQ12elv','LSQ',44.2790416666667,-21.8779444444444,NULL,NULL,'2012-08-27 07:17:50',56166.30406,19.9357,0.2008,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 06:45:33','2012-08-28 06:45:33','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elv/LSQ12elv_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elv/LSQ12elv_snap_53528.gif',38064771756,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,594762058,9293157,NULL,NULL,NULL,NULL),(1137,989,0,'LSQ12elu','LSQ',70.4355833333333,-22.9941388888889,NULL,NULL,'2012-08-27 06:53:33',56166.2871900001,19.0675,0.1267,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 06:45:33','2019-09-06 21:34:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_snap_53526.gif',37338457798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,583413403,9115834,NULL,NULL,NULL,NULL),(1138,989,0,'LSQ12elu','LSQ',70.435625,-22.9941388888889,NULL,NULL,'2012-08-27 08:33:31',56166.3566100001,19.427,0.0873,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 06:45:33','2019-09-06 21:34:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_snap_53527.gif',37338457798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,583413403,9115834,NULL,NULL,NULL,NULL),(1139,1060,0,'LSQ12emi','LSQ',75.0574166666667,-22.18825,NULL,NULL,'2012-08-27 08:25:03',56166.3507300001,19.7026,0.0927,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 06:45:33','2012-08-28 06:45:33','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emi/LSQ12emi_history.html','sne-nice!',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emi/LSQ12emi_snap_53488.gif',37549808027,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,586715750,9167433,NULL,NULL,NULL,NULL),(1140,1060,0,'LSQ12emi','LSQ',75.0574166666667,-22.18825,NULL,NULL,'2012-08-27 09:23:05',56166.3910400001,19.6241,0.0749,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 06:45:33','2012-08-28 06:45:33','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emi/LSQ12emi_history.html','sne-nice!',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emi/LSQ12emi_snap_53489.gif',37549808027,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,586715750,9167433,NULL,NULL,NULL,NULL),(1141,1141,1,'LSQ12epq','LSQ',311.085958333333,-17.6551666666667,NULL,NULL,'2012-07-16 06:22:00',56124.2652799999,18.5676,0.0481,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epq/LSQ12epq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epq/LSQ12epq_snap_54016.gif',50973821038,NULL,NULL,NULL,'2012-07-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,796465953,12444780,NULL,NULL,NULL,NULL),(1142,1141,0,'LSQ12epq','LSQ',311.085791666667,-17.6552777777778,NULL,NULL,'2012-07-16 08:56:51',56124.3728200002,18.7023,0.0645,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epq/LSQ12epq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epq/LSQ12epq_snap_54017.gif',50973821038,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,796465953,12444780,NULL,NULL,NULL,NULL),(1143,1141,0,'LSQ12epq','LSQ',311.086,-17.6551666666667,NULL,NULL,'2012-08-27 00:13:07',56166.0091200001,17.9959,0.1191,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epq/LSQ12epq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epq/LSQ12epq_snap_53907.gif',50973821038,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,796465953,12444780,NULL,NULL,NULL,NULL),(1144,1141,0,'LSQ12epq','LSQ',311.086,-17.6551388888889,NULL,NULL,'2012-08-27 02:15:33',56166.0941400002,18.1263,0.1189,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epq/LSQ12epq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epq/LSQ12epq_snap_53908.gif',50973821030,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,796465953,12444780,NULL,NULL,NULL,NULL),(1145,1145,1,'LSQ12epp','LSQ',311.838208333333,-18.6798611111111,NULL,NULL,'2012-07-16 04:07:14',56124.1716999998,19.3449,0.1388,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_snap_54009.gif',50990609188,NULL,NULL,NULL,'2012-07-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796728268,12448879,NULL,NULL,NULL,NULL),(1146,1145,0,'LSQ12epp','LSQ',311.838125,-18.6799166666667,NULL,NULL,'2012-07-16 06:18:19',56124.26272,19.5273,0.1032,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_snap_54010.gif',50990609188,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796728268,12448879,NULL,NULL,NULL,NULL),(1147,1145,0,'LSQ12epp','LSQ',311.838041666667,-18.6799722222222,NULL,NULL,'2012-07-16 08:53:11',56124.3702699998,20.0673,0.1953,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_snap_54011.gif',50990609188,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796728268,12448879,NULL,NULL,NULL,NULL),(1148,1145,0,'LSQ12epp','LSQ',311.838166666667,-18.6799166666667,NULL,NULL,'2012-07-22 01:10:12',56130.0487500001,19.5045,0.1352,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_snap_54012.gif',50990609188,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796728268,12448879,NULL,NULL,NULL,NULL),(1149,1145,0,'LSQ12epp','LSQ',311.837583333333,-18.6803333333333,NULL,NULL,'2012-07-22 07:03:48',56130.2943099998,20.3969,0.209,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_snap_54013.gif',50990609188,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796728268,12448879,NULL,NULL,NULL,NULL),(1150,1145,0,'LSQ12epp','LSQ',311.838291666667,-18.6796944444444,NULL,NULL,'2012-07-28 02:43:23',56136.1134700002,18.7513,0.1375,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_snap_54014.gif',50990609188,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796728268,12448879,NULL,NULL,NULL,NULL),(1151,1145,0,'LSQ12epp','LSQ',311.838291666667,-18.6798888888889,NULL,NULL,'2012-08-10 23:48:07',56149.99175,19.8866,0.1493,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_snap_54015.gif',50990609188,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796728268,12448879,NULL,NULL,NULL,NULL),(1152,1145,0,'LSQ12epp','LSQ',311.837875,-18.6801944444444,NULL,NULL,'2012-08-27 00:11:26',56166.0079399999,16.6548,0.0658,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_snap_53905.gif',50990609188,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796728268,12448879,NULL,NULL,NULL,NULL),(1153,1145,0,'LSQ12epp','LSQ',311.838208333333,-18.6800555555556,NULL,NULL,'2012-08-27 02:13:51',56166.09296,17.6476,0.1019,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epp/LSQ12epp_snap_53906.gif',50990609188,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796728268,12448879,NULL,NULL,NULL,NULL),(1154,1154,1,'LSQ12epl','LSQ',78.7472916666667,-19.2884444444444,NULL,NULL,'2012-08-27 08:57:10',56166.37304,21.1087,0.1664,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epl/LSQ12epl_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epl/LSQ12epl_snap_53897.gif',37425226681,NULL,NULL,NULL,'2012-08-27 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,584769166,9137018,NULL,NULL,NULL,NULL),(1155,1154,0,'LSQ12epl','LSQ',78.7473333333333,-19.2884444444444,NULL,NULL,'2012-08-27 09:33:14',56166.3980899998,21.0538,0.1663,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epl/LSQ12epl_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epl/LSQ12epl_snap_53898.gif',37425226681,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,584769166,9137018,NULL,NULL,NULL,NULL),(1156,1156,1,'LSQ12epi','LSQ',71.9270416666667,-18.5434444444444,NULL,NULL,'2012-08-27 08:53:46',56166.3706800002,20.7418,0.1542,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epi/LSQ12epi_history.html','sne',NULL,0.074692,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epi/LSQ12epi_snap_53891.gif',37556785581,NULL,NULL,NULL,'2012-08-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,586824774,9169137,NULL,NULL,NULL,NULL),(1157,1156,0,'LSQ12epi','LSQ',71.9270416666667,-18.5435,NULL,NULL,'2012-08-27 09:31:33',56166.3969200002,20.7627,0.1592,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epi/LSQ12epi_history.html','sne',NULL,0.074692,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epi/LSQ12epi_snap_53892.gif',37556785581,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,586824774,9169137,NULL,NULL,NULL,NULL),(1158,1158,1,'LSQ12eph','LSQ',73.3724166666667,-21.0657222222222,NULL,NULL,'2012-08-05 09:09:50',56144.3818399999,17.0471,0.1506,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eph/LSQ12eph_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eph/LSQ12eph_snap_53992.gif',37344097653,NULL,NULL,NULL,'2012-08-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583501525,9117211,NULL,NULL,NULL,NULL),(1159,1158,0,'LSQ12eph','LSQ',73.3721666666667,-21.0655833333333,NULL,NULL,'2012-08-05 09:49:46',56144.4095700001,18.3429,0.1086,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eph/LSQ12eph_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eph/LSQ12eph_snap_53993.gif',37344097653,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583501525,9117211,NULL,NULL,NULL,NULL),(1160,1158,0,'LSQ12eph','LSQ',73.372,-21.0655,NULL,NULL,'2012-08-27 08:53:46',56166.3706800002,19.8312,0.0877,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eph/LSQ12eph_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eph/LSQ12eph_snap_53889.gif',37344097610,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583501525,9117211,NULL,NULL,NULL,NULL),(1161,1158,0,'LSQ12eph','LSQ',73.3719583333333,-21.0655277777778,NULL,NULL,'2012-08-27 09:31:33',56166.3969200002,20.0173,0.1014,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eph/LSQ12eph_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eph/LSQ12eph_snap_53890.gif',37344097610,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583501525,9117211,NULL,NULL,NULL,NULL),(1162,1162,1,'LSQ12epg','LSQ',74.4789583333333,-21.0233333333333,NULL,NULL,'2012-08-27 08:53:46',56166.3706800002,19.8494,0.1107,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epg/LSQ12epg_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epg/LSQ12epg_snap_53887.gif',37549696809,NULL,NULL,NULL,'2012-08-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,586714012,9167406,NULL,NULL,NULL,NULL),(1163,1162,0,'LSQ12epg','LSQ',74.4789166666667,-21.0234444444444,NULL,NULL,'2012-08-27 09:31:33',56166.3969200002,19.9216,0.1389,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epg/LSQ12epg_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epg/LSQ12epg_snap_53888.gif',37549696809,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,586714012,9167406,NULL,NULL,NULL,NULL),(1164,1164,1,'LSQ12epf','LSQ',73.5524166666667,-18.6885277777778,NULL,NULL,'2012-08-27 08:52:04',56166.3695,18.6342,0.0954,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epf/LSQ12epf_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epf/LSQ12epf_snap_53885.gif',37558685697,NULL,NULL,NULL,'2012-08-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,586854464,9169601,NULL,NULL,NULL,NULL),(1165,1164,0,'LSQ12epf','LSQ',73.5524583333333,-18.6885,NULL,NULL,'2012-08-27 09:55:58',56166.4138699998,18.7008,0.0864,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epf/LSQ12epf_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epf/LSQ12epf_snap_53886.gif',37558685697,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,586854464,9169601,NULL,NULL,NULL,NULL),(1166,1166,1,'LSQ12epd','LSQ',67.7811666666667,-19.8607777777778,NULL,NULL,'2012-08-27 08:50:23',56166.36833,19.4195,0.1174,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epd/LSQ12epd_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epd/LSQ12epd_snap_53879.gif',37378876812,NULL,NULL,NULL,'2012-08-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,584044950,9125702,NULL,NULL,NULL,NULL),(1167,1166,0,'LSQ12epd','LSQ',67.7810833333333,-19.8607222222222,NULL,NULL,'2012-08-27 09:29:52',56166.3957500001,18.9149,0.0742,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epd/LSQ12epd_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epd/LSQ12epd_snap_53880.gif',37378876812,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,584044950,9125702,NULL,NULL,NULL,NULL),(1168,1168,1,'LSQ12epc','LSQ',68.1962916666667,-16.4376666666667,NULL,NULL,'2012-08-27 08:50:23',56166.36833,18.5818,0.03,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epc/LSQ12epc_history.html','sne-very nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epc/LSQ12epc_snap_53877.gif',37355834039,NULL,NULL,NULL,'2012-08-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583684906,9120076,NULL,NULL,NULL,NULL),(1169,1168,0,'LSQ12epc','LSQ',68.1962916666667,-16.4376944444444,NULL,NULL,'2012-08-27 09:29:52',56166.3957500001,18.4306,0.0331,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epc/LSQ12epc_history.html','sne-very nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epc/LSQ12epc_snap_53878.gif',37355834039,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583684906,9120076,NULL,NULL,NULL,NULL),(1170,1170,1,'LSQ12eou','LSQ',61.4215416666667,-19.1896666666667,NULL,NULL,'2012-08-09 10:12:42',56148.4254899998,19.7225,0.1429,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eou/LSQ12eou_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eou/LSQ12eou_snap_53984.gif',36855805416,NULL,NULL,NULL,'2012-08-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,575871959,8997999,NULL,NULL,NULL,NULL),(1171,1170,0,'LSQ12eou','LSQ',61.4215833333333,-19.1896111111111,NULL,NULL,'2012-08-09 10:19:31',56148.43022,19.7655,0.1441,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eou/LSQ12eou_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eou/LSQ12eou_snap_53985.gif',36855805416,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,575871959,8997999,NULL,NULL,NULL,NULL),(1172,1170,0,'LSQ12eou','LSQ',61.4216666666667,-19.1896944444444,NULL,NULL,'2012-08-27 08:43:40',56166.3636599998,19.5714,0.1314,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eou/LSQ12eou_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eou/LSQ12eou_snap_53861.gif',36855805416,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,575871959,8997999,NULL,NULL,NULL,NULL),(1173,1170,0,'LSQ12eou','LSQ',61.42175,-19.1898333333333,NULL,NULL,'2012-08-27 09:26:29',56166.3933999999,19.5515,0.1245,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eou/LSQ12eou_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eou/LSQ12eou_snap_53862.gif',36855805416,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,575871959,8997999,NULL,NULL,NULL,NULL),(1174,1174,1,'LSQ12eor','LSQ',57.7149166666667,-16.9243611111111,NULL,NULL,'2012-07-28 09:48:23',56136.4086099998,18.0611,0.0586,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eor/LSQ12eor_history.html','sn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eor/LSQ12eor_snap_53939.gif',36881294756,NULL,NULL,NULL,'2011-12-15 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,576270230,9004222,NULL,NULL,NULL,NULL),(1175,1174,0,'LSQ12eor','LSQ',57.7149583333333,-16.9244166666667,NULL,NULL,'2012-07-30 09:25:49',56138.3929300001,18.397,0.0551,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eor/LSQ12eor_history.html','sn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eor/LSQ12eor_snap_53940.gif',36881294756,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,576270230,9004222,NULL,NULL,NULL,NULL),(1176,1174,0,'LSQ12eor','LSQ',57.715,-16.9243333333333,NULL,NULL,'2012-08-05 08:46:05',56144.36534,17.8923,0.1804,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eor/LSQ12eor_history.html','sn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eor/LSQ12eor_snap_53941.gif',36881294756,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,576270230,9004222,NULL,NULL,NULL,NULL),(1177,1174,0,'LSQ12eor','LSQ',57.7149166666667,-16.9243333333333,NULL,NULL,'2012-08-27 08:41:59',56166.3624900002,18.6417,0.0718,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eor/LSQ12eor_history.html','sn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eor/LSQ12eor_snap_53855.gif',36881294756,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,576270230,9004222,NULL,NULL,NULL,NULL),(1178,1174,0,'LSQ12eor','LSQ',57.715,-16.9243888888889,NULL,NULL,'2012-08-27 10:01:03',56166.4174000002,18.3406,0.081,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eor/LSQ12eor_history.html','sn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eor/LSQ12eor_snap_53856.gif',36881294756,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,576270230,9004222,NULL,NULL,NULL,NULL),(1179,1179,1,'LSQ12eoo','LSQ',35.0484583333333,-19.03075,NULL,NULL,'2012-07-06 07:49:31',56114.3260599999,19.4534,0.1746,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoo/LSQ12eoo_history.html','sne?',NULL,0.136284,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoo/LSQ12eoo_snap_53934.gif',37974006116,NULL,NULL,NULL,'2011-12-15 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,593343845,9270997,NULL,NULL,NULL,NULL),(1180,1179,0,'LSQ12eoo','LSQ',35.047875,-19.0304444444444,NULL,NULL,'2012-07-28 06:24:33',56136.2670499999,18.514,0.1347,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoo/LSQ12eoo_history.html','sne?',NULL,0.136284,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoo/LSQ12eoo_snap_53935.gif',37974006117,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,593343845,9270997,NULL,NULL,NULL,NULL),(1181,1179,0,'LSQ12eoo','LSQ',35.04725,-19.0302222222222,NULL,NULL,'2012-07-28 08:24:19',56136.35023,19.3248,0.1484,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoo/LSQ12eoo_history.html','sne?',NULL,0.136284,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoo/LSQ12eoo_snap_53936.gif',37974006117,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,593343845,9270997,NULL,NULL,NULL,NULL),(1182,1179,0,'LSQ12eoo','LSQ',35.0480833333333,-19.0306388888889,NULL,NULL,'2012-07-30 09:43:57',56138.4055300001,19.2529,0.1687,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoo/LSQ12eoo_history.html','sne?',NULL,0.136284,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoo/LSQ12eoo_snap_53937.gif',37974006117,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,593343845,9270997,NULL,NULL,NULL,NULL),(1183,1179,0,'LSQ12eoo','LSQ',35.0480416666667,-19.0305,NULL,NULL,'2012-08-27 06:02:51',56166.2519899998,18.4955,0.1324,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoo/LSQ12eoo_history.html','sne?',NULL,0.136284,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoo/LSQ12eoo_snap_53849.gif',37974006117,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,593343845,9270997,NULL,NULL,NULL,NULL),(1184,1179,0,'LSQ12eoo','LSQ',35.0477916666667,-19.0304444444444,NULL,NULL,'2012-08-27 08:05:54',56166.3374399999,18.1113,0.0793,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoo/LSQ12eoo_history.html','sne?',NULL,0.136284,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoo/LSQ12eoo_snap_53850.gif',37974006117,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,593343845,9270997,NULL,NULL,NULL,NULL),(1185,1185,1,'LSQ12eom','LSQ',28.2500416666667,-18.1508888888889,NULL,NULL,'2012-08-27 05:59:28',56166.24963,19.7871,0.1565,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eom/LSQ12eom_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eom/LSQ12eom_snap_53845.gif',35086441365,NULL,NULL,NULL,'2012-08-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,548225646,8566025,NULL,NULL,NULL,NULL),(1186,1185,0,'LSQ12eom','LSQ',28.2499583333333,-18.1509166666667,NULL,NULL,'2012-08-27 08:02:31',56166.3350900002,19.8768,0.1069,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eom/LSQ12eom_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eom/LSQ12eom_snap_53846.gif',35086441365,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,548225646,8566025,NULL,NULL,NULL,NULL),(1187,1187,1,'LSQ12eok','LSQ',28.2188333333333,-18.1269444444444,NULL,NULL,'2012-07-28 06:11:56',56136.2582899998,18.4377,0.0753,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_snap_53970.gif',35086449258,NULL,NULL,NULL,'2012-07-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,548225769,8566027,NULL,NULL,NULL,NULL),(1188,1187,0,'LSQ12eok','LSQ',28.2187916666667,-18.1270277777778,NULL,NULL,'2012-07-28 08:12:14',56136.3418299998,18.8201,0.051,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_snap_53971.gif',35086449258,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,548225769,8566027,NULL,NULL,NULL,NULL),(1189,1187,0,'LSQ12eok','LSQ',28.2188333333333,-18.127,NULL,NULL,'2012-07-30 07:08:40',56138.2976899999,17.8335,0.0405,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_snap_53972.gif',35086449258,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,548225769,8566027,NULL,NULL,NULL,NULL),(1190,1187,0,'LSQ12eok','LSQ',28.218875,-18.1269722222222,NULL,NULL,'2012-07-30 09:49:02',56138.40906,17.9091,0.0373,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_snap_53973.gif',35086449258,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,548225769,8566027,NULL,NULL,NULL,NULL),(1191,1187,0,'LSQ12eok','LSQ',28.2189166666667,-18.127,NULL,NULL,'2012-08-05 07:31:29',56144.31354,16.7072,0.0497,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_snap_53974.gif',35086449258,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,548225769,8566027,NULL,NULL,NULL,NULL),(1192,1187,0,'LSQ12eok','LSQ',28.2189583333333,-18.1270277777778,NULL,NULL,'2012-08-27 05:57:46',56166.2484599999,17.7264,0.0311,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_snap_53841.gif',35086449258,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,548225769,8566027,NULL,NULL,NULL,NULL),(1193,1187,0,'LSQ12eok','LSQ',28.2188333333333,-18.127,NULL,NULL,'2012-08-27 08:00:50',56166.3339200001,17.6063,0.0202,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_snap_53842.gif',35086449258,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,548225769,8566027,NULL,NULL,NULL,NULL),(1194,1194,1,'LSQ12eog','LSQ',341.963625,-23.5885555555556,NULL,NULL,'2012-07-06 06:23:28',56114.2662999998,16.5173,0.0678,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eog/LSQ12eog_history.html','sne?',NULL,0.07675,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eog/LSQ12eog_snap_53943.gif',50224358479,NULL,NULL,NULL,'2012-07-03 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,784755601,12261806,NULL,NULL,NULL,NULL),(1195,1194,0,'LSQ12eog','LSQ',341.963916666667,-23.5885277777778,NULL,NULL,'2012-07-22 10:07:02',56130.4215600002,19.0269,0.1902,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eog/LSQ12eog_history.html','sne?',NULL,0.07675,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eog/LSQ12eog_snap_53944.gif',50224358477,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,784755601,12261806,NULL,NULL,NULL,NULL),(1196,1194,0,'LSQ12eog','LSQ',341.963666666667,-23.5885833333333,NULL,NULL,'2012-07-30 03:12:18',56138.1335499999,19.2898,0.1155,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eog/LSQ12eog_history.html','sne?',NULL,0.07675,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eog/LSQ12eog_snap_53945.gif',50224358479,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,784755601,12261806,NULL,NULL,NULL,NULL),(1197,1194,0,'LSQ12eog','LSQ',341.963291666667,-23.5886111111111,NULL,NULL,'2012-08-07 05:55:37',56146.2469600001,18.3328,0.0761,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eog/LSQ12eog_history.html','sne?',NULL,0.07675,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eog/LSQ12eog_snap_53946.gif',50224358476,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,784755601,12261806,NULL,NULL,NULL,NULL),(1198,1194,0,'LSQ12eog','LSQ',341.964166666667,-23.5883333333333,NULL,NULL,'2012-08-09 04:12:30',56148.1753500002,19.2282,0.0951,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eog/LSQ12eog_history.html','sne?',NULL,0.07675,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eog/LSQ12eog_snap_53947.gif',50224358477,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,784755601,12261806,NULL,NULL,NULL,NULL),(1199,1194,0,'LSQ12eog','LSQ',341.963583333333,-23.5886111111111,NULL,NULL,'2012-08-27 01:56:35',56166.08097,18.9483,0.1153,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eog/LSQ12eog_history.html','sne?',NULL,0.07675,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eog/LSQ12eog_snap_53833.gif',50224358476,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,784755601,12261806,NULL,NULL,NULL,NULL),(1200,1194,0,'LSQ12eog','LSQ',341.963458333333,-23.5885277777778,NULL,NULL,'2012-08-27 04:07:02',56166.1715600002,17.91,0.0983,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eog/LSQ12eog_history.html','sne?',NULL,0.07675,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eog/LSQ12eog_snap_53834.gif',50224358476,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,784755601,12261806,NULL,NULL,NULL,NULL),(1201,1201,1,'LSQ12eod','LSQ',319.040166666667,-24.1268611111111,NULL,NULL,'2012-08-15 01:10:05',56154.04868,20.3534,0.1503,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eod/LSQ12eod_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eod/LSQ12eod_snap_53826.gif',50917408090,NULL,NULL,NULL,'2012-08-13 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,795584501,12431007,NULL,NULL,NULL,NULL),(1202,1201,0,'LSQ12eod','LSQ',319.040208333333,-24.1268055555556,NULL,NULL,'2012-08-19 00:53:01',56158.03682,19.7947,0.0858,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eod/LSQ12eod_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eod/LSQ12eod_snap_53827.gif',50917408090,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,795584501,12431007,NULL,NULL,NULL,NULL),(1203,1201,0,'LSQ12eod','LSQ',319.04025,-24.1268055555556,NULL,NULL,'2012-08-27 00:48:50',56166.0339199998,19.5769,0.1613,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eod/LSQ12eod_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eod/LSQ12eod_snap_53680.gif',50917408090,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,795584501,12431007,NULL,NULL,NULL,NULL),(1204,1201,0,'LSQ12eod','LSQ',319.040208333333,-24.1268055555556,NULL,NULL,'2012-08-27 02:59:11',56166.1244399999,19.8413,0.1267,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eod/LSQ12eod_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eod/LSQ12eod_snap_53681.gif',50917408090,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,795584501,12431007,NULL,NULL,NULL,NULL),(1205,1205,1,'LSQ12eoc','LSQ',317.283416666667,-22.2568611111111,NULL,NULL,'2012-07-08 04:58:24',56116.2072299998,18.7897,0.1472,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_snap_53822.gif',50904231018,NULL,NULL,NULL,'2012-07-03 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,795378609,12427790,NULL,NULL,NULL,NULL),(1206,1205,0,'LSQ12eoc','LSQ',317.28375,-22.2571944444444,NULL,NULL,'2012-07-13 06:53:27',56121.28712,19.5671,0.1018,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_snap_53823.gif',50904231018,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,795378609,12427790,NULL,NULL,NULL,NULL),(1207,1205,0,'LSQ12eoc','LSQ',317.283833333333,-22.2569722222222,NULL,NULL,'2012-07-19 02:20:19',56127.0974499998,18.4262,0.0421,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_snap_53824.gif',50904231018,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,795378609,12427790,NULL,NULL,NULL,NULL),(1208,1205,0,'LSQ12eoc','LSQ',317.283041666667,-22.2569444444444,NULL,NULL,'2012-07-28 01:10:38',56136.0490600001,19.4863,0.1395,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_snap_53933.gif',50904231025,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,795378609,12427790,NULL,NULL,NULL,NULL),(1209,1205,0,'LSQ12eoc','LSQ',317.283458333333,-22.2570833333333,NULL,NULL,'2012-08-09 00:22:21',56148.01553,20.4808,0.162,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_snap_53825.gif',50904231018,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,795378609,12427790,NULL,NULL,NULL,NULL),(1210,1205,0,'LSQ12eoc','LSQ',317.283708333333,-22.2571111111111,NULL,NULL,'2012-08-27 00:36:55',56166.0256400001,18.2498,0.099,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_snap_53678.gif',50904231018,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,795378609,12427790,NULL,NULL,NULL,NULL),(1211,1205,0,'LSQ12eoc','LSQ',317.283833333333,-22.2571111111111,NULL,NULL,'2012-08-27 02:39:18',56166.11063,18.0098,0.0953,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_snap_53679.gif',50904231018,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,795378609,12427790,NULL,NULL,NULL,NULL),(1212,1212,1,'LSQ12env','LSQ',79.9316666666667,-24.6253333333333,NULL,NULL,'2012-08-25 09:08:24',56164.3808400002,19.2846,0.108,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12env/LSQ12env_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12env/LSQ12env_snap_53705.gif',37130844292,NULL,NULL,NULL,'2012-02-01 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,580169442,9065147,NULL,NULL,NULL,NULL),(1213,1212,0,'LSQ12env','LSQ',79.9316666666667,-24.6252222222222,NULL,NULL,'2012-08-25 09:39:49',56164.4026600001,19.3251,0.1136,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12env/LSQ12env_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12env/LSQ12env_snap_53706.gif',37130844292,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,580169442,9065147,NULL,NULL,NULL,NULL),(1214,1212,0,'LSQ12env','LSQ',79.93175,-24.6253055555556,NULL,NULL,'2012-08-27 08:30:08',56166.3542599999,19.441,0.1251,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12env/LSQ12env_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12env/LSQ12env_snap_53664.gif',37130830920,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,580169233,9065144,NULL,NULL,NULL,NULL),(1215,1212,0,'LSQ12env','LSQ',79.931625,-24.6253611111111,NULL,NULL,'2012-08-27 09:19:42',56166.3886899999,19.3679,0.1001,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12env/LSQ12env_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12env/LSQ12env_snap_53665.gif',37130844292,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,580169442,9065147,NULL,NULL,NULL,NULL),(1216,1216,1,'LSQ12ens','LSQ',79.1612083333333,-25.06175,NULL,NULL,'2012-08-27 08:28:25',56166.3530700002,20.1073,0.1232,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ens/LSQ12ens_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ens/LSQ12ens_snap_53658.gif',37131980291,NULL,NULL,NULL,'2012-08-25 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,580187192,9065424,NULL,NULL,NULL,NULL),(1217,1216,0,'LSQ12ens','LSQ',79.1610833333333,-25.0617777777778,NULL,NULL,'2012-08-27 09:21:23',56166.38986,20.1895,0.1305,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ens/LSQ12ens_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ens/LSQ12ens_snap_53659.gif',37131980291,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,580187192,9065424,NULL,NULL,NULL,NULL),(1218,1218,1,'LSQ12enp','LSQ',80.7665833333333,-24.2645277777778,NULL,NULL,'2012-08-27 08:28:25',56166.3530700002,20.4032,0.1412,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enp/LSQ12enp_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enp/LSQ12enp_snap_53652.gif',37141750864,NULL,NULL,NULL,'2012-08-25 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,580339857,9067810,NULL,NULL,NULL,NULL),(1219,1218,0,'LSQ12enp','LSQ',80.7665,-24.2645833333333,NULL,NULL,'2012-08-27 09:21:23',56166.38986,18.9181,0.0953,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enp/LSQ12enp_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enp/LSQ12enp_snap_53653.gif',37141750864,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,580339857,9067810,NULL,NULL,NULL,NULL),(1220,1220,1,'LSQ12eno','LSQ',74.4076666666667,-25.1766111111111,NULL,NULL,'2012-08-09 10:16:06',56148.4278500001,20.3244,0.2162,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eno/LSQ12eno_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eno/LSQ12eno_snap_53698.gif',37227330578,NULL,NULL,NULL,'2012-01-27 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,581677040,9088703,NULL,NULL,NULL,NULL),(1221,1220,0,'LSQ12eno','LSQ',74.4079583333333,-25.1763333333333,NULL,NULL,'2012-08-25 09:38:07',56164.4014699999,20.6718,0.1888,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eno/LSQ12eno_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eno/LSQ12eno_snap_53699.gif',37227330081,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,581677032,9088703,NULL,NULL,NULL,NULL),(1222,1220,0,'LSQ12eno','LSQ',74.4079166666667,-25.1765555555556,NULL,NULL,'2012-08-27 08:26:44',56166.3519000001,21.2498,0.1675,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eno/LSQ12eno_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eno/LSQ12eno_snap_53650.gif',37227330081,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,581677032,9088703,NULL,NULL,NULL,NULL),(1223,1220,0,'LSQ12eno','LSQ',74.4080416666667,-25.1763888888889,NULL,NULL,'2012-08-27 09:18:01',56166.3875199999,20.8946,0.1506,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eno/LSQ12eno_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eno/LSQ12eno_snap_53651.gif',37227330081,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,581677032,9088703,NULL,NULL,NULL,NULL),(1224,1224,1,'LSQ12enl','LSQ',74.92375,-24.2499444444444,NULL,NULL,'2012-08-09 10:14:25',56148.42668,19.9258,0.1593,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enl/LSQ12enl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enl/LSQ12enl_snap_53688.gif',37213664024,NULL,NULL,NULL,'2012-01-26 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,581463500,9085367,NULL,NULL,NULL,NULL),(1225,1224,0,'LSQ12enl','LSQ',74.9236666666667,-24.2500555555556,NULL,NULL,'2012-08-25 09:43:11',56164.4049999998,19.773,0.1051,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enl/LSQ12enl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enl/LSQ12enl_snap_53689.gif',37213664024,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,581463500,9085367,NULL,NULL,NULL,NULL),(1226,1224,0,'LSQ12enl','LSQ',74.9239583333333,-24.2499444444444,NULL,NULL,'2012-08-27 08:25:03',56166.3507300001,20.5609,0.1553,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enl/LSQ12enl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enl/LSQ12enl_snap_53644.gif',37213664024,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,581463500,9085367,NULL,NULL,NULL,NULL),(1227,1224,0,'LSQ12enl','LSQ',74.9236666666667,-24.2500833333333,NULL,NULL,'2012-08-27 09:23:05',56166.3910400001,20.1717,0.1271,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enl/LSQ12enl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enl/LSQ12enl_snap_53645.gif',37213664024,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,581463500,9085367,NULL,NULL,NULL,NULL),(1228,1228,1,'LSQ12enj','LSQ',70.639125,-24.0433888888889,NULL,NULL,'2012-08-21 10:07:53',56160.42215,19.2667,0.1886,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enj/LSQ12enj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enj/LSQ12enj_snap_53684.gif',37337805598,NULL,NULL,NULL,'2012-08-09 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583403212,9115675,NULL,NULL,NULL,NULL),(1229,1228,0,'LSQ12enj','LSQ',70.6392916666667,-24.0434444444444,NULL,NULL,'2012-08-25 08:59:58',56164.3749799998,19.4517,0.1095,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enj/LSQ12enj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enj/LSQ12enj_snap_53685.gif',37337805598,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583403212,9115675,NULL,NULL,NULL,NULL),(1230,1228,0,'LSQ12enj','LSQ',70.63925,-24.0433333333333,NULL,NULL,'2012-08-25 09:44:53',56164.4061799999,19.4762,0.144,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enj/LSQ12enj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enj/LSQ12enj_snap_53686.gif',37337805598,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583403212,9115675,NULL,NULL,NULL,NULL),(1231,1228,0,'LSQ12enj','LSQ',70.6391666666667,-24.0434166666667,NULL,NULL,'2012-08-27 06:53:33',56166.2871900001,19.298,0.1632,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enj/LSQ12enj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enj/LSQ12enj_snap_53640.gif',37337805598,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583403212,9115675,NULL,NULL,NULL,NULL),(1232,1228,0,'LSQ12enj','LSQ',70.63925,-24.0434166666667,NULL,NULL,'2012-08-27 08:33:31',56166.3566100001,19.4356,0.0863,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 21:45:35','2012-08-28 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enj/LSQ12enj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enj/LSQ12enj_snap_53641.gif',37337805598,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583403212,9115675,NULL,NULL,NULL,NULL),(1233,1233,1,'LSQ12eqa','LSQ',339.820375,-19.6164444444444,NULL,NULL,'2012-07-28 04:54:20',56136.2044000002,19.6187,0.1141,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 22:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqa/LSQ12eqa_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqa/LSQ12eqa_snap_54066.gif',50250522592,NULL,NULL,NULL,'2012-07-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785164415,12268193,NULL,NULL,NULL,NULL),(1234,1233,0,'LSQ12eqa','LSQ',339.820083333333,-19.6163333333333,NULL,NULL,'2012-07-30 03:33:02',56138.1479500001,18.7965,0.1533,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 22:45:35','2012-08-28 22:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqa/LSQ12eqa_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqa/LSQ12eqa_snap_54067.gif',50250522384,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785164412,12268193,NULL,NULL,NULL,NULL),(1235,1233,0,'LSQ12eqa','LSQ',339.82025,-19.6161666666667,NULL,NULL,'2012-07-30 05:35:37',56138.2330700001,18.8632,0.1042,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 22:45:35','2012-08-28 22:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqa/LSQ12eqa_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqa/LSQ12eqa_snap_54068.gif',50250522384,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785164412,12268193,NULL,NULL,NULL,NULL),(1236,1233,0,'LSQ12eqa','LSQ',339.820166666667,-19.6161388888889,NULL,NULL,'2012-08-09 04:59:57',56148.2083100001,17.7154,0.0423,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 22:45:35','2012-08-28 22:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqa/LSQ12eqa_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqa/LSQ12eqa_snap_54069.gif',50250522384,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785164412,12268193,NULL,NULL,NULL,NULL),(1237,1233,0,'LSQ12eqa','LSQ',339.820125,-19.6162777777778,NULL,NULL,'2012-08-12 07:39:19',56151.3189699999,18.787,0.0467,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 22:45:35','2012-08-28 22:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqa/LSQ12eqa_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqa/LSQ12eqa_snap_54070.gif',50250522384,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785164412,12268193,NULL,NULL,NULL,NULL),(1238,1233,0,'LSQ12eqa','LSQ',339.820625,-19.6160277777778,NULL,NULL,'2012-08-27 01:48:07',56166.0750899999,18.6137,0.0894,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 22:45:35','2012-08-28 22:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqa/LSQ12eqa_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqa/LSQ12eqa_snap_53927.gif',50250522592,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785164415,12268193,NULL,NULL,NULL,NULL),(1239,1233,0,'LSQ12eqa','LSQ',339.820416666667,-19.6161944444444,NULL,NULL,'2012-08-27 03:58:35',56166.1656900002,18.8875,0.1499,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 22:45:35','2012-08-28 22:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqa/LSQ12eqa_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqa/LSQ12eqa_snap_53928.gif',50250522592,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785164415,12268193,NULL,NULL,NULL,NULL),(1240,1240,1,'LSQ12epy','LSQ',339.397125,-18.3271111111111,NULL,NULL,'2012-08-12 04:23:15',56151.1828200002,20.403,0.1081,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 22:45:35','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epy/LSQ12epy_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epy/LSQ12epy_snap_54058.gif',50251458903,NULL,NULL,NULL,'2012-08-09 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785179045,12268422,NULL,NULL,NULL,NULL),(1241,1240,0,'LSQ12epy','LSQ',339.396916666667,-18.3271388888889,NULL,NULL,'2012-08-27 01:46:26',56166.0739199999,19.4005,0.1429,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 22:45:35','2012-08-28 22:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epy/LSQ12epy_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epy/LSQ12epy_snap_53923.gif',50251458903,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785179045,12268422,NULL,NULL,NULL,NULL),(1242,1240,0,'LSQ12epy','LSQ',339.396958333333,-18.3268888888889,NULL,NULL,'2012-08-27 03:56:53',56166.16451,19.0618,0.1204,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-28 22:45:35','2012-08-28 22:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epy/LSQ12epy_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epy/LSQ12epy_snap_53924.gif',50251458900,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785179045,12268422,NULL,NULL,NULL,NULL),(1243,451,0,'LSQ12eea','LSQ',358.399166666667,-6.38319444444444,NULL,NULL,'2012-08-28 05:43:10',56167.23832,17.8842,0.0846,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eea/LSQ12eea_history.html','sne?',NULL,0.045465,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eea/LSQ12eea_snap_54262.gif',49431273985,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772363656,12068182,NULL,NULL,NULL,NULL),(1244,451,0,'LSQ12eea','LSQ',358.39925,-6.38305555555556,NULL,NULL,'2012-08-28 07:45:03',56167.32296,18.8366,0.1132,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eea/LSQ12eea_history.html','sne?',NULL,0.045465,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eea/LSQ12eea_snap_54263.gif',49431273985,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772363656,12068182,NULL,NULL,NULL,NULL),(1245,457,0,'LSQ12edo','LSQ',51.57825,-3.29761111111111,NULL,NULL,'2012-08-28 08:10:18',56167.3404899999,18.4859,0.1046,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_snap_54231.gif',36842019075,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,575656548,8994633,NULL,NULL,NULL,NULL),(1246,457,0,'LSQ12edo','LSQ',51.578375,-3.29791666666667,NULL,NULL,'2012-08-28 09:09:42',56167.3817400001,19.099,0.118,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edo/LSQ12edo_snap_54232.gif',36842019075,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,575656548,8994633,NULL,NULL,NULL,NULL),(1247,462,0,'LSQ12edk','LSQ',47.2393333333333,-2.95430555555556,NULL,NULL,'2012-08-28 08:05:14',56167.3369700001,18.1997,0.0824,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_history.html','sne',NULL,0.0082,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12edk/LSQ12edk_snap_54258.gif',36790348536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,574849195,8982018,NULL,NULL,NULL,NULL),(1248,544,0,'LSQ12egf','LSQ',342.308833333333,1.74255555555556,NULL,NULL,'2012-08-28 04:28:05',56167.1861700001,19.3969,0.0963,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_54372.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(1249,544,0,'LSQ12egf','LSQ',342.308791666667,1.7425,NULL,NULL,'2012-08-28 06:28:24',56167.2697299998,18.9975,0.0799,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_54373.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(1250,557,0,'LSQ12ege','LSQ',252.715916666667,2.8745,NULL,NULL,'2012-08-27 23:38:23',56166.9849999999,18.6271,0.0988,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_snap_54392.gif',55981393928,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,874709280,13667332,NULL,NULL,NULL,NULL),(1251,557,0,'LSQ12ege','LSQ',252.715916666667,2.87458333333333,NULL,NULL,'2012-08-28 01:01:58',56167.0430399999,18.8664,0.1149,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_snap_54393.gif',55981393928,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,874709280,13667332,NULL,NULL,NULL,NULL),(1252,571,0,'LSQ12ehj','LSQ',347.315666666667,7.04827777777778,NULL,NULL,'2012-08-28 04:33:09',56167.1896899999,18.6118,0.0692,'gr-LSQ',NULL,NULL,'AGN',NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_snap_54377.gif',51719133726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,808111464,12626741,NULL,NULL,NULL,NULL),(1253,571,0,'LSQ12ehj','LSQ',347.315625,7.04827777777778,NULL,NULL,'2012-08-28 06:33:28',56167.2732500001,18.5484,0.0726,'gr-LSQ',NULL,NULL,'AGN',NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_snap_54378.gif',51719133726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,808111464,12626741,NULL,NULL,NULL,NULL),(1254,1118,0,'LSQ12egy','LSQ',359.941458333333,-6.35227777777778,NULL,NULL,'2012-08-28 05:49:56',56167.2430199999,19.5661,0.1395,'gr-LSQ',NULL,NULL,'II',NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_snap_54362.gif',49430463909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772350998,12067984,NULL,NULL,NULL,NULL),(1255,1118,0,'LSQ12egy','LSQ',359.941416666667,-6.35225,NULL,NULL,'2012-08-28 07:51:48',56167.3276499999,19.4478,0.1882,'gr-LSQ',NULL,NULL,'II',NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_snap_54363.gif',49430463909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772350998,12067984,NULL,NULL,NULL,NULL),(1256,611,0,'LSQ12eid','LSQ',4.40816666666667,-5.38286111111111,NULL,NULL,'2012-08-28 05:55:12',56167.2466699998,18.8611,0.0665,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_snap_54147.gif',34413529726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537711401,8401740,NULL,NULL,NULL,NULL),(1257,611,0,'LSQ12eid','LSQ',4.408375,-5.38275,NULL,NULL,'2012-08-28 07:58:02',56167.3319700002,18.7324,0.055,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_snap_54148.gif',34413529726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537711401,8401740,NULL,NULL,NULL,NULL),(1258,617,0,'LSQ12eib','LSQ',8.041,-7.3815,NULL,NULL,'2012-08-28 08:03:07',56167.3355,19.8139,0.1395,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_snap_54144.gif',34627856184,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,541060252,8454066,NULL,NULL,NULL,NULL),(1259,623,0,'LSQ12ehw','LSQ',357.061833333333,-7.17163888888889,NULL,NULL,'2012-08-28 05:43:10',56167.23832,19.6559,0.1496,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehw/LSQ12ehw_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehw/LSQ12ehw_snap_54167.gif',49435432346,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772428630,12069197,NULL,NULL,NULL,NULL),(1260,623,0,'LSQ12ehw','LSQ',357.061875,-7.17172222222222,NULL,NULL,'2012-08-28 07:45:03',56167.32296,20.08,0.1644,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehw/LSQ12ehw_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehw/LSQ12ehw_snap_54168.gif',49435432346,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772428630,12069197,NULL,NULL,NULL,NULL),(1261,646,0,'LSQ12eiq','LSQ',32.5294166666667,-5.57613888888889,NULL,NULL,'2012-08-28 07:07:59',56167.2972200001,18.9115,0.0611,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_snap_54204.gif',35142165909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549096342,8579630,NULL,NULL,NULL,NULL),(1262,646,0,'LSQ12eiq','LSQ',32.5295416666667,-5.57605555555556,NULL,NULL,'2012-08-28 08:45:42',56167.3650799999,18.9101,0.0485,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_snap_54205.gif',35142165909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549096342,8579630,NULL,NULL,NULL,NULL),(1263,697,0,'LSQ12eix','LSQ',40.2240833333333,-6.53883333333333,NULL,NULL,'2012-08-28 07:41:14',56167.3203099999,19.4963,0.151,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_54194.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(1264,697,0,'LSQ12eix','LSQ',40.224125,-6.53880555555556,NULL,NULL,'2012-08-28 08:54:41',56167.3713099998,19.5292,0.1325,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_54195.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(1265,722,0,'LSQ12eir','LSQ',34.10075,-3.01947222222222,NULL,NULL,'2012-08-28 07:09:40',56167.2983900001,19.6105,0.1734,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_snap_54208.gif',35133634952,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,548963046,8577547,NULL,NULL,NULL,NULL),(1266,722,0,'LSQ12eir','LSQ',34.10075,-3.01944444444444,NULL,NULL,'2012-08-28 08:44:00',56167.3639000002,18.9808,0.1105,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_snap_54209.gif',35133634952,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,548963046,8577547,NULL,NULL,NULL,NULL),(1267,726,0,'LSQ12eil','LSQ',1.672875,-6.28086111111111,NULL,NULL,'2012-08-28 05:49:56',56167.2430199999,19.5448,0.1581,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eil/LSQ12eil_history.html','sne - young ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eil/LSQ12eil_snap_54200.gif',34387815364,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537309615,8395462,NULL,NULL,NULL,NULL),(1268,726,0,'LSQ12eil','LSQ',1.67270833333333,-6.28083333333333,NULL,NULL,'2012-08-28 07:51:48',56167.3276499999,19.8139,0.1981,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eil/LSQ12eil_history.html','sne - young ?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eil/LSQ12eil_snap_54201.gif',34387815364,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537309615,8395462,NULL,NULL,NULL,NULL),(1269,771,0,'LSQ12ejr','LSQ',351.924791666667,-5.09005555555555,NULL,NULL,'2012-08-28 05:29:18',56167.2286899998,18.2083,0.1359,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejr/LSQ12ejr_snap_54285.gif',49638300038,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775598438,12118725,NULL,NULL,NULL,NULL),(1270,826,0,'LSQ12eju','LSQ',350.748791666667,-7.43338888888889,NULL,NULL,'2012-08-28 05:29:18',56167.2286899998,19.5471,0.1756,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_54294.gif',49649863587,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(1271,826,0,'LSQ12eju','LSQ',350.748833333333,-7.43327777777778,NULL,NULL,'2012-08-28 07:30:19',56167.3127199998,19.8477,0.1517,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_54295.gif',49649863586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(1272,858,0,'LSQ12eks','LSQ',345.267375,-6.69516666666667,NULL,NULL,'2012-08-28 04:55:32',56167.20524,19.0096,0.0828,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eks/LSQ12eks_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eks/LSQ12eks_snap_54302.gif',49487173961,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773237093,12081829,NULL,NULL,NULL,NULL),(1273,858,0,'LSQ12eks','LSQ',345.267416666667,-6.69516666666667,NULL,NULL,'2012-08-28 06:55:50',56167.2887800001,19.1788,0.0988,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eks/LSQ12eks_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eks/LSQ12eks_snap_54303.gif',49487173961,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773237093,12081829,NULL,NULL,NULL,NULL),(1274,861,0,'LSQ12ekr','LSQ',344.37975,-6.24488888888889,NULL,NULL,'2012-08-28 04:53:49',56167.2040499998,19.9233,0.1901,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2019-08-21 00:25:10','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_54304.gif',49488043315,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(1275,861,0,'LSQ12ekr','LSQ',344.37975,-6.24491666666667,NULL,NULL,'2012-08-28 06:54:08',56167.2875999999,19.9253,0.1417,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2019-08-21 00:25:10','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_54305.gif',49488043315,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(1276,915,0,'LSQ12elk','LSQ',31.3318333333333,-5.97238888888889,NULL,NULL,'2012-08-28 07:09:40',56167.2983900001,19.4279,0.1257,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_snap_54330.gif',35137599396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(1277,915,0,'LSQ12elk','LSQ',31.3318333333333,-5.97230555555556,NULL,NULL,'2012-08-28 08:44:00',56167.3639000002,19.4652,0.073,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_snap_54331.gif',35137599396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(1278,921,0,'LSQ12elj','LSQ',31.0349583333333,-4.82058333333333,NULL,NULL,'2012-08-28 08:44:00',56167.3639000002,20.3675,0.1225,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_history.html','sne?',NULL,0.0829,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elj/LSQ12elj_snap_54332.gif',35139786209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,549059159,8579049,NULL,NULL,NULL,NULL),(1279,934,0,'LSQ12eli','LSQ',51.1983333333333,-6.86369444444444,NULL,NULL,'2012-08-28 08:08:37',56167.3393199998,19.3749,0.1936,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eli/LSQ12eli_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eli/LSQ12eli_snap_54328.gif',36804372252,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,575068316,8985442,NULL,NULL,NULL,NULL),(1280,934,0,'LSQ12eli','LSQ',51.1981666666667,-6.86366666666667,NULL,NULL,'2012-08-28 09:11:23',56167.3829100002,19.2209,0.1471,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eli/LSQ12eli_history.html','hostless sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eli/LSQ12eli_snap_54329.gif',36804372250,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,575068316,8985442,NULL,NULL,NULL,NULL),(1281,947,0,'LSQ12ele','LSQ',62.697625,-7.07022222222222,NULL,NULL,'2012-08-28 09:18:07',56167.3875899999,20.0389,0.1277,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ele/LSQ12ele_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ele/LSQ12ele_snap_54333.gif',36955954125,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,577436783,9022449,NULL,NULL,NULL,NULL),(1282,1026,0,'LSQ12elz','LSQ',329.397708333333,-0.839194444444444,NULL,NULL,'2012-08-28 00:31:09',56167.0216399999,19.7529,0.2022,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_history.html','sne?',NULL,0.21853,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_snap_54170.gif',49826069800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778532340,12164567,NULL,NULL,NULL,NULL),(1283,1097,0,'LSQ12enc','LSQ',66.9710833333333,-3.19430555555556,NULL,NULL,'2012-08-28 08:31:39',56167.3553200001,19.1673,0.0954,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enc/LSQ12enc_history.html','sne??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enc/LSQ12enc_snap_54283.gif',36919366489,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,576865101,9013517,NULL,NULL,NULL,NULL),(1284,1097,0,'LSQ12enc','LSQ',66.9710416666667,-3.19436111111111,NULL,NULL,'2012-08-28 09:19:49',56167.3887700001,19.1746,0.0803,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enc/LSQ12enc_history.html','sne??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enc/LSQ12enc_snap_54284.gif',36919366489,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,576865101,9013517,NULL,NULL,NULL,NULL),(1285,1099,0,'LSQ12enb','LSQ',4.19729166666667,-0.644055555555555,NULL,NULL,'2012-08-28 09:32:17',56167.3974299999,18.7424,0.0572,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_history.html','agn?',NULL,0.06394,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_snap_54227.gif',34371929527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537061398,8391584,NULL,NULL,NULL,NULL),(1286,1109,0,'LSQ12emx','LSQ',57.5730833333333,-5.23116666666667,NULL,NULL,'2012-08-28 09:16:26',56167.3864199999,18.5045,0.095,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 03:45:40','2012-08-29 03:45:40','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emx/LSQ12emx_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emx/LSQ12emx_snap_54296.gif',37007224837,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,578237888,9034967,NULL,NULL,NULL,NULL),(1287,1287,1,'LSQ12erd','LSQ',10.60625,0.864694444444444,NULL,NULL,'2012-08-28 09:05:56',56167.3791299998,19.4802,0.1313,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erd/LSQ12erd_history.html','sne?',NULL,0.16679,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erd/LSQ12erd_snap_54605.gif',66807779648,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,1043871557,16310493,NULL,NULL,NULL,NULL),(1288,1287,0,'LSQ12erd','LSQ',10.606125,0.864777777777778,NULL,NULL,'2012-08-28 09:39:03',56167.4021200002,19.9384,0.1653,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erd/LSQ12erd_history.html','sne?',NULL,0.16679,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erd/LSQ12erd_snap_54606.gif',66807779648,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,1043871557,16310493,NULL,NULL,NULL,NULL),(1289,1289,1,'LSQ12erc','LSQ',8.771125,1.48155555555556,NULL,NULL,'2012-08-04 08:53:52',56143.3707499998,19.3985,0.1634,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_snap_54687.gif',66590313565,NULL,NULL,NULL,'2012-07-31 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1040473649,16257400,NULL,NULL,NULL,NULL),(1290,1289,0,'LSQ12erc','LSQ',8.77129166666667,1.48144444444444,NULL,NULL,'2012-08-08 09:44:34',56147.40595,19.8754,0.1479,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_snap_54688.gif',66590313565,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1040473649,16257400,NULL,NULL,NULL,NULL),(1291,1289,0,'LSQ12erc','LSQ',8.77120833333333,1.48161111111111,NULL,NULL,'2012-08-08 10:20:40',56147.4310300001,19.3192,0.1234,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_snap_54689.gif',66590313565,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1040473649,16257400,NULL,NULL,NULL,NULL),(1292,1289,0,'LSQ12erc','LSQ',8.77091666666667,1.48147222222222,NULL,NULL,'2012-08-10 10:07:27',56149.42185,20.2439,0.1642,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_snap_54690.gif',66590313561,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1040473649,16257400,NULL,NULL,NULL,NULL),(1293,1289,0,'LSQ12erc','LSQ',8.771,1.48144444444444,NULL,NULL,'2012-08-28 09:00:10',56167.37512,20.3742,0.1626,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_snap_54603.gif',66590313561,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1040473649,16257400,NULL,NULL,NULL,NULL),(1294,1289,0,'LSQ12erc','LSQ',8.77104166666667,1.48141666666667,NULL,NULL,'2012-08-28 09:33:59',56167.3986,19.6311,0.1077,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_snap_54604.gif',66590313561,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1040473649,16257400,NULL,NULL,NULL,NULL),(1295,1295,1,'LSQ12era','LSQ',324.270583333333,0.478972222222222,NULL,NULL,'2012-08-28 00:15:34',56167.01082,17.3558,0.0578,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12era/LSQ12era_history.html','sne?',NULL,0.05021,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12era/LSQ12era_snap_54599.gif',52096398906,NULL,NULL,NULL,'2012-08-22 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814006232,12718847,NULL,NULL,NULL,NULL),(1296,1295,0,'LSQ12era','LSQ',324.270583333333,0.479,NULL,NULL,'2012-08-28 02:14:51',56167.0936500002,17.3624,0.0586,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12era/LSQ12era_history.html','sne?',NULL,0.05021,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12era/LSQ12era_snap_54600.gif',52096398906,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814006232,12718847,NULL,NULL,NULL,NULL),(1297,1297,1,'LSQ12eqy','LSQ',328.247125,0.566916666666667,NULL,NULL,'2012-08-06 02:00:19',56145.0835600002,18.0055,0.0828,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqy/LSQ12eqy_history.html','sne?',NULL,0.07381,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqy/LSQ12eqy_snap_54680.gif',52178899047,NULL,NULL,NULL,'2012-07-29 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,815295297,12738989,NULL,NULL,NULL,NULL),(1298,1297,0,'LSQ12eqy','LSQ',328.247416666667,0.567194444444444,NULL,NULL,'2012-08-28 00:31:09',56167.0216399999,18.9537,0.141,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqy/LSQ12eqy_history.html','sne?',NULL,0.07381,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqy/LSQ12eqy_snap_54593.gif',52178899046,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,815295297,12738989,NULL,NULL,NULL,NULL),(1299,1297,0,'LSQ12eqy','LSQ',328.247375,0.567111111111111,NULL,NULL,'2012-08-28 02:31:56',56167.1055200002,18.1713,0.1251,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqy/LSQ12eqy_history.html','sne?',NULL,0.07381,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqy/LSQ12eqy_snap_54594.gif',52178899046,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,815295297,12738989,NULL,NULL,NULL,NULL),(1300,1300,1,'LSQ12eqw','LSQ',331.09925,-1.79319444444444,NULL,NULL,'2012-08-08 02:11:49',56147.09155,20.4673,0.1282,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqw/LSQ12eqw_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqw/LSQ12eqw_snap_54670.gif',49822866147,NULL,NULL,NULL,'2012-08-06 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,778482283,12163785,NULL,NULL,NULL,NULL),(1301,1300,0,'LSQ12eqw','LSQ',331.099291666667,-1.79302777777778,NULL,NULL,'2012-08-08 04:14:51',56147.1769900001,19.758,0.1029,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqw/LSQ12eqw_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqw/LSQ12eqw_snap_54671.gif',49822866145,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,778482283,12163785,NULL,NULL,NULL,NULL),(1302,1300,0,'LSQ12eqw','LSQ',331.099208333333,-1.79316666666667,NULL,NULL,'2012-08-10 02:04:33',56149.0865000002,20.3958,0.1374,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqw/LSQ12eqw_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqw/LSQ12eqw_snap_54672.gif',49822866147,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,778482283,12163785,NULL,NULL,NULL,NULL),(1303,1300,0,'LSQ12eqw','LSQ',331.099,-1.79308333333333,NULL,NULL,'2012-08-22 02:55:46',56161.12207,20.1278,0.0784,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqw/LSQ12eqw_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqw/LSQ12eqw_snap_54673.gif',49822866147,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,778482283,12163785,NULL,NULL,NULL,NULL),(1304,1300,0,'LSQ12eqw','LSQ',331.098958333333,-1.79291666666667,NULL,NULL,'2012-08-22 05:46:39',56161.2407399998,20.3939,0.1065,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqw/LSQ12eqw_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqw/LSQ12eqw_snap_54674.gif',49822866147,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,778482283,12163785,NULL,NULL,NULL,NULL),(1305,1300,0,'LSQ12eqw','LSQ',331.09925,-1.79325,NULL,NULL,'2012-08-28 00:52:11',56167.0362399998,19.5523,0.1444,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqw/LSQ12eqw_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqw/LSQ12eqw_snap_54589.gif',49822866147,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,778482283,12163785,NULL,NULL,NULL,NULL),(1306,1300,0,'LSQ12eqw','LSQ',331.099333333333,-1.79305555555556,NULL,NULL,'2012-08-28 02:57:02',56167.1229400001,19.9168,0.1519,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqw/LSQ12eqw_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqw/LSQ12eqw_snap_54590.gif',49822866145,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,778482283,12163785,NULL,NULL,NULL,NULL),(1307,1307,1,'LSQ12eqv','LSQ',338.3895,-1.16272222222222,NULL,NULL,'2012-08-23 03:34:44',56162.1491299998,18.5039,0.0365,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqv/LSQ12eqv_history.html','sne',NULL,0.05648,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqv/LSQ12eqv_snap_54669.gif',50332414104,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,786443970,12288187,NULL,NULL,NULL,NULL),(1308,1307,0,'LSQ12eqv','LSQ',338.389708333333,-1.16269444444444,NULL,NULL,'2012-08-28 01:29:20',56167.0620400002,18.0517,0.0619,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqv/LSQ12eqv_history.html','sne',NULL,0.05648,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqv/LSQ12eqv_snap_54587.gif',50332414136,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,786443970,12288187,NULL,NULL,NULL,NULL),(1309,1307,0,'LSQ12eqv','LSQ',338.38975,-1.16266666666667,NULL,NULL,'2012-08-28 03:29:32',56167.1455100002,17.9558,0.0455,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqv/LSQ12eqv_history.html','sne',NULL,0.05648,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqv/LSQ12eqv_snap_54588.gif',50332414136,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,786443970,12288187,NULL,NULL,NULL,NULL),(1310,1310,1,'LSQ12eqs','LSQ',346.33325,3.24355555555556,NULL,NULL,'2012-08-19 02:48:45',56158.1171900001,19.7482,0.0649,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqs/LSQ12eqs_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqs/LSQ12eqs_snap_54627.gif',51696025755,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,807750402,12621100,NULL,NULL,NULL,NULL),(1311,1310,0,'LSQ12eqs','LSQ',346.33325,3.24355555555556,NULL,NULL,'2012-08-19 08:11:04',56158.3410299998,19.6653,0.0566,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqs/LSQ12eqs_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqs/LSQ12eqs_snap_54628.gif',51696025755,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,807750402,12621100,NULL,NULL,NULL,NULL),(1312,1310,0,'LSQ12eqs','LSQ',346.333208333333,3.24358333333333,NULL,NULL,'2012-08-28 04:45:01',56167.1979299998,18.9803,0.0894,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqs/LSQ12eqs_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqs/LSQ12eqs_snap_54581.gif',51696025755,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,807750402,12621100,NULL,NULL,NULL,NULL),(1313,1310,0,'LSQ12eqs','LSQ',346.333291666667,3.24358333333333,NULL,NULL,'2012-08-28 06:45:25',56167.2815399999,19.067,0.089,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqs/LSQ12eqs_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqs/LSQ12eqs_snap_54582.gif',51696025755,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,807750402,12621100,NULL,NULL,NULL,NULL),(1314,1314,1,'LSQ12eql','LSQ',63.2167083333333,-7.00136111111111,NULL,NULL,'2011-12-15 01:34:16',55910.0654699998,20.4111,0.1633,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eql/LSQ12eql_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eql/LSQ12eql_snap_54666.gif',36954694319,NULL,NULL,NULL,'2011-12-14 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,577417098,9022142,NULL,NULL,NULL,NULL),(1315,1314,0,'LSQ12eql','LSQ',63.2165416666667,-7.00147222222222,NULL,NULL,'2011-12-15 03:36:44',55910.1505100001,20.5755,0.2007,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eql/LSQ12eql_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eql/LSQ12eql_snap_54667.gif',36954694319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,577417098,9022142,NULL,NULL,NULL,NULL),(1316,1314,0,'LSQ12eql','LSQ',63.2165833333333,-7.00127777777778,NULL,NULL,'2012-08-26 09:35:52',56165.3999100002,20.7672,0.2012,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eql/LSQ12eql_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eql/LSQ12eql_snap_54668.gif',36954694319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,577417098,9022142,NULL,NULL,NULL,NULL),(1317,1314,0,'LSQ12eql','LSQ',63.2165,-7.00122222222222,NULL,NULL,'2012-08-28 08:29:56',56167.3541299999,20.0107,0.1559,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eql/LSQ12eql_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eql/LSQ12eql_snap_54567.gif',36954694319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,577417098,9022142,NULL,NULL,NULL,NULL),(1318,1314,0,'LSQ12eql','LSQ',63.2160833333333,-7.00127777777778,NULL,NULL,'2012-08-28 09:24:53',56167.3922899999,20.3658,0.1547,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eql/LSQ12eql_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eql/LSQ12eql_snap_54568.gif',36954694318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,577417098,9022142,NULL,NULL,NULL,NULL),(1319,1319,1,'LSQ12eqi','LSQ',13.3140416666667,-3.55155555555556,NULL,NULL,'2012-08-10 06:40:01',56149.2777999998,21.1962,0.1316,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqi/LSQ12eqi_history.html','sn?',NULL,0.051639,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqi/LSQ12eqi_snap_54656.gif',34516868825,NULL,NULL,NULL,'2012-08-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,539326075,8426969,NULL,NULL,NULL,NULL),(1320,1319,0,'LSQ12eqi','LSQ',13.3137083333333,-3.5515,NULL,NULL,'2012-08-10 08:33:58',56149.3569299998,21.576,0.1673,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqi/LSQ12eqi_history.html','sn?',NULL,0.051639,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqi/LSQ12eqi_snap_54657.gif',34516868825,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,539326075,8426969,NULL,NULL,NULL,NULL),(1321,1319,0,'LSQ12eqi','LSQ',13.314125,-3.55138888888889,NULL,NULL,'2012-08-20 09:33:08',56159.3980100001,19.8175,0.0393,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqi/LSQ12eqi_history.html','sn?',NULL,0.051639,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqi/LSQ12eqi_snap_54658.gif',34516868825,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,539326075,8426969,NULL,NULL,NULL,NULL),(1322,1319,0,'LSQ12eqi','LSQ',13.3141666666667,-3.55133333333333,NULL,NULL,'2012-08-26 08:18:48',56165.3463900001,20.9871,0.1178,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqi/LSQ12eqi_history.html','sn?',NULL,0.051639,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqi/LSQ12eqi_snap_54659.gif',34516868825,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,539326075,8426969,NULL,NULL,NULL,NULL),(1323,1319,0,'LSQ12eqi','LSQ',13.314125,-3.5515,NULL,NULL,'2012-08-28 06:12:31',56167.2587000001,20.0192,0.0901,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqi/LSQ12eqi_history.html','sn?',NULL,0.051639,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqi/LSQ12eqi_snap_54561.gif',34516868825,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,539326075,8426969,NULL,NULL,NULL,NULL),(1324,1319,0,'LSQ12eqi','LSQ',13.313875,-3.55133333333333,NULL,NULL,'2012-08-28 08:12:29',56167.3420099998,19.1172,0.0455,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-29 21:45:37','2012-08-29 21:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqi/LSQ12eqi_history.html','sn?',NULL,0.051639,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqi/LSQ12eqi_snap_54562.gif',34516868825,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,539326075,8426969,NULL,NULL,NULL,NULL),(1325,573,0,'LSQ12ehn','LSQ',53.811,-18.4273888888889,NULL,NULL,'2012-08-29 07:39:20',56168.3189900001,20.0704,0.1443,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_history.html','variable or unusual',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_snap_54711.gif',38005697462,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,593839022,9278734,NULL,NULL,NULL,NULL),(1326,573,0,'LSQ12ehn','LSQ',53.8110416666667,-18.4274166666667,NULL,NULL,'2012-08-29 09:40:31',56168.4031400001,19.9874,0.0786,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_history.html','variable or unusual',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehn/LSQ12ehn_snap_54712.gif',38005697462,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,593839022,9278734,NULL,NULL,NULL,NULL),(1327,581,0,'LSQ12ehl','LSQ',72.52775,-21.77525,NULL,NULL,'2012-08-29 07:30:37',56168.31293,18.6793,0.1208,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_history.html','sne???',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_snap_54697.gif',37345461187,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,583522831,9117544,NULL,NULL,NULL,NULL),(1328,581,0,'LSQ12ehl','LSQ',72.5277083333333,-21.77525,NULL,NULL,'2012-08-29 08:51:02',56168.3687800001,19.0975,0.0812,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_history.html','sne???',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehl/LSQ12ehl_snap_54698.gif',37345461187,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,583522831,9117544,NULL,NULL,NULL,NULL),(1329,989,0,'LSQ12elu','LSQ',70.4355833333333,-22.9940555555556,NULL,NULL,'2012-08-29 06:59:32',56168.2913500001,19.2171,0.1796,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2019-09-06 21:34:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_snap_54763.gif',37338457798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,583413403,9115834,NULL,NULL,NULL,NULL),(1330,989,0,'LSQ12elu','LSQ',70.4355833333333,-22.9941111111111,NULL,NULL,'2012-08-29 08:33:44',56168.35677,19.2671,0.1618,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2019-09-06 21:34:20','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elu/LSQ12elu_snap_54764.gif',37338457798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,583413403,9115834,NULL,NULL,NULL,NULL),(1331,1060,0,'LSQ12emi','LSQ',75.0574166666667,-22.1881388888889,NULL,NULL,'2012-08-29 07:30:37',56168.31293,19.1668,0.1866,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emi/LSQ12emi_history.html','sne-nice!',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emi/LSQ12emi_snap_54723.gif',37549808027,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,586715750,9167433,NULL,NULL,NULL,NULL),(1332,1060,0,'LSQ12emi','LSQ',75.0574166666667,-22.1881388888889,NULL,NULL,'2012-08-29 08:51:02',56168.3687800001,19.5325,0.1251,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emi/LSQ12emi_history.html','sne-nice!',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12emi/LSQ12emi_snap_54724.gif',37549808027,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,586715750,9167433,NULL,NULL,NULL,NULL),(1333,1168,0,'LSQ12epc','LSQ',68.1963333333333,-16.4376666666667,NULL,NULL,'2012-08-29 07:52:52',56168.3283799998,18.3151,0.0899,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epc/LSQ12epc_history.html','sne-very nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epc/LSQ12epc_snap_54759.gif',37355834039,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583684906,9120076,NULL,NULL,NULL,NULL),(1334,1168,0,'LSQ12epc','LSQ',68.1963333333333,-16.4376666666667,NULL,NULL,'2012-08-29 08:59:33',56168.37469,18.4292,0.0672,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epc/LSQ12epc_history.html','sne-very nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epc/LSQ12epc_snap_54760.gif',37355834039,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583684906,9120076,NULL,NULL,NULL,NULL),(1335,1174,0,'LSQ12eor','LSQ',57.7149583333333,-16.9243333333333,NULL,NULL,'2012-08-29 07:41:01',56168.3201600001,18.5871,0.1164,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eor/LSQ12eor_history.html','sn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eor/LSQ12eor_snap_54773.gif',36881294756,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,576270230,9004222,NULL,NULL,NULL,NULL),(1336,1174,0,'LSQ12eor','LSQ',57.715,-16.9243888888889,NULL,NULL,'2012-08-29 08:54:28',56168.3711600001,18.2493,0.0975,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eor/LSQ12eor_history.html','sn',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eor/LSQ12eor_snap_54774.gif',36881294756,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,576270230,9004222,NULL,NULL,NULL,NULL),(1337,1185,0,'LSQ12eom','LSQ',28.250125,-18.1509444444444,NULL,NULL,'2012-08-29 04:34:26',56168.1905800002,19.8371,0.1944,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eom/LSQ12eom_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eom/LSQ12eom_snap_54804.gif',35086441365,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,548225646,8566025,NULL,NULL,NULL,NULL),(1338,1187,0,'LSQ12eok','LSQ',28.2187916666667,-18.1270277777778,NULL,NULL,'2012-08-29 04:32:44',56168.1894,17.6333,0.0442,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_snap_54801.gif',35086449258,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,548225769,8566027,NULL,NULL,NULL,NULL),(1339,1187,0,'LSQ12eok','LSQ',28.219,-18.127,NULL,NULL,'2012-08-29 06:31:45',56168.2720499998,17.6782,0.0729,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eok/LSQ12eok_snap_54802.gif',35086449258,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,548225769,8566027,NULL,NULL,NULL,NULL),(1340,1216,0,'LSQ12ens','LSQ',79.1612083333333,-25.0617777777778,NULL,NULL,'2012-08-29 09:45:45',56168.4067799998,19.7135,0.1329,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ens/LSQ12ens_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ens/LSQ12ens_snap_54787.gif',37131980291,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,580187192,9065424,NULL,NULL,NULL,NULL),(1341,1218,0,'LSQ12enp','LSQ',80.7666666666667,-24.2646111111111,NULL,NULL,'2012-08-29 07:33:59',56168.3152700001,19.4998,0.1672,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enp/LSQ12enp_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enp/LSQ12enp_snap_54753.gif',37141750864,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,580339857,9067810,NULL,NULL,NULL,NULL),(1342,1220,0,'LSQ12eno','LSQ',74.4075416666667,-25.1767777777778,NULL,NULL,'2012-08-29 08:52:45',56168.3699699999,19.6795,0.1468,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eno/LSQ12eno_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eno/LSQ12eno_snap_54788.gif',37227330578,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,581677040,9088703,NULL,NULL,NULL,NULL),(1343,1224,0,'LSQ12enl','LSQ',74.9237083333333,-24.25,NULL,NULL,'2012-08-29 07:30:37',56168.31293,18.538,0.1298,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enl/LSQ12enl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enl/LSQ12enl_snap_54752.gif',37213664024,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,581463500,9085367,NULL,NULL,NULL,NULL),(1344,1228,0,'LSQ12enj','LSQ',70.6392916666667,-24.0433333333333,NULL,NULL,'2012-08-29 08:33:44',56168.35677,19.1746,0.1949,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enj/LSQ12enj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enj/LSQ12enj_snap_54783.gif',37337805598,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583403212,9115675,NULL,NULL,NULL,NULL),(1345,1240,0,'LSQ12epy','LSQ',339.396833333333,-18.3270833333333,NULL,NULL,'2012-08-29 02:50:20',56168.1182900001,19.4623,0.1531,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 05:45:36','2012-08-30 05:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epy/LSQ12epy_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epy/LSQ12epy_snap_54779.gif',50251458903,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785179045,12268422,NULL,NULL,NULL,NULL),(1346,1346,1,'LSQ12err','LSQ',348.143791666667,-22.1853611111111,NULL,NULL,'2012-07-01 07:01:37',56109.2927899999,19.4626,0.1492,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 17:45:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12err/LSQ12err_history.html','sne?',NULL,0.110973,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12err/LSQ12err_snap_54921.gif',50300863986,NULL,NULL,NULL,'2012-06-23 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785950999,12280484,NULL,NULL,NULL,NULL),(1347,1346,0,'LSQ12err','LSQ',348.143208333333,-22.1851111111111,NULL,NULL,'2012-08-01 03:00:36',56140.1254199999,18.4325,0.1806,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 17:45:36','2012-08-30 17:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12err/LSQ12err_history.html','sne?',NULL,0.110973,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12err/LSQ12err_snap_54922.gif',50300863986,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785950999,12280484,NULL,NULL,NULL,NULL),(1348,1346,0,'LSQ12err','LSQ',348.143166666667,-22.1854166666667,NULL,NULL,'2012-08-07 03:53:40',56146.1622799998,20.1374,0.1531,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 17:45:36','2012-08-30 17:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12err/LSQ12err_history.html','sne?',NULL,0.110973,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12err/LSQ12err_snap_54923.gif',50300863986,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785950999,12280484,NULL,NULL,NULL,NULL),(1349,1346,0,'LSQ12err','LSQ',348.143458333333,-22.1851666666667,NULL,NULL,'2012-08-29 01:05:37',56168.0455700001,17.6113,0.137,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 17:45:36','2012-08-30 17:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12err/LSQ12err_history.html','sne?',NULL,0.110973,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12err/LSQ12err_snap_54855.gif',50300863986,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785950999,12280484,NULL,NULL,NULL,NULL),(1350,1346,0,'LSQ12err','LSQ',348.143666666667,-22.1854166666667,NULL,NULL,'2012-08-29 03:08:57',56168.1312199999,18.3883,0.1273,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 17:45:36','2012-08-30 17:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12err/LSQ12err_history.html','sne?',NULL,0.110973,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12err/LSQ12err_snap_54856.gif',50300863987,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785950999,12280484,NULL,NULL,NULL,NULL),(1351,1351,1,'LSQ12erp','LSQ',347.613333333333,-22.173,NULL,NULL,'2012-08-27 04:20:34',56166.18095,19.7529,0.1408,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 17:45:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erp/LSQ12erp_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erp/LSQ12erp_snap_54919.gif',50300580081,NULL,NULL,NULL,'2012-08-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785946563,12280415,NULL,NULL,NULL,NULL),(1352,1351,0,'LSQ12erp','LSQ',347.613083333333,-22.1729722222222,NULL,NULL,'2012-08-27 06:22:28',56166.2656100001,19.7682,0.1858,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 17:45:36','2012-08-30 17:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erp/LSQ12erp_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erp/LSQ12erp_snap_54920.gif',50300580081,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785946563,12280415,NULL,NULL,NULL,NULL),(1353,1351,0,'LSQ12erp','LSQ',347.613083333333,-22.173,NULL,NULL,'2012-08-29 01:03:54',56168.0443799999,18.6771,0.1191,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 17:45:36','2012-08-30 17:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erp/LSQ12erp_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erp/LSQ12erp_snap_54851.gif',50300580081,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785946563,12280415,NULL,NULL,NULL,NULL),(1354,1351,0,'LSQ12erp','LSQ',347.613041666667,-22.1730277777778,NULL,NULL,'2012-08-29 03:07:14',56168.1300300001,17.7013,0.1062,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 17:45:36','2012-08-30 17:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erp/LSQ12erp_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erp/LSQ12erp_snap_54852.gif',50300580081,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785946563,12280415,NULL,NULL,NULL,NULL),(1355,1355,1,'LSQ12erl','LSQ',328.12325,-22.1982222222222,NULL,NULL,'2012-08-01 02:12:00',56140.09167,17.7884,0.1361,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 17:45:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erl/LSQ12erl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erl/LSQ12erl_snap_54899.gif',50881760614,NULL,NULL,NULL,'2012-07-30 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,795027509,12422304,NULL,NULL,NULL,NULL),(1356,1355,0,'LSQ12erl','LSQ',328.123291666667,-22.1981111111111,NULL,NULL,'2012-08-28 23:59:22',56167.99957,17.3716,0.1446,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 17:45:36','2012-08-30 17:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erl/LSQ12erl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erl/LSQ12erl_snap_54843.gif',50881760614,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,795027509,12422304,NULL,NULL,NULL,NULL),(1357,1355,0,'LSQ12erl','LSQ',328.123458333333,-22.1983055555556,NULL,NULL,'2012-08-29 02:01:16',56168.0842200001,17.7014,0.1107,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 17:45:36','2012-08-30 17:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erl/LSQ12erl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erl/LSQ12erl_snap_54844.gif',50881760614,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,795027509,12422304,NULL,NULL,NULL,NULL),(1358,1358,1,'LSQ12esf','LSQ',66.69975,-19.8695833333333,NULL,NULL,'2012-08-27 08:50:23',56166.36833,18.3924,0.0278,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esf/LSQ12esf_history.html','sne-nice',NULL,0.033306,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esf/LSQ12esf_snap_54945.gif',37368917072,NULL,NULL,NULL,'2012-08-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583889329,9123270,NULL,NULL,NULL,NULL),(1359,1358,0,'LSQ12esf','LSQ',66.69975,-19.8695833333333,NULL,NULL,'2012-08-27 09:29:52',56166.3957500001,18.5045,0.0292,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2012-08-30 18:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esf/LSQ12esf_history.html','sne-nice',NULL,0.033306,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esf/LSQ12esf_snap_54946.gif',37368917072,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583889329,9123270,NULL,NULL,NULL,NULL),(1360,1358,0,'LSQ12esf','LSQ',66.69975,-19.8695555555556,NULL,NULL,'2012-08-29 07:52:52',56168.3283799998,18.366,0.0753,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2012-08-30 18:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esf/LSQ12esf_history.html','sne-nice',NULL,0.033306,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esf/LSQ12esf_snap_54883.gif',37368917072,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583889329,9123270,NULL,NULL,NULL,NULL),(1361,1358,0,'LSQ12esf','LSQ',66.6997916666667,-19.8695833333333,NULL,NULL,'2012-08-29 08:59:33',56168.37469,18.297,0.0786,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2012-08-30 18:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esf/LSQ12esf_history.html','sne-nice',NULL,0.033306,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esf/LSQ12esf_snap_54884.gif',37368917072,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583889329,9123270,NULL,NULL,NULL,NULL),(1362,1362,1,'LSQ12esc','LSQ',65.5290833333333,-17.1624444444444,NULL,NULL,'2012-08-27 08:45:21',56166.3648299999,20.3336,0.1765,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esc/LSQ12esc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esc/LSQ12esc_snap_54942.gif',37354263475,NULL,NULL,NULL,'2012-08-09 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583660366,9119693,NULL,NULL,NULL,NULL),(1363,1362,0,'LSQ12esc','LSQ',65.5284166666667,-17.1625277777778,NULL,NULL,'2012-08-27 09:59:19',56166.4161999999,20.8527,0.1805,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2012-08-30 18:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esc/LSQ12esc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esc/LSQ12esc_snap_54943.gif',37354263475,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583660366,9119693,NULL,NULL,NULL,NULL),(1364,1362,0,'LSQ12esc','LSQ',65.5287083333333,-17.1625,NULL,NULL,'2012-08-29 07:47:47',56168.32485,19.9146,0.1367,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2012-08-30 18:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esc/LSQ12esc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esc/LSQ12esc_snap_54877.gif',37354263475,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583660366,9119693,NULL,NULL,NULL,NULL),(1365,1362,0,'LSQ12esc','LSQ',65.529,-17.1623611111111,NULL,NULL,'2012-08-29 09:38:47',56168.4019399998,20.2704,0.1518,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2012-08-30 18:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esc/LSQ12esc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esc/LSQ12esc_snap_54878.gif',37354263475,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,583660366,9119693,NULL,NULL,NULL,NULL),(1366,1366,1,'LSQ12esb','LSQ',60.7909583333333,-20.8234444444444,NULL,NULL,'2012-08-09 10:11:00',56148.4243100001,19.7081,0.0854,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esb/LSQ12esb_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esb/LSQ12esb_snap_54941.gif',36852253562,NULL,NULL,NULL,'2012-08-07 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,575816461,8997132,NULL,NULL,NULL,NULL),(1367,1366,0,'LSQ12esb','LSQ',60.7912916666667,-20.8235555555556,NULL,NULL,'2012-08-29 07:41:01',56168.3201600001,18.865,0.0734,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2012-08-30 18:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esb/LSQ12esb_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esb/LSQ12esb_snap_54875.gif',36852253509,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,575816461,8997132,NULL,NULL,NULL,NULL),(1368,1366,0,'LSQ12esb','LSQ',60.7914583333333,-20.8235833333333,NULL,NULL,'2012-08-29 08:54:28',56168.3711600001,19.2284,0.0754,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2012-08-30 18:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esb/LSQ12esb_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esb/LSQ12esb_snap_54876.gif',36852253516,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,575816461,8997132,NULL,NULL,NULL,NULL),(1369,1369,1,'LSQ12ery','LSQ',36.7847916666667,-17.1805277777778,NULL,NULL,'2012-08-27 08:07:35',56166.33861,20.8132,0.143,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ery/LSQ12ery_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ery/LSQ12ery_snap_54936.gif',37962960538,NULL,NULL,NULL,'2012-08-09 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,593171258,9268300,NULL,NULL,NULL,NULL),(1370,1369,0,'LSQ12ery','LSQ',36.7847083333333,-17.1806388888889,NULL,NULL,'2012-08-29 04:49:50',56168.2012800002,18.6884,0.1217,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2012-08-30 18:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ery/LSQ12ery_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ery/LSQ12ery_snap_54869.gif',37962960538,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,593171258,9268300,NULL,NULL,NULL,NULL),(1371,1369,0,'LSQ12ery','LSQ',36.7849166666667,-17.1805277777778,NULL,NULL,'2012-08-29 06:49:07',56168.2841099999,18.5976,0.1078,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2012-08-30 18:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ery/LSQ12ery_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ery/LSQ12ery_snap_54870.gif',37962960538,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,593171258,9268300,NULL,NULL,NULL,NULL),(1372,1372,1,'LSQ12eru','LSQ',350.361583333333,-22.1618055555556,NULL,NULL,'2012-08-27 06:30:55',56166.27147,19.7106,0.1241,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eru/LSQ12eru_history.html','sne?',NULL,0.086016,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eru/LSQ12eru_snap_54925.gif',50304911514,NULL,NULL,NULL,'2012-08-09 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,786014242,12281472,NULL,NULL,NULL,NULL),(1373,1372,0,'LSQ12eru','LSQ',350.361208333333,-22.1620277777778,NULL,NULL,'2012-08-29 01:26:10',56168.0598399998,18.5852,0.1307,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2012-08-30 18:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eru/LSQ12eru_history.html','sne?',NULL,0.086016,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eru/LSQ12eru_snap_54861.gif',50304911545,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,786014242,12281472,NULL,NULL,NULL,NULL),(1374,1372,0,'LSQ12eru','LSQ',350.36125,-22.1620833333333,NULL,NULL,'2012-08-29 03:26:01',56168.1430700002,18.4128,0.16,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2012-08-30 18:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eru/LSQ12eru_history.html','sne?',NULL,0.086016,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eru/LSQ12eru_snap_54862.gif',50304911545,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,786014242,12281472,NULL,NULL,NULL,NULL),(1375,1375,1,'LSQ12ers','LSQ',345.5155,-22.8755277777778,NULL,NULL,'2012-08-27 06:24:09',56166.2667800002,18.9932,0.0976,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ers/LSQ12ers_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ers/LSQ12ers_snap_54924.gif',50214718088,NULL,NULL,NULL,'2012-08-09 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,784604970,12259452,NULL,NULL,NULL,NULL),(1376,1375,0,'LSQ12ers','LSQ',345.515583333333,-22.8753888888889,NULL,NULL,'2012-08-29 01:05:37',56168.0455700001,18.1147,0.1225,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2012-08-30 18:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ers/LSQ12ers_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ers/LSQ12ers_snap_54857.gif',50214718088,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,784604970,12259452,NULL,NULL,NULL,NULL),(1377,1375,0,'LSQ12ers','LSQ',345.515541666667,-22.8755277777778,NULL,NULL,'2012-08-29 03:08:57',56168.1312199999,18.7291,0.1549,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-30 18:45:36','2012-08-30 18:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ers/LSQ12ers_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ers/LSQ12ers_snap_54858.gif',50214718088,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,784604970,12259452,NULL,NULL,NULL,NULL),(1378,544,0,'LSQ12egf','LSQ',342.308708333333,1.74255555555556,NULL,NULL,'2012-08-30 03:47:31',56169.1579999998,18.4368,0.0836,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egf/LSQ12egf_snap_55123.gif',51679416304,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807490879,12617044,NULL,NULL,NULL,NULL),(1379,557,0,'LSQ12ege','LSQ',252.715916666667,2.87447222222222,NULL,NULL,'2012-08-29 23:36:43',56168.9838399999,18.8558,0.1429,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ege/LSQ12ege_snap_55141.gif',55981393928,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,874709280,13667332,NULL,NULL,NULL,NULL),(1380,571,0,'LSQ12ehj','LSQ',347.315541666667,7.04827777777778,NULL,NULL,'2012-08-30 02:16:09',56169.09455,18.5955,0.1121,'gr-LSQ',NULL,NULL,'AGN',NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_snap_55127.gif',51719133726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,808111464,12626741,NULL,NULL,NULL,NULL),(1381,571,0,'LSQ12ehj','LSQ',347.315666666667,7.04827777777778,NULL,NULL,'2012-08-30 04:18:02',56169.1791900001,18.5069,0.0748,'gr-LSQ',NULL,NULL,'AGN',NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ehj/LSQ12ehj_snap_55128.gif',51719133726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,808111464,12626741,NULL,NULL,NULL,NULL),(1382,1118,0,'LSQ12egy','LSQ',359.9415,-6.35216666666667,NULL,NULL,'2012-08-30 07:32:24',56169.3141700001,19.4668,0.1618,'gr-LSQ',NULL,NULL,'II',NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egy/LSQ12egy_snap_55119.gif',49430463909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772350998,12067984,NULL,NULL,NULL,NULL),(1383,611,0,'LSQ12eid','LSQ',4.40825,-5.38272222222222,NULL,NULL,'2012-08-30 05:37:31',56169.2343899999,19.2703,0.2085,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_snap_54997.gif',34413529726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537711401,8401740,NULL,NULL,NULL,NULL),(1384,617,0,'LSQ12eib','LSQ',8.04091666666667,-7.3815,NULL,NULL,'2012-08-30 05:42:35',56169.2379100001,18.9828,0.1879,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eib/LSQ12eib_snap_54995.gif',34627856184,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,541060252,8454066,NULL,NULL,NULL,NULL),(1385,646,0,'LSQ12eiq','LSQ',32.529375,-5.57611111111111,NULL,NULL,'2012-08-30 06:01:11',56169.2508299998,18.9093,0.0865,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_snap_55022.gif',35142165909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549096342,8579630,NULL,NULL,NULL,NULL),(1386,697,0,'LSQ12eix','LSQ',40.224125,-6.53880555555556,NULL,NULL,'2012-08-30 06:09:44',56169.2567599998,19.6414,0.1711,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eix/LSQ12eix_snap_55026.gif',34934513405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,545851771,8528933,NULL,NULL,NULL,NULL),(1387,722,0,'LSQ12eir','LSQ',34.1007083333333,-3.01922222222222,NULL,NULL,'2012-08-30 08:02:50',56169.33531,19.4247,0.2034,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_history.html','sne or variable',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eir/LSQ12eir_snap_55024.gif',35133634996,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,548963046,8577547,NULL,NULL,NULL,NULL),(1388,858,0,'LSQ12eks','LSQ',345.267458333333,-6.69525,NULL,NULL,'2012-08-30 01:50:39',56169.0768499998,19.4077,0.1868,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eks/LSQ12eks_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eks/LSQ12eks_snap_55079.gif',49487173961,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773237093,12081829,NULL,NULL,NULL,NULL),(1389,858,0,'LSQ12eks','LSQ',345.267375,-6.69525,NULL,NULL,'2012-08-30 03:52:35',56169.1615200001,19.097,0.1673,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eks/LSQ12eks_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eks/LSQ12eks_snap_55080.gif',49487173961,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773237093,12081829,NULL,NULL,NULL,NULL),(1390,876,0,'LSQ12ekl','LSQ',347.856083333333,-1.86508333333333,NULL,NULL,'2012-08-30 02:11:04',56169.0910299998,18.2924,0.0734,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekl/LSQ12ekl_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekl/LSQ12ekl_snap_55089.gif',49495526397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773367599,12083868,NULL,NULL,NULL,NULL),(1391,876,0,'LSQ12ekl','LSQ',347.856125,-1.86505555555556,NULL,NULL,'2012-08-30 04:12:57',56169.1756699998,18.4022,0.0774,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekl/LSQ12ekl_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekl/LSQ12ekl_snap_55090.gif',49495526397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773367599,12083868,NULL,NULL,NULL,NULL),(1392,915,0,'LSQ12elk','LSQ',31.3318333333333,-5.97230555555556,NULL,NULL,'2012-08-30 06:02:55',56169.2520300001,19.4508,0.1711,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_snap_55099.gif',35137599396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(1393,915,0,'LSQ12elk','LSQ',31.3318333333333,-5.97230555555556,NULL,NULL,'2012-08-30 08:02:50',56169.33531,19.8621,0.1387,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_snap_55100.gif',35137599396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(1394,947,0,'LSQ12ele','LSQ',62.6980416666667,-7.07047222222222,NULL,NULL,'2012-08-30 08:16:22',56169.3446999998,18.7305,0.2093,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ele/LSQ12ele_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ele/LSQ12ele_snap_55102.gif',36955954114,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,577436783,9022449,NULL,NULL,NULL,NULL),(1395,1097,0,'LSQ12enc','LSQ',66.971125,-3.19427777777778,NULL,NULL,'2012-08-30 06:57:17',56169.2897899998,18.9892,0.1662,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enc/LSQ12enc_history.html','sne??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enc/LSQ12enc_snap_55064.gif',36919365798,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,576865090,9013517,NULL,NULL,NULL,NULL),(1396,1099,0,'LSQ12enb','LSQ',4.19695833333333,-0.644194444444444,NULL,NULL,'2012-08-30 07:34:06',56169.3153499998,19.6443,0.1761,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_history.html','agn?',NULL,0.06394,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12enb/LSQ12enb_snap_55044.gif',34371929527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,537061398,8391584,NULL,NULL,NULL,NULL),(1397,1287,0,'LSQ12erd','LSQ',10.6061666666667,0.864666666666667,NULL,NULL,'2012-08-30 07:03:08',56169.29385,19.2033,0.1944,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erd/LSQ12erd_history.html','sne?',NULL,0.16679,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erd/LSQ12erd_snap_55144.gif',66807779648,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,1043871557,16310493,NULL,NULL,NULL,NULL),(1398,1289,0,'LSQ12erc','LSQ',8.77054166666667,1.48155555555556,NULL,NULL,'2012-08-30 06:30:38',56169.27128,19.4085,0.1375,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_snap_55150.gif',66590313561,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1040473649,16257400,NULL,NULL,NULL,NULL),(1399,1289,0,'LSQ12erc','LSQ',8.77120833333333,1.48152777777778,NULL,NULL,'2012-08-30 08:18:42',56169.34632,18.822,0.1234,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_snap_55151.gif',66590313565,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1040473649,16257400,NULL,NULL,NULL,NULL),(1400,1307,0,'LSQ12eqv','LSQ',338.389625,-1.16269444444444,NULL,NULL,'2012-08-30 01:21:45',56169.0567800002,17.8261,0.0777,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqv/LSQ12eqv_history.html','sne',NULL,0.05648,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqv/LSQ12eqv_snap_55147.gif',50332414136,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,786443970,12288187,NULL,NULL,NULL,NULL),(1401,1307,0,'LSQ12eqv','LSQ',338.389708333333,-1.16263888888889,NULL,NULL,'2012-08-30 03:23:45',56169.1414999999,17.5777,0.078,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqv/LSQ12eqv_history.html','sne',NULL,0.05648,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqv/LSQ12eqv_snap_55148.gif',50332414136,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,786443970,12288187,NULL,NULL,NULL,NULL),(1402,1310,0,'LSQ12eqs','LSQ',346.333125,3.24358333333333,NULL,NULL,'2012-08-30 02:04:13',56169.0862699999,18.5995,0.148,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqs/LSQ12eqs_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqs/LSQ12eqs_snap_55154.gif',51696025755,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,807750402,12621100,NULL,NULL,NULL,NULL),(1403,1310,0,'LSQ12eqs','LSQ',346.333166666667,3.2435,NULL,NULL,'2012-08-30 04:06:11',56169.1709699999,19.0342,0.1204,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqs/LSQ12eqs_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqs/LSQ12eqs_snap_55155.gif',51696025755,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,807750402,12621100,NULL,NULL,NULL,NULL),(1404,1319,0,'LSQ12eqi','LSQ',13.31375,-3.55161111111111,NULL,NULL,'2012-08-30 05:45:59',56169.24027,20.0256,0.0921,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 03:45:38','2012-08-31 03:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqi/LSQ12eqi_history.html','sn?',NULL,0.051639,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqi/LSQ12eqi_snap_55158.gif',34516868825,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,539326075,8426969,NULL,NULL,NULL,NULL),(1405,646,0,'LSQ12eiq','LSQ',32.5293333333333,-5.57616666666667,NULL,NULL,'2012-08-30 06:02:55',56169.2520300001,18.9089,0.0873,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 14:45:37','2012-08-31 14:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_snap_55261.gif',35142165909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549096342,8579630,NULL,NULL,NULL,NULL),(1406,646,0,'LSQ12eiq','LSQ',32.5293333333333,-5.57622222222222,NULL,NULL,'2012-08-30 08:02:50',56169.33531,18.8236,0.0812,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 14:45:37','2012-08-31 14:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eiq/LSQ12eiq_snap_55262.gif',35142165909,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549096342,8579630,NULL,NULL,NULL,NULL),(1407,876,0,'LSQ12ekl','LSQ',347.856208333333,-1.86511111111111,NULL,NULL,'2012-08-30 02:12:46',56169.0921999998,18.2613,0.0743,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 16:45:36','2012-08-31 16:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekl/LSQ12ekl_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekl/LSQ12ekl_snap_55367.gif',49495526397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773367599,12083868,NULL,NULL,NULL,NULL),(1408,876,0,'LSQ12ekl','LSQ',347.856166666667,-1.86513888888889,NULL,NULL,'2012-08-30 04:14:38',56169.1768399999,18.3577,0.0604,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 16:45:36','2012-08-31 16:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekl/LSQ12ekl_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekl/LSQ12ekl_snap_55368.gif',49495526397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773367599,12083868,NULL,NULL,NULL,NULL),(1409,1409,1,'LSQ12etj','LSQ',354.85375,-1.44855555555556,NULL,NULL,'2012-08-08 10:13:47',56147.4262399999,19.8744,0.1523,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 17:45:38','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12etj/LSQ12etj_history.html','sn?? or agn',NULL,0.022539,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12etj/LSQ12etj_snap_55416.gif',49454673138,NULL,NULL,NULL,'2012-08-04 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772729267,12073894,NULL,NULL,NULL,NULL),(1410,1409,0,'LSQ12etj','LSQ',354.85375,-1.4485,NULL,NULL,'2012-08-19 04:23:00',56158.1826499999,20.1488,0.1078,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 17:45:38','2012-08-31 17:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12etj/LSQ12etj_history.html','sn?? or agn',NULL,0.022539,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12etj/LSQ12etj_snap_55417.gif',49454673138,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772729267,12073894,NULL,NULL,NULL,NULL),(1411,1409,0,'LSQ12etj','LSQ',354.85375,-1.44836111111111,NULL,NULL,'2012-08-30 05:20:38',56169.22267,19.1387,0.1348,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 17:45:38','2012-08-31 17:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12etj/LSQ12etj_history.html','sn?? or agn',NULL,0.022539,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12etj/LSQ12etj_snap_55371.gif',49454673138,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772729267,12073894,NULL,NULL,NULL,NULL),(1412,1409,0,'LSQ12etj','LSQ',354.85375,-1.44855555555556,NULL,NULL,'2012-08-30 07:20:33',56169.3059399999,18.9748,0.1329,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 17:45:38','2012-08-31 17:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12etj/LSQ12etj_history.html','sn?? or agn',NULL,0.022539,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12etj/LSQ12etj_snap_55372.gif',49454673138,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772729267,12073894,NULL,NULL,NULL,NULL),(1413,1413,1,'LSQ12etc','LSQ',335.135791666667,0.552944444444444,NULL,NULL,'2012-08-23 05:37:24',56162.2343100002,19.6606,0.0513,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 17:45:38','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12etc/LSQ12etc_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12etc/LSQ12etc_snap_55353.gif',52145872977,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,814779265,12730926,NULL,NULL,NULL,NULL),(1414,1413,0,'LSQ12etc','LSQ',335.136416666667,0.553055555555556,NULL,NULL,'2012-08-28 03:24:15',56167.1418499998,19.7321,0.1402,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 17:45:38','2012-08-31 17:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12etc/LSQ12etc_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12etc/LSQ12etc_snap_55354.gif',52145872976,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,814779265,12730926,NULL,NULL,NULL,NULL),(1415,1413,0,'LSQ12etc','LSQ',335.135833333333,0.552972222222222,NULL,NULL,'2012-08-30 01:16:34',56169.0531799998,17.5756,0.1029,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 17:45:38','2012-08-31 17:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12etc/LSQ12etc_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12etc/LSQ12etc_snap_55309.gif',52145872977,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,814779265,12730926,NULL,NULL,NULL,NULL),(1416,1413,0,'LSQ12etc','LSQ',335.135791666667,0.552916666666667,NULL,NULL,'2012-08-30 03:18:32',56169.1378799998,17.8687,0.1016,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 17:45:38','2012-08-31 17:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12etc/LSQ12etc_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12etc/LSQ12etc_snap_55310.gif',52145872979,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,814779265,12730926,NULL,NULL,NULL,NULL),(1417,1417,1,'LSQ12esy','LSQ',359.015541666667,0.309277777777778,NULL,NULL,'2012-08-28 07:48:26',56167.3253100002,13.772,0.0015,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 17:45:38','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esy/LSQ12esy_history.html','variable?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esy/LSQ12esy_snap_55347.gif',51540358796,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,805318106,12583095,NULL,NULL,NULL,NULL),(1418,1417,0,'LSQ12esy','LSQ',359.0155,0.30925,NULL,NULL,'2012-08-30 05:29:04',56169.22853,14.256,0.0026,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 17:45:38','2012-08-31 17:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esy/LSQ12esy_history.html','variable?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esy/LSQ12esy_snap_55301.gif',51540358796,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,805318106,12583095,NULL,NULL,NULL,NULL),(1419,1417,0,'LSQ12esy','LSQ',359.015541666667,0.309277777777778,NULL,NULL,'2012-08-30 07:29:02',56169.31183,14.2776,0.0026,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 17:45:38','2012-08-31 17:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esy/LSQ12esy_history.html','variable?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esy/LSQ12esy_snap_55302.gif',51540358796,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,805318106,12583095,NULL,NULL,NULL,NULL),(1420,1420,1,'LSQ12esq','LSQ',240.877208333333,-6.27063888888889,NULL,NULL,'2012-08-28 00:39:16',56167.02727,19.0793,0.1499,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 17:45:38','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esq/LSQ12esq_history.html','sne-nice',NULL,0.030351,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esq/LSQ12esq_snap_55322.gif',45571174319,NULL,NULL,NULL,'2012-08-12 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,712049598,11125774,NULL,NULL,NULL,NULL),(1421,1420,0,'LSQ12esq','LSQ',240.877333333333,-6.27063888888889,NULL,NULL,'2012-08-30 00:02:20',56169.0016299998,19.2611,0.1662,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 17:45:38','2012-08-31 17:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esq/LSQ12esq_history.html','sne-nice',NULL,0.030351,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esq/LSQ12esq_snap_55285.gif',45571174318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,712049598,11125774,NULL,NULL,NULL,NULL),(1422,1420,0,'LSQ12esq','LSQ',240.877208333333,-6.27069444444444,NULL,NULL,'2012-08-30 00:58:26',56169.0405799998,19.7179,0.1402,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-08-31 17:45:38','2012-08-31 17:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esq/LSQ12esq_history.html','sne-nice',NULL,0.030351,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12esq/LSQ12esq_snap_55286.gif',45571174319,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,712049598,11125774,NULL,NULL,NULL,NULL),(1423,1423,1,'SSS120817-002822-305723','CRTS-SSS',7.09095,-30.95642,NULL,NULL,'2012-08-17 00:00:00',56156,19.09,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-03 18:56:13','2019-10-11 14:10:04','http://nesssi.cacr.caltech.edu/SSS/20120817/1208170310044215046.html','supernova',NULL,0.051,NULL,NULL,'NULL',NULL,NULL,34889867327,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'SN',NULL,0,NULL,0,545154176,8518034,NULL,NULL,NULL,NULL),(1424,1240,0,'LSQ12epy','LSQ',339.396958333333,-18.3268333333333,NULL,NULL,'2012-09-03 04:31:50',56173.18878,18.9715,0.2163,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-03 21:45:38','2012-09-03 21:45:38','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epy/LSQ12epy_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epy/LSQ12epy_snap_55797.gif',50251458900,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785179045,12268422,NULL,NULL,NULL,NULL),(1425,48203,0,'LSQ12dlc','atel',36.8,-6.45563888889,NULL,NULL,'2012-07-11 00:00:00',56119,NULL,NULL,NULL,0.06,NULL,'IIP',NULL,'2012-09-03 23:25:01','2012-09-03 23:25:01','http://www.astronomerstelegram.org/?read=4311',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34941112030,'UT 2.2m','SNIFS','Anon',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,545954875,8530544,NULL,NULL,NULL,NULL),(1426,1426,1,'LSQ12evf','LSQ',335.365583333333,-24.5856111111111,NULL,NULL,'2012-08-27 01:29:33',56166.06219,19.8257,0.1584,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 02:45:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evf/LSQ12evf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evf/LSQ12evf_snap_55820.gif',50066844723,NULL,NULL,NULL,'2012-08-09 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782294448,12223350,NULL,NULL,NULL,NULL),(1427,1426,0,'LSQ12evf','LSQ',335.365625,-24.5856388888889,NULL,NULL,'2012-08-27 03:39:59',56166.15277,19.9767,0.1726,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 02:45:36','2012-09-04 02:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evf/LSQ12evf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evf/LSQ12evf_snap_55821.gif',50066844723,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782294448,12223350,NULL,NULL,NULL,NULL),(1428,1426,0,'LSQ12evf','LSQ',335.365625,-24.5854722222222,NULL,NULL,'2012-09-03 04:11:21',56173.1745600002,19.6612,0.1583,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 02:45:36','2012-09-04 02:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evf/LSQ12evf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evf/LSQ12evf_snap_55813.gif',50066844723,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782294448,12223350,NULL,NULL,NULL,NULL),(1429,1426,0,'LSQ12evf','LSQ',335.365666666667,-24.5854722222222,NULL,NULL,'2012-09-03 06:11:19',56173.2578699999,19.2062,0.1643,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 02:45:36','2012-09-04 02:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evf/LSQ12evf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evf/LSQ12evf_snap_55814.gif',50066844723,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782294448,12223350,NULL,NULL,NULL,NULL),(1430,1430,1,'LSQ12eve','LSQ',328.319208333333,-21.7153611111111,NULL,NULL,'2012-08-27 01:17:40',56166.05394,19.6738,0.1245,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 02:45:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eve/LSQ12eve_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eve/LSQ12eve_snap_55817.gif',50881668328,NULL,NULL,NULL,'2012-08-19 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,795026067,12422282,NULL,NULL,NULL,NULL),(1431,1430,0,'LSQ12eve','LSQ',328.319125,-21.7153888888889,NULL,NULL,'2012-08-27 03:28:03',56166.1444899999,19.5712,0.1114,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 02:45:36','2012-09-04 02:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eve/LSQ12eve_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eve/LSQ12eve_snap_55818.gif',50881668328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,795026067,12422282,NULL,NULL,NULL,NULL),(1432,1430,0,'LSQ12eve','LSQ',328.319125,-21.7154722222222,NULL,NULL,'2012-08-29 02:01:16',56168.0842200001,19.2015,0.134,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 02:45:36','2012-09-04 02:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eve/LSQ12eve_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eve/LSQ12eve_snap_55819.gif',50881668328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,795026067,12422282,NULL,NULL,NULL,NULL),(1433,1430,0,'LSQ12eve','LSQ',328.31925,-21.7153333333333,NULL,NULL,'2012-09-03 04:06:17',56173.1710399999,19.2997,0.1172,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 02:45:36','2012-09-04 02:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eve/LSQ12eve_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eve/LSQ12eve_snap_55811.gif',50881668328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,795026067,12422282,NULL,NULL,NULL,NULL),(1434,1430,0,'LSQ12eve','LSQ',328.319125,-21.7153055555556,NULL,NULL,'2012-09-03 06:06:13',56173.2543199998,19.2042,0.126,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 02:45:36','2012-09-04 02:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eve/LSQ12eve_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eve/LSQ12eve_snap_55812.gif',50881668328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,795026067,12422282,NULL,NULL,NULL,NULL),(1435,1060,0,'LSQ12emi','pessto',75.0574583333,-22.1881666667,NULL,NULL,'2012-08-26 00:00:00',56165,NULL,NULL,NULL,0.05,NULL,'Ic',NULL,'2012-09-04 10:53:44','2012-09-04 10:53:44','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37549808027,'NTT','EFOSC2 Gm13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,586715750,9167433,NULL,NULL,NULL,NULL),(1436,992,0,'LSQ12elt','pessto',302.779875,-23.1457222222,NULL,NULL,'2012-08-26 00:00:00',56165,NULL,NULL,NULL,0.1,NULL,'Ia',NULL,'2012-09-04 11:14:45','2012-09-04 11:14:45','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50808789842,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793887341,12404489,NULL,NULL,NULL,NULL),(1437,934,0,'LSQ12eli','pessto',51.1982083333,-6.86372222222,NULL,NULL,'2012-08-25 00:00:00',56164,NULL,NULL,NULL,0.15,NULL,'Ia',NULL,'2012-09-04 11:23:40','2012-09-04 11:23:40','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36804372250,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,575068316,8985442,NULL,NULL,NULL,NULL),(1438,915,0,'LSQ12elk','pessto',31.3318333333,-5.97241666667,NULL,NULL,'2012-08-25 00:00:00',56164,NULL,NULL,NULL,0.12,NULL,'Ia',NULL,'2012-09-04 11:27:19','2012-09-04 11:27:19','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35137599396,'NTT','EFOSC2','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(1439,876,0,'LSQ12ekl','atel',347.856041667,-1.86508333333,NULL,NULL,'2012-08-22 00:00:00',56161,NULL,NULL,NULL,0.082,NULL,'Ia',NULL,'2012-09-04 11:31:27','2012-09-04 11:31:27','http://www.astronomerstelegram.org/?read=4331',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49495526397,'UH_2p2m','SNIFS','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773367599,12083868,NULL,NULL,NULL,NULL),(1440,858,0,'LSQ12eks','atel',345.26725,-6.69516666667,NULL,NULL,'2012-08-22 00:00:00',56161,NULL,NULL,NULL,0.094,NULL,'Ia',NULL,'2012-09-04 12:14:29','2012-09-04 12:14:29','http://www.astronomerstelegram.org/?read=4331',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49487173961,'UH_2.2m','SNIFS','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773237093,12081829,NULL,NULL,NULL,NULL),(1441,762,0,'PSNJ19371572-4218271','pessto',294.315504167,-42.3075388889,NULL,NULL,'2012-08-18 00:00:00',56157,NULL,NULL,NULL,0.02,NULL,'IIP',NULL,'2012-09-04 12:31:21','2012-09-04 12:31:21','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51268024318,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,801062879,12516607,NULL,NULL,NULL,NULL),(1442,1014,0,'LSQ12elq','pessto',308.064416667,1.48769444444,NULL,NULL,'2012-08-25 00:00:00',56164,NULL,NULL,NULL,NULL,NULL,'variable star',NULL,'2012-09-04 12:37:56','2012-09-04 12:37:56','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,53996973989,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,843702718,13182854,NULL,NULL,NULL,NULL),(1443,1047,0,'LSQ12emc','pessto',309.749333333,-5.03875,NULL,NULL,'2012-08-25 00:00:00',56164,NULL,NULL,NULL,NULL,NULL,'variable star',NULL,'2012-09-04 12:56:23','2012-09-04 12:56:23','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,47839885908,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,747498217,11679659,NULL,NULL,NULL,NULL),(1444,543,0,'PSNJ20032484-5557192','pessto',300.8535,-55.955325,NULL,NULL,'2012-08-07 00:00:00',56146,NULL,NULL,NULL,0.015,NULL,'Ia',NULL,'2012-09-04 14:29:44','2012-09-04 14:29:44','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49049600212,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,766400003,11975000,NULL,NULL,NULL,NULL),(1445,542,0,'PSNJ21253403-4016432','pessto',321.391766667,-40.2786888889,NULL,NULL,'2012-08-07 00:00:00',56146,NULL,NULL,NULL,0.017,NULL,'Ia',NULL,'2012-09-04 14:31:54','2012-09-04 14:31:54','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51356335194,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,802442737,12538167,NULL,NULL,NULL,NULL),(1446,691,0,'PS1-12bch','Pan-STARRS1',37.141866732,24.1646723684,NULL,NULL,'2012-08-21 00:00:00',56160,NULL,NULL,NULL,0.02,NULL,'IIb',NULL,'2012-09-04 14:34:25','2019-08-19 23:13:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1022834041240952800/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68086492146,'WHT','ISIS','Darryl Wright',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1063851439,16622678,NULL,NULL,NULL,NULL),(1447,1447,1,'LSQ12euv','LSQ',328.523833333333,-5.83372222222222,NULL,NULL,'2012-08-28 00:18:57',56167.0131700002,19.6959,0.1662,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 14:45:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euv/LSQ12euv_history.html','sn?',NULL,0.357,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euv/LSQ12euv_snap_55762.gif',49890107103,NULL,NULL,NULL,'2012-08-22 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,779532923,12180201,NULL,NULL,NULL,NULL),(1448,1447,0,'LSQ12euv','LSQ',328.523875,-5.83369444444444,NULL,NULL,'2012-08-28 02:18:15',56167.09601,19.5176,0.1399,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 14:45:36','2012-09-04 14:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euv/LSQ12euv_history.html','sn?',NULL,0.357,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euv/LSQ12euv_snap_55763.gif',49890107103,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,779532923,12180201,NULL,NULL,NULL,NULL),(1449,1447,0,'LSQ12euv','LSQ',328.523666666667,-5.83375,NULL,NULL,'2012-09-02 00:00:19',56172.0002299999,19.1004,0.1193,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 14:45:36','2012-09-04 14:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euv/LSQ12euv_history.html','sn?',NULL,0.357,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euv/LSQ12euv_snap_55686.gif',49890107101,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,779532923,12180201,NULL,NULL,NULL,NULL),(1450,1447,0,'LSQ12euv','LSQ',328.523916666667,-5.83366666666667,NULL,NULL,'2012-09-02 02:02:23',56172.085,19.2098,0.1278,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 14:45:36','2012-09-04 14:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euv/LSQ12euv_history.html','sn?',NULL,0.357,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euv/LSQ12euv_snap_55687.gif',49890107103,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,779532923,12180201,NULL,NULL,NULL,NULL),(1451,1451,0,'LSQ12euu','LSQ',322.784083333333,-6.70402777777778,NULL,NULL,'2012-08-22 00:30:28',56161.02116,19.8563,0.1415,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 14:45:36','2019-10-11 20:38:03','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euu/LSQ12euu_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euu/LSQ12euu_snap_55761.gif',49683505270,NULL,NULL,NULL,'2012-08-12 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,776304769,12129762,NULL,NULL,NULL,NULL),(1452,1451,0,'LSQ12euu','LSQ',322.784083333333,-6.70402777777778,NULL,NULL,'2012-09-01 23:48:29',56171.9920100002,19.0422,0.1159,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 14:45:36','2012-09-04 14:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euu/LSQ12euu_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euu/LSQ12euu_snap_55684.gif',49683505270,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,776304769,12129762,NULL,NULL,NULL,NULL),(1453,1451,0,'LSQ12euu','LSQ',322.784083333333,-6.70408333333333,NULL,NULL,'2012-09-02 01:50:27',56172.0767100002,18.9315,0.169,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 14:45:36','2012-09-04 14:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euu/LSQ12euu_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euu/LSQ12euu_snap_55685.gif',49683505270,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,776304769,12129762,NULL,NULL,NULL,NULL),(1454,1454,1,'LSQ12eus','LSQ',335.192208333333,0.522361111111111,NULL,NULL,'2012-08-28 01:24:02',56167.0583600001,19.0237,0.15,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 14:45:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eus/LSQ12eus_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eus/LSQ12eus_snap_55754.gif',52145877361,NULL,NULL,NULL,'2012-08-23 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,814779333,12730927,NULL,NULL,NULL,NULL),(1455,1454,0,'LSQ12eus','LSQ',335.191833333333,0.522583333333333,NULL,NULL,'2012-08-30 01:16:34',56169.0531799998,17.9725,0.131,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 14:45:36','2012-09-04 14:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eus/LSQ12eus_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eus/LSQ12eus_snap_55755.gif',52145877355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,814779333,12730927,NULL,NULL,NULL,NULL),(1456,1454,0,'LSQ12eus','LSQ',335.191875,0.522527777777778,NULL,NULL,'2012-09-02 00:48:47',56172.03388,17.1878,0.0738,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 14:45:36','2012-09-04 14:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eus/LSQ12eus_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eus/LSQ12eus_snap_55680.gif',52145877355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,814779333,12730927,NULL,NULL,NULL,NULL),(1457,1454,0,'LSQ12eus','LSQ',335.19175,0.522416666666667,NULL,NULL,'2012-09-02 02:48:41',56172.1171499998,17.7452,0.1186,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 14:45:36','2012-09-04 14:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eus/LSQ12eus_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eus/LSQ12eus_snap_55681.gif',52145877355,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,814779333,12730927,NULL,NULL,NULL,NULL),(1458,1458,1,'LSQ12eui','LSQ',51.85675,-11.5907777777778,NULL,NULL,'2012-09-02 06:12:41',56172.25881,18.9351,0.1613,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 14:45:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eui/LSQ12eui_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eui/LSQ12eui_snap_55656.gif',37886492397,NULL,NULL,NULL,'2012-09-02 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,591976443,9249631,NULL,NULL,NULL,NULL),(1459,1458,0,'LSQ12eui','LSQ',51.8569166666667,-11.5911111111111,NULL,NULL,'2012-09-02 08:09:25',56172.3398799999,18.4782,0.1335,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 14:45:36','2012-09-04 14:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eui/LSQ12eui_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eui/LSQ12eui_snap_55657.gif',37886492399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,591976443,9249631,NULL,NULL,NULL,NULL),(1460,1460,1,'LSQ12eue','LSQ',38.8794166666667,-7.49277777777778,NULL,NULL,'2012-09-02 04:28:25',56172.1864100001,18.9056,0.1511,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 14:45:36','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eue/LSQ12eue_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eue/LSQ12eue_snap_55646.gif',34938434364,NULL,NULL,NULL,'2012-09-02 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,545913036,8529891,NULL,NULL,NULL,NULL),(1461,1460,0,'LSQ12eue','LSQ',38.8793333333333,-7.49280555555556,NULL,NULL,'2012-09-02 06:30:18',56172.2710500001,18.9361,0.1605,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 14:45:36','2012-09-04 14:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eue/LSQ12eue_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eue/LSQ12eue_snap_55647.gif',34938434364,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,545913036,8529891,NULL,NULL,NULL,NULL),(1463,472,0,'LSQ12eeq','pessto',313.204416667,-16.5600555556,NULL,NULL,'2012-08-07 00:00:00',56146,NULL,NULL,NULL,NULL,NULL,'variable star',NULL,'2012-09-04 15:12:01','2012-09-04 15:12:01','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50992845486,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,796763210,12449425,NULL,NULL,NULL,NULL),(1464,611,0,'LSQ12eid','LSQ',4.40841666666667,-5.38283333333333,NULL,NULL,'2012-09-04 09:01:48',56174.3762599998,19.1856,0.1732,'gr-LSQ',NULL,NULL,'Ia',NULL,'2012-09-04 17:45:37','2012-09-04 17:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eid/LSQ12eid_snap_55831.gif',34413529726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537711401,8401740,NULL,NULL,NULL,NULL),(1465,1289,0,'LSQ12erc','LSQ',8.771,1.48172222222222,NULL,NULL,'2012-09-04 07:45:58',56174.3235900002,18.9548,0.1232,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 17:45:37','2012-09-04 17:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_snap_55853.gif',66590313565,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1040473649,16257400,NULL,NULL,NULL,NULL),(1466,1289,0,'LSQ12erc','LSQ',8.771125,1.48133333333333,NULL,NULL,'2012-09-04 07:54:47',56174.3297199998,19.0254,0.1358,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-04 17:45:37','2012-09-04 17:45:37','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_snap_55854.gif',66590313561,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1040473649,16257400,NULL,NULL,NULL,NULL),(1467,921,0,'LSQ12elj','pessto',31.0349166667,-4.82077777778,NULL,NULL,'2012-08-26 00:00:00',56165,NULL,NULL,NULL,0.09,NULL,'Ia',NULL,'2012-09-04 17:50:14','2012-09-04 17:50:14','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35139786209,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,549059159,8579049,NULL,NULL,NULL,NULL),(1468,689,0,'PS1-12bci','Pan-STARRS1',324.582515025,-6.90536756795,NULL,NULL,'2012-08-21 00:00:00',56160,NULL,NULL,NULL,0,NULL,'variable star',NULL,'2012-09-05 09:35:36','2019-08-19 23:13:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1213819800065419300/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49682141053,'WHT','ISIS','Darryl Wright',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,776283453,12129428,NULL,NULL,NULL,NULL),(1469,425,0,'LSQ12ecp','pessto',21.7569583333,-17.3654444444,NULL,NULL,'2012-08-07 00:00:00',56146,NULL,NULL,NULL,0.077,NULL,'Ia',NULL,'2012-09-05 09:39:58','2012-09-05 09:39:58','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35188002643,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,549812541,8590820,NULL,NULL,NULL,NULL),(1470,435,0,'LSQ12ecb','pessto',337.79475,-24.8876111111,NULL,NULL,'2012-08-07 00:00:00',56146,NULL,NULL,NULL,0.089,NULL,'unknown',NULL,'2012-09-05 09:41:34','2012-09-05 09:41:34','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50073090666,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,782392041,12224875,NULL,NULL,NULL,NULL),(1472,1472,1,'SN2012ec','TOCP',41.4995,-7.57417,NULL,NULL,'2012-08-11 00:00:00',56150,14.5,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-05 08:15:42','2020-04-28 09:08:48','http://www.cbat.eps.harvard.edu/iau/cbet/003200/CBET003201.txt','supernova',NULL,0.00469,NULL,NULL,'http://farm8.staticflickr.com/7275/7771441224_597103075a_b.jpg',NULL,NULL,37875151026,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591799234,9246863,NULL,NULL,NULL,NULL),(1473,423,0,'LSQ12ecu','pessto',356.538125,-19.3575833333,NULL,NULL,'2012-08-07 00:00:00',56146,NULL,NULL,NULL,0.006,NULL,'unknown',NULL,'2012-09-05 14:59:22','2012-09-05 14:59:22','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49535940995,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,773999078,12093735,NULL,NULL,NULL,NULL),(1474,1472,0,'SN2012ec','CBET',41.4995,-7.57417,NULL,NULL,'2012-08-12 00:00:00',56151,NULL,NULL,NULL,0.00469,NULL,'IIP',NULL,'2012-09-05 15:10:40','2012-09-05 15:10:40','http://www.cbat.eps.harvard.edu/iau/cbet/003200/CBET003201.txt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37875151026,'ANU_2m','WiFeS','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591799234,9246863,NULL,NULL,NULL,NULL),(1475,1475,1,'SN2012dy','TOCP',319.71125,-57.64514,NULL,NULL,'2012-08-03 00:00:00',56142,15.6,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-05 16:16:11','2020-04-28 09:08:48','http://www.cbat.eps.harvard.edu/iau/cbet/003100/CBET003197.txt','supernova',NULL,0.01,NULL,NULL,'http://farm9.staticflickr.com/8423/7739392156_d39b5826a9_b.jpg',NULL,NULL,49133728063,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,767714500,11995539,NULL,NULL,NULL,NULL),(1476,1475,0,'SN2012dy','CBET',319.71125,-57.64514,NULL,NULL,'2012-08-05 00:00:00',56144,NULL,NULL,NULL,0.01,NULL,'IIb',NULL,'2012-09-05 15:17:21','2012-09-05 15:17:21','http://www.cbat.eps.harvard.edu/iau/cbet/003100/CBET003197.txt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49133728063,'SALT','RSS','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,767714500,11995539,NULL,NULL,NULL,NULL),(1477,417,0,'LSQ12dyt','atel',345.311166667,-6.72166666667,NULL,NULL,'2012-08-02 00:00:00',56141,NULL,NULL,NULL,0,NULL,'variable star',NULL,'2012-09-05 16:10:50','2012-09-05 16:10:50','http://www.astronomerstelegram.org/?read=4311',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49487242571,'UH_2p2m','SNIFS','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,773238165,12081846,NULL,NULL,NULL,NULL),(1478,428,0,'LSQ12ecd','pessto',339.4785,-21.1293888889,NULL,NULL,'2012-08-08 00:00:00',56147,NULL,NULL,NULL,0.09,NULL,'Ia',NULL,'2012-09-05 16:58:44','2012-09-05 16:58:44','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50257618254,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785275285,12269926,NULL,NULL,NULL,NULL),(1479,407,0,'LSQ12dyw','pessto',352.353666667,-7.38908333333,NULL,NULL,'2012-08-07 00:00:00',56146,NULL,NULL,NULL,0.09,NULL,'unknown',NULL,'2012-09-05 17:16:45','2019-10-11 14:09:07','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49660467229,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,1182471,NULL,0,775944800,12124137,NULL,NULL,NULL,NULL),(1480,85,0,'LSQ12dlf','pessto',27.6241666667,-21.8126111111,NULL,NULL,'2012-08-07 00:00:00',56146,NULL,NULL,NULL,0.25,NULL,'Ic peculiar',NULL,'2012-09-05 17:21:15','2019-10-11 14:09:07','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35034119519,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,1182499,NULL,0,547408117,8553251,NULL,NULL,NULL,NULL),(1481,1481,1,'SSS120810-231802-560926','CRTS-SSS',349.50757,-56.15713,NULL,NULL,'2012-08-10 00:00:00',56149,18,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-05 11:25:10','2019-10-11 14:10:04','http://crts.caltech.edu/ATEL/SSS/1208100551024104013.atel.html','supernova',NULL,0,NULL,NULL,'http://crts.caltech.edu/ATEL/SSS/1208100551024104013/1208100551024104013-0001.arch.jpg',NULL,NULL,48810736786,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,762667762,11916683,NULL,NULL,NULL,NULL),(1482,1481,0,'SSS120810-231802-560926','pessto',349.50757,-56.15713,NULL,NULL,'2012-08-17 00:00:00',56156,NULL,NULL,NULL,0.2,NULL,'Ic peculiar',NULL,'2012-09-05 17:27:10','2019-10-11 14:09:07','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48810736786,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,1182665,NULL,0,762667762,11916683,NULL,NULL,NULL,NULL),(1483,1483,1,'SSS120816-012937-175040','CRTS-SSS',22.40618,-17.84455,NULL,NULL,'2012-08-16 00:00:00',56155,17.9,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-05 17:35:31','2019-10-11 14:10:04','http://crts.caltech.edu/ATEL/SSS/1208160170114103042.atel.html','supernova',NULL,0,NULL,NULL,'http://crts.caltech.edu/ATEL/SSS/1208160170114103042/1208160170114103042-0001.arch.jpg',NULL,NULL,35194431803,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,549912996,8592390,NULL,NULL,NULL,NULL),(1484,396,0,'LSQ12dya','atel',346.8545,-23.5859166667,NULL,NULL,'2012-08-02 00:00:00',56141,NULL,NULL,NULL,0,NULL,'unknown',NULL,'2012-09-05 17:46:01','2012-09-05 17:46:01','http://www.astronomerstelegram.org/?read=4311',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50298140916,'UH_2p2m','SNIFS','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,785908451,12279819,NULL,NULL,NULL,NULL),(1485,1485,1,'SSS120811-124603-165210','CRTS-SSS',191.51084,-16.86946,NULL,NULL,'2012-08-15 00:00:00',56154,18.6,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-05 17:49:53','2019-10-11 14:10:04','http://crts.caltech.edu/ATEL/SSS/1208110170924114100.atel.html','supernova',NULL,0,NULL,NULL,'http://crts.caltech.edu/ATEL/SSS/1208110170924114100/1208110170924114100-0001.arch.jpg',NULL,NULL,43931795834,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,686434309,10725536,NULL,NULL,NULL,NULL),(1486,1486,1,'SNHunt143','SNHunt',357.25747,-16.54264,NULL,NULL,'2012-07-30 00:00:00',56138,18,NULL,'R',NULL,NULL,NULL,NULL,'2012-09-05 12:03:44','2019-10-11 14:10:04','http://nesssi.cacr.caltech.edu/catalina/Current/20120730_24.html','supernova',NULL,0,NULL,NULL,'http://farm8.staticflickr.com/7123/7749586940_0513eab757_b.jpg',NULL,NULL,49587337283,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,774802145,12106283,NULL,NULL,NULL,NULL),(1487,1487,1,'SNHunt140','SNHunt',193.9165,-39.53837,NULL,NULL,'2012-07-07 00:00:00',56115,17,NULL,'R',NULL,NULL,NULL,NULL,'2012-09-05 12:08:33','2019-10-11 14:10:04','http://nesssi.cacr.caltech.edu/catalina/Current/20120707_89.html','supernova',NULL,0.01047,NULL,NULL,'http://nesssi.cacr.caltech.edu/catalina/20010855/jpg/108550390764104313_20120707_01_4.jpg',NULL,NULL,46757243354,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,730581927,11415342,NULL,NULL,NULL,NULL),(1488,1488,1,'SN2012ca','TOCP',280.28021,-41.794,NULL,NULL,'2012-04-25 00:00:00',56042,14.8,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-05 12:41:02','2020-04-28 09:08:48','NULL','supernova',NULL,0.01946,NULL,NULL,'/pessto/private/marshall/other_assets/remote_finders/2012ca_fc_20130227.jpg',NULL,NULL,51060883888,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,797826310,12466036,NULL,NULL,NULL,NULL),(1489,1488,0,'SN2012ca','pessto',280.28021,-41.794,NULL,NULL,'2012-04-29 00:00:00',56046,NULL,NULL,NULL,0.0195,NULL,'IIn',NULL,'2012-09-05 18:42:30','2012-09-05 18:42:30','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51060883888,'NTT','EFOSC2 Gr13','Stefano Valenti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,797826310,12466036,NULL,NULL,NULL,NULL),(1490,1201,0,'LSQ12eod','LSQ',319.040166666667,-24.1268333333333,NULL,NULL,'2012-09-05 00:46:23',56175.0322199999,20.1818,0.1087,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-05 21:45:35','2012-09-05 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eod/LSQ12eod_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eod/LSQ12eod_snap_55936.gif',50917408090,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,795584501,12431007,NULL,NULL,NULL,NULL),(1491,1201,0,'LSQ12eod','LSQ',319.040125,-24.1268055555556,NULL,NULL,'2012-09-05 02:55:45',56175.1220499999,20.4291,0.2052,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-05 21:45:35','2012-09-05 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eod/LSQ12eod_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eod/LSQ12eod_snap_55937.gif',50917408090,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,795584501,12431007,NULL,NULL,NULL,NULL),(1492,1233,0,'LSQ12eqa','LSQ',339.820166666667,-19.6163333333333,NULL,NULL,'2012-09-05 06:07:55',56175.2555,18.2626,0.1076,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-05 21:45:35','2012-09-05 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqa/LSQ12eqa_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqa/LSQ12eqa_snap_55946.gif',50250522384,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785164412,12268193,NULL,NULL,NULL,NULL),(1493,1240,0,'LSQ12epy','LSQ',339.396916666667,-18.3269444444444,NULL,NULL,'2012-09-05 04:05:53',56175.1707600001,19.6294,0.1418,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-05 21:45:35','2012-09-05 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epy/LSQ12epy_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12epy/LSQ12epy_snap_55934.gif',50251458900,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785179045,12268422,NULL,NULL,NULL,NULL),(1494,1426,0,'LSQ12evf','LSQ',335.365541666667,-24.5855277777778,NULL,NULL,'2012-09-05 01:36:00',56175.0666700001,19.8212,0.0983,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-05 21:45:35','2012-09-05 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evf/LSQ12evf_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evf/LSQ12evf_snap_55916.gif',50066844723,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782294448,12223350,NULL,NULL,NULL,NULL),(1495,1430,0,'LSQ12eve','LSQ',328.319125,-21.7154166666667,NULL,NULL,'2012-09-05 01:30:55',56175.0631400002,18.9941,0.0489,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-05 21:45:35','2012-09-05 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eve/LSQ12eve_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eve/LSQ12eve_snap_55918.gif',50881668328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,795026067,12422282,NULL,NULL,NULL,NULL),(1496,1430,0,'LSQ12eve','LSQ',328.319083333333,-21.7153888888889,NULL,NULL,'2012-09-05 03:40:26',56175.1530800001,18.9218,0.0572,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-05 21:45:35','2012-09-05 21:45:35','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eve/LSQ12eve_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eve/LSQ12eve_snap_55919.gif',50881668328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,795026067,12422282,NULL,NULL,NULL,NULL),(1498,1498,1,'LSQ12djg','LSQ',238.669,-8.5086,NULL,NULL,'2012-08-05 00:00:00',56144,18.75,NULL,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-05 17:36:53','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djg/LSQ12djg_history.html','agn',NULL,0,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djg/LSQ12djg_snap_42616.gif',NULL,NULL,45633447719,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,713022620,11140978,NULL,NULL,NULL,NULL),(1499,332,0,'LSQ12dwl','non-pessto atel',333.173125,0.511972222222,NULL,NULL,'2012-07-27 00:00:00',56135,NULL,NULL,NULL,0.0137,NULL,'Ic peculiar',NULL,'2012-09-05 23:51:40','2012-09-05 23:51:40','http://www.astronomerstelegram.org/?read=4398',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52152344380,'P200','DS','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814880380,12732505,NULL,NULL,NULL,NULL),(1500,96,0,'LSQ12dle','pessto',25.1842916667,-25.2649166667,NULL,NULL,'2012-08-08 00:00:00',56147,NULL,NULL,NULL,0.05,NULL,'Ia',NULL,'2012-09-06 00:03:50','2012-09-06 00:03:50','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34695840990,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542122515,8470664,NULL,NULL,NULL,NULL),(1501,343,0,'LSQ12dvr','pessto',39.5682083333,-2.43908333333,NULL,NULL,'2012-08-07 00:00:00',56146,NULL,NULL,NULL,0,NULL,'variable star',NULL,'2012-09-06 00:05:13','2012-09-06 00:05:13','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34958364933,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,546224452,8534757,NULL,NULL,NULL,NULL),(1502,1502,1,'LSQ12dhs','LSQ',215.1405,-16.5966,NULL,NULL,'2012-07-06 00:00:00',56114,17.7,NULL,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 00:07:41','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dhs/LSQ12dhs_history.html','supernova',NULL,0.0408,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dhs/LSQ12dhs_snap_42138.gif',NULL,NULL,46554965008,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,727421328,11365958,NULL,NULL,NULL,NULL),(1503,1503,1,'LSQ12dhe','LSQ',234.4163,6.6161,NULL,NULL,'2012-07-05 12:00:00',56113.5,18,NULL,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 00:11:22','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dhe/LSQ12dhe_history.html','supernova',NULL,0,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dhe/LSQ12dhe_snap_41892.gif',NULL,NULL,56414422997,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,881475359,13773052,NULL,NULL,NULL,NULL),(1504,1504,1,'LSQ12dgs','LSQ',356.4808,-6.0914,NULL,NULL,'2012-06-24 00:00:00',56102,18.5,NULL,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 00:15:11','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dgs/LSQ12dgs_history.html','supernova',NULL,0,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dgs/LSQ12dgs_snap_41866.gif',NULL,NULL,49436998382,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,772453099,12069579,NULL,NULL,NULL,NULL),(1505,353,0,'LSQ12dvj','pessto',28.3065416667,-1.85125,NULL,NULL,'2012-08-09 00:00:00',56148,NULL,NULL,NULL,0.13,NULL,'Ia peculiar',NULL,'2012-09-06 00:18:03','2012-09-06 00:18:03','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35020647697,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,547197620,8549962,NULL,NULL,NULL,NULL),(1506,336,0,'LSQ12dwf','pessto',323.475041667,0.149083333333,NULL,NULL,'2012-08-08 00:00:00',56147,NULL,NULL,NULL,0.12,NULL,'Ia',NULL,'2012-09-06 00:20:02','2012-09-06 00:20:02','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52106900277,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,814170316,12721411,NULL,NULL,NULL,NULL),(1507,307,0,'LSQ12drz','pessto',252.072625,19.2898333333,NULL,NULL,'2012-08-07 00:00:00',56146,NULL,NULL,NULL,0.137,NULL,'Ia',NULL,'2012-09-06 00:22:00','2012-09-06 00:22:00','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,56682128644,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,885658260,13838410,NULL,NULL,NULL,NULL),(1508,316,0,'LSQ12dww','pessto',229.472291667,4.87497222222,NULL,NULL,'2012-08-09 00:00:00',56148,NULL,NULL,NULL,0,NULL,'variable star',NULL,'2012-09-06 00:22:45','2012-09-06 00:22:45','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,56380598798,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,880946856,13764794,NULL,NULL,NULL,NULL),(1509,1509,0,'PSNJ02554120-2725276','TOCP',43.92167,-27.42433,NULL,NULL,'2012-08-22 00:00:00',56161,17.2,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2012-09-06 00:30:23','2019-10-12 20:41:36','http://www.cbat.eps.harvard.edu/unconf/followups/J02554120-2725276.html','supernova',NULL,0.0176,NULL,NULL,'http://www.rochesterastronomy.org/sn2012/e417m3s1.jpg',NULL,NULL,38605987746,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,603218558,9425289,NULL,NULL,NULL,NULL),(1510,1510,0,'PSNJ23054871+1419564','TOCP',346.45296,14.33233,NULL,NULL,'2012-08-21 00:00:00',56160,19.2,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2012-09-05 18:36:01','2019-10-12 20:41:36','http://www.cbat.eps.harvard.edu/unconf/followups/J23054871 1419564.html','supernova',NULL,0,NULL,NULL,'http://farm8.staticflickr.com/7248/7879070720_ab1af6b738_b.jpg',NULL,NULL,52561414916,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,821272108,12832376,NULL,NULL,NULL,NULL),(1511,1511,0,'PSNJ21015899-4816259','TOCP',315.49579,-48.27386,NULL,NULL,'2012-08-19 00:00:00',56158,15.6,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2012-09-05 18:40:27','2019-10-12 20:41:36','http://cador.obs-hp.fr/sn_tarot/PSN_J21015899-4816259','supernova',NULL,0.0186,NULL,NULL,'http://farm9.staticflickr.com/8290/7827294480_ee5e292bc1_o.png',NULL,NULL,51351056248,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,802360253,12536878,NULL,NULL,NULL,NULL),(1512,1512,1,'SNHunt144','SNHunt',318.03714,-47.05388,NULL,NULL,'2012-08-06 00:00:00',56145,16.8,NULL,'R',NULL,NULL,NULL,NULL,'2012-09-06 01:43:00','2019-10-11 14:10:04','http://nesssi.cacr.caltech.edu/catalina/Current/20120806_298.html','supernova',NULL,0,NULL,NULL,'http://farm9.staticflickr.com/8293/7744079614_153746b561_o.jpg',NULL,NULL,51400628406,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,803134818,12548981,NULL,NULL,NULL,NULL),(1513,1513,1,'SSS120814-221352-124146','CRTS-SSS',333.4661,-12.69603,NULL,NULL,'2012-08-14 00:00:00',56153,18.4,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-05 18:50:40','2019-10-11 14:10:04','http://crts.caltech.edu/ATEL/SSS/1208140131634121666.atel.html','supernova',NULL,0,NULL,NULL,'http://crts.caltech.edu/ATEL/SSS/1208140131634121666/1208140131634121666-0003.arch.jpg',NULL,NULL,49746502596,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,777289103,12145142,NULL,NULL,NULL,NULL),(1514,1513,0,'SSS120814-221352-124146','pessto',333.4661,-12.69603,NULL,NULL,'2012-08-26 00:00:00',56165,NULL,NULL,NULL,0.08,NULL,'Ia',NULL,'2012-09-06 00:51:53','2012-09-06 00:51:53','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49746502596,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,777289103,12145142,NULL,NULL,NULL,NULL),(1515,1512,0,'SNHunt144','pessto',318.03714,-47.05388,NULL,NULL,'2012-08-07 00:00:00',56146,NULL,NULL,NULL,0.028,NULL,'Ia',NULL,'2012-09-06 00:52:45','2012-09-06 00:52:45','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51400628406,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,803134818,12548981,NULL,NULL,NULL,NULL),(1516,1511,0,'PSNJ21015899-4816259','pessto',315.49579,-48.27386,NULL,NULL,'2012-08-26 00:00:00',56165,NULL,NULL,NULL,0.019,NULL,'Ia',NULL,'2012-09-06 00:53:47','2012-09-06 00:53:47','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51351056248,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,802360253,12536878,NULL,NULL,NULL,NULL),(1517,1510,0,'PSNJ23054871+1419564','pessto',346.45296,14.33233,NULL,NULL,'2012-08-26 00:00:00',56165,NULL,NULL,NULL,0.11,NULL,'Ia peculiar',NULL,'2012-09-06 00:54:44','2012-09-06 00:54:44','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52561414916,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,821272108,12832376,NULL,NULL,NULL,NULL),(1518,1509,0,'PSNJ02554120-2725276','pessto',43.92167,-27.42433,NULL,NULL,'2012-08-26 00:00:00',56165,NULL,NULL,NULL,0.02,NULL,'Ia peculiar',NULL,'2012-09-06 00:56:55','2012-09-06 00:56:55','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38605987746,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,603218558,9425289,NULL,NULL,NULL,NULL),(1519,1519,1,'SNHunt141','SNHunt',204.4884,-17.90755,NULL,NULL,'2012-07-24 00:00:00',56132,15.6,NULL,'R',NULL,NULL,NULL,NULL,'2012-09-06 01:07:22','2019-10-11 14:10:04','http://nesssi.cacr.caltech.edu/catalina/Current/20120724_54.html','supernova',NULL,0.00452,NULL,NULL,'http://farm9.staticflickr.com/8283/7880288434_b6629255fb_b.jpg',NULL,NULL,43780786638,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,684074791,10688668,NULL,NULL,NULL,NULL),(1520,1519,0,'SNHunt141','pessto',204.4884,-17.90755,NULL,NULL,'2012-08-08 00:00:00',56147,NULL,NULL,NULL,0.004,NULL,'IIP',NULL,'2012-09-06 01:09:44','2012-09-06 01:09:44','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,43780786638,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,684074791,10688668,NULL,NULL,NULL,NULL),(1521,1521,0,'SNHunt142','SNHunt',314.47465,-51.87356,NULL,NULL,'2012-07-25 00:00:00',56133,18.9,NULL,'R',NULL,NULL,NULL,NULL,'2012-09-06 01:13:03','2019-10-12 20:41:36','http://nesssi.cacr.caltech.edu/catalina/Current/20120725_79.html','supernova',NULL,0.0156,NULL,NULL,'http://farm9.staticflickr.com/8287/7660396306_f282c7582f_b.jpg',NULL,NULL,51341548799,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,802211699,12534557,NULL,NULL,NULL,NULL),(1522,1522,1,'LSQ12egz','LSQ',58.8607,-7.0874,NULL,NULL,'2012-08-08 19:11:59',56147.8,18.7,NULL,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 02:20:29','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egz/LSQ12egz_history.html','unknown',NULL,0,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12egz/LSQ12egz_snap_50448.gif',NULL,NULL,37037239971,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,578706874,9042294,NULL,NULL,NULL,NULL),(1523,1523,1,'LSQ12eho','LSQ',318.3398,-19.9759,NULL,NULL,'2012-08-07 14:24:00',56146.6,19.3,NULL,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 01:22:04','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eho/LSQ12eho_history.html','supernova',NULL,0,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eho/LSQ12eho_snap_50652.gif',NULL,NULL,50940566374,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,795946349,12436661,NULL,NULL,NULL,NULL),(1524,1522,0,'LSQ12egz','pessto',58.8607,-7.0874,NULL,NULL,'2012-08-10 00:00:00',56149,NULL,NULL,NULL,0,NULL,'unknown',NULL,'2012-09-06 01:26:39','2012-09-06 01:26:39','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37037239971,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,578706874,9042294,NULL,NULL,NULL,NULL),(1525,1523,0,'LSQ12eho','pessto',318.3398,-19.9759,NULL,NULL,'2012-08-10 00:00:00',56149,NULL,NULL,NULL,0,NULL,'unknown',NULL,'2012-09-06 01:27:53','2012-09-06 01:27:53','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50940566374,'NTT','EFOS2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,795946349,12436661,NULL,NULL,NULL,NULL),(1526,1521,0,'SNHunt142','pessto',314.47465,-51.87356,NULL,NULL,'2012-08-08 00:00:00',56147,NULL,NULL,NULL,0.016,NULL,'Ic',NULL,'2012-09-06 01:30:42','2012-09-06 01:30:42','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51341548799,'NTT','EFOSC2 Gr13','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,802211699,12534557,NULL,NULL,NULL,NULL),(1527,1527,1,'SSS120807-233315-330852','CRTS-SSS',353.31184,-33.14778,NULL,NULL,'2012-08-07 00:00:00',56146,18.2,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-06 01:32:40','2019-10-11 14:10:04','http://crts.caltech.edu/ATEL/SSS/1208070331494112436.atel.html','supernova',NULL,0,NULL,NULL,'http://crts.caltech.edu/ATEL/SSS/1208070331494112436/1208070331494112436-0001.arch.jpg',NULL,NULL,50174744747,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,783980386,12249693,NULL,NULL,NULL,NULL),(1528,1527,0,'SSS120807-233315-330852','pessto',353.31184,-33.14778,NULL,NULL,'2012-08-17 00:00:00',56156,NULL,NULL,NULL,0.03,NULL,'IIP',NULL,'2012-09-06 01:33:37','2012-09-06 01:33:37','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50174744747,'NTT','EFOSC2','Morgan Fraser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,783980386,12249693,NULL,NULL,NULL,NULL),(1529,1529,1,'LSQ12deo','LSQ',353.873,-24.8304,NULL,NULL,'2012-06-19 00:00:00',56097,20.2,NULL,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 01:37:14','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12deo/LSQ12deo_history.html','supernova',NULL,0,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12deo/LSQ12deo_snap_41219.gif',NULL,NULL,50058717786,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782167465,12221366,NULL,NULL,NULL,NULL),(1530,1530,1,'LSQ12dlj','LSQ',237.221,-9.7528,NULL,NULL,'2012-07-08 00:00:00',56116,20.3,NULL,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-05 19:41:21','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djl/LSQ12djl_history.html','supernova',NULL,0,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12djl/LSQ12djl_snap_42597.gif',NULL,NULL,45605790081,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,712590470,11134226,NULL,NULL,NULL,NULL),(1531,1531,0,'PSNJ23501925+1637562','TOCP',357.58021,16.63228,NULL,NULL,'2012-08-18 00:00:00',56157,18.1,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2012-09-06 03:49:10','2019-10-12 20:41:36','http://www.astronomerstelegram.org/?read=4317','supernova',NULL,0,NULL,NULL,'http://master.sai.msu.ru/static/OT/235019.25163756.2_1.png',NULL,NULL,51663184044,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807237250,12613082,NULL,NULL,NULL,NULL),(1532,1531,0,'PSNJ23501925+1637562','CBET',357.58021,16.63228,NULL,NULL,'2012-08-21 00:00:00',56160,NULL,NULL,NULL,0.08,NULL,'Ia',NULL,'2012-09-06 09:52:48','2012-09-06 09:52:48','http://www.cbat.eps.harvard.edu/iau/cbet/003200/CBET003206.txt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51663184044,'NOT','ALFOSC','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,807237250,12613082,NULL,NULL,NULL,NULL),(1533,398,0,'LSQ12dzt','LSQ',44.4755,-1.504,NULL,NULL,'2012-07-27 19:11:59',56135.8,17.9,NULL,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 09:54:44','2012-09-06 09:54:44','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzt/LSQ12dzt_history.html','supernova',NULL,0,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12dzt/LSQ12dzt_snap_48160.gif',NULL,NULL,37849891215,NULL,NULL,NULL,'2012-07-23 09:33:07',56131.398,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591404550,9240696,NULL,NULL,NULL,NULL),(1534,398,0,'LSQ12dzt','atel',44.4754583333,-1.50394444444,NULL,NULL,'2012-08-02 00:00:00',56141,NULL,NULL,NULL,0.037,NULL,'IIn',NULL,'2012-09-06 09:57:31','2012-09-06 09:57:31','http://www.astronomerstelegram.org/?read=4311',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37849891215,'UH_2p2m','SNIFS','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,591404550,9240696,NULL,NULL,NULL,NULL),(1535,1535,0,'SNHunt145','SNHunt',311.31367,-5.62281,NULL,NULL,'2012-08-13 00:00:00',56152,16.4,NULL,'R',NULL,NULL,NULL,NULL,'2012-09-06 10:02:26','2019-10-12 20:41:36','http://nesssi.cacr.caltech.edu/catalina/Current/20120813_105.html','supernova',NULL,0.0274,NULL,NULL,'http://farm8.staticflickr.com/7109/7791806424_61bd503ee8_b.jpg',NULL,NULL,50738665227,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,792791644,12387369,NULL,NULL,NULL,NULL),(1536,1535,0,'SN2012ee','IAU',311.31367,-5.62281,NULL,NULL,'2012-08-13 00:00:00',56152,16.4,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-06 10:06:05','2012-09-06 10:06:05','http://www.cbat.eps.harvard.edu/iau/cbet/003200/CBET003205.txt','supernova',NULL,0.027,NULL,NULL,'http://farm8.staticflickr.com/7109/7791806424_61bd503ee8_b.jpg',NULL,NULL,50738665227,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,792791644,12387369,NULL,NULL,NULL,NULL),(1537,1535,0,'SNHunt145','CBET',311.31367,-5.62281,NULL,NULL,'2012-08-17 23:16:48',56156.97,NULL,NULL,NULL,0.027,NULL,'Ia',NULL,'2012-09-06 10:09:06','2012-09-06 10:09:06','http://www.cbat.eps.harvard.edu/iau/cbet/003200/CBET003205.txt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50738665227,'Ekar_1p8m','AFOSC','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,792791644,12387369,NULL,NULL,NULL,NULL),(1538,1538,0,'CSS120813-153936-024101','CRTS-CSS',234.90189,-2.68354,NULL,NULL,'2012-08-13 00:00:00',56152,17.7,NULL,'R',NULL,NULL,NULL,NULL,'2012-09-06 04:13:41','2019-10-12 20:41:36','http://voeventnet.caltech.edu/feeds/ATEL/CRTS/1208130010844101062.atel.html','supernova',NULL,0,NULL,NULL,'http://voeventnet.caltech.edu/feeds/ATEL/CRTS/1208130010844101062/1208130010844101062-0001.arch.jpg',NULL,NULL,45413652819,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,709588325,11087317,NULL,NULL,NULL,NULL),(1539,1538,0,'CSS120813-153936-024101','atel',234.90189,-2.68354,NULL,NULL,'2012-08-17 00:00:00',56156,NULL,NULL,NULL,0.015,NULL,'II',NULL,'2012-09-06 10:16:27','2012-09-06 10:16:27','http://www.astronomerstelegram.org/?read=4312',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,45413652819,'Ekar_1p8m','AFOSC','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,709588325,11087317,NULL,NULL,NULL,NULL),(1540,685,0,'PS1_12bcg','Pan-STARRS1',34.62608,-0.45614,NULL,NULL,'2012-08-04 14:24:00',56143.6,18,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-06 10:20:30','2019-08-19 23:13:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1021830260002722100/','variable star',NULL,0,NULL,NULL,'http://star.pst.qub.ac.uk/sne/ps1fgss/site_media/images/data/ps1fgss/56143/1021830260002722100_56143.597_504674_158_target.fits',NULL,NULL,34914087818,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,545532622,8523947,NULL,NULL,NULL,NULL),(1541,685,0,'PS1-12bcg','Pan-STARRS1',34.6261005007,-0.45615004647,NULL,NULL,'2012-08-21 00:00:00',56160,NULL,NULL,NULL,0,NULL,'variable star',NULL,'2012-09-06 10:23:47','2019-08-19 23:13:53','http://star.pst.qub.ac.uk/sne/ps1fgss/psdb/candidate/1021830260002722100/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34914087818,'WHT','ISIS','Darryl Wright',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,545532622,8523947,NULL,NULL,NULL,NULL),(1542,1542,0,'PSNJ15395722-3033192','TOCP',234.98842,-30.55533,NULL,NULL,'2012-08-18 09:35:59',56157.4,17.2,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2012-09-06 04:29:40','2019-10-12 20:41:36','http://www.cbat.eps.harvard.edu/iau/cbet/003200/CBET003213.txt','supernova',NULL,0.0182,NULL,NULL,'http://spaceobs.org/images/TOCP/PSNJ15395722-3033192-20120820.png',NULL,NULL,47175762859,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,737121294,11517520,NULL,NULL,NULL,NULL),(1543,1542,0,'PSNJ15395722-3033192','CBET',234.98842,-30.55533,NULL,NULL,'2012-08-25 00:00:00',56164,NULL,NULL,NULL,0.0182,NULL,'Ia',NULL,'2012-09-06 10:30:43','2012-09-06 10:30:43','http://www.cbat.eps.harvard.edu/iau/cbet/003200/CBET003213.txt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,47175762859,'NTT','EFOSC2 Gr13','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,737121294,11517520,NULL,NULL,NULL,NULL),(1544,1544,0,'PSNJ14242911-1645392','TOCP',216.12129,-16.76089,NULL,NULL,'2012-08-12 00:00:00',56151,16.3,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2012-09-06 11:38:53','2019-10-12 20:41:36','http://www.cbat.eps.harvard.edu/unconf/followups/J14242911-1645392.html','supernova',NULL,0.0089,NULL,NULL,'http://www.rochesterastronomy.org/sn2012/n5597s2.jpg',NULL,NULL,46556516621,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,727445572,11366337,NULL,NULL,NULL,NULL),(1545,1544,0,'PSNJ14242911-1645392','TOCP',216.12129,-16.76089,NULL,NULL,'2012-08-24 00:00:00',56163,NULL,NULL,NULL,0.008,NULL,'IIb',NULL,'2012-09-06 10:39:55','2012-09-06 10:39:55','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,46556516621,'NTT','EFOSC2 Gr13','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,727445572,11366337,NULL,NULL,NULL,NULL),(1546,332,0,'CSS120825-221242+003043','CRTS-CSS',333.17314,0.51201,NULL,NULL,'2012-08-25 00:00:00',56164,15.8,NULL,'R',NULL,NULL,NULL,NULL,'2012-09-06 10:42:18','2012-09-06 10:42:18','http://voeventnet.caltech.edu/feeds/ATEL/CRTS/1208251011194110586.atel.html','supernova',NULL,0,NULL,NULL,'http://voeventnet.caltech.edu/feeds/ATEL/CRTS/1208251011194110586/1208251011194110586-0001.arch.jpg',NULL,NULL,52152344378,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814880380,12732505,NULL,NULL,NULL,NULL),(1547,1547,1,'PSNJ02263653+1208555','TOCP',36.65221,12.14875,NULL,NULL,'2012-08-27 00:00:00',56166,17.6,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2012-09-06 10:47:11','2019-10-11 14:10:04','http://www.cbat.eps.harvard.edu/unconf/followups/J02263653 1208555.html','supernova',NULL,0.0275,NULL,NULL,'http://www.astrofilisenesi.it/public/Sne/Uploads/PSN_in_NGC0927.jpg',NULL,NULL,67947771383,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1061683927,16588811,NULL,NULL,NULL,NULL),(1548,1547,0,'PSNJ02263653+1208555','atel',36.65221,12.14875,NULL,NULL,'2012-08-29 00:00:00',56168,NULL,NULL,NULL,0.028,NULL,'Ia',NULL,'2012-09-06 10:48:25','2012-09-06 10:48:25','http://www.astronomerstelegram.org/?read=4348',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67947771383,'UH_2p2m','SNIFS','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1061683927,16588811,NULL,NULL,NULL,NULL),(1549,1549,1,'PSNJ03412317-1745348','TOCP',55.34654,-17.75967,NULL,NULL,'2012-08-27 00:00:00',56166,17.4,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2012-09-06 12:16:38','2019-10-11 14:10:04','http://www.cbat.eps.harvard.edu/unconf/followups/J03412317-1745348.html','supernova',NULL,0.0239,NULL,NULL,'http://farm9.staticflickr.com/8300/7876367506_0d898dff7d_b.jpg',NULL,NULL,38011729532,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,593933273,9280207,NULL,NULL,NULL,NULL),(1550,1550,0,'PSNJ04371913-6908254','TOCP',69.32971,-69.14039,NULL,NULL,'2012-08-27 00:00:00',56166,17.5,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2012-09-06 11:18:29','2019-10-12 20:41:36','http://www.cbat.eps.harvard.edu/unconf/followups/J04371913-6908254.html','supernova',NULL,0.0605,NULL,NULL,'http://farm9.staticflickr.com/8462/7891154554_bffc0ecc94_b.jpg',NULL,NULL,36436638088,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,569322470,8895663,NULL,NULL,NULL,NULL),(1551,1551,1,'SNhunt146','SNHunt',49.713,-13.06312,NULL,NULL,'2012-08-28 00:00:00',56167,18.2,NULL,'R',NULL,NULL,NULL,NULL,'2012-09-06 11:36:30','2019-10-11 14:10:04','http://nesssi.cacr.caltech.edu/catalina/Current/20120828_350.html','supernova',NULL,0.0311,NULL,NULL,'http://farm9.staticflickr.com/8178/7893886008_c1d2e25a82_b.jpg',NULL,NULL,38082367977,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,595036999,9297453,NULL,NULL,NULL,NULL),(1552,1552,1,'SNhunt147','SNhunt',218.84541,-13.73247,NULL,NULL,'2012-09-03 00:00:00',56173,17,NULL,'R',NULL,NULL,NULL,NULL,'2012-09-06 05:38:59','2019-10-11 14:10:04','http://nesssi.cacr.caltech.edu/catalina/Current/20120903_9.html','supernova',NULL,0.0139,NULL,NULL,'http://nesssi.cacr.caltech.edu/catalina/20010863/jpg/108630131074105149_20120903_01_4.jpg',NULL,NULL,46677585064,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,729337266,11395894,NULL,NULL,NULL,NULL),(1553,1553,1,'SSS120828-233202-454503','CRTS-SSS',353.00907,-45.75089,NULL,NULL,'2012-08-28 00:00:00',56167,17.8,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-06 06:11:54','2019-10-11 14:10:04','http://crts.caltech.edu/ATEL/SSS/1208280451264106073.atel.html','supernova',NULL,0,NULL,NULL,'http://crts.caltech.edu/ATEL/SSS/1208280451264106073/1208280451264106073-0001.arch.jpg',NULL,NULL,50476903066,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,788701610,12323462,NULL,NULL,NULL,NULL),(1554,1554,0,'SSS120827-010014-304831','CRTS-SSS',15.05988,-30.80858,NULL,NULL,'2012-08-27 00:00:00',56166,15.4,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-06 08:18:13','2019-10-12 20:41:36','http://crts.caltech.edu/ATEL/SSS/1208270090244119566.atel.html','supernova',NULL,0.0322,NULL,NULL,'http://crts.caltech.edu/ATEL/SSS/1208270310074114752/1208270310074114752-0003.arch.jpg',NULL,NULL,34740993705,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542828026,8481687,NULL,NULL,NULL,NULL),(1555,1555,0,'SSS120827-031304-082332','CRTS-SSS',48.26734,-8.39214,NULL,NULL,'2012-08-27 00:00:00',56166,17.2,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-06 14:20:18','2019-10-12 20:41:36','http://crts.caltech.edu/ATEL/SSS/1208270090244119566.atel.html','supernova',NULL,0.0299,NULL,NULL,'http://crts.caltech.edu/ATEL/SSS/1208270090244119566/1208270090244119566-0001.arch.jpg',NULL,NULL,37888921026,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,592014391,9250224,NULL,NULL,NULL,NULL),(1556,1556,0,'CSS120828-231622+241519','CRTS-CSS',349.09205,24.25517,NULL,NULL,'2012-08-28 00:00:00',56167,18.8,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-06 15:26:41','2019-10-12 20:41:36','http://voeventnet.caltech.edu/feeds/ATEL/CRTS/1208281231154134578.atel.html','supernova',NULL,0,NULL,NULL,'http://voeventnet.caltech.edu/feeds/ATEL/CRTS/1208281231154134578/1208281231154134578-0001.arch.jpg',NULL,NULL,51977526954,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,812148858,12689825,NULL,NULL,NULL,NULL),(1557,1557,1,'LSQ12evn','LSQ',311.892625,-17.1578611111111,NULL,NULL,'2012-08-07 04:13:27',56146.1760100001,19.3367,0.0806,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 15:45:34','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_history.html','sn',NULL,0.044828,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_snap_56019.gif',50992570481,NULL,NULL,NULL,'2012-08-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,796758913,12449358,NULL,NULL,NULL,NULL),(1558,1557,0,'LSQ12evn','LSQ',311.892875,-17.1579166666667,NULL,NULL,'2012-08-09 01:56:36',56148.0809800001,18.3122,0.0429,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 15:45:34','2012-09-06 15:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_history.html','sn',NULL,0.044828,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_snap_56020.gif',50992570481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,796758913,12449358,NULL,NULL,NULL,NULL),(1559,1557,0,'LSQ12evn','LSQ',311.892791666667,-17.1581388888889,NULL,NULL,'2012-08-10 23:48:07',56149.99175,18.6705,0.0692,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 15:45:34','2012-09-06 15:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_history.html','sn',NULL,0.044828,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_snap_56021.gif',50992570481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,796758913,12449358,NULL,NULL,NULL,NULL),(1560,1557,0,'LSQ12evn','LSQ',311.892708333333,-17.1578333333333,NULL,NULL,'2012-08-15 00:32:29',56154.02256,17.9943,0.0305,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 15:45:34','2012-09-06 15:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_history.html','sn',NULL,0.044828,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_snap_56022.gif',50992570481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,796758913,12449358,NULL,NULL,NULL,NULL),(1561,1557,0,'LSQ12evn','LSQ',311.892708333333,-17.1579166666667,NULL,NULL,'2012-08-19 00:15:40',56158.01088,17.9733,0.0319,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 15:45:34','2012-09-06 15:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_history.html','sn',NULL,0.044828,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_snap_56023.gif',50992570481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,796758913,12449358,NULL,NULL,NULL,NULL),(1562,1557,0,'LSQ12evn','LSQ',311.892708333333,-17.1577222222222,NULL,NULL,'2012-08-21 01:09:14',56160.0480900002,17.8513,0.0441,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 15:45:34','2012-09-06 15:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_history.html','sn',NULL,0.044828,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_snap_56024.gif',50992570481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,796758913,12449358,NULL,NULL,NULL,NULL),(1563,1557,0,'LSQ12evn','LSQ',311.892625,-17.1578055555556,NULL,NULL,'2012-08-27 02:13:51',56166.09296,17.7691,0.0717,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 15:45:34','2012-09-06 15:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_history.html','sn',NULL,0.044828,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_snap_56025.gif',50992570481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,796758913,12449358,NULL,NULL,NULL,NULL),(1564,1557,0,'LSQ12evn','LSQ',311.892708333333,-17.1579166666667,NULL,NULL,'2012-09-04 23:58:44',56174.9991299999,18.5252,0.0473,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 15:45:34','2012-09-06 15:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_history.html','sn',NULL,0.044828,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_snap_56003.gif',50992570481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,796758913,12449358,NULL,NULL,NULL,NULL),(1565,1557,0,'LSQ12evn','LSQ',311.89275,-17.1578055555556,NULL,NULL,'2012-09-05 02:00:03',56175.0833700001,18.3605,0.041,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 15:45:34','2012-09-06 15:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_history.html','sn',NULL,0.044828,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_snap_56004.gif',50992570481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,796758913,12449358,NULL,NULL,NULL,NULL),(1566,1566,1,'LSQ12evm','LSQ',336.765708333333,-23.6769444444444,NULL,NULL,'2012-09-05 04:04:12',56175.1695900001,19.32,0.1324,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 15:45:34','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evm/LSQ12evm_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evm/LSQ12evm_snap_56001.gif',50212210897,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,784565795,12258840,NULL,NULL,NULL,NULL),(1567,1566,0,'LSQ12evm','LSQ',336.765708333333,-23.6769444444444,NULL,NULL,'2012-09-05 06:04:32',56175.2531499998,19.3216,0.107,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 15:45:34','2012-09-06 15:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evm/LSQ12evm_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evm/LSQ12evm_snap_56002.gif',50212210897,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,784565795,12258840,NULL,NULL,NULL,NULL),(1568,1568,1,'LSQ12evl','LSQ',309.547291666667,-20.9068333333333,NULL,NULL,'2012-09-04 23:58:44',56174.9991299999,20.3684,0.1308,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 15:45:34','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_snap_55999.gif',50824114763,NULL,NULL,NULL,'2012-08-27 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,794126793,12408231,NULL,NULL,NULL,NULL),(1569,1568,0,'LSQ12evl','LSQ',309.54725,-20.9068611111111,NULL,NULL,'2012-09-05 02:00:03',56175.0833700001,20.377,0.1235,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 15:45:34','2012-09-06 15:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_snap_56000.gif',50824114763,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,794126793,12408231,NULL,NULL,NULL,NULL),(1570,1570,1,'LSQ12evo','LSQ',317.5235,-25.5899,NULL,NULL,'2012-08-27 12:00:00',56166.5,19.9,NULL,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 10:04:41','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_history.html','supernova',NULL,0,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_snap_56005.gif',NULL,NULL,51425622868,NULL,NULL,NULL,'2012-08-19 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,803525357,12555083,NULL,NULL,NULL,NULL),(1571,1570,0,'LSQ12evo','LSQ',317.523458333333,-25.5899444444444,NULL,NULL,'2012-08-27 00:35:14',56166.0244700001,19.9346,0.1686,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 16:45:34','2012-09-06 16:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_snap_56026.gif',51425622868,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,803525357,12555083,NULL,NULL,NULL,NULL),(1572,1570,0,'LSQ12evo','LSQ',317.523416666667,-25.5899722222222,NULL,NULL,'2012-09-05 00:26:03',56175.0181,18.9462,0.1015,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 16:45:34','2012-09-06 16:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_snap_56005.gif',51425622868,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,803525357,12555083,NULL,NULL,NULL,NULL),(1573,1570,0,'LSQ12evo','LSQ',317.523333333333,-25.5900277777778,NULL,NULL,'2012-09-05 02:35:25',56175.1079299999,19.2899,0.0961,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 16:45:34','2012-09-06 16:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_snap_56006.gif',51425622868,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,803525357,12555083,NULL,NULL,NULL,NULL),(1574,1511,0,'PSNJ21015899-4816259','TOCP',315.49579,-48.273861,NULL,NULL,'2012-08-19 12:00:00',56158.5,15.3,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2012-09-06 19:51:11','2012-09-06 19:51:11','http://www.astronomerstelegram.org/?read=4339','supernova',NULL,0.01859,NULL,NULL,'https://c2.staticflickr.com/8/7136/7848777388_141ec55ba6_o.jpg',NULL,NULL,51351056248,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,802360253,12536878,NULL,NULL,NULL,NULL),(1575,1430,0,'LSQ12eve','LSQ',328.319208333,-21.7153611111,NULL,NULL,'2012-09-07 00:00:00',56177,NULL,NULL,NULL,0.098,NULL,'Ia',NULL,'2012-09-06 21:41:38','2012-09-06 21:41:38','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50881668328,'ANU','WiFeS','Childress',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,795026067,12422282,NULL,NULL,NULL,NULL),(1576,1375,0,'LSQ12ers','LSQ',345.5155,-22.8755277778,NULL,NULL,'2012-09-07 00:00:00',56177,NULL,NULL,NULL,0.099,NULL,'Ia',NULL,'2012-09-06 21:46:31','2012-09-06 21:46:31','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50214718088,'ANU','WiFeS','Childress',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,784604970,12259452,NULL,NULL,NULL,NULL),(1577,1447,0,'LSQ12euv','LSQ',328.523791666667,-5.834,NULL,NULL,'2012-09-06 03:00:36',56176.1254199999,20.0188,0.1846,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-06 22:45:34','2012-09-06 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euv/LSQ12euv_history.html','sn?',NULL,0.357,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euv/LSQ12euv_snap_56031.gif',49890107101,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,779532923,12180201,NULL,NULL,NULL,NULL),(1578,1355,0,'LSQ12erl','LSQ',328.12325,-22.1982222222,NULL,NULL,'2012-09-06 00:00:00',56176,NULL,NULL,NULL,0.073,NULL,'unknown',NULL,'2012-09-06 23:24:10','2012-09-06 23:24:10','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50881760614,'ANU_2p2m','WiFeS','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,795027509,12422304,NULL,NULL,NULL,NULL),(1579,1451,0,'LSQ12euu','LSQ',322.784083333,-6.70402777778,NULL,NULL,'2012-09-06 00:00:00',56176,NULL,NULL,NULL,0.098,NULL,'Ia',NULL,'2012-09-06 23:26:20','2012-09-06 23:26:20','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49683505270,'ANU_2p2m','WiFeS','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,776304769,12129762,NULL,NULL,NULL,NULL),(1580,1447,0,'LSQ12euv','LSQ',328.523833333,-5.83372222222,NULL,NULL,'2012-09-06 00:00:00',56176,NULL,NULL,NULL,0.137,NULL,'unknown',NULL,'2012-09-06 23:30:11','2012-09-06 23:30:11','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49890107103,'ANU_2p2m','WiFeS','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,779532923,12180201,NULL,NULL,NULL,NULL),(1581,1413,0,'LSQ12etc','LSQ',335.135791667,0.552944444444,NULL,NULL,'2012-09-06 00:00:00',56176,NULL,NULL,NULL,0,NULL,'variable star',NULL,'2012-09-06 23:31:43','2012-09-06 23:31:43','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52145872977,'ANU_2p2m','WiFeS','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,814779265,12730926,NULL,NULL,NULL,NULL),(1582,1454,0,'LSQ12eus','LSQ',335.192208333,0.522361111111,NULL,NULL,'2012-09-06 00:00:00',56176,NULL,NULL,NULL,0,NULL,'variable star',NULL,'2012-09-06 23:32:44','2012-09-06 23:32:44','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52145877361,'ANU_2p2m','WiFeS','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,814779333,12730927,NULL,NULL,NULL,NULL),(1583,1351,0,'LSQ12erp','LSQ',347.613333333,-22.173,NULL,NULL,'2012-09-06 00:00:00',56176,NULL,NULL,NULL,0,NULL,'variable star',NULL,'2012-09-06 23:37:21','2012-09-06 23:37:21','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50300580081,'ANU_2p2m','WiFeS','Anon Reducer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,785946563,12280415,NULL,NULL,NULL,NULL),(1584,1584,1,'PTF12iiq','PTF',42.532333,-0.265124,NULL,NULL,'2012-08-31 00:00:00',56170,18,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-07 08:40:11','2019-10-11 14:10:04','http://navtara.caltech.edu/cgi-bin/ptf/view_source.cgi?name=12iiq','supernova',NULL,0.0291,NULL,NULL,'http://navtara.caltech.edu/ptf/thumbs/12iiq_ref.png',NULL,NULL,34897860426,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,545279069,8519985,NULL,NULL,NULL,NULL),(1585,1584,0,'PTF12iiq','PTF',42.532333,-0.265124,NULL,NULL,'2012-09-01 00:00:00',56171,NULL,NULL,NULL,0.0291,NULL,'Ia',NULL,'2012-09-07 08:43:38','2012-09-07 08:43:38','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34897860426,'UH88','SNIFS','None',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,545279069,8519985,NULL,NULL,NULL,NULL),(1586,1554,0,'SSS120827-010014-304831','CRTS-SSS',15.05988,-30.80858,NULL,NULL,'2012-09-08 00:00:00',56178,NULL,NULL,NULL,0.033,NULL,'Ia',NULL,'2012-09-08 06:20:06','2012-09-08 06:20:06','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34740993705,'ANU','WiFeS','Childress',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,542828026,8481687,NULL,NULL,NULL,NULL),(1587,1551,0,'SNhunt146','pessto',49.713,-13.06312,NULL,NULL,'2012-09-08 00:00:00',56178,NULL,NULL,NULL,0.032,NULL,'Ia',NULL,'2012-09-08 08:23:23','2012-09-08 08:23:23','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38082367977,'NTT','EFOSC','Yen Chen Pan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,595036999,9297453,NULL,NULL,NULL,NULL),(1588,1423,0,'SSS120817-002822-305723','pessto',7.09095,-30.95642,NULL,NULL,'2012-09-08 19:11:59',56178.8,NULL,NULL,NULL,0.05,NULL,'Ia',NULL,'2012-09-08 08:55:26','2012-09-08 08:55:26','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34889867327,'NTT','EFOSC','Yen Chen Pan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,545154176,8518034,NULL,NULL,NULL,NULL),(1589,1174,0,'LSQ12eor','pessto',57.7149166667,-16.9243611111,NULL,NULL,'2012-09-08 19:11:59',56178.8,NULL,NULL,NULL,0.04,NULL,'II',NULL,'2012-09-08 10:04:01','2012-09-08 10:04:01','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36881294756,'NTT','EFOSC','Yen Chen Pan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,576270230,9004222,NULL,NULL,NULL,NULL),(1590,1566,0,'LSQ12evm','LSQ',336.765833333333,-23.6768611111111,NULL,NULL,'2012-09-07 04:06:19',56177.1710600001,19.577,0.1364,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-09 08:45:36','2012-09-09 08:45:36','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evm/LSQ12evm_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evm/LSQ12evm_snap_56052.gif',50212210897,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,784565795,12258840,NULL,NULL,NULL,NULL),(1591,644,0,'LSQ12eij','LSQ',353.852458333333,-20.5113611111111,NULL,NULL,'2012-09-08 07:33:10',56178.3147,20.3859,0.1572,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-09 13:45:32','2012-09-09 13:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eij/LSQ12eij_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eij/LSQ12eij_snap_56069.gif',50275077896,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785548092,12274188,NULL,NULL,NULL,NULL),(1592,644,0,'LSQ12eij','LSQ',353.852375,-20.5112777777778,NULL,NULL,'2012-09-09 02:59:55',56179.1249500001,19.8286,0.072,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 03:45:32','2012-09-10 03:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eij/LSQ12eij_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eij/LSQ12eij_snap_56073.gif',50275077940,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785548092,12274188,NULL,NULL,NULL,NULL),(1593,644,0,'LSQ12eij','LSQ',353.8525,-20.5113888888889,NULL,NULL,'2012-09-09 05:02:23',56179.2099899999,20.3366,0.0952,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 03:45:32','2012-09-10 03:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eij/LSQ12eij_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eij/LSQ12eij_snap_56074.gif',50275077896,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785548092,12274188,NULL,NULL,NULL,NULL),(1594,823,0,'LSQ12ejw','LSQ',357.601041666667,-24.6792777777778,NULL,NULL,'2012-09-09 00:57:23',56179.0398599999,19.0272,0.1165,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 03:45:32','2012-09-10 03:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_snap_56082.gif',50012665062,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,781447891,12210123,NULL,NULL,NULL,NULL),(1595,823,0,'LSQ12ejw','LSQ',357.600958333333,-24.6792777777778,NULL,NULL,'2012-09-09 02:59:55',56179.1249500001,17.0898,0.0818,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 03:45:32','2012-09-10 03:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_snap_56083.gif',50012664937,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,781447889,12210123,NULL,NULL,NULL,NULL),(1596,1557,0,'LSQ12evn','LSQ',311.892625,-17.1579166666667,NULL,NULL,'2012-09-09 00:00:42',56179.00049,18.733,0.048,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 03:45:32','2012-09-10 03:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_history.html','sn',NULL,0.044828,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_snap_56086.gif',50992570481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,796758913,12449358,NULL,NULL,NULL,NULL),(1597,1570,0,'LSQ12evo','LSQ',317.523458333333,-25.59,NULL,NULL,'2012-09-09 00:27:59',56179.0194399999,19.3742,0.1397,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 03:45:32','2012-09-10 03:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_snap_56084.gif',51425622868,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,803525357,12555083,NULL,NULL,NULL,NULL),(1598,1483,0,'SSS120816-012937-175040','pessto',22.40618,-17.84455,NULL,NULL,'2012-09-10 19:11:59',56180.8,NULL,NULL,NULL,0.07,NULL,'Ia',NULL,'2012-09-10 08:56:25','2012-09-10 08:56:25','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35194431803,'NTT','EFOSC','Yen Chen',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,549912996,8592390,NULL,NULL,NULL,NULL),(1599,1599,1,'LSQ12evr','LSQ',27.4370833333333,-27.5272777777778,NULL,NULL,'2012-09-08 03:31:19',56178.1467499998,21.0924,0.1373,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evr/LSQ12evr_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evr/LSQ12evr_snap_56113.gif',38254315647,NULL,NULL,NULL,'2012-09-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,597723681,9339432,NULL,NULL,NULL,NULL),(1600,1599,0,'LSQ12evr','LSQ',27.437,-27.5274722222222,NULL,NULL,'2012-09-08 05:59:17',56178.24951,20.6734,0.1226,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evr/LSQ12evr_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evr/LSQ12evr_snap_56114.gif',38254315647,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,597723681,9339432,NULL,NULL,NULL,NULL),(1601,1599,0,'LSQ12evr','LSQ',27.4364583333333,-27.5276388888889,NULL,NULL,'2012-09-09 03:11:37',56179.13307,20.9836,0.1359,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evr/LSQ12evr_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evr/LSQ12evr_snap_56186.gif',38254315645,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,597723681,9339432,NULL,NULL,NULL,NULL),(1602,1602,1,'LSQ12ewh','LSQ',353.865916666667,-24.3461666666667,NULL,NULL,'2012-08-12 04:45:39',56151.1983699999,21.1629,0.1026,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_snap_56178.gif',50055645510,NULL,NULL,NULL,'2012-08-12 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,782119461,12220616,NULL,NULL,NULL,NULL),(1603,1602,0,'LSQ12ewh','LSQ',353.866,-24.3461666666667,NULL,NULL,'2012-08-12 07:05:27',56151.2954600002,20.9767,0.0988,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_snap_56179.gif',50055645510,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,782119461,12220616,NULL,NULL,NULL,NULL),(1604,1602,0,'LSQ12ewh','LSQ',353.866,-24.3461666666667,NULL,NULL,'2012-08-12 09:06:52',56151.37977,21.0498,0.1025,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_snap_56180.gif',50055645510,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,782119461,12220616,NULL,NULL,NULL,NULL),(1605,1602,0,'LSQ12ewh','LSQ',353.865958333333,-24.3461666666667,NULL,NULL,'2012-08-15 02:48:52',56154.1172699998,20.8443,0.1283,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_snap_56181.gif',50055645510,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,782119461,12220616,NULL,NULL,NULL,NULL),(1606,1602,0,'LSQ12ewh','LSQ',353.866,-24.3462222222222,NULL,NULL,'2012-08-18 08:44:28',56157.3642199999,20.5916,0.1097,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_snap_56182.gif',50055645510,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,782119461,12220616,NULL,NULL,NULL,NULL),(1607,1602,0,'LSQ12ewh','LSQ',353.866041666667,-24.3461944444444,NULL,NULL,'2012-09-09 00:57:23',56179.0398599999,20.8972,0.1433,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_snap_56147.gif',50055645510,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,782119461,12220616,NULL,NULL,NULL,NULL),(1608,1602,0,'LSQ12ewh','LSQ',353.866041666667,-24.3461944444444,NULL,NULL,'2012-09-09 02:59:55',56179.1249500001,21.0194,0.1549,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_snap_56148.gif',50055645510,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,782119461,12220616,NULL,NULL,NULL,NULL),(1609,1609,1,'LSQ12ewa','LSQ',353.000416666667,-3.63072222222222,NULL,NULL,'2012-08-28 04:00:32',56167.1670400002,19.2036,0.1532,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewa/LSQ12ewa_history.html','unknown',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewa/LSQ12ewa_snap_56157.gif',49416648630,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772135134,12064611,NULL,NULL,NULL,NULL),(1610,1609,0,'LSQ12ewa','LSQ',353.000125,-3.63072222222222,NULL,NULL,'2012-08-30 03:54:17',56169.1627000002,19.1511,0.1981,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewa/LSQ12ewa_history.html','unknown',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewa/LSQ12ewa_snap_56158.gif',49416648630,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772135134,12064611,NULL,NULL,NULL,NULL),(1611,1609,0,'LSQ12ewa','LSQ',353.000333333333,-3.63047222222222,NULL,NULL,'2012-09-05 03:26:34',56175.1434499999,19.3845,0.1537,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewa/LSQ12ewa_history.html','unknown',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewa/LSQ12ewa_snap_56159.gif',49416648630,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772135134,12064611,NULL,NULL,NULL,NULL),(1612,1609,0,'LSQ12ewa','LSQ',353,-3.63075,NULL,NULL,'2012-09-09 01:12:57',56179.0506600002,19.0752,0.1142,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewa/LSQ12ewa_history.html','unknown',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewa/LSQ12ewa_snap_56131.gif',49416648630,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772135134,12064611,NULL,NULL,NULL,NULL),(1613,1609,0,'LSQ12ewa','LSQ',353.000083333333,-3.63069444444444,NULL,NULL,'2012-09-09 03:15:35',56179.13583,19.1368,0.1036,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewa/LSQ12ewa_history.html','unknown',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewa/LSQ12ewa_snap_56132.gif',49416648630,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772135134,12064611,NULL,NULL,NULL,NULL),(1614,1614,1,'LSQ12evz','LSQ',25.7012916666667,-29.8614722222222,NULL,NULL,'2012-09-09 05:14:02',56179.21808,21.505,0.1389,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evz/LSQ12evz_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evz/LSQ12evz_snap_56129.gif',38265679391,NULL,NULL,NULL,'2012-09-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,597901240,9342206,NULL,NULL,NULL,NULL),(1615,1614,0,'LSQ12evz','LSQ',25.7015,-29.8613333333333,NULL,NULL,'2012-09-09 07:14:45',56179.3019099999,21.4629,0.1335,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evz/LSQ12evz_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evz/LSQ12evz_snap_56130.gif',38265679391,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,597901240,9342206,NULL,NULL,NULL,NULL),(1616,1616,1,'LSQ12evy','LSQ',25.0972916666667,-29.7412222222222,NULL,NULL,'2012-09-09 05:14:02',56179.21808,22.2878,0.1616,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_history.html','sn?',NULL,0.242061,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_snap_56127.gif',38265285488,NULL,NULL,NULL,'2012-09-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,597895085,9342110,NULL,NULL,NULL,NULL),(1617,1616,0,'LSQ12evy','LSQ',25.0970833333333,-29.74125,NULL,NULL,'2012-09-09 07:14:45',56179.3019099999,22.2821,0.1565,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_history.html','sn?',NULL,0.242061,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_snap_56128.gif',38265285488,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,597895085,9342110,NULL,NULL,NULL,NULL),(1618,1618,1,'LSQ12evw','LSQ',28.8267916666667,-29.9607222222222,NULL,NULL,'2012-09-09 05:14:02',56179.21808,20.2576,0.1175,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_56123.gif',38262027470,NULL,NULL,NULL,'2012-09-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1619,1618,0,'LSQ12evw','LSQ',28.826625,-29.9608333333333,NULL,NULL,'2012-09-09 07:14:45',56179.3019099999,20.4204,0.1463,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_56124.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1620,1620,1,'LSQ12evv','LSQ',28.7776666666667,-27.6871111111111,NULL,NULL,'2012-09-09 03:11:37',56179.13307,19.8694,0.1205,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_snap_56156.gif',38401172066,NULL,NULL,NULL,'2012-09-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,600018313,9375286,NULL,NULL,NULL,NULL),(1621,1620,0,'LSQ12evv','LSQ',28.7777083333333,-27.6870555555556,NULL,NULL,'2012-09-09 05:14:02',56179.21808,19.1619,0.1425,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_snap_56121.gif',38401172066,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,600018313,9375286,NULL,NULL,NULL,NULL),(1622,1620,0,'LSQ12evv','LSQ',28.77775,-27.6871666666667,NULL,NULL,'2012-09-09 07:14:45',56179.3019099999,17.8316,0.0826,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-10 20:45:29','2012-09-10 20:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_snap_56122.gif',38401172067,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,600018313,9375286,NULL,NULL,NULL,NULL),(1623,811,0,'LSQ12ejy','LSQ',355.411333333333,-22.7781388888889,NULL,NULL,'2012-09-10 03:02:21',56180.1266399999,18.4584,0.102,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 01:45:31','2012-09-12 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_56229.gif',50274702770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(1624,811,0,'LSQ12ejy','LSQ',355.411208333333,-22.7781388888889,NULL,NULL,'2012-09-10 05:23:14',56180.2244699998,18.3844,0.0916,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 01:45:31','2012-09-12 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_56230.gif',50274702770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(1625,817,0,'LSQ12ejx','LSQ',355.03875,-21.8748333333333,NULL,NULL,'2012-09-10 05:23:14',56180.2244699998,21.1731,0.176,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 01:45:31','2012-09-12 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_history.html','hostless sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_snap_56231.gif',50276293318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,785567083,12274485,NULL,NULL,NULL,NULL),(1626,1185,0,'LSQ12eom','LSQ',28.2500416666667,-18.1508888888889,NULL,NULL,'2012-09-10 04:11:53',56180.1749200001,20.2664,0.0837,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 01:45:31','2012-09-12 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eom/LSQ12eom_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eom/LSQ12eom_snap_56269.gif',35086441365,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,548225646,8566025,NULL,NULL,NULL,NULL),(1627,1185,0,'LSQ12eom','LSQ',28.2500416666667,-18.1509166666667,NULL,NULL,'2012-09-10 06:46:10',56180.2820700002,20.5726,0.097,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 01:45:31','2012-09-12 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eom/LSQ12eom_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eom/LSQ12eom_snap_56270.gif',35086441365,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,548225646,8566025,NULL,NULL,NULL,NULL),(1628,1185,0,'LSQ12eom','LSQ',28.25,-18.1509444444444,NULL,NULL,'2012-09-10 08:46:58',56180.3659600001,20.6035,0.1103,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 01:45:31','2012-09-12 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eom/LSQ12eom_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eom/LSQ12eom_snap_56271.gif',35086441365,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,548225646,8566025,NULL,NULL,NULL,NULL),(1629,1602,0,'LSQ12ewh','LSQ',353.866166666667,-24.3461111111111,NULL,NULL,'2012-09-10 00:58:50',56180.0408600001,21.2023,0.186,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 01:45:31','2012-09-12 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_snap_56238.gif',50055645961,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,782119468,12220616,NULL,NULL,NULL,NULL),(1630,1602,0,'LSQ12ewh','LSQ',353.866041666667,-24.3461388888889,NULL,NULL,'2012-09-10 03:02:21',56180.1266399999,21.3327,0.1287,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 01:45:31','2012-09-12 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_snap_56239.gif',50055645510,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,782119461,12220616,NULL,NULL,NULL,NULL),(1631,1602,0,'LSQ12ewh','LSQ',353.866083333333,-24.3461388888889,NULL,NULL,'2012-09-10 05:23:14',56180.2244699998,20.8947,0.1259,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 01:45:31','2012-09-12 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewh/LSQ12ewh_snap_56240.gif',50055645510,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,782119461,12220616,NULL,NULL,NULL,NULL),(1632,1609,0,'LSQ12ewa','LSQ',353.00025,-3.63058333333333,NULL,NULL,'2012-09-10 03:06:04',56180.12922,19.2179,0.1179,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 01:45:31','2012-09-12 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewa/LSQ12ewa_history.html','unknown',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewa/LSQ12ewa_snap_56246.gif',49416648630,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772135134,12064611,NULL,NULL,NULL,NULL),(1633,1614,0,'LSQ12evz','LSQ',25.7019166666667,-29.8614444444444,NULL,NULL,'2012-09-10 03:50:04',56180.1597799999,21.4401,0.1283,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 01:45:31','2012-09-12 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evz/LSQ12evz_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evz/LSQ12evz_snap_56258.gif',38265679391,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,597901240,9342206,NULL,NULL,NULL,NULL),(1634,1616,0,'LSQ12evy','LSQ',25.0973333333333,-29.7411111111111,NULL,NULL,'2012-09-10 06:08:34',56180.2559500001,21.9823,0.1055,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 01:45:31','2012-09-12 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_history.html','sn?',NULL,0.242061,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_snap_56241.gif',38265285480,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,597895085,9342110,NULL,NULL,NULL,NULL),(1635,1618,0,'LSQ12evw','LSQ',28.8266666666667,-29.9609166666667,NULL,NULL,'2012-09-10 03:50:04',56180.1597799999,20.1229,0.1279,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 01:45:31','2012-09-12 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_56244.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1636,1620,0,'LSQ12evv','LSQ',28.7777916666667,-27.6871666666667,NULL,NULL,'2012-09-10 03:50:04',56180.1597799999,19.9118,0.1833,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 01:45:31','2012-09-12 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_snap_56245.gif',38401172067,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,600018313,9375286,NULL,NULL,NULL,NULL),(1637,811,0,'LSQ12ejy','LSQ',355.411166666667,-22.7781388888889,NULL,NULL,'2012-09-11 00:52:31',56181.0364799998,19.0841,0.1378,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 14:45:30','2012-09-12 14:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_56327.gif',50274702770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(1638,811,0,'LSQ12ejy','LSQ',355.411125,-22.7780277777778,NULL,NULL,'2012-09-11 02:51:57',56181.1194199999,18.5558,0.098,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 14:45:30','2012-09-12 14:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_56328.gif',50274702770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(1639,811,0,'LSQ12ejy','LSQ',355.411541666667,-22.7781111111111,NULL,NULL,'2012-09-11 04:55:06',56181.2049400001,18.7264,0.1219,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 14:45:30','2012-09-12 14:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_56329.gif',50274702741,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(1640,1557,0,'LSQ12evn','LSQ',311.89275,-17.158,NULL,NULL,'2012-09-11 00:01:37',56181.0011300002,18.4682,0.0613,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 14:45:30','2012-09-12 14:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_history.html','sn',NULL,0.044828,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_snap_56336.gif',50992570481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,796758913,12449358,NULL,NULL,NULL,NULL),(1641,1568,0,'LSQ12evl','LSQ',309.547208333333,-20.9068611111111,NULL,NULL,'2012-09-11 00:01:37',56181.0011300002,20.0354,0.1142,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 14:45:30','2012-09-12 14:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_snap_56333.gif',50824114763,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,794126793,12408231,NULL,NULL,NULL,NULL),(1642,1570,0,'LSQ12evo','LSQ',317.5235,-25.5899166666667,NULL,NULL,'2012-09-11 00:29:07',56181.0202199998,19.5322,0.1425,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 14:45:30','2012-09-12 14:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_snap_56334.gif',51425622868,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,803525357,12555083,NULL,NULL,NULL,NULL),(1643,1616,0,'LSQ12evy','LSQ',25.097375,-29.7413055555556,NULL,NULL,'2012-09-11 03:47:14',56181.1578099998,22.7267,0.16,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 14:45:30','2012-09-12 14:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_history.html','sn?',NULL,0.242061,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_snap_56347.gif',38265285488,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,597895085,9342110,NULL,NULL,NULL,NULL),(1644,1618,0,'LSQ12evw','LSQ',28.8265416666667,-29.9608333333333,NULL,NULL,'2012-09-11 03:47:14',56181.1578099998,20.0191,0.1034,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 14:45:30','2012-09-12 14:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_56345.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1645,1618,0,'LSQ12evw','LSQ',28.8265416666667,-29.9608611111111,NULL,NULL,'2012-09-11 06:03:33',56181.2524700002,20.0995,0.1017,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-12 14:45:30','2012-09-12 14:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_56346.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1646,1646,1,'LSQ12ewu','LSQ',317.788875,-6.94127777777778,NULL,NULL,'2012-09-09 23:41:40',56179.98728,19.2513,0.1009,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 01:45:31','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewu/LSQ12ewu_history.html','sne - nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewu/LSQ12ewu_snap_56431.gif',50789486443,NULL,NULL,NULL,'2012-09-06 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'BS',NULL,0,NULL,0,793585725,12399776,NULL,NULL,NULL,NULL),(1647,1646,0,'LSQ12ewu','LSQ',317.788791666667,-6.94125,NULL,NULL,'2012-09-10 01:44:53',56180.07284,19.7413,0.1023,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 01:45:31','2012-09-13 01:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewu/LSQ12ewu_history.html','sne - nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewu/LSQ12ewu_snap_56432.gif',50789486443,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'BS',NULL,0,NULL,0,793585725,12399776,NULL,NULL,NULL,NULL),(1648,811,0,'LSQ12ejy','LSQ',355.411125,-22.7780833333333,NULL,NULL,'2012-09-12 02:46:35',56182.1156899999,18.3885,0.0984,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_56630.gif',50274702770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(1649,811,0,'LSQ12ejy','LSQ',355.411,-22.7781111111111,NULL,NULL,'2012-09-12 04:47:46',56182.1998399999,19.0365,0.1173,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_56631.gif',50274702771,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(1650,817,0,'LSQ12ejx','LSQ',355.038708333333,-21.8748611111111,NULL,NULL,'2012-09-12 02:46:35',56182.1156899999,21.6771,0.1933,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_history.html','hostless sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_snap_56626.gif',50276293318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,785567083,12274485,NULL,NULL,NULL,NULL),(1651,823,0,'LSQ12ejw','LSQ',357.601083333333,-24.6791944444444,NULL,NULL,'2012-09-12 00:47:01',56182.03266,19.6961,0.1207,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_snap_56643.gif',50012665062,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,781447891,12210123,NULL,NULL,NULL,NULL),(1652,823,0,'LSQ12ejw','LSQ',357.600875,-24.6791666666667,NULL,NULL,'2012-09-12 04:47:46',56182.1998399999,19.4731,0.149,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_snap_56644.gif',50012664937,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,781447889,12210123,NULL,NULL,NULL,NULL),(1653,915,0,'LSQ12elk','LSQ',31.3317916666667,-5.97233333333333,NULL,NULL,'2012-09-12 07:06:34',56182.29623,19.981,0.1444,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_snap_56659.gif',35137599396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(1654,915,0,'LSQ12elk','LSQ',31.33175,-5.97230555555556,NULL,NULL,'2012-09-12 08:28:27',56182.3530999999,20.0788,0.1532,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_snap_56660.gif',35137599396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(1655,1020,0,'LSQ12elo','LSQ',318.356708333333,-6.59952777777778,NULL,NULL,'2012-09-12 02:18:05',56182.0959000001,20.8569,0.1807,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elo/LSQ12elo_history.html','sne?',NULL,0.12145,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elo/LSQ12elo_snap_56689.gif',50789822544,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793590977,12399859,NULL,NULL,NULL,NULL),(1656,1026,0,'LSQ12elz','LSQ',329.397541666667,-0.839222222222222,NULL,NULL,'2012-09-12 00:21:47',56182.0151300002,20.4417,0.1242,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_history.html','sne?',NULL,0.21853,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_snap_56744.gif',49826069800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778532340,12164567,NULL,NULL,NULL,NULL),(1657,1289,0,'LSQ12erc','LSQ',8.77129166666667,1.48133333333333,NULL,NULL,'2012-09-12 09:08:34',56182.3809500001,18.1139,0.0478,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_snap_56765.gif',66590313565,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1040473649,16257400,NULL,NULL,NULL,NULL),(1658,1451,0,'LSQ12euu','LSQ',322.784166666667,-6.70405555555556,NULL,NULL,'2012-09-12 00:16:36',56182.0115299998,19.1328,0.083,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euu/LSQ12euu_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euu/LSQ12euu_snap_56585.gif',49683505265,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,776304769,12129762,NULL,NULL,NULL,NULL),(1659,1451,0,'LSQ12euu','LSQ',322.784125,-6.70402777777778,NULL,NULL,'2012-09-12 02:52:16',56182.1196300001,19.4809,0.0872,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euu/LSQ12euu_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euu/LSQ12euu_snap_56586.gif',49683505265,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,776304769,12129762,NULL,NULL,NULL,NULL),(1660,1458,0,'LSQ12eui','LSQ',51.856875,-11.5908888888889,NULL,NULL,'2012-09-12 06:27:54',56182.26938,19.6897,0.1587,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eui/LSQ12eui_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eui/LSQ12eui_snap_56645.gif',37886492397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,591976443,9249631,NULL,NULL,NULL,NULL),(1661,1458,0,'LSQ12eui','LSQ',51.8568333333333,-11.5907777777778,NULL,NULL,'2012-09-12 08:10:34',56182.3406799999,19.8122,0.1489,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eui/LSQ12eui_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eui/LSQ12eui_snap_56646.gif',37886492397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,591976443,9249631,NULL,NULL,NULL,NULL),(1662,1616,0,'LSQ12evy','LSQ',25.0973333333333,-29.7412777777778,NULL,NULL,'2012-09-12 02:58:28',56182.1239399998,22.4184,0.16,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_history.html','sn?',NULL,0.242061,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_snap_56678.gif',38265285488,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,597895085,9342110,NULL,NULL,NULL,NULL),(1663,1616,0,'LSQ12evy','LSQ',25.09725,-29.7411666666667,NULL,NULL,'2012-09-12 07:01:05',56182.2924299999,22.3386,0.1444,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_history.html','sn?',NULL,0.242061,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_snap_56679.gif',38265285488,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,597895085,9342110,NULL,NULL,NULL,NULL),(1664,1618,0,'LSQ12evw','LSQ',28.8264583333333,-29.96075,NULL,NULL,'2012-09-12 02:58:28',56182.1239399998,20.0436,0.103,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_56661.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1665,1618,0,'LSQ12evw','LSQ',28.8265833333333,-29.9608333333333,NULL,NULL,'2012-09-12 04:59:13',56182.2078,20.2989,0.1159,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_56662.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1666,1618,0,'LSQ12evw','LSQ',28.826375,-29.9608611111111,NULL,NULL,'2012-09-12 07:01:05',56182.2924299999,20.1173,0.0867,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_56663.gif',38262027462,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1667,1620,0,'LSQ12evv','LSQ',28.7778333333333,-27.68725,NULL,NULL,'2012-09-12 02:58:28',56182.1239399998,20.1932,0.2154,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_snap_56667.gif',38401172067,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,600018313,9375286,NULL,NULL,NULL,NULL),(1668,1620,0,'LSQ12evv','LSQ',28.7779166666667,-27.6872777777778,NULL,NULL,'2012-09-12 04:59:13',56182.2078,18.5187,0.118,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-13 22:45:29','2012-09-13 22:45:29','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_snap_56668.gif',38401172067,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,600018313,9375286,NULL,NULL,NULL,NULL),(1669,1669,0,'PSNJ02452841-6207214','TOCP',41.36838,-62.12261,NULL,NULL,'2012-07-17 00:00:00',56125,17.7,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2012-09-13 19:05:07','2020-01-13 20:37:59','http://www.cbat.eps.harvard.edu/unconf/followups/J02452841-6207214.html','supernova',NULL,0,NULL,NULL,'NULL',NULL,NULL,36260997780,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,566578090,8852782,NULL,NULL,NULL,NULL),(1670,1670,1,'LSQ12exp','LSQ',354.286416666667,-24.1555555555556,NULL,NULL,'2012-09-09 00:57:23',56179.0398599999,19.6143,0.0828,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_57021.gif',50055472816,NULL,NULL,NULL,'2012-09-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1671,1670,0,'LSQ12exp','LSQ',354.286291666667,-24.1555,NULL,NULL,'2012-09-10 03:02:21',56180.1266399999,19.2735,0.0617,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2012-09-14 17:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_57022.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1672,1670,0,'LSQ12exp','LSQ',354.286333333333,-24.1554166666667,NULL,NULL,'2012-09-10 05:23:14',56180.2244699998,19.6348,0.0705,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2012-09-14 17:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_57023.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1673,1670,0,'LSQ12exp','LSQ',354.286458333333,-24.1556111111111,NULL,NULL,'2012-09-11 00:52:31',56181.0364799998,19.2115,0.0671,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2012-09-14 17:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_57024.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1674,1670,0,'LSQ12exp','LSQ',354.28625,-24.1554722222222,NULL,NULL,'2012-09-11 02:51:57',56181.1194199999,19.7755,0.0636,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2012-09-14 17:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_57025.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1675,1670,0,'LSQ12exp','LSQ',354.286375,-24.1554444444444,NULL,NULL,'2012-09-11 04:55:06',56181.2049400001,19.7879,0.0733,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2012-09-14 17:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_57026.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1676,1670,0,'LSQ12exp','LSQ',354.286375,-24.1554722222222,NULL,NULL,'2012-09-12 00:47:01',56182.03266,19.7836,0.0757,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2012-09-14 17:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_56975.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1677,1670,0,'LSQ12exp','LSQ',354.286416666667,-24.1554444444444,NULL,NULL,'2012-09-12 02:46:35',56182.1156899999,19.9345,0.0622,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2012-09-14 17:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_56977.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1678,1670,0,'LSQ12exp','LSQ',354.286416666667,-24.1554722222222,NULL,NULL,'2012-09-12 04:47:46',56182.1998399999,19.8039,0.0613,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2012-09-14 17:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_56976.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1679,1679,1,'LSQ12exl','LSQ',356.054625,-24.201,NULL,NULL,'2012-09-09 02:59:55',56179.1249500001,20.8592,0.1938,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_57005.gif',50003648244,NULL,NULL,NULL,'2012-09-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1680,1679,0,'LSQ12exl','LSQ',356.054541666667,-24.2010555555556,NULL,NULL,'2012-09-09 05:02:23',56179.2099899999,21.4001,0.1509,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2012-09-14 17:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_57006.gif',50003648247,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1681,1679,0,'LSQ12exl','LSQ',356.054458333333,-24.2011388888889,NULL,NULL,'2012-09-10 00:58:50',56180.0408600001,20.3523,0.1561,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2012-09-14 17:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_57007.gif',50003648247,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1682,1679,0,'LSQ12exl','LSQ',356.054291666667,-24.2009722222222,NULL,NULL,'2012-09-11 00:52:31',56181.0364799998,20.1918,0.1302,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2012-09-14 17:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_57008.gif',50003648244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1683,1679,0,'LSQ12exl','LSQ',356.054375,-24.201,NULL,NULL,'2012-09-11 02:51:57',56181.1194199999,20.5268,0.0999,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2012-09-14 17:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_57009.gif',50003648244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1684,1679,0,'LSQ12exl','LSQ',356.054375,-24.201,NULL,NULL,'2012-09-12 00:47:01',56182.03266,19.8493,0.112,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2012-09-14 17:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_57010.gif',50003648244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1685,1679,0,'LSQ12exl','LSQ',356.054291666667,-24.2008888888889,NULL,NULL,'2012-09-12 02:46:35',56182.1156899999,20.4816,0.0774,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2012-09-14 17:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_56967.gif',50003648244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1686,1679,0,'LSQ12exl','LSQ',356.054375,-24.2009722222222,NULL,NULL,'2012-09-12 04:47:46',56182.1998399999,20.7048,0.108,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 17:45:30','2012-09-14 17:45:30','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_56968.gif',50003648244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1687,811,0,'LSQ12ejy','LSQ',355.411208333333,-22.7781388888889,NULL,NULL,'2012-09-13 00:48:47',56183.03388,19.2158,0.1288,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_57151.gif',50274702770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(1688,811,0,'LSQ12ejy','LSQ',355.411333333333,-22.7781111111111,NULL,NULL,'2012-09-13 02:50:13',56183.11821,19.2751,0.1365,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_57152.gif',50274702770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(1689,811,0,'LSQ12ejy','LSQ',355.411125,-22.7781111111111,NULL,NULL,'2012-09-13 04:50:55',56183.2020299998,18.7218,0.095,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_57153.gif',50274702770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(1690,817,0,'LSQ12ejx','LSQ',355.038583333333,-21.8748333333333,NULL,NULL,'2012-09-13 00:48:47',56183.03388,21.3566,0.2053,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_history.html','hostless sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_snap_57156.gif',50276293318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,785567083,12274485,NULL,NULL,NULL,NULL),(1691,817,0,'LSQ12ejx','LSQ',355.038541666667,-21.8748333333333,NULL,NULL,'2012-09-13 04:50:55',56183.2020299998,21.5041,0.1764,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_history.html','hostless sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_snap_57157.gif',50276293318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,785567083,12274485,NULL,NULL,NULL,NULL),(1692,823,0,'LSQ12ejw','LSQ',357.601166666667,-24.6794722222222,NULL,NULL,'2012-09-13 04:50:55',56183.2020299998,19.5998,0.0903,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_snap_57158.gif',50012665062,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,781447891,12210123,NULL,NULL,NULL,NULL),(1693,1205,0,'LSQ12eoc','LSQ',317.283541666667,-22.2569722222222,NULL,NULL,'2012-09-13 01:58:35',56183.0823599999,19.9808,0.1442,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_snap_57230.gif',50904231018,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,795378609,12427790,NULL,NULL,NULL,NULL),(1694,1557,0,'LSQ12evn','LSQ',311.892666666667,-17.1578611111111,NULL,NULL,'2012-09-13 03:37:49',56183.1512699998,18.6523,0.0526,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_history.html','sn',NULL,0.044828,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_snap_57161.gif',50992570481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,796758913,12449358,NULL,NULL,NULL,NULL),(1695,1568,0,'LSQ12evl','LSQ',309.547333333333,-20.9068333333333,NULL,NULL,'2012-09-13 01:21:21',56183.0564999999,20.268,0.128,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_snap_57163.gif',50824114763,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,794126793,12408231,NULL,NULL,NULL,NULL),(1696,1568,0,'LSQ12evl','LSQ',309.54725,-20.9068888888889,NULL,NULL,'2012-09-13 03:37:49',56183.1512699998,20.2802,0.1226,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_snap_57164.gif',50824114763,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,794126793,12408231,NULL,NULL,NULL,NULL),(1697,1570,0,'LSQ12evo','LSQ',317.523458333333,-25.5899722222222,NULL,NULL,'2012-09-13 01:56:54',56183.0811899998,19.5649,0.1367,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_snap_57162.gif',51425622868,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,803525357,12555083,NULL,NULL,NULL,NULL),(1698,1616,0,'LSQ12evy','LSQ',25.0973333333333,-29.7413333333333,NULL,NULL,'2012-09-13 02:54:11',56183.12097,22.7659,0.2098,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_history.html','sn?',NULL,0.242061,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_snap_57177.gif',38265285488,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,597895085,9342110,NULL,NULL,NULL,NULL),(1699,1616,0,'LSQ12evy','LSQ',25.0971666666667,-29.7411944444444,NULL,NULL,'2012-09-13 06:55:30',56183.2885500002,22.3304,0.1466,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_history.html','sn?',NULL,0.242061,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_snap_57178.gif',38265285488,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,597895085,9342110,NULL,NULL,NULL,NULL),(1700,1618,0,'LSQ12evw','LSQ',28.8265416666667,-29.9609444444444,NULL,NULL,'2012-09-13 02:54:11',56183.12097,20.2713,0.1194,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_57168.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1701,1618,0,'LSQ12evw','LSQ',28.8265416666667,-29.9609444444444,NULL,NULL,'2012-09-13 04:54:53',56183.2047899999,20.2327,0.1116,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_57169.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1702,1618,0,'LSQ12evw','LSQ',28.8265833333333,-29.9609166666667,NULL,NULL,'2012-09-13 06:55:30',56183.2885500002,20.5275,0.1258,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_57170.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1703,1670,0,'LSQ12exp','LSQ',354.286416666667,-24.1555555555556,NULL,NULL,'2012-09-13 00:48:47',56183.03388,19.464,0.0685,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_57231.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1704,1670,0,'LSQ12exp','LSQ',354.286458333333,-24.1554722222222,NULL,NULL,'2012-09-13 02:50:13',56183.11821,19.8106,0.0644,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_57232.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1705,1670,0,'LSQ12exp','LSQ',354.286291666667,-24.1553888888889,NULL,NULL,'2012-09-13 04:50:55',56183.2020299998,19.8525,0.0621,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_57233.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1706,1679,0,'LSQ12exl','LSQ',356.054291666667,-24.2009444444444,NULL,NULL,'2012-09-13 00:48:47',56183.03388,20.4031,0.1136,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_57247.gif',50003648244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1707,1679,0,'LSQ12exl','LSQ',356.054625,-24.2010555555556,NULL,NULL,'2012-09-13 02:50:13',56183.11821,20.8673,0.1187,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_57248.gif',50003648247,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1708,1679,0,'LSQ12exl','LSQ',356.054375,-24.201,NULL,NULL,'2012-09-13 04:50:55',56183.2020299998,20.7051,0.0949,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 19:45:31','2012-09-14 19:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_57249.gif',50003648244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1709,1709,1,'LSQ12ezm','LSQ',334.361625,-1.87375,NULL,NULL,'2012-09-02 00:47:04',56172.0326899998,18.3823,0.2102,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezm/LSQ12ezm_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezm/LSQ12ezm_snap_57413.gif',49800495953,NULL,NULL,NULL,'2012-08-30 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,778132749,12158324,NULL,NULL,NULL,NULL),(1710,1709,0,'LSQ12ezm','LSQ',334.361416666667,-1.87375,NULL,NULL,'2012-09-02 02:47:00',56172.1159799998,18.7045,0.1666,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezm/LSQ12ezm_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezm/LSQ12ezm_snap_57414.gif',49800495953,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,778132749,12158324,NULL,NULL,NULL,NULL),(1711,1709,0,'LSQ12ezm','LSQ',334.361625,-1.87375,NULL,NULL,'2012-09-12 01:34:22',56182.0655399999,18.7653,0.0509,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezm/LSQ12ezm_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezm/LSQ12ezm_snap_57395.gif',49800495953,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,778132749,12158324,NULL,NULL,NULL,NULL),(1712,1709,0,'LSQ12ezm','LSQ',334.361666666667,-1.87375,NULL,NULL,'2012-09-12 04:51:35',56182.2024900001,18.7179,0.0481,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezm/LSQ12ezm_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezm/LSQ12ezm_snap_57396.gif',49800495953,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,778132749,12158324,NULL,NULL,NULL,NULL),(1713,1713,1,'LSQ12ezk','LSQ',11.2832083333333,0.354638888888889,NULL,NULL,'2012-08-28 09:05:56',56167.3791299998,20.2206,0.1953,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezk/LSQ12ezk_history.html','sn??',NULL,0.06548,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezk/LSQ12ezk_snap_57411.gif',66672869557,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1041763586,16277556,NULL,NULL,NULL,NULL),(1714,1713,0,'LSQ12ezk','LSQ',11.2832916666667,0.354555555555556,NULL,NULL,'2012-09-12 05:42:23',56182.23777,19.2111,0.0608,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezk/LSQ12ezk_history.html','sn??',NULL,0.06548,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezk/LSQ12ezk_snap_57391.gif',66672869557,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1041763586,16277556,NULL,NULL,NULL,NULL),(1715,1713,0,'LSQ12ezk','LSQ',11.2832083333333,0.35475,NULL,NULL,'2012-09-12 07:41:45',56182.3206600002,20.1793,0.1145,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezk/LSQ12ezk_history.html','sn??',NULL,0.06548,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezk/LSQ12ezk_snap_57392.gif',66672869557,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1041763586,16277556,NULL,NULL,NULL,NULL),(1716,1716,1,'LSQ12ezi','LSQ',7.598375,-0.209361111111111,NULL,NULL,'2012-09-12 09:06:52',56182.3797800001,19.726,0.1489,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezi/LSQ12ezi_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezi/LSQ12ezi_snap_57387.gif',34400562260,NULL,NULL,NULL,'2012-09-04 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537508785,8398574,NULL,NULL,NULL,NULL),(1717,1716,0,'LSQ12ezi','LSQ',7.59820833333333,-0.209527777777778,NULL,NULL,'2012-09-12 09:23:36',56182.39139,19.4599,0.1461,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezi/LSQ12ezi_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezi/LSQ12ezi_snap_57388.gif',34400562260,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,537508785,8398574,NULL,NULL,NULL,NULL),(1718,1718,1,'LSQ12eyo','LSQ',43.8213333333333,-7.89752777777778,NULL,NULL,'2012-09-12 06:21:06',56182.2646599999,19.5083,0.1629,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eyo/LSQ12eyo_history.html','sn?',NULL,0.03116,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eyo/LSQ12eyo_snap_57329.gif',37913944767,NULL,NULL,NULL,'2012-09-04 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,592405386,9256334,NULL,NULL,NULL,NULL),(1719,1718,0,'LSQ12eyo','LSQ',43.8209583333333,-7.89738888888889,NULL,NULL,'2012-09-12 08:07:09',56182.33831,19.5292,0.1243,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eyo/LSQ12eyo_history.html','sn?',NULL,0.03116,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eyo/LSQ12eyo_snap_57330.gif',37913944767,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,592405386,9256334,NULL,NULL,NULL,NULL),(1720,1720,1,'LSQ12ezu','LSQ',355.0765,-21.1558888888889,NULL,NULL,'2012-08-27 07:25:19',56166.3092499999,19.8111,0.2153,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezu/LSQ12ezu_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezu/LSQ12ezu_snap_57457.gif',50277624863,NULL,NULL,NULL,'2012-08-09 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785587888,12274810,NULL,NULL,NULL,NULL),(1721,1720,0,'LSQ12ezu','LSQ',355.076625,-21.1560555555556,NULL,NULL,'2012-09-03 05:33:19',56173.2314800001,18.672,0.2121,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezu/LSQ12ezu_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezu/LSQ12ezu_snap_57458.gif',50277624862,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785587888,12274810,NULL,NULL,NULL,NULL),(1722,1720,0,'LSQ12ezu','LSQ',355.076625,-21.1560277777778,NULL,NULL,'2012-09-05 07:15:16',56175.3022699999,18.4493,0.1874,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezu/LSQ12ezu_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezu/LSQ12ezu_snap_57459.gif',50277624862,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785587888,12274810,NULL,NULL,NULL,NULL),(1723,1720,0,'LSQ12ezu','LSQ',355.076708333333,-21.1559444444444,NULL,NULL,'2012-09-13 09:03:28',56183.3774100002,18.334,0.0835,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezu/LSQ12ezu_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezu/LSQ12ezu_snap_57429.gif',50277624863,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785587888,12274810,NULL,NULL,NULL,NULL),(1724,1720,0,'LSQ12ezu','LSQ',355.076625,-21.1560277777778,NULL,NULL,'2012-09-13 09:08:32',56183.38093,18.6154,0.0955,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezu/LSQ12ezu_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezu/LSQ12ezu_snap_57430.gif',50277624862,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785587888,12274810,NULL,NULL,NULL,NULL),(1725,1725,1,'LSQ12ezs','LSQ',310.557625,-21.6615833333333,NULL,NULL,'2012-09-05 00:10:50',56175.0075300001,19.1517,0.0723,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_snap_57451.gif',50825557719,NULL,NULL,NULL,'2012-08-27 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,794149339,12408583,NULL,NULL,NULL,NULL),(1726,1725,0,'LSQ12ezs','LSQ',310.557791666667,-21.6615555555556,NULL,NULL,'2012-09-05 02:20:11',56175.09736,19.155,0.0911,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_snap_57452.gif',50825557717,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,794149339,12408583,NULL,NULL,NULL,NULL),(1727,1725,0,'LSQ12ezs','LSQ',310.557708333333,-21.6615555555556,NULL,NULL,'2012-09-09 00:12:46',56179.00887,18.9922,0.0545,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_snap_57453.gif',50825557717,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,794149339,12408583,NULL,NULL,NULL,NULL),(1728,1725,0,'LSQ12ezs','LSQ',310.557708333333,-21.6615277777778,NULL,NULL,'2012-09-11 00:13:43',56181.0095299999,18.9938,0.06,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_snap_57454.gif',50825557717,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,794149339,12408583,NULL,NULL,NULL,NULL),(1729,1725,0,'LSQ12ezs','LSQ',310.557666666667,-21.6615555555556,NULL,NULL,'2012-09-13 01:33:25',56183.06488,19.0037,0.0572,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_snap_57425.gif',50825557717,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,794149339,12408583,NULL,NULL,NULL,NULL),(1730,1725,0,'LSQ12ezs','LSQ',310.557666666667,-21.6615555555556,NULL,NULL,'2012-09-13 03:49:52',56183.1596300001,19.2097,0.0558,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_snap_57426.gif',50825557717,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,794149339,12408583,NULL,NULL,NULL,NULL),(1731,1731,1,'LSQ12ezr','LSQ',311.786416666667,-21.5498611111111,NULL,NULL,'2012-08-15 00:41:02',56154.0285,20.4077,0.1628,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezr/LSQ12ezr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezr/LSQ12ezr_snap_57449.gif',50825432373,NULL,NULL,NULL,'2012-08-13 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,794147380,12408552,NULL,NULL,NULL,NULL),(1732,1731,0,'LSQ12ezr','LSQ',311.786375,-21.5498333333333,NULL,NULL,'2012-08-19 00:24:06',56158.0167399999,20.9179,0.1975,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezr/LSQ12ezr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezr/LSQ12ezr_snap_57450.gif',50825432373,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,794147380,12408552,NULL,NULL,NULL,NULL),(1733,1731,0,'LSQ12ezr','LSQ',311.786458333333,-21.5498055555556,NULL,NULL,'2012-09-13 01:33:25',56183.06488,19.5185,0.0903,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezr/LSQ12ezr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezr/LSQ12ezr_snap_57423.gif',50825432373,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,794147380,12408552,NULL,NULL,NULL,NULL),(1734,1731,0,'LSQ12ezr','LSQ',311.786291666667,-21.5499722222222,NULL,NULL,'2012-09-13 03:49:52',56183.1596300001,19.0045,0.107,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezr/LSQ12ezr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezr/LSQ12ezr_snap_57424.gif',50825432373,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,794147380,12408552,NULL,NULL,NULL,NULL),(1735,1735,1,'LSQ12ezn','LSQ',54.439875,-37.26575,NULL,NULL,'2012-09-13 06:18:35',56183.26291,19.6147,0.0743,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezn/LSQ12ezn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezn/LSQ12ezn_snap_57415.gif',38556577295,NULL,NULL,NULL,'2012-09-09 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,602446520,9413226,NULL,NULL,NULL,NULL),(1736,1735,0,'LSQ12ezn','LSQ',54.4399166666667,-37.26575,NULL,NULL,'2012-09-13 08:10:50',56183.3408599999,19.6046,0.0686,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-14 21:45:32','2012-09-14 21:45:32','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezn/LSQ12ezn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezn/LSQ12ezn_snap_57416.gif',38556577295,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,602446520,9413226,NULL,NULL,NULL,NULL),(1737,788,0,'LSQ12ejo','LSQ',353.492125,-3.31552777777778,NULL,NULL,'2012-09-14 04:12:49',56184.17557,20.6825,0.1412,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_snap_57620.gif',49414528108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772102001,12064093,NULL,NULL,NULL,NULL),(1738,788,0,'LSQ12ejo','LSQ',353.492083333333,-3.31561111111111,NULL,NULL,'2012-09-14 06:14:11',56184.2598600001,20.6159,0.161,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejo/LSQ12ejo_snap_57621.gif',49414528108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,772102001,12064093,NULL,NULL,NULL,NULL),(1739,811,0,'LSQ12ejy','LSQ',355.411208333333,-22.7780833333333,NULL,NULL,'2012-09-14 02:32:58',56184.10623,18.9276,0.0982,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_57625.gif',50274702770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(1740,811,0,'LSQ12ejy','LSQ',355.411208333333,-22.7780555555556,NULL,NULL,'2012-09-14 04:34:44',56184.1907899999,18.4885,0.0936,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_57626.gif',50274702770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(1741,811,0,'LSQ12ejy','LSQ',355.411166666667,-22.7781666666667,NULL,NULL,'2012-09-14 06:34:25',56184.27391,19.2033,0.1012,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_57627.gif',50274702770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(1742,817,0,'LSQ12ejx','LSQ',355.0385,-21.8748333333333,NULL,NULL,'2012-09-14 02:32:58',56184.10623,22.0444,0.1835,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_history.html','hostless sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_snap_57634.gif',50276293318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,785567083,12274485,NULL,NULL,NULL,NULL),(1743,817,0,'LSQ12ejx','LSQ',355.038583333333,-21.8748055555556,NULL,NULL,'2012-09-14 04:34:44',56184.1907899999,21.538,0.1844,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_history.html','hostless sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_snap_57635.gif',50276293318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,785567083,12274485,NULL,NULL,NULL,NULL),(1744,823,0,'LSQ12ejw','LSQ',357.600958333333,-24.6792777777778,NULL,NULL,'2012-09-14 06:34:25',56184.27391,20.0672,0.1023,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_snap_57636.gif',50012664937,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,781447889,12210123,NULL,NULL,NULL,NULL),(1745,826,0,'LSQ12eju','LSQ',350.748833333333,-7.43319444444445,NULL,NULL,'2012-09-14 04:12:49',56184.17557,20.0881,0.1618,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_57623.gif',49649863586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(1746,826,0,'LSQ12eju','LSQ',350.748875,-7.43319444444445,NULL,NULL,'2012-09-14 06:14:11',56184.2598600001,19.7069,0.1542,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eju/LSQ12eju_snap_57624.gif',49649863586,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,775779118,12121548,NULL,NULL,NULL,NULL),(1747,858,0,'LSQ12eks','LSQ',345.267458333333,-6.69513888888889,NULL,NULL,'2012-09-14 05:46:34',56184.2406799998,20.4662,0.1363,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eks/LSQ12eks_history.html','sne-nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eks/LSQ12eks_snap_57640.gif',49487173961,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773237093,12081829,NULL,NULL,NULL,NULL),(1748,861,0,'LSQ12ekr','LSQ',344.3795,-6.24525,NULL,NULL,'2012-09-14 03:43:29',56184.1551999999,20.901,0.1666,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2019-08-21 00:25:10','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_57641.gif',49488043314,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(1749,861,0,'LSQ12ekr','LSQ',344.379333333333,-6.24522222222222,NULL,NULL,'2012-09-14 05:44:53',56184.2395100002,20.7863,0.1521,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2019-08-21 00:25:10','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_history.html','agn or old?',NULL,0.090066,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ekr/LSQ12ekr_snap_57642.gif',49488043314,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,773250676,12082041,NULL,NULL,NULL,NULL),(1750,915,0,'LSQ12elk','LSQ',31.3318333333333,-5.97238888888889,NULL,NULL,'2012-09-14 08:28:47',56184.3533299998,20.3843,0.1091,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_snap_57676.gif',35137599396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(1751,915,0,'LSQ12elk','LSQ',31.331875,-5.97236111111111,NULL,NULL,'2012-09-14 09:08:49',56184.3811300001,20.7346,0.128,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elk/LSQ12elk_snap_57677.gif',35137599396,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,549024990,8578515,NULL,NULL,NULL,NULL),(1752,954,0,'LSQ12ela','LSQ',353.607291666667,-3.68669444444444,NULL,NULL,'2012-09-14 06:14:11',56184.2598600001,20.5574,0.1286,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ela/LSQ12ela_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ela/LSQ12ela_snap_57670.gif',49417146764,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,772142918,12064733,NULL,NULL,NULL,NULL),(1753,1310,0,'LSQ12eqs','LSQ',346.333333333333,3.24355555555556,NULL,NULL,'2012-09-14 05:29:03',56184.2285099998,19.2167,0.0504,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqs/LSQ12eqs_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eqs/LSQ12eqs_snap_57769.gif',51696025755,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,807750402,12621100,NULL,NULL,NULL,NULL),(1754,1458,0,'LSQ12eui','LSQ',51.85675,-11.5909444444444,NULL,NULL,'2012-09-14 07:57:33',56184.33164,19.6993,0.1427,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eui/LSQ12eui_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eui/LSQ12eui_snap_57646.gif',37886492397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,591976443,9249631,NULL,NULL,NULL,NULL),(1755,1458,0,'LSQ12eui','LSQ',51.8568333333333,-11.5911111111111,NULL,NULL,'2012-09-14 08:52:58',56184.3701200001,19.1338,0.0907,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eui/LSQ12eui_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eui/LSQ12eui_snap_57647.gif',37886492399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,591976443,9249631,NULL,NULL,NULL,NULL),(1756,1616,0,'LSQ12evy','LSQ',25.097375,-29.7411944444444,NULL,NULL,'2012-09-14 02:48:08',56184.1167600001,22.5035,0.1918,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_history.html','sn?',NULL,0.242061,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_snap_57681.gif',38265285480,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,597895085,9342110,NULL,NULL,NULL,NULL),(1757,1616,0,'LSQ12evy','LSQ',25.0972083333333,-29.7412777777778,NULL,NULL,'2012-09-14 04:49:55',56184.2013400001,22.9063,0.1841,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_history.html','sn?',NULL,0.242061,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_snap_57682.gif',38265285488,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,597895085,9342110,NULL,NULL,NULL,NULL),(1758,1616,0,'LSQ12evy','LSQ',25.09725,-29.7411944444444,NULL,NULL,'2012-09-14 06:49:33',56184.2844199999,22.3485,0.141,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_history.html','sn?',NULL,0.242061,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_snap_57683.gif',38265285488,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,597895085,9342110,NULL,NULL,NULL,NULL),(1759,1618,0,'LSQ12evw','LSQ',28.8265833333333,-29.9607777777778,NULL,NULL,'2012-09-14 02:48:08',56184.1167600001,20.1823,0.1034,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_57658.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1760,1618,0,'LSQ12evw','LSQ',28.8265833333333,-29.9608888888889,NULL,NULL,'2012-09-14 04:49:55',56184.2013400001,20.3624,0.1119,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_57659.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1761,1618,0,'LSQ12evw','LSQ',28.8265416666667,-29.9608333333333,NULL,NULL,'2012-09-14 06:49:33',56184.2844199999,20.2823,0.0921,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_57660.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1762,1620,0,'LSQ12evv','LSQ',28.7777083333333,-27.6873055555556,NULL,NULL,'2012-09-14 02:48:08',56184.1167600001,19.1704,0.1353,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_snap_57657.gif',38401172067,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,600018313,9375286,NULL,NULL,NULL,NULL),(1763,1670,0,'LSQ12exp','LSQ',354.28625,-24.1554444444444,NULL,NULL,'2012-09-14 02:32:58',56184.10623,19.6909,0.0569,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_57730.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1764,1670,0,'LSQ12exp','LSQ',354.286416666667,-24.1555,NULL,NULL,'2012-09-14 04:34:44',56184.1907899999,19.5128,0.0558,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_57731.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1765,1670,0,'LSQ12exp','LSQ',354.286291666667,-24.1554166666667,NULL,NULL,'2012-09-14 06:34:25',56184.27391,19.6717,0.0585,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_57732.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1766,1679,0,'LSQ12exl','LSQ',356.054541666667,-24.2010277777778,NULL,NULL,'2012-09-14 02:32:58',56184.10623,20.3913,0.1114,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_57723.gif',50003648247,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1767,1679,0,'LSQ12exl','LSQ',356.054458333333,-24.2009722222222,NULL,NULL,'2012-09-14 04:34:44',56184.1907899999,20.2783,0.0927,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_57724.gif',50003648244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1768,1679,0,'LSQ12exl','LSQ',356.054541666667,-24.2010277777778,NULL,NULL,'2012-09-14 06:34:25',56184.27391,20.7079,0.139,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 06:45:41','2012-09-15 06:45:41','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_57725.gif',50003648247,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1769,1769,0,'PTF12iqw','PTF',36.210492,16.181395,NULL,NULL,'2012-09-13 00:00:00',56183,21.36,NULL,NULL,NULL,NULL,NULL,NULL,'2012-09-15 18:46:26','2019-10-12 20:41:36','NULL','supernova',NULL,0.027,NULL,NULL,'NULL',NULL,NULL,68081858590,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1063779040,16621547,NULL,NULL,NULL,NULL),(1770,1769,0,'PTF12iqw','pessto',36.210492,16.181395,NULL,NULL,'2012-09-14 00:00:00',56184,NULL,NULL,NULL,0.027,NULL,'II',NULL,'2012-09-15 17:48:24','2012-09-15 17:48:24','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68081858590,'Gemini N','GMOS','Jerod Parrent',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1063779040,16621547,NULL,NULL,NULL,NULL),(1771,811,0,'LSQ12ejy','LSQ',355.411166666667,-22.7781388888889,NULL,NULL,'2012-09-15 00:34:36',56185.02403,19.8855,0.1517,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_57963.gif',50274702770,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(1772,811,0,'LSQ12ejy','LSQ',355.411,-22.7780833333333,NULL,NULL,'2012-09-15 02:34:59',56185.10763,18.9193,0.0999,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_57964.gif',50274702771,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(1773,811,0,'LSQ12ejy','LSQ',355.411083333333,-22.7780833333333,NULL,NULL,'2012-09-15 04:35:02',56185.1910000001,19.3817,0.1375,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejy/LSQ12ejy_snap_57965.gif',50274702771,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'AGN',NULL,0,NULL,0,785542230,12274097,NULL,NULL,NULL,NULL),(1774,817,0,'LSQ12ejx','LSQ',355.038583333333,-21.87475,NULL,NULL,'2012-09-15 04:35:02',56185.1910000001,21.6495,0.1583,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_history.html','hostless sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejx/LSQ12ejx_snap_57960.gif',50276293318,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,785567083,12274485,NULL,NULL,NULL,NULL),(1775,823,0,'LSQ12ejw','LSQ',357.600791666667,-24.6791944444444,NULL,NULL,'2012-09-15 00:34:36',56185.02403,18.1077,0.0538,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_snap_57961.gif',50012664937,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,781447889,12210123,NULL,NULL,NULL,NULL),(1776,823,0,'LSQ12ejw','LSQ',357.600875,-24.6791944444444,NULL,NULL,'2012-09-15 04:35:02',56185.1910000001,18.6197,0.0682,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ejw/LSQ12ejw_snap_57962.gif',50012664937,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,781447889,12210123,NULL,NULL,NULL,NULL),(1777,1201,0,'LSQ12eod','LSQ',319.04025,-24.1268333333333,NULL,NULL,'2012-09-15 00:58:01',56185.0402899999,21.0963,0.2127,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eod/LSQ12eod_history.html','hostless?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eod/LSQ12eod_snap_58016.gif',50917408090,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,795584501,12431007,NULL,NULL,NULL,NULL),(1778,1205,0,'LSQ12eoc','LSQ',317.28425,-22.2571944444444,NULL,NULL,'2012-09-15 03:23:47',56185.1415200001,20.2052,0.1412,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eoc/LSQ12eoc_snap_58021.gif',50904231018,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,795378609,12427790,NULL,NULL,NULL,NULL),(1779,1557,0,'LSQ12evn','LSQ',311.892666666667,-17.1579444444444,NULL,NULL,'2012-09-15 00:03:16',56185.0022700001,18.872,0.059,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_history.html','sn',NULL,0.044828,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_snap_57970.gif',50992570481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,796758913,12449358,NULL,NULL,NULL,NULL),(1780,1557,0,'LSQ12evn','LSQ',311.892666666667,-17.1579166666667,NULL,NULL,'2012-09-15 02:47:05',56185.1160400002,18.8771,0.0747,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_history.html','sn',NULL,0.044828,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_snap_57971.gif',50992570481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,796758913,12449358,NULL,NULL,NULL,NULL),(1781,1568,0,'LSQ12evl','LSQ',309.547333333333,-20.9068888888889,NULL,NULL,'2012-09-15 00:03:16',56185.0022700001,20.4412,0.1972,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_snap_57973.gif',50824114763,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,794126793,12408231,NULL,NULL,NULL,NULL),(1782,1568,0,'LSQ12evl','LSQ',309.547291666667,-20.9068611111111,NULL,NULL,'2012-09-15 02:47:05',56185.1160400002,20.5527,0.2155,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_snap_57974.gif',50824114763,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,794126793,12408231,NULL,NULL,NULL,NULL),(1783,1570,0,'LSQ12evo','LSQ',317.523458333333,-25.5898888888889,NULL,NULL,'2012-09-15 00:30:42',56185.0213299999,19.2906,0.148,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_snap_57972.gif',51425622868,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,803525357,12555083,NULL,NULL,NULL,NULL),(1784,1618,0,'LSQ12evw','LSQ',28.8265416666667,-29.9608888888889,NULL,NULL,'2012-09-15 02:38:57',56185.11039,20.0625,0.1362,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_57989.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1785,1618,0,'LSQ12evw','LSQ',28.8264166666667,-29.9608611111111,NULL,NULL,'2012-09-15 06:38:49',56185.2769599999,20.2774,0.1052,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_57990.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1786,1620,0,'LSQ12evv','LSQ',28.778,-27.687,NULL,NULL,'2012-09-15 04:39:00',56185.1937500001,19.3391,0.1102,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_snap_57987.gif',38401172067,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,600018313,9375286,NULL,NULL,NULL,NULL),(1787,1670,0,'LSQ12exp','LSQ',354.286541666667,-24.1556944444444,NULL,NULL,'2012-09-15 00:34:36',56185.02403,19.3972,0.0677,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_58028.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1788,1670,0,'LSQ12exp','LSQ',354.286375,-24.1555,NULL,NULL,'2012-09-15 02:34:59',56185.10763,19.7338,0.0583,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_58029.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1789,1670,0,'LSQ12exp','LSQ',354.286291666667,-24.1554166666667,NULL,NULL,'2012-09-15 04:35:02',56185.1910000001,19.7171,0.0647,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_58030.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1790,1679,0,'LSQ12exl','LSQ',356.054333333333,-24.2009722222222,NULL,NULL,'2012-09-15 00:34:36',56185.02403,20.0495,0.1172,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_58068.gif',50003648244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1791,1679,0,'LSQ12exl','LSQ',356.0545,-24.201,NULL,NULL,'2012-09-15 02:34:59',56185.10763,20.3725,0.1132,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_58069.gif',50003648244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1792,1679,0,'LSQ12exl','LSQ',356.054416666667,-24.2009722222222,NULL,NULL,'2012-09-15 04:35:02',56185.1910000001,20.717,0.1198,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_58070.gif',50003648244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1793,1720,0,'LSQ12ezu','LSQ',355.076541666667,-21.156,NULL,NULL,'2012-09-15 05:04:14',56185.2112799999,19.0512,0.1083,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezu/LSQ12ezu_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezu/LSQ12ezu_snap_58057.gif',50277624862,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785587888,12274810,NULL,NULL,NULL,NULL),(1794,1720,0,'LSQ12ezu','LSQ',355.076625,-21.156,NULL,NULL,'2012-09-15 07:17:47',56185.3040200002,18.7605,0.0959,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezu/LSQ12ezu_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezu/LSQ12ezu_snap_58058.gif',50277624863,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785587888,12274810,NULL,NULL,NULL,NULL),(1795,1725,0,'LSQ12ezs','LSQ',310.557625,-21.6615555555556,NULL,NULL,'2012-09-15 00:15:31',56185.0107800001,19.2335,0.0652,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_snap_58055.gif',50825557719,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,794149339,12408583,NULL,NULL,NULL,NULL),(1796,1725,0,'LSQ12ezs','LSQ',310.557666666667,-21.6615555555556,NULL,NULL,'2012-09-15 03:02:00',56185.1263899999,19.1908,0.0672,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_snap_58056.gif',50825557717,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,794149339,12408583,NULL,NULL,NULL,NULL),(1797,1731,0,'LSQ12ezr','LSQ',311.787,-21.5501944444444,NULL,NULL,'2012-09-15 03:02:00',56185.1263899999,19.6529,0.1252,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezr/LSQ12ezr_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezr/LSQ12ezr_snap_58052.gif',50825432380,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,794147380,12408552,NULL,NULL,NULL,NULL),(1798,1735,0,'LSQ12ezn','LSQ',54.4398333333333,-37.26575,NULL,NULL,'2012-09-15 06:46:02',56185.2819699999,19.0988,0.0508,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezn/LSQ12ezn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezn/LSQ12ezn_snap_58059.gif',38556577295,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,602446520,9413226,NULL,NULL,NULL,NULL),(1799,1735,0,'LSQ12ezn','LSQ',54.4398333333333,-37.2657222222222,NULL,NULL,'2012-09-15 08:32:51',56185.3561499999,19.0572,0.0482,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-15 22:45:34','2012-09-15 22:45:34','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezn/LSQ12ezn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezn/LSQ12ezn_snap_58060.gif',38556577295,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,602446520,9413226,NULL,NULL,NULL,NULL),(1800,1800,1,'LSQ12fat','LSQ',356.181,3.10844444444444,NULL,NULL,'2012-09-14 04:09:26',56184.1732200002,20.6185,0.1676,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fat/LSQ12fat_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fat/LSQ12fat_snap_58132.gif',51603275523,NULL,NULL,NULL,'2012-09-14 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,806301180,12598455,NULL,NULL,NULL,NULL),(1801,1800,0,'LSQ12fat','LSQ',356.181291666667,3.10833333333333,NULL,NULL,'2012-09-14 06:10:47',56184.2574999998,19.7687,0.0968,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fat/LSQ12fat_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fat/LSQ12fat_snap_58133.gif',51603275523,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,806301180,12598455,NULL,NULL,NULL,NULL),(1802,1802,1,'LSQ12fas','LSQ',1.62958333333333,2.00305555555556,NULL,NULL,'2012-09-14 04:21:38',56184.18169,20.9163,0.1594,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fas/LSQ12fas_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fas/LSQ12fas_snap_58130.gif',66588638541,NULL,NULL,NULL,'2012-07-29 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1040447477,16256991,NULL,NULL,NULL,NULL),(1803,1802,0,'LSQ12fas','LSQ',1.62966666666667,2.00291666666667,NULL,NULL,'2012-09-14 06:22:52',56184.2658799998,20.0393,0.1691,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fas/LSQ12fas_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fas/LSQ12fas_snap_58131.gif',66588638541,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1040447477,16256991,NULL,NULL,NULL,NULL),(1804,1804,1,'LSQ12fap','LSQ',343.293166666667,-3.27513888888889,NULL,NULL,'2012-08-19 06:12:04',56158.2583900001,20.5355,0.112,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fap/LSQ12fap_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fap/LSQ12fap_snap_58207.gif',49520267198,NULL,NULL,NULL,'2012-08-10 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773754174,12089908,NULL,NULL,NULL,NULL),(1805,1804,0,'LSQ12fap','LSQ',343.293208333333,-3.27525,NULL,NULL,'2012-08-19 08:22:11',56158.3487399998,20.697,0.168,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fap/LSQ12fap_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fap/LSQ12fap_snap_58208.gif',49520267198,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773754174,12089908,NULL,NULL,NULL,NULL),(1806,1804,0,'LSQ12fap','LSQ',343.2935,-3.27511111111111,NULL,NULL,'2012-09-14 03:45:10',56184.15637,20.3068,0.167,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fap/LSQ12fap_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fap/LSQ12fap_snap_58122.gif',49520267198,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773754174,12089908,NULL,NULL,NULL,NULL),(1807,1804,0,'LSQ12fap','LSQ',343.293708333333,-3.27502777777778,NULL,NULL,'2012-09-14 05:46:34',56184.2406799998,19.9586,0.1398,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fap/LSQ12fap_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fap/LSQ12fap_snap_58123.gif',49520267198,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,773754174,12089908,NULL,NULL,NULL,NULL),(1808,1808,1,'LSQ12fal','LSQ',21.858625,-3.76283333333333,NULL,NULL,'2012-08-22 09:05:10',56161.3785899999,18.9048,0.079,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fal/LSQ12fal_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fal/LSQ12fal_snap_58183.gif',35246476730,NULL,NULL,NULL,'2012-08-20 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,550726198,8605096,NULL,NULL,NULL,NULL),(1809,1808,0,'LSQ12fal','LSQ',21.8579583333333,-3.76297222222222,NULL,NULL,'2012-08-26 08:23:55',56165.3499500002,20.1259,0.1967,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fal/LSQ12fal_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fal/LSQ12fal_snap_58184.gif',35246476677,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,550726198,8605096,NULL,NULL,NULL,NULL),(1810,1808,0,'LSQ12fal','LSQ',21.8583333333333,-3.76277777777778,NULL,NULL,'2012-08-28 06:24:39',56167.26712,19.7357,0.1376,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fal/LSQ12fal_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fal/LSQ12fal_snap_58185.gif',35246476730,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,550726198,8605096,NULL,NULL,NULL,NULL),(1811,1808,0,'LSQ12fal','LSQ',21.8582916666667,-3.76283333333333,NULL,NULL,'2012-08-30 05:51:05',56169.2438099999,19.6733,0.1535,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fal/LSQ12fal_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fal/LSQ12fal_snap_58186.gif',35246476677,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,550726198,8605096,NULL,NULL,NULL,NULL),(1812,1808,0,'LSQ12fal','LSQ',21.8585416666667,-3.76288888888889,NULL,NULL,'2012-09-02 05:46:45',56172.2408099999,19.8583,0.1831,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fal/LSQ12fal_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fal/LSQ12fal_snap_58187.gif',35246476730,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,550726198,8605096,NULL,NULL,NULL,NULL),(1813,1808,0,'LSQ12fal','LSQ',21.8588333333333,-3.763,NULL,NULL,'2012-09-12 06:47:08',56182.2827400002,19.271,0.0607,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fal/LSQ12fal_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fal/LSQ12fal_snap_58188.gif',35246476730,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,550726198,8605096,NULL,NULL,NULL,NULL),(1814,1808,0,'LSQ12fal','LSQ',21.85875,-3.76288888888889,NULL,NULL,'2012-09-14 08:16:54',56184.3450799999,19.377,0.1052,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fal/LSQ12fal_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fal/LSQ12fal_snap_58114.gif',35246476730,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,550726198,8605096,NULL,NULL,NULL,NULL),(1815,1808,0,'LSQ12fal','LSQ',21.8584583333333,-3.76291666666667,NULL,NULL,'2012-09-14 09:17:21',56184.3870600001,19.1696,0.0679,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fal/LSQ12fal_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fal/LSQ12fal_snap_58115.gif',35246476730,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,550726198,8605096,NULL,NULL,NULL,NULL),(1816,1816,1,'LSQ12fak','LSQ',56.3515833333333,-10.5703611111111,NULL,NULL,'2012-09-12 06:31:18',56182.2717400002,20.0245,0.1113,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fak/LSQ12fak_history.html','unknown',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fak/LSQ12fak_snap_58181.gif',37026669944,NULL,NULL,NULL,'2012-09-04 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,578541717,9039714,NULL,NULL,NULL,NULL),(1817,1816,0,'LSQ12fak','LSQ',56.3515833333333,-10.5703611111111,NULL,NULL,'2012-09-12 08:44:28',56182.3642199999,19.6889,0.1087,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fak/LSQ12fak_history.html','unknown',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fak/LSQ12fak_snap_58182.gif',37026669944,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,578541717,9039714,NULL,NULL,NULL,NULL),(1818,1816,0,'LSQ12fak','LSQ',56.3516666666667,-10.5702777777778,NULL,NULL,'2012-09-14 08:00:55',56184.3339800001,19.4582,0.1372,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fak/LSQ12fak_history.html','unknown',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fak/LSQ12fak_snap_58112.gif',37026669944,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,578541717,9039714,NULL,NULL,NULL,NULL),(1819,1816,0,'LSQ12fak','LSQ',56.3515833333333,-10.5703888888889,NULL,NULL,'2012-09-14 08:54:38',56184.3712800001,19.4322,0.1027,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fak/LSQ12fak_history.html','unknown',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fak/LSQ12fak_snap_58113.gif',37026669944,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,578541717,9039714,NULL,NULL,NULL,NULL),(1820,1820,1,'LSQ12fag','LSQ',25.3704166666667,-29.6439722222222,NULL,NULL,'2012-09-08 03:31:19',56178.1467499998,21.9227,0.1884,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58169.gif',38265521124,NULL,NULL,NULL,'2012-09-08 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1821,1820,0,'LSQ12fag','LSQ',25.3707083333333,-29.6440833333333,NULL,NULL,'2012-09-09 07:14:45',56179.3019099999,21.6991,0.1515,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58170.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1822,1820,0,'LSQ12fag','LSQ',25.370625,-29.644,NULL,NULL,'2012-09-10 03:50:04',56180.1597799999,21.6176,0.09,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58171.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1823,1820,0,'LSQ12fag','LSQ',25.3707083333333,-29.6440555555556,NULL,NULL,'2012-09-11 03:47:14',56181.1578099998,21.4806,0.0765,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58172.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1824,1820,0,'LSQ12fag','LSQ',25.3706666666667,-29.6440555555556,NULL,NULL,'2012-09-11 06:03:33',56181.2524700002,21.4031,0.0826,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58173.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1825,1820,0,'LSQ12fag','LSQ',25.370625,-29.6439722222222,NULL,NULL,'2012-09-12 02:58:28',56182.1239399998,21.1587,0.0663,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58174.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1826,1820,0,'LSQ12fag','LSQ',25.370625,-29.644,NULL,NULL,'2012-09-12 04:59:13',56182.2078,21.3596,0.0682,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58175.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1827,1820,0,'LSQ12fag','LSQ',25.370625,-29.6439722222222,NULL,NULL,'2012-09-12 07:01:05',56182.2924299999,21.2024,0.0601,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58176.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1828,1820,0,'LSQ12fag','LSQ',25.370625,-29.6440277777778,NULL,NULL,'2012-09-13 02:54:11',56183.12097,21.3428,0.0779,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58177.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1829,1820,0,'LSQ12fag','LSQ',25.370625,-29.6440277777778,NULL,NULL,'2012-09-13 04:54:53',56183.2047899999,21.159,0.0607,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58178.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1830,1820,0,'LSQ12fag','LSQ',25.3706666666667,-29.6440277777778,NULL,NULL,'2012-09-13 06:55:30',56183.2885500002,21.3192,0.0706,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58179.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1831,1820,0,'LSQ12fag','LSQ',25.3706666666667,-29.644,NULL,NULL,'2012-09-14 02:48:08',56184.1167600001,21.1924,0.0646,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58103.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1832,1820,0,'LSQ12fag','LSQ',25.3706666666667,-29.644,NULL,NULL,'2012-09-14 04:49:55',56184.2013400001,21.1989,0.063,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58105.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1833,1820,0,'LSQ12fag','LSQ',25.3706666666667,-29.644,NULL,NULL,'2012-09-14 06:49:33',56184.2844199999,21.2143,0.0685,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58104.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1834,1820,0,'LSQ12fag','LSQ',25.3706666666667,-29.644,NULL,NULL,'2012-09-15 02:38:57',56185.11039,21.2127,0.0637,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58253.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1835,1820,0,'LSQ12fag','LSQ',25.3706666666667,-29.6439722222222,NULL,NULL,'2012-09-15 04:39:00',56185.1937500001,21.1151,0.0675,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58254.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1836,1820,0,'LSQ12fag','LSQ',25.3707083333333,-29.644,NULL,NULL,'2012-09-15 06:38:49',56185.2769599999,21.1002,0.063,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-16 18:45:31','2012-09-16 18:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58255.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1837,1837,0,'PSNJ01184597+1459402','TOCP',19.69188,14.99442,NULL,NULL,'2012-09-11 00:00:00',56181,15.5,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2012-09-17 03:23:22','2019-10-12 20:41:36','NULL','supernova',NULL,0.023,NULL,NULL,'http://www.astrofilisenesi.it/public/Sne/Uploads/PSN_in_UGC00838.jpg',NULL,NULL,67601059096,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1056266548,16504164,NULL,NULL,NULL,NULL),(1838,1566,0,'LSQ12evm','pessto',336.765708333,-23.6769444444,NULL,NULL,'2012-09-17 14:39:50',56187.611,NULL,NULL,NULL,0.136,NULL,'IIn',NULL,'2012-09-17 03:46:26','2012-09-17 03:46:26','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50212210897,'NTT','EFOSC','Yen Chen Pan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,784565795,12258840,NULL,NULL,NULL,NULL),(1839,1568,0,'LSQ12evl','pessto',309.547291667,-20.9068333333,NULL,NULL,'2012-09-17 15:34:33',56187.649,NULL,NULL,NULL,0.15,NULL,'Ia',NULL,'2012-09-17 04:38:16','2012-09-17 04:38:16','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50824114763,'NTT','EFOSC','Yen Chen Pan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,794126793,12408231,NULL,NULL,NULL,NULL),(1840,1570,0,'LSQ12evo','pessto',317.5235,-25.5899,NULL,NULL,'2012-09-08 00:00:00',56178,NULL,NULL,NULL,0.1,NULL,'Ia',NULL,'2012-09-17 05:14:41','2012-09-17 05:14:41','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51425622868,'NTT','EFOSC','Yen Chen Pan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,803525357,12555083,NULL,NULL,NULL,NULL),(1841,1669,0,'PSNJ02452841-6207214','pessto',41.36838,-62.12261,NULL,NULL,'2012-09-17 00:00:00',56187,NULL,NULL,NULL,0.026,NULL,'II',NULL,'2012-09-17 08:19:45','2012-09-17 08:19:45','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36260997780,'NTT','EFOSC','Yen Chen Pan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,566578090,8852782,NULL,NULL,NULL,NULL),(1843,1735,0,'LSQ12ezn','pessto',54.439875,-37.26575,NULL,NULL,'2012-09-17 00:00:00',56187,NULL,NULL,NULL,0,NULL,'unknown',NULL,'2012-09-17 09:08:09','2012-09-17 09:08:09','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38556577295,'NTT','EFOSC','Yen Chen Pan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,602446520,9413226,NULL,NULL,NULL,NULL),(1844,1550,0,'PSNJ04371913-6908254','pessto',69.32971,-69.14039,NULL,NULL,'2012-09-17 00:00:00',56187,NULL,NULL,NULL,0.063,NULL,'Ia',NULL,'2012-09-17 09:40:39','2012-09-17 09:40:39','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36436638088,'NTT','EFOSC','Yen Chen Pan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,569322470,8895663,NULL,NULL,NULL,NULL),(1845,1837,0,'PSNJ01184597+1459402','pessto',19.69188,14.99442,NULL,NULL,'2012-09-17 00:00:00',56187,NULL,NULL,NULL,0,NULL,'unknown',NULL,'2012-09-17 10:43:56','2012-09-17 10:43:56','NULL',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67601059096,'NTT','EFOSC','Yen Chen Pan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,1056266548,16504164,NULL,NULL,NULL,NULL),(1846,1020,0,'LSQ12elo','LSQ',318.356625,-6.59952777777778,NULL,NULL,'2012-09-16 00:03:54',56186.0027100001,20.3636,0.1875,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elo/LSQ12elo_history.html','sne?',NULL,0.12145,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elo/LSQ12elo_snap_58462.gif',50789822544,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,793590977,12399859,NULL,NULL,NULL,NULL),(1847,1026,0,'LSQ12elz','LSQ',329.397625,-0.83925,NULL,NULL,'2012-09-16 00:35:21',56186.0245599998,20.5719,0.1918,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_history.html','sne?',NULL,0.21853,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12elz/LSQ12elz_snap_58506.gif',49826069800,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778532340,12164567,NULL,NULL,NULL,NULL),(1848,1033,0,'LSQ12ely','LSQ',329.641416666667,-1.70513888888889,NULL,NULL,'2012-09-16 04:02:08',56186.1681499998,20.6957,0.199,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ely/LSQ12ely_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ely/LSQ12ely_snap_58278.gif',49828188398,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,778565443,12165085,NULL,NULL,NULL,NULL),(1849,1287,0,'LSQ12erd','LSQ',10.6061666666667,0.864722222222222,NULL,NULL,'2012-09-16 07:27:33',56186.3108000001,20.1909,0.1888,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erd/LSQ12erd_history.html','sne?',NULL,0.16679,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erd/LSQ12erd_snap_58536.gif',66807779648,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,1043871557,16310493,NULL,NULL,NULL,NULL),(1850,1289,0,'LSQ12erc','LSQ',8.77091666666667,1.48144444444444,NULL,NULL,'2012-09-16 07:13:27',56186.3010100001,18.1232,0.0364,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12erc/LSQ12erc_snap_58558.gif',66590313561,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,1040473649,16257400,NULL,NULL,NULL,NULL),(1851,1295,0,'LSQ12era','LSQ',324.270875,0.478833333333333,NULL,NULL,'2012-09-16 00:07:17',56186.0050599999,19.2745,0.1323,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12era/LSQ12era_history.html','sne?',NULL,0.05021,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12era/LSQ12era_snap_58549.gif',52096398906,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,814006232,12718847,NULL,NULL,NULL,NULL),(1852,1451,0,'LSQ12euu','LSQ',322.784166666667,-6.70405555555556,NULL,NULL,'2012-09-16 00:26:00',56186.0180600001,19.5548,0.1087,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euu/LSQ12euu_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euu/LSQ12euu_snap_58362.gif',49683505265,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,776304769,12129762,NULL,NULL,NULL,NULL),(1853,1451,0,'LSQ12euu','LSQ',322.784083333333,-6.70405555555556,NULL,NULL,'2012-09-16 03:48:23',56186.1586099998,19.7049,0.1434,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euu/LSQ12euu_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12euu/LSQ12euu_snap_58363.gif',49683505270,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,776304769,12129762,NULL,NULL,NULL,NULL),(1854,1458,0,'LSQ12eui','LSQ',51.8567083333333,-11.5908611111111,NULL,NULL,'2012-09-16 06:43:43',56186.2803600002,19.2418,0.1091,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eui/LSQ12eui_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eui/LSQ12eui_snap_58426.gif',37886492397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,591976443,9249631,NULL,NULL,NULL,NULL),(1855,1458,0,'LSQ12eui','LSQ',51.8568333333333,-11.5908611111111,NULL,NULL,'2012-09-16 08:18:02',56186.3458599998,19.5317,0.1332,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eui/LSQ12eui_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eui/LSQ12eui_snap_58427.gif',37886492397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,591976443,9249631,NULL,NULL,NULL,NULL),(1856,1460,0,'LSQ12eue','LSQ',38.879375,-7.49275,NULL,NULL,'2012-09-16 06:03:23',56186.2523500002,19.4622,0.0726,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eue/LSQ12eue_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eue/LSQ12eue_snap_58379.gif',34938434364,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,545913036,8529891,NULL,NULL,NULL,NULL),(1857,1460,0,'LSQ12eue','LSQ',38.8793333333333,-7.49272222222222,NULL,NULL,'2012-09-16 07:54:31',56186.3295300002,19.335,0.0677,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eue/LSQ12eue_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eue/LSQ12eue_snap_58380.gif',34938434364,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,545913036,8529891,NULL,NULL,NULL,NULL),(1858,1616,0,'LSQ12evy','LSQ',25.09725,-29.7411666666667,NULL,NULL,'2012-09-16 06:45:40',56186.2817199999,22.5105,0.1769,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_history.html','sn?',NULL,0.242061,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evy/LSQ12evy_snap_58445.gif',38265285488,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,597895085,9342110,NULL,NULL,NULL,NULL),(1859,1618,0,'LSQ12evw','LSQ',28.8265,-29.9608611111111,NULL,NULL,'2012-09-16 02:41:26',56186.1121100001,20.1588,0.0939,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_58433.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1860,1618,0,'LSQ12evw','LSQ',28.8265833333333,-29.9608333333333,NULL,NULL,'2012-09-16 04:43:12',56186.19667,20.12,0.1087,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_58434.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1861,1618,0,'LSQ12evw','LSQ',28.8265416666667,-29.9608611111111,NULL,NULL,'2012-09-16 06:45:40',56186.2817199999,20.5617,0.1521,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_history.html','sn??',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evw/LSQ12evw_snap_58435.gif',38262027470,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'VS',NULL,0,NULL,0,597844179,9341315,NULL,NULL,NULL,NULL),(1862,1620,0,'LSQ12evv','LSQ',28.7785,-27.687,NULL,NULL,'2012-09-14 06:49:33',56184.2844199999,19.3002,0.1217,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_snap_58727.gif',38401172065,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,600018313,9375286,NULL,NULL,NULL,NULL),(1863,1620,0,'LSQ12evv','LSQ',28.7784583333333,-27.6871111111111,NULL,NULL,'2012-09-16 02:41:26',56186.1121100001,19.4164,0.1523,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_snap_58451.gif',38401172065,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,600018313,9375286,NULL,NULL,NULL,NULL),(1864,1620,0,'LSQ12evv','LSQ',28.7784583333333,-27.6871111111111,NULL,NULL,'2012-09-16 06:45:40',56186.2817199999,19.5515,0.1631,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_snap_58452.gif',38401172065,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,600018313,9375286,NULL,NULL,NULL,NULL),(1865,1646,0,'LSQ12ewu','LSQ',317.788958333333,-6.94141666666667,NULL,NULL,'2012-09-15 23:47:44',56185.9914899999,19.1295,0.071,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewu/LSQ12ewu_history.html','sne - nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewu/LSQ12ewu_snap_58481.gif',50789486443,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'BS',NULL,0,NULL,0,793585725,12399776,NULL,NULL,NULL,NULL),(1866,1646,0,'LSQ12ewu','LSQ',317.788833333333,-6.94133333333333,NULL,NULL,'2012-09-16 01:49:43',56186.0762,19.7742,0.1431,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewu/LSQ12ewu_history.html','sne - nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewu/LSQ12ewu_snap_58482.gif',50789486443,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'BS',NULL,0,NULL,0,793585725,12399776,NULL,NULL,NULL,NULL),(1867,1670,0,'LSQ12exp','LSQ',354.286458333333,-24.1554444444444,NULL,NULL,'2012-09-16 00:31:27',56186.0218500001,19.3262,0.0627,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_58503.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1868,1670,0,'LSQ12exp','LSQ',354.286291666667,-24.1554444444444,NULL,NULL,'2012-09-16 02:37:26',56186.1093299999,19.6363,0.0578,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_58504.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1869,1670,0,'LSQ12exp','LSQ',354.286333333333,-24.1554722222222,NULL,NULL,'2012-09-16 04:39:12',56186.1938999998,19.7389,0.0563,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_58505.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1870,1679,0,'LSQ12exl','LSQ',356.054375,-24.2008888888889,NULL,NULL,'2012-09-16 00:31:27',56186.0218500001,19.8361,0.1148,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_58573.gif',50003648244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1871,1679,0,'LSQ12exl','LSQ',356.054333333333,-24.2009444444444,NULL,NULL,'2012-09-16 02:37:26',56186.1093299999,20.4394,0.1023,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_58574.gif',50003648244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1872,1679,0,'LSQ12exl','LSQ',356.054333333333,-24.2009166666667,NULL,NULL,'2012-09-16 04:39:12',56186.1938999998,20.402,0.1077,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_58575.gif',50003648244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1873,1718,0,'LSQ12eyo','LSQ',43.8210416666667,-7.89752777777778,NULL,NULL,'2012-09-16 06:10:10',56186.2570699998,19.7251,0.1537,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eyo/LSQ12eyo_history.html','sn?',NULL,0.03116,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eyo/LSQ12eyo_snap_58532.gif',37913944767,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,592405386,9256334,NULL,NULL,NULL,NULL),(1874,1718,0,'LSQ12eyo','LSQ',43.8212083333333,-7.89752777777778,NULL,NULL,'2012-09-16 07:57:55',56186.33189,19.8545,0.2033,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eyo/LSQ12eyo_history.html','sn?',NULL,0.03116,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12eyo/LSQ12eyo_snap_58533.gif',37913944767,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,592405386,9256334,NULL,NULL,NULL,NULL),(1875,1816,0,'LSQ12fak','LSQ',56.351625,-10.5704166666667,NULL,NULL,'2012-09-16 06:58:43',56186.2907799999,19.6208,0.1144,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fak/LSQ12fak_history.html','unknown',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fak/LSQ12fak_snap_58428.gif',37026669944,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,578541717,9039714,NULL,NULL,NULL,NULL),(1876,1816,0,'LSQ12fak','LSQ',56.3516666666667,-10.5704166666667,NULL,NULL,'2012-09-16 08:23:09',56186.3494199999,19.4545,0.1304,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fak/LSQ12fak_history.html','unknown',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fak/LSQ12fak_snap_58429.gif',37026669944,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,578541717,9039714,NULL,NULL,NULL,NULL),(1877,1820,0,'LSQ12fag','LSQ',25.3706666666667,-29.6440555555556,NULL,NULL,'2012-09-16 02:41:26',56186.1121100001,21.0737,0.0611,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58417.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1878,1820,0,'LSQ12fag','LSQ',25.37075,-29.6440555555556,NULL,NULL,'2012-09-16 04:43:12',56186.19667,21.3176,0.0741,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58418.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1879,1820,0,'LSQ12fag','LSQ',25.370625,-29.644,NULL,NULL,'2012-09-16 06:45:40',56186.2817199999,21.0397,0.0574,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-18 19:45:27','2012-09-18 19:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58419.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1880,1557,0,'LSQ12evn','LSQ',311.89275,-17.1578055555556,NULL,NULL,'2012-09-17 00:04:16',56187.0029699998,18.4951,0.0443,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_history.html','sn',NULL,0.044828,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_snap_58962.gif',50992570481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,796758913,12449358,NULL,NULL,NULL,NULL),(1881,1557,0,'LSQ12evn','LSQ',311.892666666667,-17.1579166666667,NULL,NULL,'2012-09-17 02:15:44',56187.0942600002,19.2257,0.0718,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_history.html','sn',NULL,0.044828,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evn/LSQ12evn_snap_58963.gif',50992570481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,796758913,12449358,NULL,NULL,NULL,NULL),(1882,1568,0,'LSQ12evl','LSQ',309.547208333333,-20.9068333333333,NULL,NULL,'2012-09-17 00:04:16',56187.0029699998,20.7218,0.1465,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_snap_58958.gif',50824114763,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,794126793,12408231,NULL,NULL,NULL,NULL),(1883,1568,0,'LSQ12evl','LSQ',309.547416666667,-20.9069444444444,NULL,NULL,'2012-09-17 02:15:44',56187.0942600002,20.9058,0.1846,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evl/LSQ12evl_snap_58959.gif',50824114763,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,794126793,12408231,NULL,NULL,NULL,NULL),(1884,1570,0,'LSQ12evo','LSQ',317.523625,-25.5899722222222,NULL,NULL,'2012-09-17 00:36:12',56187.0251500001,19.9794,0.1965,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evo/LSQ12evo_snap_58957.gif',51425622868,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,803525357,12555083,NULL,NULL,NULL,NULL),(1885,1599,0,'LSQ12evr','LSQ',27.437375,-27.5274444444444,NULL,NULL,'2012-09-17 02:31:30',56187.1052100002,21.6202,0.1793,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evr/LSQ12evr_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evr/LSQ12evr_snap_58968.gif',38254315647,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'NT',NULL,0,NULL,0,597723681,9339432,NULL,NULL,NULL,NULL),(1886,1614,0,'LSQ12evz','LSQ',25.7008333333333,-29.8620277777778,NULL,NULL,'2012-09-16 04:43:12',56186.19667,21.339,0.1153,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evz/LSQ12evz_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evz/LSQ12evz_snap_59058.gif',38265679390,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,597901240,9342206,NULL,NULL,NULL,NULL),(1887,1614,0,'LSQ12evz','LSQ',25.7012916666667,-29.8615555555556,NULL,NULL,'2012-09-17 04:31:39',56187.1886499999,21.438,0.1302,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evz/LSQ12evz_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evz/LSQ12evz_snap_58982.gif',38265679391,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,597901240,9342206,NULL,NULL,NULL,NULL),(1888,1670,0,'LSQ12exp','LSQ',354.286458333333,-24.1555277777778,NULL,NULL,'2012-09-17 00:25:18',56187.0175800002,19.3123,0.0666,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_59006.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1889,1670,0,'LSQ12exp','LSQ',354.286375,-24.1555,NULL,NULL,'2012-09-17 02:27:29',56187.10243,19.5255,0.0564,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_59007.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1890,1670,0,'LSQ12exp','LSQ',354.286333333333,-24.1554722222222,NULL,NULL,'2012-09-17 04:27:40',56187.1858799998,19.6644,0.0554,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exp/LSQ12exp_snap_59008.gif',50055472816,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,782116762,12220574,NULL,NULL,NULL,NULL),(1891,1679,0,'LSQ12exl','LSQ',356.054416666667,-24.2009166666667,NULL,NULL,'2012-09-17 02:27:29',56187.10243,20.4667,0.1384,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12exl/LSQ12exl_snap_59020.gif',50003648244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'UNCLEAR',NULL,0,NULL,0,781307003,12207921,NULL,NULL,NULL,NULL),(1892,1725,0,'LSQ12ezs','LSQ',310.557708333333,-21.6615833333333,NULL,NULL,'2012-09-17 00:16:20',56187.0113499998,19.2497,0.0781,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezs/LSQ12ezs_snap_58949.gif',50825557717,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,794149339,12408583,NULL,NULL,NULL,NULL),(1893,1735,0,'LSQ12ezn','LSQ',54.440125,-37.2658055555556,NULL,NULL,'2012-09-17 06:04:32',56187.2531499998,19.2645,0.0991,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezn/LSQ12ezn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezn/LSQ12ezn_snap_59018.gif',38556577295,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,602446520,9413226,NULL,NULL,NULL,NULL),(1894,1735,0,'LSQ12ezn','LSQ',54.4400833333333,-37.2656944444444,NULL,NULL,'2012-09-17 07:54:44',56187.32968,19.2764,0.1456,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezn/LSQ12ezn_history.html','sne',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ezn/LSQ12ezn_snap_59019.gif',38556577295,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,602446520,9413226,NULL,NULL,NULL,NULL),(1895,1820,0,'LSQ12fag','LSQ',25.370625,-29.6440277777778,NULL,NULL,'2012-09-17 02:31:30',56187.1052100002,21.1711,0.0786,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58953.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1896,1820,0,'LSQ12fag','LSQ',25.3706666666667,-29.6439722222222,NULL,NULL,'2012-09-17 04:31:39',56187.1886499999,20.9365,0.0632,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58954.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1897,1820,0,'LSQ12fag','LSQ',25.3707916666667,-29.644,NULL,NULL,'2012-09-17 06:32:38',56187.2726699999,21.4851,0.1673,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 03:45:31','2012-09-19 03:45:31','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_58955.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1898,1620,0,'LSQ12evv','LSQ',28.7777916666667,-27.6873611111111,NULL,NULL,'2012-09-18 07:59:26',56188.3329400001,18.0528,0.1089,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 10:45:28','2012-09-19 10:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_history.html','sn?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12evv/LSQ12evv_snap_59074.gif',38401172067,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,600018313,9375286,NULL,NULL,NULL,NULL),(1899,1646,0,'LSQ12ewu','LSQ',317.788708333333,-6.94155555555556,NULL,NULL,'2012-09-18 00:58:21',56188.0405299999,20.2173,0.1759,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 10:45:28','2012-09-19 10:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewu/LSQ12ewu_history.html','sne - nice',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12ewu/LSQ12ewu_snap_59083.gif',50789486443,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'BS',NULL,0,NULL,0,793585725,12399776,NULL,NULL,NULL,NULL),(1900,1820,0,'LSQ12fag','LSQ',25.3706666666667,-29.6440555555556,NULL,NULL,'2012-09-18 06:58:11',56188.2904099999,21.0971,0.0723,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 10:45:28','2012-09-19 10:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_59068.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1901,1820,0,'LSQ12fag','LSQ',25.3705416666667,-29.6440277777778,NULL,NULL,'2012-09-18 07:59:26',56188.3329400001,21.0485,0.2058,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 10:45:28','2012-09-19 10:45:28','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_history.html','brightening',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fag/LSQ12fag_snap_59069.gif',38265521124,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'ORPHAN',NULL,0,NULL,0,597898767,9342168,NULL,NULL,NULL,NULL),(1902,1902,1,'LSQ12fbd','LSQ',355.432541666667,-20.7286666666667,NULL,NULL,'2012-09-14 06:34:25',56184.27391,21.0124,0.1766,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 15:45:27','2019-10-11 14:10:04','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fbd/LSQ12fbd_history.html','sne?',NULL,NULL,NULL,NULL,NULL,NULL,'http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fbd/LSQ12fbd_snap_58774.gif',50280653352,NULL,NULL,NULL,'2012-09-13 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,'SN',NULL,0,NULL,0,785635208,12275550,NULL,NULL,NULL,NULL),(1903,1902,0,'LSQ12fbd','LSQ',355.432541666667,-20.7287222222222,NULL,NULL,'2012-09-16 00:31:27',56186.0218500001,20.5006,0.1409,'gr-LSQ',NULL,NULL,NULL,NULL,'2012-09-19 15:45:27','2012-09-19 15:45:27','http://portal.nersc.gov/project/lssn/test/ryan/adb/LSQ12fbd/LSQ12fb