""" StatusType class """

class StatusType():
    """
    Mappings between ID and Strings for StatusType
    """

    @property
    def string_to_id(self):
        """
        Return the map of StatusType strings to ids
        """
        return {
            "": 0,
            "Finished": 1,
            "Disqualified": 2,
            "Accident": 3,
            "Collision": 4,
            "Engine": 5,
            "Gearbox": 6,
            "Transmission": 7,
            "Clutch": 8,
            "Hydraulics": 9,
            "Electrical": 10,
            "+1 Lap": 11,
            "+2 Laps": 12,
            "+3 Laps": 13,
            "+4 Laps": 14,
            "+5 Laps": 15,
            "+6 Laps": 16,
            "+7 Laps": 17,
            "+8 Laps": 18,
            "+9 Laps": 19,
            "Spun off": 20,
            "Radiator": 21,
            "Suspension": 22,
            "Brakes": 23,
            "Differential": 24,
            "Overheating": 25,
            "Mechanical": 26,
            "Tyre": 27,
            "Driver Seat": 28,
            "Puncture": 29,
            "Driveshaft": 30,
            "Retired": 31,
            "Fuel pressure": 32,
            "Front wing": 33,
            "Water pressure": 34,
            "Refuelling": 35,
            "Wheel": 36,
            "Throttle": 37,
            "Steering": 38,
            "Technical": 39,
            "Electronics": 40,
            "Broken wing": 41,
            "Heat shield fire": 42,
            "Exhaust": 43,
            "Oil leak": 44,
            "+11 Laps": 45,
            "Wheel rim": 46,
            "Water leak": 47,
            "Fuel pump": 48,
            "Track rod": 49,
            "+17 Laps": 50,
            "Oil pressure": 51,
            "+13 Laps": 53,
            "Withdrew": 54,
            "+12 Laps": 55,
            "Engine fire": 56,
            "+26 Laps": 58,
            "Tyre puncture": 59,
            "Out of fuel": 60,
            "Wheel nut": 61,
            "Not classified": 62,
            "Pneumatics": 63,
            "Handling": 64,
            "Rear wing": 65,
            "Fire": 66,
            "Wheel bearing": 67,
            "Physical": 68,
            "Fuel system": 69,
            "Oil line": 70,
            "Fuel rig": 71,
            "Launch control": 72,
            "Injured": 73,
            "Fuel": 74,
            "Power loss": 75,
            "Vibrations": 76,
            "107% Rule": 77,
            "Safety": 78,
            "Drivetrain": 79,
            "Ignition": 80,
            "Did not qualify": 81,
            "Injury": 82,
            "Chassis": 83,
            "Battery": 84,
            "Stalled": 85,
            "Halfshaft": 86,
            "Crankshaft": 87,
            "+10 Laps": 88,
            "Safety concerns": 89,
            "Not restarted": 90,
            "Alternator": 91,
            "Underweight": 92,
            "Safety belt": 93,
            "Oil pump": 94,
            "Fuel leak": 95,
            "Excluded": 96,
            "Did not prequalify": 97,
            "Injection": 98,
            "Distributor": 99,
            "Driver unwell": 100,
            "Turbo": 101,
            "CV joint": 102,
            "Water pump": 103,
            "Fatal accident": 104,
            "Spark plugs": 105,
            "Fuel pipe": 106,
            "Eye injury": 107,
            "Oil pipe": 108,
            "Axle": 109,
            "Water pipe": 110,
            "+14 Laps": 111,
            "+15 Laps": 112,
            "+25 Laps": 113,
            "+18 Laps": 114,
            "+22 Laps": 115,
            "+16 Laps": 116,
            "+24 Laps": 117,
            "+29 Laps": 118,
            "+23 Laps": 119,
            "+21 Laps": 120,
            "Magneto": 121,
            "+44 Laps": 122,
            "+30 Laps": 123,
            "+19 Laps": 124,
            "+46 Laps": 125,
            "Supercharger": 126,
            "+20 Laps": 127,
            "+42 Laps": 128,
            "Engine misfire": 129,
            "Collision damage": 130,
            "Power Unit": 131,
            "ERS": 132,
            "Brake duct": 135,
            "Seat": 136,
            "Damage": 137,
            "Debris": 138,
            "Illness": 139,
        }

    @property
    def id_to_string(self):
        """
        Return the map of StatusType ids to strings
        """
        return {
            0 : "",
            1: "Finished",
            2: "Disqualified",
            3: "Accident",
            4: "Collision",
            5: "Engine",
            6: "Gearbox",
            7: "Transmission",
            8: "Clutch",
            9: "Hydraulics",
            10: "Electrical",
            11: "+1 Lap",
            12: "+2 Laps",
            13: "+3 Laps",
            14: "+4 Laps",
            15: "+5 Laps",
            16: "+6 Laps",
            17: "+7 Laps",
            18: "+8 Laps",
            19: "+9 Laps",
            20: "Spun off",
            21: "Radiator",
            22: "Suspension",
            23: "Brakes",
            24: "Differential",
            25: "Overheating",
            26: "Mechanical",
            27: "Tyre",
            28: "Driver Seat",
            29: "Puncture",
            30: "Driveshaft",
            31: "Retired",
            32: "Fuel pressure",
            33: "Front wing",
            34: "Water pressure",
            35: "Refuelling",
            36: "Wheel",
            37: "Throttle",
            38: "Steering",
            39: "Technical",
            40: "Electronics",
            41: "Broken wing",
            42: "Heat shield fire",
            43: "Exhaust",
            44: "Oil leak",
            45: "+11 Laps",
            46: "Wheel rim",
            47: "Water leak",
            48: "Fuel pump",
            49: "Track rod",
            50: "+17 Laps",
            51: "Oil pressure",
            53: "+13 Laps",
            54: "Withdrew",
            55: "+12 Laps",
            56: "Engine fire",
            58: "+26 Laps",
            59: "Tyre puncture",
            60: "Out of fuel",
            61: "Wheel nut",
            62: "Not classified",
            63: "Pneumatics",
            64: "Handling",
            65: "Rear wing",
            66: "Fire",
            67: "Wheel bearing",
            68: "Physical",
            69: "Fuel system",
            70: "Oil line",
            71: "Fuel rig",
            72: "Launch control",
            73: "Injured",
            74: "Fuel",
            75: "Power loss",
            76: "Vibrations",
            77: "107% Rule",
            78: "Safety",
            79: "Drivetrain",
            80: "Ignition",
            81: "Did not qualify",
            82: "Injury",
            83: "Chassis",
            84: "Battery",
            85: "Stalled",
            86: "Halfshaft",
            87: "Crankshaft",
            88: "+10 Laps",
            89: "Safety concerns",
            90: "Not restarted",
            91: "Alternator",
            92: "Underweight",
            93: "Safety belt",
            94: "Oil pump",
            95: "Fuel leak",
            96: "Excluded",
            97: "Did not prequalify",
            98: "Injection",
            99: "Distributor",
            100: "Driver unwell",
            101: "Turbo",
            102: "CV joint",
            103: "Water pump",
            104: "Fatal accident",
            105: "Spark plugs",
            106: "Fuel pipe",
            107: "Eye injury",
            108: "Oil pipe",
            109: "Axle",
            110: "Water pipe",
            111: "+14 Laps",
            112: "+15 Laps",
            113: "+25 Laps",
            114: "+18 Laps",
            115: "+22 Laps",
            116: "+16 Laps",
            117: "+24 Laps",
            118: "+29 Laps",
            119: "+23 Laps",
            120: "+21 Laps",
            121: "Magneto",
            122: "+44 Laps",
            123: "+30 Laps",
            124: "+19 Laps",
            125: "+46 Laps",
            126: "Supercharger",
            127: "+20 Laps",
            128: "+42 Laps",
            129: "Engine misfire",
            130: "Collision damage",
            131: "Power Unit",
            132: "ERS",
            135: "Brake duct",
            136: "Seat",
            137: "Damage",
            138: "Debris",
            139: "Illness",
        }
