from __future__ import annotations
from typing import TYPE_CHECKING

from typing import List, Optional, Union


from pydantic import Field
from pydantic_schemaorg.Article import Article


class Report(Article):
    """A Report generated by governmental or non-governmental organization.

    See: https://schema.org/Report
    Model depth: 4
    """
    type_: str = Field(default="Report", alias='@type')
    reportNumber: Optional[Union[List[Union[str, 'Text']], str, 'Text']] = Field(
        default=None,
        description="The number or other unique designator assigned to a Report by the publishing organization.",
    )
    

if TYPE_CHECKING:
    from pydantic_schemaorg.Text import Text
