from rsgz.dianshang.xiapi.baxi_kuajing_yunfei import baxi_yunfei
from rsgz.dianshang.xiapi.settings import *
from prettytable import PrettyTable,RANDOM

r"""
平台公式：
# 商品售价=商品成本价*汇率+预期净利润*汇率+佣金+交易手续费+活动手续费+境内途运费*汇率+跨境物流成本_藏价+提现手续费
# 活动手续费=活动服务费=商品售价*活动服务费费率
# 交易手续费=(商品售价+买家支付运费)* 交易手续费费率
# 佣金=商品售价*佣金费率
# 订单收入=商品售价-跨境物流成本_藏价-佣金-交易手续费-活动手续费
# 折前售价=商品售价/(1-折扣比例)
# 净利润率=净利润/商品售价
# 站点调价比例=(店铺商品价格*(1-佣金费率-活动服务费费率-交易手续费费率)-藏价)/全球商品价格/汇率

客服提供：
商品售价=((全球商品价格*市场汇率*站点调价比例_店铺)+跨境物流成本_藏价)/(1-佣金费率-活动服务费费率-交易手续费费率)
"""



def start(国家,套餐):
    shipping_cost, guke_yunfei, laoban_yunfei = baxi_yunfei(国家=国家,套餐=套餐, 重量=包裹重量)

    跨境物流成本_藏价 = laoban_yunfei  # 老板跨境运费成本
    商品售价 = ((全球商品价格*市场汇率*站点调价比例_店铺)+跨境物流成本_藏价)/(1-佣金费率-活动服务费费率-交易手续费费率)
    折前售价 = 商品售价/折扣比例
    净利润率 = 净利润*市场汇率/商品售价
    佣金 = 商品售价*佣金费率

    # 运费
    跨境物流成本_藏价 = laoban_yunfei  # 老板跨境运费成本
    卖家支付运费 = shipping_cost  # 总的跨境运费成本
    买家支付运费 = guke_yunfei  # 顾客跨境运费成本

    # 手续费
    交易手续费 = (商品售价+买家支付运费)* 交易手续费费率
    活动手续费 = 商品售价*活动服务费费率
    活动服务费 = 商品售价 * 活动服务费费率

    订单收入 = 商品售价-跨境物流成本_藏价 - 佣金 - 交易手续费 - 活动手续费
    站点调价比例_商品售价 = (商品售价*(1-佣金费率-活动服务费费率-交易手续费费率)-藏价)/全球商品价格/汇率  # 商品售价
    站点调价比例_折前售价 = (折前售价*(1-佣金费率-活动服务费费率-交易手续费费率)-藏价)/全球商品价格/汇率  # 折前售价

    print("|{:-<21}{:-<18}{:<18}".format('属性', '外币', '人民币'))
    print("|{:-<20}{:-<20}{:<18}".format('商品售价:', '%.2f'%商品售价, '%.2f'%(商品售价/汇率)))
    print("|{:-<20}{:-<20}{:<18}".format('折前售价:', '%.2f'%折前售价, '%.2f'%(折前售价/汇率)))
    print("|{:-<20}{:-<20}{:<20}".format('净利润率:', '%.4f'%净利润率,'%.4f'%净利润率))
    print("|{:-<20}{:-<20}{:<18}".format('订单收入:', '%.2f'%订单收入, '%.2f'%(订单收入/汇率)))
    print("|{:-<16}{:-<20}{:<18}".format('站点调价比例_商品售价:', '%.2f'%站点调价比例_商品售价, '%.2f'%(站点调价比例_商品售价)))
    print("|{:-<16}{:-<20}{:<18}".format('站点调价比例_折前售价:', '%.2f'%站点调价比例_折前售价, '%.2f'%(站点调价比例_折前售价)))
    print("|{:-<21}{:-<20}{:<18}".format('佣金:', '%.2f'%佣金, '%.2f'%(佣金/汇率)))
    print("|{:-<19}{:-<20}{:<18}".format('交易手续费:', '%.2f'%交易手续费, '%.2f'%(交易手续费/汇率)))
    print("|{:-<19}{:-<20}{:<18}".format('活动服务费:', '%.2f'%活动服务费, '%.2f'%(活动服务费/汇率)))
    print("|{:-<18}{:-<20}{:<18}".format('卖家支付运费:', '%.2f'%卖家支付运费, '%.2f'%(卖家支付运费/汇率)))
    print("|{:-<17}{:-<20}{:<18}".format('跨境物流成本_藏价:', '%.2f'%跨境物流成本_藏价, '%.2f'%(跨境物流成本_藏价/汇率)))
    print("|{:-<18}{:-<20}{:<18}".format('买家支付运费:', '%.2f'%买家支付运费, '%.2f'%(买家支付运费/汇率)))
    print("-----------------------------------------------------")



    # 1.54--->58.74988952380952
    # 1.545-->58.8556019047619
    # 1.55--->58.96131428571428

if __name__ == '__main__':
    start(国家='巴西', 套餐='zone a')