# Generated by Django 3.0.6 on 2020-12-08 02:20

import os

from django.core import serializers
from django.db import migrations, models


def load_fixture(apps, schema_editor):
    fixture_dir = os.path.abspath(os.path.join(os.path.dirname(__file__), '../fixtures'))
    fixture_file_name = 'initial_data.json'
    fixture_file_path = os.path.join(fixture_dir, fixture_file_name)
    with open(fixture_file_path, 'r') as fixture_file:
        objects = serializers.deserialize('json', fixture_file, ignorenonexistent=True)
        for obj in objects:
            obj.save()


def unload_fixture(apps, schema_editor):
    Leofile = apps.get_model('fs_leonid', 'Leofile')
    Leofile.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('fs_leonid', '0002_leofile'),
    ]

    operations = [
        migrations.RunPython(load_fixture, unload_fixture),
    ]
