<?xml version="1.0"?>
<VOTABLE version="1.1" xsi:schemaLocation="http://www.ivoa.net/xml/VOTable/v1.1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
  <INFO name="QUERY_STATUS" value="OK"/>
  <RESOURCE type="results">
    <TABLE utype="photdm:PhotometryFilter.transmissionCurve.spectrum">
    <PARAM name="FilterProfileService" value="ivo://svo/fps" ucd="meta.ref.ivorn" utype="PhotometryFilter.fpsIdentifier" datatype="char" arraysize="*"/>
    <PARAM name="filterID" value="GAIA/GAIA2r.G" ucd="meta.id" utype="photdm:PhotometryFilter.identifier" datatype="char" arraysize="*"/>
    <PARAM name="WavelengthUnit" value="Angstrom" ucd="meta.unit" utype="PhotometryFilter.SpectralAxis.unit" datatype="char" arraysize="*"/>
    <PARAM name="WavelengthUCD" value="em.wl" ucd="meta.ucd" utype="PhotometryFilter.SpectralAxis.UCD" datatype="char" arraysize="*"/>
    <PARAM name="Description" value="GAIA G filter, DR2 revised curve" ucd="meta.note" utype="photdm:PhotometryFilter.description" datatype="char" arraysize="*"/>
    <PARAM name="PhotSystem" value="GAIA" utype="photdm:PhotometricSystem.description" datatype="char" arraysize="*">
       <DESCRIPTION>Photometric system</DESCRIPTION>
    </PARAM>
    <PARAM name="Instrument" value="GAIA" ucd="instr" datatype="char" arraysize="*">
       <DESCRIPTION>Instrument</DESCRIPTION>
    </PARAM>
    <PARAM name="Facility" value="GAIA" ucd="instr.obsty" datatype="char" arraysize="*">
       <DESCRIPTION>Observational facility</DESCRIPTION>
    </PARAM>
    <PARAM name="ProfileReference" value="https://www.cosmos.esa.int/web/gaia/iow_20180316/" datatype="char" arraysize="*"/>
    <PARAM name="Description" value="GAIA G filter, DR2 revised curve" ucd="meta.note" utype="photdm:PhotometryFilter.description" datatype="char" arraysize="*"/>
    <PARAM name="Comments" value="Revised passband for Gaia DR2.

The original curve has been multiplied by &amp;#955; and normalized to maximum transmission=1 (to transform it to &quot;energy counting&quot; curve)." ucd="meta.note" datatype="char" arraysize="*"/>
    <PARAM name="WavelengthMean" value="6773.7051493917" unit="Angstrom" ucd="em.wl" utype="photdm:PhotometryFilter.SpectralAxis.Coverage.Location.Value" datatype="float" >
       <DESCRIPTION>Mean wavelength. Defined as integ[x*filter(x) dx]/integ[filter(x) dx]</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthEff" value="5836.3100587476" unit="Angstrom" ucd="em.wl.effective" datatype="float" >
       <DESCRIPTION>Effective wavelength. Defined as integ[x*filter(x)*vega(x) dx]/integ[filter(x)*vega(x) dx]</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthMin" value="3321.2002148405" unit="Angstrom" ucd="em.wl;stat.min" utype="photdm:PhotometryFilter.SpectralAxis.Coverage.Bounds.Start" datatype="float" >
       <DESCRIPTION>Minimum filter wavelength. Defined as the first lambda value with a transmission at least 1% of maximum transmission</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthMax" value="10827.456811998" unit="Angstrom" ucd="em.wl;stat.max" utype="photdm:PhotometryFilter.SpectralAxis.Coverage.Bounds.Stop" datatype="float" >
       <DESCRIPTION>Maximum filter wavelength. Defined as the last lambda value with a transmission at least 1% of maximum transmission</DESCRIPTION>
    </PARAM>
    <PARAM name="WidthEff" value="4358.4268132613" unit="Angstrom" ucd="instr.bandwidth" utype="photdm:PhotometryFilter.SpectralAxis.Coverage.Bounds.Extent" datatype="float" >
       <DESCRIPTION>Effective width. Defined as integ[x*filter(x) dx].\nEquivalent to the horizontal size of a rectangle with height equal to maximum transmission and with the same area that the one covered by the filter transmission curve.</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthCen" value="6647.0115835974" unit="Angstrom" ucd="em.wl" datatype="float" >
       <DESCRIPTION>Central wavelength. Defined as the central wavelength between the two points defining FWMH</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthPivot" value="6246.7652640469" unit="Angstrom" ucd="em.wl" datatype="float" >
       <DESCRIPTION>Peak wavelength. Defined as sqrt{integ[x*filter(x) dx]/integ[filter(x) dx/x]}</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthPeak" value="7010" unit="Angstrom" ucd="em.wl" datatype="float" >
       <DESCRIPTION>Peak wavelength. Defined as the lambda value with larger transmission</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthPhot" value="6154.7882669745" unit="Angstrom" ucd="em.wl" datatype="float" >
       <DESCRIPTION>Photon distribution based effective wavelength. Defined as integ[x^2*filter(x)*vega(x) dx]/integ[x*filter(x)*vega(x) dx]</DESCRIPTION>
    </PARAM>
    <PARAM name="FWHM" value="4578.3181026466" unit="Angstrom" ucd="instr.bandwidth" datatype="float" >
       <DESCRIPTION>Full width at half maximum. Defined as the difference between the two wavelengths for which filter transmission is half maximum</DESCRIPTION>
    </PARAM>
    <PARAM name="PhotCalID" value="GAIA/GAIA2r.G/Vega" ucd="meta.id" utype="photdm:PhotCal.identifier" datatype="char" arraysize="*"/>
    <PARAM name="MagSys" value="Vega" ucd="meta.code" utype="photdm:PhotCal.MagnitudeSystem.type" datatype="char" arraysize="*"/>
    <PARAM name="ZeroPoint" value="2835.0945269811" unit="Jy" ucd="phot.flux.density" utype="photdm:PhotCal.ZeroPoint.Flux.value" datatype="float" />
    <PARAM name="ZeroPointUnit" value="Jy" ucd="meta.unit" utype="photdm:PhotCal.ZeroPoint.Flux.unit" datatype="char" arraysize="*"/>
    <PARAM name="ZeroPointType" value="Pogson" ucd="meta.code" utype="photdm:PhotCal.ZeroPoint.type" datatype="char" arraysize="*"/>
      <FIELD name="Wavelength" utype="spec:Data.SpectralAxis.Value" ucd="em.wl" unit="Angstrom" datatype="float"/>
      <FIELD name="Transmission" utype="spec:Data.FluxAxis.Value" ucd="phys.transmission" unit="" datatype="float"/>
      <DATA>
        <TABLEDATA>
          <TR>
            <TD>3000</TD>
            <TD>1.60999e-07</TD>
          </TR>
          <TR>
            <TD>3002.5</TD>
            <TD>1.58449e-07</TD>
          </TR>
          <TR>
            <TD>3005</TD>
            <TD>1.55894e-07</TD>
          </TR>
          <TR>
            <TD>3007.5</TD>
            <TD>1.53335e-07</TD>
          </TR>
          <TR>
            <TD>3010</TD>
            <TD>1.50772e-07</TD>
          </TR>
          <TR>
            <TD>3012.5</TD>
            <TD>1.47823e-07</TD>
          </TR>
          <TR>
            <TD>3015</TD>
            <TD>1.4487e-07</TD>
          </TR>
          <TR>
            <TD>3017.5</TD>
            <TD>1.41912e-07</TD>
          </TR>
          <TR>
            <TD>3020</TD>
            <TD>1.38948e-07</TD>
          </TR>
          <TR>
            <TD>3022.5</TD>
            <TD>1.35574e-07</TD>
          </TR>
          <TR>
            <TD>3025</TD>
            <TD>1.32194e-07</TD>
          </TR>
          <TR>
            <TD>3027.5</TD>
            <TD>1.28808e-07</TD>
          </TR>
          <TR>
            <TD>3030</TD>
            <TD>1.25416e-07</TD>
          </TR>
          <TR>
            <TD>3032.5</TD>
            <TD>1.21912e-07</TD>
          </TR>
          <TR>
            <TD>3035</TD>
            <TD>1.18403e-07</TD>
          </TR>
          <TR>
            <TD>3037.5</TD>
            <TD>1.14887e-07</TD>
          </TR>
          <TR>
            <TD>3040</TD>
            <TD>1.11366e-07</TD>
          </TR>
          <TR>
            <TD>3042.5</TD>
            <TD>1.07626e-07</TD>
          </TR>
          <TR>
            <TD>3045</TD>
            <TD>1.0388e-07</TD>
          </TR>
          <TR>
            <TD>3047.5</TD>
            <TD>1.00128e-07</TD>
          </TR>
          <TR>
            <TD>3050</TD>
            <TD>9.63698e-08</TD>
          </TR>
          <TR>
            <TD>3052.5</TD>
            <TD>9.2467e-08</TD>
          </TR>
          <TR>
            <TD>3055</TD>
            <TD>8.85576e-08</TD>
          </TR>
          <TR>
            <TD>3057.5</TD>
            <TD>8.46417e-08</TD>
          </TR>
          <TR>
            <TD>3060</TD>
            <TD>8.07193e-08</TD>
          </TR>
          <TR>
            <TD>3062.5</TD>
            <TD>7.72419e-08</TD>
          </TR>
          <TR>
            <TD>3065</TD>
            <TD>7.37587e-08</TD>
          </TR>
          <TR>
            <TD>3067.5</TD>
            <TD>7.02697e-08</TD>
          </TR>
          <TR>
            <TD>3070</TD>
            <TD>6.6775e-08</TD>
          </TR>
          <TR>
            <TD>3072.5</TD>
            <TD>6.35704e-08</TD>
          </TR>
          <TR>
            <TD>3075</TD>
            <TD>6.03605e-08</TD>
          </TR>
          <TR>
            <TD>3077.5</TD>
            <TD>5.71453e-08</TD>
          </TR>
          <TR>
            <TD>3080</TD>
            <TD>5.39248e-08</TD>
          </TR>
          <TR>
            <TD>3082.5</TD>
            <TD>5.1123e-08</TD>
          </TR>
          <TR>
            <TD>3085</TD>
            <TD>4.83166e-08</TD>
          </TR>
          <TR>
            <TD>3087.5</TD>
            <TD>4.55056e-08</TD>
          </TR>
          <TR>
            <TD>3090</TD>
            <TD>4.26899e-08</TD>
          </TR>
          <TR>
            <TD>3092.5</TD>
            <TD>4.06403e-08</TD>
          </TR>
          <TR>
            <TD>3095</TD>
            <TD>3.85873e-08</TD>
          </TR>
          <TR>
            <TD>3097.5</TD>
            <TD>3.6531e-08</TD>
          </TR>
          <TR>
            <TD>3100</TD>
            <TD>3.44712e-08</TD>
          </TR>
          <TR>
            <TD>3102.5</TD>
            <TD>3.29193e-08</TD>
          </TR>
          <TR>
            <TD>3105</TD>
            <TD>3.13649e-08</TD>
          </TR>
          <TR>
            <TD>3107.5</TD>
            <TD>2.98079e-08</TD>
          </TR>
          <TR>
            <TD>3110</TD>
            <TD>2.82484e-08</TD>
          </TR>
          <TR>
            <TD>3112.5</TD>
            <TD>2.71247e-08</TD>
          </TR>
          <TR>
            <TD>3115</TD>
            <TD>2.59992e-08</TD>
          </TR>
          <TR>
            <TD>3117.5</TD>
            <TD>2.48718e-08</TD>
          </TR>
          <TR>
            <TD>3120</TD>
            <TD>2.37426e-08</TD>
          </TR>
          <TR>
            <TD>3122.5</TD>
            <TD>2.28485e-08</TD>
          </TR>
          <TR>
            <TD>3125</TD>
            <TD>2.1953e-08</TD>
          </TR>
          <TR>
            <TD>3127.5</TD>
            <TD>2.10561e-08</TD>
          </TR>
          <TR>
            <TD>3130</TD>
            <TD>2.01577e-08</TD>
          </TR>
          <TR>
            <TD>3132.5</TD>
            <TD>1.94046e-08</TD>
          </TR>
          <TR>
            <TD>3135</TD>
            <TD>1.86503e-08</TD>
          </TR>
          <TR>
            <TD>3137.5</TD>
            <TD>1.78949e-08</TD>
          </TR>
          <TR>
            <TD>3140</TD>
            <TD>1.71381e-08</TD>
          </TR>
          <TR>
            <TD>3142.5</TD>
            <TD>1.65276e-08</TD>
          </TR>
          <TR>
            <TD>3145</TD>
            <TD>1.5916e-08</TD>
          </TR>
          <TR>
            <TD>3147.5</TD>
            <TD>1.53034e-08</TD>
          </TR>
          <TR>
            <TD>3150</TD>
            <TD>1.46899e-08</TD>
          </TR>
          <TR>
            <TD>3152.5</TD>
            <TD>1.40823e-08</TD>
          </TR>
          <TR>
            <TD>3155</TD>
            <TD>1.34738e-08</TD>
          </TR>
          <TR>
            <TD>3157.5</TD>
            <TD>1.28642e-08</TD>
          </TR>
          <TR>
            <TD>3160</TD>
            <TD>1.22537e-08</TD>
          </TR>
          <TR>
            <TD>3162.5</TD>
            <TD>1.19063e-08</TD>
          </TR>
          <TR>
            <TD>3165</TD>
            <TD>1.15582e-08</TD>
          </TR>
          <TR>
            <TD>3167.5</TD>
            <TD>1.12096e-08</TD>
          </TR>
          <TR>
            <TD>3170</TD>
            <TD>1.08604e-08</TD>
          </TR>
          <TR>
            <TD>3172.5</TD>
            <TD>1.08862e-08</TD>
          </TR>
          <TR>
            <TD>3175</TD>
            <TD>1.0912e-08</TD>
          </TR>
          <TR>
            <TD>3177.5</TD>
            <TD>1.09379e-08</TD>
          </TR>
          <TR>
            <TD>3180</TD>
            <TD>1.09638e-08</TD>
          </TR>
          <TR>
            <TD>3182.5</TD>
            <TD>1.11766e-08</TD>
          </TR>
          <TR>
            <TD>3185</TD>
            <TD>1.13898e-08</TD>
          </TR>
          <TR>
            <TD>3187.5</TD>
            <TD>1.16033e-08</TD>
          </TR>
          <TR>
            <TD>3190</TD>
            <TD>1.18172e-08</TD>
          </TR>
          <TR>
            <TD>3192.5</TD>
            <TD>1.3349e-08</TD>
          </TR>
          <TR>
            <TD>3195</TD>
            <TD>1.48832e-08</TD>
          </TR>
          <TR>
            <TD>3197.5</TD>
            <TD>1.64198e-08</TD>
          </TR>
          <TR>
            <TD>3200</TD>
            <TD>1.79588e-08</TD>
          </TR>
          <TR>
            <TD>3202.5</TD>
            <TD>2.96621e-08</TD>
          </TR>
          <TR>
            <TD>3205</TD>
            <TD>4.13836e-08</TD>
          </TR>
          <TR>
            <TD>3207.5</TD>
            <TD>5.31235e-08</TD>
          </TR>
          <TR>
            <TD>3210</TD>
            <TD>6.48815e-08</TD>
          </TR>
          <TR>
            <TD>3212.5</TD>
            <TD>1.27523e-07</TD>
          </TR>
          <TR>
            <TD>3215</TD>
            <TD>1.90261e-07</TD>
          </TR>
          <TR>
            <TD>3217.5</TD>
            <TD>2.53097e-07</TD>
          </TR>
          <TR>
            <TD>3220</TD>
            <TD>3.16031e-07</TD>
          </TR>
          <TR>
            <TD>3222.5</TD>
            <TD>6.24167e-07</TD>
          </TR>
          <TR>
            <TD>3225</TD>
            <TD>9.32781e-07</TD>
          </TR>
          <TR>
            <TD>3227.5</TD>
            <TD>1.24187e-06</TD>
          </TR>
          <TR>
            <TD>3230</TD>
            <TD>1.55144e-06</TD>
          </TR>
          <TR>
            <TD>3232.5</TD>
            <TD>3.05513e-06</TD>
          </TR>
          <TR>
            <TD>3235</TD>
            <TD>4.56114e-06</TD>
          </TR>
          <TR>
            <TD>3237.5</TD>
            <TD>6.06947e-06</TD>
          </TR>
          <TR>
            <TD>3240</TD>
            <TD>7.58013e-06</TD>
          </TR>
          <TR>
            <TD>3242.5</TD>
            <TD>1.40286e-05</TD>
          </TR>
          <TR>
            <TD>3245</TD>
            <TD>2.04871e-05</TD>
          </TR>
          <TR>
            <TD>3247.5</TD>
            <TD>2.69554e-05</TD>
          </TR>
          <TR>
            <TD>3250</TD>
            <TD>3.34337e-05</TD>
          </TR>
          <TR>
            <TD>3252.5</TD>
            <TD>5.64852e-05</TD>
          </TR>
          <TR>
            <TD>3255</TD>
            <TD>7.95721e-05</TD>
          </TR>
          <TR>
            <TD>3257.5</TD>
            <TD>0.000102694</TD>
          </TR>
          <TR>
            <TD>3260</TD>
            <TD>0.000125852</TD>
          </TR>
          <TR>
            <TD>3262.5</TD>
            <TD>0.000191139</TD>
          </TR>
          <TR>
            <TD>3265</TD>
            <TD>0.000256526</TD>
          </TR>
          <TR>
            <TD>3267.5</TD>
            <TD>0.000322012</TD>
          </TR>
          <TR>
            <TD>3270</TD>
            <TD>0.000387599</TD>
          </TR>
          <TR>
            <TD>3272.5</TD>
            <TD>0.000535784</TD>
          </TR>
          <TR>
            <TD>3275</TD>
            <TD>0.000684195</TD>
          </TR>
          <TR>
            <TD>3277.5</TD>
            <TD>0.000832832</TD>
          </TR>
          <TR>
            <TD>3280</TD>
            <TD>0.000981696</TD>
          </TR>
          <TR>
            <TD>3282.5</TD>
            <TD>0.00126069</TD>
          </TR>
          <TR>
            <TD>3285</TD>
            <TD>0.0015401</TD>
          </TR>
          <TR>
            <TD>3287.5</TD>
            <TD>0.00181994</TD>
          </TR>
          <TR>
            <TD>3290</TD>
            <TD>0.0021002</TD>
          </TR>
          <TR>
            <TD>3292.5</TD>
            <TD>0.00254695</TD>
          </TR>
          <TR>
            <TD>3295</TD>
            <TD>0.00299436</TD>
          </TR>
          <TR>
            <TD>3297.5</TD>
            <TD>0.00344246</TD>
          </TR>
          <TR>
            <TD>3300</TD>
            <TD>0.00389123</TD>
          </TR>
          <TR>
            <TD>3302.5</TD>
            <TD>0.00451787</TD>
          </TR>
          <TR>
            <TD>3305</TD>
            <TD>0.00514546</TD>
          </TR>
          <TR>
            <TD>3307.5</TD>
            <TD>0.00577399</TD>
          </TR>
          <TR>
            <TD>3310</TD>
            <TD>0.00640346</TD>
          </TR>
          <TR>
            <TD>3312.5</TD>
            <TD>0.00719188</TD>
          </TR>
          <TR>
            <TD>3315</TD>
            <TD>0.00798149</TD>
          </TR>
          <TR>
            <TD>3317.5</TD>
            <TD>0.00877228</TD>
          </TR>
          <TR>
            <TD>3320</TD>
            <TD>0.00956425</TD>
          </TR>
          <TR>
            <TD>3322.5</TD>
            <TD>0.0104719</TD>
          </TR>
          <TR>
            <TD>3325</TD>
            <TD>0.0113809</TD>
          </TR>
          <TR>
            <TD>3327.5</TD>
            <TD>0.0122913</TD>
          </TR>
          <TR>
            <TD>3330</TD>
            <TD>0.013203</TD>
          </TR>
          <TR>
            <TD>3332.5</TD>
            <TD>0.0142061</TD>
          </TR>
          <TR>
            <TD>3335</TD>
            <TD>0.0152106</TD>
          </TR>
          <TR>
            <TD>3337.5</TD>
            <TD>0.0162166</TD>
          </TR>
          <TR>
            <TD>3340</TD>
            <TD>0.0172241</TD>
          </TR>
          <TR>
            <TD>3342.5</TD>
            <TD>0.0182687</TD>
          </TR>
          <TR>
            <TD>3345</TD>
            <TD>0.0193149</TD>
          </TR>
          <TR>
            <TD>3347.5</TD>
            <TD>0.0203626</TD>
          </TR>
          <TR>
            <TD>3350</TD>
            <TD>0.0214118</TD>
          </TR>
          <TR>
            <TD>3352.5</TD>
            <TD>0.0224495</TD>
          </TR>
          <TR>
            <TD>3355</TD>
            <TD>0.0234887</TD>
          </TR>
          <TR>
            <TD>3357.5</TD>
            <TD>0.0245294</TD>
          </TR>
          <TR>
            <TD>3360</TD>
            <TD>0.0255716</TD>
          </TR>
          <TR>
            <TD>3362.5</TD>
            <TD>0.0266028</TD>
          </TR>
          <TR>
            <TD>3365</TD>
            <TD>0.0276355</TD>
          </TR>
          <TR>
            <TD>3367.5</TD>
            <TD>0.0286698</TD>
          </TR>
          <TR>
            <TD>3370</TD>
            <TD>0.0297055</TD>
          </TR>
          <TR>
            <TD>3372.5</TD>
            <TD>0.0306993</TD>
          </TR>
          <TR>
            <TD>3375</TD>
            <TD>0.0316945</TD>
          </TR>
          <TR>
            <TD>3377.5</TD>
            <TD>0.0326911</TD>
          </TR>
          <TR>
            <TD>3380</TD>
            <TD>0.0336893</TD>
          </TR>
          <TR>
            <TD>3382.5</TD>
            <TD>0.034661</TD>
          </TR>
          <TR>
            <TD>3385</TD>
            <TD>0.0356342</TD>
          </TR>
          <TR>
            <TD>3387.5</TD>
            <TD>0.0366088</TD>
          </TR>
          <TR>
            <TD>3390</TD>
            <TD>0.0375848</TD>
          </TR>
          <TR>
            <TD>3392.5</TD>
            <TD>0.0385168</TD>
          </TR>
          <TR>
            <TD>3395</TD>
            <TD>0.0394501</TD>
          </TR>
          <TR>
            <TD>3397.5</TD>
            <TD>0.0403848</TD>
          </TR>
          <TR>
            <TD>3400</TD>
            <TD>0.0413208</TD>
          </TR>
          <TR>
            <TD>3402.5</TD>
            <TD>0.0422319</TD>
          </TR>
          <TR>
            <TD>3405</TD>
            <TD>0.0431443</TD>
          </TR>
          <TR>
            <TD>3407.5</TD>
            <TD>0.044058</TD>
          </TR>
          <TR>
            <TD>3410</TD>
            <TD>0.044973</TD>
          </TR>
          <TR>
            <TD>3412.5</TD>
            <TD>0.0458318</TD>
          </TR>
          <TR>
            <TD>3415</TD>
            <TD>0.0466917</TD>
          </TR>
          <TR>
            <TD>3417.5</TD>
            <TD>0.0475529</TD>
          </TR>
          <TR>
            <TD>3420</TD>
            <TD>0.0484153</TD>
          </TR>
          <TR>
            <TD>3422.5</TD>
            <TD>0.0492038</TD>
          </TR>
          <TR>
            <TD>3425</TD>
            <TD>0.0499933</TD>
          </TR>
          <TR>
            <TD>3427.5</TD>
            <TD>0.050784</TD>
          </TR>
          <TR>
            <TD>3430</TD>
            <TD>0.0515758</TD>
          </TR>
          <TR>
            <TD>3432.5</TD>
            <TD>0.0523076</TD>
          </TR>
          <TR>
            <TD>3435</TD>
            <TD>0.0530403</TD>
          </TR>
          <TR>
            <TD>3437.5</TD>
            <TD>0.0537742</TD>
          </TR>
          <TR>
            <TD>3440</TD>
            <TD>0.054509</TD>
          </TR>
          <TR>
            <TD>3442.5</TD>
            <TD>0.0551939</TD>
          </TR>
          <TR>
            <TD>3445</TD>
            <TD>0.0558798</TD>
          </TR>
          <TR>
            <TD>3447.5</TD>
            <TD>0.0565666</TD>
          </TR>
          <TR>
            <TD>3450</TD>
            <TD>0.0572544</TD>
          </TR>
          <TR>
            <TD>3452.5</TD>
            <TD>0.0578518</TD>
          </TR>
          <TR>
            <TD>3455</TD>
            <TD>0.05845</TD>
          </TR>
          <TR>
            <TD>3457.5</TD>
            <TD>0.059049</TD>
          </TR>
          <TR>
            <TD>3460</TD>
            <TD>0.0596489</TD>
          </TR>
          <TR>
            <TD>3462.5</TD>
            <TD>0.0601861</TD>
          </TR>
          <TR>
            <TD>3465</TD>
            <TD>0.0607241</TD>
          </TR>
          <TR>
            <TD>3467.5</TD>
            <TD>0.0612628</TD>
          </TR>
          <TR>
            <TD>3470</TD>
            <TD>0.0618021</TD>
          </TR>
          <TR>
            <TD>3472.5</TD>
            <TD>0.0622752</TD>
          </TR>
          <TR>
            <TD>3475</TD>
            <TD>0.0627488</TD>
          </TR>
          <TR>
            <TD>3477.5</TD>
            <TD>0.0632231</TD>
          </TR>
          <TR>
            <TD>3480</TD>
            <TD>0.063698</TD>
          </TR>
          <TR>
            <TD>3482.5</TD>
            <TD>0.0641132</TD>
          </TR>
          <TR>
            <TD>3485</TD>
            <TD>0.0645289</TD>
          </TR>
          <TR>
            <TD>3487.5</TD>
            <TD>0.0649451</TD>
          </TR>
          <TR>
            <TD>3490</TD>
            <TD>0.0653619</TD>
          </TR>
          <TR>
            <TD>3492.5</TD>
            <TD>0.0657269</TD>
          </TR>
          <TR>
            <TD>3495</TD>
            <TD>0.0660923</TD>
          </TR>
          <TR>
            <TD>3497.5</TD>
            <TD>0.0664583</TD>
          </TR>
          <TR>
            <TD>3500</TD>
            <TD>0.0668246</TD>
          </TR>
          <TR>
            <TD>3502.5</TD>
            <TD>0.0671332</TD>
          </TR>
          <TR>
            <TD>3505</TD>
            <TD>0.0674421</TD>
          </TR>
          <TR>
            <TD>3507.5</TD>
            <TD>0.0677513</TD>
          </TR>
          <TR>
            <TD>3510</TD>
            <TD>0.068061</TD>
          </TR>
          <TR>
            <TD>3512.5</TD>
            <TD>0.0683097</TD>
          </TR>
          <TR>
            <TD>3515</TD>
            <TD>0.0685587</TD>
          </TR>
          <TR>
            <TD>3517.5</TD>
            <TD>0.068808</TD>
          </TR>
          <TR>
            <TD>3520</TD>
            <TD>0.0690576</TD>
          </TR>
          <TR>
            <TD>3522.5</TD>
            <TD>0.0692583</TD>
          </TR>
          <TR>
            <TD>3525</TD>
            <TD>0.0694593</TD>
          </TR>
          <TR>
            <TD>3527.5</TD>
            <TD>0.0696604</TD>
          </TR>
          <TR>
            <TD>3530</TD>
            <TD>0.0698618</TD>
          </TR>
          <TR>
            <TD>3532.5</TD>
            <TD>0.0700493</TD>
          </TR>
          <TR>
            <TD>3535</TD>
            <TD>0.0702371</TD>
          </TR>
          <TR>
            <TD>3537.5</TD>
            <TD>0.0704251</TD>
          </TR>
          <TR>
            <TD>3540</TD>
            <TD>0.0706132</TD>
          </TR>
          <TR>
            <TD>3542.5</TD>
            <TD>0.0707473</TD>
          </TR>
          <TR>
            <TD>3545</TD>
            <TD>0.0708815</TD>
          </TR>
          <TR>
            <TD>3547.5</TD>
            <TD>0.0710158</TD>
          </TR>
          <TR>
            <TD>3550</TD>
            <TD>0.0711502</TD>
          </TR>
          <TR>
            <TD>3552.5</TD>
            <TD>0.0712492</TD>
          </TR>
          <TR>
            <TD>3555</TD>
            <TD>0.0713484</TD>
          </TR>
          <TR>
            <TD>3557.5</TD>
            <TD>0.0714476</TD>
          </TR>
          <TR>
            <TD>3560</TD>
            <TD>0.0715469</TD>
          </TR>
          <TR>
            <TD>3562.5</TD>
            <TD>0.0715986</TD>
          </TR>
          <TR>
            <TD>3565</TD>
            <TD>0.0716503</TD>
          </TR>
          <TR>
            <TD>3567.5</TD>
            <TD>0.071702</TD>
          </TR>
          <TR>
            <TD>3570</TD>
            <TD>0.0717537</TD>
          </TR>
          <TR>
            <TD>3572.5</TD>
            <TD>0.0718077</TD>
          </TR>
          <TR>
            <TD>3575</TD>
            <TD>0.0718616</TD>
          </TR>
          <TR>
            <TD>3577.5</TD>
            <TD>0.0719155</TD>
          </TR>
          <TR>
            <TD>3580</TD>
            <TD>0.0719695</TD>
          </TR>
          <TR>
            <TD>3582.5</TD>
            <TD>0.0719718</TD>
          </TR>
          <TR>
            <TD>3585</TD>
            <TD>0.0719741</TD>
          </TR>
          <TR>
            <TD>3587.5</TD>
            <TD>0.0719763</TD>
          </TR>
          <TR>
            <TD>3590</TD>
            <TD>0.0719784</TD>
          </TR>
          <TR>
            <TD>3592.5</TD>
            <TD>0.0719746</TD>
          </TR>
          <TR>
            <TD>3595</TD>
            <TD>0.0719708</TD>
          </TR>
          <TR>
            <TD>3597.5</TD>
            <TD>0.071967</TD>
          </TR>
          <TR>
            <TD>3600</TD>
            <TD>0.071963</TD>
          </TR>
          <TR>
            <TD>3602.5</TD>
            <TD>0.0719649</TD>
          </TR>
          <TR>
            <TD>3605</TD>
            <TD>0.0719667</TD>
          </TR>
          <TR>
            <TD>3607.5</TD>
            <TD>0.0719685</TD>
          </TR>
          <TR>
            <TD>3610</TD>
            <TD>0.0719702</TD>
          </TR>
          <TR>
            <TD>3612.5</TD>
            <TD>0.0719342</TD>
          </TR>
          <TR>
            <TD>3615</TD>
            <TD>0.0718981</TD>
          </TR>
          <TR>
            <TD>3617.5</TD>
            <TD>0.0718619</TD>
          </TR>
          <TR>
            <TD>3620</TD>
            <TD>0.0718256</TD>
          </TR>
          <TR>
            <TD>3622.5</TD>
            <TD>0.0718387</TD>
          </TR>
          <TR>
            <TD>3625</TD>
            <TD>0.0718518</TD>
          </TR>
          <TR>
            <TD>3627.5</TD>
            <TD>0.0718648</TD>
          </TR>
          <TR>
            <TD>3630</TD>
            <TD>0.0718778</TD>
          </TR>
          <TR>
            <TD>3632.5</TD>
            <TD>0.071875</TD>
          </TR>
          <TR>
            <TD>3635</TD>
            <TD>0.0718721</TD>
          </TR>
          <TR>
            <TD>3637.5</TD>
            <TD>0.0718691</TD>
          </TR>
          <TR>
            <TD>3640</TD>
            <TD>0.0718661</TD>
          </TR>
          <TR>
            <TD>3642.5</TD>
            <TD>0.0719036</TD>
          </TR>
          <TR>
            <TD>3645</TD>
            <TD>0.071941</TD>
          </TR>
          <TR>
            <TD>3647.5</TD>
            <TD>0.0719784</TD>
          </TR>
          <TR>
            <TD>3650</TD>
            <TD>0.0720158</TD>
          </TR>
          <TR>
            <TD>3652.5</TD>
            <TD>0.0720815</TD>
          </TR>
          <TR>
            <TD>3655</TD>
            <TD>0.0721471</TD>
          </TR>
          <TR>
            <TD>3657.5</TD>
            <TD>0.0722128</TD>
          </TR>
          <TR>
            <TD>3660</TD>
            <TD>0.0722785</TD>
          </TR>
          <TR>
            <TD>3662.5</TD>
            <TD>0.0723613</TD>
          </TR>
          <TR>
            <TD>3665</TD>
            <TD>0.0724441</TD>
          </TR>
          <TR>
            <TD>3667.5</TD>
            <TD>0.072527</TD>
          </TR>
          <TR>
            <TD>3670</TD>
            <TD>0.0726099</TD>
          </TR>
          <TR>
            <TD>3672.5</TD>
            <TD>0.072764</TD>
          </TR>
          <TR>
            <TD>3675</TD>
            <TD>0.0729182</TD>
          </TR>
          <TR>
            <TD>3677.5</TD>
            <TD>0.0730726</TD>
          </TR>
          <TR>
            <TD>3680</TD>
            <TD>0.073227</TD>
          </TR>
          <TR>
            <TD>3682.5</TD>
            <TD>0.0734301</TD>
          </TR>
          <TR>
            <TD>3685</TD>
            <TD>0.0736334</TD>
          </TR>
          <TR>
            <TD>3687.5</TD>
            <TD>0.0738368</TD>
          </TR>
          <TR>
            <TD>3690</TD>
            <TD>0.0740405</TD>
          </TR>
          <TR>
            <TD>3692.5</TD>
            <TD>0.0742579</TD>
          </TR>
          <TR>
            <TD>3695</TD>
            <TD>0.0744754</TD>
          </TR>
          <TR>
            <TD>3697.5</TD>
            <TD>0.0746932</TD>
          </TR>
          <TR>
            <TD>3700</TD>
            <TD>0.0749113</TD>
          </TR>
          <TR>
            <TD>3702.5</TD>
            <TD>0.0752135</TD>
          </TR>
          <TR>
            <TD>3705</TD>
            <TD>0.075516</TD>
          </TR>
          <TR>
            <TD>3707.5</TD>
            <TD>0.0758188</TD>
          </TR>
          <TR>
            <TD>3710</TD>
            <TD>0.0761221</TD>
          </TR>
          <TR>
            <TD>3712.5</TD>
            <TD>0.0764309</TD>
          </TR>
          <TR>
            <TD>3715</TD>
            <TD>0.0767402</TD>
          </TR>
          <TR>
            <TD>3717.5</TD>
            <TD>0.0770498</TD>
          </TR>
          <TR>
            <TD>3720</TD>
            <TD>0.0773597</TD>
          </TR>
          <TR>
            <TD>3722.5</TD>
            <TD>0.077712</TD>
          </TR>
          <TR>
            <TD>3725</TD>
            <TD>0.0780648</TD>
          </TR>
          <TR>
            <TD>3727.5</TD>
            <TD>0.078418</TD>
          </TR>
          <TR>
            <TD>3730</TD>
            <TD>0.0787715</TD>
          </TR>
          <TR>
            <TD>3732.5</TD>
            <TD>0.0791771</TD>
          </TR>
          <TR>
            <TD>3735</TD>
            <TD>0.0795831</TD>
          </TR>
          <TR>
            <TD>3737.5</TD>
            <TD>0.0799896</TD>
          </TR>
          <TR>
            <TD>3740</TD>
            <TD>0.0803966</TD>
          </TR>
          <TR>
            <TD>3742.5</TD>
            <TD>0.0808673</TD>
          </TR>
          <TR>
            <TD>3745</TD>
            <TD>0.0813386</TD>
          </TR>
          <TR>
            <TD>3747.5</TD>
            <TD>0.0818105</TD>
          </TR>
          <TR>
            <TD>3750</TD>
            <TD>0.082283</TD>
          </TR>
          <TR>
            <TD>3752.5</TD>
            <TD>0.0828299</TD>
          </TR>
          <TR>
            <TD>3755</TD>
            <TD>0.0833775</TD>
          </TR>
          <TR>
            <TD>3757.5</TD>
            <TD>0.0839257</TD>
          </TR>
          <TR>
            <TD>3760</TD>
            <TD>0.0844746</TD>
          </TR>
          <TR>
            <TD>3762.5</TD>
            <TD>0.0850701</TD>
          </TR>
          <TR>
            <TD>3765</TD>
            <TD>0.0856665</TD>
          </TR>
          <TR>
            <TD>3767.5</TD>
            <TD>0.0862635</TD>
          </TR>
          <TR>
            <TD>3770</TD>
            <TD>0.0868612</TD>
          </TR>
          <TR>
            <TD>3772.5</TD>
            <TD>0.0875285</TD>
          </TR>
          <TR>
            <TD>3775</TD>
            <TD>0.0881966</TD>
          </TR>
          <TR>
            <TD>3777.5</TD>
            <TD>0.0888655</TD>
          </TR>
          <TR>
            <TD>3780</TD>
            <TD>0.0895352</TD>
          </TR>
          <TR>
            <TD>3782.5</TD>
            <TD>0.0903544</TD>
          </TR>
          <TR>
            <TD>3785</TD>
            <TD>0.0911746</TD>
          </TR>
          <TR>
            <TD>3787.5</TD>
            <TD>0.0919959</TD>
          </TR>
          <TR>
            <TD>3790</TD>
            <TD>0.0928181</TD>
          </TR>
          <TR>
            <TD>3792.5</TD>
            <TD>0.0937698</TD>
          </TR>
          <TR>
            <TD>3795</TD>
            <TD>0.0947227</TD>
          </TR>
          <TR>
            <TD>3797.5</TD>
            <TD>0.0956768</TD>
          </TR>
          <TR>
            <TD>3800</TD>
            <TD>0.0966321</TD>
          </TR>
          <TR>
            <TD>3802.5</TD>
            <TD>0.0977386</TD>
          </TR>
          <TR>
            <TD>3805</TD>
            <TD>0.0988465</TD>
          </TR>
          <TR>
            <TD>3807.5</TD>
            <TD>0.0999557</TD>
          </TR>
          <TR>
            <TD>3810</TD>
            <TD>0.101066</TD>
          </TR>
          <TR>
            <TD>3812.5</TD>
            <TD>0.102375</TD>
          </TR>
          <TR>
            <TD>3815</TD>
            <TD>0.103686</TD>
          </TR>
          <TR>
            <TD>3817.5</TD>
            <TD>0.104999</TD>
          </TR>
          <TR>
            <TD>3820</TD>
            <TD>0.106313</TD>
          </TR>
          <TR>
            <TD>3822.5</TD>
            <TD>0.10779</TD>
          </TR>
          <TR>
            <TD>3825</TD>
            <TD>0.109269</TD>
          </TR>
          <TR>
            <TD>3827.5</TD>
            <TD>0.110751</TD>
          </TR>
          <TR>
            <TD>3830</TD>
            <TD>0.112233</TD>
          </TR>
          <TR>
            <TD>3832.5</TD>
            <TD>0.113929</TD>
          </TR>
          <TR>
            <TD>3835</TD>
            <TD>0.115626</TD>
          </TR>
          <TR>
            <TD>3837.5</TD>
            <TD>0.117325</TD>
          </TR>
          <TR>
            <TD>3840</TD>
            <TD>0.119027</TD>
          </TR>
          <TR>
            <TD>3842.5</TD>
            <TD>0.12093</TD>
          </TR>
          <TR>
            <TD>3845</TD>
            <TD>0.122836</TD>
          </TR>
          <TR>
            <TD>3847.5</TD>
            <TD>0.124744</TD>
          </TR>
          <TR>
            <TD>3850</TD>
            <TD>0.126654</TD>
          </TR>
          <TR>
            <TD>3852.5</TD>
            <TD>0.128812</TD>
          </TR>
          <TR>
            <TD>3855</TD>
            <TD>0.130973</TD>
          </TR>
          <TR>
            <TD>3857.5</TD>
            <TD>0.133137</TD>
          </TR>
          <TR>
            <TD>3860</TD>
            <TD>0.135303</TD>
          </TR>
          <TR>
            <TD>3862.5</TD>
            <TD>0.137656</TD>
          </TR>
          <TR>
            <TD>3865</TD>
            <TD>0.140013</TD>
          </TR>
          <TR>
            <TD>3867.5</TD>
            <TD>0.142372</TD>
          </TR>
          <TR>
            <TD>3870</TD>
            <TD>0.144734</TD>
          </TR>
          <TR>
            <TD>3872.5</TD>
            <TD>0.147292</TD>
          </TR>
          <TR>
            <TD>3875</TD>
            <TD>0.149854</TD>
          </TR>
          <TR>
            <TD>3877.5</TD>
            <TD>0.152418</TD>
          </TR>
          <TR>
            <TD>3880</TD>
            <TD>0.154986</TD>
          </TR>
          <TR>
            <TD>3882.5</TD>
            <TD>0.157737</TD>
          </TR>
          <TR>
            <TD>3885</TD>
            <TD>0.160491</TD>
          </TR>
          <TR>
            <TD>3887.5</TD>
            <TD>0.163248</TD>
          </TR>
          <TR>
            <TD>3890</TD>
            <TD>0.166009</TD>
          </TR>
          <TR>
            <TD>3892.5</TD>
            <TD>0.168875</TD>
          </TR>
          <TR>
            <TD>3895</TD>
            <TD>0.171745</TD>
          </TR>
          <TR>
            <TD>3897.5</TD>
            <TD>0.174618</TD>
          </TR>
          <TR>
            <TD>3900</TD>
            <TD>0.177495</TD>
          </TR>
          <TR>
            <TD>3902.5</TD>
            <TD>0.180454</TD>
          </TR>
          <TR>
            <TD>3905</TD>
            <TD>0.183418</TD>
          </TR>
          <TR>
            <TD>3907.5</TD>
            <TD>0.186385</TD>
          </TR>
          <TR>
            <TD>3910</TD>
            <TD>0.189355</TD>
          </TR>
          <TR>
            <TD>3912.5</TD>
            <TD>0.192407</TD>
          </TR>
          <TR>
            <TD>3915</TD>
            <TD>0.195463</TD>
          </TR>
          <TR>
            <TD>3917.5</TD>
            <TD>0.198523</TD>
          </TR>
          <TR>
            <TD>3920</TD>
            <TD>0.201586</TD>
          </TR>
          <TR>
            <TD>3922.5</TD>
            <TD>0.204611</TD>
          </TR>
          <TR>
            <TD>3925</TD>
            <TD>0.20764</TD>
          </TR>
          <TR>
            <TD>3927.5</TD>
            <TD>0.210673</TD>
          </TR>
          <TR>
            <TD>3930</TD>
            <TD>0.213709</TD>
          </TR>
          <TR>
            <TD>3932.5</TD>
            <TD>0.216758</TD>
          </TR>
          <TR>
            <TD>3935</TD>
            <TD>0.219811</TD>
          </TR>
          <TR>
            <TD>3937.5</TD>
            <TD>0.222867</TD>
          </TR>
          <TR>
            <TD>3940</TD>
            <TD>0.225928</TD>
          </TR>
          <TR>
            <TD>3942.5</TD>
            <TD>0.22886</TD>
          </TR>
          <TR>
            <TD>3945</TD>
            <TD>0.231797</TD>
          </TR>
          <TR>
            <TD>3947.5</TD>
            <TD>0.234737</TD>
          </TR>
          <TR>
            <TD>3950</TD>
            <TD>0.23768</TD>
          </TR>
          <TR>
            <TD>3952.5</TD>
            <TD>0.240563</TD>
          </TR>
          <TR>
            <TD>3955</TD>
            <TD>0.243449</TD>
          </TR>
          <TR>
            <TD>3957.5</TD>
            <TD>0.246339</TD>
          </TR>
          <TR>
            <TD>3960</TD>
            <TD>0.249233</TD>
          </TR>
          <TR>
            <TD>3962.5</TD>
            <TD>0.251985</TD>
          </TR>
          <TR>
            <TD>3965</TD>
            <TD>0.254741</TD>
          </TR>
          <TR>
            <TD>3967.5</TD>
            <TD>0.2575</TD>
          </TR>
          <TR>
            <TD>3970</TD>
            <TD>0.260263</TD>
          </TR>
          <TR>
            <TD>3972.5</TD>
            <TD>0.262892</TD>
          </TR>
          <TR>
            <TD>3975</TD>
            <TD>0.265524</TD>
          </TR>
          <TR>
            <TD>3977.5</TD>
            <TD>0.268159</TD>
          </TR>
          <TR>
            <TD>3980</TD>
            <TD>0.270798</TD>
          </TR>
          <TR>
            <TD>3982.5</TD>
            <TD>0.273409</TD>
          </TR>
          <TR>
            <TD>3985</TD>
            <TD>0.276023</TD>
          </TR>
          <TR>
            <TD>3987.5</TD>
            <TD>0.27864</TD>
          </TR>
          <TR>
            <TD>3990</TD>
            <TD>0.28126</TD>
          </TR>
          <TR>
            <TD>3992.5</TD>
            <TD>0.283716</TD>
          </TR>
          <TR>
            <TD>3995</TD>
            <TD>0.286174</TD>
          </TR>
          <TR>
            <TD>3997.5</TD>
            <TD>0.288636</TD>
          </TR>
          <TR>
            <TD>4000</TD>
            <TD>0.2911</TD>
          </TR>
          <TR>
            <TD>4002.5</TD>
            <TD>0.293376</TD>
          </TR>
          <TR>
            <TD>4005</TD>
            <TD>0.295655</TD>
          </TR>
          <TR>
            <TD>4007.5</TD>
            <TD>0.297936</TD>
          </TR>
          <TR>
            <TD>4010</TD>
            <TD>0.300219</TD>
          </TR>
          <TR>
            <TD>4012.5</TD>
            <TD>0.302483</TD>
          </TR>
          <TR>
            <TD>4015</TD>
            <TD>0.304749</TD>
          </TR>
          <TR>
            <TD>4017.5</TD>
            <TD>0.307018</TD>
          </TR>
          <TR>
            <TD>4020</TD>
            <TD>0.309289</TD>
          </TR>
          <TR>
            <TD>4022.5</TD>
            <TD>0.311567</TD>
          </TR>
          <TR>
            <TD>4025</TD>
            <TD>0.313847</TD>
          </TR>
          <TR>
            <TD>4027.5</TD>
            <TD>0.31613</TD>
          </TR>
          <TR>
            <TD>4030</TD>
            <TD>0.318415</TD>
          </TR>
          <TR>
            <TD>4032.5</TD>
            <TD>0.320488</TD>
          </TR>
          <TR>
            <TD>4035</TD>
            <TD>0.322562</TD>
          </TR>
          <TR>
            <TD>4037.5</TD>
            <TD>0.324639</TD>
          </TR>
          <TR>
            <TD>4040</TD>
            <TD>0.326718</TD>
          </TR>
          <TR>
            <TD>4042.5</TD>
            <TD>0.328708</TD>
          </TR>
          <TR>
            <TD>4045</TD>
            <TD>0.3307</TD>
          </TR>
          <TR>
            <TD>4047.5</TD>
            <TD>0.332694</TD>
          </TR>
          <TR>
            <TD>4050</TD>
            <TD>0.33469</TD>
          </TR>
          <TR>
            <TD>4052.5</TD>
            <TD>0.336672</TD>
          </TR>
          <TR>
            <TD>4055</TD>
            <TD>0.338656</TD>
          </TR>
          <TR>
            <TD>4057.5</TD>
            <TD>0.340642</TD>
          </TR>
          <TR>
            <TD>4060</TD>
            <TD>0.342631</TD>
          </TR>
          <TR>
            <TD>4062.5</TD>
            <TD>0.344457</TD>
          </TR>
          <TR>
            <TD>4065</TD>
            <TD>0.346285</TD>
          </TR>
          <TR>
            <TD>4067.5</TD>
            <TD>0.348114</TD>
          </TR>
          <TR>
            <TD>4070</TD>
            <TD>0.349946</TD>
          </TR>
          <TR>
            <TD>4072.5</TD>
            <TD>0.351724</TD>
          </TR>
          <TR>
            <TD>4075</TD>
            <TD>0.353503</TD>
          </TR>
          <TR>
            <TD>4077.5</TD>
            <TD>0.355284</TD>
          </TR>
          <TR>
            <TD>4080</TD>
            <TD>0.357068</TD>
          </TR>
          <TR>
            <TD>4082.5</TD>
            <TD>0.358813</TD>
          </TR>
          <TR>
            <TD>4085</TD>
            <TD>0.36056</TD>
          </TR>
          <TR>
            <TD>4087.5</TD>
            <TD>0.362308</TD>
          </TR>
          <TR>
            <TD>4090</TD>
            <TD>0.364059</TD>
          </TR>
          <TR>
            <TD>4092.5</TD>
            <TD>0.365736</TD>
          </TR>
          <TR>
            <TD>4095</TD>
            <TD>0.367415</TD>
          </TR>
          <TR>
            <TD>4097.5</TD>
            <TD>0.369096</TD>
          </TR>
          <TR>
            <TD>4100</TD>
            <TD>0.370779</TD>
          </TR>
          <TR>
            <TD>4102.5</TD>
            <TD>0.372505</TD>
          </TR>
          <TR>
            <TD>4105</TD>
            <TD>0.374232</TD>
          </TR>
          <TR>
            <TD>4107.5</TD>
            <TD>0.375962</TD>
          </TR>
          <TR>
            <TD>4110</TD>
            <TD>0.377693</TD>
          </TR>
          <TR>
            <TD>4112.5</TD>
            <TD>0.379366</TD>
          </TR>
          <TR>
            <TD>4115</TD>
            <TD>0.381041</TD>
          </TR>
          <TR>
            <TD>4117.5</TD>
            <TD>0.382717</TD>
          </TR>
          <TR>
            <TD>4120</TD>
            <TD>0.384395</TD>
          </TR>
          <TR>
            <TD>4122.5</TD>
            <TD>0.385923</TD>
          </TR>
          <TR>
            <TD>4125</TD>
            <TD>0.387453</TD>
          </TR>
          <TR>
            <TD>4127.5</TD>
            <TD>0.388984</TD>
          </TR>
          <TR>
            <TD>4130</TD>
            <TD>0.390517</TD>
          </TR>
          <TR>
            <TD>4132.5</TD>
            <TD>0.391967</TD>
          </TR>
          <TR>
            <TD>4135</TD>
            <TD>0.393418</TD>
          </TR>
          <TR>
            <TD>4137.5</TD>
            <TD>0.394871</TD>
          </TR>
          <TR>
            <TD>4140</TD>
            <TD>0.396325</TD>
          </TR>
          <TR>
            <TD>4142.5</TD>
            <TD>0.39781</TD>
          </TR>
          <TR>
            <TD>4145</TD>
            <TD>0.399296</TD>
          </TR>
          <TR>
            <TD>4147.5</TD>
            <TD>0.400784</TD>
          </TR>
          <TR>
            <TD>4150</TD>
            <TD>0.402273</TD>
          </TR>
          <TR>
            <TD>4152.5</TD>
            <TD>0.403713</TD>
          </TR>
          <TR>
            <TD>4155</TD>
            <TD>0.405154</TD>
          </TR>
          <TR>
            <TD>4157.5</TD>
            <TD>0.406596</TD>
          </TR>
          <TR>
            <TD>4160</TD>
            <TD>0.40804</TD>
          </TR>
          <TR>
            <TD>4162.5</TD>
            <TD>0.409436</TD>
          </TR>
          <TR>
            <TD>4165</TD>
            <TD>0.410832</TD>
          </TR>
          <TR>
            <TD>4167.5</TD>
            <TD>0.41223</TD>
          </TR>
          <TR>
            <TD>4170</TD>
            <TD>0.413629</TD>
          </TR>
          <TR>
            <TD>4172.5</TD>
            <TD>0.415017</TD>
          </TR>
          <TR>
            <TD>4175</TD>
            <TD>0.416407</TD>
          </TR>
          <TR>
            <TD>4177.5</TD>
            <TD>0.417798</TD>
          </TR>
          <TR>
            <TD>4180</TD>
            <TD>0.41919</TD>
          </TR>
          <TR>
            <TD>4182.5</TD>
            <TD>0.420491</TD>
          </TR>
          <TR>
            <TD>4185</TD>
            <TD>0.421794</TD>
          </TR>
          <TR>
            <TD>4187.5</TD>
            <TD>0.423098</TD>
          </TR>
          <TR>
            <TD>4190</TD>
            <TD>0.424404</TD>
          </TR>
          <TR>
            <TD>4192.5</TD>
            <TD>0.425684</TD>
          </TR>
          <TR>
            <TD>4195</TD>
            <TD>0.426965</TD>
          </TR>
          <TR>
            <TD>4197.5</TD>
            <TD>0.428248</TD>
          </TR>
          <TR>
            <TD>4200</TD>
            <TD>0.429531</TD>
          </TR>
          <TR>
            <TD>4202.5</TD>
            <TD>0.430811</TD>
          </TR>
          <TR>
            <TD>4205</TD>
            <TD>0.432092</TD>
          </TR>
          <TR>
            <TD>4207.5</TD>
            <TD>0.433374</TD>
          </TR>
          <TR>
            <TD>4210</TD>
            <TD>0.434657</TD>
          </TR>
          <TR>
            <TD>4212.5</TD>
            <TD>0.435867</TD>
          </TR>
          <TR>
            <TD>4215</TD>
            <TD>0.437077</TD>
          </TR>
          <TR>
            <TD>4217.5</TD>
            <TD>0.438289</TD>
          </TR>
          <TR>
            <TD>4220</TD>
            <TD>0.439502</TD>
          </TR>
          <TR>
            <TD>4222.5</TD>
            <TD>0.440794</TD>
          </TR>
          <TR>
            <TD>4225</TD>
            <TD>0.442088</TD>
          </TR>
          <TR>
            <TD>4227.5</TD>
            <TD>0.443382</TD>
          </TR>
          <TR>
            <TD>4230</TD>
            <TD>0.444678</TD>
          </TR>
          <TR>
            <TD>4232.5</TD>
            <TD>0.445843</TD>
          </TR>
          <TR>
            <TD>4235</TD>
            <TD>0.447009</TD>
          </TR>
          <TR>
            <TD>4237.5</TD>
            <TD>0.448176</TD>
          </TR>
          <TR>
            <TD>4240</TD>
            <TD>0.449344</TD>
          </TR>
          <TR>
            <TD>4242.5</TD>
            <TD>0.450413</TD>
          </TR>
          <TR>
            <TD>4245</TD>
            <TD>0.451482</TD>
          </TR>
          <TR>
            <TD>4247.5</TD>
            <TD>0.452553</TD>
          </TR>
          <TR>
            <TD>4250</TD>
            <TD>0.453625</TD>
          </TR>
          <TR>
            <TD>4252.5</TD>
            <TD>0.454784</TD>
          </TR>
          <TR>
            <TD>4255</TD>
            <TD>0.455945</TD>
          </TR>
          <TR>
            <TD>4257.5</TD>
            <TD>0.457106</TD>
          </TR>
          <TR>
            <TD>4260</TD>
            <TD>0.458268</TD>
          </TR>
          <TR>
            <TD>4262.5</TD>
            <TD>0.459469</TD>
          </TR>
          <TR>
            <TD>4265</TD>
            <TD>0.460672</TD>
          </TR>
          <TR>
            <TD>4267.5</TD>
            <TD>0.461875</TD>
          </TR>
          <TR>
            <TD>4270</TD>
            <TD>0.463079</TD>
          </TR>
          <TR>
            <TD>4272.5</TD>
            <TD>0.464197</TD>
          </TR>
          <TR>
            <TD>4275</TD>
            <TD>0.465316</TD>
          </TR>
          <TR>
            <TD>4277.5</TD>
            <TD>0.466437</TD>
          </TR>
          <TR>
            <TD>4280</TD>
            <TD>0.467558</TD>
          </TR>
          <TR>
            <TD>4282.5</TD>
            <TD>0.468606</TD>
          </TR>
          <TR>
            <TD>4285</TD>
            <TD>0.469655</TD>
          </TR>
          <TR>
            <TD>4287.5</TD>
            <TD>0.470706</TD>
          </TR>
          <TR>
            <TD>4290</TD>
            <TD>0.471757</TD>
          </TR>
          <TR>
            <TD>4292.5</TD>
            <TD>0.472828</TD>
          </TR>
          <TR>
            <TD>4295</TD>
            <TD>0.473901</TD>
          </TR>
          <TR>
            <TD>4297.5</TD>
            <TD>0.474975</TD>
          </TR>
          <TR>
            <TD>4300</TD>
            <TD>0.476049</TD>
          </TR>
          <TR>
            <TD>4302.5</TD>
            <TD>0.477065</TD>
          </TR>
          <TR>
            <TD>4305</TD>
            <TD>0.478082</TD>
          </TR>
          <TR>
            <TD>4307.5</TD>
            <TD>0.4791</TD>
          </TR>
          <TR>
            <TD>4310</TD>
            <TD>0.480118</TD>
          </TR>
          <TR>
            <TD>4312.5</TD>
            <TD>0.48112</TD>
          </TR>
          <TR>
            <TD>4315</TD>
            <TD>0.482122</TD>
          </TR>
          <TR>
            <TD>4317.5</TD>
            <TD>0.483125</TD>
          </TR>
          <TR>
            <TD>4320</TD>
            <TD>0.484128</TD>
          </TR>
          <TR>
            <TD>4322.5</TD>
            <TD>0.485191</TD>
          </TR>
          <TR>
            <TD>4325</TD>
            <TD>0.486256</TD>
          </TR>
          <TR>
            <TD>4327.5</TD>
            <TD>0.487321</TD>
          </TR>
          <TR>
            <TD>4330</TD>
            <TD>0.488387</TD>
          </TR>
          <TR>
            <TD>4332.5</TD>
            <TD>0.489437</TD>
          </TR>
          <TR>
            <TD>4335</TD>
            <TD>0.490489</TD>
          </TR>
          <TR>
            <TD>4337.5</TD>
            <TD>0.491541</TD>
          </TR>
          <TR>
            <TD>4340</TD>
            <TD>0.492595</TD>
          </TR>
          <TR>
            <TD>4342.5</TD>
            <TD>0.493656</TD>
          </TR>
          <TR>
            <TD>4345</TD>
            <TD>0.494718</TD>
          </TR>
          <TR>
            <TD>4347.5</TD>
            <TD>0.495781</TD>
          </TR>
          <TR>
            <TD>4350</TD>
            <TD>0.496845</TD>
          </TR>
          <TR>
            <TD>4352.5</TD>
            <TD>0.497849</TD>
          </TR>
          <TR>
            <TD>4355</TD>
            <TD>0.498853</TD>
          </TR>
          <TR>
            <TD>4357.5</TD>
            <TD>0.499858</TD>
          </TR>
          <TR>
            <TD>4360</TD>
            <TD>0.500865</TD>
          </TR>
          <TR>
            <TD>4362.5</TD>
            <TD>0.501709</TD>
          </TR>
          <TR>
            <TD>4365</TD>
            <TD>0.502554</TD>
          </TR>
          <TR>
            <TD>4367.5</TD>
            <TD>0.503399</TD>
          </TR>
          <TR>
            <TD>4370</TD>
            <TD>0.504245</TD>
          </TR>
          <TR>
            <TD>4372.5</TD>
            <TD>0.505162</TD>
          </TR>
          <TR>
            <TD>4375</TD>
            <TD>0.50608</TD>
          </TR>
          <TR>
            <TD>4377.5</TD>
            <TD>0.506999</TD>
          </TR>
          <TR>
            <TD>4380</TD>
            <TD>0.507918</TD>
          </TR>
          <TR>
            <TD>4382.5</TD>
            <TD>0.508845</TD>
          </TR>
          <TR>
            <TD>4385</TD>
            <TD>0.509773</TD>
          </TR>
          <TR>
            <TD>4387.5</TD>
            <TD>0.510702</TD>
          </TR>
          <TR>
            <TD>4390</TD>
            <TD>0.511631</TD>
          </TR>
          <TR>
            <TD>4392.5</TD>
            <TD>0.512593</TD>
          </TR>
          <TR>
            <TD>4395</TD>
            <TD>0.513556</TD>
          </TR>
          <TR>
            <TD>4397.5</TD>
            <TD>0.514519</TD>
          </TR>
          <TR>
            <TD>4400</TD>
            <TD>0.515484</TD>
          </TR>
          <TR>
            <TD>4402.5</TD>
            <TD>0.516431</TD>
          </TR>
          <TR>
            <TD>4405</TD>
            <TD>0.517379</TD>
          </TR>
          <TR>
            <TD>4407.5</TD>
            <TD>0.518328</TD>
          </TR>
          <TR>
            <TD>4410</TD>
            <TD>0.519277</TD>
          </TR>
          <TR>
            <TD>4412.5</TD>
            <TD>0.520243</TD>
          </TR>
          <TR>
            <TD>4415</TD>
            <TD>0.52121</TD>
          </TR>
          <TR>
            <TD>4417.5</TD>
            <TD>0.522178</TD>
          </TR>
          <TR>
            <TD>4420</TD>
            <TD>0.523146</TD>
          </TR>
          <TR>
            <TD>4422.5</TD>
            <TD>0.524135</TD>
          </TR>
          <TR>
            <TD>4425</TD>
            <TD>0.525124</TD>
          </TR>
          <TR>
            <TD>4427.5</TD>
            <TD>0.526113</TD>
          </TR>
          <TR>
            <TD>4430</TD>
            <TD>0.527104</TD>
          </TR>
          <TR>
            <TD>4432.5</TD>
            <TD>0.528034</TD>
          </TR>
          <TR>
            <TD>4435</TD>
            <TD>0.528965</TD>
          </TR>
          <TR>
            <TD>4437.5</TD>
            <TD>0.529896</TD>
          </TR>
          <TR>
            <TD>4440</TD>
            <TD>0.530828</TD>
          </TR>
          <TR>
            <TD>4442.5</TD>
            <TD>0.531792</TD>
          </TR>
          <TR>
            <TD>4445</TD>
            <TD>0.532756</TD>
          </TR>
          <TR>
            <TD>4447.5</TD>
            <TD>0.533721</TD>
          </TR>
          <TR>
            <TD>4450</TD>
            <TD>0.534687</TD>
          </TR>
          <TR>
            <TD>4452.5</TD>
            <TD>0.53557</TD>
          </TR>
          <TR>
            <TD>4455</TD>
            <TD>0.536455</TD>
          </TR>
          <TR>
            <TD>4457.5</TD>
            <TD>0.537339</TD>
          </TR>
          <TR>
            <TD>4460</TD>
            <TD>0.538225</TD>
          </TR>
          <TR>
            <TD>4462.5</TD>
            <TD>0.539049</TD>
          </TR>
          <TR>
            <TD>4465</TD>
            <TD>0.539873</TD>
          </TR>
          <TR>
            <TD>4467.5</TD>
            <TD>0.540698</TD>
          </TR>
          <TR>
            <TD>4470</TD>
            <TD>0.541523</TD>
          </TR>
          <TR>
            <TD>4472.5</TD>
            <TD>0.542481</TD>
          </TR>
          <TR>
            <TD>4475</TD>
            <TD>0.54344</TD>
          </TR>
          <TR>
            <TD>4477.5</TD>
            <TD>0.544399</TD>
          </TR>
          <TR>
            <TD>4480</TD>
            <TD>0.545359</TD>
          </TR>
          <TR>
            <TD>4482.5</TD>
            <TD>0.54635</TD>
          </TR>
          <TR>
            <TD>4485</TD>
            <TD>0.547341</TD>
          </TR>
          <TR>
            <TD>4487.5</TD>
            <TD>0.548334</TD>
          </TR>
          <TR>
            <TD>4490</TD>
            <TD>0.549327</TD>
          </TR>
          <TR>
            <TD>4492.5</TD>
            <TD>0.550155</TD>
          </TR>
          <TR>
            <TD>4495</TD>
            <TD>0.550984</TD>
          </TR>
          <TR>
            <TD>4497.5</TD>
            <TD>0.551813</TD>
          </TR>
          <TR>
            <TD>4500</TD>
            <TD>0.552642</TD>
          </TR>
          <TR>
            <TD>4502.5</TD>
            <TD>0.553451</TD>
          </TR>
          <TR>
            <TD>4505</TD>
            <TD>0.554259</TD>
          </TR>
          <TR>
            <TD>4507.5</TD>
            <TD>0.555068</TD>
          </TR>
          <TR>
            <TD>4510</TD>
            <TD>0.555878</TD>
          </TR>
          <TR>
            <TD>4512.5</TD>
            <TD>0.556876</TD>
          </TR>
          <TR>
            <TD>4515</TD>
            <TD>0.557874</TD>
          </TR>
          <TR>
            <TD>4517.5</TD>
            <TD>0.558872</TD>
          </TR>
          <TR>
            <TD>4520</TD>
            <TD>0.559872</TD>
          </TR>
          <TR>
            <TD>4522.5</TD>
            <TD>0.56078</TD>
          </TR>
          <TR>
            <TD>4525</TD>
            <TD>0.561689</TD>
          </TR>
          <TR>
            <TD>4527.5</TD>
            <TD>0.562599</TD>
          </TR>
          <TR>
            <TD>4530</TD>
            <TD>0.563509</TD>
          </TR>
          <TR>
            <TD>4532.5</TD>
            <TD>0.564341</TD>
          </TR>
          <TR>
            <TD>4535</TD>
            <TD>0.565173</TD>
          </TR>
          <TR>
            <TD>4537.5</TD>
            <TD>0.566005</TD>
          </TR>
          <TR>
            <TD>4540</TD>
            <TD>0.566838</TD>
          </TR>
          <TR>
            <TD>4542.5</TD>
            <TD>0.567751</TD>
          </TR>
          <TR>
            <TD>4545</TD>
            <TD>0.568664</TD>
          </TR>
          <TR>
            <TD>4547.5</TD>
            <TD>0.569577</TD>
          </TR>
          <TR>
            <TD>4550</TD>
            <TD>0.570492</TD>
          </TR>
          <TR>
            <TD>4552.5</TD>
            <TD>0.571401</TD>
          </TR>
          <TR>
            <TD>4555</TD>
            <TD>0.572311</TD>
          </TR>
          <TR>
            <TD>4557.5</TD>
            <TD>0.573221</TD>
          </TR>
          <TR>
            <TD>4560</TD>
            <TD>0.574133</TD>
          </TR>
          <TR>
            <TD>4562.5</TD>
            <TD>0.574941</TD>
          </TR>
          <TR>
            <TD>4565</TD>
            <TD>0.57575</TD>
          </TR>
          <TR>
            <TD>4567.5</TD>
            <TD>0.576559</TD>
          </TR>
          <TR>
            <TD>4570</TD>
            <TD>0.577369</TD>
          </TR>
          <TR>
            <TD>4572.5</TD>
            <TD>0.578229</TD>
          </TR>
          <TR>
            <TD>4575</TD>
            <TD>0.579091</TD>
          </TR>
          <TR>
            <TD>4577.5</TD>
            <TD>0.579952</TD>
          </TR>
          <TR>
            <TD>4580</TD>
            <TD>0.580815</TD>
          </TR>
          <TR>
            <TD>4582.5</TD>
            <TD>0.581751</TD>
          </TR>
          <TR>
            <TD>4585</TD>
            <TD>0.582687</TD>
          </TR>
          <TR>
            <TD>4587.5</TD>
            <TD>0.583624</TD>
          </TR>
          <TR>
            <TD>4590</TD>
            <TD>0.584562</TD>
          </TR>
          <TR>
            <TD>4592.5</TD>
            <TD>0.585426</TD>
          </TR>
          <TR>
            <TD>4595</TD>
            <TD>0.586291</TD>
          </TR>
          <TR>
            <TD>4597.5</TD>
            <TD>0.587156</TD>
          </TR>
          <TR>
            <TD>4600</TD>
            <TD>0.588022</TD>
          </TR>
          <TR>
            <TD>4602.5</TD>
            <TD>0.588895</TD>
          </TR>
          <TR>
            <TD>4605</TD>
            <TD>0.589768</TD>
          </TR>
          <TR>
            <TD>4607.5</TD>
            <TD>0.590642</TD>
          </TR>
          <TR>
            <TD>4610</TD>
            <TD>0.591517</TD>
          </TR>
          <TR>
            <TD>4612.5</TD>
            <TD>0.592361</TD>
          </TR>
          <TR>
            <TD>4615</TD>
            <TD>0.593206</TD>
          </TR>
          <TR>
            <TD>4617.5</TD>
            <TD>0.594052</TD>
          </TR>
          <TR>
            <TD>4620</TD>
            <TD>0.594898</TD>
          </TR>
          <TR>
            <TD>4622.5</TD>
            <TD>0.595689</TD>
          </TR>
          <TR>
            <TD>4625</TD>
            <TD>0.596481</TD>
          </TR>
          <TR>
            <TD>4627.5</TD>
            <TD>0.597274</TD>
          </TR>
          <TR>
            <TD>4630</TD>
            <TD>0.598067</TD>
          </TR>
          <TR>
            <TD>4632.5</TD>
            <TD>0.598925</TD>
          </TR>
          <TR>
            <TD>4635</TD>
            <TD>0.599784</TD>
          </TR>
          <TR>
            <TD>4637.5</TD>
            <TD>0.600644</TD>
          </TR>
          <TR>
            <TD>4640</TD>
            <TD>0.601505</TD>
          </TR>
          <TR>
            <TD>4642.5</TD>
            <TD>0.602467</TD>
          </TR>
          <TR>
            <TD>4645</TD>
            <TD>0.60343</TD>
          </TR>
          <TR>
            <TD>4647.5</TD>
            <TD>0.604394</TD>
          </TR>
          <TR>
            <TD>4650</TD>
            <TD>0.605358</TD>
          </TR>
          <TR>
            <TD>4652.5</TD>
            <TD>0.606262</TD>
          </TR>
          <TR>
            <TD>4655</TD>
            <TD>0.607167</TD>
          </TR>
          <TR>
            <TD>4657.5</TD>
            <TD>0.608072</TD>
          </TR>
          <TR>
            <TD>4660</TD>
            <TD>0.608978</TD>
          </TR>
          <TR>
            <TD>4662.5</TD>
            <TD>0.609734</TD>
          </TR>
          <TR>
            <TD>4665</TD>
            <TD>0.61049</TD>
          </TR>
          <TR>
            <TD>4667.5</TD>
            <TD>0.611247</TD>
          </TR>
          <TR>
            <TD>4670</TD>
            <TD>0.612004</TD>
          </TR>
          <TR>
            <TD>4672.5</TD>
            <TD>0.612774</TD>
          </TR>
          <TR>
            <TD>4675</TD>
            <TD>0.613544</TD>
          </TR>
          <TR>
            <TD>4677.5</TD>
            <TD>0.614315</TD>
          </TR>
          <TR>
            <TD>4680</TD>
            <TD>0.615086</TD>
          </TR>
          <TR>
            <TD>4682.5</TD>
            <TD>0.616033</TD>
          </TR>
          <TR>
            <TD>4685</TD>
            <TD>0.616981</TD>
          </TR>
          <TR>
            <TD>4687.5</TD>
            <TD>0.61793</TD>
          </TR>
          <TR>
            <TD>4690</TD>
            <TD>0.618879</TD>
          </TR>
          <TR>
            <TD>4692.5</TD>
            <TD>0.619702</TD>
          </TR>
          <TR>
            <TD>4695</TD>
            <TD>0.620525</TD>
          </TR>
          <TR>
            <TD>4697.5</TD>
            <TD>0.621348</TD>
          </TR>
          <TR>
            <TD>4700</TD>
            <TD>0.622173</TD>
          </TR>
          <TR>
            <TD>4702.5</TD>
            <TD>0.622933</TD>
          </TR>
          <TR>
            <TD>4705</TD>
            <TD>0.623694</TD>
          </TR>
          <TR>
            <TD>4707.5</TD>
            <TD>0.624456</TD>
          </TR>
          <TR>
            <TD>4710</TD>
            <TD>0.625217</TD>
          </TR>
          <TR>
            <TD>4712.5</TD>
            <TD>0.626179</TD>
          </TR>
          <TR>
            <TD>4715</TD>
            <TD>0.627141</TD>
          </TR>
          <TR>
            <TD>4717.5</TD>
            <TD>0.628104</TD>
          </TR>
          <TR>
            <TD>4720</TD>
            <TD>0.629067</TD>
          </TR>
          <TR>
            <TD>4722.5</TD>
            <TD>0.629946</TD>
          </TR>
          <TR>
            <TD>4725</TD>
            <TD>0.630826</TD>
          </TR>
          <TR>
            <TD>4727.5</TD>
            <TD>0.631706</TD>
          </TR>
          <TR>
            <TD>4730</TD>
            <TD>0.632587</TD>
          </TR>
          <TR>
            <TD>4732.5</TD>
            <TD>0.633351</TD>
          </TR>
          <TR>
            <TD>4735</TD>
            <TD>0.634116</TD>
          </TR>
          <TR>
            <TD>4737.5</TD>
            <TD>0.634881</TD>
          </TR>
          <TR>
            <TD>4740</TD>
            <TD>0.635646</TD>
          </TR>
          <TR>
            <TD>4742.5</TD>
            <TD>0.636454</TD>
          </TR>
          <TR>
            <TD>4745</TD>
            <TD>0.637262</TD>
          </TR>
          <TR>
            <TD>4747.5</TD>
            <TD>0.638071</TD>
          </TR>
          <TR>
            <TD>4750</TD>
            <TD>0.63888</TD>
          </TR>
          <TR>
            <TD>4752.5</TD>
            <TD>0.639774</TD>
          </TR>
          <TR>
            <TD>4755</TD>
            <TD>0.64067</TD>
          </TR>
          <TR>
            <TD>4757.5</TD>
            <TD>0.641566</TD>
          </TR>
          <TR>
            <TD>4760</TD>
            <TD>0.642462</TD>
          </TR>
          <TR>
            <TD>4762.5</TD>
            <TD>0.643394</TD>
          </TR>
          <TR>
            <TD>4765</TD>
            <TD>0.644327</TD>
          </TR>
          <TR>
            <TD>4767.5</TD>
            <TD>0.64526</TD>
          </TR>
          <TR>
            <TD>4770</TD>
            <TD>0.646195</TD>
          </TR>
          <TR>
            <TD>4772.5</TD>
            <TD>0.647028</TD>
          </TR>
          <TR>
            <TD>4775</TD>
            <TD>0.647863</TD>
          </TR>
          <TR>
            <TD>4777.5</TD>
            <TD>0.648698</TD>
          </TR>
          <TR>
            <TD>4780</TD>
            <TD>0.649533</TD>
          </TR>
          <TR>
            <TD>4782.5</TD>
            <TD>0.650259</TD>
          </TR>
          <TR>
            <TD>4785</TD>
            <TD>0.650986</TD>
          </TR>
          <TR>
            <TD>4787.5</TD>
            <TD>0.651713</TD>
          </TR>
          <TR>
            <TD>4790</TD>
            <TD>0.65244</TD>
          </TR>
          <TR>
            <TD>4792.5</TD>
            <TD>0.653168</TD>
          </TR>
          <TR>
            <TD>4795</TD>
            <TD>0.653897</TD>
          </TR>
          <TR>
            <TD>4797.5</TD>
            <TD>0.654626</TD>
          </TR>
          <TR>
            <TD>4800</TD>
            <TD>0.655355</TD>
          </TR>
          <TR>
            <TD>4802.5</TD>
            <TD>0.656339</TD>
          </TR>
          <TR>
            <TD>4805</TD>
            <TD>0.657322</TD>
          </TR>
          <TR>
            <TD>4807.5</TD>
            <TD>0.658307</TD>
          </TR>
          <TR>
            <TD>4810</TD>
            <TD>0.659292</TD>
          </TR>
          <TR>
            <TD>4812.5</TD>
            <TD>0.660011</TD>
          </TR>
          <TR>
            <TD>4815</TD>
            <TD>0.660729</TD>
          </TR>
          <TR>
            <TD>4817.5</TD>
            <TD>0.661448</TD>
          </TR>
          <TR>
            <TD>4820</TD>
            <TD>0.662168</TD>
          </TR>
          <TR>
            <TD>4822.5</TD>
            <TD>0.662789</TD>
          </TR>
          <TR>
            <TD>4825</TD>
            <TD>0.663411</TD>
          </TR>
          <TR>
            <TD>4827.5</TD>
            <TD>0.664034</TD>
          </TR>
          <TR>
            <TD>4830</TD>
            <TD>0.664657</TD>
          </TR>
          <TR>
            <TD>4832.5</TD>
            <TD>0.665403</TD>
          </TR>
          <TR>
            <TD>4835</TD>
            <TD>0.66615</TD>
          </TR>
          <TR>
            <TD>4837.5</TD>
            <TD>0.666897</TD>
          </TR>
          <TR>
            <TD>4840</TD>
            <TD>0.667645</TD>
          </TR>
          <TR>
            <TD>4842.5</TD>
            <TD>0.668492</TD>
          </TR>
          <TR>
            <TD>4845</TD>
            <TD>0.66934</TD>
          </TR>
          <TR>
            <TD>4847.5</TD>
            <TD>0.670188</TD>
          </TR>
          <TR>
            <TD>4850</TD>
            <TD>0.671036</TD>
          </TR>
          <TR>
            <TD>4852.5</TD>
            <TD>0.671879</TD>
          </TR>
          <TR>
            <TD>4855</TD>
            <TD>0.672722</TD>
          </TR>
          <TR>
            <TD>4857.5</TD>
            <TD>0.673566</TD>
          </TR>
          <TR>
            <TD>4860</TD>
            <TD>0.674411</TD>
          </TR>
          <TR>
            <TD>4862.5</TD>
            <TD>0.675248</TD>
          </TR>
          <TR>
            <TD>4865</TD>
            <TD>0.676086</TD>
          </TR>
          <TR>
            <TD>4867.5</TD>
            <TD>0.676924</TD>
          </TR>
          <TR>
            <TD>4870</TD>
            <TD>0.677763</TD>
          </TR>
          <TR>
            <TD>4872.5</TD>
            <TD>0.678511</TD>
          </TR>
          <TR>
            <TD>4875</TD>
            <TD>0.67926</TD>
          </TR>
          <TR>
            <TD>4877.5</TD>
            <TD>0.680009</TD>
          </TR>
          <TR>
            <TD>4880</TD>
            <TD>0.680759</TD>
          </TR>
          <TR>
            <TD>4882.5</TD>
            <TD>0.681503</TD>
          </TR>
          <TR>
            <TD>4885</TD>
            <TD>0.682247</TD>
          </TR>
          <TR>
            <TD>4887.5</TD>
            <TD>0.682992</TD>
          </TR>
          <TR>
            <TD>4890</TD>
            <TD>0.683737</TD>
          </TR>
          <TR>
            <TD>4892.5</TD>
            <TD>0.684504</TD>
          </TR>
          <TR>
            <TD>4895</TD>
            <TD>0.685271</TD>
          </TR>
          <TR>
            <TD>4897.5</TD>
            <TD>0.686039</TD>
          </TR>
          <TR>
            <TD>4900</TD>
            <TD>0.686807</TD>
          </TR>
          <TR>
            <TD>4902.5</TD>
            <TD>0.687533</TD>
          </TR>
          <TR>
            <TD>4905</TD>
            <TD>0.688258</TD>
          </TR>
          <TR>
            <TD>4907.5</TD>
            <TD>0.688985</TD>
          </TR>
          <TR>
            <TD>4910</TD>
            <TD>0.689712</TD>
          </TR>
          <TR>
            <TD>4912.5</TD>
            <TD>0.690354</TD>
          </TR>
          <TR>
            <TD>4915</TD>
            <TD>0.690996</TD>
          </TR>
          <TR>
            <TD>4917.5</TD>
            <TD>0.691638</TD>
          </TR>
          <TR>
            <TD>4920</TD>
            <TD>0.692281</TD>
          </TR>
          <TR>
            <TD>4922.5</TD>
            <TD>0.693021</TD>
          </TR>
          <TR>
            <TD>4925</TD>
            <TD>0.693761</TD>
          </TR>
          <TR>
            <TD>4927.5</TD>
            <TD>0.694501</TD>
          </TR>
          <TR>
            <TD>4930</TD>
            <TD>0.695242</TD>
          </TR>
          <TR>
            <TD>4932.5</TD>
            <TD>0.696085</TD>
          </TR>
          <TR>
            <TD>4935</TD>
            <TD>0.696928</TD>
          </TR>
          <TR>
            <TD>4937.5</TD>
            <TD>0.697773</TD>
          </TR>
          <TR>
            <TD>4940</TD>
            <TD>0.698617</TD>
          </TR>
          <TR>
            <TD>4942.5</TD>
            <TD>0.699548</TD>
          </TR>
          <TR>
            <TD>4945</TD>
            <TD>0.700479</TD>
          </TR>
          <TR>
            <TD>4947.5</TD>
            <TD>0.701411</TD>
          </TR>
          <TR>
            <TD>4950</TD>
            <TD>0.702343</TD>
          </TR>
          <TR>
            <TD>4952.5</TD>
            <TD>0.703101</TD>
          </TR>
          <TR>
            <TD>4955</TD>
            <TD>0.70386</TD>
          </TR>
          <TR>
            <TD>4957.5</TD>
            <TD>0.704619</TD>
          </TR>
          <TR>
            <TD>4960</TD>
            <TD>0.705379</TD>
          </TR>
          <TR>
            <TD>4962.5</TD>
            <TD>0.706097</TD>
          </TR>
          <TR>
            <TD>4965</TD>
            <TD>0.706816</TD>
          </TR>
          <TR>
            <TD>4967.5</TD>
            <TD>0.707535</TD>
          </TR>
          <TR>
            <TD>4970</TD>
            <TD>0.708254</TD>
          </TR>
          <TR>
            <TD>4972.5</TD>
            <TD>0.708959</TD>
          </TR>
          <TR>
            <TD>4975</TD>
            <TD>0.709665</TD>
          </TR>
          <TR>
            <TD>4977.5</TD>
            <TD>0.710371</TD>
          </TR>
          <TR>
            <TD>4980</TD>
            <TD>0.711077</TD>
          </TR>
          <TR>
            <TD>4982.5</TD>
            <TD>0.711629</TD>
          </TR>
          <TR>
            <TD>4985</TD>
            <TD>0.712181</TD>
          </TR>
          <TR>
            <TD>4987.5</TD>
            <TD>0.712734</TD>
          </TR>
          <TR>
            <TD>4990</TD>
            <TD>0.713286</TD>
          </TR>
          <TR>
            <TD>4992.5</TD>
            <TD>0.713922</TD>
          </TR>
          <TR>
            <TD>4995</TD>
            <TD>0.714557</TD>
          </TR>
          <TR>
            <TD>4997.5</TD>
            <TD>0.715193</TD>
          </TR>
          <TR>
            <TD>5000</TD>
            <TD>0.715829</TD>
          </TR>
          <TR>
            <TD>5002.5</TD>
            <TD>0.716583</TD>
          </TR>
          <TR>
            <TD>5005</TD>
            <TD>0.717338</TD>
          </TR>
          <TR>
            <TD>5007.5</TD>
            <TD>0.718093</TD>
          </TR>
          <TR>
            <TD>5010</TD>
            <TD>0.718849</TD>
          </TR>
          <TR>
            <TD>5012.5</TD>
            <TD>0.719775</TD>
          </TR>
          <TR>
            <TD>5015</TD>
            <TD>0.720702</TD>
          </TR>
          <TR>
            <TD>5017.5</TD>
            <TD>0.721629</TD>
          </TR>
          <TR>
            <TD>5020</TD>
            <TD>0.722557</TD>
          </TR>
          <TR>
            <TD>5022.5</TD>
            <TD>0.723191</TD>
          </TR>
          <TR>
            <TD>5025</TD>
            <TD>0.723826</TD>
          </TR>
          <TR>
            <TD>5027.5</TD>
            <TD>0.724462</TD>
          </TR>
          <TR>
            <TD>5030</TD>
            <TD>0.725097</TD>
          </TR>
          <TR>
            <TD>5032.5</TD>
            <TD>0.72572</TD>
          </TR>
          <TR>
            <TD>5035</TD>
            <TD>0.726344</TD>
          </TR>
          <TR>
            <TD>5037.5</TD>
            <TD>0.726968</TD>
          </TR>
          <TR>
            <TD>5040</TD>
            <TD>0.727592</TD>
          </TR>
          <TR>
            <TD>5042.5</TD>
            <TD>0.72833</TD>
          </TR>
          <TR>
            <TD>5045</TD>
            <TD>0.729068</TD>
          </TR>
          <TR>
            <TD>5047.5</TD>
            <TD>0.729806</TD>
          </TR>
          <TR>
            <TD>5050</TD>
            <TD>0.730545</TD>
          </TR>
          <TR>
            <TD>5052.5</TD>
            <TD>0.731232</TD>
          </TR>
          <TR>
            <TD>5055</TD>
            <TD>0.731919</TD>
          </TR>
          <TR>
            <TD>5057.5</TD>
            <TD>0.732606</TD>
          </TR>
          <TR>
            <TD>5060</TD>
            <TD>0.733293</TD>
          </TR>
          <TR>
            <TD>5062.5</TD>
            <TD>0.734092</TD>
          </TR>
          <TR>
            <TD>5065</TD>
            <TD>0.734891</TD>
          </TR>
          <TR>
            <TD>5067.5</TD>
            <TD>0.73569</TD>
          </TR>
          <TR>
            <TD>5070</TD>
            <TD>0.73649</TD>
          </TR>
          <TR>
            <TD>5072.5</TD>
            <TD>0.737092</TD>
          </TR>
          <TR>
            <TD>5075</TD>
            <TD>0.737695</TD>
          </TR>
          <TR>
            <TD>5077.5</TD>
            <TD>0.738297</TD>
          </TR>
          <TR>
            <TD>5080</TD>
            <TD>0.7389</TD>
          </TR>
          <TR>
            <TD>5082.5</TD>
            <TD>0.739384</TD>
          </TR>
          <TR>
            <TD>5085</TD>
            <TD>0.739867</TD>
          </TR>
          <TR>
            <TD>5087.5</TD>
            <TD>0.740351</TD>
          </TR>
          <TR>
            <TD>5090</TD>
            <TD>0.740834</TD>
          </TR>
          <TR>
            <TD>5092.5</TD>
            <TD>0.741596</TD>
          </TR>
          <TR>
            <TD>5095</TD>
            <TD>0.742358</TD>
          </TR>
          <TR>
            <TD>5097.5</TD>
            <TD>0.74312</TD>
          </TR>
          <TR>
            <TD>5100</TD>
            <TD>0.743883</TD>
          </TR>
          <TR>
            <TD>5102.5</TD>
            <TD>0.744651</TD>
          </TR>
          <TR>
            <TD>5105</TD>
            <TD>0.74542</TD>
          </TR>
          <TR>
            <TD>5107.5</TD>
            <TD>0.746189</TD>
          </TR>
          <TR>
            <TD>5110</TD>
            <TD>0.746959</TD>
          </TR>
          <TR>
            <TD>5112.5</TD>
            <TD>0.747531</TD>
          </TR>
          <TR>
            <TD>5115</TD>
            <TD>0.748104</TD>
          </TR>
          <TR>
            <TD>5117.5</TD>
            <TD>0.748677</TD>
          </TR>
          <TR>
            <TD>5120</TD>
            <TD>0.74925</TD>
          </TR>
          <TR>
            <TD>5122.5</TD>
            <TD>0.749673</TD>
          </TR>
          <TR>
            <TD>5125</TD>
            <TD>0.750096</TD>
          </TR>
          <TR>
            <TD>5127.5</TD>
            <TD>0.750518</TD>
          </TR>
          <TR>
            <TD>5130</TD>
            <TD>0.750941</TD>
          </TR>
          <TR>
            <TD>5132.5</TD>
            <TD>0.75177</TD>
          </TR>
          <TR>
            <TD>5135</TD>
            <TD>0.752599</TD>
          </TR>
          <TR>
            <TD>5137.5</TD>
            <TD>0.753429</TD>
          </TR>
          <TR>
            <TD>5140</TD>
            <TD>0.754259</TD>
          </TR>
          <TR>
            <TD>5142.5</TD>
            <TD>0.754894</TD>
          </TR>
          <TR>
            <TD>5145</TD>
            <TD>0.75553</TD>
          </TR>
          <TR>
            <TD>5147.5</TD>
            <TD>0.756166</TD>
          </TR>
          <TR>
            <TD>5150</TD>
            <TD>0.756802</TD>
          </TR>
          <TR>
            <TD>5152.5</TD>
            <TD>0.757315</TD>
          </TR>
          <TR>
            <TD>5155</TD>
            <TD>0.757828</TD>
          </TR>
          <TR>
            <TD>5157.5</TD>
            <TD>0.758341</TD>
          </TR>
          <TR>
            <TD>5160</TD>
            <TD>0.758854</TD>
          </TR>
          <TR>
            <TD>5162.5</TD>
            <TD>0.759439</TD>
          </TR>
          <TR>
            <TD>5165</TD>
            <TD>0.760023</TD>
          </TR>
          <TR>
            <TD>5167.5</TD>
            <TD>0.760607</TD>
          </TR>
          <TR>
            <TD>5170</TD>
            <TD>0.761192</TD>
          </TR>
          <TR>
            <TD>5172.5</TD>
            <TD>0.761734</TD>
          </TR>
          <TR>
            <TD>5175</TD>
            <TD>0.762276</TD>
          </TR>
          <TR>
            <TD>5177.5</TD>
            <TD>0.762819</TD>
          </TR>
          <TR>
            <TD>5180</TD>
            <TD>0.763362</TD>
          </TR>
          <TR>
            <TD>5182.5</TD>
            <TD>0.764057</TD>
          </TR>
          <TR>
            <TD>5185</TD>
            <TD>0.764754</TD>
          </TR>
          <TR>
            <TD>5187.5</TD>
            <TD>0.76545</TD>
          </TR>
          <TR>
            <TD>5190</TD>
            <TD>0.766147</TD>
          </TR>
          <TR>
            <TD>5192.5</TD>
            <TD>0.766965</TD>
          </TR>
          <TR>
            <TD>5195</TD>
            <TD>0.767784</TD>
          </TR>
          <TR>
            <TD>5197.5</TD>
            <TD>0.768604</TD>
          </TR>
          <TR>
            <TD>5200</TD>
            <TD>0.769423</TD>
          </TR>
          <TR>
            <TD>5202.5</TD>
            <TD>0.770091</TD>
          </TR>
          <TR>
            <TD>5205</TD>
            <TD>0.770758</TD>
          </TR>
          <TR>
            <TD>5207.5</TD>
            <TD>0.771426</TD>
          </TR>
          <TR>
            <TD>5210</TD>
            <TD>0.772093</TD>
          </TR>
          <TR>
            <TD>5212.5</TD>
            <TD>0.77262</TD>
          </TR>
          <TR>
            <TD>5215</TD>
            <TD>0.773147</TD>
          </TR>
          <TR>
            <TD>5217.5</TD>
            <TD>0.773674</TD>
          </TR>
          <TR>
            <TD>5220</TD>
            <TD>0.774201</TD>
          </TR>
          <TR>
            <TD>5222.5</TD>
            <TD>0.77468</TD>
          </TR>
          <TR>
            <TD>5225</TD>
            <TD>0.775159</TD>
          </TR>
          <TR>
            <TD>5227.5</TD>
            <TD>0.775638</TD>
          </TR>
          <TR>
            <TD>5230</TD>
            <TD>0.776117</TD>
          </TR>
          <TR>
            <TD>5232.5</TD>
            <TD>0.776702</TD>
          </TR>
          <TR>
            <TD>5235</TD>
            <TD>0.777287</TD>
          </TR>
          <TR>
            <TD>5237.5</TD>
            <TD>0.777872</TD>
          </TR>
          <TR>
            <TD>5240</TD>
            <TD>0.778457</TD>
          </TR>
          <TR>
            <TD>5242.5</TD>
            <TD>0.779118</TD>
          </TR>
          <TR>
            <TD>5245</TD>
            <TD>0.779779</TD>
          </TR>
          <TR>
            <TD>5247.5</TD>
            <TD>0.78044</TD>
          </TR>
          <TR>
            <TD>5250</TD>
            <TD>0.781101</TD>
          </TR>
          <TR>
            <TD>5252.5</TD>
            <TD>0.781666</TD>
          </TR>
          <TR>
            <TD>5255</TD>
            <TD>0.78223</TD>
          </TR>
          <TR>
            <TD>5257.5</TD>
            <TD>0.782795</TD>
          </TR>
          <TR>
            <TD>5260</TD>
            <TD>0.78336</TD>
          </TR>
          <TR>
            <TD>5262.5</TD>
            <TD>0.783927</TD>
          </TR>
          <TR>
            <TD>5265</TD>
            <TD>0.784494</TD>
          </TR>
          <TR>
            <TD>5267.5</TD>
            <TD>0.785061</TD>
          </TR>
          <TR>
            <TD>5270</TD>
            <TD>0.785629</TD>
          </TR>
          <TR>
            <TD>5272.5</TD>
            <TD>0.786162</TD>
          </TR>
          <TR>
            <TD>5275</TD>
            <TD>0.786696</TD>
          </TR>
          <TR>
            <TD>5277.5</TD>
            <TD>0.78723</TD>
          </TR>
          <TR>
            <TD>5280</TD>
            <TD>0.787764</TD>
          </TR>
          <TR>
            <TD>5282.5</TD>
            <TD>0.788252</TD>
          </TR>
          <TR>
            <TD>5285</TD>
            <TD>0.78874</TD>
          </TR>
          <TR>
            <TD>5287.5</TD>
            <TD>0.789228</TD>
          </TR>
          <TR>
            <TD>5290</TD>
            <TD>0.789716</TD>
          </TR>
          <TR>
            <TD>5292.5</TD>
            <TD>0.790216</TD>
          </TR>
          <TR>
            <TD>5295</TD>
            <TD>0.790717</TD>
          </TR>
          <TR>
            <TD>5297.5</TD>
            <TD>0.791218</TD>
          </TR>
          <TR>
            <TD>5300</TD>
            <TD>0.791718</TD>
          </TR>
          <TR>
            <TD>5302.5</TD>
            <TD>0.792423</TD>
          </TR>
          <TR>
            <TD>5305</TD>
            <TD>0.793128</TD>
          </TR>
          <TR>
            <TD>5307.5</TD>
            <TD>0.793833</TD>
          </TR>
          <TR>
            <TD>5310</TD>
            <TD>0.794538</TD>
          </TR>
          <TR>
            <TD>5312.5</TD>
            <TD>0.795194</TD>
          </TR>
          <TR>
            <TD>5315</TD>
            <TD>0.795849</TD>
          </TR>
          <TR>
            <TD>5317.5</TD>
            <TD>0.796505</TD>
          </TR>
          <TR>
            <TD>5320</TD>
            <TD>0.797161</TD>
          </TR>
          <TR>
            <TD>5322.5</TD>
            <TD>0.797815</TD>
          </TR>
          <TR>
            <TD>5325</TD>
            <TD>0.798469</TD>
          </TR>
          <TR>
            <TD>5327.5</TD>
            <TD>0.799123</TD>
          </TR>
          <TR>
            <TD>5330</TD>
            <TD>0.799777</TD>
          </TR>
          <TR>
            <TD>5332.5</TD>
            <TD>0.800447</TD>
          </TR>
          <TR>
            <TD>5335</TD>
            <TD>0.801117</TD>
          </TR>
          <TR>
            <TD>5337.5</TD>
            <TD>0.801787</TD>
          </TR>
          <TR>
            <TD>5340</TD>
            <TD>0.802457</TD>
          </TR>
          <TR>
            <TD>5342.5</TD>
            <TD>0.802872</TD>
          </TR>
          <TR>
            <TD>5345</TD>
            <TD>0.803287</TD>
          </TR>
          <TR>
            <TD>5347.5</TD>
            <TD>0.803702</TD>
          </TR>
          <TR>
            <TD>5350</TD>
            <TD>0.804116</TD>
          </TR>
          <TR>
            <TD>5352.5</TD>
            <TD>0.804627</TD>
          </TR>
          <TR>
            <TD>5355</TD>
            <TD>0.805137</TD>
          </TR>
          <TR>
            <TD>5357.5</TD>
            <TD>0.805648</TD>
          </TR>
          <TR>
            <TD>5360</TD>
            <TD>0.806158</TD>
          </TR>
          <TR>
            <TD>5362.5</TD>
            <TD>0.806641</TD>
          </TR>
          <TR>
            <TD>5365</TD>
            <TD>0.807123</TD>
          </TR>
          <TR>
            <TD>5367.5</TD>
            <TD>0.807606</TD>
          </TR>
          <TR>
            <TD>5370</TD>
            <TD>0.808089</TD>
          </TR>
          <TR>
            <TD>5372.5</TD>
            <TD>0.808599</TD>
          </TR>
          <TR>
            <TD>5375</TD>
            <TD>0.80911</TD>
          </TR>
          <TR>
            <TD>5377.5</TD>
            <TD>0.809621</TD>
          </TR>
          <TR>
            <TD>5380</TD>
            <TD>0.810132</TD>
          </TR>
          <TR>
            <TD>5382.5</TD>
            <TD>0.810752</TD>
          </TR>
          <TR>
            <TD>5385</TD>
            <TD>0.811372</TD>
          </TR>
          <TR>
            <TD>5387.5</TD>
            <TD>0.811992</TD>
          </TR>
          <TR>
            <TD>5390</TD>
            <TD>0.812613</TD>
          </TR>
          <TR>
            <TD>5392.5</TD>
            <TD>0.813225</TD>
          </TR>
          <TR>
            <TD>5395</TD>
            <TD>0.813838</TD>
          </TR>
          <TR>
            <TD>5397.5</TD>
            <TD>0.814451</TD>
          </TR>
          <TR>
            <TD>5400</TD>
            <TD>0.815063</TD>
          </TR>
          <TR>
            <TD>5402.5</TD>
            <TD>0.81559</TD>
          </TR>
          <TR>
            <TD>5405</TD>
            <TD>0.816118</TD>
          </TR>
          <TR>
            <TD>5407.5</TD>
            <TD>0.816645</TD>
          </TR>
          <TR>
            <TD>5410</TD>
            <TD>0.817172</TD>
          </TR>
          <TR>
            <TD>5412.5</TD>
            <TD>0.817651</TD>
          </TR>
          <TR>
            <TD>5415</TD>
            <TD>0.818131</TD>
          </TR>
          <TR>
            <TD>5417.5</TD>
            <TD>0.81861</TD>
          </TR>
          <TR>
            <TD>5420</TD>
            <TD>0.819089</TD>
          </TR>
          <TR>
            <TD>5422.5</TD>
            <TD>0.81943</TD>
          </TR>
          <TR>
            <TD>5425</TD>
            <TD>0.819771</TD>
          </TR>
          <TR>
            <TD>5427.5</TD>
            <TD>0.820112</TD>
          </TR>
          <TR>
            <TD>5430</TD>
            <TD>0.820453</TD>
          </TR>
          <TR>
            <TD>5432.5</TD>
            <TD>0.820834</TD>
          </TR>
          <TR>
            <TD>5435</TD>
            <TD>0.821215</TD>
          </TR>
          <TR>
            <TD>5437.5</TD>
            <TD>0.821596</TD>
          </TR>
          <TR>
            <TD>5440</TD>
            <TD>0.821978</TD>
          </TR>
          <TR>
            <TD>5442.5</TD>
            <TD>0.822511</TD>
          </TR>
          <TR>
            <TD>5445</TD>
            <TD>0.823045</TD>
          </TR>
          <TR>
            <TD>5447.5</TD>
            <TD>0.82358</TD>
          </TR>
          <TR>
            <TD>5450</TD>
            <TD>0.824114</TD>
          </TR>
          <TR>
            <TD>5452.5</TD>
            <TD>0.824797</TD>
          </TR>
          <TR>
            <TD>5455</TD>
            <TD>0.825481</TD>
          </TR>
          <TR>
            <TD>5457.5</TD>
            <TD>0.826165</TD>
          </TR>
          <TR>
            <TD>5460</TD>
            <TD>0.826849</TD>
          </TR>
          <TR>
            <TD>5462.5</TD>
            <TD>0.827521</TD>
          </TR>
          <TR>
            <TD>5465</TD>
            <TD>0.828192</TD>
          </TR>
          <TR>
            <TD>5467.5</TD>
            <TD>0.828865</TD>
          </TR>
          <TR>
            <TD>5470</TD>
            <TD>0.829537</TD>
          </TR>
          <TR>
            <TD>5472.5</TD>
            <TD>0.829926</TD>
          </TR>
          <TR>
            <TD>5475</TD>
            <TD>0.830315</TD>
          </TR>
          <TR>
            <TD>5477.5</TD>
            <TD>0.830703</TD>
          </TR>
          <TR>
            <TD>5480</TD>
            <TD>0.831092</TD>
          </TR>
          <TR>
            <TD>5482.5</TD>
            <TD>0.831533</TD>
          </TR>
          <TR>
            <TD>5485</TD>
            <TD>0.831973</TD>
          </TR>
          <TR>
            <TD>5487.5</TD>
            <TD>0.832414</TD>
          </TR>
          <TR>
            <TD>5490</TD>
            <TD>0.832855</TD>
          </TR>
          <TR>
            <TD>5492.5</TD>
            <TD>0.833339</TD>
          </TR>
          <TR>
            <TD>5495</TD>
            <TD>0.833823</TD>
          </TR>
          <TR>
            <TD>5497.5</TD>
            <TD>0.834308</TD>
          </TR>
          <TR>
            <TD>5500</TD>
            <TD>0.834792</TD>
          </TR>
          <TR>
            <TD>5502.5</TD>
            <TD>0.835175</TD>
          </TR>
          <TR>
            <TD>5505</TD>
            <TD>0.835559</TD>
          </TR>
          <TR>
            <TD>5507.5</TD>
            <TD>0.835942</TD>
          </TR>
          <TR>
            <TD>5510</TD>
            <TD>0.836325</TD>
          </TR>
          <TR>
            <TD>5512.5</TD>
            <TD>0.836698</TD>
          </TR>
          <TR>
            <TD>5515</TD>
            <TD>0.83707</TD>
          </TR>
          <TR>
            <TD>5517.5</TD>
            <TD>0.837443</TD>
          </TR>
          <TR>
            <TD>5520</TD>
            <TD>0.837815</TD>
          </TR>
          <TR>
            <TD>5522.5</TD>
            <TD>0.838625</TD>
          </TR>
          <TR>
            <TD>5525</TD>
            <TD>0.839436</TD>
          </TR>
          <TR>
            <TD>5527.5</TD>
            <TD>0.840247</TD>
          </TR>
          <TR>
            <TD>5530</TD>
            <TD>0.841058</TD>
          </TR>
          <TR>
            <TD>5532.5</TD>
            <TD>0.841631</TD>
          </TR>
          <TR>
            <TD>5535</TD>
            <TD>0.842203</TD>
          </TR>
          <TR>
            <TD>5537.5</TD>
            <TD>0.842776</TD>
          </TR>
          <TR>
            <TD>5540</TD>
            <TD>0.843348</TD>
          </TR>
          <TR>
            <TD>5542.5</TD>
            <TD>0.843762</TD>
          </TR>
          <TR>
            <TD>5545</TD>
            <TD>0.844176</TD>
          </TR>
          <TR>
            <TD>5547.5</TD>
            <TD>0.84459</TD>
          </TR>
          <TR>
            <TD>5550</TD>
            <TD>0.845004</TD>
          </TR>
          <TR>
            <TD>5552.5</TD>
            <TD>0.845488</TD>
          </TR>
          <TR>
            <TD>5555</TD>
            <TD>0.845972</TD>
          </TR>
          <TR>
            <TD>5557.5</TD>
            <TD>0.846455</TD>
          </TR>
          <TR>
            <TD>5560</TD>
            <TD>0.846939</TD>
          </TR>
          <TR>
            <TD>5562.5</TD>
            <TD>0.847409</TD>
          </TR>
          <TR>
            <TD>5565</TD>
            <TD>0.84788</TD>
          </TR>
          <TR>
            <TD>5567.5</TD>
            <TD>0.84835</TD>
          </TR>
          <TR>
            <TD>5570</TD>
            <TD>0.84882</TD>
          </TR>
          <TR>
            <TD>5572.5</TD>
            <TD>0.849218</TD>
          </TR>
          <TR>
            <TD>5575</TD>
            <TD>0.849615</TD>
          </TR>
          <TR>
            <TD>5577.5</TD>
            <TD>0.850013</TD>
          </TR>
          <TR>
            <TD>5580</TD>
            <TD>0.850411</TD>
          </TR>
          <TR>
            <TD>5582.5</TD>
            <TD>0.850797</TD>
          </TR>
          <TR>
            <TD>5585</TD>
            <TD>0.851183</TD>
          </TR>
          <TR>
            <TD>5587.5</TD>
            <TD>0.851569</TD>
          </TR>
          <TR>
            <TD>5590</TD>
            <TD>0.851955</TD>
          </TR>
          <TR>
            <TD>5592.5</TD>
            <TD>0.852554</TD>
          </TR>
          <TR>
            <TD>5595</TD>
            <TD>0.853153</TD>
          </TR>
          <TR>
            <TD>5597.5</TD>
            <TD>0.853752</TD>
          </TR>
          <TR>
            <TD>5600</TD>
            <TD>0.854352</TD>
          </TR>
          <TR>
            <TD>5602.5</TD>
            <TD>0.854716</TD>
          </TR>
          <TR>
            <TD>5605</TD>
            <TD>0.855079</TD>
          </TR>
          <TR>
            <TD>5607.5</TD>
            <TD>0.855443</TD>
          </TR>
          <TR>
            <TD>5610</TD>
            <TD>0.855806</TD>
          </TR>
          <TR>
            <TD>5612.5</TD>
            <TD>0.856413</TD>
          </TR>
          <TR>
            <TD>5615</TD>
            <TD>0.857021</TD>
          </TR>
          <TR>
            <TD>5617.5</TD>
            <TD>0.857628</TD>
          </TR>
          <TR>
            <TD>5620</TD>
            <TD>0.858236</TD>
          </TR>
          <TR>
            <TD>5622.5</TD>
            <TD>0.858644</TD>
          </TR>
          <TR>
            <TD>5625</TD>
            <TD>0.859053</TD>
          </TR>
          <TR>
            <TD>5627.5</TD>
            <TD>0.859461</TD>
          </TR>
          <TR>
            <TD>5630</TD>
            <TD>0.85987</TD>
          </TR>
          <TR>
            <TD>5632.5</TD>
            <TD>0.860393</TD>
          </TR>
          <TR>
            <TD>5635</TD>
            <TD>0.860917</TD>
          </TR>
          <TR>
            <TD>5637.5</TD>
            <TD>0.861441</TD>
          </TR>
          <TR>
            <TD>5640</TD>
            <TD>0.861965</TD>
          </TR>
          <TR>
            <TD>5642.5</TD>
            <TD>0.862411</TD>
          </TR>
          <TR>
            <TD>5645</TD>
            <TD>0.862858</TD>
          </TR>
          <TR>
            <TD>5647.5</TD>
            <TD>0.863305</TD>
          </TR>
          <TR>
            <TD>5650</TD>
            <TD>0.863751</TD>
          </TR>
          <TR>
            <TD>5652.5</TD>
            <TD>0.864145</TD>
          </TR>
          <TR>
            <TD>5655</TD>
            <TD>0.864538</TD>
          </TR>
          <TR>
            <TD>5657.5</TD>
            <TD>0.864931</TD>
          </TR>
          <TR>
            <TD>5660</TD>
            <TD>0.865325</TD>
          </TR>
          <TR>
            <TD>5662.5</TD>
            <TD>0.865919</TD>
          </TR>
          <TR>
            <TD>5665</TD>
            <TD>0.866513</TD>
          </TR>
          <TR>
            <TD>5667.5</TD>
            <TD>0.867107</TD>
          </TR>
          <TR>
            <TD>5670</TD>
            <TD>0.867702</TD>
          </TR>
          <TR>
            <TD>5672.5</TD>
            <TD>0.868147</TD>
          </TR>
          <TR>
            <TD>5675</TD>
            <TD>0.868592</TD>
          </TR>
          <TR>
            <TD>5677.5</TD>
            <TD>0.869037</TD>
          </TR>
          <TR>
            <TD>5680</TD>
            <TD>0.869482</TD>
          </TR>
          <TR>
            <TD>5682.5</TD>
            <TD>0.869677</TD>
          </TR>
          <TR>
            <TD>5685</TD>
            <TD>0.869872</TD>
          </TR>
          <TR>
            <TD>5687.5</TD>
            <TD>0.870067</TD>
          </TR>
          <TR>
            <TD>5690</TD>
            <TD>0.870261</TD>
          </TR>
          <TR>
            <TD>5692.5</TD>
            <TD>0.87083</TD>
          </TR>
          <TR>
            <TD>5695</TD>
            <TD>0.8714</TD>
          </TR>
          <TR>
            <TD>5697.5</TD>
            <TD>0.871969</TD>
          </TR>
          <TR>
            <TD>5700</TD>
            <TD>0.872539</TD>
          </TR>
          <TR>
            <TD>5702.5</TD>
            <TD>0.872835</TD>
          </TR>
          <TR>
            <TD>5705</TD>
            <TD>0.873132</TD>
          </TR>
          <TR>
            <TD>5707.5</TD>
            <TD>0.873428</TD>
          </TR>
          <TR>
            <TD>5710</TD>
            <TD>0.873725</TD>
          </TR>
          <TR>
            <TD>5712.5</TD>
            <TD>0.874131</TD>
          </TR>
          <TR>
            <TD>5715</TD>
            <TD>0.874537</TD>
          </TR>
          <TR>
            <TD>5717.5</TD>
            <TD>0.874943</TD>
          </TR>
          <TR>
            <TD>5720</TD>
            <TD>0.875349</TD>
          </TR>
          <TR>
            <TD>5722.5</TD>
            <TD>0.875768</TD>
          </TR>
          <TR>
            <TD>5725</TD>
            <TD>0.876186</TD>
          </TR>
          <TR>
            <TD>5727.5</TD>
            <TD>0.876606</TD>
          </TR>
          <TR>
            <TD>5730</TD>
            <TD>0.877025</TD>
          </TR>
          <TR>
            <TD>5732.5</TD>
            <TD>0.877586</TD>
          </TR>
          <TR>
            <TD>5735</TD>
            <TD>0.878147</TD>
          </TR>
          <TR>
            <TD>5737.5</TD>
            <TD>0.878709</TD>
          </TR>
          <TR>
            <TD>5740</TD>
            <TD>0.87927</TD>
          </TR>
          <TR>
            <TD>5742.5</TD>
            <TD>0.87959</TD>
          </TR>
          <TR>
            <TD>5745</TD>
            <TD>0.879909</TD>
          </TR>
          <TR>
            <TD>5747.5</TD>
            <TD>0.880228</TD>
          </TR>
          <TR>
            <TD>5750</TD>
            <TD>0.880547</TD>
          </TR>
          <TR>
            <TD>5752.5</TD>
            <TD>0.880953</TD>
          </TR>
          <TR>
            <TD>5755</TD>
            <TD>0.881359</TD>
          </TR>
          <TR>
            <TD>5757.5</TD>
            <TD>0.881765</TD>
          </TR>
          <TR>
            <TD>5760</TD>
            <TD>0.882172</TD>
          </TR>
          <TR>
            <TD>5762.5</TD>
            <TD>0.882614</TD>
          </TR>
          <TR>
            <TD>5765</TD>
            <TD>0.883057</TD>
          </TR>
          <TR>
            <TD>5767.5</TD>
            <TD>0.8835</TD>
          </TR>
          <TR>
            <TD>5770</TD>
            <TD>0.883943</TD>
          </TR>
          <TR>
            <TD>5772.5</TD>
            <TD>0.884578</TD>
          </TR>
          <TR>
            <TD>5775</TD>
            <TD>0.885212</TD>
          </TR>
          <TR>
            <TD>5777.5</TD>
            <TD>0.885847</TD>
          </TR>
          <TR>
            <TD>5780</TD>
            <TD>0.886482</TD>
          </TR>
          <TR>
            <TD>5782.5</TD>
            <TD>0.886794</TD>
          </TR>
          <TR>
            <TD>5785</TD>
            <TD>0.887105</TD>
          </TR>
          <TR>
            <TD>5787.5</TD>
            <TD>0.887416</TD>
          </TR>
          <TR>
            <TD>5790</TD>
            <TD>0.887727</TD>
          </TR>
          <TR>
            <TD>5792.5</TD>
            <TD>0.888145</TD>
          </TR>
          <TR>
            <TD>5795</TD>
            <TD>0.888563</TD>
          </TR>
          <TR>
            <TD>5797.5</TD>
            <TD>0.888982</TD>
          </TR>
          <TR>
            <TD>5800</TD>
            <TD>0.8894</TD>
          </TR>
          <TR>
            <TD>5802.5</TD>
            <TD>0.889951</TD>
          </TR>
          <TR>
            <TD>5805</TD>
            <TD>0.890503</TD>
          </TR>
          <TR>
            <TD>5807.5</TD>
            <TD>0.891054</TD>
          </TR>
          <TR>
            <TD>5810</TD>
            <TD>0.891606</TD>
          </TR>
          <TR>
            <TD>5812.5</TD>
            <TD>0.891862</TD>
          </TR>
          <TR>
            <TD>5815</TD>
            <TD>0.892118</TD>
          </TR>
          <TR>
            <TD>5817.5</TD>
            <TD>0.892374</TD>
          </TR>
          <TR>
            <TD>5820</TD>
            <TD>0.89263</TD>
          </TR>
          <TR>
            <TD>5822.5</TD>
            <TD>0.893205</TD>
          </TR>
          <TR>
            <TD>5825</TD>
            <TD>0.89378</TD>
          </TR>
          <TR>
            <TD>5827.5</TD>
            <TD>0.894356</TD>
          </TR>
          <TR>
            <TD>5830</TD>
            <TD>0.894931</TD>
          </TR>
          <TR>
            <TD>5832.5</TD>
            <TD>0.895229</TD>
          </TR>
          <TR>
            <TD>5835</TD>
            <TD>0.895526</TD>
          </TR>
          <TR>
            <TD>5837.5</TD>
            <TD>0.895823</TD>
          </TR>
          <TR>
            <TD>5840</TD>
            <TD>0.89612</TD>
          </TR>
          <TR>
            <TD>5842.5</TD>
            <TD>0.896396</TD>
          </TR>
          <TR>
            <TD>5845</TD>
            <TD>0.896672</TD>
          </TR>
          <TR>
            <TD>5847.5</TD>
            <TD>0.896948</TD>
          </TR>
          <TR>
            <TD>5850</TD>
            <TD>0.897224</TD>
          </TR>
          <TR>
            <TD>5852.5</TD>
            <TD>0.89742</TD>
          </TR>
          <TR>
            <TD>5855</TD>
            <TD>0.897616</TD>
          </TR>
          <TR>
            <TD>5857.5</TD>
            <TD>0.897812</TD>
          </TR>
          <TR>
            <TD>5860</TD>
            <TD>0.898008</TD>
          </TR>
          <TR>
            <TD>5862.5</TD>
            <TD>0.898717</TD>
          </TR>
          <TR>
            <TD>5865</TD>
            <TD>0.899426</TD>
          </TR>
          <TR>
            <TD>5867.5</TD>
            <TD>0.900135</TD>
          </TR>
          <TR>
            <TD>5870</TD>
            <TD>0.900844</TD>
          </TR>
          <TR>
            <TD>5872.5</TD>
            <TD>0.901288</TD>
          </TR>
          <TR>
            <TD>5875</TD>
            <TD>0.901731</TD>
          </TR>
          <TR>
            <TD>5877.5</TD>
            <TD>0.902175</TD>
          </TR>
          <TR>
            <TD>5880</TD>
            <TD>0.902619</TD>
          </TR>
          <TR>
            <TD>5882.5</TD>
            <TD>0.903198</TD>
          </TR>
          <TR>
            <TD>5885</TD>
            <TD>0.903778</TD>
          </TR>
          <TR>
            <TD>5887.5</TD>
            <TD>0.904357</TD>
          </TR>
          <TR>
            <TD>5890</TD>
            <TD>0.904937</TD>
          </TR>
          <TR>
            <TD>5892.5</TD>
            <TD>0.905433</TD>
          </TR>
          <TR>
            <TD>5895</TD>
            <TD>0.905929</TD>
          </TR>
          <TR>
            <TD>5897.5</TD>
            <TD>0.906425</TD>
          </TR>
          <TR>
            <TD>5900</TD>
            <TD>0.906921</TD>
          </TR>
          <TR>
            <TD>5902.5</TD>
            <TD>0.907081</TD>
          </TR>
          <TR>
            <TD>5905</TD>
            <TD>0.907241</TD>
          </TR>
          <TR>
            <TD>5907.5</TD>
            <TD>0.907401</TD>
          </TR>
          <TR>
            <TD>5910</TD>
            <TD>0.907561</TD>
          </TR>
          <TR>
            <TD>5912.5</TD>
            <TD>0.907606</TD>
          </TR>
          <TR>
            <TD>5915</TD>
            <TD>0.907651</TD>
          </TR>
          <TR>
            <TD>5917.5</TD>
            <TD>0.907695</TD>
          </TR>
          <TR>
            <TD>5920</TD>
            <TD>0.907739</TD>
          </TR>
          <TR>
            <TD>5922.5</TD>
            <TD>0.908384</TD>
          </TR>
          <TR>
            <TD>5925</TD>
            <TD>0.909029</TD>
          </TR>
          <TR>
            <TD>5927.5</TD>
            <TD>0.909674</TD>
          </TR>
          <TR>
            <TD>5930</TD>
            <TD>0.910319</TD>
          </TR>
          <TR>
            <TD>5932.5</TD>
            <TD>0.910716</TD>
          </TR>
          <TR>
            <TD>5935</TD>
            <TD>0.911113</TD>
          </TR>
          <TR>
            <TD>5937.5</TD>
            <TD>0.911509</TD>
          </TR>
          <TR>
            <TD>5940</TD>
            <TD>0.911906</TD>
          </TR>
          <TR>
            <TD>5942.5</TD>
            <TD>0.912321</TD>
          </TR>
          <TR>
            <TD>5945</TD>
            <TD>0.912736</TD>
          </TR>
          <TR>
            <TD>5947.5</TD>
            <TD>0.913151</TD>
          </TR>
          <TR>
            <TD>5950</TD>
            <TD>0.913566</TD>
          </TR>
          <TR>
            <TD>5952.5</TD>
            <TD>0.914242</TD>
          </TR>
          <TR>
            <TD>5955</TD>
            <TD>0.914918</TD>
          </TR>
          <TR>
            <TD>5957.5</TD>
            <TD>0.915594</TD>
          </TR>
          <TR>
            <TD>5960</TD>
            <TD>0.91627</TD>
          </TR>
          <TR>
            <TD>5962.5</TD>
            <TD>0.916331</TD>
          </TR>
          <TR>
            <TD>5965</TD>
            <TD>0.916392</TD>
          </TR>
          <TR>
            <TD>5967.5</TD>
            <TD>0.916453</TD>
          </TR>
          <TR>
            <TD>5970</TD>
            <TD>0.916514</TD>
          </TR>
          <TR>
            <TD>5972.5</TD>
            <TD>0.91685</TD>
          </TR>
          <TR>
            <TD>5975</TD>
            <TD>0.917187</TD>
          </TR>
          <TR>
            <TD>5977.5</TD>
            <TD>0.917524</TD>
          </TR>
          <TR>
            <TD>5980</TD>
            <TD>0.91786</TD>
          </TR>
          <TR>
            <TD>5982.5</TD>
            <TD>0.918051</TD>
          </TR>
          <TR>
            <TD>5985</TD>
            <TD>0.918241</TD>
          </TR>
          <TR>
            <TD>5987.5</TD>
            <TD>0.91843</TD>
          </TR>
          <TR>
            <TD>5990</TD>
            <TD>0.91862</TD>
          </TR>
          <TR>
            <TD>5992.5</TD>
            <TD>0.918996</TD>
          </TR>
          <TR>
            <TD>5995</TD>
            <TD>0.919371</TD>
          </TR>
          <TR>
            <TD>5997.5</TD>
            <TD>0.919747</TD>
          </TR>
          <TR>
            <TD>6000</TD>
            <TD>0.920123</TD>
          </TR>
          <TR>
            <TD>6002.5</TD>
            <TD>0.920926</TD>
          </TR>
          <TR>
            <TD>6005</TD>
            <TD>0.921729</TD>
          </TR>
          <TR>
            <TD>6007.5</TD>
            <TD>0.922533</TD>
          </TR>
          <TR>
            <TD>6010</TD>
            <TD>0.923338</TD>
          </TR>
          <TR>
            <TD>6012.5</TD>
            <TD>0.923382</TD>
          </TR>
          <TR>
            <TD>6015</TD>
            <TD>0.923426</TD>
          </TR>
          <TR>
            <TD>6017.5</TD>
            <TD>0.923469</TD>
          </TR>
          <TR>
            <TD>6020</TD>
            <TD>0.923513</TD>
          </TR>
          <TR>
            <TD>6022.5</TD>
            <TD>0.92383</TD>
          </TR>
          <TR>
            <TD>6025</TD>
            <TD>0.924147</TD>
          </TR>
          <TR>
            <TD>6027.5</TD>
            <TD>0.924464</TD>
          </TR>
          <TR>
            <TD>6030</TD>
            <TD>0.924781</TD>
          </TR>
          <TR>
            <TD>6032.5</TD>
            <TD>0.925268</TD>
          </TR>
          <TR>
            <TD>6035</TD>
            <TD>0.925755</TD>
          </TR>
          <TR>
            <TD>6037.5</TD>
            <TD>0.926243</TD>
          </TR>
          <TR>
            <TD>6040</TD>
            <TD>0.92673</TD>
          </TR>
          <TR>
            <TD>6042.5</TD>
            <TD>0.926884</TD>
          </TR>
          <TR>
            <TD>6045</TD>
            <TD>0.927038</TD>
          </TR>
          <TR>
            <TD>6047.5</TD>
            <TD>0.927192</TD>
          </TR>
          <TR>
            <TD>6050</TD>
            <TD>0.927346</TD>
          </TR>
          <TR>
            <TD>6052.5</TD>
            <TD>0.92771</TD>
          </TR>
          <TR>
            <TD>6055</TD>
            <TD>0.928074</TD>
          </TR>
          <TR>
            <TD>6057.5</TD>
            <TD>0.928438</TD>
          </TR>
          <TR>
            <TD>6060</TD>
            <TD>0.928802</TD>
          </TR>
          <TR>
            <TD>6062.5</TD>
            <TD>0.929016</TD>
          </TR>
          <TR>
            <TD>6065</TD>
            <TD>0.92923</TD>
          </TR>
          <TR>
            <TD>6067.5</TD>
            <TD>0.929443</TD>
          </TR>
          <TR>
            <TD>6070</TD>
            <TD>0.929657</TD>
          </TR>
          <TR>
            <TD>6072.5</TD>
            <TD>0.930145</TD>
          </TR>
          <TR>
            <TD>6075</TD>
            <TD>0.930633</TD>
          </TR>
          <TR>
            <TD>6077.5</TD>
            <TD>0.931121</TD>
          </TR>
          <TR>
            <TD>6080</TD>
            <TD>0.931609</TD>
          </TR>
          <TR>
            <TD>6082.5</TD>
            <TD>0.932031</TD>
          </TR>
          <TR>
            <TD>6085</TD>
            <TD>0.932454</TD>
          </TR>
          <TR>
            <TD>6087.5</TD>
            <TD>0.932876</TD>
          </TR>
          <TR>
            <TD>6090</TD>
            <TD>0.933298</TD>
          </TR>
          <TR>
            <TD>6092.5</TD>
            <TD>0.933574</TD>
          </TR>
          <TR>
            <TD>6095</TD>
            <TD>0.93385</TD>
          </TR>
          <TR>
            <TD>6097.5</TD>
            <TD>0.934125</TD>
          </TR>
          <TR>
            <TD>6100</TD>
            <TD>0.9344</TD>
          </TR>
          <TR>
            <TD>6102.5</TD>
            <TD>0.93492</TD>
          </TR>
          <TR>
            <TD>6105</TD>
            <TD>0.93544</TD>
          </TR>
          <TR>
            <TD>6107.5</TD>
            <TD>0.93596</TD>
          </TR>
          <TR>
            <TD>6110</TD>
            <TD>0.936479</TD>
          </TR>
          <TR>
            <TD>6112.5</TD>
            <TD>0.936606</TD>
          </TR>
          <TR>
            <TD>6115</TD>
            <TD>0.936732</TD>
          </TR>
          <TR>
            <TD>6117.5</TD>
            <TD>0.936858</TD>
          </TR>
          <TR>
            <TD>6120</TD>
            <TD>0.936983</TD>
          </TR>
          <TR>
            <TD>6122.5</TD>
            <TD>0.937386</TD>
          </TR>
          <TR>
            <TD>6125</TD>
            <TD>0.937788</TD>
          </TR>
          <TR>
            <TD>6127.5</TD>
            <TD>0.938191</TD>
          </TR>
          <TR>
            <TD>6130</TD>
            <TD>0.938593</TD>
          </TR>
          <TR>
            <TD>6132.5</TD>
            <TD>0.938902</TD>
          </TR>
          <TR>
            <TD>6135</TD>
            <TD>0.939211</TD>
          </TR>
          <TR>
            <TD>6137.5</TD>
            <TD>0.93952</TD>
          </TR>
          <TR>
            <TD>6140</TD>
            <TD>0.939828</TD>
          </TR>
          <TR>
            <TD>6142.5</TD>
            <TD>0.940244</TD>
          </TR>
          <TR>
            <TD>6145</TD>
            <TD>0.94066</TD>
          </TR>
          <TR>
            <TD>6147.5</TD>
            <TD>0.941076</TD>
          </TR>
          <TR>
            <TD>6150</TD>
            <TD>0.941492</TD>
          </TR>
          <TR>
            <TD>6152.5</TD>
            <TD>0.94182</TD>
          </TR>
          <TR>
            <TD>6155</TD>
            <TD>0.942148</TD>
          </TR>
          <TR>
            <TD>6157.5</TD>
            <TD>0.942476</TD>
          </TR>
          <TR>
            <TD>6160</TD>
            <TD>0.942804</TD>
          </TR>
          <TR>
            <TD>6162.5</TD>
            <TD>0.943012</TD>
          </TR>
          <TR>
            <TD>6165</TD>
            <TD>0.94322</TD>
          </TR>
          <TR>
            <TD>6167.5</TD>
            <TD>0.943428</TD>
          </TR>
          <TR>
            <TD>6170</TD>
            <TD>0.943635</TD>
          </TR>
          <TR>
            <TD>6172.5</TD>
            <TD>0.943655</TD>
          </TR>
          <TR>
            <TD>6175</TD>
            <TD>0.943674</TD>
          </TR>
          <TR>
            <TD>6177.5</TD>
            <TD>0.943694</TD>
          </TR>
          <TR>
            <TD>6180</TD>
            <TD>0.943713</TD>
          </TR>
          <TR>
            <TD>6182.5</TD>
            <TD>0.944131</TD>
          </TR>
          <TR>
            <TD>6185</TD>
            <TD>0.944549</TD>
          </TR>
          <TR>
            <TD>6187.5</TD>
            <TD>0.944968</TD>
          </TR>
          <TR>
            <TD>6190</TD>
            <TD>0.945386</TD>
          </TR>
          <TR>
            <TD>6192.5</TD>
            <TD>0.945804</TD>
          </TR>
          <TR>
            <TD>6195</TD>
            <TD>0.946222</TD>
          </TR>
          <TR>
            <TD>6197.5</TD>
            <TD>0.94664</TD>
          </TR>
          <TR>
            <TD>6200</TD>
            <TD>0.947058</TD>
          </TR>
          <TR>
            <TD>6202.5</TD>
            <TD>0.947348</TD>
          </TR>
          <TR>
            <TD>6205</TD>
            <TD>0.947639</TD>
          </TR>
          <TR>
            <TD>6207.5</TD>
            <TD>0.947929</TD>
          </TR>
          <TR>
            <TD>6210</TD>
            <TD>0.948219</TD>
          </TR>
          <TR>
            <TD>6212.5</TD>
            <TD>0.948749</TD>
          </TR>
          <TR>
            <TD>6215</TD>
            <TD>0.949279</TD>
          </TR>
          <TR>
            <TD>6217.5</TD>
            <TD>0.949809</TD>
          </TR>
          <TR>
            <TD>6220</TD>
            <TD>0.950339</TD>
          </TR>
          <TR>
            <TD>6222.5</TD>
            <TD>0.950347</TD>
          </TR>
          <TR>
            <TD>6225</TD>
            <TD>0.950354</TD>
          </TR>
          <TR>
            <TD>6227.5</TD>
            <TD>0.950362</TD>
          </TR>
          <TR>
            <TD>6230</TD>
            <TD>0.950369</TD>
          </TR>
          <TR>
            <TD>6232.5</TD>
            <TD>0.950342</TD>
          </TR>
          <TR>
            <TD>6235</TD>
            <TD>0.950316</TD>
          </TR>
          <TR>
            <TD>6237.5</TD>
            <TD>0.950289</TD>
          </TR>
          <TR>
            <TD>6240</TD>
            <TD>0.950262</TD>
          </TR>
          <TR>
            <TD>6242.5</TD>
            <TD>0.950591</TD>
          </TR>
          <TR>
            <TD>6245</TD>
            <TD>0.950919</TD>
          </TR>
          <TR>
            <TD>6247.5</TD>
            <TD>0.951248</TD>
          </TR>
          <TR>
            <TD>6250</TD>
            <TD>0.951576</TD>
          </TR>
          <TR>
            <TD>6252.5</TD>
            <TD>0.951857</TD>
          </TR>
          <TR>
            <TD>6255</TD>
            <TD>0.952137</TD>
          </TR>
          <TR>
            <TD>6257.5</TD>
            <TD>0.952417</TD>
          </TR>
          <TR>
            <TD>6260</TD>
            <TD>0.952697</TD>
          </TR>
          <TR>
            <TD>6262.5</TD>
            <TD>0.953082</TD>
          </TR>
          <TR>
            <TD>6265</TD>
            <TD>0.953466</TD>
          </TR>
          <TR>
            <TD>6267.5</TD>
            <TD>0.953851</TD>
          </TR>
          <TR>
            <TD>6270</TD>
            <TD>0.954235</TD>
          </TR>
          <TR>
            <TD>6272.5</TD>
            <TD>0.954435</TD>
          </TR>
          <TR>
            <TD>6275</TD>
            <TD>0.954635</TD>
          </TR>
          <TR>
            <TD>6277.5</TD>
            <TD>0.954835</TD>
          </TR>
          <TR>
            <TD>6280</TD>
            <TD>0.955035</TD>
          </TR>
          <TR>
            <TD>6282.5</TD>
            <TD>0.955379</TD>
          </TR>
          <TR>
            <TD>6285</TD>
            <TD>0.955722</TD>
          </TR>
          <TR>
            <TD>6287.5</TD>
            <TD>0.956066</TD>
          </TR>
          <TR>
            <TD>6290</TD>
            <TD>0.956409</TD>
          </TR>
          <TR>
            <TD>6292.5</TD>
            <TD>0.956533</TD>
          </TR>
          <TR>
            <TD>6295</TD>
            <TD>0.956656</TD>
          </TR>
          <TR>
            <TD>6297.5</TD>
            <TD>0.956779</TD>
          </TR>
          <TR>
            <TD>6300</TD>
            <TD>0.956902</TD>
          </TR>
          <TR>
            <TD>6302.5</TD>
            <TD>0.957272</TD>
          </TR>
          <TR>
            <TD>6305</TD>
            <TD>0.957641</TD>
          </TR>
          <TR>
            <TD>6307.5</TD>
            <TD>0.958011</TD>
          </TR>
          <TR>
            <TD>6310</TD>
            <TD>0.95838</TD>
          </TR>
          <TR>
            <TD>6312.5</TD>
            <TD>0.958879</TD>
          </TR>
          <TR>
            <TD>6315</TD>
            <TD>0.959377</TD>
          </TR>
          <TR>
            <TD>6317.5</TD>
            <TD>0.959876</TD>
          </TR>
          <TR>
            <TD>6320</TD>
            <TD>0.960374</TD>
          </TR>
          <TR>
            <TD>6322.5</TD>
            <TD>0.960508</TD>
          </TR>
          <TR>
            <TD>6325</TD>
            <TD>0.960642</TD>
          </TR>
          <TR>
            <TD>6327.5</TD>
            <TD>0.960775</TD>
          </TR>
          <TR>
            <TD>6330</TD>
            <TD>0.960908</TD>
          </TR>
          <TR>
            <TD>6332.5</TD>
            <TD>0.96113</TD>
          </TR>
          <TR>
            <TD>6335</TD>
            <TD>0.961352</TD>
          </TR>
          <TR>
            <TD>6337.5</TD>
            <TD>0.961573</TD>
          </TR>
          <TR>
            <TD>6340</TD>
            <TD>0.961795</TD>
          </TR>
          <TR>
            <TD>6342.5</TD>
            <TD>0.961891</TD>
          </TR>
          <TR>
            <TD>6345</TD>
            <TD>0.961987</TD>
          </TR>
          <TR>
            <TD>6347.5</TD>
            <TD>0.962083</TD>
          </TR>
          <TR>
            <TD>6350</TD>
            <TD>0.962179</TD>
          </TR>
          <TR>
            <TD>6352.5</TD>
            <TD>0.962625</TD>
          </TR>
          <TR>
            <TD>6355</TD>
            <TD>0.963072</TD>
          </TR>
          <TR>
            <TD>6357.5</TD>
            <TD>0.963518</TD>
          </TR>
          <TR>
            <TD>6360</TD>
            <TD>0.963965</TD>
          </TR>
          <TR>
            <TD>6362.5</TD>
            <TD>0.96419</TD>
          </TR>
          <TR>
            <TD>6365</TD>
            <TD>0.964415</TD>
          </TR>
          <TR>
            <TD>6367.5</TD>
            <TD>0.964641</TD>
          </TR>
          <TR>
            <TD>6370</TD>
            <TD>0.964866</TD>
          </TR>
          <TR>
            <TD>6372.5</TD>
            <TD>0.965277</TD>
          </TR>
          <TR>
            <TD>6375</TD>
            <TD>0.965688</TD>
          </TR>
          <TR>
            <TD>6377.5</TD>
            <TD>0.966099</TD>
          </TR>
          <TR>
            <TD>6380</TD>
            <TD>0.966511</TD>
          </TR>
          <TR>
            <TD>6382.5</TD>
            <TD>0.966495</TD>
          </TR>
          <TR>
            <TD>6385</TD>
            <TD>0.966479</TD>
          </TR>
          <TR>
            <TD>6387.5</TD>
            <TD>0.966462</TD>
          </TR>
          <TR>
            <TD>6390</TD>
            <TD>0.966445</TD>
          </TR>
          <TR>
            <TD>6392.5</TD>
            <TD>0.966588</TD>
          </TR>
          <TR>
            <TD>6395</TD>
            <TD>0.96673</TD>
          </TR>
          <TR>
            <TD>6397.5</TD>
            <TD>0.966872</TD>
          </TR>
          <TR>
            <TD>6400</TD>
            <TD>0.967013</TD>
          </TR>
          <TR>
            <TD>6402.5</TD>
            <TD>0.967209</TD>
          </TR>
          <TR>
            <TD>6405</TD>
            <TD>0.967405</TD>
          </TR>
          <TR>
            <TD>6407.5</TD>
            <TD>0.967601</TD>
          </TR>
          <TR>
            <TD>6410</TD>
            <TD>0.967796</TD>
          </TR>
          <TR>
            <TD>6412.5</TD>
            <TD>0.968188</TD>
          </TR>
          <TR>
            <TD>6415</TD>
            <TD>0.968579</TD>
          </TR>
          <TR>
            <TD>6417.5</TD>
            <TD>0.968971</TD>
          </TR>
          <TR>
            <TD>6420</TD>
            <TD>0.969362</TD>
          </TR>
          <TR>
            <TD>6422.5</TD>
            <TD>0.969654</TD>
          </TR>
          <TR>
            <TD>6425</TD>
            <TD>0.969946</TD>
          </TR>
          <TR>
            <TD>6427.5</TD>
            <TD>0.970238</TD>
          </TR>
          <TR>
            <TD>6430</TD>
            <TD>0.970529</TD>
          </TR>
          <TR>
            <TD>6432.5</TD>
            <TD>0.970675</TD>
          </TR>
          <TR>
            <TD>6435</TD>
            <TD>0.970821</TD>
          </TR>
          <TR>
            <TD>6437.5</TD>
            <TD>0.970966</TD>
          </TR>
          <TR>
            <TD>6440</TD>
            <TD>0.971111</TD>
          </TR>
          <TR>
            <TD>6442.5</TD>
            <TD>0.971141</TD>
          </TR>
          <TR>
            <TD>6445</TD>
            <TD>0.971171</TD>
          </TR>
          <TR>
            <TD>6447.5</TD>
            <TD>0.9712</TD>
          </TR>
          <TR>
            <TD>6450</TD>
            <TD>0.971229</TD>
          </TR>
          <TR>
            <TD>6452.5</TD>
            <TD>0.971455</TD>
          </TR>
          <TR>
            <TD>6455</TD>
            <TD>0.97168</TD>
          </TR>
          <TR>
            <TD>6457.5</TD>
            <TD>0.971904</TD>
          </TR>
          <TR>
            <TD>6460</TD>
            <TD>0.972129</TD>
          </TR>
          <TR>
            <TD>6462.5</TD>
            <TD>0.972686</TD>
          </TR>
          <TR>
            <TD>6465</TD>
            <TD>0.973242</TD>
          </TR>
          <TR>
            <TD>6467.5</TD>
            <TD>0.973799</TD>
          </TR>
          <TR>
            <TD>6470</TD>
            <TD>0.974356</TD>
          </TR>
          <TR>
            <TD>6472.5</TD>
            <TD>0.974487</TD>
          </TR>
          <TR>
            <TD>6475</TD>
            <TD>0.974618</TD>
          </TR>
          <TR>
            <TD>6477.5</TD>
            <TD>0.974749</TD>
          </TR>
          <TR>
            <TD>6480</TD>
            <TD>0.97488</TD>
          </TR>
          <TR>
            <TD>6482.5</TD>
            <TD>0.974838</TD>
          </TR>
          <TR>
            <TD>6485</TD>
            <TD>0.974796</TD>
          </TR>
          <TR>
            <TD>6487.5</TD>
            <TD>0.974754</TD>
          </TR>
          <TR>
            <TD>6490</TD>
            <TD>0.974712</TD>
          </TR>
          <TR>
            <TD>6492.5</TD>
            <TD>0.975062</TD>
          </TR>
          <TR>
            <TD>6495</TD>
            <TD>0.975412</TD>
          </TR>
          <TR>
            <TD>6497.5</TD>
            <TD>0.975761</TD>
          </TR>
          <TR>
            <TD>6500</TD>
            <TD>0.976111</TD>
          </TR>
          <TR>
            <TD>6502.5</TD>
            <TD>0.976378</TD>
          </TR>
          <TR>
            <TD>6505</TD>
            <TD>0.976644</TD>
          </TR>
          <TR>
            <TD>6507.5</TD>
            <TD>0.976911</TD>
          </TR>
          <TR>
            <TD>6510</TD>
            <TD>0.977177</TD>
          </TR>
          <TR>
            <TD>6512.5</TD>
            <TD>0.977367</TD>
          </TR>
          <TR>
            <TD>6515</TD>
            <TD>0.977557</TD>
          </TR>
          <TR>
            <TD>6517.5</TD>
            <TD>0.977746</TD>
          </TR>
          <TR>
            <TD>6520</TD>
            <TD>0.977936</TD>
          </TR>
          <TR>
            <TD>6522.5</TD>
            <TD>0.978187</TD>
          </TR>
          <TR>
            <TD>6525</TD>
            <TD>0.978438</TD>
          </TR>
          <TR>
            <TD>6527.5</TD>
            <TD>0.97869</TD>
          </TR>
          <TR>
            <TD>6530</TD>
            <TD>0.978941</TD>
          </TR>
          <TR>
            <TD>6532.5</TD>
            <TD>0.979063</TD>
          </TR>
          <TR>
            <TD>6535</TD>
            <TD>0.979185</TD>
          </TR>
          <TR>
            <TD>6537.5</TD>
            <TD>0.979306</TD>
          </TR>
          <TR>
            <TD>6540</TD>
            <TD>0.979428</TD>
          </TR>
          <TR>
            <TD>6542.5</TD>
            <TD>0.979468</TD>
          </TR>
          <TR>
            <TD>6545</TD>
            <TD>0.979507</TD>
          </TR>
          <TR>
            <TD>6547.5</TD>
            <TD>0.979547</TD>
          </TR>
          <TR>
            <TD>6550</TD>
            <TD>0.979586</TD>
          </TR>
          <TR>
            <TD>6552.5</TD>
            <TD>0.979827</TD>
          </TR>
          <TR>
            <TD>6555</TD>
            <TD>0.980067</TD>
          </TR>
          <TR>
            <TD>6557.5</TD>
            <TD>0.980308</TD>
          </TR>
          <TR>
            <TD>6560</TD>
            <TD>0.980548</TD>
          </TR>
          <TR>
            <TD>6562.5</TD>
            <TD>0.980635</TD>
          </TR>
          <TR>
            <TD>6565</TD>
            <TD>0.980722</TD>
          </TR>
          <TR>
            <TD>6567.5</TD>
            <TD>0.980809</TD>
          </TR>
          <TR>
            <TD>6570</TD>
            <TD>0.980896</TD>
          </TR>
          <TR>
            <TD>6572.5</TD>
            <TD>0.98128</TD>
          </TR>
          <TR>
            <TD>6575</TD>
            <TD>0.981664</TD>
          </TR>
          <TR>
            <TD>6577.5</TD>
            <TD>0.982048</TD>
          </TR>
          <TR>
            <TD>6580</TD>
            <TD>0.982432</TD>
          </TR>
          <TR>
            <TD>6582.5</TD>
            <TD>0.982446</TD>
          </TR>
          <TR>
            <TD>6585</TD>
            <TD>0.982459</TD>
          </TR>
          <TR>
            <TD>6587.5</TD>
            <TD>0.982473</TD>
          </TR>
          <TR>
            <TD>6590</TD>
            <TD>0.982486</TD>
          </TR>
          <TR>
            <TD>6592.5</TD>
            <TD>0.982865</TD>
          </TR>
          <TR>
            <TD>6595</TD>
            <TD>0.983245</TD>
          </TR>
          <TR>
            <TD>6597.5</TD>
            <TD>0.983624</TD>
          </TR>
          <TR>
            <TD>6600</TD>
            <TD>0.984004</TD>
          </TR>
          <TR>
            <TD>6602.5</TD>
            <TD>0.984073</TD>
          </TR>
          <TR>
            <TD>6605</TD>
            <TD>0.984141</TD>
          </TR>
          <TR>
            <TD>6607.5</TD>
            <TD>0.98421</TD>
          </TR>
          <TR>
            <TD>6610</TD>
            <TD>0.984278</TD>
          </TR>
          <TR>
            <TD>6612.5</TD>
            <TD>0.984445</TD>
          </TR>
          <TR>
            <TD>6615</TD>
            <TD>0.984612</TD>
          </TR>
          <TR>
            <TD>6617.5</TD>
            <TD>0.984778</TD>
          </TR>
          <TR>
            <TD>6620</TD>
            <TD>0.984945</TD>
          </TR>
          <TR>
            <TD>6622.5</TD>
            <TD>0.984891</TD>
          </TR>
          <TR>
            <TD>6625</TD>
            <TD>0.984836</TD>
          </TR>
          <TR>
            <TD>6627.5</TD>
            <TD>0.984781</TD>
          </TR>
          <TR>
            <TD>6630</TD>
            <TD>0.984726</TD>
          </TR>
          <TR>
            <TD>6632.5</TD>
            <TD>0.984964</TD>
          </TR>
          <TR>
            <TD>6635</TD>
            <TD>0.985202</TD>
          </TR>
          <TR>
            <TD>6637.5</TD>
            <TD>0.98544</TD>
          </TR>
          <TR>
            <TD>6640</TD>
            <TD>0.985677</TD>
          </TR>
          <TR>
            <TD>6642.5</TD>
            <TD>0.985942</TD>
          </TR>
          <TR>
            <TD>6645</TD>
            <TD>0.986208</TD>
          </TR>
          <TR>
            <TD>6647.5</TD>
            <TD>0.986473</TD>
          </TR>
          <TR>
            <TD>6650</TD>
            <TD>0.986738</TD>
          </TR>
          <TR>
            <TD>6652.5</TD>
            <TD>0.987079</TD>
          </TR>
          <TR>
            <TD>6655</TD>
            <TD>0.98742</TD>
          </TR>
          <TR>
            <TD>6657.5</TD>
            <TD>0.98776</TD>
          </TR>
          <TR>
            <TD>6660</TD>
            <TD>0.988101</TD>
          </TR>
          <TR>
            <TD>6662.5</TD>
            <TD>0.988365</TD>
          </TR>
          <TR>
            <TD>6665</TD>
            <TD>0.988629</TD>
          </TR>
          <TR>
            <TD>6667.5</TD>
            <TD>0.988892</TD>
          </TR>
          <TR>
            <TD>6670</TD>
            <TD>0.989156</TD>
          </TR>
          <TR>
            <TD>6672.5</TD>
            <TD>0.989245</TD>
          </TR>
          <TR>
            <TD>6675</TD>
            <TD>0.989333</TD>
          </TR>
          <TR>
            <TD>6677.5</TD>
            <TD>0.989422</TD>
          </TR>
          <TR>
            <TD>6680</TD>
            <TD>0.98951</TD>
          </TR>
          <TR>
            <TD>6682.5</TD>
            <TD>0.989513</TD>
          </TR>
          <TR>
            <TD>6685</TD>
            <TD>0.989515</TD>
          </TR>
          <TR>
            <TD>6687.5</TD>
            <TD>0.989517</TD>
          </TR>
          <TR>
            <TD>6690</TD>
            <TD>0.989519</TD>
          </TR>
          <TR>
            <TD>6692.5</TD>
            <TD>0.98952</TD>
          </TR>
          <TR>
            <TD>6695</TD>
            <TD>0.98952</TD>
          </TR>
          <TR>
            <TD>6697.5</TD>
            <TD>0.989519</TD>
          </TR>
          <TR>
            <TD>6700</TD>
            <TD>0.989519</TD>
          </TR>
          <TR>
            <TD>6702.5</TD>
            <TD>0.989857</TD>
          </TR>
          <TR>
            <TD>6705</TD>
            <TD>0.990196</TD>
          </TR>
          <TR>
            <TD>6707.5</TD>
            <TD>0.990534</TD>
          </TR>
          <TR>
            <TD>6710</TD>
            <TD>0.990872</TD>
          </TR>
          <TR>
            <TD>6712.5</TD>
            <TD>0.990791</TD>
          </TR>
          <TR>
            <TD>6715</TD>
            <TD>0.990709</TD>
          </TR>
          <TR>
            <TD>6717.5</TD>
            <TD>0.990627</TD>
          </TR>
          <TR>
            <TD>6720</TD>
            <TD>0.990544</TD>
          </TR>
          <TR>
            <TD>6722.5</TD>
            <TD>0.991066</TD>
          </TR>
          <TR>
            <TD>6725</TD>
            <TD>0.991587</TD>
          </TR>
          <TR>
            <TD>6727.5</TD>
            <TD>0.992108</TD>
          </TR>
          <TR>
            <TD>6730</TD>
            <TD>0.99263</TD>
          </TR>
          <TR>
            <TD>6732.5</TD>
            <TD>0.992722</TD>
          </TR>
          <TR>
            <TD>6735</TD>
            <TD>0.992813</TD>
          </TR>
          <TR>
            <TD>6737.5</TD>
            <TD>0.992904</TD>
          </TR>
          <TR>
            <TD>6740</TD>
            <TD>0.992995</TD>
          </TR>
          <TR>
            <TD>6742.5</TD>
            <TD>0.993044</TD>
          </TR>
          <TR>
            <TD>6745</TD>
            <TD>0.993093</TD>
          </TR>
          <TR>
            <TD>6747.5</TD>
            <TD>0.993142</TD>
          </TR>
          <TR>
            <TD>6750</TD>
            <TD>0.99319</TD>
          </TR>
          <TR>
            <TD>6752.5</TD>
            <TD>0.993131</TD>
          </TR>
          <TR>
            <TD>6755</TD>
            <TD>0.993072</TD>
          </TR>
          <TR>
            <TD>6757.5</TD>
            <TD>0.993013</TD>
          </TR>
          <TR>
            <TD>6760</TD>
            <TD>0.992953</TD>
          </TR>
          <TR>
            <TD>6762.5</TD>
            <TD>0.993061</TD>
          </TR>
          <TR>
            <TD>6765</TD>
            <TD>0.993168</TD>
          </TR>
          <TR>
            <TD>6767.5</TD>
            <TD>0.993276</TD>
          </TR>
          <TR>
            <TD>6770</TD>
            <TD>0.993383</TD>
          </TR>
          <TR>
            <TD>6772.5</TD>
            <TD>0.993597</TD>
          </TR>
          <TR>
            <TD>6775</TD>
            <TD>0.99381</TD>
          </TR>
          <TR>
            <TD>6777.5</TD>
            <TD>0.994024</TD>
          </TR>
          <TR>
            <TD>6780</TD>
            <TD>0.994237</TD>
          </TR>
          <TR>
            <TD>6782.5</TD>
            <TD>0.994457</TD>
          </TR>
          <TR>
            <TD>6785</TD>
            <TD>0.994677</TD>
          </TR>
          <TR>
            <TD>6787.5</TD>
            <TD>0.994897</TD>
          </TR>
          <TR>
            <TD>6790</TD>
            <TD>0.995116</TD>
          </TR>
          <TR>
            <TD>6792.5</TD>
            <TD>0.995146</TD>
          </TR>
          <TR>
            <TD>6795</TD>
            <TD>0.995176</TD>
          </TR>
          <TR>
            <TD>6797.5</TD>
            <TD>0.995206</TD>
          </TR>
          <TR>
            <TD>6800</TD>
            <TD>0.995235</TD>
          </TR>
          <TR>
            <TD>6802.5</TD>
            <TD>0.995276</TD>
          </TR>
          <TR>
            <TD>6805</TD>
            <TD>0.995317</TD>
          </TR>
          <TR>
            <TD>6807.5</TD>
            <TD>0.995358</TD>
          </TR>
          <TR>
            <TD>6810</TD>
            <TD>0.995398</TD>
          </TR>
          <TR>
            <TD>6812.5</TD>
            <TD>0.995383</TD>
          </TR>
          <TR>
            <TD>6815</TD>
            <TD>0.995368</TD>
          </TR>
          <TR>
            <TD>6817.5</TD>
            <TD>0.995352</TD>
          </TR>
          <TR>
            <TD>6820</TD>
            <TD>0.995336</TD>
          </TR>
          <TR>
            <TD>6822.5</TD>
            <TD>0.995404</TD>
          </TR>
          <TR>
            <TD>6825</TD>
            <TD>0.995471</TD>
          </TR>
          <TR>
            <TD>6827.5</TD>
            <TD>0.995537</TD>
          </TR>
          <TR>
            <TD>6830</TD>
            <TD>0.995604</TD>
          </TR>
          <TR>
            <TD>6832.5</TD>
            <TD>0.99567</TD>
          </TR>
          <TR>
            <TD>6835</TD>
            <TD>0.995735</TD>
          </TR>
          <TR>
            <TD>6837.5</TD>
            <TD>0.995801</TD>
          </TR>
          <TR>
            <TD>6840</TD>
            <TD>0.995866</TD>
          </TR>
          <TR>
            <TD>6842.5</TD>
            <TD>0.995989</TD>
          </TR>
          <TR>
            <TD>6845</TD>
            <TD>0.996111</TD>
          </TR>
          <TR>
            <TD>6847.5</TD>
            <TD>0.996234</TD>
          </TR>
          <TR>
            <TD>6850</TD>
            <TD>0.996356</TD>
          </TR>
          <TR>
            <TD>6852.5</TD>
            <TD>0.99644</TD>
          </TR>
          <TR>
            <TD>6855</TD>
            <TD>0.996523</TD>
          </TR>
          <TR>
            <TD>6857.5</TD>
            <TD>0.996607</TD>
          </TR>
          <TR>
            <TD>6860</TD>
            <TD>0.99669</TD>
          </TR>
          <TR>
            <TD>6862.5</TD>
            <TD>0.99674</TD>
          </TR>
          <TR>
            <TD>6865</TD>
            <TD>0.996789</TD>
          </TR>
          <TR>
            <TD>6867.5</TD>
            <TD>0.996838</TD>
          </TR>
          <TR>
            <TD>6870</TD>
            <TD>0.996887</TD>
          </TR>
          <TR>
            <TD>6872.5</TD>
            <TD>0.996935</TD>
          </TR>
          <TR>
            <TD>6875</TD>
            <TD>0.996982</TD>
          </TR>
          <TR>
            <TD>6877.5</TD>
            <TD>0.997029</TD>
          </TR>
          <TR>
            <TD>6880</TD>
            <TD>0.997076</TD>
          </TR>
          <TR>
            <TD>6882.5</TD>
            <TD>0.997332</TD>
          </TR>
          <TR>
            <TD>6885</TD>
            <TD>0.997587</TD>
          </TR>
          <TR>
            <TD>6887.5</TD>
            <TD>0.997843</TD>
          </TR>
          <TR>
            <TD>6890</TD>
            <TD>0.998098</TD>
          </TR>
          <TR>
            <TD>6892.5</TD>
            <TD>0.997947</TD>
          </TR>
          <TR>
            <TD>6895</TD>
            <TD>0.997796</TD>
          </TR>
          <TR>
            <TD>6897.5</TD>
            <TD>0.997645</TD>
          </TR>
          <TR>
            <TD>6900</TD>
            <TD>0.997493</TD>
          </TR>
          <TR>
            <TD>6902.5</TD>
            <TD>0.997683</TD>
          </TR>
          <TR>
            <TD>6905</TD>
            <TD>0.997874</TD>
          </TR>
          <TR>
            <TD>6907.5</TD>
            <TD>0.998064</TD>
          </TR>
          <TR>
            <TD>6910</TD>
            <TD>0.998254</TD>
          </TR>
          <TR>
            <TD>6912.5</TD>
            <TD>0.99865</TD>
          </TR>
          <TR>
            <TD>6915</TD>
            <TD>0.999045</TD>
          </TR>
          <TR>
            <TD>6917.5</TD>
            <TD>0.999441</TD>
          </TR>
          <TR>
            <TD>6920</TD>
            <TD>0.999836</TD>
          </TR>
          <TR>
            <TD>6922.5</TD>
            <TD>0.999338</TD>
          </TR>
          <TR>
            <TD>6925</TD>
            <TD>0.998839</TD>
          </TR>
          <TR>
            <TD>6927.5</TD>
            <TD>0.99834</TD>
          </TR>
          <TR>
            <TD>6930</TD>
            <TD>0.99784</TD>
          </TR>
          <TR>
            <TD>6932.5</TD>
            <TD>0.998139</TD>
          </TR>
          <TR>
            <TD>6935</TD>
            <TD>0.998437</TD>
          </TR>
          <TR>
            <TD>6937.5</TD>
            <TD>0.998736</TD>
          </TR>
          <TR>
            <TD>6940</TD>
            <TD>0.999035</TD>
          </TR>
          <TR>
            <TD>6942.5</TD>
            <TD>0.998895</TD>
          </TR>
          <TR>
            <TD>6945</TD>
            <TD>0.998756</TD>
          </TR>
          <TR>
            <TD>6947.5</TD>
            <TD>0.998615</TD>
          </TR>
          <TR>
            <TD>6950</TD>
            <TD>0.998475</TD>
          </TR>
          <TR>
            <TD>6952.5</TD>
            <TD>0.998613</TD>
          </TR>
          <TR>
            <TD>6955</TD>
            <TD>0.998752</TD>
          </TR>
          <TR>
            <TD>6957.5</TD>
            <TD>0.99889</TD>
          </TR>
          <TR>
            <TD>6960</TD>
            <TD>0.999028</TD>
          </TR>
          <TR>
            <TD>6962.5</TD>
            <TD>0.999038</TD>
          </TR>
          <TR>
            <TD>6965</TD>
            <TD>0.999049</TD>
          </TR>
          <TR>
            <TD>6967.5</TD>
            <TD>0.999059</TD>
          </TR>
          <TR>
            <TD>6970</TD>
            <TD>0.999069</TD>
          </TR>
          <TR>
            <TD>6972.5</TD>
            <TD>0.999045</TD>
          </TR>
          <TR>
            <TD>6975</TD>
            <TD>0.99902</TD>
          </TR>
          <TR>
            <TD>6977.5</TD>
            <TD>0.998995</TD>
          </TR>
          <TR>
            <TD>6980</TD>
            <TD>0.99897</TD>
          </TR>
          <TR>
            <TD>6982.5</TD>
            <TD>0.999212</TD>
          </TR>
          <TR>
            <TD>6985</TD>
            <TD>0.999454</TD>
          </TR>
          <TR>
            <TD>6987.5</TD>
            <TD>0.999696</TD>
          </TR>
          <TR>
            <TD>6990</TD>
            <TD>0.999938</TD>
          </TR>
          <TR>
            <TD>6992.5</TD>
            <TD>0.999926</TD>
          </TR>
          <TR>
            <TD>6995</TD>
            <TD>0.999913</TD>
          </TR>
          <TR>
            <TD>6997.5</TD>
            <TD>0.999899</TD>
          </TR>
          <TR>
            <TD>7000</TD>
            <TD>0.999886</TD>
          </TR>
          <TR>
            <TD>7002.5</TD>
            <TD>0.999915</TD>
          </TR>
          <TR>
            <TD>7005</TD>
            <TD>0.999943</TD>
          </TR>
          <TR>
            <TD>7007.5</TD>
            <TD>0.999972</TD>
          </TR>
          <TR>
            <TD>7010</TD>
            <TD>1</TD>
          </TR>
          <TR>
            <TD>7012.5</TD>
            <TD>0.999496</TD>
          </TR>
          <TR>
            <TD>7015</TD>
            <TD>0.998991</TD>
          </TR>
          <TR>
            <TD>7017.5</TD>
            <TD>0.998485</TD>
          </TR>
          <TR>
            <TD>7020</TD>
            <TD>0.997979</TD>
          </TR>
          <TR>
            <TD>7022.5</TD>
            <TD>0.997915</TD>
          </TR>
          <TR>
            <TD>7025</TD>
            <TD>0.997851</TD>
          </TR>
          <TR>
            <TD>7027.5</TD>
            <TD>0.997787</TD>
          </TR>
          <TR>
            <TD>7030</TD>
            <TD>0.997722</TD>
          </TR>
          <TR>
            <TD>7032.5</TD>
            <TD>0.998037</TD>
          </TR>
          <TR>
            <TD>7035</TD>
            <TD>0.998352</TD>
          </TR>
          <TR>
            <TD>7037.5</TD>
            <TD>0.998667</TD>
          </TR>
          <TR>
            <TD>7040</TD>
            <TD>0.998982</TD>
          </TR>
          <TR>
            <TD>7042.5</TD>
            <TD>0.999027</TD>
          </TR>
          <TR>
            <TD>7045</TD>
            <TD>0.999072</TD>
          </TR>
          <TR>
            <TD>7047.5</TD>
            <TD>0.999116</TD>
          </TR>
          <TR>
            <TD>7050</TD>
            <TD>0.999161</TD>
          </TR>
          <TR>
            <TD>7052.5</TD>
            <TD>0.999222</TD>
          </TR>
          <TR>
            <TD>7055</TD>
            <TD>0.999284</TD>
          </TR>
          <TR>
            <TD>7057.5</TD>
            <TD>0.999345</TD>
          </TR>
          <TR>
            <TD>7060</TD>
            <TD>0.999406</TD>
          </TR>
          <TR>
            <TD>7062.5</TD>
            <TD>0.999162</TD>
          </TR>
          <TR>
            <TD>7065</TD>
            <TD>0.998918</TD>
          </TR>
          <TR>
            <TD>7067.5</TD>
            <TD>0.998674</TD>
          </TR>
          <TR>
            <TD>7070</TD>
            <TD>0.998429</TD>
          </TR>
          <TR>
            <TD>7072.5</TD>
            <TD>0.998201</TD>
          </TR>
          <TR>
            <TD>7075</TD>
            <TD>0.997972</TD>
          </TR>
          <TR>
            <TD>7077.5</TD>
            <TD>0.997743</TD>
          </TR>
          <TR>
            <TD>7080</TD>
            <TD>0.997514</TD>
          </TR>
          <TR>
            <TD>7082.5</TD>
            <TD>0.997397</TD>
          </TR>
          <TR>
            <TD>7085</TD>
            <TD>0.99728</TD>
          </TR>
          <TR>
            <TD>7087.5</TD>
            <TD>0.997162</TD>
          </TR>
          <TR>
            <TD>7090</TD>
            <TD>0.997044</TD>
          </TR>
          <TR>
            <TD>7092.5</TD>
            <TD>0.997118</TD>
          </TR>
          <TR>
            <TD>7095</TD>
            <TD>0.997191</TD>
          </TR>
          <TR>
            <TD>7097.5</TD>
            <TD>0.997264</TD>
          </TR>
          <TR>
            <TD>7100</TD>
            <TD>0.997338</TD>
          </TR>
          <TR>
            <TD>7102.5</TD>
            <TD>0.997359</TD>
          </TR>
          <TR>
            <TD>7105</TD>
            <TD>0.997379</TD>
          </TR>
          <TR>
            <TD>7107.5</TD>
            <TD>0.9974</TD>
          </TR>
          <TR>
            <TD>7110</TD>
            <TD>0.99742</TD>
          </TR>
          <TR>
            <TD>7112.5</TD>
            <TD>0.997385</TD>
          </TR>
          <TR>
            <TD>7115</TD>
            <TD>0.99735</TD>
          </TR>
          <TR>
            <TD>7117.5</TD>
            <TD>0.997314</TD>
          </TR>
          <TR>
            <TD>7120</TD>
            <TD>0.997278</TD>
          </TR>
          <TR>
            <TD>7122.5</TD>
            <TD>0.9972</TD>
          </TR>
          <TR>
            <TD>7125</TD>
            <TD>0.997123</TD>
          </TR>
          <TR>
            <TD>7127.5</TD>
            <TD>0.997044</TD>
          </TR>
          <TR>
            <TD>7130</TD>
            <TD>0.996966</TD>
          </TR>
          <TR>
            <TD>7132.5</TD>
            <TD>0.99697</TD>
          </TR>
          <TR>
            <TD>7135</TD>
            <TD>0.996973</TD>
          </TR>
          <TR>
            <TD>7137.5</TD>
            <TD>0.996976</TD>
          </TR>
          <TR>
            <TD>7140</TD>
            <TD>0.996979</TD>
          </TR>
          <TR>
            <TD>7142.5</TD>
            <TD>0.996678</TD>
          </TR>
          <TR>
            <TD>7145</TD>
            <TD>0.996375</TD>
          </TR>
          <TR>
            <TD>7147.5</TD>
            <TD>0.996073</TD>
          </TR>
          <TR>
            <TD>7150</TD>
            <TD>0.995769</TD>
          </TR>
          <TR>
            <TD>7152.5</TD>
            <TD>0.995747</TD>
          </TR>
          <TR>
            <TD>7155</TD>
            <TD>0.995725</TD>
          </TR>
          <TR>
            <TD>7157.5</TD>
            <TD>0.995702</TD>
          </TR>
          <TR>
            <TD>7160</TD>
            <TD>0.995679</TD>
          </TR>
          <TR>
            <TD>7162.5</TD>
            <TD>0.995646</TD>
          </TR>
          <TR>
            <TD>7165</TD>
            <TD>0.995614</TD>
          </TR>
          <TR>
            <TD>7167.5</TD>
            <TD>0.995581</TD>
          </TR>
          <TR>
            <TD>7170</TD>
            <TD>0.995547</TD>
          </TR>
          <TR>
            <TD>7172.5</TD>
            <TD>0.995234</TD>
          </TR>
          <TR>
            <TD>7175</TD>
            <TD>0.994921</TD>
          </TR>
          <TR>
            <TD>7177.5</TD>
            <TD>0.994607</TD>
          </TR>
          <TR>
            <TD>7180</TD>
            <TD>0.994293</TD>
          </TR>
          <TR>
            <TD>7182.5</TD>
            <TD>0.994126</TD>
          </TR>
          <TR>
            <TD>7185</TD>
            <TD>0.993958</TD>
          </TR>
          <TR>
            <TD>7187.5</TD>
            <TD>0.99379</TD>
          </TR>
          <TR>
            <TD>7190</TD>
            <TD>0.993622</TD>
          </TR>
          <TR>
            <TD>7192.5</TD>
            <TD>0.993912</TD>
          </TR>
          <TR>
            <TD>7195</TD>
            <TD>0.994202</TD>
          </TR>
          <TR>
            <TD>7197.5</TD>
            <TD>0.994491</TD>
          </TR>
          <TR>
            <TD>7200</TD>
            <TD>0.994781</TD>
          </TR>
          <TR>
            <TD>7202.5</TD>
            <TD>0.994246</TD>
          </TR>
          <TR>
            <TD>7205</TD>
            <TD>0.993711</TD>
          </TR>
          <TR>
            <TD>7207.5</TD>
            <TD>0.993175</TD>
          </TR>
          <TR>
            <TD>7210</TD>
            <TD>0.992639</TD>
          </TR>
          <TR>
            <TD>7212.5</TD>
            <TD>0.992415</TD>
          </TR>
          <TR>
            <TD>7215</TD>
            <TD>0.992191</TD>
          </TR>
          <TR>
            <TD>7217.5</TD>
            <TD>0.991967</TD>
          </TR>
          <TR>
            <TD>7220</TD>
            <TD>0.991742</TD>
          </TR>
          <TR>
            <TD>7222.5</TD>
            <TD>0.991449</TD>
          </TR>
          <TR>
            <TD>7225</TD>
            <TD>0.991155</TD>
          </TR>
          <TR>
            <TD>7227.5</TD>
            <TD>0.99086</TD>
          </TR>
          <TR>
            <TD>7230</TD>
            <TD>0.990566</TD>
          </TR>
          <TR>
            <TD>7232.5</TD>
            <TD>0.990812</TD>
          </TR>
          <TR>
            <TD>7235</TD>
            <TD>0.991059</TD>
          </TR>
          <TR>
            <TD>7237.5</TD>
            <TD>0.991306</TD>
          </TR>
          <TR>
            <TD>7240</TD>
            <TD>0.991552</TD>
          </TR>
          <TR>
            <TD>7242.5</TD>
            <TD>0.991141</TD>
          </TR>
          <TR>
            <TD>7245</TD>
            <TD>0.99073</TD>
          </TR>
          <TR>
            <TD>7247.5</TD>
            <TD>0.990318</TD>
          </TR>
          <TR>
            <TD>7250</TD>
            <TD>0.989906</TD>
          </TR>
          <TR>
            <TD>7252.5</TD>
            <TD>0.990205</TD>
          </TR>
          <TR>
            <TD>7255</TD>
            <TD>0.990504</TD>
          </TR>
          <TR>
            <TD>7257.5</TD>
            <TD>0.990802</TD>
          </TR>
          <TR>
            <TD>7260</TD>
            <TD>0.991101</TD>
          </TR>
          <TR>
            <TD>7262.5</TD>
            <TD>0.990735</TD>
          </TR>
          <TR>
            <TD>7265</TD>
            <TD>0.990369</TD>
          </TR>
          <TR>
            <TD>7267.5</TD>
            <TD>0.990003</TD>
          </TR>
          <TR>
            <TD>7270</TD>
            <TD>0.989636</TD>
          </TR>
          <TR>
            <TD>7272.5</TD>
            <TD>0.989126</TD>
          </TR>
          <TR>
            <TD>7275</TD>
            <TD>0.988614</TD>
          </TR>
          <TR>
            <TD>7277.5</TD>
            <TD>0.988103</TD>
          </TR>
          <TR>
            <TD>7280</TD>
            <TD>0.98759</TD>
          </TR>
          <TR>
            <TD>7282.5</TD>
            <TD>0.987388</TD>
          </TR>
          <TR>
            <TD>7285</TD>
            <TD>0.987186</TD>
          </TR>
          <TR>
            <TD>7287.5</TD>
            <TD>0.986983</TD>
          </TR>
          <TR>
            <TD>7290</TD>
            <TD>0.98678</TD>
          </TR>
          <TR>
            <TD>7292.5</TD>
            <TD>0.986424</TD>
          </TR>
          <TR>
            <TD>7295</TD>
            <TD>0.986068</TD>
          </TR>
          <TR>
            <TD>7297.5</TD>
            <TD>0.985712</TD>
          </TR>
          <TR>
            <TD>7300</TD>
            <TD>0.985355</TD>
          </TR>
          <TR>
            <TD>7302.5</TD>
            <TD>0.985446</TD>
          </TR>
          <TR>
            <TD>7305</TD>
            <TD>0.985538</TD>
          </TR>
          <TR>
            <TD>7307.5</TD>
            <TD>0.985629</TD>
          </TR>
          <TR>
            <TD>7310</TD>
            <TD>0.98572</TD>
          </TR>
          <TR>
            <TD>7312.5</TD>
            <TD>0.985426</TD>
          </TR>
          <TR>
            <TD>7315</TD>
            <TD>0.985131</TD>
          </TR>
          <TR>
            <TD>7317.5</TD>
            <TD>0.984836</TD>
          </TR>
          <TR>
            <TD>7320</TD>
            <TD>0.98454</TD>
          </TR>
          <TR>
            <TD>7322.5</TD>
            <TD>0.984436</TD>
          </TR>
          <TR>
            <TD>7325</TD>
            <TD>0.984331</TD>
          </TR>
          <TR>
            <TD>7327.5</TD>
            <TD>0.984226</TD>
          </TR>
          <TR>
            <TD>7330</TD>
            <TD>0.98412</TD>
          </TR>
          <TR>
            <TD>7332.5</TD>
            <TD>0.983919</TD>
          </TR>
          <TR>
            <TD>7335</TD>
            <TD>0.983717</TD>
          </TR>
          <TR>
            <TD>7337.5</TD>
            <TD>0.983514</TD>
          </TR>
          <TR>
            <TD>7340</TD>
            <TD>0.983311</TD>
          </TR>
          <TR>
            <TD>7342.5</TD>
            <TD>0.983067</TD>
          </TR>
          <TR>
            <TD>7345</TD>
            <TD>0.982823</TD>
          </TR>
          <TR>
            <TD>7347.5</TD>
            <TD>0.982578</TD>
          </TR>
          <TR>
            <TD>7350</TD>
            <TD>0.982332</TD>
          </TR>
          <TR>
            <TD>7352.5</TD>
            <TD>0.98182</TD>
          </TR>
          <TR>
            <TD>7355</TD>
            <TD>0.981307</TD>
          </TR>
          <TR>
            <TD>7357.5</TD>
            <TD>0.980794</TD>
          </TR>
          <TR>
            <TD>7360</TD>
            <TD>0.98028</TD>
          </TR>
          <TR>
            <TD>7362.5</TD>
            <TD>0.979931</TD>
          </TR>
          <TR>
            <TD>7365</TD>
            <TD>0.979581</TD>
          </TR>
          <TR>
            <TD>7367.5</TD>
            <TD>0.979232</TD>
          </TR>
          <TR>
            <TD>7370</TD>
            <TD>0.978881</TD>
          </TR>
          <TR>
            <TD>7372.5</TD>
            <TD>0.978854</TD>
          </TR>
          <TR>
            <TD>7375</TD>
            <TD>0.978827</TD>
          </TR>
          <TR>
            <TD>7377.5</TD>
            <TD>0.978799</TD>
          </TR>
          <TR>
            <TD>7380</TD>
            <TD>0.978771</TD>
          </TR>
          <TR>
            <TD>7382.5</TD>
            <TD>0.978694</TD>
          </TR>
          <TR>
            <TD>7385</TD>
            <TD>0.978617</TD>
          </TR>
          <TR>
            <TD>7387.5</TD>
            <TD>0.978539</TD>
          </TR>
          <TR>
            <TD>7390</TD>
            <TD>0.978462</TD>
          </TR>
          <TR>
            <TD>7392.5</TD>
            <TD>0.978173</TD>
          </TR>
          <TR>
            <TD>7395</TD>
            <TD>0.977884</TD>
          </TR>
          <TR>
            <TD>7397.5</TD>
            <TD>0.977595</TD>
          </TR>
          <TR>
            <TD>7400</TD>
            <TD>0.977305</TD>
          </TR>
          <TR>
            <TD>7402.5</TD>
            <TD>0.976868</TD>
          </TR>
          <TR>
            <TD>7405</TD>
            <TD>0.976429</TD>
          </TR>
          <TR>
            <TD>7407.5</TD>
            <TD>0.975991</TD>
          </TR>
          <TR>
            <TD>7410</TD>
            <TD>0.975552</TD>
          </TR>
          <TR>
            <TD>7412.5</TD>
            <TD>0.975178</TD>
          </TR>
          <TR>
            <TD>7415</TD>
            <TD>0.974804</TD>
          </TR>
          <TR>
            <TD>7417.5</TD>
            <TD>0.974429</TD>
          </TR>
          <TR>
            <TD>7420</TD>
            <TD>0.974054</TD>
          </TR>
          <TR>
            <TD>7422.5</TD>
            <TD>0.973865</TD>
          </TR>
          <TR>
            <TD>7425</TD>
            <TD>0.973675</TD>
          </TR>
          <TR>
            <TD>7427.5</TD>
            <TD>0.973484</TD>
          </TR>
          <TR>
            <TD>7430</TD>
            <TD>0.973294</TD>
          </TR>
          <TR>
            <TD>7432.5</TD>
            <TD>0.972838</TD>
          </TR>
          <TR>
            <TD>7435</TD>
            <TD>0.972383</TD>
          </TR>
          <TR>
            <TD>7437.5</TD>
            <TD>0.971927</TD>
          </TR>
          <TR>
            <TD>7440</TD>
            <TD>0.97147</TD>
          </TR>
          <TR>
            <TD>7442.5</TD>
            <TD>0.971313</TD>
          </TR>
          <TR>
            <TD>7445</TD>
            <TD>0.971156</TD>
          </TR>
          <TR>
            <TD>7447.5</TD>
            <TD>0.970999</TD>
          </TR>
          <TR>
            <TD>7450</TD>
            <TD>0.970842</TD>
          </TR>
          <TR>
            <TD>7452.5</TD>
            <TD>0.970292</TD>
          </TR>
          <TR>
            <TD>7455</TD>
            <TD>0.969743</TD>
          </TR>
          <TR>
            <TD>7457.5</TD>
            <TD>0.969193</TD>
          </TR>
          <TR>
            <TD>7460</TD>
            <TD>0.968642</TD>
          </TR>
          <TR>
            <TD>7462.5</TD>
            <TD>0.968288</TD>
          </TR>
          <TR>
            <TD>7465</TD>
            <TD>0.967933</TD>
          </TR>
          <TR>
            <TD>7467.5</TD>
            <TD>0.967577</TD>
          </TR>
          <TR>
            <TD>7470</TD>
            <TD>0.967222</TD>
          </TR>
          <TR>
            <TD>7472.5</TD>
            <TD>0.967203</TD>
          </TR>
          <TR>
            <TD>7475</TD>
            <TD>0.967184</TD>
          </TR>
          <TR>
            <TD>7477.5</TD>
            <TD>0.967164</TD>
          </TR>
          <TR>
            <TD>7480</TD>
            <TD>0.967145</TD>
          </TR>
          <TR>
            <TD>7482.5</TD>
            <TD>0.96675</TD>
          </TR>
          <TR>
            <TD>7485</TD>
            <TD>0.966355</TD>
          </TR>
          <TR>
            <TD>7487.5</TD>
            <TD>0.965959</TD>
          </TR>
          <TR>
            <TD>7490</TD>
            <TD>0.965563</TD>
          </TR>
          <TR>
            <TD>7492.5</TD>
            <TD>0.96507</TD>
          </TR>
          <TR>
            <TD>7495</TD>
            <TD>0.964577</TD>
          </TR>
          <TR>
            <TD>7497.5</TD>
            <TD>0.964083</TD>
          </TR>
          <TR>
            <TD>7500</TD>
            <TD>0.963589</TD>
          </TR>
          <TR>
            <TD>7502.5</TD>
            <TD>0.963339</TD>
          </TR>
          <TR>
            <TD>7505</TD>
            <TD>0.963088</TD>
          </TR>
          <TR>
            <TD>7507.5</TD>
            <TD>0.962838</TD>
          </TR>
          <TR>
            <TD>7510</TD>
            <TD>0.962587</TD>
          </TR>
          <TR>
            <TD>7512.5</TD>
            <TD>0.962375</TD>
          </TR>
          <TR>
            <TD>7515</TD>
            <TD>0.962162</TD>
          </TR>
          <TR>
            <TD>7517.5</TD>
            <TD>0.96195</TD>
          </TR>
          <TR>
            <TD>7520</TD>
            <TD>0.961736</TD>
          </TR>
          <TR>
            <TD>7522.5</TD>
            <TD>0.961034</TD>
          </TR>
          <TR>
            <TD>7525</TD>
            <TD>0.96033</TD>
          </TR>
          <TR>
            <TD>7527.5</TD>
            <TD>0.959626</TD>
          </TR>
          <TR>
            <TD>7530</TD>
            <TD>0.958921</TD>
          </TR>
          <TR>
            <TD>7532.5</TD>
            <TD>0.958505</TD>
          </TR>
          <TR>
            <TD>7535</TD>
            <TD>0.958089</TD>
          </TR>
          <TR>
            <TD>7537.5</TD>
            <TD>0.957672</TD>
          </TR>
          <TR>
            <TD>7540</TD>
            <TD>0.957254</TD>
          </TR>
          <TR>
            <TD>7542.5</TD>
            <TD>0.957219</TD>
          </TR>
          <TR>
            <TD>7545</TD>
            <TD>0.957183</TD>
          </TR>
          <TR>
            <TD>7547.5</TD>
            <TD>0.957148</TD>
          </TR>
          <TR>
            <TD>7550</TD>
            <TD>0.957112</TD>
          </TR>
          <TR>
            <TD>7552.5</TD>
            <TD>0.956681</TD>
          </TR>
          <TR>
            <TD>7555</TD>
            <TD>0.956249</TD>
          </TR>
          <TR>
            <TD>7557.5</TD>
            <TD>0.955817</TD>
          </TR>
          <TR>
            <TD>7560</TD>
            <TD>0.955385</TD>
          </TR>
          <TR>
            <TD>7562.5</TD>
            <TD>0.955049</TD>
          </TR>
          <TR>
            <TD>7565</TD>
            <TD>0.954713</TD>
          </TR>
          <TR>
            <TD>7567.5</TD>
            <TD>0.954377</TD>
          </TR>
          <TR>
            <TD>7570</TD>
            <TD>0.95404</TD>
          </TR>
          <TR>
            <TD>7572.5</TD>
            <TD>0.953568</TD>
          </TR>
          <TR>
            <TD>7575</TD>
            <TD>0.953095</TD>
          </TR>
          <TR>
            <TD>7577.5</TD>
            <TD>0.952622</TD>
          </TR>
          <TR>
            <TD>7580</TD>
            <TD>0.952148</TD>
          </TR>
          <TR>
            <TD>7582.5</TD>
            <TD>0.951838</TD>
          </TR>
          <TR>
            <TD>7585</TD>
            <TD>0.951527</TD>
          </TR>
          <TR>
            <TD>7587.5</TD>
            <TD>0.951216</TD>
          </TR>
          <TR>
            <TD>7590</TD>
            <TD>0.950904</TD>
          </TR>
          <TR>
            <TD>7592.5</TD>
            <TD>0.950171</TD>
          </TR>
          <TR>
            <TD>7595</TD>
            <TD>0.949436</TD>
          </TR>
          <TR>
            <TD>7597.5</TD>
            <TD>0.948701</TD>
          </TR>
          <TR>
            <TD>7600</TD>
            <TD>0.947966</TD>
          </TR>
          <TR>
            <TD>7602.5</TD>
            <TD>0.947625</TD>
          </TR>
          <TR>
            <TD>7605</TD>
            <TD>0.947284</TD>
          </TR>
          <TR>
            <TD>7607.5</TD>
            <TD>0.946943</TD>
          </TR>
          <TR>
            <TD>7610</TD>
            <TD>0.946601</TD>
          </TR>
          <TR>
            <TD>7612.5</TD>
            <TD>0.946382</TD>
          </TR>
          <TR>
            <TD>7615</TD>
            <TD>0.946163</TD>
          </TR>
          <TR>
            <TD>7617.5</TD>
            <TD>0.945943</TD>
          </TR>
          <TR>
            <TD>7620</TD>
            <TD>0.945722</TD>
          </TR>
          <TR>
            <TD>7622.5</TD>
            <TD>0.945318</TD>
          </TR>
          <TR>
            <TD>7625</TD>
            <TD>0.944914</TD>
          </TR>
          <TR>
            <TD>7627.5</TD>
            <TD>0.944509</TD>
          </TR>
          <TR>
            <TD>7630</TD>
            <TD>0.944103</TD>
          </TR>
          <TR>
            <TD>7632.5</TD>
            <TD>0.943792</TD>
          </TR>
          <TR>
            <TD>7635</TD>
            <TD>0.943481</TD>
          </TR>
          <TR>
            <TD>7637.5</TD>
            <TD>0.94317</TD>
          </TR>
          <TR>
            <TD>7640</TD>
            <TD>0.942858</TD>
          </TR>
          <TR>
            <TD>7642.5</TD>
            <TD>0.942422</TD>
          </TR>
          <TR>
            <TD>7645</TD>
            <TD>0.941985</TD>
          </TR>
          <TR>
            <TD>7647.5</TD>
            <TD>0.941548</TD>
          </TR>
          <TR>
            <TD>7650</TD>
            <TD>0.941111</TD>
          </TR>
          <TR>
            <TD>7652.5</TD>
            <TD>0.940564</TD>
          </TR>
          <TR>
            <TD>7655</TD>
            <TD>0.940016</TD>
          </TR>
          <TR>
            <TD>7657.5</TD>
            <TD>0.939468</TD>
          </TR>
          <TR>
            <TD>7660</TD>
            <TD>0.938919</TD>
          </TR>
          <TR>
            <TD>7662.5</TD>
            <TD>0.938162</TD>
          </TR>
          <TR>
            <TD>7665</TD>
            <TD>0.937404</TD>
          </TR>
          <TR>
            <TD>7667.5</TD>
            <TD>0.936646</TD>
          </TR>
          <TR>
            <TD>7670</TD>
            <TD>0.935887</TD>
          </TR>
          <TR>
            <TD>7672.5</TD>
            <TD>0.935717</TD>
          </TR>
          <TR>
            <TD>7675</TD>
            <TD>0.935547</TD>
          </TR>
          <TR>
            <TD>7677.5</TD>
            <TD>0.935377</TD>
          </TR>
          <TR>
            <TD>7680</TD>
            <TD>0.935206</TD>
          </TR>
          <TR>
            <TD>7682.5</TD>
            <TD>0.934355</TD>
          </TR>
          <TR>
            <TD>7685</TD>
            <TD>0.933503</TD>
          </TR>
          <TR>
            <TD>7687.5</TD>
            <TD>0.93265</TD>
          </TR>
          <TR>
            <TD>7690</TD>
            <TD>0.931796</TD>
          </TR>
          <TR>
            <TD>7692.5</TD>
            <TD>0.931207</TD>
          </TR>
          <TR>
            <TD>7695</TD>
            <TD>0.930617</TD>
          </TR>
          <TR>
            <TD>7697.5</TD>
            <TD>0.930027</TD>
          </TR>
          <TR>
            <TD>7700</TD>
            <TD>0.929436</TD>
          </TR>
          <TR>
            <TD>7702.5</TD>
            <TD>0.92913</TD>
          </TR>
          <TR>
            <TD>7705</TD>
            <TD>0.928823</TD>
          </TR>
          <TR>
            <TD>7707.5</TD>
            <TD>0.928517</TD>
          </TR>
          <TR>
            <TD>7710</TD>
            <TD>0.928209</TD>
          </TR>
          <TR>
            <TD>7712.5</TD>
            <TD>0.927584</TD>
          </TR>
          <TR>
            <TD>7715</TD>
            <TD>0.926957</TD>
          </TR>
          <TR>
            <TD>7717.5</TD>
            <TD>0.92633</TD>
          </TR>
          <TR>
            <TD>7720</TD>
            <TD>0.925703</TD>
          </TR>
          <TR>
            <TD>7722.5</TD>
            <TD>0.925163</TD>
          </TR>
          <TR>
            <TD>7725</TD>
            <TD>0.924622</TD>
          </TR>
          <TR>
            <TD>7727.5</TD>
            <TD>0.924081</TD>
          </TR>
          <TR>
            <TD>7730</TD>
            <TD>0.923539</TD>
          </TR>
          <TR>
            <TD>7732.5</TD>
            <TD>0.923282</TD>
          </TR>
          <TR>
            <TD>7735</TD>
            <TD>0.923026</TD>
          </TR>
          <TR>
            <TD>7737.5</TD>
            <TD>0.922769</TD>
          </TR>
          <TR>
            <TD>7740</TD>
            <TD>0.922512</TD>
          </TR>
          <TR>
            <TD>7742.5</TD>
            <TD>0.921939</TD>
          </TR>
          <TR>
            <TD>7745</TD>
            <TD>0.921367</TD>
          </TR>
          <TR>
            <TD>7747.5</TD>
            <TD>0.920793</TD>
          </TR>
          <TR>
            <TD>7750</TD>
            <TD>0.920219</TD>
          </TR>
          <TR>
            <TD>7752.5</TD>
            <TD>0.91963</TD>
          </TR>
          <TR>
            <TD>7755</TD>
            <TD>0.91904</TD>
          </TR>
          <TR>
            <TD>7757.5</TD>
            <TD>0.91845</TD>
          </TR>
          <TR>
            <TD>7760</TD>
            <TD>0.917859</TD>
          </TR>
          <TR>
            <TD>7762.5</TD>
            <TD>0.916984</TD>
          </TR>
          <TR>
            <TD>7765</TD>
            <TD>0.916108</TD>
          </TR>
          <TR>
            <TD>7767.5</TD>
            <TD>0.915231</TD>
          </TR>
          <TR>
            <TD>7770</TD>
            <TD>0.914354</TD>
          </TR>
          <TR>
            <TD>7772.5</TD>
            <TD>0.91399</TD>
          </TR>
          <TR>
            <TD>7775</TD>
            <TD>0.913625</TD>
          </TR>
          <TR>
            <TD>7777.5</TD>
            <TD>0.91326</TD>
          </TR>
          <TR>
            <TD>7780</TD>
            <TD>0.912895</TD>
          </TR>
          <TR>
            <TD>7782.5</TD>
            <TD>0.912659</TD>
          </TR>
          <TR>
            <TD>7785</TD>
            <TD>0.912424</TD>
          </TR>
          <TR>
            <TD>7787.5</TD>
            <TD>0.912188</TD>
          </TR>
          <TR>
            <TD>7790</TD>
            <TD>0.911952</TD>
          </TR>
          <TR>
            <TD>7792.5</TD>
            <TD>0.910953</TD>
          </TR>
          <TR>
            <TD>7795</TD>
            <TD>0.909953</TD>
          </TR>
          <TR>
            <TD>7797.5</TD>
            <TD>0.908952</TD>
          </TR>
          <TR>
            <TD>7800</TD>
            <TD>0.90795</TD>
          </TR>
          <TR>
            <TD>7802.5</TD>
            <TD>0.907375</TD>
          </TR>
          <TR>
            <TD>7805</TD>
            <TD>0.9068</TD>
          </TR>
          <TR>
            <TD>7807.5</TD>
            <TD>0.906224</TD>
          </TR>
          <TR>
            <TD>7810</TD>
            <TD>0.905647</TD>
          </TR>
          <TR>
            <TD>7812.5</TD>
            <TD>0.905494</TD>
          </TR>
          <TR>
            <TD>7815</TD>
            <TD>0.90534</TD>
          </TR>
          <TR>
            <TD>7817.5</TD>
            <TD>0.905186</TD>
          </TR>
          <TR>
            <TD>7820</TD>
            <TD>0.905032</TD>
          </TR>
          <TR>
            <TD>7822.5</TD>
            <TD>0.904518</TD>
          </TR>
          <TR>
            <TD>7825</TD>
            <TD>0.904005</TD>
          </TR>
          <TR>
            <TD>7827.5</TD>
            <TD>0.90349</TD>
          </TR>
          <TR>
            <TD>7830</TD>
            <TD>0.902976</TD>
          </TR>
          <TR>
            <TD>7832.5</TD>
            <TD>0.902005</TD>
          </TR>
          <TR>
            <TD>7835</TD>
            <TD>0.901034</TD>
          </TR>
          <TR>
            <TD>7837.5</TD>
            <TD>0.900061</TD>
          </TR>
          <TR>
            <TD>7840</TD>
            <TD>0.899088</TD>
          </TR>
          <TR>
            <TD>7842.5</TD>
            <TD>0.898378</TD>
          </TR>
          <TR>
            <TD>7845</TD>
            <TD>0.897667</TD>
          </TR>
          <TR>
            <TD>7847.5</TD>
            <TD>0.896955</TD>
          </TR>
          <TR>
            <TD>7850</TD>
            <TD>0.896243</TD>
          </TR>
          <TR>
            <TD>7852.5</TD>
            <TD>0.895679</TD>
          </TR>
          <TR>
            <TD>7855</TD>
            <TD>0.895116</TD>
          </TR>
          <TR>
            <TD>7857.5</TD>
            <TD>0.894552</TD>
          </TR>
          <TR>
            <TD>7860</TD>
            <TD>0.893987</TD>
          </TR>
          <TR>
            <TD>7862.5</TD>
            <TD>0.893362</TD>
          </TR>
          <TR>
            <TD>7865</TD>
            <TD>0.892738</TD>
          </TR>
          <TR>
            <TD>7867.5</TD>
            <TD>0.892112</TD>
          </TR>
          <TR>
            <TD>7870</TD>
            <TD>0.891486</TD>
          </TR>
          <TR>
            <TD>7872.5</TD>
            <TD>0.890942</TD>
          </TR>
          <TR>
            <TD>7875</TD>
            <TD>0.890397</TD>
          </TR>
          <TR>
            <TD>7877.5</TD>
            <TD>0.889851</TD>
          </TR>
          <TR>
            <TD>7880</TD>
            <TD>0.889305</TD>
          </TR>
          <TR>
            <TD>7882.5</TD>
            <TD>0.888789</TD>
          </TR>
          <TR>
            <TD>7885</TD>
            <TD>0.888272</TD>
          </TR>
          <TR>
            <TD>7887.5</TD>
            <TD>0.887754</TD>
          </TR>
          <TR>
            <TD>7890</TD>
            <TD>0.887236</TD>
          </TR>
          <TR>
            <TD>7892.5</TD>
            <TD>0.886489</TD>
          </TR>
          <TR>
            <TD>7895</TD>
            <TD>0.885741</TD>
          </TR>
          <TR>
            <TD>7897.5</TD>
            <TD>0.884993</TD>
          </TR>
          <TR>
            <TD>7900</TD>
            <TD>0.884244</TD>
          </TR>
          <TR>
            <TD>7902.5</TD>
            <TD>0.88362</TD>
          </TR>
          <TR>
            <TD>7905</TD>
            <TD>0.882996</TD>
          </TR>
          <TR>
            <TD>7907.5</TD>
            <TD>0.882371</TD>
          </TR>
          <TR>
            <TD>7910</TD>
            <TD>0.881746</TD>
          </TR>
          <TR>
            <TD>7912.5</TD>
            <TD>0.881249</TD>
          </TR>
          <TR>
            <TD>7915</TD>
            <TD>0.880752</TD>
          </TR>
          <TR>
            <TD>7917.5</TD>
            <TD>0.880255</TD>
          </TR>
          <TR>
            <TD>7920</TD>
            <TD>0.879757</TD>
          </TR>
          <TR>
            <TD>7922.5</TD>
            <TD>0.879179</TD>
          </TR>
          <TR>
            <TD>7925</TD>
            <TD>0.878601</TD>
          </TR>
          <TR>
            <TD>7927.5</TD>
            <TD>0.878022</TD>
          </TR>
          <TR>
            <TD>7930</TD>
            <TD>0.877442</TD>
          </TR>
          <TR>
            <TD>7932.5</TD>
            <TD>0.876636</TD>
          </TR>
          <TR>
            <TD>7935</TD>
            <TD>0.87583</TD>
          </TR>
          <TR>
            <TD>7937.5</TD>
            <TD>0.875023</TD>
          </TR>
          <TR>
            <TD>7940</TD>
            <TD>0.874215</TD>
          </TR>
          <TR>
            <TD>7942.5</TD>
            <TD>0.873345</TD>
          </TR>
          <TR>
            <TD>7945</TD>
            <TD>0.872475</TD>
          </TR>
          <TR>
            <TD>7947.5</TD>
            <TD>0.871603</TD>
          </TR>
          <TR>
            <TD>7950</TD>
            <TD>0.870731</TD>
          </TR>
          <TR>
            <TD>7952.5</TD>
            <TD>0.870058</TD>
          </TR>
          <TR>
            <TD>7955</TD>
            <TD>0.869384</TD>
          </TR>
          <TR>
            <TD>7957.5</TD>
            <TD>0.86871</TD>
          </TR>
          <TR>
            <TD>7960</TD>
            <TD>0.868035</TD>
          </TR>
          <TR>
            <TD>7962.5</TD>
            <TD>0.867351</TD>
          </TR>
          <TR>
            <TD>7965</TD>
            <TD>0.866667</TD>
          </TR>
          <TR>
            <TD>7967.5</TD>
            <TD>0.865982</TD>
          </TR>
          <TR>
            <TD>7970</TD>
            <TD>0.865297</TD>
          </TR>
          <TR>
            <TD>7972.5</TD>
            <TD>0.864704</TD>
          </TR>
          <TR>
            <TD>7975</TD>
            <TD>0.86411</TD>
          </TR>
          <TR>
            <TD>7977.5</TD>
            <TD>0.863516</TD>
          </TR>
          <TR>
            <TD>7980</TD>
            <TD>0.862921</TD>
          </TR>
          <TR>
            <TD>7982.5</TD>
            <TD>0.862046</TD>
          </TR>
          <TR>
            <TD>7985</TD>
            <TD>0.861171</TD>
          </TR>
          <TR>
            <TD>7987.5</TD>
            <TD>0.860295</TD>
          </TR>
          <TR>
            <TD>7990</TD>
            <TD>0.859418</TD>
          </TR>
          <TR>
            <TD>7992.5</TD>
            <TD>0.858579</TD>
          </TR>
          <TR>
            <TD>7995</TD>
            <TD>0.85774</TD>
          </TR>
          <TR>
            <TD>7997.5</TD>
            <TD>0.8569</TD>
          </TR>
          <TR>
            <TD>8000</TD>
            <TD>0.85606</TD>
          </TR>
          <TR>
            <TD>8002.5</TD>
            <TD>0.855228</TD>
          </TR>
          <TR>
            <TD>8005</TD>
            <TD>0.854395</TD>
          </TR>
          <TR>
            <TD>8007.5</TD>
            <TD>0.853562</TD>
          </TR>
          <TR>
            <TD>8010</TD>
            <TD>0.852728</TD>
          </TR>
          <TR>
            <TD>8012.5</TD>
            <TD>0.852103</TD>
          </TR>
          <TR>
            <TD>8015</TD>
            <TD>0.851478</TD>
          </TR>
          <TR>
            <TD>8017.5</TD>
            <TD>0.850852</TD>
          </TR>
          <TR>
            <TD>8020</TD>
            <TD>0.850226</TD>
          </TR>
          <TR>
            <TD>8022.5</TD>
            <TD>0.849675</TD>
          </TR>
          <TR>
            <TD>8025</TD>
            <TD>0.849124</TD>
          </TR>
          <TR>
            <TD>8027.5</TD>
            <TD>0.848572</TD>
          </TR>
          <TR>
            <TD>8030</TD>
            <TD>0.848019</TD>
          </TR>
          <TR>
            <TD>8032.5</TD>
            <TD>0.847211</TD>
          </TR>
          <TR>
            <TD>8035</TD>
            <TD>0.846402</TD>
          </TR>
          <TR>
            <TD>8037.5</TD>
            <TD>0.845592</TD>
          </TR>
          <TR>
            <TD>8040</TD>
            <TD>0.844781</TD>
          </TR>
          <TR>
            <TD>8042.5</TD>
            <TD>0.843872</TD>
          </TR>
          <TR>
            <TD>8045</TD>
            <TD>0.842963</TD>
          </TR>
          <TR>
            <TD>8047.5</TD>
            <TD>0.842052</TD>
          </TR>
          <TR>
            <TD>8050</TD>
            <TD>0.841141</TD>
          </TR>
          <TR>
            <TD>8052.5</TD>
            <TD>0.840199</TD>
          </TR>
          <TR>
            <TD>8055</TD>
            <TD>0.839256</TD>
          </TR>
          <TR>
            <TD>8057.5</TD>
            <TD>0.838312</TD>
          </TR>
          <TR>
            <TD>8060</TD>
            <TD>0.837367</TD>
          </TR>
          <TR>
            <TD>8062.5</TD>
            <TD>0.836688</TD>
          </TR>
          <TR>
            <TD>8065</TD>
            <TD>0.836009</TD>
          </TR>
          <TR>
            <TD>8067.5</TD>
            <TD>0.835329</TD>
          </TR>
          <TR>
            <TD>8070</TD>
            <TD>0.834648</TD>
          </TR>
          <TR>
            <TD>8072.5</TD>
            <TD>0.833752</TD>
          </TR>
          <TR>
            <TD>8075</TD>
            <TD>0.832856</TD>
          </TR>
          <TR>
            <TD>8077.5</TD>
            <TD>0.831959</TD>
          </TR>
          <TR>
            <TD>8080</TD>
            <TD>0.831061</TD>
          </TR>
          <TR>
            <TD>8082.5</TD>
            <TD>0.8304</TD>
          </TR>
          <TR>
            <TD>8085</TD>
            <TD>0.82974</TD>
          </TR>
          <TR>
            <TD>8087.5</TD>
            <TD>0.829078</TD>
          </TR>
          <TR>
            <TD>8090</TD>
            <TD>0.828416</TD>
          </TR>
          <TR>
            <TD>8092.5</TD>
            <TD>0.82757</TD>
          </TR>
          <TR>
            <TD>8095</TD>
            <TD>0.826723</TD>
          </TR>
          <TR>
            <TD>8097.5</TD>
            <TD>0.825875</TD>
          </TR>
          <TR>
            <TD>8100</TD>
            <TD>0.825027</TD>
          </TR>
          <TR>
            <TD>8102.5</TD>
            <TD>0.824341</TD>
          </TR>
          <TR>
            <TD>8105</TD>
            <TD>0.823654</TD>
          </TR>
          <TR>
            <TD>8107.5</TD>
            <TD>0.822967</TD>
          </TR>
          <TR>
            <TD>8110</TD>
            <TD>0.822279</TD>
          </TR>
          <TR>
            <TD>8112.5</TD>
            <TD>0.821267</TD>
          </TR>
          <TR>
            <TD>8115</TD>
            <TD>0.820255</TD>
          </TR>
          <TR>
            <TD>8117.5</TD>
            <TD>0.819243</TD>
          </TR>
          <TR>
            <TD>8120</TD>
            <TD>0.818229</TD>
          </TR>
          <TR>
            <TD>8122.5</TD>
            <TD>0.81795</TD>
          </TR>
          <TR>
            <TD>8125</TD>
            <TD>0.817671</TD>
          </TR>
          <TR>
            <TD>8127.5</TD>
            <TD>0.817391</TD>
          </TR>
          <TR>
            <TD>8130</TD>
            <TD>0.817111</TD>
          </TR>
          <TR>
            <TD>8132.5</TD>
            <TD>0.816363</TD>
          </TR>
          <TR>
            <TD>8135</TD>
            <TD>0.815614</TD>
          </TR>
          <TR>
            <TD>8137.5</TD>
            <TD>0.814865</TD>
          </TR>
          <TR>
            <TD>8140</TD>
            <TD>0.814115</TD>
          </TR>
          <TR>
            <TD>8142.5</TD>
            <TD>0.813216</TD>
          </TR>
          <TR>
            <TD>8145</TD>
            <TD>0.812317</TD>
          </TR>
          <TR>
            <TD>8147.5</TD>
            <TD>0.811416</TD>
          </TR>
          <TR>
            <TD>8150</TD>
            <TD>0.810515</TD>
          </TR>
          <TR>
            <TD>8152.5</TD>
            <TD>0.809314</TD>
          </TR>
          <TR>
            <TD>8155</TD>
            <TD>0.808112</TD>
          </TR>
          <TR>
            <TD>8157.5</TD>
            <TD>0.80691</TD>
          </TR>
          <TR>
            <TD>8160</TD>
            <TD>0.805706</TD>
          </TR>
          <TR>
            <TD>8162.5</TD>
            <TD>0.804847</TD>
          </TR>
          <TR>
            <TD>8165</TD>
            <TD>0.803987</TD>
          </TR>
          <TR>
            <TD>8167.5</TD>
            <TD>0.803127</TD>
          </TR>
          <TR>
            <TD>8170</TD>
            <TD>0.802266</TD>
          </TR>
          <TR>
            <TD>8172.5</TD>
            <TD>0.801577</TD>
          </TR>
          <TR>
            <TD>8175</TD>
            <TD>0.800887</TD>
          </TR>
          <TR>
            <TD>8177.5</TD>
            <TD>0.800197</TD>
          </TR>
          <TR>
            <TD>8180</TD>
            <TD>0.799506</TD>
          </TR>
          <TR>
            <TD>8182.5</TD>
            <TD>0.798574</TD>
          </TR>
          <TR>
            <TD>8185</TD>
            <TD>0.797641</TD>
          </TR>
          <TR>
            <TD>8187.5</TD>
            <TD>0.796708</TD>
          </TR>
          <TR>
            <TD>8190</TD>
            <TD>0.795774</TD>
          </TR>
          <TR>
            <TD>8192.5</TD>
            <TD>0.794757</TD>
          </TR>
          <TR>
            <TD>8195</TD>
            <TD>0.79374</TD>
          </TR>
          <TR>
            <TD>8197.5</TD>
            <TD>0.792721</TD>
          </TR>
          <TR>
            <TD>8200</TD>
            <TD>0.791702</TD>
          </TR>
          <TR>
            <TD>8202.5</TD>
            <TD>0.790822</TD>
          </TR>
          <TR>
            <TD>8205</TD>
            <TD>0.789942</TD>
          </TR>
          <TR>
            <TD>8207.5</TD>
            <TD>0.789061</TD>
          </TR>
          <TR>
            <TD>8210</TD>
            <TD>0.788179</TD>
          </TR>
          <TR>
            <TD>8212.5</TD>
            <TD>0.787504</TD>
          </TR>
          <TR>
            <TD>8215</TD>
            <TD>0.786828</TD>
          </TR>
          <TR>
            <TD>8217.5</TD>
            <TD>0.786152</TD>
          </TR>
          <TR>
            <TD>8220</TD>
            <TD>0.785475</TD>
          </TR>
          <TR>
            <TD>8222.5</TD>
            <TD>0.784583</TD>
          </TR>
          <TR>
            <TD>8225</TD>
            <TD>0.78369</TD>
          </TR>
          <TR>
            <TD>8227.5</TD>
            <TD>0.782796</TD>
          </TR>
          <TR>
            <TD>8230</TD>
            <TD>0.781902</TD>
          </TR>
          <TR>
            <TD>8232.5</TD>
            <TD>0.781112</TD>
          </TR>
          <TR>
            <TD>8235</TD>
            <TD>0.780322</TD>
          </TR>
          <TR>
            <TD>8237.5</TD>
            <TD>0.779531</TD>
          </TR>
          <TR>
            <TD>8240</TD>
            <TD>0.77874</TD>
          </TR>
          <TR>
            <TD>8242.5</TD>
            <TD>0.777641</TD>
          </TR>
          <TR>
            <TD>8245</TD>
            <TD>0.776542</TD>
          </TR>
          <TR>
            <TD>8247.5</TD>
            <TD>0.775442</TD>
          </TR>
          <TR>
            <TD>8250</TD>
            <TD>0.774341</TD>
          </TR>
          <TR>
            <TD>8252.5</TD>
            <TD>0.773381</TD>
          </TR>
          <TR>
            <TD>8255</TD>
            <TD>0.77242</TD>
          </TR>
          <TR>
            <TD>8257.5</TD>
            <TD>0.771458</TD>
          </TR>
          <TR>
            <TD>8260</TD>
            <TD>0.770495</TD>
          </TR>
          <TR>
            <TD>8262.5</TD>
            <TD>0.769686</TD>
          </TR>
          <TR>
            <TD>8265</TD>
            <TD>0.768876</TD>
          </TR>
          <TR>
            <TD>8267.5</TD>
            <TD>0.768066</TD>
          </TR>
          <TR>
            <TD>8270</TD>
            <TD>0.767255</TD>
          </TR>
          <TR>
            <TD>8272.5</TD>
            <TD>0.766199</TD>
          </TR>
          <TR>
            <TD>8275</TD>
            <TD>0.765141</TD>
          </TR>
          <TR>
            <TD>8277.5</TD>
            <TD>0.764084</TD>
          </TR>
          <TR>
            <TD>8280</TD>
            <TD>0.763025</TD>
          </TR>
          <TR>
            <TD>8282.5</TD>
            <TD>0.76207</TD>
          </TR>
          <TR>
            <TD>8285</TD>
            <TD>0.761115</TD>
          </TR>
          <TR>
            <TD>8287.5</TD>
            <TD>0.760159</TD>
          </TR>
          <TR>
            <TD>8290</TD>
            <TD>0.759202</TD>
          </TR>
          <TR>
            <TD>8292.5</TD>
            <TD>0.758523</TD>
          </TR>
          <TR>
            <TD>8295</TD>
            <TD>0.757843</TD>
          </TR>
          <TR>
            <TD>8297.5</TD>
            <TD>0.757162</TD>
          </TR>
          <TR>
            <TD>8300</TD>
            <TD>0.756481</TD>
          </TR>
          <TR>
            <TD>8302.5</TD>
            <TD>0.755614</TD>
          </TR>
          <TR>
            <TD>8305</TD>
            <TD>0.754746</TD>
          </TR>
          <TR>
            <TD>8307.5</TD>
            <TD>0.753878</TD>
          </TR>
          <TR>
            <TD>8310</TD>
            <TD>0.753009</TD>
          </TR>
          <TR>
            <TD>8312.5</TD>
            <TD>0.752088</TD>
          </TR>
          <TR>
            <TD>8315</TD>
            <TD>0.751166</TD>
          </TR>
          <TR>
            <TD>8317.5</TD>
            <TD>0.750244</TD>
          </TR>
          <TR>
            <TD>8320</TD>
            <TD>0.749321</TD>
          </TR>
          <TR>
            <TD>8322.5</TD>
            <TD>0.748464</TD>
          </TR>
          <TR>
            <TD>8325</TD>
            <TD>0.747606</TD>
          </TR>
          <TR>
            <TD>8327.5</TD>
            <TD>0.746748</TD>
          </TR>
          <TR>
            <TD>8330</TD>
            <TD>0.745889</TD>
          </TR>
          <TR>
            <TD>8332.5</TD>
            <TD>0.745117</TD>
          </TR>
          <TR>
            <TD>8335</TD>
            <TD>0.744344</TD>
          </TR>
          <TR>
            <TD>8337.5</TD>
            <TD>0.743571</TD>
          </TR>
          <TR>
            <TD>8340</TD>
            <TD>0.742797</TD>
          </TR>
          <TR>
            <TD>8342.5</TD>
            <TD>0.741992</TD>
          </TR>
          <TR>
            <TD>8345</TD>
            <TD>0.741187</TD>
          </TR>
          <TR>
            <TD>8347.5</TD>
            <TD>0.740381</TD>
          </TR>
          <TR>
            <TD>8350</TD>
            <TD>0.739575</TD>
          </TR>
          <TR>
            <TD>8352.5</TD>
            <TD>0.738549</TD>
          </TR>
          <TR>
            <TD>8355</TD>
            <TD>0.737523</TD>
          </TR>
          <TR>
            <TD>8357.5</TD>
            <TD>0.736495</TD>
          </TR>
          <TR>
            <TD>8360</TD>
            <TD>0.735467</TD>
          </TR>
          <TR>
            <TD>8362.5</TD>
            <TD>0.734156</TD>
          </TR>
          <TR>
            <TD>8365</TD>
            <TD>0.732843</TD>
          </TR>
          <TR>
            <TD>8367.5</TD>
            <TD>0.73153</TD>
          </TR>
          <TR>
            <TD>8370</TD>
            <TD>0.730215</TD>
          </TR>
          <TR>
            <TD>8372.5</TD>
            <TD>0.72923</TD>
          </TR>
          <TR>
            <TD>8375</TD>
            <TD>0.728244</TD>
          </TR>
          <TR>
            <TD>8377.5</TD>
            <TD>0.727258</TD>
          </TR>
          <TR>
            <TD>8380</TD>
            <TD>0.72627</TD>
          </TR>
          <TR>
            <TD>8382.5</TD>
            <TD>0.725466</TD>
          </TR>
          <TR>
            <TD>8385</TD>
            <TD>0.724661</TD>
          </TR>
          <TR>
            <TD>8387.5</TD>
            <TD>0.723856</TD>
          </TR>
          <TR>
            <TD>8390</TD>
            <TD>0.723049</TD>
          </TR>
          <TR>
            <TD>8392.5</TD>
            <TD>0.722141</TD>
          </TR>
          <TR>
            <TD>8395</TD>
            <TD>0.721232</TD>
          </TR>
          <TR>
            <TD>8397.5</TD>
            <TD>0.720322</TD>
          </TR>
          <TR>
            <TD>8400</TD>
            <TD>0.719412</TD>
          </TR>
          <TR>
            <TD>8402.5</TD>
            <TD>0.718262</TD>
          </TR>
          <TR>
            <TD>8405</TD>
            <TD>0.717111</TD>
          </TR>
          <TR>
            <TD>8407.5</TD>
            <TD>0.715959</TD>
          </TR>
          <TR>
            <TD>8410</TD>
            <TD>0.714807</TD>
          </TR>
          <TR>
            <TD>8412.5</TD>
            <TD>0.713851</TD>
          </TR>
          <TR>
            <TD>8415</TD>
            <TD>0.712894</TD>
          </TR>
          <TR>
            <TD>8417.5</TD>
            <TD>0.711937</TD>
          </TR>
          <TR>
            <TD>8420</TD>
            <TD>0.710978</TD>
          </TR>
          <TR>
            <TD>8422.5</TD>
            <TD>0.710186</TD>
          </TR>
          <TR>
            <TD>8425</TD>
            <TD>0.709393</TD>
          </TR>
          <TR>
            <TD>8427.5</TD>
            <TD>0.7086</TD>
          </TR>
          <TR>
            <TD>8430</TD>
            <TD>0.707806</TD>
          </TR>
          <TR>
            <TD>8432.5</TD>
            <TD>0.707398</TD>
          </TR>
          <TR>
            <TD>8435</TD>
            <TD>0.70699</TD>
          </TR>
          <TR>
            <TD>8437.5</TD>
            <TD>0.706581</TD>
          </TR>
          <TR>
            <TD>8440</TD>
            <TD>0.706172</TD>
          </TR>
          <TR>
            <TD>8442.5</TD>
            <TD>0.70491</TD>
          </TR>
          <TR>
            <TD>8445</TD>
            <TD>0.703647</TD>
          </TR>
          <TR>
            <TD>8447.5</TD>
            <TD>0.702383</TD>
          </TR>
          <TR>
            <TD>8450</TD>
            <TD>0.701118</TD>
          </TR>
          <TR>
            <TD>8452.5</TD>
            <TD>0.699809</TD>
          </TR>
          <TR>
            <TD>8455</TD>
            <TD>0.698498</TD>
          </TR>
          <TR>
            <TD>8457.5</TD>
            <TD>0.697187</TD>
          </TR>
          <TR>
            <TD>8460</TD>
            <TD>0.695875</TD>
          </TR>
          <TR>
            <TD>8462.5</TD>
            <TD>0.694757</TD>
          </TR>
          <TR>
            <TD>8465</TD>
            <TD>0.693638</TD>
          </TR>
          <TR>
            <TD>8467.5</TD>
            <TD>0.692518</TD>
          </TR>
          <TR>
            <TD>8470</TD>
            <TD>0.691398</TD>
          </TR>
          <TR>
            <TD>8472.5</TD>
            <TD>0.690376</TD>
          </TR>
          <TR>
            <TD>8475</TD>
            <TD>0.689354</TD>
          </TR>
          <TR>
            <TD>8477.5</TD>
            <TD>0.688331</TD>
          </TR>
          <TR>
            <TD>8480</TD>
            <TD>0.687308</TD>
          </TR>
          <TR>
            <TD>8482.5</TD>
            <TD>0.686421</TD>
          </TR>
          <TR>
            <TD>8485</TD>
            <TD>0.685533</TD>
          </TR>
          <TR>
            <TD>8487.5</TD>
            <TD>0.684645</TD>
          </TR>
          <TR>
            <TD>8490</TD>
            <TD>0.683756</TD>
          </TR>
          <TR>
            <TD>8492.5</TD>
            <TD>0.68255</TD>
          </TR>
          <TR>
            <TD>8495</TD>
            <TD>0.681344</TD>
          </TR>
          <TR>
            <TD>8497.5</TD>
            <TD>0.680137</TD>
          </TR>
          <TR>
            <TD>8500</TD>
            <TD>0.678929</TD>
          </TR>
          <TR>
            <TD>8502.5</TD>
            <TD>0.678014</TD>
          </TR>
          <TR>
            <TD>8505</TD>
            <TD>0.677098</TD>
          </TR>
          <TR>
            <TD>8507.5</TD>
            <TD>0.676182</TD>
          </TR>
          <TR>
            <TD>8510</TD>
            <TD>0.675265</TD>
          </TR>
          <TR>
            <TD>8512.5</TD>
            <TD>0.67436</TD>
          </TR>
          <TR>
            <TD>8515</TD>
            <TD>0.673455</TD>
          </TR>
          <TR>
            <TD>8517.5</TD>
            <TD>0.672549</TD>
          </TR>
          <TR>
            <TD>8520</TD>
            <TD>0.671642</TD>
          </TR>
          <TR>
            <TD>8522.5</TD>
            <TD>0.670399</TD>
          </TR>
          <TR>
            <TD>8525</TD>
            <TD>0.669155</TD>
          </TR>
          <TR>
            <TD>8527.5</TD>
            <TD>0.66791</TD>
          </TR>
          <TR>
            <TD>8530</TD>
            <TD>0.666664</TD>
          </TR>
          <TR>
            <TD>8532.5</TD>
            <TD>0.665753</TD>
          </TR>
          <TR>
            <TD>8535</TD>
            <TD>0.664842</TD>
          </TR>
          <TR>
            <TD>8537.5</TD>
            <TD>0.66393</TD>
          </TR>
          <TR>
            <TD>8540</TD>
            <TD>0.663017</TD>
          </TR>
          <TR>
            <TD>8542.5</TD>
            <TD>0.662237</TD>
          </TR>
          <TR>
            <TD>8545</TD>
            <TD>0.661456</TD>
          </TR>
          <TR>
            <TD>8547.5</TD>
            <TD>0.660675</TD>
          </TR>
          <TR>
            <TD>8550</TD>
            <TD>0.659893</TD>
          </TR>
          <TR>
            <TD>8552.5</TD>
            <TD>0.658913</TD>
          </TR>
          <TR>
            <TD>8555</TD>
            <TD>0.657932</TD>
          </TR>
          <TR>
            <TD>8557.5</TD>
            <TD>0.656951</TD>
          </TR>
          <TR>
            <TD>8560</TD>
            <TD>0.655969</TD>
          </TR>
          <TR>
            <TD>8562.5</TD>
            <TD>0.655132</TD>
          </TR>
          <TR>
            <TD>8565</TD>
            <TD>0.654294</TD>
          </TR>
          <TR>
            <TD>8567.5</TD>
            <TD>0.653455</TD>
          </TR>
          <TR>
            <TD>8570</TD>
            <TD>0.652616</TD>
          </TR>
          <TR>
            <TD>8572.5</TD>
            <TD>0.651307</TD>
          </TR>
          <TR>
            <TD>8575</TD>
            <TD>0.649997</TD>
          </TR>
          <TR>
            <TD>8577.5</TD>
            <TD>0.648686</TD>
          </TR>
          <TR>
            <TD>8580</TD>
            <TD>0.647374</TD>
          </TR>
          <TR>
            <TD>8582.5</TD>
            <TD>0.646035</TD>
          </TR>
          <TR>
            <TD>8585</TD>
            <TD>0.644694</TD>
          </TR>
          <TR>
            <TD>8587.5</TD>
            <TD>0.643353</TD>
          </TR>
          <TR>
            <TD>8590</TD>
            <TD>0.642011</TD>
          </TR>
          <TR>
            <TD>8592.5</TD>
            <TD>0.641324</TD>
          </TR>
          <TR>
            <TD>8595</TD>
            <TD>0.640636</TD>
          </TR>
          <TR>
            <TD>8597.5</TD>
            <TD>0.639948</TD>
          </TR>
          <TR>
            <TD>8600</TD>
            <TD>0.63926</TD>
          </TR>
          <TR>
            <TD>8602.5</TD>
            <TD>0.638066</TD>
          </TR>
          <TR>
            <TD>8605</TD>
            <TD>0.636872</TD>
          </TR>
          <TR>
            <TD>8607.5</TD>
            <TD>0.635677</TD>
          </TR>
          <TR>
            <TD>8610</TD>
            <TD>0.634481</TD>
          </TR>
          <TR>
            <TD>8612.5</TD>
            <TD>0.633832</TD>
          </TR>
          <TR>
            <TD>8615</TD>
            <TD>0.633182</TD>
          </TR>
          <TR>
            <TD>8617.5</TD>
            <TD>0.632531</TD>
          </TR>
          <TR>
            <TD>8620</TD>
            <TD>0.631881</TD>
          </TR>
          <TR>
            <TD>8622.5</TD>
            <TD>0.630945</TD>
          </TR>
          <TR>
            <TD>8625</TD>
            <TD>0.63001</TD>
          </TR>
          <TR>
            <TD>8627.5</TD>
            <TD>0.629073</TD>
          </TR>
          <TR>
            <TD>8630</TD>
            <TD>0.628136</TD>
          </TR>
          <TR>
            <TD>8632.5</TD>
            <TD>0.626928</TD>
          </TR>
          <TR>
            <TD>8635</TD>
            <TD>0.62572</TD>
          </TR>
          <TR>
            <TD>8637.5</TD>
            <TD>0.624511</TD>
          </TR>
          <TR>
            <TD>8640</TD>
            <TD>0.6233</TD>
          </TR>
          <TR>
            <TD>8642.5</TD>
            <TD>0.621956</TD>
          </TR>
          <TR>
            <TD>8645</TD>
            <TD>0.620611</TD>
          </TR>
          <TR>
            <TD>8647.5</TD>
            <TD>0.619265</TD>
          </TR>
          <TR>
            <TD>8650</TD>
            <TD>0.617917</TD>
          </TR>
          <TR>
            <TD>8652.5</TD>
            <TD>0.61722</TD>
          </TR>
          <TR>
            <TD>8655</TD>
            <TD>0.616522</TD>
          </TR>
          <TR>
            <TD>8657.5</TD>
            <TD>0.615823</TD>
          </TR>
          <TR>
            <TD>8660</TD>
            <TD>0.615124</TD>
          </TR>
          <TR>
            <TD>8662.5</TD>
            <TD>0.613854</TD>
          </TR>
          <TR>
            <TD>8665</TD>
            <TD>0.612583</TD>
          </TR>
          <TR>
            <TD>8667.5</TD>
            <TD>0.611312</TD>
          </TR>
          <TR>
            <TD>8670</TD>
            <TD>0.610039</TD>
          </TR>
          <TR>
            <TD>8672.5</TD>
            <TD>0.608358</TD>
          </TR>
          <TR>
            <TD>8675</TD>
            <TD>0.606675</TD>
          </TR>
          <TR>
            <TD>8677.5</TD>
            <TD>0.604991</TD>
          </TR>
          <TR>
            <TD>8680</TD>
            <TD>0.603306</TD>
          </TR>
          <TR>
            <TD>8682.5</TD>
            <TD>0.602873</TD>
          </TR>
          <TR>
            <TD>8685</TD>
            <TD>0.602439</TD>
          </TR>
          <TR>
            <TD>8687.5</TD>
            <TD>0.602005</TD>
          </TR>
          <TR>
            <TD>8690</TD>
            <TD>0.601571</TD>
          </TR>
          <TR>
            <TD>8692.5</TD>
            <TD>0.600775</TD>
          </TR>
          <TR>
            <TD>8695</TD>
            <TD>0.599979</TD>
          </TR>
          <TR>
            <TD>8697.5</TD>
            <TD>0.599182</TD>
          </TR>
          <TR>
            <TD>8700</TD>
            <TD>0.598385</TD>
          </TR>
          <TR>
            <TD>8702.5</TD>
            <TD>0.597122</TD>
          </TR>
          <TR>
            <TD>8705</TD>
            <TD>0.595858</TD>
          </TR>
          <TR>
            <TD>8707.5</TD>
            <TD>0.594593</TD>
          </TR>
          <TR>
            <TD>8710</TD>
            <TD>0.593328</TD>
          </TR>
          <TR>
            <TD>8712.5</TD>
            <TD>0.592256</TD>
          </TR>
          <TR>
            <TD>8715</TD>
            <TD>0.591183</TD>
          </TR>
          <TR>
            <TD>8717.5</TD>
            <TD>0.590109</TD>
          </TR>
          <TR>
            <TD>8720</TD>
            <TD>0.589035</TD>
          </TR>
          <TR>
            <TD>8722.5</TD>
            <TD>0.588613</TD>
          </TR>
          <TR>
            <TD>8725</TD>
            <TD>0.588191</TD>
          </TR>
          <TR>
            <TD>8727.5</TD>
            <TD>0.587768</TD>
          </TR>
          <TR>
            <TD>8730</TD>
            <TD>0.587346</TD>
          </TR>
          <TR>
            <TD>8732.5</TD>
            <TD>0.586343</TD>
          </TR>
          <TR>
            <TD>8735</TD>
            <TD>0.585341</TD>
          </TR>
          <TR>
            <TD>8737.5</TD>
            <TD>0.584337</TD>
          </TR>
          <TR>
            <TD>8740</TD>
            <TD>0.583333</TD>
          </TR>
          <TR>
            <TD>8742.5</TD>
            <TD>0.582102</TD>
          </TR>
          <TR>
            <TD>8745</TD>
            <TD>0.580871</TD>
          </TR>
          <TR>
            <TD>8747.5</TD>
            <TD>0.579638</TD>
          </TR>
          <TR>
            <TD>8750</TD>
            <TD>0.578405</TD>
          </TR>
          <TR>
            <TD>8752.5</TD>
            <TD>0.577462</TD>
          </TR>
          <TR>
            <TD>8755</TD>
            <TD>0.576519</TD>
          </TR>
          <TR>
            <TD>8757.5</TD>
            <TD>0.575575</TD>
          </TR>
          <TR>
            <TD>8760</TD>
            <TD>0.57463</TD>
          </TR>
          <TR>
            <TD>8762.5</TD>
            <TD>0.573473</TD>
          </TR>
          <TR>
            <TD>8765</TD>
            <TD>0.572316</TD>
          </TR>
          <TR>
            <TD>8767.5</TD>
            <TD>0.571158</TD>
          </TR>
          <TR>
            <TD>8770</TD>
            <TD>0.569999</TD>
          </TR>
          <TR>
            <TD>8772.5</TD>
            <TD>0.568838</TD>
          </TR>
          <TR>
            <TD>8775</TD>
            <TD>0.567677</TD>
          </TR>
          <TR>
            <TD>8777.5</TD>
            <TD>0.566515</TD>
          </TR>
          <TR>
            <TD>8780</TD>
            <TD>0.565352</TD>
          </TR>
          <TR>
            <TD>8782.5</TD>
            <TD>0.564009</TD>
          </TR>
          <TR>
            <TD>8785</TD>
            <TD>0.562665</TD>
          </TR>
          <TR>
            <TD>8787.5</TD>
            <TD>0.561321</TD>
          </TR>
          <TR>
            <TD>8790</TD>
            <TD>0.559975</TD>
          </TR>
          <TR>
            <TD>8792.5</TD>
            <TD>0.55884</TD>
          </TR>
          <TR>
            <TD>8795</TD>
            <TD>0.557704</TD>
          </TR>
          <TR>
            <TD>8797.5</TD>
            <TD>0.556567</TD>
          </TR>
          <TR>
            <TD>8800</TD>
            <TD>0.555429</TD>
          </TR>
          <TR>
            <TD>8802.5</TD>
            <TD>0.554624</TD>
          </TR>
          <TR>
            <TD>8805</TD>
            <TD>0.553819</TD>
          </TR>
          <TR>
            <TD>8807.5</TD>
            <TD>0.553013</TD>
          </TR>
          <TR>
            <TD>8810</TD>
            <TD>0.552206</TD>
          </TR>
          <TR>
            <TD>8812.5</TD>
            <TD>0.551334</TD>
          </TR>
          <TR>
            <TD>8815</TD>
            <TD>0.55046</TD>
          </TR>
          <TR>
            <TD>8817.5</TD>
            <TD>0.549587</TD>
          </TR>
          <TR>
            <TD>8820</TD>
            <TD>0.548712</TD>
          </TR>
          <TR>
            <TD>8822.5</TD>
            <TD>0.547541</TD>
          </TR>
          <TR>
            <TD>8825</TD>
            <TD>0.54637</TD>
          </TR>
          <TR>
            <TD>8827.5</TD>
            <TD>0.545197</TD>
          </TR>
          <TR>
            <TD>8830</TD>
            <TD>0.544024</TD>
          </TR>
          <TR>
            <TD>8832.5</TD>
            <TD>0.5428</TD>
          </TR>
          <TR>
            <TD>8835</TD>
            <TD>0.541575</TD>
          </TR>
          <TR>
            <TD>8837.5</TD>
            <TD>0.54035</TD>
          </TR>
          <TR>
            <TD>8840</TD>
            <TD>0.539124</TD>
          </TR>
          <TR>
            <TD>8842.5</TD>
            <TD>0.53806</TD>
          </TR>
          <TR>
            <TD>8845</TD>
            <TD>0.536996</TD>
          </TR>
          <TR>
            <TD>8847.5</TD>
            <TD>0.535931</TD>
          </TR>
          <TR>
            <TD>8850</TD>
            <TD>0.534865</TD>
          </TR>
          <TR>
            <TD>8852.5</TD>
            <TD>0.533845</TD>
          </TR>
          <TR>
            <TD>8855</TD>
            <TD>0.532824</TD>
          </TR>
          <TR>
            <TD>8857.5</TD>
            <TD>0.531802</TD>
          </TR>
          <TR>
            <TD>8860</TD>
            <TD>0.53078</TD>
          </TR>
          <TR>
            <TD>8862.5</TD>
            <TD>0.529908</TD>
          </TR>
          <TR>
            <TD>8865</TD>
            <TD>0.529034</TD>
          </TR>
          <TR>
            <TD>8867.5</TD>
            <TD>0.52816</TD>
          </TR>
          <TR>
            <TD>8870</TD>
            <TD>0.527286</TD>
          </TR>
          <TR>
            <TD>8872.5</TD>
            <TD>0.526569</TD>
          </TR>
          <TR>
            <TD>8875</TD>
            <TD>0.525851</TD>
          </TR>
          <TR>
            <TD>8877.5</TD>
            <TD>0.525133</TD>
          </TR>
          <TR>
            <TD>8880</TD>
            <TD>0.524414</TD>
          </TR>
          <TR>
            <TD>8882.5</TD>
            <TD>0.523317</TD>
          </TR>
          <TR>
            <TD>8885</TD>
            <TD>0.52222</TD>
          </TR>
          <TR>
            <TD>8887.5</TD>
            <TD>0.521122</TD>
          </TR>
          <TR>
            <TD>8890</TD>
            <TD>0.520023</TD>
          </TR>
          <TR>
            <TD>8892.5</TD>
            <TD>0.518918</TD>
          </TR>
          <TR>
            <TD>8895</TD>
            <TD>0.517813</TD>
          </TR>
          <TR>
            <TD>8897.5</TD>
            <TD>0.516708</TD>
          </TR>
          <TR>
            <TD>8900</TD>
            <TD>0.515601</TD>
          </TR>
          <TR>
            <TD>8902.5</TD>
            <TD>0.514487</TD>
          </TR>
          <TR>
            <TD>8905</TD>
            <TD>0.513372</TD>
          </TR>
          <TR>
            <TD>8907.5</TD>
            <TD>0.512257</TD>
          </TR>
          <TR>
            <TD>8910</TD>
            <TD>0.51114</TD>
          </TR>
          <TR>
            <TD>8912.5</TD>
            <TD>0.509927</TD>
          </TR>
          <TR>
            <TD>8915</TD>
            <TD>0.508712</TD>
          </TR>
          <TR>
            <TD>8917.5</TD>
            <TD>0.507497</TD>
          </TR>
          <TR>
            <TD>8920</TD>
            <TD>0.506281</TD>
          </TR>
          <TR>
            <TD>8922.5</TD>
            <TD>0.505178</TD>
          </TR>
          <TR>
            <TD>8925</TD>
            <TD>0.504074</TD>
          </TR>
          <TR>
            <TD>8927.5</TD>
            <TD>0.50297</TD>
          </TR>
          <TR>
            <TD>8930</TD>
            <TD>0.501865</TD>
          </TR>
          <TR>
            <TD>8932.5</TD>
            <TD>0.50111</TD>
          </TR>
          <TR>
            <TD>8935</TD>
            <TD>0.500354</TD>
          </TR>
          <TR>
            <TD>8937.5</TD>
            <TD>0.499598</TD>
          </TR>
          <TR>
            <TD>8940</TD>
            <TD>0.498841</TD>
          </TR>
          <TR>
            <TD>8942.5</TD>
            <TD>0.497673</TD>
          </TR>
          <TR>
            <TD>8945</TD>
            <TD>0.496505</TD>
          </TR>
          <TR>
            <TD>8947.5</TD>
            <TD>0.495335</TD>
          </TR>
          <TR>
            <TD>8950</TD>
            <TD>0.494165</TD>
          </TR>
          <TR>
            <TD>8952.5</TD>
            <TD>0.493145</TD>
          </TR>
          <TR>
            <TD>8955</TD>
            <TD>0.492124</TD>
          </TR>
          <TR>
            <TD>8957.5</TD>
            <TD>0.491102</TD>
          </TR>
          <TR>
            <TD>8960</TD>
            <TD>0.49008</TD>
          </TR>
          <TR>
            <TD>8962.5</TD>
            <TD>0.489193</TD>
          </TR>
          <TR>
            <TD>8965</TD>
            <TD>0.488305</TD>
          </TR>
          <TR>
            <TD>8967.5</TD>
            <TD>0.487417</TD>
          </TR>
          <TR>
            <TD>8970</TD>
            <TD>0.486529</TD>
          </TR>
          <TR>
            <TD>8972.5</TD>
            <TD>0.485323</TD>
          </TR>
          <TR>
            <TD>8975</TD>
            <TD>0.484118</TD>
          </TR>
          <TR>
            <TD>8977.5</TD>
            <TD>0.482911</TD>
          </TR>
          <TR>
            <TD>8980</TD>
            <TD>0.481704</TD>
          </TR>
          <TR>
            <TD>8982.5</TD>
            <TD>0.480431</TD>
          </TR>
          <TR>
            <TD>8985</TD>
            <TD>0.479158</TD>
          </TR>
          <TR>
            <TD>8987.5</TD>
            <TD>0.477884</TD>
          </TR>
          <TR>
            <TD>8990</TD>
            <TD>0.476609</TD>
          </TR>
          <TR>
            <TD>8992.5</TD>
            <TD>0.475612</TD>
          </TR>
          <TR>
            <TD>8995</TD>
            <TD>0.474614</TD>
          </TR>
          <TR>
            <TD>8997.5</TD>
            <TD>0.473615</TD>
          </TR>
          <TR>
            <TD>9000</TD>
            <TD>0.472616</TD>
          </TR>
          <TR>
            <TD>9002.5</TD>
            <TD>0.471629</TD>
          </TR>
          <TR>
            <TD>9005</TD>
            <TD>0.470641</TD>
          </TR>
          <TR>
            <TD>9007.5</TD>
            <TD>0.469653</TD>
          </TR>
          <TR>
            <TD>9010</TD>
            <TD>0.468663</TD>
          </TR>
          <TR>
            <TD>9012.5</TD>
            <TD>0.467569</TD>
          </TR>
          <TR>
            <TD>9015</TD>
            <TD>0.466474</TD>
          </TR>
          <TR>
            <TD>9017.5</TD>
            <TD>0.465378</TD>
          </TR>
          <TR>
            <TD>9020</TD>
            <TD>0.464281</TD>
          </TR>
          <TR>
            <TD>9022.5</TD>
            <TD>0.463129</TD>
          </TR>
          <TR>
            <TD>9025</TD>
            <TD>0.461975</TD>
          </TR>
          <TR>
            <TD>9027.5</TD>
            <TD>0.460822</TD>
          </TR>
          <TR>
            <TD>9030</TD>
            <TD>0.459667</TD>
          </TR>
          <TR>
            <TD>9032.5</TD>
            <TD>0.45866</TD>
          </TR>
          <TR>
            <TD>9035</TD>
            <TD>0.457652</TD>
          </TR>
          <TR>
            <TD>9037.5</TD>
            <TD>0.456643</TD>
          </TR>
          <TR>
            <TD>9040</TD>
            <TD>0.455634</TD>
          </TR>
          <TR>
            <TD>9042.5</TD>
            <TD>0.454575</TD>
          </TR>
          <TR>
            <TD>9045</TD>
            <TD>0.453516</TD>
          </TR>
          <TR>
            <TD>9047.5</TD>
            <TD>0.452455</TD>
          </TR>
          <TR>
            <TD>9050</TD>
            <TD>0.451394</TD>
          </TR>
          <TR>
            <TD>9052.5</TD>
            <TD>0.450435</TD>
          </TR>
          <TR>
            <TD>9055</TD>
            <TD>0.449475</TD>
          </TR>
          <TR>
            <TD>9057.5</TD>
            <TD>0.448515</TD>
          </TR>
          <TR>
            <TD>9060</TD>
            <TD>0.447554</TD>
          </TR>
          <TR>
            <TD>9062.5</TD>
            <TD>0.446406</TD>
          </TR>
          <TR>
            <TD>9065</TD>
            <TD>0.445258</TD>
          </TR>
          <TR>
            <TD>9067.5</TD>
            <TD>0.444108</TD>
          </TR>
          <TR>
            <TD>9070</TD>
            <TD>0.442959</TD>
          </TR>
          <TR>
            <TD>9072.5</TD>
            <TD>0.441929</TD>
          </TR>
          <TR>
            <TD>9075</TD>
            <TD>0.440898</TD>
          </TR>
          <TR>
            <TD>9077.5</TD>
            <TD>0.439867</TD>
          </TR>
          <TR>
            <TD>9080</TD>
            <TD>0.438835</TD>
          </TR>
          <TR>
            <TD>9082.5</TD>
            <TD>0.437968</TD>
          </TR>
          <TR>
            <TD>9085</TD>
            <TD>0.4371</TD>
          </TR>
          <TR>
            <TD>9087.5</TD>
            <TD>0.436232</TD>
          </TR>
          <TR>
            <TD>9090</TD>
            <TD>0.435363</TD>
          </TR>
          <TR>
            <TD>9092.5</TD>
            <TD>0.434234</TD>
          </TR>
          <TR>
            <TD>9095</TD>
            <TD>0.433104</TD>
          </TR>
          <TR>
            <TD>9097.5</TD>
            <TD>0.431973</TD>
          </TR>
          <TR>
            <TD>9100</TD>
            <TD>0.430841</TD>
          </TR>
          <TR>
            <TD>9102.5</TD>
            <TD>0.429588</TD>
          </TR>
          <TR>
            <TD>9105</TD>
            <TD>0.428333</TD>
          </TR>
          <TR>
            <TD>9107.5</TD>
            <TD>0.427078</TD>
          </TR>
          <TR>
            <TD>9110</TD>
            <TD>0.425821</TD>
          </TR>
          <TR>
            <TD>9112.5</TD>
            <TD>0.424656</TD>
          </TR>
          <TR>
            <TD>9115</TD>
            <TD>0.423491</TD>
          </TR>
          <TR>
            <TD>9117.5</TD>
            <TD>0.422324</TD>
          </TR>
          <TR>
            <TD>9120</TD>
            <TD>0.421157</TD>
          </TR>
          <TR>
            <TD>9122.5</TD>
            <TD>0.420144</TD>
          </TR>
          <TR>
            <TD>9125</TD>
            <TD>0.419129</TD>
          </TR>
          <TR>
            <TD>9127.5</TD>
            <TD>0.418115</TD>
          </TR>
          <TR>
            <TD>9130</TD>
            <TD>0.417099</TD>
          </TR>
          <TR>
            <TD>9132.5</TD>
            <TD>0.416231</TD>
          </TR>
          <TR>
            <TD>9135</TD>
            <TD>0.415363</TD>
          </TR>
          <TR>
            <TD>9137.5</TD>
            <TD>0.414494</TD>
          </TR>
          <TR>
            <TD>9140</TD>
            <TD>0.413625</TD>
          </TR>
          <TR>
            <TD>9142.5</TD>
            <TD>0.412659</TD>
          </TR>
          <TR>
            <TD>9145</TD>
            <TD>0.411692</TD>
          </TR>
          <TR>
            <TD>9147.5</TD>
            <TD>0.410724</TD>
          </TR>
          <TR>
            <TD>9150</TD>
            <TD>0.409756</TD>
          </TR>
          <TR>
            <TD>9152.5</TD>
            <TD>0.408731</TD>
          </TR>
          <TR>
            <TD>9155</TD>
            <TD>0.407705</TD>
          </TR>
          <TR>
            <TD>9157.5</TD>
            <TD>0.406679</TD>
          </TR>
          <TR>
            <TD>9160</TD>
            <TD>0.405653</TD>
          </TR>
          <TR>
            <TD>9162.5</TD>
            <TD>0.404636</TD>
          </TR>
          <TR>
            <TD>9165</TD>
            <TD>0.403619</TD>
          </TR>
          <TR>
            <TD>9167.5</TD>
            <TD>0.402601</TD>
          </TR>
          <TR>
            <TD>9170</TD>
            <TD>0.401583</TD>
          </TR>
          <TR>
            <TD>9172.5</TD>
            <TD>0.400378</TD>
          </TR>
          <TR>
            <TD>9175</TD>
            <TD>0.399172</TD>
          </TR>
          <TR>
            <TD>9177.5</TD>
            <TD>0.397965</TD>
          </TR>
          <TR>
            <TD>9180</TD>
            <TD>0.396758</TD>
          </TR>
          <TR>
            <TD>9182.5</TD>
            <TD>0.3956</TD>
          </TR>
          <TR>
            <TD>9185</TD>
            <TD>0.394442</TD>
          </TR>
          <TR>
            <TD>9187.5</TD>
            <TD>0.393283</TD>
          </TR>
          <TR>
            <TD>9190</TD>
            <TD>0.392123</TD>
          </TR>
          <TR>
            <TD>9192.5</TD>
            <TD>0.391201</TD>
          </TR>
          <TR>
            <TD>9195</TD>
            <TD>0.390278</TD>
          </TR>
          <TR>
            <TD>9197.5</TD>
            <TD>0.389355</TD>
          </TR>
          <TR>
            <TD>9200</TD>
            <TD>0.388431</TD>
          </TR>
          <TR>
            <TD>9202.5</TD>
            <TD>0.387468</TD>
          </TR>
          <TR>
            <TD>9205</TD>
            <TD>0.386503</TD>
          </TR>
          <TR>
            <TD>9207.5</TD>
            <TD>0.385539</TD>
          </TR>
          <TR>
            <TD>9210</TD>
            <TD>0.384573</TD>
          </TR>
          <TR>
            <TD>9212.5</TD>
            <TD>0.383467</TD>
          </TR>
          <TR>
            <TD>9215</TD>
            <TD>0.382361</TD>
          </TR>
          <TR>
            <TD>9217.5</TD>
            <TD>0.381254</TD>
          </TR>
          <TR>
            <TD>9220</TD>
            <TD>0.380146</TD>
          </TR>
          <TR>
            <TD>9222.5</TD>
            <TD>0.37911</TD>
          </TR>
          <TR>
            <TD>9225</TD>
            <TD>0.378074</TD>
          </TR>
          <TR>
            <TD>9227.5</TD>
            <TD>0.377038</TD>
          </TR>
          <TR>
            <TD>9230</TD>
            <TD>0.376</TD>
          </TR>
          <TR>
            <TD>9232.5</TD>
            <TD>0.374961</TD>
          </TR>
          <TR>
            <TD>9235</TD>
            <TD>0.373921</TD>
          </TR>
          <TR>
            <TD>9237.5</TD>
            <TD>0.37288</TD>
          </TR>
          <TR>
            <TD>9240</TD>
            <TD>0.371839</TD>
          </TR>
          <TR>
            <TD>9242.5</TD>
            <TD>0.370753</TD>
          </TR>
          <TR>
            <TD>9245</TD>
            <TD>0.369666</TD>
          </TR>
          <TR>
            <TD>9247.5</TD>
            <TD>0.368579</TD>
          </TR>
          <TR>
            <TD>9250</TD>
            <TD>0.367491</TD>
          </TR>
          <TR>
            <TD>9252.5</TD>
            <TD>0.366391</TD>
          </TR>
          <TR>
            <TD>9255</TD>
            <TD>0.365291</TD>
          </TR>
          <TR>
            <TD>9257.5</TD>
            <TD>0.36419</TD>
          </TR>
          <TR>
            <TD>9260</TD>
            <TD>0.363089</TD>
          </TR>
          <TR>
            <TD>9262.5</TD>
            <TD>0.36214</TD>
          </TR>
          <TR>
            <TD>9265</TD>
            <TD>0.36119</TD>
          </TR>
          <TR>
            <TD>9267.5</TD>
            <TD>0.36024</TD>
          </TR>
          <TR>
            <TD>9270</TD>
            <TD>0.35929</TD>
          </TR>
          <TR>
            <TD>9272.5</TD>
            <TD>0.358353</TD>
          </TR>
          <TR>
            <TD>9275</TD>
            <TD>0.357416</TD>
          </TR>
          <TR>
            <TD>9277.5</TD>
            <TD>0.356478</TD>
          </TR>
          <TR>
            <TD>9280</TD>
            <TD>0.35554</TD>
          </TR>
          <TR>
            <TD>9282.5</TD>
            <TD>0.354648</TD>
          </TR>
          <TR>
            <TD>9285</TD>
            <TD>0.353754</TD>
          </TR>
          <TR>
            <TD>9287.5</TD>
            <TD>0.352861</TD>
          </TR>
          <TR>
            <TD>9290</TD>
            <TD>0.351967</TD>
          </TR>
          <TR>
            <TD>9292.5</TD>
            <TD>0.351077</TD>
          </TR>
          <TR>
            <TD>9295</TD>
            <TD>0.350187</TD>
          </TR>
          <TR>
            <TD>9297.5</TD>
            <TD>0.349297</TD>
          </TR>
          <TR>
            <TD>9300</TD>
            <TD>0.348406</TD>
          </TR>
          <TR>
            <TD>9302.5</TD>
            <TD>0.347299</TD>
          </TR>
          <TR>
            <TD>9305</TD>
            <TD>0.346193</TD>
          </TR>
          <TR>
            <TD>9307.5</TD>
            <TD>0.345085</TD>
          </TR>
          <TR>
            <TD>9310</TD>
            <TD>0.343977</TD>
          </TR>
          <TR>
            <TD>9312.5</TD>
            <TD>0.342987</TD>
          </TR>
          <TR>
            <TD>9315</TD>
            <TD>0.341996</TD>
          </TR>
          <TR>
            <TD>9317.5</TD>
            <TD>0.341004</TD>
          </TR>
          <TR>
            <TD>9320</TD>
            <TD>0.340012</TD>
          </TR>
          <TR>
            <TD>9322.5</TD>
            <TD>0.339048</TD>
          </TR>
          <TR>
            <TD>9325</TD>
            <TD>0.338083</TD>
          </TR>
          <TR>
            <TD>9327.5</TD>
            <TD>0.337118</TD>
          </TR>
          <TR>
            <TD>9330</TD>
            <TD>0.336152</TD>
          </TR>
          <TR>
            <TD>9332.5</TD>
            <TD>0.335168</TD>
          </TR>
          <TR>
            <TD>9335</TD>
            <TD>0.334183</TD>
          </TR>
          <TR>
            <TD>9337.5</TD>
            <TD>0.333197</TD>
          </TR>
          <TR>
            <TD>9340</TD>
            <TD>0.332211</TD>
          </TR>
          <TR>
            <TD>9342.5</TD>
            <TD>0.331218</TD>
          </TR>
          <TR>
            <TD>9345</TD>
            <TD>0.330224</TD>
          </TR>
          <TR>
            <TD>9347.5</TD>
            <TD>0.32923</TD>
          </TR>
          <TR>
            <TD>9350</TD>
            <TD>0.328235</TD>
          </TR>
          <TR>
            <TD>9352.5</TD>
            <TD>0.327325</TD>
          </TR>
          <TR>
            <TD>9355</TD>
            <TD>0.326415</TD>
          </TR>
          <TR>
            <TD>9357.5</TD>
            <TD>0.325505</TD>
          </TR>
          <TR>
            <TD>9360</TD>
            <TD>0.324594</TD>
          </TR>
          <TR>
            <TD>9362.5</TD>
            <TD>0.323657</TD>
          </TR>
          <TR>
            <TD>9365</TD>
            <TD>0.32272</TD>
          </TR>
          <TR>
            <TD>9367.5</TD>
            <TD>0.321782</TD>
          </TR>
          <TR>
            <TD>9370</TD>
            <TD>0.320844</TD>
          </TR>
          <TR>
            <TD>9372.5</TD>
            <TD>0.319786</TD>
          </TR>
          <TR>
            <TD>9375</TD>
            <TD>0.318727</TD>
          </TR>
          <TR>
            <TD>9377.5</TD>
            <TD>0.317667</TD>
          </TR>
          <TR>
            <TD>9380</TD>
            <TD>0.316607</TD>
          </TR>
          <TR>
            <TD>9382.5</TD>
            <TD>0.315607</TD>
          </TR>
          <TR>
            <TD>9385</TD>
            <TD>0.314606</TD>
          </TR>
          <TR>
            <TD>9387.5</TD>
            <TD>0.313604</TD>
          </TR>
          <TR>
            <TD>9390</TD>
            <TD>0.312602</TD>
          </TR>
          <TR>
            <TD>9392.5</TD>
            <TD>0.31161</TD>
          </TR>
          <TR>
            <TD>9395</TD>
            <TD>0.310618</TD>
          </TR>
          <TR>
            <TD>9397.5</TD>
            <TD>0.309625</TD>
          </TR>
          <TR>
            <TD>9400</TD>
            <TD>0.308632</TD>
          </TR>
          <TR>
            <TD>9402.5</TD>
            <TD>0.307751</TD>
          </TR>
          <TR>
            <TD>9405</TD>
            <TD>0.30687</TD>
          </TR>
          <TR>
            <TD>9407.5</TD>
            <TD>0.305988</TD>
          </TR>
          <TR>
            <TD>9410</TD>
            <TD>0.305106</TD>
          </TR>
          <TR>
            <TD>9412.5</TD>
            <TD>0.30421</TD>
          </TR>
          <TR>
            <TD>9415</TD>
            <TD>0.303314</TD>
          </TR>
          <TR>
            <TD>9417.5</TD>
            <TD>0.302417</TD>
          </TR>
          <TR>
            <TD>9420</TD>
            <TD>0.301519</TD>
          </TR>
          <TR>
            <TD>9422.5</TD>
            <TD>0.300529</TD>
          </TR>
          <TR>
            <TD>9425</TD>
            <TD>0.299537</TD>
          </TR>
          <TR>
            <TD>9427.5</TD>
            <TD>0.298545</TD>
          </TR>
          <TR>
            <TD>9430</TD>
            <TD>0.297552</TD>
          </TR>
          <TR>
            <TD>9432.5</TD>
            <TD>0.296667</TD>
          </TR>
          <TR>
            <TD>9435</TD>
            <TD>0.295781</TD>
          </TR>
          <TR>
            <TD>9437.5</TD>
            <TD>0.294894</TD>
          </TR>
          <TR>
            <TD>9440</TD>
            <TD>0.294007</TD>
          </TR>
          <TR>
            <TD>9442.5</TD>
            <TD>0.293039</TD>
          </TR>
          <TR>
            <TD>9445</TD>
            <TD>0.292071</TD>
          </TR>
          <TR>
            <TD>9447.5</TD>
            <TD>0.291102</TD>
          </TR>
          <TR>
            <TD>9450</TD>
            <TD>0.290132</TD>
          </TR>
          <TR>
            <TD>9452.5</TD>
            <TD>0.289131</TD>
          </TR>
          <TR>
            <TD>9455</TD>
            <TD>0.288129</TD>
          </TR>
          <TR>
            <TD>9457.5</TD>
            <TD>0.287127</TD>
          </TR>
          <TR>
            <TD>9460</TD>
            <TD>0.286124</TD>
          </TR>
          <TR>
            <TD>9462.5</TD>
            <TD>0.285198</TD>
          </TR>
          <TR>
            <TD>9465</TD>
            <TD>0.284272</TD>
          </TR>
          <TR>
            <TD>9467.5</TD>
            <TD>0.283344</TD>
          </TR>
          <TR>
            <TD>9470</TD>
            <TD>0.282417</TD>
          </TR>
          <TR>
            <TD>9472.5</TD>
            <TD>0.281552</TD>
          </TR>
          <TR>
            <TD>9475</TD>
            <TD>0.280686</TD>
          </TR>
          <TR>
            <TD>9477.5</TD>
            <TD>0.27982</TD>
          </TR>
          <TR>
            <TD>9480</TD>
            <TD>0.278953</TD>
          </TR>
          <TR>
            <TD>9482.5</TD>
            <TD>0.278037</TD>
          </TR>
          <TR>
            <TD>9485</TD>
            <TD>0.277121</TD>
          </TR>
          <TR>
            <TD>9487.5</TD>
            <TD>0.276205</TD>
          </TR>
          <TR>
            <TD>9490</TD>
            <TD>0.275287</TD>
          </TR>
          <TR>
            <TD>9492.5</TD>
            <TD>0.274413</TD>
          </TR>
          <TR>
            <TD>9495</TD>
            <TD>0.273539</TD>
          </TR>
          <TR>
            <TD>9497.5</TD>
            <TD>0.272663</TD>
          </TR>
          <TR>
            <TD>9500</TD>
            <TD>0.271788</TD>
          </TR>
          <TR>
            <TD>9502.5</TD>
            <TD>0.270913</TD>
          </TR>
          <TR>
            <TD>9505</TD>
            <TD>0.270039</TD>
          </TR>
          <TR>
            <TD>9507.5</TD>
            <TD>0.269163</TD>
          </TR>
          <TR>
            <TD>9510</TD>
            <TD>0.268287</TD>
          </TR>
          <TR>
            <TD>9512.5</TD>
            <TD>0.267489</TD>
          </TR>
          <TR>
            <TD>9515</TD>
            <TD>0.26669</TD>
          </TR>
          <TR>
            <TD>9517.5</TD>
            <TD>0.265891</TD>
          </TR>
          <TR>
            <TD>9520</TD>
            <TD>0.265091</TD>
          </TR>
          <TR>
            <TD>9522.5</TD>
            <TD>0.264188</TD>
          </TR>
          <TR>
            <TD>9525</TD>
            <TD>0.263285</TD>
          </TR>
          <TR>
            <TD>9527.5</TD>
            <TD>0.262382</TD>
          </TR>
          <TR>
            <TD>9530</TD>
            <TD>0.261477</TD>
          </TR>
          <TR>
            <TD>9532.5</TD>
            <TD>0.260616</TD>
          </TR>
          <TR>
            <TD>9535</TD>
            <TD>0.259754</TD>
          </TR>
          <TR>
            <TD>9537.5</TD>
            <TD>0.258892</TD>
          </TR>
          <TR>
            <TD>9540</TD>
            <TD>0.258029</TD>
          </TR>
          <TR>
            <TD>9542.5</TD>
            <TD>0.257077</TD>
          </TR>
          <TR>
            <TD>9545</TD>
            <TD>0.256125</TD>
          </TR>
          <TR>
            <TD>9547.5</TD>
            <TD>0.255173</TD>
          </TR>
          <TR>
            <TD>9550</TD>
            <TD>0.25422</TD>
          </TR>
          <TR>
            <TD>9552.5</TD>
            <TD>0.253143</TD>
          </TR>
          <TR>
            <TD>9555</TD>
            <TD>0.252066</TD>
          </TR>
          <TR>
            <TD>9557.5</TD>
            <TD>0.250988</TD>
          </TR>
          <TR>
            <TD>9560</TD>
            <TD>0.249909</TD>
          </TR>
          <TR>
            <TD>9562.5</TD>
            <TD>0.249104</TD>
          </TR>
          <TR>
            <TD>9565</TD>
            <TD>0.248298</TD>
          </TR>
          <TR>
            <TD>9567.5</TD>
            <TD>0.247492</TD>
          </TR>
          <TR>
            <TD>9570</TD>
            <TD>0.246685</TD>
          </TR>
          <TR>
            <TD>9572.5</TD>
            <TD>0.245893</TD>
          </TR>
          <TR>
            <TD>9575</TD>
            <TD>0.2451</TD>
          </TR>
          <TR>
            <TD>9577.5</TD>
            <TD>0.244307</TD>
          </TR>
          <TR>
            <TD>9580</TD>
            <TD>0.243514</TD>
          </TR>
          <TR>
            <TD>9582.5</TD>
            <TD>0.242644</TD>
          </TR>
          <TR>
            <TD>9585</TD>
            <TD>0.241774</TD>
          </TR>
          <TR>
            <TD>9587.5</TD>
            <TD>0.240904</TD>
          </TR>
          <TR>
            <TD>9590</TD>
            <TD>0.240033</TD>
          </TR>
          <TR>
            <TD>9592.5</TD>
            <TD>0.239123</TD>
          </TR>
          <TR>
            <TD>9595</TD>
            <TD>0.238213</TD>
          </TR>
          <TR>
            <TD>9597.5</TD>
            <TD>0.237302</TD>
          </TR>
          <TR>
            <TD>9600</TD>
            <TD>0.236391</TD>
          </TR>
          <TR>
            <TD>9602.5</TD>
            <TD>0.235466</TD>
          </TR>
          <TR>
            <TD>9605</TD>
            <TD>0.234541</TD>
          </TR>
          <TR>
            <TD>9607.5</TD>
            <TD>0.233615</TD>
          </TR>
          <TR>
            <TD>9610</TD>
            <TD>0.232689</TD>
          </TR>
          <TR>
            <TD>9612.5</TD>
            <TD>0.231755</TD>
          </TR>
          <TR>
            <TD>9615</TD>
            <TD>0.23082</TD>
          </TR>
          <TR>
            <TD>9617.5</TD>
            <TD>0.229885</TD>
          </TR>
          <TR>
            <TD>9620</TD>
            <TD>0.228949</TD>
          </TR>
          <TR>
            <TD>9622.5</TD>
            <TD>0.228067</TD>
          </TR>
          <TR>
            <TD>9625</TD>
            <TD>0.227184</TD>
          </TR>
          <TR>
            <TD>9627.5</TD>
            <TD>0.2263</TD>
          </TR>
          <TR>
            <TD>9630</TD>
            <TD>0.225417</TD>
          </TR>
          <TR>
            <TD>9632.5</TD>
            <TD>0.224563</TD>
          </TR>
          <TR>
            <TD>9635</TD>
            <TD>0.223709</TD>
          </TR>
          <TR>
            <TD>9637.5</TD>
            <TD>0.222855</TD>
          </TR>
          <TR>
            <TD>9640</TD>
            <TD>0.222</TD>
          </TR>
          <TR>
            <TD>9642.5</TD>
            <TD>0.2212</TD>
          </TR>
          <TR>
            <TD>9645</TD>
            <TD>0.2204</TD>
          </TR>
          <TR>
            <TD>9647.5</TD>
            <TD>0.2196</TD>
          </TR>
          <TR>
            <TD>9650</TD>
            <TD>0.218799</TD>
          </TR>
          <TR>
            <TD>9652.5</TD>
            <TD>0.218016</TD>
          </TR>
          <TR>
            <TD>9655</TD>
            <TD>0.217234</TD>
          </TR>
          <TR>
            <TD>9657.5</TD>
            <TD>0.216451</TD>
          </TR>
          <TR>
            <TD>9660</TD>
            <TD>0.215667</TD>
          </TR>
          <TR>
            <TD>9662.5</TD>
            <TD>0.214865</TD>
          </TR>
          <TR>
            <TD>9665</TD>
            <TD>0.214063</TD>
          </TR>
          <TR>
            <TD>9667.5</TD>
            <TD>0.21326</TD>
          </TR>
          <TR>
            <TD>9670</TD>
            <TD>0.212457</TD>
          </TR>
          <TR>
            <TD>9672.5</TD>
            <TD>0.211593</TD>
          </TR>
          <TR>
            <TD>9675</TD>
            <TD>0.210728</TD>
          </TR>
          <TR>
            <TD>9677.5</TD>
            <TD>0.209863</TD>
          </TR>
          <TR>
            <TD>9680</TD>
            <TD>0.208997</TD>
          </TR>
          <TR>
            <TD>9682.5</TD>
            <TD>0.208121</TD>
          </TR>
          <TR>
            <TD>9685</TD>
            <TD>0.207245</TD>
          </TR>
          <TR>
            <TD>9687.5</TD>
            <TD>0.206368</TD>
          </TR>
          <TR>
            <TD>9690</TD>
            <TD>0.20549</TD>
          </TR>
          <TR>
            <TD>9692.5</TD>
            <TD>0.204657</TD>
          </TR>
          <TR>
            <TD>9695</TD>
            <TD>0.203823</TD>
          </TR>
          <TR>
            <TD>9697.5</TD>
            <TD>0.202988</TD>
          </TR>
          <TR>
            <TD>9700</TD>
            <TD>0.202154</TD>
          </TR>
          <TR>
            <TD>9702.5</TD>
            <TD>0.201302</TD>
          </TR>
          <TR>
            <TD>9705</TD>
            <TD>0.20045</TD>
          </TR>
          <TR>
            <TD>9707.5</TD>
            <TD>0.199597</TD>
          </TR>
          <TR>
            <TD>9710</TD>
            <TD>0.198744</TD>
          </TR>
          <TR>
            <TD>9712.5</TD>
            <TD>0.197942</TD>
          </TR>
          <TR>
            <TD>9715</TD>
            <TD>0.19714</TD>
          </TR>
          <TR>
            <TD>9717.5</TD>
            <TD>0.196338</TD>
          </TR>
          <TR>
            <TD>9720</TD>
            <TD>0.195535</TD>
          </TR>
          <TR>
            <TD>9722.5</TD>
            <TD>0.194791</TD>
          </TR>
          <TR>
            <TD>9725</TD>
            <TD>0.194047</TD>
          </TR>
          <TR>
            <TD>9727.5</TD>
            <TD>0.193303</TD>
          </TR>
          <TR>
            <TD>9730</TD>
            <TD>0.192558</TD>
          </TR>
          <TR>
            <TD>9732.5</TD>
            <TD>0.191859</TD>
          </TR>
          <TR>
            <TD>9735</TD>
            <TD>0.19116</TD>
          </TR>
          <TR>
            <TD>9737.5</TD>
            <TD>0.19046</TD>
          </TR>
          <TR>
            <TD>9740</TD>
            <TD>0.189761</TD>
          </TR>
          <TR>
            <TD>9742.5</TD>
            <TD>0.189035</TD>
          </TR>
          <TR>
            <TD>9745</TD>
            <TD>0.188309</TD>
          </TR>
          <TR>
            <TD>9747.5</TD>
            <TD>0.187583</TD>
          </TR>
          <TR>
            <TD>9750</TD>
            <TD>0.186856</TD>
          </TR>
          <TR>
            <TD>9752.5</TD>
            <TD>0.186062</TD>
          </TR>
          <TR>
            <TD>9755</TD>
            <TD>0.185268</TD>
          </TR>
          <TR>
            <TD>9757.5</TD>
            <TD>0.184473</TD>
          </TR>
          <TR>
            <TD>9760</TD>
            <TD>0.183678</TD>
          </TR>
          <TR>
            <TD>9762.5</TD>
            <TD>0.18287</TD>
          </TR>
          <TR>
            <TD>9765</TD>
            <TD>0.182062</TD>
          </TR>
          <TR>
            <TD>9767.5</TD>
            <TD>0.181253</TD>
          </TR>
          <TR>
            <TD>9770</TD>
            <TD>0.180444</TD>
          </TR>
          <TR>
            <TD>9772.5</TD>
            <TD>0.179645</TD>
          </TR>
          <TR>
            <TD>9775</TD>
            <TD>0.178846</TD>
          </TR>
          <TR>
            <TD>9777.5</TD>
            <TD>0.178046</TD>
          </TR>
          <TR>
            <TD>9780</TD>
            <TD>0.177246</TD>
          </TR>
          <TR>
            <TD>9782.5</TD>
            <TD>0.176478</TD>
          </TR>
          <TR>
            <TD>9785</TD>
            <TD>0.175709</TD>
          </TR>
          <TR>
            <TD>9787.5</TD>
            <TD>0.17494</TD>
          </TR>
          <TR>
            <TD>9790</TD>
            <TD>0.174171</TD>
          </TR>
          <TR>
            <TD>9792.5</TD>
            <TD>0.173419</TD>
          </TR>
          <TR>
            <TD>9795</TD>
            <TD>0.172666</TD>
          </TR>
          <TR>
            <TD>9797.5</TD>
            <TD>0.171913</TD>
          </TR>
          <TR>
            <TD>9800</TD>
            <TD>0.17116</TD>
          </TR>
          <TR>
            <TD>9802.5</TD>
            <TD>0.170457</TD>
          </TR>
          <TR>
            <TD>9805</TD>
            <TD>0.169754</TD>
          </TR>
          <TR>
            <TD>9807.5</TD>
            <TD>0.169051</TD>
          </TR>
          <TR>
            <TD>9810</TD>
            <TD>0.168347</TD>
          </TR>
          <TR>
            <TD>9812.5</TD>
            <TD>0.167659</TD>
          </TR>
          <TR>
            <TD>9815</TD>
            <TD>0.166971</TD>
          </TR>
          <TR>
            <TD>9817.5</TD>
            <TD>0.166282</TD>
          </TR>
          <TR>
            <TD>9820</TD>
            <TD>0.165593</TD>
          </TR>
          <TR>
            <TD>9822.5</TD>
            <TD>0.164889</TD>
          </TR>
          <TR>
            <TD>9825</TD>
            <TD>0.164185</TD>
          </TR>
          <TR>
            <TD>9827.5</TD>
            <TD>0.16348</TD>
          </TR>
          <TR>
            <TD>9830</TD>
            <TD>0.162775</TD>
          </TR>
          <TR>
            <TD>9832.5</TD>
            <TD>0.16208</TD>
          </TR>
          <TR>
            <TD>9835</TD>
            <TD>0.161384</TD>
          </TR>
          <TR>
            <TD>9837.5</TD>
            <TD>0.160688</TD>
          </TR>
          <TR>
            <TD>9840</TD>
            <TD>0.159991</TD>
          </TR>
          <TR>
            <TD>9842.5</TD>
            <TD>0.159307</TD>
          </TR>
          <TR>
            <TD>9845</TD>
            <TD>0.158621</TD>
          </TR>
          <TR>
            <TD>9847.5</TD>
            <TD>0.157936</TD>
          </TR>
          <TR>
            <TD>9850</TD>
            <TD>0.15725</TD>
          </TR>
          <TR>
            <TD>9852.5</TD>
            <TD>0.156505</TD>
          </TR>
          <TR>
            <TD>9855</TD>
            <TD>0.15576</TD>
          </TR>
          <TR>
            <TD>9857.5</TD>
            <TD>0.155014</TD>
          </TR>
          <TR>
            <TD>9860</TD>
            <TD>0.154268</TD>
          </TR>
          <TR>
            <TD>9862.5</TD>
            <TD>0.153573</TD>
          </TR>
          <TR>
            <TD>9865</TD>
            <TD>0.152877</TD>
          </TR>
          <TR>
            <TD>9867.5</TD>
            <TD>0.152181</TD>
          </TR>
          <TR>
            <TD>9870</TD>
            <TD>0.151485</TD>
          </TR>
          <TR>
            <TD>9872.5</TD>
            <TD>0.150787</TD>
          </TR>
          <TR>
            <TD>9875</TD>
            <TD>0.150088</TD>
          </TR>
          <TR>
            <TD>9877.5</TD>
            <TD>0.14939</TD>
          </TR>
          <TR>
            <TD>9880</TD>
            <TD>0.14869</TD>
          </TR>
          <TR>
            <TD>9882.5</TD>
            <TD>0.148057</TD>
          </TR>
          <TR>
            <TD>9885</TD>
            <TD>0.147423</TD>
          </TR>
          <TR>
            <TD>9887.5</TD>
            <TD>0.146789</TD>
          </TR>
          <TR>
            <TD>9890</TD>
            <TD>0.146154</TD>
          </TR>
          <TR>
            <TD>9892.5</TD>
            <TD>0.145529</TD>
          </TR>
          <TR>
            <TD>9895</TD>
            <TD>0.144902</TD>
          </TR>
          <TR>
            <TD>9897.5</TD>
            <TD>0.144276</TD>
          </TR>
          <TR>
            <TD>9900</TD>
            <TD>0.143649</TD>
          </TR>
          <TR>
            <TD>9902.5</TD>
            <TD>0.143004</TD>
          </TR>
          <TR>
            <TD>9905</TD>
            <TD>0.142358</TD>
          </TR>
          <TR>
            <TD>9907.5</TD>
            <TD>0.141712</TD>
          </TR>
          <TR>
            <TD>9910</TD>
            <TD>0.141066</TD>
          </TR>
          <TR>
            <TD>9912.5</TD>
            <TD>0.140429</TD>
          </TR>
          <TR>
            <TD>9915</TD>
            <TD>0.139792</TD>
          </TR>
          <TR>
            <TD>9917.5</TD>
            <TD>0.139154</TD>
          </TR>
          <TR>
            <TD>9920</TD>
            <TD>0.138516</TD>
          </TR>
          <TR>
            <TD>9922.5</TD>
            <TD>0.137851</TD>
          </TR>
          <TR>
            <TD>9925</TD>
            <TD>0.137187</TD>
          </TR>
          <TR>
            <TD>9927.5</TD>
            <TD>0.136521</TD>
          </TR>
          <TR>
            <TD>9930</TD>
            <TD>0.135856</TD>
          </TR>
          <TR>
            <TD>9932.5</TD>
            <TD>0.135186</TD>
          </TR>
          <TR>
            <TD>9935</TD>
            <TD>0.134516</TD>
          </TR>
          <TR>
            <TD>9937.5</TD>
            <TD>0.133845</TD>
          </TR>
          <TR>
            <TD>9940</TD>
            <TD>0.133174</TD>
          </TR>
          <TR>
            <TD>9942.5</TD>
            <TD>0.132524</TD>
          </TR>
          <TR>
            <TD>9945</TD>
            <TD>0.131873</TD>
          </TR>
          <TR>
            <TD>9947.5</TD>
            <TD>0.131222</TD>
          </TR>
          <TR>
            <TD>9950</TD>
            <TD>0.130571</TD>
          </TR>
          <TR>
            <TD>9952.5</TD>
            <TD>0.12992</TD>
          </TR>
          <TR>
            <TD>9955</TD>
            <TD>0.12927</TD>
          </TR>
          <TR>
            <TD>9957.5</TD>
            <TD>0.128619</TD>
          </TR>
          <TR>
            <TD>9960</TD>
            <TD>0.127967</TD>
          </TR>
          <TR>
            <TD>9962.5</TD>
            <TD>0.127363</TD>
          </TR>
          <TR>
            <TD>9965</TD>
            <TD>0.126758</TD>
          </TR>
          <TR>
            <TD>9967.5</TD>
            <TD>0.126153</TD>
          </TR>
          <TR>
            <TD>9970</TD>
            <TD>0.125547</TD>
          </TR>
          <TR>
            <TD>9972.5</TD>
            <TD>0.124986</TD>
          </TR>
          <TR>
            <TD>9975</TD>
            <TD>0.124425</TD>
          </TR>
          <TR>
            <TD>9977.5</TD>
            <TD>0.123864</TD>
          </TR>
          <TR>
            <TD>9980</TD>
            <TD>0.123302</TD>
          </TR>
          <TR>
            <TD>9982.5</TD>
            <TD>0.122753</TD>
          </TR>
          <TR>
            <TD>9985</TD>
            <TD>0.122205</TD>
          </TR>
          <TR>
            <TD>9987.5</TD>
            <TD>0.121656</TD>
          </TR>
          <TR>
            <TD>9990</TD>
            <TD>0.121106</TD>
          </TR>
          <TR>
            <TD>9992.5</TD>
            <TD>0.120522</TD>
          </TR>
          <TR>
            <TD>9995</TD>
            <TD>0.119938</TD>
          </TR>
          <TR>
            <TD>9997.5</TD>
            <TD>0.119353</TD>
          </TR>
          <TR>
            <TD>10000</TD>
            <TD>0.118768</TD>
          </TR>
          <TR>
            <TD>10002.5</TD>
            <TD>0.118166</TD>
          </TR>
          <TR>
            <TD>10005</TD>
            <TD>0.117563</TD>
          </TR>
          <TR>
            <TD>10007.5</TD>
            <TD>0.116959</TD>
          </TR>
          <TR>
            <TD>10010</TD>
            <TD>0.116356</TD>
          </TR>
          <TR>
            <TD>10012.5</TD>
            <TD>0.115764</TD>
          </TR>
          <TR>
            <TD>10015</TD>
            <TD>0.115172</TD>
          </TR>
          <TR>
            <TD>10017.5</TD>
            <TD>0.114579</TD>
          </TR>
          <TR>
            <TD>10020</TD>
            <TD>0.113986</TD>
          </TR>
          <TR>
            <TD>10022.5</TD>
            <TD>0.113403</TD>
          </TR>
          <TR>
            <TD>10025</TD>
            <TD>0.112819</TD>
          </TR>
          <TR>
            <TD>10027.5</TD>
            <TD>0.112235</TD>
          </TR>
          <TR>
            <TD>10030</TD>
            <TD>0.111651</TD>
          </TR>
          <TR>
            <TD>10032.5</TD>
            <TD>0.111073</TD>
          </TR>
          <TR>
            <TD>10035</TD>
            <TD>0.110496</TD>
          </TR>
          <TR>
            <TD>10037.5</TD>
            <TD>0.109918</TD>
          </TR>
          <TR>
            <TD>10040</TD>
            <TD>0.109339</TD>
          </TR>
          <TR>
            <TD>10042.5</TD>
            <TD>0.108796</TD>
          </TR>
          <TR>
            <TD>10045</TD>
            <TD>0.108252</TD>
          </TR>
          <TR>
            <TD>10047.5</TD>
            <TD>0.107708</TD>
          </TR>
          <TR>
            <TD>10050</TD>
            <TD>0.107164</TD>
          </TR>
          <TR>
            <TD>10052.5</TD>
            <TD>0.106632</TD>
          </TR>
          <TR>
            <TD>10055</TD>
            <TD>0.1061</TD>
          </TR>
          <TR>
            <TD>10057.5</TD>
            <TD>0.105567</TD>
          </TR>
          <TR>
            <TD>10060</TD>
            <TD>0.105034</TD>
          </TR>
          <TR>
            <TD>10062.5</TD>
            <TD>0.104518</TD>
          </TR>
          <TR>
            <TD>10065</TD>
            <TD>0.104002</TD>
          </TR>
          <TR>
            <TD>10067.5</TD>
            <TD>0.103486</TD>
          </TR>
          <TR>
            <TD>10070</TD>
            <TD>0.102969</TD>
          </TR>
          <TR>
            <TD>10072.5</TD>
            <TD>0.102452</TD>
          </TR>
          <TR>
            <TD>10075</TD>
            <TD>0.101935</TD>
          </TR>
          <TR>
            <TD>10077.5</TD>
            <TD>0.101418</TD>
          </TR>
          <TR>
            <TD>10080</TD>
            <TD>0.1009</TD>
          </TR>
          <TR>
            <TD>10082.5</TD>
            <TD>0.100381</TD>
          </TR>
          <TR>
            <TD>10085</TD>
            <TD>0.0998613</TD>
          </TR>
          <TR>
            <TD>10087.5</TD>
            <TD>0.0993415</TD>
          </TR>
          <TR>
            <TD>10090</TD>
            <TD>0.0988215</TD>
          </TR>
          <TR>
            <TD>10092.5</TD>
            <TD>0.0982752</TD>
          </TR>
          <TR>
            <TD>10095</TD>
            <TD>0.0977286</TD>
          </TR>
          <TR>
            <TD>10097.5</TD>
            <TD>0.0971817</TD>
          </TR>
          <TR>
            <TD>10100</TD>
            <TD>0.0966346</TD>
          </TR>
          <TR>
            <TD>10102.5</TD>
            <TD>0.0961025</TD>
          </TR>
          <TR>
            <TD>10105</TD>
            <TD>0.0955702</TD>
          </TR>
          <TR>
            <TD>10107.5</TD>
            <TD>0.0950376</TD>
          </TR>
          <TR>
            <TD>10110</TD>
            <TD>0.0945047</TD>
          </TR>
          <TR>
            <TD>10112.5</TD>
            <TD>0.0939839</TD>
          </TR>
          <TR>
            <TD>10115</TD>
            <TD>0.0934627</TD>
          </TR>
          <TR>
            <TD>10117.5</TD>
            <TD>0.0929414</TD>
          </TR>
          <TR>
            <TD>10120</TD>
            <TD>0.0924197</TD>
          </TR>
          <TR>
            <TD>10122.5</TD>
            <TD>0.0919195</TD>
          </TR>
          <TR>
            <TD>10125</TD>
            <TD>0.0914189</TD>
          </TR>
          <TR>
            <TD>10127.5</TD>
            <TD>0.0909182</TD>
          </TR>
          <TR>
            <TD>10130</TD>
            <TD>0.0904171</TD>
          </TR>
          <TR>
            <TD>10132.5</TD>
            <TD>0.0899285</TD>
          </TR>
          <TR>
            <TD>10135</TD>
            <TD>0.0894395</TD>
          </TR>
          <TR>
            <TD>10137.5</TD>
            <TD>0.0889503</TD>
          </TR>
          <TR>
            <TD>10140</TD>
            <TD>0.0884609</TD>
          </TR>
          <TR>
            <TD>10142.5</TD>
            <TD>0.0879947</TD>
          </TR>
          <TR>
            <TD>10145</TD>
            <TD>0.0875282</TD>
          </TR>
          <TR>
            <TD>10147.5</TD>
            <TD>0.0870614</TD>
          </TR>
          <TR>
            <TD>10150</TD>
            <TD>0.0865945</TD>
          </TR>
          <TR>
            <TD>10152.5</TD>
            <TD>0.0861465</TD>
          </TR>
          <TR>
            <TD>10155</TD>
            <TD>0.0856984</TD>
          </TR>
          <TR>
            <TD>10157.5</TD>
            <TD>0.08525</TD>
          </TR>
          <TR>
            <TD>10160</TD>
            <TD>0.0848014</TD>
          </TR>
          <TR>
            <TD>10162.5</TD>
            <TD>0.0843476</TD>
          </TR>
          <TR>
            <TD>10165</TD>
            <TD>0.0838936</TD>
          </TR>
          <TR>
            <TD>10167.5</TD>
            <TD>0.0834394</TD>
          </TR>
          <TR>
            <TD>10170</TD>
            <TD>0.082985</TD>
          </TR>
          <TR>
            <TD>10172.5</TD>
            <TD>0.0824941</TD>
          </TR>
          <TR>
            <TD>10175</TD>
            <TD>0.0820031</TD>
          </TR>
          <TR>
            <TD>10177.5</TD>
            <TD>0.0815117</TD>
          </TR>
          <TR>
            <TD>10180</TD>
            <TD>0.0810201</TD>
          </TR>
          <TR>
            <TD>10182.5</TD>
            <TD>0.0805609</TD>
          </TR>
          <TR>
            <TD>10185</TD>
            <TD>0.0801015</TD>
          </TR>
          <TR>
            <TD>10187.5</TD>
            <TD>0.0796418</TD>
          </TR>
          <TR>
            <TD>10190</TD>
            <TD>0.0791819</TD>
          </TR>
          <TR>
            <TD>10192.5</TD>
            <TD>0.0787076</TD>
          </TR>
          <TR>
            <TD>10195</TD>
            <TD>0.0782331</TD>
          </TR>
          <TR>
            <TD>10197.5</TD>
            <TD>0.0777584</TD>
          </TR>
          <TR>
            <TD>10200</TD>
            <TD>0.0772834</TD>
          </TR>
          <TR>
            <TD>10202.5</TD>
            <TD>0.0768373</TD>
          </TR>
          <TR>
            <TD>10205</TD>
            <TD>0.076391</TD>
          </TR>
          <TR>
            <TD>10207.5</TD>
            <TD>0.0759444</TD>
          </TR>
          <TR>
            <TD>10210</TD>
            <TD>0.0754977</TD>
          </TR>
          <TR>
            <TD>10212.5</TD>
            <TD>0.0750683</TD>
          </TR>
          <TR>
            <TD>10215</TD>
            <TD>0.0746387</TD>
          </TR>
          <TR>
            <TD>10217.5</TD>
            <TD>0.0742088</TD>
          </TR>
          <TR>
            <TD>10220</TD>
            <TD>0.0737788</TD>
          </TR>
          <TR>
            <TD>10222.5</TD>
            <TD>0.0733612</TD>
          </TR>
          <TR>
            <TD>10225</TD>
            <TD>0.0729433</TD>
          </TR>
          <TR>
            <TD>10227.5</TD>
            <TD>0.0725252</TD>
          </TR>
          <TR>
            <TD>10230</TD>
            <TD>0.0721069</TD>
          </TR>
          <TR>
            <TD>10232.5</TD>
            <TD>0.0716987</TD>
          </TR>
          <TR>
            <TD>10235</TD>
            <TD>0.0712902</TD>
          </TR>
          <TR>
            <TD>10237.5</TD>
            <TD>0.0708816</TD>
          </TR>
          <TR>
            <TD>10240</TD>
            <TD>0.0704727</TD>
          </TR>
          <TR>
            <TD>10242.5</TD>
            <TD>0.0700817</TD>
          </TR>
          <TR>
            <TD>10245</TD>
            <TD>0.0696906</TD>
          </TR>
          <TR>
            <TD>10247.5</TD>
            <TD>0.0692992</TD>
          </TR>
          <TR>
            <TD>10250</TD>
            <TD>0.0689076</TD>
          </TR>
          <TR>
            <TD>10252.5</TD>
            <TD>0.0685029</TD>
          </TR>
          <TR>
            <TD>10255</TD>
            <TD>0.0680979</TD>
          </TR>
          <TR>
            <TD>10257.5</TD>
            <TD>0.0676927</TD>
          </TR>
          <TR>
            <TD>10260</TD>
            <TD>0.0672873</TD>
          </TR>
          <TR>
            <TD>10262.5</TD>
            <TD>0.0668692</TD>
          </TR>
          <TR>
            <TD>10265</TD>
            <TD>0.0664509</TD>
          </TR>
          <TR>
            <TD>10267.5</TD>
            <TD>0.0660324</TD>
          </TR>
          <TR>
            <TD>10270</TD>
            <TD>0.0656136</TD>
          </TR>
          <TR>
            <TD>10272.5</TD>
            <TD>0.0652035</TD>
          </TR>
          <TR>
            <TD>10275</TD>
            <TD>0.0647931</TD>
          </TR>
          <TR>
            <TD>10277.5</TD>
            <TD>0.0643826</TD>
          </TR>
          <TR>
            <TD>10280</TD>
            <TD>0.0639718</TD>
          </TR>
          <TR>
            <TD>10282.5</TD>
            <TD>0.0635757</TD>
          </TR>
          <TR>
            <TD>10285</TD>
            <TD>0.0631794</TD>
          </TR>
          <TR>
            <TD>10287.5</TD>
            <TD>0.0627828</TD>
          </TR>
          <TR>
            <TD>10290</TD>
            <TD>0.0623861</TD>
          </TR>
          <TR>
            <TD>10292.5</TD>
            <TD>0.0619911</TD>
          </TR>
          <TR>
            <TD>10295</TD>
            <TD>0.0615959</TD>
          </TR>
          <TR>
            <TD>10297.5</TD>
            <TD>0.0612005</TD>
          </TR>
          <TR>
            <TD>10300</TD>
            <TD>0.0608048</TD>
          </TR>
          <TR>
            <TD>10302.5</TD>
            <TD>0.060434</TD>
          </TR>
          <TR>
            <TD>10305</TD>
            <TD>0.0600629</TD>
          </TR>
          <TR>
            <TD>10307.5</TD>
            <TD>0.0596917</TD>
          </TR>
          <TR>
            <TD>10310</TD>
            <TD>0.0593203</TD>
          </TR>
          <TR>
            <TD>10312.5</TD>
            <TD>0.0589526</TD>
          </TR>
          <TR>
            <TD>10315</TD>
            <TD>0.0585848</TD>
          </TR>
          <TR>
            <TD>10317.5</TD>
            <TD>0.0582167</TD>
          </TR>
          <TR>
            <TD>10320</TD>
            <TD>0.0578485</TD>
          </TR>
          <TR>
            <TD>10322.5</TD>
            <TD>0.0574932</TD>
          </TR>
          <TR>
            <TD>10325</TD>
            <TD>0.0571377</TD>
          </TR>
          <TR>
            <TD>10327.5</TD>
            <TD>0.0567821</TD>
          </TR>
          <TR>
            <TD>10330</TD>
            <TD>0.0564262</TD>
          </TR>
          <TR>
            <TD>10332.5</TD>
            <TD>0.0560705</TD>
          </TR>
          <TR>
            <TD>10335</TD>
            <TD>0.0557145</TD>
          </TR>
          <TR>
            <TD>10337.5</TD>
            <TD>0.0553584</TD>
          </TR>
          <TR>
            <TD>10340</TD>
            <TD>0.0550021</TD>
          </TR>
          <TR>
            <TD>10342.5</TD>
            <TD>0.0546507</TD>
          </TR>
          <TR>
            <TD>10345</TD>
            <TD>0.0542992</TD>
          </TR>
          <TR>
            <TD>10347.5</TD>
            <TD>0.0539474</TD>
          </TR>
          <TR>
            <TD>10350</TD>
            <TD>0.0535955</TD>
          </TR>
          <TR>
            <TD>10352.5</TD>
            <TD>0.0532527</TD>
          </TR>
          <TR>
            <TD>10355</TD>
            <TD>0.0529097</TD>
          </TR>
          <TR>
            <TD>10357.5</TD>
            <TD>0.0525666</TD>
          </TR>
          <TR>
            <TD>10360</TD>
            <TD>0.0522233</TD>
          </TR>
          <TR>
            <TD>10362.5</TD>
            <TD>0.0518776</TD>
          </TR>
          <TR>
            <TD>10365</TD>
            <TD>0.0515318</TD>
          </TR>
          <TR>
            <TD>10367.5</TD>
            <TD>0.0511858</TD>
          </TR>
          <TR>
            <TD>10370</TD>
            <TD>0.0508397</TD>
          </TR>
          <TR>
            <TD>10372.5</TD>
            <TD>0.0505021</TD>
          </TR>
          <TR>
            <TD>10375</TD>
            <TD>0.0501643</TD>
          </TR>
          <TR>
            <TD>10377.5</TD>
            <TD>0.0498263</TD>
          </TR>
          <TR>
            <TD>10380</TD>
            <TD>0.0494882</TD>
          </TR>
          <TR>
            <TD>10382.5</TD>
            <TD>0.0491555</TD>
          </TR>
          <TR>
            <TD>10385</TD>
            <TD>0.0488226</TD>
          </TR>
          <TR>
            <TD>10387.5</TD>
            <TD>0.0484895</TD>
          </TR>
          <TR>
            <TD>10390</TD>
            <TD>0.0481562</TD>
          </TR>
          <TR>
            <TD>10392.5</TD>
            <TD>0.0478354</TD>
          </TR>
          <TR>
            <TD>10395</TD>
            <TD>0.0475145</TD>
          </TR>
          <TR>
            <TD>10397.5</TD>
            <TD>0.0471934</TD>
          </TR>
          <TR>
            <TD>10400</TD>
            <TD>0.0468721</TD>
          </TR>
          <TR>
            <TD>10402.5</TD>
            <TD>0.0465578</TD>
          </TR>
          <TR>
            <TD>10405</TD>
            <TD>0.0462434</TD>
          </TR>
          <TR>
            <TD>10407.5</TD>
            <TD>0.0459289</TD>
          </TR>
          <TR>
            <TD>10410</TD>
            <TD>0.0456141</TD>
          </TR>
          <TR>
            <TD>10412.5</TD>
            <TD>0.0453033</TD>
          </TR>
          <TR>
            <TD>10415</TD>
            <TD>0.0449924</TD>
          </TR>
          <TR>
            <TD>10417.5</TD>
            <TD>0.0446812</TD>
          </TR>
          <TR>
            <TD>10420</TD>
            <TD>0.04437</TD>
          </TR>
          <TR>
            <TD>10422.5</TD>
            <TD>0.0440699</TD>
          </TR>
          <TR>
            <TD>10425</TD>
            <TD>0.0437697</TD>
          </TR>
          <TR>
            <TD>10427.5</TD>
            <TD>0.0434694</TD>
          </TR>
          <TR>
            <TD>10430</TD>
            <TD>0.0431689</TD>
          </TR>
          <TR>
            <TD>10432.5</TD>
            <TD>0.0428669</TD>
          </TR>
          <TR>
            <TD>10435</TD>
            <TD>0.0425647</TD>
          </TR>
          <TR>
            <TD>10437.5</TD>
            <TD>0.0422623</TD>
          </TR>
          <TR>
            <TD>10440</TD>
            <TD>0.0419598</TD>
          </TR>
          <TR>
            <TD>10442.5</TD>
            <TD>0.0416624</TD>
          </TR>
          <TR>
            <TD>10445</TD>
            <TD>0.0413648</TD>
          </TR>
          <TR>
            <TD>10447.5</TD>
            <TD>0.041067</TD>
          </TR>
          <TR>
            <TD>10450</TD>
            <TD>0.0407691</TD>
          </TR>
          <TR>
            <TD>10452.5</TD>
            <TD>0.0404704</TD>
          </TR>
          <TR>
            <TD>10455</TD>
            <TD>0.0401715</TD>
          </TR>
          <TR>
            <TD>10457.5</TD>
            <TD>0.0398724</TD>
          </TR>
          <TR>
            <TD>10460</TD>
            <TD>0.0395732</TD>
          </TR>
          <TR>
            <TD>10462.5</TD>
            <TD>0.0392786</TD>
          </TR>
          <TR>
            <TD>10465</TD>
            <TD>0.0389838</TD>
          </TR>
          <TR>
            <TD>10467.5</TD>
            <TD>0.0386889</TD>
          </TR>
          <TR>
            <TD>10470</TD>
            <TD>0.0383939</TD>
          </TR>
          <TR>
            <TD>10472.5</TD>
            <TD>0.0381139</TD>
          </TR>
          <TR>
            <TD>10475</TD>
            <TD>0.0378337</TD>
          </TR>
          <TR>
            <TD>10477.5</TD>
            <TD>0.0375534</TD>
          </TR>
          <TR>
            <TD>10480</TD>
            <TD>0.037273</TD>
          </TR>
          <TR>
            <TD>10482.5</TD>
            <TD>0.0369992</TD>
          </TR>
          <TR>
            <TD>10485</TD>
            <TD>0.0367253</TD>
          </TR>
          <TR>
            <TD>10487.5</TD>
            <TD>0.0364512</TD>
          </TR>
          <TR>
            <TD>10490</TD>
            <TD>0.036177</TD>
          </TR>
          <TR>
            <TD>10492.5</TD>
            <TD>0.0359083</TD>
          </TR>
          <TR>
            <TD>10495</TD>
            <TD>0.0356394</TD>
          </TR>
          <TR>
            <TD>10497.5</TD>
            <TD>0.0353704</TD>
          </TR>
          <TR>
            <TD>10500</TD>
            <TD>0.0351012</TD>
          </TR>
          <TR>
            <TD>10502.5</TD>
            <TD>0.0348439</TD>
          </TR>
          <TR>
            <TD>10505</TD>
            <TD>0.0345864</TD>
          </TR>
          <TR>
            <TD>10507.5</TD>
            <TD>0.0343289</TD>
          </TR>
          <TR>
            <TD>10510</TD>
            <TD>0.0340712</TD>
          </TR>
          <TR>
            <TD>10512.5</TD>
            <TD>0.0338134</TD>
          </TR>
          <TR>
            <TD>10515</TD>
            <TD>0.0335556</TD>
          </TR>
          <TR>
            <TD>10517.5</TD>
            <TD>0.0332976</TD>
          </TR>
          <TR>
            <TD>10520</TD>
            <TD>0.0330395</TD>
          </TR>
          <TR>
            <TD>10522.5</TD>
            <TD>0.0327838</TD>
          </TR>
          <TR>
            <TD>10525</TD>
            <TD>0.032528</TD>
          </TR>
          <TR>
            <TD>10527.5</TD>
            <TD>0.0322721</TD>
          </TR>
          <TR>
            <TD>10530</TD>
            <TD>0.032016</TD>
          </TR>
          <TR>
            <TD>10532.5</TD>
            <TD>0.0317668</TD>
          </TR>
          <TR>
            <TD>10535</TD>
            <TD>0.0315175</TD>
          </TR>
          <TR>
            <TD>10537.5</TD>
            <TD>0.0312681</TD>
          </TR>
          <TR>
            <TD>10540</TD>
            <TD>0.0310186</TD>
          </TR>
          <TR>
            <TD>10542.5</TD>
            <TD>0.0307765</TD>
          </TR>
          <TR>
            <TD>10545</TD>
            <TD>0.0305343</TD>
          </TR>
          <TR>
            <TD>10547.5</TD>
            <TD>0.030292</TD>
          </TR>
          <TR>
            <TD>10550</TD>
            <TD>0.0300496</TD>
          </TR>
          <TR>
            <TD>10552.5</TD>
            <TD>0.0298129</TD>
          </TR>
          <TR>
            <TD>10555</TD>
            <TD>0.0295761</TD>
          </TR>
          <TR>
            <TD>10557.5</TD>
            <TD>0.0293392</TD>
          </TR>
          <TR>
            <TD>10560</TD>
            <TD>0.0291021</TD>
          </TR>
          <TR>
            <TD>10562.5</TD>
            <TD>0.028872</TD>
          </TR>
          <TR>
            <TD>10565</TD>
            <TD>0.0286418</TD>
          </TR>
          <TR>
            <TD>10567.5</TD>
            <TD>0.0284115</TD>
          </TR>
          <TR>
            <TD>10570</TD>
            <TD>0.028181</TD>
          </TR>
          <TR>
            <TD>10572.5</TD>
            <TD>0.0279563</TD>
          </TR>
          <TR>
            <TD>10575</TD>
            <TD>0.0277315</TD>
          </TR>
          <TR>
            <TD>10577.5</TD>
            <TD>0.0275065</TD>
          </TR>
          <TR>
            <TD>10580</TD>
            <TD>0.0272815</TD>
          </TR>
          <TR>
            <TD>10582.5</TD>
            <TD>0.0270642</TD>
          </TR>
          <TR>
            <TD>10585</TD>
            <TD>0.0268469</TD>
          </TR>
          <TR>
            <TD>10587.5</TD>
            <TD>0.0266294</TD>
          </TR>
          <TR>
            <TD>10590</TD>
            <TD>0.0264118</TD>
          </TR>
          <TR>
            <TD>10592.5</TD>
            <TD>0.0262041</TD>
          </TR>
          <TR>
            <TD>10595</TD>
            <TD>0.0259963</TD>
          </TR>
          <TR>
            <TD>10597.5</TD>
            <TD>0.0257884</TD>
          </TR>
          <TR>
            <TD>10600</TD>
            <TD>0.0255804</TD>
          </TR>
          <TR>
            <TD>10602.5</TD>
            <TD>0.0253743</TD>
          </TR>
          <TR>
            <TD>10605</TD>
            <TD>0.0251681</TD>
          </TR>
          <TR>
            <TD>10607.5</TD>
            <TD>0.0249617</TD>
          </TR>
          <TR>
            <TD>10610</TD>
            <TD>0.0247553</TD>
          </TR>
          <TR>
            <TD>10612.5</TD>
            <TD>0.0245534</TD>
          </TR>
          <TR>
            <TD>10615</TD>
            <TD>0.0243515</TD>
          </TR>
          <TR>
            <TD>10617.5</TD>
            <TD>0.0241494</TD>
          </TR>
          <TR>
            <TD>10620</TD>
            <TD>0.0239472</TD>
          </TR>
          <TR>
            <TD>10622.5</TD>
            <TD>0.0237522</TD>
          </TR>
          <TR>
            <TD>10625</TD>
            <TD>0.0235571</TD>
          </TR>
          <TR>
            <TD>10627.5</TD>
            <TD>0.0233619</TD>
          </TR>
          <TR>
            <TD>10630</TD>
            <TD>0.0231666</TD>
          </TR>
          <TR>
            <TD>10632.5</TD>
            <TD>0.0229738</TD>
          </TR>
          <TR>
            <TD>10635</TD>
            <TD>0.0227809</TD>
          </TR>
          <TR>
            <TD>10637.5</TD>
            <TD>0.0225879</TD>
          </TR>
          <TR>
            <TD>10640</TD>
            <TD>0.0223947</TD>
          </TR>
          <TR>
            <TD>10642.5</TD>
            <TD>0.022206</TD>
          </TR>
          <TR>
            <TD>10645</TD>
            <TD>0.0220172</TD>
          </TR>
          <TR>
            <TD>10647.5</TD>
            <TD>0.0218283</TD>
          </TR>
          <TR>
            <TD>10650</TD>
            <TD>0.0216393</TD>
          </TR>
          <TR>
            <TD>10652.5</TD>
            <TD>0.0214547</TD>
          </TR>
          <TR>
            <TD>10655</TD>
            <TD>0.0212701</TD>
          </TR>
          <TR>
            <TD>10657.5</TD>
            <TD>0.0210853</TD>
          </TR>
          <TR>
            <TD>10660</TD>
            <TD>0.0209004</TD>
          </TR>
          <TR>
            <TD>10662.5</TD>
            <TD>0.0207233</TD>
          </TR>
          <TR>
            <TD>10665</TD>
            <TD>0.020546</TD>
          </TR>
          <TR>
            <TD>10667.5</TD>
            <TD>0.0203687</TD>
          </TR>
          <TR>
            <TD>10670</TD>
            <TD>0.0201913</TD>
          </TR>
          <TR>
            <TD>10672.5</TD>
            <TD>0.0200178</TD>
          </TR>
          <TR>
            <TD>10675</TD>
            <TD>0.0198442</TD>
          </TR>
          <TR>
            <TD>10677.5</TD>
            <TD>0.0196706</TD>
          </TR>
          <TR>
            <TD>10680</TD>
            <TD>0.0194969</TD>
          </TR>
          <TR>
            <TD>10682.5</TD>
            <TD>0.0193267</TD>
          </TR>
          <TR>
            <TD>10685</TD>
            <TD>0.0191563</TD>
          </TR>
          <TR>
            <TD>10687.5</TD>
            <TD>0.0189859</TD>
          </TR>
          <TR>
            <TD>10690</TD>
            <TD>0.0188155</TD>
          </TR>
          <TR>
            <TD>10692.5</TD>
            <TD>0.0186482</TD>
          </TR>
          <TR>
            <TD>10695</TD>
            <TD>0.0184808</TD>
          </TR>
          <TR>
            <TD>10697.5</TD>
            <TD>0.0183134</TD>
          </TR>
          <TR>
            <TD>10700</TD>
            <TD>0.0181459</TD>
          </TR>
          <TR>
            <TD>10702.5</TD>
            <TD>0.0179802</TD>
          </TR>
          <TR>
            <TD>10705</TD>
            <TD>0.0178145</TD>
          </TR>
          <TR>
            <TD>10707.5</TD>
            <TD>0.0176487</TD>
          </TR>
          <TR>
            <TD>10710</TD>
            <TD>0.0174828</TD>
          </TR>
          <TR>
            <TD>10712.5</TD>
            <TD>0.0173191</TD>
          </TR>
          <TR>
            <TD>10715</TD>
            <TD>0.0171553</TD>
          </TR>
          <TR>
            <TD>10717.5</TD>
            <TD>0.0169915</TD>
          </TR>
          <TR>
            <TD>10720</TD>
            <TD>0.0168276</TD>
          </TR>
          <TR>
            <TD>10722.5</TD>
            <TD>0.0166654</TD>
          </TR>
          <TR>
            <TD>10725</TD>
            <TD>0.0165031</TD>
          </TR>
          <TR>
            <TD>10727.5</TD>
            <TD>0.0163407</TD>
          </TR>
          <TR>
            <TD>10730</TD>
            <TD>0.0161783</TD>
          </TR>
          <TR>
            <TD>10732.5</TD>
            <TD>0.0160156</TD>
          </TR>
          <TR>
            <TD>10735</TD>
            <TD>0.0158528</TD>
          </TR>
          <TR>
            <TD>10737.5</TD>
            <TD>0.01569</TD>
          </TR>
          <TR>
            <TD>10740</TD>
            <TD>0.015527</TD>
          </TR>
          <TR>
            <TD>10742.5</TD>
            <TD>0.0153675</TD>
          </TR>
          <TR>
            <TD>10745</TD>
            <TD>0.0152079</TD>
          </TR>
          <TR>
            <TD>10747.5</TD>
            <TD>0.0150482</TD>
          </TR>
          <TR>
            <TD>10750</TD>
            <TD>0.0148884</TD>
          </TR>
          <TR>
            <TD>10752.5</TD>
            <TD>0.0147297</TD>
          </TR>
          <TR>
            <TD>10755</TD>
            <TD>0.0145709</TD>
          </TR>
          <TR>
            <TD>10757.5</TD>
            <TD>0.0144121</TD>
          </TR>
          <TR>
            <TD>10760</TD>
            <TD>0.0142531</TD>
          </TR>
          <TR>
            <TD>10762.5</TD>
            <TD>0.0140954</TD>
          </TR>
          <TR>
            <TD>10765</TD>
            <TD>0.0139376</TD>
          </TR>
          <TR>
            <TD>10767.5</TD>
            <TD>0.0137796</TD>
          </TR>
          <TR>
            <TD>10770</TD>
            <TD>0.0136217</TD>
          </TR>
          <TR>
            <TD>10772.5</TD>
            <TD>0.0134643</TD>
          </TR>
          <TR>
            <TD>10775</TD>
            <TD>0.013307</TD>
          </TR>
          <TR>
            <TD>10777.5</TD>
            <TD>0.0131495</TD>
          </TR>
          <TR>
            <TD>10780</TD>
            <TD>0.012992</TD>
          </TR>
          <TR>
            <TD>10782.5</TD>
            <TD>0.0128349</TD>
          </TR>
          <TR>
            <TD>10785</TD>
            <TD>0.0126778</TD>
          </TR>
          <TR>
            <TD>10787.5</TD>
            <TD>0.0125205</TD>
          </TR>
          <TR>
            <TD>10790</TD>
            <TD>0.0123633</TD>
          </TR>
          <TR>
            <TD>10792.5</TD>
            <TD>0.0122064</TD>
          </TR>
          <TR>
            <TD>10795</TD>
            <TD>0.0120494</TD>
          </TR>
          <TR>
            <TD>10797.5</TD>
            <TD>0.0118923</TD>
          </TR>
          <TR>
            <TD>10800</TD>
            <TD>0.0117352</TD>
          </TR>
          <TR>
            <TD>10802.5</TD>
            <TD>0.0115775</TD>
          </TR>
          <TR>
            <TD>10805</TD>
            <TD>0.0114196</TD>
          </TR>
          <TR>
            <TD>10807.5</TD>
            <TD>0.0112617</TD>
          </TR>
          <TR>
            <TD>10810</TD>
            <TD>0.0111037</TD>
          </TR>
          <TR>
            <TD>10812.5</TD>
            <TD>0.0109457</TD>
          </TR>
          <TR>
            <TD>10815</TD>
            <TD>0.0107876</TD>
          </TR>
          <TR>
            <TD>10817.5</TD>
            <TD>0.0106295</TD>
          </TR>
          <TR>
            <TD>10820</TD>
            <TD>0.0104712</TD>
          </TR>
          <TR>
            <TD>10822.5</TD>
            <TD>0.0103133</TD>
          </TR>
          <TR>
            <TD>10825</TD>
            <TD>0.0101553</TD>
          </TR>
          <TR>
            <TD>10827.5</TD>
            <TD>0.00999727</TD>
          </TR>
          <TR>
            <TD>10830</TD>
            <TD>0.00983913</TD>
          </TR>
          <TR>
            <TD>10832.5</TD>
            <TD>0.0096808</TD>
          </TR>
          <TR>
            <TD>10835</TD>
            <TD>0.00952239</TD>
          </TR>
          <TR>
            <TD>10837.5</TD>
            <TD>0.00936391</TD>
          </TR>
          <TR>
            <TD>10840</TD>
            <TD>0.00920536</TD>
          </TR>
          <TR>
            <TD>10842.5</TD>
            <TD>0.0090486</TD>
          </TR>
          <TR>
            <TD>10845</TD>
            <TD>0.00889176</TD>
          </TR>
          <TR>
            <TD>10847.5</TD>
            <TD>0.00873485</TD>
          </TR>
          <TR>
            <TD>10850</TD>
            <TD>0.00857787</TD>
          </TR>
          <TR>
            <TD>10852.5</TD>
            <TD>0.00842105</TD>
          </TR>
          <TR>
            <TD>10855</TD>
            <TD>0.00826417</TD>
          </TR>
          <TR>
            <TD>10857.5</TD>
            <TD>0.0081072</TD>
          </TR>
          <TR>
            <TD>10860</TD>
            <TD>0.00795017</TD>
          </TR>
          <TR>
            <TD>10862.5</TD>
            <TD>0.00779361</TD>
          </TR>
          <TR>
            <TD>10865</TD>
            <TD>0.00763697</TD>
          </TR>
          <TR>
            <TD>10867.5</TD>
            <TD>0.00748026</TD>
          </TR>
          <TR>
            <TD>10870</TD>
            <TD>0.00732348</TD>
          </TR>
          <TR>
            <TD>10872.5</TD>
            <TD>0.0071677</TD>
          </TR>
          <TR>
            <TD>10875</TD>
            <TD>0.00701185</TD>
          </TR>
          <TR>
            <TD>10877.5</TD>
            <TD>0.00685593</TD>
          </TR>
          <TR>
            <TD>10880</TD>
            <TD>0.00669993</TD>
          </TR>
          <TR>
            <TD>10882.5</TD>
            <TD>0.00654359</TD>
          </TR>
          <TR>
            <TD>10885</TD>
            <TD>0.00638719</TD>
          </TR>
          <TR>
            <TD>10887.5</TD>
            <TD>0.00623071</TD>
          </TR>
          <TR>
            <TD>10890</TD>
            <TD>0.00607416</TD>
          </TR>
          <TR>
            <TD>10892.5</TD>
            <TD>0.00591776</TD>
          </TR>
          <TR>
            <TD>10895</TD>
            <TD>0.00576129</TD>
          </TR>
          <TR>
            <TD>10897.5</TD>
            <TD>0.00560475</TD>
          </TR>
          <TR>
            <TD>10900</TD>
            <TD>0.00544814</TD>
          </TR>
          <TR>
            <TD>10902.5</TD>
            <TD>0.00529236</TD>
          </TR>
          <TR>
            <TD>10905</TD>
            <TD>0.00513652</TD>
          </TR>
          <TR>
            <TD>10907.5</TD>
            <TD>0.0049806</TD>
          </TR>
          <TR>
            <TD>10910</TD>
            <TD>0.00482461</TD>
          </TR>
          <TR>
            <TD>10912.5</TD>
            <TD>0.00466818</TD>
          </TR>
          <TR>
            <TD>10915</TD>
            <TD>0.00451169</TD>
          </TR>
          <TR>
            <TD>10917.5</TD>
            <TD>0.00435512</TD>
          </TR>
          <TR>
            <TD>10920</TD>
            <TD>0.00419848</TD>
          </TR>
          <TR>
            <TD>10922.5</TD>
            <TD>0.00404221</TD>
          </TR>
          <TR>
            <TD>10925</TD>
            <TD>0.00388587</TD>
          </TR>
          <TR>
            <TD>10927.5</TD>
            <TD>0.00372945</TD>
          </TR>
          <TR>
            <TD>10930</TD>
            <TD>0.00357297</TD>
          </TR>
          <TR>
            <TD>10932.5</TD>
            <TD>0.00341653</TD>
          </TR>
          <TR>
            <TD>10935</TD>
            <TD>0.00326002</TD>
          </TR>
          <TR>
            <TD>10937.5</TD>
            <TD>0.00310344</TD>
          </TR>
          <TR>
            <TD>10940</TD>
            <TD>0.00294679</TD>
          </TR>
          <TR>
            <TD>10942.5</TD>
            <TD>0.00279068</TD>
          </TR>
          <TR>
            <TD>10945</TD>
            <TD>0.0026345</TD>
          </TR>
          <TR>
            <TD>10947.5</TD>
            <TD>0.00247824</TD>
          </TR>
          <TR>
            <TD>10950</TD>
            <TD>0.00232191</TD>
          </TR>
          <TR>
            <TD>10952.5</TD>
            <TD>0.00216601</TD>
          </TR>
          <TR>
            <TD>10955</TD>
            <TD>0.00201003</TD>
          </TR>
          <TR>
            <TD>10957.5</TD>
            <TD>0.00185398</TD>
          </TR>
          <TR>
            <TD>10960</TD>
            <TD>0.00169787</TD>
          </TR>
          <TR>
            <TD>10962.5</TD>
            <TD>0.00154146</TD>
          </TR>
          <TR>
            <TD>10965</TD>
            <TD>0.00138498</TD>
          </TR>
          <TR>
            <TD>10967.5</TD>
            <TD>0.00122842</TD>
          </TR>
          <TR>
            <TD>10970</TD>
            <TD>0.0010718</TD>
          </TR>
          <TR>
            <TD>10972.5</TD>
            <TD>0.000914837</TD>
          </TR>
          <TR>
            <TD>10975</TD>
            <TD>0.000757801</TD>
          </TR>
          <TR>
            <TD>10977.5</TD>
            <TD>0.000600694</TD>
          </TR>
          <TR>
            <TD>10980</TD>
            <TD>0.000443514</TD>
          </TR>
          <TR>
            <TD>10982.5</TD>
            <TD>0.000285831</TD>
          </TR>
          <TR>
            <TD>10985</TD>
            <TD>0.000128077</TD>
          </TR>
          <TR>
            <TD>10987.5</TD>
            <TD>-2.97498e-05</TD>
          </TR>
          <TR>
            <TD>10990</TD>
            <TD>-0.000187648</TD>
          </TR>
        </TABLEDATA>
      </DATA>
    </TABLE>
  </RESOURCE>
</VOTABLE>
