# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 instance_type: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 availability_type: Optional[pulumi.Input[str]] = None,
                 database_flags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 gce_zone: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 machine_config: Optional[pulumi.Input['InstanceMachineConfigArgs']] = None,
                 read_pool_config: Optional[pulumi.Input['InstanceReadPoolConfigArgs']] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] cluster: Identifies the alloydb cluster. Must be in the format
               'projects/{project}/locations/{location}/clusters/{cluster_id}'
        :param pulumi.Input[str] instance_id: The ID of the alloydb instance.
        :param pulumi.Input[str] instance_type: The type of the instance.
               Possible values are `PRIMARY` and `READ_POOL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
        :param pulumi.Input[str] availability_type: Availability type of an Instance. Defaults to REGIONAL for both primary and read instances. Note that primary and read instances can have different availability types.
               Possible values are `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, and `REGIONAL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] database_flags: Database flags. Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
        :param pulumi.Input[str] display_name: User-settable and human-readable display name for the Instance.
        :param pulumi.Input[str] gce_zone: The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for the alloydb instance.
        :param pulumi.Input['InstanceMachineConfigArgs'] machine_config: Configurations for the machines that host the underlying database engine.
               Structure is documented below.
        :param pulumi.Input['InstanceReadPoolConfigArgs'] read_pool_config: Read pool specific config.
               Structure is documented below.
        """
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_type", instance_type)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if availability_type is not None:
            pulumi.set(__self__, "availability_type", availability_type)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gce_zone is not None:
            pulumi.set(__self__, "gce_zone", gce_zone)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if machine_config is not None:
            pulumi.set(__self__, "machine_config", machine_config)
        if read_pool_config is not None:
            pulumi.set(__self__, "read_pool_config", read_pool_config)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[str]:
        """
        Identifies the alloydb cluster. Must be in the format
        'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The ID of the alloydb instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        The type of the instance.
        Possible values are `PRIMARY` and `READ_POOL`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> Optional[pulumi.Input[str]]:
        """
        Availability type of an Instance. Defaults to REGIONAL for both primary and read instances. Note that primary and read instances can have different availability types.
        Possible values are `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, and `REGIONAL`.
        """
        return pulumi.get(self, "availability_type")

    @availability_type.setter
    def availability_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_type", value)

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Database flags. Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
        """
        return pulumi.get(self, "database_flags")

    @database_flags.setter
    def database_flags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "database_flags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        User-settable and human-readable display name for the Instance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="gceZone")
    def gce_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
        """
        return pulumi.get(self, "gce_zone")

    @gce_zone.setter
    def gce_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gce_zone", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-defined labels for the alloydb instance.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="machineConfig")
    def machine_config(self) -> Optional[pulumi.Input['InstanceMachineConfigArgs']]:
        """
        Configurations for the machines that host the underlying database engine.
        Structure is documented below.
        """
        return pulumi.get(self, "machine_config")

    @machine_config.setter
    def machine_config(self, value: Optional[pulumi.Input['InstanceMachineConfigArgs']]):
        pulumi.set(self, "machine_config", value)

    @property
    @pulumi.getter(name="readPoolConfig")
    def read_pool_config(self) -> Optional[pulumi.Input['InstanceReadPoolConfigArgs']]:
        """
        Read pool specific config.
        Structure is documented below.
        """
        return pulumi.get(self, "read_pool_config")

    @read_pool_config.setter
    def read_pool_config(self, value: Optional[pulumi.Input['InstanceReadPoolConfigArgs']]):
        pulumi.set(self, "read_pool_config", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 availability_type: Optional[pulumi.Input[str]] = None,
                 cluster: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 database_flags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 gce_zone: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 machine_config: Optional[pulumi.Input['InstanceMachineConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 read_pool_config: Optional[pulumi.Input['InstanceReadPoolConfigArgs']] = None,
                 reconciling: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
        :param pulumi.Input[str] availability_type: Availability type of an Instance. Defaults to REGIONAL for both primary and read instances. Note that primary and read instances can have different availability types.
               Possible values are `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, and `REGIONAL`.
        :param pulumi.Input[str] cluster: Identifies the alloydb cluster. Must be in the format
               'projects/{project}/locations/{location}/clusters/{cluster_id}'
        :param pulumi.Input[str] create_time: Time the Instance was created in UTC.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] database_flags: Database flags. Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
        :param pulumi.Input[str] display_name: User-settable and human-readable display name for the Instance.
        :param pulumi.Input[str] gce_zone: The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
        :param pulumi.Input[str] instance_id: The ID of the alloydb instance.
        :param pulumi.Input[str] instance_type: The type of the instance.
               Possible values are `PRIMARY` and `READ_POOL`.
        :param pulumi.Input[str] ip_address: The IP address for the Instance. This is the connection endpoint for an end-user application.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for the alloydb instance.
        :param pulumi.Input['InstanceMachineConfigArgs'] machine_config: Configurations for the machines that host the underlying database engine.
               Structure is documented below.
        :param pulumi.Input[str] name: The name of the instance resource.
        :param pulumi.Input['InstanceReadPoolConfigArgs'] read_pool_config: Read pool specific config.
               Structure is documented below.
        :param pulumi.Input[bool] reconciling: Set to true if the current state of Instance does not match the user's intended state, and the service is actively updating the resource to reconcile them. This can happen due to user-triggered updates or system actions like failover or maintenance.
        :param pulumi.Input[str] state: The current state of the alloydb instance.
        :param pulumi.Input[str] uid: The system-generated UID of the resource.
        :param pulumi.Input[str] update_time: Time the Instance was updated in UTC.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if availability_type is not None:
            pulumi.set(__self__, "availability_type", availability_type)
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gce_zone is not None:
            pulumi.set(__self__, "gce_zone", gce_zone)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if machine_config is not None:
            pulumi.set(__self__, "machine_config", machine_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_pool_config is not None:
            pulumi.set(__self__, "read_pool_config", read_pool_config)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> Optional[pulumi.Input[str]]:
        """
        Availability type of an Instance. Defaults to REGIONAL for both primary and read instances. Note that primary and read instances can have different availability types.
        Possible values are `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, and `REGIONAL`.
        """
        return pulumi.get(self, "availability_type")

    @availability_type.setter
    def availability_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_type", value)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the alloydb cluster. Must be in the format
        'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time the Instance was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Database flags. Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
        """
        return pulumi.get(self, "database_flags")

    @database_flags.setter
    def database_flags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "database_flags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        User-settable and human-readable display name for the Instance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="gceZone")
    def gce_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
        """
        return pulumi.get(self, "gce_zone")

    @gce_zone.setter
    def gce_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gce_zone", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the alloydb instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the instance.
        Possible values are `PRIMARY` and `READ_POOL`.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address for the Instance. This is the connection endpoint for an end-user application.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-defined labels for the alloydb instance.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="machineConfig")
    def machine_config(self) -> Optional[pulumi.Input['InstanceMachineConfigArgs']]:
        """
        Configurations for the machines that host the underlying database engine.
        Structure is documented below.
        """
        return pulumi.get(self, "machine_config")

    @machine_config.setter
    def machine_config(self, value: Optional[pulumi.Input['InstanceMachineConfigArgs']]):
        pulumi.set(self, "machine_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the instance resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readPoolConfig")
    def read_pool_config(self) -> Optional[pulumi.Input['InstanceReadPoolConfigArgs']]:
        """
        Read pool specific config.
        Structure is documented below.
        """
        return pulumi.get(self, "read_pool_config")

    @read_pool_config.setter
    def read_pool_config(self, value: Optional[pulumi.Input['InstanceReadPoolConfigArgs']]):
        pulumi.set(self, "read_pool_config", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the current state of Instance does not match the user's intended state, and the service is actively updating the resource to reconcile them. This can happen due to user-triggered updates or system actions like failover or maintenance.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the alloydb instance.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        The system-generated UID of the resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time the Instance was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 availability_type: Optional[pulumi.Input[str]] = None,
                 cluster: Optional[pulumi.Input[str]] = None,
                 database_flags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 gce_zone: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 machine_config: Optional[pulumi.Input[pulumi.InputType['InstanceMachineConfigArgs']]] = None,
                 read_pool_config: Optional[pulumi.Input[pulumi.InputType['InstanceReadPoolConfigArgs']]] = None,
                 __props__=None):
        """
        ## Example Usage
        ### Alloydb Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default_network = gcp.compute.Network("defaultNetwork", opts=pulumi.ResourceOptions(provider=google_beta))
        default_cluster = gcp.alloydb.Cluster("defaultCluster",
            cluster_id="alloydb-cluster",
            location="us-central1",
            network=default_network.name.apply(lambda name: f"projects/{project.number}/global/networks/{name}"),
            initial_user=gcp.alloydb.ClusterInitialUserArgs(
                password="alloydb-cluster",
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        private_ip_alloc = gcp.compute.GlobalAddress("privateIpAlloc",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=16,
            network=default_network.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        vpc_connection = gcp.servicenetworking.Connection("vpcConnection",
            network=default_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name],
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_instance = gcp.alloydb.Instance("defaultInstance",
            cluster=default_cluster.name,
            instance_id="alloydb-instance",
            instance_type="PRIMARY",
            machine_config=gcp.alloydb.InstanceMachineConfigArgs(
                cpu_count=2,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[vpc_connection]))
        ```

        ## Import

        Instance can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:alloydb/instance:Instance default {{cluster}}/instances/{{instance_id}}
        ```

        ```sh
         $ pulumi import gcp:alloydb/instance:Instance default {{cluster}}/{{instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
        :param pulumi.Input[str] availability_type: Availability type of an Instance. Defaults to REGIONAL for both primary and read instances. Note that primary and read instances can have different availability types.
               Possible values are `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, and `REGIONAL`.
        :param pulumi.Input[str] cluster: Identifies the alloydb cluster. Must be in the format
               'projects/{project}/locations/{location}/clusters/{cluster_id}'
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] database_flags: Database flags. Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
        :param pulumi.Input[str] display_name: User-settable and human-readable display name for the Instance.
        :param pulumi.Input[str] gce_zone: The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
        :param pulumi.Input[str] instance_id: The ID of the alloydb instance.
        :param pulumi.Input[str] instance_type: The type of the instance.
               Possible values are `PRIMARY` and `READ_POOL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for the alloydb instance.
        :param pulumi.Input[pulumi.InputType['InstanceMachineConfigArgs']] machine_config: Configurations for the machines that host the underlying database engine.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['InstanceReadPoolConfigArgs']] read_pool_config: Read pool specific config.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage
        ### Alloydb Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default_network = gcp.compute.Network("defaultNetwork", opts=pulumi.ResourceOptions(provider=google_beta))
        default_cluster = gcp.alloydb.Cluster("defaultCluster",
            cluster_id="alloydb-cluster",
            location="us-central1",
            network=default_network.name.apply(lambda name: f"projects/{project.number}/global/networks/{name}"),
            initial_user=gcp.alloydb.ClusterInitialUserArgs(
                password="alloydb-cluster",
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        private_ip_alloc = gcp.compute.GlobalAddress("privateIpAlloc",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=16,
            network=default_network.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        vpc_connection = gcp.servicenetworking.Connection("vpcConnection",
            network=default_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name],
            opts=pulumi.ResourceOptions(provider=google_beta))
        default_instance = gcp.alloydb.Instance("defaultInstance",
            cluster=default_cluster.name,
            instance_id="alloydb-instance",
            instance_type="PRIMARY",
            machine_config=gcp.alloydb.InstanceMachineConfigArgs(
                cpu_count=2,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[vpc_connection]))
        ```

        ## Import

        Instance can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:alloydb/instance:Instance default {{cluster}}/instances/{{instance_id}}
        ```

        ```sh
         $ pulumi import gcp:alloydb/instance:Instance default {{cluster}}/{{instance_id}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 availability_type: Optional[pulumi.Input[str]] = None,
                 cluster: Optional[pulumi.Input[str]] = None,
                 database_flags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 gce_zone: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 machine_config: Optional[pulumi.Input[pulumi.InputType['InstanceMachineConfigArgs']]] = None,
                 read_pool_config: Optional[pulumi.Input[pulumi.InputType['InstanceReadPoolConfigArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["availability_type"] = availability_type
            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["database_flags"] = database_flags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["gce_zone"] = gce_zone
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["labels"] = labels
            __props__.__dict__["machine_config"] = machine_config
            __props__.__dict__["read_pool_config"] = read_pool_config
            __props__.__dict__["create_time"] = None
            __props__.__dict__["ip_address"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(Instance, __self__).__init__(
            'gcp:alloydb/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            availability_type: Optional[pulumi.Input[str]] = None,
            cluster: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            database_flags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            gce_zone: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            machine_config: Optional[pulumi.Input[pulumi.InputType['InstanceMachineConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            read_pool_config: Optional[pulumi.Input[pulumi.InputType['InstanceReadPoolConfigArgs']]] = None,
            reconciling: Optional[pulumi.Input[bool]] = None,
            state: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
        :param pulumi.Input[str] availability_type: Availability type of an Instance. Defaults to REGIONAL for both primary and read instances. Note that primary and read instances can have different availability types.
               Possible values are `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, and `REGIONAL`.
        :param pulumi.Input[str] cluster: Identifies the alloydb cluster. Must be in the format
               'projects/{project}/locations/{location}/clusters/{cluster_id}'
        :param pulumi.Input[str] create_time: Time the Instance was created in UTC.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] database_flags: Database flags. Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
        :param pulumi.Input[str] display_name: User-settable and human-readable display name for the Instance.
        :param pulumi.Input[str] gce_zone: The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
        :param pulumi.Input[str] instance_id: The ID of the alloydb instance.
        :param pulumi.Input[str] instance_type: The type of the instance.
               Possible values are `PRIMARY` and `READ_POOL`.
        :param pulumi.Input[str] ip_address: The IP address for the Instance. This is the connection endpoint for an end-user application.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for the alloydb instance.
        :param pulumi.Input[pulumi.InputType['InstanceMachineConfigArgs']] machine_config: Configurations for the machines that host the underlying database engine.
               Structure is documented below.
        :param pulumi.Input[str] name: The name of the instance resource.
        :param pulumi.Input[pulumi.InputType['InstanceReadPoolConfigArgs']] read_pool_config: Read pool specific config.
               Structure is documented below.
        :param pulumi.Input[bool] reconciling: Set to true if the current state of Instance does not match the user's intended state, and the service is actively updating the resource to reconcile them. This can happen due to user-triggered updates or system actions like failover or maintenance.
        :param pulumi.Input[str] state: The current state of the alloydb instance.
        :param pulumi.Input[str] uid: The system-generated UID of the resource.
        :param pulumi.Input[str] update_time: Time the Instance was updated in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["availability_type"] = availability_type
        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["database_flags"] = database_flags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["gce_zone"] = gce_zone
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["labels"] = labels
        __props__.__dict__["machine_config"] = machine_config
        __props__.__dict__["name"] = name
        __props__.__dict__["read_pool_config"] = read_pool_config
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["state"] = state
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Annotations to allow client tools to store small amount of arbitrary data. This is distinct from labels.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> pulumi.Output[str]:
        """
        Availability type of an Instance. Defaults to REGIONAL for both primary and read instances. Note that primary and read instances can have different availability types.
        Possible values are `AVAILABILITY_TYPE_UNSPECIFIED`, `ZONAL`, and `REGIONAL`.
        """
        return pulumi.get(self, "availability_type")

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[str]:
        """
        Identifies the alloydb cluster. Must be in the format
        'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time the Instance was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Database flags. Set at instance level. * They are copied from primary instance on read instance creation. * Read instances can set new or override existing flags that are relevant for reads, e.g. for enabling columnar cache on a read instance. Flags set on read instance may or may not be present on primary.
        """
        return pulumi.get(self, "database_flags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        User-settable and human-readable display name for the Instance.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="gceZone")
    def gce_zone(self) -> pulumi.Output[Optional[str]]:
        """
        The Compute Engine zone that the instance should serve from, per https://cloud.google.com/compute/docs/regions-zones This can ONLY be specified for ZONAL instances. If present for a REGIONAL instance, an error will be thrown. If this is absent for a ZONAL instance, instance is created in a random zone with available capacity.
        """
        return pulumi.get(self, "gce_zone")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The ID of the alloydb instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        The type of the instance.
        Possible values are `PRIMARY` and `READ_POOL`.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The IP address for the Instance. This is the connection endpoint for an end-user application.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        User-defined labels for the alloydb instance.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="machineConfig")
    def machine_config(self) -> pulumi.Output['outputs.InstanceMachineConfig']:
        """
        Configurations for the machines that host the underlying database engine.
        Structure is documented below.
        """
        return pulumi.get(self, "machine_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the instance resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readPoolConfig")
    def read_pool_config(self) -> pulumi.Output[Optional['outputs.InstanceReadPoolConfig']]:
        """
        Read pool specific config.
        Structure is documented below.
        """
        return pulumi.get(self, "read_pool_config")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[bool]:
        """
        Set to true if the current state of Instance does not match the user's intended state, and the service is actively updating the resource to reconcile them. This can happen due to user-triggered updates or system actions like failover or maintenance.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the alloydb instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        The system-generated UID of the resource.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Time the Instance was updated in UTC.
        """
        return pulumi.get(self, "update_time")

