# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SyncAuthorizationArgs', 'SyncAuthorization']

@pulumi.input_type
class SyncAuthorizationArgs:
    def __init__(__self__, *,
                 identities: pulumi.Input[Sequence[pulumi.Input[str]]],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SyncAuthorization resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identities: Array of service accounts to grant access to control plane resources, each specified using the following format: `serviceAccount:service-account-name`.
               The `service-account-name` is formatted like an email address. For example: my-synchronizer-manager-serviceAccount@my_project_id.iam.gserviceaccount.com
               You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
               The service accounts must have **Apigee Synchronizer Manager** role. See also [Create service accounts](https://cloud.google.com/apigee/docs/hybrid/v1.8/sa-about#create-the-service-accounts).
        :param pulumi.Input[str] name: Name of the Apigee organization.
        """
        pulumi.set(__self__, "identities", identities)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def identities(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Array of service accounts to grant access to control plane resources, each specified using the following format: `serviceAccount:service-account-name`.
        The `service-account-name` is formatted like an email address. For example: my-synchronizer-manager-serviceAccount@my_project_id.iam.gserviceaccount.com
        You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
        The service accounts must have **Apigee Synchronizer Manager** role. See also [Create service accounts](https://cloud.google.com/apigee/docs/hybrid/v1.8/sa-about#create-the-service-accounts).
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "identities", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Apigee organization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SyncAuthorizationState:
    def __init__(__self__, *,
                 etag: Optional[pulumi.Input[str]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SyncAuthorization resources.
        :param pulumi.Input[str] etag: Entity tag (ETag) used for optimistic concurrency control as a way to help prevent simultaneous updates from overwriting each other.
               Used internally during updates.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identities: Array of service accounts to grant access to control plane resources, each specified using the following format: `serviceAccount:service-account-name`.
               The `service-account-name` is formatted like an email address. For example: my-synchronizer-manager-serviceAccount@my_project_id.iam.gserviceaccount.com
               You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
               The service accounts must have **Apigee Synchronizer Manager** role. See also [Create service accounts](https://cloud.google.com/apigee/docs/hybrid/v1.8/sa-about#create-the-service-accounts).
        :param pulumi.Input[str] name: Name of the Apigee organization.
        """
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Entity tag (ETag) used for optimistic concurrency control as a way to help prevent simultaneous updates from overwriting each other.
        Used internally during updates.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Array of service accounts to grant access to control plane resources, each specified using the following format: `serviceAccount:service-account-name`.
        The `service-account-name` is formatted like an email address. For example: my-synchronizer-manager-serviceAccount@my_project_id.iam.gserviceaccount.com
        You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
        The service accounts must have **Apigee Synchronizer Manager** role. See also [Create service accounts](https://cloud.google.com/apigee/docs/hybrid/v1.8/sa-about#create-the-service-accounts).
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "identities", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Apigee organization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


class SyncAuthorization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Authorize the Synchronizer to download environment data from the control plane.

        To get more information about SyncAuthorization, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations#getsyncauthorization)
        * How-to Guides
            * [Enable Synchronizer access](https://cloud.google.com/apigee/docs/hybrid/v1.8/synchronizer-access#enable-synchronizer-access)

        ## Example Usage
        ### Apigee Sync Authorization Basic Test

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="my-project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000")
        apigee = gcp.projects.Service("apigee",
            project=project.project_id,
            service="apigee.googleapis.com")
        apigee_org = gcp.apigee.Organization("apigeeOrg",
            analytics_region="us-central1",
            project_id=project.project_id,
            runtime_type="HYBRID",
            opts=pulumi.ResourceOptions(depends_on=[apigee]))
        service_account = gcp.service_account.Account("serviceAccount",
            account_id="my-account",
            display_name="Service Account")
        synchronizer_iam = gcp.projects.IAMBinding("synchronizer-iam",
            project=project.project_id,
            role="roles/apigee.synchronizerManager",
            members=[service_account.email.apply(lambda email: f"serviceAccount:{email}")])
        apigee_sync_authorization = gcp.apigee.SyncAuthorization("apigeeSyncAuthorization", identities=[service_account.email.apply(lambda email: f"serviceAccount:{email}")],
        opts=pulumi.ResourceOptions(depends_on=[synchronizer_iam]))
        ```

        ## Import

        SyncAuthorization can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:apigee/syncAuthorization:SyncAuthorization default organizations/{{name}}/syncAuthorization
        ```

        ```sh
         $ pulumi import gcp:apigee/syncAuthorization:SyncAuthorization default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identities: Array of service accounts to grant access to control plane resources, each specified using the following format: `serviceAccount:service-account-name`.
               The `service-account-name` is formatted like an email address. For example: my-synchronizer-manager-serviceAccount@my_project_id.iam.gserviceaccount.com
               You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
               The service accounts must have **Apigee Synchronizer Manager** role. See also [Create service accounts](https://cloud.google.com/apigee/docs/hybrid/v1.8/sa-about#create-the-service-accounts).
        :param pulumi.Input[str] name: Name of the Apigee organization.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SyncAuthorizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Authorize the Synchronizer to download environment data from the control plane.

        To get more information about SyncAuthorization, see:

        * [API documentation](https://cloud.google.com/apigee/docs/reference/apis/apigee/rest/v1/organizations#getsyncauthorization)
        * How-to Guides
            * [Enable Synchronizer access](https://cloud.google.com/apigee/docs/hybrid/v1.8/synchronizer-access#enable-synchronizer-access)

        ## Example Usage
        ### Apigee Sync Authorization Basic Test

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="my-project",
            org_id="123456789",
            billing_account="000000-0000000-0000000-000000")
        apigee = gcp.projects.Service("apigee",
            project=project.project_id,
            service="apigee.googleapis.com")
        apigee_org = gcp.apigee.Organization("apigeeOrg",
            analytics_region="us-central1",
            project_id=project.project_id,
            runtime_type="HYBRID",
            opts=pulumi.ResourceOptions(depends_on=[apigee]))
        service_account = gcp.service_account.Account("serviceAccount",
            account_id="my-account",
            display_name="Service Account")
        synchronizer_iam = gcp.projects.IAMBinding("synchronizer-iam",
            project=project.project_id,
            role="roles/apigee.synchronizerManager",
            members=[service_account.email.apply(lambda email: f"serviceAccount:{email}")])
        apigee_sync_authorization = gcp.apigee.SyncAuthorization("apigeeSyncAuthorization", identities=[service_account.email.apply(lambda email: f"serviceAccount:{email}")],
        opts=pulumi.ResourceOptions(depends_on=[synchronizer_iam]))
        ```

        ## Import

        SyncAuthorization can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:apigee/syncAuthorization:SyncAuthorization default organizations/{{name}}/syncAuthorization
        ```

        ```sh
         $ pulumi import gcp:apigee/syncAuthorization:SyncAuthorization default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SyncAuthorizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SyncAuthorizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SyncAuthorizationArgs.__new__(SyncAuthorizationArgs)

            if identities is None and not opts.urn:
                raise TypeError("Missing required property 'identities'")
            __props__.__dict__["identities"] = identities
            __props__.__dict__["name"] = name
            __props__.__dict__["etag"] = None
        super(SyncAuthorization, __self__).__init__(
            'gcp:apigee/syncAuthorization:SyncAuthorization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            etag: Optional[pulumi.Input[str]] = None,
            identities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'SyncAuthorization':
        """
        Get an existing SyncAuthorization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] etag: Entity tag (ETag) used for optimistic concurrency control as a way to help prevent simultaneous updates from overwriting each other.
               Used internally during updates.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] identities: Array of service accounts to grant access to control plane resources, each specified using the following format: `serviceAccount:service-account-name`.
               The `service-account-name` is formatted like an email address. For example: my-synchronizer-manager-serviceAccount@my_project_id.iam.gserviceaccount.com
               You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
               The service accounts must have **Apigee Synchronizer Manager** role. See also [Create service accounts](https://cloud.google.com/apigee/docs/hybrid/v1.8/sa-about#create-the-service-accounts).
        :param pulumi.Input[str] name: Name of the Apigee organization.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SyncAuthorizationState.__new__(_SyncAuthorizationState)

        __props__.__dict__["etag"] = etag
        __props__.__dict__["identities"] = identities
        __props__.__dict__["name"] = name
        return SyncAuthorization(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        Entity tag (ETag) used for optimistic concurrency control as a way to help prevent simultaneous updates from overwriting each other.
        Used internally during updates.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def identities(self) -> pulumi.Output[Sequence[str]]:
        """
        Array of service accounts to grant access to control plane resources, each specified using the following format: `serviceAccount:service-account-name`.
        The `service-account-name` is formatted like an email address. For example: my-synchronizer-manager-serviceAccount@my_project_id.iam.gserviceaccount.com
        You might specify multiple service accounts, for example, if you have multiple environments and wish to assign a unique service account to each one.
        The service accounts must have **Apigee Synchronizer Manager** role. See also [Create service accounts](https://cloud.google.com/apigee/docs/hybrid/v1.8/sa-about#create-the-service-accounts).
        """
        return pulumi.get(self, "identities")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the Apigee organization.
        """
        return pulumi.get(self, "name")

