# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ListingArgs', 'Listing']

@pulumi.input_type
class ListingArgs:
    def __init__(__self__, *,
                 bigquery_dataset: pulumi.Input['ListingBigqueryDatasetArgs'],
                 data_exchange_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 listing_id: pulumi.Input[str],
                 location: pulumi.Input[str],
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_provider: Optional[pulumi.Input['ListingDataProviderArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 documentation: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 primary_contact: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input['ListingPublisherArgs']] = None,
                 request_access: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Listing resource.
        :param pulumi.Input['ListingBigqueryDatasetArgs'] bigquery_dataset: Shared dataset i.e. BigQuery dataset source.
               Structure is documented below.
        :param pulumi.Input[str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[str] display_name: Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
        :param pulumi.Input[str] listing_id: The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[str] location: The name of the location this data exchange listing.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] categories: Categories of the listing. Up to two categories are allowed.
        :param pulumi.Input['ListingDataProviderArgs'] data_provider: Details of the data provider who owns the source data.
               Structure is documented below.
        :param pulumi.Input[str] description: Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
        :param pulumi.Input[str] documentation: Documentation describing the listing.
        :param pulumi.Input[str] icon: Base64 encoded image representing the listing.
        :param pulumi.Input[str] primary_contact: Email or URL of the primary point of contact of the listing.
               (Optional)
               Email or URL of the data provider.
               (Optional)
               Email or URL of the listing publisher.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ListingPublisherArgs'] publisher: Details of the publisher who owns the listing and who can share the source data.
               Structure is documented below.
        :param pulumi.Input[str] request_access: Email or URL of the request access of the listing. Subscribers can use this reference to request access.
        """
        pulumi.set(__self__, "bigquery_dataset", bigquery_dataset)
        pulumi.set(__self__, "data_exchange_id", data_exchange_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "listing_id", listing_id)
        pulumi.set(__self__, "location", location)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if data_provider is not None:
            pulumi.set(__self__, "data_provider", data_provider)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if documentation is not None:
            pulumi.set(__self__, "documentation", documentation)
        if icon is not None:
            pulumi.set(__self__, "icon", icon)
        if primary_contact is not None:
            pulumi.set(__self__, "primary_contact", primary_contact)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if request_access is not None:
            pulumi.set(__self__, "request_access", request_access)

    @property
    @pulumi.getter(name="bigqueryDataset")
    def bigquery_dataset(self) -> pulumi.Input['ListingBigqueryDatasetArgs']:
        """
        Shared dataset i.e. BigQuery dataset source.
        Structure is documented below.
        """
        return pulumi.get(self, "bigquery_dataset")

    @bigquery_dataset.setter
    def bigquery_dataset(self, value: pulumi.Input['ListingBigqueryDatasetArgs']):
        pulumi.set(self, "bigquery_dataset", value)

    @property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> pulumi.Input[str]:
        """
        The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "data_exchange_id")

    @data_exchange_id.setter
    def data_exchange_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_exchange_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> pulumi.Input[str]:
        """
        The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "listing_id")

    @listing_id.setter
    def listing_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "listing_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The name of the location this data exchange listing.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Categories of the listing. Up to two categories are allowed.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter(name="dataProvider")
    def data_provider(self) -> Optional[pulumi.Input['ListingDataProviderArgs']]:
        """
        Details of the data provider who owns the source data.
        Structure is documented below.
        """
        return pulumi.get(self, "data_provider")

    @data_provider.setter
    def data_provider(self, value: Optional[pulumi.Input['ListingDataProviderArgs']]):
        pulumi.set(self, "data_provider", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def documentation(self) -> Optional[pulumi.Input[str]]:
        """
        Documentation describing the listing.
        """
        return pulumi.get(self, "documentation")

    @documentation.setter
    def documentation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "documentation", value)

    @property
    @pulumi.getter
    def icon(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 encoded image representing the listing.
        """
        return pulumi.get(self, "icon")

    @icon.setter
    def icon(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon", value)

    @property
    @pulumi.getter(name="primaryContact")
    def primary_contact(self) -> Optional[pulumi.Input[str]]:
        """
        Email or URL of the primary point of contact of the listing.
        (Optional)
        Email or URL of the data provider.
        (Optional)
        Email or URL of the listing publisher.
        """
        return pulumi.get(self, "primary_contact")

    @primary_contact.setter
    def primary_contact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_contact", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input['ListingPublisherArgs']]:
        """
        Details of the publisher who owns the listing and who can share the source data.
        Structure is documented below.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input['ListingPublisherArgs']]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter(name="requestAccess")
    def request_access(self) -> Optional[pulumi.Input[str]]:
        """
        Email or URL of the request access of the listing. Subscribers can use this reference to request access.
        """
        return pulumi.get(self, "request_access")

    @request_access.setter
    def request_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_access", value)


@pulumi.input_type
class _ListingState:
    def __init__(__self__, *,
                 bigquery_dataset: Optional[pulumi.Input['ListingBigqueryDatasetArgs']] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_exchange_id: Optional[pulumi.Input[str]] = None,
                 data_provider: Optional[pulumi.Input['ListingDataProviderArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 documentation: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 listing_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_contact: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input['ListingPublisherArgs']] = None,
                 request_access: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Listing resources.
        :param pulumi.Input['ListingBigqueryDatasetArgs'] bigquery_dataset: Shared dataset i.e. BigQuery dataset source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] categories: Categories of the listing. Up to two categories are allowed.
        :param pulumi.Input[str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input['ListingDataProviderArgs'] data_provider: Details of the data provider who owns the source data.
               Structure is documented below.
        :param pulumi.Input[str] description: Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
        :param pulumi.Input[str] display_name: Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
        :param pulumi.Input[str] documentation: Documentation describing the listing.
        :param pulumi.Input[str] icon: Base64 encoded image representing the listing.
        :param pulumi.Input[str] listing_id: The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[str] location: The name of the location this data exchange listing.
        :param pulumi.Input[str] name: Name of the data provider.
               (Required)
               Name of the listing publisher.
        :param pulumi.Input[str] primary_contact: Email or URL of the primary point of contact of the listing.
               (Optional)
               Email or URL of the data provider.
               (Optional)
               Email or URL of the listing publisher.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ListingPublisherArgs'] publisher: Details of the publisher who owns the listing and who can share the source data.
               Structure is documented below.
        :param pulumi.Input[str] request_access: Email or URL of the request access of the listing. Subscribers can use this reference to request access.
        """
        if bigquery_dataset is not None:
            pulumi.set(__self__, "bigquery_dataset", bigquery_dataset)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if data_exchange_id is not None:
            pulumi.set(__self__, "data_exchange_id", data_exchange_id)
        if data_provider is not None:
            pulumi.set(__self__, "data_provider", data_provider)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if documentation is not None:
            pulumi.set(__self__, "documentation", documentation)
        if icon is not None:
            pulumi.set(__self__, "icon", icon)
        if listing_id is not None:
            pulumi.set(__self__, "listing_id", listing_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_contact is not None:
            pulumi.set(__self__, "primary_contact", primary_contact)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if request_access is not None:
            pulumi.set(__self__, "request_access", request_access)

    @property
    @pulumi.getter(name="bigqueryDataset")
    def bigquery_dataset(self) -> Optional[pulumi.Input['ListingBigqueryDatasetArgs']]:
        """
        Shared dataset i.e. BigQuery dataset source.
        Structure is documented below.
        """
        return pulumi.get(self, "bigquery_dataset")

    @bigquery_dataset.setter
    def bigquery_dataset(self, value: Optional[pulumi.Input['ListingBigqueryDatasetArgs']]):
        pulumi.set(self, "bigquery_dataset", value)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Categories of the listing. Up to two categories are allowed.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "data_exchange_id")

    @data_exchange_id.setter
    def data_exchange_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_exchange_id", value)

    @property
    @pulumi.getter(name="dataProvider")
    def data_provider(self) -> Optional[pulumi.Input['ListingDataProviderArgs']]:
        """
        Details of the data provider who owns the source data.
        Structure is documented below.
        """
        return pulumi.get(self, "data_provider")

    @data_provider.setter
    def data_provider(self, value: Optional[pulumi.Input['ListingDataProviderArgs']]):
        pulumi.set(self, "data_provider", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def documentation(self) -> Optional[pulumi.Input[str]]:
        """
        Documentation describing the listing.
        """
        return pulumi.get(self, "documentation")

    @documentation.setter
    def documentation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "documentation", value)

    @property
    @pulumi.getter
    def icon(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 encoded image representing the listing.
        """
        return pulumi.get(self, "icon")

    @icon.setter
    def icon(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon", value)

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "listing_id")

    @listing_id.setter
    def listing_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listing_id", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the location this data exchange listing.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the data provider.
        (Required)
        Name of the listing publisher.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="primaryContact")
    def primary_contact(self) -> Optional[pulumi.Input[str]]:
        """
        Email or URL of the primary point of contact of the listing.
        (Optional)
        Email or URL of the data provider.
        (Optional)
        Email or URL of the listing publisher.
        """
        return pulumi.get(self, "primary_contact")

    @primary_contact.setter
    def primary_contact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_contact", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input['ListingPublisherArgs']]:
        """
        Details of the publisher who owns the listing and who can share the source data.
        Structure is documented below.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input['ListingPublisherArgs']]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter(name="requestAccess")
    def request_access(self) -> Optional[pulumi.Input[str]]:
        """
        Email or URL of the request access of the listing. Subscribers can use this reference to request access.
        """
        return pulumi.get(self, "request_access")

    @request_access.setter
    def request_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_access", value)


class Listing(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bigquery_dataset: Optional[pulumi.Input[pulumi.InputType['ListingBigqueryDatasetArgs']]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_exchange_id: Optional[pulumi.Input[str]] = None,
                 data_provider: Optional[pulumi.Input[pulumi.InputType['ListingDataProviderArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 documentation: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 listing_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 primary_contact: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[pulumi.InputType['ListingPublisherArgs']]] = None,
                 request_access: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A Bigquery Analytics Hub data exchange listing

        To get more information about Listing, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/analytics-hub/rest/v1/projects.locations.dataExchanges.listings)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/bigquery/docs/analytics-hub-introduction)

        ## Example Usage
        ### Bigquery Analyticshub Listing Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        listing_data_exchange = gcp.bigqueryanalyticshub.DataExchange("listingDataExchange",
            location="US",
            data_exchange_id="my_data_exchange",
            display_name="my_data_exchange",
            description="example data exchange")
        listing_dataset = gcp.bigquery.Dataset("listingDataset",
            dataset_id="my_listing",
            friendly_name="my_listing",
            description="example data exchange",
            location="US")
        listing_listing = gcp.bigqueryanalyticshub.Listing("listingListing",
            location="US",
            data_exchange_id=listing_data_exchange.data_exchange_id,
            listing_id="my_listing",
            display_name="my_listing",
            description="example data exchange",
            bigquery_dataset=gcp.bigqueryanalyticshub.ListingBigqueryDatasetArgs(
                dataset=listing_dataset.id,
            ))
        ```

        ## Import

        Listing can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:bigqueryanalyticshub/listing:Listing default projects/{{project}}/locations/{{location}}/dataExchanges/{{data_exchange_id}}/listings/{{listing_id}}
        ```

        ```sh
         $ pulumi import gcp:bigqueryanalyticshub/listing:Listing default {{project}}/{{location}}/{{data_exchange_id}}/{{listing_id}}
        ```

        ```sh
         $ pulumi import gcp:bigqueryanalyticshub/listing:Listing default {{location}}/{{data_exchange_id}}/{{listing_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ListingBigqueryDatasetArgs']] bigquery_dataset: Shared dataset i.e. BigQuery dataset source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] categories: Categories of the listing. Up to two categories are allowed.
        :param pulumi.Input[str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[pulumi.InputType['ListingDataProviderArgs']] data_provider: Details of the data provider who owns the source data.
               Structure is documented below.
        :param pulumi.Input[str] description: Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
        :param pulumi.Input[str] display_name: Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
        :param pulumi.Input[str] documentation: Documentation describing the listing.
        :param pulumi.Input[str] icon: Base64 encoded image representing the listing.
        :param pulumi.Input[str] listing_id: The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[str] location: The name of the location this data exchange listing.
        :param pulumi.Input[str] primary_contact: Email or URL of the primary point of contact of the listing.
               (Optional)
               Email or URL of the data provider.
               (Optional)
               Email or URL of the listing publisher.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['ListingPublisherArgs']] publisher: Details of the publisher who owns the listing and who can share the source data.
               Structure is documented below.
        :param pulumi.Input[str] request_access: Email or URL of the request access of the listing. Subscribers can use this reference to request access.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Bigquery Analytics Hub data exchange listing

        To get more information about Listing, see:

        * [API documentation](https://cloud.google.com/bigquery/docs/reference/analytics-hub/rest/v1/projects.locations.dataExchanges.listings)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/bigquery/docs/analytics-hub-introduction)

        ## Example Usage
        ### Bigquery Analyticshub Listing Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        listing_data_exchange = gcp.bigqueryanalyticshub.DataExchange("listingDataExchange",
            location="US",
            data_exchange_id="my_data_exchange",
            display_name="my_data_exchange",
            description="example data exchange")
        listing_dataset = gcp.bigquery.Dataset("listingDataset",
            dataset_id="my_listing",
            friendly_name="my_listing",
            description="example data exchange",
            location="US")
        listing_listing = gcp.bigqueryanalyticshub.Listing("listingListing",
            location="US",
            data_exchange_id=listing_data_exchange.data_exchange_id,
            listing_id="my_listing",
            display_name="my_listing",
            description="example data exchange",
            bigquery_dataset=gcp.bigqueryanalyticshub.ListingBigqueryDatasetArgs(
                dataset=listing_dataset.id,
            ))
        ```

        ## Import

        Listing can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:bigqueryanalyticshub/listing:Listing default projects/{{project}}/locations/{{location}}/dataExchanges/{{data_exchange_id}}/listings/{{listing_id}}
        ```

        ```sh
         $ pulumi import gcp:bigqueryanalyticshub/listing:Listing default {{project}}/{{location}}/{{data_exchange_id}}/{{listing_id}}
        ```

        ```sh
         $ pulumi import gcp:bigqueryanalyticshub/listing:Listing default {{location}}/{{data_exchange_id}}/{{listing_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ListingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bigquery_dataset: Optional[pulumi.Input[pulumi.InputType['ListingBigqueryDatasetArgs']]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 data_exchange_id: Optional[pulumi.Input[str]] = None,
                 data_provider: Optional[pulumi.Input[pulumi.InputType['ListingDataProviderArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 documentation: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 listing_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 primary_contact: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[pulumi.InputType['ListingPublisherArgs']]] = None,
                 request_access: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListingArgs.__new__(ListingArgs)

            if bigquery_dataset is None and not opts.urn:
                raise TypeError("Missing required property 'bigquery_dataset'")
            __props__.__dict__["bigquery_dataset"] = bigquery_dataset
            __props__.__dict__["categories"] = categories
            if data_exchange_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_exchange_id'")
            __props__.__dict__["data_exchange_id"] = data_exchange_id
            __props__.__dict__["data_provider"] = data_provider
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["documentation"] = documentation
            __props__.__dict__["icon"] = icon
            if listing_id is None and not opts.urn:
                raise TypeError("Missing required property 'listing_id'")
            __props__.__dict__["listing_id"] = listing_id
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["primary_contact"] = primary_contact
            __props__.__dict__["project"] = project
            __props__.__dict__["publisher"] = publisher
            __props__.__dict__["request_access"] = request_access
            __props__.__dict__["name"] = None
        super(Listing, __self__).__init__(
            'gcp:bigqueryanalyticshub/listing:Listing',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bigquery_dataset: Optional[pulumi.Input[pulumi.InputType['ListingBigqueryDatasetArgs']]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            data_exchange_id: Optional[pulumi.Input[str]] = None,
            data_provider: Optional[pulumi.Input[pulumi.InputType['ListingDataProviderArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            documentation: Optional[pulumi.Input[str]] = None,
            icon: Optional[pulumi.Input[str]] = None,
            listing_id: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            primary_contact: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            publisher: Optional[pulumi.Input[pulumi.InputType['ListingPublisherArgs']]] = None,
            request_access: Optional[pulumi.Input[str]] = None) -> 'Listing':
        """
        Get an existing Listing resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ListingBigqueryDatasetArgs']] bigquery_dataset: Shared dataset i.e. BigQuery dataset source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] categories: Categories of the listing. Up to two categories are allowed.
        :param pulumi.Input[str] data_exchange_id: The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[pulumi.InputType['ListingDataProviderArgs']] data_provider: Details of the data provider who owns the source data.
               Structure is documented below.
        :param pulumi.Input[str] description: Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
        :param pulumi.Input[str] display_name: Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
        :param pulumi.Input[str] documentation: Documentation describing the listing.
        :param pulumi.Input[str] icon: Base64 encoded image representing the listing.
        :param pulumi.Input[str] listing_id: The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        :param pulumi.Input[str] location: The name of the location this data exchange listing.
        :param pulumi.Input[str] name: Name of the data provider.
               (Required)
               Name of the listing publisher.
        :param pulumi.Input[str] primary_contact: Email or URL of the primary point of contact of the listing.
               (Optional)
               Email or URL of the data provider.
               (Optional)
               Email or URL of the listing publisher.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['ListingPublisherArgs']] publisher: Details of the publisher who owns the listing and who can share the source data.
               Structure is documented below.
        :param pulumi.Input[str] request_access: Email or URL of the request access of the listing. Subscribers can use this reference to request access.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListingState.__new__(_ListingState)

        __props__.__dict__["bigquery_dataset"] = bigquery_dataset
        __props__.__dict__["categories"] = categories
        __props__.__dict__["data_exchange_id"] = data_exchange_id
        __props__.__dict__["data_provider"] = data_provider
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["documentation"] = documentation
        __props__.__dict__["icon"] = icon
        __props__.__dict__["listing_id"] = listing_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_contact"] = primary_contact
        __props__.__dict__["project"] = project
        __props__.__dict__["publisher"] = publisher
        __props__.__dict__["request_access"] = request_access
        return Listing(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bigqueryDataset")
    def bigquery_dataset(self) -> pulumi.Output['outputs.ListingBigqueryDataset']:
        """
        Shared dataset i.e. BigQuery dataset source.
        Structure is documented below.
        """
        return pulumi.get(self, "bigquery_dataset")

    @property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Categories of the listing. Up to two categories are allowed.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> pulumi.Output[str]:
        """
        The ID of the data exchange. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "data_exchange_id")

    @property
    @pulumi.getter(name="dataProvider")
    def data_provider(self) -> pulumi.Output[Optional['outputs.ListingDataProvider']]:
        """
        Details of the data provider who owns the source data.
        Structure is documented below.
        """
        return pulumi.get(self, "data_provider")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def documentation(self) -> pulumi.Output[Optional[str]]:
        """
        Documentation describing the listing.
        """
        return pulumi.get(self, "documentation")

    @property
    @pulumi.getter
    def icon(self) -> pulumi.Output[Optional[str]]:
        """
        Base64 encoded image representing the listing.
        """
        return pulumi.get(self, "icon")

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> pulumi.Output[str]:
        """
        The ID of the listing. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces.
        """
        return pulumi.get(self, "listing_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The name of the location this data exchange listing.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the data provider.
        (Required)
        Name of the listing publisher.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryContact")
    def primary_contact(self) -> pulumi.Output[Optional[str]]:
        """
        Email or URL of the primary point of contact of the listing.
        (Optional)
        Email or URL of the data provider.
        (Optional)
        Email or URL of the listing publisher.
        """
        return pulumi.get(self, "primary_contact")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def publisher(self) -> pulumi.Output[Optional['outputs.ListingPublisher']]:
        """
        Details of the publisher who owns the listing and who can share the source data.
        Structure is documented below.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter(name="requestAccess")
    def request_access(self) -> pulumi.Output[Optional[str]]:
        """
        Email or URL of the request access of the listing. Subscribers can use this reference to request access.
        """
        return pulumi.get(self, "request_access")

