# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TargetArgs', 'Target']

@pulumi.input_type
class TargetArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 anthos_cluster: Optional[pulumi.Input['TargetAnthosClusterArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_configs: Optional[pulumi.Input[Sequence[pulumi.Input['TargetExecutionConfigArgs']]]] = None,
                 gke: Optional[pulumi.Input['TargetGkeArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 require_approval: Optional[pulumi.Input[bool]] = None,
                 run: Optional[pulumi.Input['TargetRunArgs']] = None):
        """
        The set of arguments for constructing a Target resource.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
        :param pulumi.Input['TargetAnthosClusterArgs'] anthos_cluster: Information specifying an Anthos Cluster.
        :param pulumi.Input[str] description: Optional. Description of the `Target`. Max length is 255 characters.
        :param pulumi.Input[Sequence[pulumi.Input['TargetExecutionConfigArgs']]] execution_configs: Configurations for all execution that relates to this `Target`. Each `ExecutionEnvironmentUsage` value may only be used in a single configuration; using the same value multiple times is an error. When one or more configurations are specified, they must include the `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values. When no configurations are specified, execution will use the default specified in `DefaultPool`.
        :param pulumi.Input['TargetGkeArgs'] gke: Information specifying a GKE Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
        :param pulumi.Input[str] name: Name of the `Target`. Format is [a-z][a-z0-9\\-]{0,62}.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[bool] require_approval: Optional. Whether or not the `Target` requires approval.
        :param pulumi.Input['TargetRunArgs'] run: (Beta only) Information specifying a Cloud Run deployment target.
        """
        pulumi.set(__self__, "location", location)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if anthos_cluster is not None:
            pulumi.set(__self__, "anthos_cluster", anthos_cluster)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if execution_configs is not None:
            pulumi.set(__self__, "execution_configs", execution_configs)
        if gke is not None:
            pulumi.set(__self__, "gke", gke)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if require_approval is not None:
            pulumi.set(__self__, "require_approval", require_approval)
        if run is not None:
            pulumi.set(__self__, "run", run)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="anthosCluster")
    def anthos_cluster(self) -> Optional[pulumi.Input['TargetAnthosClusterArgs']]:
        """
        Information specifying an Anthos Cluster.
        """
        return pulumi.get(self, "anthos_cluster")

    @anthos_cluster.setter
    def anthos_cluster(self, value: Optional[pulumi.Input['TargetAnthosClusterArgs']]):
        pulumi.set(self, "anthos_cluster", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the `Target`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="executionConfigs")
    def execution_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetExecutionConfigArgs']]]]:
        """
        Configurations for all execution that relates to this `Target`. Each `ExecutionEnvironmentUsage` value may only be used in a single configuration; using the same value multiple times is an error. When one or more configurations are specified, they must include the `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values. When no configurations are specified, execution will use the default specified in `DefaultPool`.
        """
        return pulumi.get(self, "execution_configs")

    @execution_configs.setter
    def execution_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetExecutionConfigArgs']]]]):
        pulumi.set(self, "execution_configs", value)

    @property
    @pulumi.getter
    def gke(self) -> Optional[pulumi.Input['TargetGkeArgs']]:
        """
        Information specifying a GKE Cluster.
        """
        return pulumi.get(self, "gke")

    @gke.setter
    def gke(self, value: Optional[pulumi.Input['TargetGkeArgs']]):
        pulumi.set(self, "gke", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the `Target`. Format is [a-z][a-z0-9\\-]{0,62}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requireApproval")
    def require_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether or not the `Target` requires approval.
        """
        return pulumi.get(self, "require_approval")

    @require_approval.setter
    def require_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_approval", value)

    @property
    @pulumi.getter
    def run(self) -> Optional[pulumi.Input['TargetRunArgs']]:
        """
        (Beta only) Information specifying a Cloud Run deployment target.
        """
        return pulumi.get(self, "run")

    @run.setter
    def run(self, value: Optional[pulumi.Input['TargetRunArgs']]):
        pulumi.set(self, "run", value)


@pulumi.input_type
class _TargetState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 anthos_cluster: Optional[pulumi.Input['TargetAnthosClusterArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 execution_configs: Optional[pulumi.Input[Sequence[pulumi.Input['TargetExecutionConfigArgs']]]] = None,
                 gke: Optional[pulumi.Input['TargetGkeArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 require_approval: Optional[pulumi.Input[bool]] = None,
                 run: Optional[pulumi.Input['TargetRunArgs']] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Target resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
        :param pulumi.Input['TargetAnthosClusterArgs'] anthos_cluster: Information specifying an Anthos Cluster.
        :param pulumi.Input[str] create_time: Output only. Time at which the `Target` was created.
        :param pulumi.Input[str] description: Optional. Description of the `Target`. Max length is 255 characters.
        :param pulumi.Input[str] etag: Optional. This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[Sequence[pulumi.Input['TargetExecutionConfigArgs']]] execution_configs: Configurations for all execution that relates to this `Target`. Each `ExecutionEnvironmentUsage` value may only be used in a single configuration; using the same value multiple times is an error. When one or more configurations are specified, they must include the `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values. When no configurations are specified, execution will use the default specified in `DefaultPool`.
        :param pulumi.Input['TargetGkeArgs'] gke: Information specifying a GKE Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Name of the `Target`. Format is [a-z][a-z0-9\\-]{0,62}.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[bool] require_approval: Optional. Whether or not the `Target` requires approval.
        :param pulumi.Input['TargetRunArgs'] run: (Beta only) Information specifying a Cloud Run deployment target.
        :param pulumi.Input[str] target_id: Output only. Resource id of the `Target`.
        :param pulumi.Input[str] uid: Output only. Unique identifier of the `Target`.
        :param pulumi.Input[str] update_time: Output only. Most recent time at which the `Target` was updated.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if anthos_cluster is not None:
            pulumi.set(__self__, "anthos_cluster", anthos_cluster)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if execution_configs is not None:
            pulumi.set(__self__, "execution_configs", execution_configs)
        if gke is not None:
            pulumi.set(__self__, "gke", gke)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if require_approval is not None:
            pulumi.set(__self__, "require_approval", require_approval)
        if run is not None:
            pulumi.set(__self__, "run", run)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="anthosCluster")
    def anthos_cluster(self) -> Optional[pulumi.Input['TargetAnthosClusterArgs']]:
        """
        Information specifying an Anthos Cluster.
        """
        return pulumi.get(self, "anthos_cluster")

    @anthos_cluster.setter
    def anthos_cluster(self, value: Optional[pulumi.Input['TargetAnthosClusterArgs']]):
        pulumi.set(self, "anthos_cluster", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Time at which the `Target` was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the `Target`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="executionConfigs")
    def execution_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetExecutionConfigArgs']]]]:
        """
        Configurations for all execution that relates to this `Target`. Each `ExecutionEnvironmentUsage` value may only be used in a single configuration; using the same value multiple times is an error. When one or more configurations are specified, they must include the `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values. When no configurations are specified, execution will use the default specified in `DefaultPool`.
        """
        return pulumi.get(self, "execution_configs")

    @execution_configs.setter
    def execution_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetExecutionConfigArgs']]]]):
        pulumi.set(self, "execution_configs", value)

    @property
    @pulumi.getter
    def gke(self) -> Optional[pulumi.Input['TargetGkeArgs']]:
        """
        Information specifying a GKE Cluster.
        """
        return pulumi.get(self, "gke")

    @gke.setter
    def gke(self, value: Optional[pulumi.Input['TargetGkeArgs']]):
        pulumi.set(self, "gke", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the `Target`. Format is [a-z][a-z0-9\\-]{0,62}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requireApproval")
    def require_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether or not the `Target` requires approval.
        """
        return pulumi.get(self, "require_approval")

    @require_approval.setter
    def require_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_approval", value)

    @property
    @pulumi.getter
    def run(self) -> Optional[pulumi.Input['TargetRunArgs']]:
        """
        (Beta only) Information specifying a Cloud Run deployment target.
        """
        return pulumi.get(self, "run")

    @run.setter
    def run(self, value: Optional[pulumi.Input['TargetRunArgs']]):
        pulumi.set(self, "run", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Resource id of the `Target`.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Unique identifier of the `Target`.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Most recent time at which the `Target` was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class Target(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 anthos_cluster: Optional[pulumi.Input[pulumi.InputType['TargetAnthosClusterArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetExecutionConfigArgs']]]]] = None,
                 gke: Optional[pulumi.Input[pulumi.InputType['TargetGkeArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 require_approval: Optional[pulumi.Input[bool]] = None,
                 run: Optional[pulumi.Input[pulumi.InputType['TargetRunArgs']]] = None,
                 __props__=None):
        """
        The Cloud Deploy `Target` resource

        ## Example Usage
        ### Run_target
        tests creating and updating a cloud run target
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.Target("primary",
            location="us-west1",
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            description="basic description",
            execution_configs=[gcp.clouddeploy.TargetExecutionConfigArgs(
                usages=[
                    "RENDER",
                    "DEPLOY",
                ],
                execution_timeout="3600s",
            )],
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            },
            project="my-project-name",
            require_approval=False,
            run=gcp.clouddeploy.TargetRunArgs(
                location="projects/my-project-name/locations/us-west1",
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Target
        Creates a basic Cloud Deploy target
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.Target("primary",
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            description="basic description",
            gke=gcp.clouddeploy.TargetGkeArgs(
                cluster="projects/my-project-name/locations/us-west1/clusters/example-cluster-name",
            ),
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            },
            location="us-west1",
            project="my-project-name",
            require_approval=False)
        ```

        ## Import

        Target can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:clouddeploy/target:Target default projects/{{project}}/locations/{{location}}/targets/{{name}}
        ```

        ```sh
         $ pulumi import gcp:clouddeploy/target:Target default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:clouddeploy/target:Target default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
        :param pulumi.Input[pulumi.InputType['TargetAnthosClusterArgs']] anthos_cluster: Information specifying an Anthos Cluster.
        :param pulumi.Input[str] description: Optional. Description of the `Target`. Max length is 255 characters.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetExecutionConfigArgs']]]] execution_configs: Configurations for all execution that relates to this `Target`. Each `ExecutionEnvironmentUsage` value may only be used in a single configuration; using the same value multiple times is an error. When one or more configurations are specified, they must include the `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values. When no configurations are specified, execution will use the default specified in `DefaultPool`.
        :param pulumi.Input[pulumi.InputType['TargetGkeArgs']] gke: Information specifying a GKE Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Name of the `Target`. Format is [a-z][a-z0-9\\-]{0,62}.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[bool] require_approval: Optional. Whether or not the `Target` requires approval.
        :param pulumi.Input[pulumi.InputType['TargetRunArgs']] run: (Beta only) Information specifying a Cloud Run deployment target.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TargetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Cloud Deploy `Target` resource

        ## Example Usage
        ### Run_target
        tests creating and updating a cloud run target
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.Target("primary",
            location="us-west1",
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            description="basic description",
            execution_configs=[gcp.clouddeploy.TargetExecutionConfigArgs(
                usages=[
                    "RENDER",
                    "DEPLOY",
                ],
                execution_timeout="3600s",
            )],
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            },
            project="my-project-name",
            require_approval=False,
            run=gcp.clouddeploy.TargetRunArgs(
                location="projects/my-project-name/locations/us-west1",
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Target
        Creates a basic Cloud Deploy target
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.clouddeploy.Target("primary",
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            description="basic description",
            gke=gcp.clouddeploy.TargetGkeArgs(
                cluster="projects/my-project-name/locations/us-west1/clusters/example-cluster-name",
            ),
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            },
            location="us-west1",
            project="my-project-name",
            require_approval=False)
        ```

        ## Import

        Target can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:clouddeploy/target:Target default projects/{{project}}/locations/{{location}}/targets/{{name}}
        ```

        ```sh
         $ pulumi import gcp:clouddeploy/target:Target default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:clouddeploy/target:Target default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param TargetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TargetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 anthos_cluster: Optional[pulumi.Input[pulumi.InputType['TargetAnthosClusterArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 execution_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetExecutionConfigArgs']]]]] = None,
                 gke: Optional[pulumi.Input[pulumi.InputType['TargetGkeArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 require_approval: Optional[pulumi.Input[bool]] = None,
                 run: Optional[pulumi.Input[pulumi.InputType['TargetRunArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TargetArgs.__new__(TargetArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["anthos_cluster"] = anthos_cluster
            __props__.__dict__["description"] = description
            __props__.__dict__["execution_configs"] = execution_configs
            __props__.__dict__["gke"] = gke
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["require_approval"] = require_approval
            __props__.__dict__["run"] = run
            __props__.__dict__["create_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["target_id"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(Target, __self__).__init__(
            'gcp:clouddeploy/target:Target',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            anthos_cluster: Optional[pulumi.Input[pulumi.InputType['TargetAnthosClusterArgs']]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            execution_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetExecutionConfigArgs']]]]] = None,
            gke: Optional[pulumi.Input[pulumi.InputType['TargetGkeArgs']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            require_approval: Optional[pulumi.Input[bool]] = None,
            run: Optional[pulumi.Input[pulumi.InputType['TargetRunArgs']]] = None,
            target_id: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'Target':
        """
        Get an existing Target resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
        :param pulumi.Input[pulumi.InputType['TargetAnthosClusterArgs']] anthos_cluster: Information specifying an Anthos Cluster.
        :param pulumi.Input[str] create_time: Output only. Time at which the `Target` was created.
        :param pulumi.Input[str] description: Optional. Description of the `Target`. Max length is 255 characters.
        :param pulumi.Input[str] etag: Optional. This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetExecutionConfigArgs']]]] execution_configs: Configurations for all execution that relates to this `Target`. Each `ExecutionEnvironmentUsage` value may only be used in a single configuration; using the same value multiple times is an error. When one or more configurations are specified, they must include the `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values. When no configurations are specified, execution will use the default specified in `DefaultPool`.
        :param pulumi.Input[pulumi.InputType['TargetGkeArgs']] gke: Information specifying a GKE Cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Name of the `Target`. Format is [a-z][a-z0-9\\-]{0,62}.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[bool] require_approval: Optional. Whether or not the `Target` requires approval.
        :param pulumi.Input[pulumi.InputType['TargetRunArgs']] run: (Beta only) Information specifying a Cloud Run deployment target.
        :param pulumi.Input[str] target_id: Output only. Resource id of the `Target`.
        :param pulumi.Input[str] uid: Output only. Unique identifier of the `Target`.
        :param pulumi.Input[str] update_time: Output only. Most recent time at which the `Target` was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TargetState.__new__(_TargetState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["anthos_cluster"] = anthos_cluster
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["etag"] = etag
        __props__.__dict__["execution_configs"] = execution_configs
        __props__.__dict__["gke"] = gke
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["require_approval"] = require_approval
        __props__.__dict__["run"] = run
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Target(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Optional. User annotations. These attributes can only be set and used by the user, and not by Google Cloud Deploy. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="anthosCluster")
    def anthos_cluster(self) -> pulumi.Output[Optional['outputs.TargetAnthosCluster']]:
        """
        Information specifying an Anthos Cluster.
        """
        return pulumi.get(self, "anthos_cluster")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Output only. Time at which the `Target` was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. Description of the `Target`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        Optional. This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="executionConfigs")
    def execution_configs(self) -> pulumi.Output[Sequence['outputs.TargetExecutionConfig']]:
        """
        Configurations for all execution that relates to this `Target`. Each `ExecutionEnvironmentUsage` value may only be used in a single configuration; using the same value multiple times is an error. When one or more configurations are specified, they must include the `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values. When no configurations are specified, execution will use the default specified in `DefaultPool`.
        """
        return pulumi.get(self, "execution_configs")

    @property
    @pulumi.getter
    def gke(self) -> pulumi.Output[Optional['outputs.TargetGke']]:
        """
        Information specifying a GKE Cluster.
        """
        return pulumi.get(self, "gke")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Optional. Labels are attributes that can be set and used by both the user and by Google Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 128 bytes.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the `Target`. Format is [a-z][a-z0-9\\-]{0,62}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="requireApproval")
    def require_approval(self) -> pulumi.Output[Optional[bool]]:
        """
        Optional. Whether or not the `Target` requires approval.
        """
        return pulumi.get(self, "require_approval")

    @property
    @pulumi.getter
    def run(self) -> pulumi.Output[Optional['outputs.TargetRun']]:
        """
        (Beta only) Information specifying a Cloud Run deployment target.
        """
        return pulumi.get(self, "run")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[str]:
        """
        Output only. Resource id of the `Target`.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        Output only. Unique identifier of the `Target`.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Output only. Most recent time at which the `Target` was updated.
        """
        return pulumi.get(self, "update_time")

