# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionArgs', 'Function']

@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 build_config: Optional[pulumi.Input['FunctionBuildConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_trigger: Optional[pulumi.Input['FunctionEventTriggerArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_config: Optional[pulumi.Input['FunctionServiceConfigArgs']] = None):
        """
        The set of arguments for constructing a Function resource.
        :param pulumi.Input['FunctionBuildConfigArgs'] build_config: Describes the Build step of the function that builds a container
               from the given source.
               Structure is documented below.
        :param pulumi.Input[str] description: User-provided description of a function.
        :param pulumi.Input['FunctionEventTriggerArgs'] event_trigger: An Eventarc trigger managed by Google Cloud Functions that fires events in
               response to a condition in another service.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs associated with this Cloud Function.
        :param pulumi.Input[str] location: The location of this cloud function.
        :param pulumi.Input[str] name: A user-defined name of the function. Function names must
               be unique globally and match pattern `projects/*/locations/*/functions/*`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['FunctionServiceConfigArgs'] service_config: Describes the Service being deployed.
               Structure is documented below.
        """
        if build_config is not None:
            pulumi.set(__self__, "build_config", build_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if event_trigger is not None:
            pulumi.set(__self__, "event_trigger", event_trigger)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_config is not None:
            pulumi.set(__self__, "service_config", service_config)

    @property
    @pulumi.getter(name="buildConfig")
    def build_config(self) -> Optional[pulumi.Input['FunctionBuildConfigArgs']]:
        """
        Describes the Build step of the function that builds a container
        from the given source.
        Structure is documented below.
        """
        return pulumi.get(self, "build_config")

    @build_config.setter
    def build_config(self, value: Optional[pulumi.Input['FunctionBuildConfigArgs']]):
        pulumi.set(self, "build_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User-provided description of a function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> Optional[pulumi.Input['FunctionEventTriggerArgs']]:
        """
        An Eventarc trigger managed by Google Cloud Functions that fires events in
        response to a condition in another service.
        Structure is documented below.
        """
        return pulumi.get(self, "event_trigger")

    @event_trigger.setter
    def event_trigger(self, value: Optional[pulumi.Input['FunctionEventTriggerArgs']]):
        pulumi.set(self, "event_trigger", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs associated with this Cloud Function.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of this cloud function.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-defined name of the function. Function names must
        be unique globally and match pattern `projects/*/locations/*/functions/*`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceConfig")
    def service_config(self) -> Optional[pulumi.Input['FunctionServiceConfigArgs']]:
        """
        Describes the Service being deployed.
        Structure is documented below.
        """
        return pulumi.get(self, "service_config")

    @service_config.setter
    def service_config(self, value: Optional[pulumi.Input['FunctionServiceConfigArgs']]):
        pulumi.set(self, "service_config", value)


@pulumi.input_type
class _FunctionState:
    def __init__(__self__, *,
                 build_config: Optional[pulumi.Input['FunctionBuildConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 event_trigger: Optional[pulumi.Input['FunctionEventTriggerArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_config: Optional[pulumi.Input['FunctionServiceConfigArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Function resources.
        :param pulumi.Input['FunctionBuildConfigArgs'] build_config: Describes the Build step of the function that builds a container
               from the given source.
               Structure is documented below.
        :param pulumi.Input[str] description: User-provided description of a function.
        :param pulumi.Input[str] environment: The environment the function is hosted on.
        :param pulumi.Input['FunctionEventTriggerArgs'] event_trigger: An Eventarc trigger managed by Google Cloud Functions that fires events in
               response to a condition in another service.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs associated with this Cloud Function.
        :param pulumi.Input[str] location: The location of this cloud function.
        :param pulumi.Input[str] name: A user-defined name of the function. Function names must
               be unique globally and match pattern `projects/*/locations/*/functions/*`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['FunctionServiceConfigArgs'] service_config: Describes the Service being deployed.
               Structure is documented below.
        :param pulumi.Input[str] state: Describes the current state of the function.
        :param pulumi.Input[str] update_time: The last update timestamp of a Cloud Function.
        """
        if build_config is not None:
            pulumi.set(__self__, "build_config", build_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if event_trigger is not None:
            pulumi.set(__self__, "event_trigger", event_trigger)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_config is not None:
            pulumi.set(__self__, "service_config", service_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="buildConfig")
    def build_config(self) -> Optional[pulumi.Input['FunctionBuildConfigArgs']]:
        """
        Describes the Build step of the function that builds a container
        from the given source.
        Structure is documented below.
        """
        return pulumi.get(self, "build_config")

    @build_config.setter
    def build_config(self, value: Optional[pulumi.Input['FunctionBuildConfigArgs']]):
        pulumi.set(self, "build_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User-provided description of a function.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        The environment the function is hosted on.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> Optional[pulumi.Input['FunctionEventTriggerArgs']]:
        """
        An Eventarc trigger managed by Google Cloud Functions that fires events in
        response to a condition in another service.
        Structure is documented below.
        """
        return pulumi.get(self, "event_trigger")

    @event_trigger.setter
    def event_trigger(self, value: Optional[pulumi.Input['FunctionEventTriggerArgs']]):
        pulumi.set(self, "event_trigger", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs associated with this Cloud Function.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of this cloud function.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-defined name of the function. Function names must
        be unique globally and match pattern `projects/*/locations/*/functions/*`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceConfig")
    def service_config(self) -> Optional[pulumi.Input['FunctionServiceConfigArgs']]:
        """
        Describes the Service being deployed.
        Structure is documented below.
        """
        return pulumi.get(self, "service_config")

    @service_config.setter
    def service_config(self, value: Optional[pulumi.Input['FunctionServiceConfigArgs']]):
        pulumi.set(self, "service_config", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the current state of the function.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The last update timestamp of a Cloud Function.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_config: Optional[pulumi.Input[pulumi.InputType['FunctionBuildConfigArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_trigger: Optional[pulumi.Input[pulumi.InputType['FunctionEventTriggerArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_config: Optional[pulumi.Input[pulumi.InputType['FunctionServiceConfigArgs']]] = None,
                 __props__=None):
        """
        A Cloud Function that contains user computation executed in response to an event.

        To get more information about function, see:

        * [API documentation](https://cloud.google.com/functions/docs/reference/rest/v2beta/projects.locations.functions)

        ## Example Usage
        ### Cloudfunctions2 Basic Gcs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # [START functions_v2_basic_gcs]
        source_bucket = gcp.storage.Bucket("source-bucket",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            bucket=source_bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        # Add path to the zipped function source code
        trigger_bucket = gcp.storage.Bucket("trigger-bucket",
            location="us-central1",
            uniform_bucket_level_access=True)
        gcs_account = gcp.storage.get_project_service_account()
        # To use GCS CloudEvent triggers, the GCS service account requires the Pub/Sub Publisher(roles/pubsub.publisher) IAM role in the specified project.
        # (See https://cloud.google.com/eventarc/docs/run/quickstart-storage#before-you-begin)
        gcs_pubsub_publishing = gcp.projects.IAMMember("gcs-pubsub-publishing",
            project="my-project-name",
            role="roles/pubsub.publisher",
            member=f"serviceAccount:{gcs_account.email_address}")
        account = gcp.service_account.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account - used for both the cloud function and eventarc trigger in the test")
        # Permissions on the service account used by the function and Eventarc trigger
        invoking = gcp.projects.IAMMember("invoking",
            project="my-project-name",
            role="roles/run.invoker",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts=pulumi.ResourceOptions(depends_on=[gcs_pubsub_publishing]))
        event_receiving = gcp.projects.IAMMember("event-receiving",
            project="my-project-name",
            role="roles/eventarc.eventReceiver",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts=pulumi.ResourceOptions(depends_on=[invoking]))
        artifactregistry_reader = gcp.projects.IAMMember("artifactregistry-reader",
            project="my-project-name",
            role="roles/artifactregistry.reader",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts=pulumi.ResourceOptions(depends_on=[event_receiving]))
        function = gcp.cloudfunctionsv2.Function("function",
            location="us-central1",
            description="a new function",
            build_config=gcp.cloudfunctionsv2.FunctionBuildConfigArgs(
                runtime="nodejs12",
                entry_point="entryPoint",
                environment_variables={
                    "BUILD_CONFIG_TEST": "build_test",
                },
                source=gcp.cloudfunctionsv2.FunctionBuildConfigSourceArgs(
                    storage_source=gcp.cloudfunctionsv2.FunctionBuildConfigSourceStorageSourceArgs(
                        bucket=source_bucket.name,
                        object=object.name,
                    ),
                ),
            ),
            service_config=gcp.cloudfunctionsv2.FunctionServiceConfigArgs(
                max_instance_count=3,
                min_instance_count=1,
                available_memory="256M",
                timeout_seconds=60,
                environment_variables={
                    "SERVICE_CONFIG_TEST": "config_test",
                },
                ingress_settings="ALLOW_INTERNAL_ONLY",
                all_traffic_on_latest_revision=True,
                service_account_email=account.email,
            ),
            event_trigger=gcp.cloudfunctionsv2.FunctionEventTriggerArgs(
                trigger_region="us-central1",
                event_type="google.cloud.storage.object.v1.finalized",
                retry_policy="RETRY_POLICY_RETRY",
                service_account_email=account.email,
                event_filters=[gcp.cloudfunctionsv2.FunctionEventTriggerEventFilterArgs(
                    attribute="bucket",
                    value=trigger_bucket.name,
                )],
            ),
            opts=pulumi.ResourceOptions(depends_on=[
                    event_receiving,
                    artifactregistry_reader,
                ]))
        ```
        ### Cloudfunctions2 Basic Auditlogs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # [START functions_v2_basic_auditlogs]
        # This example follows the examples shown in this Google Cloud Community blog post
        # https://medium.com/google-cloud/applying-a-path-pattern-when-filtering-in-eventarc-f06b937b4c34
        # and the docs:
        # https://cloud.google.com/eventarc/docs/path-patterns
        source_bucket = gcp.storage.Bucket("source-bucket",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            bucket=source_bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        # Add path to the zipped function source code
        account = gcp.service_account.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account - used for both the cloud function and eventarc trigger in the test")
        # Note: The right way of listening for Cloud Storage events is to use a Cloud Storage trigger.
        # Here we use Audit Logs to monitor the bucket so path patterns can be used in the example of
        # google_cloudfunctions2_function below (Audit Log events have path pattern support)
        audit_log_bucket = gcp.storage.Bucket("audit-log-bucket",
            location="us-central1",
            uniform_bucket_level_access=True)
        # Permissions on the service account used by the function and Eventarc trigger
        invoking = gcp.projects.IAMMember("invoking",
            project="my-project-name",
            role="roles/run.invoker",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"))
        event_receiving = gcp.projects.IAMMember("event-receiving",
            project="my-project-name",
            role="roles/eventarc.eventReceiver",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts=pulumi.ResourceOptions(depends_on=[invoking]))
        artifactregistry_reader = gcp.projects.IAMMember("artifactregistry-reader",
            project="my-project-name",
            role="roles/artifactregistry.reader",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts=pulumi.ResourceOptions(depends_on=[event_receiving]))
        function = gcp.cloudfunctionsv2.Function("function",
            location="us-central1",
            description="a new function",
            build_config=gcp.cloudfunctionsv2.FunctionBuildConfigArgs(
                runtime="nodejs12",
                entry_point="entryPoint",
                environment_variables={
                    "BUILD_CONFIG_TEST": "build_test",
                },
                source=gcp.cloudfunctionsv2.FunctionBuildConfigSourceArgs(
                    storage_source=gcp.cloudfunctionsv2.FunctionBuildConfigSourceStorageSourceArgs(
                        bucket=source_bucket.name,
                        object=object.name,
                    ),
                ),
            ),
            service_config=gcp.cloudfunctionsv2.FunctionServiceConfigArgs(
                max_instance_count=3,
                min_instance_count=1,
                available_memory="256M",
                timeout_seconds=60,
                environment_variables={
                    "SERVICE_CONFIG_TEST": "config_test",
                },
                ingress_settings="ALLOW_INTERNAL_ONLY",
                all_traffic_on_latest_revision=True,
                service_account_email=account.email,
            ),
            event_trigger=gcp.cloudfunctionsv2.FunctionEventTriggerArgs(
                trigger_region="us-central1",
                event_type="google.cloud.audit.log.v1.written",
                retry_policy="RETRY_POLICY_RETRY",
                service_account_email=account.email,
                event_filters=[
                    gcp.cloudfunctionsv2.FunctionEventTriggerEventFilterArgs(
                        attribute="serviceName",
                        value="storage.googleapis.com",
                    ),
                    gcp.cloudfunctionsv2.FunctionEventTriggerEventFilterArgs(
                        attribute="methodName",
                        value="storage.objects.create",
                    ),
                    gcp.cloudfunctionsv2.FunctionEventTriggerEventFilterArgs(
                        attribute="resourceName",
                        value=audit_log_bucket.name.apply(lambda name: f"/projects/_/buckets/{name}/objects/*.txt"),
                        operator="match-path-pattern",
                    ),
                ],
            ),
            opts=pulumi.ResourceOptions(depends_on=[
                    event_receiving,
                    artifactregistry_reader,
                ]))
        ```

        ## Import

        function can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:cloudfunctionsv2/function:Function default projects/{{project}}/locations/{{location}}/functions/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudfunctionsv2/function:Function default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudfunctionsv2/function:Function default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['FunctionBuildConfigArgs']] build_config: Describes the Build step of the function that builds a container
               from the given source.
               Structure is documented below.
        :param pulumi.Input[str] description: User-provided description of a function.
        :param pulumi.Input[pulumi.InputType['FunctionEventTriggerArgs']] event_trigger: An Eventarc trigger managed by Google Cloud Functions that fires events in
               response to a condition in another service.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs associated with this Cloud Function.
        :param pulumi.Input[str] location: The location of this cloud function.
        :param pulumi.Input[str] name: A user-defined name of the function. Function names must
               be unique globally and match pattern `projects/*/locations/*/functions/*`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['FunctionServiceConfigArgs']] service_config: Describes the Service being deployed.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[FunctionArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Cloud Function that contains user computation executed in response to an event.

        To get more information about function, see:

        * [API documentation](https://cloud.google.com/functions/docs/reference/rest/v2beta/projects.locations.functions)

        ## Example Usage
        ### Cloudfunctions2 Basic Gcs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # [START functions_v2_basic_gcs]
        source_bucket = gcp.storage.Bucket("source-bucket",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            bucket=source_bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        # Add path to the zipped function source code
        trigger_bucket = gcp.storage.Bucket("trigger-bucket",
            location="us-central1",
            uniform_bucket_level_access=True)
        gcs_account = gcp.storage.get_project_service_account()
        # To use GCS CloudEvent triggers, the GCS service account requires the Pub/Sub Publisher(roles/pubsub.publisher) IAM role in the specified project.
        # (See https://cloud.google.com/eventarc/docs/run/quickstart-storage#before-you-begin)
        gcs_pubsub_publishing = gcp.projects.IAMMember("gcs-pubsub-publishing",
            project="my-project-name",
            role="roles/pubsub.publisher",
            member=f"serviceAccount:{gcs_account.email_address}")
        account = gcp.service_account.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account - used for both the cloud function and eventarc trigger in the test")
        # Permissions on the service account used by the function and Eventarc trigger
        invoking = gcp.projects.IAMMember("invoking",
            project="my-project-name",
            role="roles/run.invoker",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts=pulumi.ResourceOptions(depends_on=[gcs_pubsub_publishing]))
        event_receiving = gcp.projects.IAMMember("event-receiving",
            project="my-project-name",
            role="roles/eventarc.eventReceiver",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts=pulumi.ResourceOptions(depends_on=[invoking]))
        artifactregistry_reader = gcp.projects.IAMMember("artifactregistry-reader",
            project="my-project-name",
            role="roles/artifactregistry.reader",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts=pulumi.ResourceOptions(depends_on=[event_receiving]))
        function = gcp.cloudfunctionsv2.Function("function",
            location="us-central1",
            description="a new function",
            build_config=gcp.cloudfunctionsv2.FunctionBuildConfigArgs(
                runtime="nodejs12",
                entry_point="entryPoint",
                environment_variables={
                    "BUILD_CONFIG_TEST": "build_test",
                },
                source=gcp.cloudfunctionsv2.FunctionBuildConfigSourceArgs(
                    storage_source=gcp.cloudfunctionsv2.FunctionBuildConfigSourceStorageSourceArgs(
                        bucket=source_bucket.name,
                        object=object.name,
                    ),
                ),
            ),
            service_config=gcp.cloudfunctionsv2.FunctionServiceConfigArgs(
                max_instance_count=3,
                min_instance_count=1,
                available_memory="256M",
                timeout_seconds=60,
                environment_variables={
                    "SERVICE_CONFIG_TEST": "config_test",
                },
                ingress_settings="ALLOW_INTERNAL_ONLY",
                all_traffic_on_latest_revision=True,
                service_account_email=account.email,
            ),
            event_trigger=gcp.cloudfunctionsv2.FunctionEventTriggerArgs(
                trigger_region="us-central1",
                event_type="google.cloud.storage.object.v1.finalized",
                retry_policy="RETRY_POLICY_RETRY",
                service_account_email=account.email,
                event_filters=[gcp.cloudfunctionsv2.FunctionEventTriggerEventFilterArgs(
                    attribute="bucket",
                    value=trigger_bucket.name,
                )],
            ),
            opts=pulumi.ResourceOptions(depends_on=[
                    event_receiving,
                    artifactregistry_reader,
                ]))
        ```
        ### Cloudfunctions2 Basic Auditlogs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # [START functions_v2_basic_auditlogs]
        # This example follows the examples shown in this Google Cloud Community blog post
        # https://medium.com/google-cloud/applying-a-path-pattern-when-filtering-in-eventarc-f06b937b4c34
        # and the docs:
        # https://cloud.google.com/eventarc/docs/path-patterns
        source_bucket = gcp.storage.Bucket("source-bucket",
            location="US",
            uniform_bucket_level_access=True)
        object = gcp.storage.BucketObject("object",
            bucket=source_bucket.name,
            source=pulumi.FileAsset("function-source.zip"))
        # Add path to the zipped function source code
        account = gcp.service_account.Account("account",
            account_id="gcf-sa",
            display_name="Test Service Account - used for both the cloud function and eventarc trigger in the test")
        # Note: The right way of listening for Cloud Storage events is to use a Cloud Storage trigger.
        # Here we use Audit Logs to monitor the bucket so path patterns can be used in the example of
        # google_cloudfunctions2_function below (Audit Log events have path pattern support)
        audit_log_bucket = gcp.storage.Bucket("audit-log-bucket",
            location="us-central1",
            uniform_bucket_level_access=True)
        # Permissions on the service account used by the function and Eventarc trigger
        invoking = gcp.projects.IAMMember("invoking",
            project="my-project-name",
            role="roles/run.invoker",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"))
        event_receiving = gcp.projects.IAMMember("event-receiving",
            project="my-project-name",
            role="roles/eventarc.eventReceiver",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts=pulumi.ResourceOptions(depends_on=[invoking]))
        artifactregistry_reader = gcp.projects.IAMMember("artifactregistry-reader",
            project="my-project-name",
            role="roles/artifactregistry.reader",
            member=account.email.apply(lambda email: f"serviceAccount:{email}"),
            opts=pulumi.ResourceOptions(depends_on=[event_receiving]))
        function = gcp.cloudfunctionsv2.Function("function",
            location="us-central1",
            description="a new function",
            build_config=gcp.cloudfunctionsv2.FunctionBuildConfigArgs(
                runtime="nodejs12",
                entry_point="entryPoint",
                environment_variables={
                    "BUILD_CONFIG_TEST": "build_test",
                },
                source=gcp.cloudfunctionsv2.FunctionBuildConfigSourceArgs(
                    storage_source=gcp.cloudfunctionsv2.FunctionBuildConfigSourceStorageSourceArgs(
                        bucket=source_bucket.name,
                        object=object.name,
                    ),
                ),
            ),
            service_config=gcp.cloudfunctionsv2.FunctionServiceConfigArgs(
                max_instance_count=3,
                min_instance_count=1,
                available_memory="256M",
                timeout_seconds=60,
                environment_variables={
                    "SERVICE_CONFIG_TEST": "config_test",
                },
                ingress_settings="ALLOW_INTERNAL_ONLY",
                all_traffic_on_latest_revision=True,
                service_account_email=account.email,
            ),
            event_trigger=gcp.cloudfunctionsv2.FunctionEventTriggerArgs(
                trigger_region="us-central1",
                event_type="google.cloud.audit.log.v1.written",
                retry_policy="RETRY_POLICY_RETRY",
                service_account_email=account.email,
                event_filters=[
                    gcp.cloudfunctionsv2.FunctionEventTriggerEventFilterArgs(
                        attribute="serviceName",
                        value="storage.googleapis.com",
                    ),
                    gcp.cloudfunctionsv2.FunctionEventTriggerEventFilterArgs(
                        attribute="methodName",
                        value="storage.objects.create",
                    ),
                    gcp.cloudfunctionsv2.FunctionEventTriggerEventFilterArgs(
                        attribute="resourceName",
                        value=audit_log_bucket.name.apply(lambda name: f"/projects/_/buckets/{name}/objects/*.txt"),
                        operator="match-path-pattern",
                    ),
                ],
            ),
            opts=pulumi.ResourceOptions(depends_on=[
                    event_receiving,
                    artifactregistry_reader,
                ]))
        ```

        ## Import

        function can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:cloudfunctionsv2/function:Function default projects/{{project}}/locations/{{location}}/functions/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudfunctionsv2/function:Function default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudfunctionsv2/function:Function default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 build_config: Optional[pulumi.Input[pulumi.InputType['FunctionBuildConfigArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 event_trigger: Optional[pulumi.Input[pulumi.InputType['FunctionEventTriggerArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_config: Optional[pulumi.Input[pulumi.InputType['FunctionServiceConfigArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionArgs.__new__(FunctionArgs)

            __props__.__dict__["build_config"] = build_config
            __props__.__dict__["description"] = description
            __props__.__dict__["event_trigger"] = event_trigger
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["service_config"] = service_config
            __props__.__dict__["environment"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        super(Function, __self__).__init__(
            'gcp:cloudfunctionsv2/function:Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            build_config: Optional[pulumi.Input[pulumi.InputType['FunctionBuildConfigArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            environment: Optional[pulumi.Input[str]] = None,
            event_trigger: Optional[pulumi.Input[pulumi.InputType['FunctionEventTriggerArgs']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            service_config: Optional[pulumi.Input[pulumi.InputType['FunctionServiceConfigArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'Function':
        """
        Get an existing Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['FunctionBuildConfigArgs']] build_config: Describes the Build step of the function that builds a container
               from the given source.
               Structure is documented below.
        :param pulumi.Input[str] description: User-provided description of a function.
        :param pulumi.Input[str] environment: The environment the function is hosted on.
        :param pulumi.Input[pulumi.InputType['FunctionEventTriggerArgs']] event_trigger: An Eventarc trigger managed by Google Cloud Functions that fires events in
               response to a condition in another service.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs associated with this Cloud Function.
        :param pulumi.Input[str] location: The location of this cloud function.
        :param pulumi.Input[str] name: A user-defined name of the function. Function names must
               be unique globally and match pattern `projects/*/locations/*/functions/*`.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['FunctionServiceConfigArgs']] service_config: Describes the Service being deployed.
               Structure is documented below.
        :param pulumi.Input[str] state: Describes the current state of the function.
        :param pulumi.Input[str] update_time: The last update timestamp of a Cloud Function.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionState.__new__(_FunctionState)

        __props__.__dict__["build_config"] = build_config
        __props__.__dict__["description"] = description
        __props__.__dict__["environment"] = environment
        __props__.__dict__["event_trigger"] = event_trigger
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["service_config"] = service_config
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return Function(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="buildConfig")
    def build_config(self) -> pulumi.Output[Optional['outputs.FunctionBuildConfig']]:
        """
        Describes the Build step of the function that builds a container
        from the given source.
        Structure is documented below.
        """
        return pulumi.get(self, "build_config")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        User-provided description of a function.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[str]:
        """
        The environment the function is hosted on.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="eventTrigger")
    def event_trigger(self) -> pulumi.Output[Optional['outputs.FunctionEventTrigger']]:
        """
        An Eventarc trigger managed by Google Cloud Functions that fires events in
        response to a condition in another service.
        Structure is documented below.
        """
        return pulumi.get(self, "event_trigger")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A set of key/value label pairs associated with this Cloud Function.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The location of this cloud function.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A user-defined name of the function. Function names must
        be unique globally and match pattern `projects/*/locations/*/functions/*`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceConfig")
    def service_config(self) -> pulumi.Output[Optional['outputs.FunctionServiceConfig']]:
        """
        Describes the Service being deployed.
        Structure is documented below.
        """
        return pulumi.get(self, "service_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Describes the current state of the function.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The last update timestamp of a Cloud Function.
        """
        return pulumi.get(self, "update_time")

