# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetFunctionResult',
    'AwaitableGetFunctionResult',
    'get_function',
    'get_function_output',
]

@pulumi.output_type
class GetFunctionResult:
    """
    A collection of values returned by getFunction.
    """
    def __init__(__self__, build_configs=None, description=None, environment=None, event_triggers=None, id=None, labels=None, location=None, name=None, project=None, service_configs=None, state=None, update_time=None):
        if build_configs and not isinstance(build_configs, list):
            raise TypeError("Expected argument 'build_configs' to be a list")
        pulumi.set(__self__, "build_configs", build_configs)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if environment and not isinstance(environment, str):
            raise TypeError("Expected argument 'environment' to be a str")
        pulumi.set(__self__, "environment", environment)
        if event_triggers and not isinstance(event_triggers, list):
            raise TypeError("Expected argument 'event_triggers' to be a list")
        pulumi.set(__self__, "event_triggers", event_triggers)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_configs and not isinstance(service_configs, list):
            raise TypeError("Expected argument 'service_configs' to be a list")
        pulumi.set(__self__, "service_configs", service_configs)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="buildConfigs")
    def build_configs(self) -> Sequence['outputs.GetFunctionBuildConfigResult']:
        return pulumi.get(self, "build_configs")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> str:
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="eventTriggers")
    def event_triggers(self) -> Sequence['outputs.GetFunctionEventTriggerResult']:
        return pulumi.get(self, "event_triggers")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceConfigs")
    def service_configs(self) -> Sequence['outputs.GetFunctionServiceConfigResult']:
        return pulumi.get(self, "service_configs")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        return pulumi.get(self, "update_time")


class AwaitableGetFunctionResult(GetFunctionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFunctionResult(
            build_configs=self.build_configs,
            description=self.description,
            environment=self.environment,
            event_triggers=self.event_triggers,
            id=self.id,
            labels=self.labels,
            location=self.location,
            name=self.name,
            project=self.project,
            service_configs=self.service_configs,
            state=self.state,
            update_time=self.update_time)


def get_function(location: Optional[str] = None,
                 name: Optional[str] = None,
                 project: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFunctionResult:
    """
    Get information about a Google Cloud Function (2nd gen). For more information see:

    * [API documentation](https://cloud.google.com/functions/docs/reference/rest/v2beta/projects.locations.functions).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_function = gcp.cloudfunctionsv2.get_function(location="us-central1",
        name="function")
    ```


    :param str location: The location in which the resource belongs.
    :param str name: The name of a Cloud Function (2nd gen).
    :param str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['name'] = name
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:cloudfunctionsv2/getFunction:getFunction', __args__, opts=opts, typ=GetFunctionResult).value

    return AwaitableGetFunctionResult(
        build_configs=__ret__.build_configs,
        description=__ret__.description,
        environment=__ret__.environment,
        event_triggers=__ret__.event_triggers,
        id=__ret__.id,
        labels=__ret__.labels,
        location=__ret__.location,
        name=__ret__.name,
        project=__ret__.project,
        service_configs=__ret__.service_configs,
        state=__ret__.state,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_function)
def get_function_output(location: Optional[pulumi.Input[str]] = None,
                        name: Optional[pulumi.Input[str]] = None,
                        project: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFunctionResult]:
    """
    Get information about a Google Cloud Function (2nd gen). For more information see:

    * [API documentation](https://cloud.google.com/functions/docs/reference/rest/v2beta/projects.locations.functions).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_function = gcp.cloudfunctionsv2.get_function(location="us-central1",
        name="function")
    ```


    :param str location: The location in which the resource belongs.
    :param str name: The name of a Cloud Function (2nd gen).
    :param str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    ...
