# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'JobBinaryAuthorizationArgs',
    'JobConditionArgs',
    'JobLatestCreatedExecutionArgs',
    'JobTemplateArgs',
    'JobTemplateTemplateArgs',
    'JobTemplateTemplateContainerArgs',
    'JobTemplateTemplateContainerEnvArgs',
    'JobTemplateTemplateContainerEnvValueSourceArgs',
    'JobTemplateTemplateContainerEnvValueSourceSecretKeyRefArgs',
    'JobTemplateTemplateContainerLivenessProbeArgs',
    'JobTemplateTemplateContainerLivenessProbeHttpGetArgs',
    'JobTemplateTemplateContainerLivenessProbeHttpGetHttpHeaderArgs',
    'JobTemplateTemplateContainerLivenessProbeTcpSocketArgs',
    'JobTemplateTemplateContainerPortArgs',
    'JobTemplateTemplateContainerResourcesArgs',
    'JobTemplateTemplateContainerStartupProbeArgs',
    'JobTemplateTemplateContainerStartupProbeHttpGetArgs',
    'JobTemplateTemplateContainerStartupProbeHttpGetHttpHeaderArgs',
    'JobTemplateTemplateContainerStartupProbeTcpSocketArgs',
    'JobTemplateTemplateContainerVolumeMountArgs',
    'JobTemplateTemplateVolumeArgs',
    'JobTemplateTemplateVolumeCloudSqlInstanceArgs',
    'JobTemplateTemplateVolumeSecretArgs',
    'JobTemplateTemplateVolumeSecretItemArgs',
    'JobTemplateTemplateVpcAccessArgs',
    'JobTerminalConditionArgs',
    'ServiceBinaryAuthorizationArgs',
    'ServiceConditionArgs',
    'ServiceTemplateArgs',
    'ServiceTemplateContainerArgs',
    'ServiceTemplateContainerEnvArgs',
    'ServiceTemplateContainerEnvValueSourceArgs',
    'ServiceTemplateContainerEnvValueSourceSecretKeyRefArgs',
    'ServiceTemplateContainerLivenessProbeArgs',
    'ServiceTemplateContainerLivenessProbeHttpGetArgs',
    'ServiceTemplateContainerLivenessProbeHttpGetHttpHeaderArgs',
    'ServiceTemplateContainerLivenessProbeTcpSocketArgs',
    'ServiceTemplateContainerPortArgs',
    'ServiceTemplateContainerResourcesArgs',
    'ServiceTemplateContainerStartupProbeArgs',
    'ServiceTemplateContainerStartupProbeHttpGetArgs',
    'ServiceTemplateContainerStartupProbeHttpGetHttpHeaderArgs',
    'ServiceTemplateContainerStartupProbeTcpSocketArgs',
    'ServiceTemplateContainerVolumeMountArgs',
    'ServiceTemplateScalingArgs',
    'ServiceTemplateVolumeArgs',
    'ServiceTemplateVolumeCloudSqlInstanceArgs',
    'ServiceTemplateVolumeSecretArgs',
    'ServiceTemplateVolumeSecretItemArgs',
    'ServiceTemplateVpcAccessArgs',
    'ServiceTerminalConditionArgs',
    'ServiceTrafficArgs',
    'ServiceTrafficStatusArgs',
]

@pulumi.input_type
class JobBinaryAuthorizationArgs:
    def __init__(__self__, *,
                 breakglass_justification: Optional[pulumi.Input[str]] = None,
                 use_default: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] breakglass_justification: If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        :param pulumi.Input[bool] use_default: If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        if breakglass_justification is not None:
            pulumi.set(__self__, "breakglass_justification", breakglass_justification)
        if use_default is not None:
            pulumi.set(__self__, "use_default", use_default)

    @property
    @pulumi.getter(name="breakglassJustification")
    def breakglass_justification(self) -> Optional[pulumi.Input[str]]:
        """
        If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        """
        return pulumi.get(self, "breakglass_justification")

    @breakglass_justification.setter
    def breakglass_justification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "breakglass_justification", value)

    @property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> Optional[pulumi.Input[bool]]:
        """
        If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        return pulumi.get(self, "use_default")

    @use_default.setter
    def use_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_default", value)


@pulumi.input_type
class JobConditionArgs:
    def __init__(__self__, *,
                 execution_reason: Optional[pulumi.Input[str]] = None,
                 last_transition_time: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 revision_reason: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] execution_reason: A reason for the execution condition.
        :param pulumi.Input[str] last_transition_time: Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] message: Human readable message indicating details about the current status.
        :param pulumi.Input[str] reason: A common (service-level) reason for this condition.
        :param pulumi.Input[str] revision_reason: A reason for the revision condition.
        :param pulumi.Input[str] severity: How to interpret failures of this condition, one of Error, Warning, Info
        :param pulumi.Input[str] state: State of the condition.
        :param pulumi.Input[str] type: type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[pulumi.Input[str]]:
        """
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @execution_reason.setter
    def execution_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_reason", value)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[str]]:
        """
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[pulumi.Input[str]]:
        """
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @revision_reason.setter
    def revision_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_reason", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[str]]:
        """
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the condition.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class JobLatestCreatedExecutionArgs:
    def __init__(__self__, *,
                 completion_time: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] completion_time: Completion timestamp of the execution.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] create_time: Creation timestamp of the execution.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] name: Name of the Job.
        """
        if completion_time is not None:
            pulumi.set(__self__, "completion_time", completion_time)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> Optional[pulumi.Input[str]]:
        """
        Completion timestamp of the execution.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "completion_time")

    @completion_time.setter
    def completion_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "completion_time", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp of the execution.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class JobTemplateArgs:
    def __init__(__self__, *,
                 template: pulumi.Input['JobTemplateTemplateArgs'],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 parallelism: Optional[pulumi.Input[int]] = None,
                 task_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input['JobTemplateTemplateArgs'] template: Describes the task(s) that will be created when executing an execution
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: KRM-style labels for the resource.
        :param pulumi.Input[int] parallelism: Specifies the maximum desired number of tasks the execution should run at given time. Must be <= taskCount. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed remaining, i.e. when the work left to do is less than max parallelism.
        :param pulumi.Input[int] task_count: Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        pulumi.set(__self__, "template", template)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @property
    @pulumi.getter
    def template(self) -> pulumi.Input['JobTemplateTemplateArgs']:
        """
        Describes the task(s) that will be created when executing an execution
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: pulumi.Input['JobTemplateTemplateArgs']):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        KRM-style labels for the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def parallelism(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the maximum desired number of tasks the execution should run at given time. Must be <= taskCount. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed remaining, i.e. when the work left to do is less than max parallelism.
        """
        return pulumi.get(self, "parallelism")

    @parallelism.setter
    def parallelism(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "parallelism", value)

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        return pulumi.get(self, "task_count")

    @task_count.setter
    def task_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "task_count", value)


@pulumi.input_type
class JobTemplateTemplateArgs:
    def __init__(__self__, *,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerArgs']]]] = None,
                 encryption_key: Optional[pulumi.Input[str]] = None,
                 execution_environment: Optional[pulumi.Input[str]] = None,
                 max_retries: Optional[pulumi.Input[int]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateVolumeArgs']]]] = None,
                 vpc_access: Optional[pulumi.Input['JobTemplateTemplateVpcAccessArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerArgs']]] containers: Holds the single container that defines the unit of execution for this task.
               Structure is documented below.
        :param pulumi.Input[str] encryption_key: A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        :param pulumi.Input[str] execution_environment: The execution environment being used to host this Task.
               Possible values are `EXECUTION_ENVIRONMENT_GEN1` and `EXECUTION_ENVIRONMENT_GEN2`.
        :param pulumi.Input[int] max_retries: Number of retries allowed per Task, before marking this Task failed.
        :param pulumi.Input[str] service_account: Email address of the IAM service account associated with the Task of a Job. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
        :param pulumi.Input[str] timeout: Max allowed time duration the Task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateVolumeArgs']]] volumes: A list of Volumes to make available to containers.
               Structure is documented below.
        :param pulumi.Input['JobTemplateTemplateVpcAccessArgs'] vpc_access: VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
               Structure is documented below.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if execution_environment is not None:
            pulumi.set(__self__, "execution_environment", execution_environment)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if vpc_access is not None:
            pulumi.set(__self__, "vpc_access", vpc_access)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerArgs']]]]:
        """
        Holds the single container that defines the unit of execution for this task.
        Structure is documented below.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[str]]:
        """
        A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="executionEnvironment")
    def execution_environment(self) -> Optional[pulumi.Input[str]]:
        """
        The execution environment being used to host this Task.
        Possible values are `EXECUTION_ENVIRONMENT_GEN1` and `EXECUTION_ENVIRONMENT_GEN2`.
        """
        return pulumi.get(self, "execution_environment")

    @execution_environment.setter
    def execution_environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_environment", value)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[int]]:
        """
        Number of retries allowed per Task, before marking this Task failed.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retries", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        Email address of the IAM service account associated with the Task of a Job. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Max allowed time duration the Task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateVolumeArgs']]]]:
        """
        A list of Volumes to make available to containers.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="vpcAccess")
    def vpc_access(self) -> Optional[pulumi.Input['JobTemplateTemplateVpcAccessArgs']]:
        """
        VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_access")

    @vpc_access.setter
    def vpc_access(self, value: Optional[pulumi.Input['JobTemplateTemplateVpcAccessArgs']]):
        pulumi.set(self, "vpc_access", value)


@pulumi.input_type
class JobTemplateTemplateContainerArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerEnvArgs']]]] = None,
                 liveness_probe: Optional[pulumi.Input['JobTemplateTemplateContainerLivenessProbeArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerPortArgs']]]] = None,
                 resources: Optional[pulumi.Input['JobTemplateTemplateContainerResourcesArgs']] = None,
                 startup_probe: Optional[pulumi.Input['JobTemplateTemplateContainerStartupProbeArgs']] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerVolumeMountArgs']]]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] image: URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerEnvArgs']]] envs: List of environment variables to set in the container.
               Structure is documented below.
        :param pulumi.Input['JobTemplateTemplateContainerLivenessProbeArgs'] liveness_probe: Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the container specified as a DNS_LABEL.
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerPortArgs']]] ports: List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
               If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
               Structure is documented below.
        :param pulumi.Input['JobTemplateTemplateContainerResourcesArgs'] resources: Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
               Structure is documented below.
        :param pulumi.Input['JobTemplateTemplateContainerStartupProbeArgs'] startup_probe: Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerVolumeMountArgs']]] volume_mounts: Volume to mount into the container's filesystem.
               Structure is documented below.
        :param pulumi.Input[str] working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if startup_probe is not None:
            pulumi.set(__self__, "startup_probe", startup_probe)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[str]:
        """
        URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerEnvArgs']]]]:
        """
        List of environment variables to set in the container.
        Structure is documented below.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerEnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional[pulumi.Input['JobTemplateTemplateContainerLivenessProbeArgs']]:
        """
        Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        Structure is documented below.
        """
        return pulumi.get(self, "liveness_probe")

    @liveness_probe.setter
    def liveness_probe(self, value: Optional[pulumi.Input['JobTemplateTemplateContainerLivenessProbeArgs']]):
        pulumi.set(self, "liveness_probe", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the container specified as a DNS_LABEL.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerPortArgs']]]]:
        """
        List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
        If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
        Structure is documented below.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['JobTemplateTemplateContainerResourcesArgs']]:
        """
        Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['JobTemplateTemplateContainerResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> Optional[pulumi.Input['JobTemplateTemplateContainerStartupProbeArgs']]:
        """
        Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        Structure is documented below.
        """
        return pulumi.get(self, "startup_probe")

    @startup_probe.setter
    def startup_probe(self, value: Optional[pulumi.Input['JobTemplateTemplateContainerStartupProbeArgs']]):
        pulumi.set(self, "startup_probe", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerVolumeMountArgs']]]]:
        """
        Volume to mount into the container's filesystem.
        Structure is documented below.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


@pulumi.input_type
class JobTemplateTemplateContainerEnvArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None,
                 value_source: Optional[pulumi.Input['JobTemplateTemplateContainerEnvValueSourceArgs']] = None):
        """
        :param pulumi.Input[str] name: Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
        :param pulumi.Input[str] value: Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "", and the maximum length is 32768 bytes
        :param pulumi.Input['JobTemplateTemplateContainerEnvValueSourceArgs'] value_source: Source for the environment variable's value.
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_source is not None:
            pulumi.set(__self__, "value_source", value_source)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "", and the maximum length is 32768 bytes
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> Optional[pulumi.Input['JobTemplateTemplateContainerEnvValueSourceArgs']]:
        """
        Source for the environment variable's value.
        Structure is documented below.
        """
        return pulumi.get(self, "value_source")

    @value_source.setter
    def value_source(self, value: Optional[pulumi.Input['JobTemplateTemplateContainerEnvValueSourceArgs']]):
        pulumi.set(self, "value_source", value)


@pulumi.input_type
class JobTemplateTemplateContainerEnvValueSourceArgs:
    def __init__(__self__, *,
                 secret_key_ref: Optional[pulumi.Input['JobTemplateTemplateContainerEnvValueSourceSecretKeyRefArgs']] = None):
        """
        :param pulumi.Input['JobTemplateTemplateContainerEnvValueSourceSecretKeyRefArgs'] secret_key_ref: Selects a secret and a specific version from Cloud Secret Manager.
               Structure is documented below.
        """
        if secret_key_ref is not None:
            pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> Optional[pulumi.Input['JobTemplateTemplateContainerEnvValueSourceSecretKeyRefArgs']]:
        """
        Selects a secret and a specific version from Cloud Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_key_ref")

    @secret_key_ref.setter
    def secret_key_ref(self, value: Optional[pulumi.Input['JobTemplateTemplateContainerEnvValueSourceSecretKeyRefArgs']]):
        pulumi.set(self, "secret_key_ref", value)


@pulumi.input_type
class JobTemplateTemplateContainerEnvValueSourceSecretKeyRefArgs:
    def __init__(__self__, *,
                 secret: pulumi.Input[str],
                 version: pulumi.Input[str]):
        """
        :param pulumi.Input[str] secret: The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        :param pulumi.Input[str] version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[str]:
        """
        The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class JobTemplateTemplateContainerLivenessProbeArgs:
    def __init__(__self__, *,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 http_get: Optional[pulumi.Input['JobTemplateTemplateContainerLivenessProbeHttpGetArgs']] = None,
                 initial_delay_seconds: Optional[pulumi.Input[int]] = None,
                 period_seconds: Optional[pulumi.Input[int]] = None,
                 tcp_socket: Optional[pulumi.Input['JobTemplateTemplateContainerLivenessProbeTcpSocketArgs']] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param pulumi.Input['JobTemplateTemplateContainerLivenessProbeHttpGetArgs'] http_get: HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param pulumi.Input[int] initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param pulumi.Input[int] period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        :param pulumi.Input['JobTemplateTemplateContainerLivenessProbeTcpSocketArgs'] tcp_socket: TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param pulumi.Input[int] timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional[pulumi.Input['JobTemplateTemplateContainerLivenessProbeHttpGetArgs']]:
        """
        HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "http_get")

    @http_get.setter
    def http_get(self, value: Optional[pulumi.Input['JobTemplateTemplateContainerLivenessProbeHttpGetArgs']]):
        pulumi.set(self, "http_get", value)

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @initial_delay_seconds.setter
    def initial_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_delay_seconds", value)

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        """
        return pulumi.get(self, "period_seconds")

    @period_seconds.setter
    def period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period_seconds", value)

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional[pulumi.Input['JobTemplateTemplateContainerLivenessProbeTcpSocketArgs']]:
        """
        TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_socket")

    @tcp_socket.setter
    def tcp_socket(self, value: Optional[pulumi.Input['JobTemplateTemplateContainerLivenessProbeTcpSocketArgs']]):
        pulumi.set(self, "tcp_socket", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.input_type
class JobTemplateTemplateContainerLivenessProbeHttpGetArgs:
    def __init__(__self__, *,
                 http_headers: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerLivenessProbeHttpGetHttpHeaderArgs']]]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerLivenessProbeHttpGetHttpHeaderArgs']]] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
               Structure is documented below.
        :param pulumi.Input[str] path: Path to access on the HTTP server. Defaults to '/'.
        """
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerLivenessProbeHttpGetHttpHeaderArgs']]]]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        Structure is documented below.
        """
        return pulumi.get(self, "http_headers")

    @http_headers.setter
    def http_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerLivenessProbeHttpGetHttpHeaderArgs']]]]):
        pulumi.set(self, "http_headers", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to access on the HTTP server. Defaults to '/'.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class JobTemplateTemplateContainerLivenessProbeHttpGetHttpHeaderArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The header field name
        :param pulumi.Input[str] value: The header field value
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The header field value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class JobTemplateTemplateContainerLivenessProbeTcpSocketArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] port: Port number to access on the container. Must be in the range 1 to 65535. If not specified, defaults to 8080.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port number to access on the container. Must be in the range 1 to 65535. If not specified, defaults to 8080.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class JobTemplateTemplateContainerPortArgs:
    def __init__(__self__, *,
                 container_port: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] container_port: Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        :param pulumi.Input[str] name: If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[pulumi.Input[int]]:
        """
        Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        """
        return pulumi.get(self, "container_port")

    @container_port.setter
    def container_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "container_port", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class JobTemplateTemplateContainerResourcesArgs:
    def __init__(__self__, *,
                 limits: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] limits: Only memory and CPU are supported. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Only memory and CPU are supported. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "limits", value)


@pulumi.input_type
class JobTemplateTemplateContainerStartupProbeArgs:
    def __init__(__self__, *,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 http_get: Optional[pulumi.Input['JobTemplateTemplateContainerStartupProbeHttpGetArgs']] = None,
                 initial_delay_seconds: Optional[pulumi.Input[int]] = None,
                 period_seconds: Optional[pulumi.Input[int]] = None,
                 tcp_socket: Optional[pulumi.Input['JobTemplateTemplateContainerStartupProbeTcpSocketArgs']] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param pulumi.Input['JobTemplateTemplateContainerStartupProbeHttpGetArgs'] http_get: HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param pulumi.Input[int] initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param pulumi.Input[int] period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        :param pulumi.Input['JobTemplateTemplateContainerStartupProbeTcpSocketArgs'] tcp_socket: TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param pulumi.Input[int] timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional[pulumi.Input['JobTemplateTemplateContainerStartupProbeHttpGetArgs']]:
        """
        HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "http_get")

    @http_get.setter
    def http_get(self, value: Optional[pulumi.Input['JobTemplateTemplateContainerStartupProbeHttpGetArgs']]):
        pulumi.set(self, "http_get", value)

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @initial_delay_seconds.setter
    def initial_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_delay_seconds", value)

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        """
        return pulumi.get(self, "period_seconds")

    @period_seconds.setter
    def period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period_seconds", value)

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional[pulumi.Input['JobTemplateTemplateContainerStartupProbeTcpSocketArgs']]:
        """
        TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_socket")

    @tcp_socket.setter
    def tcp_socket(self, value: Optional[pulumi.Input['JobTemplateTemplateContainerStartupProbeTcpSocketArgs']]):
        pulumi.set(self, "tcp_socket", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.input_type
class JobTemplateTemplateContainerStartupProbeHttpGetArgs:
    def __init__(__self__, *,
                 http_headers: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerStartupProbeHttpGetHttpHeaderArgs']]]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerStartupProbeHttpGetHttpHeaderArgs']]] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
               Structure is documented below.
        :param pulumi.Input[str] path: Path to access on the HTTP server. Defaults to '/'.
        """
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerStartupProbeHttpGetHttpHeaderArgs']]]]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        Structure is documented below.
        """
        return pulumi.get(self, "http_headers")

    @http_headers.setter
    def http_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateContainerStartupProbeHttpGetHttpHeaderArgs']]]]):
        pulumi.set(self, "http_headers", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to access on the HTTP server. Defaults to '/'.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class JobTemplateTemplateContainerStartupProbeHttpGetHttpHeaderArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The header field name
        :param pulumi.Input[str] value: The header field value
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The header field value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class JobTemplateTemplateContainerStartupProbeTcpSocketArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] port: Port number to access on the container. Must be in the range 1 to 65535. If not specified, defaults to 8080.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port number to access on the container. Must be in the range 1 to 65535. If not specified, defaults to 8080.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class JobTemplateTemplateContainerVolumeMountArgs:
    def __init__(__self__, *,
                 mount_path: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] mount_path: Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        :param pulumi.Input[str] name: This must match the Name of a Volume.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> pulumi.Input[str]:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class JobTemplateTemplateVolumeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 cloud_sql_instance: Optional[pulumi.Input['JobTemplateTemplateVolumeCloudSqlInstanceArgs']] = None,
                 secret: Optional[pulumi.Input['JobTemplateTemplateVolumeSecretArgs']] = None):
        """
        :param pulumi.Input[str] name: Volume's name.
        :param pulumi.Input['JobTemplateTemplateVolumeCloudSqlInstanceArgs'] cloud_sql_instance: For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
               Structure is documented below.
        :param pulumi.Input['JobTemplateTemplateVolumeSecretArgs'] secret: Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if cloud_sql_instance is not None:
            pulumi.set(__self__, "cloud_sql_instance", cloud_sql_instance)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="cloudSqlInstance")
    def cloud_sql_instance(self) -> Optional[pulumi.Input['JobTemplateTemplateVolumeCloudSqlInstanceArgs']]:
        """
        For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_sql_instance")

    @cloud_sql_instance.setter
    def cloud_sql_instance(self, value: Optional[pulumi.Input['JobTemplateTemplateVolumeCloudSqlInstanceArgs']]):
        pulumi.set(self, "cloud_sql_instance", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input['JobTemplateTemplateVolumeSecretArgs']]:
        """
        Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        Structure is documented below.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input['JobTemplateTemplateVolumeSecretArgs']]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class JobTemplateTemplateVolumeCloudSqlInstanceArgs:
    def __init__(__self__, *,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        if instances is not None:
            pulumi.set(__self__, "instances", instances)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instances", value)


@pulumi.input_type
class JobTemplateTemplateVolumeSecretArgs:
    def __init__(__self__, *,
                 secret: pulumi.Input[str],
                 default_mode: Optional[pulumi.Input[int]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateVolumeSecretItemArgs']]]] = None):
        """
        :param pulumi.Input[str] secret: The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        :param pulumi.Input[int] default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        :param pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateVolumeSecretItemArgs']]] items: If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
               Structure is documented below.
        """
        pulumi.set(__self__, "secret", secret)
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[str]:
        """
        The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[pulumi.Input[int]]:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        """
        return pulumi.get(self, "default_mode")

    @default_mode.setter
    def default_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_mode", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateVolumeSecretItemArgs']]]]:
        """
        If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        Structure is documented below.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobTemplateTemplateVolumeSecretItemArgs']]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class JobTemplateTemplateVolumeSecretItemArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[int],
                 path: pulumi.Input[str],
                 version: pulumi.Input[str]):
        """
        :param pulumi.Input[int] mode: Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        :param pulumi.Input[str] path: The relative path of the secret in the container.
        :param pulumi.Input[str] version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[int]:
        """
        Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[int]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The relative path of the secret in the container.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class JobTemplateTemplateVpcAccessArgs:
    def __init__(__self__, *,
                 connector: Optional[pulumi.Input[str]] = None,
                 egress: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] connector: VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        :param pulumi.Input[str] egress: Traffic VPC egress settings.
               Possible values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`.
        """
        if connector is not None:
            pulumi.set(__self__, "connector", connector)
        if egress is not None:
            pulumi.set(__self__, "egress", egress)

    @property
    @pulumi.getter
    def connector(self) -> Optional[pulumi.Input[str]]:
        """
        VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        """
        return pulumi.get(self, "connector")

    @connector.setter
    def connector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connector", value)

    @property
    @pulumi.getter
    def egress(self) -> Optional[pulumi.Input[str]]:
        """
        Traffic VPC egress settings.
        Possible values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`.
        """
        return pulumi.get(self, "egress")

    @egress.setter
    def egress(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "egress", value)


@pulumi.input_type
class JobTerminalConditionArgs:
    def __init__(__self__, *,
                 execution_reason: Optional[pulumi.Input[str]] = None,
                 last_transition_time: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 revision_reason: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] execution_reason: A reason for the execution condition.
        :param pulumi.Input[str] last_transition_time: Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] message: Human readable message indicating details about the current status.
        :param pulumi.Input[str] reason: A common (service-level) reason for this condition.
        :param pulumi.Input[str] revision_reason: A reason for the revision condition.
        :param pulumi.Input[str] severity: How to interpret failures of this condition, one of Error, Warning, Info
        :param pulumi.Input[str] state: State of the condition.
        :param pulumi.Input[str] type: type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[pulumi.Input[str]]:
        """
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @execution_reason.setter
    def execution_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_reason", value)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[str]]:
        """
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[pulumi.Input[str]]:
        """
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @revision_reason.setter
    def revision_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_reason", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[str]]:
        """
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the condition.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ServiceBinaryAuthorizationArgs:
    def __init__(__self__, *,
                 breakglass_justification: Optional[pulumi.Input[str]] = None,
                 use_default: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] breakglass_justification: If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        :param pulumi.Input[bool] use_default: If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        if breakglass_justification is not None:
            pulumi.set(__self__, "breakglass_justification", breakglass_justification)
        if use_default is not None:
            pulumi.set(__self__, "use_default", use_default)

    @property
    @pulumi.getter(name="breakglassJustification")
    def breakglass_justification(self) -> Optional[pulumi.Input[str]]:
        """
        If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        """
        return pulumi.get(self, "breakglass_justification")

    @breakglass_justification.setter
    def breakglass_justification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "breakglass_justification", value)

    @property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> Optional[pulumi.Input[bool]]:
        """
        If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        return pulumi.get(self, "use_default")

    @use_default.setter
    def use_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_default", value)


@pulumi.input_type
class ServiceConditionArgs:
    def __init__(__self__, *,
                 execution_reason: Optional[pulumi.Input[str]] = None,
                 last_transition_time: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 revision_reason: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] execution_reason: A reason for the execution condition.
        :param pulumi.Input[str] last_transition_time: Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] message: Human readable message indicating details about the current status.
        :param pulumi.Input[str] reason: A common (service-level) reason for this condition.
        :param pulumi.Input[str] revision_reason: A reason for the revision condition.
        :param pulumi.Input[str] severity: How to interpret failures of this condition, one of Error, Warning, Info
        :param pulumi.Input[str] state: State of the condition.
        :param pulumi.Input[str] type: The allocation type for this traffic target.
               Possible values are `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST` and `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[pulumi.Input[str]]:
        """
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @execution_reason.setter
    def execution_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_reason", value)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[str]]:
        """
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[pulumi.Input[str]]:
        """
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @revision_reason.setter
    def revision_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_reason", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[str]]:
        """
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the condition.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The allocation type for this traffic target.
        Possible values are `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST` and `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ServiceTemplateArgs:
    def __init__(__self__, *,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerArgs']]]] = None,
                 encryption_key: Optional[pulumi.Input[str]] = None,
                 execution_environment: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_instance_request_concurrency: Optional[pulumi.Input[int]] = None,
                 revision: Optional[pulumi.Input[str]] = None,
                 scaling: Optional[pulumi.Input['ServiceTemplateScalingArgs']] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateVolumeArgs']]]] = None,
                 vpc_access: Optional[pulumi.Input['ServiceTemplateVpcAccessArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerArgs']]] containers: Holds the single container that defines the unit of execution for this task.
               Structure is documented below.
        :param pulumi.Input[str] encryption_key: A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        :param pulumi.Input[str] execution_environment: The sandbox environment to host this Revision.
               Possible values are `EXECUTION_ENVIRONMENT_GEN1` and `EXECUTION_ENVIRONMENT_GEN2`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: KRM-style labels for the resource.
        :param pulumi.Input[int] max_instance_request_concurrency: Sets the maximum number of requests that each serving instance can receive.
        :param pulumi.Input[str] revision: The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
        :param pulumi.Input['ServiceTemplateScalingArgs'] scaling: Scaling settings for this Revision.
               Structure is documented below.
        :param pulumi.Input[str] service_account: Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        :param pulumi.Input[str] timeout: Max allowed time for an instance to respond to a request.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTemplateVolumeArgs']]] volumes: A list of Volumes to make available to containers.
               Structure is documented below.
        :param pulumi.Input['ServiceTemplateVpcAccessArgs'] vpc_access: VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
               Structure is documented below.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if execution_environment is not None:
            pulumi.set(__self__, "execution_environment", execution_environment)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_instance_request_concurrency is not None:
            pulumi.set(__self__, "max_instance_request_concurrency", max_instance_request_concurrency)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if scaling is not None:
            pulumi.set(__self__, "scaling", scaling)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if vpc_access is not None:
            pulumi.set(__self__, "vpc_access", vpc_access)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerArgs']]]]:
        """
        Holds the single container that defines the unit of execution for this task.
        Structure is documented below.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[str]]:
        """
        A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_key", value)

    @property
    @pulumi.getter(name="executionEnvironment")
    def execution_environment(self) -> Optional[pulumi.Input[str]]:
        """
        The sandbox environment to host this Revision.
        Possible values are `EXECUTION_ENVIRONMENT_GEN1` and `EXECUTION_ENVIRONMENT_GEN2`.
        """
        return pulumi.get(self, "execution_environment")

    @execution_environment.setter
    def execution_environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_environment", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        KRM-style labels for the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maxInstanceRequestConcurrency")
    def max_instance_request_concurrency(self) -> Optional[pulumi.Input[int]]:
        """
        Sets the maximum number of requests that each serving instance can receive.
        """
        return pulumi.get(self, "max_instance_request_concurrency")

    @max_instance_request_concurrency.setter
    def max_instance_request_concurrency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instance_request_concurrency", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter
    def scaling(self) -> Optional[pulumi.Input['ServiceTemplateScalingArgs']]:
        """
        Scaling settings for this Revision.
        Structure is documented below.
        """
        return pulumi.get(self, "scaling")

    @scaling.setter
    def scaling(self, value: Optional[pulumi.Input['ServiceTemplateScalingArgs']]):
        pulumi.set(self, "scaling", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Max allowed time for an instance to respond to a request.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateVolumeArgs']]]]:
        """
        A list of Volumes to make available to containers.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="vpcAccess")
    def vpc_access(self) -> Optional[pulumi.Input['ServiceTemplateVpcAccessArgs']]:
        """
        VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_access")

    @vpc_access.setter
    def vpc_access(self, value: Optional[pulumi.Input['ServiceTemplateVpcAccessArgs']]):
        pulumi.set(self, "vpc_access", value)


@pulumi.input_type
class ServiceTemplateContainerArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerEnvArgs']]]] = None,
                 liveness_probe: Optional[pulumi.Input['ServiceTemplateContainerLivenessProbeArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerPortArgs']]]] = None,
                 resources: Optional[pulumi.Input['ServiceTemplateContainerResourcesArgs']] = None,
                 startup_probe: Optional[pulumi.Input['ServiceTemplateContainerStartupProbeArgs']] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerVolumeMountArgs']]]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] image: URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerEnvArgs']]] envs: List of environment variables to set in the container.
               Structure is documented below.
        :param pulumi.Input['ServiceTemplateContainerLivenessProbeArgs'] liveness_probe: Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the container specified as a DNS_LABEL.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerPortArgs']]] ports: List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
               If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
               Structure is documented below.
        :param pulumi.Input['ServiceTemplateContainerResourcesArgs'] resources: Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
               Structure is documented below.
        :param pulumi.Input['ServiceTemplateContainerStartupProbeArgs'] startup_probe: Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerVolumeMountArgs']]] volume_mounts: Volume to mount into the container's filesystem.
               Structure is documented below.
        :param pulumi.Input[str] working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if startup_probe is not None:
            pulumi.set(__self__, "startup_probe", startup_probe)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[str]:
        """
        URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerEnvArgs']]]]:
        """
        List of environment variables to set in the container.
        Structure is documented below.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerEnvArgs']]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional[pulumi.Input['ServiceTemplateContainerLivenessProbeArgs']]:
        """
        Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        Structure is documented below.
        """
        return pulumi.get(self, "liveness_probe")

    @liveness_probe.setter
    def liveness_probe(self, value: Optional[pulumi.Input['ServiceTemplateContainerLivenessProbeArgs']]):
        pulumi.set(self, "liveness_probe", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the container specified as a DNS_LABEL.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerPortArgs']]]]:
        """
        List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
        If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
        Structure is documented below.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['ServiceTemplateContainerResourcesArgs']]:
        """
        Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['ServiceTemplateContainerResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> Optional[pulumi.Input['ServiceTemplateContainerStartupProbeArgs']]:
        """
        Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        Structure is documented below.
        """
        return pulumi.get(self, "startup_probe")

    @startup_probe.setter
    def startup_probe(self, value: Optional[pulumi.Input['ServiceTemplateContainerStartupProbeArgs']]):
        pulumi.set(self, "startup_probe", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerVolumeMountArgs']]]]:
        """
        Volume to mount into the container's filesystem.
        Structure is documented below.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


@pulumi.input_type
class ServiceTemplateContainerEnvArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None,
                 value_source: Optional[pulumi.Input['ServiceTemplateContainerEnvValueSourceArgs']] = None):
        """
        :param pulumi.Input[str] name: Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
        :param pulumi.Input[str] value: Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "", and the maximum length is 32768 bytes
        :param pulumi.Input['ServiceTemplateContainerEnvValueSourceArgs'] value_source: Source for the environment variable's value.
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_source is not None:
            pulumi.set(__self__, "value_source", value_source)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "", and the maximum length is 32768 bytes
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> Optional[pulumi.Input['ServiceTemplateContainerEnvValueSourceArgs']]:
        """
        Source for the environment variable's value.
        Structure is documented below.
        """
        return pulumi.get(self, "value_source")

    @value_source.setter
    def value_source(self, value: Optional[pulumi.Input['ServiceTemplateContainerEnvValueSourceArgs']]):
        pulumi.set(self, "value_source", value)


@pulumi.input_type
class ServiceTemplateContainerEnvValueSourceArgs:
    def __init__(__self__, *,
                 secret_key_ref: Optional[pulumi.Input['ServiceTemplateContainerEnvValueSourceSecretKeyRefArgs']] = None):
        """
        :param pulumi.Input['ServiceTemplateContainerEnvValueSourceSecretKeyRefArgs'] secret_key_ref: Selects a secret and a specific version from Cloud Secret Manager.
               Structure is documented below.
        """
        if secret_key_ref is not None:
            pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> Optional[pulumi.Input['ServiceTemplateContainerEnvValueSourceSecretKeyRefArgs']]:
        """
        Selects a secret and a specific version from Cloud Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_key_ref")

    @secret_key_ref.setter
    def secret_key_ref(self, value: Optional[pulumi.Input['ServiceTemplateContainerEnvValueSourceSecretKeyRefArgs']]):
        pulumi.set(self, "secret_key_ref", value)


@pulumi.input_type
class ServiceTemplateContainerEnvValueSourceSecretKeyRefArgs:
    def __init__(__self__, *,
                 secret: pulumi.Input[str],
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] secret: The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        :param pulumi.Input[str] version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        pulumi.set(__self__, "secret", secret)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[str]:
        """
        The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ServiceTemplateContainerLivenessProbeArgs:
    def __init__(__self__, *,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 http_get: Optional[pulumi.Input['ServiceTemplateContainerLivenessProbeHttpGetArgs']] = None,
                 initial_delay_seconds: Optional[pulumi.Input[int]] = None,
                 period_seconds: Optional[pulumi.Input[int]] = None,
                 tcp_socket: Optional[pulumi.Input['ServiceTemplateContainerLivenessProbeTcpSocketArgs']] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param pulumi.Input['ServiceTemplateContainerLivenessProbeHttpGetArgs'] http_get: HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param pulumi.Input[int] initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param pulumi.Input[int] period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        :param pulumi.Input['ServiceTemplateContainerLivenessProbeTcpSocketArgs'] tcp_socket: TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param pulumi.Input[int] timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional[pulumi.Input['ServiceTemplateContainerLivenessProbeHttpGetArgs']]:
        """
        HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "http_get")

    @http_get.setter
    def http_get(self, value: Optional[pulumi.Input['ServiceTemplateContainerLivenessProbeHttpGetArgs']]):
        pulumi.set(self, "http_get", value)

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @initial_delay_seconds.setter
    def initial_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_delay_seconds", value)

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        """
        return pulumi.get(self, "period_seconds")

    @period_seconds.setter
    def period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period_seconds", value)

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional[pulumi.Input['ServiceTemplateContainerLivenessProbeTcpSocketArgs']]:
        """
        TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_socket")

    @tcp_socket.setter
    def tcp_socket(self, value: Optional[pulumi.Input['ServiceTemplateContainerLivenessProbeTcpSocketArgs']]):
        pulumi.set(self, "tcp_socket", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.input_type
class ServiceTemplateContainerLivenessProbeHttpGetArgs:
    def __init__(__self__, *,
                 http_headers: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerLivenessProbeHttpGetHttpHeaderArgs']]]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerLivenessProbeHttpGetHttpHeaderArgs']]] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
               Structure is documented below.
        :param pulumi.Input[str] path: Path to access on the HTTP server. Defaults to '/'.
        """
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerLivenessProbeHttpGetHttpHeaderArgs']]]]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        Structure is documented below.
        """
        return pulumi.get(self, "http_headers")

    @http_headers.setter
    def http_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerLivenessProbeHttpGetHttpHeaderArgs']]]]):
        pulumi.set(self, "http_headers", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to access on the HTTP server. Defaults to '/'.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class ServiceTemplateContainerLivenessProbeHttpGetHttpHeaderArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The header field name
        :param pulumi.Input[str] value: The header field value
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The header field value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ServiceTemplateContainerLivenessProbeTcpSocketArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] port: Port number to access on the container. Must be in the range 1 to 65535. If not specified, defaults to 8080.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port number to access on the container. Must be in the range 1 to 65535. If not specified, defaults to 8080.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ServiceTemplateContainerPortArgs:
    def __init__(__self__, *,
                 container_port: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] container_port: Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        :param pulumi.Input[str] name: If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[pulumi.Input[int]]:
        """
        Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        """
        return pulumi.get(self, "container_port")

    @container_port.setter
    def container_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "container_port", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ServiceTemplateContainerResourcesArgs:
    def __init__(__self__, *,
                 cpu_idle: Optional[pulumi.Input[bool]] = None,
                 limits: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[bool] cpu_idle: Determines whether CPU should be throttled or not outside of requests.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] limits: Only memory and CPU are supported. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        if cpu_idle is not None:
            pulumi.set(__self__, "cpu_idle", cpu_idle)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)

    @property
    @pulumi.getter(name="cpuIdle")
    def cpu_idle(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether CPU should be throttled or not outside of requests.
        """
        return pulumi.get(self, "cpu_idle")

    @cpu_idle.setter
    def cpu_idle(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cpu_idle", value)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Only memory and CPU are supported. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "limits", value)


@pulumi.input_type
class ServiceTemplateContainerStartupProbeArgs:
    def __init__(__self__, *,
                 failure_threshold: Optional[pulumi.Input[int]] = None,
                 http_get: Optional[pulumi.Input['ServiceTemplateContainerStartupProbeHttpGetArgs']] = None,
                 initial_delay_seconds: Optional[pulumi.Input[int]] = None,
                 period_seconds: Optional[pulumi.Input[int]] = None,
                 tcp_socket: Optional[pulumi.Input['ServiceTemplateContainerStartupProbeTcpSocketArgs']] = None,
                 timeout_seconds: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param pulumi.Input['ServiceTemplateContainerStartupProbeHttpGetArgs'] http_get: HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param pulumi.Input[int] initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param pulumi.Input[int] period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        :param pulumi.Input['ServiceTemplateContainerStartupProbeTcpSocketArgs'] tcp_socket: TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param pulumi.Input[int] timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @failure_threshold.setter
    def failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "failure_threshold", value)

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional[pulumi.Input['ServiceTemplateContainerStartupProbeHttpGetArgs']]:
        """
        HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "http_get")

    @http_get.setter
    def http_get(self, value: Optional[pulumi.Input['ServiceTemplateContainerStartupProbeHttpGetArgs']]):
        pulumi.set(self, "http_get", value)

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @initial_delay_seconds.setter
    def initial_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_delay_seconds", value)

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        """
        return pulumi.get(self, "period_seconds")

    @period_seconds.setter
    def period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period_seconds", value)

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional[pulumi.Input['ServiceTemplateContainerStartupProbeTcpSocketArgs']]:
        """
        TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_socket")

    @tcp_socket.setter
    def tcp_socket(self, value: Optional[pulumi.Input['ServiceTemplateContainerStartupProbeTcpSocketArgs']]):
        pulumi.set(self, "tcp_socket", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_seconds", value)


@pulumi.input_type
class ServiceTemplateContainerStartupProbeHttpGetArgs:
    def __init__(__self__, *,
                 http_headers: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerStartupProbeHttpGetHttpHeaderArgs']]]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerStartupProbeHttpGetHttpHeaderArgs']]] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
               Structure is documented below.
        :param pulumi.Input[str] path: Path to access on the HTTP server. Defaults to '/'.
        """
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerStartupProbeHttpGetHttpHeaderArgs']]]]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        Structure is documented below.
        """
        return pulumi.get(self, "http_headers")

    @http_headers.setter
    def http_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateContainerStartupProbeHttpGetHttpHeaderArgs']]]]):
        pulumi.set(self, "http_headers", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to access on the HTTP server. Defaults to '/'.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class ServiceTemplateContainerStartupProbeHttpGetHttpHeaderArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The header field name
        :param pulumi.Input[str] value: The header field value
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The header field value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ServiceTemplateContainerStartupProbeTcpSocketArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] port: Port number to access on the container. Must be in the range 1 to 65535. If not specified, defaults to 8080.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port number to access on the container. Must be in the range 1 to 65535. If not specified, defaults to 8080.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ServiceTemplateContainerVolumeMountArgs:
    def __init__(__self__, *,
                 mount_path: pulumi.Input[str],
                 name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] mount_path: Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        :param pulumi.Input[str] name: This must match the Name of a Volume.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> pulumi.Input[str]:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ServiceTemplateScalingArgs:
    def __init__(__self__, *,
                 max_instance_count: Optional[pulumi.Input[int]] = None,
                 min_instance_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] max_instance_count: Maximum number of serving instances that this resource should have.
        :param pulumi.Input[int] min_instance_count: Minimum number of serving instances that this resource should have.
        """
        if max_instance_count is not None:
            pulumi.set(__self__, "max_instance_count", max_instance_count)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of serving instances that this resource should have.
        """
        return pulumi.get(self, "max_instance_count")

    @max_instance_count.setter
    def max_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_instance_count", value)

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of serving instances that this resource should have.
        """
        return pulumi.get(self, "min_instance_count")

    @min_instance_count.setter
    def min_instance_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_instance_count", value)


@pulumi.input_type
class ServiceTemplateVolumeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 cloud_sql_instance: Optional[pulumi.Input['ServiceTemplateVolumeCloudSqlInstanceArgs']] = None,
                 secret: Optional[pulumi.Input['ServiceTemplateVolumeSecretArgs']] = None):
        """
        :param pulumi.Input[str] name: Volume's name.
        :param pulumi.Input['ServiceTemplateVolumeCloudSqlInstanceArgs'] cloud_sql_instance: For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
               Structure is documented below.
        :param pulumi.Input['ServiceTemplateVolumeSecretArgs'] secret: Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if cloud_sql_instance is not None:
            pulumi.set(__self__, "cloud_sql_instance", cloud_sql_instance)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="cloudSqlInstance")
    def cloud_sql_instance(self) -> Optional[pulumi.Input['ServiceTemplateVolumeCloudSqlInstanceArgs']]:
        """
        For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_sql_instance")

    @cloud_sql_instance.setter
    def cloud_sql_instance(self, value: Optional[pulumi.Input['ServiceTemplateVolumeCloudSqlInstanceArgs']]):
        pulumi.set(self, "cloud_sql_instance", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input['ServiceTemplateVolumeSecretArgs']]:
        """
        Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        Structure is documented below.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input['ServiceTemplateVolumeSecretArgs']]):
        pulumi.set(self, "secret", value)


@pulumi.input_type
class ServiceTemplateVolumeCloudSqlInstanceArgs:
    def __init__(__self__, *,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instances: The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        if instances is not None:
            pulumi.set(__self__, "instances", instances)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instances", value)


@pulumi.input_type
class ServiceTemplateVolumeSecretArgs:
    def __init__(__self__, *,
                 secret: pulumi.Input[str],
                 default_mode: Optional[pulumi.Input[int]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateVolumeSecretItemArgs']]]] = None):
        """
        :param pulumi.Input[str] secret: The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        :param pulumi.Input[int] default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTemplateVolumeSecretItemArgs']]] items: If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
               Structure is documented below.
        """
        pulumi.set(__self__, "secret", secret)
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[str]:
        """
        The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[pulumi.Input[int]]:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        """
        return pulumi.get(self, "default_mode")

    @default_mode.setter
    def default_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_mode", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateVolumeSecretItemArgs']]]]:
        """
        If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        Structure is documented below.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTemplateVolumeSecretItemArgs']]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class ServiceTemplateVolumeSecretItemArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[int],
                 path: pulumi.Input[str],
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] mode: Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        :param pulumi.Input[str] path: The relative path of the secret in the container.
        :param pulumi.Input[str] version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[int]:
        """
        Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[int]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The relative path of the secret in the container.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ServiceTemplateVpcAccessArgs:
    def __init__(__self__, *,
                 connector: Optional[pulumi.Input[str]] = None,
                 egress: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] connector: VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        :param pulumi.Input[str] egress: Traffic VPC egress settings.
               Possible values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`.
        """
        if connector is not None:
            pulumi.set(__self__, "connector", connector)
        if egress is not None:
            pulumi.set(__self__, "egress", egress)

    @property
    @pulumi.getter
    def connector(self) -> Optional[pulumi.Input[str]]:
        """
        VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        """
        return pulumi.get(self, "connector")

    @connector.setter
    def connector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connector", value)

    @property
    @pulumi.getter
    def egress(self) -> Optional[pulumi.Input[str]]:
        """
        Traffic VPC egress settings.
        Possible values are `ALL_TRAFFIC` and `PRIVATE_RANGES_ONLY`.
        """
        return pulumi.get(self, "egress")

    @egress.setter
    def egress(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "egress", value)


@pulumi.input_type
class ServiceTerminalConditionArgs:
    def __init__(__self__, *,
                 execution_reason: Optional[pulumi.Input[str]] = None,
                 last_transition_time: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None,
                 revision_reason: Optional[pulumi.Input[str]] = None,
                 severity: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] execution_reason: A reason for the execution condition.
        :param pulumi.Input[str] last_transition_time: Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] message: Human readable message indicating details about the current status.
        :param pulumi.Input[str] reason: A common (service-level) reason for this condition.
        :param pulumi.Input[str] revision_reason: A reason for the revision condition.
        :param pulumi.Input[str] severity: How to interpret failures of this condition, one of Error, Warning, Info
        :param pulumi.Input[str] state: State of the condition.
        :param pulumi.Input[str] type: The allocation type for this traffic target.
               Possible values are `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST` and `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[pulumi.Input[str]]:
        """
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @execution_reason.setter
    def execution_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "execution_reason", value)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[pulumi.Input[str]]:
        """
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @last_transition_time.setter
    def last_transition_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_transition_time", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)

    @property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[pulumi.Input[str]]:
        """
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @revision_reason.setter
    def revision_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_reason", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[str]]:
        """
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the condition.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The allocation type for this traffic target.
        Possible values are `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST` and `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ServiceTrafficArgs:
    def __init__(__self__, *,
                 percent: Optional[pulumi.Input[int]] = None,
                 revision: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] percent: Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        :param pulumi.Input[str] revision: Revision to which to send this portion of traffic, if traffic allocation is by revision.
        :param pulumi.Input[str] tag: Indicates a string to be part of the URI to exclusively reference this target.
        :param pulumi.Input[str] type: The allocation type for this traffic target.
               Possible values are `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST` and `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        if percent is not None:
            pulumi.set(__self__, "percent", percent)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def percent(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        """
        return pulumi.get(self, "percent")

    @percent.setter
    def percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "percent", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[str]]:
        """
        Revision to which to send this portion of traffic, if traffic allocation is by revision.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates a string to be part of the URI to exclusively reference this target.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The allocation type for this traffic target.
        Possible values are `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST` and `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ServiceTrafficStatusArgs:
    def __init__(__self__, *,
                 percent: Optional[pulumi.Input[int]] = None,
                 revision: Optional[pulumi.Input[str]] = None,
                 tag: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] percent: Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        :param pulumi.Input[str] revision: The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
               (Optional)
               Revision to which to send this portion of traffic, if traffic allocation is by revision.
        :param pulumi.Input[str] tag: Indicates a string to be part of the URI to exclusively reference this target.
        :param pulumi.Input[str] type: The allocation type for this traffic target.
               Possible values are `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST` and `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        :param pulumi.Input[str] uri: Displays the target URI.
        """
        if percent is not None:
            pulumi.set(__self__, "percent", percent)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def percent(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        """
        return pulumi.get(self, "percent")

    @percent.setter
    def percent(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "percent", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
        (Optional)
        Revision to which to send this portion of traffic, if traffic allocation is by revision.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates a string to be part of the URI to exclusively reference this target.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The allocation type for this traffic target.
        Possible values are `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST` and `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Displays the target URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


