# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 template: pulumi.Input['ServiceTemplateArgs'],
                 binary_authorization: Optional[pulumi.Input['ServiceBinaryAuthorizationArgs']] = None,
                 client: Optional[pulumi.Input[str]] = None,
                 client_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ingress: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 launch_stage: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input['ServiceTemplateArgs'] template: The template used to create revisions for this Service.
               Structure is documented below.
        :param pulumi.Input['ServiceBinaryAuthorizationArgs'] binary_authorization: Settings for the Binary Authorization feature.
               Structure is documented below.
        :param pulumi.Input[str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[str] description: User-provided description of the Service. This field currently has a 512-character limit.
        :param pulumi.Input[str] ingress: Provides the ingress settings for this Service. On output, returns the currently observed ingress settings, or INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
               Possible values are `INGRESS_TRAFFIC_ALL`, `INGRESS_TRAFFIC_INTERNAL_ONLY`, and `INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: KRM-style labels for the resource.
               (Optional)
               Map of string keys and values that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels Cloud Run will populate some labels with 'run.googleapis.com' or 'serving.knative.dev' namespaces. Those labels are read-only, and user changes will not be preserved.
        :param pulumi.Input[str] launch_stage: The launch stage as defined by Google Cloud Platform Launch Stages. Cloud Run supports ALPHA, BETA, and GA. If no value is specified, GA is assumed.
               Possible values are `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, and `DEPRECATED`.
        :param pulumi.Input[str] location: The location of the cloud run service
        :param pulumi.Input[str] name: Name of the Service.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]] traffics: Specifies how to distribute traffic over a collection of Revisions belonging to the Service. If traffic is empty or not provided, defaults to 100% traffic to the latest Ready Revision.
               Structure is documented below.
        """
        pulumi.set(__self__, "template", template)
        if binary_authorization is not None:
            pulumi.set(__self__, "binary_authorization", binary_authorization)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if client_version is not None:
            pulumi.set(__self__, "client_version", client_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launch_stage is not None:
            pulumi.set(__self__, "launch_stage", launch_stage)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if traffics is not None:
            pulumi.set(__self__, "traffics", traffics)

    @property
    @pulumi.getter
    def template(self) -> pulumi.Input['ServiceTemplateArgs']:
        """
        The template used to create revisions for this Service.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: pulumi.Input['ServiceTemplateArgs']):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> Optional[pulumi.Input['ServiceBinaryAuthorizationArgs']]:
        """
        Settings for the Binary Authorization feature.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @binary_authorization.setter
    def binary_authorization(self, value: Optional[pulumi.Input['ServiceBinaryAuthorizationArgs']]):
        pulumi.set(self, "binary_authorization", value)

    @property
    @pulumi.getter
    def client(self) -> Optional[pulumi.Input[str]]:
        """
        Arbitrary identifier for the API client.
        """
        return pulumi.get(self, "client")

    @client.setter
    def client(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client", value)

    @property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> Optional[pulumi.Input[str]]:
        """
        Arbitrary version identifier for the API client.
        """
        return pulumi.get(self, "client_version")

    @client_version.setter
    def client_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User-provided description of the Service. This field currently has a 512-character limit.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def ingress(self) -> Optional[pulumi.Input[str]]:
        """
        Provides the ingress settings for this Service. On output, returns the currently observed ingress settings, or INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
        Possible values are `INGRESS_TRAFFIC_ALL`, `INGRESS_TRAFFIC_INTERNAL_ONLY`, and `INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER`.
        """
        return pulumi.get(self, "ingress")

    @ingress.setter
    def ingress(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        KRM-style labels for the resource.
        (Optional)
        Map of string keys and values that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels Cloud Run will populate some labels with 'run.googleapis.com' or 'serving.knative.dev' namespaces. Those labels are read-only, and user changes will not be preserved.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> Optional[pulumi.Input[str]]:
        """
        The launch stage as defined by Google Cloud Platform Launch Stages. Cloud Run supports ALPHA, BETA, and GA. If no value is specified, GA is assumed.
        Possible values are `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, and `DEPRECATED`.
        """
        return pulumi.get(self, "launch_stage")

    @launch_stage.setter
    def launch_stage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_stage", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the cloud run service
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def traffics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]]:
        """
        Specifies how to distribute traffic over a collection of Revisions belonging to the Service. If traffic is empty or not provided, defaults to 100% traffic to the latest Ready Revision.
        Structure is documented below.
        """
        return pulumi.get(self, "traffics")

    @traffics.setter
    def traffics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]]):
        pulumi.set(self, "traffics", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 binary_authorization: Optional[pulumi.Input['ServiceBinaryAuthorizationArgs']] = None,
                 client: Optional[pulumi.Input[str]] = None,
                 client_version: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConditionArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 generation: Optional[pulumi.Input[str]] = None,
                 ingress: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 latest_created_revision: Optional[pulumi.Input[str]] = None,
                 latest_ready_revision: Optional[pulumi.Input[str]] = None,
                 launch_stage: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 observed_generation: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reconciling: Optional[pulumi.Input[bool]] = None,
                 template: Optional[pulumi.Input['ServiceTemplateArgs']] = None,
                 terminal_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTerminalConditionArgs']]]] = None,
                 traffic_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficStatusArgs']]]] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input['ServiceBinaryAuthorizationArgs'] binary_authorization: Settings for the Binary Authorization feature.
               Structure is documented below.
        :param pulumi.Input[str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceConditionArgs']]] conditions: The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Service does not reach its Serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[str] description: User-provided description of the Service. This field currently has a 512-character limit.
        :param pulumi.Input[str] etag: A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        :param pulumi.Input[str] generation: A number that monotonically increases every time the user modifies the desired state. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        :param pulumi.Input[str] ingress: Provides the ingress settings for this Service. On output, returns the currently observed ingress settings, or INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
               Possible values are `INGRESS_TRAFFIC_ALL`, `INGRESS_TRAFFIC_INTERNAL_ONLY`, and `INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: KRM-style labels for the resource.
               (Optional)
               Map of string keys and values that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels Cloud Run will populate some labels with 'run.googleapis.com' or 'serving.knative.dev' namespaces. Those labels are read-only, and user changes will not be preserved.
        :param pulumi.Input[str] latest_created_revision: Name of the last created revision. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        :param pulumi.Input[str] latest_ready_revision: Name of the latest revision that is serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        :param pulumi.Input[str] launch_stage: The launch stage as defined by Google Cloud Platform Launch Stages. Cloud Run supports ALPHA, BETA, and GA. If no value is specified, GA is assumed.
               Possible values are `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, and `DEPRECATED`.
        :param pulumi.Input[str] location: The location of the cloud run service
        :param pulumi.Input[str] name: Name of the Service.
        :param pulumi.Input[str] observed_generation: The generation of this Service currently serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] reconciling: Returns true if the Service is currently being acted upon by the system to bring it into the desired state.
               When a new Service is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Service to the desired serving state. This process is called reconciliation. While reconciliation is in process, observedGeneration, latest_ready_revison, trafficStatuses, and uri will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the serving state matches the Service, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
               If reconciliation succeeded, the following fields will match: traffic and trafficStatuses, observedGeneration and generation, latestReadyRevision and latestCreatedRevision.
               If reconciliation failed, trafficStatuses, observedGeneration, and latestReadyRevision will have the state of the last serving revision, or empty for newly created Services. Additional information on the failure can be found in terminalCondition and conditions.
        :param pulumi.Input['ServiceTemplateArgs'] template: The template used to create revisions for this Service.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTerminalConditionArgs']]] terminal_conditions: The Condition of this Service, containing its readiness status, and detailed error information in case it did not reach a serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTrafficStatusArgs']]] traffic_statuses: Detailed status information for corresponding traffic targets. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]] traffics: Specifies how to distribute traffic over a collection of Revisions belonging to the Service. If traffic is empty or not provided, defaults to 100% traffic to the latest Ready Revision.
               Structure is documented below.
        :param pulumi.Input[str] uid: Server assigned unique identifier for the trigger. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[str] uri: Displays the target URI.
        """
        if binary_authorization is not None:
            pulumi.set(__self__, "binary_authorization", binary_authorization)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if client_version is not None:
            pulumi.set(__self__, "client_version", client_version)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if ingress is not None:
            pulumi.set(__self__, "ingress", ingress)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if latest_created_revision is not None:
            pulumi.set(__self__, "latest_created_revision", latest_created_revision)
        if latest_ready_revision is not None:
            pulumi.set(__self__, "latest_ready_revision", latest_ready_revision)
        if launch_stage is not None:
            pulumi.set(__self__, "launch_stage", launch_stage)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if terminal_conditions is not None:
            pulumi.set(__self__, "terminal_conditions", terminal_conditions)
        if traffic_statuses is not None:
            pulumi.set(__self__, "traffic_statuses", traffic_statuses)
        if traffics is not None:
            pulumi.set(__self__, "traffics", traffics)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> Optional[pulumi.Input['ServiceBinaryAuthorizationArgs']]:
        """
        Settings for the Binary Authorization feature.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @binary_authorization.setter
    def binary_authorization(self, value: Optional[pulumi.Input['ServiceBinaryAuthorizationArgs']]):
        pulumi.set(self, "binary_authorization", value)

    @property
    @pulumi.getter
    def client(self) -> Optional[pulumi.Input[str]]:
        """
        Arbitrary identifier for the API client.
        """
        return pulumi.get(self, "client")

    @client.setter
    def client(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client", value)

    @property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> Optional[pulumi.Input[str]]:
        """
        Arbitrary version identifier for the API client.
        """
        return pulumi.get(self, "client_version")

    @client_version.setter
    def client_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_version", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConditionArgs']]]]:
        """
        The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Service does not reach its Serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User-provided description of the Service. This field currently has a 512-character limit.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[str]]:
        """
        A number that monotonically increases every time the user modifies the desired state. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generation", value)

    @property
    @pulumi.getter
    def ingress(self) -> Optional[pulumi.Input[str]]:
        """
        Provides the ingress settings for this Service. On output, returns the currently observed ingress settings, or INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
        Possible values are `INGRESS_TRAFFIC_ALL`, `INGRESS_TRAFFIC_INTERNAL_ONLY`, and `INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER`.
        """
        return pulumi.get(self, "ingress")

    @ingress.setter
    def ingress(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        KRM-style labels for the resource.
        (Optional)
        Map of string keys and values that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels Cloud Run will populate some labels with 'run.googleapis.com' or 'serving.knative.dev' namespaces. Those labels are read-only, and user changes will not be preserved.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="latestCreatedRevision")
    def latest_created_revision(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the last created revision. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "latest_created_revision")

    @latest_created_revision.setter
    def latest_created_revision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latest_created_revision", value)

    @property
    @pulumi.getter(name="latestReadyRevision")
    def latest_ready_revision(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the latest revision that is serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "latest_ready_revision")

    @latest_ready_revision.setter
    def latest_ready_revision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latest_ready_revision", value)

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> Optional[pulumi.Input[str]]:
        """
        The launch stage as defined by Google Cloud Platform Launch Stages. Cloud Run supports ALPHA, BETA, and GA. If no value is specified, GA is assumed.
        Possible values are `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, and `DEPRECATED`.
        """
        return pulumi.get(self, "launch_stage")

    @launch_stage.setter
    def launch_stage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_stage", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the cloud run service
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Service.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[str]]:
        """
        The generation of this Service currently serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "observed_generation", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[bool]]:
        """
        Returns true if the Service is currently being acted upon by the system to bring it into the desired state.
        When a new Service is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Service to the desired serving state. This process is called reconciliation. While reconciliation is in process, observedGeneration, latest_ready_revison, trafficStatuses, and uri will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the serving state matches the Service, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
        If reconciliation succeeded, the following fields will match: traffic and trafficStatuses, observedGeneration and generation, latestReadyRevision and latestCreatedRevision.
        If reconciliation failed, trafficStatuses, observedGeneration, and latestReadyRevision will have the state of the last serving revision, or empty for newly created Services. Additional information on the failure can be found in terminalCondition and conditions.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['ServiceTemplateArgs']]:
        """
        The template used to create revisions for this Service.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['ServiceTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter(name="terminalConditions")
    def terminal_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTerminalConditionArgs']]]]:
        """
        The Condition of this Service, containing its readiness status, and detailed error information in case it did not reach a serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "terminal_conditions")

    @terminal_conditions.setter
    def terminal_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTerminalConditionArgs']]]]):
        pulumi.set(self, "terminal_conditions", value)

    @property
    @pulumi.getter(name="trafficStatuses")
    def traffic_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficStatusArgs']]]]:
        """
        Detailed status information for corresponding traffic targets. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "traffic_statuses")

    @traffic_statuses.setter
    def traffic_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficStatusArgs']]]]):
        pulumi.set(self, "traffic_statuses", value)

    @property
    @pulumi.getter
    def traffics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]]:
        """
        Specifies how to distribute traffic over a collection of Revisions belonging to the Service. If traffic is empty or not provided, defaults to 100% traffic to the latest Ready Revision.
        Structure is documented below.
        """
        return pulumi.get(self, "traffics")

    @traffics.setter
    def traffics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]]):
        pulumi.set(self, "traffics", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        Server assigned unique identifier for the trigger. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Displays the target URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 binary_authorization: Optional[pulumi.Input[pulumi.InputType['ServiceBinaryAuthorizationArgs']]] = None,
                 client: Optional[pulumi.Input[str]] = None,
                 client_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ingress: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 launch_stage: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['ServiceTemplateArgs']]] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTrafficArgs']]]]] = None,
                 __props__=None):
        """
        Service acts as a top-level container that manages a set of configurations and revision templates which implement a network service. Service exists to provide a singular abstraction which can be access controlled, reasoned about, and which encapsulates software lifecycle decisions such as rollout policy and team resource ownership.

        To get more information about Service, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/)

        ## Example Usage
        ### Cloudrunv2 Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            ingress="INGRESS_TRAFFIC_ALL",
            location="us-central1",
            template=gcp.cloudrunv2.ServiceTemplateArgs(
                containers=[gcp.cloudrunv2.ServiceTemplateContainerArgs(
                    image="us-docker.pkg.dev/cloudrun/container/hello",
                )],
            ))
        ```
        ### Cloudrunv2 Service Sql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret-1",
            replication=gcp.secretmanager.SecretReplicationArgs(
                automatic=True,
            ))
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        instance = gcp.sql.DatabaseInstance("instance",
            region="us-central1",
            database_version="MYSQL_5_7",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
            ),
            deletion_protection=True)
        default = gcp.cloudrunv2.Service("default",
            location="us-central1",
            ingress="INGRESS_TRAFFIC_ALL",
            template=gcp.cloudrunv2.ServiceTemplateArgs(
                scaling=gcp.cloudrunv2.ServiceTemplateScalingArgs(
                    max_instance_count=2,
                ),
                volumes=[gcp.cloudrunv2.ServiceTemplateVolumeArgs(
                    name="cloudsql",
                    cloud_sql_instance=gcp.cloudrunv2.ServiceTemplateVolumeCloudSqlInstanceArgs(
                        instances=[instance.connection_name],
                    ),
                )],
                containers=[gcp.cloudrunv2.ServiceTemplateContainerArgs(
                    image="us-docker.pkg.dev/cloudrun/container/hello",
                    envs=[
                        gcp.cloudrunv2.ServiceTemplateContainerEnvArgs(
                            name="FOO",
                            value="bar",
                        ),
                        gcp.cloudrunv2.ServiceTemplateContainerEnvArgs(
                            name="SECRET_ENV_VAR",
                            value_source=gcp.cloudrunv2.ServiceTemplateContainerEnvValueSourceArgs(
                                secret_key_ref=gcp.cloudrunv2.ServiceTemplateContainerEnvValueSourceSecretKeyRefArgs(
                                    secret=secret.secret_id,
                                    version="1",
                                ),
                            ),
                        ),
                    ],
                    volume_mounts=[gcp.cloudrunv2.ServiceTemplateContainerVolumeMountArgs(
                        name="cloudsql",
                        mount_path="/cloudsql",
                    )],
                )],
            ),
            traffics=[gcp.cloudrunv2.ServiceTrafficArgs(
                type="TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST",
                percent=100,
            )],
            opts=pulumi.ResourceOptions(depends_on=[secret_version_data]))
        project = gcp.organizations.get_project()
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts=pulumi.ResourceOptions(depends_on=[secret]))
        ```
        ### Cloudrunv2 Service Vpcaccess

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test_network = gcp.compute.Network("customTestNetwork", auto_create_subnetworks=False)
        custom_test_subnetwork = gcp.compute.Subnetwork("customTestSubnetwork",
            ip_cidr_range="10.2.0.0/28",
            region="us-central1",
            network=custom_test_network.id)
        connector = gcp.vpcaccess.Connector("connector",
            subnet=gcp.vpcaccess.ConnectorSubnetArgs(
                name=custom_test_subnetwork.name,
            ),
            machine_type="e2-standard-4",
            min_instances=2,
            max_instances=3,
            region="us-central1")
        default = gcp.cloudrunv2.Service("default",
            location="us-central1",
            template=gcp.cloudrunv2.ServiceTemplateArgs(
                containers=[gcp.cloudrunv2.ServiceTemplateContainerArgs(
                    image="us-docker.pkg.dev/cloudrun/container/hello",
                )],
                vpc_access=gcp.cloudrunv2.ServiceTemplateVpcAccessArgs(
                    connector=connector.id,
                    egress="ALL_TRAFFIC",
                ),
            ))
        ```
        ### Cloudrunv2 Service Probes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            location="us-central1",
            template=gcp.cloudrunv2.ServiceTemplateArgs(
                containers=[gcp.cloudrunv2.ServiceTemplateContainerArgs(
                    image="us-docker.pkg.dev/cloudrun/container/hello",
                    liveness_probe=gcp.cloudrunv2.ServiceTemplateContainerLivenessProbeArgs(
                        http_get=gcp.cloudrunv2.ServiceTemplateContainerLivenessProbeHttpGetArgs(
                            path="/",
                        ),
                    ),
                    startup_probe=gcp.cloudrunv2.ServiceTemplateContainerStartupProbeArgs(
                        failure_threshold=1,
                        initial_delay_seconds=0,
                        period_seconds=3,
                        tcp_socket=gcp.cloudrunv2.ServiceTemplateContainerStartupProbeTcpSocketArgs(
                            port=8080,
                        ),
                        timeout_seconds=1,
                    ),
                )],
            ))
        ```
        ### Cloudrunv2 Service Secret

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret-1",
            replication=gcp.secretmanager.SecretReplicationArgs(
                automatic=True,
            ))
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        default = gcp.cloudrunv2.Service("default",
            location="us-central1",
            ingress="INGRESS_TRAFFIC_ALL",
            template=gcp.cloudrunv2.ServiceTemplateArgs(
                volumes=[gcp.cloudrunv2.ServiceTemplateVolumeArgs(
                    name="a-volume",
                    secret=gcp.cloudrunv2.ServiceTemplateVolumeSecretArgs(
                        secret=secret.secret_id,
                        default_mode=292,
                        items=[gcp.cloudrunv2.ServiceTemplateVolumeSecretItemArgs(
                            version="1",
                            path="my-secret",
                            mode=256,
                        )],
                    ),
                )],
                containers=[gcp.cloudrunv2.ServiceTemplateContainerArgs(
                    image="us-docker.pkg.dev/cloudrun/container/hello",
                    volume_mounts=[gcp.cloudrunv2.ServiceTemplateContainerVolumeMountArgs(
                        name="a-volume",
                        mount_path="/secrets",
                    )],
                )],
            ),
            opts=pulumi.ResourceOptions(depends_on=[secret_version_data]))
        project = gcp.organizations.get_project()
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts=pulumi.ResourceOptions(depends_on=[secret]))
        ```

        ## Import

        Service can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:cloudrunv2/service:Service default projects/{{project}}/locations/{{location}}/services/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudrunv2/service:Service default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudrunv2/service:Service default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServiceBinaryAuthorizationArgs']] binary_authorization: Settings for the Binary Authorization feature.
               Structure is documented below.
        :param pulumi.Input[str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[str] description: User-provided description of the Service. This field currently has a 512-character limit.
        :param pulumi.Input[str] ingress: Provides the ingress settings for this Service. On output, returns the currently observed ingress settings, or INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
               Possible values are `INGRESS_TRAFFIC_ALL`, `INGRESS_TRAFFIC_INTERNAL_ONLY`, and `INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: KRM-style labels for the resource.
               (Optional)
               Map of string keys and values that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels Cloud Run will populate some labels with 'run.googleapis.com' or 'serving.knative.dev' namespaces. Those labels are read-only, and user changes will not be preserved.
        :param pulumi.Input[str] launch_stage: The launch stage as defined by Google Cloud Platform Launch Stages. Cloud Run supports ALPHA, BETA, and GA. If no value is specified, GA is assumed.
               Possible values are `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, and `DEPRECATED`.
        :param pulumi.Input[str] location: The location of the cloud run service
        :param pulumi.Input[str] name: Name of the Service.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['ServiceTemplateArgs']] template: The template used to create revisions for this Service.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTrafficArgs']]]] traffics: Specifies how to distribute traffic over a collection of Revisions belonging to the Service. If traffic is empty or not provided, defaults to 100% traffic to the latest Ready Revision.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Service acts as a top-level container that manages a set of configurations and revision templates which implement a network service. Service exists to provide a singular abstraction which can be access controlled, reasoned about, and which encapsulates software lifecycle decisions such as rollout policy and team resource ownership.

        To get more information about Service, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/)

        ## Example Usage
        ### Cloudrunv2 Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            ingress="INGRESS_TRAFFIC_ALL",
            location="us-central1",
            template=gcp.cloudrunv2.ServiceTemplateArgs(
                containers=[gcp.cloudrunv2.ServiceTemplateContainerArgs(
                    image="us-docker.pkg.dev/cloudrun/container/hello",
                )],
            ))
        ```
        ### Cloudrunv2 Service Sql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret-1",
            replication=gcp.secretmanager.SecretReplicationArgs(
                automatic=True,
            ))
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        instance = gcp.sql.DatabaseInstance("instance",
            region="us-central1",
            database_version="MYSQL_5_7",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
            ),
            deletion_protection=True)
        default = gcp.cloudrunv2.Service("default",
            location="us-central1",
            ingress="INGRESS_TRAFFIC_ALL",
            template=gcp.cloudrunv2.ServiceTemplateArgs(
                scaling=gcp.cloudrunv2.ServiceTemplateScalingArgs(
                    max_instance_count=2,
                ),
                volumes=[gcp.cloudrunv2.ServiceTemplateVolumeArgs(
                    name="cloudsql",
                    cloud_sql_instance=gcp.cloudrunv2.ServiceTemplateVolumeCloudSqlInstanceArgs(
                        instances=[instance.connection_name],
                    ),
                )],
                containers=[gcp.cloudrunv2.ServiceTemplateContainerArgs(
                    image="us-docker.pkg.dev/cloudrun/container/hello",
                    envs=[
                        gcp.cloudrunv2.ServiceTemplateContainerEnvArgs(
                            name="FOO",
                            value="bar",
                        ),
                        gcp.cloudrunv2.ServiceTemplateContainerEnvArgs(
                            name="SECRET_ENV_VAR",
                            value_source=gcp.cloudrunv2.ServiceTemplateContainerEnvValueSourceArgs(
                                secret_key_ref=gcp.cloudrunv2.ServiceTemplateContainerEnvValueSourceSecretKeyRefArgs(
                                    secret=secret.secret_id,
                                    version="1",
                                ),
                            ),
                        ),
                    ],
                    volume_mounts=[gcp.cloudrunv2.ServiceTemplateContainerVolumeMountArgs(
                        name="cloudsql",
                        mount_path="/cloudsql",
                    )],
                )],
            ),
            traffics=[gcp.cloudrunv2.ServiceTrafficArgs(
                type="TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST",
                percent=100,
            )],
            opts=pulumi.ResourceOptions(depends_on=[secret_version_data]))
        project = gcp.organizations.get_project()
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts=pulumi.ResourceOptions(depends_on=[secret]))
        ```
        ### Cloudrunv2 Service Vpcaccess

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test_network = gcp.compute.Network("customTestNetwork", auto_create_subnetworks=False)
        custom_test_subnetwork = gcp.compute.Subnetwork("customTestSubnetwork",
            ip_cidr_range="10.2.0.0/28",
            region="us-central1",
            network=custom_test_network.id)
        connector = gcp.vpcaccess.Connector("connector",
            subnet=gcp.vpcaccess.ConnectorSubnetArgs(
                name=custom_test_subnetwork.name,
            ),
            machine_type="e2-standard-4",
            min_instances=2,
            max_instances=3,
            region="us-central1")
        default = gcp.cloudrunv2.Service("default",
            location="us-central1",
            template=gcp.cloudrunv2.ServiceTemplateArgs(
                containers=[gcp.cloudrunv2.ServiceTemplateContainerArgs(
                    image="us-docker.pkg.dev/cloudrun/container/hello",
                )],
                vpc_access=gcp.cloudrunv2.ServiceTemplateVpcAccessArgs(
                    connector=connector.id,
                    egress="ALL_TRAFFIC",
                ),
            ))
        ```
        ### Cloudrunv2 Service Probes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.Service("default",
            location="us-central1",
            template=gcp.cloudrunv2.ServiceTemplateArgs(
                containers=[gcp.cloudrunv2.ServiceTemplateContainerArgs(
                    image="us-docker.pkg.dev/cloudrun/container/hello",
                    liveness_probe=gcp.cloudrunv2.ServiceTemplateContainerLivenessProbeArgs(
                        http_get=gcp.cloudrunv2.ServiceTemplateContainerLivenessProbeHttpGetArgs(
                            path="/",
                        ),
                    ),
                    startup_probe=gcp.cloudrunv2.ServiceTemplateContainerStartupProbeArgs(
                        failure_threshold=1,
                        initial_delay_seconds=0,
                        period_seconds=3,
                        tcp_socket=gcp.cloudrunv2.ServiceTemplateContainerStartupProbeTcpSocketArgs(
                            port=8080,
                        ),
                        timeout_seconds=1,
                    ),
                )],
            ))
        ```
        ### Cloudrunv2 Service Secret

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret-1",
            replication=gcp.secretmanager.SecretReplicationArgs(
                automatic=True,
            ))
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        default = gcp.cloudrunv2.Service("default",
            location="us-central1",
            ingress="INGRESS_TRAFFIC_ALL",
            template=gcp.cloudrunv2.ServiceTemplateArgs(
                volumes=[gcp.cloudrunv2.ServiceTemplateVolumeArgs(
                    name="a-volume",
                    secret=gcp.cloudrunv2.ServiceTemplateVolumeSecretArgs(
                        secret=secret.secret_id,
                        default_mode=292,
                        items=[gcp.cloudrunv2.ServiceTemplateVolumeSecretItemArgs(
                            version="1",
                            path="my-secret",
                            mode=256,
                        )],
                    ),
                )],
                containers=[gcp.cloudrunv2.ServiceTemplateContainerArgs(
                    image="us-docker.pkg.dev/cloudrun/container/hello",
                    volume_mounts=[gcp.cloudrunv2.ServiceTemplateContainerVolumeMountArgs(
                        name="a-volume",
                        mount_path="/secrets",
                    )],
                )],
            ),
            opts=pulumi.ResourceOptions(depends_on=[secret_version_data]))
        project = gcp.organizations.get_project()
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts=pulumi.ResourceOptions(depends_on=[secret]))
        ```

        ## Import

        Service can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:cloudrunv2/service:Service default projects/{{project}}/locations/{{location}}/services/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudrunv2/service:Service default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudrunv2/service:Service default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 binary_authorization: Optional[pulumi.Input[pulumi.InputType['ServiceBinaryAuthorizationArgs']]] = None,
                 client: Optional[pulumi.Input[str]] = None,
                 client_version: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ingress: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 launch_stage: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['ServiceTemplateArgs']]] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTrafficArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["binary_authorization"] = binary_authorization
            __props__.__dict__["client"] = client
            __props__.__dict__["client_version"] = client_version
            __props__.__dict__["description"] = description
            __props__.__dict__["ingress"] = ingress
            __props__.__dict__["labels"] = labels
            __props__.__dict__["launch_stage"] = launch_stage
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if template is None and not opts.urn:
                raise TypeError("Missing required property 'template'")
            __props__.__dict__["template"] = template
            __props__.__dict__["traffics"] = traffics
            __props__.__dict__["conditions"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["generation"] = None
            __props__.__dict__["latest_created_revision"] = None
            __props__.__dict__["latest_ready_revision"] = None
            __props__.__dict__["observed_generation"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["terminal_conditions"] = None
            __props__.__dict__["traffic_statuses"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["uri"] = None
        super(Service, __self__).__init__(
            'gcp:cloudrunv2/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            binary_authorization: Optional[pulumi.Input[pulumi.InputType['ServiceBinaryAuthorizationArgs']]] = None,
            client: Optional[pulumi.Input[str]] = None,
            client_version: Optional[pulumi.Input[str]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceConditionArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            generation: Optional[pulumi.Input[str]] = None,
            ingress: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            latest_created_revision: Optional[pulumi.Input[str]] = None,
            latest_ready_revision: Optional[pulumi.Input[str]] = None,
            launch_stage: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            observed_generation: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            reconciling: Optional[pulumi.Input[bool]] = None,
            template: Optional[pulumi.Input[pulumi.InputType['ServiceTemplateArgs']]] = None,
            terminal_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTerminalConditionArgs']]]]] = None,
            traffic_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTrafficStatusArgs']]]]] = None,
            traffics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTrafficArgs']]]]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            uri: Optional[pulumi.Input[str]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServiceBinaryAuthorizationArgs']] binary_authorization: Settings for the Binary Authorization feature.
               Structure is documented below.
        :param pulumi.Input[str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceConditionArgs']]]] conditions: The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Service does not reach its Serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[str] description: User-provided description of the Service. This field currently has a 512-character limit.
        :param pulumi.Input[str] etag: A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        :param pulumi.Input[str] generation: A number that monotonically increases every time the user modifies the desired state. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        :param pulumi.Input[str] ingress: Provides the ingress settings for this Service. On output, returns the currently observed ingress settings, or INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
               Possible values are `INGRESS_TRAFFIC_ALL`, `INGRESS_TRAFFIC_INTERNAL_ONLY`, and `INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: KRM-style labels for the resource.
               (Optional)
               Map of string keys and values that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels Cloud Run will populate some labels with 'run.googleapis.com' or 'serving.knative.dev' namespaces. Those labels are read-only, and user changes will not be preserved.
        :param pulumi.Input[str] latest_created_revision: Name of the last created revision. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        :param pulumi.Input[str] latest_ready_revision: Name of the latest revision that is serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        :param pulumi.Input[str] launch_stage: The launch stage as defined by Google Cloud Platform Launch Stages. Cloud Run supports ALPHA, BETA, and GA. If no value is specified, GA is assumed.
               Possible values are `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, and `DEPRECATED`.
        :param pulumi.Input[str] location: The location of the cloud run service
        :param pulumi.Input[str] name: Name of the Service.
        :param pulumi.Input[str] observed_generation: The generation of this Service currently serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[bool] reconciling: Returns true if the Service is currently being acted upon by the system to bring it into the desired state.
               When a new Service is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Service to the desired serving state. This process is called reconciliation. While reconciliation is in process, observedGeneration, latest_ready_revison, trafficStatuses, and uri will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the serving state matches the Service, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
               If reconciliation succeeded, the following fields will match: traffic and trafficStatuses, observedGeneration and generation, latestReadyRevision and latestCreatedRevision.
               If reconciliation failed, trafficStatuses, observedGeneration, and latestReadyRevision will have the state of the last serving revision, or empty for newly created Services. Additional information on the failure can be found in terminalCondition and conditions.
        :param pulumi.Input[pulumi.InputType['ServiceTemplateArgs']] template: The template used to create revisions for this Service.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTerminalConditionArgs']]]] terminal_conditions: The Condition of this Service, containing its readiness status, and detailed error information in case it did not reach a serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTrafficStatusArgs']]]] traffic_statuses: Detailed status information for corresponding traffic targets. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTrafficArgs']]]] traffics: Specifies how to distribute traffic over a collection of Revisions belonging to the Service. If traffic is empty or not provided, defaults to 100% traffic to the latest Ready Revision.
               Structure is documented below.
        :param pulumi.Input[str] uid: Server assigned unique identifier for the trigger. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[str] uri: Displays the target URI.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["binary_authorization"] = binary_authorization
        __props__.__dict__["client"] = client
        __props__.__dict__["client_version"] = client_version
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["description"] = description
        __props__.__dict__["etag"] = etag
        __props__.__dict__["generation"] = generation
        __props__.__dict__["ingress"] = ingress
        __props__.__dict__["labels"] = labels
        __props__.__dict__["latest_created_revision"] = latest_created_revision
        __props__.__dict__["latest_ready_revision"] = latest_ready_revision
        __props__.__dict__["launch_stage"] = launch_stage
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["observed_generation"] = observed_generation
        __props__.__dict__["project"] = project
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["template"] = template
        __props__.__dict__["terminal_conditions"] = terminal_conditions
        __props__.__dict__["traffic_statuses"] = traffic_statuses
        __props__.__dict__["traffics"] = traffics
        __props__.__dict__["uid"] = uid
        __props__.__dict__["uri"] = uri
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> pulumi.Output[Optional['outputs.ServiceBinaryAuthorization']]:
        """
        Settings for the Binary Authorization feature.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @property
    @pulumi.getter
    def client(self) -> pulumi.Output[Optional[str]]:
        """
        Arbitrary identifier for the API client.
        """
        return pulumi.get(self, "client")

    @property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> pulumi.Output[Optional[str]]:
        """
        Arbitrary version identifier for the API client.
        """
        return pulumi.get(self, "client_version")

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.ServiceCondition']]:
        """
        The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the Service does not reach its Serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        User-provided description of the Service. This field currently has a 512-character limit.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def generation(self) -> pulumi.Output[str]:
        """
        A number that monotonically increases every time the user modifies the desired state. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def ingress(self) -> pulumi.Output[str]:
        """
        Provides the ingress settings for this Service. On output, returns the currently observed ingress settings, or INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
        Possible values are `INGRESS_TRAFFIC_ALL`, `INGRESS_TRAFFIC_INTERNAL_ONLY`, and `INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER`.
        """
        return pulumi.get(self, "ingress")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        KRM-style labels for the resource.
        (Optional)
        Map of string keys and values that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels Cloud Run will populate some labels with 'run.googleapis.com' or 'serving.knative.dev' namespaces. Those labels are read-only, and user changes will not be preserved.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="latestCreatedRevision")
    def latest_created_revision(self) -> pulumi.Output[str]:
        """
        Name of the last created revision. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "latest_created_revision")

    @property
    @pulumi.getter(name="latestReadyRevision")
    def latest_ready_revision(self) -> pulumi.Output[str]:
        """
        Name of the latest revision that is serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "latest_ready_revision")

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> pulumi.Output[str]:
        """
        The launch stage as defined by Google Cloud Platform Launch Stages. Cloud Run supports ALPHA, BETA, and GA. If no value is specified, GA is assumed.
        Possible values are `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, and `DEPRECATED`.
        """
        return pulumi.get(self, "launch_stage")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The location of the cloud run service
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the Service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> pulumi.Output[str]:
        """
        The generation of this Service currently serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[bool]:
        """
        Returns true if the Service is currently being acted upon by the system to bring it into the desired state.
        When a new Service is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the Service to the desired serving state. This process is called reconciliation. While reconciliation is in process, observedGeneration, latest_ready_revison, trafficStatuses, and uri will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the serving state matches the Service, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
        If reconciliation succeeded, the following fields will match: traffic and trafficStatuses, observedGeneration and generation, latestReadyRevision and latestCreatedRevision.
        If reconciliation failed, trafficStatuses, observedGeneration, and latestReadyRevision will have the state of the last serving revision, or empty for newly created Services. Additional information on the failure can be found in terminalCondition and conditions.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output['outputs.ServiceTemplate']:
        """
        The template used to create revisions for this Service.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="terminalConditions")
    def terminal_conditions(self) -> pulumi.Output[Sequence['outputs.ServiceTerminalCondition']]:
        """
        The Condition of this Service, containing its readiness status, and detailed error information in case it did not reach a serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "terminal_conditions")

    @property
    @pulumi.getter(name="trafficStatuses")
    def traffic_statuses(self) -> pulumi.Output[Sequence['outputs.ServiceTrafficStatus']]:
        """
        Detailed status information for corresponding traffic targets. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "traffic_statuses")

    @property
    @pulumi.getter
    def traffics(self) -> pulumi.Output[Sequence['outputs.ServiceTraffic']]:
        """
        Specifies how to distribute traffic over a collection of Revisions belonging to the Service. If traffic is empty or not provided, defaults to 100% traffic to the latest Ready Revision.
        Structure is documented below.
        """
        return pulumi.get(self, "traffics")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        Server assigned unique identifier for the trigger. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Output[str]:
        """
        Displays the target URI.
        """
        return pulumi.get(self, "uri")

