# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackendServiceArgs', 'BackendService']

@pulumi.input_type
class BackendServiceArgs:
    def __init__(__self__, *,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceBackendArgs']]]] = None,
                 cdn_policy: Optional[pulumi.Input['BackendServiceCdnPolicyArgs']] = None,
                 circuit_breakers: Optional[pulumi.Input['BackendServiceCircuitBreakersArgs']] = None,
                 compression_mode: Optional[pulumi.Input[str]] = None,
                 connection_draining_timeout_sec: Optional[pulumi.Input[int]] = None,
                 consistent_hash: Optional[pulumi.Input['BackendServiceConsistentHashArgs']] = None,
                 custom_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_cdn: Optional[pulumi.Input[bool]] = None,
                 health_checks: Optional[pulumi.Input[str]] = None,
                 iap: Optional[pulumi.Input['BackendServiceIapArgs']] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 locality_lb_policy: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input['BackendServiceLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outlier_detection: Optional[pulumi.Input['BackendServiceOutlierDetectionArgs']] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 security_settings: Optional[pulumi.Input['BackendServiceSecuritySettingsArgs']] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 timeout_sec: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a BackendService resource.
        :param pulumi.Input[int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds if session_affinity is
               GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
               only until the end of the browser session (or equivalent). The
               maximum allowed value for TTL is one day.
               When the load balancing scheme is INTERNAL, this field is not used.
        :param pulumi.Input[Sequence[pulumi.Input['BackendServiceBackendArgs']]] backends: The set of backends that serve this BackendService.
               Structure is documented below.
        :param pulumi.Input['BackendServiceCdnPolicyArgs'] cdn_policy: Cloud CDN configuration for this BackendService.
               Structure is documented below.
        :param pulumi.Input['BackendServiceCircuitBreakersArgs'] circuit_breakers: Settings controlling the volume of connections to a backend service. This field
               is applicable only when the load_balancing_scheme is set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[str] compression_mode: Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
               Possible values are `AUTOMATIC` and `DISABLED`.
        :param pulumi.Input[int] connection_draining_timeout_sec: Time for which instance will be drained (not accept new
               connections, but still work to finish started).
        :param pulumi.Input['BackendServiceConsistentHashArgs'] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session
               affinity based on HTTP headers, cookies or other properties. This load balancing
               policy is applicable only for HTTP connections. The affinity to a particular
               destination host will be lost when one or more hosts are added/removed from the
               destination service. This field specifies parameters that control consistent
               hashing. This field only applies if the load_balancing_scheme is set to
               INTERNAL_SELF_MANAGED. This field is only applicable when locality_lb_policy is
               set to MAGLEV or RING_HASH.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_request_headers: Headers that the HTTP/S load balancer should add to proxied
               requests.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_response_headers: Headers that the HTTP/S load balancer should add to proxied
               responses.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[bool] enable_cdn: If true, enable Cloud CDN for this BackendService.
        :param pulumi.Input[str] health_checks: The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource
               for health checking this BackendService. Currently at most one health
               check can be specified.
               A health check must be specified unless the backend service uses an internet
               or serverless NEG as a backend.
               For internal load balancing, a URL to a HealthCheck resource must be specified instead.
        :param pulumi.Input['BackendServiceIapArgs'] iap: Settings for enabling Cloud Identity Aware Proxy
               Structure is documented below.
        :param pulumi.Input[str] load_balancing_scheme: Indicates whether the backend service will be used with internal or
               external load balancing. A backend service created for one type of
               load balancing cannot be used with the other. For more information, refer to
               [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
               Default value is `EXTERNAL`.
               Possible values are `EXTERNAL`, `INTERNAL_SELF_MANAGED`, and `EXTERNAL_MANAGED`.
        :param pulumi.Input[str] locality_lb_policy: The load balancing algorithm used within the scope of the locality.
               The possible values are:
        :param pulumi.Input['BackendServiceLogConfigArgs'] log_config: This field denotes the logging options for the load balancer traffic served by this backend service.
               If logging is enabled, logs will be exported to Stackdriver.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input['BackendServiceOutlierDetectionArgs'] outlier_detection: Settings controlling eviction of unhealthy hosts from the load balancing pool.
               This field is applicable only when the load_balancing_scheme is set
               to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[str] port_name: Name of backend port. The same name should appear in the instance
               groups referenced by this service. Required when the load balancing
               scheme is EXTERNAL.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] protocol: The protocol this BackendService uses to communicate with backends.
               The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
               types and may result in errors if used with the GA API.
               Possible values are `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, and `GRPC`.
        :param pulumi.Input[str] security_policy: The security policy associated with this backend service.
        :param pulumi.Input['BackendServiceSecuritySettingsArgs'] security_settings: The security settings that apply to this backend service. This field is applicable to either
               a regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and
               load_balancing_scheme set to INTERNAL_MANAGED; or a global backend service with the
               load_balancing_scheme set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[str] session_affinity: Type of session affinity to use. The default is NONE. Session affinity is
               not applicable if the protocol is UDP.
               Possible values are `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, and `HTTP_COOKIE`.
        :param pulumi.Input[int] timeout_sec: How many seconds to wait for the backend before considering it a
               failed request. Default is 30 seconds. Valid range is [1, 86400].
        """
        if affinity_cookie_ttl_sec is not None:
            pulumi.set(__self__, "affinity_cookie_ttl_sec", affinity_cookie_ttl_sec)
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if cdn_policy is not None:
            pulumi.set(__self__, "cdn_policy", cdn_policy)
        if circuit_breakers is not None:
            pulumi.set(__self__, "circuit_breakers", circuit_breakers)
        if compression_mode is not None:
            pulumi.set(__self__, "compression_mode", compression_mode)
        if connection_draining_timeout_sec is not None:
            pulumi.set(__self__, "connection_draining_timeout_sec", connection_draining_timeout_sec)
        if consistent_hash is not None:
            pulumi.set(__self__, "consistent_hash", consistent_hash)
        if custom_request_headers is not None:
            pulumi.set(__self__, "custom_request_headers", custom_request_headers)
        if custom_response_headers is not None:
            pulumi.set(__self__, "custom_response_headers", custom_response_headers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_cdn is not None:
            pulumi.set(__self__, "enable_cdn", enable_cdn)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if iap is not None:
            pulumi.set(__self__, "iap", iap)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if locality_lb_policy is not None:
            pulumi.set(__self__, "locality_lb_policy", locality_lb_policy)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outlier_detection is not None:
            pulumi.set(__self__, "outlier_detection", outlier_detection)
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)
        if security_settings is not None:
            pulumi.set(__self__, "security_settings", security_settings)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if timeout_sec is not None:
            pulumi.set(__self__, "timeout_sec", timeout_sec)

    @property
    @pulumi.getter(name="affinityCookieTtlSec")
    def affinity_cookie_ttl_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Lifetime of cookies in seconds if session_affinity is
        GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
        only until the end of the browser session (or equivalent). The
        maximum allowed value for TTL is one day.
        When the load balancing scheme is INTERNAL, this field is not used.
        """
        return pulumi.get(self, "affinity_cookie_ttl_sec")

    @affinity_cookie_ttl_sec.setter
    def affinity_cookie_ttl_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "affinity_cookie_ttl_sec", value)

    @property
    @pulumi.getter
    def backends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceBackendArgs']]]]:
        """
        The set of backends that serve this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "backends")

    @backends.setter
    def backends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceBackendArgs']]]]):
        pulumi.set(self, "backends", value)

    @property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> Optional[pulumi.Input['BackendServiceCdnPolicyArgs']]:
        """
        Cloud CDN configuration for this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "cdn_policy")

    @cdn_policy.setter
    def cdn_policy(self, value: Optional[pulumi.Input['BackendServiceCdnPolicyArgs']]):
        pulumi.set(self, "cdn_policy", value)

    @property
    @pulumi.getter(name="circuitBreakers")
    def circuit_breakers(self) -> Optional[pulumi.Input['BackendServiceCircuitBreakersArgs']]:
        """
        Settings controlling the volume of connections to a backend service. This field
        is applicable only when the load_balancing_scheme is set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "circuit_breakers")

    @circuit_breakers.setter
    def circuit_breakers(self, value: Optional[pulumi.Input['BackendServiceCircuitBreakersArgs']]):
        pulumi.set(self, "circuit_breakers", value)

    @property
    @pulumi.getter(name="compressionMode")
    def compression_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
        Possible values are `AUTOMATIC` and `DISABLED`.
        """
        return pulumi.get(self, "compression_mode")

    @compression_mode.setter
    def compression_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_mode", value)

    @property
    @pulumi.getter(name="connectionDrainingTimeoutSec")
    def connection_draining_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Time for which instance will be drained (not accept new
        connections, but still work to finish started).
        """
        return pulumi.get(self, "connection_draining_timeout_sec")

    @connection_draining_timeout_sec.setter
    def connection_draining_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_draining_timeout_sec", value)

    @property
    @pulumi.getter(name="consistentHash")
    def consistent_hash(self) -> Optional[pulumi.Input['BackendServiceConsistentHashArgs']]:
        """
        Consistent Hash-based load balancing can be used to provide soft session
        affinity based on HTTP headers, cookies or other properties. This load balancing
        policy is applicable only for HTTP connections. The affinity to a particular
        destination host will be lost when one or more hosts are added/removed from the
        destination service. This field specifies parameters that control consistent
        hashing. This field only applies if the load_balancing_scheme is set to
        INTERNAL_SELF_MANAGED. This field is only applicable when locality_lb_policy is
        set to MAGLEV or RING_HASH.
        Structure is documented below.
        """
        return pulumi.get(self, "consistent_hash")

    @consistent_hash.setter
    def consistent_hash(self, value: Optional[pulumi.Input['BackendServiceConsistentHashArgs']]):
        pulumi.set(self, "consistent_hash", value)

    @property
    @pulumi.getter(name="customRequestHeaders")
    def custom_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Headers that the HTTP/S load balancer should add to proxied
        requests.
        """
        return pulumi.get(self, "custom_request_headers")

    @custom_request_headers.setter
    def custom_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_request_headers", value)

    @property
    @pulumi.getter(name="customResponseHeaders")
    def custom_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Headers that the HTTP/S load balancer should add to proxied
        responses.
        """
        return pulumi.get(self, "custom_response_headers")

    @custom_response_headers.setter
    def custom_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_response_headers", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableCdn")
    def enable_cdn(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, enable Cloud CDN for this BackendService.
        """
        return pulumi.get(self, "enable_cdn")

    @enable_cdn.setter
    def enable_cdn(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_cdn", value)

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[pulumi.Input[str]]:
        """
        The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource
        for health checking this BackendService. Currently at most one health
        check can be specified.
        A health check must be specified unless the backend service uses an internet
        or serverless NEG as a backend.
        For internal load balancing, a URL to a HealthCheck resource must be specified instead.
        """
        return pulumi.get(self, "health_checks")

    @health_checks.setter
    def health_checks(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_checks", value)

    @property
    @pulumi.getter
    def iap(self) -> Optional[pulumi.Input['BackendServiceIapArgs']]:
        """
        Settings for enabling Cloud Identity Aware Proxy
        Structure is documented below.
        """
        return pulumi.get(self, "iap")

    @iap.setter
    def iap(self, value: Optional[pulumi.Input['BackendServiceIapArgs']]):
        pulumi.set(self, "iap", value)

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether the backend service will be used with internal or
        external load balancing. A backend service created for one type of
        load balancing cannot be used with the other. For more information, refer to
        [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
        Default value is `EXTERNAL`.
        Possible values are `EXTERNAL`, `INTERNAL_SELF_MANAGED`, and `EXTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @property
    @pulumi.getter(name="localityLbPolicy")
    def locality_lb_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancing algorithm used within the scope of the locality.
        The possible values are:
        """
        return pulumi.get(self, "locality_lb_policy")

    @locality_lb_policy.setter
    def locality_lb_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locality_lb_policy", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['BackendServiceLogConfigArgs']]:
        """
        This field denotes the logging options for the load balancer traffic served by this backend service.
        If logging is enabled, logs will be exported to Stackdriver.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['BackendServiceLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outlierDetection")
    def outlier_detection(self) -> Optional[pulumi.Input['BackendServiceOutlierDetectionArgs']]:
        """
        Settings controlling eviction of unhealthy hosts from the load balancing pool.
        This field is applicable only when the load_balancing_scheme is set
        to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "outlier_detection")

    @outlier_detection.setter
    def outlier_detection(self, value: Optional[pulumi.Input['BackendServiceOutlierDetectionArgs']]):
        pulumi.set(self, "outlier_detection", value)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of backend port. The same name should appear in the instance
        groups referenced by this service. Required when the load balancing
        scheme is EXTERNAL.
        """
        return pulumi.get(self, "port_name")

    @port_name.setter
    def port_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol this BackendService uses to communicate with backends.
        The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
        types and may result in errors if used with the GA API.
        Possible values are `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, and `GRPC`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The security policy associated with this backend service.
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy", value)

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> Optional[pulumi.Input['BackendServiceSecuritySettingsArgs']]:
        """
        The security settings that apply to this backend service. This field is applicable to either
        a regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and
        load_balancing_scheme set to INTERNAL_MANAGED; or a global backend service with the
        load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "security_settings")

    @security_settings.setter
    def security_settings(self, value: Optional[pulumi.Input['BackendServiceSecuritySettingsArgs']]):
        pulumi.set(self, "security_settings", value)

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[str]]:
        """
        Type of session affinity to use. The default is NONE. Session affinity is
        not applicable if the protocol is UDP.
        Possible values are `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, and `HTTP_COOKIE`.
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_affinity", value)

    @property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        How many seconds to wait for the backend before considering it a
        failed request. Default is 30 seconds. Valid range is [1, 86400].
        """
        return pulumi.get(self, "timeout_sec")

    @timeout_sec.setter
    def timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_sec", value)


@pulumi.input_type
class _BackendServiceState:
    def __init__(__self__, *,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceBackendArgs']]]] = None,
                 cdn_policy: Optional[pulumi.Input['BackendServiceCdnPolicyArgs']] = None,
                 circuit_breakers: Optional[pulumi.Input['BackendServiceCircuitBreakersArgs']] = None,
                 compression_mode: Optional[pulumi.Input[str]] = None,
                 connection_draining_timeout_sec: Optional[pulumi.Input[int]] = None,
                 consistent_hash: Optional[pulumi.Input['BackendServiceConsistentHashArgs']] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 custom_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_cdn: Optional[pulumi.Input[bool]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 generated_id: Optional[pulumi.Input[int]] = None,
                 health_checks: Optional[pulumi.Input[str]] = None,
                 iap: Optional[pulumi.Input['BackendServiceIapArgs']] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 locality_lb_policy: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input['BackendServiceLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outlier_detection: Optional[pulumi.Input['BackendServiceOutlierDetectionArgs']] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 security_settings: Optional[pulumi.Input['BackendServiceSecuritySettingsArgs']] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 timeout_sec: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering BackendService resources.
        :param pulumi.Input[int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds if session_affinity is
               GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
               only until the end of the browser session (or equivalent). The
               maximum allowed value for TTL is one day.
               When the load balancing scheme is INTERNAL, this field is not used.
        :param pulumi.Input[Sequence[pulumi.Input['BackendServiceBackendArgs']]] backends: The set of backends that serve this BackendService.
               Structure is documented below.
        :param pulumi.Input['BackendServiceCdnPolicyArgs'] cdn_policy: Cloud CDN configuration for this BackendService.
               Structure is documented below.
        :param pulumi.Input['BackendServiceCircuitBreakersArgs'] circuit_breakers: Settings controlling the volume of connections to a backend service. This field
               is applicable only when the load_balancing_scheme is set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[str] compression_mode: Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
               Possible values are `AUTOMATIC` and `DISABLED`.
        :param pulumi.Input[int] connection_draining_timeout_sec: Time for which instance will be drained (not accept new
               connections, but still work to finish started).
        :param pulumi.Input['BackendServiceConsistentHashArgs'] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session
               affinity based on HTTP headers, cookies or other properties. This load balancing
               policy is applicable only for HTTP connections. The affinity to a particular
               destination host will be lost when one or more hosts are added/removed from the
               destination service. This field specifies parameters that control consistent
               hashing. This field only applies if the load_balancing_scheme is set to
               INTERNAL_SELF_MANAGED. This field is only applicable when locality_lb_policy is
               set to MAGLEV or RING_HASH.
               Structure is documented below.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_request_headers: Headers that the HTTP/S load balancer should add to proxied
               requests.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_response_headers: Headers that the HTTP/S load balancer should add to proxied
               responses.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[bool] enable_cdn: If true, enable Cloud CDN for this BackendService.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this
               object. This field is used in optimistic locking.
        :param pulumi.Input[int] generated_id: The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[str] health_checks: The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource
               for health checking this BackendService. Currently at most one health
               check can be specified.
               A health check must be specified unless the backend service uses an internet
               or serverless NEG as a backend.
               For internal load balancing, a URL to a HealthCheck resource must be specified instead.
        :param pulumi.Input['BackendServiceIapArgs'] iap: Settings for enabling Cloud Identity Aware Proxy
               Structure is documented below.
        :param pulumi.Input[str] load_balancing_scheme: Indicates whether the backend service will be used with internal or
               external load balancing. A backend service created for one type of
               load balancing cannot be used with the other. For more information, refer to
               [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
               Default value is `EXTERNAL`.
               Possible values are `EXTERNAL`, `INTERNAL_SELF_MANAGED`, and `EXTERNAL_MANAGED`.
        :param pulumi.Input[str] locality_lb_policy: The load balancing algorithm used within the scope of the locality.
               The possible values are:
        :param pulumi.Input['BackendServiceLogConfigArgs'] log_config: This field denotes the logging options for the load balancer traffic served by this backend service.
               If logging is enabled, logs will be exported to Stackdriver.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input['BackendServiceOutlierDetectionArgs'] outlier_detection: Settings controlling eviction of unhealthy hosts from the load balancing pool.
               This field is applicable only when the load_balancing_scheme is set
               to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[str] port_name: Name of backend port. The same name should appear in the instance
               groups referenced by this service. Required when the load balancing
               scheme is EXTERNAL.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] protocol: The protocol this BackendService uses to communicate with backends.
               The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
               types and may result in errors if used with the GA API.
               Possible values are `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, and `GRPC`.
        :param pulumi.Input[str] security_policy: The security policy associated with this backend service.
        :param pulumi.Input['BackendServiceSecuritySettingsArgs'] security_settings: The security settings that apply to this backend service. This field is applicable to either
               a regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and
               load_balancing_scheme set to INTERNAL_MANAGED; or a global backend service with the
               load_balancing_scheme set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] session_affinity: Type of session affinity to use. The default is NONE. Session affinity is
               not applicable if the protocol is UDP.
               Possible values are `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, and `HTTP_COOKIE`.
        :param pulumi.Input[int] timeout_sec: How many seconds to wait for the backend before considering it a
               failed request. Default is 30 seconds. Valid range is [1, 86400].
        """
        if affinity_cookie_ttl_sec is not None:
            pulumi.set(__self__, "affinity_cookie_ttl_sec", affinity_cookie_ttl_sec)
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if cdn_policy is not None:
            pulumi.set(__self__, "cdn_policy", cdn_policy)
        if circuit_breakers is not None:
            pulumi.set(__self__, "circuit_breakers", circuit_breakers)
        if compression_mode is not None:
            pulumi.set(__self__, "compression_mode", compression_mode)
        if connection_draining_timeout_sec is not None:
            pulumi.set(__self__, "connection_draining_timeout_sec", connection_draining_timeout_sec)
        if consistent_hash is not None:
            pulumi.set(__self__, "consistent_hash", consistent_hash)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if custom_request_headers is not None:
            pulumi.set(__self__, "custom_request_headers", custom_request_headers)
        if custom_response_headers is not None:
            pulumi.set(__self__, "custom_response_headers", custom_response_headers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_cdn is not None:
            pulumi.set(__self__, "enable_cdn", enable_cdn)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if generated_id is not None:
            pulumi.set(__self__, "generated_id", generated_id)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if iap is not None:
            pulumi.set(__self__, "iap", iap)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if locality_lb_policy is not None:
            pulumi.set(__self__, "locality_lb_policy", locality_lb_policy)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outlier_detection is not None:
            pulumi.set(__self__, "outlier_detection", outlier_detection)
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)
        if security_settings is not None:
            pulumi.set(__self__, "security_settings", security_settings)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if timeout_sec is not None:
            pulumi.set(__self__, "timeout_sec", timeout_sec)

    @property
    @pulumi.getter(name="affinityCookieTtlSec")
    def affinity_cookie_ttl_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Lifetime of cookies in seconds if session_affinity is
        GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
        only until the end of the browser session (or equivalent). The
        maximum allowed value for TTL is one day.
        When the load balancing scheme is INTERNAL, this field is not used.
        """
        return pulumi.get(self, "affinity_cookie_ttl_sec")

    @affinity_cookie_ttl_sec.setter
    def affinity_cookie_ttl_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "affinity_cookie_ttl_sec", value)

    @property
    @pulumi.getter
    def backends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceBackendArgs']]]]:
        """
        The set of backends that serve this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "backends")

    @backends.setter
    def backends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendServiceBackendArgs']]]]):
        pulumi.set(self, "backends", value)

    @property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> Optional[pulumi.Input['BackendServiceCdnPolicyArgs']]:
        """
        Cloud CDN configuration for this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "cdn_policy")

    @cdn_policy.setter
    def cdn_policy(self, value: Optional[pulumi.Input['BackendServiceCdnPolicyArgs']]):
        pulumi.set(self, "cdn_policy", value)

    @property
    @pulumi.getter(name="circuitBreakers")
    def circuit_breakers(self) -> Optional[pulumi.Input['BackendServiceCircuitBreakersArgs']]:
        """
        Settings controlling the volume of connections to a backend service. This field
        is applicable only when the load_balancing_scheme is set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "circuit_breakers")

    @circuit_breakers.setter
    def circuit_breakers(self, value: Optional[pulumi.Input['BackendServiceCircuitBreakersArgs']]):
        pulumi.set(self, "circuit_breakers", value)

    @property
    @pulumi.getter(name="compressionMode")
    def compression_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
        Possible values are `AUTOMATIC` and `DISABLED`.
        """
        return pulumi.get(self, "compression_mode")

    @compression_mode.setter
    def compression_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression_mode", value)

    @property
    @pulumi.getter(name="connectionDrainingTimeoutSec")
    def connection_draining_timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Time for which instance will be drained (not accept new
        connections, but still work to finish started).
        """
        return pulumi.get(self, "connection_draining_timeout_sec")

    @connection_draining_timeout_sec.setter
    def connection_draining_timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connection_draining_timeout_sec", value)

    @property
    @pulumi.getter(name="consistentHash")
    def consistent_hash(self) -> Optional[pulumi.Input['BackendServiceConsistentHashArgs']]:
        """
        Consistent Hash-based load balancing can be used to provide soft session
        affinity based on HTTP headers, cookies or other properties. This load balancing
        policy is applicable only for HTTP connections. The affinity to a particular
        destination host will be lost when one or more hosts are added/removed from the
        destination service. This field specifies parameters that control consistent
        hashing. This field only applies if the load_balancing_scheme is set to
        INTERNAL_SELF_MANAGED. This field is only applicable when locality_lb_policy is
        set to MAGLEV or RING_HASH.
        Structure is documented below.
        """
        return pulumi.get(self, "consistent_hash")

    @consistent_hash.setter
    def consistent_hash(self, value: Optional[pulumi.Input['BackendServiceConsistentHashArgs']]):
        pulumi.set(self, "consistent_hash", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter(name="customRequestHeaders")
    def custom_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Headers that the HTTP/S load balancer should add to proxied
        requests.
        """
        return pulumi.get(self, "custom_request_headers")

    @custom_request_headers.setter
    def custom_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_request_headers", value)

    @property
    @pulumi.getter(name="customResponseHeaders")
    def custom_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Headers that the HTTP/S load balancer should add to proxied
        responses.
        """
        return pulumi.get(self, "custom_response_headers")

    @custom_response_headers.setter
    def custom_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_response_headers", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableCdn")
    def enable_cdn(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, enable Cloud CDN for this BackendService.
        """
        return pulumi.get(self, "enable_cdn")

    @enable_cdn.setter
    def enable_cdn(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_cdn", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        Fingerprint of this resource. A hash of the contents stored in this
        object. This field is used in optimistic locking.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="generatedId")
    def generated_id(self) -> Optional[pulumi.Input[int]]:
        """
        The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "generated_id")

    @generated_id.setter
    def generated_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "generated_id", value)

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[pulumi.Input[str]]:
        """
        The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource
        for health checking this BackendService. Currently at most one health
        check can be specified.
        A health check must be specified unless the backend service uses an internet
        or serverless NEG as a backend.
        For internal load balancing, a URL to a HealthCheck resource must be specified instead.
        """
        return pulumi.get(self, "health_checks")

    @health_checks.setter
    def health_checks(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_checks", value)

    @property
    @pulumi.getter
    def iap(self) -> Optional[pulumi.Input['BackendServiceIapArgs']]:
        """
        Settings for enabling Cloud Identity Aware Proxy
        Structure is documented below.
        """
        return pulumi.get(self, "iap")

    @iap.setter
    def iap(self, value: Optional[pulumi.Input['BackendServiceIapArgs']]):
        pulumi.set(self, "iap", value)

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether the backend service will be used with internal or
        external load balancing. A backend service created for one type of
        load balancing cannot be used with the other. For more information, refer to
        [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
        Default value is `EXTERNAL`.
        Possible values are `EXTERNAL`, `INTERNAL_SELF_MANAGED`, and `EXTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @property
    @pulumi.getter(name="localityLbPolicy")
    def locality_lb_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancing algorithm used within the scope of the locality.
        The possible values are:
        """
        return pulumi.get(self, "locality_lb_policy")

    @locality_lb_policy.setter
    def locality_lb_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locality_lb_policy", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['BackendServiceLogConfigArgs']]:
        """
        This field denotes the logging options for the load balancer traffic served by this backend service.
        If logging is enabled, logs will be exported to Stackdriver.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['BackendServiceLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outlierDetection")
    def outlier_detection(self) -> Optional[pulumi.Input['BackendServiceOutlierDetectionArgs']]:
        """
        Settings controlling eviction of unhealthy hosts from the load balancing pool.
        This field is applicable only when the load_balancing_scheme is set
        to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "outlier_detection")

    @outlier_detection.setter
    def outlier_detection(self, value: Optional[pulumi.Input['BackendServiceOutlierDetectionArgs']]):
        pulumi.set(self, "outlier_detection", value)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of backend port. The same name should appear in the instance
        groups referenced by this service. Required when the load balancing
        scheme is EXTERNAL.
        """
        return pulumi.get(self, "port_name")

    @port_name.setter
    def port_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol this BackendService uses to communicate with backends.
        The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
        types and may result in errors if used with the GA API.
        Possible values are `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, and `GRPC`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The security policy associated with this backend service.
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy", value)

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> Optional[pulumi.Input['BackendServiceSecuritySettingsArgs']]:
        """
        The security settings that apply to this backend service. This field is applicable to either
        a regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and
        load_balancing_scheme set to INTERNAL_MANAGED; or a global backend service with the
        load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "security_settings")

    @security_settings.setter
    def security_settings(self, value: Optional[pulumi.Input['BackendServiceSecuritySettingsArgs']]):
        pulumi.set(self, "security_settings", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[str]]:
        """
        Type of session affinity to use. The default is NONE. Session affinity is
        not applicable if the protocol is UDP.
        Possible values are `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, and `HTTP_COOKIE`.
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_affinity", value)

    @property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        How many seconds to wait for the backend before considering it a
        failed request. Default is 30 seconds. Valid range is [1, 86400].
        """
        return pulumi.get(self, "timeout_sec")

    @timeout_sec.setter
    def timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_sec", value)


class BackendService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BackendServiceBackendArgs']]]]] = None,
                 cdn_policy: Optional[pulumi.Input[pulumi.InputType['BackendServiceCdnPolicyArgs']]] = None,
                 circuit_breakers: Optional[pulumi.Input[pulumi.InputType['BackendServiceCircuitBreakersArgs']]] = None,
                 compression_mode: Optional[pulumi.Input[str]] = None,
                 connection_draining_timeout_sec: Optional[pulumi.Input[int]] = None,
                 consistent_hash: Optional[pulumi.Input[pulumi.InputType['BackendServiceConsistentHashArgs']]] = None,
                 custom_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_cdn: Optional[pulumi.Input[bool]] = None,
                 health_checks: Optional[pulumi.Input[str]] = None,
                 iap: Optional[pulumi.Input[pulumi.InputType['BackendServiceIapArgs']]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 locality_lb_policy: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input[pulumi.InputType['BackendServiceLogConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outlier_detection: Optional[pulumi.Input[pulumi.InputType['BackendServiceOutlierDetectionArgs']]] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 security_settings: Optional[pulumi.Input[pulumi.InputType['BackendServiceSecuritySettingsArgs']]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 timeout_sec: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        A Backend Service defines a group of virtual machines that will serve
        traffic for load balancing. This resource is a global backend service,
        appropriate for external load balancing or self-managed internal load balancing.
        For managed internal load balancing, use a regional backend service instead.

        Currently self-managed internal load balancing is only available in beta.

        To get more information about BackendService, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/backendServices)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/load-balancing/http/backend-service)

        > **Warning:** All arguments including `iap.oauth2_client_secret` and `iap.oauth2_client_secret_sha256` will be stored in the raw
        state as plain-text.

        ## Example Usage
        ### Backend Service Cache Include Http Headers

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.BackendService("default",
            cdn_policy=gcp.compute.BackendServiceCdnPolicyArgs(
                cache_key_policy=gcp.compute.BackendServiceCdnPolicyCacheKeyPolicyArgs(
                    include_host=True,
                    include_http_headers=["X-My-Header-Field"],
                    include_protocol=True,
                    include_query_string=True,
                ),
                cache_mode="USE_ORIGIN_HEADERS",
            ),
            enable_cdn=True)
        ```
        ### Backend Service Cache Include Named Cookies

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.BackendService("default",
            cdn_policy=gcp.compute.BackendServiceCdnPolicyArgs(
                cache_key_policy=gcp.compute.BackendServiceCdnPolicyCacheKeyPolicyArgs(
                    include_host=True,
                    include_named_cookies=[
                        "__next_preview_data",
                        "__prerender_bypass",
                    ],
                    include_protocol=True,
                    include_query_string=True,
                ),
                cache_mode="CACHE_ALL_STATIC",
                client_ttl=7200,
                default_ttl=3600,
                max_ttl=10800,
            ),
            enable_cdn=True)
        ```
        ### Backend Service Network Endpoint

        ```python
        import pulumi
        import pulumi_gcp as gcp

        external_proxy = gcp.compute.GlobalNetworkEndpointGroup("externalProxy",
            network_endpoint_type="INTERNET_FQDN_PORT",
            default_port=443,
            opts=pulumi.ResourceOptions(provider=google_beta))
        proxy = gcp.compute.GlobalNetworkEndpoint("proxy",
            global_network_endpoint_group=external_proxy.id,
            fqdn="test.example.com",
            port=external_proxy.default_port,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default = gcp.compute.BackendService("default",
            enable_cdn=True,
            timeout_sec=10,
            connection_draining_timeout_sec=10,
            custom_request_headers=[proxy.fqdn.apply(lambda fqdn: f"host: {fqdn}")],
            custom_response_headers=["X-Cache-Hit: {cdn_cache_status}"],
            backends=[gcp.compute.BackendServiceBackendArgs(
                group=external_proxy.id,
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        BackendService can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/backendService:BackendService default projects/{{project}}/global/backendServices/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/backendService:BackendService default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/backendService:BackendService default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds if session_affinity is
               GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
               only until the end of the browser session (or equivalent). The
               maximum allowed value for TTL is one day.
               When the load balancing scheme is INTERNAL, this field is not used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BackendServiceBackendArgs']]]] backends: The set of backends that serve this BackendService.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['BackendServiceCdnPolicyArgs']] cdn_policy: Cloud CDN configuration for this BackendService.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['BackendServiceCircuitBreakersArgs']] circuit_breakers: Settings controlling the volume of connections to a backend service. This field
               is applicable only when the load_balancing_scheme is set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[str] compression_mode: Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
               Possible values are `AUTOMATIC` and `DISABLED`.
        :param pulumi.Input[int] connection_draining_timeout_sec: Time for which instance will be drained (not accept new
               connections, but still work to finish started).
        :param pulumi.Input[pulumi.InputType['BackendServiceConsistentHashArgs']] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session
               affinity based on HTTP headers, cookies or other properties. This load balancing
               policy is applicable only for HTTP connections. The affinity to a particular
               destination host will be lost when one or more hosts are added/removed from the
               destination service. This field specifies parameters that control consistent
               hashing. This field only applies if the load_balancing_scheme is set to
               INTERNAL_SELF_MANAGED. This field is only applicable when locality_lb_policy is
               set to MAGLEV or RING_HASH.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_request_headers: Headers that the HTTP/S load balancer should add to proxied
               requests.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_response_headers: Headers that the HTTP/S load balancer should add to proxied
               responses.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[bool] enable_cdn: If true, enable Cloud CDN for this BackendService.
        :param pulumi.Input[str] health_checks: The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource
               for health checking this BackendService. Currently at most one health
               check can be specified.
               A health check must be specified unless the backend service uses an internet
               or serverless NEG as a backend.
               For internal load balancing, a URL to a HealthCheck resource must be specified instead.
        :param pulumi.Input[pulumi.InputType['BackendServiceIapArgs']] iap: Settings for enabling Cloud Identity Aware Proxy
               Structure is documented below.
        :param pulumi.Input[str] load_balancing_scheme: Indicates whether the backend service will be used with internal or
               external load balancing. A backend service created for one type of
               load balancing cannot be used with the other. For more information, refer to
               [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
               Default value is `EXTERNAL`.
               Possible values are `EXTERNAL`, `INTERNAL_SELF_MANAGED`, and `EXTERNAL_MANAGED`.
        :param pulumi.Input[str] locality_lb_policy: The load balancing algorithm used within the scope of the locality.
               The possible values are:
        :param pulumi.Input[pulumi.InputType['BackendServiceLogConfigArgs']] log_config: This field denotes the logging options for the load balancer traffic served by this backend service.
               If logging is enabled, logs will be exported to Stackdriver.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[pulumi.InputType['BackendServiceOutlierDetectionArgs']] outlier_detection: Settings controlling eviction of unhealthy hosts from the load balancing pool.
               This field is applicable only when the load_balancing_scheme is set
               to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[str] port_name: Name of backend port. The same name should appear in the instance
               groups referenced by this service. Required when the load balancing
               scheme is EXTERNAL.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] protocol: The protocol this BackendService uses to communicate with backends.
               The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
               types and may result in errors if used with the GA API.
               Possible values are `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, and `GRPC`.
        :param pulumi.Input[str] security_policy: The security policy associated with this backend service.
        :param pulumi.Input[pulumi.InputType['BackendServiceSecuritySettingsArgs']] security_settings: The security settings that apply to this backend service. This field is applicable to either
               a regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and
               load_balancing_scheme set to INTERNAL_MANAGED; or a global backend service with the
               load_balancing_scheme set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[str] session_affinity: Type of session affinity to use. The default is NONE. Session affinity is
               not applicable if the protocol is UDP.
               Possible values are `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, and `HTTP_COOKIE`.
        :param pulumi.Input[int] timeout_sec: How many seconds to wait for the backend before considering it a
               failed request. Default is 30 seconds. Valid range is [1, 86400].
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BackendServiceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Backend Service defines a group of virtual machines that will serve
        traffic for load balancing. This resource is a global backend service,
        appropriate for external load balancing or self-managed internal load balancing.
        For managed internal load balancing, use a regional backend service instead.

        Currently self-managed internal load balancing is only available in beta.

        To get more information about BackendService, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/backendServices)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/load-balancing/http/backend-service)

        > **Warning:** All arguments including `iap.oauth2_client_secret` and `iap.oauth2_client_secret_sha256` will be stored in the raw
        state as plain-text.

        ## Example Usage
        ### Backend Service Cache Include Http Headers

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.BackendService("default",
            cdn_policy=gcp.compute.BackendServiceCdnPolicyArgs(
                cache_key_policy=gcp.compute.BackendServiceCdnPolicyCacheKeyPolicyArgs(
                    include_host=True,
                    include_http_headers=["X-My-Header-Field"],
                    include_protocol=True,
                    include_query_string=True,
                ),
                cache_mode="USE_ORIGIN_HEADERS",
            ),
            enable_cdn=True)
        ```
        ### Backend Service Cache Include Named Cookies

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.BackendService("default",
            cdn_policy=gcp.compute.BackendServiceCdnPolicyArgs(
                cache_key_policy=gcp.compute.BackendServiceCdnPolicyCacheKeyPolicyArgs(
                    include_host=True,
                    include_named_cookies=[
                        "__next_preview_data",
                        "__prerender_bypass",
                    ],
                    include_protocol=True,
                    include_query_string=True,
                ),
                cache_mode="CACHE_ALL_STATIC",
                client_ttl=7200,
                default_ttl=3600,
                max_ttl=10800,
            ),
            enable_cdn=True)
        ```
        ### Backend Service Network Endpoint

        ```python
        import pulumi
        import pulumi_gcp as gcp

        external_proxy = gcp.compute.GlobalNetworkEndpointGroup("externalProxy",
            network_endpoint_type="INTERNET_FQDN_PORT",
            default_port=443,
            opts=pulumi.ResourceOptions(provider=google_beta))
        proxy = gcp.compute.GlobalNetworkEndpoint("proxy",
            global_network_endpoint_group=external_proxy.id,
            fqdn="test.example.com",
            port=external_proxy.default_port,
            opts=pulumi.ResourceOptions(provider=google_beta))
        default = gcp.compute.BackendService("default",
            enable_cdn=True,
            timeout_sec=10,
            connection_draining_timeout_sec=10,
            custom_request_headers=[proxy.fqdn.apply(lambda fqdn: f"host: {fqdn}")],
            custom_response_headers=["X-Cache-Hit: {cdn_cache_status}"],
            backends=[gcp.compute.BackendServiceBackendArgs(
                group=external_proxy.id,
            )],
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```

        ## Import

        BackendService can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/backendService:BackendService default projects/{{project}}/global/backendServices/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/backendService:BackendService default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/backendService:BackendService default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param BackendServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackendServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BackendServiceBackendArgs']]]]] = None,
                 cdn_policy: Optional[pulumi.Input[pulumi.InputType['BackendServiceCdnPolicyArgs']]] = None,
                 circuit_breakers: Optional[pulumi.Input[pulumi.InputType['BackendServiceCircuitBreakersArgs']]] = None,
                 compression_mode: Optional[pulumi.Input[str]] = None,
                 connection_draining_timeout_sec: Optional[pulumi.Input[int]] = None,
                 consistent_hash: Optional[pulumi.Input[pulumi.InputType['BackendServiceConsistentHashArgs']]] = None,
                 custom_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_cdn: Optional[pulumi.Input[bool]] = None,
                 health_checks: Optional[pulumi.Input[str]] = None,
                 iap: Optional[pulumi.Input[pulumi.InputType['BackendServiceIapArgs']]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 locality_lb_policy: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input[pulumi.InputType['BackendServiceLogConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outlier_detection: Optional[pulumi.Input[pulumi.InputType['BackendServiceOutlierDetectionArgs']]] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 security_settings: Optional[pulumi.Input[pulumi.InputType['BackendServiceSecuritySettingsArgs']]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 timeout_sec: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackendServiceArgs.__new__(BackendServiceArgs)

            __props__.__dict__["affinity_cookie_ttl_sec"] = affinity_cookie_ttl_sec
            __props__.__dict__["backends"] = backends
            __props__.__dict__["cdn_policy"] = cdn_policy
            __props__.__dict__["circuit_breakers"] = circuit_breakers
            __props__.__dict__["compression_mode"] = compression_mode
            __props__.__dict__["connection_draining_timeout_sec"] = connection_draining_timeout_sec
            __props__.__dict__["consistent_hash"] = consistent_hash
            __props__.__dict__["custom_request_headers"] = custom_request_headers
            __props__.__dict__["custom_response_headers"] = custom_response_headers
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_cdn"] = enable_cdn
            __props__.__dict__["health_checks"] = health_checks
            __props__.__dict__["iap"] = iap
            __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
            __props__.__dict__["locality_lb_policy"] = locality_lb_policy
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["name"] = name
            __props__.__dict__["outlier_detection"] = outlier_detection
            __props__.__dict__["port_name"] = port_name
            __props__.__dict__["project"] = project
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["security_policy"] = security_policy
            __props__.__dict__["security_settings"] = security_settings
            __props__.__dict__["session_affinity"] = session_affinity
            __props__.__dict__["timeout_sec"] = timeout_sec
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["generated_id"] = None
            __props__.__dict__["self_link"] = None
        super(BackendService, __self__).__init__(
            'gcp:compute/backendService:BackendService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            affinity_cookie_ttl_sec: Optional[pulumi.Input[int]] = None,
            backends: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BackendServiceBackendArgs']]]]] = None,
            cdn_policy: Optional[pulumi.Input[pulumi.InputType['BackendServiceCdnPolicyArgs']]] = None,
            circuit_breakers: Optional[pulumi.Input[pulumi.InputType['BackendServiceCircuitBreakersArgs']]] = None,
            compression_mode: Optional[pulumi.Input[str]] = None,
            connection_draining_timeout_sec: Optional[pulumi.Input[int]] = None,
            consistent_hash: Optional[pulumi.Input[pulumi.InputType['BackendServiceConsistentHashArgs']]] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            custom_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            custom_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enable_cdn: Optional[pulumi.Input[bool]] = None,
            fingerprint: Optional[pulumi.Input[str]] = None,
            generated_id: Optional[pulumi.Input[int]] = None,
            health_checks: Optional[pulumi.Input[str]] = None,
            iap: Optional[pulumi.Input[pulumi.InputType['BackendServiceIapArgs']]] = None,
            load_balancing_scheme: Optional[pulumi.Input[str]] = None,
            locality_lb_policy: Optional[pulumi.Input[str]] = None,
            log_config: Optional[pulumi.Input[pulumi.InputType['BackendServiceLogConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            outlier_detection: Optional[pulumi.Input[pulumi.InputType['BackendServiceOutlierDetectionArgs']]] = None,
            port_name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            security_policy: Optional[pulumi.Input[str]] = None,
            security_settings: Optional[pulumi.Input[pulumi.InputType['BackendServiceSecuritySettingsArgs']]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            session_affinity: Optional[pulumi.Input[str]] = None,
            timeout_sec: Optional[pulumi.Input[int]] = None) -> 'BackendService':
        """
        Get an existing BackendService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds if session_affinity is
               GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
               only until the end of the browser session (or equivalent). The
               maximum allowed value for TTL is one day.
               When the load balancing scheme is INTERNAL, this field is not used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BackendServiceBackendArgs']]]] backends: The set of backends that serve this BackendService.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['BackendServiceCdnPolicyArgs']] cdn_policy: Cloud CDN configuration for this BackendService.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['BackendServiceCircuitBreakersArgs']] circuit_breakers: Settings controlling the volume of connections to a backend service. This field
               is applicable only when the load_balancing_scheme is set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[str] compression_mode: Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
               Possible values are `AUTOMATIC` and `DISABLED`.
        :param pulumi.Input[int] connection_draining_timeout_sec: Time for which instance will be drained (not accept new
               connections, but still work to finish started).
        :param pulumi.Input[pulumi.InputType['BackendServiceConsistentHashArgs']] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session
               affinity based on HTTP headers, cookies or other properties. This load balancing
               policy is applicable only for HTTP connections. The affinity to a particular
               destination host will be lost when one or more hosts are added/removed from the
               destination service. This field specifies parameters that control consistent
               hashing. This field only applies if the load_balancing_scheme is set to
               INTERNAL_SELF_MANAGED. This field is only applicable when locality_lb_policy is
               set to MAGLEV or RING_HASH.
               Structure is documented below.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_request_headers: Headers that the HTTP/S load balancer should add to proxied
               requests.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_response_headers: Headers that the HTTP/S load balancer should add to proxied
               responses.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[bool] enable_cdn: If true, enable Cloud CDN for this BackendService.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this
               object. This field is used in optimistic locking.
        :param pulumi.Input[int] generated_id: The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[str] health_checks: The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource
               for health checking this BackendService. Currently at most one health
               check can be specified.
               A health check must be specified unless the backend service uses an internet
               or serverless NEG as a backend.
               For internal load balancing, a URL to a HealthCheck resource must be specified instead.
        :param pulumi.Input[pulumi.InputType['BackendServiceIapArgs']] iap: Settings for enabling Cloud Identity Aware Proxy
               Structure is documented below.
        :param pulumi.Input[str] load_balancing_scheme: Indicates whether the backend service will be used with internal or
               external load balancing. A backend service created for one type of
               load balancing cannot be used with the other. For more information, refer to
               [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
               Default value is `EXTERNAL`.
               Possible values are `EXTERNAL`, `INTERNAL_SELF_MANAGED`, and `EXTERNAL_MANAGED`.
        :param pulumi.Input[str] locality_lb_policy: The load balancing algorithm used within the scope of the locality.
               The possible values are:
        :param pulumi.Input[pulumi.InputType['BackendServiceLogConfigArgs']] log_config: This field denotes the logging options for the load balancer traffic served by this backend service.
               If logging is enabled, logs will be exported to Stackdriver.
               Structure is documented below.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[pulumi.InputType['BackendServiceOutlierDetectionArgs']] outlier_detection: Settings controlling eviction of unhealthy hosts from the load balancing pool.
               This field is applicable only when the load_balancing_scheme is set
               to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[str] port_name: Name of backend port. The same name should appear in the instance
               groups referenced by this service. Required when the load balancing
               scheme is EXTERNAL.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] protocol: The protocol this BackendService uses to communicate with backends.
               The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
               types and may result in errors if used with the GA API.
               Possible values are `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, and `GRPC`.
        :param pulumi.Input[str] security_policy: The security policy associated with this backend service.
        :param pulumi.Input[pulumi.InputType['BackendServiceSecuritySettingsArgs']] security_settings: The security settings that apply to this backend service. This field is applicable to either
               a regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and
               load_balancing_scheme set to INTERNAL_MANAGED; or a global backend service with the
               load_balancing_scheme set to INTERNAL_SELF_MANAGED.
               Structure is documented below.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] session_affinity: Type of session affinity to use. The default is NONE. Session affinity is
               not applicable if the protocol is UDP.
               Possible values are `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, and `HTTP_COOKIE`.
        :param pulumi.Input[int] timeout_sec: How many seconds to wait for the backend before considering it a
               failed request. Default is 30 seconds. Valid range is [1, 86400].
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackendServiceState.__new__(_BackendServiceState)

        __props__.__dict__["affinity_cookie_ttl_sec"] = affinity_cookie_ttl_sec
        __props__.__dict__["backends"] = backends
        __props__.__dict__["cdn_policy"] = cdn_policy
        __props__.__dict__["circuit_breakers"] = circuit_breakers
        __props__.__dict__["compression_mode"] = compression_mode
        __props__.__dict__["connection_draining_timeout_sec"] = connection_draining_timeout_sec
        __props__.__dict__["consistent_hash"] = consistent_hash
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["custom_request_headers"] = custom_request_headers
        __props__.__dict__["custom_response_headers"] = custom_response_headers
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_cdn"] = enable_cdn
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["generated_id"] = generated_id
        __props__.__dict__["health_checks"] = health_checks
        __props__.__dict__["iap"] = iap
        __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
        __props__.__dict__["locality_lb_policy"] = locality_lb_policy
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["name"] = name
        __props__.__dict__["outlier_detection"] = outlier_detection
        __props__.__dict__["port_name"] = port_name
        __props__.__dict__["project"] = project
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["security_policy"] = security_policy
        __props__.__dict__["security_settings"] = security_settings
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["session_affinity"] = session_affinity
        __props__.__dict__["timeout_sec"] = timeout_sec
        return BackendService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="affinityCookieTtlSec")
    def affinity_cookie_ttl_sec(self) -> pulumi.Output[Optional[int]]:
        """
        Lifetime of cookies in seconds if session_affinity is
        GENERATED_COOKIE. If set to 0, the cookie is non-persistent and lasts
        only until the end of the browser session (or equivalent). The
        maximum allowed value for TTL is one day.
        When the load balancing scheme is INTERNAL, this field is not used.
        """
        return pulumi.get(self, "affinity_cookie_ttl_sec")

    @property
    @pulumi.getter
    def backends(self) -> pulumi.Output[Optional[Sequence['outputs.BackendServiceBackend']]]:
        """
        The set of backends that serve this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> pulumi.Output['outputs.BackendServiceCdnPolicy']:
        """
        Cloud CDN configuration for this BackendService.
        Structure is documented below.
        """
        return pulumi.get(self, "cdn_policy")

    @property
    @pulumi.getter(name="circuitBreakers")
    def circuit_breakers(self) -> pulumi.Output[Optional['outputs.BackendServiceCircuitBreakers']]:
        """
        Settings controlling the volume of connections to a backend service. This field
        is applicable only when the load_balancing_scheme is set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "circuit_breakers")

    @property
    @pulumi.getter(name="compressionMode")
    def compression_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
        Possible values are `AUTOMATIC` and `DISABLED`.
        """
        return pulumi.get(self, "compression_mode")

    @property
    @pulumi.getter(name="connectionDrainingTimeoutSec")
    def connection_draining_timeout_sec(self) -> pulumi.Output[Optional[int]]:
        """
        Time for which instance will be drained (not accept new
        connections, but still work to finish started).
        """
        return pulumi.get(self, "connection_draining_timeout_sec")

    @property
    @pulumi.getter(name="consistentHash")
    def consistent_hash(self) -> pulumi.Output[Optional['outputs.BackendServiceConsistentHash']]:
        """
        Consistent Hash-based load balancing can be used to provide soft session
        affinity based on HTTP headers, cookies or other properties. This load balancing
        policy is applicable only for HTTP connections. The affinity to a particular
        destination host will be lost when one or more hosts are added/removed from the
        destination service. This field specifies parameters that control consistent
        hashing. This field only applies if the load_balancing_scheme is set to
        INTERNAL_SELF_MANAGED. This field is only applicable when locality_lb_policy is
        set to MAGLEV or RING_HASH.
        Structure is documented below.
        """
        return pulumi.get(self, "consistent_hash")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="customRequestHeaders")
    def custom_request_headers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Headers that the HTTP/S load balancer should add to proxied
        requests.
        """
        return pulumi.get(self, "custom_request_headers")

    @property
    @pulumi.getter(name="customResponseHeaders")
    def custom_response_headers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Headers that the HTTP/S load balancer should add to proxied
        responses.
        """
        return pulumi.get(self, "custom_response_headers")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableCdn")
    def enable_cdn(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, enable Cloud CDN for this BackendService.
        """
        return pulumi.get(self, "enable_cdn")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[str]:
        """
        Fingerprint of this resource. A hash of the contents stored in this
        object. This field is used in optimistic locking.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="generatedId")
    def generated_id(self) -> pulumi.Output[int]:
        """
        The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "generated_id")

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> pulumi.Output[Optional[str]]:
        """
        The set of URLs to the HttpHealthCheck or HttpsHealthCheck resource
        for health checking this BackendService. Currently at most one health
        check can be specified.
        A health check must be specified unless the backend service uses an internet
        or serverless NEG as a backend.
        For internal load balancing, a URL to a HealthCheck resource must be specified instead.
        """
        return pulumi.get(self, "health_checks")

    @property
    @pulumi.getter
    def iap(self) -> pulumi.Output[Optional['outputs.BackendServiceIap']]:
        """
        Settings for enabling Cloud Identity Aware Proxy
        Structure is documented below.
        """
        return pulumi.get(self, "iap")

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates whether the backend service will be used with internal or
        external load balancing. A backend service created for one type of
        load balancing cannot be used with the other. For more information, refer to
        [Choosing a load balancer](https://cloud.google.com/load-balancing/docs/backend-service).
        Default value is `EXTERNAL`.
        Possible values are `EXTERNAL`, `INTERNAL_SELF_MANAGED`, and `EXTERNAL_MANAGED`.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @property
    @pulumi.getter(name="localityLbPolicy")
    def locality_lb_policy(self) -> pulumi.Output[Optional[str]]:
        """
        The load balancing algorithm used within the scope of the locality.
        The possible values are:
        """
        return pulumi.get(self, "locality_lb_policy")

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output['outputs.BackendServiceLogConfig']:
        """
        This field denotes the logging options for the load balancer traffic served by this backend service.
        If logging is enabled, logs will be exported to Stackdriver.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outlierDetection")
    def outlier_detection(self) -> pulumi.Output[Optional['outputs.BackendServiceOutlierDetection']]:
        """
        Settings controlling eviction of unhealthy hosts from the load balancing pool.
        This field is applicable only when the load_balancing_scheme is set
        to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "outlier_detection")

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> pulumi.Output[str]:
        """
        Name of backend port. The same name should appear in the instance
        groups referenced by this service. Required when the load balancing
        scheme is EXTERNAL.
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        The protocol this BackendService uses to communicate with backends.
        The default is HTTP. **NOTE**: HTTP2 is only valid for beta HTTP/2 load balancer
        types and may result in errors if used with the GA API.
        Possible values are `HTTP`, `HTTPS`, `HTTP2`, `TCP`, `SSL`, and `GRPC`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> pulumi.Output[Optional[str]]:
        """
        The security policy associated with this backend service.
        """
        return pulumi.get(self, "security_policy")

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> pulumi.Output[Optional['outputs.BackendServiceSecuritySettings']]:
        """
        The security settings that apply to this backend service. This field is applicable to either
        a regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and
        load_balancing_scheme set to INTERNAL_MANAGED; or a global backend service with the
        load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        Structure is documented below.
        """
        return pulumi.get(self, "security_settings")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> pulumi.Output[str]:
        """
        Type of session affinity to use. The default is NONE. Session affinity is
        not applicable if the protocol is UDP.
        Possible values are `NONE`, `CLIENT_IP`, `CLIENT_IP_PORT_PROTO`, `CLIENT_IP_PROTO`, `GENERATED_COOKIE`, `HEADER_FIELD`, and `HTTP_COOKIE`.
        """
        return pulumi.get(self, "session_affinity")

    @property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> pulumi.Output[int]:
        """
        How many seconds to wait for the backend before considering it a
        failed request. Default is 30 seconds. Valid range is [1, 86400].
        """
        return pulumi.get(self, "timeout_sec")

