# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouterPeerArgs', 'RouterPeer']

@pulumi.input_type
class RouterPeerArgs:
    def __init__(__self__, *,
                 interface: pulumi.Input[str],
                 peer_asn: pulumi.Input[int],
                 peer_ip_address: pulumi.Input[str],
                 router: pulumi.Input[str],
                 advertise_mode: Optional[pulumi.Input[str]] = None,
                 advertised_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 advertised_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerAdvertisedIpRangeArgs']]]] = None,
                 advertised_route_priority: Optional[pulumi.Input[int]] = None,
                 bfd: Optional[pulumi.Input['RouterPeerBfdArgs']] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router_appliance_instance: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RouterPeer resource.
        :param pulumi.Input[str] interface: Name of the interface the BGP peer is associated with.
        :param pulumi.Input[int] peer_asn: Peer BGP Autonomous System Number (ASN).
               Each BGP interface may use a different value.
        :param pulumi.Input[str] peer_ip_address: IP address of the BGP interface outside Google Cloud Platform.
               Only IPv4 is supported.
        :param pulumi.Input[str] router: The name of the Cloud Router in which this BgpPeer will be configured.
        :param pulumi.Input[str] advertise_mode: User-specified flag to indicate which mode to use for advertisement.
               Valid values of this enum field are: `DEFAULT`, `CUSTOM`
               Default value is `DEFAULT`.
               Possible values are `DEFAULT` and `CUSTOM`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] advertised_groups: User-specified list of prefix groups to advertise in custom
               mode, which can take one of the following options:
        :param pulumi.Input[Sequence[pulumi.Input['RouterPeerAdvertisedIpRangeArgs']]] advertised_ip_ranges: User-specified list of individual IP ranges to advertise in
               custom mode. This field can only be populated if advertiseMode
               is `CUSTOM` and is advertised to all peers of the router. These IP
               ranges will be advertised in addition to any specified groups.
               Leave this field blank to advertise no custom IP ranges.
               Structure is documented below.
        :param pulumi.Input[int] advertised_route_priority: The priority of routes advertised to this BGP peer.
               Where there is more than one matching route of maximum
               length, the routes with the lowest priority value win.
        :param pulumi.Input['RouterPeerBfdArgs'] bfd: BFD configuration for the BGP peering.
               Structure is documented below.
        :param pulumi.Input[bool] enable: The status of the BGP peer connection. If set to false, any active session
               with the peer is terminated and all associated routing information is removed.
               If set to true, the peer connection can be established with routing information.
               The default is true.
        :param pulumi.Input[str] ip_address: IP address of the interface inside Google Cloud Platform.
               Only IPv4 is supported.
        :param pulumi.Input[str] name: Name of this BGP peer. The name must be 1-63 characters long,
               and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region where the router and BgpPeer reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[str] router_appliance_instance: The URI of the VM instance that is used as third-party router appliances
               such as Next Gen Firewalls, Virtual Routers, or Router Appliances.
               The VM instance must be located in zones contained in the same region as
               this Cloud Router. The VM instance is the peer side of the BGP session.
        """
        pulumi.set(__self__, "interface", interface)
        pulumi.set(__self__, "peer_asn", peer_asn)
        pulumi.set(__self__, "peer_ip_address", peer_ip_address)
        pulumi.set(__self__, "router", router)
        if advertise_mode is not None:
            pulumi.set(__self__, "advertise_mode", advertise_mode)
        if advertised_groups is not None:
            pulumi.set(__self__, "advertised_groups", advertised_groups)
        if advertised_ip_ranges is not None:
            pulumi.set(__self__, "advertised_ip_ranges", advertised_ip_ranges)
        if advertised_route_priority is not None:
            pulumi.set(__self__, "advertised_route_priority", advertised_route_priority)
        if bfd is not None:
            pulumi.set(__self__, "bfd", bfd)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if router_appliance_instance is not None:
            pulumi.set(__self__, "router_appliance_instance", router_appliance_instance)

    @property
    @pulumi.getter
    def interface(self) -> pulumi.Input[str]:
        """
        Name of the interface the BGP peer is associated with.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: pulumi.Input[str]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> pulumi.Input[int]:
        """
        Peer BGP Autonomous System Number (ASN).
        Each BGP interface may use a different value.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: pulumi.Input[int]):
        pulumi.set(self, "peer_asn", value)

    @property
    @pulumi.getter(name="peerIpAddress")
    def peer_ip_address(self) -> pulumi.Input[str]:
        """
        IP address of the BGP interface outside Google Cloud Platform.
        Only IPv4 is supported.
        """
        return pulumi.get(self, "peer_ip_address")

    @peer_ip_address.setter
    def peer_ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_ip_address", value)

    @property
    @pulumi.getter
    def router(self) -> pulumi.Input[str]:
        """
        The name of the Cloud Router in which this BgpPeer will be configured.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: pulumi.Input[str]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter(name="advertiseMode")
    def advertise_mode(self) -> Optional[pulumi.Input[str]]:
        """
        User-specified flag to indicate which mode to use for advertisement.
        Valid values of this enum field are: `DEFAULT`, `CUSTOM`
        Default value is `DEFAULT`.
        Possible values are `DEFAULT` and `CUSTOM`.
        """
        return pulumi.get(self, "advertise_mode")

    @advertise_mode.setter
    def advertise_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "advertise_mode", value)

    @property
    @pulumi.getter(name="advertisedGroups")
    def advertised_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        User-specified list of prefix groups to advertise in custom
        mode, which can take one of the following options:
        """
        return pulumi.get(self, "advertised_groups")

    @advertised_groups.setter
    def advertised_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "advertised_groups", value)

    @property
    @pulumi.getter(name="advertisedIpRanges")
    def advertised_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerAdvertisedIpRangeArgs']]]]:
        """
        User-specified list of individual IP ranges to advertise in
        custom mode. This field can only be populated if advertiseMode
        is `CUSTOM` and is advertised to all peers of the router. These IP
        ranges will be advertised in addition to any specified groups.
        Leave this field blank to advertise no custom IP ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "advertised_ip_ranges")

    @advertised_ip_ranges.setter
    def advertised_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerAdvertisedIpRangeArgs']]]]):
        pulumi.set(self, "advertised_ip_ranges", value)

    @property
    @pulumi.getter(name="advertisedRoutePriority")
    def advertised_route_priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of routes advertised to this BGP peer.
        Where there is more than one matching route of maximum
        length, the routes with the lowest priority value win.
        """
        return pulumi.get(self, "advertised_route_priority")

    @advertised_route_priority.setter
    def advertised_route_priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "advertised_route_priority", value)

    @property
    @pulumi.getter
    def bfd(self) -> Optional[pulumi.Input['RouterPeerBfdArgs']]:
        """
        BFD configuration for the BGP peering.
        Structure is documented below.
        """
        return pulumi.get(self, "bfd")

    @bfd.setter
    def bfd(self, value: Optional[pulumi.Input['RouterPeerBfdArgs']]):
        pulumi.set(self, "bfd", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        The status of the BGP peer connection. If set to false, any active session
        with the peer is terminated and all associated routing information is removed.
        If set to true, the peer connection can be established with routing information.
        The default is true.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of the interface inside Google Cloud Platform.
        Only IPv4 is supported.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of this BGP peer. The name must be 1-63 characters long,
        and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which
        means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region where the router and BgpPeer reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routerApplianceInstance")
    def router_appliance_instance(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the VM instance that is used as third-party router appliances
        such as Next Gen Firewalls, Virtual Routers, or Router Appliances.
        The VM instance must be located in zones contained in the same region as
        this Cloud Router. The VM instance is the peer side of the BGP session.
        """
        return pulumi.get(self, "router_appliance_instance")

    @router_appliance_instance.setter
    def router_appliance_instance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "router_appliance_instance", value)


@pulumi.input_type
class _RouterPeerState:
    def __init__(__self__, *,
                 advertise_mode: Optional[pulumi.Input[str]] = None,
                 advertised_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 advertised_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerAdvertisedIpRangeArgs']]]] = None,
                 advertised_route_priority: Optional[pulumi.Input[int]] = None,
                 bfd: Optional[pulumi.Input['RouterPeerBfdArgs']] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 interface: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 management_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peer_asn: Optional[pulumi.Input[int]] = None,
                 peer_ip_address: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 router_appliance_instance: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RouterPeer resources.
        :param pulumi.Input[str] advertise_mode: User-specified flag to indicate which mode to use for advertisement.
               Valid values of this enum field are: `DEFAULT`, `CUSTOM`
               Default value is `DEFAULT`.
               Possible values are `DEFAULT` and `CUSTOM`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] advertised_groups: User-specified list of prefix groups to advertise in custom
               mode, which can take one of the following options:
        :param pulumi.Input[Sequence[pulumi.Input['RouterPeerAdvertisedIpRangeArgs']]] advertised_ip_ranges: User-specified list of individual IP ranges to advertise in
               custom mode. This field can only be populated if advertiseMode
               is `CUSTOM` and is advertised to all peers of the router. These IP
               ranges will be advertised in addition to any specified groups.
               Leave this field blank to advertise no custom IP ranges.
               Structure is documented below.
        :param pulumi.Input[int] advertised_route_priority: The priority of routes advertised to this BGP peer.
               Where there is more than one matching route of maximum
               length, the routes with the lowest priority value win.
        :param pulumi.Input['RouterPeerBfdArgs'] bfd: BFD configuration for the BGP peering.
               Structure is documented below.
        :param pulumi.Input[bool] enable: The status of the BGP peer connection. If set to false, any active session
               with the peer is terminated and all associated routing information is removed.
               If set to true, the peer connection can be established with routing information.
               The default is true.
        :param pulumi.Input[str] interface: Name of the interface the BGP peer is associated with.
        :param pulumi.Input[str] ip_address: IP address of the interface inside Google Cloud Platform.
               Only IPv4 is supported.
        :param pulumi.Input[str] management_type: The resource that configures and manages this BGP peer.
        :param pulumi.Input[str] name: Name of this BGP peer. The name must be 1-63 characters long,
               and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[int] peer_asn: Peer BGP Autonomous System Number (ASN).
               Each BGP interface may use a different value.
        :param pulumi.Input[str] peer_ip_address: IP address of the BGP interface outside Google Cloud Platform.
               Only IPv4 is supported.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region where the router and BgpPeer reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[str] router: The name of the Cloud Router in which this BgpPeer will be configured.
        :param pulumi.Input[str] router_appliance_instance: The URI of the VM instance that is used as third-party router appliances
               such as Next Gen Firewalls, Virtual Routers, or Router Appliances.
               The VM instance must be located in zones contained in the same region as
               this Cloud Router. The VM instance is the peer side of the BGP session.
        """
        if advertise_mode is not None:
            pulumi.set(__self__, "advertise_mode", advertise_mode)
        if advertised_groups is not None:
            pulumi.set(__self__, "advertised_groups", advertised_groups)
        if advertised_ip_ranges is not None:
            pulumi.set(__self__, "advertised_ip_ranges", advertised_ip_ranges)
        if advertised_route_priority is not None:
            pulumi.set(__self__, "advertised_route_priority", advertised_route_priority)
        if bfd is not None:
            pulumi.set(__self__, "bfd", bfd)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if management_type is not None:
            pulumi.set(__self__, "management_type", management_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peer_ip_address is not None:
            pulumi.set(__self__, "peer_ip_address", peer_ip_address)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if router is not None:
            pulumi.set(__self__, "router", router)
        if router_appliance_instance is not None:
            pulumi.set(__self__, "router_appliance_instance", router_appliance_instance)

    @property
    @pulumi.getter(name="advertiseMode")
    def advertise_mode(self) -> Optional[pulumi.Input[str]]:
        """
        User-specified flag to indicate which mode to use for advertisement.
        Valid values of this enum field are: `DEFAULT`, `CUSTOM`
        Default value is `DEFAULT`.
        Possible values are `DEFAULT` and `CUSTOM`.
        """
        return pulumi.get(self, "advertise_mode")

    @advertise_mode.setter
    def advertise_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "advertise_mode", value)

    @property
    @pulumi.getter(name="advertisedGroups")
    def advertised_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        User-specified list of prefix groups to advertise in custom
        mode, which can take one of the following options:
        """
        return pulumi.get(self, "advertised_groups")

    @advertised_groups.setter
    def advertised_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "advertised_groups", value)

    @property
    @pulumi.getter(name="advertisedIpRanges")
    def advertised_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerAdvertisedIpRangeArgs']]]]:
        """
        User-specified list of individual IP ranges to advertise in
        custom mode. This field can only be populated if advertiseMode
        is `CUSTOM` and is advertised to all peers of the router. These IP
        ranges will be advertised in addition to any specified groups.
        Leave this field blank to advertise no custom IP ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "advertised_ip_ranges")

    @advertised_ip_ranges.setter
    def advertised_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterPeerAdvertisedIpRangeArgs']]]]):
        pulumi.set(self, "advertised_ip_ranges", value)

    @property
    @pulumi.getter(name="advertisedRoutePriority")
    def advertised_route_priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of routes advertised to this BGP peer.
        Where there is more than one matching route of maximum
        length, the routes with the lowest priority value win.
        """
        return pulumi.get(self, "advertised_route_priority")

    @advertised_route_priority.setter
    def advertised_route_priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "advertised_route_priority", value)

    @property
    @pulumi.getter
    def bfd(self) -> Optional[pulumi.Input['RouterPeerBfdArgs']]:
        """
        BFD configuration for the BGP peering.
        Structure is documented below.
        """
        return pulumi.get(self, "bfd")

    @bfd.setter
    def bfd(self, value: Optional[pulumi.Input['RouterPeerBfdArgs']]):
        pulumi.set(self, "bfd", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        The status of the BGP peer connection. If set to false, any active session
        with the peer is terminated and all associated routing information is removed.
        If set to true, the peer connection can be established with routing information.
        The default is true.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the interface the BGP peer is associated with.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of the interface inside Google Cloud Platform.
        Only IPv4 is supported.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="managementType")
    def management_type(self) -> Optional[pulumi.Input[str]]:
        """
        The resource that configures and manages this BGP peer.
        """
        return pulumi.get(self, "management_type")

    @management_type.setter
    def management_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of this BGP peer. The name must be 1-63 characters long,
        and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which
        means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[pulumi.Input[int]]:
        """
        Peer BGP Autonomous System Number (ASN).
        Each BGP interface may use a different value.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "peer_asn", value)

    @property
    @pulumi.getter(name="peerIpAddress")
    def peer_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of the BGP interface outside Google Cloud Platform.
        Only IPv4 is supported.
        """
        return pulumi.get(self, "peer_ip_address")

    @peer_ip_address.setter
    def peer_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_ip_address", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region where the router and BgpPeer reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def router(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Cloud Router in which this BgpPeer will be configured.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter(name="routerApplianceInstance")
    def router_appliance_instance(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the VM instance that is used as third-party router appliances
        such as Next Gen Firewalls, Virtual Routers, or Router Appliances.
        The VM instance must be located in zones contained in the same region as
        this Cloud Router. The VM instance is the peer side of the BGP session.
        """
        return pulumi.get(self, "router_appliance_instance")

    @router_appliance_instance.setter
    def router_appliance_instance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "router_appliance_instance", value)


class RouterPeer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advertise_mode: Optional[pulumi.Input[str]] = None,
                 advertised_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 advertised_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterPeerAdvertisedIpRangeArgs']]]]] = None,
                 advertised_route_priority: Optional[pulumi.Input[int]] = None,
                 bfd: Optional[pulumi.Input[pulumi.InputType['RouterPeerBfdArgs']]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 interface: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peer_asn: Optional[pulumi.Input[int]] = None,
                 peer_ip_address: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 router_appliance_instance: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        BGP information that must be configured into the routing stack to
        establish BGP peering. This information must specify the peer ASN
        and either the interface name, IP address, or peer IP address.
        Please refer to RFC4273.

        To get more information about RouterBgpPeer, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/routers)
        * How-to Guides
            * [Google Cloud Router](https://cloud.google.com/router/docs/)

        ## Example Usage
        ### Router Peer Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        peer = gcp.compute.RouterPeer("peer",
            advertised_route_priority=100,
            interface="interface-1",
            peer_asn=65513,
            peer_ip_address="169.254.1.2",
            region="us-central1",
            router="my-router")
        ```
        ### Router Peer Disabled

        ```python
        import pulumi
        import pulumi_gcp as gcp

        peer = gcp.compute.RouterPeer("peer",
            advertised_route_priority=100,
            enable=False,
            interface="interface-1",
            peer_asn=65513,
            peer_ip_address="169.254.1.2",
            region="us-central1",
            router="my-router")
        ```
        ### Router Peer Bfd

        ```python
        import pulumi
        import pulumi_gcp as gcp

        peer = gcp.compute.RouterPeer("peer",
            advertised_route_priority=100,
            bfd=gcp.compute.RouterPeerBfdArgs(
                min_receive_interval=1000,
                min_transmit_interval=1000,
                multiplier=5,
                session_initialization_mode="ACTIVE",
            ),
            interface="interface-1",
            peer_asn=65513,
            peer_ip_address="169.254.1.2",
            region="us-central1",
            router="my-router")
        ```
        ### Router Peer Router Appliance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network", auto_create_subnetworks=False)
        subnetwork = gcp.compute.Subnetwork("subnetwork",
            network=network.self_link,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        addr_intf = gcp.compute.Address("addrIntf",
            region=subnetwork.region,
            subnetwork=subnetwork.id,
            address_type="INTERNAL")
        addr_intf_redundant = gcp.compute.Address("addrIntfRedundant",
            region=subnetwork.region,
            subnetwork=subnetwork.id,
            address_type="INTERNAL")
        addr_peer = gcp.compute.Address("addrPeer",
            region=subnetwork.region,
            subnetwork=subnetwork.id,
            address_type="INTERNAL")
        instance = gcp.compute.Instance("instance",
            zone="us-central1-a",
            machine_type="e2-medium",
            can_ip_forward=True,
            boot_disk=gcp.compute.InstanceBootDiskArgs(
                initialize_params=gcp.compute.InstanceBootDiskInitializeParamsArgs(
                    image="debian-cloud/debian-11",
                ),
            ),
            network_interfaces=[gcp.compute.InstanceNetworkInterfaceArgs(
                network_ip=addr_peer.address,
                subnetwork=subnetwork.self_link,
            )])
        hub = gcp.networkconnectivity.Hub("hub")
        spoke = gcp.networkconnectivity.Spoke("spoke",
            location=subnetwork.region,
            hub=hub.id,
            linked_router_appliance_instances=gcp.networkconnectivity.SpokeLinkedRouterApplianceInstancesArgs(
                instances=[gcp.networkconnectivity.SpokeLinkedRouterApplianceInstancesInstanceArgs(
                    virtual_machine=instance.self_link,
                    ip_address=addr_peer.address,
                )],
                site_to_site_data_transfer=False,
            ))
        router = gcp.compute.Router("router",
            region=subnetwork.region,
            network=network.self_link,
            bgp=gcp.compute.RouterBgpArgs(
                asn=64514,
            ))
        interface_redundant = gcp.compute.RouterInterface("interfaceRedundant",
            region=router.region,
            router=router.name,
            subnetwork=subnetwork.self_link,
            private_ip_address=addr_intf_redundant.address)
        interface = gcp.compute.RouterInterface("interface",
            region=router.region,
            router=router.name,
            subnetwork=subnetwork.self_link,
            private_ip_address=addr_intf.address,
            redundant_interface=interface_redundant.name)
        peer = gcp.compute.RouterPeer("peer",
            router=router.name,
            region=router.region,
            interface=interface.name,
            router_appliance_instance=instance.self_link,
            peer_asn=65513,
            peer_ip_address=addr_peer.address)
        ```

        ## Import

        RouterBgpPeer can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/routerPeer:RouterPeer default projects/{{project}}/regions/{{region}}/routers/{{router}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/routerPeer:RouterPeer default {{project}}/{{region}}/{{router}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/routerPeer:RouterPeer default {{region}}/{{router}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/routerPeer:RouterPeer default {{router}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] advertise_mode: User-specified flag to indicate which mode to use for advertisement.
               Valid values of this enum field are: `DEFAULT`, `CUSTOM`
               Default value is `DEFAULT`.
               Possible values are `DEFAULT` and `CUSTOM`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] advertised_groups: User-specified list of prefix groups to advertise in custom
               mode, which can take one of the following options:
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterPeerAdvertisedIpRangeArgs']]]] advertised_ip_ranges: User-specified list of individual IP ranges to advertise in
               custom mode. This field can only be populated if advertiseMode
               is `CUSTOM` and is advertised to all peers of the router. These IP
               ranges will be advertised in addition to any specified groups.
               Leave this field blank to advertise no custom IP ranges.
               Structure is documented below.
        :param pulumi.Input[int] advertised_route_priority: The priority of routes advertised to this BGP peer.
               Where there is more than one matching route of maximum
               length, the routes with the lowest priority value win.
        :param pulumi.Input[pulumi.InputType['RouterPeerBfdArgs']] bfd: BFD configuration for the BGP peering.
               Structure is documented below.
        :param pulumi.Input[bool] enable: The status of the BGP peer connection. If set to false, any active session
               with the peer is terminated and all associated routing information is removed.
               If set to true, the peer connection can be established with routing information.
               The default is true.
        :param pulumi.Input[str] interface: Name of the interface the BGP peer is associated with.
        :param pulumi.Input[str] ip_address: IP address of the interface inside Google Cloud Platform.
               Only IPv4 is supported.
        :param pulumi.Input[str] name: Name of this BGP peer. The name must be 1-63 characters long,
               and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[int] peer_asn: Peer BGP Autonomous System Number (ASN).
               Each BGP interface may use a different value.
        :param pulumi.Input[str] peer_ip_address: IP address of the BGP interface outside Google Cloud Platform.
               Only IPv4 is supported.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region where the router and BgpPeer reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[str] router: The name of the Cloud Router in which this BgpPeer will be configured.
        :param pulumi.Input[str] router_appliance_instance: The URI of the VM instance that is used as third-party router appliances
               such as Next Gen Firewalls, Virtual Routers, or Router Appliances.
               The VM instance must be located in zones contained in the same region as
               this Cloud Router. The VM instance is the peer side of the BGP session.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouterPeerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        BGP information that must be configured into the routing stack to
        establish BGP peering. This information must specify the peer ASN
        and either the interface name, IP address, or peer IP address.
        Please refer to RFC4273.

        To get more information about RouterBgpPeer, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/routers)
        * How-to Guides
            * [Google Cloud Router](https://cloud.google.com/router/docs/)

        ## Example Usage
        ### Router Peer Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        peer = gcp.compute.RouterPeer("peer",
            advertised_route_priority=100,
            interface="interface-1",
            peer_asn=65513,
            peer_ip_address="169.254.1.2",
            region="us-central1",
            router="my-router")
        ```
        ### Router Peer Disabled

        ```python
        import pulumi
        import pulumi_gcp as gcp

        peer = gcp.compute.RouterPeer("peer",
            advertised_route_priority=100,
            enable=False,
            interface="interface-1",
            peer_asn=65513,
            peer_ip_address="169.254.1.2",
            region="us-central1",
            router="my-router")
        ```
        ### Router Peer Bfd

        ```python
        import pulumi
        import pulumi_gcp as gcp

        peer = gcp.compute.RouterPeer("peer",
            advertised_route_priority=100,
            bfd=gcp.compute.RouterPeerBfdArgs(
                min_receive_interval=1000,
                min_transmit_interval=1000,
                multiplier=5,
                session_initialization_mode="ACTIVE",
            ),
            interface="interface-1",
            peer_asn=65513,
            peer_ip_address="169.254.1.2",
            region="us-central1",
            router="my-router")
        ```
        ### Router Peer Router Appliance

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network", auto_create_subnetworks=False)
        subnetwork = gcp.compute.Subnetwork("subnetwork",
            network=network.self_link,
            ip_cidr_range="10.0.0.0/16",
            region="us-central1")
        addr_intf = gcp.compute.Address("addrIntf",
            region=subnetwork.region,
            subnetwork=subnetwork.id,
            address_type="INTERNAL")
        addr_intf_redundant = gcp.compute.Address("addrIntfRedundant",
            region=subnetwork.region,
            subnetwork=subnetwork.id,
            address_type="INTERNAL")
        addr_peer = gcp.compute.Address("addrPeer",
            region=subnetwork.region,
            subnetwork=subnetwork.id,
            address_type="INTERNAL")
        instance = gcp.compute.Instance("instance",
            zone="us-central1-a",
            machine_type="e2-medium",
            can_ip_forward=True,
            boot_disk=gcp.compute.InstanceBootDiskArgs(
                initialize_params=gcp.compute.InstanceBootDiskInitializeParamsArgs(
                    image="debian-cloud/debian-11",
                ),
            ),
            network_interfaces=[gcp.compute.InstanceNetworkInterfaceArgs(
                network_ip=addr_peer.address,
                subnetwork=subnetwork.self_link,
            )])
        hub = gcp.networkconnectivity.Hub("hub")
        spoke = gcp.networkconnectivity.Spoke("spoke",
            location=subnetwork.region,
            hub=hub.id,
            linked_router_appliance_instances=gcp.networkconnectivity.SpokeLinkedRouterApplianceInstancesArgs(
                instances=[gcp.networkconnectivity.SpokeLinkedRouterApplianceInstancesInstanceArgs(
                    virtual_machine=instance.self_link,
                    ip_address=addr_peer.address,
                )],
                site_to_site_data_transfer=False,
            ))
        router = gcp.compute.Router("router",
            region=subnetwork.region,
            network=network.self_link,
            bgp=gcp.compute.RouterBgpArgs(
                asn=64514,
            ))
        interface_redundant = gcp.compute.RouterInterface("interfaceRedundant",
            region=router.region,
            router=router.name,
            subnetwork=subnetwork.self_link,
            private_ip_address=addr_intf_redundant.address)
        interface = gcp.compute.RouterInterface("interface",
            region=router.region,
            router=router.name,
            subnetwork=subnetwork.self_link,
            private_ip_address=addr_intf.address,
            redundant_interface=interface_redundant.name)
        peer = gcp.compute.RouterPeer("peer",
            router=router.name,
            region=router.region,
            interface=interface.name,
            router_appliance_instance=instance.self_link,
            peer_asn=65513,
            peer_ip_address=addr_peer.address)
        ```

        ## Import

        RouterBgpPeer can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/routerPeer:RouterPeer default projects/{{project}}/regions/{{region}}/routers/{{router}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/routerPeer:RouterPeer default {{project}}/{{region}}/{{router}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/routerPeer:RouterPeer default {{region}}/{{router}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/routerPeer:RouterPeer default {{router}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RouterPeerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouterPeerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advertise_mode: Optional[pulumi.Input[str]] = None,
                 advertised_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 advertised_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterPeerAdvertisedIpRangeArgs']]]]] = None,
                 advertised_route_priority: Optional[pulumi.Input[int]] = None,
                 bfd: Optional[pulumi.Input[pulumi.InputType['RouterPeerBfdArgs']]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 interface: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peer_asn: Optional[pulumi.Input[int]] = None,
                 peer_ip_address: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 router_appliance_instance: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouterPeerArgs.__new__(RouterPeerArgs)

            __props__.__dict__["advertise_mode"] = advertise_mode
            __props__.__dict__["advertised_groups"] = advertised_groups
            __props__.__dict__["advertised_ip_ranges"] = advertised_ip_ranges
            __props__.__dict__["advertised_route_priority"] = advertised_route_priority
            __props__.__dict__["bfd"] = bfd
            __props__.__dict__["enable"] = enable
            if interface is None and not opts.urn:
                raise TypeError("Missing required property 'interface'")
            __props__.__dict__["interface"] = interface
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["name"] = name
            if peer_asn is None and not opts.urn:
                raise TypeError("Missing required property 'peer_asn'")
            __props__.__dict__["peer_asn"] = peer_asn
            if peer_ip_address is None and not opts.urn:
                raise TypeError("Missing required property 'peer_ip_address'")
            __props__.__dict__["peer_ip_address"] = peer_ip_address
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            if router is None and not opts.urn:
                raise TypeError("Missing required property 'router'")
            __props__.__dict__["router"] = router
            __props__.__dict__["router_appliance_instance"] = router_appliance_instance
            __props__.__dict__["management_type"] = None
        super(RouterPeer, __self__).__init__(
            'gcp:compute/routerPeer:RouterPeer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advertise_mode: Optional[pulumi.Input[str]] = None,
            advertised_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            advertised_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterPeerAdvertisedIpRangeArgs']]]]] = None,
            advertised_route_priority: Optional[pulumi.Input[int]] = None,
            bfd: Optional[pulumi.Input[pulumi.InputType['RouterPeerBfdArgs']]] = None,
            enable: Optional[pulumi.Input[bool]] = None,
            interface: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            management_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            peer_asn: Optional[pulumi.Input[int]] = None,
            peer_ip_address: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            router: Optional[pulumi.Input[str]] = None,
            router_appliance_instance: Optional[pulumi.Input[str]] = None) -> 'RouterPeer':
        """
        Get an existing RouterPeer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] advertise_mode: User-specified flag to indicate which mode to use for advertisement.
               Valid values of this enum field are: `DEFAULT`, `CUSTOM`
               Default value is `DEFAULT`.
               Possible values are `DEFAULT` and `CUSTOM`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] advertised_groups: User-specified list of prefix groups to advertise in custom
               mode, which can take one of the following options:
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterPeerAdvertisedIpRangeArgs']]]] advertised_ip_ranges: User-specified list of individual IP ranges to advertise in
               custom mode. This field can only be populated if advertiseMode
               is `CUSTOM` and is advertised to all peers of the router. These IP
               ranges will be advertised in addition to any specified groups.
               Leave this field blank to advertise no custom IP ranges.
               Structure is documented below.
        :param pulumi.Input[int] advertised_route_priority: The priority of routes advertised to this BGP peer.
               Where there is more than one matching route of maximum
               length, the routes with the lowest priority value win.
        :param pulumi.Input[pulumi.InputType['RouterPeerBfdArgs']] bfd: BFD configuration for the BGP peering.
               Structure is documented below.
        :param pulumi.Input[bool] enable: The status of the BGP peer connection. If set to false, any active session
               with the peer is terminated and all associated routing information is removed.
               If set to true, the peer connection can be established with routing information.
               The default is true.
        :param pulumi.Input[str] interface: Name of the interface the BGP peer is associated with.
        :param pulumi.Input[str] ip_address: IP address of the interface inside Google Cloud Platform.
               Only IPv4 is supported.
        :param pulumi.Input[str] management_type: The resource that configures and manages this BGP peer.
        :param pulumi.Input[str] name: Name of this BGP peer. The name must be 1-63 characters long,
               and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[int] peer_asn: Peer BGP Autonomous System Number (ASN).
               Each BGP interface may use a different value.
        :param pulumi.Input[str] peer_ip_address: IP address of the BGP interface outside Google Cloud Platform.
               Only IPv4 is supported.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] region: Region where the router and BgpPeer reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[str] router: The name of the Cloud Router in which this BgpPeer will be configured.
        :param pulumi.Input[str] router_appliance_instance: The URI of the VM instance that is used as third-party router appliances
               such as Next Gen Firewalls, Virtual Routers, or Router Appliances.
               The VM instance must be located in zones contained in the same region as
               this Cloud Router. The VM instance is the peer side of the BGP session.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouterPeerState.__new__(_RouterPeerState)

        __props__.__dict__["advertise_mode"] = advertise_mode
        __props__.__dict__["advertised_groups"] = advertised_groups
        __props__.__dict__["advertised_ip_ranges"] = advertised_ip_ranges
        __props__.__dict__["advertised_route_priority"] = advertised_route_priority
        __props__.__dict__["bfd"] = bfd
        __props__.__dict__["enable"] = enable
        __props__.__dict__["interface"] = interface
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["management_type"] = management_type
        __props__.__dict__["name"] = name
        __props__.__dict__["peer_asn"] = peer_asn
        __props__.__dict__["peer_ip_address"] = peer_ip_address
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["router"] = router
        __props__.__dict__["router_appliance_instance"] = router_appliance_instance
        return RouterPeer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="advertiseMode")
    def advertise_mode(self) -> pulumi.Output[Optional[str]]:
        """
        User-specified flag to indicate which mode to use for advertisement.
        Valid values of this enum field are: `DEFAULT`, `CUSTOM`
        Default value is `DEFAULT`.
        Possible values are `DEFAULT` and `CUSTOM`.
        """
        return pulumi.get(self, "advertise_mode")

    @property
    @pulumi.getter(name="advertisedGroups")
    def advertised_groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        User-specified list of prefix groups to advertise in custom
        mode, which can take one of the following options:
        """
        return pulumi.get(self, "advertised_groups")

    @property
    @pulumi.getter(name="advertisedIpRanges")
    def advertised_ip_ranges(self) -> pulumi.Output[Optional[Sequence['outputs.RouterPeerAdvertisedIpRange']]]:
        """
        User-specified list of individual IP ranges to advertise in
        custom mode. This field can only be populated if advertiseMode
        is `CUSTOM` and is advertised to all peers of the router. These IP
        ranges will be advertised in addition to any specified groups.
        Leave this field blank to advertise no custom IP ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "advertised_ip_ranges")

    @property
    @pulumi.getter(name="advertisedRoutePriority")
    def advertised_route_priority(self) -> pulumi.Output[Optional[int]]:
        """
        The priority of routes advertised to this BGP peer.
        Where there is more than one matching route of maximum
        length, the routes with the lowest priority value win.
        """
        return pulumi.get(self, "advertised_route_priority")

    @property
    @pulumi.getter
    def bfd(self) -> pulumi.Output['outputs.RouterPeerBfd']:
        """
        BFD configuration for the BGP peering.
        Structure is documented below.
        """
        return pulumi.get(self, "bfd")

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Output[Optional[bool]]:
        """
        The status of the BGP peer connection. If set to false, any active session
        with the peer is terminated and all associated routing information is removed.
        If set to true, the peer connection can be established with routing information.
        The default is true.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter
    def interface(self) -> pulumi.Output[str]:
        """
        Name of the interface the BGP peer is associated with.
        """
        return pulumi.get(self, "interface")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        IP address of the interface inside Google Cloud Platform.
        Only IPv4 is supported.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="managementType")
    def management_type(self) -> pulumi.Output[str]:
        """
        The resource that configures and manages this BGP peer.
        """
        return pulumi.get(self, "management_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of this BGP peer. The name must be 1-63 characters long,
        and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which
        means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> pulumi.Output[int]:
        """
        Peer BGP Autonomous System Number (ASN).
        Each BGP interface may use a different value.
        """
        return pulumi.get(self, "peer_asn")

    @property
    @pulumi.getter(name="peerIpAddress")
    def peer_ip_address(self) -> pulumi.Output[str]:
        """
        IP address of the BGP interface outside Google Cloud Platform.
        Only IPv4 is supported.
        """
        return pulumi.get(self, "peer_ip_address")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Region where the router and BgpPeer reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def router(self) -> pulumi.Output[str]:
        """
        The name of the Cloud Router in which this BgpPeer will be configured.
        """
        return pulumi.get(self, "router")

    @property
    @pulumi.getter(name="routerApplianceInstance")
    def router_appliance_instance(self) -> pulumi.Output[Optional[str]]:
        """
        The URI of the VM instance that is used as third-party router appliances
        such as Next Gen Firewalls, Virtual Routers, or Router Appliances.
        The VM instance must be located in zones contained in the same region as
        this Cloud Router. The VM instance is the peer side of the BGP session.
        """
        return pulumi.get(self, "router_appliance_instance")

