# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SubnetworkArgs', 'Subnetwork']

@pulumi.input_type
class SubnetworkArgs:
    def __init__(__self__, *,
                 ip_cidr_range: pulumi.Input[str],
                 network: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 ipv6_access_type: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input['SubnetworkLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_ip_google_access: Optional[pulumi.Input[bool]] = None,
                 private_ipv6_google_access: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 purpose: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 secondary_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetworkSecondaryIpRangeArgs']]]] = None,
                 stack_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Subnetwork resource.
        :param pulumi.Input[str] ip_cidr_range: The range of internal addresses that are owned by this subnetwork.
               Provide this property when you create the subnetwork. For example,
               10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
               non-overlapping within a network. Only IPv4 is supported.
        :param pulumi.Input[str] network: The network this subnet belongs to.
               Only networks that are in the distributed mode can have subnetworks.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource. This field can be set only at resource
               creation time.
        :param pulumi.Input[str] ipv6_access_type: The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation
               or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
               cannot enable direct path.
               Possible values are `EXTERNAL` and `INTERNAL`.
        :param pulumi.Input['SubnetworkLogConfigArgs'] log_config: Denotes the logging options for the subnetwork flow logs. If logging is enabled
               logs will be exported to Stackdriver. This field cannot be set if the `purpose` of this
               subnetwork is `INTERNAL_HTTPS_LOAD_BALANCER`
               Structure is documented below.
        :param pulumi.Input[str] name: The name of the resource, provided by the client when initially
               creating the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[bool] private_ip_google_access: When enabled, VMs in this subnetwork without external IP addresses can
               access Google APIs and services by using Private Google Access.
        :param pulumi.Input[str] private_ipv6_google_access: The private IPv6 google access type for the VMs in this subnet.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] purpose: The purpose of the resource. A subnetwork with purpose set to
               INTERNAL_HTTPS_LOAD_BALANCER is a user-created subnetwork that is
               reserved for Internal HTTP(S) Load Balancing.
               If set to INTERNAL_HTTPS_LOAD_BALANCER you must also set the `role` field.
        :param pulumi.Input[str] region: The GCP region for this subnetwork.
        :param pulumi.Input[str] role: The role of subnetwork. Currently, this field is only used when
               purpose = INTERNAL_HTTPS_LOAD_BALANCER. The value can be set to ACTIVE
               or BACKUP. An ACTIVE subnetwork is one that is currently being used
               for Internal HTTP(S) Load Balancing. A BACKUP subnetwork is one that
               is ready to be promoted to ACTIVE or is currently draining.
               Possible values are `ACTIVE` and `BACKUP`.
        :param pulumi.Input[Sequence[pulumi.Input['SubnetworkSecondaryIpRangeArgs']]] secondary_ip_ranges: An array of configurations for secondary IP ranges for VM instances
               contained in this subnetwork. The primary IP of such VM must belong
               to the primary ipCidrRange of the subnetwork. The alias IPs may belong
               to either primary or secondary ranges.
               Structure is documented below.
        :param pulumi.Input[str] stack_type: The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
               If not specified IPV4_ONLY will be used.
               Possible values are `IPV4_ONLY` and `IPV4_IPV6`.
        """
        pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        pulumi.set(__self__, "network", network)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ipv6_access_type is not None:
            pulumi.set(__self__, "ipv6_access_type", ipv6_access_type)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip_google_access is not None:
            pulumi.set(__self__, "private_ip_google_access", private_ip_google_access)
        if private_ipv6_google_access is not None:
            pulumi.set(__self__, "private_ipv6_google_access", private_ipv6_google_access)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if secondary_ip_ranges is not None:
            pulumi.set(__self__, "secondary_ip_ranges", secondary_ip_ranges)
        if stack_type is not None:
            pulumi.set(__self__, "stack_type", stack_type)

    @property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> pulumi.Input[str]:
        """
        The range of internal addresses that are owned by this subnetwork.
        Provide this property when you create the subnetwork. For example,
        10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
        non-overlapping within a network. Only IPv4 is supported.
        """
        return pulumi.get(self, "ip_cidr_range")

    @ip_cidr_range.setter
    def ip_cidr_range(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_cidr_range", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[str]:
        """
        The network this subnet belongs to.
        Only networks that are in the distributed mode can have subnetworks.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource. This field can be set only at resource
        creation time.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipv6AccessType")
    def ipv6_access_type(self) -> Optional[pulumi.Input[str]]:
        """
        The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation
        or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
        cannot enable direct path.
        Possible values are `EXTERNAL` and `INTERNAL`.
        """
        return pulumi.get(self, "ipv6_access_type")

    @ipv6_access_type.setter
    def ipv6_access_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_access_type", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['SubnetworkLogConfigArgs']]:
        """
        Denotes the logging options for the subnetwork flow logs. If logging is enabled
        logs will be exported to Stackdriver. This field cannot be set if the `purpose` of this
        subnetwork is `INTERNAL_HTTPS_LOAD_BALANCER`
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['SubnetworkLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource, provided by the client when initially
        creating the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which
        means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateIpGoogleAccess")
    def private_ip_google_access(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, VMs in this subnetwork without external IP addresses can
        access Google APIs and services by using Private Google Access.
        """
        return pulumi.get(self, "private_ip_google_access")

    @private_ip_google_access.setter
    def private_ip_google_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "private_ip_google_access", value)

    @property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> Optional[pulumi.Input[str]]:
        """
        The private IPv6 google access type for the VMs in this subnet.
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @private_ipv6_google_access.setter
    def private_ipv6_google_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ipv6_google_access", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[str]]:
        """
        The purpose of the resource. A subnetwork with purpose set to
        INTERNAL_HTTPS_LOAD_BALANCER is a user-created subnetwork that is
        reserved for Internal HTTP(S) Load Balancing.
        If set to INTERNAL_HTTPS_LOAD_BALANCER you must also set the `role` field.
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purpose", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The GCP region for this subnetwork.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The role of subnetwork. Currently, this field is only used when
        purpose = INTERNAL_HTTPS_LOAD_BALANCER. The value can be set to ACTIVE
        or BACKUP. An ACTIVE subnetwork is one that is currently being used
        for Internal HTTP(S) Load Balancing. A BACKUP subnetwork is one that
        is ready to be promoted to ACTIVE or is currently draining.
        Possible values are `ACTIVE` and `BACKUP`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="secondaryIpRanges")
    def secondary_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubnetworkSecondaryIpRangeArgs']]]]:
        """
        An array of configurations for secondary IP ranges for VM instances
        contained in this subnetwork. The primary IP of such VM must belong
        to the primary ipCidrRange of the subnetwork. The alias IPs may belong
        to either primary or secondary ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "secondary_ip_ranges")

    @secondary_ip_ranges.setter
    def secondary_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetworkSecondaryIpRangeArgs']]]]):
        pulumi.set(self, "secondary_ip_ranges", value)

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> Optional[pulumi.Input[str]]:
        """
        The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
        If not specified IPV4_ONLY will be used.
        Possible values are `IPV4_ONLY` and `IPV4_IPV6`.
        """
        return pulumi.get(self, "stack_type")

    @stack_type.setter
    def stack_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stack_type", value)


@pulumi.input_type
class _SubnetworkState:
    def __init__(__self__, *,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 external_ipv6_prefix: Optional[pulumi.Input[str]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 gateway_address: Optional[pulumi.Input[str]] = None,
                 ip_cidr_range: Optional[pulumi.Input[str]] = None,
                 ipv6_access_type: Optional[pulumi.Input[str]] = None,
                 ipv6_cidr_range: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input['SubnetworkLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 private_ip_google_access: Optional[pulumi.Input[bool]] = None,
                 private_ipv6_google_access: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 purpose: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 secondary_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetworkSecondaryIpRangeArgs']]]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 stack_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Subnetwork resources.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource. This field can be set only at resource
               creation time.
        :param pulumi.Input[str] external_ipv6_prefix: The range of external IPv6 addresses that are owned by this subnetwork.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource. This field is used internally during updates of this resource.
        :param pulumi.Input[str] gateway_address: The gateway address for default routes to reach destination addresses
               outside this subnetwork.
        :param pulumi.Input[str] ip_cidr_range: The range of internal addresses that are owned by this subnetwork.
               Provide this property when you create the subnetwork. For example,
               10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
               non-overlapping within a network. Only IPv4 is supported.
        :param pulumi.Input[str] ipv6_access_type: The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation
               or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
               cannot enable direct path.
               Possible values are `EXTERNAL` and `INTERNAL`.
        :param pulumi.Input[str] ipv6_cidr_range: The range of internal IPv6 addresses that are owned by this subnetwork.
        :param pulumi.Input['SubnetworkLogConfigArgs'] log_config: Denotes the logging options for the subnetwork flow logs. If logging is enabled
               logs will be exported to Stackdriver. This field cannot be set if the `purpose` of this
               subnetwork is `INTERNAL_HTTPS_LOAD_BALANCER`
               Structure is documented below.
        :param pulumi.Input[str] name: The name of the resource, provided by the client when initially
               creating the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[str] network: The network this subnet belongs to.
               Only networks that are in the distributed mode can have subnetworks.
        :param pulumi.Input[bool] private_ip_google_access: When enabled, VMs in this subnetwork without external IP addresses can
               access Google APIs and services by using Private Google Access.
        :param pulumi.Input[str] private_ipv6_google_access: The private IPv6 google access type for the VMs in this subnet.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] purpose: The purpose of the resource. A subnetwork with purpose set to
               INTERNAL_HTTPS_LOAD_BALANCER is a user-created subnetwork that is
               reserved for Internal HTTP(S) Load Balancing.
               If set to INTERNAL_HTTPS_LOAD_BALANCER you must also set the `role` field.
        :param pulumi.Input[str] region: The GCP region for this subnetwork.
        :param pulumi.Input[str] role: The role of subnetwork. Currently, this field is only used when
               purpose = INTERNAL_HTTPS_LOAD_BALANCER. The value can be set to ACTIVE
               or BACKUP. An ACTIVE subnetwork is one that is currently being used
               for Internal HTTP(S) Load Balancing. A BACKUP subnetwork is one that
               is ready to be promoted to ACTIVE or is currently draining.
               Possible values are `ACTIVE` and `BACKUP`.
        :param pulumi.Input[Sequence[pulumi.Input['SubnetworkSecondaryIpRangeArgs']]] secondary_ip_ranges: An array of configurations for secondary IP ranges for VM instances
               contained in this subnetwork. The primary IP of such VM must belong
               to the primary ipCidrRange of the subnetwork. The alias IPs may belong
               to either primary or secondary ranges.
               Structure is documented below.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] stack_type: The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
               If not specified IPV4_ONLY will be used.
               Possible values are `IPV4_ONLY` and `IPV4_IPV6`.
        """
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_ipv6_prefix is not None:
            pulumi.set(__self__, "external_ipv6_prefix", external_ipv6_prefix)
        if fingerprint is not None:
            warnings.warn("""This field is not useful for users, and has been removed as an output.""", DeprecationWarning)
            pulumi.log.warn("""fingerprint is deprecated: This field is not useful for users, and has been removed as an output.""")
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if gateway_address is not None:
            pulumi.set(__self__, "gateway_address", gateway_address)
        if ip_cidr_range is not None:
            pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        if ipv6_access_type is not None:
            pulumi.set(__self__, "ipv6_access_type", ipv6_access_type)
        if ipv6_cidr_range is not None:
            pulumi.set(__self__, "ipv6_cidr_range", ipv6_cidr_range)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if private_ip_google_access is not None:
            pulumi.set(__self__, "private_ip_google_access", private_ip_google_access)
        if private_ipv6_google_access is not None:
            pulumi.set(__self__, "private_ipv6_google_access", private_ipv6_google_access)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if secondary_ip_ranges is not None:
            pulumi.set(__self__, "secondary_ip_ranges", secondary_ip_ranges)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if stack_type is not None:
            pulumi.set(__self__, "stack_type", stack_type)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource. This field can be set only at resource
        creation time.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalIpv6Prefix")
    def external_ipv6_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The range of external IPv6 addresses that are owned by this subnetwork.
        """
        return pulumi.get(self, "external_ipv6_prefix")

    @external_ipv6_prefix.setter
    def external_ipv6_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_ipv6_prefix", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        Fingerprint of this resource. This field is used internally during updates of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="gatewayAddress")
    def gateway_address(self) -> Optional[pulumi.Input[str]]:
        """
        The gateway address for default routes to reach destination addresses
        outside this subnetwork.
        """
        return pulumi.get(self, "gateway_address")

    @gateway_address.setter
    def gateway_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gateway_address", value)

    @property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> Optional[pulumi.Input[str]]:
        """
        The range of internal addresses that are owned by this subnetwork.
        Provide this property when you create the subnetwork. For example,
        10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
        non-overlapping within a network. Only IPv4 is supported.
        """
        return pulumi.get(self, "ip_cidr_range")

    @ip_cidr_range.setter
    def ip_cidr_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_cidr_range", value)

    @property
    @pulumi.getter(name="ipv6AccessType")
    def ipv6_access_type(self) -> Optional[pulumi.Input[str]]:
        """
        The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation
        or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
        cannot enable direct path.
        Possible values are `EXTERNAL` and `INTERNAL`.
        """
        return pulumi.get(self, "ipv6_access_type")

    @ipv6_access_type.setter
    def ipv6_access_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_access_type", value)

    @property
    @pulumi.getter(name="ipv6CidrRange")
    def ipv6_cidr_range(self) -> Optional[pulumi.Input[str]]:
        """
        The range of internal IPv6 addresses that are owned by this subnetwork.
        """
        return pulumi.get(self, "ipv6_cidr_range")

    @ipv6_cidr_range.setter
    def ipv6_cidr_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_cidr_range", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['SubnetworkLogConfigArgs']]:
        """
        Denotes the logging options for the subnetwork flow logs. If logging is enabled
        logs will be exported to Stackdriver. This field cannot be set if the `purpose` of this
        subnetwork is `INTERNAL_HTTPS_LOAD_BALANCER`
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['SubnetworkLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource, provided by the client when initially
        creating the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which
        means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The network this subnet belongs to.
        Only networks that are in the distributed mode can have subnetworks.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="privateIpGoogleAccess")
    def private_ip_google_access(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, VMs in this subnetwork without external IP addresses can
        access Google APIs and services by using Private Google Access.
        """
        return pulumi.get(self, "private_ip_google_access")

    @private_ip_google_access.setter
    def private_ip_google_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "private_ip_google_access", value)

    @property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> Optional[pulumi.Input[str]]:
        """
        The private IPv6 google access type for the VMs in this subnet.
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @private_ipv6_google_access.setter
    def private_ipv6_google_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ipv6_google_access", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[str]]:
        """
        The purpose of the resource. A subnetwork with purpose set to
        INTERNAL_HTTPS_LOAD_BALANCER is a user-created subnetwork that is
        reserved for Internal HTTP(S) Load Balancing.
        If set to INTERNAL_HTTPS_LOAD_BALANCER you must also set the `role` field.
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "purpose", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The GCP region for this subnetwork.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The role of subnetwork. Currently, this field is only used when
        purpose = INTERNAL_HTTPS_LOAD_BALANCER. The value can be set to ACTIVE
        or BACKUP. An ACTIVE subnetwork is one that is currently being used
        for Internal HTTP(S) Load Balancing. A BACKUP subnetwork is one that
        is ready to be promoted to ACTIVE or is currently draining.
        Possible values are `ACTIVE` and `BACKUP`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="secondaryIpRanges")
    def secondary_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubnetworkSecondaryIpRangeArgs']]]]:
        """
        An array of configurations for secondary IP ranges for VM instances
        contained in this subnetwork. The primary IP of such VM must belong
        to the primary ipCidrRange of the subnetwork. The alias IPs may belong
        to either primary or secondary ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "secondary_ip_ranges")

    @secondary_ip_ranges.setter
    def secondary_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubnetworkSecondaryIpRangeArgs']]]]):
        pulumi.set(self, "secondary_ip_ranges", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> Optional[pulumi.Input[str]]:
        """
        The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
        If not specified IPV4_ONLY will be used.
        Possible values are `IPV4_ONLY` and `IPV4_IPV6`.
        """
        return pulumi.get(self, "stack_type")

    @stack_type.setter
    def stack_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stack_type", value)


class Subnetwork(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_cidr_range: Optional[pulumi.Input[str]] = None,
                 ipv6_access_type: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input[pulumi.InputType['SubnetworkLogConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 private_ip_google_access: Optional[pulumi.Input[bool]] = None,
                 private_ipv6_google_access: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 purpose: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 secondary_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetworkSecondaryIpRangeArgs']]]]] = None,
                 stack_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A VPC network is a virtual version of the traditional physical networks
        that exist within and between physical data centers. A VPC network
        provides connectivity for your Compute Engine virtual machine (VM)
        instances, Container Engine containers, App Engine Flex services, and
        other network-related resources.

        Each GCP project contains one or more VPC networks. Each VPC network is a
        global entity spanning all GCP regions. This global VPC network allows VM
        instances and other resources to communicate with each other via internal,
        private IP addresses.

        Each VPC network is subdivided into subnets, and each subnet is contained
        within a single region. You can have more than one subnet in a region for
        a given VPC network. Each subnet has a contiguous private RFC1918 IP
        space. You create instances, containers, and the like in these subnets.
        When you create an instance, you must create it in a subnet, and the
        instance draws its internal IP address from that subnet.

        Virtual machine (VM) instances in a VPC network can communicate with
        instances in all other subnets of the same VPC network, regardless of
        region, using their RFC1918 private IP addresses. You can isolate portions
        of the network, even entire subnets, using firewall rules.

        To get more information about Subnetwork, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/subnetworks)
        * How-to Guides
            * [Private Google Access](https://cloud.google.com/vpc/docs/configure-private-google-access)
            * [Cloud Networking](https://cloud.google.com/vpc/docs/using-vpc)

        ## Example Usage
        ### Subnetwork Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test", auto_create_subnetworks=False)
        network_with_private_secondary_ip_ranges = gcp.compute.Subnetwork("network-with-private-secondary-ip-ranges",
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=custom_test.id,
            secondary_ip_ranges=[gcp.compute.SubnetworkSecondaryIpRangeArgs(
                range_name="tf-test-secondary-range-update1",
                ip_cidr_range="192.168.10.0/24",
            )])
        ```
        ### Subnetwork Logging Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test", auto_create_subnetworks=False)
        subnet_with_logging = gcp.compute.Subnetwork("subnet-with-logging",
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=custom_test.id,
            log_config=gcp.compute.SubnetworkLogConfigArgs(
                aggregation_interval="INTERVAL_10_MIN",
                flow_sampling=0.5,
                metadata="INCLUDE_ALL_METADATA",
            ))
        ```
        ### Subnetwork Internal L7lb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        network_for_l7lb = gcp.compute.Subnetwork("network-for-l7lb",
            ip_cidr_range="10.0.0.0/22",
            region="us-central1",
            purpose="INTERNAL_HTTPS_LOAD_BALANCER",
            role="ACTIVE",
            network=custom_test.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Subnetwork Ipv6

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test", auto_create_subnetworks=False)
        subnetwork_ipv6 = gcp.compute.Subnetwork("subnetwork-ipv6",
            ip_cidr_range="10.0.0.0/22",
            region="us-west2",
            stack_type="IPV4_IPV6",
            ipv6_access_type="EXTERNAL",
            network=custom_test.id)
        ```
        ### Subnetwork Internal Ipv6

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test",
            auto_create_subnetworks=False,
            enable_ula_internal_ipv6=True)
        subnetwork_internal_ipv6 = gcp.compute.Subnetwork("subnetwork-internal-ipv6",
            ip_cidr_range="10.0.0.0/22",
            region="us-west2",
            stack_type="IPV4_IPV6",
            ipv6_access_type="INTERNAL",
            network=custom_test.id)
        ```

        ## Import

        Subnetwork can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/subnetwork:Subnetwork default projects/{{project}}/regions/{{region}}/subnetworks/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/subnetwork:Subnetwork default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/subnetwork:Subnetwork default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/subnetwork:Subnetwork default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource. This field can be set only at resource
               creation time.
        :param pulumi.Input[str] ip_cidr_range: The range of internal addresses that are owned by this subnetwork.
               Provide this property when you create the subnetwork. For example,
               10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
               non-overlapping within a network. Only IPv4 is supported.
        :param pulumi.Input[str] ipv6_access_type: The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation
               or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
               cannot enable direct path.
               Possible values are `EXTERNAL` and `INTERNAL`.
        :param pulumi.Input[pulumi.InputType['SubnetworkLogConfigArgs']] log_config: Denotes the logging options for the subnetwork flow logs. If logging is enabled
               logs will be exported to Stackdriver. This field cannot be set if the `purpose` of this
               subnetwork is `INTERNAL_HTTPS_LOAD_BALANCER`
               Structure is documented below.
        :param pulumi.Input[str] name: The name of the resource, provided by the client when initially
               creating the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[str] network: The network this subnet belongs to.
               Only networks that are in the distributed mode can have subnetworks.
        :param pulumi.Input[bool] private_ip_google_access: When enabled, VMs in this subnetwork without external IP addresses can
               access Google APIs and services by using Private Google Access.
        :param pulumi.Input[str] private_ipv6_google_access: The private IPv6 google access type for the VMs in this subnet.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] purpose: The purpose of the resource. A subnetwork with purpose set to
               INTERNAL_HTTPS_LOAD_BALANCER is a user-created subnetwork that is
               reserved for Internal HTTP(S) Load Balancing.
               If set to INTERNAL_HTTPS_LOAD_BALANCER you must also set the `role` field.
        :param pulumi.Input[str] region: The GCP region for this subnetwork.
        :param pulumi.Input[str] role: The role of subnetwork. Currently, this field is only used when
               purpose = INTERNAL_HTTPS_LOAD_BALANCER. The value can be set to ACTIVE
               or BACKUP. An ACTIVE subnetwork is one that is currently being used
               for Internal HTTP(S) Load Balancing. A BACKUP subnetwork is one that
               is ready to be promoted to ACTIVE or is currently draining.
               Possible values are `ACTIVE` and `BACKUP`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetworkSecondaryIpRangeArgs']]]] secondary_ip_ranges: An array of configurations for secondary IP ranges for VM instances
               contained in this subnetwork. The primary IP of such VM must belong
               to the primary ipCidrRange of the subnetwork. The alias IPs may belong
               to either primary or secondary ranges.
               Structure is documented below.
        :param pulumi.Input[str] stack_type: The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
               If not specified IPV4_ONLY will be used.
               Possible values are `IPV4_ONLY` and `IPV4_IPV6`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubnetworkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A VPC network is a virtual version of the traditional physical networks
        that exist within and between physical data centers. A VPC network
        provides connectivity for your Compute Engine virtual machine (VM)
        instances, Container Engine containers, App Engine Flex services, and
        other network-related resources.

        Each GCP project contains one or more VPC networks. Each VPC network is a
        global entity spanning all GCP regions. This global VPC network allows VM
        instances and other resources to communicate with each other via internal,
        private IP addresses.

        Each VPC network is subdivided into subnets, and each subnet is contained
        within a single region. You can have more than one subnet in a region for
        a given VPC network. Each subnet has a contiguous private RFC1918 IP
        space. You create instances, containers, and the like in these subnets.
        When you create an instance, you must create it in a subnet, and the
        instance draws its internal IP address from that subnet.

        Virtual machine (VM) instances in a VPC network can communicate with
        instances in all other subnets of the same VPC network, regardless of
        region, using their RFC1918 private IP addresses. You can isolate portions
        of the network, even entire subnets, using firewall rules.

        To get more information about Subnetwork, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/subnetworks)
        * How-to Guides
            * [Private Google Access](https://cloud.google.com/vpc/docs/configure-private-google-access)
            * [Cloud Networking](https://cloud.google.com/vpc/docs/using-vpc)

        ## Example Usage
        ### Subnetwork Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test", auto_create_subnetworks=False)
        network_with_private_secondary_ip_ranges = gcp.compute.Subnetwork("network-with-private-secondary-ip-ranges",
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=custom_test.id,
            secondary_ip_ranges=[gcp.compute.SubnetworkSecondaryIpRangeArgs(
                range_name="tf-test-secondary-range-update1",
                ip_cidr_range="192.168.10.0/24",
            )])
        ```
        ### Subnetwork Logging Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test", auto_create_subnetworks=False)
        subnet_with_logging = gcp.compute.Subnetwork("subnet-with-logging",
            ip_cidr_range="10.2.0.0/16",
            region="us-central1",
            network=custom_test.id,
            log_config=gcp.compute.SubnetworkLogConfigArgs(
                aggregation_interval="INTERVAL_10_MIN",
                flow_sampling=0.5,
                metadata="INCLUDE_ALL_METADATA",
            ))
        ```
        ### Subnetwork Internal L7lb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test", auto_create_subnetworks=False,
        opts=pulumi.ResourceOptions(provider=google_beta))
        network_for_l7lb = gcp.compute.Subnetwork("network-for-l7lb",
            ip_cidr_range="10.0.0.0/22",
            region="us-central1",
            purpose="INTERNAL_HTTPS_LOAD_BALANCER",
            role="ACTIVE",
            network=custom_test.id,
            opts=pulumi.ResourceOptions(provider=google_beta))
        ```
        ### Subnetwork Ipv6

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test", auto_create_subnetworks=False)
        subnetwork_ipv6 = gcp.compute.Subnetwork("subnetwork-ipv6",
            ip_cidr_range="10.0.0.0/22",
            region="us-west2",
            stack_type="IPV4_IPV6",
            ipv6_access_type="EXTERNAL",
            network=custom_test.id)
        ```
        ### Subnetwork Internal Ipv6

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_test = gcp.compute.Network("custom-test",
            auto_create_subnetworks=False,
            enable_ula_internal_ipv6=True)
        subnetwork_internal_ipv6 = gcp.compute.Subnetwork("subnetwork-internal-ipv6",
            ip_cidr_range="10.0.0.0/22",
            region="us-west2",
            stack_type="IPV4_IPV6",
            ipv6_access_type="INTERNAL",
            network=custom_test.id)
        ```

        ## Import

        Subnetwork can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:compute/subnetwork:Subnetwork default projects/{{project}}/regions/{{region}}/subnetworks/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/subnetwork:Subnetwork default {{project}}/{{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/subnetwork:Subnetwork default {{region}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:compute/subnetwork:Subnetwork default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SubnetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubnetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ip_cidr_range: Optional[pulumi.Input[str]] = None,
                 ipv6_access_type: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input[pulumi.InputType['SubnetworkLogConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 private_ip_google_access: Optional[pulumi.Input[bool]] = None,
                 private_ipv6_google_access: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 purpose: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 secondary_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetworkSecondaryIpRangeArgs']]]]] = None,
                 stack_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubnetworkArgs.__new__(SubnetworkArgs)

            __props__.__dict__["description"] = description
            if ip_cidr_range is None and not opts.urn:
                raise TypeError("Missing required property 'ip_cidr_range'")
            __props__.__dict__["ip_cidr_range"] = ip_cidr_range
            __props__.__dict__["ipv6_access_type"] = ipv6_access_type
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["name"] = name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["private_ip_google_access"] = private_ip_google_access
            __props__.__dict__["private_ipv6_google_access"] = private_ipv6_google_access
            __props__.__dict__["project"] = project
            __props__.__dict__["purpose"] = purpose
            __props__.__dict__["region"] = region
            __props__.__dict__["role"] = role
            __props__.__dict__["secondary_ip_ranges"] = secondary_ip_ranges
            __props__.__dict__["stack_type"] = stack_type
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["external_ipv6_prefix"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["gateway_address"] = None
            __props__.__dict__["ipv6_cidr_range"] = None
            __props__.__dict__["self_link"] = None
        super(Subnetwork, __self__).__init__(
            'gcp:compute/subnetwork:Subnetwork',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_timestamp: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            external_ipv6_prefix: Optional[pulumi.Input[str]] = None,
            fingerprint: Optional[pulumi.Input[str]] = None,
            gateway_address: Optional[pulumi.Input[str]] = None,
            ip_cidr_range: Optional[pulumi.Input[str]] = None,
            ipv6_access_type: Optional[pulumi.Input[str]] = None,
            ipv6_cidr_range: Optional[pulumi.Input[str]] = None,
            log_config: Optional[pulumi.Input[pulumi.InputType['SubnetworkLogConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network: Optional[pulumi.Input[str]] = None,
            private_ip_google_access: Optional[pulumi.Input[bool]] = None,
            private_ipv6_google_access: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            purpose: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            secondary_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetworkSecondaryIpRangeArgs']]]]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            stack_type: Optional[pulumi.Input[str]] = None) -> 'Subnetwork':
        """
        Get an existing Subnetwork resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when
               you create the resource. This field can be set only at resource
               creation time.
        :param pulumi.Input[str] external_ipv6_prefix: The range of external IPv6 addresses that are owned by this subnetwork.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource. This field is used internally during updates of this resource.
        :param pulumi.Input[str] gateway_address: The gateway address for default routes to reach destination addresses
               outside this subnetwork.
        :param pulumi.Input[str] ip_cidr_range: The range of internal addresses that are owned by this subnetwork.
               Provide this property when you create the subnetwork. For example,
               10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
               non-overlapping within a network. Only IPv4 is supported.
        :param pulumi.Input[str] ipv6_access_type: The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation
               or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
               cannot enable direct path.
               Possible values are `EXTERNAL` and `INTERNAL`.
        :param pulumi.Input[str] ipv6_cidr_range: The range of internal IPv6 addresses that are owned by this subnetwork.
        :param pulumi.Input[pulumi.InputType['SubnetworkLogConfigArgs']] log_config: Denotes the logging options for the subnetwork flow logs. If logging is enabled
               logs will be exported to Stackdriver. This field cannot be set if the `purpose` of this
               subnetwork is `INTERNAL_HTTPS_LOAD_BALANCER`
               Structure is documented below.
        :param pulumi.Input[str] name: The name of the resource, provided by the client when initially
               creating the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which
               means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[str] network: The network this subnet belongs to.
               Only networks that are in the distributed mode can have subnetworks.
        :param pulumi.Input[bool] private_ip_google_access: When enabled, VMs in this subnetwork without external IP addresses can
               access Google APIs and services by using Private Google Access.
        :param pulumi.Input[str] private_ipv6_google_access: The private IPv6 google access type for the VMs in this subnet.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[str] purpose: The purpose of the resource. A subnetwork with purpose set to
               INTERNAL_HTTPS_LOAD_BALANCER is a user-created subnetwork that is
               reserved for Internal HTTP(S) Load Balancing.
               If set to INTERNAL_HTTPS_LOAD_BALANCER you must also set the `role` field.
        :param pulumi.Input[str] region: The GCP region for this subnetwork.
        :param pulumi.Input[str] role: The role of subnetwork. Currently, this field is only used when
               purpose = INTERNAL_HTTPS_LOAD_BALANCER. The value can be set to ACTIVE
               or BACKUP. An ACTIVE subnetwork is one that is currently being used
               for Internal HTTP(S) Load Balancing. A BACKUP subnetwork is one that
               is ready to be promoted to ACTIVE or is currently draining.
               Possible values are `ACTIVE` and `BACKUP`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SubnetworkSecondaryIpRangeArgs']]]] secondary_ip_ranges: An array of configurations for secondary IP ranges for VM instances
               contained in this subnetwork. The primary IP of such VM must belong
               to the primary ipCidrRange of the subnetwork. The alias IPs may belong
               to either primary or secondary ranges.
               Structure is documented below.
        :param pulumi.Input[str] self_link: The URI of the created resource.
        :param pulumi.Input[str] stack_type: The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
               If not specified IPV4_ONLY will be used.
               Possible values are `IPV4_ONLY` and `IPV4_IPV6`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubnetworkState.__new__(_SubnetworkState)

        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["external_ipv6_prefix"] = external_ipv6_prefix
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["gateway_address"] = gateway_address
        __props__.__dict__["ip_cidr_range"] = ip_cidr_range
        __props__.__dict__["ipv6_access_type"] = ipv6_access_type
        __props__.__dict__["ipv6_cidr_range"] = ipv6_cidr_range
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["private_ip_google_access"] = private_ip_google_access
        __props__.__dict__["private_ipv6_google_access"] = private_ipv6_google_access
        __props__.__dict__["project"] = project
        __props__.__dict__["purpose"] = purpose
        __props__.__dict__["region"] = region
        __props__.__dict__["role"] = role
        __props__.__dict__["secondary_ip_ranges"] = secondary_ip_ranges
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["stack_type"] = stack_type
        return Subnetwork(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource. This field can be set only at resource
        creation time.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalIpv6Prefix")
    def external_ipv6_prefix(self) -> pulumi.Output[str]:
        """
        The range of external IPv6 addresses that are owned by this subnetwork.
        """
        return pulumi.get(self, "external_ipv6_prefix")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[str]:
        """
        Fingerprint of this resource. This field is used internally during updates of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="gatewayAddress")
    def gateway_address(self) -> pulumi.Output[str]:
        """
        The gateway address for default routes to reach destination addresses
        outside this subnetwork.
        """
        return pulumi.get(self, "gateway_address")

    @property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> pulumi.Output[str]:
        """
        The range of internal addresses that are owned by this subnetwork.
        Provide this property when you create the subnetwork. For example,
        10.0.0.0/8 or 192.168.0.0/16. Ranges must be unique and
        non-overlapping within a network. Only IPv4 is supported.
        """
        return pulumi.get(self, "ip_cidr_range")

    @property
    @pulumi.getter(name="ipv6AccessType")
    def ipv6_access_type(self) -> pulumi.Output[Optional[str]]:
        """
        The access type of IPv6 address this subnet holds. It's immutable and can only be specified during creation
        or the first time the subnet is updated into IPV4_IPV6 dual stack. If the ipv6_type is EXTERNAL then this subnet
        cannot enable direct path.
        Possible values are `EXTERNAL` and `INTERNAL`.
        """
        return pulumi.get(self, "ipv6_access_type")

    @property
    @pulumi.getter(name="ipv6CidrRange")
    def ipv6_cidr_range(self) -> pulumi.Output[str]:
        """
        The range of internal IPv6 addresses that are owned by this subnetwork.
        """
        return pulumi.get(self, "ipv6_cidr_range")

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output[Optional['outputs.SubnetworkLogConfig']]:
        """
        Denotes the logging options for the subnetwork flow logs. If logging is enabled
        logs will be exported to Stackdriver. This field cannot be set if the `purpose` of this
        subnetwork is `INTERNAL_HTTPS_LOAD_BALANCER`
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource, provided by the client when initially
        creating the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which
        means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        """
        The network this subnet belongs to.
        Only networks that are in the distributed mode can have subnetworks.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="privateIpGoogleAccess")
    def private_ip_google_access(self) -> pulumi.Output[bool]:
        """
        When enabled, VMs in this subnetwork without external IP addresses can
        access Google APIs and services by using Private Google Access.
        """
        return pulumi.get(self, "private_ip_google_access")

    @property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> pulumi.Output[str]:
        """
        The private IPv6 google access type for the VMs in this subnet.
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def purpose(self) -> pulumi.Output[str]:
        """
        The purpose of the resource. A subnetwork with purpose set to
        INTERNAL_HTTPS_LOAD_BALANCER is a user-created subnetwork that is
        reserved for Internal HTTP(S) Load Balancing.
        If set to INTERNAL_HTTPS_LOAD_BALANCER you must also set the `role` field.
        """
        return pulumi.get(self, "purpose")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The GCP region for this subnetwork.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[str]]:
        """
        The role of subnetwork. Currently, this field is only used when
        purpose = INTERNAL_HTTPS_LOAD_BALANCER. The value can be set to ACTIVE
        or BACKUP. An ACTIVE subnetwork is one that is currently being used
        for Internal HTTP(S) Load Balancing. A BACKUP subnetwork is one that
        is ready to be promoted to ACTIVE or is currently draining.
        Possible values are `ACTIVE` and `BACKUP`.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="secondaryIpRanges")
    def secondary_ip_ranges(self) -> pulumi.Output[Sequence['outputs.SubnetworkSecondaryIpRange']]:
        """
        An array of configurations for secondary IP ranges for VM instances
        contained in this subnetwork. The primary IP of such VM must belong
        to the primary ipCidrRange of the subnetwork. The alias IPs may belong
        to either primary or secondary ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "secondary_ip_ranges")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> pulumi.Output[str]:
        """
        The stack type for this subnet to identify whether the IPv6 feature is enabled or not.
        If not specified IPV4_ONLY will be used.
        Possible values are `IPV4_ONLY` and `IPV4_IPV6`.
        """
        return pulumi.get(self, "stack_type")

