# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AzureClusterArgs', 'AzureCluster']

@pulumi.input_type
class AzureClusterArgs:
    def __init__(__self__, *,
                 authorization: pulumi.Input['AzureClusterAuthorizationArgs'],
                 azure_region: pulumi.Input[str],
                 client: pulumi.Input[str],
                 control_plane: pulumi.Input['AzureClusterControlPlaneArgs'],
                 fleet: pulumi.Input['AzureClusterFleetArgs'],
                 location: pulumi.Input[str],
                 networking: pulumi.Input['AzureClusterNetworkingArgs'],
                 resource_group_id: pulumi.Input[str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 logging_config: Optional[pulumi.Input['AzureClusterLoggingConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AzureCluster resource.
        :param pulumi.Input['AzureClusterAuthorizationArgs'] authorization: Configuration related to the cluster RBAC settings.
        :param pulumi.Input[str] azure_region: The Azure region where the cluster runs. Each Google Cloud region supports a subset of nearby Azure regions. You can call to list all supported Azure regions within a given Google Cloud region.
        :param pulumi.Input[str] client: Name of the AzureClient. The `AzureClient` resource must reside on the same GCP project and region as the `AzureCluster`. `AzureClient` names are formatted as `projects/<project-number>/locations/<region>/azureClients/<client-id>`. See Resource Names (https:cloud.google.com/apis/design/resource_names) for more details on Google Cloud resource names.
        :param pulumi.Input['AzureClusterControlPlaneArgs'] control_plane: Configuration related to the cluster control plane.
        :param pulumi.Input['AzureClusterFleetArgs'] fleet: Fleet configuration.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input['AzureClusterNetworkingArgs'] networking: Cluster-wide networking configuration.
        :param pulumi.Input[str] resource_group_id: The ARM ID of the resource group where the cluster resources are deployed. For example: `/subscriptions/*/resourceGroups/*`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required), separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between.
        :param pulumi.Input[str] description: Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
        :param pulumi.Input['AzureClusterLoggingConfigArgs'] logging_config: (Beta only) Logging configuration.
        :param pulumi.Input[str] name: The name of this resource.
        :param pulumi.Input[str] project: The number of the Fleet host project where this cluster will be registered.
               (Optional)
               The project for the resource
        """
        pulumi.set(__self__, "authorization", authorization)
        pulumi.set(__self__, "azure_region", azure_region)
        pulumi.set(__self__, "client", client)
        pulumi.set(__self__, "control_plane", control_plane)
        pulumi.set(__self__, "fleet", fleet)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "networking", networking)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Input['AzureClusterAuthorizationArgs']:
        """
        Configuration related to the cluster RBAC settings.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: pulumi.Input['AzureClusterAuthorizationArgs']):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="azureRegion")
    def azure_region(self) -> pulumi.Input[str]:
        """
        The Azure region where the cluster runs. Each Google Cloud region supports a subset of nearby Azure regions. You can call to list all supported Azure regions within a given Google Cloud region.
        """
        return pulumi.get(self, "azure_region")

    @azure_region.setter
    def azure_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "azure_region", value)

    @property
    @pulumi.getter
    def client(self) -> pulumi.Input[str]:
        """
        Name of the AzureClient. The `AzureClient` resource must reside on the same GCP project and region as the `AzureCluster`. `AzureClient` names are formatted as `projects/<project-number>/locations/<region>/azureClients/<client-id>`. See Resource Names (https:cloud.google.com/apis/design/resource_names) for more details on Google Cloud resource names.
        """
        return pulumi.get(self, "client")

    @client.setter
    def client(self, value: pulumi.Input[str]):
        pulumi.set(self, "client", value)

    @property
    @pulumi.getter(name="controlPlane")
    def control_plane(self) -> pulumi.Input['AzureClusterControlPlaneArgs']:
        """
        Configuration related to the cluster control plane.
        """
        return pulumi.get(self, "control_plane")

    @control_plane.setter
    def control_plane(self, value: pulumi.Input['AzureClusterControlPlaneArgs']):
        pulumi.set(self, "control_plane", value)

    @property
    @pulumi.getter
    def fleet(self) -> pulumi.Input['AzureClusterFleetArgs']:
        """
        Fleet configuration.
        """
        return pulumi.get(self, "fleet")

    @fleet.setter
    def fleet(self, value: pulumi.Input['AzureClusterFleetArgs']):
        pulumi.set(self, "fleet", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def networking(self) -> pulumi.Input['AzureClusterNetworkingArgs']:
        """
        Cluster-wide networking configuration.
        """
        return pulumi.get(self, "networking")

    @networking.setter
    def networking(self, value: pulumi.Input['AzureClusterNetworkingArgs']):
        pulumi.set(self, "networking", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Input[str]:
        """
        The ARM ID of the resource group where the cluster resources are deployed. For example: `/subscriptions/*/resourceGroups/*`
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required), separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['AzureClusterLoggingConfigArgs']]:
        """
        (Beta only) Logging configuration.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['AzureClusterLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The number of the Fleet host project where this cluster will be registered.
        (Optional)
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _AzureClusterState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 authorization: Optional[pulumi.Input['AzureClusterAuthorizationArgs']] = None,
                 azure_region: Optional[pulumi.Input[str]] = None,
                 client: Optional[pulumi.Input[str]] = None,
                 control_plane: Optional[pulumi.Input['AzureClusterControlPlaneArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 fleet: Optional[pulumi.Input['AzureClusterFleetArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 logging_config: Optional[pulumi.Input['AzureClusterLoggingConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networking: Optional[pulumi.Input['AzureClusterNetworkingArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reconciling: Optional[pulumi.Input[bool]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 uid: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 workload_identity_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AzureClusterWorkloadIdentityConfigArgs']]]] = None):
        """
        Input properties used for looking up and filtering AzureCluster resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required), separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between.
        :param pulumi.Input['AzureClusterAuthorizationArgs'] authorization: Configuration related to the cluster RBAC settings.
        :param pulumi.Input[str] azure_region: The Azure region where the cluster runs. Each Google Cloud region supports a subset of nearby Azure regions. You can call to list all supported Azure regions within a given Google Cloud region.
        :param pulumi.Input[str] client: Name of the AzureClient. The `AzureClient` resource must reside on the same GCP project and region as the `AzureCluster`. `AzureClient` names are formatted as `projects/<project-number>/locations/<region>/azureClients/<client-id>`. See Resource Names (https:cloud.google.com/apis/design/resource_names) for more details on Google Cloud resource names.
        :param pulumi.Input['AzureClusterControlPlaneArgs'] control_plane: Configuration related to the cluster control plane.
        :param pulumi.Input[str] create_time: Output only. The time at which this cluster was created.
        :param pulumi.Input[str] description: Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
        :param pulumi.Input[str] endpoint: Output only. The endpoint of the cluster's API server.
        :param pulumi.Input[str] etag: Allows clients to perform consistent read-modify-writes through optimistic concurrency control. May be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input['AzureClusterFleetArgs'] fleet: Fleet configuration.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input['AzureClusterLoggingConfigArgs'] logging_config: (Beta only) Logging configuration.
        :param pulumi.Input[str] name: The name of this resource.
        :param pulumi.Input['AzureClusterNetworkingArgs'] networking: Cluster-wide networking configuration.
        :param pulumi.Input[str] project: The number of the Fleet host project where this cluster will be registered.
               (Optional)
               The project for the resource
        :param pulumi.Input[bool] reconciling: Output only. If set, there are currently changes in flight to the cluster.
        :param pulumi.Input[str] resource_group_id: The ARM ID of the resource group where the cluster resources are deployed. For example: `/subscriptions/*/resourceGroups/*`
        :param pulumi.Input[str] state: Output only. The current state of the cluster. Possible values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR, DEGRADED
        :param pulumi.Input[str] uid: Output only. A globally unique identifier for the cluster.
        :param pulumi.Input[str] update_time: Output only. The time at which this cluster was last updated.
        :param pulumi.Input[Sequence[pulumi.Input['AzureClusterWorkloadIdentityConfigArgs']]] workload_identity_configs: Output only. Workload Identity settings.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if azure_region is not None:
            pulumi.set(__self__, "azure_region", azure_region)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if control_plane is not None:
            pulumi.set(__self__, "control_plane", control_plane)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if fleet is not None:
            pulumi.set(__self__, "fleet", fleet)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networking is not None:
            pulumi.set(__self__, "networking", networking)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if workload_identity_configs is not None:
            pulumi.set(__self__, "workload_identity_configs", workload_identity_configs)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required), separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input['AzureClusterAuthorizationArgs']]:
        """
        Configuration related to the cluster RBAC settings.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input['AzureClusterAuthorizationArgs']]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="azureRegion")
    def azure_region(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure region where the cluster runs. Each Google Cloud region supports a subset of nearby Azure regions. You can call to list all supported Azure regions within a given Google Cloud region.
        """
        return pulumi.get(self, "azure_region")

    @azure_region.setter
    def azure_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "azure_region", value)

    @property
    @pulumi.getter
    def client(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the AzureClient. The `AzureClient` resource must reside on the same GCP project and region as the `AzureCluster`. `AzureClient` names are formatted as `projects/<project-number>/locations/<region>/azureClients/<client-id>`. See Resource Names (https:cloud.google.com/apis/design/resource_names) for more details on Google Cloud resource names.
        """
        return pulumi.get(self, "client")

    @client.setter
    def client(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client", value)

    @property
    @pulumi.getter(name="controlPlane")
    def control_plane(self) -> Optional[pulumi.Input['AzureClusterControlPlaneArgs']]:
        """
        Configuration related to the cluster control plane.
        """
        return pulumi.get(self, "control_plane")

    @control_plane.setter
    def control_plane(self, value: Optional[pulumi.Input['AzureClusterControlPlaneArgs']]):
        pulumi.set(self, "control_plane", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The time at which this cluster was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The endpoint of the cluster's API server.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        Allows clients to perform consistent read-modify-writes through optimistic concurrency control. May be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def fleet(self) -> Optional[pulumi.Input['AzureClusterFleetArgs']]:
        """
        Fleet configuration.
        """
        return pulumi.get(self, "fleet")

    @fleet.setter
    def fleet(self, value: Optional[pulumi.Input['AzureClusterFleetArgs']]):
        pulumi.set(self, "fleet", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['AzureClusterLoggingConfigArgs']]:
        """
        (Beta only) Logging configuration.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['AzureClusterLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def networking(self) -> Optional[pulumi.Input['AzureClusterNetworkingArgs']]:
        """
        Cluster-wide networking configuration.
        """
        return pulumi.get(self, "networking")

    @networking.setter
    def networking(self, value: Optional[pulumi.Input['AzureClusterNetworkingArgs']]):
        pulumi.set(self, "networking", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The number of the Fleet host project where this cluster will be registered.
        (Optional)
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[bool]]:
        """
        Output only. If set, there are currently changes in flight to the cluster.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ARM ID of the resource group where the cluster resources are deployed. For example: `/subscriptions/*/resourceGroups/*`
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The current state of the cluster. Possible values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR, DEGRADED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. A globally unique identifier for the cluster.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The time at which this cluster was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="workloadIdentityConfigs")
    def workload_identity_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AzureClusterWorkloadIdentityConfigArgs']]]]:
        """
        Output only. Workload Identity settings.
        """
        return pulumi.get(self, "workload_identity_configs")

    @workload_identity_configs.setter
    def workload_identity_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AzureClusterWorkloadIdentityConfigArgs']]]]):
        pulumi.set(self, "workload_identity_configs", value)


class AzureCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 authorization: Optional[pulumi.Input[pulumi.InputType['AzureClusterAuthorizationArgs']]] = None,
                 azure_region: Optional[pulumi.Input[str]] = None,
                 client: Optional[pulumi.Input[str]] = None,
                 control_plane: Optional[pulumi.Input[pulumi.InputType['AzureClusterControlPlaneArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fleet: Optional[pulumi.Input[pulumi.InputType['AzureClusterFleetArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 logging_config: Optional[pulumi.Input[pulumi.InputType['AzureClusterLoggingConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networking: Optional[pulumi.Input[pulumi.InputType['AzureClusterNetworkingArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        An Anthos cluster running on Azure.

        For more information, see:
        * [Multicloud overview](https://cloud.google.com/anthos/clusters/docs/multi-cloud)
        ## Example Usage
        ### Basic_azure_cluster
        A basic example of a containerazure azure cluster
        ```python
        import pulumi
        import pulumi_gcp as gcp

        versions = gcp.container.get_azure_versions(location="us-west1",
            project="my-project-name")
        basic = gcp.container.AzureClient("basic",
            application_id="12345678-1234-1234-1234-123456789111",
            location="us-west1",
            project="my-project-name",
            tenant_id="12345678-1234-1234-1234-123456789111")
        primary = gcp.container.AzureCluster("primary",
            authorization=gcp.container.AzureClusterAuthorizationArgs(
                admin_users=[gcp.container.AzureClusterAuthorizationAdminUserArgs(
                    username="mmv2@google.com",
                )],
            ),
            azure_region="westus2",
            client=basic.name.apply(lambda name: f"projects/my-project-number/locations/us-west1/azureClients/{name}"),
            control_plane=gcp.container.AzureClusterControlPlaneArgs(
                ssh_config=gcp.container.AzureClusterControlPlaneSshConfigArgs(
                    authorized_key="ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQC8yaayO6lnb2v+SedxUMa2c8vtIEzCzBjM3EJJsv8Vm9zUDWR7dXWKoNGARUb2mNGXASvI6mFIDXTIlkQ0poDEPpMaXR0g2cb5xT8jAAJq7fqXL3+0rcJhY/uigQ+MrT6s+ub0BFVbsmGHNrMQttXX9gtmwkeAEvj3mra9e5pkNf90qlKnZz6U0SVArxVsLx07vHPHDIYrl0OPG4zUREF52igbBPiNrHJFDQJT/4YlDMJmo/QT/A1D6n9ocemvZSzhRx15/Arjowhr+VVKSbaxzPtEfY0oIg2SrqJnnr/l3Du5qIefwh5VmCZe4xopPUaDDoOIEFriZ88sB+3zz8ib8sk8zJJQCgeP78tQvXCgS+4e5W3TUg9mxjB6KjXTyHIVhDZqhqde0OI3Fy1UuVzRUwnBaLjBnAwP5EoFQGRmDYk/rEYe7HTmovLeEBUDQocBQKT4Ripm/xJkkWY7B07K/tfo56dGUCkvyIVXKBInCh+dLK7gZapnd4UWkY0xBYcwo1geMLRq58iFTLA2j/JmpmHXp7m0l7jJii7d44uD3tTIFYThn7NlOnvhLim/YcBK07GMGIN7XwrrKZKmxXaspw6KBWVhzuw1UPxctxshYEaMLfFg/bwOw8HvMPr9VtrElpSB7oiOh91PDIPdPBgHCi7N2QgQ5l/ZDBHieSpNrQ== thomasrodgers",
                ),
                subnet_id="/subscriptions/12345678-1234-1234-1234-123456789111/resourceGroups/my--dev-byo/providers/Microsoft.Network/virtualNetworks/my--dev-vnet/subnets/default",
                version=versions.valid_versions[0],
            ),
            fleet=gcp.container.AzureClusterFleetArgs(
                project="my-project-number",
            ),
            location="us-west1",
            networking=gcp.container.AzureClusterNetworkingArgs(
                pod_address_cidr_blocks=["10.200.0.0/16"],
                service_address_cidr_blocks=["10.32.0.0/24"],
                virtual_network_id="/subscriptions/12345678-1234-1234-1234-123456789111/resourceGroups/my--dev-byo/providers/Microsoft.Network/virtualNetworks/my--dev-vnet",
            ),
            project="my-project-name",
            resource_group_id="/subscriptions/12345678-1234-1234-1234-123456789111/resourceGroups/my--dev-cluster")
        ```

        ## Import

        Cluster can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:container/azureCluster:AzureCluster default projects/{{project}}/locations/{{location}}/azureClusters/{{name}}
        ```

        ```sh
         $ pulumi import gcp:container/azureCluster:AzureCluster default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:container/azureCluster:AzureCluster default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required), separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between.
        :param pulumi.Input[pulumi.InputType['AzureClusterAuthorizationArgs']] authorization: Configuration related to the cluster RBAC settings.
        :param pulumi.Input[str] azure_region: The Azure region where the cluster runs. Each Google Cloud region supports a subset of nearby Azure regions. You can call to list all supported Azure regions within a given Google Cloud region.
        :param pulumi.Input[str] client: Name of the AzureClient. The `AzureClient` resource must reside on the same GCP project and region as the `AzureCluster`. `AzureClient` names are formatted as `projects/<project-number>/locations/<region>/azureClients/<client-id>`. See Resource Names (https:cloud.google.com/apis/design/resource_names) for more details on Google Cloud resource names.
        :param pulumi.Input[pulumi.InputType['AzureClusterControlPlaneArgs']] control_plane: Configuration related to the cluster control plane.
        :param pulumi.Input[str] description: Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
        :param pulumi.Input[pulumi.InputType['AzureClusterFleetArgs']] fleet: Fleet configuration.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[pulumi.InputType['AzureClusterLoggingConfigArgs']] logging_config: (Beta only) Logging configuration.
        :param pulumi.Input[str] name: The name of this resource.
        :param pulumi.Input[pulumi.InputType['AzureClusterNetworkingArgs']] networking: Cluster-wide networking configuration.
        :param pulumi.Input[str] project: The number of the Fleet host project where this cluster will be registered.
               (Optional)
               The project for the resource
        :param pulumi.Input[str] resource_group_id: The ARM ID of the resource group where the cluster resources are deployed. For example: `/subscriptions/*/resourceGroups/*`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An Anthos cluster running on Azure.

        For more information, see:
        * [Multicloud overview](https://cloud.google.com/anthos/clusters/docs/multi-cloud)
        ## Example Usage
        ### Basic_azure_cluster
        A basic example of a containerazure azure cluster
        ```python
        import pulumi
        import pulumi_gcp as gcp

        versions = gcp.container.get_azure_versions(location="us-west1",
            project="my-project-name")
        basic = gcp.container.AzureClient("basic",
            application_id="12345678-1234-1234-1234-123456789111",
            location="us-west1",
            project="my-project-name",
            tenant_id="12345678-1234-1234-1234-123456789111")
        primary = gcp.container.AzureCluster("primary",
            authorization=gcp.container.AzureClusterAuthorizationArgs(
                admin_users=[gcp.container.AzureClusterAuthorizationAdminUserArgs(
                    username="mmv2@google.com",
                )],
            ),
            azure_region="westus2",
            client=basic.name.apply(lambda name: f"projects/my-project-number/locations/us-west1/azureClients/{name}"),
            control_plane=gcp.container.AzureClusterControlPlaneArgs(
                ssh_config=gcp.container.AzureClusterControlPlaneSshConfigArgs(
                    authorized_key="ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQC8yaayO6lnb2v+SedxUMa2c8vtIEzCzBjM3EJJsv8Vm9zUDWR7dXWKoNGARUb2mNGXASvI6mFIDXTIlkQ0poDEPpMaXR0g2cb5xT8jAAJq7fqXL3+0rcJhY/uigQ+MrT6s+ub0BFVbsmGHNrMQttXX9gtmwkeAEvj3mra9e5pkNf90qlKnZz6U0SVArxVsLx07vHPHDIYrl0OPG4zUREF52igbBPiNrHJFDQJT/4YlDMJmo/QT/A1D6n9ocemvZSzhRx15/Arjowhr+VVKSbaxzPtEfY0oIg2SrqJnnr/l3Du5qIefwh5VmCZe4xopPUaDDoOIEFriZ88sB+3zz8ib8sk8zJJQCgeP78tQvXCgS+4e5W3TUg9mxjB6KjXTyHIVhDZqhqde0OI3Fy1UuVzRUwnBaLjBnAwP5EoFQGRmDYk/rEYe7HTmovLeEBUDQocBQKT4Ripm/xJkkWY7B07K/tfo56dGUCkvyIVXKBInCh+dLK7gZapnd4UWkY0xBYcwo1geMLRq58iFTLA2j/JmpmHXp7m0l7jJii7d44uD3tTIFYThn7NlOnvhLim/YcBK07GMGIN7XwrrKZKmxXaspw6KBWVhzuw1UPxctxshYEaMLfFg/bwOw8HvMPr9VtrElpSB7oiOh91PDIPdPBgHCi7N2QgQ5l/ZDBHieSpNrQ== thomasrodgers",
                ),
                subnet_id="/subscriptions/12345678-1234-1234-1234-123456789111/resourceGroups/my--dev-byo/providers/Microsoft.Network/virtualNetworks/my--dev-vnet/subnets/default",
                version=versions.valid_versions[0],
            ),
            fleet=gcp.container.AzureClusterFleetArgs(
                project="my-project-number",
            ),
            location="us-west1",
            networking=gcp.container.AzureClusterNetworkingArgs(
                pod_address_cidr_blocks=["10.200.0.0/16"],
                service_address_cidr_blocks=["10.32.0.0/24"],
                virtual_network_id="/subscriptions/12345678-1234-1234-1234-123456789111/resourceGroups/my--dev-byo/providers/Microsoft.Network/virtualNetworks/my--dev-vnet",
            ),
            project="my-project-name",
            resource_group_id="/subscriptions/12345678-1234-1234-1234-123456789111/resourceGroups/my--dev-cluster")
        ```

        ## Import

        Cluster can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:container/azureCluster:AzureCluster default projects/{{project}}/locations/{{location}}/azureClusters/{{name}}
        ```

        ```sh
         $ pulumi import gcp:container/azureCluster:AzureCluster default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:container/azureCluster:AzureCluster default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AzureClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 authorization: Optional[pulumi.Input[pulumi.InputType['AzureClusterAuthorizationArgs']]] = None,
                 azure_region: Optional[pulumi.Input[str]] = None,
                 client: Optional[pulumi.Input[str]] = None,
                 control_plane: Optional[pulumi.Input[pulumi.InputType['AzureClusterControlPlaneArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fleet: Optional[pulumi.Input[pulumi.InputType['AzureClusterFleetArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 logging_config: Optional[pulumi.Input[pulumi.InputType['AzureClusterLoggingConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 networking: Optional[pulumi.Input[pulumi.InputType['AzureClusterNetworkingArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureClusterArgs.__new__(AzureClusterArgs)

            __props__.__dict__["annotations"] = annotations
            if authorization is None and not opts.urn:
                raise TypeError("Missing required property 'authorization'")
            __props__.__dict__["authorization"] = authorization
            if azure_region is None and not opts.urn:
                raise TypeError("Missing required property 'azure_region'")
            __props__.__dict__["azure_region"] = azure_region
            if client is None and not opts.urn:
                raise TypeError("Missing required property 'client'")
            __props__.__dict__["client"] = client
            if control_plane is None and not opts.urn:
                raise TypeError("Missing required property 'control_plane'")
            __props__.__dict__["control_plane"] = control_plane
            __props__.__dict__["description"] = description
            if fleet is None and not opts.urn:
                raise TypeError("Missing required property 'fleet'")
            __props__.__dict__["fleet"] = fleet
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["logging_config"] = logging_config
            __props__.__dict__["name"] = name
            if networking is None and not opts.urn:
                raise TypeError("Missing required property 'networking'")
            __props__.__dict__["networking"] = networking
            __props__.__dict__["project"] = project
            if resource_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_id'")
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["workload_identity_configs"] = None
        super(AzureCluster, __self__).__init__(
            'gcp:container/azureCluster:AzureCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            authorization: Optional[pulumi.Input[pulumi.InputType['AzureClusterAuthorizationArgs']]] = None,
            azure_region: Optional[pulumi.Input[str]] = None,
            client: Optional[pulumi.Input[str]] = None,
            control_plane: Optional[pulumi.Input[pulumi.InputType['AzureClusterControlPlaneArgs']]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            fleet: Optional[pulumi.Input[pulumi.InputType['AzureClusterFleetArgs']]] = None,
            location: Optional[pulumi.Input[str]] = None,
            logging_config: Optional[pulumi.Input[pulumi.InputType['AzureClusterLoggingConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            networking: Optional[pulumi.Input[pulumi.InputType['AzureClusterNetworkingArgs']]] = None,
            project: Optional[pulumi.Input[str]] = None,
            reconciling: Optional[pulumi.Input[bool]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            uid: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            workload_identity_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AzureClusterWorkloadIdentityConfigArgs']]]]] = None) -> 'AzureCluster':
        """
        Get an existing AzureCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotations: Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required), separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between.
        :param pulumi.Input[pulumi.InputType['AzureClusterAuthorizationArgs']] authorization: Configuration related to the cluster RBAC settings.
        :param pulumi.Input[str] azure_region: The Azure region where the cluster runs. Each Google Cloud region supports a subset of nearby Azure regions. You can call to list all supported Azure regions within a given Google Cloud region.
        :param pulumi.Input[str] client: Name of the AzureClient. The `AzureClient` resource must reside on the same GCP project and region as the `AzureCluster`. `AzureClient` names are formatted as `projects/<project-number>/locations/<region>/azureClients/<client-id>`. See Resource Names (https:cloud.google.com/apis/design/resource_names) for more details on Google Cloud resource names.
        :param pulumi.Input[pulumi.InputType['AzureClusterControlPlaneArgs']] control_plane: Configuration related to the cluster control plane.
        :param pulumi.Input[str] create_time: Output only. The time at which this cluster was created.
        :param pulumi.Input[str] description: Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
        :param pulumi.Input[str] endpoint: Output only. The endpoint of the cluster's API server.
        :param pulumi.Input[str] etag: Allows clients to perform consistent read-modify-writes through optimistic concurrency control. May be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[pulumi.InputType['AzureClusterFleetArgs']] fleet: Fleet configuration.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[pulumi.InputType['AzureClusterLoggingConfigArgs']] logging_config: (Beta only) Logging configuration.
        :param pulumi.Input[str] name: The name of this resource.
        :param pulumi.Input[pulumi.InputType['AzureClusterNetworkingArgs']] networking: Cluster-wide networking configuration.
        :param pulumi.Input[str] project: The number of the Fleet host project where this cluster will be registered.
               (Optional)
               The project for the resource
        :param pulumi.Input[bool] reconciling: Output only. If set, there are currently changes in flight to the cluster.
        :param pulumi.Input[str] resource_group_id: The ARM ID of the resource group where the cluster resources are deployed. For example: `/subscriptions/*/resourceGroups/*`
        :param pulumi.Input[str] state: Output only. The current state of the cluster. Possible values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR, DEGRADED
        :param pulumi.Input[str] uid: Output only. A globally unique identifier for the cluster.
        :param pulumi.Input[str] update_time: Output only. The time at which this cluster was last updated.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AzureClusterWorkloadIdentityConfigArgs']]]] workload_identity_configs: Output only. Workload Identity settings.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureClusterState.__new__(_AzureClusterState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["azure_region"] = azure_region
        __props__.__dict__["client"] = client
        __props__.__dict__["control_plane"] = control_plane
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["etag"] = etag
        __props__.__dict__["fleet"] = fleet
        __props__.__dict__["location"] = location
        __props__.__dict__["logging_config"] = logging_config
        __props__.__dict__["name"] = name
        __props__.__dict__["networking"] = networking
        __props__.__dict__["project"] = project
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["state"] = state
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["workload_identity_configs"] = workload_identity_configs
        return AzureCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required), separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output['outputs.AzureClusterAuthorization']:
        """
        Configuration related to the cluster RBAC settings.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="azureRegion")
    def azure_region(self) -> pulumi.Output[str]:
        """
        The Azure region where the cluster runs. Each Google Cloud region supports a subset of nearby Azure regions. You can call to list all supported Azure regions within a given Google Cloud region.
        """
        return pulumi.get(self, "azure_region")

    @property
    @pulumi.getter
    def client(self) -> pulumi.Output[str]:
        """
        Name of the AzureClient. The `AzureClient` resource must reside on the same GCP project and region as the `AzureCluster`. `AzureClient` names are formatted as `projects/<project-number>/locations/<region>/azureClients/<client-id>`. See Resource Names (https:cloud.google.com/apis/design/resource_names) for more details on Google Cloud resource names.
        """
        return pulumi.get(self, "client")

    @property
    @pulumi.getter(name="controlPlane")
    def control_plane(self) -> pulumi.Output['outputs.AzureClusterControlPlane']:
        """
        Configuration related to the cluster control plane.
        """
        return pulumi.get(self, "control_plane")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Output only. The time at which this cluster was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        Output only. The endpoint of the cluster's API server.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        Allows clients to perform consistent read-modify-writes through optimistic concurrency control. May be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def fleet(self) -> pulumi.Output['outputs.AzureClusterFleet']:
        """
        Fleet configuration.
        """
        return pulumi.get(self, "fleet")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> pulumi.Output['outputs.AzureClusterLoggingConfig']:
        """
        (Beta only) Logging configuration.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networking(self) -> pulumi.Output['outputs.AzureClusterNetworking']:
        """
        Cluster-wide networking configuration.
        """
        return pulumi.get(self, "networking")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The number of the Fleet host project where this cluster will be registered.
        (Optional)
        The project for the resource
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[bool]:
        """
        Output only. If set, there are currently changes in flight to the cluster.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ARM ID of the resource group where the cluster resources are deployed. For example: `/subscriptions/*/resourceGroups/*`
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Output only. The current state of the cluster. Possible values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR, DEGRADED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        Output only. A globally unique identifier for the cluster.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Output only. The time at which this cluster was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="workloadIdentityConfigs")
    def workload_identity_configs(self) -> pulumi.Output[Sequence['outputs.AzureClusterWorkloadIdentityConfig']]:
        """
        Output only. Workload Identity settings.
        """
        return pulumi.get(self, "workload_identity_configs")

