# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAttachedInstallManifestResult',
    'AwaitableGetAttachedInstallManifestResult',
    'get_attached_install_manifest',
    'get_attached_install_manifest_output',
]

@pulumi.output_type
class GetAttachedInstallManifestResult:
    """
    A collection of values returned by getAttachedInstallManifest.
    """
    def __init__(__self__, cluster_id=None, id=None, location=None, manifest=None, platform_version=None, project=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if manifest and not isinstance(manifest, str):
            raise TypeError("Expected argument 'manifest' to be a str")
        pulumi.set(__self__, "manifest", manifest)
        if platform_version and not isinstance(platform_version, str):
            raise TypeError("Expected argument 'platform_version' to be a str")
        pulumi.set(__self__, "platform_version", platform_version)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def manifest(self) -> str:
        """
        A string with the YAML manifest that needs to be applied to the cluster.
        """
        return pulumi.get(self, "manifest")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> str:
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter
    def project(self) -> str:
        return pulumi.get(self, "project")


class AwaitableGetAttachedInstallManifestResult(GetAttachedInstallManifestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAttachedInstallManifestResult(
            cluster_id=self.cluster_id,
            id=self.id,
            location=self.location,
            manifest=self.manifest,
            platform_version=self.platform_version,
            project=self.project)


def get_attached_install_manifest(cluster_id: Optional[str] = None,
                                  location: Optional[str] = None,
                                  platform_version: Optional[str] = None,
                                  project: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAttachedInstallManifestResult:
    """
    Provides access to available platform versions in a location for a given project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    manifest = gcp.container.get_attached_install_manifest(location="us-west1",
        project="my-project",
        cluster_id="test-cluster-1",
        platform_version="1.25.0-gke.1")
    pulumi.export("installManifest", manifest)
    ```


    :param str cluster_id: The name that will be used when creating the attached cluster resource.
    :param str location: The location to list versions for.
    :param str platform_version: The platform version for the cluster. A list of valid values can be retrieved using the `container.get_attached_versions` data source.
    :param str project: ID of the project to list available platform versions for. Should match the project the cluster will be deployed to.
           Defaults to the project that the provider is authenticated with.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['location'] = location
    __args__['platformVersion'] = platform_version
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:container/getAttachedInstallManifest:getAttachedInstallManifest', __args__, opts=opts, typ=GetAttachedInstallManifestResult).value

    return AwaitableGetAttachedInstallManifestResult(
        cluster_id=__ret__.cluster_id,
        id=__ret__.id,
        location=__ret__.location,
        manifest=__ret__.manifest,
        platform_version=__ret__.platform_version,
        project=__ret__.project)


@_utilities.lift_output_func(get_attached_install_manifest)
def get_attached_install_manifest_output(cluster_id: Optional[pulumi.Input[str]] = None,
                                         location: Optional[pulumi.Input[str]] = None,
                                         platform_version: Optional[pulumi.Input[str]] = None,
                                         project: Optional[pulumi.Input[str]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAttachedInstallManifestResult]:
    """
    Provides access to available platform versions in a location for a given project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    manifest = gcp.container.get_attached_install_manifest(location="us-west1",
        project="my-project",
        cluster_id="test-cluster-1",
        platform_version="1.25.0-gke.1")
    pulumi.export("installManifest", manifest)
    ```


    :param str cluster_id: The name that will be used when creating the attached cluster resource.
    :param str location: The location to list versions for.
    :param str platform_version: The platform version for the cluster. A list of valid values can be retrieved using the `container.get_attached_versions` data source.
    :param str project: ID of the project to list available platform versions for. Should match the project the cluster will be deployed to.
           Defaults to the project that the provider is authenticated with.
    """
    ...
