# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodePoolArgs', 'NodePool']

@pulumi.input_type
class NodePoolArgs:
    def __init__(__self__, *,
                 cluster: pulumi.Input[str],
                 autoscaling: Optional[pulumi.Input['NodePoolAutoscalingArgs']] = None,
                 initial_node_count: Optional[pulumi.Input[int]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 management: Optional[pulumi.Input['NodePoolManagementArgs']] = None,
                 max_pods_per_node: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 network_config: Optional[pulumi.Input['NodePoolNetworkConfigArgs']] = None,
                 node_config: Optional[pulumi.Input['NodePoolNodeConfigArgs']] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 node_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 placement_policy: Optional[pulumi.Input['NodePoolPlacementPolicyArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 upgrade_settings: Optional[pulumi.Input['NodePoolUpgradeSettingsArgs']] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NodePool resource.
        :param pulumi.Input[str] cluster: The cluster to create the node pool for. Cluster must be present in `location` provided for clusters. May be specified in the format `projects/{{project}}/locations/{{location}}/clusters/{{cluster}}` or as just the name of the cluster.
        :param pulumi.Input['NodePoolAutoscalingArgs'] autoscaling: Configuration required by cluster autoscaler to adjust
               the size of the node pool to the current cluster usage. Structure is documented below.
        :param pulumi.Input[int] initial_node_count: The initial number of nodes for the pool. In
               regional or multi-zonal clusters, this is the number of nodes per zone. Changing
               this will force recreation of the resource. WARNING: Resizing your node pool manually
               may change this value in your existing cluster, which will trigger destruction
               and recreation on the next provider run (to rectify the discrepancy).  If you don't
               need this value, don't set it.  If you do need it, you can use a lifecycle block to
               ignore subsqeuent changes to this field.
        :param pulumi.Input[str] location: The location (region or zone) of the cluster.
        :param pulumi.Input['NodePoolManagementArgs'] management: Node management configuration, wherein auto-repair and
               auto-upgrade is configured. Structure is documented below.
        :param pulumi.Input[int] max_pods_per_node: The maximum number of pods per node in this node pool.
               Note that this does not work on node pools which are "route-based" - that is, node
               pools belonging to clusters that do not have IP Aliasing enabled.
               See the [official documentation](https://cloud.google.com/kubernetes-engine/docs/how-to/flexible-pod-cidr)
               for more information.
        :param pulumi.Input[str] name: The name of the node pool. If left blank, the provider will
               auto-generate a unique name.
        :param pulumi.Input[str] name_prefix: Creates a unique name for the node pool beginning
               with the specified prefix. Conflicts with `name`.
        :param pulumi.Input['NodePoolNetworkConfigArgs'] network_config: The network configuration of the pool. Such as
               configuration for [Adding Pod IP address ranges](https://cloud.google.com/kubernetes-engine/docs/how-to/multi-pod-cidr)) to the node pool. Or enabling private nodes. Structure is
               documented below
        :param pulumi.Input['NodePoolNodeConfigArgs'] node_config: Parameters used in creating the node pool. See
               container.Cluster for schema.
        :param pulumi.Input[int] node_count: The number of nodes per instance group. This field can be used to
               update the number of nodes per instance group but should not be used alongside `autoscaling`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_locations: The list of zones in which the node pool's nodes should be located. Nodes must
               be in the region of their regional cluster or in the same region as their
               cluster's zone for zonal clusters. If unspecified, the cluster-level
               `node_locations` will be used.
        :param pulumi.Input['NodePoolPlacementPolicyArgs'] placement_policy: Specifies a custom placement policy for the
               nodes.
        :param pulumi.Input[str] project: The ID of the project in which to create the node pool. If blank,
               the provider-configured project will be used.
        :param pulumi.Input['NodePoolUpgradeSettingsArgs'] upgrade_settings: Specify node upgrade settings to change how GKE upgrades nodes.
               The maximum number of nodes upgraded simultaneously is limited to 20. Structure is documented below.
        :param pulumi.Input[str] version: The Kubernetes version for the nodes in this pool. Note that if this field
               and `auto_upgrade` are both specified, they will fight each other for what the node version should
               be, so setting both is highly discouraged. While a fuzzy version can be specified, it's
               recommended that you specify explicit versions as the provider will see spurious diffs
               when fuzzy versions are used. See the `container.get_engine_versions` data source's
               `version_prefix` field to approximate fuzzy versions in a provider-compatible way.
        """
        pulumi.set(__self__, "cluster", cluster)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if initial_node_count is not None:
            pulumi.set(__self__, "initial_node_count", initial_node_count)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if management is not None:
            pulumi.set(__self__, "management", management)
        if max_pods_per_node is not None:
            pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_locations is not None:
            pulumi.set(__self__, "node_locations", node_locations)
        if placement_policy is not None:
            pulumi.set(__self__, "placement_policy", placement_policy)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if upgrade_settings is not None:
            pulumi.set(__self__, "upgrade_settings", upgrade_settings)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[str]:
        """
        The cluster to create the node pool for. Cluster must be present in `location` provided for clusters. May be specified in the format `projects/{{project}}/locations/{{location}}/clusters/{{cluster}}` or as just the name of the cluster.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional[pulumi.Input['NodePoolAutoscalingArgs']]:
        """
        Configuration required by cluster autoscaler to adjust
        the size of the node pool to the current cluster usage. Structure is documented below.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: Optional[pulumi.Input['NodePoolAutoscalingArgs']]):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The initial number of nodes for the pool. In
        regional or multi-zonal clusters, this is the number of nodes per zone. Changing
        this will force recreation of the resource. WARNING: Resizing your node pool manually
        may change this value in your existing cluster, which will trigger destruction
        and recreation on the next provider run (to rectify the discrepancy).  If you don't
        need this value, don't set it.  If you do need it, you can use a lifecycle block to
        ignore subsqeuent changes to this field.
        """
        return pulumi.get(self, "initial_node_count")

    @initial_node_count.setter
    def initial_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_node_count", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location (region or zone) of the cluster.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def management(self) -> Optional[pulumi.Input['NodePoolManagementArgs']]:
        """
        Node management configuration, wherein auto-repair and
        auto-upgrade is configured. Structure is documented below.
        """
        return pulumi.get(self, "management")

    @management.setter
    def management(self, value: Optional[pulumi.Input['NodePoolManagementArgs']]):
        pulumi.set(self, "management", value)

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of pods per node in this node pool.
        Note that this does not work on node pools which are "route-based" - that is, node
        pools belonging to clusters that do not have IP Aliasing enabled.
        See the [official documentation](https://cloud.google.com/kubernetes-engine/docs/how-to/flexible-pod-cidr)
        for more information.
        """
        return pulumi.get(self, "max_pods_per_node")

    @max_pods_per_node.setter
    def max_pods_per_node(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods_per_node", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the node pool. If left blank, the provider will
        auto-generate a unique name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique name for the node pool beginning
        with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['NodePoolNetworkConfigArgs']]:
        """
        The network configuration of the pool. Such as
        configuration for [Adding Pod IP address ranges](https://cloud.google.com/kubernetes-engine/docs/how-to/multi-pod-cidr)) to the node pool. Or enabling private nodes. Structure is
        documented below
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['NodePoolNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['NodePoolNodeConfigArgs']]:
        """
        Parameters used in creating the node pool. See
        container.Cluster for schema.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['NodePoolNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes per instance group. This field can be used to
        update the number of nodes per instance group but should not be used alongside `autoscaling`.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeLocations")
    def node_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of zones in which the node pool's nodes should be located. Nodes must
        be in the region of their regional cluster or in the same region as their
        cluster's zone for zonal clusters. If unspecified, the cluster-level
        `node_locations` will be used.
        """
        return pulumi.get(self, "node_locations")

    @node_locations.setter
    def node_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_locations", value)

    @property
    @pulumi.getter(name="placementPolicy")
    def placement_policy(self) -> Optional[pulumi.Input['NodePoolPlacementPolicyArgs']]:
        """
        Specifies a custom placement policy for the
        nodes.
        """
        return pulumi.get(self, "placement_policy")

    @placement_policy.setter
    def placement_policy(self, value: Optional[pulumi.Input['NodePoolPlacementPolicyArgs']]):
        pulumi.set(self, "placement_policy", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which to create the node pool. If blank,
        the provider-configured project will be used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> Optional[pulumi.Input['NodePoolUpgradeSettingsArgs']]:
        """
        Specify node upgrade settings to change how GKE upgrades nodes.
        The maximum number of nodes upgraded simultaneously is limited to 20. Structure is documented below.
        """
        return pulumi.get(self, "upgrade_settings")

    @upgrade_settings.setter
    def upgrade_settings(self, value: Optional[pulumi.Input['NodePoolUpgradeSettingsArgs']]):
        pulumi.set(self, "upgrade_settings", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The Kubernetes version for the nodes in this pool. Note that if this field
        and `auto_upgrade` are both specified, they will fight each other for what the node version should
        be, so setting both is highly discouraged. While a fuzzy version can be specified, it's
        recommended that you specify explicit versions as the provider will see spurious diffs
        when fuzzy versions are used. See the `container.get_engine_versions` data source's
        `version_prefix` field to approximate fuzzy versions in a provider-compatible way.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _NodePoolState:
    def __init__(__self__, *,
                 autoscaling: Optional[pulumi.Input['NodePoolAutoscalingArgs']] = None,
                 cluster: Optional[pulumi.Input[str]] = None,
                 initial_node_count: Optional[pulumi.Input[int]] = None,
                 instance_group_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 managed_instance_group_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 management: Optional[pulumi.Input['NodePoolManagementArgs']] = None,
                 max_pods_per_node: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 network_config: Optional[pulumi.Input['NodePoolNetworkConfigArgs']] = None,
                 node_config: Optional[pulumi.Input['NodePoolNodeConfigArgs']] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 node_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 operation: Optional[pulumi.Input[str]] = None,
                 placement_policy: Optional[pulumi.Input['NodePoolPlacementPolicyArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 upgrade_settings: Optional[pulumi.Input['NodePoolUpgradeSettingsArgs']] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NodePool resources.
        :param pulumi.Input['NodePoolAutoscalingArgs'] autoscaling: Configuration required by cluster autoscaler to adjust
               the size of the node pool to the current cluster usage. Structure is documented below.
        :param pulumi.Input[str] cluster: The cluster to create the node pool for. Cluster must be present in `location` provided for clusters. May be specified in the format `projects/{{project}}/locations/{{location}}/clusters/{{cluster}}` or as just the name of the cluster.
        :param pulumi.Input[int] initial_node_count: The initial number of nodes for the pool. In
               regional or multi-zonal clusters, this is the number of nodes per zone. Changing
               this will force recreation of the resource. WARNING: Resizing your node pool manually
               may change this value in your existing cluster, which will trigger destruction
               and recreation on the next provider run (to rectify the discrepancy).  If you don't
               need this value, don't set it.  If you do need it, you can use a lifecycle block to
               ignore subsqeuent changes to this field.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_group_urls: The resource URLs of the managed instance groups associated with this node pool.
        :param pulumi.Input[str] location: The location (region or zone) of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] managed_instance_group_urls: List of instance group URLs which have been assigned to this node pool.
        :param pulumi.Input['NodePoolManagementArgs'] management: Node management configuration, wherein auto-repair and
               auto-upgrade is configured. Structure is documented below.
        :param pulumi.Input[int] max_pods_per_node: The maximum number of pods per node in this node pool.
               Note that this does not work on node pools which are "route-based" - that is, node
               pools belonging to clusters that do not have IP Aliasing enabled.
               See the [official documentation](https://cloud.google.com/kubernetes-engine/docs/how-to/flexible-pod-cidr)
               for more information.
        :param pulumi.Input[str] name: The name of the node pool. If left blank, the provider will
               auto-generate a unique name.
        :param pulumi.Input[str] name_prefix: Creates a unique name for the node pool beginning
               with the specified prefix. Conflicts with `name`.
        :param pulumi.Input['NodePoolNetworkConfigArgs'] network_config: The network configuration of the pool. Such as
               configuration for [Adding Pod IP address ranges](https://cloud.google.com/kubernetes-engine/docs/how-to/multi-pod-cidr)) to the node pool. Or enabling private nodes. Structure is
               documented below
        :param pulumi.Input['NodePoolNodeConfigArgs'] node_config: Parameters used in creating the node pool. See
               container.Cluster for schema.
        :param pulumi.Input[int] node_count: The number of nodes per instance group. This field can be used to
               update the number of nodes per instance group but should not be used alongside `autoscaling`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_locations: The list of zones in which the node pool's nodes should be located. Nodes must
               be in the region of their regional cluster or in the same region as their
               cluster's zone for zonal clusters. If unspecified, the cluster-level
               `node_locations` will be used.
        :param pulumi.Input['NodePoolPlacementPolicyArgs'] placement_policy: Specifies a custom placement policy for the
               nodes.
        :param pulumi.Input[str] project: The ID of the project in which to create the node pool. If blank,
               the provider-configured project will be used.
        :param pulumi.Input['NodePoolUpgradeSettingsArgs'] upgrade_settings: Specify node upgrade settings to change how GKE upgrades nodes.
               The maximum number of nodes upgraded simultaneously is limited to 20. Structure is documented below.
        :param pulumi.Input[str] version: The Kubernetes version for the nodes in this pool. Note that if this field
               and `auto_upgrade` are both specified, they will fight each other for what the node version should
               be, so setting both is highly discouraged. While a fuzzy version can be specified, it's
               recommended that you specify explicit versions as the provider will see spurious diffs
               when fuzzy versions are used. See the `container.get_engine_versions` data source's
               `version_prefix` field to approximate fuzzy versions in a provider-compatible way.
        """
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if initial_node_count is not None:
            pulumi.set(__self__, "initial_node_count", initial_node_count)
        if instance_group_urls is not None:
            pulumi.set(__self__, "instance_group_urls", instance_group_urls)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_instance_group_urls is not None:
            pulumi.set(__self__, "managed_instance_group_urls", managed_instance_group_urls)
        if management is not None:
            pulumi.set(__self__, "management", management)
        if max_pods_per_node is not None:
            pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if node_locations is not None:
            pulumi.set(__self__, "node_locations", node_locations)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if placement_policy is not None:
            pulumi.set(__self__, "placement_policy", placement_policy)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if upgrade_settings is not None:
            pulumi.set(__self__, "upgrade_settings", upgrade_settings)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional[pulumi.Input['NodePoolAutoscalingArgs']]:
        """
        Configuration required by cluster autoscaler to adjust
        the size of the node pool to the current cluster usage. Structure is documented below.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: Optional[pulumi.Input['NodePoolAutoscalingArgs']]):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster to create the node pool for. Cluster must be present in `location` provided for clusters. May be specified in the format `projects/{{project}}/locations/{{location}}/clusters/{{cluster}}` or as just the name of the cluster.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The initial number of nodes for the pool. In
        regional or multi-zonal clusters, this is the number of nodes per zone. Changing
        this will force recreation of the resource. WARNING: Resizing your node pool manually
        may change this value in your existing cluster, which will trigger destruction
        and recreation on the next provider run (to rectify the discrepancy).  If you don't
        need this value, don't set it.  If you do need it, you can use a lifecycle block to
        ignore subsqeuent changes to this field.
        """
        return pulumi.get(self, "initial_node_count")

    @initial_node_count.setter
    def initial_node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initial_node_count", value)

    @property
    @pulumi.getter(name="instanceGroupUrls")
    def instance_group_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The resource URLs of the managed instance groups associated with this node pool.
        """
        return pulumi.get(self, "instance_group_urls")

    @instance_group_urls.setter
    def instance_group_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_group_urls", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location (region or zone) of the cluster.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="managedInstanceGroupUrls")
    def managed_instance_group_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of instance group URLs which have been assigned to this node pool.
        """
        return pulumi.get(self, "managed_instance_group_urls")

    @managed_instance_group_urls.setter
    def managed_instance_group_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "managed_instance_group_urls", value)

    @property
    @pulumi.getter
    def management(self) -> Optional[pulumi.Input['NodePoolManagementArgs']]:
        """
        Node management configuration, wherein auto-repair and
        auto-upgrade is configured. Structure is documented below.
        """
        return pulumi.get(self, "management")

    @management.setter
    def management(self, value: Optional[pulumi.Input['NodePoolManagementArgs']]):
        pulumi.set(self, "management", value)

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of pods per node in this node pool.
        Note that this does not work on node pools which are "route-based" - that is, node
        pools belonging to clusters that do not have IP Aliasing enabled.
        See the [official documentation](https://cloud.google.com/kubernetes-engine/docs/how-to/flexible-pod-cidr)
        for more information.
        """
        return pulumi.get(self, "max_pods_per_node")

    @max_pods_per_node.setter
    def max_pods_per_node(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods_per_node", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the node pool. If left blank, the provider will
        auto-generate a unique name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique name for the node pool beginning
        with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['NodePoolNetworkConfigArgs']]:
        """
        The network configuration of the pool. Such as
        configuration for [Adding Pod IP address ranges](https://cloud.google.com/kubernetes-engine/docs/how-to/multi-pod-cidr)) to the node pool. Or enabling private nodes. Structure is
        documented below
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['NodePoolNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['NodePoolNodeConfigArgs']]:
        """
        Parameters used in creating the node pool. See
        container.Cluster for schema.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['NodePoolNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes per instance group. This field can be used to
        update the number of nodes per instance group but should not be used alongside `autoscaling`.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeLocations")
    def node_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of zones in which the node pool's nodes should be located. Nodes must
        be in the region of their regional cluster or in the same region as their
        cluster's zone for zonal clusters. If unspecified, the cluster-level
        `node_locations` will be used.
        """
        return pulumi.get(self, "node_locations")

    @node_locations.setter
    def node_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_locations", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter(name="placementPolicy")
    def placement_policy(self) -> Optional[pulumi.Input['NodePoolPlacementPolicyArgs']]:
        """
        Specifies a custom placement policy for the
        nodes.
        """
        return pulumi.get(self, "placement_policy")

    @placement_policy.setter
    def placement_policy(self, value: Optional[pulumi.Input['NodePoolPlacementPolicyArgs']]):
        pulumi.set(self, "placement_policy", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which to create the node pool. If blank,
        the provider-configured project will be used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> Optional[pulumi.Input['NodePoolUpgradeSettingsArgs']]:
        """
        Specify node upgrade settings to change how GKE upgrades nodes.
        The maximum number of nodes upgraded simultaneously is limited to 20. Structure is documented below.
        """
        return pulumi.get(self, "upgrade_settings")

    @upgrade_settings.setter
    def upgrade_settings(self, value: Optional[pulumi.Input['NodePoolUpgradeSettingsArgs']]):
        pulumi.set(self, "upgrade_settings", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The Kubernetes version for the nodes in this pool. Note that if this field
        and `auto_upgrade` are both specified, they will fight each other for what the node version should
        be, so setting both is highly discouraged. While a fuzzy version can be specified, it's
        recommended that you specify explicit versions as the provider will see spurious diffs
        when fuzzy versions are used. See the `container.get_engine_versions` data source's
        `version_prefix` field to approximate fuzzy versions in a provider-compatible way.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class NodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscaling: Optional[pulumi.Input[pulumi.InputType['NodePoolAutoscalingArgs']]] = None,
                 cluster: Optional[pulumi.Input[str]] = None,
                 initial_node_count: Optional[pulumi.Input[int]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 management: Optional[pulumi.Input[pulumi.InputType['NodePoolManagementArgs']]] = None,
                 max_pods_per_node: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 network_config: Optional[pulumi.Input[pulumi.InputType['NodePoolNetworkConfigArgs']]] = None,
                 node_config: Optional[pulumi.Input[pulumi.InputType['NodePoolNodeConfigArgs']]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 node_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 placement_policy: Optional[pulumi.Input[pulumi.InputType['NodePoolPlacementPolicyArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 upgrade_settings: Optional[pulumi.Input[pulumi.InputType['NodePoolUpgradeSettingsArgs']]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a node pool in a Google Kubernetes Engine (GKE) cluster separately from
        the cluster control plane. For more information see [the official documentation](https://cloud.google.com/container-engine/docs/node-pools)
        and [the API reference](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1beta1/projects.locations.clusters.nodePools).

        ## Example Usage
        ### Using A Separately Managed Node Pool (Recommended)

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.service_account.Account("default",
            account_id="service-account-id",
            display_name="Service Account")
        primary = gcp.container.Cluster("primary",
            location="us-central1",
            remove_default_node_pool=True,
            initial_node_count=1)
        primary_preemptible_nodes = gcp.container.NodePool("primaryPreemptibleNodes",
            cluster=primary.id,
            node_count=1,
            node_config=gcp.container.NodePoolNodeConfigArgs(
                preemptible=True,
                machine_type="e2-medium",
                service_account=default.email,
                oauth_scopes=["https://www.googleapis.com/auth/cloud-platform"],
            ))
        ```

        ## Import

        Node pools can be imported using the `project`, `location`, `cluster` and `name`. If the project is omitted, the project value in the provider configuration will be used. Examples

        ```sh
         $ pulumi import gcp:container/nodePool:NodePool mainpool my-gcp-project/us-east1-a/my-cluster/main-pool
        ```

        ```sh
         $ pulumi import gcp:container/nodePool:NodePool mainpool us-east1/my-cluster/main-pool
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['NodePoolAutoscalingArgs']] autoscaling: Configuration required by cluster autoscaler to adjust
               the size of the node pool to the current cluster usage. Structure is documented below.
        :param pulumi.Input[str] cluster: The cluster to create the node pool for. Cluster must be present in `location` provided for clusters. May be specified in the format `projects/{{project}}/locations/{{location}}/clusters/{{cluster}}` or as just the name of the cluster.
        :param pulumi.Input[int] initial_node_count: The initial number of nodes for the pool. In
               regional or multi-zonal clusters, this is the number of nodes per zone. Changing
               this will force recreation of the resource. WARNING: Resizing your node pool manually
               may change this value in your existing cluster, which will trigger destruction
               and recreation on the next provider run (to rectify the discrepancy).  If you don't
               need this value, don't set it.  If you do need it, you can use a lifecycle block to
               ignore subsqeuent changes to this field.
        :param pulumi.Input[str] location: The location (region or zone) of the cluster.
        :param pulumi.Input[pulumi.InputType['NodePoolManagementArgs']] management: Node management configuration, wherein auto-repair and
               auto-upgrade is configured. Structure is documented below.
        :param pulumi.Input[int] max_pods_per_node: The maximum number of pods per node in this node pool.
               Note that this does not work on node pools which are "route-based" - that is, node
               pools belonging to clusters that do not have IP Aliasing enabled.
               See the [official documentation](https://cloud.google.com/kubernetes-engine/docs/how-to/flexible-pod-cidr)
               for more information.
        :param pulumi.Input[str] name: The name of the node pool. If left blank, the provider will
               auto-generate a unique name.
        :param pulumi.Input[str] name_prefix: Creates a unique name for the node pool beginning
               with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[pulumi.InputType['NodePoolNetworkConfigArgs']] network_config: The network configuration of the pool. Such as
               configuration for [Adding Pod IP address ranges](https://cloud.google.com/kubernetes-engine/docs/how-to/multi-pod-cidr)) to the node pool. Or enabling private nodes. Structure is
               documented below
        :param pulumi.Input[pulumi.InputType['NodePoolNodeConfigArgs']] node_config: Parameters used in creating the node pool. See
               container.Cluster for schema.
        :param pulumi.Input[int] node_count: The number of nodes per instance group. This field can be used to
               update the number of nodes per instance group but should not be used alongside `autoscaling`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_locations: The list of zones in which the node pool's nodes should be located. Nodes must
               be in the region of their regional cluster or in the same region as their
               cluster's zone for zonal clusters. If unspecified, the cluster-level
               `node_locations` will be used.
        :param pulumi.Input[pulumi.InputType['NodePoolPlacementPolicyArgs']] placement_policy: Specifies a custom placement policy for the
               nodes.
        :param pulumi.Input[str] project: The ID of the project in which to create the node pool. If blank,
               the provider-configured project will be used.
        :param pulumi.Input[pulumi.InputType['NodePoolUpgradeSettingsArgs']] upgrade_settings: Specify node upgrade settings to change how GKE upgrades nodes.
               The maximum number of nodes upgraded simultaneously is limited to 20. Structure is documented below.
        :param pulumi.Input[str] version: The Kubernetes version for the nodes in this pool. Note that if this field
               and `auto_upgrade` are both specified, they will fight each other for what the node version should
               be, so setting both is highly discouraged. While a fuzzy version can be specified, it's
               recommended that you specify explicit versions as the provider will see spurious diffs
               when fuzzy versions are used. See the `container.get_engine_versions` data source's
               `version_prefix` field to approximate fuzzy versions in a provider-compatible way.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a node pool in a Google Kubernetes Engine (GKE) cluster separately from
        the cluster control plane. For more information see [the official documentation](https://cloud.google.com/container-engine/docs/node-pools)
        and [the API reference](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1beta1/projects.locations.clusters.nodePools).

        ## Example Usage
        ### Using A Separately Managed Node Pool (Recommended)

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.service_account.Account("default",
            account_id="service-account-id",
            display_name="Service Account")
        primary = gcp.container.Cluster("primary",
            location="us-central1",
            remove_default_node_pool=True,
            initial_node_count=1)
        primary_preemptible_nodes = gcp.container.NodePool("primaryPreemptibleNodes",
            cluster=primary.id,
            node_count=1,
            node_config=gcp.container.NodePoolNodeConfigArgs(
                preemptible=True,
                machine_type="e2-medium",
                service_account=default.email,
                oauth_scopes=["https://www.googleapis.com/auth/cloud-platform"],
            ))
        ```

        ## Import

        Node pools can be imported using the `project`, `location`, `cluster` and `name`. If the project is omitted, the project value in the provider configuration will be used. Examples

        ```sh
         $ pulumi import gcp:container/nodePool:NodePool mainpool my-gcp-project/us-east1-a/my-cluster/main-pool
        ```

        ```sh
         $ pulumi import gcp:container/nodePool:NodePool mainpool us-east1/my-cluster/main-pool
        ```

        :param str resource_name: The name of the resource.
        :param NodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscaling: Optional[pulumi.Input[pulumi.InputType['NodePoolAutoscalingArgs']]] = None,
                 cluster: Optional[pulumi.Input[str]] = None,
                 initial_node_count: Optional[pulumi.Input[int]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 management: Optional[pulumi.Input[pulumi.InputType['NodePoolManagementArgs']]] = None,
                 max_pods_per_node: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 network_config: Optional[pulumi.Input[pulumi.InputType['NodePoolNetworkConfigArgs']]] = None,
                 node_config: Optional[pulumi.Input[pulumi.InputType['NodePoolNodeConfigArgs']]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 node_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 placement_policy: Optional[pulumi.Input[pulumi.InputType['NodePoolPlacementPolicyArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 upgrade_settings: Optional[pulumi.Input[pulumi.InputType['NodePoolUpgradeSettingsArgs']]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodePoolArgs.__new__(NodePoolArgs)

            __props__.__dict__["autoscaling"] = autoscaling
            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["initial_node_count"] = initial_node_count
            __props__.__dict__["location"] = location
            __props__.__dict__["management"] = management
            __props__.__dict__["max_pods_per_node"] = max_pods_per_node
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["network_config"] = network_config
            __props__.__dict__["node_config"] = node_config
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["node_locations"] = node_locations
            __props__.__dict__["placement_policy"] = placement_policy
            __props__.__dict__["project"] = project
            __props__.__dict__["upgrade_settings"] = upgrade_settings
            __props__.__dict__["version"] = version
            __props__.__dict__["instance_group_urls"] = None
            __props__.__dict__["managed_instance_group_urls"] = None
            __props__.__dict__["operation"] = None
        super(NodePool, __self__).__init__(
            'gcp:container/nodePool:NodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autoscaling: Optional[pulumi.Input[pulumi.InputType['NodePoolAutoscalingArgs']]] = None,
            cluster: Optional[pulumi.Input[str]] = None,
            initial_node_count: Optional[pulumi.Input[int]] = None,
            instance_group_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            managed_instance_group_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            management: Optional[pulumi.Input[pulumi.InputType['NodePoolManagementArgs']]] = None,
            max_pods_per_node: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_prefix: Optional[pulumi.Input[str]] = None,
            network_config: Optional[pulumi.Input[pulumi.InputType['NodePoolNetworkConfigArgs']]] = None,
            node_config: Optional[pulumi.Input[pulumi.InputType['NodePoolNodeConfigArgs']]] = None,
            node_count: Optional[pulumi.Input[int]] = None,
            node_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            operation: Optional[pulumi.Input[str]] = None,
            placement_policy: Optional[pulumi.Input[pulumi.InputType['NodePoolPlacementPolicyArgs']]] = None,
            project: Optional[pulumi.Input[str]] = None,
            upgrade_settings: Optional[pulumi.Input[pulumi.InputType['NodePoolUpgradeSettingsArgs']]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'NodePool':
        """
        Get an existing NodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['NodePoolAutoscalingArgs']] autoscaling: Configuration required by cluster autoscaler to adjust
               the size of the node pool to the current cluster usage. Structure is documented below.
        :param pulumi.Input[str] cluster: The cluster to create the node pool for. Cluster must be present in `location` provided for clusters. May be specified in the format `projects/{{project}}/locations/{{location}}/clusters/{{cluster}}` or as just the name of the cluster.
        :param pulumi.Input[int] initial_node_count: The initial number of nodes for the pool. In
               regional or multi-zonal clusters, this is the number of nodes per zone. Changing
               this will force recreation of the resource. WARNING: Resizing your node pool manually
               may change this value in your existing cluster, which will trigger destruction
               and recreation on the next provider run (to rectify the discrepancy).  If you don't
               need this value, don't set it.  If you do need it, you can use a lifecycle block to
               ignore subsqeuent changes to this field.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_group_urls: The resource URLs of the managed instance groups associated with this node pool.
        :param pulumi.Input[str] location: The location (region or zone) of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] managed_instance_group_urls: List of instance group URLs which have been assigned to this node pool.
        :param pulumi.Input[pulumi.InputType['NodePoolManagementArgs']] management: Node management configuration, wherein auto-repair and
               auto-upgrade is configured. Structure is documented below.
        :param pulumi.Input[int] max_pods_per_node: The maximum number of pods per node in this node pool.
               Note that this does not work on node pools which are "route-based" - that is, node
               pools belonging to clusters that do not have IP Aliasing enabled.
               See the [official documentation](https://cloud.google.com/kubernetes-engine/docs/how-to/flexible-pod-cidr)
               for more information.
        :param pulumi.Input[str] name: The name of the node pool. If left blank, the provider will
               auto-generate a unique name.
        :param pulumi.Input[str] name_prefix: Creates a unique name for the node pool beginning
               with the specified prefix. Conflicts with `name`.
        :param pulumi.Input[pulumi.InputType['NodePoolNetworkConfigArgs']] network_config: The network configuration of the pool. Such as
               configuration for [Adding Pod IP address ranges](https://cloud.google.com/kubernetes-engine/docs/how-to/multi-pod-cidr)) to the node pool. Or enabling private nodes. Structure is
               documented below
        :param pulumi.Input[pulumi.InputType['NodePoolNodeConfigArgs']] node_config: Parameters used in creating the node pool. See
               container.Cluster for schema.
        :param pulumi.Input[int] node_count: The number of nodes per instance group. This field can be used to
               update the number of nodes per instance group but should not be used alongside `autoscaling`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_locations: The list of zones in which the node pool's nodes should be located. Nodes must
               be in the region of their regional cluster or in the same region as their
               cluster's zone for zonal clusters. If unspecified, the cluster-level
               `node_locations` will be used.
        :param pulumi.Input[pulumi.InputType['NodePoolPlacementPolicyArgs']] placement_policy: Specifies a custom placement policy for the
               nodes.
        :param pulumi.Input[str] project: The ID of the project in which to create the node pool. If blank,
               the provider-configured project will be used.
        :param pulumi.Input[pulumi.InputType['NodePoolUpgradeSettingsArgs']] upgrade_settings: Specify node upgrade settings to change how GKE upgrades nodes.
               The maximum number of nodes upgraded simultaneously is limited to 20. Structure is documented below.
        :param pulumi.Input[str] version: The Kubernetes version for the nodes in this pool. Note that if this field
               and `auto_upgrade` are both specified, they will fight each other for what the node version should
               be, so setting both is highly discouraged. While a fuzzy version can be specified, it's
               recommended that you specify explicit versions as the provider will see spurious diffs
               when fuzzy versions are used. See the `container.get_engine_versions` data source's
               `version_prefix` field to approximate fuzzy versions in a provider-compatible way.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodePoolState.__new__(_NodePoolState)

        __props__.__dict__["autoscaling"] = autoscaling
        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["initial_node_count"] = initial_node_count
        __props__.__dict__["instance_group_urls"] = instance_group_urls
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_instance_group_urls"] = managed_instance_group_urls
        __props__.__dict__["management"] = management
        __props__.__dict__["max_pods_per_node"] = max_pods_per_node
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["network_config"] = network_config
        __props__.__dict__["node_config"] = node_config
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["node_locations"] = node_locations
        __props__.__dict__["operation"] = operation
        __props__.__dict__["placement_policy"] = placement_policy
        __props__.__dict__["project"] = project
        __props__.__dict__["upgrade_settings"] = upgrade_settings
        __props__.__dict__["version"] = version
        return NodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def autoscaling(self) -> pulumi.Output[Optional['outputs.NodePoolAutoscaling']]:
        """
        Configuration required by cluster autoscaler to adjust
        the size of the node pool to the current cluster usage. Structure is documented below.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[str]:
        """
        The cluster to create the node pool for. Cluster must be present in `location` provided for clusters. May be specified in the format `projects/{{project}}/locations/{{location}}/clusters/{{cluster}}` or as just the name of the cluster.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> pulumi.Output[int]:
        """
        The initial number of nodes for the pool. In
        regional or multi-zonal clusters, this is the number of nodes per zone. Changing
        this will force recreation of the resource. WARNING: Resizing your node pool manually
        may change this value in your existing cluster, which will trigger destruction
        and recreation on the next provider run (to rectify the discrepancy).  If you don't
        need this value, don't set it.  If you do need it, you can use a lifecycle block to
        ignore subsqeuent changes to this field.
        """
        return pulumi.get(self, "initial_node_count")

    @property
    @pulumi.getter(name="instanceGroupUrls")
    def instance_group_urls(self) -> pulumi.Output[Sequence[str]]:
        """
        The resource URLs of the managed instance groups associated with this node pool.
        """
        return pulumi.get(self, "instance_group_urls")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location (region or zone) of the cluster.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="managedInstanceGroupUrls")
    def managed_instance_group_urls(self) -> pulumi.Output[Sequence[str]]:
        """
        List of instance group URLs which have been assigned to this node pool.
        """
        return pulumi.get(self, "managed_instance_group_urls")

    @property
    @pulumi.getter
    def management(self) -> pulumi.Output['outputs.NodePoolManagement']:
        """
        Node management configuration, wherein auto-repair and
        auto-upgrade is configured. Structure is documented below.
        """
        return pulumi.get(self, "management")

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> pulumi.Output[int]:
        """
        The maximum number of pods per node in this node pool.
        Note that this does not work on node pools which are "route-based" - that is, node
        pools belonging to clusters that do not have IP Aliasing enabled.
        See the [official documentation](https://cloud.google.com/kubernetes-engine/docs/how-to/flexible-pod-cidr)
        for more information.
        """
        return pulumi.get(self, "max_pods_per_node")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the node pool. If left blank, the provider will
        auto-generate a unique name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[str]:
        """
        Creates a unique name for the node pool beginning
        with the specified prefix. Conflicts with `name`.
        """
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> pulumi.Output['outputs.NodePoolNetworkConfig']:
        """
        The network configuration of the pool. Such as
        configuration for [Adding Pod IP address ranges](https://cloud.google.com/kubernetes-engine/docs/how-to/multi-pod-cidr)) to the node pool. Or enabling private nodes. Structure is
        documented below
        """
        return pulumi.get(self, "network_config")

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> pulumi.Output['outputs.NodePoolNodeConfig']:
        """
        Parameters used in creating the node pool. See
        container.Cluster for schema.
        """
        return pulumi.get(self, "node_config")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[int]:
        """
        The number of nodes per instance group. This field can be used to
        update the number of nodes per instance group but should not be used alongside `autoscaling`.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeLocations")
    def node_locations(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of zones in which the node pool's nodes should be located. Nodes must
        be in the region of their regional cluster or in the same region as their
        cluster's zone for zonal clusters. If unspecified, the cluster-level
        `node_locations` will be used.
        """
        return pulumi.get(self, "node_locations")

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Output[str]:
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter(name="placementPolicy")
    def placement_policy(self) -> pulumi.Output[Optional['outputs.NodePoolPlacementPolicy']]:
        """
        Specifies a custom placement policy for the
        nodes.
        """
        return pulumi.get(self, "placement_policy")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which to create the node pool. If blank,
        the provider-configured project will be used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> pulumi.Output['outputs.NodePoolUpgradeSettings']:
        """
        Specify node upgrade settings to change how GKE upgrades nodes.
        The maximum number of nodes upgraded simultaneously is limited to 20. Structure is documented below.
        """
        return pulumi.get(self, "upgrade_settings")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The Kubernetes version for the nodes in this pool. Note that if this field
        and `auto_upgrade` are both specified, they will fight each other for what the node version should
        be, so setting both is highly discouraged. While a fuzzy version can be specified, it's
        recommended that you specify explicit versions as the provider will see spurious diffs
        when fuzzy versions are used. See the `container.get_engine_versions` data source's
        `version_prefix` field to approximate fuzzy versions in a provider-compatible way.
        """
        return pulumi.get(self, "version")

