# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StreamArgs', 'Stream']

@pulumi.input_type
class StreamArgs:
    def __init__(__self__, *,
                 destination_config: pulumi.Input['StreamDestinationConfigArgs'],
                 display_name: pulumi.Input[str],
                 location: pulumi.Input[str],
                 source_config: pulumi.Input['StreamSourceConfigArgs'],
                 stream_id: pulumi.Input[str],
                 backfill_all: Optional[pulumi.Input['StreamBackfillAllArgs']] = None,
                 backfill_none: Optional[pulumi.Input['StreamBackfillNoneArgs']] = None,
                 desired_state: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Stream resource.
        :param pulumi.Input['StreamDestinationConfigArgs'] destination_config: Destination connection profile configuration.
               Structure is documented below.
        :param pulumi.Input[str] display_name: Display name.
        :param pulumi.Input[str] location: The name of the location this stream is located in.
        :param pulumi.Input['StreamSourceConfigArgs'] source_config: Source connection profile configuration.
               Structure is documented below.
        :param pulumi.Input[str] stream_id: The stream identifier.
        :param pulumi.Input['StreamBackfillAllArgs'] backfill_all: Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
               Structure is documented below.
        :param pulumi.Input['StreamBackfillNoneArgs'] backfill_none: Backfill strategy to disable automatic backfill for the Stream's objects.
        :param pulumi.Input[str] desired_state: Desired state of the Stream. Set this field to `RUNNING` to start the stream, and `PAUSED` to pause the stream.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "destination_config", destination_config)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "source_config", source_config)
        pulumi.set(__self__, "stream_id", stream_id)
        if backfill_all is not None:
            pulumi.set(__self__, "backfill_all", backfill_all)
        if backfill_none is not None:
            pulumi.set(__self__, "backfill_none", backfill_none)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> pulumi.Input['StreamDestinationConfigArgs']:
        """
        Destination connection profile configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_config")

    @destination_config.setter
    def destination_config(self, value: pulumi.Input['StreamDestinationConfigArgs']):
        pulumi.set(self, "destination_config", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        Display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The name of the location this stream is located in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="sourceConfig")
    def source_config(self) -> pulumi.Input['StreamSourceConfigArgs']:
        """
        Source connection profile configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "source_config")

    @source_config.setter
    def source_config(self, value: pulumi.Input['StreamSourceConfigArgs']):
        pulumi.set(self, "source_config", value)

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> pulumi.Input[str]:
        """
        The stream identifier.
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "stream_id", value)

    @property
    @pulumi.getter(name="backfillAll")
    def backfill_all(self) -> Optional[pulumi.Input['StreamBackfillAllArgs']]:
        """
        Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
        Structure is documented below.
        """
        return pulumi.get(self, "backfill_all")

    @backfill_all.setter
    def backfill_all(self, value: Optional[pulumi.Input['StreamBackfillAllArgs']]):
        pulumi.set(self, "backfill_all", value)

    @property
    @pulumi.getter(name="backfillNone")
    def backfill_none(self) -> Optional[pulumi.Input['StreamBackfillNoneArgs']]:
        """
        Backfill strategy to disable automatic backfill for the Stream's objects.
        """
        return pulumi.get(self, "backfill_none")

    @backfill_none.setter
    def backfill_none(self, value: Optional[pulumi.Input['StreamBackfillNoneArgs']]):
        pulumi.set(self, "backfill_none", value)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[str]]:
        """
        Desired state of the Stream. Set this field to `RUNNING` to start the stream, and `PAUSED` to pause the stream.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desired_state", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _StreamState:
    def __init__(__self__, *,
                 backfill_all: Optional[pulumi.Input['StreamBackfillAllArgs']] = None,
                 backfill_none: Optional[pulumi.Input['StreamBackfillNoneArgs']] = None,
                 desired_state: Optional[pulumi.Input[str]] = None,
                 destination_config: Optional[pulumi.Input['StreamDestinationConfigArgs']] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 source_config: Optional[pulumi.Input['StreamSourceConfigArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 stream_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Stream resources.
        :param pulumi.Input['StreamBackfillAllArgs'] backfill_all: Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
               Structure is documented below.
        :param pulumi.Input['StreamBackfillNoneArgs'] backfill_none: Backfill strategy to disable automatic backfill for the Stream's objects.
        :param pulumi.Input[str] desired_state: Desired state of the Stream. Set this field to `RUNNING` to start the stream, and `PAUSED` to pause the stream.
        :param pulumi.Input['StreamDestinationConfigArgs'] destination_config: Destination connection profile configuration.
               Structure is documented below.
        :param pulumi.Input[str] display_name: Display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels.
        :param pulumi.Input[str] location: The name of the location this stream is located in.
        :param pulumi.Input[str] name: The stream's name.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['StreamSourceConfigArgs'] source_config: Source connection profile configuration.
               Structure is documented below.
        :param pulumi.Input[str] state: The state of the stream.
        :param pulumi.Input[str] stream_id: The stream identifier.
        """
        if backfill_all is not None:
            pulumi.set(__self__, "backfill_all", backfill_all)
        if backfill_none is not None:
            pulumi.set(__self__, "backfill_none", backfill_none)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if destination_config is not None:
            pulumi.set(__self__, "destination_config", destination_config)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if source_config is not None:
            pulumi.set(__self__, "source_config", source_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)

    @property
    @pulumi.getter(name="backfillAll")
    def backfill_all(self) -> Optional[pulumi.Input['StreamBackfillAllArgs']]:
        """
        Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
        Structure is documented below.
        """
        return pulumi.get(self, "backfill_all")

    @backfill_all.setter
    def backfill_all(self, value: Optional[pulumi.Input['StreamBackfillAllArgs']]):
        pulumi.set(self, "backfill_all", value)

    @property
    @pulumi.getter(name="backfillNone")
    def backfill_none(self) -> Optional[pulumi.Input['StreamBackfillNoneArgs']]:
        """
        Backfill strategy to disable automatic backfill for the Stream's objects.
        """
        return pulumi.get(self, "backfill_none")

    @backfill_none.setter
    def backfill_none(self, value: Optional[pulumi.Input['StreamBackfillNoneArgs']]):
        pulumi.set(self, "backfill_none", value)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[str]]:
        """
        Desired state of the Stream. Set this field to `RUNNING` to start the stream, and `PAUSED` to pause the stream.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desired_state", value)

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> Optional[pulumi.Input['StreamDestinationConfigArgs']]:
        """
        Destination connection profile configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_config")

    @destination_config.setter
    def destination_config(self, value: Optional[pulumi.Input['StreamDestinationConfigArgs']]):
        pulumi.set(self, "destination_config", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the location this stream is located in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The stream's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sourceConfig")
    def source_config(self) -> Optional[pulumi.Input['StreamSourceConfigArgs']]:
        """
        Source connection profile configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "source_config")

    @source_config.setter
    def source_config(self, value: Optional[pulumi.Input['StreamSourceConfigArgs']]):
        pulumi.set(self, "source_config", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the stream.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[pulumi.Input[str]]:
        """
        The stream identifier.
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_id", value)


class Stream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backfill_all: Optional[pulumi.Input[pulumi.InputType['StreamBackfillAllArgs']]] = None,
                 backfill_none: Optional[pulumi.Input[pulumi.InputType['StreamBackfillNoneArgs']]] = None,
                 desired_state: Optional[pulumi.Input[str]] = None,
                 destination_config: Optional[pulumi.Input[pulumi.InputType['StreamDestinationConfigArgs']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 source_config: Optional[pulumi.Input[pulumi.InputType['StreamSourceConfigArgs']]] = None,
                 stream_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        A resource representing streaming data from a source to a destination.

        To get more information about Stream, see:

        * [API documentation](https://cloud.google.com/datastream/docs/reference/rest/v1/projects.locations.streams)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/datastream/docs/create-a-stream)

        ## Example Usage
        ### Datastream Stream Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        project = gcp.organizations.get_project()
        instance = gcp.sql.DatabaseInstance("instance",
            database_version="MYSQL_8_0",
            region="us-central1",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
                backup_configuration=gcp.sql.DatabaseInstanceSettingsBackupConfigurationArgs(
                    enabled=True,
                    binary_log_enabled=True,
                ),
                ip_configuration=gcp.sql.DatabaseInstanceSettingsIpConfigurationArgs(
                    authorized_networks=[
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.71.242.81",
                        ),
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.72.28.29",
                        ),
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.67.6.157",
                        ),
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.67.234.134",
                        ),
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.72.239.218",
                        ),
                    ],
                ),
            ),
            deletion_protection=True)
        db = gcp.sql.Database("db", instance=instance.name)
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            instance=instance.name,
            host="%",
            password=pwd.result)
        source_connection_profile = gcp.datastream.ConnectionProfile("sourceConnectionProfile",
            display_name="Source connection profile",
            location="us-central1",
            connection_profile_id="source-profile",
            mysql_profile=gcp.datastream.ConnectionProfileMysqlProfileArgs(
                hostname=instance.public_ip_address,
                username=user.name,
                password=user.password,
            ))
        bucket = gcp.storage.Bucket("bucket",
            location="US",
            uniform_bucket_level_access=True)
        viewer = gcp.storage.BucketIAMMember("viewer",
            bucket=bucket.name,
            role="roles/storage.objectViewer",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datastream.iam.gserviceaccount.com")
        creator = gcp.storage.BucketIAMMember("creator",
            bucket=bucket.name,
            role="roles/storage.objectCreator",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datastream.iam.gserviceaccount.com")
        reader = gcp.storage.BucketIAMMember("reader",
            bucket=bucket.name,
            role="roles/storage.legacyBucketReader",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datastream.iam.gserviceaccount.com")
        destination_connection_profile = gcp.datastream.ConnectionProfile("destinationConnectionProfile",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="destination-profile",
            gcs_profile=gcp.datastream.ConnectionProfileGcsProfileArgs(
                bucket=bucket.name,
                root_path="/path",
            ))
        default = gcp.datastream.Stream("default",
            stream_id="my-stream",
            desired_state="NOT_STARTED",
            location="us-central1",
            display_name="my stream",
            labels={
                "key": "value",
            },
            source_config=gcp.datastream.StreamSourceConfigArgs(
                source_connection_profile=source_connection_profile.id,
                mysql_source_config=gcp.datastream.StreamSourceConfigMysqlSourceConfigArgs(
                    include_objects=gcp.datastream.StreamSourceConfigMysqlSourceConfigIncludeObjectsArgs(
                        mysql_databases=[gcp.datastream.StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseArgs(
                            database="my-database",
                            mysql_tables=[gcp.datastream.StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTableArgs(
                                table="includedTable",
                                mysql_columns=[gcp.datastream.StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTableMysqlColumnArgs(
                                    column="includedColumn",
                                    data_type="VARCHAR",
                                    collation="utf8mb4",
                                    primary_key=False,
                                    nullable=False,
                                    ordinal_position=0,
                                )],
                            )],
                        )],
                    ),
                    exclude_objects=gcp.datastream.StreamSourceConfigMysqlSourceConfigExcludeObjectsArgs(
                        mysql_databases=[gcp.datastream.StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseArgs(
                            database="my-database",
                            mysql_tables=[gcp.datastream.StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTableArgs(
                                table="excludedTable",
                                mysql_columns=[gcp.datastream.StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTableMysqlColumnArgs(
                                    column="excludedColumn",
                                    data_type="VARCHAR",
                                    collation="utf8mb4",
                                    primary_key=False,
                                    nullable=False,
                                    ordinal_position=0,
                                )],
                            )],
                        )],
                    ),
                    max_concurrent_cdc_tasks=5,
                ),
            ),
            destination_config=gcp.datastream.StreamDestinationConfigArgs(
                destination_connection_profile=destination_connection_profile.id,
                gcs_destination_config=gcp.datastream.StreamDestinationConfigGcsDestinationConfigArgs(
                    path="mydata",
                    file_rotation_mb=200,
                    file_rotation_interval="900s",
                    json_file_format=gcp.datastream.StreamDestinationConfigGcsDestinationConfigJsonFileFormatArgs(
                        schema_file_format="NO_SCHEMA_FILE",
                        compression="GZIP",
                    ),
                ),
            ),
            backfill_all=gcp.datastream.StreamBackfillAllArgs(
                mysql_excluded_objects=gcp.datastream.StreamBackfillAllMysqlExcludedObjectsArgs(
                    mysql_databases=[gcp.datastream.StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseArgs(
                        database="my-database",
                        mysql_tables=[gcp.datastream.StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTableArgs(
                            table="excludedTable",
                            mysql_columns=[gcp.datastream.StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTableMysqlColumnArgs(
                                column="excludedColumn",
                                data_type="VARCHAR",
                                collation="utf8mb4",
                                primary_key=False,
                                nullable=False,
                                ordinal_position=0,
                            )],
                        )],
                    )],
                ),
            ))
        ```

        ## Import

        Stream can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:datastream/stream:Stream default projects/{{project}}/locations/{{location}}/streams/{{stream_id}}
        ```

        ```sh
         $ pulumi import gcp:datastream/stream:Stream default {{project}}/{{location}}/{{stream_id}}
        ```

        ```sh
         $ pulumi import gcp:datastream/stream:Stream default {{location}}/{{stream_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['StreamBackfillAllArgs']] backfill_all: Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['StreamBackfillNoneArgs']] backfill_none: Backfill strategy to disable automatic backfill for the Stream's objects.
        :param pulumi.Input[str] desired_state: Desired state of the Stream. Set this field to `RUNNING` to start the stream, and `PAUSED` to pause the stream.
        :param pulumi.Input[pulumi.InputType['StreamDestinationConfigArgs']] destination_config: Destination connection profile configuration.
               Structure is documented below.
        :param pulumi.Input[str] display_name: Display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels.
        :param pulumi.Input[str] location: The name of the location this stream is located in.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['StreamSourceConfigArgs']] source_config: Source connection profile configuration.
               Structure is documented below.
        :param pulumi.Input[str] stream_id: The stream identifier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A resource representing streaming data from a source to a destination.

        To get more information about Stream, see:

        * [API documentation](https://cloud.google.com/datastream/docs/reference/rest/v1/projects.locations.streams)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/datastream/docs/create-a-stream)

        ## Example Usage
        ### Datastream Stream Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_random as random

        project = gcp.organizations.get_project()
        instance = gcp.sql.DatabaseInstance("instance",
            database_version="MYSQL_8_0",
            region="us-central1",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
                backup_configuration=gcp.sql.DatabaseInstanceSettingsBackupConfigurationArgs(
                    enabled=True,
                    binary_log_enabled=True,
                ),
                ip_configuration=gcp.sql.DatabaseInstanceSettingsIpConfigurationArgs(
                    authorized_networks=[
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.71.242.81",
                        ),
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.72.28.29",
                        ),
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.67.6.157",
                        ),
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.67.234.134",
                        ),
                        gcp.sql.DatabaseInstanceSettingsIpConfigurationAuthorizedNetworkArgs(
                            value="34.72.239.218",
                        ),
                    ],
                ),
            ),
            deletion_protection=True)
        db = gcp.sql.Database("db", instance=instance.name)
        pwd = random.RandomPassword("pwd",
            length=16,
            special=False)
        user = gcp.sql.User("user",
            instance=instance.name,
            host="%",
            password=pwd.result)
        source_connection_profile = gcp.datastream.ConnectionProfile("sourceConnectionProfile",
            display_name="Source connection profile",
            location="us-central1",
            connection_profile_id="source-profile",
            mysql_profile=gcp.datastream.ConnectionProfileMysqlProfileArgs(
                hostname=instance.public_ip_address,
                username=user.name,
                password=user.password,
            ))
        bucket = gcp.storage.Bucket("bucket",
            location="US",
            uniform_bucket_level_access=True)
        viewer = gcp.storage.BucketIAMMember("viewer",
            bucket=bucket.name,
            role="roles/storage.objectViewer",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datastream.iam.gserviceaccount.com")
        creator = gcp.storage.BucketIAMMember("creator",
            bucket=bucket.name,
            role="roles/storage.objectCreator",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datastream.iam.gserviceaccount.com")
        reader = gcp.storage.BucketIAMMember("reader",
            bucket=bucket.name,
            role="roles/storage.legacyBucketReader",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datastream.iam.gserviceaccount.com")
        destination_connection_profile = gcp.datastream.ConnectionProfile("destinationConnectionProfile",
            display_name="Connection profile",
            location="us-central1",
            connection_profile_id="destination-profile",
            gcs_profile=gcp.datastream.ConnectionProfileGcsProfileArgs(
                bucket=bucket.name,
                root_path="/path",
            ))
        default = gcp.datastream.Stream("default",
            stream_id="my-stream",
            desired_state="NOT_STARTED",
            location="us-central1",
            display_name="my stream",
            labels={
                "key": "value",
            },
            source_config=gcp.datastream.StreamSourceConfigArgs(
                source_connection_profile=source_connection_profile.id,
                mysql_source_config=gcp.datastream.StreamSourceConfigMysqlSourceConfigArgs(
                    include_objects=gcp.datastream.StreamSourceConfigMysqlSourceConfigIncludeObjectsArgs(
                        mysql_databases=[gcp.datastream.StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseArgs(
                            database="my-database",
                            mysql_tables=[gcp.datastream.StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTableArgs(
                                table="includedTable",
                                mysql_columns=[gcp.datastream.StreamSourceConfigMysqlSourceConfigIncludeObjectsMysqlDatabaseMysqlTableMysqlColumnArgs(
                                    column="includedColumn",
                                    data_type="VARCHAR",
                                    collation="utf8mb4",
                                    primary_key=False,
                                    nullable=False,
                                    ordinal_position=0,
                                )],
                            )],
                        )],
                    ),
                    exclude_objects=gcp.datastream.StreamSourceConfigMysqlSourceConfigExcludeObjectsArgs(
                        mysql_databases=[gcp.datastream.StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseArgs(
                            database="my-database",
                            mysql_tables=[gcp.datastream.StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTableArgs(
                                table="excludedTable",
                                mysql_columns=[gcp.datastream.StreamSourceConfigMysqlSourceConfigExcludeObjectsMysqlDatabaseMysqlTableMysqlColumnArgs(
                                    column="excludedColumn",
                                    data_type="VARCHAR",
                                    collation="utf8mb4",
                                    primary_key=False,
                                    nullable=False,
                                    ordinal_position=0,
                                )],
                            )],
                        )],
                    ),
                    max_concurrent_cdc_tasks=5,
                ),
            ),
            destination_config=gcp.datastream.StreamDestinationConfigArgs(
                destination_connection_profile=destination_connection_profile.id,
                gcs_destination_config=gcp.datastream.StreamDestinationConfigGcsDestinationConfigArgs(
                    path="mydata",
                    file_rotation_mb=200,
                    file_rotation_interval="900s",
                    json_file_format=gcp.datastream.StreamDestinationConfigGcsDestinationConfigJsonFileFormatArgs(
                        schema_file_format="NO_SCHEMA_FILE",
                        compression="GZIP",
                    ),
                ),
            ),
            backfill_all=gcp.datastream.StreamBackfillAllArgs(
                mysql_excluded_objects=gcp.datastream.StreamBackfillAllMysqlExcludedObjectsArgs(
                    mysql_databases=[gcp.datastream.StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseArgs(
                        database="my-database",
                        mysql_tables=[gcp.datastream.StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTableArgs(
                            table="excludedTable",
                            mysql_columns=[gcp.datastream.StreamBackfillAllMysqlExcludedObjectsMysqlDatabaseMysqlTableMysqlColumnArgs(
                                column="excludedColumn",
                                data_type="VARCHAR",
                                collation="utf8mb4",
                                primary_key=False,
                                nullable=False,
                                ordinal_position=0,
                            )],
                        )],
                    )],
                ),
            ))
        ```

        ## Import

        Stream can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:datastream/stream:Stream default projects/{{project}}/locations/{{location}}/streams/{{stream_id}}
        ```

        ```sh
         $ pulumi import gcp:datastream/stream:Stream default {{project}}/{{location}}/{{stream_id}}
        ```

        ```sh
         $ pulumi import gcp:datastream/stream:Stream default {{location}}/{{stream_id}}
        ```

        :param str resource_name: The name of the resource.
        :param StreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backfill_all: Optional[pulumi.Input[pulumi.InputType['StreamBackfillAllArgs']]] = None,
                 backfill_none: Optional[pulumi.Input[pulumi.InputType['StreamBackfillNoneArgs']]] = None,
                 desired_state: Optional[pulumi.Input[str]] = None,
                 destination_config: Optional[pulumi.Input[pulumi.InputType['StreamDestinationConfigArgs']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 source_config: Optional[pulumi.Input[pulumi.InputType['StreamSourceConfigArgs']]] = None,
                 stream_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamArgs.__new__(StreamArgs)

            __props__.__dict__["backfill_all"] = backfill_all
            __props__.__dict__["backfill_none"] = backfill_none
            __props__.__dict__["desired_state"] = desired_state
            if destination_config is None and not opts.urn:
                raise TypeError("Missing required property 'destination_config'")
            __props__.__dict__["destination_config"] = destination_config
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if source_config is None and not opts.urn:
                raise TypeError("Missing required property 'source_config'")
            __props__.__dict__["source_config"] = source_config
            if stream_id is None and not opts.urn:
                raise TypeError("Missing required property 'stream_id'")
            __props__.__dict__["stream_id"] = stream_id
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
        super(Stream, __self__).__init__(
            'gcp:datastream/stream:Stream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backfill_all: Optional[pulumi.Input[pulumi.InputType['StreamBackfillAllArgs']]] = None,
            backfill_none: Optional[pulumi.Input[pulumi.InputType['StreamBackfillNoneArgs']]] = None,
            desired_state: Optional[pulumi.Input[str]] = None,
            destination_config: Optional[pulumi.Input[pulumi.InputType['StreamDestinationConfigArgs']]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            source_config: Optional[pulumi.Input[pulumi.InputType['StreamSourceConfigArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            stream_id: Optional[pulumi.Input[str]] = None) -> 'Stream':
        """
        Get an existing Stream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['StreamBackfillAllArgs']] backfill_all: Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['StreamBackfillNoneArgs']] backfill_none: Backfill strategy to disable automatic backfill for the Stream's objects.
        :param pulumi.Input[str] desired_state: Desired state of the Stream. Set this field to `RUNNING` to start the stream, and `PAUSED` to pause the stream.
        :param pulumi.Input[pulumi.InputType['StreamDestinationConfigArgs']] destination_config: Destination connection profile configuration.
               Structure is documented below.
        :param pulumi.Input[str] display_name: Display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels.
        :param pulumi.Input[str] location: The name of the location this stream is located in.
        :param pulumi.Input[str] name: The stream's name.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['StreamSourceConfigArgs']] source_config: Source connection profile configuration.
               Structure is documented below.
        :param pulumi.Input[str] state: The state of the stream.
        :param pulumi.Input[str] stream_id: The stream identifier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamState.__new__(_StreamState)

        __props__.__dict__["backfill_all"] = backfill_all
        __props__.__dict__["backfill_none"] = backfill_none
        __props__.__dict__["desired_state"] = desired_state
        __props__.__dict__["destination_config"] = destination_config
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["source_config"] = source_config
        __props__.__dict__["state"] = state
        __props__.__dict__["stream_id"] = stream_id
        return Stream(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backfillAll")
    def backfill_all(self) -> pulumi.Output[Optional['outputs.StreamBackfillAll']]:
        """
        Backfill strategy to automatically backfill the Stream's objects. Specific objects can be excluded.
        Structure is documented below.
        """
        return pulumi.get(self, "backfill_all")

    @property
    @pulumi.getter(name="backfillNone")
    def backfill_none(self) -> pulumi.Output[Optional['outputs.StreamBackfillNone']]:
        """
        Backfill strategy to disable automatic backfill for the Stream's objects.
        """
        return pulumi.get(self, "backfill_none")

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> pulumi.Output[Optional[str]]:
        """
        Desired state of the Stream. Set this field to `RUNNING` to start the stream, and `PAUSED` to pause the stream.
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> pulumi.Output['outputs.StreamDestinationConfig']:
        """
        Destination connection profile configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_config")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The name of the location this stream is located in.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The stream's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="sourceConfig")
    def source_config(self) -> pulumi.Output['outputs.StreamSourceConfig']:
        """
        Source connection profile configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "source_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the stream.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> pulumi.Output[str]:
        """
        The stream identifier.
        """
        return pulumi.get(self, "stream_id")

