# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CxIntentArgs', 'CxIntent']

@pulumi.input_type
class CxIntentArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 is_fallback: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['CxIntentParameterArgs']]]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 training_phrases: Optional[pulumi.Input[Sequence[pulumi.Input['CxIntentTrainingPhraseArgs']]]] = None):
        """
        The set of arguments for constructing a CxIntent resource.
        :param pulumi.Input[str] display_name: The human-readable name of the intent, unique within the agent.
        :param pulumi.Input[str] description: Human readable description for better understanding an intent like its scope, content, result etc. Maximum character limit: 140 characters.
        :param pulumi.Input[bool] is_fallback: Indicates whether this is a fallback intent. Currently only default fallback intent is allowed in the agent, which is added upon agent creation.
               Adding training phrases to fallback intent is useful in the case of requests that are mistakenly matched, since training phrases assigned to fallback intents act as negative examples that triggers no-match event.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The key/value metadata to label an intent. Labels can contain lowercase letters, digits and the symbols '-' and '_'. International characters are allowed, including letters from unicase alphabets. Keys must start with a letter. Keys and values can be no longer than 63 characters and no more than 128 bytes.
               Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed Dialogflow defined labels include: * sys-head * sys-contextual The above labels do not require value. "sys-head" means the intent is a head intent. "sys.contextual" means the intent is a contextual intent.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] language_code: The language of the following fields in intent:
               Intent.training_phrases.parts.text
               If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        :param pulumi.Input[Sequence[pulumi.Input['CxIntentParameterArgs']]] parameters: The collection of parameters associated with the intent.
               Structure is documented below.
        :param pulumi.Input[str] parent: The agent to create an intent for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[int] priority: The priority of this intent. Higher numbers represent higher priorities.
               If the supplied value is unspecified or 0, the service translates the value to 500,000, which corresponds to the Normal priority in the console.
               If the supplied value is negative, the intent is ignored in runtime detect intent requests.
        :param pulumi.Input[Sequence[pulumi.Input['CxIntentTrainingPhraseArgs']]] training_phrases: The collection of training phrases the agent is trained on to identify the intent.
               Structure is documented below.
        """
        pulumi.set(__self__, "display_name", display_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_fallback is not None:
            pulumi.set(__self__, "is_fallback", is_fallback)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if training_phrases is not None:
            pulumi.set(__self__, "training_phrases", training_phrases)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The human-readable name of the intent, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable description for better understanding an intent like its scope, content, result etc. Maximum character limit: 140 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isFallback")
    def is_fallback(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this is a fallback intent. Currently only default fallback intent is allowed in the agent, which is added upon agent creation.
        Adding training phrases to fallback intent is useful in the case of requests that are mistakenly matched, since training phrases assigned to fallback intents act as negative examples that triggers no-match event.
        """
        return pulumi.get(self, "is_fallback")

    @is_fallback.setter
    def is_fallback(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_fallback", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value metadata to label an intent. Labels can contain lowercase letters, digits and the symbols '-' and '_'. International characters are allowed, including letters from unicase alphabets. Keys must start with a letter. Keys and values can be no longer than 63 characters and no more than 128 bytes.
        Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed Dialogflow defined labels include: * sys-head * sys-contextual The above labels do not require value. "sys-head" means the intent is a head intent. "sys.contextual" means the intent is a contextual intent.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[str]]:
        """
        The language of the following fields in intent:
        Intent.training_phrases.parts.text
        If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxIntentParameterArgs']]]]:
        """
        The collection of parameters associated with the intent.
        Structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxIntentParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[str]]:
        """
        The agent to create an intent for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of this intent. Higher numbers represent higher priorities.
        If the supplied value is unspecified or 0, the service translates the value to 500,000, which corresponds to the Normal priority in the console.
        If the supplied value is negative, the intent is ignored in runtime detect intent requests.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="trainingPhrases")
    def training_phrases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxIntentTrainingPhraseArgs']]]]:
        """
        The collection of training phrases the agent is trained on to identify the intent.
        Structure is documented below.
        """
        return pulumi.get(self, "training_phrases")

    @training_phrases.setter
    def training_phrases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxIntentTrainingPhraseArgs']]]]):
        pulumi.set(self, "training_phrases", value)


@pulumi.input_type
class _CxIntentState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 is_fallback: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['CxIntentParameterArgs']]]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 training_phrases: Optional[pulumi.Input[Sequence[pulumi.Input['CxIntentTrainingPhraseArgs']]]] = None):
        """
        Input properties used for looking up and filtering CxIntent resources.
        :param pulumi.Input[str] description: Human readable description for better understanding an intent like its scope, content, result etc. Maximum character limit: 140 characters.
        :param pulumi.Input[str] display_name: The human-readable name of the intent, unique within the agent.
        :param pulumi.Input[bool] is_fallback: Indicates whether this is a fallback intent. Currently only default fallback intent is allowed in the agent, which is added upon agent creation.
               Adding training phrases to fallback intent is useful in the case of requests that are mistakenly matched, since training phrases assigned to fallback intents act as negative examples that triggers no-match event.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The key/value metadata to label an intent. Labels can contain lowercase letters, digits and the symbols '-' and '_'. International characters are allowed, including letters from unicase alphabets. Keys must start with a letter. Keys and values can be no longer than 63 characters and no more than 128 bytes.
               Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed Dialogflow defined labels include: * sys-head * sys-contextual The above labels do not require value. "sys-head" means the intent is a head intent. "sys.contextual" means the intent is a contextual intent.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] language_code: The language of the following fields in intent:
               Intent.training_phrases.parts.text
               If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        :param pulumi.Input[str] name: The unique identifier of the intent.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>.
        :param pulumi.Input[Sequence[pulumi.Input['CxIntentParameterArgs']]] parameters: The collection of parameters associated with the intent.
               Structure is documented below.
        :param pulumi.Input[str] parent: The agent to create an intent for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[int] priority: The priority of this intent. Higher numbers represent higher priorities.
               If the supplied value is unspecified or 0, the service translates the value to 500,000, which corresponds to the Normal priority in the console.
               If the supplied value is negative, the intent is ignored in runtime detect intent requests.
        :param pulumi.Input[Sequence[pulumi.Input['CxIntentTrainingPhraseArgs']]] training_phrases: The collection of training phrases the agent is trained on to identify the intent.
               Structure is documented below.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if is_fallback is not None:
            pulumi.set(__self__, "is_fallback", is_fallback)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if language_code is not None:
            pulumi.set(__self__, "language_code", language_code)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if training_phrases is not None:
            pulumi.set(__self__, "training_phrases", training_phrases)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable description for better understanding an intent like its scope, content, result etc. Maximum character limit: 140 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-readable name of the intent, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="isFallback")
    def is_fallback(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether this is a fallback intent. Currently only default fallback intent is allowed in the agent, which is added upon agent creation.
        Adding training phrases to fallback intent is useful in the case of requests that are mistakenly matched, since training phrases assigned to fallback intents act as negative examples that triggers no-match event.
        """
        return pulumi.get(self, "is_fallback")

    @is_fallback.setter
    def is_fallback(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_fallback", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value metadata to label an intent. Labels can contain lowercase letters, digits and the symbols '-' and '_'. International characters are allowed, including letters from unicase alphabets. Keys must start with a letter. Keys and values can be no longer than 63 characters and no more than 128 bytes.
        Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed Dialogflow defined labels include: * sys-head * sys-contextual The above labels do not require value. "sys-head" means the intent is a head intent. "sys.contextual" means the intent is a contextual intent.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> Optional[pulumi.Input[str]]:
        """
        The language of the following fields in intent:
        Intent.training_phrases.parts.text
        If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        """
        return pulumi.get(self, "language_code")

    @language_code.setter
    def language_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "language_code", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the intent.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxIntentParameterArgs']]]]:
        """
        The collection of parameters associated with the intent.
        Structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxIntentParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[str]]:
        """
        The agent to create an intent for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The priority of this intent. Higher numbers represent higher priorities.
        If the supplied value is unspecified or 0, the service translates the value to 500,000, which corresponds to the Normal priority in the console.
        If the supplied value is negative, the intent is ignored in runtime detect intent requests.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="trainingPhrases")
    def training_phrases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CxIntentTrainingPhraseArgs']]]]:
        """
        The collection of training phrases the agent is trained on to identify the intent.
        Structure is documented below.
        """
        return pulumi.get(self, "training_phrases")

    @training_phrases.setter
    def training_phrases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CxIntentTrainingPhraseArgs']]]]):
        pulumi.set(self, "training_phrases", value)


class CxIntent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 is_fallback: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CxIntentParameterArgs']]]]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 training_phrases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CxIntentTrainingPhraseArgs']]]]] = None,
                 __props__=None):
        """
        An intent represents a user's intent to interact with a conversational agent.

        To get more information about Intent, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.intents)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage
        ### Dialogflowcx Intent Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings=gcp.diagflow.CxAgentSpeechToTextSettingsArgs(
                enable_speech_adaptation=True,
            ))
        basic_intent = gcp.diagflow.CxIntent("basicIntent",
            parent=agent.id,
            display_name="Example",
            priority=1,
            description="Intent example",
            training_phrases=[gcp.diagflow.CxIntentTrainingPhraseArgs(
                parts=[
                    gcp.diagflow.CxIntentTrainingPhrasePartArgs(
                        text="training",
                    ),
                    gcp.diagflow.CxIntentTrainingPhrasePartArgs(
                        text="phrase",
                    ),
                    gcp.diagflow.CxIntentTrainingPhrasePartArgs(
                        text="example",
                    ),
                ],
                repeat_count=1,
            )],
            parameters=[gcp.diagflow.CxIntentParameterArgs(
                id="param1",
                entity_type="projects/-/locations/-/agents/-/entityTypes/sys.date",
            )],
            labels={
                "label1": "value1",
                "label2": "value2",
            })
        ```

        ## Import

        Intent can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:diagflow/cxIntent:CxIntent default {{parent}}/intents/{{name}}
        ```

        ```sh
         $ pulumi import gcp:diagflow/cxIntent:CxIntent default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Human readable description for better understanding an intent like its scope, content, result etc. Maximum character limit: 140 characters.
        :param pulumi.Input[str] display_name: The human-readable name of the intent, unique within the agent.
        :param pulumi.Input[bool] is_fallback: Indicates whether this is a fallback intent. Currently only default fallback intent is allowed in the agent, which is added upon agent creation.
               Adding training phrases to fallback intent is useful in the case of requests that are mistakenly matched, since training phrases assigned to fallback intents act as negative examples that triggers no-match event.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The key/value metadata to label an intent. Labels can contain lowercase letters, digits and the symbols '-' and '_'. International characters are allowed, including letters from unicase alphabets. Keys must start with a letter. Keys and values can be no longer than 63 characters and no more than 128 bytes.
               Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed Dialogflow defined labels include: * sys-head * sys-contextual The above labels do not require value. "sys-head" means the intent is a head intent. "sys.contextual" means the intent is a contextual intent.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] language_code: The language of the following fields in intent:
               Intent.training_phrases.parts.text
               If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CxIntentParameterArgs']]]] parameters: The collection of parameters associated with the intent.
               Structure is documented below.
        :param pulumi.Input[str] parent: The agent to create an intent for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[int] priority: The priority of this intent. Higher numbers represent higher priorities.
               If the supplied value is unspecified or 0, the service translates the value to 500,000, which corresponds to the Normal priority in the console.
               If the supplied value is negative, the intent is ignored in runtime detect intent requests.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CxIntentTrainingPhraseArgs']]]] training_phrases: The collection of training phrases the agent is trained on to identify the intent.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CxIntentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An intent represents a user's intent to interact with a conversational agent.

        To get more information about Intent, see:

        * [API documentation](https://cloud.google.com/dialogflow/cx/docs/reference/rest/v3/projects.locations.agents.intents)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dialogflow/cx/docs)

        ## Example Usage
        ### Dialogflowcx Intent Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        agent = gcp.diagflow.CxAgent("agent",
            display_name="dialogflowcx-agent",
            location="global",
            default_language_code="en",
            supported_language_codes=[
                "fr",
                "de",
                "es",
            ],
            time_zone="America/New_York",
            description="Example description.",
            avatar_uri="https://cloud.google.com/_static/images/cloud/icons/favicons/onecloud/super_cloud.png",
            enable_stackdriver_logging=True,
            enable_spell_correction=True,
            speech_to_text_settings=gcp.diagflow.CxAgentSpeechToTextSettingsArgs(
                enable_speech_adaptation=True,
            ))
        basic_intent = gcp.diagflow.CxIntent("basicIntent",
            parent=agent.id,
            display_name="Example",
            priority=1,
            description="Intent example",
            training_phrases=[gcp.diagflow.CxIntentTrainingPhraseArgs(
                parts=[
                    gcp.diagflow.CxIntentTrainingPhrasePartArgs(
                        text="training",
                    ),
                    gcp.diagflow.CxIntentTrainingPhrasePartArgs(
                        text="phrase",
                    ),
                    gcp.diagflow.CxIntentTrainingPhrasePartArgs(
                        text="example",
                    ),
                ],
                repeat_count=1,
            )],
            parameters=[gcp.diagflow.CxIntentParameterArgs(
                id="param1",
                entity_type="projects/-/locations/-/agents/-/entityTypes/sys.date",
            )],
            labels={
                "label1": "value1",
                "label2": "value2",
            })
        ```

        ## Import

        Intent can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:diagflow/cxIntent:CxIntent default {{parent}}/intents/{{name}}
        ```

        ```sh
         $ pulumi import gcp:diagflow/cxIntent:CxIntent default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CxIntentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CxIntentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 is_fallback: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 language_code: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CxIntentParameterArgs']]]]] = None,
                 parent: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 training_phrases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CxIntentTrainingPhraseArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CxIntentArgs.__new__(CxIntentArgs)

            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["is_fallback"] = is_fallback
            __props__.__dict__["labels"] = labels
            __props__.__dict__["language_code"] = language_code
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["parent"] = parent
            __props__.__dict__["priority"] = priority
            __props__.__dict__["training_phrases"] = training_phrases
            __props__.__dict__["name"] = None
        super(CxIntent, __self__).__init__(
            'gcp:diagflow/cxIntent:CxIntent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            is_fallback: Optional[pulumi.Input[bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            language_code: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CxIntentParameterArgs']]]]] = None,
            parent: Optional[pulumi.Input[str]] = None,
            priority: Optional[pulumi.Input[int]] = None,
            training_phrases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CxIntentTrainingPhraseArgs']]]]] = None) -> 'CxIntent':
        """
        Get an existing CxIntent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Human readable description for better understanding an intent like its scope, content, result etc. Maximum character limit: 140 characters.
        :param pulumi.Input[str] display_name: The human-readable name of the intent, unique within the agent.
        :param pulumi.Input[bool] is_fallback: Indicates whether this is a fallback intent. Currently only default fallback intent is allowed in the agent, which is added upon agent creation.
               Adding training phrases to fallback intent is useful in the case of requests that are mistakenly matched, since training phrases assigned to fallback intents act as negative examples that triggers no-match event.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The key/value metadata to label an intent. Labels can contain lowercase letters, digits and the symbols '-' and '_'. International characters are allowed, including letters from unicase alphabets. Keys must start with a letter. Keys and values can be no longer than 63 characters and no more than 128 bytes.
               Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed Dialogflow defined labels include: * sys-head * sys-contextual The above labels do not require value. "sys-head" means the intent is a head intent. "sys.contextual" means the intent is a contextual intent.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param pulumi.Input[str] language_code: The language of the following fields in intent:
               Intent.training_phrases.parts.text
               If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        :param pulumi.Input[str] name: The unique identifier of the intent.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CxIntentParameterArgs']]]] parameters: The collection of parameters associated with the intent.
               Structure is documented below.
        :param pulumi.Input[str] parent: The agent to create an intent for.
               Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        :param pulumi.Input[int] priority: The priority of this intent. Higher numbers represent higher priorities.
               If the supplied value is unspecified or 0, the service translates the value to 500,000, which corresponds to the Normal priority in the console.
               If the supplied value is negative, the intent is ignored in runtime detect intent requests.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CxIntentTrainingPhraseArgs']]]] training_phrases: The collection of training phrases the agent is trained on to identify the intent.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CxIntentState.__new__(_CxIntentState)

        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["is_fallback"] = is_fallback
        __props__.__dict__["labels"] = labels
        __props__.__dict__["language_code"] = language_code
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["parent"] = parent
        __props__.__dict__["priority"] = priority
        __props__.__dict__["training_phrases"] = training_phrases
        return CxIntent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Human readable description for better understanding an intent like its scope, content, result etc. Maximum character limit: 140 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The human-readable name of the intent, unique within the agent.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="isFallback")
    def is_fallback(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether this is a fallback intent. Currently only default fallback intent is allowed in the agent, which is added upon agent creation.
        Adding training phrases to fallback intent is useful in the case of requests that are mistakenly matched, since training phrases assigned to fallback intents act as negative examples that triggers no-match event.
        """
        return pulumi.get(self, "is_fallback")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The key/value metadata to label an intent. Labels can contain lowercase letters, digits and the symbols '-' and '_'. International characters are allowed, including letters from unicase alphabets. Keys must start with a letter. Keys and values can be no longer than 63 characters and no more than 128 bytes.
        Prefix "sys-" is reserved for Dialogflow defined labels. Currently allowed Dialogflow defined labels include: * sys-head * sys-contextual The above labels do not require value. "sys-head" means the intent is a head intent. "sys.contextual" means the intent is a contextual intent.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> pulumi.Output[Optional[str]]:
        """
        The language of the following fields in intent:
        Intent.training_phrases.parts.text
        If not specified, the agent's default language is used. Many languages are supported. Note: languages must be enabled in the agent before they can be used.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The unique identifier of the intent.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>/intents/<Intent ID>.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Sequence['outputs.CxIntentParameter']]]:
        """
        The collection of parameters associated with the intent.
        Structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[Optional[str]]:
        """
        The agent to create an intent for.
        Format: projects/<Project ID>/locations/<Location ID>/agents/<Agent ID>.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[int]]:
        """
        The priority of this intent. Higher numbers represent higher priorities.
        If the supplied value is unspecified or 0, the service translates the value to 500,000, which corresponds to the Normal priority in the console.
        If the supplied value is negative, the intent is ignored in runtime detect intent requests.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="trainingPhrases")
    def training_phrases(self) -> pulumi.Output[Optional[Sequence['outputs.CxIntentTrainingPhrase']]]:
        """
        The collection of training phrases the agent is trained on to identify the intent.
        Structure is documented below.
        """
        return pulumi.get(self, "training_phrases")

