# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BackupPlanBackupConfig',
    'BackupPlanBackupConfigEncryptionKey',
    'BackupPlanBackupConfigSelectedApplications',
    'BackupPlanBackupConfigSelectedApplicationsNamespacedName',
    'BackupPlanBackupConfigSelectedNamespaces',
    'BackupPlanBackupSchedule',
    'BackupPlanRetentionPolicy',
]

@pulumi.output_type
class BackupPlanBackupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allNamespaces":
            suggest = "all_namespaces"
        elif key == "encryptionKey":
            suggest = "encryption_key"
        elif key == "includeSecrets":
            suggest = "include_secrets"
        elif key == "includeVolumeData":
            suggest = "include_volume_data"
        elif key == "selectedApplications":
            suggest = "selected_applications"
        elif key == "selectedNamespaces":
            suggest = "selected_namespaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_namespaces: Optional[bool] = None,
                 encryption_key: Optional['outputs.BackupPlanBackupConfigEncryptionKey'] = None,
                 include_secrets: Optional[bool] = None,
                 include_volume_data: Optional[bool] = None,
                 selected_applications: Optional['outputs.BackupPlanBackupConfigSelectedApplications'] = None,
                 selected_namespaces: Optional['outputs.BackupPlanBackupConfigSelectedNamespaces'] = None):
        """
        :param bool all_namespaces: If True, include all namespaced resources.
        :param 'BackupPlanBackupConfigEncryptionKeyArgs' encryption_key: This defines a customer managed encryption key that will be used to encrypt the "config"
               portion (the Kubernetes resources) of Backups created via this plan.
               Structure is documented below.
        :param bool include_secrets: This flag specifies whether Kubernetes Secret resources should be included
               when they fall into the scope of Backups.
        :param bool include_volume_data: This flag specifies whether volume data should be backed up when PVCs are
               included in the scope of a Backup.
        :param 'BackupPlanBackupConfigSelectedApplicationsArgs' selected_applications: A list of namespaced Kubernetes Resources.
               Structure is documented below.
        :param 'BackupPlanBackupConfigSelectedNamespacesArgs' selected_namespaces: If set, include just the resources in the listed namespaces.
               Structure is documented below.
        """
        if all_namespaces is not None:
            pulumi.set(__self__, "all_namespaces", all_namespaces)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if include_secrets is not None:
            pulumi.set(__self__, "include_secrets", include_secrets)
        if include_volume_data is not None:
            pulumi.set(__self__, "include_volume_data", include_volume_data)
        if selected_applications is not None:
            pulumi.set(__self__, "selected_applications", selected_applications)
        if selected_namespaces is not None:
            pulumi.set(__self__, "selected_namespaces", selected_namespaces)

    @property
    @pulumi.getter(name="allNamespaces")
    def all_namespaces(self) -> Optional[bool]:
        """
        If True, include all namespaced resources.
        """
        return pulumi.get(self, "all_namespaces")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional['outputs.BackupPlanBackupConfigEncryptionKey']:
        """
        This defines a customer managed encryption key that will be used to encrypt the "config"
        portion (the Kubernetes resources) of Backups created via this plan.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter(name="includeSecrets")
    def include_secrets(self) -> Optional[bool]:
        """
        This flag specifies whether Kubernetes Secret resources should be included
        when they fall into the scope of Backups.
        """
        return pulumi.get(self, "include_secrets")

    @property
    @pulumi.getter(name="includeVolumeData")
    def include_volume_data(self) -> Optional[bool]:
        """
        This flag specifies whether volume data should be backed up when PVCs are
        included in the scope of a Backup.
        """
        return pulumi.get(self, "include_volume_data")

    @property
    @pulumi.getter(name="selectedApplications")
    def selected_applications(self) -> Optional['outputs.BackupPlanBackupConfigSelectedApplications']:
        """
        A list of namespaced Kubernetes Resources.
        Structure is documented below.
        """
        return pulumi.get(self, "selected_applications")

    @property
    @pulumi.getter(name="selectedNamespaces")
    def selected_namespaces(self) -> Optional['outputs.BackupPlanBackupConfigSelectedNamespaces']:
        """
        If set, include just the resources in the listed namespaces.
        Structure is documented below.
        """
        return pulumi.get(self, "selected_namespaces")


@pulumi.output_type
class BackupPlanBackupConfigEncryptionKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcpKmsEncryptionKey":
            suggest = "gcp_kms_encryption_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupConfigEncryptionKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupConfigEncryptionKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupConfigEncryptionKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcp_kms_encryption_key: str):
        """
        :param str gcp_kms_encryption_key: Google Cloud KMS encryption key. Format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
        pulumi.set(__self__, "gcp_kms_encryption_key", gcp_kms_encryption_key)

    @property
    @pulumi.getter(name="gcpKmsEncryptionKey")
    def gcp_kms_encryption_key(self) -> str:
        """
        Google Cloud KMS encryption key. Format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
        return pulumi.get(self, "gcp_kms_encryption_key")


@pulumi.output_type
class BackupPlanBackupConfigSelectedApplications(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespacedNames":
            suggest = "namespaced_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupConfigSelectedApplications. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupConfigSelectedApplications.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupConfigSelectedApplications.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespaced_names: Sequence['outputs.BackupPlanBackupConfigSelectedApplicationsNamespacedName']):
        """
        :param Sequence['BackupPlanBackupConfigSelectedApplicationsNamespacedNameArgs'] namespaced_names: A list of namespaced Kubernetes resources.
               Structure is documented below.
        """
        pulumi.set(__self__, "namespaced_names", namespaced_names)

    @property
    @pulumi.getter(name="namespacedNames")
    def namespaced_names(self) -> Sequence['outputs.BackupPlanBackupConfigSelectedApplicationsNamespacedName']:
        """
        A list of namespaced Kubernetes resources.
        Structure is documented below.
        """
        return pulumi.get(self, "namespaced_names")


@pulumi.output_type
class BackupPlanBackupConfigSelectedApplicationsNamespacedName(dict):
    def __init__(__self__, *,
                 name: str,
                 namespace: str):
        """
        :param str name: The name of a Kubernetes Resource.
        :param str namespace: The namespace of a Kubernetes Resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of a Kubernetes Resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace of a Kubernetes Resource.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class BackupPlanBackupConfigSelectedNamespaces(dict):
    def __init__(__self__, *,
                 namespaces: Sequence[str]):
        """
        :param Sequence[str] namespaces: A list of Kubernetes Namespaces.
        """
        pulumi.set(__self__, "namespaces", namespaces)

    @property
    @pulumi.getter
    def namespaces(self) -> Sequence[str]:
        """
        A list of Kubernetes Namespaces.
        """
        return pulumi.get(self, "namespaces")


@pulumi.output_type
class BackupPlanBackupSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronSchedule":
            suggest = "cron_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanBackupSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanBackupSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanBackupSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_schedule: Optional[str] = None,
                 paused: Optional[bool] = None):
        """
        :param str cron_schedule: A standard cron string that defines a repeating schedule for
               creating Backups via this BackupPlan.
               If this is defined, then backupRetainDays must also be defined.
        :param bool paused: This flag denotes whether automatic Backup creation is paused for this BackupPlan.
        """
        if cron_schedule is not None:
            pulumi.set(__self__, "cron_schedule", cron_schedule)
        if paused is not None:
            pulumi.set(__self__, "paused", paused)

    @property
    @pulumi.getter(name="cronSchedule")
    def cron_schedule(self) -> Optional[str]:
        """
        A standard cron string that defines a repeating schedule for
        creating Backups via this BackupPlan.
        If this is defined, then backupRetainDays must also be defined.
        """
        return pulumi.get(self, "cron_schedule")

    @property
    @pulumi.getter
    def paused(self) -> Optional[bool]:
        """
        This flag denotes whether automatic Backup creation is paused for this BackupPlan.
        """
        return pulumi.get(self, "paused")


@pulumi.output_type
class BackupPlanRetentionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupDeleteLockDays":
            suggest = "backup_delete_lock_days"
        elif key == "backupRetainDays":
            suggest = "backup_retain_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupPlanRetentionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupPlanRetentionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupPlanRetentionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_delete_lock_days: Optional[int] = None,
                 backup_retain_days: Optional[int] = None,
                 locked: Optional[bool] = None):
        """
        :param int backup_delete_lock_days: Minimum age for a Backup created via this BackupPlan (in days).
               Must be an integer value between 0-90 (inclusive).
               A Backup created under this BackupPlan will not be deletable
               until it reaches Backup's (create time + backup_delete_lock_days).
               Updating this field of a BackupPlan does not affect existing Backups.
               Backups created after a successful update will inherit this new value.
        :param int backup_retain_days: The default maximum age of a Backup created via this BackupPlan.
               This field MUST be an integer value >= 0 and <= 365. If specified,
               a Backup created under this BackupPlan will be automatically deleted
               after its age reaches (createTime + backupRetainDays).
               If not specified, Backups created under this BackupPlan will NOT be
               subject to automatic deletion. Updating this field does NOT affect
               existing Backups under it. Backups created AFTER a successful update
               will automatically pick up the new value.
               NOTE: backupRetainDays must be >= backupDeleteLockDays.
               If cronSchedule is defined, then this must be <= 360 * the creation interval.]
        :param bool locked: This flag denotes whether the retention policy of this BackupPlan is locked.
               If set to True, no further update is allowed on this policy, including
               the locked field itself.
        """
        if backup_delete_lock_days is not None:
            pulumi.set(__self__, "backup_delete_lock_days", backup_delete_lock_days)
        if backup_retain_days is not None:
            pulumi.set(__self__, "backup_retain_days", backup_retain_days)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)

    @property
    @pulumi.getter(name="backupDeleteLockDays")
    def backup_delete_lock_days(self) -> Optional[int]:
        """
        Minimum age for a Backup created via this BackupPlan (in days).
        Must be an integer value between 0-90 (inclusive).
        A Backup created under this BackupPlan will not be deletable
        until it reaches Backup's (create time + backup_delete_lock_days).
        Updating this field of a BackupPlan does not affect existing Backups.
        Backups created after a successful update will inherit this new value.
        """
        return pulumi.get(self, "backup_delete_lock_days")

    @property
    @pulumi.getter(name="backupRetainDays")
    def backup_retain_days(self) -> Optional[int]:
        """
        The default maximum age of a Backup created via this BackupPlan.
        This field MUST be an integer value >= 0 and <= 365. If specified,
        a Backup created under this BackupPlan will be automatically deleted
        after its age reaches (createTime + backupRetainDays).
        If not specified, Backups created under this BackupPlan will NOT be
        subject to automatic deletion. Updating this field does NOT affect
        existing Backups under it. Backups created AFTER a successful update
        will automatically pick up the new value.
        NOTE: backupRetainDays must be >= backupDeleteLockDays.
        If cronSchedule is defined, then this must be <= 360 * the creation interval.]
        """
        return pulumi.get(self, "backup_retain_days")

    @property
    @pulumi.getter
    def locked(self) -> Optional[bool]:
        """
        This flag denotes whether the retention policy of this BackupPlan is locked.
        If set to True, no further update is allowed on this policy, including
        the locked field itself.
        """
        return pulumi.get(self, "locked")


