# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ClientArgs', 'Client']

@pulumi.input_type
class ClientArgs:
    def __init__(__self__, *,
                 brand: pulumi.Input[str],
                 display_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a Client resource.
        :param pulumi.Input[str] brand: Identifier of the brand to which this client
               is attached to. The format is
               `projects/{project_number}/brands/{brand_id}/identityAwareProxyClients/{client_id}`.
        :param pulumi.Input[str] display_name: Human-friendly name given to the OAuth client.
        """
        pulumi.set(__self__, "brand", brand)
        pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def brand(self) -> pulumi.Input[str]:
        """
        Identifier of the brand to which this client
        is attached to. The format is
        `projects/{project_number}/brands/{brand_id}/identityAwareProxyClients/{client_id}`.
        """
        return pulumi.get(self, "brand")

    @brand.setter
    def brand(self, value: pulumi.Input[str]):
        pulumi.set(self, "brand", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        Human-friendly name given to the OAuth client.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)


@pulumi.input_type
class _ClientState:
    def __init__(__self__, *,
                 brand: Optional[pulumi.Input[str]] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 secret: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Client resources.
        :param pulumi.Input[str] brand: Identifier of the brand to which this client
               is attached to. The format is
               `projects/{project_number}/brands/{brand_id}/identityAwareProxyClients/{client_id}`.
        :param pulumi.Input[str] client_id: The OAuth2 ID of the client.
        :param pulumi.Input[str] display_name: Human-friendly name given to the OAuth client.
        :param pulumi.Input[str] secret: Output only. Client secret of the OAuth client.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        if brand is not None:
            pulumi.set(__self__, "brand", brand)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter
    def brand(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the brand to which this client
        is attached to. The format is
        `projects/{project_number}/brands/{brand_id}/identityAwareProxyClients/{client_id}`.
        """
        return pulumi.get(self, "brand")

    @brand.setter
    def brand(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "brand", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OAuth2 ID of the client.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-friendly name given to the OAuth client.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Client secret of the OAuth client.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)


class Client(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 brand: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Contains the data that describes an Identity Aware Proxy owned client.

        > **Note:** Only internal org clients can be created via declarative tools. External clients must be
        manually created via the GCP console. This restriction is due to the existing APIs and not lack of support
        in this tool.

        To get more information about Client, see:

        * [API documentation](https://cloud.google.com/iap/docs/reference/rest/v1/projects.brands.identityAwareProxyClients)
        * How-to Guides
            * [Setting up IAP Client](https://cloud.google.com/iap/docs/authentication-howto)

        > **Warning:** All arguments including `secret` will be stored in the raw
        state as plain-text.

        ## Example Usage
        ### Iap Client

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="tf-test",
            org_id="123456789")
        project_service = gcp.projects.Service("projectService",
            project=project.project_id,
            service="iap.googleapis.com")
        project_brand = gcp.iap.Brand("projectBrand",
            support_email="support@example.com",
            application_title="Cloud IAP protected Application",
            project=project_service.project)
        project_client = gcp.iap.Client("projectClient",
            display_name="Test Client",
            brand=project_brand.name)
        ```

        ## Import

        Client can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:iap/client:Client default {{brand}}/identityAwareProxyClients/{{client_id}}
        ```

        ```sh
         $ pulumi import gcp:iap/client:Client default {{brand}}/{{client_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] brand: Identifier of the brand to which this client
               is attached to. The format is
               `projects/{project_number}/brands/{brand_id}/identityAwareProxyClients/{client_id}`.
        :param pulumi.Input[str] display_name: Human-friendly name given to the OAuth client.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClientArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Contains the data that describes an Identity Aware Proxy owned client.

        > **Note:** Only internal org clients can be created via declarative tools. External clients must be
        manually created via the GCP console. This restriction is due to the existing APIs and not lack of support
        in this tool.

        To get more information about Client, see:

        * [API documentation](https://cloud.google.com/iap/docs/reference/rest/v1/projects.brands.identityAwareProxyClients)
        * How-to Guides
            * [Setting up IAP Client](https://cloud.google.com/iap/docs/authentication-howto)

        > **Warning:** All arguments including `secret` will be stored in the raw
        state as plain-text.

        ## Example Usage
        ### Iap Client

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="tf-test",
            org_id="123456789")
        project_service = gcp.projects.Service("projectService",
            project=project.project_id,
            service="iap.googleapis.com")
        project_brand = gcp.iap.Brand("projectBrand",
            support_email="support@example.com",
            application_title="Cloud IAP protected Application",
            project=project_service.project)
        project_client = gcp.iap.Client("projectClient",
            display_name="Test Client",
            brand=project_brand.name)
        ```

        ## Import

        Client can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:iap/client:Client default {{brand}}/identityAwareProxyClients/{{client_id}}
        ```

        ```sh
         $ pulumi import gcp:iap/client:Client default {{brand}}/{{client_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ClientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 brand: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClientArgs.__new__(ClientArgs)

            if brand is None and not opts.urn:
                raise TypeError("Missing required property 'brand'")
            __props__.__dict__["brand"] = brand
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["client_id"] = None
            __props__.__dict__["secret"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Client, __self__).__init__(
            'gcp:iap/client:Client',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            brand: Optional[pulumi.Input[str]] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            secret: Optional[pulumi.Input[str]] = None) -> 'Client':
        """
        Get an existing Client resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] brand: Identifier of the brand to which this client
               is attached to. The format is
               `projects/{project_number}/brands/{brand_id}/identityAwareProxyClients/{client_id}`.
        :param pulumi.Input[str] client_id: The OAuth2 ID of the client.
        :param pulumi.Input[str] display_name: Human-friendly name given to the OAuth client.
        :param pulumi.Input[str] secret: Output only. Client secret of the OAuth client.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClientState.__new__(_ClientState)

        __props__.__dict__["brand"] = brand
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["secret"] = secret
        return Client(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def brand(self) -> pulumi.Output[str]:
        """
        Identifier of the brand to which this client
        is attached to. The format is
        `projects/{project_number}/brands/{brand_id}/identityAwareProxyClients/{client_id}`.
        """
        return pulumi.get(self, "brand")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        The OAuth2 ID of the client.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Human-friendly name given to the OAuth client.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Output[str]:
        """
        Output only. Client secret of the OAuth client.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "secret")

