# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertPolicyArgs', 'AlertPolicy']

@pulumi.input_type
class AlertPolicyArgs:
    def __init__(__self__, *,
                 combiner: pulumi.Input[str],
                 conditions: pulumi.Input[Sequence[pulumi.Input['AlertPolicyConditionArgs']]],
                 display_name: pulumi.Input[str],
                 alert_strategy: Optional[pulumi.Input['AlertPolicyAlertStrategyArgs']] = None,
                 documentation: Optional[pulumi.Input['AlertPolicyDocumentationArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 notification_channels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AlertPolicy resource.
        :param pulumi.Input[str] combiner: How to combine the results of multiple conditions to
               determine if an incident should be opened.
               Possible values are `AND`, `OR`, and `AND_WITH_MATCHING_RESOURCE`.
        :param pulumi.Input[Sequence[pulumi.Input['AlertPolicyConditionArgs']]] conditions: A list of conditions for the policy. The conditions are combined by
               AND or OR according to the combiner field. If the combined conditions
               evaluate to true, then an incident is created. A policy can have from
               one to six conditions.
               Structure is documented below.
        :param pulumi.Input[str] display_name: A short name or phrase used to identify the policy in
               dashboards, notifications, and incidents. To avoid confusion, don't use
               the same display name for multiple policies in the same project. The
               name is limited to 512 Unicode characters.
        :param pulumi.Input['AlertPolicyAlertStrategyArgs'] alert_strategy: Control over how this alert policy's notification channels are notified.
               Structure is documented below.
        :param pulumi.Input['AlertPolicyDocumentationArgs'] documentation: Documentation that is included with notifications and incidents related
               to this policy. Best practice is for the documentation to include information
               to help responders understand, mitigate, escalate, and correct the underlying
               problems detected by the alerting policy. Notification channels that have
               limited capacity might not show this documentation.
               Structure is documented below.
        :param pulumi.Input[bool] enabled: Whether or not the policy is enabled. The default is true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_channels: Identifies the notification channels to which notifications should be
               sent when incidents are opened or closed or when new violations occur
               on an already opened incident. Each element of this array corresponds
               to the name field in each of the NotificationChannel objects that are
               returned from the notificationChannels.list method. The syntax of the
               entries in this field is
               `projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]`
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: This field is intended to be used for organizing and identifying the AlertPolicy
               objects.The field can contain up to 64 entries. Each key and value is limited
               to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
               can contain only lowercase letters, numerals, underscores, and dashes. Keys
               must begin with a letter.
        """
        pulumi.set(__self__, "combiner", combiner)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "display_name", display_name)
        if alert_strategy is not None:
            pulumi.set(__self__, "alert_strategy", alert_strategy)
        if documentation is not None:
            pulumi.set(__self__, "documentation", documentation)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if notification_channels is not None:
            pulumi.set(__self__, "notification_channels", notification_channels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)

    @property
    @pulumi.getter
    def combiner(self) -> pulumi.Input[str]:
        """
        How to combine the results of multiple conditions to
        determine if an incident should be opened.
        Possible values are `AND`, `OR`, and `AND_WITH_MATCHING_RESOURCE`.
        """
        return pulumi.get(self, "combiner")

    @combiner.setter
    def combiner(self, value: pulumi.Input[str]):
        pulumi.set(self, "combiner", value)

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Input[Sequence[pulumi.Input['AlertPolicyConditionArgs']]]:
        """
        A list of conditions for the policy. The conditions are combined by
        AND or OR according to the combiner field. If the combined conditions
        evaluate to true, then an incident is created. A policy can have from
        one to six conditions.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: pulumi.Input[Sequence[pulumi.Input['AlertPolicyConditionArgs']]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        A short name or phrase used to identify the policy in
        dashboards, notifications, and incidents. To avoid confusion, don't use
        the same display name for multiple policies in the same project. The
        name is limited to 512 Unicode characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="alertStrategy")
    def alert_strategy(self) -> Optional[pulumi.Input['AlertPolicyAlertStrategyArgs']]:
        """
        Control over how this alert policy's notification channels are notified.
        Structure is documented below.
        """
        return pulumi.get(self, "alert_strategy")

    @alert_strategy.setter
    def alert_strategy(self, value: Optional[pulumi.Input['AlertPolicyAlertStrategyArgs']]):
        pulumi.set(self, "alert_strategy", value)

    @property
    @pulumi.getter
    def documentation(self) -> Optional[pulumi.Input['AlertPolicyDocumentationArgs']]:
        """
        Documentation that is included with notifications and incidents related
        to this policy. Best practice is for the documentation to include information
        to help responders understand, mitigate, escalate, and correct the underlying
        problems detected by the alerting policy. Notification channels that have
        limited capacity might not show this documentation.
        Structure is documented below.
        """
        return pulumi.get(self, "documentation")

    @documentation.setter
    def documentation(self, value: Optional[pulumi.Input['AlertPolicyDocumentationArgs']]):
        pulumi.set(self, "documentation", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the policy is enabled. The default is true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="notificationChannels")
    def notification_channels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Identifies the notification channels to which notifications should be
        sent when incidents are opened or closed or when new violations occur
        on an already opened incident. Each element of this array corresponds
        to the name field in each of the NotificationChannel objects that are
        returned from the notificationChannels.list method. The syntax of the
        entries in this field is
        `projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]`
        """
        return pulumi.get(self, "notification_channels")

    @notification_channels.setter
    def notification_channels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notification_channels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        This field is intended to be used for organizing and identifying the AlertPolicy
        objects.The field can contain up to 64 entries. Each key and value is limited
        to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
        can contain only lowercase letters, numerals, underscores, and dashes. Keys
        must begin with a letter.
        """
        return pulumi.get(self, "user_labels")

    @user_labels.setter
    def user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_labels", value)


@pulumi.input_type
class _AlertPolicyState:
    def __init__(__self__, *,
                 alert_strategy: Optional[pulumi.Input['AlertPolicyAlertStrategyArgs']] = None,
                 combiner: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyConditionArgs']]]] = None,
                 creation_records: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyCreationRecordArgs']]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 documentation: Optional[pulumi.Input['AlertPolicyDocumentationArgs']] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_channels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering AlertPolicy resources.
        :param pulumi.Input['AlertPolicyAlertStrategyArgs'] alert_strategy: Control over how this alert policy's notification channels are notified.
               Structure is documented below.
        :param pulumi.Input[str] combiner: How to combine the results of multiple conditions to
               determine if an incident should be opened.
               Possible values are `AND`, `OR`, and `AND_WITH_MATCHING_RESOURCE`.
        :param pulumi.Input[Sequence[pulumi.Input['AlertPolicyConditionArgs']]] conditions: A list of conditions for the policy. The conditions are combined by
               AND or OR according to the combiner field. If the combined conditions
               evaluate to true, then an incident is created. A policy can have from
               one to six conditions.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['AlertPolicyCreationRecordArgs']]] creation_records: A read-only record of the creation of the alerting policy.
               If provided in a call to create or update, this field will
               be ignored.
               Structure is documented below.
        :param pulumi.Input[str] display_name: A short name or phrase used to identify the policy in
               dashboards, notifications, and incidents. To avoid confusion, don't use
               the same display name for multiple policies in the same project. The
               name is limited to 512 Unicode characters.
        :param pulumi.Input['AlertPolicyDocumentationArgs'] documentation: Documentation that is included with notifications and incidents related
               to this policy. Best practice is for the documentation to include information
               to help responders understand, mitigate, escalate, and correct the underlying
               problems detected by the alerting policy. Notification channels that have
               limited capacity might not show this documentation.
               Structure is documented below.
        :param pulumi.Input[bool] enabled: Whether or not the policy is enabled. The default is true.
        :param pulumi.Input[str] name: The unique resource name for this condition.
               Its syntax is:
               projects/[PROJECT_ID]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
               [CONDITION_ID] is assigned by Stackdriver Monitoring when
               the condition is created as part of a new or updated alerting
               policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_channels: Identifies the notification channels to which notifications should be
               sent when incidents are opened or closed or when new violations occur
               on an already opened incident. Each element of this array corresponds
               to the name field in each of the NotificationChannel objects that are
               returned from the notificationChannels.list method. The syntax of the
               entries in this field is
               `projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]`
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: This field is intended to be used for organizing and identifying the AlertPolicy
               objects.The field can contain up to 64 entries. Each key and value is limited
               to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
               can contain only lowercase letters, numerals, underscores, and dashes. Keys
               must begin with a letter.
        """
        if alert_strategy is not None:
            pulumi.set(__self__, "alert_strategy", alert_strategy)
        if combiner is not None:
            pulumi.set(__self__, "combiner", combiner)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if creation_records is not None:
            pulumi.set(__self__, "creation_records", creation_records)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if documentation is not None:
            pulumi.set(__self__, "documentation", documentation)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_channels is not None:
            pulumi.set(__self__, "notification_channels", notification_channels)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)

    @property
    @pulumi.getter(name="alertStrategy")
    def alert_strategy(self) -> Optional[pulumi.Input['AlertPolicyAlertStrategyArgs']]:
        """
        Control over how this alert policy's notification channels are notified.
        Structure is documented below.
        """
        return pulumi.get(self, "alert_strategy")

    @alert_strategy.setter
    def alert_strategy(self, value: Optional[pulumi.Input['AlertPolicyAlertStrategyArgs']]):
        pulumi.set(self, "alert_strategy", value)

    @property
    @pulumi.getter
    def combiner(self) -> Optional[pulumi.Input[str]]:
        """
        How to combine the results of multiple conditions to
        determine if an incident should be opened.
        Possible values are `AND`, `OR`, and `AND_WITH_MATCHING_RESOURCE`.
        """
        return pulumi.get(self, "combiner")

    @combiner.setter
    def combiner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "combiner", value)

    @property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyConditionArgs']]]]:
        """
        A list of conditions for the policy. The conditions are combined by
        AND or OR according to the combiner field. If the combined conditions
        evaluate to true, then an incident is created. A policy can have from
        one to six conditions.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @property
    @pulumi.getter(name="creationRecords")
    def creation_records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyCreationRecordArgs']]]]:
        """
        A read-only record of the creation of the alerting policy.
        If provided in a call to create or update, this field will
        be ignored.
        Structure is documented below.
        """
        return pulumi.get(self, "creation_records")

    @creation_records.setter
    def creation_records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPolicyCreationRecordArgs']]]]):
        pulumi.set(self, "creation_records", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A short name or phrase used to identify the policy in
        dashboards, notifications, and incidents. To avoid confusion, don't use
        the same display name for multiple policies in the same project. The
        name is limited to 512 Unicode characters.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def documentation(self) -> Optional[pulumi.Input['AlertPolicyDocumentationArgs']]:
        """
        Documentation that is included with notifications and incidents related
        to this policy. Best practice is for the documentation to include information
        to help responders understand, mitigate, escalate, and correct the underlying
        problems detected by the alerting policy. Notification channels that have
        limited capacity might not show this documentation.
        Structure is documented below.
        """
        return pulumi.get(self, "documentation")

    @documentation.setter
    def documentation(self, value: Optional[pulumi.Input['AlertPolicyDocumentationArgs']]):
        pulumi.set(self, "documentation", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the policy is enabled. The default is true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique resource name for this condition.
        Its syntax is:
        projects/[PROJECT_ID]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
        [CONDITION_ID] is assigned by Stackdriver Monitoring when
        the condition is created as part of a new or updated alerting
        policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationChannels")
    def notification_channels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Identifies the notification channels to which notifications should be
        sent when incidents are opened or closed or when new violations occur
        on an already opened incident. Each element of this array corresponds
        to the name field in each of the NotificationChannel objects that are
        returned from the notificationChannels.list method. The syntax of the
        entries in this field is
        `projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]`
        """
        return pulumi.get(self, "notification_channels")

    @notification_channels.setter
    def notification_channels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notification_channels", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        This field is intended to be used for organizing and identifying the AlertPolicy
        objects.The field can contain up to 64 entries. Each key and value is limited
        to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
        can contain only lowercase letters, numerals, underscores, and dashes. Keys
        must begin with a letter.
        """
        return pulumi.get(self, "user_labels")

    @user_labels.setter
    def user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_labels", value)


class AlertPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_strategy: Optional[pulumi.Input[pulumi.InputType['AlertPolicyAlertStrategyArgs']]] = None,
                 combiner: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertPolicyConditionArgs']]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 documentation: Optional[pulumi.Input[pulumi.InputType['AlertPolicyDocumentationArgs']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 notification_channels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        A description of the conditions under which some aspect of your system is
        considered to be "unhealthy" and the ways to notify people or services
        about this state.

        To get more information about AlertPolicy, see:

        * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.alertPolicies)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/monitoring/alerts/)

        ## Example Usage
        ### Monitoring Alert Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        alert_policy = gcp.monitoring.AlertPolicy("alertPolicy",
            combiner="OR",
            conditions=[gcp.monitoring.AlertPolicyConditionArgs(
                condition_threshold=gcp.monitoring.AlertPolicyConditionConditionThresholdArgs(
                    aggregations=[gcp.monitoring.AlertPolicyConditionConditionThresholdAggregationArgs(
                        alignment_period="60s",
                        per_series_aligner="ALIGN_RATE",
                    )],
                    comparison="COMPARISON_GT",
                    duration="60s",
                    filter="metric.type=\\"compute.googleapis.com/instance/disk/write_bytes_count\\" AND resource.type=\\"gce_instance\\"",
                ),
                display_name="test condition",
            )],
            display_name="My Alert Policy",
            user_labels={
                "foo": "bar",
            })
        ```
        ### Monitoring Alert Policy Evaluation Missing Data

        ```python
        import pulumi
        import pulumi_gcp as gcp

        alert_policy = gcp.monitoring.AlertPolicy("alertPolicy",
            combiner="OR",
            conditions=[gcp.monitoring.AlertPolicyConditionArgs(
                condition_threshold=gcp.monitoring.AlertPolicyConditionConditionThresholdArgs(
                    aggregations=[gcp.monitoring.AlertPolicyConditionConditionThresholdAggregationArgs(
                        alignment_period="60s",
                        per_series_aligner="ALIGN_RATE",
                    )],
                    comparison="COMPARISON_GT",
                    duration="60s",
                    evaluation_missing_data="EVALUATION_MISSING_DATA_INACTIVE",
                    filter="metric.type=\\"compute.googleapis.com/instance/disk/write_bytes_count\\" AND resource.type=\\"gce_instance\\"",
                ),
                display_name="test condition",
            )],
            display_name="My Alert Policy",
            user_labels={
                "foo": "bar",
            })
        ```

        ## Import

        AlertPolicy can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:monitoring/alertPolicy:AlertPolicy default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AlertPolicyAlertStrategyArgs']] alert_strategy: Control over how this alert policy's notification channels are notified.
               Structure is documented below.
        :param pulumi.Input[str] combiner: How to combine the results of multiple conditions to
               determine if an incident should be opened.
               Possible values are `AND`, `OR`, and `AND_WITH_MATCHING_RESOURCE`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertPolicyConditionArgs']]]] conditions: A list of conditions for the policy. The conditions are combined by
               AND or OR according to the combiner field. If the combined conditions
               evaluate to true, then an incident is created. A policy can have from
               one to six conditions.
               Structure is documented below.
        :param pulumi.Input[str] display_name: A short name or phrase used to identify the policy in
               dashboards, notifications, and incidents. To avoid confusion, don't use
               the same display name for multiple policies in the same project. The
               name is limited to 512 Unicode characters.
        :param pulumi.Input[pulumi.InputType['AlertPolicyDocumentationArgs']] documentation: Documentation that is included with notifications and incidents related
               to this policy. Best practice is for the documentation to include information
               to help responders understand, mitigate, escalate, and correct the underlying
               problems detected by the alerting policy. Notification channels that have
               limited capacity might not show this documentation.
               Structure is documented below.
        :param pulumi.Input[bool] enabled: Whether or not the policy is enabled. The default is true.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_channels: Identifies the notification channels to which notifications should be
               sent when incidents are opened or closed or when new violations occur
               on an already opened incident. Each element of this array corresponds
               to the name field in each of the NotificationChannel objects that are
               returned from the notificationChannels.list method. The syntax of the
               entries in this field is
               `projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]`
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: This field is intended to be used for organizing and identifying the AlertPolicy
               objects.The field can contain up to 64 entries. Each key and value is limited
               to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
               can contain only lowercase letters, numerals, underscores, and dashes. Keys
               must begin with a letter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A description of the conditions under which some aspect of your system is
        considered to be "unhealthy" and the ways to notify people or services
        about this state.

        To get more information about AlertPolicy, see:

        * [API documentation](https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.alertPolicies)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/monitoring/alerts/)

        ## Example Usage
        ### Monitoring Alert Policy Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        alert_policy = gcp.monitoring.AlertPolicy("alertPolicy",
            combiner="OR",
            conditions=[gcp.monitoring.AlertPolicyConditionArgs(
                condition_threshold=gcp.monitoring.AlertPolicyConditionConditionThresholdArgs(
                    aggregations=[gcp.monitoring.AlertPolicyConditionConditionThresholdAggregationArgs(
                        alignment_period="60s",
                        per_series_aligner="ALIGN_RATE",
                    )],
                    comparison="COMPARISON_GT",
                    duration="60s",
                    filter="metric.type=\\"compute.googleapis.com/instance/disk/write_bytes_count\\" AND resource.type=\\"gce_instance\\"",
                ),
                display_name="test condition",
            )],
            display_name="My Alert Policy",
            user_labels={
                "foo": "bar",
            })
        ```
        ### Monitoring Alert Policy Evaluation Missing Data

        ```python
        import pulumi
        import pulumi_gcp as gcp

        alert_policy = gcp.monitoring.AlertPolicy("alertPolicy",
            combiner="OR",
            conditions=[gcp.monitoring.AlertPolicyConditionArgs(
                condition_threshold=gcp.monitoring.AlertPolicyConditionConditionThresholdArgs(
                    aggregations=[gcp.monitoring.AlertPolicyConditionConditionThresholdAggregationArgs(
                        alignment_period="60s",
                        per_series_aligner="ALIGN_RATE",
                    )],
                    comparison="COMPARISON_GT",
                    duration="60s",
                    evaluation_missing_data="EVALUATION_MISSING_DATA_INACTIVE",
                    filter="metric.type=\\"compute.googleapis.com/instance/disk/write_bytes_count\\" AND resource.type=\\"gce_instance\\"",
                ),
                display_name="test condition",
            )],
            display_name="My Alert Policy",
            user_labels={
                "foo": "bar",
            })
        ```

        ## Import

        AlertPolicy can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:monitoring/alertPolicy:AlertPolicy default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AlertPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_strategy: Optional[pulumi.Input[pulumi.InputType['AlertPolicyAlertStrategyArgs']]] = None,
                 combiner: Optional[pulumi.Input[str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertPolicyConditionArgs']]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 documentation: Optional[pulumi.Input[pulumi.InputType['AlertPolicyDocumentationArgs']]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 notification_channels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertPolicyArgs.__new__(AlertPolicyArgs)

            __props__.__dict__["alert_strategy"] = alert_strategy
            if combiner is None and not opts.urn:
                raise TypeError("Missing required property 'combiner'")
            __props__.__dict__["combiner"] = combiner
            if conditions is None and not opts.urn:
                raise TypeError("Missing required property 'conditions'")
            __props__.__dict__["conditions"] = conditions
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["documentation"] = documentation
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["notification_channels"] = notification_channels
            __props__.__dict__["project"] = project
            __props__.__dict__["user_labels"] = user_labels
            __props__.__dict__["creation_records"] = None
            __props__.__dict__["name"] = None
        super(AlertPolicy, __self__).__init__(
            'gcp:monitoring/alertPolicy:AlertPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_strategy: Optional[pulumi.Input[pulumi.InputType['AlertPolicyAlertStrategyArgs']]] = None,
            combiner: Optional[pulumi.Input[str]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertPolicyConditionArgs']]]]] = None,
            creation_records: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertPolicyCreationRecordArgs']]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            documentation: Optional[pulumi.Input[pulumi.InputType['AlertPolicyDocumentationArgs']]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            notification_channels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            project: Optional[pulumi.Input[str]] = None,
            user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'AlertPolicy':
        """
        Get an existing AlertPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AlertPolicyAlertStrategyArgs']] alert_strategy: Control over how this alert policy's notification channels are notified.
               Structure is documented below.
        :param pulumi.Input[str] combiner: How to combine the results of multiple conditions to
               determine if an incident should be opened.
               Possible values are `AND`, `OR`, and `AND_WITH_MATCHING_RESOURCE`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertPolicyConditionArgs']]]] conditions: A list of conditions for the policy. The conditions are combined by
               AND or OR according to the combiner field. If the combined conditions
               evaluate to true, then an incident is created. A policy can have from
               one to six conditions.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlertPolicyCreationRecordArgs']]]] creation_records: A read-only record of the creation of the alerting policy.
               If provided in a call to create or update, this field will
               be ignored.
               Structure is documented below.
        :param pulumi.Input[str] display_name: A short name or phrase used to identify the policy in
               dashboards, notifications, and incidents. To avoid confusion, don't use
               the same display name for multiple policies in the same project. The
               name is limited to 512 Unicode characters.
        :param pulumi.Input[pulumi.InputType['AlertPolicyDocumentationArgs']] documentation: Documentation that is included with notifications and incidents related
               to this policy. Best practice is for the documentation to include information
               to help responders understand, mitigate, escalate, and correct the underlying
               problems detected by the alerting policy. Notification channels that have
               limited capacity might not show this documentation.
               Structure is documented below.
        :param pulumi.Input[bool] enabled: Whether or not the policy is enabled. The default is true.
        :param pulumi.Input[str] name: The unique resource name for this condition.
               Its syntax is:
               projects/[PROJECT_ID]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
               [CONDITION_ID] is assigned by Stackdriver Monitoring when
               the condition is created as part of a new or updated alerting
               policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notification_channels: Identifies the notification channels to which notifications should be
               sent when incidents are opened or closed or when new violations occur
               on an already opened incident. Each element of this array corresponds
               to the name field in each of the NotificationChannel objects that are
               returned from the notificationChannels.list method. The syntax of the
               entries in this field is
               `projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]`
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: This field is intended to be used for organizing and identifying the AlertPolicy
               objects.The field can contain up to 64 entries. Each key and value is limited
               to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
               can contain only lowercase letters, numerals, underscores, and dashes. Keys
               must begin with a letter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertPolicyState.__new__(_AlertPolicyState)

        __props__.__dict__["alert_strategy"] = alert_strategy
        __props__.__dict__["combiner"] = combiner
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["creation_records"] = creation_records
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["documentation"] = documentation
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_channels"] = notification_channels
        __props__.__dict__["project"] = project
        __props__.__dict__["user_labels"] = user_labels
        return AlertPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alertStrategy")
    def alert_strategy(self) -> pulumi.Output[Optional['outputs.AlertPolicyAlertStrategy']]:
        """
        Control over how this alert policy's notification channels are notified.
        Structure is documented below.
        """
        return pulumi.get(self, "alert_strategy")

    @property
    @pulumi.getter
    def combiner(self) -> pulumi.Output[str]:
        """
        How to combine the results of multiple conditions to
        determine if an incident should be opened.
        Possible values are `AND`, `OR`, and `AND_WITH_MATCHING_RESOURCE`.
        """
        return pulumi.get(self, "combiner")

    @property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.AlertPolicyCondition']]:
        """
        A list of conditions for the policy. The conditions are combined by
        AND or OR according to the combiner field. If the combined conditions
        evaluate to true, then an incident is created. A policy can have from
        one to six conditions.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="creationRecords")
    def creation_records(self) -> pulumi.Output[Sequence['outputs.AlertPolicyCreationRecord']]:
        """
        A read-only record of the creation of the alerting policy.
        If provided in a call to create or update, this field will
        be ignored.
        Structure is documented below.
        """
        return pulumi.get(self, "creation_records")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        A short name or phrase used to identify the policy in
        dashboards, notifications, and incidents. To avoid confusion, don't use
        the same display name for multiple policies in the same project. The
        name is limited to 512 Unicode characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def documentation(self) -> pulumi.Output[Optional['outputs.AlertPolicyDocumentation']]:
        """
        Documentation that is included with notifications and incidents related
        to this policy. Best practice is for the documentation to include information
        to help responders understand, mitigate, escalate, and correct the underlying
        problems detected by the alerting policy. Notification channels that have
        limited capacity might not show this documentation.
        Structure is documented below.
        """
        return pulumi.get(self, "documentation")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not the policy is enabled. The default is true.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The unique resource name for this condition.
        Its syntax is:
        projects/[PROJECT_ID]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
        [CONDITION_ID] is assigned by Stackdriver Monitoring when
        the condition is created as part of a new or updated alerting
        policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationChannels")
    def notification_channels(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Identifies the notification channels to which notifications should be
        sent when incidents are opened or closed or when new violations occur
        on an already opened incident. Each element of this array corresponds
        to the name field in each of the NotificationChannel objects that are
        returned from the notificationChannels.list method. The syntax of the
        entries in this field is
        `projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]`
        """
        return pulumi.get(self, "notification_channels")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        This field is intended to be used for organizing and identifying the AlertPolicy
        objects.The field can contain up to 64 entries. Each key and value is limited
        to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
        can contain only lowercase letters, numerals, underscores, and dashes. Keys
        must begin with a letter.
        """
        return pulumi.get(self, "user_labels")

