# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OsPolicyAssignmentArgs', 'OsPolicyAssignment']

@pulumi.input_type
class OsPolicyAssignmentArgs:
    def __init__(__self__, *,
                 instance_filter: pulumi.Input['OsPolicyAssignmentInstanceFilterArgs'],
                 location: pulumi.Input[str],
                 os_policies: pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]],
                 rollout: pulumi.Input['OsPolicyAssignmentRolloutArgs'],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 skip_await_rollout: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a OsPolicyAssignment resource.
        :param pulumi.Input['OsPolicyAssignmentInstanceFilterArgs'] instance_filter: Required. Filter to select VMs.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]] os_policies: Required. List of OS policies to be applied to the VMs.
        :param pulumi.Input['OsPolicyAssignmentRolloutArgs'] rollout: Required. Rollout to deploy the OS policy assignment. A rollout is triggered in the following situations: 1) OSPolicyAssignment is created. 2) OSPolicyAssignment is updated and the update contains changes to one of the following fields: - instance_filter - os_policies 3) OSPolicyAssignment is deleted.
        :param pulumi.Input[str] description: Policy description. Length of the description is limited to 1024 characters.
               (Optional)
               OS policy assignment description. Length of the description is limited to 1024 characters.
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[bool] skip_await_rollout: Set to true to skip awaiting rollout during resource creation and update.
        """
        pulumi.set(__self__, "instance_filter", instance_filter)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "os_policies", os_policies)
        pulumi.set(__self__, "rollout", rollout)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if skip_await_rollout is not None:
            pulumi.set(__self__, "skip_await_rollout", skip_await_rollout)

    @property
    @pulumi.getter(name="instanceFilter")
    def instance_filter(self) -> pulumi.Input['OsPolicyAssignmentInstanceFilterArgs']:
        """
        Required. Filter to select VMs.
        """
        return pulumi.get(self, "instance_filter")

    @instance_filter.setter
    def instance_filter(self, value: pulumi.Input['OsPolicyAssignmentInstanceFilterArgs']):
        pulumi.set(self, "instance_filter", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="osPolicies")
    def os_policies(self) -> pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]]:
        """
        Required. List of OS policies to be applied to the VMs.
        """
        return pulumi.get(self, "os_policies")

    @os_policies.setter
    def os_policies(self, value: pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]]):
        pulumi.set(self, "os_policies", value)

    @property
    @pulumi.getter
    def rollout(self) -> pulumi.Input['OsPolicyAssignmentRolloutArgs']:
        """
        Required. Rollout to deploy the OS policy assignment. A rollout is triggered in the following situations: 1) OSPolicyAssignment is created. 2) OSPolicyAssignment is updated and the update contains changes to one of the following fields: - instance_filter - os_policies 3) OSPolicyAssignment is deleted.
        """
        return pulumi.get(self, "rollout")

    @rollout.setter
    def rollout(self, value: pulumi.Input['OsPolicyAssignmentRolloutArgs']):
        pulumi.set(self, "rollout", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Policy description. Length of the description is limited to 1024 characters.
        (Optional)
        OS policy assignment description. Length of the description is limited to 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="skipAwaitRollout")
    def skip_await_rollout(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true to skip awaiting rollout during resource creation and update.
        """
        return pulumi.get(self, "skip_await_rollout")

    @skip_await_rollout.setter
    def skip_await_rollout(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_await_rollout", value)


@pulumi.input_type
class _OsPolicyAssignmentState:
    def __init__(__self__, *,
                 baseline: Optional[pulumi.Input[bool]] = None,
                 deleted: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 instance_filter: Optional[pulumi.Input['OsPolicyAssignmentInstanceFilterArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_policies: Optional[pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reconciling: Optional[pulumi.Input[bool]] = None,
                 revision_create_time: Optional[pulumi.Input[str]] = None,
                 revision_id: Optional[pulumi.Input[str]] = None,
                 rollout: Optional[pulumi.Input['OsPolicyAssignmentRolloutArgs']] = None,
                 rollout_state: Optional[pulumi.Input[str]] = None,
                 skip_await_rollout: Optional[pulumi.Input[bool]] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OsPolicyAssignment resources.
        :param pulumi.Input[bool] baseline: Output only. Indicates that this revision has been successfully rolled out in this zone and new VMs will be assigned OS policies from this revision. For a given OS policy assignment, there is only one revision with a value of `true` for this field.
        :param pulumi.Input[bool] deleted: Output only. Indicates that this revision deletes the OS policy assignment.
        :param pulumi.Input[str] description: Policy description. Length of the description is limited to 1024 characters.
               (Optional)
               OS policy assignment description. Length of the description is limited to 1024 characters.
        :param pulumi.Input[str] etag: The etag for this OS policy assignment. If this is provided on update, it must match the server's etag.
        :param pulumi.Input['OsPolicyAssignmentInstanceFilterArgs'] instance_filter: Required. Filter to select VMs.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]] os_policies: Required. List of OS policies to be applied to the VMs.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[bool] reconciling: Output only. Indicates that reconciliation is in progress for the revision. This value is `true` when the `rollout_state` is one of: * IN_PROGRESS * CANCELLING
        :param pulumi.Input[str] revision_create_time: Output only. The timestamp that the revision was created.
        :param pulumi.Input[str] revision_id: Output only. The assignment revision ID A new revision is committed whenever a rollout is triggered for a OS policy assignment
        :param pulumi.Input['OsPolicyAssignmentRolloutArgs'] rollout: Required. Rollout to deploy the OS policy assignment. A rollout is triggered in the following situations: 1) OSPolicyAssignment is created. 2) OSPolicyAssignment is updated and the update contains changes to one of the following fields: - instance_filter - os_policies 3) OSPolicyAssignment is deleted.
        :param pulumi.Input[str] rollout_state: Output only. OS policy assignment rollout state Possible values: ROLLOUT_STATE_UNSPECIFIED, IN_PROGRESS, CANCELLING, CANCELLED, SUCCEEDED
        :param pulumi.Input[bool] skip_await_rollout: Set to true to skip awaiting rollout during resource creation and update.
        :param pulumi.Input[str] uid: Output only. Server generated unique id for the OS policy assignment resource.
        """
        if baseline is not None:
            pulumi.set(__self__, "baseline", baseline)
        if deleted is not None:
            pulumi.set(__self__, "deleted", deleted)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if instance_filter is not None:
            pulumi.set(__self__, "instance_filter", instance_filter)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_policies is not None:
            pulumi.set(__self__, "os_policies", os_policies)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if revision_create_time is not None:
            pulumi.set(__self__, "revision_create_time", revision_create_time)
        if revision_id is not None:
            pulumi.set(__self__, "revision_id", revision_id)
        if rollout is not None:
            pulumi.set(__self__, "rollout", rollout)
        if rollout_state is not None:
            pulumi.set(__self__, "rollout_state", rollout_state)
        if skip_await_rollout is not None:
            pulumi.set(__self__, "skip_await_rollout", skip_await_rollout)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def baseline(self) -> Optional[pulumi.Input[bool]]:
        """
        Output only. Indicates that this revision has been successfully rolled out in this zone and new VMs will be assigned OS policies from this revision. For a given OS policy assignment, there is only one revision with a value of `true` for this field.
        """
        return pulumi.get(self, "baseline")

    @baseline.setter
    def baseline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "baseline", value)

    @property
    @pulumi.getter
    def deleted(self) -> Optional[pulumi.Input[bool]]:
        """
        Output only. Indicates that this revision deletes the OS policy assignment.
        """
        return pulumi.get(self, "deleted")

    @deleted.setter
    def deleted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deleted", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Policy description. Length of the description is limited to 1024 characters.
        (Optional)
        OS policy assignment description. Length of the description is limited to 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        The etag for this OS policy assignment. If this is provided on update, it must match the server's etag.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="instanceFilter")
    def instance_filter(self) -> Optional[pulumi.Input['OsPolicyAssignmentInstanceFilterArgs']]:
        """
        Required. Filter to select VMs.
        """
        return pulumi.get(self, "instance_filter")

    @instance_filter.setter
    def instance_filter(self, value: Optional[pulumi.Input['OsPolicyAssignmentInstanceFilterArgs']]):
        pulumi.set(self, "instance_filter", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osPolicies")
    def os_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]]]:
        """
        Required. List of OS policies to be applied to the VMs.
        """
        return pulumi.get(self, "os_policies")

    @os_policies.setter
    def os_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OsPolicyAssignmentOsPolicyArgs']]]]):
        pulumi.set(self, "os_policies", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[bool]]:
        """
        Output only. Indicates that reconciliation is in progress for the revision. This value is `true` when the `rollout_state` is one of: * IN_PROGRESS * CANCELLING
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter(name="revisionCreateTime")
    def revision_create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The timestamp that the revision was created.
        """
        return pulumi.get(self, "revision_create_time")

    @revision_create_time.setter
    def revision_create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_create_time", value)

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. The assignment revision ID A new revision is committed whenever a rollout is triggered for a OS policy assignment
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_id", value)

    @property
    @pulumi.getter
    def rollout(self) -> Optional[pulumi.Input['OsPolicyAssignmentRolloutArgs']]:
        """
        Required. Rollout to deploy the OS policy assignment. A rollout is triggered in the following situations: 1) OSPolicyAssignment is created. 2) OSPolicyAssignment is updated and the update contains changes to one of the following fields: - instance_filter - os_policies 3) OSPolicyAssignment is deleted.
        """
        return pulumi.get(self, "rollout")

    @rollout.setter
    def rollout(self, value: Optional[pulumi.Input['OsPolicyAssignmentRolloutArgs']]):
        pulumi.set(self, "rollout", value)

    @property
    @pulumi.getter(name="rolloutState")
    def rollout_state(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. OS policy assignment rollout state Possible values: ROLLOUT_STATE_UNSPECIFIED, IN_PROGRESS, CANCELLING, CANCELLED, SUCCEEDED
        """
        return pulumi.get(self, "rollout_state")

    @rollout_state.setter
    def rollout_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rollout_state", value)

    @property
    @pulumi.getter(name="skipAwaitRollout")
    def skip_await_rollout(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true to skip awaiting rollout during resource creation and update.
        """
        return pulumi.get(self, "skip_await_rollout")

    @skip_await_rollout.setter
    def skip_await_rollout(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_await_rollout", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        Output only. Server generated unique id for the OS policy assignment resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


class OsPolicyAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_filter: Optional[pulumi.Input[pulumi.InputType['OsPolicyAssignmentInstanceFilterArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OsPolicyAssignmentOsPolicyArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 rollout: Optional[pulumi.Input[pulumi.InputType['OsPolicyAssignmentRolloutArgs']]] = None,
                 skip_await_rollout: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Represents an OSPolicyAssignment resource.

        ## Example Usage
        ### Fixed_os_policy_assignment
        An example of an osconfig os policy assignment with fixed rollout disruption budget
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.osconfig.OsPolicyAssignment("primary",
            description="A test os policy assignment",
            instance_filter=gcp.osconfig.OsPolicyAssignmentInstanceFilterArgs(
                all=False,
                exclusion_labels=[gcp.osconfig.OsPolicyAssignmentInstanceFilterExclusionLabelArgs(
                    labels={
                        "label-two": "value-two",
                    },
                )],
                inclusion_labels=[gcp.osconfig.OsPolicyAssignmentInstanceFilterInclusionLabelArgs(
                    labels={
                        "label-one": "value-one",
                    },
                )],
                inventories=[gcp.osconfig.OsPolicyAssignmentInstanceFilterInventoryArgs(
                    os_short_name="centos",
                    os_version="8.*",
                )],
            ),
            location="us-west1-a",
            os_policies=[gcp.osconfig.OsPolicyAssignmentOsPolicyArgs(
                allow_no_resource_group_match=False,
                description="A test os policy",
                id="policy",
                mode="VALIDATION",
                resource_groups=[gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupArgs(
                    inventory_filters=[gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupInventoryFilterArgs(
                        os_short_name="centos",
                        os_version="8.*",
                    )],
                    resources=[gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                        id="apt",
                        pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                            apt=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgAptArgs(
                                name="bazel",
                            ),
                            desired_state="INSTALLED",
                        ),
                    )],
                )],
            )],
            project="my-project-name",
            rollout=gcp.osconfig.OsPolicyAssignmentRolloutArgs(
                disruption_budget=gcp.osconfig.OsPolicyAssignmentRolloutDisruptionBudgetArgs(
                    fixed=1,
                ),
                min_wait_duration="3.5s",
            ))
        ```

        ## Import

        OSPolicyAssignment can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default projects/{{project}}/locations/{{location}}/osPolicyAssignments/{{name}}
        ```

        ```sh
         $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Policy description. Length of the description is limited to 1024 characters.
               (Optional)
               OS policy assignment description. Length of the description is limited to 1024 characters.
        :param pulumi.Input[pulumi.InputType['OsPolicyAssignmentInstanceFilterArgs']] instance_filter: Required. Filter to select VMs.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OsPolicyAssignmentOsPolicyArgs']]]] os_policies: Required. List of OS policies to be applied to the VMs.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[pulumi.InputType['OsPolicyAssignmentRolloutArgs']] rollout: Required. Rollout to deploy the OS policy assignment. A rollout is triggered in the following situations: 1) OSPolicyAssignment is created. 2) OSPolicyAssignment is updated and the update contains changes to one of the following fields: - instance_filter - os_policies 3) OSPolicyAssignment is deleted.
        :param pulumi.Input[bool] skip_await_rollout: Set to true to skip awaiting rollout during resource creation and update.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OsPolicyAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents an OSPolicyAssignment resource.

        ## Example Usage
        ### Fixed_os_policy_assignment
        An example of an osconfig os policy assignment with fixed rollout disruption budget
        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.osconfig.OsPolicyAssignment("primary",
            description="A test os policy assignment",
            instance_filter=gcp.osconfig.OsPolicyAssignmentInstanceFilterArgs(
                all=False,
                exclusion_labels=[gcp.osconfig.OsPolicyAssignmentInstanceFilterExclusionLabelArgs(
                    labels={
                        "label-two": "value-two",
                    },
                )],
                inclusion_labels=[gcp.osconfig.OsPolicyAssignmentInstanceFilterInclusionLabelArgs(
                    labels={
                        "label-one": "value-one",
                    },
                )],
                inventories=[gcp.osconfig.OsPolicyAssignmentInstanceFilterInventoryArgs(
                    os_short_name="centos",
                    os_version="8.*",
                )],
            ),
            location="us-west1-a",
            os_policies=[gcp.osconfig.OsPolicyAssignmentOsPolicyArgs(
                allow_no_resource_group_match=False,
                description="A test os policy",
                id="policy",
                mode="VALIDATION",
                resource_groups=[gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupArgs(
                    inventory_filters=[gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupInventoryFilterArgs(
                        os_short_name="centos",
                        os_version="8.*",
                    )],
                    resources=[gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourceArgs(
                        id="apt",
                        pkg=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgArgs(
                            apt=gcp.osconfig.OsPolicyAssignmentOsPolicyResourceGroupResourcePkgAptArgs(
                                name="bazel",
                            ),
                            desired_state="INSTALLED",
                        ),
                    )],
                )],
            )],
            project="my-project-name",
            rollout=gcp.osconfig.OsPolicyAssignmentRolloutArgs(
                disruption_budget=gcp.osconfig.OsPolicyAssignmentRolloutDisruptionBudgetArgs(
                    fixed=1,
                ),
                min_wait_duration="3.5s",
            ))
        ```

        ## Import

        OSPolicyAssignment can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default projects/{{project}}/locations/{{location}}/osPolicyAssignments/{{name}}
        ```

        ```sh
         $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default {{project}}/{{location}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:osconfig/osPolicyAssignment:OsPolicyAssignment default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param OsPolicyAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OsPolicyAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_filter: Optional[pulumi.Input[pulumi.InputType['OsPolicyAssignmentInstanceFilterArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OsPolicyAssignmentOsPolicyArgs']]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 rollout: Optional[pulumi.Input[pulumi.InputType['OsPolicyAssignmentRolloutArgs']]] = None,
                 skip_await_rollout: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OsPolicyAssignmentArgs.__new__(OsPolicyAssignmentArgs)

            __props__.__dict__["description"] = description
            if instance_filter is None and not opts.urn:
                raise TypeError("Missing required property 'instance_filter'")
            __props__.__dict__["instance_filter"] = instance_filter
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if os_policies is None and not opts.urn:
                raise TypeError("Missing required property 'os_policies'")
            __props__.__dict__["os_policies"] = os_policies
            __props__.__dict__["project"] = project
            if rollout is None and not opts.urn:
                raise TypeError("Missing required property 'rollout'")
            __props__.__dict__["rollout"] = rollout
            __props__.__dict__["skip_await_rollout"] = skip_await_rollout
            __props__.__dict__["baseline"] = None
            __props__.__dict__["deleted"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["revision_create_time"] = None
            __props__.__dict__["revision_id"] = None
            __props__.__dict__["rollout_state"] = None
            __props__.__dict__["uid"] = None
        super(OsPolicyAssignment, __self__).__init__(
            'gcp:osconfig/osPolicyAssignment:OsPolicyAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            baseline: Optional[pulumi.Input[bool]] = None,
            deleted: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            etag: Optional[pulumi.Input[str]] = None,
            instance_filter: Optional[pulumi.Input[pulumi.InputType['OsPolicyAssignmentInstanceFilterArgs']]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            os_policies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OsPolicyAssignmentOsPolicyArgs']]]]] = None,
            project: Optional[pulumi.Input[str]] = None,
            reconciling: Optional[pulumi.Input[bool]] = None,
            revision_create_time: Optional[pulumi.Input[str]] = None,
            revision_id: Optional[pulumi.Input[str]] = None,
            rollout: Optional[pulumi.Input[pulumi.InputType['OsPolicyAssignmentRolloutArgs']]] = None,
            rollout_state: Optional[pulumi.Input[str]] = None,
            skip_await_rollout: Optional[pulumi.Input[bool]] = None,
            uid: Optional[pulumi.Input[str]] = None) -> 'OsPolicyAssignment':
        """
        Get an existing OsPolicyAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] baseline: Output only. Indicates that this revision has been successfully rolled out in this zone and new VMs will be assigned OS policies from this revision. For a given OS policy assignment, there is only one revision with a value of `true` for this field.
        :param pulumi.Input[bool] deleted: Output only. Indicates that this revision deletes the OS policy assignment.
        :param pulumi.Input[str] description: Policy description. Length of the description is limited to 1024 characters.
               (Optional)
               OS policy assignment description. Length of the description is limited to 1024 characters.
        :param pulumi.Input[str] etag: The etag for this OS policy assignment. If this is provided on update, it must match the server's etag.
        :param pulumi.Input[pulumi.InputType['OsPolicyAssignmentInstanceFilterArgs']] instance_filter: Required. Filter to select VMs.
        :param pulumi.Input[str] location: The location for the resource
        :param pulumi.Input[str] name: Resource name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['OsPolicyAssignmentOsPolicyArgs']]]] os_policies: Required. List of OS policies to be applied to the VMs.
        :param pulumi.Input[str] project: The project for the resource
        :param pulumi.Input[bool] reconciling: Output only. Indicates that reconciliation is in progress for the revision. This value is `true` when the `rollout_state` is one of: * IN_PROGRESS * CANCELLING
        :param pulumi.Input[str] revision_create_time: Output only. The timestamp that the revision was created.
        :param pulumi.Input[str] revision_id: Output only. The assignment revision ID A new revision is committed whenever a rollout is triggered for a OS policy assignment
        :param pulumi.Input[pulumi.InputType['OsPolicyAssignmentRolloutArgs']] rollout: Required. Rollout to deploy the OS policy assignment. A rollout is triggered in the following situations: 1) OSPolicyAssignment is created. 2) OSPolicyAssignment is updated and the update contains changes to one of the following fields: - instance_filter - os_policies 3) OSPolicyAssignment is deleted.
        :param pulumi.Input[str] rollout_state: Output only. OS policy assignment rollout state Possible values: ROLLOUT_STATE_UNSPECIFIED, IN_PROGRESS, CANCELLING, CANCELLED, SUCCEEDED
        :param pulumi.Input[bool] skip_await_rollout: Set to true to skip awaiting rollout during resource creation and update.
        :param pulumi.Input[str] uid: Output only. Server generated unique id for the OS policy assignment resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OsPolicyAssignmentState.__new__(_OsPolicyAssignmentState)

        __props__.__dict__["baseline"] = baseline
        __props__.__dict__["deleted"] = deleted
        __props__.__dict__["description"] = description
        __props__.__dict__["etag"] = etag
        __props__.__dict__["instance_filter"] = instance_filter
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["os_policies"] = os_policies
        __props__.__dict__["project"] = project
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["revision_create_time"] = revision_create_time
        __props__.__dict__["revision_id"] = revision_id
        __props__.__dict__["rollout"] = rollout
        __props__.__dict__["rollout_state"] = rollout_state
        __props__.__dict__["skip_await_rollout"] = skip_await_rollout
        __props__.__dict__["uid"] = uid
        return OsPolicyAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def baseline(self) -> pulumi.Output[bool]:
        """
        Output only. Indicates that this revision has been successfully rolled out in this zone and new VMs will be assigned OS policies from this revision. For a given OS policy assignment, there is only one revision with a value of `true` for this field.
        """
        return pulumi.get(self, "baseline")

    @property
    @pulumi.getter
    def deleted(self) -> pulumi.Output[bool]:
        """
        Output only. Indicates that this revision deletes the OS policy assignment.
        """
        return pulumi.get(self, "deleted")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Policy description. Length of the description is limited to 1024 characters.
        (Optional)
        OS policy assignment description. Length of the description is limited to 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        The etag for this OS policy assignment. If this is provided on update, it must match the server's etag.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="instanceFilter")
    def instance_filter(self) -> pulumi.Output['outputs.OsPolicyAssignmentInstanceFilter']:
        """
        Required. Filter to select VMs.
        """
        return pulumi.get(self, "instance_filter")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osPolicies")
    def os_policies(self) -> pulumi.Output[Sequence['outputs.OsPolicyAssignmentOsPolicy']]:
        """
        Required. List of OS policies to be applied to the VMs.
        """
        return pulumi.get(self, "os_policies")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[bool]:
        """
        Output only. Indicates that reconciliation is in progress for the revision. This value is `true` when the `rollout_state` is one of: * IN_PROGRESS * CANCELLING
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter(name="revisionCreateTime")
    def revision_create_time(self) -> pulumi.Output[str]:
        """
        Output only. The timestamp that the revision was created.
        """
        return pulumi.get(self, "revision_create_time")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> pulumi.Output[str]:
        """
        Output only. The assignment revision ID A new revision is committed whenever a rollout is triggered for a OS policy assignment
        """
        return pulumi.get(self, "revision_id")

    @property
    @pulumi.getter
    def rollout(self) -> pulumi.Output['outputs.OsPolicyAssignmentRollout']:
        """
        Required. Rollout to deploy the OS policy assignment. A rollout is triggered in the following situations: 1) OSPolicyAssignment is created. 2) OSPolicyAssignment is updated and the update contains changes to one of the following fields: - instance_filter - os_policies 3) OSPolicyAssignment is deleted.
        """
        return pulumi.get(self, "rollout")

    @property
    @pulumi.getter(name="rolloutState")
    def rollout_state(self) -> pulumi.Output[str]:
        """
        Output only. OS policy assignment rollout state Possible values: ROLLOUT_STATE_UNSPECIFIED, IN_PROGRESS, CANCELLING, CANCELLED, SUCCEEDED
        """
        return pulumi.get(self, "rollout_state")

    @property
    @pulumi.getter(name="skipAwaitRollout")
    def skip_await_rollout(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to true to skip awaiting rollout during resource creation and update.
        """
        return pulumi.get(self, "skip_await_rollout")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        Output only. Server generated unique id for the OS policy assignment resource.
        """
        return pulumi.get(self, "uid")

