# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AiDatasetEncryptionSpec',
    'AiEndpointDeployedModel',
    'AiEndpointDeployedModelAutomaticResource',
    'AiEndpointDeployedModelDedicatedResource',
    'AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpec',
    'AiEndpointDeployedModelDedicatedResourceMachineSpec',
    'AiEndpointDeployedModelPrivateEndpoint',
    'AiEndpointEncryptionSpec',
    'AiFeatureStoreEncryptionSpec',
    'AiFeatureStoreEntityTypeIamBindingCondition',
    'AiFeatureStoreEntityTypeIamMemberCondition',
    'AiFeatureStoreEntityTypeMonitoringConfig',
    'AiFeatureStoreEntityTypeMonitoringConfigCategoricalThresholdConfig',
    'AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysis',
    'AiFeatureStoreEntityTypeMonitoringConfigNumericalThresholdConfig',
    'AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysis',
    'AiFeatureStoreIamBindingCondition',
    'AiFeatureStoreIamMemberCondition',
    'AiFeatureStoreOnlineServingConfig',
    'AiFeatureStoreOnlineServingConfigScaling',
    'AiIndexDeployedIndex',
    'AiIndexIndexStat',
    'AiIndexMetadata',
    'AiIndexMetadataConfig',
    'AiIndexMetadataConfigAlgorithmConfig',
    'AiIndexMetadataConfigAlgorithmConfigBruteForceConfig',
    'AiIndexMetadataConfigAlgorithmConfigTreeAhConfig',
    'AiMetadataStoreEncryptionSpec',
    'AiMetadataStoreState',
    'AiTensorboardEncryptionSpec',
]

@pulumi.output_type
class AiDatasetEncryptionSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiDatasetEncryptionSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiDatasetEncryptionSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiDatasetEncryptionSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[str] = None):
        """
        :param str kms_key_name: Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
               Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[str]:
        """
        Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
        Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class AiEndpointDeployedModel(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automaticResources":
            suggest = "automatic_resources"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "dedicatedResources":
            suggest = "dedicated_resources"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "enableAccessLogging":
            suggest = "enable_access_logging"
        elif key == "enableContainerLogging":
            suggest = "enable_container_logging"
        elif key == "modelVersionId":
            suggest = "model_version_id"
        elif key == "privateEndpoints":
            suggest = "private_endpoints"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "sharedResources":
            suggest = "shared_resources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointDeployedModel. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointDeployedModel.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointDeployedModel.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic_resources: Optional[Sequence['outputs.AiEndpointDeployedModelAutomaticResource']] = None,
                 create_time: Optional[str] = None,
                 dedicated_resources: Optional[Sequence['outputs.AiEndpointDeployedModelDedicatedResource']] = None,
                 display_name: Optional[str] = None,
                 enable_access_logging: Optional[bool] = None,
                 enable_container_logging: Optional[bool] = None,
                 id: Optional[str] = None,
                 model: Optional[str] = None,
                 model_version_id: Optional[str] = None,
                 private_endpoints: Optional[Sequence['outputs.AiEndpointDeployedModelPrivateEndpoint']] = None,
                 service_account: Optional[str] = None,
                 shared_resources: Optional[str] = None):
        """
        :param Sequence['AiEndpointDeployedModelAutomaticResourceArgs'] automatic_resources: A description of resources that to large degree are decided by Vertex AI, and require only a modest additional configuration.
               Structure is documented below.
        :param str create_time: Output only. Timestamp when the DeployedModel was created.
        :param Sequence['AiEndpointDeployedModelDedicatedResourceArgs'] dedicated_resources: A description of resources that are dedicated to the DeployedModel, and that need a higher degree of manual configuration.
               Structure is documented below.
        :param str display_name: Required. The display name of the Endpoint. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        :param bool enable_access_logging: These logs are like standard server access logs, containing information like timestamp and latency for each prediction request. Note that Stackdriver logs may incur a cost, especially if your project receives prediction requests at a high queries per second rate (QPS). Estimate your costs before enabling this option.
        :param bool enable_container_logging: If true, the container of the DeployedModel instances will send `stderr` and `stdout` streams to Stackdriver Logging. Only supported for custom-trained Models and AutoML Tabular Models.
        :param str id: The ID of the DeployedModel. If not provided upon deployment, Vertex AI will generate a value for this ID. This value should be 1-10 characters, and valid characters are /[0-9]/.
        :param str model: The name of the Model that this is the deployment of. Note that the Model may be in a different location than the DeployedModel's Endpoint.
        :param str model_version_id: Output only. The version ID of the model that is deployed.
        :param Sequence['AiEndpointDeployedModelPrivateEndpointArgs'] private_endpoints: Output only. Provide paths for users to send predict/explain/health requests directly to the deployed model services running on Cloud via private services access. This field is populated if network is configured.
               Structure is documented below.
        :param str service_account: The service account that the DeployedModel's container runs as. Specify the email address of the service account. If this service account is not specified, the container runs as a service account that doesn't have access to the resource project. Users deploying the Model must have the `iam.serviceAccounts.actAs` permission on this service account.
        :param str shared_resources: The resource name of the shared DeploymentResourcePool to deploy on. Format: projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}
        """
        if automatic_resources is not None:
            pulumi.set(__self__, "automatic_resources", automatic_resources)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dedicated_resources is not None:
            pulumi.set(__self__, "dedicated_resources", dedicated_resources)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_access_logging is not None:
            pulumi.set(__self__, "enable_access_logging", enable_access_logging)
        if enable_container_logging is not None:
            pulumi.set(__self__, "enable_container_logging", enable_container_logging)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if model_version_id is not None:
            pulumi.set(__self__, "model_version_id", model_version_id)
        if private_endpoints is not None:
            pulumi.set(__self__, "private_endpoints", private_endpoints)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shared_resources is not None:
            pulumi.set(__self__, "shared_resources", shared_resources)

    @property
    @pulumi.getter(name="automaticResources")
    def automatic_resources(self) -> Optional[Sequence['outputs.AiEndpointDeployedModelAutomaticResource']]:
        """
        A description of resources that to large degree are decided by Vertex AI, and require only a modest additional configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "automatic_resources")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        """
        Output only. Timestamp when the DeployedModel was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dedicatedResources")
    def dedicated_resources(self) -> Optional[Sequence['outputs.AiEndpointDeployedModelDedicatedResource']]:
        """
        A description of resources that are dedicated to the DeployedModel, and that need a higher degree of manual configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "dedicated_resources")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Required. The display name of the Endpoint. The name can be up to 128 characters long and can consist of any UTF-8 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enableAccessLogging")
    def enable_access_logging(self) -> Optional[bool]:
        """
        These logs are like standard server access logs, containing information like timestamp and latency for each prediction request. Note that Stackdriver logs may incur a cost, especially if your project receives prediction requests at a high queries per second rate (QPS). Estimate your costs before enabling this option.
        """
        return pulumi.get(self, "enable_access_logging")

    @property
    @pulumi.getter(name="enableContainerLogging")
    def enable_container_logging(self) -> Optional[bool]:
        """
        If true, the container of the DeployedModel instances will send `stderr` and `stdout` streams to Stackdriver Logging. Only supported for custom-trained Models and AutoML Tabular Models.
        """
        return pulumi.get(self, "enable_container_logging")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the DeployedModel. If not provided upon deployment, Vertex AI will generate a value for this ID. This value should be 1-10 characters, and valid characters are /[0-9]/.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def model(self) -> Optional[str]:
        """
        The name of the Model that this is the deployment of. Note that the Model may be in a different location than the DeployedModel's Endpoint.
        """
        return pulumi.get(self, "model")

    @property
    @pulumi.getter(name="modelVersionId")
    def model_version_id(self) -> Optional[str]:
        """
        Output only. The version ID of the model that is deployed.
        """
        return pulumi.get(self, "model_version_id")

    @property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> Optional[Sequence['outputs.AiEndpointDeployedModelPrivateEndpoint']]:
        """
        Output only. Provide paths for users to send predict/explain/health requests directly to the deployed model services running on Cloud via private services access. This field is populated if network is configured.
        Structure is documented below.
        """
        return pulumi.get(self, "private_endpoints")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[str]:
        """
        The service account that the DeployedModel's container runs as. Specify the email address of the service account. If this service account is not specified, the container runs as a service account that doesn't have access to the resource project. Users deploying the Model must have the `iam.serviceAccounts.actAs` permission on this service account.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="sharedResources")
    def shared_resources(self) -> Optional[str]:
        """
        The resource name of the shared DeploymentResourcePool to deploy on. Format: projects/{project}/locations/{location}/deploymentResourcePools/{deployment_resource_pool}
        """
        return pulumi.get(self, "shared_resources")


@pulumi.output_type
class AiEndpointDeployedModelAutomaticResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReplicaCount":
            suggest = "max_replica_count"
        elif key == "minReplicaCount":
            suggest = "min_replica_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointDeployedModelAutomaticResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointDeployedModelAutomaticResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointDeployedModelAutomaticResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_replica_count: Optional[int] = None,
                 min_replica_count: Optional[int] = None):
        """
        :param int max_replica_count: The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale the model to that many replicas is guaranteed (barring service outages). If traffic against the DeployedModel increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, a no upper bound for scaling under heavy traffic will be assume, though Vertex AI may be unable to scale beyond certain replica number.
        :param int min_replica_count: The minimum number of replicas this DeployedModel will be always deployed on. If traffic against it increases, it may dynamically be deployed onto more replicas up to max_replica_count, and as traffic decreases, some of these extra replicas may be freed. If the requested value is too large, the deployment will error.
        """
        if max_replica_count is not None:
            pulumi.set(__self__, "max_replica_count", max_replica_count)
        if min_replica_count is not None:
            pulumi.set(__self__, "min_replica_count", min_replica_count)

    @property
    @pulumi.getter(name="maxReplicaCount")
    def max_replica_count(self) -> Optional[int]:
        """
        The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale the model to that many replicas is guaranteed (barring service outages). If traffic against the DeployedModel increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, a no upper bound for scaling under heavy traffic will be assume, though Vertex AI may be unable to scale beyond certain replica number.
        """
        return pulumi.get(self, "max_replica_count")

    @property
    @pulumi.getter(name="minReplicaCount")
    def min_replica_count(self) -> Optional[int]:
        """
        The minimum number of replicas this DeployedModel will be always deployed on. If traffic against it increases, it may dynamically be deployed onto more replicas up to max_replica_count, and as traffic decreases, some of these extra replicas may be freed. If the requested value is too large, the deployment will error.
        """
        return pulumi.get(self, "min_replica_count")


@pulumi.output_type
class AiEndpointDeployedModelDedicatedResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscalingMetricSpecs":
            suggest = "autoscaling_metric_specs"
        elif key == "machineSpecs":
            suggest = "machine_specs"
        elif key == "maxReplicaCount":
            suggest = "max_replica_count"
        elif key == "minReplicaCount":
            suggest = "min_replica_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointDeployedModelDedicatedResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointDeployedModelDedicatedResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointDeployedModelDedicatedResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling_metric_specs: Optional[Sequence['outputs.AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpec']] = None,
                 machine_specs: Optional[Sequence['outputs.AiEndpointDeployedModelDedicatedResourceMachineSpec']] = None,
                 max_replica_count: Optional[int] = None,
                 min_replica_count: Optional[int] = None):
        """
        :param Sequence['AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpecArgs'] autoscaling_metric_specs: The metric specifications that overrides a resource utilization metric (CPU utilization, accelerator's duty cycle, and so on) target value (default to 60 if not set). At most one entry is allowed per metric. If machine_spec.accelerator_count is above 0, the autoscaling will be based on both CPU utilization and accelerator's duty cycle metrics and scale up when either metrics exceeds its target value while scale down if both metrics are under their target value. The default target value is 60 for both metrics. If machine_spec.accelerator_count is 0, the autoscaling will be based on CPU utilization metric only with default target value 60 if not explicitly set. For example, in the case of Online Prediction, if you want to override target CPU utilization to 80, you should set autoscaling_metric_specs.metric_name to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and autoscaling_metric_specs.target to `80`.
               Structure is documented below.
        :param Sequence['AiEndpointDeployedModelDedicatedResourceMachineSpecArgs'] machine_specs: The specification of a single machine used by the prediction.
               Structure is documented below.
        :param int max_replica_count: The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale the model to that many replicas is guaranteed (barring service outages). If traffic against the DeployedModel increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, a no upper bound for scaling under heavy traffic will be assume, though Vertex AI may be unable to scale beyond certain replica number.
        :param int min_replica_count: The minimum number of replicas this DeployedModel will be always deployed on. If traffic against it increases, it may dynamically be deployed onto more replicas up to max_replica_count, and as traffic decreases, some of these extra replicas may be freed. If the requested value is too large, the deployment will error.
        """
        if autoscaling_metric_specs is not None:
            pulumi.set(__self__, "autoscaling_metric_specs", autoscaling_metric_specs)
        if machine_specs is not None:
            pulumi.set(__self__, "machine_specs", machine_specs)
        if max_replica_count is not None:
            pulumi.set(__self__, "max_replica_count", max_replica_count)
        if min_replica_count is not None:
            pulumi.set(__self__, "min_replica_count", min_replica_count)

    @property
    @pulumi.getter(name="autoscalingMetricSpecs")
    def autoscaling_metric_specs(self) -> Optional[Sequence['outputs.AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpec']]:
        """
        The metric specifications that overrides a resource utilization metric (CPU utilization, accelerator's duty cycle, and so on) target value (default to 60 if not set). At most one entry is allowed per metric. If machine_spec.accelerator_count is above 0, the autoscaling will be based on both CPU utilization and accelerator's duty cycle metrics and scale up when either metrics exceeds its target value while scale down if both metrics are under their target value. The default target value is 60 for both metrics. If machine_spec.accelerator_count is 0, the autoscaling will be based on CPU utilization metric only with default target value 60 if not explicitly set. For example, in the case of Online Prediction, if you want to override target CPU utilization to 80, you should set autoscaling_metric_specs.metric_name to `aiplatform.googleapis.com/prediction/online/cpu/utilization` and autoscaling_metric_specs.target to `80`.
        Structure is documented below.
        """
        return pulumi.get(self, "autoscaling_metric_specs")

    @property
    @pulumi.getter(name="machineSpecs")
    def machine_specs(self) -> Optional[Sequence['outputs.AiEndpointDeployedModelDedicatedResourceMachineSpec']]:
        """
        The specification of a single machine used by the prediction.
        Structure is documented below.
        """
        return pulumi.get(self, "machine_specs")

    @property
    @pulumi.getter(name="maxReplicaCount")
    def max_replica_count(self) -> Optional[int]:
        """
        The maximum number of replicas this DeployedModel may be deployed on when the traffic against it increases. If the requested value is too large, the deployment will error, but if deployment succeeds then the ability to scale the model to that many replicas is guaranteed (barring service outages). If traffic against the DeployedModel increases beyond what its replicas at maximum may handle, a portion of the traffic will be dropped. If this value is not provided, a no upper bound for scaling under heavy traffic will be assume, though Vertex AI may be unable to scale beyond certain replica number.
        """
        return pulumi.get(self, "max_replica_count")

    @property
    @pulumi.getter(name="minReplicaCount")
    def min_replica_count(self) -> Optional[int]:
        """
        The minimum number of replicas this DeployedModel will be always deployed on. If traffic against it increases, it may dynamically be deployed onto more replicas up to max_replica_count, and as traffic decreases, some of these extra replicas may be freed. If the requested value is too large, the deployment will error.
        """
        return pulumi.get(self, "min_replica_count")


@pulumi.output_type
class AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointDeployedModelDedicatedResourceAutoscalingMetricSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: Optional[str] = None,
                 target: Optional[int] = None):
        """
        :param str metric_name: The resource metric name. Supported metrics: * For Online Prediction: * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle` * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
        :param int target: The target resource utilization in percentage (1% - 100%) for the given metric; once the real usage deviates from the target by a certain percentage, the machine replicas change. The default value is 60 (representing 60%) if not provided.
        """
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[str]:
        """
        The resource metric name. Supported metrics: * For Online Prediction: * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle` * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def target(self) -> Optional[int]:
        """
        The target resource utilization in percentage (1% - 100%) for the given metric; once the real usage deviates from the target by a certain percentage, the machine replicas change. The default value is 60 (representing 60%) if not provided.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class AiEndpointDeployedModelDedicatedResourceMachineSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorCount":
            suggest = "accelerator_count"
        elif key == "acceleratorType":
            suggest = "accelerator_type"
        elif key == "machineType":
            suggest = "machine_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointDeployedModelDedicatedResourceMachineSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointDeployedModelDedicatedResourceMachineSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointDeployedModelDedicatedResourceMachineSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_count: Optional[int] = None,
                 accelerator_type: Optional[str] = None,
                 machine_type: Optional[str] = None):
        """
        :param int accelerator_count: The number of accelerators to attach to the machine.
        :param str accelerator_type: The type of accelerator(s) that may be attached to the machine as per accelerator_count. See possible values [here](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec#AcceleratorType).
        :param str machine_type: The type of the machine. See the [list of machine types supported for prediction](https://cloud.google.com/vertex-ai/docs/predictions/configure-compute#machine-types) See the [list of machine types supported for custom training](https://cloud.google.com/vertex-ai/docs/training/configure-compute#machine-types). For DeployedModel this field is optional, and the default value is `n1-standard-2`. For BatchPredictionJob or as part of WorkerPoolSpec this field is required. TODO(rsurowka): Try to better unify the required vs optional.
        """
        if accelerator_count is not None:
            pulumi.set(__self__, "accelerator_count", accelerator_count)
        if accelerator_type is not None:
            pulumi.set(__self__, "accelerator_type", accelerator_type)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> Optional[int]:
        """
        The number of accelerators to attach to the machine.
        """
        return pulumi.get(self, "accelerator_count")

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> Optional[str]:
        """
        The type of accelerator(s) that may be attached to the machine as per accelerator_count. See possible values [here](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec#AcceleratorType).
        """
        return pulumi.get(self, "accelerator_type")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[str]:
        """
        The type of the machine. See the [list of machine types supported for prediction](https://cloud.google.com/vertex-ai/docs/predictions/configure-compute#machine-types) See the [list of machine types supported for custom training](https://cloud.google.com/vertex-ai/docs/training/configure-compute#machine-types). For DeployedModel this field is optional, and the default value is `n1-standard-2`. For BatchPredictionJob or as part of WorkerPoolSpec this field is required. TODO(rsurowka): Try to better unify the required vs optional.
        """
        return pulumi.get(self, "machine_type")


@pulumi.output_type
class AiEndpointDeployedModelPrivateEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "explainHttpUri":
            suggest = "explain_http_uri"
        elif key == "healthHttpUri":
            suggest = "health_http_uri"
        elif key == "predictHttpUri":
            suggest = "predict_http_uri"
        elif key == "serviceAttachment":
            suggest = "service_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointDeployedModelPrivateEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointDeployedModelPrivateEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointDeployedModelPrivateEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 explain_http_uri: Optional[str] = None,
                 health_http_uri: Optional[str] = None,
                 predict_http_uri: Optional[str] = None,
                 service_attachment: Optional[str] = None):
        """
        :param str explain_http_uri: Output only. Http(s) path to send explain requests.
        :param str health_http_uri: Output only. Http(s) path to send health check requests.
        :param str predict_http_uri: Output only. Http(s) path to send prediction requests.
        :param str service_attachment: Output only. The name of the service attachment resource. Populated if private service connect is enabled.
        """
        if explain_http_uri is not None:
            pulumi.set(__self__, "explain_http_uri", explain_http_uri)
        if health_http_uri is not None:
            pulumi.set(__self__, "health_http_uri", health_http_uri)
        if predict_http_uri is not None:
            pulumi.set(__self__, "predict_http_uri", predict_http_uri)
        if service_attachment is not None:
            pulumi.set(__self__, "service_attachment", service_attachment)

    @property
    @pulumi.getter(name="explainHttpUri")
    def explain_http_uri(self) -> Optional[str]:
        """
        Output only. Http(s) path to send explain requests.
        """
        return pulumi.get(self, "explain_http_uri")

    @property
    @pulumi.getter(name="healthHttpUri")
    def health_http_uri(self) -> Optional[str]:
        """
        Output only. Http(s) path to send health check requests.
        """
        return pulumi.get(self, "health_http_uri")

    @property
    @pulumi.getter(name="predictHttpUri")
    def predict_http_uri(self) -> Optional[str]:
        """
        Output only. Http(s) path to send prediction requests.
        """
        return pulumi.get(self, "predict_http_uri")

    @property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> Optional[str]:
        """
        Output only. The name of the service attachment resource. Populated if private service connect is enabled.
        """
        return pulumi.get(self, "service_attachment")


@pulumi.output_type
class AiEndpointEncryptionSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiEndpointEncryptionSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiEndpointEncryptionSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiEndpointEncryptionSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`. The key needs to be in the same region as where the compute resource is created.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: `projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key`. The key needs to be in the same region as where the compute resource is created.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class AiFeatureStoreEncryptionSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureStoreEncryptionSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureStoreEncryptionSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureStoreEncryptionSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the compute resource is created.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource. Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the compute resource is created.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class AiFeatureStoreEntityTypeIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AiFeatureStoreEntityTypeIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AiFeatureStoreEntityTypeMonitoringConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "categoricalThresholdConfig":
            suggest = "categorical_threshold_config"
        elif key == "importFeaturesAnalysis":
            suggest = "import_features_analysis"
        elif key == "numericalThresholdConfig":
            suggest = "numerical_threshold_config"
        elif key == "snapshotAnalysis":
            suggest = "snapshot_analysis"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureStoreEntityTypeMonitoringConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureStoreEntityTypeMonitoringConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureStoreEntityTypeMonitoringConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 categorical_threshold_config: Optional['outputs.AiFeatureStoreEntityTypeMonitoringConfigCategoricalThresholdConfig'] = None,
                 import_features_analysis: Optional['outputs.AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysis'] = None,
                 numerical_threshold_config: Optional['outputs.AiFeatureStoreEntityTypeMonitoringConfigNumericalThresholdConfig'] = None,
                 snapshot_analysis: Optional['outputs.AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysis'] = None):
        """
        :param 'AiFeatureStoreEntityTypeMonitoringConfigCategoricalThresholdConfigArgs' categorical_threshold_config: Threshold for categorical features of anomaly detection. This is shared by all types of Featurestore Monitoring for categorical features (i.e. Features with type (Feature.ValueType) BOOL or STRING).
               Structure is documented below.
        :param 'AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysisArgs' import_features_analysis: The config for ImportFeatures Analysis Based Feature Monitoring.
               Structure is documented below.
        :param 'AiFeatureStoreEntityTypeMonitoringConfigNumericalThresholdConfigArgs' numerical_threshold_config: Threshold for numerical features of anomaly detection. This is shared by all objectives of Featurestore Monitoring for numerical features (i.e. Features with type (Feature.ValueType) DOUBLE or INT64).
               Structure is documented below.
        :param 'AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysisArgs' snapshot_analysis: The config for Snapshot Analysis Based Feature Monitoring.
               Structure is documented below.
        """
        if categorical_threshold_config is not None:
            pulumi.set(__self__, "categorical_threshold_config", categorical_threshold_config)
        if import_features_analysis is not None:
            pulumi.set(__self__, "import_features_analysis", import_features_analysis)
        if numerical_threshold_config is not None:
            pulumi.set(__self__, "numerical_threshold_config", numerical_threshold_config)
        if snapshot_analysis is not None:
            pulumi.set(__self__, "snapshot_analysis", snapshot_analysis)

    @property
    @pulumi.getter(name="categoricalThresholdConfig")
    def categorical_threshold_config(self) -> Optional['outputs.AiFeatureStoreEntityTypeMonitoringConfigCategoricalThresholdConfig']:
        """
        Threshold for categorical features of anomaly detection. This is shared by all types of Featurestore Monitoring for categorical features (i.e. Features with type (Feature.ValueType) BOOL or STRING).
        Structure is documented below.
        """
        return pulumi.get(self, "categorical_threshold_config")

    @property
    @pulumi.getter(name="importFeaturesAnalysis")
    def import_features_analysis(self) -> Optional['outputs.AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysis']:
        """
        The config for ImportFeatures Analysis Based Feature Monitoring.
        Structure is documented below.
        """
        return pulumi.get(self, "import_features_analysis")

    @property
    @pulumi.getter(name="numericalThresholdConfig")
    def numerical_threshold_config(self) -> Optional['outputs.AiFeatureStoreEntityTypeMonitoringConfigNumericalThresholdConfig']:
        """
        Threshold for numerical features of anomaly detection. This is shared by all objectives of Featurestore Monitoring for numerical features (i.e. Features with type (Feature.ValueType) DOUBLE or INT64).
        Structure is documented below.
        """
        return pulumi.get(self, "numerical_threshold_config")

    @property
    @pulumi.getter(name="snapshotAnalysis")
    def snapshot_analysis(self) -> Optional['outputs.AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysis']:
        """
        The config for Snapshot Analysis Based Feature Monitoring.
        Structure is documented below.
        """
        return pulumi.get(self, "snapshot_analysis")


@pulumi.output_type
class AiFeatureStoreEntityTypeMonitoringConfigCategoricalThresholdConfig(dict):
    def __init__(__self__, *,
                 value: float):
        """
        :param float value: Specify a threshold value that can trigger the alert. For categorical feature, the distribution distance is calculated by L-inifinity norm. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature. The default value is 0.3.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        Specify a threshold value that can trigger the alert. For categorical feature, the distribution distance is calculated by L-inifinity norm. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature. The default value is 0.3.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysis(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "anomalyDetectionBaseline":
            suggest = "anomaly_detection_baseline"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureStoreEntityTypeMonitoringConfigImportFeaturesAnalysis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 anomaly_detection_baseline: Optional[str] = None,
                 state: Optional[str] = None):
        """
        :param str anomaly_detection_baseline: Defines the baseline to do anomaly detection for feature values imported by each [entityTypes.importFeatureValues][] operation. The value must be one of the values below:
               * LATEST_STATS: Choose the later one statistics generated by either most recent snapshot analysis or previous import features analysis. If non of them exists, skip anomaly detection and only generate a statistics.
               * MOST_RECENT_SNAPSHOT_STATS: Use the statistics generated by the most recent snapshot analysis if exists.
               * PREVIOUS_IMPORT_FEATURES_STATS: Use the statistics generated by the previous import features analysis if exists.
        :param str state: Whether to enable / disable / inherite default hebavior for import features analysis. The value must be one of the values below:
               * DEFAULT: The default behavior of whether to enable the monitoring. EntityType-level config: disabled.
               * ENABLED: Explicitly enables import features analysis. EntityType-level config: by default enables import features analysis for all Features under it.
               * DISABLED: Explicitly disables import features analysis. EntityType-level config: by default disables import features analysis for all Features under it.
        """
        if anomaly_detection_baseline is not None:
            pulumi.set(__self__, "anomaly_detection_baseline", anomaly_detection_baseline)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="anomalyDetectionBaseline")
    def anomaly_detection_baseline(self) -> Optional[str]:
        """
        Defines the baseline to do anomaly detection for feature values imported by each [entityTypes.importFeatureValues][] operation. The value must be one of the values below:
        * LATEST_STATS: Choose the later one statistics generated by either most recent snapshot analysis or previous import features analysis. If non of them exists, skip anomaly detection and only generate a statistics.
        * MOST_RECENT_SNAPSHOT_STATS: Use the statistics generated by the most recent snapshot analysis if exists.
        * PREVIOUS_IMPORT_FEATURES_STATS: Use the statistics generated by the previous import features analysis if exists.
        """
        return pulumi.get(self, "anomaly_detection_baseline")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Whether to enable / disable / inherite default hebavior for import features analysis. The value must be one of the values below:
        * DEFAULT: The default behavior of whether to enable the monitoring. EntityType-level config: disabled.
        * ENABLED: Explicitly enables import features analysis. EntityType-level config: by default enables import features analysis for all Features under it.
        * DISABLED: Explicitly disables import features analysis. EntityType-level config: by default disables import features analysis for all Features under it.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class AiFeatureStoreEntityTypeMonitoringConfigNumericalThresholdConfig(dict):
    def __init__(__self__, *,
                 value: float):
        """
        :param float value: Specify a threshold value that can trigger the alert. For numerical feature, the distribution distance is calculated by Jensen–Shannon divergence. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature. The default value is 0.3.
        """
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> float:
        """
        Specify a threshold value that can trigger the alert. For numerical feature, the distribution distance is calculated by Jensen–Shannon divergence. Each feature must have a non-zero threshold if they need to be monitored. Otherwise no alert will be triggered for that feature. The default value is 0.3.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysis(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monitoringInterval":
            suggest = "monitoring_interval"
        elif key == "monitoringIntervalDays":
            suggest = "monitoring_interval_days"
        elif key == "stalenessDays":
            suggest = "staleness_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysis. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysis.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureStoreEntityTypeMonitoringConfigSnapshotAnalysis.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: Optional[bool] = None,
                 monitoring_interval: Optional[str] = None,
                 monitoring_interval_days: Optional[int] = None,
                 staleness_days: Optional[int] = None):
        """
        :param bool disabled: The monitoring schedule for snapshot analysis. For EntityType-level config: unset / disabled = true indicates disabled by default for Features under it; otherwise by default enable snapshot analysis monitoring with monitoringInterval for Features under it.
        :param int monitoring_interval_days: Configuration of the snapshot analysis based monitoring pipeline running interval. The value indicates number of days. The default value is 1.
               If both FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days and [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval][] are set when creating/updating EntityTypes/Features, FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days will be used.
        :param int staleness_days: Customized export features time window for snapshot analysis. Unit is one day. The default value is 21 days. Minimum value is 1 day. Maximum value is 4000 days.
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if monitoring_interval is not None:
            pulumi.set(__self__, "monitoring_interval", monitoring_interval)
        if monitoring_interval_days is not None:
            pulumi.set(__self__, "monitoring_interval_days", monitoring_interval_days)
        if staleness_days is not None:
            pulumi.set(__self__, "staleness_days", staleness_days)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        """
        The monitoring schedule for snapshot analysis. For EntityType-level config: unset / disabled = true indicates disabled by default for Features under it; otherwise by default enable snapshot analysis monitoring with monitoringInterval for Features under it.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="monitoringInterval")
    def monitoring_interval(self) -> Optional[str]:
        return pulumi.get(self, "monitoring_interval")

    @property
    @pulumi.getter(name="monitoringIntervalDays")
    def monitoring_interval_days(self) -> Optional[int]:
        """
        Configuration of the snapshot analysis based monitoring pipeline running interval. The value indicates number of days. The default value is 1.
        If both FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days and [FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval][] are set when creating/updating EntityTypes/Features, FeaturestoreMonitoringConfig.SnapshotAnalysis.monitoring_interval_days will be used.
        """
        return pulumi.get(self, "monitoring_interval_days")

    @property
    @pulumi.getter(name="stalenessDays")
    def staleness_days(self) -> Optional[int]:
        """
        Customized export features time window for snapshot analysis. Unit is one day. The default value is 21 days. Minimum value is 1 day. Maximum value is 4000 days.
        """
        return pulumi.get(self, "staleness_days")


@pulumi.output_type
class AiFeatureStoreIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AiFeatureStoreIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class AiFeatureStoreOnlineServingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedNodeCount":
            suggest = "fixed_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureStoreOnlineServingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureStoreOnlineServingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureStoreOnlineServingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_node_count: Optional[int] = None,
                 scaling: Optional['outputs.AiFeatureStoreOnlineServingConfigScaling'] = None):
        """
        :param int fixed_node_count: The number of nodes for each cluster. The number of nodes will not scale automatically but can be scaled manually by providing different values when updating.
        :param 'AiFeatureStoreOnlineServingConfigScalingArgs' scaling: Online serving scaling configuration. Only one of fixedNodeCount and scaling can be set. Setting one will reset the other.
               Structure is documented below.
        """
        if fixed_node_count is not None:
            pulumi.set(__self__, "fixed_node_count", fixed_node_count)
        if scaling is not None:
            pulumi.set(__self__, "scaling", scaling)

    @property
    @pulumi.getter(name="fixedNodeCount")
    def fixed_node_count(self) -> Optional[int]:
        """
        The number of nodes for each cluster. The number of nodes will not scale automatically but can be scaled manually by providing different values when updating.
        """
        return pulumi.get(self, "fixed_node_count")

    @property
    @pulumi.getter
    def scaling(self) -> Optional['outputs.AiFeatureStoreOnlineServingConfigScaling']:
        """
        Online serving scaling configuration. Only one of fixedNodeCount and scaling can be set. Setting one will reset the other.
        Structure is documented below.
        """
        return pulumi.get(self, "scaling")


@pulumi.output_type
class AiFeatureStoreOnlineServingConfigScaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiFeatureStoreOnlineServingConfigScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiFeatureStoreOnlineServingConfigScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiFeatureStoreOnlineServingConfigScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_node_count: int,
                 min_node_count: int):
        """
        :param int max_node_count: The maximum number of nodes to scale up to. Must be greater than minNodeCount, and less than or equal to 10 times of 'minNodeCount'.
        :param int min_node_count: The minimum number of nodes to scale down to. Must be greater than or equal to 1.
        """
        pulumi.set(__self__, "max_node_count", max_node_count)
        pulumi.set(__self__, "min_node_count", min_node_count)

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> int:
        """
        The maximum number of nodes to scale up to. Must be greater than minNodeCount, and less than or equal to 10 times of 'minNodeCount'.
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> int:
        """
        The minimum number of nodes to scale down to. Must be greater than or equal to 1.
        """
        return pulumi.get(self, "min_node_count")


@pulumi.output_type
class AiIndexDeployedIndex(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployedIndexId":
            suggest = "deployed_index_id"
        elif key == "indexEndpoint":
            suggest = "index_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexDeployedIndex. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexDeployedIndex.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexDeployedIndex.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployed_index_id: Optional[str] = None,
                 index_endpoint: Optional[str] = None):
        """
        :param str deployed_index_id: The ID of the DeployedIndex in the above IndexEndpoint.
        :param str index_endpoint: A resource name of the IndexEndpoint.
        """
        if deployed_index_id is not None:
            pulumi.set(__self__, "deployed_index_id", deployed_index_id)
        if index_endpoint is not None:
            pulumi.set(__self__, "index_endpoint", index_endpoint)

    @property
    @pulumi.getter(name="deployedIndexId")
    def deployed_index_id(self) -> Optional[str]:
        """
        The ID of the DeployedIndex in the above IndexEndpoint.
        """
        return pulumi.get(self, "deployed_index_id")

    @property
    @pulumi.getter(name="indexEndpoint")
    def index_endpoint(self) -> Optional[str]:
        """
        A resource name of the IndexEndpoint.
        """
        return pulumi.get(self, "index_endpoint")


@pulumi.output_type
class AiIndexIndexStat(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shardsCount":
            suggest = "shards_count"
        elif key == "vectorsCount":
            suggest = "vectors_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexIndexStat. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexIndexStat.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexIndexStat.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 shards_count: Optional[int] = None,
                 vectors_count: Optional[str] = None):
        """
        :param int shards_count: The number of shards in the Index.
        :param str vectors_count: The number of vectors in the Index.
        """
        if shards_count is not None:
            pulumi.set(__self__, "shards_count", shards_count)
        if vectors_count is not None:
            pulumi.set(__self__, "vectors_count", vectors_count)

    @property
    @pulumi.getter(name="shardsCount")
    def shards_count(self) -> Optional[int]:
        """
        The number of shards in the Index.
        """
        return pulumi.get(self, "shards_count")

    @property
    @pulumi.getter(name="vectorsCount")
    def vectors_count(self) -> Optional[str]:
        """
        The number of vectors in the Index.
        """
        return pulumi.get(self, "vectors_count")


@pulumi.output_type
class AiIndexMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentsDeltaUri":
            suggest = "contents_delta_uri"
        elif key == "isCompleteOverwrite":
            suggest = "is_complete_overwrite"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: Optional['outputs.AiIndexMetadataConfig'] = None,
                 contents_delta_uri: Optional[str] = None,
                 is_complete_overwrite: Optional[bool] = None):
        """
        :param 'AiIndexMetadataConfigArgs' config: The configuration of the Matching Engine Index.
               Structure is documented below.
        :param str contents_delta_uri: Allows inserting, updating  or deleting the contents of the Matching Engine Index.
               The string must be a valid Cloud Storage directory path. If this
               field is set when calling IndexService.UpdateIndex, then no other
               Index field can be also updated as part of the same call.
               The expected structure and format of the files this URI points to is
               described at https://cloud.google.com/vertex-ai/docs/matching-engine/using-matching-engine#input-data-format
        :param bool is_complete_overwrite: If this field is set together with contentsDeltaUri when calling IndexService.UpdateIndex,
               then existing content of the Index will be replaced by the data from the contentsDeltaUri.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if contents_delta_uri is not None:
            pulumi.set(__self__, "contents_delta_uri", contents_delta_uri)
        if is_complete_overwrite is not None:
            pulumi.set(__self__, "is_complete_overwrite", is_complete_overwrite)

    @property
    @pulumi.getter
    def config(self) -> Optional['outputs.AiIndexMetadataConfig']:
        """
        The configuration of the Matching Engine Index.
        Structure is documented below.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="contentsDeltaUri")
    def contents_delta_uri(self) -> Optional[str]:
        """
        Allows inserting, updating  or deleting the contents of the Matching Engine Index.
        The string must be a valid Cloud Storage directory path. If this
        field is set when calling IndexService.UpdateIndex, then no other
        Index field can be also updated as part of the same call.
        The expected structure and format of the files this URI points to is
        described at https://cloud.google.com/vertex-ai/docs/matching-engine/using-matching-engine#input-data-format
        """
        return pulumi.get(self, "contents_delta_uri")

    @property
    @pulumi.getter(name="isCompleteOverwrite")
    def is_complete_overwrite(self) -> Optional[bool]:
        """
        If this field is set together with contentsDeltaUri when calling IndexService.UpdateIndex,
        then existing content of the Index will be replaced by the data from the contentsDeltaUri.
        """
        return pulumi.get(self, "is_complete_overwrite")


@pulumi.output_type
class AiIndexMetadataConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "algorithmConfig":
            suggest = "algorithm_config"
        elif key == "approximateNeighborsCount":
            suggest = "approximate_neighbors_count"
        elif key == "distanceMeasureType":
            suggest = "distance_measure_type"
        elif key == "featureNormType":
            suggest = "feature_norm_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexMetadataConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexMetadataConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexMetadataConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimensions: int,
                 algorithm_config: Optional['outputs.AiIndexMetadataConfigAlgorithmConfig'] = None,
                 approximate_neighbors_count: Optional[int] = None,
                 distance_measure_type: Optional[str] = None,
                 feature_norm_type: Optional[str] = None):
        """
        :param int dimensions: The number of dimensions of the input vectors.
        :param 'AiIndexMetadataConfigAlgorithmConfigArgs' algorithm_config: The configuration with regard to the algorithms used for efficient search.
               Structure is documented below.
        :param int approximate_neighbors_count: The default number of neighbors to find via approximate search before exact reordering is
               performed. Exact reordering is a procedure where results returned by an
               approximate search algorithm are reordered via a more expensive distance computation.
               Required if tree-AH algorithm is used.
        :param str distance_measure_type: The distance measure used in nearest neighbor search. The value must be one of the followings:
               * SQUARED_L2_DISTANCE: Euclidean (L_2) Distance
               * L1_DISTANCE: Manhattan (L_1) Distance
               * COSINE_DISTANCE: Cosine Distance. Defined as 1 - cosine similarity.
               * DOT_PRODUCT_DISTANCE: Dot Product Distance. Defined as a negative of the dot product
        :param str feature_norm_type: Type of normalization to be carried out on each vector. The value must be one of the followings:
               * UNIT_L2_NORM: Unit L2 normalization type
               * NONE: No normalization type is specified.
        """
        pulumi.set(__self__, "dimensions", dimensions)
        if algorithm_config is not None:
            pulumi.set(__self__, "algorithm_config", algorithm_config)
        if approximate_neighbors_count is not None:
            pulumi.set(__self__, "approximate_neighbors_count", approximate_neighbors_count)
        if distance_measure_type is not None:
            pulumi.set(__self__, "distance_measure_type", distance_measure_type)
        if feature_norm_type is not None:
            pulumi.set(__self__, "feature_norm_type", feature_norm_type)

    @property
    @pulumi.getter
    def dimensions(self) -> int:
        """
        The number of dimensions of the input vectors.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="algorithmConfig")
    def algorithm_config(self) -> Optional['outputs.AiIndexMetadataConfigAlgorithmConfig']:
        """
        The configuration with regard to the algorithms used for efficient search.
        Structure is documented below.
        """
        return pulumi.get(self, "algorithm_config")

    @property
    @pulumi.getter(name="approximateNeighborsCount")
    def approximate_neighbors_count(self) -> Optional[int]:
        """
        The default number of neighbors to find via approximate search before exact reordering is
        performed. Exact reordering is a procedure where results returned by an
        approximate search algorithm are reordered via a more expensive distance computation.
        Required if tree-AH algorithm is used.
        """
        return pulumi.get(self, "approximate_neighbors_count")

    @property
    @pulumi.getter(name="distanceMeasureType")
    def distance_measure_type(self) -> Optional[str]:
        """
        The distance measure used in nearest neighbor search. The value must be one of the followings:
        * SQUARED_L2_DISTANCE: Euclidean (L_2) Distance
        * L1_DISTANCE: Manhattan (L_1) Distance
        * COSINE_DISTANCE: Cosine Distance. Defined as 1 - cosine similarity.
        * DOT_PRODUCT_DISTANCE: Dot Product Distance. Defined as a negative of the dot product
        """
        return pulumi.get(self, "distance_measure_type")

    @property
    @pulumi.getter(name="featureNormType")
    def feature_norm_type(self) -> Optional[str]:
        """
        Type of normalization to be carried out on each vector. The value must be one of the followings:
        * UNIT_L2_NORM: Unit L2 normalization type
        * NONE: No normalization type is specified.
        """
        return pulumi.get(self, "feature_norm_type")


@pulumi.output_type
class AiIndexMetadataConfigAlgorithmConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bruteForceConfig":
            suggest = "brute_force_config"
        elif key == "treeAhConfig":
            suggest = "tree_ah_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexMetadataConfigAlgorithmConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexMetadataConfigAlgorithmConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexMetadataConfigAlgorithmConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 brute_force_config: Optional['outputs.AiIndexMetadataConfigAlgorithmConfigBruteForceConfig'] = None,
                 tree_ah_config: Optional['outputs.AiIndexMetadataConfigAlgorithmConfigTreeAhConfig'] = None):
        """
        :param 'AiIndexMetadataConfigAlgorithmConfigBruteForceConfigArgs' brute_force_config: Configuration options for using brute force search, which simply implements the
               standard linear search in the database for each query.
        :param 'AiIndexMetadataConfigAlgorithmConfigTreeAhConfigArgs' tree_ah_config: Configuration options for using the tree-AH algorithm (Shallow tree + Asymmetric Hashing).
               Please refer to this paper for more details: https://arxiv.org/abs/1908.10396
               Structure is documented below.
        """
        if brute_force_config is not None:
            pulumi.set(__self__, "brute_force_config", brute_force_config)
        if tree_ah_config is not None:
            pulumi.set(__self__, "tree_ah_config", tree_ah_config)

    @property
    @pulumi.getter(name="bruteForceConfig")
    def brute_force_config(self) -> Optional['outputs.AiIndexMetadataConfigAlgorithmConfigBruteForceConfig']:
        """
        Configuration options for using brute force search, which simply implements the
        standard linear search in the database for each query.
        """
        return pulumi.get(self, "brute_force_config")

    @property
    @pulumi.getter(name="treeAhConfig")
    def tree_ah_config(self) -> Optional['outputs.AiIndexMetadataConfigAlgorithmConfigTreeAhConfig']:
        """
        Configuration options for using the tree-AH algorithm (Shallow tree + Asymmetric Hashing).
        Please refer to this paper for more details: https://arxiv.org/abs/1908.10396
        Structure is documented below.
        """
        return pulumi.get(self, "tree_ah_config")


@pulumi.output_type
class AiIndexMetadataConfigAlgorithmConfigBruteForceConfig(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class AiIndexMetadataConfigAlgorithmConfigTreeAhConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "leafNodeEmbeddingCount":
            suggest = "leaf_node_embedding_count"
        elif key == "leafNodesToSearchPercent":
            suggest = "leaf_nodes_to_search_percent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiIndexMetadataConfigAlgorithmConfigTreeAhConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiIndexMetadataConfigAlgorithmConfigTreeAhConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiIndexMetadataConfigAlgorithmConfigTreeAhConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 leaf_node_embedding_count: Optional[int] = None,
                 leaf_nodes_to_search_percent: Optional[int] = None):
        """
        :param int leaf_node_embedding_count: Number of embeddings on each leaf node. The default value is 1000 if not set.
        :param int leaf_nodes_to_search_percent: The default percentage of leaf nodes that any query may be searched. Must be in
               range 1-100, inclusive. The default value is 10 (means 10%) if not set.
        """
        if leaf_node_embedding_count is not None:
            pulumi.set(__self__, "leaf_node_embedding_count", leaf_node_embedding_count)
        if leaf_nodes_to_search_percent is not None:
            pulumi.set(__self__, "leaf_nodes_to_search_percent", leaf_nodes_to_search_percent)

    @property
    @pulumi.getter(name="leafNodeEmbeddingCount")
    def leaf_node_embedding_count(self) -> Optional[int]:
        """
        Number of embeddings on each leaf node. The default value is 1000 if not set.
        """
        return pulumi.get(self, "leaf_node_embedding_count")

    @property
    @pulumi.getter(name="leafNodesToSearchPercent")
    def leaf_nodes_to_search_percent(self) -> Optional[int]:
        """
        The default percentage of leaf nodes that any query may be searched. Must be in
        range 1-100, inclusive. The default value is 10 (means 10%) if not set.
        """
        return pulumi.get(self, "leaf_nodes_to_search_percent")


@pulumi.output_type
class AiMetadataStoreEncryptionSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiMetadataStoreEncryptionSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiMetadataStoreEncryptionSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiMetadataStoreEncryptionSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[str] = None):
        """
        :param str kms_key_name: Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
               Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[str]:
        """
        Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
        Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class AiMetadataStoreState(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskUtilizationBytes":
            suggest = "disk_utilization_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiMetadataStoreState. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiMetadataStoreState.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiMetadataStoreState.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_utilization_bytes: Optional[str] = None):
        """
        :param str disk_utilization_bytes: The disk utilization of the MetadataStore in bytes.
        """
        if disk_utilization_bytes is not None:
            pulumi.set(__self__, "disk_utilization_bytes", disk_utilization_bytes)

    @property
    @pulumi.getter(name="diskUtilizationBytes")
    def disk_utilization_bytes(self) -> Optional[str]:
        """
        The disk utilization of the MetadataStore in bytes.
        """
        return pulumi.get(self, "disk_utilization_bytes")


@pulumi.output_type
class AiTensorboardEncryptionSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AiTensorboardEncryptionSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AiTensorboardEncryptionSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AiTensorboardEncryptionSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str):
        """
        :param str kms_key_name: The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
               Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
        Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
        """
        return pulumi.get(self, "kms_key_name")


