wdf
     # This is the package that writes the input file for the DEGAS
     # Monte Carlo neutral transport code.
{
NCHAR = 80      # number of characters in id line for DEGAS run
NPEXIT = 1      # number of exits
NPNTYP = 2      # number of types of neutral species
NPHYD = 2       # number of hydrogenic species
NTASK = 4       # maximum number of tasks for multi-tasking
MPSEGXZ = 1000  # maximum wall segment dimension for kwmat character array
MPW = 10        # maximum wall index dimension for kwmat character array
NWORK = 1000    # dimension for temporary arrays
}

***** Dimwdf:
     # dimensioning parameters
noregsw         integer
     # number of horizontal regions
nptsvb         integer
     # maximum number of vertical (flux-like) surfaces in PLANET/DEGAS grid
nptshb         integer
     # maximum number of horizontal (angle-like) surfaces in PLANET/DEGAS grid
nptskb         integer /2/
     # toroidal dimension of DEGAS arrays
npw             integer /3/
     # maximum number of walls in DEGAS
npsegxz         integer
     # maximum number of poloidal segments in a wall in DEGAS
nptsw          integer
     # maximum number of poloidal nodes for defining a wall in DEGAS
npsegy          integer /1/
     # maximum number of toroidal segments in a wall in DEGAS
nptp1   integer /2/
     # maximum number of toroidal nodes for defining a wall in DEGAS
ndec            integer /2/
     # maximum number of vertical (flux-like) walls in DEGAS
npis    integer /2/
     # number of ion species
npns    integer /2/
     # number of neutral species
mpsegxz integer /MPSEGXZ/
     # maximum wall segment dimension for kwmat character array
mpw     integer /MPW/
     # maximum wall index dimension for kwmat character array
idimw    integer
     # dimensioning parameter for 2-d mesh arrays from grd package
jdimw    integer
     # dimensioning parameter for 2-d mesh arrays from grd package
nixw     integer
     # number of angle-like surfaces passing thru the x-point in each region
 
***** Auxw:
     # some parameters used to transform UEDGE indices to DEGAS indices
ixpt1b     integer  # ix index of pf cell just below x-point on inboard half
ixtop1b    integer  # ix index of cell at top of inboard half mesh
ixtop2b    integer  # ix index of cell at top of outboard half mesh
ixpt2b     integer  # ix index of core cell just above x-point on outboard half
nohzsb     integer  # number of DEGAS horizontal zones
novzsb     integer  # number of DEGAS vertical zones
nosegsxzb  integer  # number of DEGAS wall segments

***** Linkgrd:
     # information shared by grd and wdf packages
cmeshxw(idimw,jdimw)       _real   [m]
     # comment needed
cmeshyw(idimw,jdimw)       _real   [m]
     # comment needed
ilmaxw(noregsw)           _integer
     # comment needed
ixpointw(nixw,noregsw)     _integer
     # comment needed
jsptrxw(noregsw)          _integer
     # comment needed
jaxisw                   integer
     # index of magnetic axis flux surface
jminw(noregsw)            _integer
     # comment needed
jmaxw(noregsw)            _integer
     # comment needed

***** Nodew:
     # information on wall nodes
jindx(ndec)     _integer
     # horizontal (j) index of "vertical walls in (i,j) space
njwall          integer
     # number of "vertical" walls in (i,j) space
nodedwn(ndec)   _integer
     # number of nodes on jth "vertical" wall
nodewl(nptshb,ndec)    _integer
     # vertical (i) index of each node on jth "vertical" wall
nopts(ndec)     _integer
     # comment needed
numseg(3)    integer
     # number of segments on the left-vertical, bottom-horizontal, and
     # right-vertical sections of the exterior wall
walnodx(nptshb,ndec)   _real    [m]
     # radial position of wall nodes, in original EFIT coordinate system
walnody(nptshb,ndec)   _real    [m]
     # vertical position of wall nodes, in original EFIT coordinate system

***** Options:
     # miscellaneous control variables for DEGAS namelist file
iswdfon		integer	/1/
     # iswdfon=1 (default) ===> automatic generation of grid (grd-wdf) and 
     # plasma (bbb-wdf) data files from grd and bbb packages for use in wdf.
     # iswdfon=0     ===> these files must be explicitly generated by user.
fname	character*16
     # file name for DEGAS namelist input
     # default is 'degas.in'
idline          character*(NCHAR)
     # one line description of DEGAS problem
endmark character*(8)
     # end mark for namelists
ivnull          integer
     # vertical index of null plasma zone separating core and private regions
frr01   real    /.001/  [/sec]
     # fictitious reaction rate for neutral atoms
frr02   real    /.001/  [/sec]
     # fictitious reaction rate for neutral molecules

***** Degas1:
     # incomplete group of variables from degas namelist /input/
deni0(npis)     _real    [/cm**3]
     # density of ion species in the case of a constant plasma
engymin         real    [eV]
     # minimum tracking energy
fictrr0(npns)   _real
     # fictitious reaction rate in the case of a constant plasma
h2frac  real    /1.00/
     # fraction of desorbed hydrogenic particles desorbing as molecules
lchex   real
     # comment needed
leh0    real
     # = 1 for e + h0 ionization rate dependent on ne
     # = 2 for e + h0 ionization rate independent of ne
lflags  integer
     # printout flag for code flags
lgeomtry        integer
     # printout flag for geometric quantities
lhalpha         integer
     # printout flag for h-alpha results
lmaxwell        integer		/0/
     # = 0 for constant energy puffing and desorption
     # = 1 for puffed and desorbed energies from maxwellian
lmesh   integer /2/
     # DEGAS default is lmesh=1; "detailed reference mesh calculation"
     # DEGAS user guide recommends lmesh=2; "elementary calculation"
lnamelst        integer
     # printout flag for namelist echo
lneutral        integer
     # printout flag for neutral density, temperature, and pressure
loutput         integer         /3/
     # = 0 for no output; = 1 for minimum output; = 2 for medium output;
     # = 3 for long output
lplasma         integer
     # printout flag for plasma density, temperature, fictitious reaction rate,
     # and electron reaction rates
lprofh  integer
     # = 0 for plasma not constant over horizontal zones
     # = 1 for plasma constant over horizontal zones
lproft  integer /1/
     # = 0 for plasma not constant over toroidal zones
     # = 1 for plasma constant over toroidal zones
lprofv  integer
     # = 0 for plasma not constant over vertical zones
     # = 1 for plasma constant over vertical zones
lrandom         integer
     # = 1 use system random number generator
     # = 2 use internal generator random() necessary for macrotasking reproducibility
     # = 3 use a constant number (crandom) in place of a random one
lrecycle        integer
     # = 0 re-ionized atomic test flights are not recycled
     # = 1 re-ionized atomic test flights are recycled using array kplrecyc
lrflct1         integer         /1/
     # = 0 reflection coefficient is independent of incident polar angle
     # = 1 reflection coefficient is increased to 1 if incident polar angle is
     #     greater than 40 degrees
     # = 2 the trim code is used directly
lrflct2         integer         /2/
     # = 1 reflected direction is chosen from a cosine dist. in polar angle
     # = 2 varies continuously from cosine distribution at normal incidence to
     #     specular at grazing incidence
lrrulet         integer         /1/
     # = 0 do not play russian roulet; = 1 play russian roulet
lshrtrun        integer
     # = 0 long profile; = 1 short profile
lsources        integer
     # printout flag for plasma particle, momentum, and energy source rates
lsputter        integer
     # = 0 no sputtering calculated; = 1 sputtering calculated
lstat           integer
     # printout flag for statistical quantities
lsymetry        integer /1/
     # = 1 toroidal symmetry; = 2 cylindrical symmetry; = 3 no symmetry
lunit   integer /-1/
     # < 0 no printout of reference mesh
     # = 0 print mesh on STDOUT ?
     # > 0 print mesh on logical unit lunit
lvolsrc integer
     # = 1 recombination source; = 2 volume source
lwall   integer
     # printout flag for wall particle, momentum, and energy fluxes
lwalldst        integer
     # printout flag for wall flux energy and incident angle distributions
maxerrs integer /100/
     # number of errors allowed before program terminates
mparts  integer /0/
     # number of hydrogenic or helium test flights
ncount  integer /100/
     # send a message to terminal every ncount test flights
nexit   integer
     # number of exits in the device model
nhyd(NPHYD)     integer /NPHYD*2/
     # hydrogenic atomic mass in AMU
nocols  integer /420/
     # number of columns in the reference grid
nohbs   integer
     # number of horizontal plasma zone boundaries
nohzs   integer
     # number of horizontal plasma zones
norows  integer /840/
     # number of rows in the reference grid
nosegsxz(npw)   _integer
     # number of linear segements in the DEGAS wall
nosegsy(npw)    _integer
     # number of segements in wall jw in toroidal direction
nosplits        integer         /1/
     # splitting factor
notasks integer
     # number of tasks (ama=16 cma=8 fma=4)
notzs   integer
     # number of toroidal plasma zones
novbs   integer
     # number of vertical plasma zone boundaries
novzs   integer
     # number of vertical plasma zones
nowals  integer         /1/
     # number of walls in the DEGAS model
nwriter integer
     # logical unit of main output
nseed(NTASK)    integer
     # random number seed for tasks
ntty    integer
     # logical unit of the terminal
plsang  real    /90.00/    [degrees]
     # angle between the plasma flow velocity and the y-axis (for lsymetry = 2)
rmajor  real    [cm]
     # plasma major radius
rminor  real    [cm]
     # minor plasma radius for circular discharge
rrengy  real
     # minumum energy russian roulet factor
scrrmax real    /1.01/
     # scaling factor for rratemax
shethp  real	/3.00/
     # sheath potential in units of electron temperature
sndspd  real
     # plasma flow mach number where sound speed = sqrt((te+ti)/mi)
t0puff(npns)    _real    [eV]	/.025/
     # energy of puffed source of neutrals
te0     real    [eV]
     # electron temperature in the case of a constant plasma
ti0(npis)       _real    [eV]
     # ion temperature in the case of a constant plasma
wtmin0  real
     # minimum test flight weight
xlen    real    [cm]
     # length of the side of the reference grid
ylen    real    [cm]
     # length of the side of the reference grid
zlen    real    [cm]
     # length of the side of the reference grid

***** Degas2:
     # incomplete group of variables from degas namelist /arrays/
arcdeg(nptp1)   _real    [degrees]
     # toroidal angle of toroidal plasma zone boundaries
currxzt(npsegxz,npsegy,npw,npis)        _real    [/sec]
     # ion current to wall segments
denehvt(nptsvb,nptshb,nptskb)    _real    [/cm**3]
     # electron density in plasma zones
denihvt(nptsvb,nptshb,nptskb,npis)       _real    [/cm**3]
     # ion density in plasma zones
ficrrhvt(nptsvb,nptshb,nptskb,npns)      _real    [/sec]
     # fictitious reaction rate for neutrals in plasma zones
frabsorb(npsegxz,npsegy,npw,npns)       _real
     # fraction of absorbed particles retained by walls
gridx(nptsvb,nptshb,nptskb)  _real    [cm]
     # horizontal position of grid nodes
gridz(nptsvb,nptshb,nptskb)  _real    [cm]
     # vertical position of grid nodes
kplrecyc(nptsvb,nptshb)       _integer
     # re-initialize the test flight ionized in zone (jh,iv) at plate
     # segment kplrecyc (used when lrecycle=1)
ksplzone(nptsvb,nptshb,nptskb)   _integer
     # power law factor for splitting in plasma zone (jh,iv,kt)
kwmat(MPSEGXZ,MPW)        character*8
     # label that characterizes the reflective properties
     # of each wall segment, e.g., "fe" for iron.
$ civic & cft77 do not handle dynamic character arrays at present 07/18/91
kzone1(nptsvb,nptshb) _integer
     # horizontal plasma zone index of plasma zone grid cell.
     # values should be set according to kzone1(iv,jh) = iv
kzone2(nptsvb,nptshb) _integer
     # vertical plasma zone index of plasma zone grid cell.
     # values should be set according to kzone2(iv,jh) = jh
lboun1(nptsvb) _integer
     # horizontal (flux-like) index of plasma zone grid boundaries.
     # choose lboun1(j) for j=1,nohbs such that the correspondence
     # between j and jj is jj=lboun1(j).
lboun2(nptshb) _integer
     # vertical (angle-like) index of plasma zone grid boundaries.
     # choose lboun2(i) for i=1,novbs such that the correspondence
     # between i and ii is ii=lboun2(i).
rflcoef(npsegxz,npsegy,npw)     _real
     # roughness coefficient of wall segments
tehvt(nptsvb,nptshb,nptskb)      _real    [eV]
     # electron temperature in plasma zones
tihvt(nptsvb,nptshb,nptskb,npis) _real    [eV]
     # ion temperature in plasma zones
twall(npsegxz,npsegy,npw)       _real    [degrees K]
     # temperature of each wall segment
vflowx(nptsvb,nptshb,nptskb)	_real	[cm/sec]	/0./
     # plasma flow velocity in x (horizontal) direction
vflowy(nptsvb,nptshb,nptskb)	_real	[cm/sec]	/0./
     # plasma flow velocity in y (toroidal) direction
vflowz(nptsvb,nptshb,nptskb)	_real	[cm/sec]	/0./
     # plasma flow velocity in z (vertical) direction
vsorchvt(nptsvb,nptshb,nptskb,npns)      _real    [/sec]
     # volume source rate
xwall(nptsw,npw)       _real    [cm]
     # horizontal position of wall nodes
zwall(nptsw,npw)       _real    [cm]
     # vertical position of wall nodes

***** Eqdsk:
     # information from the aeqdsk and neqdsk files produced by the EFIT code
xdimw    real    [cm]
     # horizontal (radial) extent of EFIT computational grid
zdimw    real    [cm]
     # vertical extent of EFIT computational grid
rgrid1w  real    [cm]
     # major radius at inner edge of EFIT computational grid
eshotw   integer
     # shot number from EFIT
etimew   real    [msec]
     # time slice from EFIT
bcentrw  real    [Tesla]
     # reference toroidal field
rcentrw  real    [cm]
     # major radius of point where vacuum toroidal field is bcentr
rmagxw   real    [cm]
     # major radius of magnetic axis
zmagxw   real    [cm]
     # vertical position of magnetic axis
simagxw  real    [volt-sec/radian]
     # poloidal magnetic flux at the magnetic axis
sibdryw  real    [volt-sec/radian]
     # poloidal magnetic flux at the x-point
rsepsw   real    [cm]
     # major radius of x-point
zsepsw   real    [cm]
     # vertical position of x-point in EFIT coordinate system
rvsinw   real    [cm]
     # major radius of inboard strike point
zvsinw   real    [cm]
     # vertical position of inboard strike point in EFIT coordinate system
rvsoutw  real    [cm]
     # major radius of outboard strike point
zvsoutw  real    [cm]
     # vertical position of outboard strike point in EFIT coordinate system
nlimw           integer
     # number of data points on limiter/vessel boundary
xlimw(nlimw)    _real   [m]
     # radial coordinates of data points on limiter/vessel boundary
ylimw(nlimw)    _real   [m]
     # vertical coordinates of data points on limiter/vessel boundary

***** Urun:
     # user-callable subroutines
write_degas		subroutine
     # this is the driver routine that executes the wdf package
write_namelist		subroutine
     # this subroutine writes the DEGAS namelist input file
frrate  	subroutine
     # this subroutine sets the fictitious reaction rate for neutral
     # atoms and molecules in cells with zero plasma density.
ueplasma	subroutine
     # converts plasma information from bbb package into DEGAS namelist arrays





