/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.nav;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.ops.OPSHandler30;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.vocab.StructureVocab;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLParser;
import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import java.util.EnumSet;
import java.util.Set;

public class NavHandler
extends OPSHandler30 {
    private NavType currentNavType = NavType.NONE;
    private boolean isNavTypes = false;

    NavHandler(ValidationContext context, XMLParser parser) {
        super(context, parser);
    }

    @Override
    public void startElement() {
        String href;
        super.startElement();
        XMLElement e = this.parser.getCurrentElement();
        if ("http://www.w3.org/1999/xhtml".equals(e.getNamespace()) && e.getName().equals("a") && (href = e.getAttribute("href")) != null) {
            String resolvedHref = PathUtil.resolveRelativeReference(this.base, href);
            if (this.currentNavType == NavType.TOC) {
                this.context.featureReport.report(FeatureEnum.TOC_LINKS, this.parser.getLocation());
            }
            if (EnumSet.of(NavType.TOC, NavType.LANDMARKS, NavType.PAGE_LIST).contains((Object)this.currentNavType) && PathUtil.isRemote(resolvedHref)) {
                this.report.message(MessageId.NAV_010, EPUBLocation.create(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber()), new Object[]{this.currentNavType, href});
            } else if (this.xrefChecker.isPresent() && (this.currentNavType == NavType.TOC || this.currentNavType == NavType.PAGE_LIST)) {
                ((XRefChecker)this.xrefChecker.get()).registerReference(this.path, this.parser.getLineNumber(), this.parser.getColumnNumber(), resolvedHref, this.currentNavType == NavType.TOC ? XRefChecker.Type.NAV_TOC_LINK : XRefChecker.Type.NAV_PAGELIST_LINK);
            }
        }
    }

    @Override
    public void endElement() {
        super.endElement();
        XMLElement e = this.parser.getCurrentElement();
        if ("http://www.w3.org/1999/xhtml".equals(e.getNamespace()) && e.getName().equals("nav")) {
            this.currentNavType = NavType.NONE;
        }
    }

    @Override
    protected void checkType(XMLElement e, String type) {
        this.isNavTypes = "http://www.w3.org/1999/xhtml".equals(e.getNamespace()) && e.getName().equals("nav");
        super.checkType(e, type);
        this.isNavTypes = false;
    }

    @Override
    protected void checkTypes(Set<StructureVocab.EPUB_TYPES> types) {
        super.checkTypes(types);
        if (this.isNavTypes) {
            if (types.contains(StructureVocab.EPUB_TYPES.TOC)) {
                this.currentNavType = NavType.TOC;
            }
            if (types.contains(StructureVocab.EPUB_TYPES.PAGE_LIST)) {
                this.currentNavType = NavType.PAGE_LIST;
                this.context.featureReport.report(FeatureEnum.PAGE_LIST, this.parser.getLocation());
            }
            if (types.contains(StructureVocab.EPUB_TYPES.LANDMARKS)) {
                this.currentNavType = NavType.LANDMARKS;
            }
            if (types.contains(StructureVocab.EPUB_TYPES.LOI)) {
                this.context.featureReport.report(FeatureEnum.LOI, this.parser.getLocation());
            }
            if (types.contains(StructureVocab.EPUB_TYPES.LOT)) {
                this.context.featureReport.report(FeatureEnum.LOT, this.parser.getLocation());
            }
            if (types.contains(StructureVocab.EPUB_TYPES.LOA)) {
                this.context.featureReport.report(FeatureEnum.LOA, this.parser.getLocation());
            }
            if (types.contains(StructureVocab.EPUB_TYPES.LOV)) {
                this.context.featureReport.report(FeatureEnum.LOV, this.parser.getLocation());
            }
        }
    }

    private static enum NavType {
        NONE,
        TOC,
        LANDMARKS,
        PAGE_LIST,
        OTHER;

        private Converter<String, String> formatter = CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_HYPHEN);

        public String toString() {
            return (String)this.formatter.convert((Object)this.name());
        }
    }
}

