"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithEffect = exports.Effect = void 0;
const _4_resources_1 = require("./4-resources");
/**
 * Policy effects
 */
var Effect;
(function (Effect) {
    Effect["ALLOW"] = "Allow";
    Effect["DENY"] = "Deny";
})(Effect = exports.Effect || (exports.Effect = {}));
/**
 * Adds "effect" functionality to the Policy Statement
 */
class PolicyStatementWithEffect extends _4_resources_1.PolicyStatementWithResources {
    constructor() {
        super(...arguments);
        this.effect = Effect.ALLOW;
        /** When `true`, an "Effect: Allow" will be put into the policy statement.
         * By default it will be omitted, since `Allow` is the default anyway.
         */
        this.explicitAllow = false;
    }
    /**
     * Injects effect into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     */
    toJSON() {
        // @ts-ignore only available after swapping 1-base
        if (typeof this.addResources == 'function') {
            return super.toJSON();
        }
        const statement = super.toJSON();
        if (this.effect != Effect.ALLOW || this.explicitAllow) {
            statement.Effect = this.effect;
        }
        return statement;
    }
    /**
     * Allow the actions in this statement
     *
     * The default `Effect` is `Allow`. Therefore by default the `Effect` key
     * will not be present in the statement. To enforce the `Effect` key, pass
     * `true` as argument.
     *
     * @param explicit Enforce the `Effect` key to be present in the statement
     */
    allow(explicit) {
        this.explicitAllow = explicit || false;
        this.effect = Effect.ALLOW;
        return this;
    }
    /**
     * Deny the actions in this statement
     */
    deny() {
        this.effect = Effect.DENY;
        return this;
    }
}
exports.PolicyStatementWithEffect = PolicyStatementWithEffect;
//# sourceMappingURL=data:application/json;base64,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