"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeVoiceConnector = exports.Protocol = exports.NotificationTargetType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const customResource_1 = require("./customResource");
const voiceConnectorValidator_1 = require("./voiceConnectorValidator");
var NotificationTargetType;
(function (NotificationTargetType) {
    NotificationTargetType["EVENTBRIDGE"] = "EventBridge";
    NotificationTargetType["SNS"] = "SNS";
    NotificationTargetType["SQS"] = "SQS";
})(NotificationTargetType = exports.NotificationTargetType || (exports.NotificationTargetType = {}));
var Protocol;
(function (Protocol) {
    Protocol["TCP"] = "TCP";
    Protocol["UDP"] = "UDP";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
class ChimeVoiceConnector extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, region, encryption, termination, origination, streaming } = props;
        voiceConnectorValidator_1.voiceConnectorValidator(props);
        const voiceConnectorRequest = new customResource_1.ChimeResources(this, 'voiceConnectorRequest', {
            resourceType: 'VoiceConnector',
            uid: uid,
            properties: {
                region: region || cdk.Stack.of(this).region,
                name: name !== null && name !== void 0 ? name : uid,
                encryption: encryption || false,
                termination: termination,
                origination: origination,
                streaming: streaming,
            },
        });
        this.voiceConnectorId =
            voiceConnectorRequest.chimeCustomResource.getAttString('voiceConnectorId');
    }
}
exports.ChimeVoiceConnector = ChimeVoiceConnector;
_a = JSII_RTTI_SYMBOL_1;
ChimeVoiceConnector[_a] = { fqn: "cdk-amazon-chime-resources.ChimeVoiceConnector", version: "0.0.39" };
//# sourceMappingURL=data:application/json;base64,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